import { withTiming, withSpring, ReduceMotion } from 'react-native-reanimated';
import { ANIMATION_CONFIGS, ANIMATION_METHOD } from '../constants';
export const animate = ({
  point,
  configs,
  velocity = 0,
  onComplete
}) => {
  'worklet';

  if (!configs) {
    configs = ANIMATION_CONFIGS;
  }

  // Users might have an accessibility setting to reduce motion turned on.
  // This prevents the animation from running when presenting the sheet, which results in
  // the bottom sheet not even appearing so we need to override it to ensure the animation runs.
  configs.reduceMotion = ReduceMotion.Never;

  // detect animation type
  const type = 'duration' in configs || 'easing' in configs ? ANIMATION_METHOD.TIMING : ANIMATION_METHOD.SPRING;
  if (type === ANIMATION_METHOD.TIMING) {
    return withTiming(point, configs, onComplete);
  } else {
    return withSpring(point, Object.assign({
      velocity
    }, configs), onComplete);
  }
};
//# sourceMappingURL=animate.js.map