# React Native Bottom Sheet

[![Reanimated v2 version](https://img.shields.io/github/package-json/v/gorhom/react-native-bottom-sheet/master?label=Reanimated%20v2&style=flat-square)](https://www.npmjs.com/package/@gorhom/bottom-sheet) [![Reanimated v1 version](https://img.shields.io/github/package-json/v/gorhom/react-native-bottom-sheet/v2?label=Reanimated%20v1&style=flat-square)](https://www.npmjs.com/package/@gorhom/bottom-sheet) [![npm](https://img.shields.io/npm/l/@gorhom/bottom-sheet?style=flat-square)](https://www.npmjs.com/package/@gorhom/bottom-sheet) [![npm](https://img.shields.io/badge/types-included-blue?style=flat-square)](https://www.npmjs.com/package/@gorhom/bottom-sheet) [![runs with expo](https://img.shields.io/badge/Runs%20with%20Expo-4630EB.svg?style=flat-square&logo=EXPO&labelColor=f3f3f3&logoColor=000)](https://expo.io/)<!-- ALL-CONTRIBUTORS-BADGE:START - Do not remove or modify this section -->
[![All Contributors](https://img.shields.io/badge/all_contributors-2-orange.svg?style=flat-square)](#contributors-)

<!-- ALL-CONTRIBUTORS-BADGE:END -->

A performant interactive bottom sheet with fully configurable options 🚀

![React Native Bottom Sheet](./preview.gif)

---

## Features

- Modal presentation view, [Bottom Sheet Modal](https://ui.gorhom.dev/components/bottom-sheet/modal).
- Smooth gesture interactions & snapping animations.
- Seamless [keyboard handling](https://ui.gorhom.dev/components/bottom-sheet/keyboard-handling) for iOS & Android.
- Support [pull to refresh](https://ui.gorhom.dev/components/bottom-sheet/pull-to-refresh) for scrollables.
- Support [FlatList](https://ui.gorhom.dev/components/bottom-sheet/components/bottomsheetflatlist), [SectionList](https://ui.gorhom.dev/components/bottom-sheet/components/bottomsheetsectionlist), [ScrollView](https://ui.gorhom.dev/components/bottom-sheet/components/bottomsheetscrollview) & [View](https://ui.gorhom.dev/components/bottom-sheet/components/bottomsheetview) scrolling interactions.
- Support [React Navigation integration](https://ui.gorhom.dev/components/bottom-sheet/react-navigation-integration).
- Compatible with `Reanimated` v1-3.
- Compatible with `Expo`.
- Accessibility support.
- Written in `TypeScript`.
- [Read more](https://ui.gorhom.dev/components/bottom-sheet).

## Getting Started

Check out [the documentation website](https://gorhom.github.io/react-native-bottom-sheet).

## Versioning

This library been written in 2 versions of `Reanimated`, and kept both implementation in 2 separate branches:

- **`v2`** | [branch](https://github.com/gorhom/react-native-bottom-sheet/tree/v2) | [changelog](https://github.com/gorhom/react-native-bottom-sheet/blob/v2/CHANGELOG.md) : written with `Reanimated v1` & compatible with `Reanimated v2`.

- **`v4`** | [branch](https://github.com/gorhom/react-native-bottom-sheet/tree/v4) | [changelog](https://github.com/gorhom/react-native-bottom-sheet/blob/v4/CHANGELOG.md) : written with `Reanimated v2`.

- **`v5`** | [branch](https://github.com/gorhom/react-native-bottom-sheet/tree/master) | [changelog](https://github.com/gorhom/react-native-bottom-sheet/blob/master/CHANGELOG.md) : written with `Reanimated v3` & `Gesture Handler v2`.

> I highly recommend to use `v5` which provides more stability with all latest features.

## Author

- [Mo Gorhom](https://gorhom.dev/)

## Contributors

Thanks goes to these wonderful people ([emoji key](https://allcontributors.org/docs/en/emoji-key)):

> These people have helped to improve the library, but **DO NOT** maintain it.

<!-- ALL-CONTRIBUTORS-LIST:START - Do not remove or modify this section -->
<!-- prettier-ignore-start -->
<!-- markdownlint-disable -->
<table>
  <tr>
    <td align="center"><a href="https://react-native-training.eu"><img src="https://avatars.githubusercontent.com/u/1566403?v=4?s=76" width="76px;" alt=""/><br /><sub><b>Vojtech Novak</b></sub></a><br /><a href="https://github.com/gorhom/react-native-bottom-sheet/commits?author=vonovak" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/kickbk"><img src="https://avatars.githubusercontent.com/u/31323376?v=4?s=76" width="76px;" alt=""/><br /><sub><b>kickbk</b></sub></a><br /><a href="https://github.com/gorhom/react-native-bottom-sheet/issues?q=author%3Akickbk" title="Bug reports">🐛</a> <a href="https://github.com/gorhom/react-native-bottom-sheet/commits?author=kickbk" title="Tests">⚠️</a></td>
  </tr>
</table>

<!-- markdownlint-restore -->
<!-- prettier-ignore-end -->

<!-- ALL-CONTRIBUTORS-LIST:END -->

## Sponsor & Support

To keep this library maintained and up-to-date please consider [sponsoring it on GitHub](https://github.com/sponsors/gorhom). Or if you are looking for a private support or help in customizing the experience, then reach out to me on Twitter [@gorhom](https://twitter.com/gorhom).

## License

[MIT](./LICENSE)

---

<p align="center">
  <a href="https://gorhom.dev/#gh-light-mode-only" target="_blank">
    <img height="18" alt="Mo Gorhom" src="./mogorhom-light.png">
  </a>
  <a href="https://gorhom.dev/#gh-dark-mode-only" target="_blank">
    <img height="18" alt="Mo Gorhom" src="./mogorhom-dark.png">
  </a>
</p>
s