"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    createBundlesAsync: ()=>createBundlesAsync,
    getAssets: ()=>getAssets
});
function _config() {
    const data = require("@expo/config");
    _config = function() {
        return data;
    };
    return data;
}
function _getAssets() {
    const data = /*#__PURE__*/ _interopRequireDefault(require("@expo/metro-config/build/transform-worker/getAssets"));
    _getAssets = function() {
        return data;
    };
    return data;
}
function _assert() {
    const data = /*#__PURE__*/ _interopRequireDefault(require("assert"));
    _assert = function() {
        return data;
    };
    return data;
}
function _metro() {
    const data = /*#__PURE__*/ _interopRequireDefault(require("metro"));
    _metro = function() {
        return data;
    };
    return data;
}
function _server() {
    const data = /*#__PURE__*/ _interopRequireDefault(require("metro/src/Server"));
    _server = function() {
        return data;
    };
    return data;
}
function _splitBundleOptions() {
    const data = /*#__PURE__*/ _interopRequireDefault(require("metro/src/lib/splitBundleOptions"));
    _splitBundleOptions = function() {
        return data;
    };
    return data;
}
function _path() {
    const data = /*#__PURE__*/ _interopRequireDefault(require("path"));
    _path = function() {
        return data;
    };
    return data;
}
const _exportHermes = require("./exportHermes");
const _attachAtlas = require("../start/server/metro/debugging/attachAtlas");
const _instantiateMetro = require("../start/server/metro/instantiateMetro");
const _manifestMiddleware = require("../start/server/middleware/ManifestMiddleware");
const _metroOptions = require("../start/server/middleware/metroOptions");
const _env = require("../utils/env");
const _errors = require("../utils/errors");
function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
let nextBuildID = 0;
async function assertEngineMismatchAsync(projectRoot, exp, platform) {
    const isHermesManaged = (0, _exportHermes.isEnableHermesManaged)(exp, platform);
    const paths = (0, _config().getConfigFilePaths)(projectRoot);
    var _dynamicConfigPath, ref;
    const configFilePath = (ref = (_dynamicConfigPath = paths.dynamicConfigPath) != null ? _dynamicConfigPath : paths.staticConfigPath) != null ? ref : "app.json";
    await (0, _exportHermes.maybeThrowFromInconsistentEngineAsync)(projectRoot, configFilePath, platform, isHermesManaged);
}
async function createBundlesAsync(projectRoot, projectConfig, bundleOptions) {
    if (!bundleOptions.platforms.length) {
        return {};
    }
    const { exp , pkg  } = projectConfig;
    var _entryPoint;
    const bundles = await bundleProductionMetroClientAsync(projectRoot, exp, {
        // If not legacy, ignore the target option to prevent warnings from being thrown.
        resetCache: bundleOptions.clear,
        maxWorkers: bundleOptions.maxWorkers
    }, bundleOptions.platforms.map((platform)=>({
            platform,
            entryPoint: (_entryPoint = bundleOptions.entryPoint) != null ? _entryPoint : (0, _manifestMiddleware.getEntryWithServerRoot)(projectRoot, {
                platform,
                pkg
            }),
            sourcemaps: bundleOptions.sourcemaps,
            minify: bundleOptions.minify,
            bytecode: bundleOptions.bytecode,
            dev: bundleOptions.dev
        })));
    // { ios: bundle, android: bundle }
    return bundleOptions.platforms.reduce((prev, platform, index)=>({
            ...prev,
            [platform]: bundles[index]
        }), {});
}
function assertMetroConfig(config) {
    var ref;
    if (!((ref = config.serializer) == null ? void 0 : ref.customSerializer)) {
        throw new _errors.CommandError("METRO_CONFIG_MALFORMED", `The Metro bundler configuration is missing required features from 'expo/metro-config' and cannot be used with Expo CLI. Ensure the metro.config.js file is extending 'expo/metro-config'. Learn more: https://docs.expo.dev/guides/customizing-metro`);
    }
}
async function bundleProductionMetroClientAsync(projectRoot, expoConfig, metroOptions, bundles) {
    // Assert early so the user doesn't have to wait until bundling is complete to find out that
    // Hermes won't be available.
    await Promise.all(bundles.map(({ platform  })=>assertEngineMismatchAsync(projectRoot, expoConfig, platform)));
    const { config , reporter  } = await (0, _instantiateMetro.loadMetroConfigAsync)(projectRoot, metroOptions, {
        exp: expoConfig,
        isExporting: true,
        getMetroBundler () {
            return metroServer.getBundler().getBundler();
        }
    });
    assertMetroConfig(config);
    // Attach Expo Atlas if enabled
    await (0, _attachAtlas.attachAtlasAsync)({
        exp: expoConfig,
        projectRoot,
        metroConfig: config,
        isExporting: true,
        resetAtlasFile: true
    });
    const metroServer = await _metro().default.runMetro(config, {
        watch: false
    });
    const buildAsync = async (bundle)=>{
        const buildID = `bundle_${nextBuildID++}_${bundle.platform}`;
        const isHermes = (0, _exportHermes.isEnableHermesManaged)(expoConfig, bundle.platform);
        if (isHermes) {
            await assertEngineMismatchAsync(projectRoot, expoConfig, bundle.platform);
        }
        const bundleOptions = {
            ..._server().default.DEFAULT_BUNDLE_OPTIONS,
            sourceMapUrl: bundle.sourceMapUrl,
            ...(0, _metroOptions.getMetroDirectBundleOptionsForExpoConfig)(projectRoot, expoConfig, {
                splitChunks: !_env.env.EXPO_NO_BUNDLE_SPLITTING && bundle.platform === "web",
                minify: bundle.minify,
                mainModuleName: bundle.entryPoint,
                platform: bundle.platform,
                mode: bundle.dev ? "development" : "production",
                engine: isHermes ? "hermes" : undefined,
                serializerIncludeMaps: bundle.sourcemaps,
                bytecode: bundle.bytecode && isHermes,
                // Bundle splitting on web-only for now.
                // serializerOutput: bundle.platform === 'web' ? 'static' : undefined,
                serializerOutput: "static",
                isExporting: true
            }),
            bundleType: "bundle",
            inlineSourceMap: false,
            createModuleIdFactory: config.serializer.createModuleIdFactory,
            onProgress: (transformedFileCount, totalFileCount)=>{
                reporter.update({
                    buildID,
                    type: "bundle_transform_progressed",
                    transformedFileCount,
                    totalFileCount
                });
            }
        };
        const bundleDetails = {
            ...bundleOptions,
            buildID
        };
        reporter.update({
            buildID,
            type: "bundle_build_started",
            bundleDetails
        });
        try {
            const artifacts = await forkMetroBuildAsync(metroServer, bundleOptions);
            reporter.update({
                buildID,
                type: "bundle_build_done"
            });
            return artifacts;
        } catch (error) {
            reporter.update({
                buildID,
                type: "bundle_build_failed"
            });
            throw error;
        }
    };
    try {
        return await Promise.all(bundles.map((bundle)=>buildAsync(bundle)));
    } catch (error) {
        // New line so errors don't show up inline with the progress bar
        console.log("");
        throw error;
    } finally{
        metroServer.end();
    }
}
async function getAssets(metro, options) {
    const { entryFile , onProgress , resolverOptions , transformOptions  } = (0, _splitBundleOptions().default)(options);
    // @ts-expect-error: _bundler isn't exposed on the type.
    const dependencies = await metro._bundler.getDependencies([
        entryFile
    ], transformOptions, resolverOptions, {
        onProgress,
        shallow: false,
        lazy: false
    });
    // @ts-expect-error
    const _config = metro._config;
    return (0, _getAssets().default)(dependencies, {
        processModuleFilter: _config.serializer.processModuleFilter,
        assetPlugins: _config.transformer.assetPlugins,
        platform: transformOptions.platform,
        projectRoot: _config.projectRoot,
        publicPath: _config.transformer.publicPath
    });
}
function isMetroServerInstance(metro) {
    return "_shouldAddModuleToIgnoreList" in metro;
}
async function forkMetroBuildAsync(metro, options) {
    var ref;
    if (!isMetroServerInstance(metro)) {
        throw new Error("Expected Metro server instance to have private functions exposed.");
    }
    if (((ref = options.serializerOptions) == null ? void 0 : ref.output) !== "static") {
        throw new Error("Only multi-serializer output is supported.");
    }
    const { entryFile , graphOptions , onProgress , resolverOptions , serializerOptions , transformOptions ,  } = (0, _splitBundleOptions().default)(options);
    const { prepend , graph  } = await metro._bundler.buildGraph(entryFile, transformOptions, resolverOptions, {
        onProgress,
        shallow: graphOptions.shallow,
        // @ts-expect-error
        lazy: graphOptions.lazy
    });
    const entryPoint = metro._getEntryPointAbsolutePath(entryFile);
    var _unstable_serverRoot;
    const bundleOptions = {
        asyncRequireModulePath: await metro._resolveRelativePath(metro._config.transformer.asyncRequireModulePath, {
            relativeTo: "project",
            resolverOptions,
            transformOptions
        }),
        processModuleFilter: metro._config.serializer.processModuleFilter,
        createModuleId: metro._createModuleId,
        getRunModuleStatement: metro._config.serializer.getRunModuleStatement,
        dev: transformOptions.dev,
        includeAsyncPaths: graphOptions.lazy,
        projectRoot: metro._config.projectRoot,
        modulesOnly: serializerOptions.modulesOnly,
        runBeforeMainModule: metro._config.serializer.getModulesRunBeforeMainModule(_path().default.relative(metro._config.projectRoot, entryPoint)),
        runModule: serializerOptions.runModule,
        sourceMapUrl: serializerOptions.sourceMapUrl,
        sourceUrl: serializerOptions.sourceUrl,
        inlineSourceMap: serializerOptions.inlineSourceMap,
        serverRoot: (_unstable_serverRoot = metro._config.server.unstable_serverRoot) != null ? _unstable_serverRoot : metro._config.projectRoot,
        shouldAddToIgnoreList: (module)=>metro._shouldAddModuleToIgnoreList(module),
        // Custom options we pass to the serializer to emulate the URL query parameters.
        serializerOptions: options.serializerOptions
    };
    assertMetroConfig(metro._config);
    const bundle = await metro._config.serializer.customSerializer(entryPoint, // @ts-expect-error: Metro is typed incorrectly
    prepend, graph, bundleOptions);
    try {
        const parsed = typeof bundle === "string" ? JSON.parse(bundle) : bundle;
        (0, _assert().default)("artifacts" in parsed && Array.isArray(parsed.artifacts), "Expected serializer to return an object with key artifacts to contain an array of serial assets.");
        return parsed;
    } catch (error) {
        throw new Error("Serializer did not return expected format. The project copy of `expo/metro-config` may be out of date. Error: " + error.message);
    }
}

//# sourceMappingURL=fork-bundleAsync.js.map