import React from 'react';
import { FlatListProps } from 'react-native';
import Animated, { AnimateProps } from 'react-native-reanimated';
import type { SharedScrollContainerProps } from './types';
type AnimatedFlatListType<ItemT = any> = React.ComponentClass<AnimateProps<FlatListProps<ItemT>>, ItemT>;
type AnimatedFlatListBaseProps<ItemT> = React.ComponentProps<AnimatedFlatListType<ItemT>>;
type AnimatedFlatListProps<ItemT> = AnimatedFlatListBaseProps<ItemT>;
type FlatListWithHeadersProps<ItemT> = Omit<AnimatedFlatListProps<ItemT> & SharedScrollContainerProps, 'onScroll'>;
declare const FlatListWithHeaders: <ItemT = any>(props: FlatListWithHeadersProps<ItemT> & {
    ref?: React.Ref<Animated.FlatList<ItemT>> | undefined;
}) => React.ReactElement;
export default FlatListWithHeaders;
//# sourceMappingURL=FlatList.d.ts.map