function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useImperativeHandle } from 'react';
import { View, StyleSheet, ScrollView } from 'react-native';
import { useSafeAreaInsets } from 'react-native-safe-area-context';
import Animated, { useAnimatedRef } from 'react-native-reanimated';
import FadingView from './FadingView';
import { useScrollContainerLogic } from './useScrollContainerLogic';
const AnimatedScrollView = Animated.createAnimatedComponent(ScrollView);
const ScrollViewWithHeadersInputComp = (_ref, ref) => {
  let {
    largeHeaderShown,
    containerStyle,
    LargeHeaderSubtitleComponent,
    LargeHeaderComponent,
    largeHeaderContainerStyle,
    HeaderComponent,
    onLargeHeaderLayout,
    ignoreLeftSafeArea,
    ignoreRightSafeArea,
    // We use this to ensure that the onScroll property isn't accidentally used.
    // @ts-ignore
    onScroll: _unusedOnScroll,
    onScrollBeginDrag,
    onScrollEndDrag,
    onScrollWorklet,
    onMomentumScrollBegin,
    onMomentumScrollEnd,
    disableAutoFixScroll = false,
    children,
    absoluteHeader = false,
    initialAbsoluteHeaderHeight = 0,
    contentContainerStyle,
    automaticallyAdjustsScrollIndicatorInsets,
    headerFadeInThreshold = 1,
    scrollIndicatorInsets = {},
    disableLargeHeaderFadeAnim = false,
    ...rest
  } = _ref;
  if (_unusedOnScroll) {
    throw new Error("The 'onScroll' property is not supported. Please use onScrollWorklet to track the scroll container's state.");
  }
  const insets = useSafeAreaInsets();
  const scrollRef = useAnimatedRef();
  useImperativeHandle(ref, () => scrollRef.current);
  const {
    scrollY,
    showNavBar,
    largeHeaderHeight,
    largeHeaderOpacity,
    scrollHandler,
    debouncedFixScroll,
    absoluteHeaderHeight,
    onAbsoluteHeaderLayout,
    scrollViewAdjustments
  } = useScrollContainerLogic({
    scrollRef,
    largeHeaderShown,
    disableAutoFixScroll,
    largeHeaderExists: !!LargeHeaderComponent,
    absoluteHeader,
    initialAbsoluteHeaderHeight,
    headerFadeInThreshold,
    onScrollWorklet
  });
  return /*#__PURE__*/React.createElement(View, {
    style: [styles.container, containerStyle, !ignoreLeftSafeArea && {
      paddingLeft: insets.left
    }, !ignoreRightSafeArea && {
      paddingRight: insets.right
    }]
  }, !absoluteHeader && HeaderComponent({
    showNavBar,
    scrollY
  }), /*#__PURE__*/React.createElement(AnimatedScrollView, _extends({
    ref: scrollRef,
    scrollEventThrottle: 16,
    overScrollMode: "auto",
    onScroll: scrollHandler,
    automaticallyAdjustContentInsets: false,
    onScrollBeginDrag: e => {
      debouncedFixScroll.cancel();
      if (onScrollBeginDrag) onScrollBeginDrag(e);
    },
    onScrollEndDrag: e => {
      debouncedFixScroll();
      if (onScrollEndDrag) onScrollEndDrag(e);
    },
    onMomentumScrollBegin: e => {
      debouncedFixScroll.cancel();
      if (onMomentumScrollBegin) onMomentumScrollBegin(e);
    },
    onMomentumScrollEnd: e => {
      debouncedFixScroll();
      if (onMomentumScrollEnd) onMomentumScrollEnd(e);
    },
    contentContainerStyle: [scrollViewAdjustments.contentContainerStyle,
    // @ts-ignore
    // Reanimated typings are causing this error - will fix in the future.
    contentContainerStyle],
    automaticallyAdjustsScrollIndicatorInsets: automaticallyAdjustsScrollIndicatorInsets !== undefined ? automaticallyAdjustsScrollIndicatorInsets : !absoluteHeader,
    scrollIndicatorInsets: {
      top: absoluteHeader ? absoluteHeaderHeight : 0,
      ...scrollIndicatorInsets
    }
  }, rest), LargeHeaderComponent && /*#__PURE__*/React.createElement(View, {
    onLayout: e => {
      largeHeaderHeight.value = e.nativeEvent.layout.height;
      if (onLargeHeaderLayout) onLargeHeaderLayout(e.nativeEvent.layout);
    }
  }, !disableLargeHeaderFadeAnim ? /*#__PURE__*/React.createElement(FadingView, {
    opacity: largeHeaderOpacity,
    style: largeHeaderContainerStyle
  }, LargeHeaderComponent({
    scrollY,
    showNavBar
  })) : /*#__PURE__*/React.createElement(View, {
    style: largeHeaderContainerStyle
  }, LargeHeaderComponent({
    scrollY,
    showNavBar
  }))), LargeHeaderSubtitleComponent && LargeHeaderSubtitleComponent({
    showNavBar,
    scrollY
  }), children), absoluteHeader && /*#__PURE__*/React.createElement(View, {
    style: styles.absoluteHeader,
    onLayout: onAbsoluteHeaderLayout
  }, HeaderComponent({
    showNavBar,
    scrollY
  })));
};
const ScrollViewWithHeaders = /*#__PURE__*/React.forwardRef(ScrollViewWithHeadersInputComp);
export default ScrollViewWithHeaders;
const styles = StyleSheet.create({
  container: {
    flex: 1
  },
  absoluteHeader: {
    position: 'absolute',
    top: 0,
    right: 0,
    left: 0
  }
});
//# sourceMappingURL=ScrollView.js.map