function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { forwardRef } from 'react';
import { StyleSheet } from 'react-native';
import Animated, { useAnimatedProps, useAnimatedStyle } from 'react-native-reanimated';
const FadingView = /*#__PURE__*/forwardRef((_ref, ref) => {
  let {
    children,
    style,
    opacity,
    animatedProps = {},
    opacityThresholdToEnablePointerEvents = 1,
    ...rest
  } = _ref;
  const _animatedProps = useAnimatedProps(() => {
    const _pointerEvents = opacity.value >= opacityThresholdToEnablePointerEvents ? 'auto' : 'none';
    return {
      pointerEvents: _pointerEvents
    };
  }, [opacityThresholdToEnablePointerEvents]);
  const fadeStyle = useAnimatedStyle(() => ({
    opacity: opacity.value
  }));
  return /*#__PURE__*/React.createElement(Animated.View, _extends({
    ref: ref,
    style: [styles.container, style, fadeStyle],
    animatedProps: {
      ..._animatedProps,
      ...animatedProps
    }
  }, rest), children);
});
export default FadingView;
const styles = StyleSheet.create({
  container: {
    opacity: 0
  }
});
//# sourceMappingURL=FadingView.js.map