"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactNative = require("react-native");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
const LH_VERTICAL_PADDING = 6;
const LH_HORIZONTAL_PADDING = 12;

/**
 * A convenience component to wrap your large header content with.
 *
 * @param {LargeHeaderProps} props
 */
const LargeHeader = _ref => {
  let {
    headerStyle,
    children
  } = _ref;
  return /*#__PURE__*/_react.default.createElement(_reactNative.View, {
    style: [styles.headerContainer, headerStyle]
  }, children);
};
var _default = LargeHeader;
exports.default = _default;
const styles = _reactNative.StyleSheet.create({
  headerContainer: {
    width: '100%',
    flexDirection: 'row',
    justifyContent: 'space-between',
    paddingVertical: LH_VERTICAL_PADDING,
    paddingHorizontal: LH_HORIZONTAL_PADDING
  }
});
//# sourceMappingURL=LargeHeader.js.map