"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactNative = require("react-native");
var _reactNativeSafeAreaContext = require("react-native-safe-area-context");
var _containers = require("../containers");
var _line = require("../line");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const MIN_CENTER_WIDTH_PRC = 0.4;
const Header = _ref => {
  let {
    showNavBar,
    headerStyle,
    headerLeft = null,
    headerLeftStyle,
    headerLeftFadesIn,
    headerCenter = null,
    headerCenterStyle,
    headerCenterFadesIn = true,
    headerRight = null,
    headerRightStyle,
    headerRightFadesIn,
    noBottomBorder = false,
    ignoreTopSafeArea = false,
    borderColor,
    initialBorderColor,
    borderWidth,
    SurfaceComponent
  } = _ref;
  const {
    top
  } = (0, _reactNativeSafeAreaContext.useSafeAreaInsets)();
  const dimensions = (0, _reactNative.useWindowDimensions)();
  const headerCenterExists = !!headerCenter;
  const {
    centerWidth,
    minSideHeaderWidth
  } = (0, _react.useMemo)(() => {
    const _centerWidth = headerCenterExists ? MIN_CENTER_WIDTH_PRC * dimensions.width : 0;
    const _minSideHeaderWidth = (dimensions.width - _centerWidth) / 2;
    return {
      centerWidth: _centerWidth,
      minSideHeaderWidth: _minSideHeaderWidth
    };
  }, [headerCenterExists, dimensions]);
  const noHeaderLeftRight = !headerLeft && !headerRight;
  return /*#__PURE__*/_react.default.createElement(_reactNative.View, null, SurfaceComponent && SurfaceComponent({
    showNavBar
  }), /*#__PURE__*/_react.default.createElement(_reactNative.View, {
    style: [styles.container, headerStyle, !ignoreTopSafeArea && {
      paddingTop: top
    }]
  }, headerLeftFadesIn ? /*#__PURE__*/_react.default.createElement(_containers.FadingView, {
    opacity: showNavBar,
    style: [styles.leftContainer, headerLeftStyle, noHeaderLeftRight && styles.noFlex, {
      width: minSideHeaderWidth
    }]
  }, headerLeft) : /*#__PURE__*/_react.default.createElement(_reactNative.View, {
    style: [styles.leftContainer, headerLeftStyle, noHeaderLeftRight && styles.noFlex, {
      width: minSideHeaderWidth
    }]
  }, headerLeft), headerCenter && (headerCenterFadesIn ? /*#__PURE__*/_react.default.createElement(_containers.FadingView, {
    opacity: showNavBar,
    style: [styles.centerContainer, headerCenterStyle, {
      minWidth: centerWidth
    }]
  }, headerCenter) : /*#__PURE__*/_react.default.createElement(_reactNative.View, {
    style: [styles.centerContainer, headerCenterStyle, {
      width: centerWidth
    }]
  }, headerCenter)), headerRightFadesIn ? /*#__PURE__*/_react.default.createElement(_containers.FadingView, {
    opacity: showNavBar,
    style: [styles.rightContainer, headerRightStyle, noHeaderLeftRight && styles.noFlex, {
      width: minSideHeaderWidth
    }]
  }, headerRight) : /*#__PURE__*/_react.default.createElement(_reactNative.View, {
    style: [styles.rightContainer, headerRightStyle, noHeaderLeftRight && styles.noFlex, {
      width: minSideHeaderWidth
    }]
  }, headerRight)), !noBottomBorder && /*#__PURE__*/_react.default.createElement(_line.HeaderBottomBorder, {
    opacity: showNavBar,
    borderColor: borderColor,
    initialBorderColor: initialBorderColor,
    borderWidth: borderWidth
  }));
};
var _default = Header;
exports.default = _default;
const styles = _reactNative.StyleSheet.create({
  container: {
    flexDirection: 'row',
    width: '100%',
    alignItems: 'center',
    justifyContent: 'flex-start'
  },
  leftContainer: {
    flexDirection: 'row',
    paddingHorizontal: 8,
    paddingVertical: 4,
    justifyContent: 'flex-start',
    alignItems: 'center',
    overflow: 'hidden'
  },
  centerContainer: {
    flex: 1,
    flexDirection: 'row',
    paddingHorizontal: 6,
    alignItems: 'center',
    justifyContent: 'center'
  },
  rightContainer: {
    flexDirection: 'row-reverse',
    paddingVertical: 4,
    paddingHorizontal: 8,
    alignItems: 'center',
    justifyContent: 'flex-start',
    overflow: 'hidden'
  },
  noFlex: {
    display: 'none'
  }
});
//# sourceMappingURL=Header.js.map