"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactNative = require("react-native");
var _reactNativeSafeAreaContext = require("react-native-safe-area-context");
var _reactNativeReanimated = _interopRequireWildcard(require("react-native-reanimated"));
var _FadingView = _interopRequireDefault(require("./FadingView"));
var _useScrollContainerLogic = require("./useScrollContainerLogic");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const AnimatedScrollView = _reactNativeReanimated.default.createAnimatedComponent(_reactNative.ScrollView);
const ScrollViewWithHeadersInputComp = (_ref, ref) => {
  let {
    largeHeaderShown,
    containerStyle,
    LargeHeaderSubtitleComponent,
    LargeHeaderComponent,
    largeHeaderContainerStyle,
    HeaderComponent,
    onLargeHeaderLayout,
    ignoreLeftSafeArea,
    ignoreRightSafeArea,
    // We use this to ensure that the onScroll property isn't accidentally used.
    // @ts-ignore
    onScroll: _unusedOnScroll,
    onScrollBeginDrag,
    onScrollEndDrag,
    onScrollWorklet,
    onMomentumScrollBegin,
    onMomentumScrollEnd,
    disableAutoFixScroll = false,
    children,
    absoluteHeader = false,
    initialAbsoluteHeaderHeight = 0,
    contentContainerStyle,
    automaticallyAdjustsScrollIndicatorInsets,
    headerFadeInThreshold = 1,
    scrollIndicatorInsets = {},
    disableLargeHeaderFadeAnim = false,
    ...rest
  } = _ref;
  if (_unusedOnScroll) {
    throw new Error("The 'onScroll' property is not supported. Please use onScrollWorklet to track the scroll container's state.");
  }
  const insets = (0, _reactNativeSafeAreaContext.useSafeAreaInsets)();
  const scrollRef = (0, _reactNativeReanimated.useAnimatedRef)();
  (0, _react.useImperativeHandle)(ref, () => scrollRef.current);
  const {
    scrollY,
    showNavBar,
    largeHeaderHeight,
    largeHeaderOpacity,
    scrollHandler,
    debouncedFixScroll,
    absoluteHeaderHeight,
    onAbsoluteHeaderLayout,
    scrollViewAdjustments
  } = (0, _useScrollContainerLogic.useScrollContainerLogic)({
    scrollRef,
    largeHeaderShown,
    disableAutoFixScroll,
    largeHeaderExists: !!LargeHeaderComponent,
    absoluteHeader,
    initialAbsoluteHeaderHeight,
    headerFadeInThreshold,
    onScrollWorklet
  });
  return /*#__PURE__*/_react.default.createElement(_reactNative.View, {
    style: [styles.container, containerStyle, !ignoreLeftSafeArea && {
      paddingLeft: insets.left
    }, !ignoreRightSafeArea && {
      paddingRight: insets.right
    }]
  }, !absoluteHeader && HeaderComponent({
    showNavBar,
    scrollY
  }), /*#__PURE__*/_react.default.createElement(AnimatedScrollView, _extends({
    ref: scrollRef,
    scrollEventThrottle: 16,
    overScrollMode: "auto",
    onScroll: scrollHandler,
    automaticallyAdjustContentInsets: false,
    onScrollBeginDrag: e => {
      debouncedFixScroll.cancel();
      if (onScrollBeginDrag) onScrollBeginDrag(e);
    },
    onScrollEndDrag: e => {
      debouncedFixScroll();
      if (onScrollEndDrag) onScrollEndDrag(e);
    },
    onMomentumScrollBegin: e => {
      debouncedFixScroll.cancel();
      if (onMomentumScrollBegin) onMomentumScrollBegin(e);
    },
    onMomentumScrollEnd: e => {
      debouncedFixScroll();
      if (onMomentumScrollEnd) onMomentumScrollEnd(e);
    },
    contentContainerStyle: [scrollViewAdjustments.contentContainerStyle,
    // @ts-ignore
    // Reanimated typings are causing this error - will fix in the future.
    contentContainerStyle],
    automaticallyAdjustsScrollIndicatorInsets: automaticallyAdjustsScrollIndicatorInsets !== undefined ? automaticallyAdjustsScrollIndicatorInsets : !absoluteHeader,
    scrollIndicatorInsets: {
      top: absoluteHeader ? absoluteHeaderHeight : 0,
      ...scrollIndicatorInsets
    }
  }, rest), LargeHeaderComponent && /*#__PURE__*/_react.default.createElement(_reactNative.View, {
    onLayout: e => {
      largeHeaderHeight.value = e.nativeEvent.layout.height;
      if (onLargeHeaderLayout) onLargeHeaderLayout(e.nativeEvent.layout);
    }
  }, !disableLargeHeaderFadeAnim ? /*#__PURE__*/_react.default.createElement(_FadingView.default, {
    opacity: largeHeaderOpacity,
    style: largeHeaderContainerStyle
  }, LargeHeaderComponent({
    scrollY,
    showNavBar
  })) : /*#__PURE__*/_react.default.createElement(_reactNative.View, {
    style: largeHeaderContainerStyle
  }, LargeHeaderComponent({
    scrollY,
    showNavBar
  }))), LargeHeaderSubtitleComponent && LargeHeaderSubtitleComponent({
    showNavBar,
    scrollY
  }), children), absoluteHeader && /*#__PURE__*/_react.default.createElement(_reactNative.View, {
    style: styles.absoluteHeader,
    onLayout: onAbsoluteHeaderLayout
  }, HeaderComponent({
    showNavBar,
    scrollY
  })));
};
const ScrollViewWithHeaders = /*#__PURE__*/_react.default.forwardRef(ScrollViewWithHeadersInputComp);
var _default = ScrollViewWithHeaders;
exports.default = _default;
const styles = _reactNative.StyleSheet.create({
  container: {
    flex: 1
  },
  absoluteHeader: {
    position: 'absolute',
    top: 0,
    right: 0,
    left: 0
  }
});
//# sourceMappingURL=ScrollView.js.map