"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactNative = require("react-native");
var _reactNativeReanimated = _interopRequireWildcard(require("react-native-reanimated"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
/**
 * A view that scales and translates based on the scroll position. This is useful for
 * mimicking the behavior of the iOS navigation bar.
 *
 * @param {AnimatedScalingViewProps} props
 */
const AnimatedScalingView = _ref => {
  let {
    style,
    startRange = 0,
    startScale = 1,
    endRange = _reactNative.Dimensions.get('window').height * 0.1,
    endScale = 1.05,
    scrollY,
    translationDirection = 'right',
    children,
    ...viewProps
  } = _ref;
  const width = (0, _reactNativeReanimated.useSharedValue)(0);
  const animatedStyle = (0, _reactNativeReanimated.useAnimatedStyle)(() => {
    const scaleInterpolation = (0, _reactNativeReanimated.interpolate)(-scrollY.value, [startRange, endRange], [startScale, endScale], _reactNativeReanimated.Extrapolate.CLAMP);
    if (translationDirection === 'none') {
      return {
        transform: [{
          scale: scaleInterpolation
        }]
      };
    }
    if (translationDirection === 'right') {
      const scaleTransformOffset = (0, _reactNativeReanimated.interpolate)(scaleInterpolation, [startScale, endScale], [0, width.value * (endScale - startScale) / 2], _reactNativeReanimated.Extrapolate.CLAMP);
      return {
        transform: [{
          scale: scaleInterpolation
        }, {
          translateX: scaleTransformOffset
        }]
      };
    }

    // For now, we only support right translations.
    // TODO: Implement left translations.
    return {};
  }, [translationDirection, startRange, endRange, startScale, endScale]);
  return /*#__PURE__*/_react.default.createElement(_reactNativeReanimated.default.View, _extends({
    onLayout: evt => width.value = evt.nativeEvent.layout.width,
    style: [animatedStyle, style]
  }, viewProps), children);
};
var _default = AnimatedScalingView;
exports.default = _default;
//# sourceMappingURL=ScalingView.js.map