/*!
 * Stockfish copyright T. Romstad, M. Costalba, J. Kiiski, G. Linscott
 * and other contributors.
 *
 * Multi-variant support by Daniel Dugovic:
 * https://github.com/ddugovic/Stockfish
 *
 * Released under the GNU General Public License v3.
 *
 * Compiled to JavaScript by Niklas Fiekas <niklas.fiekas@backscattering.de>
 * using Emscripten.
 *
 * https://github.com/niklasf/stockfish.js
 */

var Module={print:(function(stdout){postMessage(stdout)})};var Module;if(!Module)Module=(typeof Module!=="undefined"?Module:null)||{};var moduleOverrides={};for(var key in Module){if(Module.hasOwnProperty(key)){moduleOverrides[key]=Module[key]}}var ENVIRONMENT_IS_WEB=false;var ENVIRONMENT_IS_WORKER=false;var ENVIRONMENT_IS_NODE=false;var ENVIRONMENT_IS_SHELL=false;if(Module["ENVIRONMENT"]){if(Module["ENVIRONMENT"]==="WEB"){ENVIRONMENT_IS_WEB=true}else if(Module["ENVIRONMENT"]==="WORKER"){ENVIRONMENT_IS_WORKER=true}else if(Module["ENVIRONMENT"]==="NODE"){ENVIRONMENT_IS_NODE=true}else if(Module["ENVIRONMENT"]==="SHELL"){ENVIRONMENT_IS_SHELL=true}else{throw new Error("The provided Module['ENVIRONMENT'] value is not valid. It must be one of: WEB|WORKER|NODE|SHELL.")}}else{ENVIRONMENT_IS_WEB=typeof window==="object";ENVIRONMENT_IS_WORKER=typeof importScripts==="function";ENVIRONMENT_IS_NODE=typeof process==="object"&&typeof require==="function"&&!ENVIRONMENT_IS_WEB&&!ENVIRONMENT_IS_WORKER;ENVIRONMENT_IS_SHELL=!ENVIRONMENT_IS_WEB&&!ENVIRONMENT_IS_NODE&&!ENVIRONMENT_IS_WORKER}if(ENVIRONMENT_IS_NODE){if(!Module["print"])Module["print"]=console.log;if(!Module["printErr"])Module["printErr"]=console.warn;var nodeFS;var nodePath;Module["read"]=function read(filename,binary){if(!nodeFS)nodeFS=require("fs");if(!nodePath)nodePath=require("path");filename=nodePath["normalize"](filename);var ret=nodeFS["readFileSync"](filename);if(!ret&&filename!=nodePath["resolve"](filename)){filename=path.join(__dirname,"..","src",filename);ret=nodeFS["readFileSync"](filename)}if(ret&&!binary)ret=ret.toString();return ret};Module["readBinary"]=function readBinary(filename){var ret=Module["read"](filename,true);if(!ret.buffer){ret=new Uint8Array(ret)}assert(ret.buffer);return ret};Module["load"]=function load(f){globalEval(read(f))};if(!Module["thisProgram"]){if(process["argv"].length>1){Module["thisProgram"]=process["argv"][1].replace(/\\/g,"/")}else{Module["thisProgram"]="unknown-program"}}Module["arguments"]=process["argv"].slice(2);if(typeof module!=="undefined"){module["exports"]=Module}process["on"]("uncaughtException",(function(ex){if(!(ex instanceof ExitStatus)){throw ex}}));Module["inspect"]=(function(){return"[Emscripten Module object]"})}else if(ENVIRONMENT_IS_SHELL){if(!Module["print"])Module["print"]=print;if(typeof printErr!="undefined")Module["printErr"]=printErr;if(typeof read!="undefined"){Module["read"]=read}else{Module["read"]=function read(){throw"no read() available (jsc?)"}}Module["readBinary"]=function readBinary(f){if(typeof readbuffer==="function"){return new Uint8Array(readbuffer(f))}var data=read(f,"binary");assert(typeof data==="object");return data};if(typeof scriptArgs!="undefined"){Module["arguments"]=scriptArgs}else if(typeof arguments!="undefined"){Module["arguments"]=arguments}}else if(ENVIRONMENT_IS_WEB||ENVIRONMENT_IS_WORKER){Module["read"]=function read(url){var xhr=new XMLHttpRequest;xhr.open("GET",url,false);xhr.send(null);return xhr.responseText};Module["readAsync"]=function readAsync(url,onload,onerror){var xhr=new XMLHttpRequest;xhr.open("GET",url,true);xhr.responseType="arraybuffer";xhr.onload=function xhr_onload(){if(xhr.status==200||xhr.status==0&&xhr.response){onload(xhr.response)}else{onerror()}};xhr.onerror=onerror;xhr.send(null)};if(typeof arguments!="undefined"){Module["arguments"]=arguments}if(typeof console!=="undefined"){if(!Module["print"])Module["print"]=function print(x){console.log(x)};if(!Module["printErr"])Module["printErr"]=function printErr(x){console.warn(x)}}else{var TRY_USE_DUMP=false;if(!Module["print"])Module["print"]=TRY_USE_DUMP&&typeof dump!=="undefined"?(function(x){dump(x)}):(function(x){})}if(ENVIRONMENT_IS_WORKER){Module["load"]=importScripts}if(typeof Module["setWindowTitle"]==="undefined"){Module["setWindowTitle"]=(function(title){document.title=title})}}else{throw"Unknown runtime environment. Where are we?"}function globalEval(x){eval.call(null,x)}if(!Module["load"]&&Module["read"]){Module["load"]=function load(f){globalEval(Module["read"](f))}}if(!Module["print"]){Module["print"]=(function(){})}if(!Module["printErr"]){Module["printErr"]=Module["print"]}if(!Module["arguments"]){Module["arguments"]=[]}if(!Module["thisProgram"]){Module["thisProgram"]="./this.program"}Module.print=Module["print"];Module.printErr=Module["printErr"];Module["preRun"]=[];Module["postRun"]=[];for(var key in moduleOverrides){if(moduleOverrides.hasOwnProperty(key)){Module[key]=moduleOverrides[key]}}moduleOverrides=undefined;var Runtime={setTempRet0:(function(value){tempRet0=value}),getTempRet0:(function(){return tempRet0}),stackSave:(function(){return STACKTOP}),stackRestore:(function(stackTop){STACKTOP=stackTop}),getNativeTypeSize:(function(type){switch(type){case"i1":case"i8":return 1;case"i16":return 2;case"i32":return 4;case"i64":return 8;case"float":return 4;case"double":return 8;default:{if(type[type.length-1]==="*"){return Runtime.QUANTUM_SIZE}else if(type[0]==="i"){var bits=parseInt(type.substr(1));assert(bits%8===0);return bits/8}else{return 0}}}}),getNativeFieldSize:(function(type){return Math.max(Runtime.getNativeTypeSize(type),Runtime.QUANTUM_SIZE)}),STACK_ALIGN:16,prepVararg:(function(ptr,type){if(type==="double"||type==="i64"){if(ptr&7){assert((ptr&7)===4);ptr+=4}}else{assert((ptr&3)===0)}return ptr}),getAlignSize:(function(type,size,vararg){if(!vararg&&(type=="i64"||type=="double"))return 8;if(!type)return Math.min(size,8);return Math.min(size||(type?Runtime.getNativeFieldSize(type):0),Runtime.QUANTUM_SIZE)}),dynCall:(function(sig,ptr,args){if(args&&args.length){if(!args.splice)args=Array.prototype.slice.call(args);args.splice(0,0,ptr);return Module["dynCall_"+sig].apply(null,args)}else{return Module["dynCall_"+sig].call(null,ptr)}}),functionPointers:[],addFunction:(function(func){for(var i=0;i<Runtime.functionPointers.length;i++){if(!Runtime.functionPointers[i]){Runtime.functionPointers[i]=func;return 2*(1+i)}}throw"Finished up all reserved function pointers. Use a higher value for RESERVED_FUNCTION_POINTERS."}),removeFunction:(function(index){Runtime.functionPointers[(index-2)/2]=null}),warnOnce:(function(text){if(!Runtime.warnOnce.shown)Runtime.warnOnce.shown={};if(!Runtime.warnOnce.shown[text]){Runtime.warnOnce.shown[text]=1;Module.printErr(text)}}),funcWrappers:{},getFuncWrapper:(function(func,sig){assert(sig);if(!Runtime.funcWrappers[sig]){Runtime.funcWrappers[sig]={}}var sigCache=Runtime.funcWrappers[sig];if(!sigCache[func]){sigCache[func]=function dynCall_wrapper(){return Runtime.dynCall(sig,func,arguments)}}return sigCache[func]}),getCompilerSetting:(function(name){throw"You must build with -s RETAIN_COMPILER_SETTINGS=1 for Runtime.getCompilerSetting or emscripten_get_compiler_setting to work"}),stackAlloc:(function(size){var ret=STACKTOP;STACKTOP=STACKTOP+size|0;STACKTOP=STACKTOP+15&-16;return ret}),staticAlloc:(function(size){var ret=STATICTOP;STATICTOP=STATICTOP+size|0;STATICTOP=STATICTOP+15&-16;return ret}),dynamicAlloc:(function(size){var ret=DYNAMICTOP;DYNAMICTOP=DYNAMICTOP+size|0;DYNAMICTOP=DYNAMICTOP+15&-16;if(DYNAMICTOP>=TOTAL_MEMORY){var success=enlargeMemory();if(!success){DYNAMICTOP=ret;return 0}}return ret}),alignMemory:(function(size,quantum){var ret=size=Math.ceil(size/(quantum?quantum:16))*(quantum?quantum:16);return ret}),makeBigInt:(function(low,high,unsigned){var ret=unsigned?+(low>>>0)+ +(high>>>0)*+4294967296:+(low>>>0)+ +(high|0)*+4294967296;return ret}),GLOBAL_BASE:8,QUANTUM_SIZE:4,__dummy__:0};Module["Runtime"]=Runtime;var ABORT=false;var EXITSTATUS=0;function assert(condition,text){if(!condition){abort("Assertion failed: "+text)}}function getCFunc(ident){var func=Module["_"+ident];if(!func){try{func=eval("_"+ident)}catch(e){}}assert(func,"Cannot call unknown function "+ident+" (perhaps LLVM optimizations or closure removed it?)");return func}var cwrap,ccall;((function(){var JSfuncs={"stackSave":(function(){Runtime.stackSave()}),"stackRestore":(function(){Runtime.stackRestore()}),"arrayToC":(function(arr){var ret=Runtime.stackAlloc(arr.length);writeArrayToMemory(arr,ret);return ret}),"stringToC":(function(str){var ret=0;if(str!==null&&str!==undefined&&str!==0){ret=Runtime.stackAlloc((str.length<<2)+1);writeStringToMemory(str,ret)}return ret})};var toC={"string":JSfuncs["stringToC"],"array":JSfuncs["arrayToC"]};ccall=function ccallFunc(ident,returnType,argTypes,args,opts){var func=getCFunc(ident);var cArgs=[];var stack=0;if(args){for(var i=0;i<args.length;i++){var converter=toC[argTypes[i]];if(converter){if(stack===0)stack=Runtime.stackSave();cArgs[i]=converter(args[i])}else{cArgs[i]=args[i]}}}var ret=func.apply(null,cArgs);if(returnType==="string")ret=Pointer_stringify(ret);if(stack!==0){if(opts&&opts.async){EmterpreterAsync.asyncFinalizers.push((function(){Runtime.stackRestore(stack)}));return}Runtime.stackRestore(stack)}return ret};var sourceRegex=/^function\s*[a-zA-Z$_0-9]*\s*\(([^)]*)\)\s*{\s*([^*]*?)[\s;]*(?:return\s*(.*?)[;\s]*)?}$/;function parseJSFunc(jsfunc){var parsed=jsfunc.toString().match(sourceRegex).slice(1);return{arguments:parsed[0],body:parsed[1],returnValue:parsed[2]}}var JSsource=null;function ensureJSsource(){if(!JSsource){JSsource={};for(var fun in JSfuncs){if(JSfuncs.hasOwnProperty(fun)){JSsource[fun]=parseJSFunc(JSfuncs[fun])}}}}cwrap=function cwrap(ident,returnType,argTypes){argTypes=argTypes||[];var cfunc=getCFunc(ident);var numericArgs=argTypes.every((function(type){return type==="number"}));var numericRet=returnType!=="string";if(numericRet&&numericArgs){return cfunc}var argNames=argTypes.map((function(x,i){return"$"+i}));var funcstr="(function("+argNames.join(",")+") {";var nargs=argTypes.length;if(!numericArgs){ensureJSsource();funcstr+="var stack = "+JSsource["stackSave"].body+";";for(var i=0;i<nargs;i++){var arg=argNames[i],type=argTypes[i];if(type==="number")continue;var convertCode=JSsource[type+"ToC"];funcstr+="var "+convertCode.arguments+" = "+arg+";";funcstr+=convertCode.body+";";funcstr+=arg+"=("+convertCode.returnValue+");"}}var cfuncname=parseJSFunc((function(){return cfunc})).returnValue;funcstr+="var ret = "+cfuncname+"("+argNames.join(",")+");";if(!numericRet){var strgfy=parseJSFunc((function(){return Pointer_stringify})).returnValue;funcstr+="ret = "+strgfy+"(ret);"}if(!numericArgs){ensureJSsource();funcstr+=JSsource["stackRestore"].body.replace("()","(stack)")+";"}funcstr+="return ret})";return eval(funcstr)}}))();Module["ccall"]=ccall;Module["cwrap"]=cwrap;function setValue(ptr,value,type,noSafe){type=type||"i8";if(type.charAt(type.length-1)==="*")type="i32";switch(type){case"i1":HEAP8[ptr>>0]=value;break;case"i8":HEAP8[ptr>>0]=value;break;case"i16":HEAP16[ptr>>1]=value;break;case"i32":HEAP32[ptr>>2]=value;break;case"i64":tempI64=[value>>>0,(tempDouble=value,+Math_abs(tempDouble)>=+1?tempDouble>+0?(Math_min(+Math_floor(tempDouble/+4294967296),+4294967295)|0)>>>0:~~+Math_ceil((tempDouble- +(~~tempDouble>>>0))/+4294967296)>>>0:0)],HEAP32[ptr>>2]=tempI64[0],HEAP32[ptr+4>>2]=tempI64[1];break;case"float":HEAPF32[ptr>>2]=value;break;case"double":HEAPF64[ptr>>3]=value;break;default:abort("invalid type for setValue: "+type)}}Module["setValue"]=setValue;function getValue(ptr,type,noSafe){type=type||"i8";if(type.charAt(type.length-1)==="*")type="i32";switch(type){case"i1":return HEAP8[ptr>>0];case"i8":return HEAP8[ptr>>0];case"i16":return HEAP16[ptr>>1];case"i32":return HEAP32[ptr>>2];case"i64":return HEAP32[ptr>>2];case"float":return HEAPF32[ptr>>2];case"double":return HEAPF64[ptr>>3];default:abort("invalid type for setValue: "+type)}return null}Module["getValue"]=getValue;var ALLOC_NORMAL=0;var ALLOC_STACK=1;var ALLOC_STATIC=2;var ALLOC_DYNAMIC=3;var ALLOC_NONE=4;Module["ALLOC_NORMAL"]=ALLOC_NORMAL;Module["ALLOC_STACK"]=ALLOC_STACK;Module["ALLOC_STATIC"]=ALLOC_STATIC;Module["ALLOC_DYNAMIC"]=ALLOC_DYNAMIC;Module["ALLOC_NONE"]=ALLOC_NONE;function allocate(slab,types,allocator,ptr){var zeroinit,size;if(typeof slab==="number"){zeroinit=true;size=slab}else{zeroinit=false;size=slab.length}var singleType=typeof types==="string"?types:null;var ret;if(allocator==ALLOC_NONE){ret=ptr}else{ret=[typeof _malloc==="function"?_malloc:Runtime.staticAlloc,Runtime.stackAlloc,Runtime.staticAlloc,Runtime.dynamicAlloc][allocator===undefined?ALLOC_STATIC:allocator](Math.max(size,singleType?1:types.length))}if(zeroinit){var ptr=ret,stop;assert((ret&3)==0);stop=ret+(size&~3);for(;ptr<stop;ptr+=4){HEAP32[ptr>>2]=0}stop=ret+size;while(ptr<stop){HEAP8[ptr++>>0]=0}return ret}if(singleType==="i8"){if(slab.subarray||slab.slice){HEAPU8.set(slab,ret)}else{HEAPU8.set(new Uint8Array(slab),ret)}return ret}var i=0,type,typeSize,previousType;while(i<size){var curr=slab[i];if(typeof curr==="function"){curr=Runtime.getFunctionIndex(curr)}type=singleType||types[i];if(type===0){i++;continue}if(type=="i64")type="i32";setValue(ret+i,curr,type);if(previousType!==type){typeSize=Runtime.getNativeTypeSize(type);previousType=type}i+=typeSize}return ret}Module["allocate"]=allocate;function getMemory(size){if(!staticSealed)return Runtime.staticAlloc(size);if(typeof _sbrk!=="undefined"&&!_sbrk.called||!runtimeInitialized)return Runtime.dynamicAlloc(size);return _malloc(size)}Module["getMemory"]=getMemory;function Pointer_stringify(ptr,length){if(length===0||!ptr)return"";var hasUtf=0;var t;var i=0;while(1){t=HEAPU8[ptr+i>>0];hasUtf|=t;if(t==0&&!length)break;i++;if(length&&i==length)break}if(!length)length=i;var ret="";if(hasUtf<128){var MAX_CHUNK=1024;var curr;while(length>0){curr=String.fromCharCode.apply(String,HEAPU8.subarray(ptr,ptr+Math.min(length,MAX_CHUNK)));ret=ret?ret+curr:curr;ptr+=MAX_CHUNK;length-=MAX_CHUNK}return ret}return Module["UTF8ToString"](ptr)}Module["Pointer_stringify"]=Pointer_stringify;function AsciiToString(ptr){var str="";while(1){var ch=HEAP8[ptr++>>0];if(!ch)return str;str+=String.fromCharCode(ch)}}Module["AsciiToString"]=AsciiToString;function stringToAscii(str,outPtr){return writeAsciiToMemory(str,outPtr,false)}Module["stringToAscii"]=stringToAscii;function UTF8ArrayToString(u8Array,idx){var u0,u1,u2,u3,u4,u5;var str="";while(1){u0=u8Array[idx++];if(!u0)return str;if(!(u0&128)){str+=String.fromCharCode(u0);continue}u1=u8Array[idx++]&63;if((u0&224)==192){str+=String.fromCharCode((u0&31)<<6|u1);continue}u2=u8Array[idx++]&63;if((u0&240)==224){u0=(u0&15)<<12|u1<<6|u2}else{u3=u8Array[idx++]&63;if((u0&248)==240){u0=(u0&7)<<18|u1<<12|u2<<6|u3}else{u4=u8Array[idx++]&63;if((u0&252)==248){u0=(u0&3)<<24|u1<<18|u2<<12|u3<<6|u4}else{u5=u8Array[idx++]&63;u0=(u0&1)<<30|u1<<24|u2<<18|u3<<12|u4<<6|u5}}}if(u0<65536){str+=String.fromCharCode(u0)}else{var ch=u0-65536;str+=String.fromCharCode(55296|ch>>10,56320|ch&1023)}}}Module["UTF8ArrayToString"]=UTF8ArrayToString;function UTF8ToString(ptr){return UTF8ArrayToString(HEAPU8,ptr)}Module["UTF8ToString"]=UTF8ToString;function stringToUTF8Array(str,outU8Array,outIdx,maxBytesToWrite){if(!(maxBytesToWrite>0))return 0;var startIdx=outIdx;var endIdx=outIdx+maxBytesToWrite-1;for(var i=0;i<str.length;++i){var u=str.charCodeAt(i);if(u>=55296&&u<=57343)u=65536+((u&1023)<<10)|str.charCodeAt(++i)&1023;if(u<=127){if(outIdx>=endIdx)break;outU8Array[outIdx++]=u}else if(u<=2047){if(outIdx+1>=endIdx)break;outU8Array[outIdx++]=192|u>>6;outU8Array[outIdx++]=128|u&63}else if(u<=65535){if(outIdx+2>=endIdx)break;outU8Array[outIdx++]=224|u>>12;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}else if(u<=2097151){if(outIdx+3>=endIdx)break;outU8Array[outIdx++]=240|u>>18;outU8Array[outIdx++]=128|u>>12&63;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}else if(u<=67108863){if(outIdx+4>=endIdx)break;outU8Array[outIdx++]=248|u>>24;outU8Array[outIdx++]=128|u>>18&63;outU8Array[outIdx++]=128|u>>12&63;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}else{if(outIdx+5>=endIdx)break;outU8Array[outIdx++]=252|u>>30;outU8Array[outIdx++]=128|u>>24&63;outU8Array[outIdx++]=128|u>>18&63;outU8Array[outIdx++]=128|u>>12&63;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}}outU8Array[outIdx]=0;return outIdx-startIdx}Module["stringToUTF8Array"]=stringToUTF8Array;function stringToUTF8(str,outPtr,maxBytesToWrite){return stringToUTF8Array(str,HEAPU8,outPtr,maxBytesToWrite)}Module["stringToUTF8"]=stringToUTF8;function lengthBytesUTF8(str){var len=0;for(var i=0;i<str.length;++i){var u=str.charCodeAt(i);if(u>=55296&&u<=57343)u=65536+((u&1023)<<10)|str.charCodeAt(++i)&1023;if(u<=127){++len}else if(u<=2047){len+=2}else if(u<=65535){len+=3}else if(u<=2097151){len+=4}else if(u<=67108863){len+=5}else{len+=6}}return len}Module["lengthBytesUTF8"]=lengthBytesUTF8;function demangle(func){var hasLibcxxabi=!!Module["___cxa_demangle"];if(hasLibcxxabi){try{var buf=_malloc(func.length);writeStringToMemory(func.substr(1),buf);var status=_malloc(4);var ret=Module["___cxa_demangle"](buf,0,0,status);if(getValue(status,"i32")===0&&ret){return Pointer_stringify(ret)}}catch(e){return func}finally{if(buf)_free(buf);if(status)_free(status);if(ret)_free(ret)}}Runtime.warnOnce("warning: build with  -s DEMANGLE_SUPPORT=1  to link in libcxxabi demangling");return func}function demangleAll(text){return text.replace(/__Z[\w\d_]+/g,(function(x){var y=demangle(x);return x===y?x:x+" ["+y+"]"}))}function jsStackTrace(){var err=new Error;if(!err.stack){try{throw new Error(0)}catch(e){err=e}if(!err.stack){return"(no stack trace available)"}}return err.stack.toString()}function stackTrace(){return demangleAll(jsStackTrace())}Module["stackTrace"]=stackTrace;var PAGE_SIZE=4096;function alignMemoryPage(x){if(x%4096>0){x+=4096-x%4096}return x}var HEAP;var buffer;var HEAP8,HEAPU8,HEAP16,HEAPU16,HEAP32,HEAPU32,HEAPF32,HEAPF64;function updateGlobalBufferViews(){Module["HEAP8"]=HEAP8=new Int8Array(buffer);Module["HEAP16"]=HEAP16=new Int16Array(buffer);Module["HEAP32"]=HEAP32=new Int32Array(buffer);Module["HEAPU8"]=HEAPU8=new Uint8Array(buffer);Module["HEAPU16"]=HEAPU16=new Uint16Array(buffer);Module["HEAPU32"]=HEAPU32=new Uint32Array(buffer);Module["HEAPF32"]=HEAPF32=new Float32Array(buffer);Module["HEAPF64"]=HEAPF64=new Float64Array(buffer)}var STATIC_BASE=0,STATICTOP=0,staticSealed=false;var STACK_BASE=0,STACKTOP=0,STACK_MAX=0;var DYNAMIC_BASE=0,DYNAMICTOP=0;function abortOnCannotGrowMemory(){abort("Cannot enlarge memory arrays. Either (1) compile with  -s TOTAL_MEMORY=X  with X higher than the current value "+TOTAL_MEMORY+", (2) compile with  -s ALLOW_MEMORY_GROWTH=1  which adjusts the size at runtime but prevents some optimizations, (3) set Module.TOTAL_MEMORY to a higher value before the program runs, or if you want malloc to return NULL (0) instead of this abort, compile with  -s ABORTING_MALLOC=0 ")}function enlargeMemory(){abortOnCannotGrowMemory()}var TOTAL_STACK=Module["TOTAL_STACK"]||5242880;var TOTAL_MEMORY=Module["TOTAL_MEMORY"]||3355e4;var totalMemory=64*1024;while(totalMemory<TOTAL_MEMORY||totalMemory<2*TOTAL_STACK){if(totalMemory<16*1024*1024){totalMemory*=2}else{totalMemory+=16*1024*1024}}if(totalMemory!==TOTAL_MEMORY){TOTAL_MEMORY=totalMemory}if(Module["buffer"]){buffer=Module["buffer"]}else{buffer=new ArrayBuffer(TOTAL_MEMORY)}updateGlobalBufferViews();HEAP32[0]=255;if(HEAPU8[0]!==255||HEAPU8[3]!==0)throw"Typed arrays 2 must be run on a little-endian system";Module["HEAP"]=HEAP;Module["buffer"]=buffer;Module["HEAP8"]=HEAP8;Module["HEAP16"]=HEAP16;Module["HEAP32"]=HEAP32;Module["HEAPU8"]=HEAPU8;Module["HEAPU16"]=HEAPU16;Module["HEAPU32"]=HEAPU32;Module["HEAPF32"]=HEAPF32;Module["HEAPF64"]=HEAPF64;function callRuntimeCallbacks(callbacks){while(callbacks.length>0){var callback=callbacks.shift();if(typeof callback=="function"){callback();continue}var func=callback.func;if(typeof func==="number"){if(callback.arg===undefined){Runtime.dynCall("v",func)}else{Runtime.dynCall("vi",func,[callback.arg])}}else{func(callback.arg===undefined?null:callback.arg)}}}var __ATPRERUN__=[];var __ATINIT__=[];var __ATMAIN__=[];var __ATEXIT__=[];var __ATPOSTRUN__=[];var runtimeInitialized=false;var runtimeExited=false;function preRun(){if(Module["preRun"]){if(typeof Module["preRun"]=="function")Module["preRun"]=[Module["preRun"]];while(Module["preRun"].length){addOnPreRun(Module["preRun"].shift())}}callRuntimeCallbacks(__ATPRERUN__)}function ensureInitRuntime(){if(runtimeInitialized)return;runtimeInitialized=true;callRuntimeCallbacks(__ATINIT__)}function preMain(){callRuntimeCallbacks(__ATMAIN__)}function exitRuntime(){callRuntimeCallbacks(__ATEXIT__);runtimeExited=true}function postRun(){if(Module["postRun"]){if(typeof Module["postRun"]=="function")Module["postRun"]=[Module["postRun"]];while(Module["postRun"].length){addOnPostRun(Module["postRun"].shift())}}callRuntimeCallbacks(__ATPOSTRUN__)}function addOnPreRun(cb){__ATPRERUN__.unshift(cb)}Module["addOnPreRun"]=addOnPreRun;function addOnInit(cb){__ATINIT__.unshift(cb)}Module["addOnInit"]=addOnInit;function addOnPreMain(cb){__ATMAIN__.unshift(cb)}Module["addOnPreMain"]=addOnPreMain;function addOnExit(cb){__ATEXIT__.unshift(cb)}Module["addOnExit"]=addOnExit;function addOnPostRun(cb){__ATPOSTRUN__.unshift(cb)}Module["addOnPostRun"]=addOnPostRun;function intArrayFromString(stringy,dontAddNull,length){var len=length>0?length:lengthBytesUTF8(stringy)+1;var u8array=new Array(len);var numBytesWritten=stringToUTF8Array(stringy,u8array,0,u8array.length);if(dontAddNull)u8array.length=numBytesWritten;return u8array}Module["intArrayFromString"]=intArrayFromString;function intArrayToString(array){var ret=[];for(var i=0;i<array.length;i++){var chr=array[i];if(chr>255){chr&=255}ret.push(String.fromCharCode(chr))}return ret.join("")}Module["intArrayToString"]=intArrayToString;function writeStringToMemory(string,buffer,dontAddNull){var array=intArrayFromString(string,dontAddNull);var i=0;while(i<array.length){var chr=array[i];HEAP8[buffer+i>>0]=chr;i=i+1}}Module["writeStringToMemory"]=writeStringToMemory;function writeArrayToMemory(array,buffer){for(var i=0;i<array.length;i++){HEAP8[buffer++>>0]=array[i]}}Module["writeArrayToMemory"]=writeArrayToMemory;function writeAsciiToMemory(str,buffer,dontAddNull){for(var i=0;i<str.length;++i){HEAP8[buffer++>>0]=str.charCodeAt(i)}if(!dontAddNull)HEAP8[buffer>>0]=0}Module["writeAsciiToMemory"]=writeAsciiToMemory;if(!Math["imul"]||Math["imul"](4294967295,5)!==-5)Math["imul"]=function imul(a,b){var ah=a>>>16;var al=a&65535;var bh=b>>>16;var bl=b&65535;return al*bl+(ah*bl+al*bh<<16)|0};Math.imul=Math["imul"];if(!Math["clz32"])Math["clz32"]=(function(x){x=x>>>0;for(var i=0;i<32;i++){if(x&1<<31-i)return i}return 32});Math.clz32=Math["clz32"];var Math_abs=Math.abs;var Math_cos=Math.cos;var Math_sin=Math.sin;var Math_tan=Math.tan;var Math_acos=Math.acos;var Math_asin=Math.asin;var Math_atan=Math.atan;var Math_atan2=Math.atan2;var Math_exp=Math.exp;var Math_log=Math.log;var Math_sqrt=Math.sqrt;var Math_ceil=Math.ceil;var Math_floor=Math.floor;var Math_pow=Math.pow;var Math_imul=Math.imul;var Math_fround=Math.fround;var Math_min=Math.min;var Math_clz32=Math.clz32;var runDependencies=0;var runDependencyWatcher=null;var dependenciesFulfilled=null;function getUniqueRunDependency(id){return id}function addRunDependency(id){runDependencies++;if(Module["monitorRunDependencies"]){Module["monitorRunDependencies"](runDependencies)}}Module["addRunDependency"]=addRunDependency;function removeRunDependency(id){runDependencies--;if(Module["monitorRunDependencies"]){Module["monitorRunDependencies"](runDependencies)}if(runDependencies==0){if(runDependencyWatcher!==null){clearInterval(runDependencyWatcher);runDependencyWatcher=null}if(dependenciesFulfilled){var callback=dependenciesFulfilled;dependenciesFulfilled=null;callback()}}}Module["removeRunDependency"]=removeRunDependency;Module["preloadedImages"]={};Module["preloadedAudios"]={};var ASM_CONSTS=[];STATIC_BASE=8;STATICTOP=STATIC_BASE+1219568;__ATINIT__.push({func:(function(){__GLOBAL__I_000101()})},{func:(function(){__GLOBAL__sub_I_position_cpp()})},{func:(function(){__GLOBAL__sub_I_iostream_cpp()})},{func:(function(){__GLOBAL__sub_I_ucioption_cpp()})},{func:(function(){__GLOBAL__sub_I_uci_cpp()})},{func:(function(){__GLOBAL__sub_I_tt_cpp()})},{func:(function(){__GLOBAL__sub_I_timeman_cpp()})},{func:(function(){__GLOBAL__sub_I_thread_cpp()})},{func:(function(){__GLOBAL__sub_I_search_cpp()})},{func:(function(){__GLOBAL__sub_I_psqt_cpp()})},{func:(function(){__GLOBAL__sub_I_bitbase_cpp()})},{func:(function(){__GLOBAL__sub_I_pawns_cpp()})},{func:(function(){__GLOBAL__sub_I_movepick_cpp()})},{func:(function(){__GLOBAL__sub_I_movegen_cpp()})},{func:(function(){__GLOBAL__sub_I_misc_cpp()})},{func:(function(){__GLOBAL__sub_I_material_cpp()})},{func:(function(){__GLOBAL__sub_I_main_cpp()})},{func:(function(){__GLOBAL__sub_I_evaluate_cpp()})},{func:(function(){__GLOBAL__sub_I_endgame_cpp()})},{func:(function(){__GLOBAL__sub_I_bitboard_cpp()})});allocate([15,15,15,15,15,0,0,0,15,15,15,15,15,0,0,0,15,15,15,15,15,0,0,0,60,60,60,60,60,0,0,0,60,60,60,60,60,0,0,0,240,240,240,240,240,0,0,0,240,240,240,240,240,0,0,0,240,240,240,240,240,0,0,0,0,0,0,15,15,15,15,15,0,0,0,15,15,15,15,15,0,0,0,15,15,15,15,15,0,0,0,60,60,60,60,60,0,0,0,60,60,60,60,60,0,0,0,240,240,240,240,240,0,0,0,240,240,240,240,240,0,0,0,240,240,240,240,240,44,59,0,0,39,79,0,0,240,0,0,0,0,0,0,0,44,59,0,0,101,79,0,0,240,0,0,0,0,0,0,0,44,59,0,0,126,79,0,0,248,0,0,0,0,0,0,0,44,59,0,0,150,79,0,0,248,0,0,0,0,0,0,0,44,59,0,0,254,80,0,0,216,0,0,0,0,0,0,0,4,59,0,0,40,81,0,0,44,59,0,0,58,81,0,0,216,0,0,0,0,0,0,0,4,59,0,0,100,81,0,0,4,59,0,0,149,81,0,0,104,59,0,0,198,81,0,0,0,0,0,0,1,0,0,0,200,0,0,0,3,244,255,255,104,59,0,0,245,81,0,0,0,0,0,0,1,0,0,0,224,0,0,0,3,244,255,255,104,59,0,0,36,82,0,0,0,0,0,0,1,0,0,0,200,0,0,0,3,244,255,255,104,59,0,0,83,82,0,0,0,0,0,0,1,0,0,0,224,0,0,0,3,244,255,255,44,59,0,0,130,82,0,0,112,1,0,0,0,0,0,0,44,59,0,0,150,82,0,0,192,5,0,0,0,0,0,0,44,59,0,0,172,82,0,0,112,1,0,0,0,0,0,0,104,59,0,0,192,82,0,0,0,0,0,0,2,0,0,0,112,1,0,0,2,0,0,0,176,1,0,0,0,0,0,0,104,59,0,0,4,83,0,0,0,0,0,0,1,0,0,0,200,1,0,0,0,0,0,0,4,59,0,0,26,83,0,0,104,59,0,0,89,83,0,0,0,0,0,0,2,0,0,0,112,1,0,0,2,0,0,0,240,1,0,0,0,0,0,0,104,59,0,0,157,83,0,0,0,0,0,0,1,0,0,0,200,1,0,0,0,0,0,0,104,59,0,0,179,83,0,0,0,0,0,0,2,0,0,0,112,1,0,0,2,0,0,0,40,2,0,0,0,0,0,0,104,59,0,0,247,83,0,0,0,0,0,0,1,0,0,0,64,2,0,0,0,0,0,0,4,59,0,0,13,84,0,0,104,59,0,0,57,84,0,0,0,0,0,0,2,0,0,0,112,1,0,0,2,0,0,0,104,2,0,0,0,0,0,0,104,59,0,0,125,84,0,0,0,0,0,0,1,0,0,0,64,2,0,0,0,0,0,0,104,59,0,0,147,84,0,0,0,0,0,0,3,0,0,0,112,1,0,0,2,0,0,0,168,2,0,0,2,0,0,0,176,2,0,0,0,8,0,0,4,59,0,0,216,84,0,0,4,59,0,0,235,84,0,0,104,59,0,0,77,86,0,0,0,0,0,0,3,0,0,0,112,1,0,0,2,0,0,0,168,2,0,0,2,0,0,0,224,2,0,0,0,8,0,0,4,59,0,0,146,86,0,0,104,59,0,0,180,86,0,0,0,0,0,0,2,0,0,0,112,1,0,0,2,0,0,0,8,3,0,0,0,8,0,0,4,59,0,0,249,86,0,0,104,59,0,0,14,87,0,0,0,0,0,0,2,0,0,0,112,1,0,0,2,0,0,0,8,3,0,0,0,8,0,0,104,59,0,0,83,87,0,0,0,0,0,0,2,0,0,0,112,1,0,0,2,0,0,0,80,3,0,0,2,0,0,0,4,59,0,0,111,87,0,0,104,59,0,0,132,87,0,0,0,0,0,0,2,0,0,0,112,1,0,0,2,0,0,0,80,3,0,0,2,0,0,0,104,59,0,0,160,87,0,0,0,0,0,0,2,0,0,0,112,1,0,0,2,0,0,0,80,3,0,0,2,0,0,0,104,59,0,0,188,87,0,0,0,0,0,0,2,0,0,0,112,1,0,0,2,0,0,0,80,3,0,0,2,0,0,0,104,59,0,0,216,87,0,0,0,0,0,0,2,0,0,0,112,1,0,0,2,0,0,0,216,3,0,0,0,0,0,0,4,59,0,0,30,88,0,0,104,59,0,0,70,88,0,0,0,0,0,0,2,0,0,0,112,1,0,0,2,0,0,0,0,4,0,0,0,0,0,0,4,59,0,0,140,88,0,0,104,59,0,0,176,88,0,0,0,0,0,0,2,0,0,0,112,1,0,0,2,0,0,0,40,4,0,0,0,0,0,0,4,59,0,0,246,88,0,0,104,59,0,0,21,89,0,0,0,0,0,0,2,0,0,0,112,1,0,0,2,0,0,0,80,4,0,0,0,0,0,0,4,59,0,0,91,89,0,0,104,59,0,0,116,89,0,0,0,0,0,0,2,0,0,0,112,1,0,0,2,0,0,0,120,4,0,0,2,0,0,0,4,59,0,0,137,89,0,0,104,59,0,0,161,89,0,0,0,0,0,0,2,0,0,0,112,1,0,0,2,0,0,0,120,4,0,0,2,0,0,0,44,59,0,0,182,89,0,0,176,4,0,0,0,0,0,0,104,59,0,0,216,89,0,0,0,0,0,0,2,0,0,0,112,1,0,0,2,0,0,0,208,4,0,0,2,0,0,0,4,59,0,0,251,89,0,0,44,59,0,0,18,90,0,0,176,4,0,0,0,0,0,0,104,59,0,0,53,90,0,0,0,0,0,0,2,0,0,0,112,1,0,0,2,0,0,0,208,4,0,0,2,0,0,0,104,59,0,0,87,90,0,0,0,0,0,0,2,0,0,0,112,1,0,0,2,0,0,0,208,4,0,0,2,0,0,0,104,59,0,0,121,90,0,0,0,0,0,0,2,0,0,0,112,1,0,0,2,0,0,0,208,4,0,0,2,0,0,0,44,59,0,0,156,90,0,0,112,1,0,0,0,0,0,0,104,59,0,0,178,90,0,0,0,0,0,0,2,0,0,0,112,1,0,0,2,0,0,0,120,5,0,0,2,0,0,0,4,59,0,0,196,90,0,0,104,59,0,0,217,90,0,0,0,0,0,0,2,0,0,0,112,1,0,0,2,0,0,0,120,5,0,0,2,0,0,0,44,59,0,0,235,90,0,0,112,1,0,0,0,0,0,0,44,59,0,0,11,91,0,0,112,1,0,0,0,0,0,0,4,59,0,0,204,91,0,0,4,59,0,0,242,92,0,0,44,59,0,0,208,92,0,0,240,5,0,0,0,0,0,0,44,59,0,0,125,92,0,0,208,5,0,0,0,0,0,0,44,59,0,0,162,92,0,0,0,6,0,0,0,0,0,0,4,59,0,0,195,92,0,0,44,59,0,0,184,93,0,0,200,5,0,0,0,0,0,0,44,59,0,0,212,93,0,0,208,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,0,0,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,0,0,0,15,0,0,0,10,0,0,0,6,0,0,0,250,255,255,255,246,255,255,255,241,255,255,255,239,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,0,7,0,0,0,249,255,255,255,247,255,255,255,8,0,0,0,1,0,0,0,255,255,255,255,248,255,255,255,0,0,0,0,8,0,0,0,1,0,0,0,248,255,255,255,255,255,255,255,9,0,0,0,249,255,255,255,247,255,255,255,7,0,0,0,17,35,0,0,16,174,0,0,71,212,0,0,86,152,0,0,99,22,0,0,229,115,1,0,208,153,1,0,124,66,0,0,216,2,0,0,76,40,0,0,229,214,0,0,35,128,0,0,249,47,0,0,252,58,0,0,5,65,0,0,255,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,3,0,0,0,2,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,4,0,0,0,3,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,100,0,0,0,80,0,0,0,60,0,0,0,40,0,0,0,20,0,0,0,10,0,0,0,200,0,0,0,190,0,0,0,180,0,0,0,170,0,0,0,160,0,0,0,150,0,0,0,140,0,0,0,130,0,0,0,190,0,0,0,180,0,0,0,170,0,0,0,160,0,0,0,150,0,0,0,140,0,0,0,130,0,0,0,140,0,0,0,180,0,0,0,170,0,0,0,155,0,0,0,140,0,0,0,140,0,0,0,125,0,0,0,140,0,0,0,150,0,0,0,170,0,0,0,160,0,0,0,140,0,0,0,120,0,0,0,110,0,0,0,140,0,0,0,150,0,0,0,160,0,0,0,160,0,0,0,150,0,0,0,140,0,0,0,110,0,0,0,120,0,0,0,140,0,0,0,160,0,0,0,170,0,0,0,150,0,0,0,140,0,0,0,125,0,0,0,140,0,0,0,140,0,0,0,155,0,0,0,170,0,0,0,180,0,0,0,140,0,0,0,130,0,0,0,140,0,0,0,150,0,0,0,160,0,0,0,170,0,0,0,180,0,0,0,190,0,0,0,130,0,0,0,140,0,0,0,150,0,0,0,160,0,0,0,170,0,0,0,180,0,0,0,190,0,0,0,200,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,5,0,0,0,4,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,6,0,0,0,5,0,0,0,5,0,0,0,100,0,0,0,90,0,0,0,80,0,0,0,70,0,0,0,70,0,0,0,80,0,0,0,90,0,0,0,100,0,0,0,90,0,0,0,70,0,0,0,60,0,0,0,50,0,0,0,50,0,0,0,60,0,0,0,70,0,0,0,90,0,0,0,80,0,0,0,60,0,0,0,40,0,0,0,30,0,0,0,30,0,0,0,40,0,0,0,60,0,0,0,80,0,0,0,70,0,0,0,50,0,0,0,30,0,0,0,20,0,0,0,20,0,0,0,30,0,0,0,50,0,0,0,70,0,0,0,70,0,0,0,50,0,0,0,30,0,0,0,20,0,0,0,20,0,0,0,30,0,0,0,50,0,0,0,70,0,0,0,80,0,0,0,60,0,0,0,40,0,0,0,30,0,0,0,30,0,0,0,40,0,0,0,60,0,0,0,80,0,0,0,90,0,0,0,70,0,0,0,60,0,0,0,50,0,0,0,50,0,0,0,60,0,0,0,70,0,0,0,90,0,0,0,100,0,0,0,90,0,0,0,80,0,0,0,70,0,0,0,70,0,0,0,80,0,0,0,90,0,0,0,100,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,7,0,0,0,6,0,0,0,6,0,0,0,0,0,0,0,5,0,0,0,20,0,0,0,40,0,0,0,60,0,0,0,80,0,0,0,90,0,0,0,100,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,8,0,0,0,7,0,0,0,7,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,9,0,0,0,8,0,0,0,8,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,11,0,0,0,9,0,0,0,9,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,12,0,0,0,10,0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,13,0,0,0,11,0,0,0,11,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,14,0,0,0,12,0,0,0,12,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,15,0,0,0,13,0,0,0,13,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,16,0,0,0,14,0,0,0,14,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,17,0,0,0,15,0,0,0,15,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,18,0,0,0,16,0,0,0,16,0,0,0,0,0,0,0,9,0,0,0,10,0,0,0,14,0,0,0,21,0,0,0,44,0,0,0,0,0,0,0,0,0,0,0,116,6,0,0,116,6,0,0,116,6,0,0,116,6,0,0,116,6,0,0,116,6,0,0,116,6,0,0,232,12,0,0,28,0,0,0,27,0,0,0,35,0,0,0,36,0,0,0,5,0,0,0,5,0,0,0,31,0,0,0,73,0,0,0,166,0,0,0,252,0,0,0,0,0,0,0,0,0,0,0,7,0,0,0,14,0,0,0,38,0,0,0,73,0,0,0,166,0,0,0,252,0,0,0,0,0,0,0,0,0,0,0,5,0,0,0,5,0,0,0,31,0,0,0,73,0,0,0,166,0,0,0,252,0,0,0,0,0,0,0,0,0,0,0,7,0,0,0,14,0,0,0,38,0,0,0,73,0,0,0,166,0,0,0,252,0,0,0,0,0,0,0,0,0,0,0,106,0,0,0,124,0,0,0,147,0,0,0,165,0,0,0,169,0,0,0,177,0,0,0,0,0,0,0,0,0,0,0,103,0,0,0,118,0,0,0,148,0,0,0,155,0,0,0,142,0,0,0,153,0,0,0,0,0,0,0,0,0,0,0,15,0,0,0,23,0,0,0,13,0,0,0,88,0,0,0,177,0,0,0,229,0,0,0,0,0,0,0,0,0,0,0,27,0,0,0,13,0,0,0,19,0,0,0,111,0,0,0,140,0,0,0,203,0,0,0,0,0,0,0,0,0,0,0,5,0,0,0,5,0,0,0,31,0,0,0,73,0,0,0,166,0,0,0,252,0,0,0,0,0,0,0,0,0,0,0,7,0,0,0,14,0,0,0,38,0,0,0,73,0,0,0,166,0,0,0,252,0,0,0,0,0,0,0,0,0,0,0,5,0,0,0,5,0,0,0,31,0,0,0,73,0,0,0,166,0,0,0,252,0,0,0,0,0,0,0,0,0,0,0,7,0,0,0,14,0,0,0,38,0,0,0,73,0,0,0,166,0,0,0,252,0,0,0,0,0,0,0,0,0,0,0,5,0,0,0,5,0,0,0,31,0,0,0,73,0,0,0,166,0,0,0,252,0,0,0,0,0,0,0,0,0,0,0,7,0,0,0,14,0,0,0,38,0,0,0,73,0,0,0,166,0,0,0,252,0,0,0,0,0,0,0,0,0,0,0,5,0,0,0,5,0,0,0,31,0,0,0,73,0,0,0,166,0,0,0,252,0,0,0,0,0,0,0,0,0,0,0,7,0,0,0,14,0,0,0,38,0,0,0,73,0,0,0,166,0,0,0,252,0,0,0,0,0,0,0,0,0,0,0,64,0,0,0,0,0,0,0,0,0,0,0,19,0,0,0,20,0,0,0,56,0,0,0,248,255,255,255,0,0,0,0,21,0,0,0,22,0,0,0,192,255,255,255,192,255,255,255,0,0,0,0,23,0,0,0,24,0,0,0,0,0,0,0,0,0,0,0,25,0,0,0,26,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,17,0,0,0,18,0,0,0,2,0,0,0,19,0,0,0,20,0,0,0,17,0,0,0,3,0,0,0,18,0,0,0,160,13,0,0,68,14,0,0,128,14,0,0,148,14,0,0,100,25,0,0,120,25,0,0,108,14,0,0,88,14,0,0,200,13,0,0,180,13,0,0,64,0,0,0,0,0,0,0,0,0,0,0,27,0,0,0,28,0,0,0,56,0,0,0,248,255,255,255,0,0,0,0,29,0,0,0,30,0,0,0,192,255,255,255,192,255,255,255,0,0,0,0,31,0,0,0,32,0,0,0,64,0,0,0,0,0,0,0,0,0,0,0,33,0,0,0,34,0,0,0,192,255,255,255,192,255,255,255,0,0,0,0,35,0,0,0,36,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,37,0,0,0,21,0,0,0,19,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,38,0,0,0,22,0,0,0,20,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,39,0,0,0,23,0,0,0,21,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,40,0,0,0,24,0,0,0,22,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,41,0,0,0,25,0,0,0,23,0,0,0,194,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,77,255,255,255,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,206,255,255,255,178,0,0,0,209,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,126,255,255,255,69,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,101,255,255,255,195,254,255,255,60,0,0,0,38,255,255,255,224,254,255,255,0,0,0,0,0,0,0,0,0,0,0,0,89,0,0,0,253,254,255,255,196,255,255,255,77,255,255,255,224,255,255,255,180,255,255,255,0,0,0,0,0,0,0,0,39,255,255,255,177,255,255,255,40,0,0,0,233,255,255,255,9,0,0,0,193,255,255,255,59,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,110,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,0,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,203,255,255,255,113,255,255,255,33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,73,0,0,0,214,254,255,255,3,0,0,0,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,115,255,255,255,142,254,255,255,56,0,0,0,45,0,0,0,177,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,246,0,0,0,216,255,255,255,62,255,255,255,178,0,0,0,217,255,255,255,74,0,0,0,0,0,0,0,0,0,0,0,131,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,0,0,0,255,0,0,0,253,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,104,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,230,255,255,255,254,255,255,255,47,0,0,0,105,0,0,0,107,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,71,255,255,255,24,0,0,0,122,0,0,0,137,0,0,0,122,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,0,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,59,0,0,0,65,0,0,0,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,46,0,0,0,39,0,0,0,24,0,0,0,232,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,101,0,0,0,100,0,0,0,219,255,255,255,141,0,0,0,12,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,104,0,0,0,0,0,0,0,0,0,0,0,42,0,0,0,43,0,0,0,152,255,255,255,152,255,255,255,0,0,0,0,44,0,0,0,45,0,0,0,104,0,0,0,0,0,0,0,0,0,0,0,46,0,0,0,47,0,0,0,152,255,255,255,152,255,255,255,0,0,0,0,48,0,0,0,49,0,0,0,0,0,0,0,0,0,0,0,50,0,0,0,51,0,0,0,2,0,0,0,4,0,0,0,2,0,0,0,2,0,0,0,26,0,0,0,18,0,0,0,2,0,0,0,27,0,0,0,20,0,0,0,24,0,0,0,3,0,0,0,25,0,0,0,136,18,0,0,96,18,0,0,116,18,0,0,156,18,0,0,0,0,0,0,0,0,0,0,52,0,0,0,53,0,0,0,1,0,0,0,1,0,0,0,3,0,0,0,3,0,0,0,28,0,0,0,18,0,0,0,2,0,0,0,29,0,0,0,30,0,0,0,26,0,0,0,3,0,0,0,27,0,0,0,10,0,0,0,100,0,0,0,20,0,0,0,10,0,0,0,46,0,0,0,82,0,0,0,86,0,0,0,98,0,0,0,0,0,0,0,116,0,0,0,4,0,0,0,28,0,0,0,87,0,0,0,94,0,0,0,108,0,0,0,104,0,0,0,0,0,0,0,109,0,0,0,1,0,0,0,59,0,0,0,87,0,0,0,62,0,0,0,91,0,0,0,116,0,0,0,0,0,0,0,75,0,0,0,12,0,0,0,43,0,0,0,59,0,0,0,90,0,0,0,84,0,0,0,112,0,0,0,0,0,0,0,100,0,0,0,20,0,0,0,10,0,0,0,46,0,0,0,82,0,0,0,86,0,0,0,98,0,0,0,0,0,0,0,116,0,0,0,4,0,0,0,28,0,0,0,87,0,0,0,94,0,0,0,108,0,0,0,104,0,0,0,0,0,0,0,109,0,0,0,1,0,0,0,59,0,0,0,87,0,0,0,62,0,0,0,91,0,0,0,116,0,0,0,0,0,0,0,75,0,0,0,12,0,0,0,43,0,0,0,59,0,0,0,90,0,0,0,84,0,0,0,112,0,0,0,0,0,0,0,100,0,0,0,20,0,0,0,10,0,0,0,46,0,0,0,82,0,0,0,86,0,0,0,98,0,0,0,0,0,0,0,116,0,0,0,4,0,0,0,28,0,0,0,87,0,0,0,94,0,0,0,108,0,0,0,104,0,0,0,0,0,0,0,109,0,0,0,1,0,0,0,59,0,0,0,87,0,0,0,62,0,0,0,91,0,0,0,116,0,0,0,0,0,0,0,75,0,0,0,12,0,0,0,43,0,0,0,59,0,0,0,90,0,0,0,84,0,0,0,112,0,0,0,0,0,0,0,238,0,0,0,6,0,0,0,82,0,0,0,130,0,0,0,120,0,0,0,166,0,0,0,232,0,0,0,0,0,0,0,74,1,0,0,0,0,0,0,120,0,0,0,184,0,0,0,186,0,0,0,184,0,0,0,192,0,0,0,0,0,0,0,196,0,0,0,0,0,0,0,156,0,0,0,136,0,0,0,216,0,0,0,196,0,0,0,242,0,0,0,0,0,0,0,176,0,0,0,34,0,0,0,112,0,0,0,170,0,0,0,182,0,0,0,194,0,0,0,20,1,0,0,0,0,0,0,100,0,0,0,20,0,0,0,10,0,0,0,46,0,0,0,82,0,0,0,86,0,0,0,98,0,0,0,0,0,0,0,116,0,0,0,4,0,0,0,28,0,0,0,87,0,0,0,94,0,0,0,108,0,0,0,104,0,0,0,0,0,0,0,109,0,0,0,1,0,0,0,59,0,0,0,87,0,0,0,62,0,0,0,91,0,0,0,116,0,0,0,0,0,0,0,75,0,0,0,12,0,0,0,43,0,0,0,59,0,0,0,90,0,0,0,84,0,0,0,112,0,0,0,0,0,0,0,100,0,0,0,20,0,0,0,10,0,0,0,46,0,0,0,82,0,0,0,86,0,0,0,98,0,0,0,0,0,0,0,116,0,0,0,4,0,0,0,28,0,0,0,87,0,0,0,94,0,0,0,108,0,0,0,104,0,0,0,0,0,0,0,109,0,0,0,1,0,0,0,59,0,0,0,87,0,0,0,62,0,0,0,91,0,0,0,116,0,0,0,0,0,0,0,75,0,0,0,12,0,0,0,43,0,0,0,59,0,0,0,90,0,0,0,84,0,0,0,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,100,0,0,0,20,0,0,0,10,0,0,0,46,0,0,0,82,0,0,0,86,0,0,0,98,0,0,0,0,0,0,0,116,0,0,0,4,0,0,0,28,0,0,0,87,0,0,0,94,0,0,0,108,0,0,0,104,0,0,0,0,0,0,0,109,0,0,0,1,0,0,0,59,0,0,0,87,0,0,0,62,0,0,0,91,0,0,0,116,0,0,0,0,0,0,0,75,0,0,0,12,0,0,0,43,0,0,0,59,0,0,0,90,0,0,0,84,0,0,0,112,0,0,0,0,0,0,0,4,0,0,0,73,0,0,0,132,0,0,0,46,0,0,0,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,64,0,0,0,143,0,0,0,26,0,0,0,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,47,0,0,0,110,0,0,0,44,0,0,0,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,0,0,0,127,0,0,0,50,0,0,0,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,0,0,0,45,0,0,0,104,0,0,0,62,0,0,0,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,0,0,0,30,0,0,0,99,0,0,0,39,0,0,0,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,0,0,0,29,0,0,0,96,0,0,0,41,0,0,0,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,0,0,0,23,0,0,0,116,0,0,0,41,0,0,0,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,79,0,0,0,23,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,148,0,0,0,27,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,161,0,0,0,16,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,171,0,0,0,22,0,0,0,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,222,254,255,255,238,254,255,255,57,0,0,0,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,0,0,0,144,0,0,0,39,0,0,0,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,0,0,0,141,0,0,0,41,0,0,0,34,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,53,0,0,0,127,0,0,0,56,0,0,0,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,0,0,19,0,0,0,13,0,0,0,71,0,0,0,94,0,0,0,169,0,0,0,68,1,0,0,56,0,0,0,0,0,0,0,0,0,0,0,42,0,0,0,43,0,0,0,200,255,255,255,200,255,255,255,0,0,0,0,44,0,0,0,45,0,0,0,56,0,0,0,0,0,0,0,0,0,0,0,54,0,0,0,55,0,0,0,200,255,255,255,200,255,255,255,0,0,0,0,56,0,0,0,57,0,0,0,140,25,0,0,100,25,0,0,120,25,0,0,160,25,0,0,60,0,0,0,0,0,0,0,0,0,0,0,33,0,0,0,34,0,0,0,196,255,255,255,196,255,255,255,0,0,0,0,35,0,0,0,36,0,0,0,60,0,0,0,0,0,0,0,0,0,0,0,58,0,0,0,59,0,0,0,196,255,255,255,196,255,255,255,0,0,0,0,60,0,0,0,61,0,0,0,236,25,0,0,196,25,0,0,216,25,0,0,0,26,0,0,1,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,5,0,0,0,6,0,0,0,9,0,0,0,10,0,0,0,11,0,0,0,12,0,0,0,13,0,0,0,14,0,0,0,0,0,0,0,188,0,0,0,241,2,0,0,58,3,0,0,5,5,0,0,209,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,248,0,0,0,64,3,0,0,129,3,0,0,91,5,0,0,90,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,255,255,255,126,255,255,255,190,254,255,255,16,254,255,255,69,255,255,255,236,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,254,255,255,215,255,255,255,192,255,255,255,62,0,0,0,194,254,255,255,130,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,76,1,0,0,222,1,0,0,102,2,0,0,189,3,0,0,112,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,182,1,0,0,224,2,0,0,55,3,0,0,254,4,0,0,102,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,174,0,0,0,189,1,0,0,1,2,0,0,187,2,0,0,168,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,1,0,0,155,2,0,0,178,2,0,0,22,3,0,0,198,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,114,1,0,0,196,2,0,0,224,2,0,0,61,5,0,0,217,10,0,0,249,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,171,1,0,0,83,3,0,0,91,3,0,0,151,4,0,0,110,12,0,0,207,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,178,0,0,0,222,2,0,0,91,3,0,0,135,4,0,0,92,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,252,0,0,0,50,3,0,0,115,3,0,0,9,5,0,0,50,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,2,0,0,136,3,0,0,241,4,0,0,150,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33,3,0,0,161,3,0,0,195,6,0,0,178,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,181,0,0,0,179,2,0,0,61,3,0,0,198,4,0,0,226,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,245,0,0,0,82,3,0,0,77,3,0,0,106,5,0,0,13,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,0,0,0,63,0,0,0,64,0,0,0,20,0,0,0,20,0,0,0,20,0,0,0,100,0,0,0,20,0,0,0,20,0,0,0,100,0,0,0,20,0,0,0,150,0,0,0,88,2,0,0,48,2,0,0,125,0,0,0,150,0,0,0,150,0,0,0,109,1,0,0,44,1,0,0,227,1,0,0,58,2,0,0,91,2,0,0,42,2,0,0,140,7,0,0,232,8,0,0,108,9,0,0,168,8,0,0,75,7,0,0,37,9,0,0,197,9,0,0,170,8,0,0,226,1,0,0,95,2,0,0,144,2,0,0,91,2,0,0,227,1,0,0,58,2,0,0,91,2,0,0,42,2,0,0,227,1,0,0,58,2,0,0,91,2,0,0,42,2,0,0,249,3,0,0,218,3,0,0,249,3,0,0,222,3,0,0,208,7,0,0,208,7,0,0,208,7,0,0,208,7,0,0,0,0,0,0,0,0,0,0,62,0,0,0,65,0,0,0,66,0,0,0,50,0,0,0,56,31,0,0,5,0,0,0,0,0,0,0,0,0,0,0,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,0,0,0,6,0,0,0,219,147,18,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,172,31,0,0,5,0,0,0,0,0,0,0,0,0,0,0,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,0,0,0,6,0,0,0,227,147,18,0,0,4,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,172,31,0,0,36,32,0,0,9,0,0,0,0,0,0,0,0,0,0,0,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,0,0,0,0,0,0,6,0,0,0,235,151,18,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,192,3,0,0,192,4,0,0,192,5,0,0,192,6,0,0,192,7,0,0,192,8,0,0,192,9,0,0,192,10,0,0,192,11,0,0,192,12,0,0,192,13,0,0,192,14,0,0,192,15,0,0,192,16,0,0,192,17,0,0,192,18,0,0,192,19,0,0,192,20,0,0,192,21,0,0,192,22,0,0,192,23,0,0,192,24,0,0,192,25,0,0,192,26,0,0,192,27,0,0,192,28,0,0,192,29,0,0,192,30,0,0,192,31,0,0,192,0,0,0,179,1,0,0,195,2,0,0,195,3,0,0,195,4,0,0,195,5,0,0,195,6,0,0,195,7,0,0,195,8,0,0,195,9,0,0,195,10,0,0,195,11,0,0,195,12,0,0,195,13,0,0,211,14,0,0,195,15,0,0,195,0,0,12,187,1,0,12,195,2,0,12,195,3,0,12,195,4,0,12,211,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,100,0,0,0,232,3,0,0,16,39,0,0,160,134,1,0,64,66,15,0,128,150,152,0,0,225,245,5,136,60,0,0,248,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,5,0,0,0,6,0,0,0,7,0,0,0,8,0,0,0,9,0,0,0,10,0,0,0,11,0,0,0,12,0,0,0,13,0,0,0,14,0,0,0,15,0,0,0,16,0,0,0,17,0,0,0,18,0,0,0,19,0,0,0,20,0,0,0,21,0,0,0,22,0,0,0,23,0,0,0,24,0,0,0,25,0,0,0,26,0,0,0,27,0,0,0,28,0,0,0,29,0,0,0,30,0,0,0,31,0,0,0,32,0,0,0,33,0,0,0,34,0,0,0,35,0,0,0,36,0,0,0,37,0,0,0,38,0,0,0,39,0,0,0,40,0,0,0,41,0,0,0,42,0,0,0,43,0,0,0,44,0,0,0,45,0,0,0,46,0,0,0,47,0,0,0,48,0,0,0,49,0,0,0,50,0,0,0,51,0,0,0,52,0,0,0,53,0,0,0,54,0,0,0,55,0,0,0,56,0,0,0,57,0,0,0,58,0,0,0,59,0,0,0,60,0,0,0,61,0,0,0,62,0,0,0,63,0,0,0,64,0,0,0,97,0,0,0,98,0,0,0,99,0,0,0,100,0,0,0,101,0,0,0,102,0,0,0,103,0,0,0,104,0,0,0,105,0,0,0,106,0,0,0,107,0,0,0,108,0,0,0,109,0,0,0,110,0,0,0,111,0,0,0,112,0,0,0,113,0,0,0,114,0,0,0,115,0,0,0,116,0,0,0,117,0,0,0,118,0,0,0,119,0,0,0,120,0,0,0,121,0,0,0,122,0,0,0,91,0,0,0,92,0,0,0,93,0,0,0,94,0,0,0,95,0,0,0,96,0,0,0,97,0,0,0,98,0,0,0,99,0,0,0,100,0,0,0,101,0,0,0,102,0,0,0,103,0,0,0,104,0,0,0,105,0,0,0,106,0,0,0,107,0,0,0,108,0,0,0,109,0,0,0,110,0,0,0,111,0,0,0,112,0,0,0,113,0,0,0,114,0,0,0,115,0,0,0,116,0,0,0,117,0,0,0,118,0,0,0,119,0,0,0,120,0,0,0,121,0,0,0,122,0,0,0,123,0,0,0,124,0,0,0,125,0,0,0,126,0,0,0,127,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,252,41],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE);allocate([1,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,5,0,0,0,6,0,0,0,7,0,0,0,8,0,0,0,9,0,0,0,10,0,0,0,11,0,0,0,12,0,0,0,13,0,0,0,14,0,0,0,15,0,0,0,16,0,0,0,17,0,0,0,18,0,0,0,19,0,0,0,20,0,0,0,21,0,0,0,22,0,0,0,23,0,0,0,24,0,0,0,25,0,0,0,26,0,0,0,27,0,0,0,28,0,0,0,29,0,0,0,30,0,0,0,31,0,0,0,32,0,0,0,33,0,0,0,34,0,0,0,35,0,0,0,36,0,0,0,37,0,0,0,38,0,0,0,39,0,0,0,40,0,0,0,41,0,0,0,42,0,0,0,43,0,0,0,44,0,0,0,45,0,0,0,46,0,0,0,47,0,0,0,48,0,0,0,49,0,0,0,50,0,0,0,51,0,0,0,52,0,0,0,53,0,0,0,54,0,0,0,55,0,0,0,56,0,0,0,57,0,0,0,58,0,0,0,59,0,0,0,60,0,0,0,61,0,0,0,62,0,0,0,63,0,0,0,64,0,0,0,65,0,0,0,66,0,0,0,67,0,0,0,68,0,0,0,69,0,0,0,70,0,0,0,71,0,0,0,72,0,0,0,73,0,0,0,74,0,0,0,75,0,0,0,76,0,0,0,77,0,0,0,78,0,0,0,79,0,0,0,80,0,0,0,81,0,0,0,82,0,0,0,83,0,0,0,84,0,0,0,85,0,0,0,86,0,0,0,87,0,0,0,88,0,0,0,89,0,0,0,90,0,0,0,91,0,0,0,92,0,0,0,93,0,0,0,94,0,0,0,95,0,0,0,96,0,0,0,65,0,0,0,66,0,0,0,67,0,0,0,68,0,0,0,69,0,0,0,70,0,0,0,71,0,0,0,72,0,0,0,73,0,0,0,74,0,0,0,75,0,0,0,76,0,0,0,77,0,0,0,78,0,0,0,79,0,0,0,80,0,0,0,81,0,0,0,82,0,0,0,83,0,0,0,84,0,0,0,85,0,0,0,86,0,0,0,87,0,0,0,88,0,0,0,89,0,0,0,90,0,0,0,123,0,0,0,124,0,0,0,125,0,0,0,126,0,0,0,127,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,0,0,0,52,0,0,0,67,0,0,0,3,0,0,0,1,0,0,0,3,0,0,0,3,0,0,0,17,0,0,0,18,0,0,0,2,0,0,0,32,0,0,0,33,0,0,0,28,0,0,0,3,0,0,0,29,0,0,0,0,0,0,0,152,0,0,0,52,0,0,0,68,0,0,0,4,0,0,0,1,0,0,0,3,0,0,0,3,0,0,0,34,0,0,0,18,0,0,0,2,0,0,0,35,0,0,0,20,0,0,0,26,0,0,0,10,0,0,0,30,0,0,0,0,0,0,0,168,0,0,0,69,0,0,0,70,0,0,0,5,0,0,0,11,0,0,0,4,0,0,0,4,0,0,0,36,0,0,0,37,0,0,0,12,0,0,0,38,0,0,0,39,0,0,0,31,0,0,0,13,0,0,0,32,0,0,0,0,0,0,0,184,0,0,0,69,0,0,0,71,0,0,0,6,0,0,0,11,0,0,0,4,0,0,0,4,0,0,0,40,0,0,0,37,0,0,0,12,0,0,0,41,0,0,0,42,0,0,0,33,0,0,0,14,0,0,0,34,0,0,0,0,0,0,0,216,0,0,0,72,0,0,0,73,0,0,0,0,0,0,0,240,0,0,0,52,0,0,0,74,0,0,0,1,0,0,0,1,0,0,0,3,0,0,0,3,0,0,0,17,0,0,0,18,0,0,0,2,0,0,0,35,0,0,0,20,0,0,0,26,0,0,0,3,0,0,0,29,0,0,0,0,0,0,0,248,0,0,0,69,0,0,0,75,0,0,0,7,0,0,0,11,0,0,0,4,0,0,0,4,0,0,0,36,0,0,0,37,0,0,0,12,0,0,0,41,0,0,0,42,0,0,0,33,0,0,0,13,0,0,0,32,0,0,0,8,0,0,0,0,0,0,0,0,1,0,0,33,0,0,0,34,0,0,0,248,255,255,255,248,255,255,255,0,1,0,0,35,0,0,0,36,0,0,0,8,0,0,0,0,0,0,0,24,1,0,0,76,0,0,0,77,0,0,0,248,255,255,255,248,255,255,255,24,1,0,0,78,0,0,0,79,0,0,0,4,0,0,0,0,0,0,0,48,1,0,0,42,0,0,0,43,0,0,0,252,255,255,255,252,255,255,255,48,1,0,0,44,0,0,0,45,0,0,0,4,0,0,0,0,0,0,0,72,1,0,0,80,0,0,0,81,0,0,0,252,255,255,255,252,255,255,255,72,1,0,0,82,0,0,0,83,0,0,0,0,0,0,0,96,1,0,0,84,0,0,0,85,0,0,0,86,0,0,0,1,0,0,0,5,0,0,0,15,0,0,0,0,0,0,0,128,1,0,0,87,0,0,0,88,0,0,0,86,0,0,0,2,0,0,0,6,0,0,0,16,0,0,0,0,0,0,0,144,1,0,0,89,0,0,0,90,0,0,0,86,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,5,0,0,0,6,0,0,0,7,0,0,0,8,0,0,0,9,0,0,0,10,0,0,0,11,0,0,0,0,0,0,0,208,1,0,0,91,0,0,0,92,0,0,0,86,0,0,0,12,0,0,0,13,0,0,0,14,0,0,0,15,0,0,0,16,0,0,0,17,0,0,0,18,0,0,0,19,0,0,0,20,0,0,0,21,0,0,0,22,0,0,0,0,0,0,0,8,2,0,0,93,0,0,0,94,0,0,0,86,0,0,0,3,0,0,0,4,0,0,0,23,0,0,0,5,0,0,0,24,0,0,0,1,0,0,0,2,0,0,0,6,0,0,0,0,0,0,0,72,2,0,0,95,0,0,0,96,0,0,0,86,0,0,0,7,0,0,0,8,0,0,0,25,0,0,0,9,0,0,0,26,0,0,0,3,0,0,0,4,0,0,0,10,0,0,0,0,0,0,0,128,2,0,0,97,0,0,0,98,0,0,0,86,0,0,0,43,0,0,0,27,0,0,0,28,0,0,0,29,0,0,0,30,0,0,0,31,0,0,0,1,0,0,0,248,255,255,255,128,2,0,0,44,0,0,0,45,0,0,0,46,0,0,0,47,0,0,0,48,0,0,0,49,0,0,0,50,0,0,0,0,0,0,0,184,2,0,0,99,0,0,0,100,0,0,0,86,0,0,0,51,0,0,0,32,0,0,0,33,0,0,0,34,0,0,0,35,0,0,0,36,0,0,0,2,0,0,0,248,255,255,255,184,2,0,0,52,0,0,0,53,0,0,0,54,0,0,0,55,0,0,0,56,0,0,0,57,0,0,0,58,0,0,0,37,0,0,0,72,0,0,0,58,0,0,0,37,0,0,0,77,0,0,0,58,0,0,0,37,0,0,0,83,0,0,0,37,0,0,0,109,0,0,0,47,0,0,0,37,0,0,0,100,0,0,0,47,0,0,0,37,0,0,0,121,0,0,0,37,0,0,0,89,0,0,0,45,0,0,0,37,0,0,0,109,0,0,0,45,0,0,0,37,0,0,0,100,0,0,0,37,0,0,0,73,0,0,0,58,0,0,0,37,0,0,0,77,0,0,0,58,0,0,0,37,0,0,0,83,0,0,0,32,0,0,0,37,0,0,0,112,0,0,0,37,0,0,0,72,0,0,0,58,0,0,0,37,0,0,0,77,0,0,0,37,0,0,0,72,0,0,0,58,0,0,0,37,0,0,0,77,0,0,0,58,0,0,0,37,0,0,0,83,0,0,0,83,0,0,0,117,0,0,0,110,0,0,0,100,0,0,0,97,0,0,0,121,0,0,0,0,0,0,0,77,0,0,0,111,0,0,0,110,0,0,0,100,0,0,0,97,0,0,0,121,0,0,0,0,0,0,0,84,0,0,0,117,0,0,0,101,0,0,0,115,0,0,0,100,0,0,0,97,0,0,0,121,0,0,0,0,0,0,0,87,0,0,0,101,0,0,0,100,0,0,0,110,0,0,0,101,0,0,0,115,0,0,0,100,0,0,0,97,0,0,0,121,0,0,0,0,0,0,0,84,0,0,0,104,0,0,0,117,0,0,0,114,0,0,0,115,0,0,0,100,0,0,0,97,0,0,0,121,0,0,0,0,0,0,0,70,0,0,0,114,0,0,0,105,0,0,0,100,0,0,0,97,0,0,0,121,0,0,0,0,0,0,0,83,0,0,0,97,0,0,0,116,0,0,0,117,0,0,0,114,0,0,0,100,0,0,0,97,0,0,0,121,0,0,0,0,0,0,0,83,0,0,0,117,0,0,0,110,0,0,0,0,0,0,0,77,0,0,0,111,0,0,0,110,0,0,0,0,0,0,0,84,0,0,0,117,0,0,0,101,0,0,0,0,0,0,0,87,0,0,0,101,0,0,0,100,0,0,0,0,0,0,0,84,0,0,0,104,0,0,0,117,0,0,0,0,0,0,0,70,0,0,0,114,0,0,0,105,0,0,0,0,0,0,0,83,0,0,0,97,0,0,0,116,0,0,0,0,0,0,0,74,0,0,0,97,0,0,0,110,0,0,0,117,0,0,0,97,0,0,0,114,0,0,0,121,0,0,0,0,0,0,0,70,0,0,0,101,0,0,0,98,0,0,0,114,0,0,0,117,0,0,0,97,0,0,0,114,0,0,0,121,0,0,0,0,0,0,0,77,0,0,0,97,0,0,0,114,0,0,0,99,0,0,0,104,0,0,0,0,0,0,0,65,0,0,0,112,0,0,0,114,0,0,0,105,0,0,0,108,0,0,0,0,0,0,0,77,0,0,0,97,0,0,0,121,0,0,0,0,0,0,0,74,0,0,0,117,0,0,0,110,0,0,0,101,0,0,0,0,0,0,0,74,0,0,0,117,0,0,0,108,0,0,0,121,0,0,0,0,0,0,0,65,0,0,0,117,0,0,0,103,0,0,0,117,0,0,0,115,0,0,0,116,0,0,0,0,0,0,0,83,0,0,0,101,0,0,0,112,0,0,0,116,0,0,0,101,0,0,0,109,0,0,0,98,0,0,0,101,0,0,0,114,0,0,0,0,0,0,0,79,0,0,0,99,0,0,0,116,0,0,0,111,0,0,0,98,0,0,0,101,0,0,0,114,0,0,0,0,0,0,0,78,0,0,0,111,0,0,0,118,0,0,0,101,0,0,0,109,0,0,0,98,0,0,0,101,0,0,0,114,0,0,0,0,0,0,0,68,0,0,0,101,0,0,0,99,0,0,0,101,0,0,0,109,0,0,0,98,0,0,0,101,0,0,0,114,0,0,0,0,0,0,0,74,0,0,0,97,0,0,0,110,0,0,0,0,0,0,0,70,0,0,0,101,0,0,0,98,0,0,0,0,0,0,0,77,0,0,0,97,0,0,0,114,0,0,0,0,0,0,0,65,0,0,0,112,0,0,0,114,0,0,0,0,0,0,0,74,0,0,0,117,0,0,0,110,0,0,0,0,0,0,0,74,0,0,0,117,0,0,0,108,0,0,0,0,0,0,0,65,0,0,0,117,0,0,0,103,0,0,0,0,0,0,0,83,0,0,0,101,0,0,0,112,0,0,0,0,0,0,0,79,0,0,0,99,0,0,0,116,0,0,0,0,0,0,0,78,0,0,0,111,0,0,0,118,0,0,0,0,0,0,0,68,0,0,0,101,0,0,0,99,0,0,0,0,0,0,0,65,0,0,0,77,0,0,0,0,0,0,0,80,0,0,0,77,0,0,0,0,0,0,0,37,0,0,0,97,0,0,0,32,0,0,0,37,0,0,0,98,0,0,0,32,0,0,0,37,0,0,0,100,0,0,0,32,0,0,0,37,0,0,0,72,0,0,0,58,0,0,0,37,0,0,0,77,0,0,0,58,0,0,0,37,0,0,0,83,0,0,0,32,0,0,0,37,0,0,0,89,0,0,0,0,0,0,0,37,0,0,0,73,0,0,0,58,0,0,0,37,0,0,0,77,0,0,0,58,0,0,0,37,0,0,0,83,0,0,0,32,0,0,0,37,0,0,0,112,0,0,0,0,0,0,0,37,0,0,0,109,0,0,0,47,0,0,0,37,0,0,0,100,0,0,0,47,0,0,0,37,0,0,0,121,0,0,0,0,0,0,0,37,0,0,0,72,0,0,0,58,0,0,0,37,0,0,0,77,0,0,0,58,0,0,0,37,0,0,0,83,0,0,0,0,0,0,0,0,0,0,0,232,2,0,0,101,0,0,0,102,0,0,0,86,0,0,0,1,0,0,0,0,0,0,0,16,3,0,0,103,0,0,0,104,0,0,0,86,0,0,0,2,0,0,0,0,0,0,0,48,3,0,0,105,0,0,0,106,0,0,0,86,0,0,0,59,0,0,0,60,0,0,0,8,0,0,0,9,0,0,0,10,0,0,0,11,0,0,0,61,0,0,0,12,0,0,0,13,0,0,0,0,0,0,0,88,3,0,0,107,0,0,0,108,0,0,0,86,0,0,0,62,0,0,0,63,0,0,0,14,0,0,0,15,0,0,0,16,0,0,0,17,0,0,0,64,0,0,0,18,0,0,0,19,0,0,0,0,0,0,0,120,3,0,0,109,0,0,0,110,0,0,0,86,0,0,0,65,0,0,0,66,0,0,0,20,0,0,0,21,0,0,0,22,0,0,0,23,0,0,0,67,0,0,0,24,0,0,0,25,0,0,0,0,0,0,0,152,3,0,0,111,0,0,0,112,0,0,0,86,0,0,0,68,0,0,0,69,0,0,0,26,0,0,0,27,0,0,0,28,0,0,0,29,0,0,0,70,0,0,0,30,0,0,0,31,0,0,0,0,0,0,0,184,3,0,0,113,0,0,0,114,0,0,0,86,0,0,0,3,0,0,0,4,0,0,0,0,0,0,0,224,3,0,0,115,0,0,0,116,0,0,0,86,0,0,0,5,0,0,0,6,0,0,0,0,0,0,0,8,4,0,0,117,0,0,0,118,0,0,0,86,0,0,0,1,0,0,0,37,0,0,0,0,0,0,0,48,4,0,0,119,0,0,0,120,0,0,0,86,0,0,0,2,0,0,0,38,0,0,0,0,0,0,0,88,4,0,0,121,0,0,0,122,0,0,0,86,0,0,0,17,0,0,0,5,0,0,0,32,0,0,0,0,0,0,0,128,4,0,0,123,0,0,0,124,0,0,0,86,0,0,0,18,0,0,0,6,0,0,0,33,0,0,0,0,0,0,0,160,4,0,0,125,0,0,0,126,0,0,0,86,0,0,0,3,0,0,0,4,0,0,0,11,0,0,0,71,0,0,0,72,0,0,0,12,0,0,0,73,0,0,0,0,0,0,0,216,4,0,0,125,0,0,0,127,0,0,0,86,0,0,0,3,0,0,0,4,0,0,0,11,0,0,0,71,0,0,0,72,0,0,0,12,0,0,0,73,0,0,0,0,0,0,0,8,5,0,0,128,0,0,0,129,0,0,0,86,0,0,0,5,0,0,0,6,0,0,0,13,0,0,0,74,0,0,0,75,0,0,0,14,0,0,0,76,0,0,0,0,0,0,0,72,5,0,0,130,0,0,0,131,0,0,0,86,0,0,0,0,0,0,0,88,5,0,0,132,0,0,0,133,0,0,0,86,0,0,0,35,0,0,0,19,0,0,0,36,0,0,0,20,0,0,0,37,0,0,0,1,0,0,0,21,0,0,0,15,0,0,0,0,0,0,0,160,5,0,0,134,0,0,0,135,0,0,0,86,0,0,0,77,0,0,0,78,0,0,0,34,0,0,0,35,0,0,0,36,0,0,0,0,0,0,0,176,5,0,0,136,0,0,0,137,0,0,0,86,0,0,0,79,0,0,0,80,0,0,0,37,0,0,0,38,0,0,0,39,0,0,0,116,0,0,0,114,0,0,0,117,0,0,0,101,0,0,0,0,0,0,0,102,0,0,0,97,0,0,0,108,0,0,0,115,0,0,0,101,0,0,0,0,0,0,0,0,0,0,0,112,1,0,0,125,0,0,0,138,0,0,0,86,0,0,0,0,0,0,0,128,5,0,0,125,0,0,0,139,0,0,0,86,0,0,0,22,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,38,0,0,0,23,0,0,0,39,0,0,0,24,0,0,0,40,0,0,0,5,0,0,0,25,0,0,0,16,0,0,0,0,0,0,0,232,4,0,0,125,0,0,0,140,0,0,0,86,0,0,0,7,0,0,0,8,0,0,0,17,0,0,0,81,0,0,0,82,0,0,0,18,0,0,0,83,0,0,0,0,0,0,0,40,5,0,0,125,0,0,0,141,0,0,0,86,0,0,0,9,0,0,0,10,0,0,0,19,0,0,0,84,0,0,0,85,0,0,0,20,0,0,0,86,0,0,0,0,0,0,0,176,4,0,0,125,0,0,0,142,0,0,0,86,0,0,0,3,0,0,0,4,0,0,0,11,0,0,0,71,0,0,0,72,0,0,0,12,0,0,0,73,0,0,0,1,0,0,0,0,0,0,0,208,5,0,0,143,0,0,0,144,0,0,0,145,0,0,0,146,0,0,0,26,0,0,0,7,0,0,0,1,0,0,0,7,0,0,0,0,0,0,0,224,5,0,0,143,0,0,0,147,0,0,0,145,0,0,0,146,0,0,0,26,0,0,0,8,0,0,0,2,0,0,0,8,0,0,0,0,0,0,0,8,6,0,0,148,0,0,0,149,0,0,0,87,0,0,0,0,0,0,0,24,6,0,0,143,0,0,0,150,0,0,0,145,0,0,0,146,0,0,0,26,0,0,0,9,0,0,0,3,0,0,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,3,32,2,32,2,32,2,32,2,32,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,1,96,4,192,4,192,4,192,4,192,4,192,4,192,4,192,4,192,4,192,4,192,4,192,4,192,4,192,4,192,4,192,8,216,8,216,8,216,8,216,8,216,8,216,8,216,8,216,8,216,8,216,4,192,4,192,4,192,4,192,4,192,4,192,4,192,8,213,8,213,8,213,8,213,8,213,8,213,8,197,8,197,8,197,8,197,8,197,8,197,8,197,8,197,8,197,8,197,8,197,8,197,8,197,8,197,8,197,8,197,8,197,8,197,8,197,8,197,4,192,4,192,4,192,4,192,4,192,4,192,8,214,8,214,8,214,8,214,8,214,8,214,8,198,8,198,8,198,8,198,8,198,8,198,8,198,8,198,8,198,8,198,8,198,8,198,8,198,8,198,8,198,8,198,8,198,8,198,8,198,8,198,4,192,4,192,4,192,4,192,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,75,80,118,75,0,75,78,78,118,75,0,75,66,78,118,75,0,75,82,118,75,80,0,75,82,118,75,66,0,75,82,118,75,78,0,75,81,118,75,80,0,75,81,118,75,82,0,75,78,80,118,75,0,75,78,80,118,75,66,0,75,82,80,118,75,82,0,75,82,80,118,75,66,0,75,66,80,118,75,66,0,75,66,80,118,75,78,0,75,66,80,80,118,75,66,0,75,82,80,80,118,75,82,80,0,74,97,110,32,70,101,98,32,77,97,114,32,65,112,114,32,77,97,121,32,74,117,110,32,74,117,108,32,65,117,103,32,83,101,112,32,79,99,116,32,78,111,118,32,68,101,99,0,68,101,99,32,50,51,32,50,48,49,54,0,83,116,111,99,107,102,105,115,104,32,0,10,105,100,32,97,117,116,104,111,114,32,0,32,98,121,32,0,84,46,32,82,111,109,115,116,97,100,44,32,77,46,32,67,111,115,116,97,108,98,97,44,32,74,46,32,75,105,105,115,107,105,44,32,71,46,32,76,105,110,115,99,111,116,116,0,62,62,32,0,60,60,32,0,119,0,32,80,78,66,82,81,75,32,32,112,110,98,114,113,107,0,126,0,32,119,32,0,32,98,32,0,32,45,32,0,43,0,47,56,47,56,47,56,47,56,47,56,47,56,47,0,32,119,32,45,32,45,32,48,32,49,48,0,105,110,102,111,32,100,101,112,116,104,32,48,32,115,99,111,114,101,32,0,105,110,102,111,32,100,101,112,116,104,32,0,32,99,117,114,114,109,111,118,101,32,0,32,99,117,114,114,109,111,118,101,110,117,109,98,101,114,32,0,105,110,102,111,0,32,100,101,112,116,104,32,0,32,115,101,108,100,101,112,116,104,32,0,32,109,117,108,116,105,112,118,32,0,32,115,99,111,114,101,32,0,32,117,112,112,101,114,98,111,117,110,100,0,32,108,111,119,101,114,98,111,117,110,100,0,32,110,111,100,101,115,32,0,32,110,112,115,32,0,32,104,97,115,104,102,117,108,108,32,0,32,116,98,104,105,116,115,32,0,32,116,105,109,101,32,0,32,112,118,0,98,101,115,116,109,111,118,101,32,0,32,112,111,110,100,101,114,32,0,70,97,105,108,101,100,32,116,111,32,97,108,108,111,99,97,116,101,32,0,77,66,32,102,111,114,32,116,114,97,110,115,112,111,115,105,116,105,111,110,32,116,97,98,108,101,46,0,114,110,98,113,107,98,110,114,47,112,112,112,112,112,112,112,112,47,56,47,56,47,56,47,56,47,80,80,80,80,80,80,80,80,47,82,78,66,81,75,66,78,82,32,119,32,75,81,107,113,32,45,32,48,32,49,0,114,110,98,113,107,98,110,114,47,112,112,112,112,112,112,112,112,47,56,47,56,47,56,47,56,47,80,80,80,80,80,80,80,80,47,82,78,66,81,75,66,78,82,91,93,32,119,32,75,81,107,113,32,45,32,48,32,49,0,114,110,98,113,107,98,110,114,47,112,112,112,112,112,112,112,112,47,56,47,49,80,80,50,80,80,49,47,80,80,80,80,80,80,80,80,47,80,80,80,80,80,80,80,80,47,80,80,80,80,80,80,80,80,47,80,80,80,80,80,80,80,80,32,119,32,107,113,32,45,32,48,32,49,0,56,47,56,47,56,47,56,47,56,47,56,47,107,114,98,110,78,66,82,75,47,113,114,98,110,78,66,82,81,32,119,32,45,32,45,32,48,32,49,0,114,110,98,113,107,98,110,114,47,112,112,112,112,112,112,112,112,47,56,47,56,47,56,47,56,47,80,80,80,80,80,80,80,80,47,82,78,66,81,75,66,78,82,32,119,32,75,81,107,113,32,45,32,51,43,51,32,48,32,49,0,113,117,105,116,0,115,116,111,112,0,112,111,110,100,101,114,104,105,116,0,117,99,105,0,105,100,32,110,97,109,101,32,0,10,0,10,117,99,105,111,107,0,117,99,105,110,101,119,103,97,109,101,0,105,115,114,101,97,100,121,0,114,101,97,100,121,111,107,0,103,111,0,115,101,97,114,99,104,109,111,118,101,115,0,40,110,111,110,101,41,0,48,48,48,48,0,32,80,78,66,82,81,75,32,32,80,78,66,82,81,75,32,0,32,112,110,98,114,113,107,0,119,116,105,109,101,0,98,116,105,109,101,0,119,105,110,99,0,98,105,110,99,0,109,111,118,101,115,116,111,103,111,0,100,101,112,116,104,0,110,111,100,101,115,0,109,111,118,101,116,105,109,101,0,109,97,116,101,0,105,110,102,105,110,105,116,101,0,112,111,110,100,101,114,0,112,111,115,105,116,105,111,110,0,115,116,97,114,116,112,111,115,0,102,101,110,0,109,111,118,101,115,0,32,0,115,101,116,111,112,116,105,111,110,0,118,97,108,117,101,0,105,110,102,111,32,115,116,114,105,110,103,32,118,97,114,105,97,110,116,32,0,32,115,116,97,114,116,112,111,115,32,0,78,111,32,115,117,99,104,32,111,112,116,105,111,110,58,32,0,85,110,107,110,111,119,110,32,99,111,109,109,97,110,100,58,32,0,99,112,32,0,109,97,116,101,32,0,99,104,101,115,115,0,103,105,118,101,97,119,97,121,0,97,116,111,109,105,99,0,99,114,97,122,121,104,111,117,115,101,0,104,111,114,100,101,0,107,105,110,103,111,102,116,104,101,104,105,108,108,0,114,97,99,105,110,103,107,105,110,103,115,0,116,104,114,101,101,99,104,101,99,107,0,115,112,105,110,0,68,101,98,117,103,32,76,111,103,32,70,105,108,101,0,115,116,114,105,110,103,0,67,111,110,116,101,109,112,116,0,84,104,114,101,97,100,115,0,72,97,115,104,0,67,108,101,97,114,32,72,97,115,104,0,98,117,116,116,111,110,0,80,111,110,100,101,114,0,99,104,101,99,107,0,77,117,108,116,105,80,86,0,83,107,105,108,108,32,76,101,118,101,108,0,77,111,118,101,32,79,118,101,114,104,101,97,100,0,77,105,110,105,109,117,109,32,84,104,105,110,107,105,110,103,32,84,105,109,101,0,83,108,111,119,32,77,111,118,101,114,0,110,111,100,101,115,116,105,109,101,0,85,67,73,95,67,104,101,115,115,57,54,48,0,85,67,73,95,86,97,114,105,97,110,116,0,99,111,109,98,111,0,10,111,112,116,105,111,110,32,110,97,109,101,32,0,32,116,121,112,101,32,0,32,100,101,102,97,117,108,116,32,0,32,118,97,114,32,0,32,109,105,110,32,0,32,109,97,120,32,0,17,0,10,0,17,17,17,0,0,0,0,5,0,0,0,0,0,0,9,0,0,0,0,11,0,0,0,0,0,0,0,0,17,0,15,10,17,17,17,3,10,7,0,1,19,9,11,11,0,0,9,6,11,0,0,11,0,6,17,0,0,0,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,0,17,0,10,10,17,17,17,0,10,0,0,2,0,9,11,0,0,0,9,0,11,0,0,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,12,0,0,0,0,9,12,0,0,0,0,0,12,0,0,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,0,0,0,0,0,0,0,0,0,0,0,13,0,0,0,4,13,0,0,0,0,9,14,0,0,0,0,0,14,0,0,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,15,0,0,0,0,15,0,0,0,0,9,16,0,0,0,0,0,16,0,0,16,0,0,18,0,0,0,18,18,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,0,0,0,18,18,18,0,0,0,0,0,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,0,10,0,0,0,0,9,11,0,0,0,0,0,11,0,0,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,12,0,0,0,0,9,12,0,0,0,0,0,12,0,0,12,0,0,48,49,50,51,52,53,54,55,56,57,65,66,67,68,69,70,45,43,32,32,32,48,88,48,120,0,84,33,34,25,13,1,2,3,17,75,28,12,16,4,11,29,18,30,39,104,110,111,112,113,98,32,5,6,15,19,20,21,26,8,22,7,40,36,23,24,9,10,14,27,31,37,35,131,130,125,38,42,43,60,61,62,63,67,71,74,77,88,89,90,91,92,93,94,95,96,97,99,100,101,102,103,105,106,107,108,114,115,116,121,122,123,124,0,73,108,108,101,103,97,108,32,98,121,116,101,32,115,101,113,117,101,110,99,101,0,68,111,109,97,105,110,32,101,114,114,111,114,0,82,101,115,117,108,116,32,110,111,116,32,114,101,112,114,101,115,101,110,116,97,98,108,101,0,78,111,116,32,97,32,116,116,121,0,80,101,114,109,105,115,115,105,111,110,32,100,101,110,105,101,100,0,79,112,101,114,97,116,105,111,110,32,110,111,116,32,112,101,114,109,105,116,116,101,100,0,78,111,32,115,117,99,104,32,102,105,108,101,32,111,114,32,100,105,114,101,99,116,111,114,121,0,78,111,32,115,117,99,104,32,112,114,111,99,101,115,115,0,70,105,108,101,32,101,120,105,115,116,115,0,86,97,108,117,101,32,116,111,111,32,108,97,114,103,101,32,102,111,114,32,100,97,116,97,32,116,121,112,101,0,78,111,32,115,112,97,99,101,32,108,101,102,116,32,111,110,32,100,101,118,105,99,101,0,79,117,116,32,111,102,32,109,101,109,111,114,121,0,82,101,115,111,117,114,99,101,32,98,117,115,121,0,73,110,116,101,114,114,117,112,116,101,100,32,115,121,115,116,101,109,32,99,97,108,108,0,82,101,115,111,117,114,99,101,32,116,101,109,112,111,114,97,114,105,108,121,32,117,110,97,118,97,105,108,97,98,108,101,0,73,110,118,97,108,105,100,32,115,101,101,107,0,67,114,111,115,115,45,100,101,118,105,99,101,32,108,105,110,107,0,82,101,97,100,45,111,110,108,121,32,102,105,108,101,32,115,121,115,116,101,109,0,68,105,114,101,99,116,111,114,121,32,110,111,116,32,101,109,112,116,121,0,67,111,110,110,101,99,116,105,111,110,32,114,101,115,101,116,32,98,121,32,112,101,101,114,0,79,112,101,114,97,116,105,111,110,32,116,105,109,101,100,32,111,117,116,0,67,111,110,110,101,99,116,105,111,110,32,114,101,102,117,115,101,100,0,72,111,115,116,32,105,115,32,100,111,119,110,0,72,111,115,116,32,105,115,32,117,110,114,101,97,99,104,97,98,108,101,0,65,100,100,114,101,115,115,32,105,110,32,117,115,101,0,66,114,111,107,101,110,32,112,105,112,101,0,73,47,79,32,101,114,114,111,114,0,78,111,32,115,117,99,104,32,100,101,118,105,99,101,32,111,114,32,97,100,100,114,101,115,115,0,66,108,111,99,107,32,100,101,118,105,99,101,32,114,101,113,117,105,114,101,100,0,78,111,32,115,117,99,104,32,100,101,118,105,99,101,0,78,111,116,32,97,32,100,105,114,101,99,116,111,114,121,0,73,115,32,97,32,100,105,114,101,99,116,111,114,121,0,84,101,120,116,32,102,105,108,101,32,98,117,115,121,0,69,120,101,99,32,102,111,114,109,97,116,32,101,114,114,111,114,0,73,110,118,97,108,105,100,32,97,114,103,117,109,101,110,116,0,65,114,103,117,109,101,110,116,32,108,105,115,116,32,116,111,111,32,108,111,110,103,0,83,121,109,98,111,108,105,99,32,108,105,110,107,32,108,111,111,112,0,70,105,108,101,110,97,109,101,32,116,111,111,32,108,111,110,103,0,84,111,111,32,109,97,110,121,32,111,112,101,110,32,102,105,108,101,115,32,105,110,32,115,121,115,116,101,109,0,78,111,32,102,105,108,101,32,100,101,115,99,114,105,112,116,111,114,115,32,97,118,97,105,108,97,98,108,101,0,66,97,100,32,102,105,108,101,32,100,101,115,99,114,105,112,116,111,114,0,78,111,32,99,104,105,108,100,32,112,114,111,99,101,115,115,0,66,97,100,32,97,100,100,114,101,115,115,0,70,105,108,101,32,116,111,111,32,108,97,114,103,101,0,84,111,111,32,109,97,110,121,32,108,105,110,107,115,0,78,111,32,108,111,99,107,115,32,97,118,97,105,108,97,98,108,101,0,82,101,115,111,117,114,99,101,32,100,101,97,100,108,111,99,107,32,119,111,117,108,100,32,111,99,99,117,114,0,83,116,97,116,101,32,110,111,116,32,114,101,99,111,118,101,114,97,98,108,101,0,80,114,101,118,105,111,117,115,32,111,119,110,101,114,32,100,105,101,100,0,79,112,101,114,97,116,105,111,110,32,99,97,110,99,101,108,101,100,0,70,117,110,99,116,105,111,110,32,110,111,116,32,105,109,112,108,101,109,101,110,116,101,100,0,78,111,32,109,101,115,115,97,103,101,32,111,102,32,100,101,115,105,114,101,100,32,116,121,112,101,0,73,100,101,110,116,105,102,105,101,114,32,114,101,109,111,118,101,100,0,68,101,118,105,99,101,32,110,111,116,32,97,32,115,116,114,101,97,109,0,78,111,32,100,97,116,97,32,97,118,97,105,108,97,98,108,101,0,68,101,118,105,99,101,32,116,105,109,101,111,117,116,0,79,117,116,32,111,102,32,115,116,114,101,97,109,115,32,114,101,115,111,117,114,99,101,115,0,76,105,110,107,32,104,97,115,32,98,101,101,110,32,115,101,118,101,114,101,100,0,80,114,111,116,111,99,111,108,32,101,114,114,111,114,0,66,97,100,32,109,101,115,115,97,103,101,0,70,105,108,101,32,100,101,115,99,114,105,112,116,111,114,32,105,110,32,98,97,100,32,115,116,97,116,101,0,78,111,116,32,97,32,115,111,99,107,101,116,0,68,101,115,116,105,110,97,116,105,111,110,32,97,100,100,114,101,115,115,32,114,101,113,117,105,114,101,100,0,77,101,115,115,97,103,101,32,116,111,111,32,108,97,114,103,101,0,80,114,111,116,111,99,111,108,32,119,114,111,110,103,32,116,121,112,101,32,102,111,114,32,115,111,99,107,101,116,0,80,114,111,116,111,99,111,108,32,110,111,116,32,97,118,97,105,108,97,98,108,101,0,80,114,111,116,111,99,111,108,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,83,111,99,107,101,116,32,116,121,112,101,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,78,111,116,32,115,117,112,112,111,114,116,101,100,0,80,114,111,116,111,99,111,108,32,102,97,109,105,108,121,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,65,100,100,114,101,115,115,32,102,97,109,105,108,121,32,110,111,116,32,115,117,112,112,111,114,116,101,100,32,98,121,32,112,114,111,116,111,99,111,108,0,65,100,100,114,101,115,115,32,110,111,116,32,97,118,97,105,108,97,98,108,101,0,78,101,116,119,111,114,107,32,105,115,32,100,111,119,110,0,78,101,116,119,111,114,107,32,117,110,114,101,97,99,104,97,98,108,101,0,67,111,110,110,101,99,116,105,111,110,32,114,101,115,101,116,32,98,121,32,110,101,116,119,111,114,107,0,67,111,110,110,101,99,116,105,111,110,32,97,98,111,114,116,101,100,0,78,111,32,98,117,102,102,101,114,32,115,112,97,99,101,32,97,118,97,105,108,97,98,108,101,0,83,111,99,107,101,116,32,105,115,32,99,111,110,110,101,99,116,101,100,0,83,111,99,107,101,116,32,110,111,116,32,99,111,110,110,101,99,116,101,100,0,67,97,110,110,111,116,32,115,101,110,100,32,97,102,116,101,114,32,115,111,99,107,101,116,32,115,104,117,116,100,111,119,110,0,79,112,101,114,97,116,105,111,110,32,97,108,114,101,97,100,121,32,105,110,32,112,114,111,103,114,101,115,115,0,79,112,101,114,97,116,105,111,110,32,105,110,32,112,114,111,103,114,101,115,115,0,83,116,97,108,101,32,102,105,108,101,32,104,97,110,100,108,101,0,82,101,109,111,116,101,32,73,47,79,32,101,114,114,111,114,0,81,117,111,116,97,32,101,120,99,101,101,100,101,100,0,78,111,32,109,101,100,105,117,109,32,102,111,117,110,100,0,87,114,111,110,103,32,109,101,100,105,117,109,32,116,121,112,101,0,78,111,32,101,114,114,111,114,32,105,110,102,111,114,109,97,116,105,111,110,0,0,40,110,117,108,108,41,0,45,48,88,43,48,88,32,48,88,45,48,120,43,48,120,32,48,120,0,105,110,102,0,73,78,70,0,78,65,78,0,46,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,1,2,3,4,5,6,7,8,9,255,255,255,255,255,255,255,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,255,255,255,255,255,255,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,1,2,4,7,3,6,5,0,105,110,102,105,110,105,116,121,0,110,97,110,0,114,119,97,0,80,79,83,73,88,0,99,111,110,100,105,116,105,111,110,95,118,97,114,105,97,98,108,101,58,58,119,97,105,116,58,32,109,117,116,101,120,32,110,111,116,32,108,111,99,107,101,100,0,99,111,110,100,105,116,105,111,110,95,118,97,114,105,97,98,108,101,32,119,97,105,116,32,102,97,105,108,101,100,0,78,83,116,51,95,95,49,49,48,95,95,115,116,100,105,110,98,117,102,73,99,69,69,0,117,110,115,117,112,112,111,114,116,101,100,32,108,111,99,97,108,101,32,102,111,114,32,115,116,97,110,100,97,114,100,32,105,110,112,117,116,0,78,83,116,51,95,95,49,49,49,95,95,115,116,100,111,117,116,98,117,102,73,99,69,69,0,78,83,116,51,95,95,49,49,48,95,95,115,116,100,105,110,98,117,102,73,119,69,69,0,78,83,116,51,95,95,49,49,49,95,95,115,116,100,111,117,116,98,117,102,73,119,69,69,0,109,117,116,101,120,32,108,111,99,107,32,102,97,105,108,101,100,0,101,99,32,61,61,32,48,0,47,104,111,109,101,47,110,105,107,108,97,115,47,80,97,99,107,97,103,101,115,47,101,109,115,100,107,95,112,111,114,116,97,98,108,101,47,101,109,115,99,114,105,112,116,101,110,47,109,97,115,116,101,114,47,115,121,115,116,101,109,47,108,105,98,47,108,105,98,99,120,120,47,109,117,116,101,120,46,99,112,112,0,117,110,108,111,99,107,0,33,34,98,97,115,105,99,95,115,116,114,105,110,103,32,108,101,110,103,116,104,95,101,114,114,111,114,34,0,47,104,111,109,101,47,110,105,107,108,97,115,47,80,97,99,107,97,103,101,115,47,101,109,115,100,107,95,112,111,114,116,97,98,108,101,47,101,109,115,99,114,105,112,116,101,110,47,109,97,115,116,101,114,47,115,121,115,116,101,109,47,105,110,99,108,117,100,101,47,108,105,98,99,120,120,47,115,116,114,105,110,103,0,33,34,98,97,115,105,99,95,115,116,114,105,110,103,32,111,117,116,95,111,102,95,114,97,110,103,101,34,0,115,116,111,105,0,58,32,111,117,116,32,111,102,32,114,97,110,103,101,0,58,32,110,111,32,99,111,110,118,101,114,115,105,111,110,0,37,100,0,99,108,111,99,107,95,103,101,116,116,105,109,101,40,67,76,79,67,75,95,77,79,78,79,84,79,78,73,67,41,32,102,97,105,108,101,100,0,78,83,116,51,95,95,49,57,98,97,115,105,99,95,105,111,115,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,69,69,0,78,83,116,51,95,95,49,56,105,111,115,95,98,97,115,101,69,0,78,83,116,51,95,95,49,57,98,97,115,105,99,95,105,111,115,73,119,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,119,69,69,69,69,0,78,83,116,51,95,95,49,49,53,98,97,115,105,99,95,115,116,114,101,97,109,98,117,102,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,69,69,0,78,83,116,51,95,95,49,49,53,98,97,115,105,99,95,115,116,114,101,97,109,98,117,102,73,119,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,119,69,69,69,69,0,78,83,116,51,95,95,49,49,51,98,97,115,105,99,95,105,115,116,114,101,97,109,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,69,69,0,78,83,116,51,95,95,49,49,51,98,97],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+10744);allocate([115,105,99,95,105,115,116,114,101,97,109,73,119,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,119,69,69,69,69,0,78,83,116,51,95,95,49,49,51,98,97,115,105,99,95,111,115,116,114,101,97,109,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,69,69,0,78,83,116,51,95,95,49,49,51,98,97,115,105,99,95,111,115,116,114,101,97,109,73,119,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,119,69,69,69,69,0,78,83,116,51,95,95,49,55,99,111,108,108,97,116,101,73,99,69,69,0,78,83,116,51,95,95,49,54,108,111,99,97,108,101,53,102,97,99,101,116,69,0,78,83,116,51,95,95,49,55,99,111,108,108,97,116,101,73,119,69,69,0,78,83,116,51,95,95,49,55,110,117,109,95,103,101,116,73,99,78,83,95,49,57,105,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,69,69,69,69,0,78,83,116,51,95,95,49,57,95,95,110,117,109,95,103,101,116,73,99,69,69,0,78,83,116,51,95,95,49,49,52,95,95,110,117,109,95,103,101,116,95,98,97,115,101,69,0,48,49,50,51,52,53,54,55,56,57,97,98,99,100,101,102,65,66,67,68,69,70,120,88,43,45,112,80,105,73,110,78,0,67,0,37,112,0,78,83,116,51,95,95,49,55,110,117,109,95,103,101,116,73,119,78,83,95,49,57,105,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,119,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,119,69,69,69,69,69,69,0,78,83,116,51,95,95,49,57,95,95,110,117,109,95,103,101,116,73,119,69,69,0,78,83,116,51,95,95,49,55,110,117,109,95,112,117,116,73,99,78,83,95,49,57,111,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,69,69,69,69,0,78,83,116,51,95,95,49,57,95,95,110,117,109,95,112,117,116,73,99,69,69,0,78,83,116,51,95,95,49,49,52,95,95,110,117,109,95,112,117,116,95,98,97,115,101,69,0,37,0,0,0,0,0,108,0,108,108,0,76,0,37,112,0,0,0,0,78,83,116,51,95,95,49,55,110,117,109,95,112,117,116,73,119,78,83,95,49,57,111,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,119,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,119,69,69,69,69,69,69,0,78,83,116,51,95,95,49,57,95,95,110,117,109,95,112,117,116,73,119,69,69,0,78,83,116,51,95,95,49,56,116,105,109,101,95,103,101,116,73,99,78,83,95,49,57,105,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,69,69,69,69,0,78,83,116,51,95,95,49,57,116,105,109,101,95,98,97,115,101,69,0,78,83,116,51,95,95,49,50,48,95,95,116,105,109,101,95,103,101,116,95,99,95,115,116,111,114,97,103,101,73,99,69,69,0,37,72,58,37,77,58,37,83,37,109,47,37,100,47,37,121,37,89,45,37,109,45,37,100,37,73,58,37,77,58,37,83,32,37,112,37,72,58,37,77,37,72,58,37,77,58,37,83,83,117,110,100,97,121,0,77,111,110,100,97,121,0,84,117,101,115,100,97,121,0,87,101,100,110,101,115,100,97,121,0,84,104,117,114,115,100,97,121,0,70,114,105,100,97,121,0,83,97,116,117,114,100,97,121,0,83,117,110,0,77,111,110,0,84,117,101,0,87,101,100,0,84,104,117,0,70,114,105,0,83,97,116,0,74,97,110,117,97,114,121,0,70,101,98,114,117,97,114,121,0,77,97,114,99,104,0,65,112,114,105,108,0,77,97,121,0,74,117,110,101,0,74,117,108,121,0,65,117,103,117,115,116,0,83,101,112,116,101,109,98,101,114,0,79,99,116,111,98,101,114,0,78,111,118,101,109,98,101,114,0,68,101,99,101,109,98,101,114,0,74,97,110,0,70,101,98,0,77,97,114,0,65,112,114,0,74,117,110,0,74,117,108,0,65,117,103,0,83,101,112,0,79,99,116,0,78,111,118,0,68,101,99,0,65,77,0,80,77,0,37,97,32,37,98,32,37,100,32,37,72,58,37,77,58,37,83,32,37,89,0,37,73,58,37,77,58,37,83,32,37,112,0,37,109,47,37,100,47,37,121,0,37,72,58,37,77,58,37,83,0,78,83,116,51,95,95,49,56,116,105,109,101,95,103,101,116,73,119,78,83,95,49,57,105,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,119,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,119,69,69,69,69,69,69,0,78,83,116,51,95,95,49,50,48,95,95,116,105,109,101,95,103,101,116,95,99,95,115,116,111,114,97,103,101,73,119,69,69,0,78,83,116,51,95,95,49,56,116,105,109,101,95,112,117,116,73,99,78,83,95,49,57,111,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,69,69,69,69,0,78,83,116,51,95,95,49,49,48,95,95,116,105,109,101,95,112,117,116,69,0,78,83,116,51,95,95,49,56,116,105,109,101,95,112,117,116,73,119,78,83,95,49,57,111,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,119,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,119,69,69,69,69,69,69,0,78,83,116,51,95,95,49,49,48,109,111,110,101,121,112,117,110,99,116,73,99,76,98,48,69,69,69,0,78,83,116,51,95,95,49,49,48,109,111,110,101,121,95,98,97,115,101,69,0,78,83,116,51,95,95,49,49,48,109,111,110,101,121,112,117,110,99,116,73,99,76,98,49,69,69,69,0,78,83,116,51,95,95,49,49,48,109,111,110,101,121,112,117,110,99,116,73,119,76,98,48,69,69,69,0,78,83,116,51,95,95,49,49,48,109,111,110,101,121,112,117,110,99,116,73,119,76,98,49,69,69,69,0,78,83,116,51,95,95,49,57,109,111,110,101,121,95,103,101,116,73,99,78,83,95,49,57,105,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,69,69,69,69,0,78,83,116,51,95,95,49,49,49,95,95,109,111,110,101,121,95,103,101,116,73,99,69,69,0,48,49,50,51,52,53,54,55,56,57,0,37,76,102,0,78,83,116,51,95,95,49,57,109,111,110,101,121,95,103,101,116,73,119,78,83,95,49,57,105,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,119,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,119,69,69,69,69,69,69,0,78,83,116,51,95,95,49,49,49,95,95,109,111,110,101,121,95,103,101,116,73,119,69,69,0,48,49,50,51,52,53,54,55,56,57,0,78,83,116,51,95,95,49,57,109,111,110,101,121,95,112,117,116,73,99,78,83,95,49,57,111,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,69,69,69,69,0,78,83,116,51,95,95,49,49,49,95,95,109,111,110,101,121,95,112,117,116,73,99,69,69,0,37,46,48,76,102,0,78,83,116,51,95,95,49,57,109,111,110,101,121,95,112,117,116,73,119,78,83,95,49,57,111,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,119,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,119,69,69,69,69,69,69,0,78,83,116,51,95,95,49,49,49,95,95,109,111,110,101,121,95,112,117,116,73,119,69,69,0,78,83,116,51,95,95,49,56,109,101,115,115,97,103,101,115,73,99,69,69,0,78,83,116,51,95,95,49,49,51,109,101,115,115,97,103,101,115,95,98,97,115,101,69,0,78,83,116,51,95,95,49,56,109,101,115,115,97,103,101,115,73,119,69,69,0,78,83,116,51,95,95,49,49,54,95,95,110,97,114,114,111,119,95,116,111,95,117,116,102,56,73,76,106,51,50,69,69,69,0,78,83,116,51,95,95,49,55,99,111,100,101,99,118,116,73,68,105,99,49,49,95,95,109,98,115,116,97,116,101,95,116,69,69,0,78,83,116,51,95,95,49,49,50,99,111,100,101,99,118,116,95,98,97,115,101,69,0,78,83,116,51,95,95,49,49,55,95,95,119,105,100,101,110,95,102,114,111,109,95,117,116,102,56,73,76,106,51,50,69,69,69,0,78,83,116,51,95,95,49,55,99,111,100,101,99,118,116,73,99,99,49,49,95,95,109,98,115,116,97,116,101,95,116,69,69,0,78,83,116,51,95,95,49,55,99,111,100,101,99,118,116,73,119,99,49,49,95,95,109,98,115,116,97,116,101,95,116,69,69,0,78,83,116,51,95,95,49,55,99,111,100,101,99,118,116,73,68,115,99,49,49,95,95,109,98,115,116,97,116,101,95,116,69,69,0,78,83,116,51,95,95,49,54,108,111,99,97,108,101,53,95,95,105,109,112,69,0,78,83,116,51,95,95,49,53,99,116,121,112,101,73,99,69,69,0,78,83,116,51,95,95,49,49,48,99,116,121,112,101,95,98,97,115,101,69,0,78,83,116,51,95,95,49,53,99,116,121,112,101,73,119,69,69,0,78,83,116,51,95,95,49,56,110,117,109,112,117,110,99,116,73,99,69,69,0,116,114,117,101,0,102,97,108,115,101,0,78,83,116,51,95,95,49,56,110,117,109,112,117,110,99,116,73,119,69,69,0,33,34,118,101,99,116,111,114,32,108,101,110,103,116,104,95,101,114,114,111,114,34,0,47,104,111,109,101,47,110,105,107,108,97,115,47,80,97,99,107,97,103,101,115,47,101,109,115,100,107,95,112,111,114,116,97,98,108,101,47,101,109,115,99,114,105,112,116,101,110,47,109,97,115,116,101,114,47,115,121,115,116,101,109,47,105,110,99,108,117,100,101,47,108,105,98,99,120,120,47,118,101,99,116,111,114,0,95,95,116,104,114,111,119,95,108,101,110,103,116,104,95,101,114,114,111,114,0,33,34,118,101,99,116,111,114,32,111,117,116,95,111,102,95,114,97,110,103,101,34,0,95,95,116,104,114,111,119,95,111,117,116,95,111,102,95,114,97,110,103,101,0,78,83,116,51,95,95,49,49,52,95,95,115,104,97,114,101,100,95,99,111,117,110,116,69,0,99,97,110,110,111,116,32,122,101,114,111,32,111,117,116,32,116,104,114,101,97,100,32,118,97,108,117,101,32,102,111,114,32,95,95,99,120,97,95,103,101,116,95,103,108,111,98,97,108,115,40,41,0,99,97,110,110,111,116,32,99,114,101,97,116,101,32,112,116,104,114,101,97,100,32,107,101,121,32,102,111,114,32,95,95,99,120,97,95,103,101,116,95,103,108,111,98,97,108,115,40,41,0,112,116,104,114,101,97,100,95,111,110,99,101,32,102,97,105,108,117,114,101,32,105,110,32,95,95,99,120,97,95,103,101,116,95,103,108,111,98,97,108,115,95,102,97,115,116,40,41,0,78,49,48,95,95,99,120,120,97,98,105,118,49,50,48,95,95,115,105,95,99,108,97,115,115,95,116,121,112,101,95,105,110,102,111,69,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,54,95,95,115,104,105,109,95,116,121,112,101,95,105,110,102,111,69,0,83,116,57,116,121,112,101,95,105,110,102,111,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,55,95,95,99,108,97,115,115,95,116,121,112,101,95,105,110,102,111,69,0,83,116,57,101,120,99,101,112,116,105,111,110,0,117,110,99,97,117,103,104,116,0,116,101,114,109,105,110,97,116,105,110,103,32,119,105,116,104,32,37,115,32,101,120,99,101,112,116,105,111,110,32,111,102,32,116,121,112,101,32,37,115,58,32,37,115,0,116,101,114,109,105,110,97,116,105,110,103,32,119,105,116,104,32,37,115,32,101,120,99,101,112,116,105,111,110,32,111,102,32,116,121,112,101,32,37,115,0,116,101,114,109,105,110,97,116,105,110,103,32,119,105,116,104,32,37,115,32,102,111,114,101,105,103,110,32,101,120,99,101,112,116,105,111,110,0,116,101,114,109,105,110,97,116,105,110,103,0,116,101,114,109,105,110,97,116,101,95,104,97,110,100,108,101,114,32,117,110,101,120,112,101,99,116,101,100,108,121,32,114,101,116,117,114,110,101,100,0,83,116,57,98,97,100,95,97,108,108,111,99,0,115,116,100,58,58,98,97,100,95,97,108,108,111,99,0,78,49,48,95,95,99,120,120,97,98,105,118,49,50,49,95,95,118,109,105,95,99,108,97,115,115,95,116,121,112,101,95,105,110,102,111,69,0],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+20984);var tempDoublePtr=STATICTOP;STATICTOP+=16;function _emscripten_get_now(){if(!_emscripten_get_now.actual){if(ENVIRONMENT_IS_NODE){_emscripten_get_now.actual=function _emscripten_get_now_actual(){var t=process["hrtime"]();return t[0]*1e3+t[1]/1e6}}else if(typeof dateNow!=="undefined"){_emscripten_get_now.actual=dateNow}else if(typeof self==="object"&&self["performance"]&&typeof self["performance"]["now"]==="function"){_emscripten_get_now.actual=function _emscripten_get_now_actual(){return self["performance"]["now"]()}}else if(typeof performance==="object"&&typeof performance["now"]==="function"){_emscripten_get_now.actual=function _emscripten_get_now_actual(){return performance["now"]()}}else{_emscripten_get_now.actual=Date.now}}return _emscripten_get_now.actual()}function _emscripten_get_now_is_monotonic(){return ENVIRONMENT_IS_NODE||typeof dateNow!=="undefined"||(ENVIRONMENT_IS_WEB||ENVIRONMENT_IS_WORKER)&&self["performance"]&&self["performance"]["now"]}var ERRNO_CODES={EPERM:1,ENOENT:2,ESRCH:3,EINTR:4,EIO:5,ENXIO:6,E2BIG:7,ENOEXEC:8,EBADF:9,ECHILD:10,EAGAIN:11,EWOULDBLOCK:11,ENOMEM:12,EACCES:13,EFAULT:14,ENOTBLK:15,EBUSY:16,EEXIST:17,EXDEV:18,ENODEV:19,ENOTDIR:20,EISDIR:21,EINVAL:22,ENFILE:23,EMFILE:24,ENOTTY:25,ETXTBSY:26,EFBIG:27,ENOSPC:28,ESPIPE:29,EROFS:30,EMLINK:31,EPIPE:32,EDOM:33,ERANGE:34,ENOMSG:42,EIDRM:43,ECHRNG:44,EL2NSYNC:45,EL3HLT:46,EL3RST:47,ELNRNG:48,EUNATCH:49,ENOCSI:50,EL2HLT:51,EDEADLK:35,ENOLCK:37,EBADE:52,EBADR:53,EXFULL:54,ENOANO:55,EBADRQC:56,EBADSLT:57,EDEADLOCK:35,EBFONT:59,ENOSTR:60,ENODATA:61,ETIME:62,ENOSR:63,ENONET:64,ENOPKG:65,EREMOTE:66,ENOLINK:67,EADV:68,ESRMNT:69,ECOMM:70,EPROTO:71,EMULTIHOP:72,EDOTDOT:73,EBADMSG:74,ENOTUNIQ:76,EBADFD:77,EREMCHG:78,ELIBACC:79,ELIBBAD:80,ELIBSCN:81,ELIBMAX:82,ELIBEXEC:83,ENOSYS:38,ENOTEMPTY:39,ENAMETOOLONG:36,ELOOP:40,EOPNOTSUPP:95,EPFNOSUPPORT:96,ECONNRESET:104,ENOBUFS:105,EAFNOSUPPORT:97,EPROTOTYPE:91,ENOTSOCK:88,ENOPROTOOPT:92,ESHUTDOWN:108,ECONNREFUSED:111,EADDRINUSE:98,ECONNABORTED:103,ENETUNREACH:101,ENETDOWN:100,ETIMEDOUT:110,EHOSTDOWN:112,EHOSTUNREACH:113,EINPROGRESS:115,EALREADY:114,EDESTADDRREQ:89,EMSGSIZE:90,EPROTONOSUPPORT:93,ESOCKTNOSUPPORT:94,EADDRNOTAVAIL:99,ENETRESET:102,EISCONN:106,ENOTCONN:107,ETOOMANYREFS:109,EUSERS:87,EDQUOT:122,ESTALE:116,ENOTSUP:95,ENOMEDIUM:123,EILSEQ:84,EOVERFLOW:75,ECANCELED:125,ENOTRECOVERABLE:131,EOWNERDEAD:130,ESTRPIPE:86};function ___setErrNo(value){if(Module["___errno_location"])HEAP32[Module["___errno_location"]()>>2]=value;return value}function _clock_gettime(clk_id,tp){var now;if(clk_id===0){now=Date.now()}else if(clk_id===1&&_emscripten_get_now_is_monotonic()){now=_emscripten_get_now()}else{___setErrNo(ERRNO_CODES.EINVAL);return-1}HEAP32[tp>>2]=now/1e3|0;HEAP32[tp+4>>2]=now%1e3*1e3*1e3|0;return 0}Module["_i64Subtract"]=_i64Subtract;function _sysconf(name){switch(name){case 30:return PAGE_SIZE;case 85:return totalMemory/PAGE_SIZE;case 132:case 133:case 12:case 137:case 138:case 15:case 235:case 16:case 17:case 18:case 19:case 20:case 149:case 13:case 10:case 236:case 153:case 9:case 21:case 22:case 159:case 154:case 14:case 77:case 78:case 139:case 80:case 81:case 82:case 68:case 67:case 164:case 11:case 29:case 47:case 48:case 95:case 52:case 51:case 46:return 200809;case 79:return 0;case 27:case 246:case 127:case 128:case 23:case 24:case 160:case 161:case 181:case 182:case 242:case 183:case 184:case 243:case 244:case 245:case 165:case 178:case 179:case 49:case 50:case 168:case 169:case 175:case 170:case 171:case 172:case 97:case 76:case 32:case 173:case 35:return-1;case 176:case 177:case 7:case 155:case 8:case 157:case 125:case 126:case 92:case 93:case 129:case 130:case 131:case 94:case 91:return 1;case 74:case 60:case 69:case 70:case 4:return 1024;case 31:case 42:case 72:return 32;case 87:case 26:case 33:return 2147483647;case 34:case 1:return 47839;case 38:case 36:return 99;case 43:case 37:return 2048;case 0:return 2097152;case 3:return 65536;case 28:return 32768;case 44:return 32767;case 75:return 16384;case 39:return 1e3;case 89:return 700;case 71:return 256;case 40:return 255;case 2:return 100;case 180:return 64;case 25:return 20;case 5:return 16;case 6:return 6;case 73:return 4;case 84:{if(typeof navigator==="object")return navigator["hardwareConcurrency"]||1;return 1}}___setErrNo(ERRNO_CODES.EINVAL);return-1}function __ZSt18uncaught_exceptionv(){return!!__ZSt18uncaught_exceptionv.uncaught_exception}var EXCEPTIONS={last:0,caught:[],infos:{},deAdjust:(function(adjusted){if(!adjusted||EXCEPTIONS.infos[adjusted])return adjusted;for(var ptr in EXCEPTIONS.infos){var info=EXCEPTIONS.infos[ptr];if(info.adjusted===adjusted){return ptr}}return adjusted}),addRef:(function(ptr){if(!ptr)return;var info=EXCEPTIONS.infos[ptr];info.refcount++}),decRef:(function(ptr){if(!ptr)return;var info=EXCEPTIONS.infos[ptr];assert(info.refcount>0);info.refcount--;if(info.refcount===0){if(info.destructor){Runtime.dynCall("vi",info.destructor,[ptr])}delete EXCEPTIONS.infos[ptr];___cxa_free_exception(ptr)}}),clearRef:(function(ptr){if(!ptr)return;var info=EXCEPTIONS.infos[ptr];info.refcount=0})};function ___resumeException(ptr){if(!EXCEPTIONS.last){EXCEPTIONS.last=ptr}EXCEPTIONS.clearRef(EXCEPTIONS.deAdjust(ptr));throw ptr+" - Exception catching is disabled, this exception cannot be caught. Compile with -s DISABLE_EXCEPTION_CATCHING=0 or DISABLE_EXCEPTION_CATCHING=2 to catch."}function ___cxa_find_matching_catch(){var thrown=EXCEPTIONS.last;if(!thrown){return(asm["setTempRet0"](0),0)|0}var info=EXCEPTIONS.infos[thrown];var throwntype=info.type;if(!throwntype){return(asm["setTempRet0"](0),thrown)|0}var typeArray=Array.prototype.slice.call(arguments);var pointer=Module["___cxa_is_pointer_type"](throwntype);if(!___cxa_find_matching_catch.buffer)___cxa_find_matching_catch.buffer=_malloc(4);HEAP32[___cxa_find_matching_catch.buffer>>2]=thrown;thrown=___cxa_find_matching_catch.buffer;for(var i=0;i<typeArray.length;i++){if(typeArray[i]&&Module["___cxa_can_catch"](typeArray[i],throwntype,thrown)){thrown=HEAP32[thrown>>2];info.adjusted=thrown;return(asm["setTempRet0"](typeArray[i]),thrown)|0}}thrown=HEAP32[thrown>>2];return(asm["setTempRet0"](throwntype),thrown)|0}function ___cxa_throw(ptr,type,destructor){EXCEPTIONS.infos[ptr]={ptr:ptr,adjusted:ptr,type:type,destructor:destructor,refcount:0};EXCEPTIONS.last=ptr;if(!("uncaught_exception"in __ZSt18uncaught_exceptionv)){__ZSt18uncaught_exceptionv.uncaught_exception=1}else{__ZSt18uncaught_exceptionv.uncaught_exception++}throw ptr+" - Exception catching is disabled, this exception cannot be caught. Compile with -s DISABLE_EXCEPTION_CATCHING=0 or DISABLE_EXCEPTION_CATCHING=2 to catch."}Module["_memset"]=_memset;function _pthread_mutex_lock(){}function _pthread_cond_signal(){}function _abort(){Module["abort"]()}function _pthread_cond_destroy(){}function _pthread_mutex_destroy(){}function _pthread_once(ptr,func){if(!_pthread_once.seen)_pthread_once.seen={};if(ptr in _pthread_once.seen)return;Runtime.dynCall("v",func);_pthread_once.seen[ptr]=1}function ___lock(){}function ___unlock(){}var PTHREAD_SPECIFIC={};function _pthread_getspecific(key){return PTHREAD_SPECIFIC[key]||0}var _llvm_fabs_f64=Math_abs;function ___assert_fail(condition,filename,line,func){ABORT=true;throw"Assertion failed: "+Pointer_stringify(condition)+", at: "+[filename?Pointer_stringify(filename):"unknown filename",line,func?Pointer_stringify(func):"unknown function"]+" at "+stackTrace()}var PTHREAD_SPECIFIC_NEXT_KEY=1;function _pthread_key_create(key,destructor){if(key==0){return ERRNO_CODES.EINVAL}HEAP32[key>>2]=PTHREAD_SPECIFIC_NEXT_KEY;PTHREAD_SPECIFIC[PTHREAD_SPECIFIC_NEXT_KEY]=0;PTHREAD_SPECIFIC_NEXT_KEY++;return 0}function __isLeapYear(year){return year%4===0&&(year%100!==0||year%400===0)}function __arraySum(array,index){var sum=0;for(var i=0;i<=index;sum+=array[i++]);return sum}var __MONTH_DAYS_LEAP=[31,29,31,30,31,30,31,31,30,31,30,31];var __MONTH_DAYS_REGULAR=[31,28,31,30,31,30,31,31,30,31,30,31];function __addDays(date,days){var newDate=new Date(date.getTime());while(days>0){var leap=__isLeapYear(newDate.getFullYear());var currentMonth=newDate.getMonth();var daysInCurrentMonth=(leap?__MONTH_DAYS_LEAP:__MONTH_DAYS_REGULAR)[currentMonth];if(days>daysInCurrentMonth-newDate.getDate()){days-=daysInCurrentMonth-newDate.getDate()+1;newDate.setDate(1);if(currentMonth<11){newDate.setMonth(currentMonth+1)}else{newDate.setMonth(0);newDate.setFullYear(newDate.getFullYear()+1)}}else{newDate.setDate(newDate.getDate()+days);return newDate}}return newDate}function _strftime(s,maxsize,format,tm){var tm_zone=HEAP32[tm+40>>2];var date={tm_sec:HEAP32[tm>>2],tm_min:HEAP32[tm+4>>2],tm_hour:HEAP32[tm+8>>2],tm_mday:HEAP32[tm+12>>2],tm_mon:HEAP32[tm+16>>2],tm_year:HEAP32[tm+20>>2],tm_wday:HEAP32[tm+24>>2],tm_yday:HEAP32[tm+28>>2],tm_isdst:HEAP32[tm+32>>2],tm_gmtoff:HEAP32[tm+36>>2],tm_zone:tm_zone?Pointer_stringify(tm_zone):""};var pattern=Pointer_stringify(format);var EXPANSION_RULES_1={"%c":"%a %b %d %H:%M:%S %Y","%D":"%m/%d/%y","%F":"%Y-%m-%d","%h":"%b","%r":"%I:%M:%S %p","%R":"%H:%M","%T":"%H:%M:%S","%x":"%m/%d/%y","%X":"%H:%M:%S"};for(var rule in EXPANSION_RULES_1){pattern=pattern.replace(new RegExp(rule,"g"),EXPANSION_RULES_1[rule])}var WEEKDAYS=["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"];var MONTHS=["January","February","March","April","May","June","July","August","September","October","November","December"];function leadingSomething(value,digits,character){var str=typeof value==="number"?value.toString():value||"";while(str.length<digits){str=character[0]+str}return str}function leadingNulls(value,digits){return leadingSomething(value,digits,"0")}function compareByDay(date1,date2){function sgn(value){return value<0?-1:value>0?1:0}var compare;if((compare=sgn(date1.getFullYear()-date2.getFullYear()))===0){if((compare=sgn(date1.getMonth()-date2.getMonth()))===0){compare=sgn(date1.getDate()-date2.getDate())}}return compare}function getFirstWeekStartDate(janFourth){switch(janFourth.getDay()){case 0:return new Date(janFourth.getFullYear()-1,11,29);case 1:return janFourth;case 2:return new Date(janFourth.getFullYear(),0,3);case 3:return new Date(janFourth.getFullYear(),0,2);case 4:return new Date(janFourth.getFullYear(),0,1);case 5:return new Date(janFourth.getFullYear()-1,11,31);case 6:return new Date(janFourth.getFullYear()-1,11,30)}}function getWeekBasedYear(date){var thisDate=__addDays(new Date(date.tm_year+1900,0,1),date.tm_yday);var janFourthThisYear=new Date(thisDate.getFullYear(),0,4);var janFourthNextYear=new Date(thisDate.getFullYear()+1,0,4);var firstWeekStartThisYear=getFirstWeekStartDate(janFourthThisYear);var firstWeekStartNextYear=getFirstWeekStartDate(janFourthNextYear);if(compareByDay(firstWeekStartThisYear,thisDate)<=0){if(compareByDay(firstWeekStartNextYear,thisDate)<=0){return thisDate.getFullYear()+1}else{return thisDate.getFullYear()}}else{return thisDate.getFullYear()-1}}var EXPANSION_RULES_2={"%a":(function(date){return WEEKDAYS[date.tm_wday].substring(0,3)}),"%A":(function(date){return WEEKDAYS[date.tm_wday]}),"%b":(function(date){return MONTHS[date.tm_mon].substring(0,3)}),"%B":(function(date){return MONTHS[date.tm_mon]}),"%C":(function(date){var year=date.tm_year+1900;return leadingNulls(year/100|0,2)}),"%d":(function(date){return leadingNulls(date.tm_mday,2)}),"%e":(function(date){return leadingSomething(date.tm_mday,2," ")}),"%g":(function(date){return getWeekBasedYear(date).toString().substring(2)}),"%G":(function(date){return getWeekBasedYear(date)}),"%H":(function(date){return leadingNulls(date.tm_hour,2)}),"%I":(function(date){var twelveHour=date.tm_hour;if(twelveHour==0)twelveHour=12;else if(twelveHour>12)twelveHour-=12;return leadingNulls(twelveHour,2)}),"%j":(function(date){return leadingNulls(date.tm_mday+__arraySum(__isLeapYear(date.tm_year+1900)?__MONTH_DAYS_LEAP:__MONTH_DAYS_REGULAR,date.tm_mon-1),3)}),"%m":(function(date){return leadingNulls(date.tm_mon+1,2)}),"%M":(function(date){return leadingNulls(date.tm_min,2)}),"%n":(function(){return"\n"}),"%p":(function(date){if(date.tm_hour>=0&&date.tm_hour<12){return"AM"}else{return"PM"}}),"%S":(function(date){return leadingNulls(date.tm_sec,2)}),"%t":(function(){return"\t"}),"%u":(function(date){var day=new Date(date.tm_year+1900,date.tm_mon+1,date.tm_mday,0,0,0,0);return day.getDay()||7}),"%U":(function(date){var janFirst=new Date(date.tm_year+1900,0,1);var firstSunday=janFirst.getDay()===0?janFirst:__addDays(janFirst,7-janFirst.getDay());var endDate=new Date(date.tm_year+1900,date.tm_mon,date.tm_mday);if(compareByDay(firstSunday,endDate)<0){var februaryFirstUntilEndMonth=__arraySum(__isLeapYear(endDate.getFullYear())?__MONTH_DAYS_LEAP:__MONTH_DAYS_REGULAR,endDate.getMonth()-1)-31;var firstSundayUntilEndJanuary=31-firstSunday.getDate();var days=firstSundayUntilEndJanuary+februaryFirstUntilEndMonth+endDate.getDate();return leadingNulls(Math.ceil(days/7),2)}return compareByDay(firstSunday,janFirst)===0?"01":"00"}),"%V":(function(date){var janFourthThisYear=new Date(date.tm_year+1900,0,4);var janFourthNextYear=new Date(date.tm_year+1901,0,4);var firstWeekStartThisYear=getFirstWeekStartDate(janFourthThisYear);var firstWeekStartNextYear=getFirstWeekStartDate(janFourthNextYear);var endDate=__addDays(new Date(date.tm_year+1900,0,1),date.tm_yday);if(compareByDay(endDate,firstWeekStartThisYear)<0){return"53"}if(compareByDay(firstWeekStartNextYear,endDate)<=0){return"01"}var daysDifference;if(firstWeekStartThisYear.getFullYear()<date.tm_year+1900){daysDifference=date.tm_yday+32-firstWeekStartThisYear.getDate()}else{daysDifference=date.tm_yday+1-firstWeekStartThisYear.getDate()}return leadingNulls(Math.ceil(daysDifference/7),2)}),"%w":(function(date){var day=new Date(date.tm_year+1900,date.tm_mon+1,date.tm_mday,0,0,0,0);return day.getDay()}),"%W":(function(date){var janFirst=new Date(date.tm_year,0,1);var firstMonday=janFirst.getDay()===1?janFirst:__addDays(janFirst,janFirst.getDay()===0?1:7-janFirst.getDay()+1);var endDate=new Date(date.tm_year+1900,date.tm_mon,date.tm_mday);if(compareByDay(firstMonday,endDate)<0){var februaryFirstUntilEndMonth=__arraySum(__isLeapYear(endDate.getFullYear())?__MONTH_DAYS_LEAP:__MONTH_DAYS_REGULAR,endDate.getMonth()-1)-31;var firstMondayUntilEndJanuary=31-firstMonday.getDate();var days=firstMondayUntilEndJanuary+februaryFirstUntilEndMonth+endDate.getDate();return leadingNulls(Math.ceil(days/7),2)}return compareByDay(firstMonday,janFirst)===0?"01":"00"}),"%y":(function(date){return(date.tm_year+1900).toString().substring(2)}),"%Y":(function(date){return date.tm_year+1900}),"%z":(function(date){var off=date.tm_gmtoff;var ahead=off>=0;off=Math.abs(off)/60;off=off/60*100+off%60;return(ahead?"+":"-")+String("0000"+off).slice(-4)}),"%Z":(function(date){return date.tm_zone}),"%%":(function(){return"%"})};for(var rule in EXPANSION_RULES_2){if(pattern.indexOf(rule)>=0){pattern=pattern.replace(new RegExp(rule,"g"),EXPANSION_RULES_2[rule](date))}}var bytes=intArrayFromString(pattern,false);if(bytes.length>maxsize){return 0}writeArrayToMemory(bytes,s);return bytes.length-1}function _strftime_l(s,maxsize,format,tm){return _strftime(s,maxsize,format,tm)}function __exit(status){Module["exit"](status)}function _exit(status){__exit(status)}function _pthread_setspecific(key,value){if(!(key in PTHREAD_SPECIFIC)){return ERRNO_CODES.EINVAL}PTHREAD_SPECIFIC[key]=value;return 0}function _malloc(bytes){var ptr=Runtime.dynamicAlloc(bytes+8);return ptr+8&4294967288}Module["_malloc"]=_malloc;function ___cxa_allocate_exception(size){return _malloc(size)}var ERRNO_MESSAGES={0:"Success",1:"Not super-user",2:"No such file or directory",3:"No such process",4:"Interrupted system call",5:"I/O error",6:"No such device or address",7:"Arg list too long",8:"Exec format error",9:"Bad file number",10:"No children",11:"No more processes",12:"Not enough core",13:"Permission denied",14:"Bad address",15:"Block device required",16:"Mount device busy",17:"File exists",18:"Cross-device link",19:"No such device",20:"Not a directory",21:"Is a directory",22:"Invalid argument",23:"Too many open files in system",24:"Too many open files",25:"Not a typewriter",26:"Text file busy",27:"File too large",28:"No space left on device",29:"Illegal seek",30:"Read only file system",31:"Too many links",32:"Broken pipe",33:"Math arg out of domain of func",34:"Math result not representable",35:"File locking deadlock error",36:"File or path name too long",37:"No record locks available",38:"Function not implemented",39:"Directory not empty",40:"Too many symbolic links",42:"No message of desired type",43:"Identifier removed",44:"Channel number out of range",45:"Level 2 not synchronized",46:"Level 3 halted",47:"Level 3 reset",48:"Link number out of range",49:"Protocol driver not attached",50:"No CSI structure available",51:"Level 2 halted",52:"Invalid exchange",53:"Invalid request descriptor",54:"Exchange full",55:"No anode",56:"Invalid request code",57:"Invalid slot",59:"Bad font file fmt",60:"Device not a stream",61:"No data (for no delay io)",62:"Timer expired",63:"Out of streams resources",64:"Machine is not on the network",65:"Package not installed",66:"The object is remote",67:"The link has been severed",68:"Advertise error",69:"Srmount error",70:"Communication error on send",71:"Protocol error",72:"Multihop attempted",73:"Cross mount point (not really error)",74:"Trying to read unreadable message",75:"Value too large for defined data type",76:"Given log. name not unique",77:"f.d. invalid for this operation",78:"Remote address changed",79:"Can   access a needed shared lib",80:"Accessing a corrupted shared lib",81:".lib section in a.out corrupted",82:"Attempting to link in too many libs",83:"Attempting to exec a shared library",84:"Illegal byte sequence",86:"Streams pipe error",87:"Too many users",88:"Socket operation on non-socket",89:"Destination address required",90:"Message too long",91:"Protocol wrong type for socket",92:"Protocol not available",93:"Unknown protocol",94:"Socket type not supported",95:"Not supported",96:"Protocol family not supported",97:"Address family not supported by protocol family",98:"Address already in use",99:"Address not available",100:"Network interface is not configured",101:"Network is unreachable",102:"Connection reset by network",103:"Connection aborted",104:"Connection reset by peer",105:"No buffer space available",106:"Socket is already connected",107:"Socket is not connected",108:"Can't send after socket shutdown",109:"Too many references",110:"Connection timed out",111:"Connection refused",112:"Host is down",113:"Host is unreachable",114:"Socket already connected",115:"Connection already in progress",116:"Stale file handle",122:"Quota exceeded",123:"No medium (in tape drive)",125:"Operation canceled",130:"Previous owner died",131:"State not recoverable"};var PATH={splitPath:(function(filename){var splitPathRe=/^(\/?|)([\s\S]*?)((?:\.{1,2}|[^\/]+?|)(\.[^.\/]*|))(?:[\/]*)$/;return splitPathRe.exec(filename).slice(1)}),normalizeArray:(function(parts,allowAboveRoot){var up=0;for(var i=parts.length-1;i>=0;i--){var last=parts[i];if(last==="."){parts.splice(i,1)}else if(last===".."){parts.splice(i,1);up++}else if(up){parts.splice(i,1);up--}}if(allowAboveRoot){for(;up--;up){parts.unshift("..")}}return parts}),normalize:(function(path){var isAbsolute=path.charAt(0)==="/",trailingSlash=path.substr(-1)==="/";path=PATH.normalizeArray(path.split("/").filter((function(p){return!!p})),!isAbsolute).join("/");if(!path&&!isAbsolute){path="."}if(path&&trailingSlash){path+="/"}return(isAbsolute?"/":"")+path}),dirname:(function(path){var result=PATH.splitPath(path),root=result[0],dir=result[1];if(!root&&!dir){return"."}if(dir){dir=dir.substr(0,dir.length-1)}return root+dir}),basename:(function(path){if(path==="/")return"/";var lastSlash=path.lastIndexOf("/");if(lastSlash===-1)return path;return path.substr(lastSlash+1)}),extname:(function(path){return PATH.splitPath(path)[3]}),join:(function(){var paths=Array.prototype.slice.call(arguments,0);return PATH.normalize(paths.join("/"))}),join2:(function(l,r){return PATH.normalize(l+"/"+r)}),resolve:(function(){var resolvedPath="",resolvedAbsolute=false;for(var i=arguments.length-1;i>=-1&&!resolvedAbsolute;i--){var path=i>=0?arguments[i]:FS.cwd();if(typeof path!=="string"){throw new TypeError("Arguments to path.resolve must be strings")}else if(!path){return""}resolvedPath=path+"/"+resolvedPath;resolvedAbsolute=path.charAt(0)==="/"}resolvedPath=PATH.normalizeArray(resolvedPath.split("/").filter((function(p){return!!p})),!resolvedAbsolute).join("/");return(resolvedAbsolute?"/":"")+resolvedPath||"."}),relative:(function(from,to){from=PATH.resolve(from).substr(1);to=PATH.resolve(to).substr(1);function trim(arr){var start=0;for(;start<arr.length;start++){if(arr[start]!=="")break}var end=arr.length-1;for(;end>=0;end--){if(arr[end]!=="")break}if(start>end)return[];return arr.slice(start,end-start+1)}var fromParts=trim(from.split("/"));var toParts=trim(to.split("/"));var length=Math.min(fromParts.length,toParts.length);var samePartsLength=length;for(var i=0;i<length;i++){if(fromParts[i]!==toParts[i]){samePartsLength=i;break}}var outputParts=[];for(var i=samePartsLength;i<fromParts.length;i++){outputParts.push("..")}outputParts=outputParts.concat(toParts.slice(samePartsLength));return outputParts.join("/")})};var TTY={ttys:[],init:(function(){}),shutdown:(function(){}),register:(function(dev,ops){TTY.ttys[dev]={input:[],output:[],ops:ops};FS.registerDevice(dev,TTY.stream_ops)}),stream_ops:{open:(function(stream){var tty=TTY.ttys[stream.node.rdev];if(!tty){throw new FS.ErrnoError(ERRNO_CODES.ENODEV)}stream.tty=tty;stream.seekable=false}),close:(function(stream){stream.tty.ops.flush(stream.tty)}),flush:(function(stream){stream.tty.ops.flush(stream.tty)}),read:(function(stream,buffer,offset,length,pos){if(!stream.tty||!stream.tty.ops.get_char){throw new FS.ErrnoError(ERRNO_CODES.ENXIO)}var bytesRead=0;for(var i=0;i<length;i++){var result;try{result=stream.tty.ops.get_char(stream.tty)}catch(e){throw new FS.ErrnoError(ERRNO_CODES.EIO)}if(result===undefined&&bytesRead===0){throw new FS.ErrnoError(ERRNO_CODES.EAGAIN)}if(result===null||result===undefined)break;bytesRead++;buffer[offset+i]=result}if(bytesRead){stream.node.timestamp=Date.now()}return bytesRead}),write:(function(stream,buffer,offset,length,pos){if(!stream.tty||!stream.tty.ops.put_char){throw new FS.ErrnoError(ERRNO_CODES.ENXIO)}for(var i=0;i<length;i++){try{stream.tty.ops.put_char(stream.tty,buffer[offset+i])}catch(e){throw new FS.ErrnoError(ERRNO_CODES.EIO)}}if(length){stream.node.timestamp=Date.now()}return i})},default_tty_ops:{get_char:(function(tty){if(!tty.input.length){var result=null;if(ENVIRONMENT_IS_NODE){var BUFSIZE=256;var buf=new Buffer(BUFSIZE);var bytesRead=0;var fd=process.stdin.fd;var usingDevice=false;try{fd=fs.openSync("/dev/stdin","r");usingDevice=true}catch(e){}bytesRead=fs.readSync(fd,buf,0,BUFSIZE,null);if(usingDevice){fs.closeSync(fd)}if(bytesRead>0){result=buf.slice(0,bytesRead).toString("utf-8")}else{result=null}}else if(typeof window!="undefined"&&typeof window.prompt=="function"){result=window.prompt("Input: ");if(result!==null){result+="\n"}}else if(typeof readline=="function"){result=readline();if(result!==null){result+="\n"}}if(!result){return null}tty.input=intArrayFromString(result,true)}return tty.input.shift()}),put_char:(function(tty,val){if(val===null||val===10){Module["print"](UTF8ArrayToString(tty.output,0));tty.output=[]}else{if(val!=0)tty.output.push(val)}}),flush:(function(tty){if(tty.output&&tty.output.length>0){Module["print"](UTF8ArrayToString(tty.output,0));tty.output=[]}})},default_tty1_ops:{put_char:(function(tty,val){if(val===null||val===10){Module["printErr"](UTF8ArrayToString(tty.output,0));tty.output=[]}else{if(val!=0)tty.output.push(val)}}),flush:(function(tty){if(tty.output&&tty.output.length>0){Module["printErr"](UTF8ArrayToString(tty.output,0));tty.output=[]}})}};var MEMFS={ops_table:null,mount:(function(mount){return MEMFS.createNode(null,"/",16384|511,0)}),createNode:(function(parent,name,mode,dev){if(FS.isBlkdev(mode)||FS.isFIFO(mode)){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}if(!MEMFS.ops_table){MEMFS.ops_table={dir:{node:{getattr:MEMFS.node_ops.getattr,setattr:MEMFS.node_ops.setattr,lookup:MEMFS.node_ops.lookup,mknod:MEMFS.node_ops.mknod,rename:MEMFS.node_ops.rename,unlink:MEMFS.node_ops.unlink,rmdir:MEMFS.node_ops.rmdir,readdir:MEMFS.node_ops.readdir,symlink:MEMFS.node_ops.symlink},stream:{llseek:MEMFS.stream_ops.llseek}},file:{node:{getattr:MEMFS.node_ops.getattr,setattr:MEMFS.node_ops.setattr},stream:{llseek:MEMFS.stream_ops.llseek,read:MEMFS.stream_ops.read,write:MEMFS.stream_ops.write,allocate:MEMFS.stream_ops.allocate,mmap:MEMFS.stream_ops.mmap,msync:MEMFS.stream_ops.msync}},link:{node:{getattr:MEMFS.node_ops.getattr,setattr:MEMFS.node_ops.setattr,readlink:MEMFS.node_ops.readlink},stream:{}},chrdev:{node:{getattr:MEMFS.node_ops.getattr,setattr:MEMFS.node_ops.setattr},stream:FS.chrdev_stream_ops}}}var node=FS.createNode(parent,name,mode,dev);if(FS.isDir(node.mode)){node.node_ops=MEMFS.ops_table.dir.node;node.stream_ops=MEMFS.ops_table.dir.stream;node.contents={}}else if(FS.isFile(node.mode)){node.node_ops=MEMFS.ops_table.file.node;node.stream_ops=MEMFS.ops_table.file.stream;node.usedBytes=0;node.contents=null}else if(FS.isLink(node.mode)){node.node_ops=MEMFS.ops_table.link.node;node.stream_ops=MEMFS.ops_table.link.stream}else if(FS.isChrdev(node.mode)){node.node_ops=MEMFS.ops_table.chrdev.node;node.stream_ops=MEMFS.ops_table.chrdev.stream}node.timestamp=Date.now();if(parent){parent.contents[name]=node}return node}),getFileDataAsRegularArray:(function(node){if(node.contents&&node.contents.subarray){var arr=[];for(var i=0;i<node.usedBytes;++i)arr.push(node.contents[i]);return arr}return node.contents}),getFileDataAsTypedArray:(function(node){if(!node.contents)return new Uint8Array;if(node.contents.subarray)return node.contents.subarray(0,node.usedBytes);return new Uint8Array(node.contents)}),expandFileStorage:(function(node,newCapacity){if(node.contents&&node.contents.subarray&&newCapacity>node.contents.length){node.contents=MEMFS.getFileDataAsRegularArray(node);node.usedBytes=node.contents.length}if(!node.contents||node.contents.subarray){var prevCapacity=node.contents?node.contents.buffer.byteLength:0;if(prevCapacity>=newCapacity)return;var CAPACITY_DOUBLING_MAX=1024*1024;newCapacity=Math.max(newCapacity,prevCapacity*(prevCapacity<CAPACITY_DOUBLING_MAX?2:1.125)|0);if(prevCapacity!=0)newCapacity=Math.max(newCapacity,256);var oldContents=node.contents;node.contents=new Uint8Array(newCapacity);if(node.usedBytes>0)node.contents.set(oldContents.subarray(0,node.usedBytes),0);return}if(!node.contents&&newCapacity>0)node.contents=[];while(node.contents.length<newCapacity)node.contents.push(0)}),resizeFileStorage:(function(node,newSize){if(node.usedBytes==newSize)return;if(newSize==0){node.contents=null;node.usedBytes=0;return}if(!node.contents||node.contents.subarray){var oldContents=node.contents;node.contents=new Uint8Array(new ArrayBuffer(newSize));if(oldContents){node.contents.set(oldContents.subarray(0,Math.min(newSize,node.usedBytes)))}node.usedBytes=newSize;return}if(!node.contents)node.contents=[];if(node.contents.length>newSize)node.contents.length=newSize;else while(node.contents.length<newSize)node.contents.push(0);node.usedBytes=newSize}),node_ops:{getattr:(function(node){var attr={};attr.dev=FS.isChrdev(node.mode)?node.id:1;attr.ino=node.id;attr.mode=node.mode;attr.nlink=1;attr.uid=0;attr.gid=0;attr.rdev=node.rdev;if(FS.isDir(node.mode)){attr.size=4096}else if(FS.isFile(node.mode)){attr.size=node.usedBytes}else if(FS.isLink(node.mode)){attr.size=node.link.length}else{attr.size=0}attr.atime=new Date(node.timestamp);attr.mtime=new Date(node.timestamp);attr.ctime=new Date(node.timestamp);attr.blksize=4096;attr.blocks=Math.ceil(attr.size/attr.blksize);return attr}),setattr:(function(node,attr){if(attr.mode!==undefined){node.mode=attr.mode}if(attr.timestamp!==undefined){node.timestamp=attr.timestamp}if(attr.size!==undefined){MEMFS.resizeFileStorage(node,attr.size)}}),lookup:(function(parent,name){throw FS.genericErrors[ERRNO_CODES.ENOENT]}),mknod:(function(parent,name,mode,dev){return MEMFS.createNode(parent,name,mode,dev)}),rename:(function(old_node,new_dir,new_name){if(FS.isDir(old_node.mode)){var new_node;try{new_node=FS.lookupNode(new_dir,new_name)}catch(e){}if(new_node){for(var i in new_node.contents){throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY)}}}delete old_node.parent.contents[old_node.name];old_node.name=new_name;new_dir.contents[new_name]=old_node;old_node.parent=new_dir}),unlink:(function(parent,name){delete parent.contents[name]}),rmdir:(function(parent,name){var node=FS.lookupNode(parent,name);for(var i in node.contents){throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY)}delete parent.contents[name]}),readdir:(function(node){var entries=[".",".."];for(var key in node.contents){if(!node.contents.hasOwnProperty(key)){continue}entries.push(key)}return entries}),symlink:(function(parent,newname,oldpath){var node=MEMFS.createNode(parent,newname,511|40960,0);node.link=oldpath;return node}),readlink:(function(node){if(!FS.isLink(node.mode)){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}return node.link})},stream_ops:{read:(function(stream,buffer,offset,length,position){var contents=stream.node.contents;if(position>=stream.node.usedBytes)return 0;var size=Math.min(stream.node.usedBytes-position,length);assert(size>=0);if(size>8&&contents.subarray){buffer.set(contents.subarray(position,position+size),offset)}else{for(var i=0;i<size;i++)buffer[offset+i]=contents[position+i]}return size}),write:(function(stream,buffer,offset,length,position,canOwn){if(!length)return 0;var node=stream.node;node.timestamp=Date.now();if(buffer.subarray&&(!node.contents||node.contents.subarray)){if(canOwn){node.contents=buffer.subarray(offset,offset+length);node.usedBytes=length;return length}else if(node.usedBytes===0&&position===0){node.contents=new Uint8Array(buffer.subarray(offset,offset+length));node.usedBytes=length;return length}else if(position+length<=node.usedBytes){node.contents.set(buffer.subarray(offset,offset+length),position);return length}}MEMFS.expandFileStorage(node,position+length);if(node.contents.subarray&&buffer.subarray)node.contents.set(buffer.subarray(offset,offset+length),position);else{for(var i=0;i<length;i++){node.contents[position+i]=buffer[offset+i]}}node.usedBytes=Math.max(node.usedBytes,position+length);return length}),llseek:(function(stream,offset,whence){var position=offset;if(whence===1){position+=stream.position}else if(whence===2){if(FS.isFile(stream.node.mode)){position+=stream.node.usedBytes}}if(position<0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}return position}),allocate:(function(stream,offset,length){MEMFS.expandFileStorage(stream.node,offset+length);stream.node.usedBytes=Math.max(stream.node.usedBytes,offset+length)}),mmap:(function(stream,buffer,offset,length,position,prot,flags){if(!FS.isFile(stream.node.mode)){throw new FS.ErrnoError(ERRNO_CODES.ENODEV)}var ptr;var allocated;var contents=stream.node.contents;if(!(flags&2)&&(contents.buffer===buffer||contents.buffer===buffer.buffer)){allocated=false;ptr=contents.byteOffset}else{if(position>0||position+length<stream.node.usedBytes){if(contents.subarray){contents=contents.subarray(position,position+length)}else{contents=Array.prototype.slice.call(contents,position,position+length)}}allocated=true;ptr=_malloc(length);if(!ptr){throw new FS.ErrnoError(ERRNO_CODES.ENOMEM)}buffer.set(contents,ptr)}return{ptr:ptr,allocated:allocated}}),msync:(function(stream,buffer,offset,length,mmapFlags){if(!FS.isFile(stream.node.mode)){throw new FS.ErrnoError(ERRNO_CODES.ENODEV)}if(mmapFlags&2){return 0}var bytesWritten=MEMFS.stream_ops.write(stream,buffer,0,length,offset,false);return 0})}};var IDBFS={dbs:{},indexedDB:(function(){if(typeof indexedDB!=="undefined")return indexedDB;var ret=null;if(typeof window==="object")ret=window.indexedDB||window.mozIndexedDB||window.webkitIndexedDB||window.msIndexedDB;assert(ret,"IDBFS used, but indexedDB not supported");return ret}),DB_VERSION:21,DB_STORE_NAME:"FILE_DATA",mount:(function(mount){return MEMFS.mount.apply(null,arguments)}),syncfs:(function(mount,populate,callback){IDBFS.getLocalSet(mount,(function(err,local){if(err)return callback(err);IDBFS.getRemoteSet(mount,(function(err,remote){if(err)return callback(err);var src=populate?remote:local;var dst=populate?local:remote;IDBFS.reconcile(src,dst,callback)}))}))}),getDB:(function(name,callback){var db=IDBFS.dbs[name];if(db){return callback(null,db)}var req;try{req=IDBFS.indexedDB().open(name,IDBFS.DB_VERSION)}catch(e){return callback(e)}req.onupgradeneeded=(function(e){var db=e.target.result;var transaction=e.target.transaction;var fileStore;if(db.objectStoreNames.contains(IDBFS.DB_STORE_NAME)){fileStore=transaction.objectStore(IDBFS.DB_STORE_NAME)}else{fileStore=db.createObjectStore(IDBFS.DB_STORE_NAME)}if(!fileStore.indexNames.contains("timestamp")){fileStore.createIndex("timestamp","timestamp",{unique:false})}});req.onsuccess=(function(){db=req.result;IDBFS.dbs[name]=db;callback(null,db)});req.onerror=(function(e){callback(this.error);e.preventDefault()})}),getLocalSet:(function(mount,callback){var entries={};function isRealDir(p){return p!=="."&&p!==".."}function toAbsolute(root){return(function(p){return PATH.join2(root,p)})}var check=FS.readdir(mount.mountpoint).filter(isRealDir).map(toAbsolute(mount.mountpoint));while(check.length){var path=check.pop();var stat;try{stat=FS.stat(path)}catch(e){return callback(e)}if(FS.isDir(stat.mode)){check.push.apply(check,FS.readdir(path).filter(isRealDir).map(toAbsolute(path)))}entries[path]={timestamp:stat.mtime}}return callback(null,{type:"local",entries:entries})}),getRemoteSet:(function(mount,callback){var entries={};IDBFS.getDB(mount.mountpoint,(function(err,db){if(err)return callback(err);var transaction=db.transaction([IDBFS.DB_STORE_NAME],"readonly");transaction.onerror=(function(e){callback(this.error);e.preventDefault()});var store=transaction.objectStore(IDBFS.DB_STORE_NAME);var index=store.index("timestamp");index.openKeyCursor().onsuccess=(function(event){var cursor=event.target.result;if(!cursor){return callback(null,{type:"remote",db:db,entries:entries})}entries[cursor.primaryKey]={timestamp:cursor.key};cursor.continue()})}))}),loadLocalEntry:(function(path,callback){var stat,node;try{var lookup=FS.lookupPath(path);node=lookup.node;stat=FS.stat(path)}catch(e){return callback(e)}if(FS.isDir(stat.mode)){return callback(null,{timestamp:stat.mtime,mode:stat.mode})}else if(FS.isFile(stat.mode)){node.contents=MEMFS.getFileDataAsTypedArray(node);return callback(null,{timestamp:stat.mtime,mode:stat.mode,contents:node.contents})}else{return callback(new Error("node type not supported"))}}),storeLocalEntry:(function(path,entry,callback){try{if(FS.isDir(entry.mode)){FS.mkdir(path,entry.mode)}else if(FS.isFile(entry.mode)){FS.writeFile(path,entry.contents,{encoding:"binary",canOwn:true})}else{return callback(new Error("node type not supported"))}FS.chmod(path,entry.mode);FS.utime(path,entry.timestamp,entry.timestamp)}catch(e){return callback(e)}callback(null)}),removeLocalEntry:(function(path,callback){try{var lookup=FS.lookupPath(path);var stat=FS.stat(path);if(FS.isDir(stat.mode)){FS.rmdir(path)}else if(FS.isFile(stat.mode)){FS.unlink(path)}}catch(e){return callback(e)}callback(null)}),loadRemoteEntry:(function(store,path,callback){var req=store.get(path);req.onsuccess=(function(event){callback(null,event.target.result)});req.onerror=(function(e){callback(this.error);e.preventDefault()})}),storeRemoteEntry:(function(store,path,entry,callback){var req=store.put(entry,path);req.onsuccess=(function(){callback(null)});req.onerror=(function(e){callback(this.error);e.preventDefault()})}),removeRemoteEntry:(function(store,path,callback){var req=store.delete(path);req.onsuccess=(function(){callback(null)});req.onerror=(function(e){callback(this.error);e.preventDefault()})}),reconcile:(function(src,dst,callback){var total=0;var create=[];Object.keys(src.entries).forEach((function(key){var e=src.entries[key];var e2=dst.entries[key];if(!e2||e.timestamp>e2.timestamp){create.push(key);total++}}));var remove=[];Object.keys(dst.entries).forEach((function(key){var e=dst.entries[key];var e2=src.entries[key];if(!e2){remove.push(key);total++}}));if(!total){return callback(null)}var completed=0;var db=src.type==="remote"?src.db:dst.db;var transaction=db.transaction([IDBFS.DB_STORE_NAME],"readwrite");var store=transaction.objectStore(IDBFS.DB_STORE_NAME);function done(err){if(err){if(!done.errored){done.errored=true;return callback(err)}return}if(++completed>=total){return callback(null)}}transaction.onerror=(function(e){done(this.error);e.preventDefault()});create.sort().forEach((function(path){if(dst.type==="local"){IDBFS.loadRemoteEntry(store,path,(function(err,entry){if(err)return done(err);IDBFS.storeLocalEntry(path,entry,done)}))}else{IDBFS.loadLocalEntry(path,(function(err,entry){if(err)return done(err);IDBFS.storeRemoteEntry(store,path,entry,done)}))}}));remove.sort().reverse().forEach((function(path){if(dst.type==="local"){IDBFS.removeLocalEntry(path,done)}else{IDBFS.removeRemoteEntry(store,path,done)}}))})};var NODEFS={isWindows:false,staticInit:(function(){NODEFS.isWindows=!!process.platform.match(/^win/)}),mount:(function(mount){assert(ENVIRONMENT_IS_NODE);return NODEFS.createNode(null,"/",NODEFS.getMode(mount.opts.root),0)}),createNode:(function(parent,name,mode,dev){if(!FS.isDir(mode)&&!FS.isFile(mode)&&!FS.isLink(mode)){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}var node=FS.createNode(parent,name,mode);node.node_ops=NODEFS.node_ops;node.stream_ops=NODEFS.stream_ops;return node}),getMode:(function(path){var stat;try{stat=fs.lstatSync(path);if(NODEFS.isWindows){stat.mode=stat.mode|(stat.mode&146)>>1}}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}return stat.mode}),realPath:(function(node){var parts=[];while(node.parent!==node){parts.push(node.name);node=node.parent}parts.push(node.mount.opts.root);parts.reverse();return PATH.join.apply(null,parts)}),flagsToPermissionStringMap:{0:"r",1:"r+",2:"r+",64:"r",65:"r+",66:"r+",129:"rx+",193:"rx+",514:"w+",577:"w",578:"w+",705:"wx",706:"wx+",1024:"a",1025:"a",1026:"a+",1089:"a",1090:"a+",1153:"ax",1154:"ax+",1217:"ax",1218:"ax+",4096:"rs",4098:"rs+"},flagsToPermissionString:(function(flags){flags&=~32768;flags&=~524288;if(flags in NODEFS.flagsToPermissionStringMap){return NODEFS.flagsToPermissionStringMap[flags]}else{throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}}),node_ops:{getattr:(function(node){var path=NODEFS.realPath(node);var stat;try{stat=fs.lstatSync(path)}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}if(NODEFS.isWindows&&!stat.blksize){stat.blksize=4096}if(NODEFS.isWindows&&!stat.blocks){stat.blocks=(stat.size+stat.blksize-1)/stat.blksize|0}return{dev:stat.dev,ino:stat.ino,mode:stat.mode,nlink:stat.nlink,uid:stat.uid,gid:stat.gid,rdev:stat.rdev,size:stat.size,atime:stat.atime,mtime:stat.mtime,ctime:stat.ctime,blksize:stat.blksize,blocks:stat.blocks}}),setattr:(function(node,attr){var path=NODEFS.realPath(node);try{if(attr.mode!==undefined){fs.chmodSync(path,attr.mode);node.mode=attr.mode}if(attr.timestamp!==undefined){var date=new Date(attr.timestamp);fs.utimesSync(path,date,date)}if(attr.size!==undefined){fs.truncateSync(path,attr.size)}}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),lookup:(function(parent,name){var path=PATH.join2(NODEFS.realPath(parent),name);var mode=NODEFS.getMode(path);return NODEFS.createNode(parent,name,mode)}),mknod:(function(parent,name,mode,dev){var node=NODEFS.createNode(parent,name,mode,dev);var path=NODEFS.realPath(node);try{if(FS.isDir(node.mode)){fs.mkdirSync(path,node.mode)}else{fs.writeFileSync(path,"",{mode:node.mode})}}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}return node}),rename:(function(oldNode,newDir,newName){var oldPath=NODEFS.realPath(oldNode);var newPath=PATH.join2(NODEFS.realPath(newDir),newName);try{fs.renameSync(oldPath,newPath)}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),unlink:(function(parent,name){var path=PATH.join2(NODEFS.realPath(parent),name);try{fs.unlinkSync(path)}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),rmdir:(function(parent,name){var path=PATH.join2(NODEFS.realPath(parent),name);try{fs.rmdirSync(path)}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),readdir:(function(node){var path=NODEFS.realPath(node);try{return fs.readdirSync(path)}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),symlink:(function(parent,newName,oldPath){var newPath=PATH.join2(NODEFS.realPath(parent),newName);try{fs.symlinkSync(oldPath,newPath)}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),readlink:(function(node){var path=NODEFS.realPath(node);try{path=fs.readlinkSync(path);path=NODEJS_PATH.relative(NODEJS_PATH.resolve(node.mount.opts.root),path);return path}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}})},stream_ops:{open:(function(stream){var path=NODEFS.realPath(stream.node);try{if(FS.isFile(stream.node.mode)){stream.nfd=fs.openSync(path,NODEFS.flagsToPermissionString(stream.flags))}}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),close:(function(stream){try{if(FS.isFile(stream.node.mode)&&stream.nfd){fs.closeSync(stream.nfd)}}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),read:(function(stream,buffer,offset,length,position){if(length===0)return 0;var nbuffer=new Buffer(length);var res;try{res=fs.readSync(stream.nfd,nbuffer,0,length,position)}catch(e){throw new FS.ErrnoError(ERRNO_CODES[e.code])}if(res>0){for(var i=0;i<res;i++){buffer[offset+i]=nbuffer[i]}}return res}),write:(function(stream,buffer,offset,length,position){var nbuffer=new Buffer(buffer.subarray(offset,offset+length));var res;try{res=fs.writeSync(stream.nfd,nbuffer,0,length,position)}catch(e){throw new FS.ErrnoError(ERRNO_CODES[e.code])}return res}),llseek:(function(stream,offset,whence){var position=offset;if(whence===1){position+=stream.position}else if(whence===2){if(FS.isFile(stream.node.mode)){try{var stat=fs.fstatSync(stream.nfd);position+=stat.size}catch(e){throw new FS.ErrnoError(ERRNO_CODES[e.code])}}}if(position<0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}return position})}};var WORKERFS={DIR_MODE:16895,FILE_MODE:33279,reader:null,mount:(function(mount){assert(ENVIRONMENT_IS_WORKER);if(!WORKERFS.reader)WORKERFS.reader=new FileReaderSync;var root=WORKERFS.createNode(null,"/",WORKERFS.DIR_MODE,0);var createdParents={};function ensureParent(path){var parts=path.split("/");var parent=root;for(var i=0;i<parts.length-1;i++){var curr=parts.slice(0,i+1).join("/");if(!createdParents[curr]){createdParents[curr]=WORKERFS.createNode(parent,curr,WORKERFS.DIR_MODE,0)}parent=createdParents[curr]}return parent}function base(path){var parts=path.split("/");return parts[parts.length-1]}Array.prototype.forEach.call(mount.opts["files"]||[],(function(file){WORKERFS.createNode(ensureParent(file.name),base(file.name),WORKERFS.FILE_MODE,0,file,file.lastModifiedDate)}));(mount.opts["blobs"]||[]).forEach((function(obj){WORKERFS.createNode(ensureParent(obj["name"]),base(obj["name"]),WORKERFS.FILE_MODE,0,obj["data"])}));(mount.opts["packages"]||[]).forEach((function(pack){pack["metadata"].files.forEach((function(file){var name=file.filename.substr(1);WORKERFS.createNode(ensureParent(name),base(name),WORKERFS.FILE_MODE,0,pack["blob"].slice(file.start,file.end))}))}));return root}),createNode:(function(parent,name,mode,dev,contents,mtime){var node=FS.createNode(parent,name,mode);node.mode=mode;node.node_ops=WORKERFS.node_ops;node.stream_ops=WORKERFS.stream_ops;node.timestamp=(mtime||new Date).getTime();assert(WORKERFS.FILE_MODE!==WORKERFS.DIR_MODE);if(mode===WORKERFS.FILE_MODE){node.size=contents.size;node.contents=contents}else{node.size=4096;node.contents={}}if(parent){parent.contents[name]=node}return node}),node_ops:{getattr:(function(node){return{dev:1,ino:undefined,mode:node.mode,nlink:1,uid:0,gid:0,rdev:undefined,size:node.size,atime:new Date(node.timestamp),mtime:new Date(node.timestamp),ctime:new Date(node.timestamp),blksize:4096,blocks:Math.ceil(node.size/4096)}}),setattr:(function(node,attr){if(attr.mode!==undefined){node.mode=attr.mode}if(attr.timestamp!==undefined){node.timestamp=attr.timestamp}}),lookup:(function(parent,name){throw new FS.ErrnoError(ERRNO_CODES.ENOENT)}),mknod:(function(parent,name,mode,dev){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}),rename:(function(oldNode,newDir,newName){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}),unlink:(function(parent,name){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}),rmdir:(function(parent,name){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}),readdir:(function(node){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}),symlink:(function(parent,newName,oldPath){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}),readlink:(function(node){throw new FS.ErrnoError(ERRNO_CODES.EPERM)})},stream_ops:{read:(function(stream,buffer,offset,length,position){if(position>=stream.node.size)return 0;var chunk=stream.node.contents.slice(position,position+length);var ab=WORKERFS.reader.readAsArrayBuffer(chunk);buffer.set(new Uint8Array(ab),offset);return chunk.size}),write:(function(stream,buffer,offset,length,position){throw new FS.ErrnoError(ERRNO_CODES.EIO)}),llseek:(function(stream,offset,whence){var position=offset;if(whence===1){position+=stream.position}else if(whence===2){if(FS.isFile(stream.node.mode)){position+=stream.node.size}}if(position<0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}return position})}};STATICTOP+=16;STATICTOP+=16;STATICTOP+=16;var FS={root:null,mounts:[],devices:[null],streams:[],nextInode:1,nameTable:null,currentPath:"/",initialized:false,ignorePermissions:true,trackingDelegate:{},tracking:{openFlags:{READ:1,WRITE:2}},ErrnoError:null,genericErrors:{},filesystems:null,syncFSRequests:0,handleFSError:(function(e){if(!(e instanceof FS.ErrnoError))throw e+" : "+stackTrace();return ___setErrNo(e.errno)}),lookupPath:(function(path,opts){path=PATH.resolve(FS.cwd(),path);opts=opts||{};if(!path)return{path:"",node:null};var defaults={follow_mount:true,recurse_count:0};for(var key in defaults){if(opts[key]===undefined){opts[key]=defaults[key]}}if(opts.recurse_count>8){throw new FS.ErrnoError(ERRNO_CODES.ELOOP)}var parts=PATH.normalizeArray(path.split("/").filter((function(p){return!!p})),false);var current=FS.root;var current_path="/";for(var i=0;i<parts.length;i++){var islast=i===parts.length-1;if(islast&&opts.parent){break}current=FS.lookupNode(current,parts[i]);current_path=PATH.join2(current_path,parts[i]);if(FS.isMountpoint(current)){if(!islast||islast&&opts.follow_mount){current=current.mounted.root}}if(!islast||opts.follow){var count=0;while(FS.isLink(current.mode)){var link=FS.readlink(current_path);current_path=PATH.resolve(PATH.dirname(current_path),link);var lookup=FS.lookupPath(current_path,{recurse_count:opts.recurse_count});current=lookup.node;if(count++>40){throw new FS.ErrnoError(ERRNO_CODES.ELOOP)}}}}return{path:current_path,node:current}}),getPath:(function(node){var path;while(true){if(FS.isRoot(node)){var mount=node.mount.mountpoint;if(!path)return mount;return mount[mount.length-1]!=="/"?mount+"/"+path:mount+path}path=path?node.name+"/"+path:node.name;node=node.parent}}),hashName:(function(parentid,name){var hash=0;for(var i=0;i<name.length;i++){hash=(hash<<5)-hash+name.charCodeAt(i)|0}return(parentid+hash>>>0)%FS.nameTable.length}),hashAddNode:(function(node){var hash=FS.hashName(node.parent.id,node.name);node.name_next=FS.nameTable[hash];FS.nameTable[hash]=node}),hashRemoveNode:(function(node){var hash=FS.hashName(node.parent.id,node.name);if(FS.nameTable[hash]===node){FS.nameTable[hash]=node.name_next}else{var current=FS.nameTable[hash];while(current){if(current.name_next===node){current.name_next=node.name_next;break}current=current.name_next}}}),lookupNode:(function(parent,name){var err=FS.mayLookup(parent);if(err){throw new FS.ErrnoError(err,parent)}var hash=FS.hashName(parent.id,name);for(var node=FS.nameTable[hash];node;node=node.name_next){var nodeName=node.name;if(node.parent.id===parent.id&&nodeName===name){return node}}return FS.lookup(parent,name)}),createNode:(function(parent,name,mode,rdev){if(!FS.FSNode){FS.FSNode=(function(parent,name,mode,rdev){if(!parent){parent=this}this.parent=parent;this.mount=parent.mount;this.mounted=null;this.id=FS.nextInode++;this.name=name;this.mode=mode;this.node_ops={};this.stream_ops={};this.rdev=rdev});FS.FSNode.prototype={};var readMode=292|73;var writeMode=146;Object.defineProperties(FS.FSNode.prototype,{read:{get:(function(){return(this.mode&readMode)===readMode}),set:(function(val){val?this.mode|=readMode:this.mode&=~readMode})},write:{get:(function(){return(this.mode&writeMode)===writeMode}),set:(function(val){val?this.mode|=writeMode:this.mode&=~writeMode})},isFolder:{get:(function(){return FS.isDir(this.mode)})},isDevice:{get:(function(){return FS.isChrdev(this.mode)})}})}var node=new FS.FSNode(parent,name,mode,rdev);FS.hashAddNode(node);return node}),destroyNode:(function(node){FS.hashRemoveNode(node)}),isRoot:(function(node){return node===node.parent}),isMountpoint:(function(node){return!!node.mounted}),isFile:(function(mode){return(mode&61440)===32768}),isDir:(function(mode){return(mode&61440)===16384}),isLink:(function(mode){return(mode&61440)===40960}),isChrdev:(function(mode){return(mode&61440)===8192}),isBlkdev:(function(mode){return(mode&61440)===24576}),isFIFO:(function(mode){return(mode&61440)===4096}),isSocket:(function(mode){return(mode&49152)===49152}),flagModes:{"r":0,"rs":1052672,"r+":2,"w":577,"wx":705,"xw":705,"w+":578,"wx+":706,"xw+":706,"a":1089,"ax":1217,"xa":1217,"a+":1090,"ax+":1218,"xa+":1218},modeStringToFlags:(function(str){var flags=FS.flagModes[str];if(typeof flags==="undefined"){throw new Error("Unknown file open mode: "+str)}return flags}),flagsToPermissionString:(function(flag){var perms=["r","w","rw"][flag&3];if(flag&512){perms+="w"}return perms}),nodePermissions:(function(node,perms){if(FS.ignorePermissions){return 0}if(perms.indexOf("r")!==-1&&!(node.mode&292)){return ERRNO_CODES.EACCES}else if(perms.indexOf("w")!==-1&&!(node.mode&146)){return ERRNO_CODES.EACCES}else if(perms.indexOf("x")!==-1&&!(node.mode&73)){return ERRNO_CODES.EACCES}return 0}),mayLookup:(function(dir){var err=FS.nodePermissions(dir,"x");if(err)return err;if(!dir.node_ops.lookup)return ERRNO_CODES.EACCES;return 0}),mayCreate:(function(dir,name){try{var node=FS.lookupNode(dir,name);return ERRNO_CODES.EEXIST}catch(e){}return FS.nodePermissions(dir,"wx")}),mayDelete:(function(dir,name,isdir){var node;try{node=FS.lookupNode(dir,name)}catch(e){return e.errno}var err=FS.nodePermissions(dir,"wx");if(err){return err}if(isdir){if(!FS.isDir(node.mode)){return ERRNO_CODES.ENOTDIR}if(FS.isRoot(node)||FS.getPath(node)===FS.cwd()){return ERRNO_CODES.EBUSY}}else{if(FS.isDir(node.mode)){return ERRNO_CODES.EISDIR}}return 0}),mayOpen:(function(node,flags){if(!node){return ERRNO_CODES.ENOENT}if(FS.isLink(node.mode)){return ERRNO_CODES.ELOOP}else if(FS.isDir(node.mode)){if(FS.flagsToPermissionString(flags)!=="r"||flags&512){return ERRNO_CODES.EISDIR}}return FS.nodePermissions(node,FS.flagsToPermissionString(flags))}),MAX_OPEN_FDS:4096,nextfd:(function(fd_start,fd_end){fd_start=fd_start||0;fd_end=fd_end||FS.MAX_OPEN_FDS;for(var fd=fd_start;fd<=fd_end;fd++){if(!FS.streams[fd]){return fd}}throw new FS.ErrnoError(ERRNO_CODES.EMFILE)}),getStream:(function(fd){return FS.streams[fd]}),createStream:(function(stream,fd_start,fd_end){if(!FS.FSStream){FS.FSStream=(function(){});FS.FSStream.prototype={};Object.defineProperties(FS.FSStream.prototype,{object:{get:(function(){return this.node}),set:(function(val){this.node=val})},isRead:{get:(function(){return(this.flags&2097155)!==1})},isWrite:{get:(function(){return(this.flags&2097155)!==0})},isAppend:{get:(function(){return this.flags&1024})}})}var newStream=new FS.FSStream;for(var p in stream){newStream[p]=stream[p]}stream=newStream;var fd=FS.nextfd(fd_start,fd_end);stream.fd=fd;FS.streams[fd]=stream;return stream}),closeStream:(function(fd){FS.streams[fd]=null}),chrdev_stream_ops:{open:(function(stream){var device=FS.getDevice(stream.node.rdev);stream.stream_ops=device.stream_ops;if(stream.stream_ops.open){stream.stream_ops.open(stream)}}),llseek:(function(){throw new FS.ErrnoError(ERRNO_CODES.ESPIPE)})},major:(function(dev){return dev>>8}),minor:(function(dev){return dev&255}),makedev:(function(ma,mi){return ma<<8|mi}),registerDevice:(function(dev,ops){FS.devices[dev]={stream_ops:ops}}),getDevice:(function(dev){return FS.devices[dev]}),getMounts:(function(mount){var mounts=[];var check=[mount];while(check.length){var m=check.pop();mounts.push(m);check.push.apply(check,m.mounts)}return mounts}),syncfs:(function(populate,callback){if(typeof populate==="function"){callback=populate;populate=false}FS.syncFSRequests++;if(FS.syncFSRequests>1){console.log("warning: "+FS.syncFSRequests+" FS.syncfs operations in flight at once, probably just doing extra work")}var mounts=FS.getMounts(FS.root.mount);var completed=0;function doCallback(err){assert(FS.syncFSRequests>0);FS.syncFSRequests--;return callback(err)}function done(err){if(err){if(!done.errored){done.errored=true;return doCallback(err)}return}if(++completed>=mounts.length){doCallback(null)}}mounts.forEach((function(mount){if(!mount.type.syncfs){return done(null)}mount.type.syncfs(mount,populate,done)}))}),mount:(function(type,opts,mountpoint){var root=mountpoint==="/";var pseudo=!mountpoint;var node;if(root&&FS.root){throw new FS.ErrnoError(ERRNO_CODES.EBUSY)}else if(!root&&!pseudo){var lookup=FS.lookupPath(mountpoint,{follow_mount:false});mountpoint=lookup.path;node=lookup.node;if(FS.isMountpoint(node)){throw new FS.ErrnoError(ERRNO_CODES.EBUSY)}if(!FS.isDir(node.mode)){throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR)}}var mount={type:type,opts:opts,mountpoint:mountpoint,mounts:[]};var mountRoot=type.mount(mount);mountRoot.mount=mount;mount.root=mountRoot;if(root){FS.root=mountRoot}else if(node){node.mounted=mount;if(node.mount){node.mount.mounts.push(mount)}}return mountRoot}),unmount:(function(mountpoint){var lookup=FS.lookupPath(mountpoint,{follow_mount:false});if(!FS.isMountpoint(lookup.node)){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}var node=lookup.node;var mount=node.mounted;var mounts=FS.getMounts(mount);Object.keys(FS.nameTable).forEach((function(hash){var current=FS.nameTable[hash];while(current){var next=current.name_next;if(mounts.indexOf(current.mount)!==-1){FS.destroyNode(current)}current=next}}));node.mounted=null;var idx=node.mount.mounts.indexOf(mount);assert(idx!==-1);node.mount.mounts.splice(idx,1)}),lookup:(function(parent,name){return parent.node_ops.lookup(parent,name)}),mknod:(function(path,mode,dev){var lookup=FS.lookupPath(path,{parent:true});var parent=lookup.node;var name=PATH.basename(path);if(!name||name==="."||name===".."){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}var err=FS.mayCreate(parent,name);if(err){throw new FS.ErrnoError(err)}if(!parent.node_ops.mknod){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}return parent.node_ops.mknod(parent,name,mode,dev)}),create:(function(path,mode){mode=mode!==undefined?mode:438;mode&=4095;mode|=32768;return FS.mknod(path,mode,0)}),mkdir:(function(path,mode){mode=mode!==undefined?mode:511;mode&=511|512;mode|=16384;return FS.mknod(path,mode,0)}),mkdev:(function(path,mode,dev){if(typeof dev==="undefined"){dev=mode;mode=438}mode|=8192;return FS.mknod(path,mode,dev)}),symlink:(function(oldpath,newpath){if(!PATH.resolve(oldpath)){throw new FS.ErrnoError(ERRNO_CODES.ENOENT)}var lookup=FS.lookupPath(newpath,{parent:true});var parent=lookup.node;if(!parent){throw new FS.ErrnoError(ERRNO_CODES.ENOENT)}var newname=PATH.basename(newpath);var err=FS.mayCreate(parent,newname);if(err){throw new FS.ErrnoError(err)}if(!parent.node_ops.symlink){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}return parent.node_ops.symlink(parent,newname,oldpath)}),rename:(function(old_path,new_path){var old_dirname=PATH.dirname(old_path);var new_dirname=PATH.dirname(new_path);var old_name=PATH.basename(old_path);var new_name=PATH.basename(new_path);var lookup,old_dir,new_dir;try{lookup=FS.lookupPath(old_path,{parent:true});old_dir=lookup.node;lookup=FS.lookupPath(new_path,{parent:true});new_dir=lookup.node}catch(e){throw new FS.ErrnoError(ERRNO_CODES.EBUSY)}if(!old_dir||!new_dir)throw new FS.ErrnoError(ERRNO_CODES.ENOENT);if(old_dir.mount!==new_dir.mount){throw new FS.ErrnoError(ERRNO_CODES.EXDEV)}var old_node=FS.lookupNode(old_dir,old_name);var relative=PATH.relative(old_path,new_dirname);if(relative.charAt(0)!=="."){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}relative=PATH.relative(new_path,old_dirname);if(relative.charAt(0)!=="."){throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY)}var new_node;try{new_node=FS.lookupNode(new_dir,new_name)}catch(e){}if(old_node===new_node){return}var isdir=FS.isDir(old_node.mode);var err=FS.mayDelete(old_dir,old_name,isdir);if(err){throw new FS.ErrnoError(err)}err=new_node?FS.mayDelete(new_dir,new_name,isdir):FS.mayCreate(new_dir,new_name);if(err){throw new FS.ErrnoError(err)}if(!old_dir.node_ops.rename){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}if(FS.isMountpoint(old_node)||new_node&&FS.isMountpoint(new_node)){throw new FS.ErrnoError(ERRNO_CODES.EBUSY)}if(new_dir!==old_dir){err=FS.nodePermissions(old_dir,"w");if(err){throw new FS.ErrnoError(err)}}try{if(FS.trackingDelegate["willMovePath"]){FS.trackingDelegate["willMovePath"](old_path,new_path)}}catch(e){console.log("FS.trackingDelegate['willMovePath']('"+old_path+"', '"+new_path+"') threw an exception: "+e.message)}FS.hashRemoveNode(old_node);try{old_dir.node_ops.rename(old_node,new_dir,new_name)}catch(e){throw e}finally{FS.hashAddNode(old_node)}try{if(FS.trackingDelegate["onMovePath"])FS.trackingDelegate["onMovePath"](old_path,new_path)}catch(e){console.log("FS.trackingDelegate['onMovePath']('"+old_path+"', '"+new_path+"') threw an exception: "+e.message)}}),rmdir:(function(path){var lookup=FS.lookupPath(path,{parent:true});var parent=lookup.node;var name=PATH.basename(path);var node=FS.lookupNode(parent,name);var err=FS.mayDelete(parent,name,true);if(err){throw new FS.ErrnoError(err)}if(!parent.node_ops.rmdir){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}if(FS.isMountpoint(node)){throw new FS.ErrnoError(ERRNO_CODES.EBUSY)}try{if(FS.trackingDelegate["willDeletePath"]){FS.trackingDelegate["willDeletePath"](path)}}catch(e){console.log("FS.trackingDelegate['willDeletePath']('"+path+"') threw an exception: "+e.message)}parent.node_ops.rmdir(parent,name);FS.destroyNode(node);try{if(FS.trackingDelegate["onDeletePath"])FS.trackingDelegate["onDeletePath"](path)}catch(e){console.log("FS.trackingDelegate['onDeletePath']('"+path+"') threw an exception: "+e.message)}}),readdir:(function(path){var lookup=FS.lookupPath(path,{follow:true});var node=lookup.node;if(!node.node_ops.readdir){throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR)}return node.node_ops.readdir(node)}),unlink:(function(path){var lookup=FS.lookupPath(path,{parent:true});var parent=lookup.node;var name=PATH.basename(path);var node=FS.lookupNode(parent,name);var err=FS.mayDelete(parent,name,false);if(err){if(err===ERRNO_CODES.EISDIR)err=ERRNO_CODES.EPERM;throw new FS.ErrnoError(err)}if(!parent.node_ops.unlink){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}if(FS.isMountpoint(node)){throw new FS.ErrnoError(ERRNO_CODES.EBUSY)}try{if(FS.trackingDelegate["willDeletePath"]){FS.trackingDelegate["willDeletePath"](path)}}catch(e){console.log("FS.trackingDelegate['willDeletePath']('"+path+"') threw an exception: "+e.message)}parent.node_ops.unlink(parent,name);FS.destroyNode(node);try{if(FS.trackingDelegate["onDeletePath"])FS.trackingDelegate["onDeletePath"](path)}catch(e){console.log("FS.trackingDelegate['onDeletePath']('"+path+"') threw an exception: "+e.message)}}),readlink:(function(path){var lookup=FS.lookupPath(path);var link=lookup.node;if(!link){throw new FS.ErrnoError(ERRNO_CODES.ENOENT)}if(!link.node_ops.readlink){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}return PATH.resolve(FS.getPath(link.parent),link.node_ops.readlink(link))}),stat:(function(path,dontFollow){var lookup=FS.lookupPath(path,{follow:!dontFollow});var node=lookup.node;if(!node){throw new FS.ErrnoError(ERRNO_CODES.ENOENT)}if(!node.node_ops.getattr){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}return node.node_ops.getattr(node)}),lstat:(function(path){return FS.stat(path,true)}),chmod:(function(path,mode,dontFollow){var node;if(typeof path==="string"){var lookup=FS.lookupPath(path,{follow:!dontFollow});node=lookup.node}else{node=path}if(!node.node_ops.setattr){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}node.node_ops.setattr(node,{mode:mode&4095|node.mode&~4095,timestamp:Date.now()})}),lchmod:(function(path,mode){FS.chmod(path,mode,true)}),fchmod:(function(fd,mode){var stream=FS.getStream(fd);if(!stream){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}FS.chmod(stream.node,mode)}),chown:(function(path,uid,gid,dontFollow){var node;if(typeof path==="string"){var lookup=FS.lookupPath(path,{follow:!dontFollow});node=lookup.node}else{node=path}if(!node.node_ops.setattr){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}node.node_ops.setattr(node,{timestamp:Date.now()})}),lchown:(function(path,uid,gid){FS.chown(path,uid,gid,true)}),fchown:(function(fd,uid,gid){var stream=FS.getStream(fd);if(!stream){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}FS.chown(stream.node,uid,gid)}),truncate:(function(path,len){if(len<0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}var node;if(typeof path==="string"){var lookup=FS.lookupPath(path,{follow:true});node=lookup.node}else{node=path}if(!node.node_ops.setattr){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}if(FS.isDir(node.mode)){throw new FS.ErrnoError(ERRNO_CODES.EISDIR)}if(!FS.isFile(node.mode)){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}var err=FS.nodePermissions(node,"w");if(err){throw new FS.ErrnoError(err)}node.node_ops.setattr(node,{size:len,timestamp:Date.now()})}),ftruncate:(function(fd,len){var stream=FS.getStream(fd);if(!stream){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}if((stream.flags&2097155)===0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}FS.truncate(stream.node,len)}),utime:(function(path,atime,mtime){var lookup=FS.lookupPath(path,{follow:true});var node=lookup.node;node.node_ops.setattr(node,{timestamp:Math.max(atime,mtime)})}),open:(function(path,flags,mode,fd_start,fd_end){if(path===""){throw new FS.ErrnoError(ERRNO_CODES.ENOENT)}flags=typeof flags==="string"?FS.modeStringToFlags(flags):flags;mode=typeof mode==="undefined"?438:mode;if(flags&64){mode=mode&4095|32768}else{mode=0}var node;if(typeof path==="object"){node=path}else{path=PATH.normalize(path);try{var lookup=FS.lookupPath(path,{follow:!(flags&131072)});node=lookup.node}catch(e){}}var created=false;if(flags&64){if(node){if(flags&128){throw new FS.ErrnoError(ERRNO_CODES.EEXIST)}}else{node=FS.mknod(path,mode,0);created=true}}if(!node){throw new FS.ErrnoError(ERRNO_CODES.ENOENT)}if(FS.isChrdev(node.mode)){flags&=~512}if(flags&65536&&!FS.isDir(node.mode)){throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR)}if(!created){var err=FS.mayOpen(node,flags);if(err){throw new FS.ErrnoError(err)}}if(flags&512){FS.truncate(node,0)}flags&=~(128|512);var stream=FS.createStream({node:node,path:FS.getPath(node),flags:flags,seekable:true,position:0,stream_ops:node.stream_ops,ungotten:[],error:false},fd_start,fd_end);if(stream.stream_ops.open){stream.stream_ops.open(stream)}if(Module["logReadFiles"]&&!(flags&1)){if(!FS.readFiles)FS.readFiles={};if(!(path in FS.readFiles)){FS.readFiles[path]=1;Module["printErr"]("read file: "+path)}}try{if(FS.trackingDelegate["onOpenFile"]){var trackingFlags=0;if((flags&2097155)!==1){trackingFlags|=FS.tracking.openFlags.READ}if((flags&2097155)!==0){trackingFlags|=FS.tracking.openFlags.WRITE}FS.trackingDelegate["onOpenFile"](path,trackingFlags)}}catch(e){console.log("FS.trackingDelegate['onOpenFile']('"+path+"', flags) threw an exception: "+e.message)}return stream}),close:(function(stream){if(stream.getdents)stream.getdents=null;try{if(stream.stream_ops.close){stream.stream_ops.close(stream)}}catch(e){throw e}finally{FS.closeStream(stream.fd)}}),llseek:(function(stream,offset,whence){if(!stream.seekable||!stream.stream_ops.llseek){throw new FS.ErrnoError(ERRNO_CODES.ESPIPE)}stream.position=stream.stream_ops.llseek(stream,offset,whence);stream.ungotten=[];return stream.position}),read:(function(stream,buffer,offset,length,position){if(length<0||position<0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}if((stream.flags&2097155)===1){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}if(FS.isDir(stream.node.mode)){throw new FS.ErrnoError(ERRNO_CODES.EISDIR)}if(!stream.stream_ops.read){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}var seeking=true;if(typeof position==="undefined"){position=stream.position;seeking=false}else if(!stream.seekable){throw new FS.ErrnoError(ERRNO_CODES.ESPIPE)}var bytesRead=stream.stream_ops.read(stream,buffer,offset,length,position);if(!seeking)stream.position+=bytesRead;return bytesRead}),write:(function(stream,buffer,offset,length,position,canOwn){if(length<0||position<0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}if((stream.flags&2097155)===0){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}if(FS.isDir(stream.node.mode)){throw new FS.ErrnoError(ERRNO_CODES.EISDIR)}if(!stream.stream_ops.write){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}if(stream.flags&1024){FS.llseek(stream,0,2)}var seeking=true;if(typeof position==="undefined"){position=stream.position;seeking=false}else if(!stream.seekable){throw new FS.ErrnoError(ERRNO_CODES.ESPIPE)}var bytesWritten=stream.stream_ops.write(stream,buffer,offset,length,position,canOwn);if(!seeking)stream.position+=bytesWritten;try{if(stream.path&&FS.trackingDelegate["onWriteToFile"])FS.trackingDelegate["onWriteToFile"](stream.path)}catch(e){console.log("FS.trackingDelegate['onWriteToFile']('"+path+"') threw an exception: "+e.message)}return bytesWritten}),allocate:(function(stream,offset,length){if(offset<0||length<=0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}if((stream.flags&2097155)===0){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}if(!FS.isFile(stream.node.mode)&&!FS.isDir(node.mode)){throw new FS.ErrnoError(ERRNO_CODES.ENODEV)}if(!stream.stream_ops.allocate){throw new FS.ErrnoError(ERRNO_CODES.EOPNOTSUPP)}stream.stream_ops.allocate(stream,offset,length)}),mmap:(function(stream,buffer,offset,length,position,prot,flags){if((stream.flags&2097155)===1){throw new FS.ErrnoError(ERRNO_CODES.EACCES)}if(!stream.stream_ops.mmap){throw new FS.ErrnoError(ERRNO_CODES.ENODEV)}return stream.stream_ops.mmap(stream,buffer,offset,length,position,prot,flags)}),msync:(function(stream,buffer,offset,length,mmapFlags){if(!stream||!stream.stream_ops.msync){return 0}return stream.stream_ops.msync(stream,buffer,offset,length,mmapFlags)}),munmap:(function(stream){return 0}),ioctl:(function(stream,cmd,arg){if(!stream.stream_ops.ioctl){throw new FS.ErrnoError(ERRNO_CODES.ENOTTY)}return stream.stream_ops.ioctl(stream,cmd,arg)}),readFile:(function(path,opts){opts=opts||{};opts.flags=opts.flags||"r";opts.encoding=opts.encoding||"binary";if(opts.encoding!=="utf8"&&opts.encoding!=="binary"){throw new Error('Invalid encoding type "'+opts.encoding+'"')}var ret;var stream=FS.open(path,opts.flags);var stat=FS.stat(path);var length=stat.size;var buf=new Uint8Array(length);FS.read(stream,buf,0,length,0);if(opts.encoding==="utf8"){ret=UTF8ArrayToString(buf,0)}else if(opts.encoding==="binary"){ret=buf}FS.close(stream);return ret}),writeFile:(function(path,data,opts){opts=opts||{};opts.flags=opts.flags||"w";opts.encoding=opts.encoding||"utf8";if(opts.encoding!=="utf8"&&opts.encoding!=="binary"){throw new Error('Invalid encoding type "'+opts.encoding+'"')}var stream=FS.open(path,opts.flags,opts.mode);if(opts.encoding==="utf8"){var buf=new Uint8Array(lengthBytesUTF8(data)+1);var actualNumBytes=stringToUTF8Array(data,buf,0,buf.length);FS.write(stream,buf,0,actualNumBytes,0,opts.canOwn)}else if(opts.encoding==="binary"){FS.write(stream,data,0,data.length,0,opts.canOwn)}FS.close(stream)}),cwd:(function(){return FS.currentPath}),chdir:(function(path){var lookup=FS.lookupPath(path,{follow:true});if(!FS.isDir(lookup.node.mode)){throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR)}var err=FS.nodePermissions(lookup.node,"x");if(err){throw new FS.ErrnoError(err)}FS.currentPath=lookup.path}),createDefaultDirectories:(function(){FS.mkdir("/tmp");FS.mkdir("/home");FS.mkdir("/home/web_user")}),createDefaultDevices:(function(){FS.mkdir("/dev");FS.registerDevice(FS.makedev(1,3),{read:(function(){return 0}),write:(function(stream,buffer,offset,length,pos){return length})});FS.mkdev("/dev/null",FS.makedev(1,3));TTY.register(FS.makedev(5,0),TTY.default_tty_ops);TTY.register(FS.makedev(6,0),TTY.default_tty1_ops);FS.mkdev("/dev/tty",FS.makedev(5,0));FS.mkdev("/dev/tty1",FS.makedev(6,0));var random_device;if(typeof crypto!=="undefined"){var randomBuffer=new Uint8Array(1);random_device=(function(){crypto.getRandomValues(randomBuffer);return randomBuffer[0]})}else if(ENVIRONMENT_IS_NODE){random_device=(function(){return require("crypto").randomBytes(1)[0]})}else{random_device=(function(){return Math.random()*256|0})}FS.createDevice("/dev","random",random_device);FS.createDevice("/dev","urandom",random_device);FS.mkdir("/dev/shm");FS.mkdir("/dev/shm/tmp")}),createSpecialDirectories:(function(){FS.mkdir("/proc");FS.mkdir("/proc/self");FS.mkdir("/proc/self/fd");FS.mount({mount:(function(){var node=FS.createNode("/proc/self","fd",16384|511,73);node.node_ops={lookup:(function(parent,name){var fd=+name;var stream=FS.getStream(fd);if(!stream)throw new FS.ErrnoError(ERRNO_CODES.EBADF);var ret={parent:null,mount:{mountpoint:"fake"},node_ops:{readlink:(function(){return stream.path})}};ret.parent=ret;return ret})};return node})},{},"/proc/self/fd")}),createStandardStreams:(function(){if(Module["stdin"]){FS.createDevice("/dev","stdin",Module["stdin"])}else{FS.symlink("/dev/tty","/dev/stdin")}if(Module["stdout"]){FS.createDevice("/dev","stdout",null,Module["stdout"])}else{FS.symlink("/dev/tty","/dev/stdout")}if(Module["stderr"]){FS.createDevice("/dev","stderr",null,Module["stderr"])}else{FS.symlink("/dev/tty1","/dev/stderr")}var stdin=FS.open("/dev/stdin","r");assert(stdin.fd===0,"invalid handle for stdin ("+stdin.fd+")");var stdout=FS.open("/dev/stdout","w");assert(stdout.fd===1,"invalid handle for stdout ("+stdout.fd+")");var stderr=FS.open("/dev/stderr","w");assert(stderr.fd===2,"invalid handle for stderr ("+stderr.fd+")")}),ensureErrnoError:(function(){if(FS.ErrnoError)return;FS.ErrnoError=function ErrnoError(errno,node){this.node=node;this.setErrno=(function(errno){this.errno=errno;for(var key in ERRNO_CODES){if(ERRNO_CODES[key]===errno){this.code=key;break}}});this.setErrno(errno);this.message=ERRNO_MESSAGES[errno]};FS.ErrnoError.prototype=new Error;FS.ErrnoError.prototype.constructor=FS.ErrnoError;[ERRNO_CODES.ENOENT].forEach((function(code){FS.genericErrors[code]=new FS.ErrnoError(code);FS.genericErrors[code].stack="<generic error, no stack>"}))}),staticInit:(function(){FS.ensureErrnoError();FS.nameTable=new Array(4096);FS.mount(MEMFS,{},"/");FS.createDefaultDirectories();FS.createDefaultDevices();FS.createSpecialDirectories();FS.filesystems={"MEMFS":MEMFS,"IDBFS":IDBFS,"NODEFS":NODEFS,"WORKERFS":WORKERFS}}),init:(function(input,output,error){assert(!FS.init.initialized,"FS.init was previously called. If you want to initialize later with custom parameters, remove any earlier calls (note that one is automatically added to the generated code)");FS.init.initialized=true;FS.ensureErrnoError();Module["stdin"]=input||Module["stdin"];Module["stdout"]=output||Module["stdout"];Module["stderr"]=error||Module["stderr"];FS.createStandardStreams()}),quit:(function(){FS.init.initialized=false;var fflush=Module["_fflush"];if(fflush)fflush(0);for(var i=0;i<FS.streams.length;i++){var stream=FS.streams[i];if(!stream){continue}FS.close(stream)}}),getMode:(function(canRead,canWrite){var mode=0;if(canRead)mode|=292|73;if(canWrite)mode|=146;return mode}),joinPath:(function(parts,forceRelative){var path=PATH.join.apply(null,parts);if(forceRelative&&path[0]=="/")path=path.substr(1);return path}),absolutePath:(function(relative,base){return PATH.resolve(base,relative)}),standardizePath:(function(path){return PATH.normalize(path)}),findObject:(function(path,dontResolveLastLink){var ret=FS.analyzePath(path,dontResolveLastLink);if(ret.exists){return ret.object}else{___setErrNo(ret.error);return null}}),analyzePath:(function(path,dontResolveLastLink){try{var lookup=FS.lookupPath(path,{follow:!dontResolveLastLink});path=lookup.path}catch(e){}var ret={isRoot:false,exists:false,error:0,name:null,path:null,object:null,parentExists:false,parentPath:null,parentObject:null};try{var lookup=FS.lookupPath(path,{parent:true});ret.parentExists=true;ret.parentPath=lookup.path;ret.parentObject=lookup.node;ret.name=PATH.basename(path);lookup=FS.lookupPath(path,{follow:!dontResolveLastLink});ret.exists=true;ret.path=lookup.path;ret.object=lookup.node;ret.name=lookup.node.name;ret.isRoot=lookup.path==="/"}catch(e){ret.error=e.errno}return ret}),createFolder:(function(parent,name,canRead,canWrite){var path=PATH.join2(typeof parent==="string"?parent:FS.getPath(parent),name);var mode=FS.getMode(canRead,canWrite);return FS.mkdir(path,mode)}),createPath:(function(parent,path,canRead,canWrite){parent=typeof parent==="string"?parent:FS.getPath(parent);var parts=path.split("/").reverse();while(parts.length){var part=parts.pop();if(!part)continue;var current=PATH.join2(parent,part);try{FS.mkdir(current)}catch(e){}parent=current}return current}),createFile:(function(parent,name,properties,canRead,canWrite){var path=PATH.join2(typeof parent==="string"?parent:FS.getPath(parent),name);var mode=FS.getMode(canRead,canWrite);return FS.create(path,mode)}),createDataFile:(function(parent,name,data,canRead,canWrite,canOwn){var path=name?PATH.join2(typeof parent==="string"?parent:FS.getPath(parent),name):parent;var mode=FS.getMode(canRead,canWrite);var node=FS.create(path,mode);if(data){if(typeof data==="string"){var arr=new Array(data.length);for(var i=0,len=data.length;i<len;++i)arr[i]=data.charCodeAt(i);data=arr}FS.chmod(node,mode|146);var stream=FS.open(node,"w");FS.write(stream,data,0,data.length,0,canOwn);FS.close(stream);FS.chmod(node,mode)}return node}),createDevice:(function(parent,name,input,output){var path=PATH.join2(typeof parent==="string"?parent:FS.getPath(parent),name);var mode=FS.getMode(!!input,!!output);if(!FS.createDevice.major)FS.createDevice.major=64;var dev=FS.makedev(FS.createDevice.major++,0);FS.registerDevice(dev,{open:(function(stream){stream.seekable=false}),close:(function(stream){if(output&&output.buffer&&output.buffer.length){output(10)}}),read:(function(stream,buffer,offset,length,pos){var bytesRead=0;for(var i=0;i<length;i++){var result;try{result=input()}catch(e){throw new FS.ErrnoError(ERRNO_CODES.EIO)}if(result===undefined&&bytesRead===0){throw new FS.ErrnoError(ERRNO_CODES.EAGAIN)}if(result===null||result===undefined)break;bytesRead++;buffer[offset+i]=result}if(bytesRead){stream.node.timestamp=Date.now()}return bytesRead}),write:(function(stream,buffer,offset,length,pos){for(var i=0;i<length;i++){try{output(buffer[offset+i])}catch(e){throw new FS.ErrnoError(ERRNO_CODES.EIO)}}if(length){stream.node.timestamp=Date.now()}return i})});return FS.mkdev(path,mode,dev)}),createLink:(function(parent,name,target,canRead,canWrite){var path=PATH.join2(typeof parent==="string"?parent:FS.getPath(parent),name);return FS.symlink(target,path)}),forceLoadFile:(function(obj){if(obj.isDevice||obj.isFolder||obj.link||obj.contents)return true;var success=true;if(typeof XMLHttpRequest!=="undefined"){throw new Error("Lazy loading should have been performed (contents set) in createLazyFile, but it was not. Lazy loading only works in web workers. Use --embed-file or --preload-file in emcc on the main thread.")}else if(Module["read"]){try{obj.contents=intArrayFromString(Module["read"](obj.url),true);obj.usedBytes=obj.contents.length}catch(e){success=false}}else{throw new Error("Cannot load without read() or XMLHttpRequest.")}if(!success)___setErrNo(ERRNO_CODES.EIO);return success}),createLazyFile:(function(parent,name,url,canRead,canWrite){function LazyUint8Array(){this.lengthKnown=false;this.chunks=[]}LazyUint8Array.prototype.get=function LazyUint8Array_get(idx){if(idx>this.length-1||idx<0){return undefined}var chunkOffset=idx%this.chunkSize;var chunkNum=idx/this.chunkSize|0;return this.getter(chunkNum)[chunkOffset]};LazyUint8Array.prototype.setDataGetter=function LazyUint8Array_setDataGetter(getter){this.getter=getter};LazyUint8Array.prototype.cacheLength=function LazyUint8Array_cacheLength(){var xhr=new XMLHttpRequest;xhr.open("HEAD",url,false);xhr.send(null);if(!(xhr.status>=200&&xhr.status<300||xhr.status===304))throw new Error("Couldn't load "+url+". Status: "+xhr.status);var datalength=Number(xhr.getResponseHeader("Content-length"));var header;var hasByteServing=(header=xhr.getResponseHeader("Accept-Ranges"))&&header==="bytes";var usesGzip=(header=xhr.getResponseHeader("Content-Encoding"))&&header==="gzip";var chunkSize=1024*1024;if(!hasByteServing)chunkSize=datalength;var doXHR=(function(from,to){if(from>to)throw new Error("invalid range ("+from+", "+to+") or no bytes requested!");if(to>datalength-1)throw new Error("only "+datalength+" bytes available! programmer error!");var xhr=new XMLHttpRequest;xhr.open("GET",url,false);if(datalength!==chunkSize)xhr.setRequestHeader("Range","bytes="+from+"-"+to);if(typeof Uint8Array!="undefined")xhr.responseType="arraybuffer";if(xhr.overrideMimeType){xhr.overrideMimeType("text/plain; charset=x-user-defined")}xhr.send(null);if(!(xhr.status>=200&&xhr.status<300||xhr.status===304))throw new Error("Couldn't load "+url+". Status: "+xhr.status);if(xhr.response!==undefined){return new Uint8Array(xhr.response||[])}else{return intArrayFromString(xhr.responseText||"",true)}});var lazyArray=this;lazyArray.setDataGetter((function(chunkNum){var start=chunkNum*chunkSize;var end=(chunkNum+1)*chunkSize-1;end=Math.min(end,datalength-1);if(typeof lazyArray.chunks[chunkNum]==="undefined"){lazyArray.chunks[chunkNum]=doXHR(start,end)}if(typeof lazyArray.chunks[chunkNum]==="undefined")throw new Error("doXHR failed!");return lazyArray.chunks[chunkNum]}));if(usesGzip||!datalength){chunkSize=datalength=1;datalength=this.getter(0).length;chunkSize=datalength;console.log("LazyFiles on gzip forces download of the whole file when length is accessed")}this._length=datalength;this._chunkSize=chunkSize;this.lengthKnown=true};if(typeof XMLHttpRequest!=="undefined"){if(!ENVIRONMENT_IS_WORKER)throw"Cannot do synchronous binary XHRs outside webworkers in modern browsers. Use --embed-file or --preload-file in emcc";var lazyArray=new LazyUint8Array;Object.defineProperties(lazyArray,{length:{get:(function(){if(!this.lengthKnown){this.cacheLength()}return this._length})},chunkSize:{get:(function(){if(!this.lengthKnown){this.cacheLength()}return this._chunkSize})}});var properties={isDevice:false,contents:lazyArray}}else{var properties={isDevice:false,url:url}}var node=FS.createFile(parent,name,properties,canRead,canWrite);if(properties.contents){node.contents=properties.contents}else if(properties.url){node.contents=null;node.url=properties.url}Object.defineProperties(node,{usedBytes:{get:(function(){return this.contents.length})}});var stream_ops={};var keys=Object.keys(node.stream_ops);keys.forEach((function(key){var fn=node.stream_ops[key];stream_ops[key]=function forceLoadLazyFile(){if(!FS.forceLoadFile(node)){throw new FS.ErrnoError(ERRNO_CODES.EIO)}return fn.apply(null,arguments)}}));stream_ops.read=function stream_ops_read(stream,buffer,offset,length,position){if(!FS.forceLoadFile(node)){throw new FS.ErrnoError(ERRNO_CODES.EIO)}var contents=stream.node.contents;if(position>=contents.length)return 0;var size=Math.min(contents.length-position,length);assert(size>=0);if(contents.slice){for(var i=0;i<size;i++){buffer[offset+i]=contents[position+i]}}else{for(var i=0;i<size;i++){buffer[offset+i]=contents.get(position+i)}}return size};node.stream_ops=stream_ops;return node}),createPreloadedFile:(function(parent,name,url,canRead,canWrite,onload,onerror,dontCreateFile,canOwn,preFinish){Browser.init();var fullname=name?PATH.resolve(PATH.join2(parent,name)):parent;var dep=getUniqueRunDependency("cp "+fullname);function processData(byteArray){function finish(byteArray){if(preFinish)preFinish();if(!dontCreateFile){FS.createDataFile(parent,name,byteArray,canRead,canWrite,canOwn)}if(onload)onload();removeRunDependency(dep)}var handled=false;Module["preloadPlugins"].forEach((function(plugin){if(handled)return;if(plugin["canHandle"](fullname)){plugin["handle"](byteArray,fullname,finish,(function(){if(onerror)onerror();removeRunDependency(dep)}));handled=true}}));if(!handled)finish(byteArray)}addRunDependency(dep);if(typeof url=="string"){Browser.asyncLoad(url,(function(byteArray){processData(byteArray)}),onerror)}else{processData(url)}}),indexedDB:(function(){return window.indexedDB||window.mozIndexedDB||window.webkitIndexedDB||window.msIndexedDB}),DB_NAME:(function(){return"EM_FS_"+window.location.pathname}),DB_VERSION:20,DB_STORE_NAME:"FILE_DATA",saveFilesToDB:(function(paths,onload,onerror){onload=onload||(function(){});onerror=onerror||(function(){});var indexedDB=FS.indexedDB();try{var openRequest=indexedDB.open(FS.DB_NAME(),FS.DB_VERSION)}catch(e){return onerror(e)}openRequest.onupgradeneeded=function openRequest_onupgradeneeded(){console.log("creating db");var db=openRequest.result;db.createObjectStore(FS.DB_STORE_NAME)};openRequest.onsuccess=function openRequest_onsuccess(){var db=openRequest.result;var transaction=db.transaction([FS.DB_STORE_NAME],"readwrite");var files=transaction.objectStore(FS.DB_STORE_NAME);var ok=0,fail=0,total=paths.length;function finish(){if(fail==0)onload();else onerror()}paths.forEach((function(path){var putRequest=files.put(FS.analyzePath(path).object.contents,path);putRequest.onsuccess=function putRequest_onsuccess(){ok++;if(ok+fail==total)finish()};putRequest.onerror=function putRequest_onerror(){fail++;if(ok+fail==total)finish()}}));transaction.onerror=onerror};openRequest.onerror=onerror}),loadFilesFromDB:(function(paths,onload,onerror){onload=onload||(function(){});onerror=onerror||(function(){});var indexedDB=FS.indexedDB();try{var openRequest=indexedDB.open(FS.DB_NAME(),FS.DB_VERSION)}catch(e){return onerror(e)}openRequest.onupgradeneeded=onerror;openRequest.onsuccess=function openRequest_onsuccess(){var db=openRequest.result;try{var transaction=db.transaction([FS.DB_STORE_NAME],"readonly")}catch(e){onerror(e);return}var files=transaction.objectStore(FS.DB_STORE_NAME);var ok=0,fail=0,total=paths.length;function finish(){if(fail==0)onload();else onerror()}paths.forEach((function(path){var getRequest=files.get(path);getRequest.onsuccess=function getRequest_onsuccess(){if(FS.analyzePath(path).exists){FS.unlink(path)}FS.createDataFile(PATH.dirname(path),PATH.basename(path),getRequest.result,true,true,true);ok++;if(ok+fail==total)finish()};getRequest.onerror=function getRequest_onerror(){fail++;if(ok+fail==total)finish()}}));transaction.onerror=onerror};openRequest.onerror=onerror})};var SYSCALLS={DEFAULT_POLLMASK:5,mappings:{},umask:511,calculateAt:(function(dirfd,path){if(path[0]!=="/"){var dir;if(dirfd===-100){dir=FS.cwd()}else{var dirstream=FS.getStream(dirfd);if(!dirstream)throw new FS.ErrnoError(ERRNO_CODES.EBADF);dir=dirstream.path}path=PATH.join2(dir,path)}return path}),doStat:(function(func,path,buf){try{var stat=func(path)}catch(e){if(e&&e.node&&PATH.normalize(path)!==PATH.normalize(FS.getPath(e.node))){return-ERRNO_CODES.ENOTDIR}throw e}HEAP32[buf>>2]=stat.dev;HEAP32[buf+4>>2]=0;HEAP32[buf+8>>2]=stat.ino;HEAP32[buf+12>>2]=stat.mode;HEAP32[buf+16>>2]=stat.nlink;HEAP32[buf+20>>2]=stat.uid;HEAP32[buf+24>>2]=stat.gid;HEAP32[buf+28>>2]=stat.rdev;HEAP32[buf+32>>2]=0;HEAP32[buf+36>>2]=stat.size;HEAP32[buf+40>>2]=4096;HEAP32[buf+44>>2]=stat.blocks;HEAP32[buf+48>>2]=stat.atime.getTime()/1e3|0;HEAP32[buf+52>>2]=0;HEAP32[buf+56>>2]=stat.mtime.getTime()/1e3|0;HEAP32[buf+60>>2]=0;HEAP32[buf+64>>2]=stat.ctime.getTime()/1e3|0;HEAP32[buf+68>>2]=0;HEAP32[buf+72>>2]=stat.ino;return 0}),doMsync:(function(addr,stream,len,flags){var buffer=new Uint8Array(HEAPU8.subarray(addr,addr+len));FS.msync(stream,buffer,0,len,flags)}),doMkdir:(function(path,mode){path=PATH.normalize(path);if(path[path.length-1]==="/")path=path.substr(0,path.length-1);FS.mkdir(path,mode,0);return 0}),doMknod:(function(path,mode,dev){switch(mode&61440){case 32768:case 8192:case 24576:case 4096:case 49152:break;default:return-ERRNO_CODES.EINVAL}FS.mknod(path,mode,dev);return 0}),doReadlink:(function(path,buf,bufsize){if(bufsize<=0)return-ERRNO_CODES.EINVAL;var ret=FS.readlink(path);ret=ret.slice(0,Math.max(0,bufsize));writeStringToMemory(ret,buf,true);return ret.length}),doAccess:(function(path,amode){if(amode&~7){return-ERRNO_CODES.EINVAL}var node;var lookup=FS.lookupPath(path,{follow:true});node=lookup.node;var perms="";if(amode&4)perms+="r";if(amode&2)perms+="w";if(amode&1)perms+="x";if(perms&&FS.nodePermissions(node,perms)){return-ERRNO_CODES.EACCES}return 0}),doDup:(function(path,flags,suggestFD){var suggest=FS.getStream(suggestFD);if(suggest)FS.close(suggest);return FS.open(path,flags,0,suggestFD,suggestFD).fd}),doReadv:(function(stream,iov,iovcnt,offset){var ret=0;for(var i=0;i<iovcnt;i++){var ptr=HEAP32[iov+i*8>>2];var len=HEAP32[iov+(i*8+4)>>2];var curr=FS.read(stream,HEAP8,ptr,len,offset);if(curr<0)return-1;ret+=curr;if(curr<len)break}return ret}),doWritev:(function(stream,iov,iovcnt,offset){var ret=0;for(var i=0;i<iovcnt;i++){var ptr=HEAP32[iov+i*8>>2];var len=HEAP32[iov+(i*8+4)>>2];var curr=FS.write(stream,HEAP8,ptr,len,offset);if(curr<0)return-1;ret+=curr}return ret}),varargs:0,get:(function(varargs){SYSCALLS.varargs+=4;var ret=HEAP32[SYSCALLS.varargs-4>>2];return ret}),getStr:(function(){var ret=Pointer_stringify(SYSCALLS.get());return ret}),getStreamFromFD:(function(){var stream=FS.getStream(SYSCALLS.get());if(!stream)throw new FS.ErrnoError(ERRNO_CODES.EBADF);return stream}),getSocketFromFD:(function(){var socket=SOCKFS.getSocket(SYSCALLS.get());if(!socket)throw new FS.ErrnoError(ERRNO_CODES.EBADF);return socket}),getSocketAddress:(function(allowNull){var addrp=SYSCALLS.get(),addrlen=SYSCALLS.get();if(allowNull&&addrp===0)return null;var info=__read_sockaddr(addrp,addrlen);if(info.errno)throw new FS.ErrnoError(info.errno);info.addr=DNS.lookup_addr(info.addr)||info.addr;return info}),get64:(function(){var low=SYSCALLS.get(),high=SYSCALLS.get();if(low>=0)assert(high===0);else assert(high===-1);return low}),getZero:(function(){assert(SYSCALLS.get()===0)})};function ___syscall54(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(),op=SYSCALLS.get();switch(op){case 21505:{if(!stream.tty)return-ERRNO_CODES.ENOTTY;return 0};case 21506:{if(!stream.tty)return-ERRNO_CODES.ENOTTY;return 0};case 21519:{if(!stream.tty)return-ERRNO_CODES.ENOTTY;var argp=SYSCALLS.get();HEAP32[argp>>2]=0;return 0};case 21520:{if(!stream.tty)return-ERRNO_CODES.ENOTTY;return-ERRNO_CODES.EINVAL};case 21531:{var argp=SYSCALLS.get();return FS.ioctl(stream,op,argp)};default:abort("bad ioctl syscall "+op)}}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}Module["_i64Add"]=_i64Add;Module["_bitshift64Lshr"]=_bitshift64Lshr;function ___cxa_guard_release(){}function _pthread_cleanup_push(routine,arg){__ATEXIT__.push((function(){Runtime.dynCall("vi",routine,[arg])}));_pthread_cleanup_push.level=__ATEXIT__.length}function _pthread_cond_broadcast(){return 0}function ___cxa_guard_acquire(variable){if(!HEAP8[variable>>0]){HEAP8[variable>>0]=1;return 1}return 0}function _pthread_cleanup_pop(){assert(_pthread_cleanup_push.level==__ATEXIT__.length,"cannot pop if something else added meanwhile!");__ATEXIT__.pop();_pthread_cleanup_push.level=__ATEXIT__.length}function _pthread_join(){}Module["_bitshift64Shl"]=_bitshift64Shl;function ___syscall5(which,varargs){SYSCALLS.varargs=varargs;try{var pathname=SYSCALLS.getStr(),flags=SYSCALLS.get(),mode=SYSCALLS.get();var stream=FS.open(pathname,flags,mode);return stream.fd}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function _emscripten_memcpy_big(dest,src,num){HEAPU8.set(HEAPU8.subarray(src,src+num),dest);return dest}Module["_memcpy"]=_memcpy;function ___syscall6(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD();FS.close(stream);return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}var _llvm_pow_f64=Math_pow;function _sbrk(bytes){var self=_sbrk;if(!self.called){DYNAMICTOP=alignMemoryPage(DYNAMICTOP);self.called=true;assert(Runtime.dynamicAlloc);self.alloc=Runtime.dynamicAlloc;Runtime.dynamicAlloc=(function(){abort("cannot dynamically allocate, sbrk now has control")})}var ret=DYNAMICTOP;if(bytes!=0){var success=self.alloc(bytes);if(!success)return-1>>>0}return ret}Module["_memmove"]=_memmove;function ___cxa_begin_catch(ptr){__ZSt18uncaught_exceptionv.uncaught_exception--;EXCEPTIONS.caught.push(ptr);EXCEPTIONS.addRef(EXCEPTIONS.deAdjust(ptr));return ptr}function ___gxx_personality_v0(){}var cttz_i8=allocate([8,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,6,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,7,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,6,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0],"i8",ALLOC_STATIC);Module["_llvm_cttz_i32"]=_llvm_cttz_i32;function _llvm_cttz_i64(l,h){var ret=_llvm_cttz_i32(l);if(ret==32)ret+=_llvm_cttz_i32(h);return(asm["setTempRet0"](0),ret)|0}function _pthread_cond_wait(){return 0}function _pthread_mutex_unlock(){}Module["_llvm_ctlz_i64"]=_llvm_ctlz_i64;function _time(ptr){var ret=Date.now()/1e3|0;if(ptr){HEAP32[ptr>>2]=ret}return ret}function _pthread_self(){return 0}function ___syscall140(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(),offset_high=SYSCALLS.get(),offset_low=SYSCALLS.get(),result=SYSCALLS.get(),whence=SYSCALLS.get();var offset=offset_low;assert(offset_high===0);FS.llseek(stream,offset,whence);HEAP32[result>>2]=stream.position;if(stream.getdents&&offset===0&&whence===0)stream.getdents=null;return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall145(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(),iov=SYSCALLS.get(),iovcnt=SYSCALLS.get();return SYSCALLS.doReadv(stream,iov,iovcnt)}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall146(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(),iov=SYSCALLS.get(),iovcnt=SYSCALLS.get();return SYSCALLS.doWritev(stream,iov,iovcnt)}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}Module["_round"]=_round;function ___syscall221(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(),cmd=SYSCALLS.get();switch(cmd){case 0:{var arg=SYSCALLS.get();if(arg<0){return-ERRNO_CODES.EINVAL}var newStream;newStream=FS.open(stream.path,stream.flags,0,arg);return newStream.fd};case 1:case 2:return 0;case 3:return stream.flags;case 4:{var arg=SYSCALLS.get();stream.flags|=arg;return 0};case 12:case 12:{var arg=SYSCALLS.get();var offset=0;HEAP16[arg+offset>>1]=2;return 0};case 13:case 14:case 13:case 14:return 0;case 16:case 8:return-ERRNO_CODES.EINVAL;case 9:___setErrNo(ERRNO_CODES.EINVAL);return-1;default:{return-ERRNO_CODES.EINVAL}}}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function _emscripten_set_main_loop_timing(mode,value){Browser.mainLoop.timingMode=mode;Browser.mainLoop.timingValue=value;if(!Browser.mainLoop.func){return 1}if(mode==0){Browser.mainLoop.scheduler=function Browser_mainLoop_scheduler_setTimeout(){setTimeout(Browser.mainLoop.runner,value)};Browser.mainLoop.method="timeout"}else if(mode==1){Browser.mainLoop.scheduler=function Browser_mainLoop_scheduler_rAF(){Browser.requestAnimationFrame(Browser.mainLoop.runner)};Browser.mainLoop.method="rAF"}else if(mode==2){if(!window["setImmediate"]){var setImmediates=[];var emscriptenMainLoopMessageId="__emcc";function Browser_setImmediate_messageHandler(event){if(event.source===window&&event.data===emscriptenMainLoopMessageId){event.stopPropagation();setImmediates.shift()()}}window.addEventListener("message",Browser_setImmediate_messageHandler,true);window["setImmediate"]=function Browser_emulated_setImmediate(func){setImmediates.push(func);window.postMessage(emscriptenMainLoopMessageId,"*")}}Browser.mainLoop.scheduler=function Browser_mainLoop_scheduler_setImmediate(){window["setImmediate"](Browser.mainLoop.runner)};Browser.mainLoop.method="immediate"}return 0}function _emscripten_set_main_loop(func,fps,simulateInfiniteLoop,arg,noSetTiming){Module["noExitRuntime"]=true;assert(!Browser.mainLoop.func,"emscripten_set_main_loop: there can only be one main loop function at once: call emscripten_cancel_main_loop to cancel the previous one before setting a new one with different parameters.");Browser.mainLoop.func=func;Browser.mainLoop.arg=arg;var thisMainLoopId=Browser.mainLoop.currentlyRunningMainloop;Browser.mainLoop.runner=function Browser_mainLoop_runner(){if(ABORT)return;if(Browser.mainLoop.queue.length>0){var start=Date.now();var blocker=Browser.mainLoop.queue.shift();blocker.func(blocker.arg);if(Browser.mainLoop.remainingBlockers){var remaining=Browser.mainLoop.remainingBlockers;var next=remaining%1==0?remaining-1:Math.floor(remaining);if(blocker.counted){Browser.mainLoop.remainingBlockers=next}else{next=next+.5;Browser.mainLoop.remainingBlockers=(8*remaining+next)/9}}console.log('main loop blocker "'+blocker.name+'" took '+(Date.now()-start)+" ms");Browser.mainLoop.updateStatus();if(thisMainLoopId<Browser.mainLoop.currentlyRunningMainloop)return;setTimeout(Browser.mainLoop.runner,0);return}if(thisMainLoopId<Browser.mainLoop.currentlyRunningMainloop)return;Browser.mainLoop.currentFrameNumber=Browser.mainLoop.currentFrameNumber+1|0;if(Browser.mainLoop.timingMode==1&&Browser.mainLoop.timingValue>1&&Browser.mainLoop.currentFrameNumber%Browser.mainLoop.timingValue!=0){Browser.mainLoop.scheduler();return}if(Browser.mainLoop.method==="timeout"&&Module.ctx){Module.printErr("Looks like you are rendering without using requestAnimationFrame for the main loop. You should use 0 for the frame rate in emscripten_set_main_loop in order to use requestAnimationFrame, as that can greatly improve your frame rates!");Browser.mainLoop.method=""}Browser.mainLoop.runIter((function(){if(typeof arg!=="undefined"){Runtime.dynCall("vi",func,[arg])}else{Runtime.dynCall("v",func)}}));if(thisMainLoopId<Browser.mainLoop.currentlyRunningMainloop)return;if(typeof SDL==="object"&&SDL.audio&&SDL.audio.queueNewAudioData)SDL.audio.queueNewAudioData();Browser.mainLoop.scheduler()};if(!noSetTiming){if(fps&&fps>0)_emscripten_set_main_loop_timing(0,1e3/fps);else _emscripten_set_main_loop_timing(1,1);Browser.mainLoop.scheduler()}if(simulateInfiniteLoop){throw"SimulateInfiniteLoop"}}var Browser={mainLoop:{scheduler:null,method:"",currentlyRunningMainloop:0,func:null,arg:0,timingMode:0,timingValue:0,currentFrameNumber:0,queue:[],pause:(function(){Browser.mainLoop.scheduler=null;Browser.mainLoop.currentlyRunningMainloop++}),resume:(function(){Browser.mainLoop.currentlyRunningMainloop++;var timingMode=Browser.mainLoop.timingMode;var timingValue=Browser.mainLoop.timingValue;var func=Browser.mainLoop.func;Browser.mainLoop.func=null;_emscripten_set_main_loop(func,0,false,Browser.mainLoop.arg,true);_emscripten_set_main_loop_timing(timingMode,timingValue);Browser.mainLoop.scheduler()}),updateStatus:(function(){if(Module["setStatus"]){var message=Module["statusMessage"]||"Please wait...";var remaining=Browser.mainLoop.remainingBlockers;var expected=Browser.mainLoop.expectedBlockers;if(remaining){if(remaining<expected){Module["setStatus"](message+" ("+(expected-remaining)+"/"+expected+")")}else{Module["setStatus"](message)}}else{Module["setStatus"]("")}}}),runIter:(function(func){if(ABORT)return;if(Module["preMainLoop"]){var preRet=Module["preMainLoop"]();if(preRet===false){return}}try{func()}catch(e){if(e instanceof ExitStatus){return}else{if(e&&typeof e==="object"&&e.stack)Module.printErr("exception thrown: "+[e,e.stack]);throw e}}if(Module["postMainLoop"])Module["postMainLoop"]()})},isFullScreen:false,pointerLock:false,moduleContextCreatedCallbacks:[],workers:[],init:(function(){if(!Module["preloadPlugins"])Module["preloadPlugins"]=[];if(Browser.initted)return;Browser.initted=true;try{new Blob;Browser.hasBlobConstructor=true}catch(e){Browser.hasBlobConstructor=false;console.log("warning: no blob constructor, cannot create blobs with mimetypes")}Browser.BlobBuilder=typeof MozBlobBuilder!="undefined"?MozBlobBuilder:typeof WebKitBlobBuilder!="undefined"?WebKitBlobBuilder:!Browser.hasBlobConstructor?console.log("warning: no BlobBuilder"):null;Browser.URLObject=typeof window!="undefined"?window.URL?window.URL:window.webkitURL:undefined;if(!Module.noImageDecoding&&typeof Browser.URLObject==="undefined"){console.log("warning: Browser does not support creating object URLs. Built-in browser image decoding will not be available.");Module.noImageDecoding=true}var imagePlugin={};imagePlugin["canHandle"]=function imagePlugin_canHandle(name){return!Module.noImageDecoding&&/\.(jpg|jpeg|png|bmp)$/i.test(name)};imagePlugin["handle"]=function imagePlugin_handle(byteArray,name,onload,onerror){var b=null;if(Browser.hasBlobConstructor){try{b=new Blob([byteArray],{type:Browser.getMimetype(name)});if(b.size!==byteArray.length){b=new Blob([(new Uint8Array(byteArray)).buffer],{type:Browser.getMimetype(name)})}}catch(e){Runtime.warnOnce("Blob constructor present but fails: "+e+"; falling back to blob builder")}}if(!b){var bb=new Browser.BlobBuilder;bb.append((new Uint8Array(byteArray)).buffer);b=bb.getBlob()}var url=Browser.URLObject.createObjectURL(b);var img=new Image;img.onload=function img_onload(){assert(img.complete,"Image "+name+" could not be decoded");var canvas=document.createElement("canvas");canvas.width=img.width;canvas.height=img.height;var ctx=canvas.getContext("2d");ctx.drawImage(img,0,0);Module["preloadedImages"][name]=canvas;Browser.URLObject.revokeObjectURL(url);if(onload)onload(byteArray)};img.onerror=function img_onerror(event){console.log("Image "+url+" could not be decoded");if(onerror)onerror()};img.src=url};Module["preloadPlugins"].push(imagePlugin);var audioPlugin={};audioPlugin["canHandle"]=function audioPlugin_canHandle(name){return!Module.noAudioDecoding&&name.substr(-4)in{".ogg":1,".wav":1,".mp3":1}};audioPlugin["handle"]=function audioPlugin_handle(byteArray,name,onload,onerror){var done=false;function finish(audio){if(done)return;done=true;Module["preloadedAudios"][name]=audio;if(onload)onload(byteArray)}function fail(){if(done)return;done=true;Module["preloadedAudios"][name]=new Audio;if(onerror)onerror()}if(Browser.hasBlobConstructor){try{var b=new Blob([byteArray],{type:Browser.getMimetype(name)})}catch(e){return fail()}var url=Browser.URLObject.createObjectURL(b);var audio=new Audio;audio.addEventListener("canplaythrough",(function(){finish(audio)}),false);audio.onerror=function audio_onerror(event){if(done)return;console.log("warning: browser could not fully decode audio "+name+", trying slower base64 approach");function encode64(data){var BASE="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";var PAD="=";var ret="";var leftchar=0;var leftbits=0;for(var i=0;i<data.length;i++){leftchar=leftchar<<8|data[i];leftbits+=8;while(leftbits>=6){var curr=leftchar>>leftbits-6&63;leftbits-=6;ret+=BASE[curr]}}if(leftbits==2){ret+=BASE[(leftchar&3)<<4];ret+=PAD+PAD}else if(leftbits==4){ret+=BASE[(leftchar&15)<<2];ret+=PAD}return ret}audio.src="data:audio/x-"+name.substr(-3)+";base64,"+encode64(byteArray);finish(audio)};audio.src=url;Browser.safeSetTimeout((function(){finish(audio)}),1e4)}else{return fail()}};Module["preloadPlugins"].push(audioPlugin);var canvas=Module["canvas"];function pointerLockChange(){Browser.pointerLock=document["pointerLockElement"]===canvas||document["mozPointerLockElement"]===canvas||document["webkitPointerLockElement"]===canvas||document["msPointerLockElement"]===canvas}if(canvas){canvas.requestPointerLock=canvas["requestPointerLock"]||canvas["mozRequestPointerLock"]||canvas["webkitRequestPointerLock"]||canvas["msRequestPointerLock"]||(function(){});canvas.exitPointerLock=document["exitPointerLock"]||document["mozExitPointerLock"]||document["webkitExitPointerLock"]||document["msExitPointerLock"]||(function(){});canvas.exitPointerLock=canvas.exitPointerLock.bind(document);document.addEventListener("pointerlockchange",pointerLockChange,false);document.addEventListener("mozpointerlockchange",pointerLockChange,false);document.addEventListener("webkitpointerlockchange",pointerLockChange,false);document.addEventListener("mspointerlockchange",pointerLockChange,false);if(Module["elementPointerLock"]){canvas.addEventListener("click",(function(ev){if(!Browser.pointerLock&&canvas.requestPointerLock){canvas.requestPointerLock();ev.preventDefault()}}),false)}}}),createContext:(function(canvas,useWebGL,setInModule,webGLContextAttributes){if(useWebGL&&Module.ctx&&canvas==Module.canvas)return Module.ctx;var ctx;var contextHandle;if(useWebGL){var contextAttributes={antialias:false,alpha:false};if(webGLContextAttributes){for(var attribute in webGLContextAttributes){contextAttributes[attribute]=webGLContextAttributes[attribute]}}contextHandle=GL.createContext(canvas,contextAttributes);if(contextHandle){ctx=GL.getContext(contextHandle).GLctx}canvas.style.backgroundColor="black"}else{ctx=canvas.getContext("2d")}if(!ctx)return null;if(setInModule){if(!useWebGL)assert(typeof GLctx==="undefined","cannot set in module if GLctx is used, but we are a non-GL context that would replace it");Module.ctx=ctx;if(useWebGL)GL.makeContextCurrent(contextHandle);Module.useWebGL=useWebGL;Browser.moduleContextCreatedCallbacks.forEach((function(callback){callback()}));Browser.init()}return ctx}),destroyContext:(function(canvas,useWebGL,setInModule){}),fullScreenHandlersInstalled:false,lockPointer:undefined,resizeCanvas:undefined,requestFullScreen:(function(lockPointer,resizeCanvas,vrDevice){Browser.lockPointer=lockPointer;Browser.resizeCanvas=resizeCanvas;Browser.vrDevice=vrDevice;if(typeof Browser.lockPointer==="undefined")Browser.lockPointer=true;if(typeof Browser.resizeCanvas==="undefined")Browser.resizeCanvas=false;if(typeof Browser.vrDevice==="undefined")Browser.vrDevice=null;var canvas=Module["canvas"];function fullScreenChange(){Browser.isFullScreen=false;var canvasContainer=canvas.parentNode;if((document["webkitFullScreenElement"]||document["webkitFullscreenElement"]||document["mozFullScreenElement"]||document["mozFullscreenElement"]||document["fullScreenElement"]||document["fullscreenElement"]||document["msFullScreenElement"]||document["msFullscreenElement"]||document["webkitCurrentFullScreenElement"])===canvasContainer){canvas.cancelFullScreen=document["cancelFullScreen"]||document["mozCancelFullScreen"]||document["webkitCancelFullScreen"]||document["msExitFullscreen"]||document["exitFullscreen"]||(function(){});canvas.cancelFullScreen=canvas.cancelFullScreen.bind(document);if(Browser.lockPointer)canvas.requestPointerLock();Browser.isFullScreen=true;if(Browser.resizeCanvas)Browser.setFullScreenCanvasSize()}else{canvasContainer.parentNode.insertBefore(canvas,canvasContainer);canvasContainer.parentNode.removeChild(canvasContainer);if(Browser.resizeCanvas)Browser.setWindowedCanvasSize()}if(Module["onFullScreen"])Module["onFullScreen"](Browser.isFullScreen);Browser.updateCanvasDimensions(canvas)}if(!Browser.fullScreenHandlersInstalled){Browser.fullScreenHandlersInstalled=true;document.addEventListener("fullscreenchange",fullScreenChange,false);document.addEventListener("mozfullscreenchange",fullScreenChange,false);document.addEventListener("webkitfullscreenchange",fullScreenChange,false);document.addEventListener("MSFullscreenChange",fullScreenChange,false)}var canvasContainer=document.createElement("div");canvas.parentNode.insertBefore(canvasContainer,canvas);canvasContainer.appendChild(canvas);canvasContainer.requestFullScreen=canvasContainer["requestFullScreen"]||canvasContainer["mozRequestFullScreen"]||canvasContainer["msRequestFullscreen"]||(canvasContainer["webkitRequestFullScreen"]?(function(){canvasContainer["webkitRequestFullScreen"](Element["ALLOW_KEYBOARD_INPUT"])}):null);if(vrDevice){canvasContainer.requestFullScreen({vrDisplay:vrDevice})}else{canvasContainer.requestFullScreen()}}),nextRAF:0,fakeRequestAnimationFrame:(function(func){var now=Date.now();if(Browser.nextRAF===0){Browser.nextRAF=now+1e3/60}else{while(now+2>=Browser.nextRAF){Browser.nextRAF+=1e3/60}}var delay=Math.max(Browser.nextRAF-now,0);setTimeout(func,delay)}),requestAnimationFrame:function requestAnimationFrame(func){if(typeof window==="undefined"){Browser.fakeRequestAnimationFrame(func)}else{if(!window.requestAnimationFrame){window.requestAnimationFrame=window["requestAnimationFrame"]||window["mozRequestAnimationFrame"]||window["webkitRequestAnimationFrame"]||window["msRequestAnimationFrame"]||window["oRequestAnimationFrame"]||Browser.fakeRequestAnimationFrame}window.requestAnimationFrame(func)}},safeCallback:(function(func){return(function(){if(!ABORT)return func.apply(null,arguments)})}),allowAsyncCallbacks:true,queuedAsyncCallbacks:[],pauseAsyncCallbacks:(function(){Browser.allowAsyncCallbacks=false}),resumeAsyncCallbacks:(function(){Browser.allowAsyncCallbacks=true;if(Browser.queuedAsyncCallbacks.length>0){var callbacks=Browser.queuedAsyncCallbacks;Browser.queuedAsyncCallbacks=[];callbacks.forEach((function(func){func()}))}}),safeRequestAnimationFrame:(function(func){return Browser.requestAnimationFrame((function(){if(ABORT)return;if(Browser.allowAsyncCallbacks){func()}else{Browser.queuedAsyncCallbacks.push(func)}}))}),safeSetTimeout:(function(func,timeout){Module["noExitRuntime"]=true;return setTimeout((function(){if(ABORT)return;if(Browser.allowAsyncCallbacks){func()}else{Browser.queuedAsyncCallbacks.push(func)}}),timeout)}),safeSetInterval:(function(func,timeout){Module["noExitRuntime"]=true;return setInterval((function(){if(ABORT)return;if(Browser.allowAsyncCallbacks){func()}}),timeout)}),getMimetype:(function(name){return{"jpg":"image/jpeg","jpeg":"image/jpeg","png":"image/png","bmp":"image/bmp","ogg":"audio/ogg","wav":"audio/wav","mp3":"audio/mpeg"}[name.substr(name.lastIndexOf(".")+1)]}),getUserMedia:(function(func){if(!window.getUserMedia){window.getUserMedia=navigator["getUserMedia"]||navigator["mozGetUserMedia"]}window.getUserMedia(func)}),getMovementX:(function(event){return event["movementX"]||event["mozMovementX"]||event["webkitMovementX"]||0}),getMovementY:(function(event){return event["movementY"]||event["mozMovementY"]||event["webkitMovementY"]||0}),getMouseWheelDelta:(function(event){var delta=0;switch(event.type){case"DOMMouseScroll":delta=event.detail;break;case"mousewheel":delta=event.wheelDelta;break;case"wheel":delta=event["deltaY"];break;default:throw"unrecognized mouse wheel event: "+event.type}return delta}),mouseX:0,mouseY:0,mouseMovementX:0,mouseMovementY:0,touches:{},lastTouches:{},calculateMouseEvent:(function(event){if(Browser.pointerLock){if(event.type!="mousemove"&&"mozMovementX"in event){Browser.mouseMovementX=Browser.mouseMovementY=0}else{Browser.mouseMovementX=Browser.getMovementX(event);Browser.mouseMovementY=Browser.getMovementY(event)}if(typeof SDL!="undefined"){Browser.mouseX=SDL.mouseX+Browser.mouseMovementX;Browser.mouseY=SDL.mouseY+Browser.mouseMovementY}else{Browser.mouseX+=Browser.mouseMovementX;Browser.mouseY+=Browser.mouseMovementY}}else{var rect=Module["canvas"].getBoundingClientRect();var cw=Module["canvas"].width;var ch=Module["canvas"].height;var scrollX=typeof window.scrollX!=="undefined"?window.scrollX:window.pageXOffset;var scrollY=typeof window.scrollY!=="undefined"?window.scrollY:window.pageYOffset;if(event.type==="touchstart"||event.type==="touchend"||event.type==="touchmove"){var touch=event.touch;if(touch===undefined){return}var adjustedX=touch.pageX-(scrollX+rect.left);var adjustedY=touch.pageY-(scrollY+rect.top);adjustedX=adjustedX*(cw/rect.width);adjustedY=adjustedY*(ch/rect.height);var coords={x:adjustedX,y:adjustedY};if(event.type==="touchstart"){Browser.lastTouches[touch.identifier]=coords;Browser.touches[touch.identifier]=coords}else if(event.type==="touchend"||event.type==="touchmove"){var last=Browser.touches[touch.identifier];if(!last)last=coords;Browser.lastTouches[touch.identifier]=last;Browser.touches[touch.identifier]=coords}return}var x=event.pageX-(scrollX+rect.left);var y=event.pageY-(scrollY+rect.top);x=x*(cw/rect.width);y=y*(ch/rect.height);Browser.mouseMovementX=x-Browser.mouseX;Browser.mouseMovementY=y-Browser.mouseY;Browser.mouseX=x;Browser.mouseY=y}}),asyncLoad:(function(url,onload,onerror,noRunDep){Module["readAsync"](url,(function(arrayBuffer){assert(arrayBuffer,'Loading data file "'+url+'" failed (no arrayBuffer).');onload(new Uint8Array(arrayBuffer));if(!noRunDep)removeRunDependency("al "+url)}),(function(event){if(onerror){onerror()}else{throw'Loading data file "'+url+'" failed.'}}));if(!noRunDep)addRunDependency("al "+url)}),resizeListeners:[],updateResizeListeners:(function(){var canvas=Module["canvas"];Browser.resizeListeners.forEach((function(listener){listener(canvas.width,canvas.height)}))}),setCanvasSize:(function(width,height,noUpdates){var canvas=Module["canvas"];Browser.updateCanvasDimensions(canvas,width,height);if(!noUpdates)Browser.updateResizeListeners()}),windowedWidth:0,windowedHeight:0,setFullScreenCanvasSize:(function(){if(typeof SDL!="undefined"){var flags=HEAPU32[SDL.screen+Runtime.QUANTUM_SIZE*0>>2];flags=flags|8388608;HEAP32[SDL.screen+Runtime.QUANTUM_SIZE*0>>2]=flags}Browser.updateResizeListeners()}),setWindowedCanvasSize:(function(){if(typeof SDL!="undefined"){var flags=HEAPU32[SDL.screen+Runtime.QUANTUM_SIZE*0>>2];flags=flags&~8388608;HEAP32[SDL.screen+Runtime.QUANTUM_SIZE*0>>2]=flags}Browser.updateResizeListeners()}),updateCanvasDimensions:(function(canvas,wNative,hNative){if(wNative&&hNative){canvas.widthNative=wNative;canvas.heightNative=hNative}else{wNative=canvas.widthNative;hNative=canvas.heightNative}var w=wNative;var h=hNative;if(Module["forcedAspectRatio"]&&Module["forcedAspectRatio"]>0){if(w/h<Module["forcedAspectRatio"]){w=Math.round(h*Module["forcedAspectRatio"])}else{h=Math.round(w/Module["forcedAspectRatio"])}}if((document["webkitFullScreenElement"]||document["webkitFullscreenElement"]||document["mozFullScreenElement"]||document["mozFullscreenElement"]||document["fullScreenElement"]||document["fullscreenElement"]||document["msFullScreenElement"]||document["msFullscreenElement"]||document["webkitCurrentFullScreenElement"])===canvas.parentNode&&typeof screen!="undefined"){var factor=Math.min(screen.width/w,screen.height/h);w=Math.round(w*factor);h=Math.round(h*factor)}if(Browser.resizeCanvas){if(canvas.width!=w)canvas.width=w;if(canvas.height!=h)canvas.height=h;if(typeof canvas.style!="undefined"){canvas.style.removeProperty("width");canvas.style.removeProperty("height")}}else{if(canvas.width!=wNative)canvas.width=wNative;if(canvas.height!=hNative)canvas.height=hNative;if(typeof canvas.style!="undefined"){if(w!=wNative||h!=hNative){canvas.style.setProperty("width",w+"px","important");canvas.style.setProperty("height",h+"px","important")}else{canvas.style.removeProperty("width");canvas.style.removeProperty("height")}}}}),wgetRequests:{},nextWgetRequestHandle:0,getNextWgetRequestHandle:(function(){var handle=Browser.nextWgetRequestHandle;Browser.nextWgetRequestHandle++;return handle})};function _emscripten_async_call(func,arg,millis){Module["noExitRuntime"]=true;function wrapper(){Runtime.getFuncWrapper(func,"vi")(arg)}if(millis>=0){Browser.safeSetTimeout(wrapper,millis)}else{Browser.safeRequestAnimationFrame(wrapper)}}FS.staticInit();__ATINIT__.unshift((function(){if(!Module["noFSInit"]&&!FS.init.initialized)FS.init()}));__ATMAIN__.push((function(){FS.ignorePermissions=false}));__ATEXIT__.push((function(){FS.quit()}));Module["FS_createFolder"]=FS.createFolder;Module["FS_createPath"]=FS.createPath;Module["FS_createDataFile"]=FS.createDataFile;Module["FS_createPreloadedFile"]=FS.createPreloadedFile;Module["FS_createLazyFile"]=FS.createLazyFile;Module["FS_createLink"]=FS.createLink;Module["FS_createDevice"]=FS.createDevice;Module["FS_unlink"]=FS.unlink;__ATINIT__.unshift((function(){TTY.init()}));__ATEXIT__.push((function(){TTY.shutdown()}));if(ENVIRONMENT_IS_NODE){var fs=require("fs");var NODEJS_PATH=require("path");NODEFS.staticInit()}Module["requestFullScreen"]=function Module_requestFullScreen(lockPointer,resizeCanvas,vrDevice){Browser.requestFullScreen(lockPointer,resizeCanvas,vrDevice)};Module["requestAnimationFrame"]=function Module_requestAnimationFrame(func){Browser.requestAnimationFrame(func)};Module["setCanvasSize"]=function Module_setCanvasSize(width,height,noUpdates){Browser.setCanvasSize(width,height,noUpdates)};Module["pauseMainLoop"]=function Module_pauseMainLoop(){Browser.mainLoop.pause()};Module["resumeMainLoop"]=function Module_resumeMainLoop(){Browser.mainLoop.resume()};Module["getUserMedia"]=function Module_getUserMedia(){Browser.getUserMedia()};Module["createContext"]=function Module_createContext(canvas,useWebGL,setInModule,webGLContextAttributes){return Browser.createContext(canvas,useWebGL,setInModule,webGLContextAttributes)};STACK_BASE=STACKTOP=Runtime.alignMemory(STATICTOP);staticSealed=true;STACK_MAX=STACK_BASE+TOTAL_STACK;DYNAMIC_BASE=DYNAMICTOP=Runtime.alignMemory(STACK_MAX);function invoke_iiiiiiii(index,a1,a2,a3,a4,a5,a6,a7){try{return Module["dynCall_iiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiii(index,a1,a2,a3){try{return Module["dynCall_iiii"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiii(index,a1,a2,a3,a4,a5){try{Module["dynCall_viiiii"](index,a1,a2,a3,a4,a5)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiiiiid(index,a1,a2,a3,a4,a5,a6){try{return Module["dynCall_iiiiiid"](index,a1,a2,a3,a4,a5,a6)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_vi(index,a1){try{Module["dynCall_vi"](index,a1)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_vii(index,a1,a2){try{Module["dynCall_vii"](index,a1,a2)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiiiiii(index,a1,a2,a3,a4,a5,a6){try{return Module["dynCall_iiiiiii"](index,a1,a2,a3,a4,a5,a6)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiiiid(index,a1,a2,a3,a4,a5){try{return Module["dynCall_iiiiid"](index,a1,a2,a3,a4,a5)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_ii(index,a1){try{return Module["dynCall_ii"](index,a1)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viii(index,a1,a2,a3){try{Module["dynCall_viii"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_v(index){try{Module["dynCall_v"](index)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8){try{return Module["dynCall_iiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiiii(index,a1,a2,a3,a4){try{return Module["dynCall_iiiii"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiiii(index,a1,a2,a3,a4,a5,a6){try{Module["dynCall_viiiiii"](index,a1,a2,a3,a4,a5,a6)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iii(index,a1,a2){try{return Module["dynCall_iii"](index,a1,a2)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiiiii(index,a1,a2,a3,a4,a5){try{return Module["dynCall_iiiiii"](index,a1,a2,a3,a4,a5)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiii(index,a1,a2,a3,a4){try{Module["dynCall_viiii"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}Module.asmGlobalArg={"Math":Math,"Int8Array":Int8Array,"Int16Array":Int16Array,"Int32Array":Int32Array,"Uint8Array":Uint8Array,"Uint16Array":Uint16Array,"Uint32Array":Uint32Array,"Float32Array":Float32Array,"Float64Array":Float64Array,"NaN":NaN,"Infinity":Infinity};Module.asmLibraryArg={"abort":abort,"assert":assert,"invoke_iiiiiiii":invoke_iiiiiiii,"invoke_iiii":invoke_iiii,"invoke_viiiii":invoke_viiiii,"invoke_iiiiiid":invoke_iiiiiid,"invoke_vi":invoke_vi,"invoke_vii":invoke_vii,"invoke_iiiiiii":invoke_iiiiiii,"invoke_iiiiid":invoke_iiiiid,"invoke_ii":invoke_ii,"invoke_viii":invoke_viii,"invoke_v":invoke_v,"invoke_iiiiiiiii":invoke_iiiiiiiii,"invoke_iiiii":invoke_iiiii,"invoke_viiiiii":invoke_viiiiii,"invoke_iii":invoke_iii,"invoke_iiiiii":invoke_iiiiii,"invoke_viiii":invoke_viiii,"_pthread_cleanup_pop":_pthread_cleanup_pop,"_pthread_getspecific":_pthread_getspecific,"_pthread_cond_wait":_pthread_cond_wait,"_pthread_join":_pthread_join,"_llvm_pow_f64":_llvm_pow_f64,"_pthread_key_create":_pthread_key_create,"_pthread_cleanup_push":_pthread_cleanup_push,"_abort":_abort,"___cxa_guard_acquire":___cxa_guard_acquire,"_emscripten_set_main_loop_timing":_emscripten_set_main_loop_timing,"___gxx_personality_v0":___gxx_personality_v0,"___assert_fail":___assert_fail,"___cxa_allocate_exception":___cxa_allocate_exception,"_emscripten_get_now_is_monotonic":_emscripten_get_now_is_monotonic,"__isLeapYear":__isLeapYear,"___cxa_guard_release":___cxa_guard_release,"__addDays":__addDays,"_strftime_l":_strftime_l,"_pthread_cond_destroy":_pthread_cond_destroy,"___setErrNo":___setErrNo,"_sbrk":_sbrk,"_llvm_fabs_f64":_llvm_fabs_f64,"___cxa_begin_catch":___cxa_begin_catch,"_emscripten_memcpy_big":_emscripten_memcpy_big,"___resumeException":___resumeException,"__ZSt18uncaught_exceptionv":__ZSt18uncaught_exceptionv,"_sysconf":_sysconf,"_strftime":_strftime,"__arraySum":__arraySum,"___syscall221":___syscall221,"_pthread_cond_signal":_pthread_cond_signal,"_pthread_self":_pthread_self,"_pthread_mutex_destroy":_pthread_mutex_destroy,"_pthread_mutex_unlock":_pthread_mutex_unlock,"_pthread_once":_pthread_once,"_clock_gettime":_clock_gettime,"___syscall54":___syscall54,"___unlock":___unlock,"_pthread_cond_broadcast":_pthread_cond_broadcast,"_emscripten_set_main_loop":_emscripten_set_main_loop,"_emscripten_get_now":_emscripten_get_now,"_llvm_cttz_i64":_llvm_cttz_i64,"_pthread_setspecific":_pthread_setspecific,"___cxa_throw":___cxa_throw,"__exit":__exit,"___lock":___lock,"___syscall6":___syscall6,"___syscall5":___syscall5,"___syscall145":___syscall145,"_time":_time,"_pthread_mutex_lock":_pthread_mutex_lock,"___syscall140":___syscall140,"_exit":_exit,"___cxa_find_matching_catch":___cxa_find_matching_catch,"_emscripten_async_call":_emscripten_async_call,"___syscall146":___syscall146,"STACKTOP":STACKTOP,"STACK_MAX":STACK_MAX,"tempDoublePtr":tempDoublePtr,"ABORT":ABORT,"cttz_i8":cttz_i8};// EMSCRIPTEN_START_ASM
var asm=(function(global,env,buffer) {
"use asm";var a=new global.Int8Array(buffer);var b=new global.Int16Array(buffer);var c=new global.Int32Array(buffer);var d=new global.Uint8Array(buffer);var e=new global.Uint16Array(buffer);var f=new global.Uint32Array(buffer);var g=new global.Float32Array(buffer);var h=new global.Float64Array(buffer);var i=env.STACKTOP|0;var j=env.STACK_MAX|0;var k=env.tempDoublePtr|0;var l=env.ABORT|0;var m=env.cttz_i8|0;var n=0;var o=0;var p=0;var q=0;var r=global.NaN,s=global.Infinity;var t=0,u=0,v=0,w=0,x=0.0,y=0,z=0,A=0,B=0.0;var C=0;var D=0;var E=0;var F=0;var G=0;var H=0;var I=0;var J=0;var K=0;var L=0;var M=global.Math.floor;var N=global.Math.abs;var O=global.Math.sqrt;var P=global.Math.pow;var Q=global.Math.cos;var R=global.Math.sin;var S=global.Math.tan;var T=global.Math.acos;var U=global.Math.asin;var V=global.Math.atan;var W=global.Math.atan2;var X=global.Math.exp;var Y=global.Math.log;var Z=global.Math.ceil;var _=global.Math.imul;var $=global.Math.min;var aa=global.Math.clz32;var ba=env.abort;var ca=env.assert;var da=env.invoke_iiiiiiii;var ea=env.invoke_iiii;var fa=env.invoke_viiiii;var ga=env.invoke_iiiiiid;var ha=env.invoke_vi;var ia=env.invoke_vii;var ja=env.invoke_iiiiiii;var ka=env.invoke_iiiiid;var la=env.invoke_ii;var ma=env.invoke_viii;var na=env.invoke_v;var oa=env.invoke_iiiiiiiii;var pa=env.invoke_iiiii;var qa=env.invoke_viiiiii;var ra=env.invoke_iii;var sa=env.invoke_iiiiii;var ta=env.invoke_viiii;var ua=env._pthread_cleanup_pop;var va=env._pthread_getspecific;var wa=env._pthread_cond_wait;var xa=env._pthread_join;var ya=env._llvm_pow_f64;var za=env._pthread_key_create;var Aa=env._pthread_cleanup_push;var Ba=env._abort;var Ca=env.___cxa_guard_acquire;var Da=env._emscripten_set_main_loop_timing;var Ea=env.___gxx_personality_v0;var Fa=env.___assert_fail;var Ga=env.___cxa_allocate_exception;var Ha=env._emscripten_get_now_is_monotonic;var Ia=env.__isLeapYear;var Ja=env.___cxa_guard_release;var Ka=env.__addDays;var La=env._strftime_l;var Ma=env._pthread_cond_destroy;var Na=env.___setErrNo;var Oa=env._sbrk;var Pa=env._llvm_fabs_f64;var Qa=env.___cxa_begin_catch;var Ra=env._emscripten_memcpy_big;var Sa=env.___resumeException;var Ta=env.__ZSt18uncaught_exceptionv;var Ua=env._sysconf;var Va=env._strftime;var Wa=env.__arraySum;var Xa=env.___syscall221;var Ya=env._pthread_cond_signal;var Za=env._pthread_self;var _a=env._pthread_mutex_destroy;var $a=env._pthread_mutex_unlock;var ab=env._pthread_once;var bb=env._clock_gettime;var cb=env.___syscall54;var db=env.___unlock;var eb=env._pthread_cond_broadcast;var fb=env._emscripten_set_main_loop;var gb=env._emscripten_get_now;var hb=env._llvm_cttz_i64;var ib=env._pthread_setspecific;var jb=env.___cxa_throw;var kb=env.__exit;var lb=env.___lock;var mb=env.___syscall6;var nb=env.___syscall5;var ob=env.___syscall145;var pb=env._time;var qb=env._pthread_mutex_lock;var rb=env.___syscall140;var sb=env._exit;var tb=env.___cxa_find_matching_catch;var ub=env._emscripten_async_call;var vb=env.___syscall146;var wb=0.0;
// EMSCRIPTEN_START_FUNCS
function Xk(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0;d=i;i=i+16|0;e=d;rk(e,20657,4);a=Yk(e,a,b,c)|0;vk(e);i=d;return a|0}function Yk(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0;j=i;i=i+16|0;h=j;g=(a[d>>0]&1)==0?d+1|0:c[d+8>>2]|0;k=Dh()|0;l=c[k>>2]|0;c[k>>2]=0;f=hi(g,h,f)|0;d=c[k>>2]|0;c[k>>2]=l;if((d|0)==34)Zk(b);d=c[h>>2]|0;if((d|0)==(g|0))$k(b);if(e|0)c[e>>2]=d-g;i=j;return f|0}function Zk(b){b=b|0;var d=0;d=i;i=i+16|0;_k(d,b,20662);Oi((a[d>>0]&1)==0?d+1|0:c[d+8>>2]|0)|0;Ba()}function _k(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;f=0;while(1){if((f|0)==3)break;c[b+(f<<2)>>2]=0;f=f+1|0}g=a[d>>0]|0;h=(g&1)==0;g=h?(g&255)>>>1:c[d+4>>2]|0;f=Mh(e)|0;Mk(b,h?d+1|0:c[d+8>>2]|0,g,g+f|0);Ek(b,e,f)|0;return}function $k(b){b=b|0;var d=0;d=i;i=i+16|0;_k(d,b,20677);Oi((a[d>>0]&1)==0?d+1|0:c[d+8>>2]|0)|0;Ba()}function al(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;m=i;i=i+16|0;k=m;l=m+4|0;e=0;while(1){if((e|0)==3)break;c[l+(e<<2)>>2]=0;e=e+1|0}if(!(a[l>>0]&1))e=10;else e=(c[l>>2]&-2)+-1|0;Bk(l,e,0);g=a[l>>0]|0;h=l+1|0;j=l+8|0;f=g;g=(g&1)==0?(g&255)>>>1:c[l+4>>2]|0;while(1){e=(f&1)==0?h:c[j>>2]|0;c[k>>2]=d;e=Nh(e,g+1|0,20693,k)|0;if((e|0)>-1){if(e>>>0<=g>>>0)break}else e=g<<1|1;Bk(l,e,0);f=a[l>>0]|0;g=e}Bk(l,e,0);c[b>>2]=c[l>>2];c[b+4>>2]=c[l+4>>2];c[b+8>>2]=c[l+8>>2];e=0;while(1){if((e|0)==3)break;c[l+(e<<2)>>2]=0;e=e+1|0}vk(l);i=m;return}function bl(a){a=a|0;if(!(c[a>>2]|0))return;else Au()}function cl(a){a=a|0;xa(c[a>>2]|0,0)|0;c[a>>2]=0;return}function dl(){var a=0,b=0,d=0;b=i;i=i+16|0;a=b;bb(1,a|0)|0;d=c[a>>2]|0;a=c[a+4>>2]|0;d=hv(d|0,((d|0)<0)<<31>>31|0,1e9,0)|0;a=Xu(d|0,C|0,a|0,((a|0)<0)<<31>>31|0)|0;i=b;return a|0}function el(a){a=a|0;fl(a);return}function fl(a){a=a|0;c[a>>2]=12036;hl(a,0);_t(a+28|0);Aj(c[a+32>>2]|0);Aj(c[a+36>>2]|0);Aj(c[a+48>>2]|0);Aj(c[a+60>>2]|0);return}function gl(a){a=a|0;fl(a);mu(a);return}function hl(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;d=a+32|0;e=a+36|0;f=c[a+40>>2]|0;while(1){if(!f)break;g=f+-1|0;Gb[c[(c[d>>2]|0)+(g<<2)>>2]&0](b,a,c[(c[e>>2]|0)+(g<<2)>>2]|0);f=g}return}function il(a){a=a|0;c[a>>2]=12052;_t(a+4|0);return}function jl(a){a=a|0;c[a>>2]=12052;_t(a+4|0);mu(a);return}function kl(a,b){a=a|0;b=b|0;return}function ll(a,b,c){a=a|0;b=b|0;c=c|0;return a|0}function ml(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;b=a;c[b>>2]=0;c[b+4>>2]=0;b=a+8|0;c[b>>2]=-1;c[b+4>>2]=-1;return}function nl(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;b=a;c[b>>2]=0;c[b+4>>2]=0;b=a+8|0;c[b>>2]=-1;c[b+4>>2]=-1;return}function ol(a){a=a|0;return 0}function pl(a){a=a|0;return 0}function ql(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0;h=b+12|0;i=b+16|0;g=d;d=0;while(1){if((d|0)>=(e|0))break;f=c[h>>2]|0;if(f>>>0<(c[i>>2]|0)>>>0){c[h>>2]=f+1;f=a[f>>0]|0}else{f=Fb[c[(c[b>>2]|0)+40>>2]&127](b)|0;if((f|0)==-1)break;f=f&255}a[g>>0]=f;g=g+1|0;d=d+1|0}return d|0}function rl(a){a=a|0;return -1}function sl(a){a=a|0;var b=0;if((Fb[c[(c[a>>2]|0)+36>>2]&127](a)|0)==-1)a=-1;else{b=a+12|0;a=c[b>>2]|0;c[b>>2]=a+1;a=d[a>>0]|0}return a|0}function tl(a,b){a=a|0;b=b|0;return -1}function ul(b,e,f){b=b|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0;i=b+24|0;j=b+28|0;g=e;e=0;while(1){if((e|0)>=(f|0))break;h=c[i>>2]|0;if(h>>>0>=(c[j>>2]|0)>>>0){if((Lb[c[(c[b>>2]|0)+52>>2]&63](b,d[g>>0]|0)|0)==-1)break}else{k=a[g>>0]|0;c[i>>2]=h+1;a[h>>0]=k}g=g+1|0;e=e+1|0}return e|0}function vl(a,b){a=a|0;b=b|0;return -1}function wl(a){a=a|0;c[a>>2]=12116;_t(a+4|0);return}function xl(a){a=a|0;c[a>>2]=12116;_t(a+4|0);mu(a);return}function yl(a,b){a=a|0;b=b|0;return}function zl(a,b,c){a=a|0;b=b|0;c=c|0;return a|0}function Al(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;b=a;c[b>>2]=0;c[b+4>>2]=0;b=a+8|0;c[b>>2]=-1;c[b+4>>2]=-1;return}function Bl(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;b=a;c[b>>2]=0;c[b+4>>2]=0;b=a+8|0;c[b>>2]=-1;c[b+4>>2]=-1;return}function Cl(a){a=a|0;return 0}function Dl(a){a=a|0;return 0}function El(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0;g=a+12|0;h=a+16|0;f=b;b=0;while(1){if((b|0)>=(d|0))break;e=c[g>>2]|0;if(e>>>0>=(c[h>>2]|0)>>>0){e=Fb[c[(c[a>>2]|0)+40>>2]&127](a)|0;if((e|0)==-1)break}else{c[g>>2]=e+4;e=c[e>>2]|0}c[f>>2]=e;f=f+4|0;b=b+1|0}return b|0}function Fl(a){a=a|0;return -1}function Gl(a){a=a|0;var b=0;if((Fb[c[(c[a>>2]|0)+36>>2]&127](a)|0)==-1)a=-1;else{b=a+12|0;a=c[b>>2]|0;c[b>>2]=a+4;a=c[a>>2]|0}return a|0}function Hl(a,b){a=a|0;b=b|0;return -1}function Il(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0;g=a+24|0;h=a+28|0;e=b;b=0;while(1){if((b|0)>=(d|0))break;f=c[g>>2]|0;if(f>>>0>=(c[h>>2]|0)>>>0){if((Lb[c[(c[a>>2]|0)+52>>2]&63](a,c[e>>2]|0)|0)==-1)break}else{i=c[e>>2]|0;c[g>>2]=f+4;c[f>>2]=i}e=e+4|0;b=b+1|0}return b|0}function Jl(a,b){a=a|0;b=b|0;return -1}function Kl(a){a=a|0;fl(a+8|0);return}function Ll(a){a=a|0;fl(a+8|0);mu(a);return}function Ml(a){a=a|0;fl(a+(c[(c[a>>2]|0)+-12>>2]|0)+8|0);return}function Nl(a){a=a|0;Ll(a+(c[(c[a>>2]|0)+-12>>2]|0)|0);return}function Ol(a){a=a|0;fl(a+8|0);return}function Pl(a){a=a|0;fl(a+8|0);mu(a);return}function Ql(a){a=a|0;fl(a+(c[(c[a>>2]|0)+-12>>2]|0)+8|0);return}function Rl(a){a=a|0;Pl(a+(c[(c[a>>2]|0)+-12>>2]|0)|0);return}function Sl(a){a=a|0;fl(a+4|0);return}function Tl(a){a=a|0;fl(a+4|0);mu(a);return}function Ul(a){a=a|0;fl(a+(c[(c[a>>2]|0)+-12>>2]|0)+4|0);return}function Vl(a){a=a|0;Tl(a+(c[(c[a>>2]|0)+-12>>2]|0)|0);return}function Wl(a){a=a|0;fl(a+4|0);return}function Xl(a){a=a|0;fl(a+4|0);mu(a);return}function Yl(a){a=a|0;fl(a+(c[(c[a>>2]|0)+-12>>2]|0)+4|0);return}function Zl(a){a=a|0;Xl(a+(c[(c[a>>2]|0)+-12>>2]|0)|0);return}function _l(a){a=a|0;fl(a+12|0);return}function $l(a){a=a|0;fl(a+12|0);mu(a);return}function am(a){a=a|0;fl(a+-8+12|0);return}function bm(a){a=a|0;$l(a+-8|0);return}function cm(a){a=a|0;fl(a+(c[(c[a>>2]|0)+-12>>2]|0)+12|0);return}function dm(a){a=a|0;$l(a+(c[(c[a>>2]|0)+-12>>2]|0)|0);return}function em(a,b){a=a|0;b=b|0;c[a+16>>2]=(c[a+24>>2]|0)==0|b;return}function fm(a,b){a=a|0;b=b|0;var d=0;c[a+24>>2]=b;c[a+16>>2]=(b|0)==0&1;c[a+20>>2]=0;c[a+4>>2]=4098;c[a+12>>2]=0;c[a+8>>2]=6;d=a+28|0;b=a+32|0;a=b+40|0;do{c[b>>2]=0;b=b+4|0}while((b|0)<(a|0));Yt(d);return}function gm(a){a=a|0;var b=0,d=0;d=i;i=i+16|0;b=d;Zt(b,a+28|0);i=d;return c[b>>2]|0}function hm(a){a=a|0;c[a>>2]=12052;Yt(a+4|0);a=a+8|0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0;c[a+16>>2]=0;c[a+20>>2]=0;return}function im(a){a=a|0;c[a>>2]=12116;Yt(a+4|0);a=a+8|0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0;c[a+16>>2]=0;c[a+20>>2]=0;return}function jm(a,b){a=a|0;b=b|0;return}function km(e,f,g){e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0;u=i;i=i+16|0;l=u;a[e>>0]=0;h=f+(c[(c[f>>2]|0)+-12>>2]|0)|0;j=h+16|0;k=c[j>>2]|0;if(!k){h=c[h+72>>2]|0;if(h|0)lm(h)|0;do if(!g?(m=f+(c[(c[f>>2]|0)+-12>>2]|0)|0,c[m+4>>2]&4096|0):0){c[l>>2]=gm(m)|0;m=Om(l,1150100)|0;_t(l);h=c[f+(c[(c[f>>2]|0)+-12>>2]|0)+24>>2]|0;l=m+8|0;m=h;g=(h|0)==0;n=m+12|0;o=m+16|0;p=h;j=h;q=j+12|0;r=j+16|0;s=h;t=h;while(1){if(g){j=0;h=0;break}if((c[n>>2]|0)==(c[o>>2]|0)?(Fb[c[(c[p>>2]|0)+36>>2]&127](m)|0)==-1:0){j=0;h=0;break}k=c[q>>2]|0;if((k|0)==(c[r>>2]|0))k=Fb[c[(c[s>>2]|0)+36>>2]&127](j)|0;else k=d[k>>0]|0;if((k&255)<<24>>24<=-1)break;if(!(b[(c[l>>2]|0)+(k<<24>>24<<1)>>1]&8192))break;k=c[q>>2]|0;if((k|0)==(c[r>>2]|0)){Fb[c[(c[t>>2]|0)+40>>2]&127](j)|0;continue}else{c[q>>2]=k+1;continue}}if(h|0){if((c[j+12>>2]|0)!=(c[j+16>>2]|0))break;if((Fb[c[(c[h>>2]|0)+36>>2]&127](j)|0)!=-1)break}s=f+(c[(c[f>>2]|0)+-12>>2]|0)|0;t=s+16|0;c[t>>2]=c[t>>2]|(c[s+24>>2]|0)==0|6}while(0);a[e>>0]=(c[f+(c[(c[f>>2]|0)+-12>>2]|0)+16>>2]|0)==0&1}else c[j>>2]=k|(c[h+24>>2]|0)==0|4;i=u;return}function lm(b){b=b|0;var d=0,e=0,f=0;e=i;i=i+16|0;d=e;if(c[b+(c[(c[b>>2]|0)+-12>>2]|0)+24>>2]|0){mm(d,b);if(a[d>>0]|0?(f=c[b+(c[(c[b>>2]|0)+-12>>2]|0)+24>>2]|0,(Fb[c[(c[f>>2]|0)+24>>2]&127](f)|0)==-1):0){f=b+(c[(c[b>>2]|0)+-12>>2]|0)+16|0;c[f>>2]=c[f>>2]|1}nm(d)}i=e;return b|0}function mm(b,d){b=b|0;d=d|0;a[b>>0]=0;c[b+4>>2]=d;d=d+(c[(c[d>>2]|0)+-12>>2]|0)|0;if(!(c[d+16>>2]|0)){d=c[d+72>>2]|0;if(d|0)lm(d)|0;a[b>>0]=1}return}function nm(a){a=a|0;var b=0;a=a+4|0;b=c[a>>2]|0;b=b+(c[(c[b>>2]|0)+-12>>2]|0)|0;if((((c[b+24>>2]|0?(c[b+16>>2]|0)==0:0)?c[b+4>>2]&8192|0:0)?!(Ta()|0):0)?(b=c[a>>2]|0,b=c[b+(c[(c[b>>2]|0)+-12>>2]|0)+24>>2]|0,(Fb[c[(c[b>>2]|0)+24>>2]&127](b)|0)==-1):0){b=c[a>>2]|0;b=b+(c[(c[b>>2]|0)+-12>>2]|0)+16|0;c[b>>2]=c[b>>2]|1}return}function om(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;m=i;i=i+32|0;f=m+24|0;e=m+20|0;g=m+16|0;h=m+12|0;n=m+28|0;k=m+8|0;l=m+4|0;j=m;km(n,b,0);if(a[n>>0]|0){c[k>>2]=0;c[j>>2]=gm(b+(c[(c[b>>2]|0)+-12>>2]|0)|0)|0;o=Om(j,1150124)|0;n=b+(c[(c[b>>2]|0)+-12>>2]|0)|0;p=c[(c[o>>2]|0)+16>>2]|0;c[g>>2]=c[n+24>>2];c[h>>2]=0;c[e>>2]=c[g>>2];c[f>>2]=c[h>>2];Db[p&63](o,e,f,n,k,l)|0;_t(j);c[d>>2]=c[l>>2];l=b+(c[(c[b>>2]|0)+-12>>2]|0)|0;n=l+16|0;c[n>>2]=c[n>>2]|c[k>>2]|(c[l+24>>2]|0)==0}i=m;return b|0}function pm(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;l=i;i=i+32|0;f=l+20|0;e=l+16|0;g=l+12|0;h=l+8|0;m=l+24|0;k=l+4|0;j=l;km(m,b,0);if(a[m>>0]|0){c[k>>2]=0;c[j>>2]=gm(b+(c[(c[b>>2]|0)+-12>>2]|0)|0)|0;n=Om(j,1150124)|0;m=b+(c[(c[b>>2]|0)+-12>>2]|0)|0;o=c[(c[n>>2]|0)+20>>2]|0;c[g>>2]=c[m+24>>2];c[h>>2]=0;c[e>>2]=c[g>>2];c[f>>2]=c[h>>2];Db[o&63](n,e,f,m,k,d)|0;_t(j);d=b+(c[(c[b>>2]|0)+-12>>2]|0)|0;m=d+16|0;c[m>>2]=c[m>>2]|c[k>>2]|(c[d+24>>2]|0)==0}i=l;return b|0}function qm(b){b=b|0;var e=0,f=0,g=0;g=i;i=i+16|0;f=g;c[b+4>>2]=0;km(f,b,1);do if(a[f>>0]|0){f=c[b+(c[(c[b>>2]|0)+-12>>2]|0)+24>>2]|0;e=c[f+12>>2]|0;if((e|0)!=(c[f+16>>2]|0)){e=d[e>>0]|0;break}e=Fb[c[(c[f>>2]|0)+36>>2]&127](f)|0;if((e|0)==-1){b=b+(c[(c[b>>2]|0)+-12>>2]|0)|0;e=b+16|0;c[e>>2]=c[e>>2]|(c[b+24>>2]|0)==0|2;e=-1}}else e=-1;while(0);i=g;return e|0}function rm(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0;j=i;i=i+16|0;g=j;c[b+4>>2]=0;f=b+(c[(c[b>>2]|0)+-12>>2]|0)|0;e=f+16|0;c[e>>2]=(c[f+24>>2]|0)==0|c[e>>2]&-3;km(g,b,1);e=c[(c[b>>2]|0)+-12>>2]|0;f=b+e|0;do if(!(a[g>>0]|0)){d=f+16|0;c[d>>2]=c[d>>2]|(c[f+24>>2]|0)==0|4}else{g=c[f+24>>2]|0;if(g){e=g+12|0;f=c[e>>2]|0;if((c[g+8>>2]|0)!=(f|0)?(h=f+-1|0,(a[h>>0]|0)==d<<24>>24):0){c[e>>2]=h;break}if((Lb[c[(c[g>>2]|0)+44>>2]&63](g,d&255)|0)!=-1)break;e=c[(c[b>>2]|0)+-12>>2]|0}d=b+e+16|0;c[d>>2]=c[d>>2]|1}while(0);i=j;return b|0}function sm(a,b){a=a|0;b=b|0;return}function tm(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;n=i;i=i+32|0;j=n+16|0;k=n+12|0;m=n;e=n+8|0;mm(m,b);if(a[m>>0]|0){c[e>>2]=gm(b+(c[(c[b>>2]|0)+-12>>2]|0)|0)|0;l=Om(e,1150156)|0;_t(e);g=b+(c[(c[b>>2]|0)+-12>>2]|0)|0;h=c[g+24>>2]|0;f=g+76|0;e=c[f>>2]|0;if((e|0)==-1){c[j>>2]=gm(g)|0;e=Om(j,1150100)|0;e=Lb[c[(c[e>>2]|0)+28>>2]&63](e,32)|0;_t(j);e=e<<24>>24;c[f>>2]=e}f=c[(c[l>>2]|0)+16>>2]|0;c[k>>2]=h;c[j>>2]=c[k>>2];if(!(Mb[f&31](l,j,g,e&255,d)|0)){d=b+(c[(c[b>>2]|0)+-12>>2]|0)+16|0;c[d>>2]=c[d>>2]|5}}nm(m);i=n;return b|0}function um(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;n=i;i=i+32|0;j=n+16|0;k=n+12|0;m=n;e=n+8|0;mm(m,b);if(a[m>>0]|0){c[e>>2]=gm(b+(c[(c[b>>2]|0)+-12>>2]|0)|0)|0;l=Om(e,1150156)|0;_t(e);g=b+(c[(c[b>>2]|0)+-12>>2]|0)|0;h=c[g+24>>2]|0;f=g+76|0;e=c[f>>2]|0;if((e|0)==-1){c[j>>2]=gm(g)|0;e=Om(j,1150100)|0;e=Lb[c[(c[e>>2]|0)+28>>2]&63](e,32)|0;_t(j);e=e<<24>>24;c[f>>2]=e}f=c[(c[l>>2]|0)+24>>2]|0;c[k>>2]=h;c[j>>2]=c[k>>2];if(!(Mb[f&31](l,j,g,e&255,d)|0)){d=b+(c[(c[b>>2]|0)+-12>>2]|0)+16|0;c[d>>2]=c[d>>2]|5}}nm(m);i=n;return b|0}function vm(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;o=i;i=i+32|0;k=o+16|0;m=o+12|0;n=o;f=o+8|0;mm(n,b);if(a[n>>0]|0){c[f>>2]=gm(b+(c[(c[b>>2]|0)+-12>>2]|0)|0)|0;l=Om(f,1150156)|0;_t(f);h=b+(c[(c[b>>2]|0)+-12>>2]|0)|0;j=c[h+24>>2]|0;g=h+76|0;f=c[g>>2]|0;if((f|0)==-1){c[k>>2]=gm(h)|0;f=Om(k,1150100)|0;f=Lb[c[(c[f>>2]|0)+28>>2]&63](f,32)|0;_t(k);f=f<<24>>24;c[g>>2]=f}g=c[(c[l>>2]|0)+20>>2]|0;c[m>>2]=j;c[k>>2]=c[m>>2];if(!(Db[g&63](l,k,h,f&255,d,e)|0)){m=b+(c[(c[b>>2]|0)+-12>>2]|0)+16|0;c[m>>2]=c[m>>2]|5}}nm(n);i=o;return b|0}function wm(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;o=i;i=i+32|0;k=o+16|0;m=o+12|0;n=o;f=o+8|0;mm(n,b);if(a[n>>0]|0){c[f>>2]=gm(b+(c[(c[b>>2]|0)+-12>>2]|0)|0)|0;l=Om(f,1150156)|0;_t(f);h=b+(c[(c[b>>2]|0)+-12>>2]|0)|0;j=c[h+24>>2]|0;g=h+76|0;f=c[g>>2]|0;if((f|0)==-1){c[k>>2]=gm(h)|0;f=Om(k,1150100)|0;f=Lb[c[(c[f>>2]|0)+28>>2]&63](f,32)|0;_t(k);f=f<<24>>24;c[g>>2]=f}g=c[(c[l>>2]|0)+28>>2]|0;c[m>>2]=j;c[k>>2]=c[m>>2];if(!(Db[g&63](l,k,h,f&255,d,e)|0)){m=b+(c[(c[b>>2]|0)+-12>>2]|0)+16|0;c[m>>2]=c[m>>2]|5}}nm(n);i=o;return b|0}function xm(b,d){b=b|0;d=+d;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;n=i;i=i+32|0;j=n+16|0;k=n+12|0;m=n;e=n+8|0;mm(m,b);if(a[m>>0]|0){c[e>>2]=gm(b+(c[(c[b>>2]|0)+-12>>2]|0)|0)|0;l=Om(e,1150156)|0;_t(e);g=b+(c[(c[b>>2]|0)+-12>>2]|0)|0;h=c[g+24>>2]|0;f=g+76|0;e=c[f>>2]|0;if((e|0)==-1){c[j>>2]=gm(g)|0;e=Om(j,1150100)|0;e=Lb[c[(c[e>>2]|0)+28>>2]&63](e,32)|0;_t(j);e=e<<24>>24;c[f>>2]=e}f=c[(c[l>>2]|0)+32>>2]|0;c[k>>2]=h;c[j>>2]=c[k>>2];if(!(Eb[f&7](l,j,g,e&255,d)|0)){l=b+(c[(c[b>>2]|0)+-12>>2]|0)+16|0;c[l>>2]=c[l>>2]|5}}nm(m);i=n;return b|0}function ym(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0;k=i;i=i+16|0;j=k;mm(j,b);a:do if(a[j>>0]|0){g=c[b+(c[(c[b>>2]|0)+-12>>2]|0)+24>>2]|0;h=g;do if(g|0){e=h+24|0;f=c[e>>2]|0;if((f|0)==(c[h+28>>2]|0))if((Lb[c[(c[g>>2]|0)+52>>2]&63](h,d&255)|0)==-1)break;else break a;else{c[e>>2]=f+1;a[f>>0]=d;break a}}while(0);d=b+(c[(c[b>>2]|0)+-12>>2]|0)+16|0;c[d>>2]=c[d>>2]|1}while(0);nm(j);i=k;return b|0}function zm(a,b){a=a|0;b=b|0;return}function Am(a){a=a|0;return}function Bm(a){a=a|0;mu(a);return}function Cm(a){a=a|0;if(a|0)Bb[c[(c[a>>2]|0)+4>>2]&255](a);return}function Dm(b,c,d,e,f){b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;var g=0,h=0;while(1){if((e|0)==(f|0)){h=7;break}if((c|0)==(d|0)){c=-1;break}b=a[c>>0]|0;g=a[e>>0]|0;if(b<<24>>24<g<<24>>24){c=-1;break}if(g<<24>>24<b<<24>>24){c=1;break}e=e+1|0;c=c+1|0}if((h|0)==7)c=(c|0)!=(d|0)&1;return c|0}function Em(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;uk(a,c,d);return}function Fm(b,c,d){b=b|0;c=c|0;d=d|0;var e=0,f=0;b=0;while(1){if((c|0)==(d|0))break;e=(a[c>>0]|0)+(b<<4)|0;f=e&-268435456;b=(f>>>24|f)^e;c=c+1|0}return b|0}function Gm(a){a=a|0;return}function Hm(a){a=a|0;mu(a);return}function Im(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0;while(1){if((e|0)==(f|0)){h=7;break}if((b|0)==(d|0)){b=-1;break}a=c[b>>2]|0;g=c[e>>2]|0;if((a|0)<(g|0)){b=-1;break}if((g|0)<(a|0)){b=1;break}e=e+4|0;b=b+4|0}if((h|0)==7)b=(b|0)!=(d|0)&1;return b|0}function Jm(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;Pk(a,c,d);return}function Km(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;a=0;while(1){if((b|0)==(d|0))break;e=(c[b>>2]|0)+(a<<4)|0;f=e&-268435456;a=(f>>>24|f)^e;b=b+4|0}return a|0}function Lm(a){a=a|0;return}function Mm(a){a=a|0;mu(a);return}function Nm(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;r=i;i=i+64|0;k=r+48|0;j=r+24|0;q=r+16|0;l=r+20|0;m=r+12|0;n=r+8|0;o=r+4|0;p=r;if(!(c[f+4>>2]&1)){c[q>>2]=-1;p=c[(c[b>>2]|0)+16>>2]|0;c[l>>2]=c[d>>2];c[m>>2]=c[e>>2];c[j>>2]=c[l>>2];c[k>>2]=c[m>>2];j=Db[p&63](b,j,k,f,g,q)|0;c[d>>2]=j;switch(c[q>>2]|0){case 0:{a[h>>0]=0;break}case 1:{a[h>>0]=1;break}default:{a[h>>0]=1;c[g>>2]=4}}}else{b=gm(f)|0;c[n>>2]=b;q=Om(n,1150100)|0;du(b)|0;f=gm(f)|0;c[o>>2]=f;b=Om(o,1150112)|0;du(f)|0;Cb[c[(c[b>>2]|0)+24>>2]&63](j,b);Cb[c[(c[b>>2]|0)+28>>2]&63](j+12|0,b);c[p>>2]=c[e>>2];c[k>>2]=c[p>>2];a[h>>0]=(Sm(d,k,j,j+24|0,q,g,1)|0)==(j|0)&1;h=c[d>>2]|0;vk(j+12|0);vk(j);j=h}i=r;return j|0}function Om(a,b){a=a|0;b=b|0;a=c[a>>2]|0;b=Pm(b)|0;return c[(c[a+8>>2]|0)+(b<<2)>>2]|0}function Pm(a){a=a|0;var b=0,d=0;d=i;i=i+16|0;b=d;if((c[a>>2]|0)!=-1){c[b>>2]=a;c[b+4>>2]=159;c[b+8>>2]=0;nk(a,b,160)}i=d;return (c[a+4>>2]|0)+-1|0}function Qm(a){a=a|0;var b=0;b=c[287527]|0;c[287527]=b+1;c[a+4>>2]=b+1;return}function Rm(a){a=a|0;var b=0,d=0;b=c[a+4>>2]|0;d=c[a+8>>2]|0;a=(c[a>>2]|0)+(d>>1)|0;if(d&1)b=c[(c[a>>2]|0)+b>>2]|0;Bb[b&255](a);return}function Sm(b,e,f,g,h,j,k){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0;z=i;i=i+112|0;m=z;n=(g-f|0)/12|0;if(n>>>0>100){m=zj(n)|0;if(!m)Tu();else{x=m;l=m}}else{x=0;l=m}q=f;m=0;p=l;while(1){if((q|0)==(g|0))break;o=a[q>>0]|0;if(!(o&1))o=(o&255)>>>1;else o=c[q+4>>2]|0;if(!o){a[p>>0]=2;m=m+1|0;n=n+-1|0}else a[p>>0]=1;q=q+12|0;p=p+1|0}w=0;t=m;r=n;a:while(1){m=c[b>>2]|0;do if(m){if((c[m+12>>2]|0)==(c[m+16>>2]|0))if((Fb[c[(c[m>>2]|0)+36>>2]&127](m)|0)==-1){c[b>>2]=0;m=0;break}else{m=c[b>>2]|0;break}}else m=0;while(0);p=(m|0)==0;n=c[e>>2]|0;if(n){if((c[n+12>>2]|0)==(c[n+16>>2]|0)?(Fb[c[(c[n>>2]|0)+36>>2]&127](n)|0)==-1:0){c[e>>2]=0;n=0}}else n=0;o=(n|0)==0;m=c[b>>2]|0;if(!((r|0)!=0&(p^o)))break;n=c[m+12>>2]|0;if((n|0)==(c[m+16>>2]|0))m=Fb[c[(c[m>>2]|0)+36>>2]&127](m)|0;else m=d[n>>0]|0;m=m&255;if(!k)m=Lb[c[(c[h>>2]|0)+12>>2]&63](h,m)|0;v=w+1|0;q=0;s=f;u=r;r=l;while(1){if((s|0)==(g|0))break;do if((a[r>>0]|0)==1){if(!(a[s>>0]&1))n=s+1|0;else n=c[s+8>>2]|0;n=a[n+w>>0]|0;if(!k)n=Lb[c[(c[h>>2]|0)+12>>2]&63](h,n)|0;if(m<<24>>24!=n<<24>>24){a[r>>0]=0;n=q;o=t;p=u+-1|0;break}n=a[s>>0]|0;if(!(n&1))n=(n&255)>>>1;else n=c[s+4>>2]|0;if((n|0)==(v|0)){a[r>>0]=2;n=1;o=t+1|0;p=u+-1|0}else{n=1;o=t;p=u}}else{n=q;o=t;p=u}while(0);q=n;s=s+12|0;t=o;u=p;r=r+1|0}if(!q){w=v;r=u;continue}m=c[b>>2]|0;n=m+12|0;o=c[n>>2]|0;if((o|0)==(c[m+16>>2]|0))Fb[c[(c[m>>2]|0)+40>>2]&127](m)|0;else c[n>>2]=o+1;if((t+u|0)>>>0>1){p=f;m=t;o=l}else{w=v;r=u;continue}while(1){if((p|0)==(g|0)){w=v;t=m;r=u;continue a}if((a[o>>0]|0)==2){n=a[p>>0]|0;if(!(n&1))n=(n&255)>>>1;else n=c[p+4>>2]|0;if((n|0)!=(v|0)){a[o>>0]=0;m=m+-1|0}}p=p+12|0;o=o+1|0}}do if(m){if((c[m+12>>2]|0)==(c[m+16>>2]|0))if((Fb[c[(c[m>>2]|0)+36>>2]&127](m)|0)==-1){c[b>>2]=0;m=0;break}else{m=c[b>>2]|0;break}}else m=0;while(0);m=(m|0)==0;do if(!o){if((c[n+12>>2]|0)==(c[n+16>>2]|0)?(Fb[c[(c[n>>2]|0)+36>>2]&127](n)|0)==-1:0){c[e>>2]=0;y=34;break}if(!m)y=69}else y=34;while(0);if((y|0)==34)if(m)y=69;if((y|0)==69)c[j>>2]=c[j>>2]|2;while(1){if((f|0)==(g|0)){y=73;break}if((a[l>>0]|0)==2)break;f=f+12|0;l=l+1|0}if((y|0)==73){c[j>>2]=c[j>>2]|4;f=g}Aj(x);i=z;return f|0}function Tm(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;h=i;i=i+16|0;j=h+12|0;k=h+8|0;m=h+4|0;l=h;c[m>>2]=c[b>>2];c[l>>2]=c[d>>2];c[k>>2]=c[m>>2];c[j>>2]=c[l>>2];a=Um(a,k,j,e,f,g)|0;i=h;return a|0}function Um(b,e,f,g,h,j){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0;A=i;i=i+224|0;s=A+198|0;k=A+196|0;z=A+184|0;y=A+172|0;w=A+168|0;x=A+8|0;u=A+4|0;t=A;switch(c[g+4>>2]&74|0){case 64:{v=8;break}case 8:{v=16;break}case 0:{v=0;break}default:v=10}Vm(z,g,s,k);b=0;while(1){if((b|0)==3)break;c[y+(b<<2)>>2]=0;b=b+1|0}if(!(a[y>>0]&1))b=10;else b=(c[y>>2]&-2)+-1|0;Bk(y,b,0);p=y+8|0;q=y+1|0;n=(a[y>>0]&1)==0?q:c[p>>2]|0;c[w>>2]=n;c[u>>2]=x;c[t>>2]=0;r=y+4|0;o=a[k>>0]|0;b=c[e>>2]|0;k=n;a:while(1){if(b){if((c[b+12>>2]|0)==(c[b+16>>2]|0)?(Fb[c[(c[b>>2]|0)+36>>2]&127](b)|0)==-1:0){c[e>>2]=0;b=0}}else b=0;g=(b|0)==0;l=c[f>>2]|0;do if(l){if((c[l+12>>2]|0)!=(c[l+16>>2]|0))if(g)break;else break a;if((Fb[c[(c[l>>2]|0)+36>>2]&127](l)|0)!=-1)if(g)break;else break a;else{c[f>>2]=0;B=20;break}}else B=20;while(0);if((B|0)==20){B=0;if(g){l=0;break}else l=0}m=a[y>>0]|0;m=(m&1)==0?(m&255)>>>1:c[r>>2]|0;if((c[w>>2]|0)==(k+m|0)){Bk(y,m<<1,0);if(!(a[y>>0]&1))g=10;else g=(c[y>>2]&-2)+-1|0;Bk(y,g,0);k=(a[y>>0]&1)==0?q:c[p>>2]|0;c[w>>2]=k+m}m=b+12|0;g=c[m>>2]|0;n=b+16|0;if((g|0)==(c[n>>2]|0))g=Fb[c[(c[b>>2]|0)+36>>2]&127](b)|0;else g=d[g>>0]|0;if(Wm(g&255,v,k,w,t,o,z,x,u,s)|0)break;g=c[m>>2]|0;if((g|0)==(c[n>>2]|0)){Fb[c[(c[b>>2]|0)+40>>2]&127](b)|0;continue}else{c[m>>2]=g+1;continue}}s=a[z>>0]|0;g=c[u>>2]|0;if((((s&1)==0?(s&255)>>>1:c[z+4>>2]|0)|0)!=0?(g-x|0)<160:0){s=c[t>>2]|0;t=g+4|0;c[u>>2]=t;c[g>>2]=s;g=t}c[j>>2]=Xm(k,c[w>>2]|0,h,v)|0;Zm(z,x,g,h);if(b){if((c[b+12>>2]|0)==(c[b+16>>2]|0)?(Fb[c[(c[b>>2]|0)+36>>2]&127](b)|0)==-1:0){c[e>>2]=0;b=0}}else b=0;b=(b|0)==0;do if(l){if((c[l+12>>2]|0)==(c[l+16>>2]|0)?(Fb[c[(c[l>>2]|0)+36>>2]&127](l)|0)==-1:0){c[f>>2]=0;B=45;break}if(!b)B=46}else B=45;while(0);if((B|0)==45?b:0)B=46;if((B|0)==46)c[h>>2]=c[h>>2]|2;B=c[e>>2]|0;vk(y);vk(z);i=A;return B|0}function Vm(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0;g=i;i=i+16|0;h=g;d=gm(d)|0;c[h>>2]=d;j=Om(h,1150100)|0;Jb[c[(c[j>>2]|0)+32>>2]&7](j,21299,21325,e)|0;e=Om(h,1150112)|0;a[f>>0]=Fb[c[(c[e>>2]|0)+16>>2]&127](e)|0;Cb[c[(c[e>>2]|0)+20>>2]&63](b,e);du(d)|0;i=g;return}function Wm(b,d,e,f,g,h,i,j,k,l){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;var m=0,n=0,o=0,p=0;o=c[f>>2]|0;p=(o|0)==(e|0);do if(p){m=(a[l+24>>0]|0)==b<<24>>24;if(!m?(a[l+25>>0]|0)!=b<<24>>24:0){n=5;break}c[f>>2]=e+1;a[e>>0]=m?43:45;c[g>>2]=0;m=0}else n=5;while(0);a:do if((n|0)==5){n=a[i>>0]|0;if(b<<24>>24==h<<24>>24?(((n&1)==0?(n&255)>>>1:c[i+4>>2]|0)|0)!=0:0){m=c[k>>2]|0;if((m-j|0)>=160){m=0;break}d=c[g>>2]|0;c[k>>2]=m+4;c[m>>2]=d;c[g>>2]=0;m=0;break}i=l+26|0;m=l;while(1){if((m|0)==(i|0)){m=i;break}if((a[m>>0]|0)==b<<24>>24)break;m=m+1|0}m=m-l|0;if((m|0)>23)m=-1;else{switch(d|0){case 10:case 8:{if((m|0)>=(d|0)){m=-1;break a}break}case 16:{if((m|0)>=22){if(p){m=-1;break a}if((o-e|0)>=3){m=-1;break a}if((a[o+-1>>0]|0)!=48){m=-1;break a}c[g>>2]=0;m=a[21299+m>>0]|0;c[f>>2]=o+1;a[o>>0]=m;m=0;break a}break}default:{}}m=a[21299+m>>0]|0;c[f>>2]=o+1;a[o>>0]=m;c[g>>2]=(c[g>>2]|0)+1;m=0}}while(0);return m|0}function Xm(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0;k=i;i=i+16|0;j=k;if((a|0)==(b|0)){c[d>>2]=4;a=0}else{g=Dh()|0;h=c[g>>2]|0;c[g>>2]=0;a=tj(a,j,e,Ym()|0)|0;e=C;f=c[g>>2]|0;if(!f)c[g>>2]=h;a:do if((c[j>>2]|0)==(b|0)){do if((f|0)==34){c[d>>2]=4;if((e|0)>0|(e|0)==0&a>>>0>0){a=2147483647;break a}}else{if((e|0)<-1|(e|0)==-1&a>>>0<2147483648){c[d>>2]=4;break}if((e|0)>0|(e|0)==0&a>>>0>2147483647){c[d>>2]=4;a=2147483647;break a}else break a}while(0);a=-2147483648}else{c[d>>2]=4;a=0}while(0)}i=k;return a|0}function Ym(){if((a[989368]|0)==0?Ca(989368)|0:0){c[287530]=$i(2147483647,21332,0)|0;Ja(989368)}return c[287530]|0}function Zm(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0;g=a[b>>0]|0;i=b+4|0;h=c[i>>2]|0;do if(((g&1)==0?(g&255)>>>1:h)|0){if((d|0)!=(e|0)){g=e;h=d;while(1){g=g+-4|0;if(h>>>0>=g>>>0)break;j=c[h>>2]|0;c[h>>2]=c[g>>2];c[g>>2]=j;h=h+4|0}g=a[b>>0]|0;h=c[i>>2]|0}i=(g&1)==0;b=i?b+1|0:c[b+8>>2]|0;j=e+-4|0;e=b+(i?(g&255)>>>1:h)|0;h=d;while(1){g=a[b>>0]|0;i=g<<24>>24<1|g<<24>>24==127;if(h>>>0>=j>>>0)break;if(!i?(g<<24>>24|0)!=(c[h>>2]|0):0){k=10;break}b=(e-b|0)>1?b+1|0:b;h=h+4|0}if((k|0)==10){c[f>>2]=4;break}if(!i?((c[j>>2]|0)+-1|0)>>>0>=g<<24>>24>>>0:0)c[f>>2]=4}while(0);return}function _m(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;h=i;i=i+16|0;j=h+12|0;k=h+8|0;m=h+4|0;l=h;c[m>>2]=c[b>>2];c[l>>2]=c[d>>2];c[k>>2]=c[m>>2];c[j>>2]=c[l>>2];a=$m(a,k,j,e,f,g)|0;i=h;return a|0}function $m(b,e,f,g,h,j){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0;A=i;i=i+224|0;s=A+198|0;k=A+196|0;z=A+184|0;y=A+172|0;w=A+168|0;x=A+8|0;u=A+4|0;t=A;switch(c[g+4>>2]&74|0){case 64:{v=8;break}case 8:{v=16;break}case 0:{v=0;break}default:v=10}Vm(z,g,s,k);b=0;while(1){if((b|0)==3)break;c[y+(b<<2)>>2]=0;b=b+1|0}if(!(a[y>>0]&1))b=10;else b=(c[y>>2]&-2)+-1|0;Bk(y,b,0);p=y+8|0;q=y+1|0;n=(a[y>>0]&1)==0?q:c[p>>2]|0;c[w>>2]=n;c[u>>2]=x;c[t>>2]=0;r=y+4|0;o=a[k>>0]|0;b=c[e>>2]|0;k=n;a:while(1){if(b){if((c[b+12>>2]|0)==(c[b+16>>2]|0)?(Fb[c[(c[b>>2]|0)+36>>2]&127](b)|0)==-1:0){c[e>>2]=0;b=0}}else b=0;g=(b|0)==0;l=c[f>>2]|0;do if(l){if((c[l+12>>2]|0)!=(c[l+16>>2]|0))if(g)break;else break a;if((Fb[c[(c[l>>2]|0)+36>>2]&127](l)|0)!=-1)if(g)break;else break a;else{c[f>>2]=0;B=20;break}}else B=20;while(0);if((B|0)==20){B=0;if(g){l=0;break}else l=0}m=a[y>>0]|0;m=(m&1)==0?(m&255)>>>1:c[r>>2]|0;if((c[w>>2]|0)==(k+m|0)){Bk(y,m<<1,0);if(!(a[y>>0]&1))g=10;else g=(c[y>>2]&-2)+-1|0;Bk(y,g,0);k=(a[y>>0]&1)==0?q:c[p>>2]|0;c[w>>2]=k+m}m=b+12|0;g=c[m>>2]|0;n=b+16|0;if((g|0)==(c[n>>2]|0))g=Fb[c[(c[b>>2]|0)+36>>2]&127](b)|0;else g=d[g>>0]|0;if(Wm(g&255,v,k,w,t,o,z,x,u,s)|0)break;g=c[m>>2]|0;if((g|0)==(c[n>>2]|0)){Fb[c[(c[b>>2]|0)+40>>2]&127](b)|0;continue}else{c[m>>2]=g+1;continue}}s=a[z>>0]|0;g=c[u>>2]|0;if((((s&1)==0?(s&255)>>>1:c[z+4>>2]|0)|0)!=0?(g-x|0)<160:0){s=c[t>>2]|0;t=g+4|0;c[u>>2]=t;c[g>>2]=s;g=t}w=an(k,c[w>>2]|0,h,v)|0;c[j>>2]=w;c[j+4>>2]=C;Zm(z,x,g,h);if(b){if((c[b+12>>2]|0)==(c[b+16>>2]|0)?(Fb[c[(c[b>>2]|0)+36>>2]&127](b)|0)==-1:0){c[e>>2]=0;b=0}}else b=0;b=(b|0)==0;do if(l){if((c[l+12>>2]|0)==(c[l+16>>2]|0)?(Fb[c[(c[l>>2]|0)+36>>2]&127](l)|0)==-1:0){c[f>>2]=0;B=45;break}if(!b)B=46}else B=45;while(0);if((B|0)==45?b:0)B=46;if((B|0)==46)c[h>>2]=c[h>>2]|2;B=c[e>>2]|0;vk(y);vk(z);i=A;return B|0}function an(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0;k=i;i=i+16|0;j=k;if((a|0)==(b|0)){c[d>>2]=4;e=0;a=0}else{g=Dh()|0;h=c[g>>2]|0;c[g>>2]=0;a=tj(a,j,e,Ym()|0)|0;e=C;f=c[g>>2]|0;if(!f)c[g>>2]=h;if((c[j>>2]|0)==(b|0)){if((f|0)==34){c[d>>2]=4;e=(e|0)>0|(e|0)==0&a>>>0>0;a=e?-1:0;e=e?2147483647:-2147483648}}else{c[d>>2]=4;a=0;e=0}}C=e;i=k;return a|0}function bn(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;h=i;i=i+16|0;j=h+12|0;k=h+8|0;m=h+4|0;l=h;c[m>>2]=c[b>>2];c[l>>2]=c[d>>2];c[k>>2]=c[m>>2];c[j>>2]=c[l>>2];a=cn(a,k,j,e,f,g)|0;i=h;return a|0}function cn(e,f,g,h,j,k){e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0;B=i;i=i+224|0;t=B+198|0;l=B+196|0;A=B+184|0;z=B+172|0;x=B+168|0;y=B+8|0;v=B+4|0;u=B;switch(c[h+4>>2]&74|0){case 64:{w=8;break}case 8:{w=16;break}case 0:{w=0;break}default:w=10}Vm(A,h,t,l);e=0;while(1){if((e|0)==3)break;c[z+(e<<2)>>2]=0;e=e+1|0}if(!(a[z>>0]&1))e=10;else e=(c[z>>2]&-2)+-1|0;Bk(z,e,0);q=z+8|0;r=z+1|0;o=(a[z>>0]&1)==0?r:c[q>>2]|0;c[x>>2]=o;c[v>>2]=y;c[u>>2]=0;s=z+4|0;p=a[l>>0]|0;e=c[f>>2]|0;l=o;a:while(1){if(e){if((c[e+12>>2]|0)==(c[e+16>>2]|0)?(Fb[c[(c[e>>2]|0)+36>>2]&127](e)|0)==-1:0){c[f>>2]=0;e=0}}else e=0;h=(e|0)==0;m=c[g>>2]|0;do if(m){if((c[m+12>>2]|0)!=(c[m+16>>2]|0))if(h)break;else break a;if((Fb[c[(c[m>>2]|0)+36>>2]&127](m)|0)!=-1)if(h)break;else break a;else{c[g>>2]=0;C=20;break}}else C=20;while(0);if((C|0)==20){C=0;if(h){m=0;break}else m=0}n=a[z>>0]|0;n=(n&1)==0?(n&255)>>>1:c[s>>2]|0;if((c[x>>2]|0)==(l+n|0)){Bk(z,n<<1,0);if(!(a[z>>0]&1))h=10;else h=(c[z>>2]&-2)+-1|0;Bk(z,h,0);l=(a[z>>0]&1)==0?r:c[q>>2]|0;c[x>>2]=l+n}n=e+12|0;h=c[n>>2]|0;o=e+16|0;if((h|0)==(c[o>>2]|0))h=Fb[c[(c[e>>2]|0)+36>>2]&127](e)|0;else h=d[h>>0]|0;if(Wm(h&255,w,l,x,u,p,A,y,v,t)|0)break;h=c[n>>2]|0;if((h|0)==(c[o>>2]|0)){Fb[c[(c[e>>2]|0)+40>>2]&127](e)|0;continue}else{c[n>>2]=h+1;continue}}t=a[A>>0]|0;h=c[v>>2]|0;if((((t&1)==0?(t&255)>>>1:c[A+4>>2]|0)|0)!=0?(h-y|0)<160:0){t=c[u>>2]|0;u=h+4|0;c[v>>2]=u;c[h>>2]=t;h=u}b[k>>1]=dn(l,c[x>>2]|0,j,w)|0;Zm(A,y,h,j);if(e){if((c[e+12>>2]|0)==(c[e+16>>2]|0)?(Fb[c[(c[e>>2]|0)+36>>2]&127](e)|0)==-1:0){c[f>>2]=0;e=0}}else e=0;e=(e|0)==0;do if(m){if((c[m+12>>2]|0)==(c[m+16>>2]|0)?(Fb[c[(c[m>>2]|0)+36>>2]&127](m)|0)==-1:0){c[g>>2]=0;C=45;break}if(!e)C=46}else C=45;while(0);if((C|0)==45?e:0)C=46;if((C|0)==46)c[j>>2]=c[j>>2]|2;C=c[f>>2]|0;vk(z);vk(A);i=B;return C|0}function dn(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0;l=i;i=i+16|0;k=l;do if((b|0)==(d|0)){c[e>>2]=4;b=0}else{if((a[b>>0]|0)==45){c[e>>2]=4;b=0;break}h=Dh()|0;j=c[h>>2]|0;c[h>>2]=0;b=sj(b,k,f,Ym()|0)|0;f=C;g=c[h>>2]|0;if(!g)c[h>>2]=j;do if((c[k>>2]|0)==(d|0))if(f>>>0>0|(f|0)==0&b>>>0>65535|(g|0)==34){c[e>>2]=4;b=-1;break}else{b=b&65535;break}else{c[e>>2]=4;b=0}while(0)}while(0);i=l;return b|0}function en(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;h=i;i=i+16|0;j=h+12|0;k=h+8|0;m=h+4|0;l=h;c[m>>2]=c[b>>2];c[l>>2]=c[d>>2];c[k>>2]=c[m>>2];c[j>>2]=c[l>>2];a=fn(a,k,j,e,f,g)|0;i=h;return a|0}function fn(b,e,f,g,h,j){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0;A=i;i=i+224|0;s=A+198|0;k=A+196|0;z=A+184|0;y=A+172|0;w=A+168|0;x=A+8|0;u=A+4|0;t=A;switch(c[g+4>>2]&74|0){case 64:{v=8;break}case 8:{v=16;break}case 0:{v=0;break}default:v=10}Vm(z,g,s,k);b=0;while(1){if((b|0)==3)break;c[y+(b<<2)>>2]=0;b=b+1|0}if(!(a[y>>0]&1))b=10;else b=(c[y>>2]&-2)+-1|0;Bk(y,b,0);p=y+8|0;q=y+1|0;n=(a[y>>0]&1)==0?q:c[p>>2]|0;c[w>>2]=n;c[u>>2]=x;c[t>>2]=0;r=y+4|0;o=a[k>>0]|0;b=c[e>>2]|0;k=n;a:while(1){if(b){if((c[b+12>>2]|0)==(c[b+16>>2]|0)?(Fb[c[(c[b>>2]|0)+36>>2]&127](b)|0)==-1:0){c[e>>2]=0;b=0}}else b=0;g=(b|0)==0;l=c[f>>2]|0;do if(l){if((c[l+12>>2]|0)!=(c[l+16>>2]|0))if(g)break;else break a;if((Fb[c[(c[l>>2]|0)+36>>2]&127](l)|0)!=-1)if(g)break;else break a;else{c[f>>2]=0;B=20;break}}else B=20;while(0);if((B|0)==20){B=0;if(g){l=0;break}else l=0}m=a[y>>0]|0;m=(m&1)==0?(m&255)>>>1:c[r>>2]|0;if((c[w>>2]|0)==(k+m|0)){Bk(y,m<<1,0);if(!(a[y>>0]&1))g=10;else g=(c[y>>2]&-2)+-1|0;Bk(y,g,0);k=(a[y>>0]&1)==0?q:c[p>>2]|0;c[w>>2]=k+m}m=b+12|0;g=c[m>>2]|0;n=b+16|0;if((g|0)==(c[n>>2]|0))g=Fb[c[(c[b>>2]|0)+36>>2]&127](b)|0;else g=d[g>>0]|0;if(Wm(g&255,v,k,w,t,o,z,x,u,s)|0)break;g=c[m>>2]|0;if((g|0)==(c[n>>2]|0)){Fb[c[(c[b>>2]|0)+40>>2]&127](b)|0;continue}else{c[m>>2]=g+1;continue}}s=a[z>>0]|0;g=c[u>>2]|0;if((((s&1)==0?(s&255)>>>1:c[z+4>>2]|0)|0)!=0?(g-x|0)<160:0){s=c[t>>2]|0;t=g+4|0;c[u>>2]=t;c[g>>2]=s;g=t}c[j>>2]=gn(k,c[w>>2]|0,h,v)|0;Zm(z,x,g,h);if(b){if((c[b+12>>2]|0)==(c[b+16>>2]|0)?(Fb[c[(c[b>>2]|0)+36>>2]&127](b)|0)==-1:0){c[e>>2]=0;b=0}}else b=0;b=(b|0)==0;do if(l){if((c[l+12>>2]|0)==(c[l+16>>2]|0)?(Fb[c[(c[l>>2]|0)+36>>2]&127](l)|0)==-1:0){c[f>>2]=0;B=45;break}if(!b)B=46}else B=45;while(0);if((B|0)==45?b:0)B=46;if((B|0)==46)c[h>>2]=c[h>>2]|2;B=c[e>>2]|0;vk(y);vk(z);i=A;return B|0}function gn(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0;l=i;i=i+16|0;k=l;do if((b|0)==(d|0)){c[e>>2]=4;b=0}else{if((a[b>>0]|0)==45){c[e>>2]=4;b=0;break}h=Dh()|0;j=c[h>>2]|0;c[h>>2]=0;b=sj(b,k,f,Ym()|0)|0;f=C;g=c[h>>2]|0;if(!g)c[h>>2]=j;do if((c[k>>2]|0)==(d|0))if(f>>>0>0|(f|0)==0&b>>>0>4294967295|(g|0)==34){c[e>>2]=4;b=-1;break}else break;else{c[e>>2]=4;b=0}while(0)}while(0);i=l;return b|0}function hn(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;h=i;i=i+16|0;j=h+12|0;k=h+8|0;m=h+4|0;l=h;c[m>>2]=c[b>>2];c[l>>2]=c[d>>2];c[k>>2]=c[m>>2];c[j>>2]=c[l>>2];a=jn(a,k,j,e,f,g)|0;i=h;return a|0}function jn(b,e,f,g,h,j){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0;A=i;i=i+224|0;s=A+198|0;k=A+196|0;z=A+184|0;y=A+172|0;w=A+168|0;x=A+8|0;u=A+4|0;t=A;switch(c[g+4>>2]&74|0){case 64:{v=8;break}case 8:{v=16;break}case 0:{v=0;break}default:v=10}Vm(z,g,s,k);b=0;while(1){if((b|0)==3)break;c[y+(b<<2)>>2]=0;b=b+1|0}if(!(a[y>>0]&1))b=10;else b=(c[y>>2]&-2)+-1|0;Bk(y,b,0);p=y+8|0;q=y+1|0;n=(a[y>>0]&1)==0?q:c[p>>2]|0;c[w>>2]=n;c[u>>2]=x;c[t>>2]=0;r=y+4|0;o=a[k>>0]|0;b=c[e>>2]|0;k=n;a:while(1){if(b){if((c[b+12>>2]|0)==(c[b+16>>2]|0)?(Fb[c[(c[b>>2]|0)+36>>2]&127](b)|0)==-1:0){c[e>>2]=0;b=0}}else b=0;g=(b|0)==0;l=c[f>>2]|0;do if(l){if((c[l+12>>2]|0)!=(c[l+16>>2]|0))if(g)break;else break a;if((Fb[c[(c[l>>2]|0)+36>>2]&127](l)|0)!=-1)if(g)break;else break a;else{c[f>>2]=0;B=20;break}}else B=20;while(0);if((B|0)==20){B=0;if(g){l=0;break}else l=0}m=a[y>>0]|0;m=(m&1)==0?(m&255)>>>1:c[r>>2]|0;if((c[w>>2]|0)==(k+m|0)){Bk(y,m<<1,0);if(!(a[y>>0]&1))g=10;else g=(c[y>>2]&-2)+-1|0;Bk(y,g,0);k=(a[y>>0]&1)==0?q:c[p>>2]|0;c[w>>2]=k+m}m=b+12|0;g=c[m>>2]|0;n=b+16|0;if((g|0)==(c[n>>2]|0))g=Fb[c[(c[b>>2]|0)+36>>2]&127](b)|0;else g=d[g>>0]|0;if(Wm(g&255,v,k,w,t,o,z,x,u,s)|0)break;g=c[m>>2]|0;if((g|0)==(c[n>>2]|0)){Fb[c[(c[b>>2]|0)+40>>2]&127](b)|0;continue}else{c[m>>2]=g+1;continue}}s=a[z>>0]|0;g=c[u>>2]|0;if((((s&1)==0?(s&255)>>>1:c[z+4>>2]|0)|0)!=0?(g-x|0)<160:0){s=c[t>>2]|0;t=g+4|0;c[u>>2]=t;c[g>>2]=s;g=t}c[j>>2]=kn(k,c[w>>2]|0,h,v)|0;Zm(z,x,g,h);if(b){if((c[b+12>>2]|0)==(c[b+16>>2]|0)?(Fb[c[(c[b>>2]|0)+36>>2]&127](b)|0)==-1:0){c[e>>2]=0;b=0}}else b=0;b=(b|0)==0;do if(l){if((c[l+12>>2]|0)==(c[l+16>>2]|0)?(Fb[c[(c[l>>2]|0)+36>>2]&127](l)|0)==-1:0){c[f>>2]=0;B=45;break}if(!b)B=46}else B=45;while(0);if((B|0)==45?b:0)B=46;if((B|0)==46)c[h>>2]=c[h>>2]|2;B=c[e>>2]|0;vk(y);vk(z);i=A;return B|0}function kn(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0;l=i;i=i+16|0;k=l;do if((b|0)==(d|0)){c[e>>2]=4;b=0}else{if((a[b>>0]|0)==45){c[e>>2]=4;b=0;break}h=Dh()|0;j=c[h>>2]|0;c[h>>2]=0;b=sj(b,k,f,Ym()|0)|0;f=C;g=c[h>>2]|0;if(!g)c[h>>2]=j;do if((c[k>>2]|0)==(d|0))if(f>>>0>0|(f|0)==0&b>>>0>4294967295|(g|0)==34){c[e>>2]=4;b=-1;break}else break;else{c[e>>2]=4;b=0}while(0)}while(0);i=l;return b|0}function ln(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;h=i;i=i+16|0;j=h+12|0;k=h+8|0;m=h+4|0;l=h;c[m>>2]=c[b>>2];c[l>>2]=c[d>>2];c[k>>2]=c[m>>2];c[j>>2]=c[l>>2];a=mn(a,k,j,e,f,g)|0;i=h;return a|0}function mn(b,e,f,g,h,j){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0;A=i;i=i+224|0;s=A+198|0;k=A+196|0;z=A+184|0;y=A+172|0;w=A+168|0;x=A+8|0;u=A+4|0;t=A;switch(c[g+4>>2]&74|0){case 64:{v=8;break}case 8:{v=16;break}case 0:{v=0;break}default:v=10}Vm(z,g,s,k);b=0;while(1){if((b|0)==3)break;c[y+(b<<2)>>2]=0;b=b+1|0}if(!(a[y>>0]&1))b=10;else b=(c[y>>2]&-2)+-1|0;Bk(y,b,0);p=y+8|0;q=y+1|0;n=(a[y>>0]&1)==0?q:c[p>>2]|0;c[w>>2]=n;c[u>>2]=x;c[t>>2]=0;r=y+4|0;o=a[k>>0]|0;b=c[e>>2]|0;k=n;a:while(1){if(b){if((c[b+12>>2]|0)==(c[b+16>>2]|0)?(Fb[c[(c[b>>2]|0)+36>>2]&127](b)|0)==-1:0){c[e>>2]=0;b=0}}else b=0;g=(b|0)==0;l=c[f>>2]|0;do if(l){if((c[l+12>>2]|0)!=(c[l+16>>2]|0))if(g)break;else break a;if((Fb[c[(c[l>>2]|0)+36>>2]&127](l)|0)!=-1)if(g)break;else break a;else{c[f>>2]=0;B=20;break}}else B=20;while(0);if((B|0)==20){B=0;if(g){l=0;break}else l=0}m=a[y>>0]|0;m=(m&1)==0?(m&255)>>>1:c[r>>2]|0;if((c[w>>2]|0)==(k+m|0)){Bk(y,m<<1,0);if(!(a[y>>0]&1))g=10;else g=(c[y>>2]&-2)+-1|0;Bk(y,g,0);k=(a[y>>0]&1)==0?q:c[p>>2]|0;c[w>>2]=k+m}m=b+12|0;g=c[m>>2]|0;n=b+16|0;if((g|0)==(c[n>>2]|0))g=Fb[c[(c[b>>2]|0)+36>>2]&127](b)|0;else g=d[g>>0]|0;if(Wm(g&255,v,k,w,t,o,z,x,u,s)|0)break;g=c[m>>2]|0;if((g|0)==(c[n>>2]|0)){Fb[c[(c[b>>2]|0)+40>>2]&127](b)|0;continue}else{c[m>>2]=g+1;continue}}s=a[z>>0]|0;g=c[u>>2]|0;if((((s&1)==0?(s&255)>>>1:c[z+4>>2]|0)|0)!=0?(g-x|0)<160:0){s=c[t>>2]|0;t=g+4|0;c[u>>2]=t;c[g>>2]=s;g=t}w=nn(k,c[w>>2]|0,h,v)|0;c[j>>2]=w;c[j+4>>2]=C;Zm(z,x,g,h);if(b){if((c[b+12>>2]|0)==(c[b+16>>2]|0)?(Fb[c[(c[b>>2]|0)+36>>2]&127](b)|0)==-1:0){c[e>>2]=0;b=0}}else b=0;b=(b|0)==0;do if(l){if((c[l+12>>2]|0)==(c[l+16>>2]|0)?(Fb[c[(c[l>>2]|0)+36>>2]&127](l)|0)==-1:0){c[f>>2]=0;B=45;break}if(!b)B=46}else B=45;while(0);if((B|0)==45?b:0)B=46;if((B|0)==46)c[h>>2]=c[h>>2]|2;B=c[e>>2]|0;vk(y);vk(z);i=A;return B|0}function nn(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0;l=i;i=i+16|0;k=l;do if((b|0)==(d|0)){c[e>>2]=4;f=0;b=0}else{if((a[b>>0]|0)==45){c[e>>2]=4;f=0;b=0;break}h=Dh()|0;j=c[h>>2]|0;c[h>>2]=0;b=sj(b,k,f,Ym()|0)|0;f=C;g=c[h>>2]|0;if(!g)c[h>>2]=j;if((c[k>>2]|0)==(d|0)){if((g|0)==34){c[e>>2]=4;b=-1;f=-1}}else{c[e>>2]=4;b=0;f=0}}while(0);C=f;i=l;return b|0}function on(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;h=i;i=i+16|0;j=h+12|0;k=h+8|0;m=h+4|0;l=h;c[m>>2]=c[b>>2];c[l>>2]=c[d>>2];c[k>>2]=c[m>>2];c[j>>2]=c[l>>2];a=pn(a,k,j,e,f,g)|0;i=h;return a|0}function pn(b,e,f,h,j,k){b=b|0;e=e|0;f=f|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0;D=i;i=i+240|0;u=D+200|0;l=D+199|0;m=D+198|0;C=D+184|0;B=D+172|0;z=D+168|0;A=D+8|0;x=D+4|0;w=D;y=D+197|0;v=D+196|0;qn(C,h,u,l,m);b=0;while(1){if((b|0)==3)break;c[B+(b<<2)>>2]=0;b=b+1|0}if(!(a[B>>0]&1))b=10;else b=(c[B>>2]&-2)+-1|0;Bk(B,b,0);r=B+8|0;s=B+1|0;o=(a[B>>0]&1)==0?s:c[r>>2]|0;c[z>>2]=o;c[x>>2]=A;c[w>>2]=0;a[y>>0]=1;a[v>>0]=69;t=B+4|0;q=a[l>>0]|0;p=a[m>>0]|0;b=c[e>>2]|0;l=o;a:while(1){if(b){if((c[b+12>>2]|0)==(c[b+16>>2]|0)?(Fb[c[(c[b>>2]|0)+36>>2]&127](b)|0)==-1:0){c[e>>2]=0;b=0}}else b=0;h=(b|0)==0;m=c[f>>2]|0;do if(m){if((c[m+12>>2]|0)!=(c[m+16>>2]|0))if(h)break;else break a;if((Fb[c[(c[m>>2]|0)+36>>2]&127](m)|0)!=-1)if(h)break;else break a;else{c[f>>2]=0;E=16;break}}else E=16;while(0);if((E|0)==16){E=0;if(h){m=0;break}else m=0}n=a[B>>0]|0;n=(n&1)==0?(n&255)>>>1:c[t>>2]|0;if((c[z>>2]|0)==(l+n|0)){Bk(B,n<<1,0);if(!(a[B>>0]&1))h=10;else h=(c[B>>2]&-2)+-1|0;Bk(B,h,0);l=(a[B>>0]&1)==0?s:c[r>>2]|0;c[z>>2]=l+n}n=b+12|0;h=c[n>>2]|0;o=b+16|0;if((h|0)==(c[o>>2]|0))h=Fb[c[(c[b>>2]|0)+36>>2]&127](b)|0;else h=d[h>>0]|0;if(rn(h&255,y,v,l,z,q,p,C,A,x,w,u)|0)break;h=c[n>>2]|0;if((h|0)==(c[o>>2]|0)){Fb[c[(c[b>>2]|0)+40>>2]&127](b)|0;continue}else{c[n>>2]=h+1;continue}}v=a[C>>0]|0;h=c[x>>2]|0;if(!((a[y>>0]|0)==0?1:(((v&1)==0?(v&255)>>>1:c[C+4>>2]|0)|0)==0)?(h-A|0)<160:0){w=c[w>>2]|0;y=h+4|0;c[x>>2]=y;c[h>>2]=w;h=y}g[k>>2]=+sn(l,c[z>>2]|0,j);Zm(C,A,h,j);if(b){if((c[b+12>>2]|0)==(c[b+16>>2]|0)?(Fb[c[(c[b>>2]|0)+36>>2]&127](b)|0)==-1:0){c[e>>2]=0;b=0}}else b=0;b=(b|0)==0;do if(m){if((c[m+12>>2]|0)==(c[m+16>>2]|0)?(Fb[c[(c[m>>2]|0)+36>>2]&127](m)|0)==-1:0){c[f>>2]=0;E=41;break}if(!b)E=42}else E=41;while(0);if((E|0)==41?b:0)E=42;if((E|0)==42)c[j>>2]=c[j>>2]|2;E=c[e>>2]|0;vk(B);vk(C);i=D;return E|0}function qn(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0;h=i;i=i+16|0;j=h;d=gm(d)|0;c[j>>2]=d;k=Om(j,1150100)|0;Jb[c[(c[k>>2]|0)+32>>2]&7](k,21299,21331,e)|0;e=Om(j,1150112)|0;a[f>>0]=Fb[c[(c[e>>2]|0)+12>>2]&127](e)|0;a[g>>0]=Fb[c[(c[e>>2]|0)+16>>2]&127](e)|0;Cb[c[(c[e>>2]|0)+20>>2]&63](b,e);du(d)|0;i=h;return}function rn(b,e,f,g,h,i,j,k,l,m,n,o){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;m=m|0;n=n|0;o=o|0;var p=0,q=0;a:do if(b<<24>>24==i<<24>>24)if(a[e>>0]|0){a[e>>0]=0;f=c[h>>2]|0;c[h>>2]=f+1;a[f>>0]=46;f=a[k>>0]|0;if((((f&1)==0?(f&255)>>>1:c[k+4>>2]|0)|0)!=0?(p=c[m>>2]|0,(p-l|0)<160):0){l=c[n>>2]|0;c[m>>2]=p+4;c[p>>2]=l;p=0}else p=0}else p=-1;else{if(b<<24>>24==j<<24>>24?(j=a[k>>0]|0,((j&1)==0?(j&255)>>>1:c[k+4>>2]|0)|0):0){if(!(a[e>>0]|0)){p=-1;break}p=c[m>>2]|0;if((p-l|0)>=160){p=0;break}l=c[n>>2]|0;c[m>>2]=p+4;c[p>>2]=l;c[n>>2]=0;p=0;break}i=o+32|0;p=o;while(1){if((p|0)==(i|0)){p=i;break}if((a[p>>0]|0)==b<<24>>24)break;p=p+1|0}i=p-o|0;if((i|0)>31)p=-1;else{j=a[21299+i>>0]|0;switch(i|0){case 24:case 25:{p=c[h>>2]|0;if((p|0)!=(g|0)?(d[p+-1>>0]&95|0)!=(d[f>>0]&127|0):0){p=-1;break a}c[h>>2]=p+1;a[p>>0]=j;p=0;break a}case 23:case 22:{a[f>>0]=80;p=c[h>>2]|0;c[h>>2]=p+1;a[p>>0]=j;p=0;break a}default:{p=j&95;if((((p|0)==(a[f>>0]|0)?(a[f>>0]=p|128,a[e>>0]|0):0)?(a[e>>0]=0,f=a[k>>0]|0,((f&1)==0?(f&255)>>>1:c[k+4>>2]|0)|0):0)?(q=c[m>>2]|0,(q-l|0)<160):0){l=c[n>>2]|0;c[m>>2]=q+4;c[q>>2]=l}m=c[h>>2]|0;c[h>>2]=m+1;a[m>>0]=j;if((i|0)>21){p=0;break a}c[n>>2]=(c[n>>2]|0)+1;p=0;break a}}}}while(0);return p|0}function sn(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0,g=0,h=0,j=0;j=i;i=i+16|0;h=j;if((a|0)==(b|0)){c[d>>2]=4;e=0.0}else{f=Dh()|0;g=c[f>>2]|0;c[f>>2]=0;e=+oj(a,h,Ym()|0);a=c[f>>2]|0;if(!a)c[f>>2]=g;if((c[h>>2]|0)==(b|0)){if((a|0)==34)c[d>>2]=4}else{c[d>>2]=4;e=0.0}}i=j;return +e}function tn(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;h=i;i=i+16|0;j=h+12|0;k=h+8|0;m=h+4|0;l=h;c[m>>2]=c[b>>2];c[l>>2]=c[d>>2];c[k>>2]=c[m>>2];c[j>>2]=c[l>>2];a=un(a,k,j,e,f,g)|0;i=h;return a|0}function un(b,e,f,g,j,k){b=b|0;e=e|0;f=f|0;g=g|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0;D=i;i=i+240|0;u=D+200|0;l=D+199|0;m=D+198|0;C=D+184|0;B=D+172|0;z=D+168|0;A=D+8|0;x=D+4|0;w=D;y=D+197|0;v=D+196|0;qn(C,g,u,l,m);b=0;while(1){if((b|0)==3)break;c[B+(b<<2)>>2]=0;b=b+1|0}if(!(a[B>>0]&1))b=10;else b=(c[B>>2]&-2)+-1|0;Bk(B,b,0);r=B+8|0;s=B+1|0;o=(a[B>>0]&1)==0?s:c[r>>2]|0;c[z>>2]=o;c[x>>2]=A;c[w>>2]=0;a[y>>0]=1;a[v>>0]=69;t=B+4|0;q=a[l>>0]|0;p=a[m>>0]|0;b=c[e>>2]|0;l=o;a:while(1){if(b){if((c[b+12>>2]|0)==(c[b+16>>2]|0)?(Fb[c[(c[b>>2]|0)+36>>2]&127](b)|0)==-1:0){c[e>>2]=0;b=0}}else b=0;g=(b|0)==0;m=c[f>>2]|0;do if(m){if((c[m+12>>2]|0)!=(c[m+16>>2]|0))if(g)break;else break a;if((Fb[c[(c[m>>2]|0)+36>>2]&127](m)|0)!=-1)if(g)break;else break a;else{c[f>>2]=0;E=16;break}}else E=16;while(0);if((E|0)==16){E=0;if(g){m=0;break}else m=0}n=a[B>>0]|0;n=(n&1)==0?(n&255)>>>1:c[t>>2]|0;if((c[z>>2]|0)==(l+n|0)){Bk(B,n<<1,0);if(!(a[B>>0]&1))g=10;else g=(c[B>>2]&-2)+-1|0;Bk(B,g,0);l=(a[B>>0]&1)==0?s:c[r>>2]|0;c[z>>2]=l+n}n=b+12|0;g=c[n>>2]|0;o=b+16|0;if((g|0)==(c[o>>2]|0))g=Fb[c[(c[b>>2]|0)+36>>2]&127](b)|0;else g=d[g>>0]|0;if(rn(g&255,y,v,l,z,q,p,C,A,x,w,u)|0)break;g=c[n>>2]|0;if((g|0)==(c[o>>2]|0)){Fb[c[(c[b>>2]|0)+40>>2]&127](b)|0;continue}else{c[n>>2]=g+1;continue}}v=a[C>>0]|0;g=c[x>>2]|0;if(!((a[y>>0]|0)==0?1:(((v&1)==0?(v&255)>>>1:c[C+4>>2]|0)|0)==0)?(g-A|0)<160:0){w=c[w>>2]|0;y=g+4|0;c[x>>2]=y;c[g>>2]=w;g=y}h[k>>3]=+vn(l,c[z>>2]|0,j);Zm(C,A,g,j);if(b){if((c[b+12>>2]|0)==(c[b+16>>2]|0)?(Fb[c[(c[b>>2]|0)+36>>2]&127](b)|0)==-1:0){c[e>>2]=0;b=0}}else b=0;b=(b|0)==0;do if(m){if((c[m+12>>2]|0)==(c[m+16>>2]|0)?(Fb[c[(c[m>>2]|0)+36>>2]&127](m)|0)==-1:0){c[f>>2]=0;E=41;break}if(!b)E=42}else E=41;while(0);if((E|0)==41?b:0)E=42;if((E|0)==42)c[j>>2]=c[j>>2]|2;E=c[e>>2]|0;vk(B);vk(C);i=D;return E|0}function vn(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0,g=0,h=0,j=0;j=i;i=i+16|0;h=j;if((a|0)==(b|0)){c[d>>2]=4;e=0.0}else{f=Dh()|0;g=c[f>>2]|0;c[f>>2]=0;e=+oj(a,h,Ym()|0);a=c[f>>2]|0;if(!a)c[f>>2]=g;if((c[h>>2]|0)==(b|0)){if((a|0)==34)c[d>>2]=4}else{c[d>>2]=4;e=0.0}}i=j;return +e}function wn(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;h=i;i=i+16|0;j=h+12|0;k=h+8|0;m=h+4|0;l=h;c[m>>2]=c[b>>2];c[l>>2]=c[d>>2];c[k>>2]=c[m>>2];c[j>>2]=c[l>>2];a=xn(a,k,j,e,f,g)|0;i=h;return a|0}function xn(b,e,f,g,j,k){b=b|0;e=e|0;f=f|0;g=g|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0;D=i;i=i+240|0;u=D+200|0;l=D+199|0;m=D+198|0;C=D+184|0;B=D+172|0;z=D+168|0;A=D+8|0;x=D+4|0;w=D;y=D+197|0;v=D+196|0;qn(C,g,u,l,m);b=0;while(1){if((b|0)==3)break;c[B+(b<<2)>>2]=0;b=b+1|0}if(!(a[B>>0]&1))b=10;else b=(c[B>>2]&-2)+-1|0;Bk(B,b,0);r=B+8|0;s=B+1|0;o=(a[B>>0]&1)==0?s:c[r>>2]|0;c[z>>2]=o;c[x>>2]=A;c[w>>2]=0;a[y>>0]=1;a[v>>0]=69;t=B+4|0;q=a[l>>0]|0;p=a[m>>0]|0;b=c[e>>2]|0;l=o;a:while(1){if(b){if((c[b+12>>2]|0)==(c[b+16>>2]|0)?(Fb[c[(c[b>>2]|0)+36>>2]&127](b)|0)==-1:0){c[e>>2]=0;b=0}}else b=0;g=(b|0)==0;m=c[f>>2]|0;do if(m){if((c[m+12>>2]|0)!=(c[m+16>>2]|0))if(g)break;else break a;if((Fb[c[(c[m>>2]|0)+36>>2]&127](m)|0)!=-1)if(g)break;else break a;else{c[f>>2]=0;E=16;break}}else E=16;while(0);if((E|0)==16){E=0;if(g){m=0;break}else m=0}n=a[B>>0]|0;n=(n&1)==0?(n&255)>>>1:c[t>>2]|0;if((c[z>>2]|0)==(l+n|0)){Bk(B,n<<1,0);if(!(a[B>>0]&1))g=10;else g=(c[B>>2]&-2)+-1|0;Bk(B,g,0);l=(a[B>>0]&1)==0?s:c[r>>2]|0;c[z>>2]=l+n}n=b+12|0;g=c[n>>2]|0;o=b+16|0;if((g|0)==(c[o>>2]|0))g=Fb[c[(c[b>>2]|0)+36>>2]&127](b)|0;else g=d[g>>0]|0;if(rn(g&255,y,v,l,z,q,p,C,A,x,w,u)|0)break;g=c[n>>2]|0;if((g|0)==(c[o>>2]|0)){Fb[c[(c[b>>2]|0)+40>>2]&127](b)|0;continue}else{c[n>>2]=g+1;continue}}v=a[C>>0]|0;g=c[x>>2]|0;if(!((a[y>>0]|0)==0?1:(((v&1)==0?(v&255)>>>1:c[C+4>>2]|0)|0)==0)?(g-A|0)<160:0){w=c[w>>2]|0;y=g+4|0;c[x>>2]=y;c[g>>2]=w;g=y}h[k>>3]=+yn(l,c[z>>2]|0,j);Zm(C,A,g,j);if(b){if((c[b+12>>2]|0)==(c[b+16>>2]|0)?(Fb[c[(c[b>>2]|0)+36>>2]&127](b)|0)==-1:0){c[e>>2]=0;b=0}}else b=0;b=(b|0)==0;do if(m){if((c[m+12>>2]|0)==(c[m+16>>2]|0)?(Fb[c[(c[m>>2]|0)+36>>2]&127](m)|0)==-1:0){c[f>>2]=0;E=41;break}if(!b)E=42}else E=41;while(0);if((E|0)==41?b:0)E=42;if((E|0)==42)c[j>>2]=c[j>>2]|2;E=c[e>>2]|0;vk(B);vk(C);i=D;return E|0}function yn(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0,g=0,h=0,j=0;j=i;i=i+16|0;h=j;if((a|0)==(b|0)){c[d>>2]=4;e=0.0}else{f=Dh()|0;g=c[f>>2]|0;c[f>>2]=0;e=+oj(a,h,Ym()|0);a=c[f>>2]|0;if(!a)c[f>>2]=g;if((c[h>>2]|0)==(b|0)){if((a|0)==34)c[d>>2]=4}else{c[d>>2]=4;e=0.0}}i=j;return +e}function zn(b,e,f,g,h,j){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0;z=i;i=i+240|0;w=z;r=z+208|0;y=z+196|0;b=z+180|0;x=z+184|0;v=z+176|0;t=z+16|0;u=z+8|0;s=z+4|0;k=0;while(1){if((k|0)==3)break;c[y+(k<<2)>>2]=0;k=k+1|0}q=gm(g)|0;c[b>>2]=q;b=Om(b,1150100)|0;Jb[c[(c[b>>2]|0)+32>>2]&7](b,21299,21325,r)|0;du(q)|0;b=0;while(1){if((b|0)==3)break;c[x+(b<<2)>>2]=0;b=b+1|0}if(!(a[x>>0]&1))b=10;else b=(c[x>>2]&-2)+-1|0;Bk(x,b,0);p=x+8|0;q=x+1|0;k=(a[x>>0]&1)==0?q:c[p>>2]|0;c[v>>2]=k;c[u>>2]=t;c[s>>2]=0;o=x+4|0;b=c[e>>2]|0;a:while(1){if(b){if((c[b+12>>2]|0)==(c[b+16>>2]|0)?(Fb[c[(c[b>>2]|0)+36>>2]&127](b)|0)==-1:0){c[e>>2]=0;b=0}}else b=0;l=(b|0)==0;g=c[f>>2]|0;do if(g){if((c[g+12>>2]|0)!=(c[g+16>>2]|0))if(l)break;else break a;if((Fb[c[(c[g>>2]|0)+36>>2]&127](g)|0)!=-1)if(l)break;else break a;else{c[f>>2]=0;A=19;break}}else A=19;while(0);if((A|0)==19){A=0;if(l){g=0;break}else g=0}l=a[x>>0]|0;l=(l&1)==0?(l&255)>>>1:c[o>>2]|0;if((c[v>>2]|0)==(k+l|0)){Bk(x,l<<1,0);if(!(a[x>>0]&1))k=10;else k=(c[x>>2]&-2)+-1|0;Bk(x,k,0);k=(a[x>>0]&1)==0?q:c[p>>2]|0;c[v>>2]=k+l}m=b+12|0;l=c[m>>2]|0;n=b+16|0;if((l|0)==(c[n>>2]|0))l=Fb[c[(c[b>>2]|0)+36>>2]&127](b)|0;else l=d[l>>0]|0;if(Wm(l&255,16,k,v,s,0,y,t,u,r)|0)break;g=c[m>>2]|0;if((g|0)==(c[n>>2]|0)){Fb[c[(c[b>>2]|0)+40>>2]&127](b)|0;continue}else{c[m>>2]=g+1;continue}}Bk(x,(c[v>>2]|0)-k|0,0);u=(a[x>>0]&1)==0?q:c[p>>2]|0;v=Ym()|0;c[w>>2]=j;if((An(u,v,21334,w)|0)!=1)c[h>>2]=4;if(b){if((c[b+12>>2]|0)==(c[b+16>>2]|0)?(Fb[c[(c[b>>2]|0)+36>>2]&127](b)|0)==-1:0){c[e>>2]=0;b=0}}else b=0;b=(b|0)==0;do if(g){if((c[g+12>>2]|0)==(c[g+16>>2]|0)?(Fb[c[(c[g>>2]|0)+36>>2]&127](g)|0)==-1:0){c[f>>2]=0;A=43;break}if(!b)A=44}else A=43;while(0);if((A|0)==43?b:0)A=44;if((A|0)==44)c[h>>2]=c[h>>2]|2;A=c[e>>2]|0;vk(x);vk(y);i=z;return A|0}function An(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0;f=i;i=i+16|0;g=f;c[g>>2]=e;e=hj(b)|0;b=Ri(a,d,g)|0;if(e|0)hj(e)|0;i=f;return b|0}function Bn(a){a=a|0;return}function Cn(a){a=a|0;mu(a);return}function Dn(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;r=i;i=i+64|0;k=r+48|0;j=r+24|0;q=r+16|0;l=r+20|0;m=r+12|0;n=r+8|0;o=r+4|0;p=r;if(!(c[f+4>>2]&1)){c[q>>2]=-1;p=c[(c[b>>2]|0)+16>>2]|0;c[l>>2]=c[d>>2];c[m>>2]=c[e>>2];c[j>>2]=c[l>>2];c[k>>2]=c[m>>2];j=Db[p&63](b,j,k,f,g,q)|0;c[d>>2]=j;switch(c[q>>2]|0){case 0:{a[h>>0]=0;break}case 1:{a[h>>0]=1;break}default:{a[h>>0]=1;c[g>>2]=4}}}else{b=gm(f)|0;c[n>>2]=b;q=Om(n,1150132)|0;du(b)|0;f=gm(f)|0;c[o>>2]=f;b=Om(o,1150140)|0;du(f)|0;Cb[c[(c[b>>2]|0)+24>>2]&63](j,b);Cb[c[(c[b>>2]|0)+28>>2]&63](j+12|0,b);c[p>>2]=c[e>>2];c[k>>2]=c[p>>2];a[h>>0]=(En(d,k,j,j+24|0,q,g,1)|0)==(j|0)&1;h=c[d>>2]|0;Qk(j+12|0);Qk(j);j=h}i=r;return j|0}function En(b,d,e,f,g,h,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0;y=i;i=i+112|0;l=y;m=(f-e|0)/12|0;if(m>>>0>100){l=zj(m)|0;if(!l)Tu();else{w=l;k=l}}else{w=0;k=l}p=e;l=0;o=k;while(1){if((p|0)==(f|0))break;n=a[p>>0]|0;if(!(n&1))n=(n&255)>>>1;else n=c[p+4>>2]|0;if(!n){a[o>>0]=2;l=l+1|0;m=m+-1|0}else a[o>>0]=1;p=p+12|0;o=o+1|0}v=0;s=l;q=m;a:while(1){l=c[b>>2]|0;do if(l){m=c[l+12>>2]|0;if((m|0)==(c[l+16>>2]|0))l=Fb[c[(c[l>>2]|0)+36>>2]&127](l)|0;else l=c[m>>2]|0;if((l|0)==-1){c[b>>2]=0;o=1;break}else{o=(c[b>>2]|0)==0;break}}else o=1;while(0);n=c[d>>2]|0;if(n){l=c[n+12>>2]|0;if((l|0)==(c[n+16>>2]|0))l=Fb[c[(c[n>>2]|0)+36>>2]&127](n)|0;else l=c[l>>2]|0;if((l|0)==-1){c[d>>2]=0;n=0;l=1}else l=0}else{n=0;l=1}m=c[b>>2]|0;if(!((q|0)!=0&(o^l)))break;l=c[m+12>>2]|0;if((l|0)==(c[m+16>>2]|0))l=Fb[c[(c[m>>2]|0)+36>>2]&127](m)|0;else l=c[l>>2]|0;if(!j)l=Lb[c[(c[g>>2]|0)+28>>2]&63](g,l)|0;u=v+1|0;p=0;r=e;t=q;q=k;while(1){if((r|0)==(f|0))break;do if((a[q>>0]|0)==1){if(!(a[r>>0]&1))m=r+4|0;else m=c[r+8>>2]|0;m=c[m+(v<<2)>>2]|0;if(!j)m=Lb[c[(c[g>>2]|0)+28>>2]&63](g,m)|0;if((l|0)!=(m|0)){a[q>>0]=0;m=p;n=s;o=t+-1|0;break}m=a[r>>0]|0;if(!(m&1))m=(m&255)>>>1;else m=c[r+4>>2]|0;if((m|0)==(u|0)){a[q>>0]=2;m=1;n=s+1|0;o=t+-1|0}else{m=1;n=s;o=t}}else{m=p;n=s;o=t}while(0);p=m;r=r+12|0;s=n;t=o;q=q+1|0}if(!p){v=u;q=t;continue}l=c[b>>2]|0;m=l+12|0;n=c[m>>2]|0;if((n|0)==(c[l+16>>2]|0))Fb[c[(c[l>>2]|0)+40>>2]&127](l)|0;else c[m>>2]=n+4;if((s+t|0)>>>0>1){o=e;l=s;n=k}else{v=u;q=t;continue}while(1){if((o|0)==(f|0)){v=u;s=l;q=t;continue a}if((a[n>>0]|0)==2){m=a[o>>0]|0;if(!(m&1))m=(m&255)>>>1;else m=c[o+4>>2]|0;if((m|0)!=(u|0)){a[n>>0]=0;l=l+-1|0}}o=o+12|0;n=n+1|0}}do if(m){l=c[m+12>>2]|0;if((l|0)==(c[m+16>>2]|0))l=Fb[c[(c[m>>2]|0)+36>>2]&127](m)|0;else l=c[l>>2]|0;if((l|0)==-1){c[b>>2]=0;m=1;break}else{m=(c[b>>2]|0)==0;break}}else m=1;while(0);do if(n){l=c[n+12>>2]|0;if((l|0)==(c[n+16>>2]|0))l=Fb[c[(c[n>>2]|0)+36>>2]&127](n)|0;else l=c[l>>2]|0;if((l|0)!=-1)if(m)break;else{x=77;break}else{c[d>>2]=0;x=41;break}}else x=41;while(0);if((x|0)==41)if(m)x=77;if((x|0)==77)c[h>>2]=c[h>>2]|2;while(1){if((e|0)==(f|0)){x=81;break}if((a[k>>0]|0)==2)break;e=e+12|0;k=k+1|0}if((x|0)==81){c[h>>2]=c[h>>2]|4;e=f}Aj(w);i=y;return e|0}function Fn(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;h=i;i=i+16|0;j=h+12|0;k=h+8|0;m=h+4|0;l=h;c[m>>2]=c[b>>2];c[l>>2]=c[d>>2];c[k>>2]=c[m>>2];c[j>>2]=c[l>>2];a=Gn(a,k,j,e,f,g)|0;i=h;return a|0}function Gn(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0;z=i;i=i+304|0;r=z+200|0;j=z+196|0;y=z+184|0;x=z+172|0;v=z+168|0;w=z+8|0;t=z+4|0;s=z;switch(c[f+4>>2]&74|0){case 64:{u=8;break}case 8:{u=16;break}case 0:{u=0;break}default:u=10}Hn(y,f,r,j);b=0;while(1){if((b|0)==3)break;c[x+(b<<2)>>2]=0;b=b+1|0}if(!(a[x>>0]&1))b=10;else b=(c[x>>2]&-2)+-1|0;Bk(x,b,0);o=x+8|0;p=x+1|0;f=(a[x>>0]&1)==0?p:c[o>>2]|0;c[v>>2]=f;c[t>>2]=w;c[s>>2]=0;q=x+4|0;n=c[j>>2]|0;j=c[d>>2]|0;a:while(1){if(j){b=c[j+12>>2]|0;if((b|0)==(c[j+16>>2]|0))b=Fb[c[(c[j>>2]|0)+36>>2]&127](j)|0;else b=c[b>>2]|0;if((b|0)==-1){c[d>>2]=0;j=0;l=1}else l=0}else{j=0;l=1}k=c[e>>2]|0;do if(k){b=c[k+12>>2]|0;if((b|0)==(c[k+16>>2]|0))b=Fb[c[(c[k>>2]|0)+36>>2]&127](k)|0;else b=c[b>>2]|0;if((b|0)!=-1)if(l){m=k;break}else break a;else{c[e>>2]=0;A=23;break}}else A=23;while(0);if((A|0)==23){A=0;if(l){k=0;break}else m=0}k=a[x>>0]|0;k=(k&1)==0?(k&255)>>>1:c[q>>2]|0;if((c[v>>2]|0)==(f+k|0)){Bk(x,k<<1,0);if(!(a[x>>0]&1))b=10;else b=(c[x>>2]&-2)+-1|0;Bk(x,b,0);f=(a[x>>0]&1)==0?p:c[o>>2]|0;c[v>>2]=f+k}k=j+12|0;b=c[k>>2]|0;l=j+16|0;if((b|0)==(c[l>>2]|0))b=Fb[c[(c[j>>2]|0)+36>>2]&127](j)|0;else b=c[b>>2]|0;if(In(b,u,f,v,s,n,y,w,t,r)|0){k=m;break}b=c[k>>2]|0;if((b|0)==(c[l>>2]|0)){Fb[c[(c[j>>2]|0)+40>>2]&127](j)|0;continue}else{c[k>>2]=b+4;continue}}r=a[y>>0]|0;b=c[t>>2]|0;if((((r&1)==0?(r&255)>>>1:c[y+4>>2]|0)|0)!=0?(b-w|0)<160:0){r=c[s>>2]|0;s=b+4|0;c[t>>2]=s;c[b>>2]=r;b=s}c[h>>2]=Xm(f,c[v>>2]|0,g,u)|0;Zm(y,w,b,g);if(j){b=c[j+12>>2]|0;if((b|0)==(c[j+16>>2]|0))b=Fb[c[(c[j>>2]|0)+36>>2]&127](j)|0;else b=c[b>>2]|0;if((b|0)==-1){c[d>>2]=0;f=1}else f=0}else f=1;do if(k){b=c[k+12>>2]|0;if((b|0)==(c[k+16>>2]|0))b=Fb[c[(c[k>>2]|0)+36>>2]&127](k)|0;else b=c[b>>2]|0;if((b|0)!=-1)if(f)break;else{A=53;break}else{c[e>>2]=0;A=51;break}}else A=51;while(0);if((A|0)==51?f:0)A=53;if((A|0)==53)c[g>>2]=c[g>>2]|2;A=c[d>>2]|0;vk(x);vk(y);i=z;return A|0}function Hn(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;f=i;i=i+16|0;g=f;b=gm(b)|0;c[g>>2]=b;h=Om(g,1150132)|0;Jb[c[(c[h>>2]|0)+48>>2]&7](h,21299,21325,d)|0;d=Om(g,1150140)|0;c[e>>2]=Fb[c[(c[d>>2]|0)+16>>2]&127](d)|0;Cb[c[(c[d>>2]|0)+20>>2]&63](a,d);du(b)|0;i=f;return}function In(b,d,e,f,g,h,i,j,k,l){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;var m=0,n=0,o=0,p=0;o=c[f>>2]|0;p=(o|0)==(e|0);do if(p){m=(c[l+96>>2]|0)==(b|0);if(!m?(c[l+100>>2]|0)!=(b|0):0){n=5;break}c[f>>2]=e+1;a[e>>0]=m?43:45;c[g>>2]=0;m=0}else n=5;while(0);a:do if((n|0)==5){n=a[i>>0]|0;if((b|0)==(h|0)?(((n&1)==0?(n&255)>>>1:c[i+4>>2]|0)|0)!=0:0){m=c[k>>2]|0;if((m-j|0)>=160){m=0;break}d=c[g>>2]|0;c[k>>2]=m+4;c[m>>2]=d;c[g>>2]=0;m=0;break}i=l+104|0;m=l;while(1){if((m|0)==(i|0)){m=i;break}if((c[m>>2]|0)==(b|0))break;m=m+4|0}m=m-l|0;i=m>>2;if((m|0)>92)m=-1;else{switch(d|0){case 10:case 8:{if((i|0)>=(d|0)){m=-1;break a}break}case 16:{if((m|0)>=88){if(p){m=-1;break a}if((o-e|0)>=3){m=-1;break a}if((a[o+-1>>0]|0)!=48){m=-1;break a}c[g>>2]=0;m=a[21299+i>>0]|0;c[f>>2]=o+1;a[o>>0]=m;m=0;break a}break}default:{}}m=a[21299+i>>0]|0;c[f>>2]=o+1;a[o>>0]=m;c[g>>2]=(c[g>>2]|0)+1;m=0}}while(0);return m|0}function Jn(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;h=i;i=i+16|0;j=h+12|0;k=h+8|0;m=h+4|0;l=h;c[m>>2]=c[b>>2];c[l>>2]=c[d>>2];c[k>>2]=c[m>>2];c[j>>2]=c[l>>2];a=Kn(a,k,j,e,f,g)|0;i=h;return a|0}function Kn(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0;z=i;i=i+304|0;r=z+200|0;j=z+196|0;y=z+184|0;x=z+172|0;v=z+168|0;w=z+8|0;t=z+4|0;s=z;switch(c[f+4>>2]&74|0){case 64:{u=8;break}case 8:{u=16;break}case 0:{u=0;break}default:u=10}Hn(y,f,r,j);b=0;while(1){if((b|0)==3)break;c[x+(b<<2)>>2]=0;b=b+1|0}if(!(a[x>>0]&1))b=10;else b=(c[x>>2]&-2)+-1|0;Bk(x,b,0);o=x+8|0;p=x+1|0;f=(a[x>>0]&1)==0?p:c[o>>2]|0;c[v>>2]=f;c[t>>2]=w;c[s>>2]=0;q=x+4|0;n=c[j>>2]|0;j=c[d>>2]|0;a:while(1){if(j){b=c[j+12>>2]|0;if((b|0)==(c[j+16>>2]|0))b=Fb[c[(c[j>>2]|0)+36>>2]&127](j)|0;else b=c[b>>2]|0;if((b|0)==-1){c[d>>2]=0;j=0;l=1}else l=0}else{j=0;l=1}k=c[e>>2]|0;do if(k){b=c[k+12>>2]|0;if((b|0)==(c[k+16>>2]|0))b=Fb[c[(c[k>>2]|0)+36>>2]&127](k)|0;else b=c[b>>2]|0;if((b|0)!=-1)if(l){m=k;break}else break a;else{c[e>>2]=0;A=23;break}}else A=23;while(0);if((A|0)==23){A=0;if(l){k=0;break}else m=0}k=a[x>>0]|0;k=(k&1)==0?(k&255)>>>1:c[q>>2]|0;if((c[v>>2]|0)==(f+k|0)){Bk(x,k<<1,0);if(!(a[x>>0]&1))b=10;else b=(c[x>>2]&-2)+-1|0;Bk(x,b,0);f=(a[x>>0]&1)==0?p:c[o>>2]|0;c[v>>2]=f+k}k=j+12|0;b=c[k>>2]|0;l=j+16|0;if((b|0)==(c[l>>2]|0))b=Fb[c[(c[j>>2]|0)+36>>2]&127](j)|0;else b=c[b>>2]|0;if(In(b,u,f,v,s,n,y,w,t,r)|0){k=m;break}b=c[k>>2]|0;if((b|0)==(c[l>>2]|0)){Fb[c[(c[j>>2]|0)+40>>2]&127](j)|0;continue}else{c[k>>2]=b+4;continue}}r=a[y>>0]|0;b=c[t>>2]|0;if((((r&1)==0?(r&255)>>>1:c[y+4>>2]|0)|0)!=0?(b-w|0)<160:0){r=c[s>>2]|0;s=b+4|0;c[t>>2]=s;c[b>>2]=r;b=s}v=an(f,c[v>>2]|0,g,u)|0;c[h>>2]=v;c[h+4>>2]=C;Zm(y,w,b,g);if(j){b=c[j+12>>2]|0;if((b|0)==(c[j+16>>2]|0))b=Fb[c[(c[j>>2]|0)+36>>2]&127](j)|0;else b=c[b>>2]|0;if((b|0)==-1){c[d>>2]=0;f=1}else f=0}else f=1;do if(k){b=c[k+12>>2]|0;if((b|0)==(c[k+16>>2]|0))b=Fb[c[(c[k>>2]|0)+36>>2]&127](k)|0;else b=c[b>>2]|0;if((b|0)!=-1)if(f)break;else{A=53;break}else{c[e>>2]=0;A=51;break}}else A=51;while(0);if((A|0)==51?f:0)A=53;if((A|0)==53)c[g>>2]=c[g>>2]|2;A=c[d>>2]|0;vk(x);vk(y);i=z;return A|0}function Ln(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;h=i;i=i+16|0;j=h+12|0;k=h+8|0;m=h+4|0;l=h;c[m>>2]=c[b>>2];c[l>>2]=c[d>>2];c[k>>2]=c[m>>2];c[j>>2]=c[l>>2];a=Mn(a,k,j,e,f,g)|0;i=h;return a|0}function Mn(d,e,f,g,h,j){d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0;A=i;i=i+304|0;s=A+200|0;k=A+196|0;z=A+184|0;y=A+172|0;w=A+168|0;x=A+8|0;u=A+4|0;t=A;switch(c[g+4>>2]&74|0){case 64:{v=8;break}case 8:{v=16;break}case 0:{v=0;break}default:v=10}Hn(z,g,s,k);d=0;while(1){if((d|0)==3)break;c[y+(d<<2)>>2]=0;d=d+1|0}if(!(a[y>>0]&1))d=10;else d=(c[y>>2]&-2)+-1|0;Bk(y,d,0);p=y+8|0;q=y+1|0;g=(a[y>>0]&1)==0?q:c[p>>2]|0;c[w>>2]=g;c[u>>2]=x;c[t>>2]=0;r=y+4|0;o=c[k>>2]|0;k=c[e>>2]|0;a:while(1){if(k){d=c[k+12>>2]|0;if((d|0)==(c[k+16>>2]|0))d=Fb[c[(c[k>>2]|0)+36>>2]&127](k)|0;else d=c[d>>2]|0;if((d|0)==-1){c[e>>2]=0;k=0;m=1}else m=0}else{k=0;m=1}l=c[f>>2]|0;do if(l){d=c[l+12>>2]|0;if((d|0)==(c[l+16>>2]|0))d=Fb[c[(c[l>>2]|0)+36>>2]&127](l)|0;else d=c[d>>2]|0;if((d|0)!=-1)if(m){n=l;break}else break a;else{c[f>>2]=0;B=23;break}}else B=23;while(0);if((B|0)==23){B=0;if(m){l=0;break}else n=0}l=a[y>>0]|0;l=(l&1)==0?(l&255)>>>1:c[r>>2]|0;if((c[w>>2]|0)==(g+l|0)){Bk(y,l<<1,0);if(!(a[y>>0]&1))d=10;else d=(c[y>>2]&-2)+-1|0;Bk(y,d,0);g=(a[y>>0]&1)==0?q:c[p>>2]|0;c[w>>2]=g+l}l=k+12|0;d=c[l>>2]|0;m=k+16|0;if((d|0)==(c[m>>2]|0))d=Fb[c[(c[k>>2]|0)+36>>2]&127](k)|0;else d=c[d>>2]|0;if(In(d,v,g,w,t,o,z,x,u,s)|0){l=n;break}d=c[l>>2]|0;if((d|0)==(c[m>>2]|0)){Fb[c[(c[k>>2]|0)+40>>2]&127](k)|0;continue}else{c[l>>2]=d+4;continue}}s=a[z>>0]|0;d=c[u>>2]|0;if((((s&1)==0?(s&255)>>>1:c[z+4>>2]|0)|0)!=0?(d-x|0)<160:0){s=c[t>>2]|0;t=d+4|0;c[u>>2]=t;c[d>>2]=s;d=t}b[j>>1]=dn(g,c[w>>2]|0,h,v)|0;Zm(z,x,d,h);if(k){d=c[k+12>>2]|0;if((d|0)==(c[k+16>>2]|0))d=Fb[c[(c[k>>2]|0)+36>>2]&127](k)|0;else d=c[d>>2]|0;if((d|0)==-1){c[e>>2]=0;g=1}else g=0}else g=1;do if(l){d=c[l+12>>2]|0;if((d|0)==(c[l+16>>2]|0))d=Fb[c[(c[l>>2]|0)+36>>2]&127](l)|0;else d=c[d>>2]|0;if((d|0)!=-1)if(g)break;else{B=53;break}else{c[f>>2]=0;B=51;break}}else B=51;while(0);if((B|0)==51?g:0)B=53;if((B|0)==53)c[h>>2]=c[h>>2]|2;B=c[e>>2]|0;vk(y);vk(z);i=A;return B|0}function Nn(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;h=i;i=i+16|0;j=h+12|0;k=h+8|0;m=h+4|0;l=h;c[m>>2]=c[b>>2];c[l>>2]=c[d>>2];c[k>>2]=c[m>>2];c[j>>2]=c[l>>2];a=On(a,k,j,e,f,g)|0;i=h;return a|0}function On(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0;z=i;i=i+304|0;r=z+200|0;j=z+196|0;y=z+184|0;x=z+172|0;v=z+168|0;w=z+8|0;t=z+4|0;s=z;switch(c[f+4>>2]&74|0){case 64:{u=8;break}case 8:{u=16;break}case 0:{u=0;break}default:u=10}Hn(y,f,r,j);b=0;while(1){if((b|0)==3)break;c[x+(b<<2)>>2]=0;b=b+1|0}if(!(a[x>>0]&1))b=10;else b=(c[x>>2]&-2)+-1|0;Bk(x,b,0);o=x+8|0;p=x+1|0;f=(a[x>>0]&1)==0?p:c[o>>2]|0;c[v>>2]=f;c[t>>2]=w;c[s>>2]=0;q=x+4|0;n=c[j>>2]|0;j=c[d>>2]|0;a:while(1){if(j){b=c[j+12>>2]|0;if((b|0)==(c[j+16>>2]|0))b=Fb[c[(c[j>>2]|0)+36>>2]&127](j)|0;else b=c[b>>2]|0;if((b|0)==-1){c[d>>2]=0;j=0;l=1}else l=0}else{j=0;l=1}k=c[e>>2]|0;do if(k){b=c[k+12>>2]|0;if((b|0)==(c[k+16>>2]|0))b=Fb[c[(c[k>>2]|0)+36>>2]&127](k)|0;else b=c[b>>2]|0;if((b|0)!=-1)if(l){m=k;break}else break a;else{c[e>>2]=0;A=23;break}}else A=23;while(0);if((A|0)==23){A=0;if(l){k=0;break}else m=0}k=a[x>>0]|0;k=(k&1)==0?(k&255)>>>1:c[q>>2]|0;if((c[v>>2]|0)==(f+k|0)){Bk(x,k<<1,0);if(!(a[x>>0]&1))b=10;else b=(c[x>>2]&-2)+-1|0;Bk(x,b,0);f=(a[x>>0]&1)==0?p:c[o>>2]|0;c[v>>2]=f+k}k=j+12|0;b=c[k>>2]|0;l=j+16|0;if((b|0)==(c[l>>2]|0))b=Fb[c[(c[j>>2]|0)+36>>2]&127](j)|0;else b=c[b>>2]|0;if(In(b,u,f,v,s,n,y,w,t,r)|0){k=m;break}b=c[k>>2]|0;if((b|0)==(c[l>>2]|0)){Fb[c[(c[j>>2]|0)+40>>2]&127](j)|0;continue}else{c[k>>2]=b+4;continue}}r=a[y>>0]|0;b=c[t>>2]|0;if((((r&1)==0?(r&255)>>>1:c[y+4>>2]|0)|0)!=0?(b-w|0)<160:0){r=c[s>>2]|0;s=b+4|0;c[t>>2]=s;c[b>>2]=r;b=s}c[h>>2]=gn(f,c[v>>2]|0,g,u)|0;Zm(y,w,b,g);if(j){b=c[j+12>>2]|0;if((b|0)==(c[j+16>>2]|0))b=Fb[c[(c[j>>2]|0)+36>>2]&127](j)|0;else b=c[b>>2]|0;if((b|0)==-1){c[d>>2]=0;f=1}else f=0}else f=1;do if(k){b=c[k+12>>2]|0;if((b|0)==(c[k+16>>2]|0))b=Fb[c[(c[k>>2]|0)+36>>2]&127](k)|0;else b=c[b>>2]|0;if((b|0)!=-1)if(f)break;else{A=53;break}else{c[e>>2]=0;A=51;break}}else A=51;while(0);if((A|0)==51?f:0)A=53;if((A|0)==53)c[g>>2]=c[g>>2]|2;A=c[d>>2]|0;vk(x);vk(y);i=z;return A|0}function Pn(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;h=i;i=i+16|0;j=h+12|0;k=h+8|0;m=h+4|0;l=h;c[m>>2]=c[b>>2];c[l>>2]=c[d>>2];c[k>>2]=c[m>>2];c[j>>2]=c[l>>2];a=Qn(a,k,j,e,f,g)|0;i=h;return a|0}function Qn(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0;z=i;i=i+304|0;r=z+200|0;j=z+196|0;y=z+184|0;x=z+172|0;v=z+168|0;w=z+8|0;t=z+4|0;s=z;switch(c[f+4>>2]&74|0){case 64:{u=8;break}case 8:{u=16;break}case 0:{u=0;break}default:u=10}Hn(y,f,r,j);b=0;while(1){if((b|0)==3)break;c[x+(b<<2)>>2]=0;b=b+1|0}if(!(a[x>>0]&1))b=10;else b=(c[x>>2]&-2)+-1|0;Bk(x,b,0);o=x+8|0;p=x+1|0;f=(a[x>>0]&1)==0?p:c[o>>2]|0;c[v>>2]=f;c[t>>2]=w;c[s>>2]=0;q=x+4|0;n=c[j>>2]|0;j=c[d>>2]|0;a:while(1){if(j){b=c[j+12>>2]|0;if((b|0)==(c[j+16>>2]|0))b=Fb[c[(c[j>>2]|0)+36>>2]&127](j)|0;else b=c[b>>2]|0;if((b|0)==-1){c[d>>2]=0;j=0;l=1}else l=0}else{j=0;l=1}k=c[e>>2]|0;do if(k){b=c[k+12>>2]|0;if((b|0)==(c[k+16>>2]|0))b=Fb[c[(c[k>>2]|0)+36>>2]&127](k)|0;else b=c[b>>2]|0;if((b|0)!=-1)if(l){m=k;break}else break a;else{c[e>>2]=0;A=23;break}}else A=23;while(0);if((A|0)==23){A=0;if(l){k=0;break}else m=0}k=a[x>>0]|0;k=(k&1)==0?(k&255)>>>1:c[q>>2]|0;if((c[v>>2]|0)==(f+k|0)){Bk(x,k<<1,0);if(!(a[x>>0]&1))b=10;else b=(c[x>>2]&-2)+-1|0;Bk(x,b,0);f=(a[x>>0]&1)==0?p:c[o>>2]|0;c[v>>2]=f+k}k=j+12|0;b=c[k>>2]|0;l=j+16|0;if((b|0)==(c[l>>2]|0))b=Fb[c[(c[j>>2]|0)+36>>2]&127](j)|0;else b=c[b>>2]|0;if(In(b,u,f,v,s,n,y,w,t,r)|0){k=m;break}b=c[k>>2]|0;if((b|0)==(c[l>>2]|0)){Fb[c[(c[j>>2]|0)+40>>2]&127](j)|0;continue}else{c[k>>2]=b+4;continue}}r=a[y>>0]|0;b=c[t>>2]|0;if((((r&1)==0?(r&255)>>>1:c[y+4>>2]|0)|0)!=0?(b-w|0)<160:0){r=c[s>>2]|0;s=b+4|0;c[t>>2]=s;c[b>>2]=r;b=s}c[h>>2]=kn(f,c[v>>2]|0,g,u)|0;Zm(y,w,b,g);if(j){b=c[j+12>>2]|0;if((b|0)==(c[j+16>>2]|0))b=Fb[c[(c[j>>2]|0)+36>>2]&127](j)|0;else b=c[b>>2]|0;if((b|0)==-1){c[d>>2]=0;f=1}else f=0}else f=1;do if(k){b=c[k+12>>2]|0;if((b|0)==(c[k+16>>2]|0))b=Fb[c[(c[k>>2]|0)+36>>2]&127](k)|0;else b=c[b>>2]|0;if((b|0)!=-1)if(f)break;else{A=53;break}else{c[e>>2]=0;A=51;break}}else A=51;while(0);if((A|0)==51?f:0)A=53;if((A|0)==53)c[g>>2]=c[g>>2]|2;A=c[d>>2]|0;vk(x);vk(y);i=z;return A|0}function Rn(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;h=i;i=i+16|0;j=h+12|0;k=h+8|0;m=h+4|0;l=h;c[m>>2]=c[b>>2];c[l>>2]=c[d>>2];c[k>>2]=c[m>>2];c[j>>2]=c[l>>2];a=Sn(a,k,j,e,f,g)|0;i=h;return a|0}function Sn(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0;z=i;i=i+304|0;r=z+200|0;j=z+196|0;y=z+184|0;x=z+172|0;v=z+168|0;w=z+8|0;t=z+4|0;s=z;switch(c[f+4>>2]&74|0){case 64:{u=8;break}case 8:{u=16;break}case 0:{u=0;break}default:u=10}Hn(y,f,r,j);b=0;while(1){if((b|0)==3)break;c[x+(b<<2)>>2]=0;b=b+1|0}if(!(a[x>>0]&1))b=10;else b=(c[x>>2]&-2)+-1|0;Bk(x,b,0);o=x+8|0;p=x+1|0;f=(a[x>>0]&1)==0?p:c[o>>2]|0;c[v>>2]=f;c[t>>2]=w;c[s>>2]=0;q=x+4|0;n=c[j>>2]|0;j=c[d>>2]|0;a:while(1){if(j){b=c[j+12>>2]|0;if((b|0)==(c[j+16>>2]|0))b=Fb[c[(c[j>>2]|0)+36>>2]&127](j)|0;else b=c[b>>2]|0;if((b|0)==-1){c[d>>2]=0;j=0;l=1}else l=0}else{j=0;l=1}k=c[e>>2]|0;do if(k){b=c[k+12>>2]|0;if((b|0)==(c[k+16>>2]|0))b=Fb[c[(c[k>>2]|0)+36>>2]&127](k)|0;else b=c[b>>2]|0;if((b|0)!=-1)if(l){m=k;break}else break a;else{c[e>>2]=0;A=23;break}}else A=23;while(0);if((A|0)==23){A=0;if(l){k=0;break}else m=0}k=a[x>>0]|0;k=(k&1)==0?(k&255)>>>1:c[q>>2]|0;if((c[v>>2]|0)==(f+k|0)){Bk(x,k<<1,0);if(!(a[x>>0]&1))b=10;else b=(c[x>>2]&-2)+-1|0;Bk(x,b,0);f=(a[x>>0]&1)==0?p:c[o>>2]|0;c[v>>2]=f+k}k=j+12|0;b=c[k>>2]|0;l=j+16|0;if((b|0)==(c[l>>2]|0))b=Fb[c[(c[j>>2]|0)+36>>2]&127](j)|0;else b=c[b>>2]|0;if(In(b,u,f,v,s,n,y,w,t,r)|0){k=m;break}b=c[k>>2]|0;if((b|0)==(c[l>>2]|0)){Fb[c[(c[j>>2]|0)+40>>2]&127](j)|0;continue}else{c[k>>2]=b+4;continue}}r=a[y>>0]|0;b=c[t>>2]|0;if((((r&1)==0?(r&255)>>>1:c[y+4>>2]|0)|0)!=0?(b-w|0)<160:0){r=c[s>>2]|0;s=b+4|0;c[t>>2]=s;c[b>>2]=r;b=s}v=nn(f,c[v>>2]|0,g,u)|0;c[h>>2]=v;c[h+4>>2]=C;Zm(y,w,b,g);if(j){b=c[j+12>>2]|0;if((b|0)==(c[j+16>>2]|0))b=Fb[c[(c[j>>2]|0)+36>>2]&127](j)|0;else b=c[b>>2]|0;if((b|0)==-1){c[d>>2]=0;f=1}else f=0}else f=1;do if(k){b=c[k+12>>2]|0;if((b|0)==(c[k+16>>2]|0))b=Fb[c[(c[k>>2]|0)+36>>2]&127](k)|0;else b=c[b>>2]|0;if((b|0)!=-1)if(f)break;else{A=53;break}else{c[e>>2]=0;A=51;break}}else A=51;while(0);if((A|0)==51?f:0)A=53;if((A|0)==53)c[g>>2]=c[g>>2]|2;A=c[d>>2]|0;vk(x);vk(y);i=z;return A|0}function Tn(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;h=i;i=i+16|0;j=h+12|0;k=h+8|0;m=h+4|0;l=h;c[m>>2]=c[b>>2];c[l>>2]=c[d>>2];c[k>>2]=c[m>>2];c[j>>2]=c[l>>2];a=Un(a,k,j,e,f,g)|0;i=h;return a|0}function Un(b,d,e,f,h,j){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0;C=i;i=i+352|0;t=C+208|0;k=C+200|0;l=C+196|0;B=C+184|0;A=C+172|0;y=C+168|0;z=C+8|0;w=C+4|0;v=C;x=C+337|0;u=C+336|0;Vn(B,f,t,k,l);b=0;while(1){if((b|0)==3)break;c[A+(b<<2)>>2]=0;b=b+1|0}if(!(a[A>>0]&1))b=10;else b=(c[A>>2]&-2)+-1|0;Bk(A,b,0);q=A+8|0;r=A+1|0;f=(a[A>>0]&1)==0?r:c[q>>2]|0;c[y>>2]=f;c[w>>2]=z;c[v>>2]=0;a[x>>0]=1;a[u>>0]=69;s=A+4|0;p=c[k>>2]|0;o=c[l>>2]|0;k=c[d>>2]|0;a:while(1){if(k){b=c[k+12>>2]|0;if((b|0)==(c[k+16>>2]|0))b=Fb[c[(c[k>>2]|0)+36>>2]&127](k)|0;else b=c[b>>2]|0;if((b|0)==-1){c[d>>2]=0;k=0;m=1}else m=0}else{k=0;m=1}l=c[e>>2]|0;do if(l){b=c[l+12>>2]|0;if((b|0)==(c[l+16>>2]|0))b=Fb[c[(c[l>>2]|0)+36>>2]&127](l)|0;else b=c[b>>2]|0;if((b|0)!=-1)if(m)break;else break a;else{c[e>>2]=0;D=19;break}}else D=19;while(0);if((D|0)==19){D=0;if(m){l=0;break}else l=0}m=a[A>>0]|0;m=(m&1)==0?(m&255)>>>1:c[s>>2]|0;if((c[y>>2]|0)==(f+m|0)){Bk(A,m<<1,0);if(!(a[A>>0]&1))b=10;else b=(c[A>>2]&-2)+-1|0;Bk(A,b,0);f=(a[A>>0]&1)==0?r:c[q>>2]|0;c[y>>2]=f+m}m=k+12|0;b=c[m>>2]|0;n=k+16|0;if((b|0)==(c[n>>2]|0))b=Fb[c[(c[k>>2]|0)+36>>2]&127](k)|0;else b=c[b>>2]|0;if(Wn(b,x,u,f,y,p,o,B,z,w,v,t)|0)break;b=c[m>>2]|0;if((b|0)==(c[n>>2]|0)){Fb[c[(c[k>>2]|0)+40>>2]&127](k)|0;continue}else{c[m>>2]=b+4;continue}}u=a[B>>0]|0;b=c[w>>2]|0;if(!((a[x>>0]|0)==0?1:(((u&1)==0?(u&255)>>>1:c[B+4>>2]|0)|0)==0)?(b-z|0)<160:0){v=c[v>>2]|0;x=b+4|0;c[w>>2]=x;c[b>>2]=v;b=x}g[j>>2]=+sn(f,c[y>>2]|0,h);Zm(B,z,b,h);if(k){b=c[k+12>>2]|0;if((b|0)==(c[k+16>>2]|0))b=Fb[c[(c[k>>2]|0)+36>>2]&127](k)|0;else b=c[b>>2]|0;if((b|0)==-1){c[d>>2]=0;f=1}else f=0}else f=1;do if(l){b=c[l+12>>2]|0;if((b|0)==(c[l+16>>2]|0))b=Fb[c[(c[l>>2]|0)+36>>2]&127](l)|0;else b=c[b>>2]|0;if((b|0)!=-1)if(f)break;else{D=49;break}else{c[e>>2]=0;D=47;break}}else D=47;while(0);if((D|0)==47?f:0)D=49;if((D|0)==49)c[h>>2]=c[h>>2]|2;D=c[d>>2]|0;vk(A);vk(B);i=C;return D|0}function Vn(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0;g=i;i=i+16|0;h=g;b=gm(b)|0;c[h>>2]=b;j=Om(h,1150132)|0;Jb[c[(c[j>>2]|0)+48>>2]&7](j,21299,21331,d)|0;d=Om(h,1150140)|0;c[e>>2]=Fb[c[(c[d>>2]|0)+12>>2]&127](d)|0;c[f>>2]=Fb[c[(c[d>>2]|0)+16>>2]&127](d)|0;Cb[c[(c[d>>2]|0)+20>>2]&63](a,d);du(b)|0;i=g;return}function Wn(b,e,f,g,h,i,j,k,l,m,n,o){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;m=m|0;n=n|0;o=o|0;var p=0,q=0;a:do if((b|0)==(i|0))if(a[e>>0]|0){a[e>>0]=0;f=c[h>>2]|0;c[h>>2]=f+1;a[f>>0]=46;f=a[k>>0]|0;if((((f&1)==0?(f&255)>>>1:c[k+4>>2]|0)|0)!=0?(p=c[m>>2]|0,(p-l|0)<160):0){l=c[n>>2]|0;c[m>>2]=p+4;c[p>>2]=l;p=0}else p=0}else p=-1;else{if((b|0)==(j|0)?(j=a[k>>0]|0,((j&1)==0?(j&255)>>>1:c[k+4>>2]|0)|0):0){if(!(a[e>>0]|0)){p=-1;break}p=c[m>>2]|0;if((p-l|0)>=160){p=0;break}l=c[n>>2]|0;c[m>>2]=p+4;c[p>>2]=l;c[n>>2]=0;p=0;break}i=o+128|0;p=o;while(1){if((p|0)==(i|0)){p=i;break}if((c[p>>2]|0)==(b|0))break;p=p+4|0}i=p-o|0;p=i>>2;if((i|0)<=124){j=a[21299+p>>0]|0;switch(p|0){case 24:case 25:{p=c[h>>2]|0;if((p|0)!=(g|0)?(d[p+-1>>0]&95|0)!=(d[f>>0]&127|0):0){p=-1;break a}c[h>>2]=p+1;a[p>>0]=j;p=0;break a}case 23:case 22:{a[f>>0]=80;break}default:{p=j&95;if((((p|0)==(a[f>>0]|0)?(a[f>>0]=p|128,a[e>>0]|0):0)?(a[e>>0]=0,f=a[k>>0]|0,((f&1)==0?(f&255)>>>1:c[k+4>>2]|0)|0):0)?(q=c[m>>2]|0,(q-l|0)<160):0){l=c[n>>2]|0;c[m>>2]=q+4;c[q>>2]=l}}}m=c[h>>2]|0;c[h>>2]=m+1;a[m>>0]=j;if((i|0)>84)p=0;else{c[n>>2]=(c[n>>2]|0)+1;p=0}}else p=-1}while(0);return p|0}function Xn(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;h=i;i=i+16|0;j=h+12|0;k=h+8|0;m=h+4|0;l=h;c[m>>2]=c[b>>2];c[l>>2]=c[d>>2];c[k>>2]=c[m>>2];c[j>>2]=c[l>>2];a=Yn(a,k,j,e,f,g)|0;i=h;return a|0}function Yn(b,d,e,f,g,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0;C=i;i=i+352|0;t=C+208|0;k=C+200|0;l=C+196|0;B=C+184|0;A=C+172|0;y=C+168|0;z=C+8|0;w=C+4|0;v=C;x=C+337|0;u=C+336|0;Vn(B,f,t,k,l);b=0;while(1){if((b|0)==3)break;c[A+(b<<2)>>2]=0;b=b+1|0}if(!(a[A>>0]&1))b=10;else b=(c[A>>2]&-2)+-1|0;Bk(A,b,0);q=A+8|0;r=A+1|0;f=(a[A>>0]&1)==0?r:c[q>>2]|0;c[y>>2]=f;c[w>>2]=z;c[v>>2]=0;a[x>>0]=1;a[u>>0]=69;s=A+4|0;p=c[k>>2]|0;o=c[l>>2]|0;k=c[d>>2]|0;a:while(1){if(k){b=c[k+12>>2]|0;if((b|0)==(c[k+16>>2]|0))b=Fb[c[(c[k>>2]|0)+36>>2]&127](k)|0;else b=c[b>>2]|0;if((b|0)==-1){c[d>>2]=0;k=0;m=1}else m=0}else{k=0;m=1}l=c[e>>2]|0;do if(l){b=c[l+12>>2]|0;if((b|0)==(c[l+16>>2]|0))b=Fb[c[(c[l>>2]|0)+36>>2]&127](l)|0;else b=c[b>>2]|0;if((b|0)!=-1)if(m)break;else break a;else{c[e>>2]=0;D=19;break}}else D=19;while(0);if((D|0)==19){D=0;if(m){l=0;break}else l=0}m=a[A>>0]|0;m=(m&1)==0?(m&255)>>>1:c[s>>2]|0;if((c[y>>2]|0)==(f+m|0)){Bk(A,m<<1,0);if(!(a[A>>0]&1))b=10;else b=(c[A>>2]&-2)+-1|0;Bk(A,b,0);f=(a[A>>0]&1)==0?r:c[q>>2]|0;c[y>>2]=f+m}m=k+12|0;b=c[m>>2]|0;n=k+16|0;if((b|0)==(c[n>>2]|0))b=Fb[c[(c[k>>2]|0)+36>>2]&127](k)|0;else b=c[b>>2]|0;if(Wn(b,x,u,f,y,p,o,B,z,w,v,t)|0)break;b=c[m>>2]|0;if((b|0)==(c[n>>2]|0)){Fb[c[(c[k>>2]|0)+40>>2]&127](k)|0;continue}else{c[m>>2]=b+4;continue}}u=a[B>>0]|0;b=c[w>>2]|0;if(!((a[x>>0]|0)==0?1:(((u&1)==0?(u&255)>>>1:c[B+4>>2]|0)|0)==0)?(b-z|0)<160:0){v=c[v>>2]|0;x=b+4|0;c[w>>2]=x;c[b>>2]=v;b=x}h[j>>3]=+vn(f,c[y>>2]|0,g);Zm(B,z,b,g);if(k){b=c[k+12>>2]|0;if((b|0)==(c[k+16>>2]|0))b=Fb[c[(c[k>>2]|0)+36>>2]&127](k)|0;else b=c[b>>2]|0;if((b|0)==-1){c[d>>2]=0;f=1}else f=0}else f=1;do if(l){b=c[l+12>>2]|0;if((b|0)==(c[l+16>>2]|0))b=Fb[c[(c[l>>2]|0)+36>>2]&127](l)|0;else b=c[b>>2]|0;if((b|0)!=-1)if(f)break;else{D=49;break}else{c[e>>2]=0;D=47;break}}else D=47;while(0);if((D|0)==47?f:0)D=49;if((D|0)==49)c[g>>2]=c[g>>2]|2;D=c[d>>2]|0;vk(A);vk(B);i=C;return D|0}function Zn(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;h=i;i=i+16|0;j=h+12|0;k=h+8|0;m=h+4|0;l=h;c[m>>2]=c[b>>2];c[l>>2]=c[d>>2];c[k>>2]=c[m>>2];c[j>>2]=c[l>>2];a=_n(a,k,j,e,f,g)|0;i=h;return a|0}function _n(b,d,e,f,g,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0;C=i;i=i+352|0;t=C+208|0;k=C+200|0;l=C+196|0;B=C+184|0;A=C+172|0;y=C+168|0;z=C+8|0;w=C+4|0;v=C;x=C+337|0;u=C+336|0;Vn(B,f,t,k,l);b=0;while(1){if((b|0)==3)break;c[A+(b<<2)>>2]=0;b=b+1|0}if(!(a[A>>0]&1))b=10;else b=(c[A>>2]&-2)+-1|0;Bk(A,b,0);q=A+8|0;r=A+1|0;f=(a[A>>0]&1)==0?r:c[q>>2]|0;c[y>>2]=f;c[w>>2]=z;c[v>>2]=0;a[x>>0]=1;a[u>>0]=69;s=A+4|0;p=c[k>>2]|0;o=c[l>>2]|0;k=c[d>>2]|0;a:while(1){if(k){b=c[k+12>>2]|0;if((b|0)==(c[k+16>>2]|0))b=Fb[c[(c[k>>2]|0)+36>>2]&127](k)|0;else b=c[b>>2]|0;if((b|0)==-1){c[d>>2]=0;k=0;m=1}else m=0}else{k=0;m=1}l=c[e>>2]|0;do if(l){b=c[l+12>>2]|0;if((b|0)==(c[l+16>>2]|0))b=Fb[c[(c[l>>2]|0)+36>>2]&127](l)|0;else b=c[b>>2]|0;if((b|0)!=-1)if(m)break;else break a;else{c[e>>2]=0;D=19;break}}else D=19;while(0);if((D|0)==19){D=0;if(m){l=0;break}else l=0}m=a[A>>0]|0;m=(m&1)==0?(m&255)>>>1:c[s>>2]|0;if((c[y>>2]|0)==(f+m|0)){Bk(A,m<<1,0);if(!(a[A>>0]&1))b=10;else b=(c[A>>2]&-2)+-1|0;Bk(A,b,0);f=(a[A>>0]&1)==0?r:c[q>>2]|0;c[y>>2]=f+m}m=k+12|0;b=c[m>>2]|0;n=k+16|0;if((b|0)==(c[n>>2]|0))b=Fb[c[(c[k>>2]|0)+36>>2]&127](k)|0;else b=c[b>>2]|0;if(Wn(b,x,u,f,y,p,o,B,z,w,v,t)|0)break;b=c[m>>2]|0;if((b|0)==(c[n>>2]|0)){Fb[c[(c[k>>2]|0)+40>>2]&127](k)|0;continue}else{c[m>>2]=b+4;continue}}u=a[B>>0]|0;b=c[w>>2]|0;if(!((a[x>>0]|0)==0?1:(((u&1)==0?(u&255)>>>1:c[B+4>>2]|0)|0)==0)?(b-z|0)<160:0){v=c[v>>2]|0;x=b+4|0;c[w>>2]=x;c[b>>2]=v;b=x}h[j>>3]=+yn(f,c[y>>2]|0,g);Zm(B,z,b,g);if(k){b=c[k+12>>2]|0;if((b|0)==(c[k+16>>2]|0))b=Fb[c[(c[k>>2]|0)+36>>2]&127](k)|0;else b=c[b>>2]|0;if((b|0)==-1){c[d>>2]=0;f=1}else f=0}else f=1;do if(l){b=c[l+12>>2]|0;if((b|0)==(c[l+16>>2]|0))b=Fb[c[(c[l>>2]|0)+36>>2]&127](l)|0;else b=c[b>>2]|0;if((b|0)!=-1)if(f)break;else{D=49;break}else{c[e>>2]=0;D=47;break}}else D=47;while(0);if((D|0)==47?f:0)D=49;if((D|0)==49)c[g>>2]=c[g>>2]|2;D=c[d>>2]|0;vk(A);vk(B);i=C;return D|0}function $n(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0;y=i;i=i+320|0;v=y;q=y+208|0;x=y+196|0;b=y+180|0;w=y+184|0;u=y+176|0;s=y+16|0;t=y+8|0;r=y+4|0;j=0;while(1){if((j|0)==3)break;c[x+(j<<2)>>2]=0;j=j+1|0}p=gm(f)|0;c[b>>2]=p;b=Om(b,1150132)|0;Jb[c[(c[b>>2]|0)+48>>2]&7](b,21299,21325,q)|0;du(p)|0;b=0;while(1){if((b|0)==3)break;c[w+(b<<2)>>2]=0;b=b+1|0}if(!(a[w>>0]&1))b=10;else b=(c[w>>2]&-2)+-1|0;Bk(w,b,0);o=w+8|0;p=w+1|0;b=(a[w>>0]&1)==0?p:c[o>>2]|0;c[u>>2]=b;c[t>>2]=s;c[r>>2]=0;n=w+4|0;f=c[d>>2]|0;a:while(1){if(f){j=c[f+12>>2]|0;if((j|0)==(c[f+16>>2]|0))j=Fb[c[(c[f>>2]|0)+36>>2]&127](f)|0;else j=c[j>>2]|0;if((j|0)==-1){c[d>>2]=0;j=0;l=1}else{j=f;l=0}}else{j=0;l=1}f=c[e>>2]|0;do if(f){k=c[f+12>>2]|0;if((k|0)==(c[f+16>>2]|0))k=Fb[c[(c[f>>2]|0)+36>>2]&127](f)|0;else k=c[k>>2]|0;if((k|0)!=-1)if(l)break;else break a;else{c[e>>2]=0;z=22;break}}else z=22;while(0);if((z|0)==22){z=0;if(l){f=0;break}else f=0}k=a[w>>0]|0;k=(k&1)==0?(k&255)>>>1:c[n>>2]|0;if((c[u>>2]|0)==(b+k|0)){Bk(w,k<<1,0);if(!(a[w>>0]&1))b=10;else b=(c[w>>2]&-2)+-1|0;Bk(w,b,0);b=(a[w>>0]&1)==0?p:c[o>>2]|0;c[u>>2]=b+k}l=j+12|0;k=c[l>>2]|0;m=j+16|0;if((k|0)==(c[m>>2]|0))k=Fb[c[(c[j>>2]|0)+36>>2]&127](j)|0;else k=c[k>>2]|0;if(In(k,16,b,u,r,0,x,s,t,q)|0)break;f=c[l>>2]|0;if((f|0)==(c[m>>2]|0)){Fb[c[(c[j>>2]|0)+40>>2]&127](j)|0;f=j;continue}else{c[l>>2]=f+4;f=j;continue}}Bk(w,(c[u>>2]|0)-b|0,0);t=(a[w>>0]&1)==0?p:c[o>>2]|0;u=Ym()|0;c[v>>2]=h;if((An(t,u,21334,v)|0)!=1)c[g>>2]=4;if(j){b=c[j+12>>2]|0;if((b|0)==(c[j+16>>2]|0))b=Fb[c[(c[j>>2]|0)+36>>2]&127](j)|0;else b=c[b>>2]|0;if((b|0)==-1){c[d>>2]=0;j=1}else j=0}else j=1;do if(f){b=c[f+12>>2]|0;if((b|0)==(c[f+16>>2]|0))b=Fb[c[(c[f>>2]|0)+36>>2]&127](f)|0;else b=c[b>>2]|0;if((b|0)!=-1)if(j)break;else{z=51;break}else{c[e>>2]=0;z=49;break}}else z=49;while(0);if((z|0)==49?j:0)z=51;if((z|0)==51)c[g>>2]=c[g>>2]|2;z=c[d>>2]|0;vk(w);vk(x);i=y;return z|0}function ao(a){a=a|0;return}function bo(a){a=a|0;mu(a);return}function co(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0;n=i;i=i+32|0;m=n+8|0;h=n+4|0;j=n;if(!(c[e+4>>2]&1)){l=c[(c[b>>2]|0)+24>>2]|0;c[h>>2]=c[d>>2];c[m>>2]=c[h>>2];h=Mb[l&31](b,m,e,f,g&1)|0}else{l=gm(e)|0;c[j>>2]=l;h=Om(j,1150112)|0;du(l)|0;j=c[h>>2]|0;if(g)Cb[c[j+24>>2]&63](m,h);else Cb[c[j+28>>2]&63](m,h);e=a[m>>0]|0;b=m+1|0;g=m+8|0;l=c[g>>2]|0;k=m+4|0;h=e;j=l;l=(e&1)==0?b:l;while(1){e=(h&1)==0;if((l|0)==((e?b:j)+(e?(h&255)>>>1:c[k>>2]|0)|0))break;h=a[l>>0]|0;j=c[d>>2]|0;do if(j|0){f=j+24|0;e=c[f>>2]|0;if((e|0)!=(c[j+28>>2]|0)){c[f>>2]=e+1;a[e>>0]=h;break}if((Lb[c[(c[j>>2]|0)+52>>2]&63](j,h&255)|0)==-1)c[d>>2]=0}while(0);h=a[m>>0]|0;j=c[g>>2]|0;l=l+1|0}h=c[d>>2]|0;vk(m)}i=n;return h|0}function eo(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;h=i;i=i+64|0;k=h;o=h+56|0;q=h+44|0;j=h+20|0;m=h+16|0;b=h+8|0;n=h+12|0;l=h+4|0;a[o>>0]=a[21542]|0;a[o+1>>0]=a[21543]|0;a[o+2>>0]=a[21544]|0;a[o+3>>0]=a[21545]|0;a[o+4>>0]=a[21546]|0;a[o+5>>0]=a[21547]|0;fo(o+1|0,21548,1,c[e+4>>2]|0);p=Ym()|0;c[k>>2]=g;o=q+(go(q,12,p,o,k)|0)|0;p=ho(q,o,e)|0;g=gm(e)|0;c[n>>2]=g;io(q,p,o,j,m,b,n);du(g)|0;c[l>>2]=c[d>>2];g=c[m>>2]|0;b=c[b>>2]|0;c[k>>2]=c[l>>2];b=Vd(k,j,g,b,e,f)|0;i=h;return b|0}function fo(b,c,d,e){b=b|0;c=c|0;d=d|0;e=e|0;var f=0;if(e&2048){a[b>>0]=43;b=b+1|0}if(!(e&512))f=c;else{a[b>>0]=35;f=c;b=b+1|0}while(1){c=a[f>>0]|0;if(!(c<<24>>24))break;a[b>>0]=c;f=f+1|0;b=b+1|0}a:do switch(e&74|0){case 64:{a[b>>0]=111;break}case 8:if(!(e&16384)){a[b>>0]=120;break a}else{a[b>>0]=88;break a}default:if(d){a[b>>0]=100;break a}else{a[b>>0]=117;break a}}while(0);return}function go(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0;g=i;i=i+16|0;h=g;c[h>>2]=f;f=hj(d)|0;d=Oh(a,b,e,h)|0;if(f|0)hj(f)|0;i=g;return d|0}function ho(b,d,e){b=b|0;d=d|0;e=e|0;var f=0;a:do switch(c[e+4>>2]&176|0){case 16:{e=a[b>>0]|0;switch(e<<24>>24){case 43:case 45:{b=b+1|0;break a}default:{}}if((d-b|0)>1&e<<24>>24==48){switch(a[b+1>>0]|0){case 88:case 120:break;default:{f=7;break a}}b=b+2|0}else f=7;break}case 32:{b=d;break}default:f=7}while(0);return b|0}function io(b,d,e,f,g,h,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0;t=i;i=i+16|0;s=t;r=Om(j,1150100)|0;m=Om(j,1150112)|0;Cb[c[(c[m>>2]|0)+20>>2]&63](s,m);p=a[s>>0]|0;q=s+4|0;if(((p&1)==0?(p&255)>>>1:c[q>>2]|0)|0){c[h>>2]=f;j=a[b>>0]|0;switch(j<<24>>24){case 43:case 45:{p=Lb[c[(c[r>>2]|0)+28>>2]&63](r,j)|0;k=c[h>>2]|0;c[h>>2]=k+1;a[k>>0]=p;k=b+1|0;break}default:k=b}a:do if((e-k|0)>1?(a[k>>0]|0)==48:0){j=k+1|0;switch(a[j>>0]|0){case 88:case 120:break;default:break a}p=Lb[c[(c[r>>2]|0)+28>>2]&63](r,48)|0;o=c[h>>2]|0;c[h>>2]=o+1;a[o>>0]=p;o=Lb[c[(c[r>>2]|0)+28>>2]&63](r,a[j>>0]|0)|0;p=c[h>>2]|0;c[h>>2]=p+1;a[p>>0]=o;k=k+2|0}while(0);b:do if((k|0)!=(e|0)){j=e;l=k;while(1){j=j+-1|0;if(l>>>0>=j>>>0)break b;p=a[l>>0]|0;a[l>>0]=a[j>>0]|0;a[j>>0]=p;l=l+1|0}}while(0);m=Fb[c[(c[m>>2]|0)+16>>2]&127](m)|0;n=s+8|0;o=s+1|0;j=0;l=0;p=k;while(1){if(p>>>0>=e>>>0)break;u=a[((a[s>>0]&1)==0?o:c[n>>2]|0)+l>>0]|0;if(u<<24>>24!=0&(j|0)==(u<<24>>24|0)){u=c[h>>2]|0;c[h>>2]=u+1;a[u>>0]=m;u=a[s>>0]|0;j=0;l=(l>>>0<(((u&1)==0?(u&255)>>>1:c[q>>2]|0)+-1|0)>>>0&1)+l|0}v=Lb[c[(c[r>>2]|0)+28>>2]&63](r,a[p>>0]|0)|0;u=c[h>>2]|0;c[h>>2]=u+1;a[u>>0]=v;j=j+1|0;p=p+1|0}j=f+(k-b)|0;k=c[h>>2]|0;if((j|0)!=(k|0)){while(1){k=k+-1|0;if(j>>>0>=k>>>0)break;v=a[j>>0]|0;a[j>>0]=a[k>>0]|0;a[k>>0]=v;j=j+1|0}j=c[h>>2]|0}}else{Jb[c[(c[r>>2]|0)+32>>2]&7](r,b,e,f)|0;j=f+(e-b)|0;c[h>>2]=j}c[g>>2]=(d|0)==(e|0)?j:f+(d-b)|0;vk(s);i=t;return}function jo(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;h=i;i=i+96|0;k=h+8|0;o=h;p=h+74|0;j=h+32|0;m=h+28|0;a=h+20|0;n=h+24|0;l=h+16|0;q=o;c[q>>2]=37;c[q+4>>2]=0;fo(o+1|0,21550,1,c[d+4>>2]|0);q=Ym()|0;r=k;c[r>>2]=f;c[r+4>>2]=g;f=p+(go(p,22,q,o,k)|0)|0;o=ho(p,f,d)|0;g=gm(d)|0;c[n>>2]=g;io(p,o,f,j,m,a,n);du(g)|0;c[l>>2]=c[b>>2];b=c[m>>2]|0;a=c[a>>2]|0;c[k>>2]=c[l>>2];a=Vd(k,j,b,a,d,e)|0;i=h;return a|0}function ko(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;h=i;i=i+64|0;k=h;o=h+56|0;q=h+44|0;j=h+20|0;m=h+16|0;b=h+8|0;n=h+12|0;l=h+4|0;a[o>>0]=a[21542]|0;a[o+1>>0]=a[21543]|0;a[o+2>>0]=a[21544]|0;a[o+3>>0]=a[21545]|0;a[o+4>>0]=a[21546]|0;a[o+5>>0]=a[21547]|0;fo(o+1|0,21548,0,c[e+4>>2]|0);p=Ym()|0;c[k>>2]=g;o=q+(go(q,12,p,o,k)|0)|0;p=ho(q,o,e)|0;g=gm(e)|0;c[n>>2]=g;io(q,p,o,j,m,b,n);du(g)|0;c[l>>2]=c[d>>2];g=c[m>>2]|0;b=c[b>>2]|0;c[k>>2]=c[l>>2];b=Vd(k,j,g,b,e,f)|0;i=h;return b|0}function lo(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;h=i;i=i+112|0;k=h+8|0;o=h;p=h+75|0;j=h+32|0;m=h+28|0;a=h+20|0;n=h+24|0;l=h+16|0;q=o;c[q>>2]=37;c[q+4>>2]=0;fo(o+1|0,21550,0,c[d+4>>2]|0);q=Ym()|0;r=k;c[r>>2]=f;c[r+4>>2]=g;f=p+(go(p,23,q,o,k)|0)|0;o=ho(p,f,d)|0;g=gm(d)|0;c[n>>2]=g;io(p,o,f,j,m,a,n);du(g)|0;c[l>>2]=c[b>>2];b=c[m>>2]|0;a=c[a>>2]|0;c[k>>2]=c[l>>2];a=Vd(k,j,b,a,d,e)|0;i=h;return a|0}function mo(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=+f;var g=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0;v=i;i=i+160|0;p=v+68|0;l=v+32|0;j=v+24|0;g=v+8|0;k=v;n=v+130|0;m=v+64|0;o=v+72|0;u=v+60|0;t=v+56|0;q=v+52|0;r=v+48|0;B=k;c[B>>2]=37;c[B+4>>2]=0;B=no(k+1|0,1219563,c[d+4>>2]|0)|0;c[m>>2]=n;a=Ym()|0;if(B){c[g>>2]=c[d+8>>2];h[g+8>>3]=f;a=go(n,30,a,k,g)|0}else{h[j>>3]=f;a=go(n,30,a,k,j)|0}if((a|0)>29){g=Ym()|0;c[l>>2]=c[d+8>>2];h[l+8>>3]=f;g=oo(m,g,k,l)|0;a=c[m>>2]|0;if(!a)Tu();else{w=a;y=a;s=g}}else{w=c[m>>2]|0;y=0;s=a}g=w+s|0;j=ho(w,g,d)|0;if((w|0)!=(n|0)){a=zj(s<<1)|0;if(!a)Tu();else{x=w;z=a;A=a}}else{x=n;z=o;A=0}B=gm(d)|0;c[q>>2]=B;po(x,j,g,z,u,t,q);du(B)|0;c[r>>2]=c[b>>2];b=c[u>>2]|0;B=c[t>>2]|0;c[p>>2]=c[r>>2];B=Vd(p,z,b,B,d,e)|0;Aj(A);Aj(y);i=v;return B|0}function no(b,c,d){b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0;if(d&2048){a[b>>0]=43;b=b+1|0}if(d&1024){a[b>>0]=35;b=b+1|0}g=d&260;e=d>>>14;h=(g|0)==260;if(h)f=0;else{a[b>>0]=46;a[b+1>>0]=42;b=b+2|0;f=1}while(1){d=a[c>>0]|0;if(!(d<<24>>24))break;a[b>>0]=d;c=c+1|0;b=b+1|0}a:do switch(g|0){case 4:if(!(e&1)){a[b>>0]=102;break a}else{a[b>>0]=70;break a}case 256:if(!(e&1)){a[b>>0]=101;break a}else{a[b>>0]=69;break a}default:{d=(e&1|0)!=0;if(h)if(d){a[b>>0]=65;break a}else{a[b>>0]=97;break a}else if(d){a[b>>0]=71;break a}else{a[b>>0]=103;break a}}}while(0);return f|0}function oo(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0;f=i;i=i+16|0;g=f;c[g>>2]=e;e=hj(b)|0;b=Pi(a,d,g)|0;if(e|0)hj(e)|0;i=f;return b|0}function po(b,d,e,f,g,h,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0;x=i;i=i+16|0;v=x;u=Om(j,1150100)|0;s=Om(j,1150112)|0;Cb[c[(c[s>>2]|0)+20>>2]&63](v,s);c[h>>2]=f;j=a[b>>0]|0;switch(j<<24>>24){case 43:case 45:{t=Lb[c[(c[u>>2]|0)+28>>2]&63](u,j)|0;k=c[h>>2]|0;c[h>>2]=k+1;a[k>>0]=t;k=b+1|0;break}default:k=b}t=e;a:do if((t-k|0)>1?(a[k>>0]|0)==48:0){j=k+1|0;switch(a[j>>0]|0){case 88:case 120:break;default:{j=k;w=10;break a}}q=Lb[c[(c[u>>2]|0)+28>>2]&63](u,48)|0;r=c[h>>2]|0;c[h>>2]=r+1;a[r>>0]=q;k=k+2|0;r=Lb[c[(c[u>>2]|0)+28>>2]&63](u,a[j>>0]|0)|0;j=c[h>>2]|0;c[h>>2]=j+1;a[j>>0]=r;j=k;while(1){if(j>>>0>=e>>>0)break a;r=a[j>>0]|0;if(!(fj(r,Ym()|0)|0))break a;j=j+1|0}}else{j=k;w=10}while(0);b:do if((w|0)==10)while(1){w=0;if(j>>>0>=e>>>0)break b;r=a[j>>0]|0;if(!(mj(r,Ym()|0)|0))break b;j=j+1|0;w=10}while(0);q=a[v>>0]|0;r=v+4|0;c:do if(((q&1)==0?(q&255)>>>1:c[r>>2]|0)|0){d:do if((k|0)!=(j|0)){l=j;m=k;while(1){l=l+-1|0;if(m>>>0>=l>>>0)break d;q=a[m>>0]|0;a[m>>0]=a[l>>0]|0;a[l>>0]=q;m=m+1|0}}while(0);n=Fb[c[(c[s>>2]|0)+16>>2]&127](s)|0;o=v+8|0;p=v+1|0;l=0;m=0;q=k;while(1){if(q>>>0>=j>>>0)break;y=a[((a[v>>0]&1)==0?p:c[o>>2]|0)+m>>0]|0;if(y<<24>>24>0&(l|0)==(y<<24>>24|0)){y=c[h>>2]|0;c[h>>2]=y+1;a[y>>0]=n;y=a[v>>0]|0;l=0;m=(m>>>0<(((y&1)==0?(y&255)>>>1:c[r>>2]|0)+-1|0)>>>0&1)+m|0}z=Lb[c[(c[u>>2]|0)+28>>2]&63](u,a[q>>0]|0)|0;y=c[h>>2]|0;c[h>>2]=y+1;a[y>>0]=z;l=l+1|0;q=q+1|0}l=f+(k-b)|0;k=c[h>>2]|0;if((l|0)==(k|0))l=u;else while(1){k=k+-1|0;if(l>>>0>=k>>>0){l=u;break c}z=a[l>>0]|0;a[l>>0]=a[k>>0]|0;a[k>>0]=z;l=l+1|0}}else{Jb[c[(c[u>>2]|0)+32>>2]&7](u,k,j,c[h>>2]|0)|0;c[h>>2]=(c[h>>2]|0)+(j-k);l=u}while(0);while(1){if(j>>>0>=e>>>0)break;k=a[j>>0]|0;if(k<<24>>24==46){w=29;break}y=Lb[c[(c[l>>2]|0)+28>>2]&63](u,k)|0;z=c[h>>2]|0;c[h>>2]=z+1;a[z>>0]=y;j=j+1|0}if((w|0)==29){y=Fb[c[(c[s>>2]|0)+12>>2]&127](s)|0;z=c[h>>2]|0;c[h>>2]=z+1;a[z>>0]=y;j=j+1|0}Jb[c[(c[u>>2]|0)+32>>2]&7](u,j,e,c[h>>2]|0)|0;z=(c[h>>2]|0)+(t-j)|0;c[h>>2]=z;c[g>>2]=(d|0)==(e|0)?z:f+(d-b)|0;vk(v);i=x;return}function qo(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=+f;var g=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0;x=i;i=i+176|0;r=x+76|0;n=x+48|0;m=x+32|0;j=x+24|0;g=x+8|0;l=x;p=x+138|0;o=x+72|0;q=x+80|0;w=x+68|0;v=x+64|0;s=x+60|0;t=x+56|0;k=l;c[k>>2]=37;c[k+4>>2]=0;k=no(l+1|0,21553,c[d+4>>2]|0)|0;c[o>>2]=p;a=Ym()|0;if(k){c[g>>2]=c[d+8>>2];h[g+8>>3]=f;a=go(p,30,a,l,g)|0}else{h[j>>3]=f;a=go(p,30,a,l,j)|0}if((a|0)>29){a=Ym()|0;if(k){c[m>>2]=c[d+8>>2];h[m+8>>3]=f;g=oo(o,a,l,m)|0}else{h[n>>3]=f;g=oo(o,a,l,n)|0}a=c[o>>2]|0;if(!a)Tu();else{y=a;A=a;u=g}}else{y=c[o>>2]|0;A=0;u=a}g=y+u|0;j=ho(y,g,d)|0;if((y|0)!=(p|0)){a=zj(u<<1)|0;if(!a)Tu();else{z=y;B=a;C=a}}else{z=p;B=q;C=0}y=gm(d)|0;c[s>>2]=y;po(z,j,g,B,w,v,s);du(y)|0;c[t>>2]=c[b>>2];z=c[w>>2]|0;b=c[v>>2]|0;c[r>>2]=c[t>>2];b=Vd(r,B,z,b,d,e)|0;Aj(C);Aj(A);i=x;return b|0}function ro(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;h=i;i=i+80|0;m=h;b=h+72|0;j=h+52|0;k=h+12|0;o=h+8|0;n=h+4|0;a[b>>0]=a[21555]|0;a[b+1>>0]=a[21556]|0;a[b+2>>0]=a[21557]|0;a[b+3>>0]=a[21558]|0;a[b+4>>0]=a[21559]|0;a[b+5>>0]=a[21560]|0;l=Ym()|0;c[m>>2]=g;b=go(j,20,l,b,m)|0;l=j+b|0;g=ho(j,l,e)|0;p=gm(e)|0;c[o>>2]=p;o=Om(o,1150100)|0;du(p)|0;Jb[c[(c[o>>2]|0)+32>>2]&7](o,j,l,k)|0;b=k+b|0;c[n>>2]=c[d>>2];c[m>>2]=c[n>>2];b=Vd(m,k,(g|0)==(l|0)?b:k+(g-j)|0,b,e,f)|0;i=h;return b|0}function so(a){a=a|0;return}function to(a){a=a|0;mu(a);return}function uo(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;m=i;i=i+32|0;l=m+8|0;h=m+4|0;j=m;if(!(c[e+4>>2]&1)){k=c[(c[b>>2]|0)+24>>2]|0;c[h>>2]=c[d>>2];c[l>>2]=c[h>>2];h=Mb[k&31](b,l,e,f,g&1)|0}else{k=gm(e)|0;c[j>>2]=k;h=Om(j,1150140)|0;du(k)|0;j=c[h>>2]|0;if(g)Cb[c[j+24>>2]&63](l,h);else Cb[c[j+28>>2]&63](l,h);e=a[l>>0]|0;b=l+4|0;g=l+8|0;k=c[g>>2]|0;h=e;j=k;k=(e&1)==0?b:k;while(1){e=(h&1)==0;if((k|0)==((e?b:j)+((e?(h&255)>>>1:c[b>>2]|0)<<2)|0))break;h=c[k>>2]|0;j=c[d>>2]|0;if(j|0){f=j+24|0;e=c[f>>2]|0;if((e|0)==(c[j+28>>2]|0))h=Lb[c[(c[j>>2]|0)+52>>2]&63](j,h)|0;else{c[f>>2]=e+4;c[e>>2]=h}if((h|0)==-1)c[d>>2]=0}h=a[l>>0]|0;j=c[g>>2]|0;k=k+4|0}h=c[d>>2]|0;Qk(l)}i=m;return h|0}function vo(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;h=i;i=i+128|0;k=h;o=h+116|0;q=h+104|0;j=h+20|0;m=h+16|0;b=h+8|0;n=h+12|0;l=h+4|0;a[o>>0]=a[21542]|0;a[o+1>>0]=a[21543]|0;a[o+2>>0]=a[21544]|0;a[o+3>>0]=a[21545]|0;a[o+4>>0]=a[21546]|0;a[o+5>>0]=a[21547]|0;fo(o+1|0,21548,1,c[e+4>>2]|0);p=Ym()|0;c[k>>2]=g;o=q+(go(q,12,p,o,k)|0)|0;p=ho(q,o,e)|0;g=gm(e)|0;c[n>>2]=g;wo(q,p,o,j,m,b,n);du(g)|0;c[l>>2]=c[d>>2];g=c[m>>2]|0;b=c[b>>2]|0;c[k>>2]=c[l>>2];b=xo(k,j,g,b,e,f)|0;i=h;return b|0}function wo(b,d,e,f,g,h,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0;t=i;i=i+16|0;s=t;r=Om(j,1150132)|0;m=Om(j,1150140)|0;Cb[c[(c[m>>2]|0)+20>>2]&63](s,m);p=a[s>>0]|0;q=s+4|0;a:do if(((p&1)==0?(p&255)>>>1:c[q>>2]|0)|0){c[h>>2]=f;j=a[b>>0]|0;switch(j<<24>>24){case 43:case 45:{p=Lb[c[(c[r>>2]|0)+44>>2]&63](r,j)|0;k=c[h>>2]|0;c[h>>2]=k+4;c[k>>2]=p;k=b+1|0;break}default:k=b}b:do if((e-k|0)>1?(a[k>>0]|0)==48:0){j=k+1|0;switch(a[j>>0]|0){case 88:case 120:break;default:break b}p=Lb[c[(c[r>>2]|0)+44>>2]&63](r,48)|0;o=c[h>>2]|0;c[h>>2]=o+4;c[o>>2]=p;o=Lb[c[(c[r>>2]|0)+44>>2]&63](r,a[j>>0]|0)|0;p=c[h>>2]|0;c[h>>2]=p+4;c[p>>2]=o;k=k+2|0}while(0);c:do if((k|0)!=(e|0)){j=e;l=k;while(1){j=j+-1|0;if(l>>>0>=j>>>0)break c;p=a[l>>0]|0;a[l>>0]=a[j>>0]|0;a[j>>0]=p;l=l+1|0}}while(0);m=Fb[c[(c[m>>2]|0)+16>>2]&127](m)|0;n=s+8|0;o=s+1|0;j=0;l=0;p=k;while(1){if(p>>>0>=e>>>0)break;u=a[((a[s>>0]&1)==0?o:c[n>>2]|0)+l>>0]|0;if(u<<24>>24!=0&(j|0)==(u<<24>>24|0)){u=c[h>>2]|0;c[h>>2]=u+4;c[u>>2]=m;u=a[s>>0]|0;j=0;l=(l>>>0<(((u&1)==0?(u&255)>>>1:c[q>>2]|0)+-1|0)>>>0&1)+l|0}v=Lb[c[(c[r>>2]|0)+44>>2]&63](r,a[p>>0]|0)|0;u=c[h>>2]|0;c[h>>2]=u+4;c[u>>2]=v;j=j+1|0;p=p+1|0}j=f+(k-b<<2)|0;l=c[h>>2]|0;if((j|0)!=(l|0)){k=l;while(1){k=k+-4|0;if(j>>>0>=k>>>0){j=l;break a}v=c[j>>2]|0;c[j>>2]=c[k>>2];c[k>>2]=v;j=j+4|0}}}else{Jb[c[(c[r>>2]|0)+48>>2]&7](r,b,e,f)|0;j=f+(e-b<<2)|0;c[h>>2]=j}while(0);c[g>>2]=(d|0)==(e|0)?j:f+(d-b<<2)|0;vk(s);i=t;return}function xo(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0;o=i;i=i+16|0;n=o;j=c[b>>2]|0;a:do if(!j)j=0;else{p=d;l=f-p>>2;m=g+12|0;g=c[m>>2]|0;l=(g|0)>(l|0)?g-l|0:0;g=e;p=g-p|0;k=p>>2;if((p|0)>0?(yb[c[(c[j>>2]|0)+48>>2]&31](j,d,k)|0)!=(k|0):0){c[b>>2]=0;j=0;break}do if((l|0)>0){Ok(n,l,h);if((yb[c[(c[j>>2]|0)+48>>2]&31](j,(a[n>>0]&1)==0?n+4|0:c[n+8>>2]|0,l)|0)==(l|0)){Qk(n);break}else{c[b>>2]=0;Qk(n);j=0;break a}}while(0);p=f-g|0;f=p>>2;if((p|0)>0?(yb[c[(c[j>>2]|0)+48>>2]&31](j,e,f)|0)!=(f|0):0){c[b>>2]=0;j=0;break}c[m>>2]=0}while(0);i=o;return j|0}function yo(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;h=i;i=i+224|0;k=h+8|0;o=h;p=h+196|0;j=h+32|0;m=h+28|0;a=h+20|0;n=h+24|0;l=h+16|0;q=o;c[q>>2]=37;c[q+4>>2]=0;fo(o+1|0,21550,1,c[d+4>>2]|0);q=Ym()|0;r=k;c[r>>2]=f;c[r+4>>2]=g;f=p+(go(p,22,q,o,k)|0)|0;o=ho(p,f,d)|0;g=gm(d)|0;c[n>>2]=g;wo(p,o,f,j,m,a,n);du(g)|0;c[l>>2]=c[b>>2];b=c[m>>2]|0;a=c[a>>2]|0;c[k>>2]=c[l>>2];a=xo(k,j,b,a,d,e)|0;i=h;return a|0}function zo(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;h=i;i=i+128|0;k=h;o=h+116|0;q=h+104|0;j=h+20|0;m=h+16|0;b=h+8|0;n=h+12|0;l=h+4|0;a[o>>0]=a[21542]|0;a[o+1>>0]=a[21543]|0;a[o+2>>0]=a[21544]|0;a[o+3>>0]=a[21545]|0;a[o+4>>0]=a[21546]|0;a[o+5>>0]=a[21547]|0;fo(o+1|0,21548,0,c[e+4>>2]|0);p=Ym()|0;c[k>>2]=g;o=q+(go(q,12,p,o,k)|0)|0;p=ho(q,o,e)|0;g=gm(e)|0;c[n>>2]=g;wo(q,p,o,j,m,b,n);du(g)|0;c[l>>2]=c[d>>2];g=c[m>>2]|0;b=c[b>>2]|0;c[k>>2]=c[l>>2];b=xo(k,j,g,b,e,f)|0;i=h;return b|0}function Ao(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;h=i;i=i+240|0;k=h+8|0;o=h;p=h+204|0;j=h+32|0;m=h+28|0;a=h+20|0;n=h+24|0;l=h+16|0;q=o;c[q>>2]=37;c[q+4>>2]=0;fo(o+1|0,21550,0,c[d+4>>2]|0);q=Ym()|0;r=k;c[r>>2]=f;c[r+4>>2]=g;f=p+(go(p,23,q,o,k)|0)|0;o=ho(p,f,d)|0;g=gm(d)|0;c[n>>2]=g;wo(p,o,f,j,m,a,n);du(g)|0;c[l>>2]=c[b>>2];b=c[m>>2]|0;a=c[a>>2]|0;c[k>>2]=c[l>>2];a=xo(k,j,b,a,d,e)|0;i=h;return a|0}function Bo(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=+f;var g=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0;y=i;i=i+336|0;p=y+296|0;l=y+32|0;j=y+24|0;g=y+8|0;k=y;n=y+300|0;m=y+292|0;o=y+64|0;u=y+60|0;t=y+56|0;q=y+52|0;r=y+48|0;B=k;c[B>>2]=37;c[B+4>>2]=0;B=no(k+1|0,1219563,c[d+4>>2]|0)|0;c[m>>2]=n;a=Ym()|0;if(B){c[g>>2]=c[d+8>>2];h[g+8>>3]=f;a=go(n,30,a,k,g)|0}else{h[j>>3]=f;a=go(n,30,a,k,j)|0}if((a|0)>29){g=Ym()|0;c[l>>2]=c[d+8>>2];h[l+8>>3]=f;g=oo(m,g,k,l)|0;a=c[m>>2]|0;if(!a)Tu();else{v=a;z=a;s=g}}else{v=c[m>>2]|0;z=0;s=a}g=v+s|0;j=ho(v,g,d)|0;if((v|0)!=(n|0)){a=zj(s<<3)|0;if(!a)Tu();else{w=v;x=a;A=a}}else{w=n;x=o;A=0}B=gm(d)|0;c[q>>2]=B;Co(w,j,g,x,u,t,q);du(B)|0;c[r>>2]=c[b>>2];B=c[u>>2]|0;a=c[t>>2]|0;c[p>>2]=c[r>>2];a=xo(p,x,B,a,d,e)|0;c[b>>2]=a;if(A|0)Aj(A);Aj(z);i=y;return a|0}function Co(b,d,e,f,g,h,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0;x=i;i=i+16|0;v=x;u=Om(j,1150132)|0;s=Om(j,1150140)|0;Cb[c[(c[s>>2]|0)+20>>2]&63](v,s);c[h>>2]=f;j=a[b>>0]|0;switch(j<<24>>24){case 43:case 45:{t=Lb[c[(c[u>>2]|0)+44>>2]&63](u,j)|0;k=c[h>>2]|0;c[h>>2]=k+4;c[k>>2]=t;k=b+1|0;break}default:k=b}t=e;a:do if((t-k|0)>1?(a[k>>0]|0)==48:0){j=k+1|0;switch(a[j>>0]|0){case 88:case 120:break;default:{j=k;w=10;break a}}q=Lb[c[(c[u>>2]|0)+44>>2]&63](u,48)|0;r=c[h>>2]|0;c[h>>2]=r+4;c[r>>2]=q;k=k+2|0;r=Lb[c[(c[u>>2]|0)+44>>2]&63](u,a[j>>0]|0)|0;j=c[h>>2]|0;c[h>>2]=j+4;c[j>>2]=r;j=k;while(1){if(j>>>0>=e>>>0)break a;r=a[j>>0]|0;if(!(fj(r,Ym()|0)|0))break a;j=j+1|0}}else{j=k;w=10}while(0);b:do if((w|0)==10)while(1){w=0;if(j>>>0>=e>>>0)break b;r=a[j>>0]|0;if(!(mj(r,Ym()|0)|0))break b;j=j+1|0;w=10}while(0);q=a[v>>0]|0;r=v+4|0;c:do if(((q&1)==0?(q&255)>>>1:c[r>>2]|0)|0){d:do if((k|0)!=(j|0)){l=j;m=k;while(1){l=l+-1|0;if(m>>>0>=l>>>0)break d;q=a[m>>0]|0;a[m>>0]=a[l>>0]|0;a[l>>0]=q;m=m+1|0}}while(0);n=Fb[c[(c[s>>2]|0)+16>>2]&127](s)|0;o=v+8|0;p=v+1|0;l=0;m=0;q=k;while(1){if(q>>>0>=j>>>0)break;y=a[((a[v>>0]&1)==0?p:c[o>>2]|0)+m>>0]|0;if(y<<24>>24>0&(l|0)==(y<<24>>24|0)){y=c[h>>2]|0;c[h>>2]=y+4;c[y>>2]=n;y=a[v>>0]|0;l=0;m=(m>>>0<(((y&1)==0?(y&255)>>>1:c[r>>2]|0)+-1|0)>>>0&1)+m|0}z=Lb[c[(c[u>>2]|0)+44>>2]&63](u,a[q>>0]|0)|0;y=c[h>>2]|0;c[h>>2]=y+4;c[y>>2]=z;l=l+1|0;q=q+1|0}k=f+(k-b<<2)|0;m=c[h>>2]|0;if((k|0)==(m|0))l=u;else{l=m;while(1){l=l+-4|0;if(k>>>0>=l>>>0){l=u;k=m;break c}z=c[k>>2]|0;c[k>>2]=c[l>>2];c[l>>2]=z;k=k+4|0}}}else{Jb[c[(c[u>>2]|0)+48>>2]&7](u,k,j,c[h>>2]|0)|0;k=(c[h>>2]|0)+(j-k<<2)|0;c[h>>2]=k;l=u}while(0);while(1){if(j>>>0>=e>>>0)break;k=a[j>>0]|0;if(k<<24>>24==46){w=29;break}y=Lb[c[(c[l>>2]|0)+44>>2]&63](u,k)|0;z=c[h>>2]|0;k=z+4|0;c[h>>2]=k;c[z>>2]=y;j=j+1|0}if((w|0)==29){y=Fb[c[(c[s>>2]|0)+12>>2]&127](s)|0;z=c[h>>2]|0;k=z+4|0;c[h>>2]=k;c[z>>2]=y;j=j+1|0}Jb[c[(c[u>>2]|0)+48>>2]&7](u,j,e,k)|0;z=(c[h>>2]|0)+(t-j<<2)|0;c[h>>2]=z;c[g>>2]=(d|0)==(e|0)?z:f+(d-b<<2)|0;vk(v);i=x;return}function Do(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=+f;var g=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0;A=i;i=i+352|0;r=A+304|0;n=A+48|0;m=A+32|0;j=A+24|0;g=A+8|0;l=A;p=A+308|0;o=A+300|0;q=A+72|0;w=A+68|0;v=A+64|0;s=A+60|0;t=A+56|0;k=l;c[k>>2]=37;c[k+4>>2]=0;k=no(l+1|0,21553,c[d+4>>2]|0)|0;c[o>>2]=p;a=Ym()|0;if(k){c[g>>2]=c[d+8>>2];h[g+8>>3]=f;a=go(p,30,a,l,g)|0}else{h[j>>3]=f;a=go(p,30,a,l,j)|0}if((a|0)>29){a=Ym()|0;if(k){c[m>>2]=c[d+8>>2];h[m+8>>3]=f;g=oo(o,a,l,m)|0}else{h[n>>3]=f;g=oo(o,a,l,n)|0}a=c[o>>2]|0;if(!a)Tu();else{x=a;B=a;u=g}}else{x=c[o>>2]|0;B=0;u=a}g=x+u|0;j=ho(x,g,d)|0;if((x|0)!=(p|0)){a=zj(u<<3)|0;if(!a)Tu();else{y=x;z=a;C=a}}else{y=p;z=q;C=0}a=gm(d)|0;c[s>>2]=a;Co(y,j,g,z,w,v,s);du(a)|0;c[t>>2]=c[b>>2];y=c[w>>2]|0;a=c[v>>2]|0;c[r>>2]=c[t>>2];a=xo(r,z,y,a,d,e)|0;c[b>>2]=a;if(C|0)Aj(C);Aj(B);i=A;return a|0}function Eo(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;h=i;i=i+192|0;m=h;b=h+180|0;j=h+160|0;k=h+8|0;o=h+156|0;n=h+4|0;a[b>>0]=a[21555]|0;a[b+1>>0]=a[21556]|0;a[b+2>>0]=a[21557]|0;a[b+3>>0]=a[21558]|0;a[b+4>>0]=a[21559]|0;a[b+5>>0]=a[21560]|0;l=Ym()|0;c[m>>2]=g;b=go(j,20,l,b,m)|0;l=j+b|0;g=ho(j,l,e)|0;p=gm(e)|0;c[o>>2]=p;o=Om(o,1150132)|0;du(p)|0;Jb[c[(c[o>>2]|0)+48>>2]&7](o,j,l,k)|0;b=k+(b<<2)|0;c[n>>2]=c[d>>2];c[m>>2]=c[n>>2];b=xo(m,k,(g|0)==(l|0)?b:k+(g-j<<2)|0,b,e,f)|0;i=h;return b|0}function Fo(a){a=a|0;return}function Go(a){a=a|0;mu(a);return}function Ho(a){a=a|0;return 2}function Io(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;h=i;i=i+16|0;j=h+12|0;k=h+8|0;m=h+4|0;l=h;c[m>>2]=c[b>>2];c[l>>2]=c[d>>2];c[k>>2]=c[m>>2];c[j>>2]=c[l>>2];a=Jo(a,k,j,e,f,g,21773,21781)|0;i=h;return a|0}function Jo(e,f,g,h,j,k,l,m){e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;var n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0;B=i;i=i+32|0;u=B+16|0;t=B+12|0;x=B+8|0;v=B+4|0;w=B;y=gm(h)|0;c[x>>2]=y;x=Om(x,1150100)|0;du(y)|0;c[j>>2]=0;y=x+8|0;n=l;l=0;a:while(1){s=(n|0)!=(m|0);o=l;while(1){l=c[f>>2]|0;if(!(s&(o|0)==0))break a;o=l;if(l){if((c[l+12>>2]|0)==(c[l+16>>2]|0)?(Fb[c[(c[l>>2]|0)+36>>2]&127](l)|0)==-1:0){c[f>>2]=0;o=0;l=0}}else l=0;r=(l|0)==0;q=c[g>>2]|0;p=q;do if(q){if((c[q+12>>2]|0)==(c[q+16>>2]|0)?(Fb[c[(c[q>>2]|0)+36>>2]&127](q)|0)==-1:0){c[g>>2]=0;p=0;A=13;break}if(!r){A=14;break a}}else A=13;while(0);if((A|0)==13){A=0;if(r){A=14;break a}else q=0}if((yb[c[(c[x>>2]|0)+36>>2]&31](x,a[n>>0]|0,0)|0)<<24>>24==37){s=p;A=16;break}o=a[n>>0]|0;if(o<<24>>24>-1?(z=c[y>>2]|0,b[z+(o<<24>>24<<1)>>1]&8192):0){p=z;A=25;break}q=l+12|0;p=c[q>>2]|0;o=l+16|0;if((p|0)==(c[o>>2]|0))p=Fb[c[(c[l>>2]|0)+36>>2]&127](l)|0;else p=d[p>>0]|0;r=Lb[c[(c[x>>2]|0)+12>>2]&63](x,p&255)|0;if(r<<24>>24==(Lb[c[(c[x>>2]|0)+12>>2]&63](x,a[n>>0]|0)|0)<<24>>24){A=53;break}c[j>>2]=4;o=4}b:do if((A|0)==16){A=0;p=n+1|0;if((p|0)==(m|0)){A=17;break a}r=yb[c[(c[x>>2]|0)+36>>2]&31](x,a[p>>0]|0,0)|0;switch(r<<24>>24){case 48:case 69:{q=n+2|0;if((q|0)==(m|0)){A=22;break a}n=p;p=yb[c[(c[x>>2]|0)+36>>2]&31](x,a[q>>0]|0,0)|0;l=r;break}default:{p=r;l=0}}r=c[(c[e>>2]|0)+36>>2]|0;c[v>>2]=o;c[w>>2]=s;c[t>>2]=c[v>>2];c[u>>2]=c[w>>2];c[f>>2]=Ib[r&15](e,t,u,h,j,k,p,l)|0;l=n+2|0}else if((A|0)==25){A=0;do{n=n+1|0;if((n|0)==(m|0)){n=m;break}o=a[n>>0]|0;if(o<<24>>24<=-1)break}while((b[p+(o<<24>>24<<1)>>1]&8192)!=0);o=q;while(1){if(l){if((c[l+12>>2]|0)==(c[l+16>>2]|0)?(Fb[c[(c[l>>2]|0)+36>>2]&127](l)|0)==-1:0){c[f>>2]=0;l=0}}else l=0;p=(l|0)==0;do if(q){if((c[q+12>>2]|0)!=(c[q+16>>2]|0))if(p){s=o;break}else{l=n;break b}if((Fb[c[(c[q>>2]|0)+36>>2]&127](q)|0)!=-1)if(p^(o|0)==0){s=o;q=o;break}else{l=n;break b}else{c[g>>2]=0;o=0;A=39;break}}else A=39;while(0);if((A|0)==39){A=0;if(p){l=n;break b}else{s=o;q=0}}p=l+12|0;o=c[p>>2]|0;r=l+16|0;if((o|0)==(c[r>>2]|0))o=Fb[c[(c[l>>2]|0)+36>>2]&127](l)|0;else o=d[o>>0]|0;if((o&255)<<24>>24<=-1){l=n;break b}if(!(b[(c[y>>2]|0)+(o<<24>>24<<1)>>1]&8192)){l=n;break b}o=c[p>>2]|0;if((o|0)==(c[r>>2]|0)){Fb[c[(c[l>>2]|0)+40>>2]&127](l)|0;o=s;continue}else{c[p>>2]=o+1;o=s;continue}}}else if((A|0)==53){A=0;p=c[q>>2]|0;if((p|0)==(c[o>>2]|0))Fb[c[(c[l>>2]|0)+40>>2]&127](l)|0;else c[q>>2]=p+1;l=n+1|0}while(0);n=l;l=c[j>>2]|0}if((A|0)==14)c[j>>2]=4;else if((A|0)==17)c[j>>2]=4;else if((A|0)==22)c[j>>2]=4;if(l){if((c[l+12>>2]|0)==(c[l+16>>2]|0)?(Fb[c[(c[l>>2]|0)+36>>2]&127](l)|0)==-1:0){c[f>>2]=0;l=0}}else l=0;n=(l|0)==0;o=c[g>>2]|0;do if(o){if((c[o+12>>2]|0)==(c[o+16>>2]|0)?(Fb[c[(c[o>>2]|0)+36>>2]&127](o)|0)==-1:0){c[g>>2]=0;A=68;break}if(!n)A=69}else A=68;while(0);if((A|0)==68?n:0)A=69;if((A|0)==69)c[j>>2]=c[j>>2]|2;i=B;return l|0}function Ko(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0;j=i;i=i+16|0;k=j+12|0;l=j+8|0;n=j+4|0;m=j;o=b+8|0;o=Fb[c[(c[o>>2]|0)+20>>2]&127](o)|0;c[n>>2]=c[d>>2];c[m>>2]=c[e>>2];e=a[o>>0]|0;p=(e&1)==0;d=p?o+1|0:c[o+8>>2]|0;e=d+(p?(e&255)>>>1:c[o+4>>2]|0)|0;c[l>>2]=c[n>>2];c[k>>2]=c[m>>2];b=Jo(b,l,k,f,g,h,d,e)|0;i=j;return b|0}function Lo(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;h=i;i=i+16|0;j=h+8|0;m=h+4|0;k=h;l=gm(e)|0;c[m>>2]=l;e=Om(m,1150100)|0;du(l)|0;c[k>>2]=c[d>>2];c[j>>2]=c[k>>2];Mo(a,g+24|0,b,j,f,e);i=h;return c[b>>2]|0}function Mo(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0;h=i;i=i+16|0;j=h+4|0;k=h;a=a+8|0;a=Fb[c[c[a>>2]>>2]&127](a)|0;c[k>>2]=c[e>>2];c[j>>2]=c[k>>2];d=(Sm(d,j,a,a+168|0,g,f,0)|0)-a|0;if((d|0)<168)c[b>>2]=((d|0)/12|0|0)%7|0;i=h;return}function No(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;h=i;i=i+16|0;j=h+8|0;m=h+4|0;k=h;l=gm(e)|0;c[m>>2]=l;e=Om(m,1150100)|0;du(l)|0;c[k>>2]=c[d>>2];c[j>>2]=c[k>>2];Oo(a,g+16|0,b,j,f,e);i=h;return c[b>>2]|0}function Oo(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0;h=i;i=i+16|0;j=h+4|0;k=h;a=a+8|0;a=Fb[c[(c[a>>2]|0)+4>>2]&127](a)|0;c[k>>2]=c[e>>2];c[j>>2]=c[k>>2];d=(Sm(d,j,a,a+288|0,g,f,0)|0)-a|0;if((d|0)<288)c[b>>2]=((d|0)/12|0|0)%12|0;i=h;return}function Po(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;h=i;i=i+16|0;j=h+8|0;m=h+4|0;k=h;l=gm(e)|0;c[m>>2]=l;e=Om(m,1150100)|0;du(l)|0;c[k>>2]=c[d>>2];c[j>>2]=c[k>>2];Qo(a,g+20|0,b,j,f,e);i=h;return c[b>>2]|0}function Qo(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0;h=i;i=i+16|0;a=h+4|0;j=h;c[j>>2]=c[e>>2];c[a>>2]=c[j>>2];a=Ro(d,a,f,g,4)|0;if(!(c[f>>2]&4)){if((a|0)<69)a=a+2e3|0;else a=(a+-69|0)>>>0<31?a+1900|0:a;c[b>>2]=a+-1900}i=h;return}function Ro(a,e,f,g,h){a=a|0;e=e|0;f=f|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;i=c[a>>2]|0;do if(i){if((c[i+12>>2]|0)==(c[i+16>>2]|0))if((Fb[c[(c[i>>2]|0)+36>>2]&127](i)|0)==-1){c[a>>2]=0;i=0;break}else{i=c[a>>2]|0;break}}else i=0;while(0);j=(i|0)==0;i=c[e>>2]|0;do if(i){if((c[i+12>>2]|0)==(c[i+16>>2]|0)?(Fb[c[(c[i>>2]|0)+36>>2]&127](i)|0)==-1:0){c[e>>2]=0;r=11;break}if(j)r=13;else r=12}else r=11;while(0);if((r|0)==11)if(j)r=12;else{i=0;r=13}a:do if((r|0)==12){c[f>>2]=c[f>>2]|6;i=0}else if((r|0)==13){j=c[a>>2]|0;k=c[j+12>>2]|0;if((k|0)==(c[j+16>>2]|0))j=Fb[c[(c[j>>2]|0)+36>>2]&127](j)|0;else j=d[k>>0]|0;k=j&255;if(k<<24>>24>-1?(q=g+8|0,b[(c[q>>2]|0)+(j<<24>>24<<1)>>1]&2048):0){m=(yb[c[(c[g>>2]|0)+36>>2]&31](g,k,0)|0)<<24>>24;j=c[a>>2]|0;k=j+12|0;l=c[k>>2]|0;if((l|0)==(c[j+16>>2]|0)){Fb[c[(c[j>>2]|0)+40>>2]&127](j)|0;o=h;n=i;h=i;i=m}else{c[k>>2]=l+1;o=h;n=i;h=i;i=m}while(1){i=i+-48|0;p=o+-1|0;j=c[a>>2]|0;do if(j){if((c[j+12>>2]|0)==(c[j+16>>2]|0))if((Fb[c[(c[j>>2]|0)+36>>2]&127](j)|0)==-1){c[a>>2]=0;j=0;break}else{j=c[a>>2]|0;break}}else j=0;while(0);l=(j|0)==0;if(h)if((c[h+12>>2]|0)==(c[h+16>>2]|0))if((Fb[c[(c[h>>2]|0)+36>>2]&127](h)|0)==-1){c[e>>2]=0;k=0;h=0}else{k=n;h=n}else k=n;else{k=n;h=0}j=c[a>>2]|0;if(!((o|0)>1&(l^(h|0)==0)))break;l=c[j+12>>2]|0;if((l|0)==(c[j+16>>2]|0))j=Fb[c[(c[j>>2]|0)+36>>2]&127](j)|0;else j=d[l>>0]|0;l=j&255;if(l<<24>>24<=-1)break a;if(!(b[(c[q>>2]|0)+(j<<24>>24<<1)>>1]&2048))break a;i=((yb[c[(c[g>>2]|0)+36>>2]&31](g,l,0)|0)<<24>>24)+(i*10|0)|0;j=c[a>>2]|0;l=j+12|0;m=c[l>>2]|0;if((m|0)==(c[j+16>>2]|0)){Fb[c[(c[j>>2]|0)+40>>2]&127](j)|0;o=p;n=k;continue}else{c[l>>2]=m+1;o=p;n=k;continue}}do if(j){if((c[j+12>>2]|0)==(c[j+16>>2]|0))if((Fb[c[(c[j>>2]|0)+36>>2]&127](j)|0)==-1){c[a>>2]=0;j=0;break}else{j=c[a>>2]|0;break}}else j=0;while(0);j=(j|0)==0;do if(k){if((c[k+12>>2]|0)==(c[k+16>>2]|0)?(Fb[c[(c[k>>2]|0)+36>>2]&127](k)|0)==-1:0){c[e>>2]=0;r=50;break}if(j)break a}else r=50;while(0);if((r|0)==50?!j:0)break;c[f>>2]=c[f>>2]|2;break}c[f>>2]=c[f>>2]|4;i=0}while(0);return i|0}function So(b,d,e,f,g,h,j,k){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0;S=i;i=i+144|0;l=S+132|0;k=S+116|0;L=S+128|0;w=S+124|0;H=S+120|0;M=S+112|0;N=S+108|0;O=S+104|0;P=S+100|0;Q=S+96|0;R=S+92|0;m=S+88|0;n=S+84|0;o=S+80|0;p=S+76|0;q=S+72|0;r=S+68|0;s=S+64|0;t=S+60|0;u=S+56|0;v=S+52|0;x=S+48|0;y=S+44|0;z=S+40|0;A=S+36|0;B=S+32|0;C=S+28|0;D=S+24|0;E=S+20|0;F=S+16|0;G=S+12|0;I=S+8|0;J=S+4|0;K=S;c[g>>2]=0;U=gm(f)|0;c[L>>2]=U;L=Om(L,1150100)|0;du(U)|0;do switch(j<<24>>24|0){case 65:case 97:{c[w>>2]=c[e>>2];c[l>>2]=c[w>>2];Mo(b,h+24|0,d,l,g,L);T=26;break}case 104:case 66:case 98:{c[H>>2]=c[e>>2];c[l>>2]=c[H>>2];Oo(b,h+16|0,d,l,g,L);T=26;break}case 99:{T=b+8|0;T=Fb[c[(c[T>>2]|0)+12>>2]&127](T)|0;c[M>>2]=c[d>>2];c[N>>2]=c[e>>2];j=a[T>>0]|0;e=(j&1)==0;U=e?T+1|0:c[T+8>>2]|0;T=U+(e?(j&255)>>>1:c[T+4>>2]|0)|0;c[k>>2]=c[M>>2];c[l>>2]=c[N>>2];c[d>>2]=Jo(b,k,l,f,g,h,U,T)|0;T=26;break}case 101:case 100:{c[O>>2]=c[e>>2];c[l>>2]=c[O>>2];To(b,h+12|0,d,l,g,L);T=26;break}case 68:{c[P>>2]=c[d>>2];c[Q>>2]=c[e>>2];c[k>>2]=c[P>>2];c[l>>2]=c[Q>>2];c[d>>2]=Jo(b,k,l,f,g,h,21781,21789)|0;T=26;break}case 70:{c[R>>2]=c[d>>2];c[m>>2]=c[e>>2];c[k>>2]=c[R>>2];c[l>>2]=c[m>>2];c[d>>2]=Jo(b,k,l,f,g,h,21789,21797)|0;T=26;break}case 72:{c[n>>2]=c[e>>2];c[l>>2]=c[n>>2];Uo(b,h+8|0,d,l,g,L);T=26;break}case 73:{c[o>>2]=c[e>>2];c[l>>2]=c[o>>2];Vo(b,h+8|0,d,l,g,L);T=26;break}case 106:{c[p>>2]=c[e>>2];c[l>>2]=c[p>>2];Wo(b,h+28|0,d,l,g,L);T=26;break}case 109:{c[q>>2]=c[e>>2];c[l>>2]=c[q>>2];Xo(b,h+16|0,d,l,g,L);T=26;break}case 77:{c[r>>2]=c[e>>2];c[l>>2]=c[r>>2];Yo(b,h+4|0,d,l,g,L);T=26;break}case 116:case 110:{c[s>>2]=c[e>>2];c[l>>2]=c[s>>2];Zo(b,d,l,g,L);T=26;break}case 112:{c[t>>2]=c[e>>2];c[l>>2]=c[t>>2];_o(b,h+8|0,d,l,g,L);T=26;break}case 114:{c[u>>2]=c[d>>2];c[v>>2]=c[e>>2];c[k>>2]=c[u>>2];c[l>>2]=c[v>>2];c[d>>2]=Jo(b,k,l,f,g,h,21797,21808)|0;T=26;break}case 82:{c[x>>2]=c[d>>2];c[y>>2]=c[e>>2];c[k>>2]=c[x>>2];c[l>>2]=c[y>>2];c[d>>2]=Jo(b,k,l,f,g,h,21808,21813)|0;T=26;break}case 83:{c[z>>2]=c[e>>2];c[l>>2]=c[z>>2];$o(b,h,d,l,g,L);T=26;break}case 84:{c[A>>2]=c[d>>2];c[B>>2]=c[e>>2];c[k>>2]=c[A>>2];c[l>>2]=c[B>>2];c[d>>2]=Jo(b,k,l,f,g,h,21813,21821)|0;T=26;break}case 119:{c[C>>2]=c[e>>2];c[l>>2]=c[C>>2];ap(b,h+24|0,d,l,g,L);T=26;break}case 120:{U=c[(c[b>>2]|0)+20>>2]|0;c[D>>2]=c[d>>2];c[E>>2]=c[e>>2];c[k>>2]=c[D>>2];c[l>>2]=c[E>>2];k=Db[U&63](b,k,l,f,g,h)|0;break}case 88:{T=b+8|0;T=Fb[c[(c[T>>2]|0)+24>>2]&127](T)|0;c[F>>2]=c[d>>2];c[G>>2]=c[e>>2];j=a[T>>0]|0;e=(j&1)==0;U=e?T+1|0:c[T+8>>2]|0;T=U+(e?(j&255)>>>1:c[T+4>>2]|0)|0;c[k>>2]=c[F>>2];c[l>>2]=c[G>>2];c[d>>2]=Jo(b,k,l,f,g,h,U,T)|0;T=26;break}case 121:{c[I>>2]=c[e>>2];c[l>>2]=c[I>>2];Qo(b,h+20|0,d,l,g,L);T=26;break}case 89:{c[J>>2]=c[e>>2];c[l>>2]=c[J>>2];bp(b,h+20|0,d,l,g,L);T=26;break}case 37:{c[K>>2]=c[e>>2];c[l>>2]=c[K>>2];cp(b,d,l,g,L);T=26;break}default:{c[g>>2]=c[g>>2]|4;T=26}}while(0);if((T|0)==26)k=c[d>>2]|0;i=S;return k|0}function To(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0;h=i;i=i+16|0;a=h+4|0;j=h;c[j>>2]=c[e>>2];c[a>>2]=c[j>>2];a=Ro(d,a,f,g,2)|0;d=c[f>>2]|0;if((a+-1|0)>>>0<31&(d&4|0)==0)c[b>>2]=a;else c[f>>2]=d|4;i=h;return}function Uo(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0;h=i;i=i+16|0;a=h+4|0;j=h;c[j>>2]=c[e>>2];c[a>>2]=c[j>>2];a=Ro(d,a,f,g,2)|0;d=c[f>>2]|0;if((a|0)<24&(d&4|0)==0)c[b>>2]=a;else c[f>>2]=d|4;i=h;return}function Vo(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0;h=i;i=i+16|0;a=h+4|0;j=h;c[j>>2]=c[e>>2];c[a>>2]=c[j>>2];a=Ro(d,a,f,g,2)|0;d=c[f>>2]|0;if((a+-1|0)>>>0<12&(d&4|0)==0)c[b>>2]=a;else c[f>>2]=d|4;i=h;return}function Wo(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0;h=i;i=i+16|0;a=h+4|0;j=h;c[j>>2]=c[e>>2];c[a>>2]=c[j>>2];a=Ro(d,a,f,g,3)|0;d=c[f>>2]|0;if((a|0)<366&(d&4|0)==0)c[b>>2]=a;else c[f>>2]=d|4;i=h;return}function Xo(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0;h=i;i=i+16|0;a=h+4|0;j=h;c[j>>2]=c[e>>2];c[a>>2]=c[j>>2];a=Ro(d,a,f,g,2)|0;d=c[f>>2]|0;if((a|0)<13&(d&4|0)==0)c[b>>2]=a+-1;else c[f>>2]=d|4;i=h;return}function Yo(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0;h=i;i=i+16|0;a=h+4|0;j=h;c[j>>2]=c[e>>2];c[a>>2]=c[j>>2];a=Ro(d,a,f,g,2)|0;d=c[f>>2]|0;if((a|0)<60&(d&4|0)==0)c[b>>2]=a;else c[f>>2]=d|4;i=h;return}function Zo(a,e,f,g,h){a=a|0;e=e|0;f=f|0;g=g|0;h=h|0;var i=0,j=0,k=0;j=h+8|0;a:while(1){h=c[e>>2]|0;do if(h){if((c[h+12>>2]|0)==(c[h+16>>2]|0))if((Fb[c[(c[h>>2]|0)+36>>2]&127](h)|0)==-1){c[e>>2]=0;h=0;break}else{h=c[e>>2]|0;break}}else h=0;while(0);h=(h|0)==0;a=c[f>>2]|0;do if(a){if((c[a+12>>2]|0)!=(c[a+16>>2]|0))if(h)break;else break a;if((Fb[c[(c[a>>2]|0)+36>>2]&127](a)|0)!=-1)if(h)break;else break a;else{c[f>>2]=0;k=12;break}}else k=12;while(0);if((k|0)==12){k=0;if(h){a=0;break}else a=0}h=c[e>>2]|0;i=c[h+12>>2]|0;if((i|0)==(c[h+16>>2]|0))h=Fb[c[(c[h>>2]|0)+36>>2]&127](h)|0;else h=d[i>>0]|0;if((h&255)<<24>>24<=-1)break;if(!(b[(c[j>>2]|0)+(h<<24>>24<<1)>>1]&8192))break;h=c[e>>2]|0;a=h+12|0;i=c[a>>2]|0;if((i|0)==(c[h+16>>2]|0)){Fb[c[(c[h>>2]|0)+40>>2]&127](h)|0;continue}else{c[a>>2]=i+1;continue}}h=c[e>>2]|0;do if(h){if((c[h+12>>2]|0)==(c[h+16>>2]|0))if((Fb[c[(c[h>>2]|0)+36>>2]&127](h)|0)==-1){c[e>>2]=0;h=0;break}else{h=c[e>>2]|0;break}}else h=0;while(0);h=(h|0)==0;do if(a){if((c[a+12>>2]|0)==(c[a+16>>2]|0)?(Fb[c[(c[a>>2]|0)+36>>2]&127](a)|0)==-1:0){c[f>>2]=0;k=32;break}if(!h)k=33}else k=32;while(0);if((k|0)==32?h:0)k=33;if((k|0)==33)c[g>>2]=c[g>>2]|2;return}function _o(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0;n=i;i=i+16|0;k=n+4|0;l=n;m=b+8|0;m=Fb[c[(c[m>>2]|0)+8>>2]&127](m)|0;b=a[m>>0]|0;if(!(b&1))j=(b&255)>>>1;else j=c[m+4>>2]|0;b=a[m+12>>0]|0;if(!(b&1))b=(b&255)>>>1;else b=c[m+16>>2]|0;do if((j|0)!=(0-b|0)){c[l>>2]=c[f>>2];c[k>>2]=c[l>>2];b=Sm(e,k,m,m+24|0,h,g,0)|0;j=c[d>>2]|0;if((b|0)==(m|0)&(j|0)==12){c[d>>2]=0;break}if((j|0)<12&(b-m|0)==12)c[d>>2]=j+12}else c[g>>2]=c[g>>2]|4;while(0);i=n;return}function $o(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0;h=i;i=i+16|0;a=h+4|0;j=h;c[j>>2]=c[e>>2];c[a>>2]=c[j>>2];a=Ro(d,a,f,g,2)|0;d=c[f>>2]|0;if((a|0)<61&(d&4|0)==0)c[b>>2]=a;else c[f>>2]=d|4;i=h;return}function ap(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0;h=i;i=i+16|0;a=h+4|0;j=h;c[j>>2]=c[e>>2];c[a>>2]=c[j>>2];a=Ro(d,a,f,g,1)|0;d=c[f>>2]|0;if((a|0)<7&(d&4|0)==0)c[b>>2]=a;else c[f>>2]=d|4;i=h;return}function bp(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0;h=i;i=i+16|0;a=h+4|0;j=h;c[j>>2]=c[e>>2];c[a>>2]=c[j>>2];a=Ro(d,a,f,g,4)|0;if(!(c[f>>2]&4))c[b>>2]=a+-1900;i=h;return}function cp(a,b,e,f,g){a=a|0;b=b|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0;a=c[b>>2]|0;do if(a){if((c[a+12>>2]|0)==(c[a+16>>2]|0))if((Fb[c[(c[a>>2]|0)+36>>2]&127](a)|0)==-1){c[b>>2]=0;a=0;break}else{a=c[b>>2]|0;break}}else a=0;while(0);h=(a|0)==0;a=c[e>>2]|0;do if(a){if((c[a+12>>2]|0)==(c[a+16>>2]|0)?(Fb[c[(c[a>>2]|0)+36>>2]&127](a)|0)==-1:0){c[e>>2]=0;j=11;break}if(h){i=a;j=13}else j=12}else j=11;while(0);if((j|0)==11)if(h)j=12;else{i=0;j=13}a:do if((j|0)==12)c[f>>2]=c[f>>2]|6;else if((j|0)==13){a=c[b>>2]|0;h=c[a+12>>2]|0;if((h|0)==(c[a+16>>2]|0))a=Fb[c[(c[a>>2]|0)+36>>2]&127](a)|0;else a=d[h>>0]|0;if((yb[c[(c[g>>2]|0)+36>>2]&31](g,a&255,0)|0)<<24>>24!=37){c[f>>2]=c[f>>2]|4;break}a=c[b>>2]|0;h=a+12|0;g=c[h>>2]|0;if((g|0)==(c[a+16>>2]|0)){Fb[c[(c[a>>2]|0)+40>>2]&127](a)|0;a=c[b>>2]|0;if(!a)a=0;else j=21}else{c[h>>2]=g+1;j=21}do if((j|0)==21)if((c[a+12>>2]|0)==(c[a+16>>2]|0))if((Fb[c[(c[a>>2]|0)+36>>2]&127](a)|0)==-1){c[b>>2]=0;a=0;break}else{a=c[b>>2]|0;break}while(0);a=(a|0)==0;do if(i){if((c[i+12>>2]|0)==(c[i+16>>2]|0)?(Fb[c[(c[i>>2]|0)+36>>2]&127](i)|0)==-1:0){c[e>>2]=0;j=30;break}if(a)break a}else j=30;while(0);if((j|0)==30?!a:0)break;c[f>>2]=c[f>>2]|2}while(0);return}function dp(b){b=b|0;var d=0;if((a[989376]|0)==0?Ca(989376)|0:0){if((a[989384]|0)==0?Ca(989384)|0:0){b=1150172;do{d=0;while(1){if((d|0)==3)break;c[b+(d<<2)>>2]=0;d=d+1|0}b=b+12|0}while((b|0)!=1150340);Ja(989384)}Ak(1150172,21821)|0;Ak(1150184,21828)|0;Ak(1150196,21835)|0;Ak(1150208,21843)|0;Ak(1150220,21853)|0;Ak(1150232,21862)|0;Ak(1150244,21869)|0;Ak(1150256,21878)|0;Ak(1150268,21882)|0;Ak(1150280,21886)|0;Ak(1150292,21890)|0;Ak(1150304,21894)|0;Ak(1150316,21898)|0;Ak(1150328,21902)|0;c[287585]=1150172;Ja(989376)}return c[287585]|0}function ep(b){b=b|0;var d=0;if((a[989392]|0)==0?Ca(989392)|0:0){if((a[989400]|0)==0?Ca(989400)|0:0){b=1150344;do{d=0;while(1){if((d|0)==3)break;c[b+(d<<2)>>2]=0;d=d+1|0}b=b+12|0}while((b|0)!=1150632);Ja(989400)}Ak(1150344,21906)|0;Ak(1150356,21914)|0;Ak(1150368,21923)|0;Ak(1150380,21929)|0;Ak(1150392,21935)|0;Ak(1150404,21939)|0;Ak(1150416,21944)|0;Ak(1150428,21949)|0;Ak(1150440,21956)|0;Ak(1150452,21966)|0;Ak(1150464,21974)|0;Ak(1150476,21983)|0;Ak(1150488,21992)|0;Ak(1150500,21996)|0;Ak(1150512,22e3)|0;Ak(1150524,22004)|0;Ak(1150536,21935)|0;Ak(1150548,22008)|0;Ak(1150560,22012)|0;Ak(1150572,22016)|0;Ak(1150584,22020)|0;Ak(1150596,22024)|0;Ak(1150608,22028)|0;Ak(1150620,22032)|0;c[287658]=1150344;Ja(989392)}return c[287658]|0}function fp(b){b=b|0;var d=0;if((a[989408]|0)==0?Ca(989408)|0:0){if((a[989416]|0)==0?Ca(989416)|0:0){b=1150636;do{d=0;while(1){if((d|0)==3)break;c[b+(d<<2)>>2]=0;d=d+1|0}b=b+12|0}while((b|0)!=1150924);Ja(989416)}Ak(1150636,22036)|0;Ak(1150648,22039)|0;c[287731]=1150636;Ja(989408)}return c[287731]|0}function gp(b){b=b|0;if((a[989424]|0)==0?Ca(989424)|0:0){rk(1150928,22042,20);Ja(989424)}return 1150928}function hp(b){b=b|0;if((a[989432]|0)==0?Ca(989432)|0:0){rk(1150940,22063,11);Ja(989432)}return 1150940}function ip(b){b=b|0;if((a[989440]|0)==0?Ca(989440)|0:0){rk(1150952,22075,8);Ja(989440)}return 1150952}function jp(b){b=b|0;if((a[989448]|0)==0?Ca(989448)|0:0){rk(1150964,22084,8);Ja(989448)}return 1150964}function kp(a){a=a|0;return}function lp(a){a=a|0;mu(a);return}function mp(a){a=a|0;return 2}function np(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;h=i;i=i+16|0;j=h+12|0;k=h+8|0;m=h+4|0;l=h;c[m>>2]=c[b>>2];c[l>>2]=c[d>>2];c[k>>2]=c[m>>2];c[j>>2]=c[l>>2];a=op(a,k,j,e,f,g,12796,12828)|0;i=h;return a|0}function op(a,b,d,e,f,g,h,j){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;x=i;i=i+32|0;s=x+16|0;r=x+12|0;v=x+8|0;t=x+4|0;u=x;k=gm(e)|0;c[v>>2]=k;v=Om(v,1150132)|0;du(k)|0;c[f>>2]=0;k=h;h=0;a:while(1){q=(k|0)!=(j|0);l=h;while(1){h=c[b>>2]|0;if(!(q&(l|0)==0))break a;m=h;if(h){l=c[h+12>>2]|0;if((l|0)==(c[h+16>>2]|0))l=Fb[c[(c[h>>2]|0)+36>>2]&127](h)|0;else l=c[l>>2]|0;if((l|0)==-1){c[b>>2]=0;h=0;m=0;p=1}else p=0}else{h=0;p=1}o=c[d>>2]|0;l=o;do if(o){n=c[o+12>>2]|0;if((n|0)==(c[o+16>>2]|0))n=Fb[c[(c[o>>2]|0)+36>>2]&127](o)|0;else n=c[n>>2]|0;if((n|0)!=-1)if(p){n=o;break}else{w=18;break a}else{c[d>>2]=0;l=0;w=16;break}}else w=16;while(0);if((w|0)==16){w=0;if(p){w=18;break a}else n=0}if((yb[c[(c[v>>2]|0)+52>>2]&31](v,c[k>>2]|0,0)|0)<<24>>24==37){p=l;w=20;break}if(yb[c[(c[v>>2]|0)+12>>2]&31](v,8192,c[k>>2]|0)|0){m=n;w=28;break}n=h+12|0;m=c[n>>2]|0;l=h+16|0;if((m|0)==(c[l>>2]|0))m=Fb[c[(c[h>>2]|0)+36>>2]&127](h)|0;else m=c[m>>2]|0;p=Lb[c[(c[v>>2]|0)+28>>2]&63](v,m)|0;if((p|0)==(Lb[c[(c[v>>2]|0)+28>>2]&63](v,c[k>>2]|0)|0)){w=57;break}c[f>>2]=4;l=4}b:do if((w|0)==20){w=0;l=k+4|0;if((l|0)==(j|0)){w=21;break a}o=yb[c[(c[v>>2]|0)+52>>2]&31](v,c[l>>2]|0,0)|0;switch(o<<24>>24){case 48:case 69:{n=k+8|0;if((n|0)==(j|0)){w=26;break a}k=l;l=yb[c[(c[v>>2]|0)+52>>2]&31](v,c[n>>2]|0,0)|0;h=o;break}default:{l=o;h=0}}q=c[(c[a>>2]|0)+36>>2]|0;c[t>>2]=m;c[u>>2]=p;c[r>>2]=c[t>>2];c[s>>2]=c[u>>2];c[b>>2]=Ib[q&15](a,r,s,e,f,g,l,h)|0;h=k+8|0}else if((w|0)==28){w=0;do{k=k+4|0;if((k|0)==(j|0)){k=j;break}}while(yb[c[(c[v>>2]|0)+12>>2]&31](v,8192,c[k>>2]|0)|0);l=m;o=m;while(1){if(h){m=c[h+12>>2]|0;if((m|0)==(c[h+16>>2]|0))m=Fb[c[(c[h>>2]|0)+36>>2]&127](h)|0;else m=c[m>>2]|0;if((m|0)==-1){c[b>>2]=0;h=0;n=1}else n=0}else{h=0;n=1}do if(o){m=c[o+12>>2]|0;if((m|0)==(c[o+16>>2]|0))m=Fb[c[(c[o>>2]|0)+36>>2]&127](o)|0;else m=c[m>>2]|0;if((m|0)!=-1)if(n^(l|0)==0){p=l;o=l;break}else{h=k;break b}else{c[d>>2]=0;l=0;w=44;break}}else w=44;while(0);if((w|0)==44){w=0;if(n){h=k;break b}else{p=l;o=0}}n=h+12|0;l=c[n>>2]|0;m=h+16|0;if((l|0)==(c[m>>2]|0))l=Fb[c[(c[h>>2]|0)+36>>2]&127](h)|0;else l=c[l>>2]|0;if(!(yb[c[(c[v>>2]|0)+12>>2]&31](v,8192,l)|0)){h=k;break b}l=c[n>>2]|0;if((l|0)==(c[m>>2]|0)){Fb[c[(c[h>>2]|0)+40>>2]&127](h)|0;l=p;continue}else{c[n>>2]=l+4;l=p;continue}}}else if((w|0)==57){w=0;m=c[n>>2]|0;if((m|0)==(c[l>>2]|0))Fb[c[(c[h>>2]|0)+40>>2]&127](h)|0;else c[n>>2]=m+4;h=k+4|0}while(0);k=h;h=c[f>>2]|0}if((w|0)==18)c[f>>2]=4;else if((w|0)==21)c[f>>2]=4;else if((w|0)==26)c[f>>2]=4;if(h){k=c[h+12>>2]|0;if((k|0)==(c[h+16>>2]|0))k=Fb[c[(c[h>>2]|0)+36>>2]&127](h)|0;else k=c[k>>2]|0;if((k|0)==-1){c[b>>2]=0;h=0;m=1}else m=0}else{h=0;m=1}k=c[d>>2]|0;do if(k){l=c[k+12>>2]|0;if((l|0)==(c[k+16>>2]|0))k=Fb[c[(c[k>>2]|0)+36>>2]&127](k)|0;else k=c[l>>2]|0;if((k|0)!=-1)if(m)break;else{w=77;break}else{c[d>>2]=0;w=75;break}}else w=75;while(0);if((w|0)==75?m:0)w=77;if((w|0)==77)c[f>>2]=c[f>>2]|2;i=x;return h|0}function pp(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;j=i;i=i+16|0;k=j+12|0;l=j+8|0;n=j+4|0;m=j;q=b+8|0;q=Fb[c[(c[q>>2]|0)+20>>2]&127](q)|0;c[n>>2]=c[d>>2];c[m>>2]=c[e>>2];o=a[q>>0]|0;p=(o&1)==0;e=q+4|0;d=p?e:c[q+8>>2]|0;e=d+((p?(o&255)>>>1:c[e>>2]|0)<<2)|0;c[l>>2]=c[n>>2];c[k>>2]=c[m>>2];b=op(b,l,k,f,g,h,d,e)|0;i=j;return b|0}
function qp(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;h=i;i=i+16|0;j=h+8|0;m=h+4|0;k=h;l=gm(e)|0;c[m>>2]=l;e=Om(m,1150132)|0;du(l)|0;c[k>>2]=c[d>>2];c[j>>2]=c[k>>2];rp(a,g+24|0,b,j,f,e);i=h;return c[b>>2]|0}function rp(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0;h=i;i=i+16|0;j=h+4|0;k=h;a=a+8|0;a=Fb[c[c[a>>2]>>2]&127](a)|0;c[k>>2]=c[e>>2];c[j>>2]=c[k>>2];d=(En(d,j,a,a+168|0,g,f,0)|0)-a|0;if((d|0)<168)c[b>>2]=((d|0)/12|0|0)%7|0;i=h;return}function sp(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;h=i;i=i+16|0;j=h+8|0;m=h+4|0;k=h;l=gm(e)|0;c[m>>2]=l;e=Om(m,1150132)|0;du(l)|0;c[k>>2]=c[d>>2];c[j>>2]=c[k>>2];tp(a,g+16|0,b,j,f,e);i=h;return c[b>>2]|0}function tp(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0;h=i;i=i+16|0;j=h+4|0;k=h;a=a+8|0;a=Fb[c[(c[a>>2]|0)+4>>2]&127](a)|0;c[k>>2]=c[e>>2];c[j>>2]=c[k>>2];d=(En(d,j,a,a+288|0,g,f,0)|0)-a|0;if((d|0)<288)c[b>>2]=((d|0)/12|0|0)%12|0;i=h;return}function up(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;h=i;i=i+16|0;j=h+8|0;m=h+4|0;k=h;l=gm(e)|0;c[m>>2]=l;e=Om(m,1150132)|0;du(l)|0;c[k>>2]=c[d>>2];c[j>>2]=c[k>>2];vp(a,g+20|0,b,j,f,e);i=h;return c[b>>2]|0}function vp(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0;h=i;i=i+16|0;a=h+4|0;j=h;c[j>>2]=c[e>>2];c[a>>2]=c[j>>2];a=wp(d,a,f,g,4)|0;if(!(c[f>>2]&4)){if((a|0)<69)a=a+2e3|0;else a=(a+-69|0)>>>0<31?a+1900|0:a;c[b>>2]=a+-1900}i=h;return}function wp(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;g=c[a>>2]|0;do if(g){h=c[g+12>>2]|0;if((h|0)==(c[g+16>>2]|0))g=Fb[c[(c[g>>2]|0)+36>>2]&127](g)|0;else g=c[h>>2]|0;if((g|0)==-1){c[a>>2]=0;i=1;break}else{i=(c[a>>2]|0)==0;break}}else i=1;while(0);h=c[b>>2]|0;do if(h){g=c[h+12>>2]|0;if((g|0)==(c[h+16>>2]|0))g=Fb[c[(c[h>>2]|0)+36>>2]&127](h)|0;else g=c[g>>2]|0;if((g|0)!=-1)if(i){o=17;break}else{o=16;break}else{c[b>>2]=0;o=14;break}}else o=14;while(0);if((o|0)==14)if(i)o=16;else{h=0;o=17}a:do if((o|0)==16){c[d>>2]=c[d>>2]|6;g=0}else if((o|0)==17){g=c[a>>2]|0;i=c[g+12>>2]|0;if((i|0)==(c[g+16>>2]|0))g=Fb[c[(c[g>>2]|0)+36>>2]&127](g)|0;else g=c[i>>2]|0;if(!(yb[c[(c[e>>2]|0)+12>>2]&31](e,2048,g)|0)){c[d>>2]=c[d>>2]|4;g=0;break}g=(yb[c[(c[e>>2]|0)+52>>2]&31](e,g,0)|0)<<24>>24;i=c[a>>2]|0;j=i+12|0;k=c[j>>2]|0;if((k|0)==(c[i+16>>2]|0)){Fb[c[(c[i>>2]|0)+40>>2]&127](i)|0;m=f;l=h;j=h}else{c[j>>2]=k+4;m=f;l=h;j=h}while(1){g=g+-48|0;n=m+-1|0;h=c[a>>2]|0;do if(h){i=c[h+12>>2]|0;if((i|0)==(c[h+16>>2]|0))h=Fb[c[(c[h>>2]|0)+36>>2]&127](h)|0;else h=c[i>>2]|0;if((h|0)==-1){c[a>>2]=0;k=1;break}else{k=(c[a>>2]|0)==0;break}}else k=1;while(0);do if(j){h=c[j+12>>2]|0;if((h|0)==(c[j+16>>2]|0))h=Fb[c[(c[j>>2]|0)+36>>2]&127](j)|0;else h=c[h>>2]|0;if((h|0)==-1){c[b>>2]=0;j=0;f=0;h=1;break}else{j=l;f=l;h=(l|0)==0;break}}else{j=l;f=0;h=1}while(0);i=c[a>>2]|0;if(!((m|0)>1&(k^h)))break;h=c[i+12>>2]|0;if((h|0)==(c[i+16>>2]|0))h=Fb[c[(c[i>>2]|0)+36>>2]&127](i)|0;else h=c[h>>2]|0;if(!(yb[c[(c[e>>2]|0)+12>>2]&31](e,2048,h)|0))break a;g=((yb[c[(c[e>>2]|0)+52>>2]&31](e,h,0)|0)<<24>>24)+(g*10|0)|0;h=c[a>>2]|0;i=h+12|0;k=c[i>>2]|0;if((k|0)==(c[h+16>>2]|0)){Fb[c[(c[h>>2]|0)+40>>2]&127](h)|0;m=n;l=j;j=f;continue}else{c[i>>2]=k+4;m=n;l=j;j=f;continue}}do if(i){h=c[i+12>>2]|0;if((h|0)==(c[i+16>>2]|0))h=Fb[c[(c[i>>2]|0)+36>>2]&127](i)|0;else h=c[h>>2]|0;if((h|0)==-1){c[a>>2]=0;i=1;break}else{i=(c[a>>2]|0)==0;break}}else i=1;while(0);do if(j){h=c[j+12>>2]|0;if((h|0)==(c[j+16>>2]|0))h=Fb[c[(c[j>>2]|0)+36>>2]&127](j)|0;else h=c[h>>2]|0;if((h|0)!=-1)if(i)break a;else break;else{c[b>>2]=0;o=60;break}}else o=60;while(0);if((o|0)==60?!i:0)break;c[d>>2]=c[d>>2]|2}while(0);return g|0}function xp(b,d,e,f,g,h,j,k){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0;S=i;i=i+144|0;l=S+132|0;k=S+116|0;L=S+128|0;w=S+124|0;H=S+120|0;M=S+112|0;N=S+108|0;O=S+104|0;P=S+100|0;Q=S+96|0;R=S+92|0;m=S+88|0;n=S+84|0;o=S+80|0;p=S+76|0;q=S+72|0;r=S+68|0;s=S+64|0;t=S+60|0;u=S+56|0;v=S+52|0;x=S+48|0;y=S+44|0;z=S+40|0;A=S+36|0;B=S+32|0;C=S+28|0;D=S+24|0;E=S+20|0;F=S+16|0;G=S+12|0;I=S+8|0;J=S+4|0;K=S;c[g>>2]=0;U=gm(f)|0;c[L>>2]=U;L=Om(L,1150132)|0;du(U)|0;do switch(j<<24>>24|0){case 65:case 97:{c[w>>2]=c[e>>2];c[l>>2]=c[w>>2];rp(b,h+24|0,d,l,g,L);T=26;break}case 104:case 66:case 98:{c[H>>2]=c[e>>2];c[l>>2]=c[H>>2];tp(b,h+16|0,d,l,g,L);T=26;break}case 99:{U=b+8|0;U=Fb[c[(c[U>>2]|0)+12>>2]&127](U)|0;c[M>>2]=c[d>>2];c[N>>2]=c[e>>2];j=a[U>>0]|0;e=(j&1)==0;T=U+4|0;U=e?T:c[U+8>>2]|0;T=U+((e?(j&255)>>>1:c[T>>2]|0)<<2)|0;c[k>>2]=c[M>>2];c[l>>2]=c[N>>2];c[d>>2]=op(b,k,l,f,g,h,U,T)|0;T=26;break}case 101:case 100:{c[O>>2]=c[e>>2];c[l>>2]=c[O>>2];yp(b,h+12|0,d,l,g,L);T=26;break}case 68:{c[P>>2]=c[d>>2];c[Q>>2]=c[e>>2];c[k>>2]=c[P>>2];c[l>>2]=c[Q>>2];c[d>>2]=op(b,k,l,f,g,h,12828,12860)|0;T=26;break}case 70:{c[R>>2]=c[d>>2];c[m>>2]=c[e>>2];c[k>>2]=c[R>>2];c[l>>2]=c[m>>2];c[d>>2]=op(b,k,l,f,g,h,12860,12892)|0;T=26;break}case 72:{c[n>>2]=c[e>>2];c[l>>2]=c[n>>2];zp(b,h+8|0,d,l,g,L);T=26;break}case 73:{c[o>>2]=c[e>>2];c[l>>2]=c[o>>2];Ap(b,h+8|0,d,l,g,L);T=26;break}case 106:{c[p>>2]=c[e>>2];c[l>>2]=c[p>>2];Bp(b,h+28|0,d,l,g,L);T=26;break}case 109:{c[q>>2]=c[e>>2];c[l>>2]=c[q>>2];Cp(b,h+16|0,d,l,g,L);T=26;break}case 77:{c[r>>2]=c[e>>2];c[l>>2]=c[r>>2];Dp(b,h+4|0,d,l,g,L);T=26;break}case 116:case 110:{c[s>>2]=c[e>>2];c[l>>2]=c[s>>2];Ep(b,d,l,g,L);T=26;break}case 112:{c[t>>2]=c[e>>2];c[l>>2]=c[t>>2];Fp(b,h+8|0,d,l,g,L);T=26;break}case 114:{c[u>>2]=c[d>>2];c[v>>2]=c[e>>2];c[k>>2]=c[u>>2];c[l>>2]=c[v>>2];c[d>>2]=op(b,k,l,f,g,h,12892,12936)|0;T=26;break}case 82:{c[x>>2]=c[d>>2];c[y>>2]=c[e>>2];c[k>>2]=c[x>>2];c[l>>2]=c[y>>2];c[d>>2]=op(b,k,l,f,g,h,12936,12956)|0;T=26;break}case 83:{c[z>>2]=c[e>>2];c[l>>2]=c[z>>2];Gp(b,h,d,l,g,L);T=26;break}case 84:{c[A>>2]=c[d>>2];c[B>>2]=c[e>>2];c[k>>2]=c[A>>2];c[l>>2]=c[B>>2];c[d>>2]=op(b,k,l,f,g,h,12956,12988)|0;T=26;break}case 119:{c[C>>2]=c[e>>2];c[l>>2]=c[C>>2];Hp(b,h+24|0,d,l,g,L);T=26;break}case 120:{U=c[(c[b>>2]|0)+20>>2]|0;c[D>>2]=c[d>>2];c[E>>2]=c[e>>2];c[k>>2]=c[D>>2];c[l>>2]=c[E>>2];k=Db[U&63](b,k,l,f,g,h)|0;break}case 88:{U=b+8|0;U=Fb[c[(c[U>>2]|0)+24>>2]&127](U)|0;c[F>>2]=c[d>>2];c[G>>2]=c[e>>2];j=a[U>>0]|0;e=(j&1)==0;T=U+4|0;U=e?T:c[U+8>>2]|0;T=U+((e?(j&255)>>>1:c[T>>2]|0)<<2)|0;c[k>>2]=c[F>>2];c[l>>2]=c[G>>2];c[d>>2]=op(b,k,l,f,g,h,U,T)|0;T=26;break}case 121:{c[I>>2]=c[e>>2];c[l>>2]=c[I>>2];vp(b,h+20|0,d,l,g,L);T=26;break}case 89:{c[J>>2]=c[e>>2];c[l>>2]=c[J>>2];Ip(b,h+20|0,d,l,g,L);T=26;break}case 37:{c[K>>2]=c[e>>2];c[l>>2]=c[K>>2];Jp(b,d,l,g,L);T=26;break}default:{c[g>>2]=c[g>>2]|4;T=26}}while(0);if((T|0)==26)k=c[d>>2]|0;i=S;return k|0}function yp(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0;h=i;i=i+16|0;a=h+4|0;j=h;c[j>>2]=c[e>>2];c[a>>2]=c[j>>2];a=wp(d,a,f,g,2)|0;d=c[f>>2]|0;if((a+-1|0)>>>0<31&(d&4|0)==0)c[b>>2]=a;else c[f>>2]=d|4;i=h;return}function zp(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0;h=i;i=i+16|0;a=h+4|0;j=h;c[j>>2]=c[e>>2];c[a>>2]=c[j>>2];a=wp(d,a,f,g,2)|0;d=c[f>>2]|0;if((a|0)<24&(d&4|0)==0)c[b>>2]=a;else c[f>>2]=d|4;i=h;return}function Ap(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0;h=i;i=i+16|0;a=h+4|0;j=h;c[j>>2]=c[e>>2];c[a>>2]=c[j>>2];a=wp(d,a,f,g,2)|0;d=c[f>>2]|0;if((a+-1|0)>>>0<12&(d&4|0)==0)c[b>>2]=a;else c[f>>2]=d|4;i=h;return}function Bp(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0;h=i;i=i+16|0;a=h+4|0;j=h;c[j>>2]=c[e>>2];c[a>>2]=c[j>>2];a=wp(d,a,f,g,3)|0;d=c[f>>2]|0;if((a|0)<366&(d&4|0)==0)c[b>>2]=a;else c[f>>2]=d|4;i=h;return}function Cp(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0;h=i;i=i+16|0;a=h+4|0;j=h;c[j>>2]=c[e>>2];c[a>>2]=c[j>>2];a=wp(d,a,f,g,2)|0;d=c[f>>2]|0;if((a|0)<13&(d&4|0)==0)c[b>>2]=a+-1;else c[f>>2]=d|4;i=h;return}function Dp(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0;h=i;i=i+16|0;a=h+4|0;j=h;c[j>>2]=c[e>>2];c[a>>2]=c[j>>2];a=wp(d,a,f,g,2)|0;d=c[f>>2]|0;if((a|0)<60&(d&4|0)==0)c[b>>2]=a;else c[f>>2]=d|4;i=h;return}function Ep(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0;a:while(1){a=c[b>>2]|0;do if(a){g=c[a+12>>2]|0;if((g|0)==(c[a+16>>2]|0))a=Fb[c[(c[a>>2]|0)+36>>2]&127](a)|0;else a=c[g>>2]|0;if((a|0)==-1){c[b>>2]=0;h=1;break}else{h=(c[b>>2]|0)==0;break}}else h=1;while(0);g=c[d>>2]|0;do if(g){a=c[g+12>>2]|0;if((a|0)==(c[g+16>>2]|0))a=Fb[c[(c[g>>2]|0)+36>>2]&127](g)|0;else a=c[a>>2]|0;if((a|0)!=-1)if(h){h=g;break}else{h=g;break a}else{c[d>>2]=0;i=15;break}}else i=15;while(0);if((i|0)==15){i=0;if(h){h=0;break}else h=0}a=c[b>>2]|0;g=c[a+12>>2]|0;if((g|0)==(c[a+16>>2]|0))a=Fb[c[(c[a>>2]|0)+36>>2]&127](a)|0;else a=c[g>>2]|0;if(!(yb[c[(c[f>>2]|0)+12>>2]&31](f,8192,a)|0))break;a=c[b>>2]|0;g=a+12|0;h=c[g>>2]|0;if((h|0)==(c[a+16>>2]|0)){Fb[c[(c[a>>2]|0)+40>>2]&127](a)|0;continue}else{c[g>>2]=h+4;continue}}a=c[b>>2]|0;do if(a){g=c[a+12>>2]|0;if((g|0)==(c[a+16>>2]|0))a=Fb[c[(c[a>>2]|0)+36>>2]&127](a)|0;else a=c[g>>2]|0;if((a|0)==-1){c[b>>2]=0;g=1;break}else{g=(c[b>>2]|0)==0;break}}else g=1;while(0);do if(h){a=c[h+12>>2]|0;if((a|0)==(c[h+16>>2]|0))a=Fb[c[(c[h>>2]|0)+36>>2]&127](h)|0;else a=c[a>>2]|0;if((a|0)!=-1)if(g)break;else{i=39;break}else{c[d>>2]=0;i=37;break}}else i=37;while(0);if((i|0)==37?g:0)i=39;if((i|0)==39)c[e>>2]=c[e>>2]|2;return}function Fp(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0;n=i;i=i+16|0;k=n+4|0;l=n;m=b+8|0;m=Fb[c[(c[m>>2]|0)+8>>2]&127](m)|0;b=a[m>>0]|0;if(!(b&1))j=(b&255)>>>1;else j=c[m+4>>2]|0;b=a[m+12>>0]|0;if(!(b&1))b=(b&255)>>>1;else b=c[m+16>>2]|0;do if((j|0)!=(0-b|0)){c[l>>2]=c[f>>2];c[k>>2]=c[l>>2];b=En(e,k,m,m+24|0,h,g,0)|0;j=c[d>>2]|0;if((b|0)==(m|0)&(j|0)==12){c[d>>2]=0;break}if((j|0)<12&(b-m|0)==12)c[d>>2]=j+12}else c[g>>2]=c[g>>2]|4;while(0);i=n;return}function Gp(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0;h=i;i=i+16|0;a=h+4|0;j=h;c[j>>2]=c[e>>2];c[a>>2]=c[j>>2];a=wp(d,a,f,g,2)|0;d=c[f>>2]|0;if((a|0)<61&(d&4|0)==0)c[b>>2]=a;else c[f>>2]=d|4;i=h;return}function Hp(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0;h=i;i=i+16|0;a=h+4|0;j=h;c[j>>2]=c[e>>2];c[a>>2]=c[j>>2];a=wp(d,a,f,g,1)|0;d=c[f>>2]|0;if((a|0)<7&(d&4|0)==0)c[b>>2]=a;else c[f>>2]=d|4;i=h;return}function Ip(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0;h=i;i=i+16|0;a=h+4|0;j=h;c[j>>2]=c[e>>2];c[a>>2]=c[j>>2];a=wp(d,a,f,g,4)|0;if(!(c[f>>2]&4))c[b>>2]=a+-1900;i=h;return}function Jp(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0;a=c[b>>2]|0;do if(a){g=c[a+12>>2]|0;if((g|0)==(c[a+16>>2]|0))a=Fb[c[(c[a>>2]|0)+36>>2]&127](a)|0;else a=c[g>>2]|0;if((a|0)==-1){c[b>>2]=0;h=1;break}else{h=(c[b>>2]|0)==0;break}}else h=1;while(0);g=c[d>>2]|0;do if(g){a=c[g+12>>2]|0;if((a|0)==(c[g+16>>2]|0))a=Fb[c[(c[g>>2]|0)+36>>2]&127](g)|0;else a=c[a>>2]|0;if((a|0)!=-1)if(h){i=g;j=17;break}else{j=16;break}else{c[d>>2]=0;j=14;break}}else j=14;while(0);if((j|0)==14)if(h)j=16;else{i=0;j=17}a:do if((j|0)==16)c[e>>2]=c[e>>2]|6;else if((j|0)==17){a=c[b>>2]|0;g=c[a+12>>2]|0;if((g|0)==(c[a+16>>2]|0))a=Fb[c[(c[a>>2]|0)+36>>2]&127](a)|0;else a=c[g>>2]|0;if((yb[c[(c[f>>2]|0)+52>>2]&31](f,a,0)|0)<<24>>24!=37){c[e>>2]=c[e>>2]|4;break}a=c[b>>2]|0;g=a+12|0;h=c[g>>2]|0;if((h|0)==(c[a+16>>2]|0)){Fb[c[(c[a>>2]|0)+40>>2]&127](a)|0;a=c[b>>2]|0;if(!a)g=1;else j=25}else{c[g>>2]=h+4;j=25}do if((j|0)==25){g=c[a+12>>2]|0;if((g|0)==(c[a+16>>2]|0))a=Fb[c[(c[a>>2]|0)+36>>2]&127](a)|0;else a=c[g>>2]|0;if((a|0)==-1){c[b>>2]=0;g=1;break}else{g=(c[b>>2]|0)==0;break}}while(0);do if(i){a=c[i+12>>2]|0;if((a|0)==(c[i+16>>2]|0))a=Fb[c[(c[i>>2]|0)+36>>2]&127](i)|0;else a=c[a>>2]|0;if((a|0)!=-1)if(g)break a;else break;else{c[d>>2]=0;j=37;break}}else j=37;while(0);if((j|0)==37?!g:0)break;c[e>>2]=c[e>>2]|2}while(0);return}function Kp(b){b=b|0;var d=0;if((a[989456]|0)==0?Ca(989456)|0:0){if((a[989464]|0)==0?Ca(989464)|0:0){b=1150984;do{d=0;while(1){if((d|0)==3)break;c[b+(d<<2)>>2]=0;d=d+1|0}b=b+12|0}while((b|0)!=1151152);Ja(989464)}Uk(1150984,12988)|0;Uk(1150996,13016)|0;Uk(1151008,13044)|0;Uk(1151020,13076)|0;Uk(1151032,13116)|0;Uk(1151044,13152)|0;Uk(1151056,13180)|0;Uk(1151068,13216)|0;Uk(1151080,13232)|0;Uk(1151092,13248)|0;Uk(1151104,13264)|0;Uk(1151116,13280)|0;Uk(1151128,13296)|0;Uk(1151140,13312)|0;c[287788]=1150984;Ja(989456)}return c[287788]|0}function Lp(b){b=b|0;var d=0;if((a[989472]|0)==0?Ca(989472)|0:0){if((a[989480]|0)==0?Ca(989480)|0:0){b=1151156;do{d=0;while(1){if((d|0)==3)break;c[b+(d<<2)>>2]=0;d=d+1|0}b=b+12|0}while((b|0)!=1151444);Ja(989480)}Uk(1151156,13328)|0;Uk(1151168,13360)|0;Uk(1151180,13396)|0;Uk(1151192,13420)|0;Uk(1151204,13444)|0;Uk(1151216,13460)|0;Uk(1151228,13480)|0;Uk(1151240,13500)|0;Uk(1151252,13528)|0;Uk(1151264,13568)|0;Uk(1151276,13600)|0;Uk(1151288,13636)|0;Uk(1151300,13672)|0;Uk(1151312,13688)|0;Uk(1151324,13704)|0;Uk(1151336,13720)|0;Uk(1151348,13444)|0;Uk(1151360,13736)|0;Uk(1151372,13752)|0;Uk(1151384,13768)|0;Uk(1151396,13784)|0;Uk(1151408,13800)|0;Uk(1151420,13816)|0;Uk(1151432,13832)|0;c[287861]=1151156;Ja(989472)}return c[287861]|0}function Mp(b){b=b|0;var d=0;if((a[989488]|0)==0?Ca(989488)|0:0){if((a[989496]|0)==0?Ca(989496)|0:0){b=1151448;do{d=0;while(1){if((d|0)==3)break;c[b+(d<<2)>>2]=0;d=d+1|0}b=b+12|0}while((b|0)!=1151736);Ja(989496)}Uk(1151448,13848)|0;Uk(1151460,13860)|0;c[287934]=1151448;Ja(989488)}return c[287934]|0}function Np(b){b=b|0;if((a[989504]|0)==0?Ca(989504)|0:0){Nk(1151740,13872,gi(13872)|0);Ja(989504)}return 1151740}function Op(b){b=b|0;if((a[989512]|0)==0?Ca(989512)|0:0){Nk(1151752,13956,gi(13956)|0);Ja(989512)}return 1151752}function Pp(b){b=b|0;if((a[989520]|0)==0?Ca(989520)|0:0){Nk(1151764,14004,gi(14004)|0);Ja(989520)}return 1151764}function Qp(b){b=b|0;if((a[989528]|0)==0?Ca(989528)|0:0){Nk(1151776,14040,gi(14040)|0);Ja(989528)}return 1151776}function Rp(a){a=a|0;Sp(a+8|0);return}function Sp(a){a=a|0;var b=0;b=c[a>>2]|0;if((b|0)!=(Ym()|0))kj(c[a>>2]|0);return}function Tp(a){a=a|0;Sp(a+8|0);mu(a);return}function Up(b,d,e,f,g,h,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0;k=i;i=i+112|0;e=k+4|0;f=k;c[f>>2]=e+100;Vp(b+8|0,e,f,g,h,j);b=c[f>>2]|0;g=e;e=c[d>>2]|0;while(1){if((g|0)==(b|0))break;h=a[g>>0]|0;do if(e){j=e+24|0;f=c[j>>2]|0;if((f|0)==(c[e+28>>2]|0)){d=(Lb[c[(c[e>>2]|0)+52>>2]&63](e,h&255)|0)==-1;e=d?0:e;break}else{c[j>>2]=f+1;a[f>>0]=h;break}}else e=0;while(0);g=g+1|0}i=k;return e|0}function Vp(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0;m=i;i=i+16|0;l=m;a[l>>0]=37;j=l+1|0;a[j>>0]=g;k=l+2|0;a[k>>0]=h;a[l+3>>0]=0;if(h<<24>>24){a[j>>0]=h;a[k>>0]=g}c[e>>2]=d+(La(d|0,(c[e>>2]|0)-d|0,l|0,f|0,c[b>>2]|0)|0);i=m;return}function Wp(a){a=a|0;Sp(a+8|0);return}function Xp(a){a=a|0;Sp(a+8|0);mu(a);return}function Yp(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0;j=i;i=i+416|0;d=j+8|0;e=j;c[e>>2]=d+400;Zp(a+8|0,d,e,f,g,h);a=c[e>>2]|0;f=d;d=c[b>>2]|0;while(1){if((f|0)==(a|0))break;e=c[f>>2]|0;if(!d)d=0;else{h=d+24|0;g=c[h>>2]|0;if((g|0)==(c[d+28>>2]|0))e=Lb[c[(c[d>>2]|0)+52>>2]&63](d,e)|0;else{c[h>>2]=g+4;c[g>>2]=e}d=(e|0)==-1?0:d}f=f+4|0}i=j;return d|0}function Zp(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;h=i;i=i+128|0;l=h+16|0;m=h+12|0;j=h;k=h+8|0;c[m>>2]=l+100;Vp(a,l,m,e,f,g);g=j;c[g>>2]=0;c[g+4>>2]=0;c[k>>2]=l;g=(c[d>>2]|0)-b>>2;f=hj(c[a>>2]|0)|0;g=Xi(b,k,g,j)|0;if(f|0)hj(f)|0;c[d>>2]=b+(g<<2);i=h;return}function _p(a){a=a|0;return}function $p(a){a=a|0;mu(a);return}function aq(a){a=a|0;return 127}function bq(a){a=a|0;return 127}function cq(a,b){a=a|0;b=b|0;b=0;while(1){if((b|0)==3)break;c[a+(b<<2)>>2]=0;b=b+1|0}return}function dq(a,b){a=a|0;b=b|0;b=0;while(1){if((b|0)==3)break;c[a+(b<<2)>>2]=0;b=b+1|0}return}function eq(a,b){a=a|0;b=b|0;b=0;while(1){if((b|0)==3)break;c[a+(b<<2)>>2]=0;b=b+1|0}return}function fq(a,b){a=a|0;b=b|0;sk(a,1,45);return}function gq(a){a=a|0;return 0}function hq(b,c){b=b|0;c=c|0;a[b>>0]=2;a[b+1>>0]=3;a[b+2>>0]=0;a[b+3>>0]=4;return}function iq(b,c){b=b|0;c=c|0;a[b>>0]=2;a[b+1>>0]=3;a[b+2>>0]=0;a[b+3>>0]=4;return}function jq(a){a=a|0;return}function kq(a){a=a|0;mu(a);return}function lq(a){a=a|0;return 127}function mq(a){a=a|0;return 127}function nq(a,b){a=a|0;b=b|0;b=0;while(1){if((b|0)==3)break;c[a+(b<<2)>>2]=0;b=b+1|0}return}function oq(a,b){a=a|0;b=b|0;b=0;while(1){if((b|0)==3)break;c[a+(b<<2)>>2]=0;b=b+1|0}return}function pq(a,b){a=a|0;b=b|0;b=0;while(1){if((b|0)==3)break;c[a+(b<<2)>>2]=0;b=b+1|0}return}function qq(a,b){a=a|0;b=b|0;sk(a,1,45);return}function rq(a){a=a|0;return 0}function sq(b,c){b=b|0;c=c|0;a[b>>0]=2;a[b+1>>0]=3;a[b+2>>0]=0;a[b+3>>0]=4;return}function tq(b,c){b=b|0;c=c|0;a[b>>0]=2;a[b+1>>0]=3;a[b+2>>0]=0;a[b+3>>0]=4;return}function uq(a){a=a|0;return}function vq(a){a=a|0;mu(a);return}function wq(a){a=a|0;return 2147483647}function xq(a){a=a|0;return 2147483647}function yq(a,b){a=a|0;b=b|0;b=0;while(1){if((b|0)==3)break;c[a+(b<<2)>>2]=0;b=b+1|0}return}function zq(a,b){a=a|0;b=b|0;b=0;while(1){if((b|0)==3)break;c[a+(b<<2)>>2]=0;b=b+1|0}return}function Aq(a,b){a=a|0;b=b|0;b=0;while(1){if((b|0)==3)break;c[a+(b<<2)>>2]=0;b=b+1|0}return}function Bq(a,b){a=a|0;b=b|0;Ok(a,1,45);return}function Cq(a){a=a|0;return 0}function Dq(b,c){b=b|0;c=c|0;a[b>>0]=2;a[b+1>>0]=3;a[b+2>>0]=0;a[b+3>>0]=4;return}function Eq(b,c){b=b|0;c=c|0;a[b>>0]=2;a[b+1>>0]=3;a[b+2>>0]=0;a[b+3>>0]=4;return}function Fq(a){a=a|0;return}function Gq(a){a=a|0;mu(a);return}function Hq(a){a=a|0;return 2147483647}function Iq(a){a=a|0;return 2147483647}function Jq(a,b){a=a|0;b=b|0;b=0;while(1){if((b|0)==3)break;c[a+(b<<2)>>2]=0;b=b+1|0}return}function Kq(a,b){a=a|0;b=b|0;b=0;while(1){if((b|0)==3)break;c[a+(b<<2)>>2]=0;b=b+1|0}return}function Lq(a,b){a=a|0;b=b|0;b=0;while(1){if((b|0)==3)break;c[a+(b<<2)>>2]=0;b=b+1|0}return}function Mq(a,b){a=a|0;b=b|0;Ok(a,1,45);return}function Nq(a){a=a|0;return 0}function Oq(b,c){b=b|0;c=c|0;a[b>>0]=2;a[b+1>>0]=3;a[b+2>>0]=0;a[b+3>>0]=4;return}function Pq(b,c){b=b|0;c=c|0;a[b>>0]=2;a[b+1>>0]=3;a[b+2>>0]=0;a[b+3>>0]=4;return}function Qq(a){a=a|0;return}function Rq(a){a=a|0;mu(a);return}function Sq(b,d,e,f,g,h,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;w=i;i=i+240|0;n=w+24|0;q=w;k=w+140|0;v=w+16|0;o=w+12|0;s=w+8|0;l=w+136|0;x=w+4|0;p=w+36|0;c[v>>2]=k;u=v+4|0;c[u>>2]=161;c[s>>2]=gm(g)|0;b=Om(s,1150100)|0;a[l>>0]=0;c[x>>2]=c[e>>2];g=c[g+4>>2]|0;c[n>>2]=c[x>>2];if(Uq(d,n,f,s,g,h,l,b,v,o,k+100|0)|0){Jb[c[(c[b>>2]|0)+32>>2]&7](b,22583,22593,n)|0;f=c[o>>2]|0;k=c[v>>2]|0;b=f-k|0;if((b|0)>98){b=zj(b+2|0)|0;if(!b)Tu();else{r=b;m=b}}else{r=0;m=p}if(!(a[l>>0]|0))b=m;else{a[m>>0]=45;b=m+1|0}l=n+10|0;m=n;while(1){if(k>>>0>=f>>>0)break;g=a[k>>0]|0;f=n;while(1){if((f|0)==(l|0)){f=l;break}if((a[f>>0]|0)==g<<24>>24)break;f=f+1|0}a[b>>0]=a[22583+(f-m)>>0]|0;f=c[o>>2]|0;b=b+1|0;k=k+1|0}a[b>>0]=0;c[q>>2]=j;Qi(p,22594,q)|0;if(r|0)Aj(r)}b=c[d>>2]|0;do if(b){if((c[b+12>>2]|0)==(c[b+16>>2]|0))if((Fb[c[(c[b>>2]|0)+36>>2]&127](b)|0)==-1){c[d>>2]=0;b=0;break}else{b=c[d>>2]|0;break}}else b=0;while(0);b=(b|0)==0;f=c[e>>2]|0;do if(f){if((c[f+12>>2]|0)==(c[f+16>>2]|0)?(Fb[c[(c[f>>2]|0)+36>>2]&127](f)|0)==-1:0){c[e>>2]=0;t=27;break}if(!b)t=28}else t=27;while(0);if((t|0)==27?b:0)t=28;if((t|0)==28)c[h>>2]=c[h>>2]|2;f=c[d>>2]|0;du(c[s>>2]|0)|0;b=c[v>>2]|0;c[v>>2]=0;if(b|0)Bb[c[u>>2]&255](b);i=w;return f|0}function Tq(a){a=a|0;return}function Uq(e,f,g,h,j,k,l,m,n,o,p){e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;n=n|0;o=o|0;p=p|0;var q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0;ba=i;i=i+512|0;N=ba+88|0;t=ba+96|0;aa=ba+80|0;R=ba+72|0;Q=ba+68|0;S=ba+500|0;O=ba+497|0;T=ba+496|0;X=ba+56|0;$=ba+44|0;Z=ba+32|0;Y=ba+20|0;_=ba+8|0;P=ba+4|0;V=ba;c[N>>2]=p;c[aa>>2]=t;W=aa+4|0;c[W>>2]=161;c[R>>2]=t;c[Q>>2]=t+400;p=0;while(1){if((p|0)==3)break;c[X+(p<<2)>>2]=0;p=p+1|0}p=0;while(1){if((p|0)==3)break;c[$+(p<<2)>>2]=0;p=p+1|0}p=0;while(1){if((p|0)==3)break;c[Z+(p<<2)>>2]=0;p=p+1|0}p=0;while(1){if((p|0)==3)break;c[Y+(p<<2)>>2]=0;p=p+1|0}p=0;while(1){if((p|0)==3)break;c[_+(p<<2)>>2]=0;p=p+1|0}Vq(g,h,S,O,T,X,$,Z,Y,P);c[o>>2]=c[n>>2];G=m+8|0;H=Z+4|0;I=Y+4|0;J=Y+8|0;K=Y+1|0;L=Z+8|0;M=Z+1|0;x=(j&512|0)!=0;y=$+8|0;z=$+1|0;A=$+4|0;B=_+4|0;C=_+8|0;D=_+1|0;E=S+3|0;F=X+4|0;w=0;s=0;a:while(1){if(w>>>0>=4){U=218;break}p=c[e>>2]|0;do if(p){if((c[p+12>>2]|0)==(c[p+16>>2]|0))if((Fb[c[(c[p>>2]|0)+36>>2]&127](p)|0)==-1){c[e>>2]=0;p=0;break}else{p=c[e>>2]|0;break}}else p=0;while(0);p=(p|0)==0;m=c[f>>2]|0;do if(m){if((c[m+12>>2]|0)!=(c[m+16>>2]|0))if(p)break;else{U=218;break a}if((Fb[c[(c[m>>2]|0)+36>>2]&127](m)|0)!=-1)if(p)break;else{U=218;break a}else{c[f>>2]=0;U=28;break}}else U=28;while(0);if((U|0)==28){U=0;if(p){U=218;break}else m=0}b:do switch(a[S+w>>0]|0){case 1:{if((w|0)!=3){p=c[e>>2]|0;g=c[p+12>>2]|0;if((g|0)==(c[p+16>>2]|0))p=Fb[c[(c[p>>2]|0)+36>>2]&127](p)|0;else p=d[g>>0]|0;if((p&255)<<24>>24<=-1){U=42;break a}if(!(b[(c[G>>2]|0)+(p<<24>>24<<1)>>1]&8192)){U=42;break a}p=c[e>>2]|0;g=p+12|0;h=c[g>>2]|0;if((h|0)==(c[p+16>>2]|0))p=Fb[c[(c[p>>2]|0)+40>>2]&127](p)|0;else{c[g>>2]=h+1;p=d[h>>0]|0}Gk(_,p&255);p=m;g=m;U=44}break}case 0:{if((w|0)!=3){p=m;g=m;U=44}break}case 3:{h=a[Z>>0]|0;p=(h&1)==0?(h&255)>>>1:c[H>>2]|0;g=a[Y>>0]|0;g=(g&1)==0?(g&255)>>>1:c[I>>2]|0;if((p|0)!=(0-g|0)){j=(p|0)==0;q=c[e>>2]|0;r=c[q+12>>2]|0;p=c[q+16>>2]|0;m=(r|0)==(p|0);if(j|(g|0)==0){if(m)p=Fb[c[(c[q>>2]|0)+36>>2]&127](q)|0;else p=d[r>>0]|0;p=p&255;if(j){if(p<<24>>24!=(a[((a[Y>>0]&1)==0?K:c[J>>2]|0)>>0]|0))break b;p=c[e>>2]|0;m=p+12|0;g=c[m>>2]|0;if((g|0)==(c[p+16>>2]|0))Fb[c[(c[p>>2]|0)+40>>2]&127](p)|0;else c[m>>2]=g+1;a[l>>0]=1;v=a[Y>>0]|0;s=((v&1)==0?(v&255)>>>1:c[I>>2]|0)>>>0>1?Y:s;break b}if(p<<24>>24!=(a[((a[Z>>0]&1)==0?M:c[L>>2]|0)>>0]|0)){a[l>>0]=1;break b}p=c[e>>2]|0;m=p+12|0;g=c[m>>2]|0;if((g|0)==(c[p+16>>2]|0))Fb[c[(c[p>>2]|0)+40>>2]&127](p)|0;else c[m>>2]=g+1;v=a[Z>>0]|0;s=((v&1)==0?(v&255)>>>1:c[H>>2]|0)>>>0>1?Z:s;break b}if(m){j=Fb[c[(c[q>>2]|0)+36>>2]&127](q)|0;p=c[e>>2]|0;h=a[Z>>0]|0;q=p;g=c[p+12>>2]|0;p=c[p+16>>2]|0}else{j=d[r>>0]|0;g=r}m=q+12|0;p=(g|0)==(p|0);if((j&255)<<24>>24==(a[((h&1)==0?M:c[L>>2]|0)>>0]|0)){if(p)Fb[c[(c[q>>2]|0)+40>>2]&127](q)|0;else c[m>>2]=g+1;v=a[Z>>0]|0;s=((v&1)==0?(v&255)>>>1:c[H>>2]|0)>>>0>1?Z:s;break b}if(p)p=Fb[c[(c[q>>2]|0)+36>>2]&127](q)|0;else p=d[g>>0]|0;if((p&255)<<24>>24!=(a[((a[Y>>0]&1)==0?K:c[J>>2]|0)>>0]|0)){U=98;break a}p=c[e>>2]|0;m=p+12|0;g=c[m>>2]|0;if((g|0)==(c[p+16>>2]|0))Fb[c[(c[p>>2]|0)+40>>2]&127](p)|0;else c[m>>2]=g+1;a[l>>0]=1;v=a[Y>>0]|0;s=((v&1)==0?(v&255)>>>1:c[I>>2]|0)>>>0>1?Y:s}break}case 2:{if(!(w>>>0<2|(s|0)!=0)?!(x|(w|0)==2&(a[E>>0]|0)!=0):0){s=0;break b}r=a[$>>0]|0;p=(r&1)==0;u=c[y>>2]|0;g=p?z:u;v=g;c:do if((w|0)!=0?(d[S+(w+-1)>>0]|0)<2:0){p=g+(p?(r&255)>>>1:c[A>>2]|0)|0;q=v;while(1){h=q;if((h|0)==(p|0))break;j=a[h>>0]|0;if(j<<24>>24<=-1)break;if(!(b[(c[G>>2]|0)+(j<<24>>24<<1)>>1]&8192))break;q=h+1|0}j=q-v|0;h=a[_>>0]|0;p=(h&1)==0;h=p?(h&255)>>>1:c[B>>2]|0;if(j>>>0<=h>>>0){h=(p?D:c[C>>2]|0)+h|0;p=h+(0-j)|0;while(1){if((p|0)==(h|0)){h=m;g=r;p=u;j=m;m=q;break c}if((a[p>>0]|0)!=(a[g>>0]|0)){h=m;g=r;p=u;j=m;m=v;break c}g=g+1|0;p=p+1|0}}else{h=m;g=r;p=u;j=m;m=v}}else{h=m;g=r;p=u;j=m;m=v}while(0);d:while(1){q=(g&1)==0;p=(q?z:p)+(q?(g&255)>>>1:c[A>>2]|0)|0;q=m;if((q|0)==(p|0))break;p=c[e>>2]|0;do if(p){if((c[p+12>>2]|0)==(c[p+16>>2]|0))if((Fb[c[(c[p>>2]|0)+36>>2]&127](p)|0)==-1){c[e>>2]=0;p=0;break}else{p=c[e>>2]|0;break}}else p=0;while(0);m=(p|0)==0;do if(j){if((c[j+12>>2]|0)!=(c[j+16>>2]|0))if(m){p=h;break}else{p=q;break d}if((Fb[c[(c[j>>2]|0)+36>>2]&127](j)|0)!=-1)if(m^(h|0)==0){p=h;j=h;break}else{p=q;break d}else{c[f>>2]=0;p=0;U=124;break}}else{p=h;U=124}while(0);if((U|0)==124){U=0;if(m){p=q;break}else j=0}m=c[e>>2]|0;g=c[m+12>>2]|0;if((g|0)==(c[m+16>>2]|0))m=Fb[c[(c[m>>2]|0)+36>>2]&127](m)|0;else m=d[g>>0]|0;if((m&255)<<24>>24!=(a[q>>0]|0)){p=q;break}m=c[e>>2]|0;g=m+12|0;h=c[g>>2]|0;if((h|0)==(c[m+16>>2]|0))Fb[c[(c[m>>2]|0)+40>>2]&127](m)|0;else c[g>>2]=h+1;h=p;g=a[$>>0]|0;p=c[y>>2]|0;m=q+1|0}if(x?(v=a[$>>0]|0,u=(v&1)==0,(p|0)!=((u?z:c[y>>2]|0)+(u?(v&255)>>>1:c[A>>2]|0)|0)):0){U=136;break a}break}case 4:{r=a[T>>0]|0;j=m;h=m;p=0;e:while(1){m=c[e>>2]|0;do if(m){if((c[m+12>>2]|0)==(c[m+16>>2]|0))if((Fb[c[(c[m>>2]|0)+36>>2]&127](m)|0)==-1){c[e>>2]=0;m=0;break}else{m=c[e>>2]|0;break}}else m=0;while(0);g=(m|0)==0;do if(h){if((c[h+12>>2]|0)!=(c[h+16>>2]|0))if(g){m=j;q=h;break}else{m=j;break e}if((Fb[c[(c[h>>2]|0)+36>>2]&127](h)|0)!=-1)if(g^(j|0)==0){m=j;q=j;break}else{m=j;break e}else{c[f>>2]=0;m=0;U=147;break}}else{m=j;U=147}while(0);if((U|0)==147){U=0;if(g)break;else q=0}g=c[e>>2]|0;h=c[g+12>>2]|0;if((h|0)==(c[g+16>>2]|0))g=Fb[c[(c[g>>2]|0)+36>>2]&127](g)|0;else g=d[h>>0]|0;h=g&255;if(h<<24>>24>-1?(b[(c[G>>2]|0)+(g<<24>>24<<1)>>1]&2048)!=0:0){g=c[o>>2]|0;if((g|0)==(c[N>>2]|0)){Wq(n,o,N);g=c[o>>2]|0}c[o>>2]=g+1;a[g>>0]=h;p=p+1|0}else{v=a[X>>0]|0;if(!(h<<24>>24==r<<24>>24&(p|0?(((v&1)==0?(v&255)>>>1:c[F>>2]|0)|0)!=0:0)))break;if((t|0)==(c[Q>>2]|0)){Xq(aa,R,Q);t=c[R>>2]|0}v=t+4|0;c[R>>2]=v;c[t>>2]=p;t=v;p=0}g=c[e>>2]|0;h=g+12|0;j=c[h>>2]|0;if((j|0)==(c[g+16>>2]|0)){Fb[c[(c[g>>2]|0)+40>>2]&127](g)|0;j=m;h=q;continue}else{c[h>>2]=j+1;j=m;h=q;continue}}if(p|0?(c[aa>>2]|0)!=(t|0):0){if((t|0)==(c[Q>>2]|0)){Xq(aa,R,Q);t=c[R>>2]|0}v=t+4|0;c[R>>2]=v;c[t>>2]=p;t=v}h=c[P>>2]|0;f:do if((h|0)>0){p=c[e>>2]|0;do if(p){if((c[p+12>>2]|0)==(c[p+16>>2]|0))if((Fb[c[(c[p>>2]|0)+36>>2]&127](p)|0)==-1){c[e>>2]=0;p=0;break}else{p=c[e>>2]|0;break}}else p=0;while(0);p=(p|0)==0;do if(m){if((c[m+12>>2]|0)==(c[m+16>>2]|0)?(Fb[c[(c[m>>2]|0)+36>>2]&127](m)|0)==-1:0){c[f>>2]=0;U=179;break}if(p)j=m;else{U=184;break a}}else U=179;while(0);if((U|0)==179){U=0;if(p){U=184;break a}else j=0}p=c[e>>2]|0;m=c[p+12>>2]|0;if((m|0)==(c[p+16>>2]|0))p=Fb[c[(c[p>>2]|0)+36>>2]&127](p)|0;else p=d[m>>0]|0;if((p&255)<<24>>24!=(a[O>>0]|0)){U=184;break a}p=c[e>>2]|0;m=p+12|0;g=c[m>>2]|0;if((g|0)==(c[p+16>>2]|0)){Fb[c[(c[p>>2]|0)+40>>2]&127](p)|0;p=j;g=j}else{c[m>>2]=g+1;p=j;g=j}while(1){if((h|0)<=0)break f;m=c[e>>2]|0;do if(m){if((c[m+12>>2]|0)==(c[m+16>>2]|0))if((Fb[c[(c[m>>2]|0)+36>>2]&127](m)|0)==-1){c[e>>2]=0;m=0;break}else{m=c[e>>2]|0;break}}else m=0;while(0);m=(m|0)==0;do if(g){if((c[g+12>>2]|0)!=(c[g+16>>2]|0))if(m){q=p;j=g;break}else{U=206;break a}if((Fb[c[(c[g>>2]|0)+36>>2]&127](g)|0)!=-1)if(m^(p|0)==0){q=p;j=p;break}else{U=206;break a}else{c[f>>2]=0;p=0;U=199;break}}else U=199;while(0);if((U|0)==199){U=0;if(m){U=206;break a}else{q=p;j=0}}p=c[e>>2]|0;m=c[p+12>>2]|0;if((m|0)==(c[p+16>>2]|0))p=Fb[c[(c[p>>2]|0)+36>>2]&127](p)|0;else p=d[m>>0]|0;if((p&255)<<24>>24<=-1){U=206;break a}if(!(b[(c[G>>2]|0)+(p<<24>>24<<1)>>1]&2048)){U=206;break a}if((c[o>>2]|0)==(c[N>>2]|0))Wq(n,o,N);p=c[e>>2]|0;m=c[p+12>>2]|0;if((m|0)==(c[p+16>>2]|0))p=Fb[c[(c[p>>2]|0)+36>>2]&127](p)|0;else p=d[m>>0]|0;m=c[o>>2]|0;c[o>>2]=m+1;a[m>>0]=p;h=h+-1|0;c[P>>2]=h;p=c[e>>2]|0;m=p+12|0;g=c[m>>2]|0;if((g|0)==(c[p+16>>2]|0)){Fb[c[(c[p>>2]|0)+40>>2]&127](p)|0;p=q;g=j;continue}else{c[m>>2]=g+1;p=q;g=j;continue}}}while(0);if((c[o>>2]|0)==(c[n>>2]|0)){U=216;break a}break}default:{}}while(0);g:do if((U|0)==44)while(1){U=0;m=c[e>>2]|0;do if(m){if((c[m+12>>2]|0)==(c[m+16>>2]|0))if((Fb[c[(c[m>>2]|0)+36>>2]&127](m)|0)==-1){c[e>>2]=0;m=0;break}else{m=c[e>>2]|0;break}}else m=0;while(0);m=(m|0)==0;do if(g){if((c[g+12>>2]|0)!=(c[g+16>>2]|0))if(m){j=p;h=g;break}else break g;if((Fb[c[(c[g>>2]|0)+36>>2]&127](g)|0)!=-1)if(m^(p|0)==0){j=p;h=p;break}else break g;else{c[f>>2]=0;p=0;U=54;break}}else U=54;while(0);if((U|0)==54){U=0;if(m)break g;else{j=p;h=0}}p=c[e>>2]|0;m=c[p+12>>2]|0;if((m|0)==(c[p+16>>2]|0))p=Fb[c[(c[p>>2]|0)+36>>2]&127](p)|0;else p=d[m>>0]|0;if((p&255)<<24>>24<=-1)break g;if(!(b[(c[G>>2]|0)+(p<<24>>24<<1)>>1]&8192))break g;p=c[e>>2]|0;m=p+12|0;g=c[m>>2]|0;if((g|0)==(c[p+16>>2]|0))p=Fb[c[(c[p>>2]|0)+40>>2]&127](p)|0;else{c[m>>2]=g+1;p=d[g>>0]|0}Gk(_,p&255);p=j;g=h;U=44}while(0);w=w+1|0}h:do if((U|0)==42){c[k>>2]=c[k>>2]|4;m=0}else if((U|0)==98){c[k>>2]=c[k>>2]|4;m=0}else if((U|0)==136){c[k>>2]=c[k>>2]|4;m=0}else if((U|0)==184){c[k>>2]=c[k>>2]|4;m=0}else if((U|0)==206){c[k>>2]=c[k>>2]|4;m=0}else if((U|0)==216){c[k>>2]=c[k>>2]|4;m=0}else if((U|0)==218){i:do if(s|0){j=s+1|0;q=s+8|0;r=s+4|0;g=1;j:while(1){p=a[s>>0]|0;if(!(p&1))p=(p&255)>>>1;else p=c[r>>2]|0;if(g>>>0>=p>>>0)break i;p=c[e>>2]|0;do if(p){if((c[p+12>>2]|0)==(c[p+16>>2]|0))if((Fb[c[(c[p>>2]|0)+36>>2]&127](p)|0)==-1){c[e>>2]=0;p=0;break}else{p=c[e>>2]|0;break}}else p=0;while(0);p=(p|0)==0;m=c[f>>2]|0;do if(m){if((c[m+12>>2]|0)==(c[m+16>>2]|0)?(Fb[c[(c[m>>2]|0)+36>>2]&127](m)|0)==-1:0){c[f>>2]=0;U=234;break}if(!p)break j}else U=234;while(0);if((U|0)==234?(U=0,p):0)break;p=c[e>>2]|0;m=c[p+12>>2]|0;if((m|0)==(c[p+16>>2]|0))p=Fb[c[(c[p>>2]|0)+36>>2]&127](p)|0;else p=d[m>>0]|0;if(!(a[s>>0]&1))m=j;else m=c[q>>2]|0;if((p&255)<<24>>24!=(a[m+g>>0]|0))break;p=g+1|0;m=c[e>>2]|0;g=m+12|0;h=c[g>>2]|0;if((h|0)==(c[m+16>>2]|0)){Fb[c[(c[m>>2]|0)+40>>2]&127](m)|0;g=p;continue}else{c[g>>2]=h+1;g=p;continue}}c[k>>2]=c[k>>2]|4;m=0;break h}while(0);p=c[aa>>2]|0;if((p|0)!=(t|0)){c[V>>2]=0;Zm(X,p,t,V);if(!(c[V>>2]|0)){m=1;break}else{c[k>>2]=c[k>>2]|4;m=0;break}}else m=1}while(0);vk(_);vk(Y);vk(Z);vk($);vk(X);p=c[aa>>2]|0;c[aa>>2]=0;if(p|0)Bb[c[W>>2]&255](p);i=ba;return m|0}function Vq(b,d,e,f,g,h,j,k,l,m){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;var n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;x=i;i=i+112|0;n=x+100|0;p=x+88|0;r=x+76|0;t=x+64|0;v=x+52|0;o=x+48|0;q=x+36|0;s=x+24|0;u=x+12|0;w=x;if(b){d=Om(d,1151820)|0;Cb[c[(c[d>>2]|0)+44>>2]&63](n,d);w=c[n>>2]|0;a[e>>0]=w;a[e+1>>0]=w>>8;a[e+2>>0]=w>>16;a[e+3>>0]=w>>24;Cb[c[(c[d>>2]|0)+32>>2]&63](p,d);if(!(a[l>>0]&1)){a[l+1>>0]=0;a[l>>0]=0}else{a[c[l+8>>2]>>0]=0;c[l+4>>2]=0}zk(l,0);c[l>>2]=c[p>>2];c[l+4>>2]=c[p+4>>2];c[l+8>>2]=c[p+8>>2];b=0;while(1){if((b|0)==3)break;c[p+(b<<2)>>2]=0;b=b+1|0}vk(p);Cb[c[(c[d>>2]|0)+28>>2]&63](r,d);if(!(a[k>>0]&1)){a[k+1>>0]=0;a[k>>0]=0}else{a[c[k+8>>2]>>0]=0;c[k+4>>2]=0}zk(k,0);c[k>>2]=c[r>>2];c[k+4>>2]=c[r+4>>2];c[k+8>>2]=c[r+8>>2];b=0;while(1){if((b|0)==3)break;c[r+(b<<2)>>2]=0;b=b+1|0}vk(r);a[f>>0]=Fb[c[(c[d>>2]|0)+12>>2]&127](d)|0;a[g>>0]=Fb[c[(c[d>>2]|0)+16>>2]&127](d)|0;Cb[c[(c[d>>2]|0)+20>>2]&63](t,d);if(!(a[h>>0]&1)){a[h+1>>0]=0;a[h>>0]=0}else{a[c[h+8>>2]>>0]=0;c[h+4>>2]=0}zk(h,0);c[h>>2]=c[t>>2];c[h+4>>2]=c[t+4>>2];c[h+8>>2]=c[t+8>>2];b=0;while(1){if((b|0)==3)break;c[t+(b<<2)>>2]=0;b=b+1|0}vk(t);Cb[c[(c[d>>2]|0)+24>>2]&63](v,d);if(!(a[j>>0]&1)){a[j+1>>0]=0;a[j>>0]=0}else{a[c[j+8>>2]>>0]=0;c[j+4>>2]=0}zk(j,0);c[j>>2]=c[v>>2];c[j+4>>2]=c[v+4>>2];c[j+8>>2]=c[v+8>>2];b=0;while(1){if((b|0)==3)break;c[v+(b<<2)>>2]=0;b=b+1|0}vk(v);b=Fb[c[(c[d>>2]|0)+36>>2]&127](d)|0}else{d=Om(d,1151812)|0;Cb[c[(c[d>>2]|0)+44>>2]&63](o,d);v=c[o>>2]|0;a[e>>0]=v;a[e+1>>0]=v>>8;a[e+2>>0]=v>>16;a[e+3>>0]=v>>24;Cb[c[(c[d>>2]|0)+32>>2]&63](q,d);if(!(a[l>>0]&1)){a[l+1>>0]=0;a[l>>0]=0}else{a[c[l+8>>2]>>0]=0;c[l+4>>2]=0}zk(l,0);c[l>>2]=c[q>>2];c[l+4>>2]=c[q+4>>2];c[l+8>>2]=c[q+8>>2];b=0;while(1){if((b|0)==3)break;c[q+(b<<2)>>2]=0;b=b+1|0}vk(q);Cb[c[(c[d>>2]|0)+28>>2]&63](s,d);if(!(a[k>>0]&1)){a[k+1>>0]=0;a[k>>0]=0}else{a[c[k+8>>2]>>0]=0;c[k+4>>2]=0}zk(k,0);c[k>>2]=c[s>>2];c[k+4>>2]=c[s+4>>2];c[k+8>>2]=c[s+8>>2];b=0;while(1){if((b|0)==3)break;c[s+(b<<2)>>2]=0;b=b+1|0}vk(s);a[f>>0]=Fb[c[(c[d>>2]|0)+12>>2]&127](d)|0;a[g>>0]=Fb[c[(c[d>>2]|0)+16>>2]&127](d)|0;Cb[c[(c[d>>2]|0)+20>>2]&63](u,d);if(!(a[h>>0]&1)){a[h+1>>0]=0;a[h>>0]=0}else{a[c[h+8>>2]>>0]=0;c[h+4>>2]=0}zk(h,0);c[h>>2]=c[u>>2];c[h+4>>2]=c[u+4>>2];c[h+8>>2]=c[u+8>>2];b=0;while(1){if((b|0)==3)break;c[u+(b<<2)>>2]=0;b=b+1|0}vk(u);Cb[c[(c[d>>2]|0)+24>>2]&63](w,d);if(!(a[j>>0]&1)){a[j+1>>0]=0;a[j>>0]=0}else{a[c[j+8>>2]>>0]=0;c[j+4>>2]=0}zk(j,0);c[j>>2]=c[w>>2];c[j+4>>2]=c[w+4>>2];c[j+8>>2]=c[w+8>>2];b=0;while(1){if((b|0)==3)break;c[w+(b<<2)>>2]=0;b=b+1|0}vk(w);b=Fb[c[(c[d>>2]|0)+36>>2]&127](d)|0}c[m>>2]=b;i=x;return}function Wq(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0;h=a+4|0;f=(c[h>>2]|0)!=161;e=c[a>>2]|0;g=(c[d>>2]|0)-e|0;g=g>>>0<2147483647?g<<1:-1;i=(c[b>>2]|0)-e|0;e=Cj(f?e:0,g)|0;if(!e)Tu();if(!f){f=c[a>>2]|0;c[a>>2]=e;if(f){Bb[c[h>>2]&255](f);e=c[a>>2]|0}}else c[a>>2]=e;c[h>>2]=162;c[b>>2]=e+i;c[d>>2]=(c[a>>2]|0)+g;return}function Xq(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0;h=a+4|0;f=(c[h>>2]|0)!=161;e=c[a>>2]|0;g=(c[d>>2]|0)-e|0;g=g>>>0<2147483647?g<<1:-1;i=(c[b>>2]|0)-e>>2;e=Cj(f?e:0,g)|0;if(!e)Tu();if(!f){f=c[a>>2]|0;c[a>>2]=e;if(f){Bb[c[h>>2]&255](f);e=c[a>>2]|0}}else c[a>>2]=e;c[h>>2]=162;c[b>>2]=e+(i<<2);c[d>>2]=(c[a>>2]|0)+(g>>>2<<2);return}function Yq(b,d,e,f,g,h,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0;s=i;i=i+144|0;v=s+24|0;t=s+32|0;r=s+16|0;l=s+8|0;u=s+4|0;k=s+28|0;m=s;c[r>>2]=t;q=r+4|0;c[q>>2]=161;o=gm(g)|0;c[u>>2]=o;b=Om(u,1150100)|0;a[k>>0]=0;n=c[e>>2]|0;c[m>>2]=n;g=c[g+4>>2]|0;c[v>>2]=c[m>>2];m=n;if(Uq(d,v,f,u,g,h,k,b,r,l,t+100|0)|0){if(!(a[j>>0]&1)){a[j+1>>0]=0;a[j>>0]=0}else{a[c[j+8>>2]>>0]=0;c[j+4>>2]=0}if(a[k>>0]|0)Gk(j,Lb[c[(c[b>>2]|0)+28>>2]&63](b,45)|0);k=Lb[c[(c[b>>2]|0)+28>>2]&63](b,48)|0;f=c[l>>2]|0;g=f+-1|0;b=c[r>>2]|0;while(1){if(b>>>0>=g>>>0)break;if((a[b>>0]|0)!=k<<24>>24)break;b=b+1|0}Zq(j,b,f)|0}b=c[d>>2]|0;do if(b){if((c[b+12>>2]|0)==(c[b+16>>2]|0))if((Fb[c[(c[b>>2]|0)+36>>2]&127](b)|0)==-1){c[d>>2]=0;b=0;break}else{b=c[d>>2]|0;break}}else b=0;while(0);b=(b|0)==0;do if(n){if((c[m+12>>2]|0)==(c[m+16>>2]|0)?(Fb[c[(c[n>>2]|0)+36>>2]&127](m)|0)==-1:0){c[e>>2]=0;p=22;break}if(!b)p=23}else p=22;while(0);if((p|0)==22?b:0)p=23;if((p|0)==23)c[h>>2]=c[h>>2]|2;g=c[d>>2]|0;du(o)|0;b=c[r>>2]|0;c[r>>2]=0;if(b|0)Bb[c[q>>2]&255](b);i=s;return g|0}function Zq(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0;h=d;f=a[b>>0]|0;if(!(f&1)){k=(f&255)>>>1;g=10}else{f=c[b>>2]|0;k=c[b+4>>2]|0;g=(f&-2)+-1|0;f=f&255}j=e-h|0;do if((e|0)!=(d|0)){if((g-k|0)>>>0<j>>>0){Dk(b,g,k+j-g|0,k,k,0,0);f=a[b>>0]|0}if(!(f&1))i=b+1|0;else i=c[b+8>>2]|0;h=e+(k-h)|0;f=d;g=i+k|0;while(1){if((f|0)==(e|0))break;a[g>>0]=a[f>>0]|0;f=f+1|0;g=g+1|0}a[i+h>>0]=0;f=k+j|0;if(!(a[b>>0]&1)){a[b>>0]=f<<1;break}else{c[b+4>>2]=f;break}}while(0);return b|0}function _q(a){a=a|0;return}function $q(a){a=a|0;mu(a);return}function ar(b,d,e,f,g,h,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;w=i;i=i+576|0;n=w+424|0;q=w;k=w+24|0;v=w+16|0;o=w+12|0;s=w+8|0;l=w+564|0;x=w+4|0;p=w+464|0;c[v>>2]=k;u=v+4|0;c[u>>2]=161;c[s>>2]=gm(g)|0;b=Om(s,1150132)|0;a[l>>0]=0;c[x>>2]=c[e>>2];g=c[g+4>>2]|0;c[n>>2]=c[x>>2];if(br(d,n,f,s,g,h,l,b,v,o,k+400|0)|0){Jb[c[(c[b>>2]|0)+48>>2]&7](b,22693,22703,n)|0;f=c[o>>2]|0;k=c[v>>2]|0;b=f-k|0;if((b|0)>392){b=zj((b>>2)+2|0)|0;if(!b)Tu();else{r=b;m=b}}else{r=0;m=p}if(!(a[l>>0]|0))b=m;else{a[m>>0]=45;b=m+1|0}l=n+40|0;m=n;while(1){if(k>>>0>=f>>>0)break;g=c[k>>2]|0;f=n;while(1){if((f|0)==(l|0)){f=l;break}if((c[f>>2]|0)==(g|0))break;f=f+4|0}a[b>>0]=a[22693+(f-m>>2)>>0]|0;f=c[o>>2]|0;b=b+1|0;k=k+4|0}a[b>>0]=0;c[q>>2]=j;Qi(p,22594,q)|0;if(r|0)Aj(r)}b=c[d>>2]|0;do if(b){f=c[b+12>>2]|0;if((f|0)==(c[b+16>>2]|0))b=Fb[c[(c[b>>2]|0)+36>>2]&127](b)|0;else b=c[f>>2]|0;if((b|0)==-1){c[d>>2]=0;g=1;break}else{g=(c[d>>2]|0)==0;break}}else g=1;while(0);b=c[e>>2]|0;do if(b){f=c[b+12>>2]|0;if((f|0)==(c[b+16>>2]|0))b=Fb[c[(c[b>>2]|0)+36>>2]&127](b)|0;else b=c[f>>2]|0;if((b|0)!=-1)if(g)break;else{t=32;break}else{c[e>>2]=0;t=30;break}}else t=30;while(0);if((t|0)==30?g:0)t=32;if((t|0)==32)c[h>>2]=c[h>>2]|2;f=c[d>>2]|0;du(c[s>>2]|0)|0;b=c[v>>2]|0;c[v>>2]=0;if(b|0)Bb[c[u>>2]&255](b);i=w;return f|0}function br(b,e,f,g,h,j,k,l,m,n,o){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;n=n|0;o=o|0;var p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0;Y=i;i=i+512|0;I=Y+96|0;s=Y+104|0;X=Y+88|0;M=Y+80|0;L=Y+76|0;N=Y+504|0;J=Y+72|0;O=Y+68|0;S=Y+56|0;W=Y+44|0;U=Y+32|0;T=Y+20|0;V=Y+8|0;K=Y+4|0;Q=Y;c[I>>2]=o;c[X>>2]=s;R=X+4|0;c[R>>2]=161;c[M>>2]=s;c[L>>2]=s+400;o=0;while(1){if((o|0)==3)break;c[S+(o<<2)>>2]=0;o=o+1|0}o=0;while(1){if((o|0)==3)break;c[W+(o<<2)>>2]=0;o=o+1|0}o=0;while(1){if((o|0)==3)break;c[U+(o<<2)>>2]=0;o=o+1|0}o=0;while(1){if((o|0)==3)break;c[T+(o<<2)>>2]=0;o=o+1|0}o=0;while(1){if((o|0)==3)break;c[V+(o<<2)>>2]=0;o=o+1|0}cr(f,g,N,J,O,S,W,U,T,K);c[n>>2]=c[m>>2];E=U+4|0;F=T+4|0;G=T+8|0;H=U+8|0;x=(h&512|0)!=0;y=W+8|0;z=W+4|0;A=V+4|0;B=V+8|0;C=N+3|0;D=S+4|0;w=0;r=0;a:while(1){if(w>>>0>=4){P=232;break}o=c[b>>2]|0;do if(o){f=c[o+12>>2]|0;if((f|0)==(c[o+16>>2]|0))o=Fb[c[(c[o>>2]|0)+36>>2]&127](o)|0;else o=c[f>>2]|0;if((o|0)==-1){c[b>>2]=0;g=1;break}else{g=(c[b>>2]|0)==0;break}}else g=1;while(0);f=c[e>>2]|0;do if(f){o=c[f+12>>2]|0;if((o|0)==(c[f+16>>2]|0))o=Fb[c[(c[f>>2]|0)+36>>2]&127](f)|0;else o=c[o>>2]|0;if((o|0)!=-1)if(g){v=f;break}else{P=232;break a}else{c[e>>2]=0;P=31;break}}else P=31;while(0);if((P|0)==31){P=0;if(g){P=232;break}else v=0}b:do switch(a[N+w>>0]|0){case 1:{if((w|0)!=3){o=c[b>>2]|0;f=c[o+12>>2]|0;if((f|0)==(c[o+16>>2]|0))o=Fb[c[(c[o>>2]|0)+36>>2]&127](o)|0;else o=c[f>>2]|0;if(!(yb[c[(c[l>>2]|0)+12>>2]&31](l,8192,o)|0)){P=44;break a}o=c[b>>2]|0;f=o+12|0;g=c[f>>2]|0;if((g|0)==(c[o+16>>2]|0))o=Fb[c[(c[o>>2]|0)+40>>2]&127](o)|0;else{c[f>>2]=g+4;o=c[g>>2]|0}Wk(V,o);o=v;h=v;P=46}break}case 0:{if((w|0)!=3){o=v;h=v;P=46}break}case 3:{p=a[U>>0]|0;o=(p&1)==0?(p&255)>>>1:c[E>>2]|0;g=a[T>>0]|0;g=(g&1)==0?(g&255)>>>1:c[F>>2]|0;if((o|0)!=(0-g|0)){h=(o|0)==0;q=c[b>>2]|0;t=c[q+12>>2]|0;o=c[q+16>>2]|0;f=(t|0)==(o|0);if(h|(g|0)==0){if(f)o=Fb[c[(c[q>>2]|0)+36>>2]&127](q)|0;else o=c[t>>2]|0;if(h){if((o|0)!=(c[((a[T>>0]&1)==0?F:c[G>>2]|0)>>2]|0))break b;o=c[b>>2]|0;f=o+12|0;g=c[f>>2]|0;if((g|0)==(c[o+16>>2]|0))Fb[c[(c[o>>2]|0)+40>>2]&127](o)|0;else c[f>>2]=g+4;a[k>>0]=1;v=a[T>>0]|0;r=((v&1)==0?(v&255)>>>1:c[F>>2]|0)>>>0>1?T:r;break b}if((o|0)!=(c[((a[U>>0]&1)==0?E:c[H>>2]|0)>>2]|0)){a[k>>0]=1;break b}o=c[b>>2]|0;f=o+12|0;g=c[f>>2]|0;if((g|0)==(c[o+16>>2]|0))Fb[c[(c[o>>2]|0)+40>>2]&127](o)|0;else c[f>>2]=g+4;v=a[U>>0]|0;r=((v&1)==0?(v&255)>>>1:c[E>>2]|0)>>>0>1?U:r;break b}if(f){h=Fb[c[(c[q>>2]|0)+36>>2]&127](q)|0;o=c[b>>2]|0;p=a[U>>0]|0;q=o;g=c[o+12>>2]|0;o=c[o+16>>2]|0}else{h=c[t>>2]|0;g=t}f=q+12|0;o=(g|0)==(o|0);if((h|0)==(c[((p&1)==0?E:c[H>>2]|0)>>2]|0)){if(o)Fb[c[(c[q>>2]|0)+40>>2]&127](q)|0;else c[f>>2]=g+4;v=a[U>>0]|0;r=((v&1)==0?(v&255)>>>1:c[E>>2]|0)>>>0>1?U:r;break b}if(o)o=Fb[c[(c[q>>2]|0)+36>>2]&127](q)|0;else o=c[g>>2]|0;if((o|0)!=(c[((a[T>>0]&1)==0?F:c[G>>2]|0)>>2]|0)){P=102;break a}o=c[b>>2]|0;f=o+12|0;g=c[f>>2]|0;if((g|0)==(c[o+16>>2]|0))Fb[c[(c[o>>2]|0)+40>>2]&127](o)|0;else c[f>>2]=g+4;a[k>>0]=1;v=a[T>>0]|0;r=((v&1)==0?(v&255)>>>1:c[F>>2]|0)>>>0>1?T:r}break}case 2:{if(!(w>>>0<2|(r|0)!=0)?!(x|(w|0)==2&(a[C>>0]|0)!=0):0){r=0;break b}f=a[W>>0]|0;g=c[y>>2]|0;o=(f&1)==0?z:g;c:do if((w|0)!=0?(d[N+(w+-1)>>0]|0)<2:0){h=g;while(1){u=(f&1)==0;g=o;if((g|0)==((u?z:h)+((u?(f&255)>>>1:c[z>>2]|0)<<2)|0))break;if(!(yb[c[(c[l>>2]|0)+12>>2]&31](l,8192,c[g>>2]|0)|0)){P=109;break}f=a[W>>0]|0;h=c[y>>2]|0;o=g+4|0}if((P|0)==109){P=0;f=a[W>>0]|0;h=c[y>>2]|0}q=(f&1)==0?z:h;g=q;u=o-g>>2;t=a[V>>0]|0;p=(t&1)==0;t=p?(t&255)>>>1:c[A>>2]|0;if(u>>>0>t>>>0){t=v;p=v}else{t=(p?A:c[B>>2]|0)+(t<<2)|0;p=t+(0-u<<2)|0;while(1){if((p|0)==(t|0)){t=v;p=v;g=o;break c}if((c[p>>2]|0)!=(c[q>>2]|0)){t=v;p=v;break c}q=q+4|0;p=p+4|0}}}else{t=v;h=g;p=v;g=o}while(0);d:while(1){o=(f&1)==0;o=(o?z:h)+((o?(f&255)>>>1:c[z>>2]|0)<<2)|0;q=g;if((q|0)==(o|0))break;o=c[b>>2]|0;do if(o){f=c[o+12>>2]|0;if((f|0)==(c[o+16>>2]|0))o=Fb[c[(c[o>>2]|0)+36>>2]&127](o)|0;else o=c[f>>2]|0;if((o|0)==-1){c[b>>2]=0;f=1;break}else{f=(c[b>>2]|0)==0;break}}else f=1;while(0);do if(p){o=c[p+12>>2]|0;if((o|0)==(c[p+16>>2]|0))o=Fb[c[(c[p>>2]|0)+36>>2]&127](p)|0;else o=c[o>>2]|0;if((o|0)!=-1)if(f^(t|0)==0){o=t;p=t;break}else{o=q;break d}else{c[e>>2]=0;o=0;P=130;break}}else{o=t;P=130}while(0);if((P|0)==130){P=0;if(f){o=q;break}else p=0}f=c[b>>2]|0;g=c[f+12>>2]|0;if((g|0)==(c[f+16>>2]|0))f=Fb[c[(c[f>>2]|0)+36>>2]&127](f)|0;else f=c[g>>2]|0;if((f|0)!=(c[q>>2]|0)){o=q;break}f=c[b>>2]|0;g=f+12|0;h=c[g>>2]|0;if((h|0)==(c[f+16>>2]|0))Fb[c[(c[f>>2]|0)+40>>2]&127](f)|0;else c[g>>2]=h+4;t=o;f=a[W>>0]|0;h=c[y>>2]|0;g=q+4|0}if(x?(v=a[W>>0]|0,u=(v&1)==0,(o|0)!=((u?z:c[y>>2]|0)+((u?(v&255)>>>1:c[z>>2]|0)<<2)|0)):0){P=142;break a}break}case 4:{t=c[O>>2]|0;p=v;h=v;o=0;e:while(1){f=c[b>>2]|0;do if(f){g=c[f+12>>2]|0;if((g|0)==(c[f+16>>2]|0))f=Fb[c[(c[f>>2]|0)+36>>2]&127](f)|0;else f=c[g>>2]|0;if((f|0)==-1){c[b>>2]=0;g=1;break}else{g=(c[b>>2]|0)==0;break}}else g=1;while(0);do if(h){f=c[h+12>>2]|0;if((f|0)==(c[h+16>>2]|0))f=Fb[c[(c[h>>2]|0)+36>>2]&127](h)|0;else f=c[f>>2]|0;if((f|0)!=-1)if(g^(p|0)==0){f=p;q=p;break}else break e;else{c[e>>2]=0;f=0;P=156;break}}else{f=p;P=156}while(0);if((P|0)==156){P=0;if(g){p=f;break}else q=0}g=c[b>>2]|0;h=c[g+12>>2]|0;if((h|0)==(c[g+16>>2]|0))h=Fb[c[(c[g>>2]|0)+36>>2]&127](g)|0;else h=c[h>>2]|0;if(yb[c[(c[l>>2]|0)+12>>2]&31](l,2048,h)|0){g=c[n>>2]|0;if((g|0)==(c[I>>2]|0)){dr(m,n,I);g=c[n>>2]|0}c[n>>2]=g+4;c[g>>2]=h;o=o+1|0}else{v=a[S>>0]|0;if(!((h|0)==(t|0)&(o|0?(((v&1)==0?(v&255)>>>1:c[D>>2]|0)|0)!=0:0))){p=f;break}if((s|0)==(c[L>>2]|0)){Xq(X,M,L);s=c[M>>2]|0}v=s+4|0;c[M>>2]=v;c[s>>2]=o;s=v;o=0}g=c[b>>2]|0;h=g+12|0;p=c[h>>2]|0;if((p|0)==(c[g+16>>2]|0)){Fb[c[(c[g>>2]|0)+40>>2]&127](g)|0;p=f;h=q;continue}else{c[h>>2]=p+4;p=f;h=q;continue}}if(o|0?(c[X>>2]|0)!=(s|0):0){if((s|0)==(c[L>>2]|0)){Xq(X,M,L);s=c[M>>2]|0}v=s+4|0;c[M>>2]=v;c[s>>2]=o;s=v}h=c[K>>2]|0;f:do if((h|0)>0){o=c[b>>2]|0;do if(o){f=c[o+12>>2]|0;if((f|0)==(c[o+16>>2]|0))o=Fb[c[(c[o>>2]|0)+36>>2]&127](o)|0;else o=c[f>>2]|0;if((o|0)==-1){c[b>>2]=0;f=1;break}else{f=(c[b>>2]|0)==0;break}}else f=1;while(0);do if(p){o=c[p+12>>2]|0;if((o|0)==(c[p+16>>2]|0))o=Fb[c[(c[p>>2]|0)+36>>2]&127](p)|0;else o=c[o>>2]|0;if((o|0)!=-1)if(f)break;else{P=196;break a}else{c[e>>2]=0;P=190;break}}else P=190;while(0);if((P|0)==190){P=0;if(f){P=196;break a}else p=0}o=c[b>>2]|0;f=c[o+12>>2]|0;if((f|0)==(c[o+16>>2]|0))o=Fb[c[(c[o>>2]|0)+36>>2]&127](o)|0;else o=c[f>>2]|0;if((o|0)!=(c[J>>2]|0)){P=196;break a}o=c[b>>2]|0;f=o+12|0;g=c[f>>2]|0;if((g|0)==(c[o+16>>2]|0)){Fb[c[(c[o>>2]|0)+40>>2]&127](o)|0;o=p}else{c[f>>2]=g+4;o=p}while(1){if((h|0)<=0)break f;f=c[b>>2]|0;do if(f){g=c[f+12>>2]|0;if((g|0)==(c[f+16>>2]|0))f=Fb[c[(c[f>>2]|0)+36>>2]&127](f)|0;else f=c[g>>2]|0;if((f|0)==-1){c[b>>2]=0;g=1;break}else{g=(c[b>>2]|0)==0;break}}else g=1;while(0);do if(p){f=c[p+12>>2]|0;if((f|0)==(c[p+16>>2]|0))f=Fb[c[(c[p>>2]|0)+36>>2]&127](p)|0;else f=c[f>>2]|0;if((f|0)!=-1)if(g^(o|0)==0){q=o;p=o;break}else{P=220;break a}else{c[e>>2]=0;o=0;P=214;break}}else P=214;while(0);if((P|0)==214){P=0;if(g){P=220;break a}else{q=o;p=0}}o=c[b>>2]|0;f=c[o+12>>2]|0;if((f|0)==(c[o+16>>2]|0))o=Fb[c[(c[o>>2]|0)+36>>2]&127](o)|0;else o=c[f>>2]|0;if(!(yb[c[(c[l>>2]|0)+12>>2]&31](l,2048,o)|0)){P=220;break a}if((c[n>>2]|0)==(c[I>>2]|0))dr(m,n,I);o=c[b>>2]|0;f=c[o+12>>2]|0;if((f|0)==(c[o+16>>2]|0))o=Fb[c[(c[o>>2]|0)+36>>2]&127](o)|0;else o=c[f>>2]|0;f=c[n>>2]|0;c[n>>2]=f+4;c[f>>2]=o;h=h+-1|0;c[K>>2]=h;o=c[b>>2]|0;f=o+12|0;g=c[f>>2]|0;if((g|0)==(c[o+16>>2]|0)){Fb[c[(c[o>>2]|0)+40>>2]&127](o)|0;o=q;continue}else{c[f>>2]=g+4;o=q;continue}}}while(0);if((c[n>>2]|0)==(c[m>>2]|0)){P=230;break a}break}default:{}}while(0);g:do if((P|0)==46)while(1){P=0;f=c[b>>2]|0;do if(f){g=c[f+12>>2]|0;if((g|0)==(c[f+16>>2]|0))f=Fb[c[(c[f>>2]|0)+36>>2]&127](f)|0;else f=c[g>>2]|0;if((f|0)==-1){c[b>>2]=0;g=1;break}else{g=(c[b>>2]|0)==0;break}}else g=1;while(0);do if(h){f=c[h+12>>2]|0;if((f|0)==(c[h+16>>2]|0))f=Fb[c[(c[h>>2]|0)+36>>2]&127](h)|0;else f=c[f>>2]|0;if((f|0)!=-1)if(g^(o|0)==0){p=o;h=o;break}else break g;else{c[e>>2]=0;o=0;P=59;break}}else P=59;while(0);if((P|0)==59){P=0;if(g)break g;else{p=o;h=0}}o=c[b>>2]|0;f=c[o+12>>2]|0;if((f|0)==(c[o+16>>2]|0))o=Fb[c[(c[o>>2]|0)+36>>2]&127](o)|0;else o=c[f>>2]|0;if(!(yb[c[(c[l>>2]|0)+12>>2]&31](l,8192,o)|0))break g;o=c[b>>2]|0;f=o+12|0;g=c[f>>2]|0;if((g|0)==(c[o+16>>2]|0))o=Fb[c[(c[o>>2]|0)+40>>2]&127](o)|0;else{c[f>>2]=g+4;o=c[g>>2]|0}Wk(V,o);o=p;P=46}while(0);w=w+1|0}h:do if((P|0)==44){c[j>>2]=c[j>>2]|4;f=0}else if((P|0)==102){c[j>>2]=c[j>>2]|4;f=0}else if((P|0)==142){c[j>>2]=c[j>>2]|4;f=0}else if((P|0)==196){c[j>>2]=c[j>>2]|4;f=0}else if((P|0)==220){c[j>>2]=c[j>>2]|4;f=0}else if((P|0)==230){c[j>>2]=c[j>>2]|4;f=0}else if((P|0)==232){i:do if(r|0){p=r+4|0;q=r+8|0;h=1;j:while(1){o=a[r>>0]|0;if(!(o&1))o=(o&255)>>>1;else o=c[p>>2]|0;if(h>>>0>=o>>>0)break i;o=c[b>>2]|0;do if(o){f=c[o+12>>2]|0;if((f|0)==(c[o+16>>2]|0))o=Fb[c[(c[o>>2]|0)+36>>2]&127](o)|0;else o=c[f>>2]|0;if((o|0)==-1){c[b>>2]=0;g=1;break}else{g=(c[b>>2]|0)==0;break}}else g=1;while(0);o=c[e>>2]|0;do if(o){f=c[o+12>>2]|0;if((f|0)==(c[o+16>>2]|0))o=Fb[c[(c[o>>2]|0)+36>>2]&127](o)|0;else o=c[f>>2]|0;if((o|0)!=-1)if(g)break;else break j;else{c[e>>2]=0;P=251;break}}else P=251;while(0);if((P|0)==251?(P=0,g):0)break;o=c[b>>2]|0;f=c[o+12>>2]|0;if((f|0)==(c[o+16>>2]|0))o=Fb[c[(c[o>>2]|0)+36>>2]&127](o)|0;else o=c[f>>2]|0;if(!(a[r>>0]&1))f=p;else f=c[q>>2]|0;if((o|0)!=(c[f+(h<<2)>>2]|0))break;o=h+1|0;f=c[b>>2]|0;g=f+12|0;h=c[g>>2]|0;if((h|0)==(c[f+16>>2]|0)){Fb[c[(c[f>>2]|0)+40>>2]&127](f)|0;h=o;continue}else{c[g>>2]=h+4;h=o;continue}}c[j>>2]=c[j>>2]|4;f=0;break h}while(0);o=c[X>>2]|0;if((o|0)!=(s|0)){c[Q>>2]=0;Zm(S,o,s,Q);if(!(c[Q>>2]|0)){f=1;break}else{c[j>>2]=c[j>>2]|4;f=0;break}}else f=1}while(0);Qk(V);Qk(T);Qk(U);Qk(W);vk(S);o=c[X>>2]|0;c[X>>2]=0;if(o|0)Bb[c[R>>2]&255](o);i=Y;return f|0}function cr(b,d,e,f,g,h,j,k,l,m){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;var n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;x=i;i=i+112|0;n=x+100|0;p=x+88|0;r=x+76|0;t=x+64|0;v=x+52|0;o=x+48|0;q=x+36|0;s=x+24|0;u=x+12|0;w=x;if(b){d=Om(d,1151836)|0;Cb[c[(c[d>>2]|0)+44>>2]&63](n,d);w=c[n>>2]|0;a[e>>0]=w;a[e+1>>0]=w>>8;a[e+2>>0]=w>>16;a[e+3>>0]=w>>24;Cb[c[(c[d>>2]|0)+32>>2]&63](p,d);if(!(a[l>>0]&1))a[l>>0]=0;else c[c[l+8>>2]>>2]=0;c[l+4>>2]=0;Tk(l,0);c[l>>2]=c[p>>2];c[l+4>>2]=c[p+4>>2];c[l+8>>2]=c[p+8>>2];b=0;while(1){if((b|0)==3)break;c[p+(b<<2)>>2]=0;b=b+1|0}Qk(p);Cb[c[(c[d>>2]|0)+28>>2]&63](r,d);if(!(a[k>>0]&1))a[k>>0]=0;else c[c[k+8>>2]>>2]=0;c[k+4>>2]=0;Tk(k,0);c[k>>2]=c[r>>2];c[k+4>>2]=c[r+4>>2];c[k+8>>2]=c[r+8>>2];b=0;while(1){if((b|0)==3)break;c[r+(b<<2)>>2]=0;b=b+1|0}Qk(r);c[f>>2]=Fb[c[(c[d>>2]|0)+12>>2]&127](d)|0;c[g>>2]=Fb[c[(c[d>>2]|0)+16>>2]&127](d)|0;Cb[c[(c[d>>2]|0)+20>>2]&63](t,d);if(!(a[h>>0]&1)){a[h+1>>0]=0;a[h>>0]=0}else{a[c[h+8>>2]>>0]=0;c[h+4>>2]=0}zk(h,0);c[h>>2]=c[t>>2];c[h+4>>2]=c[t+4>>2];c[h+8>>2]=c[t+8>>2];b=0;while(1){if((b|0)==3)break;c[t+(b<<2)>>2]=0;b=b+1|0}vk(t);Cb[c[(c[d>>2]|0)+24>>2]&63](v,d);if(!(a[j>>0]&1))a[j>>0]=0;else c[c[j+8>>2]>>2]=0;c[j+4>>2]=0;Tk(j,0);c[j>>2]=c[v>>2];c[j+4>>2]=c[v+4>>2];c[j+8>>2]=c[v+8>>2];b=0;while(1){if((b|0)==3)break;c[v+(b<<2)>>2]=0;b=b+1|0}Qk(v);b=Fb[c[(c[d>>2]|0)+36>>2]&127](d)|0}else{d=Om(d,1151828)|0;Cb[c[(c[d>>2]|0)+44>>2]&63](o,d);v=c[o>>2]|0;a[e>>0]=v;a[e+1>>0]=v>>8;a[e+2>>0]=v>>16;a[e+3>>0]=v>>24;Cb[c[(c[d>>2]|0)+32>>2]&63](q,d);if(!(a[l>>0]&1))a[l>>0]=0;else c[c[l+8>>2]>>2]=0;c[l+4>>2]=0;Tk(l,0);c[l>>2]=c[q>>2];c[l+4>>2]=c[q+4>>2];c[l+8>>2]=c[q+8>>2];b=0;while(1){if((b|0)==3)break;c[q+(b<<2)>>2]=0;b=b+1|0}Qk(q);Cb[c[(c[d>>2]|0)+28>>2]&63](s,d);if(!(a[k>>0]&1))a[k>>0]=0;else c[c[k+8>>2]>>2]=0;c[k+4>>2]=0;Tk(k,0);c[k>>2]=c[s>>2];c[k+4>>2]=c[s+4>>2];c[k+8>>2]=c[s+8>>2];b=0;while(1){if((b|0)==3)break;c[s+(b<<2)>>2]=0;b=b+1|0}Qk(s);c[f>>2]=Fb[c[(c[d>>2]|0)+12>>2]&127](d)|0;c[g>>2]=Fb[c[(c[d>>2]|0)+16>>2]&127](d)|0;Cb[c[(c[d>>2]|0)+20>>2]&63](u,d);if(!(a[h>>0]&1)){a[h+1>>0]=0;a[h>>0]=0}else{a[c[h+8>>2]>>0]=0;c[h+4>>2]=0}zk(h,0);c[h>>2]=c[u>>2];c[h+4>>2]=c[u+4>>2];c[h+8>>2]=c[u+8>>2];b=0;while(1){if((b|0)==3)break;c[u+(b<<2)>>2]=0;b=b+1|0}vk(u);Cb[c[(c[d>>2]|0)+24>>2]&63](w,d);if(!(a[j>>0]&1))a[j>>0]=0;else c[c[j+8>>2]>>2]=0;c[j+4>>2]=0;Tk(j,0);c[j>>2]=c[w>>2];c[j+4>>2]=c[w+4>>2];c[j+8>>2]=c[w+8>>2];b=0;while(1){if((b|0)==3)break;c[w+(b<<2)>>2]=0;b=b+1|0}Qk(w);b=Fb[c[(c[d>>2]|0)+36>>2]&127](d)|0}c[m>>2]=b;i=x;return}function dr(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0;h=a+4|0;f=(c[h>>2]|0)!=161;e=c[a>>2]|0;g=(c[d>>2]|0)-e|0;g=g>>>0<2147483647?g<<1:-1;i=(c[b>>2]|0)-e>>2;e=Cj(f?e:0,g)|0;if(!e)Tu();if(!f){f=c[a>>2]|0;c[a>>2]=e;if(f){Bb[c[h>>2]&255](f);e=c[a>>2]|0}}else c[a>>2]=e;c[h>>2]=162;c[b>>2]=e+(i<<2);c[d>>2]=(c[a>>2]|0)+(g>>>2<<2);return}function er(b,d,e,f,g,h,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0;s=i;i=i+432|0;v=s+424|0;t=s+24|0;r=s+16|0;l=s+8|0;u=s+4|0;k=s+428|0;m=s;c[r>>2]=t;q=r+4|0;c[q>>2]=161;o=gm(g)|0;c[u>>2]=o;b=Om(u,1150132)|0;a[k>>0]=0;n=c[e>>2]|0;c[m>>2]=n;g=c[g+4>>2]|0;c[v>>2]=c[m>>2];m=n;if(br(d,v,f,u,g,h,k,b,r,l,t+400|0)|0){if(!(a[j>>0]&1))a[j>>0]=0;else c[c[j+8>>2]>>2]=0;c[j+4>>2]=0;if(a[k>>0]|0)Wk(j,Lb[c[(c[b>>2]|0)+44>>2]&63](b,45)|0);k=Lb[c[(c[b>>2]|0)+44>>2]&63](b,48)|0;f=c[l>>2]|0;g=f+-4|0;b=c[r>>2]|0;while(1){if(b>>>0>=g>>>0)break;if((c[b>>2]|0)!=(k|0))break;b=b+4|0}fr(j,b,f)|0}b=c[d>>2]|0;do if(b){g=c[b+12>>2]|0;if((g|0)==(c[b+16>>2]|0))b=Fb[c[(c[b>>2]|0)+36>>2]&127](b)|0;else b=c[g>>2]|0;if((b|0)==-1){c[d>>2]=0;g=1;break}else{g=(c[d>>2]|0)==0;break}}else g=1;while(0);do if(n){b=c[m+12>>2]|0;if((b|0)==(c[m+16>>2]|0))b=Fb[c[(c[n>>2]|0)+36>>2]&127](m)|0;else b=c[b>>2]|0;if((b|0)!=-1)if(g)break;else{p=27;break}else{c[e>>2]=0;p=25;break}}else p=25;while(0);if((p|0)==25?g:0)p=27;if((p|0)==27)c[h>>2]=c[h>>2]|2;g=c[d>>2]|0;du(o)|0;b=c[r>>2]|0;c[r>>2]=0;if(b|0)Bb[c[q>>2]&255](b);i=s;return g|0}function fr(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0;h=d;f=a[b>>0]|0;if(!(f&1)){k=(f&255)>>>1;g=1}else{f=c[b>>2]|0;k=c[b+4>>2]|0;g=(f&-2)+-1|0;f=f&255}j=e-h>>2;do if(j|0){if((g-k|0)>>>0<j>>>0){Vk(b,g,k+j-g|0,k,k,0,0);f=a[b>>0]|0}if(!(f&1))i=b+4|0;else i=c[b+8>>2]|0;h=k+((e-h|0)>>>2)|0;f=d;g=i+(k<<2)|0;while(1){if((f|0)==(e|0))break;c[g>>2]=c[f>>2];f=f+4|0;g=g+4|0}c[i+(h<<2)>>2]=0;f=k+j|0;if(!(a[b>>0]&1)){a[b>>0]=f<<1;break}else{c[b+4>>2]=f;break}}while(0);return b|0}function gr(a){a=a|0;return}function hr(a){a=a|0;mu(a);return}function ir(b,d,e,f,g,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;j=+j;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0;F=i;i=i+384|0;q=F+8|0;l=F;b=F+284|0;m=F+72|0;k=F+184|0;y=F+68|0;v=F+180|0;s=F+177|0;w=F+176|0;B=F+56|0;E=F+44|0;D=F+32|0;o=F+28|0;p=F+76|0;u=F+24|0;t=F+16|0;r=F+20|0;c[m>>2]=b;h[q>>3]=j;b=Nh(b,100,22799,q)|0;if(b>>>0>99){b=Ym()|0;h[l>>3]=j;b=oo(m,b,22799,l)|0;k=c[m>>2]|0;if(!k)Tu();l=zj(b)|0;if(!l)Tu();else{x=l;G=l;H=k;A=b}}else{x=k;G=0;H=0;A=b}b=gm(f)|0;c[y>>2]=b;n=Om(y,1150100)|0;l=c[m>>2]|0;Jb[c[(c[n>>2]|0)+32>>2]&7](n,l,l+A|0,x)|0;if(!A)m=0;else m=(a[c[m>>2]>>0]|0)==45;k=0;while(1){if((k|0)==3)break;c[B+(k<<2)>>2]=0;k=k+1|0}k=0;while(1){if((k|0)==3)break;c[E+(k<<2)>>2]=0;k=k+1|0}k=0;while(1){if((k|0)==3)break;c[D+(k<<2)>>2]=0;k=k+1|0}jr(e,m,y,v,s,w,B,E,D,o);l=c[o>>2]|0;if((A|0)>(l|0)){e=a[D>>0]|0;k=a[E>>0]|0;k=(A-l<<1|1)+l+((e&1)==0?(e&255)>>>1:c[D+4>>2]|0)+((k&1)==0?(k&255)>>>1:c[E+4>>2]|0)|0}else{e=a[D>>0]|0;k=a[E>>0]|0;k=l+2+((e&1)==0?(e&255)>>>1:c[D+4>>2]|0)+((k&1)==0?(k&255)>>>1:c[E+4>>2]|0)|0}if(k>>>0>100){k=zj(k)|0;if(!k)Tu();else{C=k;z=k}}else{C=0;z=p}kr(z,u,t,c[f+4>>2]|0,x,x+A|0,n,m,v,a[s>>0]|0,a[w>>0]|0,B,E,D,l);c[r>>2]=c[d>>2];d=c[u>>2]|0;k=c[t>>2]|0;c[q>>2]=c[r>>2];k=Vd(q,z,d,k,f,g)|0;if(C){Aj(C);b=c[y>>2]|0}vk(D);vk(E);vk(B);du(b)|0;if(G|0)Aj(G);if(H|0)Aj(H);i=F;return k|0}function jr(b,d,e,f,g,h,j,k,l,m){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;var n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0;A=i;i=i+112|0;o=A+108|0;s=A+96|0;p=A+92|0;t=A+80|0;x=A+68|0;z=A+56|0;q=A+52|0;u=A+40|0;r=A+36|0;v=A+24|0;w=A+12|0;y=A;if(b){n=Om(e,1151820)|0;b=c[n>>2]|0;if(d){Cb[c[b+44>>2]&63](o,n);y=c[o>>2]|0;a[f>>0]=y;a[f+1>>0]=y>>8;a[f+2>>0]=y>>16;a[f+3>>0]=y>>24;Cb[c[(c[n>>2]|0)+32>>2]&63](s,n);if(!(a[l>>0]&1)){a[l+1>>0]=0;a[l>>0]=0}else{a[c[l+8>>2]>>0]=0;c[l+4>>2]=0}zk(l,0);c[l>>2]=c[s>>2];c[l+4>>2]=c[s+4>>2];c[l+8>>2]=c[s+8>>2];b=0;while(1){if((b|0)==3)break;c[s+(b<<2)>>2]=0;b=b+1|0}vk(s);e=n}else{Cb[c[b+40>>2]&63](p,n);y=c[p>>2]|0;a[f>>0]=y;a[f+1>>0]=y>>8;a[f+2>>0]=y>>16;a[f+3>>0]=y>>24;Cb[c[(c[n>>2]|0)+28>>2]&63](t,n);if(!(a[l>>0]&1)){a[l+1>>0]=0;a[l>>0]=0}else{a[c[l+8>>2]>>0]=0;c[l+4>>2]=0}zk(l,0);c[l>>2]=c[t>>2];c[l+4>>2]=c[t+4>>2];c[l+8>>2]=c[t+8>>2];b=0;while(1){if((b|0)==3)break;c[t+(b<<2)>>2]=0;b=b+1|0}vk(t);e=n}a[g>>0]=Fb[c[(c[n>>2]|0)+12>>2]&127](n)|0;a[h>>0]=Fb[c[(c[n>>2]|0)+16>>2]&127](n)|0;Cb[c[(c[e>>2]|0)+20>>2]&63](x,n);if(!(a[j>>0]&1)){a[j+1>>0]=0;a[j>>0]=0}else{a[c[j+8>>2]>>0]=0;c[j+4>>2]=0}zk(j,0);c[j>>2]=c[x>>2];c[j+4>>2]=c[x+4>>2];c[j+8>>2]=c[x+8>>2];b=0;while(1){if((b|0)==3)break;c[x+(b<<2)>>2]=0;b=b+1|0}vk(x);Cb[c[(c[e>>2]|0)+24>>2]&63](z,n);if(!(a[k>>0]&1)){a[k+1>>0]=0;a[k>>0]=0}else{a[c[k+8>>2]>>0]=0;c[k+4>>2]=0}zk(k,0);c[k>>2]=c[z>>2];c[k+4>>2]=c[z+4>>2];c[k+8>>2]=c[z+8>>2];b=0;while(1){if((b|0)==3)break;c[z+(b<<2)>>2]=0;b=b+1|0}vk(z);b=Fb[c[(c[n>>2]|0)+36>>2]&127](n)|0}else{n=Om(e,1151812)|0;b=c[n>>2]|0;if(d){Cb[c[b+44>>2]&63](q,n);z=c[q>>2]|0;a[f>>0]=z;a[f+1>>0]=z>>8;a[f+2>>0]=z>>16;a[f+3>>0]=z>>24;Cb[c[(c[n>>2]|0)+32>>2]&63](u,n);if(!(a[l>>0]&1)){a[l+1>>0]=0;a[l>>0]=0}else{a[c[l+8>>2]>>0]=0;c[l+4>>2]=0}zk(l,0);c[l>>2]=c[u>>2];c[l+4>>2]=c[u+4>>2];c[l+8>>2]=c[u+8>>2];b=0;while(1){if((b|0)==3)break;c[u+(b<<2)>>2]=0;b=b+1|0}vk(u);e=n}else{Cb[c[b+40>>2]&63](r,n);z=c[r>>2]|0;a[f>>0]=z;a[f+1>>0]=z>>8;a[f+2>>0]=z>>16;a[f+3>>0]=z>>24;Cb[c[(c[n>>2]|0)+28>>2]&63](v,n);if(!(a[l>>0]&1)){a[l+1>>0]=0;a[l>>0]=0}else{a[c[l+8>>2]>>0]=0;c[l+4>>2]=0}zk(l,0);c[l>>2]=c[v>>2];c[l+4>>2]=c[v+4>>2];c[l+8>>2]=c[v+8>>2];b=0;while(1){if((b|0)==3)break;c[v+(b<<2)>>2]=0;b=b+1|0}vk(v);e=n}a[g>>0]=Fb[c[(c[n>>2]|0)+12>>2]&127](n)|0;a[h>>0]=Fb[c[(c[n>>2]|0)+16>>2]&127](n)|0;Cb[c[(c[e>>2]|0)+20>>2]&63](w,n);if(!(a[j>>0]&1)){a[j+1>>0]=0;a[j>>0]=0}else{a[c[j+8>>2]>>0]=0;c[j+4>>2]=0}zk(j,0);c[j>>2]=c[w>>2];c[j+4>>2]=c[w+4>>2];c[j+8>>2]=c[w+8>>2];b=0;while(1){if((b|0)==3)break;c[w+(b<<2)>>2]=0;b=b+1|0}vk(w);Cb[c[(c[e>>2]|0)+24>>2]&63](y,n);if(!(a[k>>0]&1)){a[k+1>>0]=0;a[k>>0]=0}else{a[c[k+8>>2]>>0]=0;c[k+4>>2]=0}zk(k,0);c[k>>2]=c[y>>2];c[k+4>>2]=c[y+4>>2];c[k+8>>2]=c[y+8>>2];b=0;while(1){if((b|0)==3)break;c[y+(b<<2)>>2]=0;b=b+1|0}vk(y);b=Fb[c[(c[n>>2]|0)+36>>2]&127](n)|0}c[m>>2]=b;i=A;return}function kr(d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;m=m|0;n=n|0;o=o|0;p=p|0;q=q|0;r=r|0;var s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0;c[f>>2]=d;H=q+4|0;I=q+8|0;J=q+1|0;B=p+4|0;C=(g&512|0)==0;D=p+8|0;E=p+1|0;F=j+8|0;G=(r|0)>0;y=o+4|0;z=o+8|0;A=o+1|0;x=0;while(1){if((x|0)==4)break;a:do switch(a[l+x>>0]|0){case 0:{c[e>>2]=c[f>>2];break}case 1:{c[e>>2]=c[f>>2];v=Lb[c[(c[j>>2]|0)+28>>2]&63](j,32)|0;w=c[f>>2]|0;c[f>>2]=w+1;a[w>>0]=v;break}case 3:{w=a[q>>0]|0;s=(w&1)==0;if((s?(w&255)>>>1:c[H>>2]|0)|0){v=a[(s?J:c[I>>2]|0)>>0]|0;w=c[f>>2]|0;c[f>>2]=w+1;a[w>>0]=v}break}case 2:{t=a[p>>0]|0;s=(t&1)==0;t=s?(t&255)>>>1:c[B>>2]|0;if(!(C|(t|0)==0)){w=s?E:c[D>>2]|0;u=w+t|0;s=c[f>>2]|0;t=w;while(1){if((t|0)==(u|0))break;a[s>>0]=a[t>>0]|0;s=s+1|0;t=t+1|0}c[f>>2]=s}break}case 4:{t=c[f>>2]|0;h=k?h+1|0:h;s=h;while(1){if(s>>>0>=i>>>0)break;u=a[s>>0]|0;if(u<<24>>24<=-1)break;if(!(b[(c[F>>2]|0)+(u<<24>>24<<1)>>1]&2048))break;s=s+1|0}if(G){v=r;while(1){u=(v|0)>0;if(!(s>>>0>h>>>0&u))break;w=s+-1|0;K=a[w>>0]|0;u=c[f>>2]|0;c[f>>2]=u+1;a[u>>0]=K;s=w;v=v+-1|0}if(u)w=Lb[c[(c[j>>2]|0)+28>>2]&63](j,48)|0;else w=0;while(1){u=c[f>>2]|0;c[f>>2]=u+1;if((v|0)<=0)break;a[u>>0]=w;v=v+-1|0}a[u>>0]=m}b:do if((s|0)==(h|0)){w=Lb[c[(c[j>>2]|0)+28>>2]&63](j,48)|0;K=c[f>>2]|0;c[f>>2]=K+1;a[K>>0]=w}else{K=a[o>>0]|0;u=(K&1)==0;if(!((u?(K&255)>>>1:c[y>>2]|0)|0)){u=-1;v=0;w=0}else{u=a[(u?A:c[z>>2]|0)>>0]|0;v=0;w=0}while(1){if((s|0)==(h|0))break b;if((w|0)==(u|0)){K=c[f>>2]|0;c[f>>2]=K+1;a[K>>0]=n;v=v+1|0;K=a[o>>0]|0;u=(K&1)==0;if(v>>>0<(u?(K&255)>>>1:c[y>>2]|0)>>>0){u=a[(u?A:c[z>>2]|0)+v>>0]|0;u=u<<24>>24==127?-1:u<<24>>24;w=0}else{u=w;w=0}}K=s+-1|0;M=a[K>>0]|0;L=c[f>>2]|0;c[f>>2]=L+1;a[L>>0]=M;s=K;w=w+1|0}}while(0);s=c[f>>2]|0;if((t|0)!=(s|0))while(1){s=s+-1|0;if(t>>>0>=s>>>0)break a;M=a[t>>0]|0;a[t>>0]=a[s>>0]|0;a[s>>0]=M;t=t+1|0}break}default:{}}while(0);x=x+1|0}h=a[q>>0]|0;s=(h&1)==0;h=s?(h&255)>>>1:c[H>>2]|0;if(h>>>0>1){s=s?J:c[I>>2]|0;t=s+h|0;h=c[f>>2]|0;while(1){s=s+1|0;if((s|0)==(t|0))break;a[h>>0]=a[s>>0]|0;h=h+1|0}c[f>>2]=h}switch(g&176|0){case 32:{c[e>>2]=c[f>>2];break}case 16:break;default:c[e>>2]=d}return}function lr(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0;D=i;i=i+176|0;p=D+56|0;x=D+52|0;v=D+164|0;s=D+161|0;w=D+160|0;z=D+40|0;C=D+28|0;B=D+16|0;m=D+12|0;o=D+60|0;u=D+8|0;t=D+4|0;q=D;b=gm(f)|0;c[x>>2]=b;r=Om(x,1150100)|0;n=a[h>>0]|0;j=(n&1)==0;k=h+4|0;if(!((j?(n&255)>>>1:c[k>>2]|0)|0))n=0;else{n=a[(j?h+1|0:c[h+8>>2]|0)>>0]|0;n=n<<24>>24==(Lb[c[(c[r>>2]|0)+28>>2]&63](r,45)|0)<<24>>24}j=0;while(1){if((j|0)==3)break;c[z+(j<<2)>>2]=0;j=j+1|0}j=0;while(1){if((j|0)==3)break;c[C+(j<<2)>>2]=0;j=j+1|0}j=0;while(1){if((j|0)==3)break;c[B+(j<<2)>>2]=0;j=j+1|0}jr(e,n,x,v,s,w,z,C,B,m);l=a[h>>0]|0;e=c[k>>2]|0;j=(l&1)==0?(l&255)>>>1:e;k=c[m>>2]|0;if((j|0)>(k|0)){E=a[B>>0]|0;m=a[C>>0]|0;j=(j-k<<1|1)+k+((E&1)==0?(E&255)>>>1:c[B+4>>2]|0)+((m&1)==0?(m&255)>>>1:c[C+4>>2]|0)|0}else{E=a[B>>0]|0;j=a[C>>0]|0;j=k+2+((E&1)==0?(E&255)>>>1:c[B+4>>2]|0)+((j&1)==0?(j&255)>>>1:c[C+4>>2]|0)|0}if(j>>>0>100){j=zj(j)|0;if(!j)Tu();else{A=j;y=j}}else{A=0;y=o}E=(l&1)==0;j=E?h+1|0:c[h+8>>2]|0;kr(y,u,t,c[f+4>>2]|0,j,j+(E?(l&255)>>>1:e)|0,r,n,v,a[s>>0]|0,a[w>>0]|0,z,C,B,k);c[q>>2]=c[d>>2];E=c[u>>2]|0;j=c[t>>2]|0;c[p>>2]=c[q>>2];j=Vd(p,y,E,j,f,g)|0;if(A){Aj(A);b=c[x>>2]|0}vk(B);vk(C);vk(z);du(b)|0;i=D;return j|0}function mr(a){a=a|0;return}function nr(a){a=a|0;mu(a);return}function or(b,d,e,f,g,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;j=+j;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0;F=i;i=i+1008|0;q=F+8|0;l=F;b=F+896|0;m=F+888|0;k=F+488|0;y=F+480|0;v=F+892|0;s=F+476|0;w=F+472|0;B=F+460|0;E=F+448|0;D=F+436|0;o=F+432|0;p=F+32|0;u=F+24|0;t=F+16|0;r=F+20|0;c[m>>2]=b;h[q>>3]=j;b=Nh(b,100,22799,q)|0;if(b>>>0>99){b=Ym()|0;h[l>>3]=j;b=oo(m,b,22799,l)|0;k=c[m>>2]|0;if(!k)Tu();l=zj(b<<2)|0;if(!l)Tu();else{x=l;G=l;H=k;A=b}}else{x=k;G=0;H=0;A=b}b=gm(f)|0;c[y>>2]=b;n=Om(y,1150132)|0;l=c[m>>2]|0;Jb[c[(c[n>>2]|0)+48>>2]&7](n,l,l+A|0,x)|0;if(!A)m=0;else m=(a[c[m>>2]>>0]|0)==45;k=0;while(1){if((k|0)==3)break;c[B+(k<<2)>>2]=0;k=k+1|0}k=0;while(1){if((k|0)==3)break;c[E+(k<<2)>>2]=0;k=k+1|0}k=0;while(1){if((k|0)==3)break;c[D+(k<<2)>>2]=0;k=k+1|0}pr(e,m,y,v,s,w,B,E,D,o);l=c[o>>2]|0;if((A|0)>(l|0)){e=a[D>>0]|0;k=a[E>>0]|0;k=(A-l<<1|1)+l+((e&1)==0?(e&255)>>>1:c[D+4>>2]|0)+((k&1)==0?(k&255)>>>1:c[E+4>>2]|0)|0}else{e=a[D>>0]|0;k=a[E>>0]|0;k=l+2+((e&1)==0?(e&255)>>>1:c[D+4>>2]|0)+((k&1)==0?(k&255)>>>1:c[E+4>>2]|0)|0}if(k>>>0>100){k=zj(k<<2)|0;if(!k)Tu();else{C=k;z=k}}else{C=0;z=p}qr(z,u,t,c[f+4>>2]|0,x,x+(A<<2)|0,n,m,v,c[s>>2]|0,c[w>>2]|0,B,E,D,l);c[r>>2]=c[d>>2];d=c[u>>2]|0;k=c[t>>2]|0;c[q>>2]=c[r>>2];k=xo(q,z,d,k,f,g)|0;if(C){Aj(C);b=c[y>>2]|0}Qk(D);Qk(E);vk(B);du(b)|0;if(G|0)Aj(G);if(H|0)Aj(H);i=F;return k|0}function pr(b,d,e,f,g,h,j,k,l,m){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;var n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0;z=i;i=i+112|0;n=z+108|0;r=z+96|0;o=z+92|0;s=z+80|0;w=z+68|0;y=z+56|0;p=z+52|0;t=z+40|0;q=z+36|0;u=z+24|0;v=z+12|0;x=z;if(b){e=Om(e,1151836)|0;b=c[e>>2]|0;if(d){Cb[c[b+44>>2]&63](n,e);x=c[n>>2]|0;a[f>>0]=x;a[f+1>>0]=x>>8;a[f+2>>0]=x>>16;a[f+3>>0]=x>>24;Cb[c[(c[e>>2]|0)+32>>2]&63](r,e);if(!(a[l>>0]&1))a[l>>0]=0;else c[c[l+8>>2]>>2]=0;c[l+4>>2]=0;Tk(l,0);c[l>>2]=c[r>>2];c[l+4>>2]=c[r+4>>2];c[l+8>>2]=c[r+8>>2];b=0;while(1){if((b|0)==3)break;c[r+(b<<2)>>2]=0;b=b+1|0}Qk(r)}else{Cb[c[b+40>>2]&63](o,e);x=c[o>>2]|0;a[f>>0]=x;a[f+1>>0]=x>>8;a[f+2>>0]=x>>16;a[f+3>>0]=x>>24;Cb[c[(c[e>>2]|0)+28>>2]&63](s,e);if(!(a[l>>0]&1))a[l>>0]=0;else c[c[l+8>>2]>>2]=0;c[l+4>>2]=0;Tk(l,0);c[l>>2]=c[s>>2];c[l+4>>2]=c[s+4>>2];c[l+8>>2]=c[s+8>>2];b=0;while(1){if((b|0)==3)break;c[s+(b<<2)>>2]=0;b=b+1|0}Qk(s)}c[g>>2]=Fb[c[(c[e>>2]|0)+12>>2]&127](e)|0;c[h>>2]=Fb[c[(c[e>>2]|0)+16>>2]&127](e)|0;Cb[c[(c[e>>2]|0)+20>>2]&63](w,e);if(!(a[j>>0]&1)){a[j+1>>0]=0;a[j>>0]=0}else{a[c[j+8>>2]>>0]=0;c[j+4>>2]=0}zk(j,0);c[j>>2]=c[w>>2];c[j+4>>2]=c[w+4>>2];c[j+8>>2]=c[w+8>>2];b=0;while(1){if((b|0)==3)break;c[w+(b<<2)>>2]=0;b=b+1|0}vk(w);Cb[c[(c[e>>2]|0)+24>>2]&63](y,e);if(!(a[k>>0]&1))a[k>>0]=0;else c[c[k+8>>2]>>2]=0;c[k+4>>2]=0;Tk(k,0);c[k>>2]=c[y>>2];c[k+4>>2]=c[y+4>>2];c[k+8>>2]=c[y+8>>2];b=0;while(1){if((b|0)==3)break;c[y+(b<<2)>>2]=0;b=b+1|0}Qk(y);b=Fb[c[(c[e>>2]|0)+36>>2]&127](e)|0}else{e=Om(e,1151828)|0;b=c[e>>2]|0;if(d){Cb[c[b+44>>2]&63](p,e);y=c[p>>2]|0;a[f>>0]=y;a[f+1>>0]=y>>8;a[f+2>>0]=y>>16;a[f+3>>0]=y>>24;Cb[c[(c[e>>2]|0)+32>>2]&63](t,e);if(!(a[l>>0]&1))a[l>>0]=0;else c[c[l+8>>2]>>2]=0;c[l+4>>2]=0;Tk(l,0);c[l>>2]=c[t>>2];c[l+4>>2]=c[t+4>>2];c[l+8>>2]=c[t+8>>2];b=0;while(1){if((b|0)==3)break;c[t+(b<<2)>>2]=0;b=b+1|0}Qk(t)}else{Cb[c[b+40>>2]&63](q,e);y=c[q>>2]|0;a[f>>0]=y;a[f+1>>0]=y>>8;a[f+2>>0]=y>>16;a[f+3>>0]=y>>24;Cb[c[(c[e>>2]|0)+28>>2]&63](u,e);if(!(a[l>>0]&1))a[l>>0]=0;else c[c[l+8>>2]>>2]=0;c[l+4>>2]=0;Tk(l,0);c[l>>2]=c[u>>2];c[l+4>>2]=c[u+4>>2];c[l+8>>2]=c[u+8>>2];b=0;while(1){if((b|0)==3)break;c[u+(b<<2)>>2]=0;b=b+1|0}Qk(u)}c[g>>2]=Fb[c[(c[e>>2]|0)+12>>2]&127](e)|0;c[h>>2]=Fb[c[(c[e>>2]|0)+16>>2]&127](e)|0;Cb[c[(c[e>>2]|0)+20>>2]&63](v,e);if(!(a[j>>0]&1)){a[j+1>>0]=0;a[j>>0]=0}else{a[c[j+8>>2]>>0]=0;c[j+4>>2]=0}zk(j,0);c[j>>2]=c[v>>2];c[j+4>>2]=c[v+4>>2];c[j+8>>2]=c[v+8>>2];b=0;while(1){if((b|0)==3)break;c[v+(b<<2)>>2]=0;b=b+1|0}vk(v);Cb[c[(c[e>>2]|0)+24>>2]&63](x,e);if(!(a[k>>0]&1))a[k>>0]=0;else c[c[k+8>>2]>>2]=0;c[k+4>>2]=0;Tk(k,0);c[k>>2]=c[x>>2];c[k+4>>2]=c[x+4>>2];c[k+8>>2]=c[x+8>>2];b=0;while(1){if((b|0)==3)break;c[x+(b<<2)>>2]=0;b=b+1|0}Qk(x);b=Fb[c[(c[e>>2]|0)+36>>2]&127](e)|0}c[m>>2]=b;i=z;return}function qr(b,d,e,f,g,h,i,j,k,l,m,n,o,p,q){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;m=m|0;n=n|0;o=o|0;p=p|0;q=q|0;var r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0;c[e>>2]=b;H=p+4|0;I=p+8|0;A=o+4|0;B=(f&512|0)==0;C=o+8|0;D=(q|0)>0;E=n+4|0;F=n+8|0;G=n+1|0;z=0;while(1){if((z|0)==4)break;a:do switch(a[k+z>>0]|0){case 0:{c[d>>2]=c[e>>2];break}case 1:{c[d>>2]=c[e>>2];x=Lb[c[(c[i>>2]|0)+44>>2]&63](i,32)|0;y=c[e>>2]|0;c[e>>2]=y+4;c[y>>2]=x;break}case 3:{y=a[p>>0]|0;r=(y&1)==0;if((r?(y&255)>>>1:c[H>>2]|0)|0){x=c[(r?H:c[I>>2]|0)>>2]|0;y=c[e>>2]|0;c[e>>2]=y+4;c[y>>2]=x}break}case 2:{v=a[o>>0]|0;r=(v&1)==0;v=r?(v&255)>>>1:c[A>>2]|0;if(!(B|(v|0)==0)){u=r?A:c[C>>2]|0;s=u+(v<<2)|0;t=c[e>>2]|0;r=t;while(1){if((u|0)==(s|0))break;c[r>>2]=c[u>>2];r=r+4|0;u=u+4|0}c[e>>2]=t+(v<<2)}break}case 4:{s=c[e>>2]|0;g=j?g+4|0:g;r=g;while(1){if(r>>>0>=h>>>0)break;if(!(yb[c[(c[i>>2]|0)+12>>2]&31](i,2048,c[r>>2]|0)|0))break;r=r+4|0}if(D){v=q;while(1){t=(v|0)>0;if(!(r>>>0>g>>>0&t))break;y=r+-4|0;w=c[y>>2]|0;x=c[e>>2]|0;c[e>>2]=x+4;c[x>>2]=w;r=y;v=v+-1|0}if(t)w=Lb[c[(c[i>>2]|0)+44>>2]&63](i,48)|0;else w=0;u=c[e>>2]|0;while(1){t=u+4|0;if((v|0)<=0)break;c[u>>2]=w;u=t;v=v+-1|0}c[e>>2]=t;c[u>>2]=l}if((r|0)==(g|0)){x=Lb[c[(c[i>>2]|0)+44>>2]&63](i,48)|0;y=c[e>>2]|0;r=y+4|0;c[e>>2]=r;c[y>>2]=x}else{x=a[n>>0]|0;t=(x&1)==0;y=c[E>>2]|0;if(!((t?(x&255)>>>1:y)|0)){w=-1;v=0;x=0}else{w=a[(t?G:c[F>>2]|0)>>0]|0;v=0;x=0}while(1){if((r|0)==(g|0))break;t=c[e>>2]|0;if((x|0)==(w|0)){u=t+4|0;c[e>>2]=u;c[t>>2]=m;v=v+1|0;w=a[n>>0]|0;t=(w&1)==0;if(v>>>0<(t?(w&255)>>>1:y)>>>0){w=a[(t?G:c[F>>2]|0)+v>>0]|0;t=u;w=w<<24>>24==127?-1:w<<24>>24;u=0}else{t=u;w=x;u=0}}else u=x;x=r+-4|0;J=c[x>>2]|0;c[e>>2]=t+4;c[t>>2]=J;r=x;x=u+1|0}r=c[e>>2]|0}if((s|0)!=(r|0))while(1){r=r+-4|0;if(s>>>0>=r>>>0)break a;J=c[s>>2]|0;c[s>>2]=c[r>>2];c[r>>2]=J;s=s+4|0}break}default:{}}while(0);z=z+1|0}r=a[p>>0]|0;g=(r&1)==0;r=g?(r&255)>>>1:c[H>>2]|0;if(r>>>0>1){s=g?H:c[I>>2]|0;u=s+4|0;r=s+(r<<2)|0;s=c[e>>2]|0;t=r-u|0;g=s;while(1){if((u|0)==(r|0))break;c[g>>2]=c[u>>2];g=g+4|0;u=u+4|0}c[e>>2]=s+(t>>>2<<2)}switch(f&176|0){case 32:{c[d>>2]=c[e>>2];break}case 16:break;default:c[d>>2]=b}return}function rr(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0;E=i;i=i+480|0;p=E+468|0;y=E+464|0;w=E+472|0;t=E+460|0;x=E+456|0;A=E+444|0;D=E+432|0;C=E+420|0;m=E+416|0;o=E+16|0;v=E+8|0;u=E+4|0;q=E;b=gm(f)|0;c[y>>2]=b;r=Om(y,1150132)|0;n=a[h>>0]|0;j=(n&1)==0;s=h+4|0;if(!((j?(n&255)>>>1:c[s>>2]|0)|0))n=0;else{n=c[(j?s:c[h+8>>2]|0)>>2]|0;n=(n|0)==(Lb[c[(c[r>>2]|0)+44>>2]&63](r,45)|0)}j=0;while(1){if((j|0)==3)break;c[A+(j<<2)>>2]=0;j=j+1|0}j=0;while(1){if((j|0)==3)break;c[D+(j<<2)>>2]=0;j=j+1|0}j=0;while(1){if((j|0)==3)break;c[C+(j<<2)>>2]=0;j=j+1|0}pr(e,n,y,w,t,x,A,D,C,m);k=a[h>>0]|0;l=c[s>>2]|0;j=(k&1)==0?(k&255)>>>1:l;e=c[m>>2]|0;if((j|0)>(e|0)){F=a[C>>0]|0;m=a[D>>0]|0;j=(j-e<<1|1)+e+((F&1)==0?(F&255)>>>1:c[C+4>>2]|0)+((m&1)==0?(m&255)>>>1:c[D+4>>2]|0)|0}else{F=a[C>>0]|0;j=a[D>>0]|0;j=e+2+((F&1)==0?(F&255)>>>1:c[C+4>>2]|0)+((j&1)==0?(j&255)>>>1:c[D+4>>2]|0)|0}if(j>>>0>100){j=zj(j<<2)|0;if(!j)Tu();else{B=j;z=j}}else{B=0;z=o}F=(k&1)==0;j=F?s:c[h+8>>2]|0;qr(z,v,u,c[f+4>>2]|0,j,j+((F?(k&255)>>>1:l)<<2)|0,r,n,w,c[t>>2]|0,c[x>>2]|0,A,D,C,e);c[q>>2]=c[d>>2];F=c[v>>2]|0;j=c[u>>2]|0;c[p>>2]=c[q>>2];j=xo(p,z,F,j,f,g)|0;if(B){Aj(B);b=c[y>>2]|0}Qk(C);Qk(D);vk(A);du(b)|0;i=E;return j|0}function sr(a){a=a|0;return}function tr(a){a=a|0;mu(a);return}function ur(b,d,e){b=b|0;d=d|0;e=e|0;b=ij((a[d>>0]&1)==0?d+1|0:c[d+8>>2]|0,1)|0;return b>>>((b|0)!=(-1|0)&1)|0}function vr(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0;k=i;i=i+16|0;j=k;d=0;while(1){if((d|0)==3)break;c[j+(d<<2)>>2]=0;d=d+1|0}l=a[h>>0]|0;m=(l&1)==0;d=m?h+1|0:c[h+8>>2]|0;h=d+(m?(l&255)>>>1:c[h+4>>2]|0)|0;while(1){if(d>>>0>=h>>>0)break;Gk(j,a[d>>0]|0);d=d+1|0}d=jj((e|0)==-1?-1:e<<1,f,g,(a[j>>0]&1)==0?j+1|0:c[j+8>>2]|0)|0;h=0;while(1){if((h|0)==3)break;c[b+(h<<2)>>2]=0;h=h+1|0}h=d+(Mh(d)|0)|0;while(1){if(d>>>0>=h>>>0)break;Gk(b,a[d>>0]|0);d=d+1|0}vk(j);i=k;return}function wr(a,b){a=a|0;b=b|0;return}function xr(a){a=a|0;return}function yr(a){a=a|0;mu(a);return}function zr(b,d,e){b=b|0;d=d|0;e=e|0;b=ij((a[d>>0]&1)==0?d+1|0:c[d+8>>2]|0,1)|0;return b>>>((b|0)!=(-1|0)&1)|0}function Ar(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;t=i;i=i+176|0;q=t+168|0;p=t+40|0;o=t+36|0;s=t+32|0;r=t;m=t+24|0;n=t+16|0;d=0;while(1){if((d|0)==3)break;c[r+(d<<2)>>2]=0;d=d+1|0}c[m+4>>2]=0;c[m>>2]=14532;l=a[h>>0]|0;d=(l&1)==0;k=h+4|0;h=d?k:c[h+8>>2]|0;k=h+((d?(l&255)>>>1:c[k>>2]|0)<<2)|0;l=p+32|0;d=0;while(1){if(!((d|0)!=2&h>>>0<k>>>0))break;c[s>>2]=h;j=Ib[c[(c[m>>2]|0)+12>>2]&15](m,q,h,k,s,p,l,o)|0;d=p;while(1){if(d>>>0>=(c[o>>2]|0)>>>0)break;Gk(r,a[d>>0]|0);d=d+1|0}h=c[s>>2]|0;d=j}h=jj((e|0)==-1?-1:e<<1,f,g,(a[r>>0]&1)==0?r+1|0:c[r+8>>2]|0)|0;d=0;while(1){if((d|0)==3)break;c[b+(d<<2)>>2]=0;d=d+1|0}c[n+4>>2]=0;c[n>>2]=14580;k=h+(Mh(h)|0)|0;l=k;m=p+128|0;d=0;while(1){if(!((d|0)!=2&h>>>0<k>>>0))break;c[s>>2]=h;j=Ib[c[(c[n>>2]|0)+16>>2]&15](n,q,h,(l-h|0)>32?h+32|0:k,s,p,m,o)|0;d=p;while(1){if(d>>>0>=(c[o>>2]|0)>>>0)break;Wk(b,c[d>>2]|0);d=d+4|0}h=c[s>>2]|0;d=j}vk(r);i=t;return}function Br(a){a=a|0;return}function Cr(a){a=a|0;mu(a);return}function Dr(a,b,d,e,f,g,h,j){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0;a=i;i=i+16|0;k=a+4|0;b=a;c[k>>2]=d;c[b>>2]=g;h=Er(d,e,k,g,h,b,1114111,0)|0;c[f>>2]=c[k>>2];c[j>>2]=c[b>>2];i=a;return h|0}function Er(b,d,e,f,g,h,i,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;var k=0,l=0;c[e>>2]=b;c[h>>2]=f;l=g;if(j&2)if((l-f|0)<3)b=1;else{c[h>>2]=f+1;a[f>>0]=-17;k=c[h>>2]|0;c[h>>2]=k+1;a[k>>0]=-69;k=c[h>>2]|0;c[h>>2]=k+1;a[k>>0]=-65;k=4}else k=4;a:do if((k|0)==4){b=c[e>>2]|0;while(1){if(b>>>0>=d>>>0){b=0;break a}j=c[b>>2]|0;if(j>>>0>i>>>0|(j&-2048|0)==55296){b=2;break a}do if(j>>>0>=128){if(j>>>0<2048){b=c[h>>2]|0;if((l-b|0)<2){b=1;break a}c[h>>2]=b+1;a[b>>0]=j>>>6|192;k=c[h>>2]|0;c[h>>2]=k+1;a[k>>0]=j&63|128;break}b=c[h>>2]|0;g=l-b|0;if(j>>>0<65536){if((g|0)<3){b=1;break a}c[h>>2]=b+1;a[b>>0]=j>>>12|224;k=c[h>>2]|0;c[h>>2]=k+1;a[k>>0]=j>>>6&63|128;k=c[h>>2]|0;c[h>>2]=k+1;a[k>>0]=j&63|128;break}else{if((g|0)<4){b=1;break a}c[h>>2]=b+1;a[b>>0]=j>>>18|240;k=c[h>>2]|0;c[h>>2]=k+1;a[k>>0]=j>>>12&63|128;k=c[h>>2]|0;c[h>>2]=k+1;a[k>>0]=j>>>6&63|128;k=c[h>>2]|0;c[h>>2]=k+1;a[k>>0]=j&63|128;break}}else{b=c[h>>2]|0;if((l-b|0)<1){b=1;break a}c[h>>2]=b+1;a[b>>0]=j}while(0);b=(c[e>>2]|0)+4|0;c[e>>2]=b}}while(0);return b|0}function Fr(a,b,d,e,f,g,h,j){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0;a=i;i=i+16|0;k=a+4|0;b=a;c[k>>2]=d;c[b>>2]=g;h=Gr(d,e,k,g,h,b,1114111,0)|0;c[f>>2]=c[k>>2];c[j>>2]=c[b>>2];i=a;return h|0}function Gr(b,e,f,g,h,i,j,k){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0;c[f>>2]=b;c[i>>2]=g;if(k&4){b=c[f>>2]|0;k=e;if((((k-b|0)>2?(a[b>>0]|0)==-17:0)?(a[b+1>>0]|0)==-69:0)?(a[b+2>>0]|0)==-65:0)c[f>>2]=b+3}else k=e;a:while(1){o=c[f>>2]|0;b=o>>>0<e>>>0;if(!b){q=40;break}p=c[i>>2]|0;if(p>>>0>=h>>>0){q=40;break}b=a[o>>0]|0;n=b&255;do if(b<<24>>24>-1){if(n>>>0>j>>>0){b=2;break a}c[p>>2]=n;c[f>>2]=o+1}else{if((b&255)<194){b=2;break a}if((b&255)<224){if((k-o|0)<2){b=1;break a}b=d[o+1>>0]|0;if((b&192|0)!=128){b=2;break a}b=b&63|n<<6&1984;if(b>>>0>j>>>0){b=2;break a}c[p>>2]=b;c[f>>2]=o+2;break}if((b&255)<240){if((k-o|0)<3){b=1;break a}g=a[o+1>>0]|0;b=a[o+2>>0]|0;switch(n|0){case 224:{if((g&-32)<<24>>24!=-96){b=2;break a}break}case 237:{if((g&-32)<<24>>24!=-128){b=2;break a}break}default:if((g&-64)<<24>>24!=-128){b=2;break a}}b=b&255;if((b&192|0)!=128){b=2;break a}b=(g&255)<<6&4032|n<<12&61440|b&63;if(b>>>0>j>>>0){b=2;break a}c[p>>2]=b;c[f>>2]=o+3;break}if((b&255)>=245){b=2;break a}if((k-o|0)<4){b=1;break a}m=a[o+1>>0]|0;b=a[o+2>>0]|0;g=a[o+3>>0]|0;switch(n|0){case 240:{if((m+112&255)>=48){b=2;break a}break}case 244:{if((m&-16)<<24>>24!=-128){b=2;break a}break}default:if((m&-64)<<24>>24!=-128){b=2;break a}}l=b&255;if((l&192|0)!=128){b=2;break a}b=g&255;if((b&192|0)!=128){b=2;break a}b=(m&255)<<12&258048|n<<18&1835008|l<<6&4032|b&63;if(b>>>0>j>>>0){b=2;break a}c[p>>2]=b;c[f>>2]=o+4}while(0);c[i>>2]=(c[i>>2]|0)+4}if((q|0)==40)b=b&1;return b|0}function Hr(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;c[f>>2]=d;return 3}function Ir(a){a=a|0;return 0}function Jr(a){a=a|0;return 0}function Kr(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return Lr(c,d,e,1114111,0)|0}function Lr(b,c,e,f,g){b=b|0;c=c|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0;n=c;if((((g&4|0)!=0?(n-b|0)>2:0)?(a[b>>0]|0)==-17:0)?(a[b+1>>0]|0)==-69:0){l=(a[b+2>>0]|0)==-65?b+3|0:b;m=0}else{l=b;m=0}a:while(1){if(!(m>>>0<e>>>0&l>>>0<c>>>0)){g=l;h=40;break}g=a[l>>0]|0;k=g&255;do if(g<<24>>24<=-1){if((g&255)<194){g=l;h=40;break a}if((g&255)<224){if((n-l|0)<2){g=l;h=40;break a}g=d[l+1>>0]|0;if((g&192|0)!=128){g=l;h=40;break a}if((g&63|k<<6&1984)>>>0>f>>>0){g=l;h=40;break a}g=l+2|0;break}if((g&255)<240){g=l;if((n-g|0)<3){g=l;h=40;break a}i=a[l+1>>0]|0;h=a[l+2>>0]|0;switch(k|0){case 224:{if((i&-32)<<24>>24!=-96){h=20;break a}break}case 237:{if((i&-32)<<24>>24!=-128){h=22;break a}break}default:if((i&-64)<<24>>24!=-128){h=24;break a}}g=h&255;if((g&192|0)!=128){g=l;h=40;break a}if(((i&255)<<6&4032|k<<12&61440|g&63)>>>0>f>>>0){g=l;h=40;break a}else{g=l+3|0;break}}if((g&255)>=245){g=l;h=40;break a}g=l;if((n-g|0)<4){g=l;h=40;break a}j=a[l+1>>0]|0;h=a[l+2>>0]|0;i=a[l+3>>0]|0;switch(k|0){case 240:{if((j+112&255)>=48){h=31;break a}break}case 244:{if((j&-16)<<24>>24!=-128){h=33;break a}break}default:if((j&-64)<<24>>24!=-128){h=35;break a}}h=h&255;if((h&192|0)!=128){g=l;h=40;break a}g=i&255;if((g&192|0)!=128){g=l;h=40;break a}if(((j&255)<<12&258048|k<<18&1835008|h<<6&4032|g&63)>>>0>f>>>0){g=l;h=40;break a}else g=l+4|0}else{if(k>>>0>f>>>0){g=l;h=40;break a}g=l+1|0}while(0);l=g;m=m+1|0}if((h|0)==20)g=g-b|0;else if((h|0)==22)g=g-b|0;else if((h|0)==24)g=g-b|0;else if((h|0)==31)g=g-b|0;else if((h|0)==33)g=g-b|0;else if((h|0)==35)g=g-b|0;else if((h|0)==40)g=g-b|0;return g|0}function Mr(a){a=a|0;return 4}function Nr(a){a=a|0;mu(a);return}function Or(a,b){a=a|0;b=b|0;return}function Pr(a,b,d,e,f,g,h,i){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;c[f>>2]=d;c[i>>2]=g;return 3}function Qr(a,b,d,e,f,g,h,i){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;c[f>>2]=d;c[i>>2]=g;return 3}function Rr(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;c[f>>2]=d;return 3}function Sr(a){a=a|0;return 1}function Tr(a){a=a|0;return 1}function Ur(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;a=d-c|0;return (a>>>0<e>>>0?a:e)|0}function Vr(a){a=a|0;return 1}function Wr(a){a=a|0;var b=0;c[a>>2]=14628;a=a+8|0;b=c[a>>2]|0;if((b|0)!=(Ym()|0))kj(c[a>>2]|0);return}function Xr(a){a=a|0;Wr(a);mu(a);return}function Yr(b,d,e,f,g,h,j,k){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;r=i;i=i+16|0;q=r;o=r+8|0;l=e;while(1){if((l|0)==(f|0)){l=f;break}if(!(c[l>>2]|0))break;l=l+4|0}c[k>>2]=h;c[g>>2]=e;n=j;p=b+8|0;a:while(1){if((h|0)==(j|0)|(e|0)==(f|0)){l=35;break}s=d;m=c[s+4>>2]|0;b=q;c[b>>2]=c[s>>2];c[b+4>>2]=m;b=hj(c[p>>2]|0)|0;m=_i(h,g,l-e>>2,n-h|0,d)|0;if(b|0)hj(b)|0;switch(m|0){case -1:{l=10;break a}case 0:{e=1;l=32;break a}default:{}}h=(c[k>>2]|0)+m|0;c[k>>2]=h;if((h|0)==(j|0)){l=33;break}if((l|0)==(f|0)){e=c[g>>2]|0;l=f}else{e=hj(c[p>>2]|0)|0;h=_h(o,0,d)|0;if(e|0)hj(e)|0;if((h|0)==-1){e=2;l=31;break}if(h>>>0>(n-(c[k>>2]|0)|0)>>>0){e=1;l=31;break}else e=o;while(1){if(!h)break;m=a[e>>0]|0;s=c[k>>2]|0;c[k>>2]=s+1;a[s>>0]=m;h=h+-1|0;e=e+1|0}e=(c[g>>2]|0)+4|0;c[g>>2]=e;l=e;while(1){if((l|0)==(f|0)){l=f;break}if(!(c[l>>2]|0))break;l=l+4|0}h=c[k>>2]|0}}if((l|0)==10){c[k>>2]=h;while(1){if((e|0)==(c[g>>2]|0))break;s=c[e>>2]|0;l=hj(c[p>>2]|0)|0;h=_h(h,s,q)|0;if(l|0)hj(l)|0;if((h|0)==-1)break;h=(c[k>>2]|0)+h|0;c[k>>2]=h;e=e+4|0}c[g>>2]=e;e=2;l=32}else if((l|0)==31)l=32;else if((l|0)==33){e=c[g>>2]|0;l=35}if((l|0)!=32)if((l|0)==35)e=(e|0)!=(f|0)&1;i=r;return e|0}function Zr(b,d,e,f,g,h,j,k){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0,r=0;r=i;i=i+16|0;q=r;l=e;while(1){if((l|0)==(f|0)){l=f;break}if(!(a[l>>0]|0))break;l=l+1|0}c[k>>2]=h;c[g>>2]=e;o=j;p=b+8|0;a:while(1){if((h|0)==(j|0)|(e|0)==(f|0)){l=34;break}n=d;m=c[n+4>>2]|0;b=q;c[b>>2]=c[n>>2];c[b+4>>2]=m;b=l;m=hj(c[p>>2]|0)|0;n=Wi(h,g,b-e|0,o-h>>2,d)|0;if(m|0)hj(m)|0;switch(n|0){case -1:{l=10;break a}case 0:{e=2;l=30;break a}default:{}}h=(c[k>>2]|0)+(n<<2)|0;c[k>>2]=h;if((h|0)==(j|0)){l=31;break}e=c[g>>2]|0;if((l|0)==(f|0))l=f;else{l=hj(c[p>>2]|0)|0;e=pi(h,e,1,d)|0;if(l|0)hj(l)|0;if(e|0){e=2;l=30;break}c[k>>2]=(c[k>>2]|0)+4;e=(c[g>>2]|0)+1|0;c[g>>2]=e;l=e;while(1){if((l|0)==(f|0)){l=f;break}if(!(a[l>>0]|0))break;l=l+1|0}h=c[k>>2]|0}}do if((l|0)==10){b:while(1){c[k>>2]=h;if((e|0)==(c[g>>2]|0)){l=20;break}l=hj(c[p>>2]|0)|0;h=pi(h,e,b-e|0,q)|0;if(l|0)hj(l)|0;switch(h|0){case -1:{l=16;break b}case -2:{l=17;break b}case 0:{e=e+1|0;break}default:e=e+h|0}h=(c[k>>2]|0)+4|0}if((l|0)==16){c[g>>2]=e;e=2;l=30;break}else if((l|0)==17){c[g>>2]=e;e=1;l=30;break}else if((l|0)==20){c[g>>2]=e;e=(e|0)!=(f|0)&1;l=30;break}}else if((l|0)==31){e=c[g>>2]|0;l=34}while(0);if((l|0)!=30)if((l|0)==34)e=(e|0)!=(f|0)&1;i=r;return e|0}function _r(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0;j=i;i=i+16|0;h=j;c[g>>2]=e;e=hj(c[b+8>>2]|0)|0;b=_h(h,0,d)|0;if(e|0)hj(e)|0;a:do switch(b|0){case 0:case -1:{h=2;break}default:{b=b+-1|0;if(b>>>0>(f-(c[g>>2]|0)|0)>>>0)h=1;else while(1){if(!b){h=0;break a}d=a[h>>0]|0;f=c[g>>2]|0;c[g>>2]=f+1;a[f>>0]=d;b=b+-1|0;h=h+1|0}}}while(0);i=j;return h|0}function $r(a){a=a|0;var b=0,d=0;a=a+8|0;b=hj(c[a>>2]|0)|0;d=ei(0,0,4)|0;if(b|0)hj(b)|0;if(!d){a=c[a>>2]|0;if(a){a=hj(a)|0;if(!a)a=0;else{hj(a)|0;a=0}}else a=1}else a=-1;return a|0}function as(a){a=a|0;return 0}function bs(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0;k=e;j=a+8|0;a=0;i=0;a:while(1){if((d|0)==(e|0)|i>>>0>=f>>>0)break;h=hj(c[j>>2]|0)|0;g=Zi(d,k-d|0,b)|0;if(h|0)hj(h)|0;switch(g|0){case -2:case -1:break a;case 0:{d=d+1|0;g=1;break}default:d=d+g|0}a=g+a|0;i=i+1|0}return a|0}function cs(a){a=a|0;a=c[a+8>>2]|0;if(a){a=hj(a)|0;if(!a)a=4;else{hj(a)|0;a=4}}else a=1;return a|0}function ds(a,b,d,e,f,g,h,j){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0;a=i;i=i+16|0;k=a+4|0;b=a;c[k>>2]=d;c[b>>2]=g;h=es(d,e,k,g,h,b,1114111,0)|0;c[f>>2]=c[k>>2];c[j>>2]=c[b>>2];i=a;return h|0}function es(d,f,g,h,i,j,k,l){d=d|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;var m=0,n=0;c[g>>2]=d;c[j>>2]=h;if(l&2)if((i-h|0)<3)d=1;else{c[j>>2]=h+1;a[h>>0]=-17;m=c[j>>2]|0;c[j>>2]=m+1;a[m>>0]=-69;m=c[j>>2]|0;c[j>>2]=m+1;a[m>>0]=-65;m=4}else m=4;a:do if((m|0)==4){n=f;d=c[g>>2]|0;while(1){if(d>>>0>=f>>>0){d=0;break a}l=b[d>>1]|0;m=l&65535;if(m>>>0>k>>>0){d=2;break a}do if((l&65535)<128){d=c[j>>2]|0;if((i-d|0)<1){d=1;break a}c[j>>2]=d+1;a[d>>0]=l}else{if((l&65535)<2048){d=c[j>>2]|0;if((i-d|0)<2){d=1;break a}c[j>>2]=d+1;a[d>>0]=m>>>6|192;h=c[j>>2]|0;c[j>>2]=h+1;a[h>>0]=m&63|128;break}if((l&65535)<55296){d=c[j>>2]|0;if((i-d|0)<3){d=1;break a}c[j>>2]=d+1;a[d>>0]=m>>>12|224;h=c[j>>2]|0;c[j>>2]=h+1;a[h>>0]=m>>>6&63|128;h=c[j>>2]|0;c[j>>2]=h+1;a[h>>0]=m&63|128;break}if((l&65535)>=56320){if((l&65535)<57344){d=2;break a}d=c[j>>2]|0;if((i-d|0)<3){d=1;break a}c[j>>2]=d+1;a[d>>0]=m>>>12|224;h=c[j>>2]|0;c[j>>2]=h+1;a[h>>0]=m>>>6&63|128;h=c[j>>2]|0;c[j>>2]=h+1;a[h>>0]=m&63|128;break}if((n-d|0)<4){d=1;break a}d=d+2|0;l=e[d>>1]|0;if((l&64512|0)!=56320){d=2;break a}if((i-(c[j>>2]|0)|0)<4){d=1;break a}h=m&960;if(((h<<10)+65536|m<<10&64512|l&1023)>>>0>k>>>0){d=2;break a}c[g>>2]=d;d=(h>>>6)+1|0;h=c[j>>2]|0;c[j>>2]=h+1;a[h>>0]=d>>>2|240;h=c[j>>2]|0;c[j>>2]=h+1;a[h>>0]=m>>>2&15|d<<4&48|128;h=c[j>>2]|0;c[j>>2]=h+1;a[h>>0]=m<<4&48|l>>>6&15|128;m=c[j>>2]|0;c[j>>2]=m+1;a[m>>0]=l&63|128}while(0);d=(c[g>>2]|0)+2|0;c[g>>2]=d}}while(0);return d|0}function fs(a,b,d,e,f,g,h,j){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0;a=i;i=i+16|0;k=a+4|0;b=a;c[k>>2]=d;c[b>>2]=g;h=gs(d,e,k,g,h,b,1114111,0)|0;c[f>>2]=c[k>>2];c[j>>2]=c[b>>2];i=a;return h|0}function gs(e,f,g,h,i,j,k,l){e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;var m=0,n=0,o=0,p=0,q=0,r=0,s=0;c[g>>2]=e;c[j>>2]=h;if(l&4){e=c[g>>2]|0;l=f;if((((l-e|0)>2?(a[e>>0]|0)==-17:0)?(a[e+1>>0]|0)==-69:0)?(a[e+2>>0]|0)==-65:0)c[g>>2]=e+3}else l=f;q=i;a:while(1){n=c[g>>2]|0;e=n>>>0<f>>>0;if(!e){s=41;break}r=c[j>>2]|0;if(r>>>0>=i>>>0){s=41;break}e=a[n>>0]|0;p=e&255;if(p>>>0>k>>>0){e=2;break}do if(e<<24>>24>-1){b[r>>1]=e&255;c[g>>2]=n+1}else{if((e&255)<194){e=2;break a}if((e&255)<224){if((l-n|0)<2){e=1;break a}e=d[n+1>>0]|0;if((e&192|0)!=128){e=2;break a}e=e&63|p<<6&1984;if(e>>>0>k>>>0){e=2;break a}b[r>>1]=e;c[g>>2]=n+2;break}if((e&255)<240){if((l-n|0)<3){e=1;break a}h=a[n+1>>0]|0;e=a[n+2>>0]|0;switch(p|0){case 224:{if((h&-32)<<24>>24!=-96){e=2;break a}break}case 237:{if((h&-32)<<24>>24!=-128){e=2;break a}break}default:if((h&-64)<<24>>24!=-128){e=2;break a}}e=e&255;if((e&192|0)!=128){e=2;break a}e=(h&255)<<6&4032|p<<12|e&63;if((e&65535)>>>0>k>>>0){e=2;break a}b[r>>1]=e;c[g>>2]=n+3;break}if((e&255)>=245){e=2;break a}if((l-n|0)<4){e=1;break a}m=a[n+1>>0]|0;e=a[n+2>>0]|0;h=a[n+3>>0]|0;switch(p|0){case 240:{if((m+112&255)>=48){e=2;break a}break}case 244:{if((m&-16)<<24>>24!=-128){e=2;break a}break}default:if((m&-64)<<24>>24!=-128){e=2;break a}}o=e&255;if((o&192|0)!=128){e=2;break a}e=h&255;if((e&192|0)!=128){e=2;break a}if((q-r|0)<4){e=1;break a}n=p&7;m=m&255;h=o<<6;e=e&63;if((m<<12&258048|n<<18|h&4032|e)>>>0>k>>>0){e=2;break a}b[r>>1]=m<<2&60|o>>>4&3|((m>>>4&3|n<<2)<<6)+16320|55296;r=r+2|0;c[j>>2]=r;b[r>>1]=e|h&960|56320;c[g>>2]=(c[g>>2]|0)+4}while(0);c[j>>2]=(c[j>>2]|0)+2}if((s|0)==41)e=e&1;return e|0}function hs(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;c[f>>2]=d;return 3}function is(a){a=a|0;return 0}function js(a){a=a|0;return 0}function ks(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return ls(c,d,e,1114111,0)|0}function ls(b,c,e,f,g){b=b|0;c=c|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0;n=c;if((((g&4|0)!=0?(n-b|0)>2:0)?(a[b>>0]|0)==-17:0)?(a[b+1>>0]|0)==-69:0){m=(a[b+2>>0]|0)==-65?b+3|0:b;h=0}else{m=b;h=0}a:while(1){if(!(h>>>0<e>>>0&m>>>0<c>>>0)){g=m;h=40;break}g=a[m>>0]|0;l=g&255;if(l>>>0>f>>>0){g=m;h=40;break}do if(g<<24>>24>-1)g=m+1|0;else{if((g&255)<194){g=m;h=40;break a}if((g&255)<224){if((n-m|0)<2){g=m;h=40;break a}g=d[m+1>>0]|0;if((g&192|0)!=128){g=m;h=40;break a}if((g&63|l<<6&1984)>>>0>f>>>0){g=m;h=40;break a}else{g=m+2|0;break}}if((g&255)<240){g=m;if((n-g|0)<3){g=m;h=40;break a}j=a[m+1>>0]|0;i=a[m+2>>0]|0;switch(l|0){case 224:{if((j&-32)<<24>>24!=-96){h=19;break a}break}case 237:{if((j&-32)<<24>>24!=-128){h=21;break a}break}default:if((j&-64)<<24>>24!=-128){h=23;break a}}g=i&255;if((g&192|0)!=128){g=m;h=40;break a}if(((j&255)<<6&4032|l<<12&61440|g&63)>>>0>f>>>0){g=m;h=40;break a}else{g=m+3|0;break}}if((g&255)>=245){g=m;h=40;break a}g=m;if((e-h|0)>>>0<2|(n-g|0)<4){g=m;h=40;break a}k=a[m+1>>0]|0;i=a[m+2>>0]|0;j=a[m+3>>0]|0;switch(l|0){case 240:{if((k+112&255)>=48){h=30;break a}break}case 244:{if((k&-16)<<24>>24!=-128){h=32;break a}break}default:if((k&-64)<<24>>24!=-128){h=34;break a}}i=i&255;if((i&192|0)!=128){g=m;h=40;break a}g=j&255;if((g&192|0)!=128){g=m;h=40;break a}if(((k&255)<<12&258048|l<<18&1835008|i<<6&4032|g&63)>>>0>f>>>0){g=m;h=40;break a}g=m+4|0;h=h+1|0}while(0);m=g;h=h+1|0}if((h|0)==19)g=g-b|0;else if((h|0)==21)g=g-b|0;else if((h|0)==23)g=g-b|0;else if((h|0)==30)g=g-b|0;else if((h|0)==32)g=g-b|0;else if((h|0)==34)g=g-b|0;else if((h|0)==40)g=g-b|0;return g|0}function ms(a){a=a|0;return 4}function ns(a){a=a|0;var b=0,d=0,e=0,f=0;c[a>>2]=14676;d=a+8|0;e=a+12|0;f=0;while(1){b=c[d>>2]|0;if(f>>>0>=(c[e>>2]|0)-b>>2>>>0)break;b=c[b+(f<<2)>>2]|0;if(b|0)du(b)|0;f=f+1|0}vk(a+144|0);os(d);return}function os(b){b=b|0;var d=0,e=0,f=0,g=0;d=c[b>>2]|0;do if(d|0){e=b+4|0;f=c[e>>2]|0;while(1){if((f|0)==(d|0))break;g=f+-4|0;c[e>>2]=g;f=g}if((b+16|0)==(d|0)){a[b+128>>0]=0;break}else{mu(d);break}}while(0);return}function ps(a){a=a|0;ns(a);mu(a);return}function qs(b){b=b|0;var d=0;c[b>>2]=14696;d=c[b+8>>2]|0;if(d|0?a[b+12>>0]|0:0)Ru(d);return}function rs(a){a=a|0;qs(a);mu(a);return}function ss(a,b){a=a|0;b=b|0;if(b<<24>>24>-1)b=c[(c[(wj()|0)>>2]|0)+((b&255)<<2)>>2]&255;return b|0}function ts(b,d,e){b=b|0;d=d|0;e=e|0;b=d;while(1){if((b|0)==(e|0))break;d=a[b>>0]|0;if(d<<24>>24>-1)d=c[(c[(wj()|0)>>2]|0)+(d<<24>>24<<2)>>2]&255;a[b>>0]=d;b=b+1|0}return e|0}function us(a,b){a=a|0;b=b|0;if(b<<24>>24>-1)b=c[(c[(vj()|0)>>2]|0)+(b<<24>>24<<2)>>2]&255;return b|0}function vs(b,d,e){b=b|0;d=d|0;e=e|0;b=d;while(1){if((b|0)==(e|0))break;d=a[b>>0]|0;if(d<<24>>24>-1)d=c[(c[(vj()|0)>>2]|0)+(d<<24>>24<<2)>>2]&255;a[b>>0]=d;b=b+1|0}return e|0}function ws(a,b){a=a|0;b=b|0;return b|0}function xs(b,c,d,e){b=b|0;c=c|0;d=d|0;e=e|0;while(1){if((c|0)==(d|0))break;a[e>>0]=a[c>>0]|0;e=e+1|0;c=c+1|0}return d|0}function ys(a,b,c){a=a|0;b=b|0;c=c|0;return (b<<24>>24>-1?b:c)|0}function zs(b,c,d,e,f){b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;while(1){if((c|0)==(d|0))break;b=a[c>>0]|0;a[f>>0]=b<<24>>24>-1?b:e;f=f+1|0;c=c+1|0}return d|0}function As(a){a=a|0;c[a>>2]=14748;vk(a+12|0);return}function Bs(a){a=a|0;As(a);mu(a);return}function Cs(b){b=b|0;return a[b+8>>0]|0}function Ds(b){b=b|0;return a[b+9>>0]|0}function Es(a,b){a=a|0;b=b|0;qk(a,b+12|0);return}function Fs(a,b){a=a|0;b=b|0;rk(a,23296,4);return}function Gs(a,b){a=a|0;b=b|0;rk(a,23301,5);return}function Hs(a){a=a|0;c[a>>2]=14788;vk(a+16|0);return}function Is(a){a=a|0;Hs(a);mu(a);return}function Js(a){a=a|0;return c[a+8>>2]|0}function Ks(a){a=a|0;return c[a+12>>2]|0}function Ls(a,b){a=a|0;b=b|0;qk(a,b+16|0);return}function Ms(a,b){a=a|0;b=b|0;Nk(a,14820,gi(14820)|0);return}function Ns(a,b){a=a|0;b=b|0;Nk(a,14840,gi(14840)|0);return}function Os(a){a=a|0;mu(a);return}function Ps(a){a=a|0;mu(a);return}function Qs(a,d,e){a=a|0;d=d|0;e=e|0;if(e>>>0<128)e=(b[(c[(uj()|0)>>2]|0)+(e<<1)>>1]&d)<<16>>16!=0;else e=0;return e|0}function Rs(a,d,f,g){a=a|0;d=d|0;f=f|0;g=g|0;var h=0,i=0;i=(f-d|0)>>>2;h=d;while(1){if((h|0)==(f|0))break;a=c[h>>2]|0;if(a>>>0<128)a=e[(c[(uj()|0)>>2]|0)+(a<<1)>>1]|0;else a=0;b[g>>1]=a;g=g+2|0;h=h+4|0}return d+(i<<2)|0}function Ss(a,d,e,f){a=a|0;d=d|0;e=e|0;f=f|0;while(1){if((e|0)==(f|0)){e=f;break}a=c[e>>2]|0;if(a>>>0<128?(b[(c[(uj()|0)>>2]|0)+(a<<1)>>1]&d)<<16>>16:0)break;e=e+4|0}return e|0}function Ts(a,d,e,f){a=a|0;d=d|0;e=e|0;f=f|0;while(1){if((e|0)==(f|0)){e=f;break}a=c[e>>2]|0;if(a>>>0>=128)break;if(!((b[(c[(uj()|0)>>2]|0)+(a<<1)>>1]&d)<<16>>16))break;e=e+4|0}return e|0}function Us(a,b){a=a|0;b=b|0;if(b>>>0<128)b=c[(c[(wj()|0)>>2]|0)+(b<<2)>>2]|0;return b|0}function Vs(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;f=(d-b|0)>>>2;e=b;while(1){if((e|0)==(d|0))break;a=c[e>>2]|0;if(a>>>0<128)a=c[(c[(wj()|0)>>2]|0)+(a<<2)>>2]|0;c[e>>2]=a;e=e+4|0}return b+(f<<2)|0}function Ws(a,b){a=a|0;b=b|0;if(b>>>0<128)b=c[(c[(vj()|0)>>2]|0)+(b<<2)>>2]|0;return b|0}function Xs(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;f=(d-b|0)>>>2;e=b;while(1){if((e|0)==(d|0))break;a=c[e>>2]|0;if(a>>>0<128)a=c[(c[(vj()|0)>>2]|0)+(a<<2)>>2]|0;c[e>>2]=a;e=e+4|0}return b+(f<<2)|0}function Ys(a,b){a=a|0;b=b|0;return b<<24>>24|0}function Zs(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;while(1){if((d|0)==(e|0))break;c[f>>2]=a[d>>0];f=f+4|0;d=d+1|0}return e|0}function _s(a,b,c){a=a|0;b=b|0;c=c|0;return (b>>>0<128?b&255:c)|0}function $s(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0;h=(e-d|0)>>>2;b=g;g=d;while(1){if((g|0)==(e|0))break;i=c[g>>2]|0;a[b>>0]=i>>>0<128?i&255:f;b=b+1|0;g=g+4|0}return d+(h<<2)|0}function at(a){a=a|0;mu(a);return}function bt(a){a=a|0;mu(a);return}function ct(a){a=a|0;mu(a);return}function dt(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;c[b+4>>2]=f+-1;c[b>>2]=14696;f=b+8|0;c[f>>2]=d;a[b+12>>0]=e&1;if(!d)c[f>>2]=c[(uj()|0)>>2];return}function et(a){a=a|0;return}function ft(a){a=a|0;Fa(23328,23351,303,23435)}function gt(a){a=a|0;Fa(23456,23351,314,23479)}function ht(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;c[a+4>>2]=b+-1;c[a>>2]=14676;b=a+8|0;it(b,28);rk(a+144|0,21332,1);b=c[b>>2]|0;d=a+12|0;e=c[d>>2]|0;while(1){if((e|0)==(b|0))break;f=e+-4|0;c[d>>2]=f;e=f}c[247385]=0;c[247384]=12340;kt(a,989536);c[247387]=0;c[247386]=12372;rt(a,989544);dt(989552,0,0,1);st(a,989552);c[247393]=0;c[247392]=14892;tt(a,989568);c[247395]=0;c[247394]=14960;ut(a,989576);c[247397]=0;c[247396]=14628;c[247398]=Ym()|0;vt(a,989584);c[247401]=0;c[247400]=15008;wt(a,989600);c[247403]=0;c[247402]=15056;xt(a,989608);yt(989616,1);zt(a,989616);At(989640,1);Bt(a,989640);c[247419]=0;c[247418]=12404;Ct(a,989672);c[247421]=0;c[247420]=12468;Dt(a,989680);c[247423]=0;c[247422]=12532;Et(a,989688);c[247425]=0;c[247424]=12584;Ft(a,989696);c[247427]=0;c[247426]=14132;Gt(a,989704);c[247429]=0;c[247428]=14188;Ht(a,989712);c[247431]=0;c[247430]=14244;It(a,989720);c[247433]=0;c[247432]=14300;Jt(a,989728);c[247435]=0;c[247434]=14356;Kt(a,989736);c[247437]=0;c[247436]=14384;Lt(a,989744);c[247439]=0;c[247438]=14412;Mt(a,989752);c[247441]=0;c[247440]=14440;Nt(a,989760);c[247443]=0;c[247442]=12636;c[247444]=12684;Ot(a,989768);c[247447]=0;c[247446]=12720;c[247448]=12768;Pt(a,989784);c[247451]=0;c[247450]=14872;c[247452]=Ym()|0;c[247450]=14084;Qt(a,989800);c[247455]=0;c[247454]=14872;c[247456]=Ym()|0;c[247454]=14108;Rt(a,989816);c[247459]=0;c[247458]=14468;St(a,989832);c[247461]=0;c[247460]=14500;Tt(a,989840);return}function it(b,d){b=b|0;d=d|0;var e=0;c[b>>2]=0;e=b+4|0;c[e>>2]=0;c[b+8>>2]=0;a[b+128>>0]=0;if(d|0){jt(b,d);b=c[e>>2]|0;do{c[b>>2]=0;b=(c[e>>2]|0)+4|0;c[e>>2]=b;d=d+-1|0}while((d|0)!=0)}return}function jt(b,d){b=b|0;d=d|0;var e=0;if(d>>>0>1073741823)ft(b);e=b+128|0;if(d>>>0<29&(a[e>>0]|0)==0){a[e>>0]=1;e=b+16|0}else e=Nu(d<<2)|0;c[b+4>>2]=e;c[b>>2]=e;c[b+8>>2]=e+(d<<2);return}function kt(a,b){a=a|0;b=b|0;lt(a,b,Pm(1150084)|0);return}function lt(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;cu(b);f=a+8|0;e=c[f>>2]|0;if((c[a+12>>2]|0)-e>>2>>>0>d>>>0)a=f;else{mt(f,d+1|0);a=f;e=c[f>>2]|0}e=c[e+(d<<2)>>2]|0;if(e|0)du(e)|0;c[(c[a>>2]|0)+(d<<2)>>2]=b;return}function mt(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;g=a+4|0;d=c[g>>2]|0;f=c[a>>2]|0;e=d-f>>2;a:do if(e>>>0>=b>>>0){if(e>>>0>b>>>0){e=f+(b<<2)|0;while(1){if((d|0)==(e|0))break a;a=d+-4|0;c[g>>2]=a;d=a}}}else nt(a,b-e|0);while(0);return}function nt(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0;k=i;i=i+32|0;j=k;g=c[a+8>>2]|0;e=a+4|0;d=c[e>>2]|0;if(g-d>>2>>>0<b>>>0){e=c[a>>2]|0;h=d-e>>2;f=h+b|0;if(f>>>0>1073741823)ft(a);d=g-e|0;if(d>>2>>>0<536870911){d=d>>1;d=d>>>0<f>>>0?f:d}else d=1073741823;ot(j,d,h,a+16|0);h=j+8|0;g=c[h>>2]|0;Wu(g|0,0,b<<2|0)|0;c[h>>2]=g+(b<<2);pt(a,j);qt(j)}else do{c[d>>2]=0;d=(c[e>>2]|0)+4|0;c[e>>2]=d;b=b+-1|0}while((b|0)!=0);i=k;return}function ot(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0;c[b+12>>2]=0;c[b+16>>2]=f;do if(d){g=f+112|0;if(d>>>0<29&(a[g>>0]|0)==0){a[g>>0]=1;break}else{f=Nu(d<<2)|0;break}}else f=0;while(0);c[b>>2]=f;e=f+(e<<2)|0;c[b+8>>2]=e;c[b+4>>2]=e;c[b+12>>2]=f+(d<<2);return}function pt(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0;e=c[a>>2]|0;g=a+4|0;d=b+4|0;f=(c[g>>2]|0)-e|0;h=(c[d>>2]|0)+(0-(f>>2)<<2)|0;c[d>>2]=h;_u(h|0,e|0,f|0)|0;f=c[a>>2]|0;c[a>>2]=c[d>>2];c[d>>2]=f;f=b+8|0;e=c[g>>2]|0;c[g>>2]=c[f>>2];c[f>>2]=e;f=a+8|0;a=b+12|0;e=c[f>>2]|0;c[f>>2]=c[a>>2];c[a>>2]=e;c[b>>2]=c[d>>2];return}function qt(b){b=b|0;var d=0,e=0,f=0,g=0;d=c[b+4>>2]|0;e=b+8|0;f=c[e>>2]|0;while(1){if((f|0)==(d|0))break;g=f+-4|0;c[e>>2]=g;f=g}e=c[b>>2]|0;do if(e|0){d=c[b+16>>2]|0;if((d|0)==(e|0)){a[d+112>>0]=0;break}else{mu(e);break}}while(0);return}function rt(a,b){a=a|0;b=b|0;lt(a,b,Pm(1150092)|0);return}function st(a,b){a=a|0;b=b|0;lt(a,b,Pm(1150100)|0);return}function tt(a,b){a=a|0;b=b|0;lt(a,b,Pm(1150132)|0);return}function ut(a,b){a=a|0;b=b|0;lt(a,b,Pm(1151892)|0);return}function vt(a,b){a=a|0;b=b|0;lt(a,b,Pm(1151900)|0);return}function wt(a,b){a=a|0;b=b|0;lt(a,b,Pm(1151908)|0);return}function xt(a,b){a=a|0;b=b|0;lt(a,b,Pm(1151916)|0);return}function yt(b,d){b=b|0;d=d|0;c[b+4>>2]=d+-1;c[b>>2]=14748;a[b+8>>0]=46;a[b+9>>0]=44;d=b+12|0;b=0;while(1){if((b|0)==3)break;c[d+(b<<2)>>2]=0;b=b+1|0}return}function zt(a,b){a=a|0;b=b|0;lt(a,b,Pm(1150112)|0);return}function At(a,b){a=a|0;b=b|0;c[a+4>>2]=b+-1;c[a>>2]=14788;c[a+8>>2]=46;c[a+12>>2]=44;b=a+16|0;a=0;while(1){if((a|0)==3)break;c[b+(a<<2)>>2]=0;a=a+1|0}return}function Bt(a,b){a=a|0;b=b|0;lt(a,b,Pm(1150140)|0);return}function Ct(a,b){a=a|0;b=b|0;lt(a,b,Pm(1150124)|0);return}function Dt(a,b){a=a|0;b=b|0;lt(a,b,Pm(1150148)|0);return}function Et(a,b){a=a|0;b=b|0;lt(a,b,Pm(1150156)|0);return}function Ft(a,b){a=a|0;b=b|0;lt(a,b,Pm(1150164)|0);return}function Gt(a,b){a=a|0;b=b|0;lt(a,b,Pm(1151812)|0);return}function Ht(a,b){a=a|0;b=b|0;lt(a,b,Pm(1151820)|0);return}function It(a,b){a=a|0;b=b|0;lt(a,b,Pm(1151828)|0);return}function Jt(a,b){a=a|0;b=b|0;lt(a,b,Pm(1151836)|0);return}function Kt(a,b){a=a|0;b=b|0;lt(a,b,Pm(1151844)|0);return}function Lt(a,b){a=a|0;b=b|0;lt(a,b,Pm(1151852)|0);return}function Mt(a,b){a=a|0;b=b|0;lt(a,b,Pm(1151860)|0);return}function Nt(a,b){a=a|0;b=b|0;lt(a,b,Pm(1151868)|0);return}function Ot(a,b){a=a|0;b=b|0;lt(a,b,Pm(1150976)|0);return}function Pt(a,b){a=a|0;b=b|0;lt(a,b,Pm(1151788)|0);return}function Qt(a,b){a=a|0;b=b|0;lt(a,b,Pm(1151796)|0);return}function Rt(a,b){a=a|0;b=b|0;lt(a,b,Pm(1151804)|0);return}function St(a,b){a=a|0;b=b|0;lt(a,b,Pm(1151876)|0);return}function Tt(a,b){a=a|0;b=b|0;lt(a,b,Pm(1151884)|0);return}function Ut(){if((a[989848]|0)==0?Ca(989848)|0:0){Vt()|0;c[287982]=1151924;Ja(989848)}return c[287982]|0}function Vt(){ht(989856,1);c[287981]=989856;return 1151924}function Wt(){var a=0;a=c[(Ut()|0)>>2]|0;c[287983]=a;cu(a);return 1151932}function Xt(){if((a[990016]|0)==0?Ca(990016)|0:0){Wt()|0;c[287984]=1151932;Ja(990016)}return c[287984]|0}function Yt(a){a=a|0;var b=0;b=c[(Xt()|0)>>2]|0;c[a>>2]=b;cu(b);return}function Zt(a,b){a=a|0;b=b|0;b=c[b>>2]|0;c[a>>2]=b;cu(b);return}function _t(a){a=a|0;du(c[a>>2]|0)|0;return}function $t(a,b){a=a|0;b=b|0;a=c[a>>2]|0;return au(a,Pm(b)|0)|0}function au(a,b){a=a|0;b=b|0;var d=0;d=c[a+8>>2]|0;if((c[a+12>>2]|0)-d>>2>>>0>b>>>0)d=(c[d+(b<<2)>>2]|0)!=0;else d=0;return d|0}function bu(a){a=a|0;return}function cu(a){a=a|0;a=a+4|0;c[a>>2]=(c[a>>2]|0)+1;return}function du(a){a=a|0;var b=0,d=0;d=a+4|0;b=c[d>>2]|0;c[d>>2]=b+-1;if(!b){Bb[c[(c[a>>2]|0)+8>>2]&255](a);a=1}else a=0;return a|0}function eu(){var a=0,b=0,d=0,e=0,f=0,g=0,h=0,j=0;f=i;i=i+48|0;h=f+32|0;d=f+24|0;j=f+16|0;g=f;f=f+36|0;a=fu()|0;if(a|0?(e=c[a>>2]|0,e|0):0){a=e+48|0;b=c[a>>2]|0;a=c[a+4>>2]|0;if(!((b&-256|0)==1126902528&(a|0)==1129074247)){c[d>>2]=23807;iu(23902,d)}if((b|0)==1126902529&(a|0)==1129074247)a=c[e+44>>2]|0;else a=e+80|0;c[f>>2]=a;e=c[e>>2]|0;a=c[e+4>>2]|0;if(yb[c[(c[370]|0)+16>>2]&31](1480,e,f)|0){j=c[f>>2]|0;j=Fb[c[(c[j>>2]|0)+8>>2]&127](j)|0;c[g>>2]=23807;c[g+4>>2]=a;c[g+8>>2]=j;iu(23816,g)}else{c[j>>2]=23807;c[j+4>>2]=a;iu(23861,j)}}iu(23940,h)}function fu(){var a=0,b=0;a=i;i=i+16|0;if(!(ab(1151940,2)|0)){b=va(c[287986]|0)|0;i=a;return b|0}else iu(23628,a);return 0}function gu(){var a=0;a=i;i=i+16|0;if(!(za(1151944,163)|0)){i=a;return}else iu(23578,a)}function hu(a){a=a|0;var b=0;b=i;i=i+16|0;Aj(a);if(!(ib(c[287986]|0,0)|0)){i=b;return}else iu(23525,b)}function iu(a,b){a=a|0;b=b|0;var d=0;d=i;i=i+16|0;c[d>>2]=b;b=c[1997]|0;Qh(b,a,d)|0;Gi(10,b)|0;Ba()}function ju(a){a=a|0;return}function ku(a){a=a|0;return}function lu(a){a=a|0;mu(a);return}function mu(a){a=a|0;Aj(a);return}function nu(a){a=a|0;return}function ou(a){a=a|0;return}function pu(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0;h=i;i=i+64|0;g=h;if((a|0)!=(b|0))if((b|0)!=0?(f=qu(b,1520,1488,0)|0,(f|0)!=0):0){b=g;e=b+56|0;do{c[b>>2]=0;b=b+4|0}while((b|0)<(e|0));c[g>>2]=f;c[g+8>>2]=a;c[g+12>>2]=-1;c[g+48>>2]=1;Nb[c[(c[f>>2]|0)+28>>2]&15](f,g,c[d>>2]|0,1);if((c[g+24>>2]|0)==1){c[d>>2]=c[g+16>>2];b=1}else b=0}else b=0;else b=1;i=h;return b|0}function qu(d,e,f,g){d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;r=i;i=i+64|0;q=r;p=c[d>>2]|0;o=d+(c[p+-8>>2]|0)|0;p=c[p+-4>>2]|0;c[q>>2]=f;c[q+4>>2]=d;c[q+8>>2]=e;c[q+12>>2]=g;l=q+16|0;g=q+20|0;d=q+24|0;e=q+28|0;h=q+32|0;j=q+40|0;k=(p|0)==(f|0);m=l;n=m+36|0;do{c[m>>2]=0;m=m+4|0}while((m|0)<(n|0));b[l+36>>1]=0;a[l+38>>0]=0;a:do if(k){c[q+48>>2]=1;Kb[c[(c[f>>2]|0)+20>>2]&15](f,q,o,o,1,0);g=(c[d>>2]|0)==1?o:0}else{zb[c[(c[p>>2]|0)+24>>2]&3](p,q,o,1,0);switch(c[q+36>>2]|0){case 0:{g=(c[j>>2]|0)==1&(c[e>>2]|0)==1&(c[h>>2]|0)==1?c[g>>2]|0:0;break a}case 1:break;default:{g=0;break a}}if((c[d>>2]|0)!=1?!((c[j>>2]|0)==0&(c[e>>2]|0)==1&(c[h>>2]|0)==1):0){g=0;break}g=c[l>>2]|0}while(0);i=r;return g|0}function ru(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;if((a|0)==(c[b+8>>2]|0))su(0,b,d,e,f);else{a=c[a+8>>2]|0;Kb[c[(c[a>>2]|0)+20>>2]&15](a,b,d,e,f,g)}return}function su(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;a[d+53>>0]=1;do if((c[d+4>>2]|0)==(f|0)){a[d+52>>0]=1;f=d+16|0;b=c[f>>2]|0;if(!b){c[f>>2]=e;c[d+24>>2]=g;c[d+36>>2]=1;if(!((g|0)==1?(c[d+48>>2]|0)==1:0))break;a[d+54>>0]=1;break}if((b|0)!=(e|0)){g=d+36|0;c[g>>2]=(c[g>>2]|0)+1;a[d+54>>0]=1;break}b=d+24|0;f=c[b>>2]|0;if((f|0)==2){c[b>>2]=g;f=g}if((f|0)==1?(c[d+48>>2]|0)==1:0)a[d+54>>0]=1}while(0);return}function tu(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0;do if((b|0)==(c[d+8>>2]|0)){if((c[d+4>>2]|0)==(e|0)?(h=d+28|0,(c[h>>2]|0)!=1):0)c[h>>2]=f}else{if((b|0)!=(c[d>>2]|0)){j=c[b+8>>2]|0;zb[c[(c[j>>2]|0)+24>>2]&3](j,d,e,f,g);break}if((c[d+16>>2]|0)!=(e|0)?(j=d+20|0,(c[j>>2]|0)!=(e|0)):0){c[d+32>>2]=f;i=d+44|0;if((c[i>>2]|0)==4)break;h=d+52|0;a[h>>0]=0;f=d+53|0;a[f>>0]=0;b=c[b+8>>2]|0;Kb[c[(c[b>>2]|0)+20>>2]&15](b,d,e,e,1,g);if(a[f>>0]|0)if(!(a[h>>0]|0)){h=1;f=13}else f=17;else{h=0;f=13}do if((f|0)==13){c[j>>2]=e;e=d+40|0;c[e>>2]=(c[e>>2]|0)+1;if((c[d+36>>2]|0)==1?(c[d+24>>2]|0)==2:0){a[d+54>>0]=1;if(h){f=17;break}else{h=4;break}}if(h)f=17;else h=4}while(0);if((f|0)==17)h=3;c[i>>2]=h;break}if((f|0)==1)c[d+32>>2]=1}while(0);return}function uu(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;if((a|0)==(c[b+8>>2]|0))vu(0,b,d,e);else{a=c[a+8>>2]|0;Nb[c[(c[a>>2]|0)+28>>2]&15](a,b,d,e)}return}function vu(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0;b=d+16|0;g=c[b>>2]|0;do if(g){if((g|0)!=(e|0)){f=d+36|0;c[f>>2]=(c[f>>2]|0)+1;c[d+24>>2]=2;a[d+54>>0]=1;break}b=d+24|0;if((c[b>>2]|0)==2)c[b>>2]=f}else{c[b>>2]=e;c[d+24>>2]=f;c[d+36>>2]=1}while(0);return}function wu(a){a=a|0;mu(a);return}function xu(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;if((a|0)==(c[b+8>>2]|0))su(0,b,d,e,f);return}function yu(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0;do if((b|0)==(c[d+8>>2]|0)){if((c[d+4>>2]|0)==(e|0)?(i=d+28|0,(c[i>>2]|0)!=1):0)c[i>>2]=f}else if((b|0)==(c[d>>2]|0)){if((c[d+16>>2]|0)!=(e|0)?(h=d+20|0,(c[h>>2]|0)!=(e|0)):0){c[d+32>>2]=f;c[h>>2]=e;g=d+40|0;c[g>>2]=(c[g>>2]|0)+1;if((c[d+36>>2]|0)==1?(c[d+24>>2]|0)==2:0)a[d+54>>0]=1;c[d+44>>2]=4;break}if((f|0)==1)c[d+32>>2]=1}while(0);return}function zu(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;if((a|0)==(c[b+8>>2]|0))vu(0,b,d,e);return}function Au(){var a=0,b=0,d=0,e=0;d=i;i=i+16|0;e=d+8|0;a=fu()|0;if((a|0?(b=c[a>>2]|0,b|0):0)?(a=b+48|0,(c[a>>2]&-256|0)==1126902528?(c[a+4>>2]|0)==1129074247:0):0){Hb[c[b+12>>2]&3]();iu(23952,d)}d=c[3774]|0;c[3774]=d+0;Hb[d&3]();iu(23952,e)}function Bu(a){a=a|0;Qa(a|0)|0;Au()}function Cu(a){a=a|0;return}function Du(a){a=a|0;return}function Eu(a){a=a|0;mu(a);return}function Fu(a){a=a|0;return 24005}function Gu(a){a=a|0;mu(a);return}function Hu(d,e,f,g,h,i){d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;if((d|0)==(c[e+8>>2]|0))su(0,e,f,g,h);else{o=e+52|0;r=b[o>>1]|0;p=r&255;q=e+53|0;r=(r&65535)>>>8&255;n=c[d+12>>2]|0;k=d+16+(n<<3)|0;a[o>>0]=0;a[q>>0]=0;Iu(d+16|0,e,f,g,h,i);a:do if((n|0)>1){l=e+24|0;m=d+8|0;n=e+54|0;j=d+24|0;do{if(a[n>>0]|0)break a;d=b[o>>1]|0;if(!((d&255)<<24>>24)){if((d&65535)>=256?(c[m>>2]&1|0)==0:0)break a}else{if((c[l>>2]|0)==1)break a;if(!(c[m>>2]&2))break a}a[o>>0]=0;a[q>>0]=0;Iu(j,e,f,g,h,i);j=j+8|0}while(j>>>0<k>>>0)}while(0);a[o>>0]=p;a[q>>0]=r}return}function Iu(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0;i=c[a+4>>2]|0;h=i>>8;if(i&1)h=c[(c[e>>2]|0)+h>>2]|0;a=c[a>>2]|0;Kb[c[(c[a>>2]|0)+20>>2]&15](a,b,d,e+h|0,i&2|0?f:2,g);return}function Ju(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;a:do if((b|0)==(c[d+8>>2]|0)){if((c[d+4>>2]|0)==(e|0)?(h=d+28|0,(c[h>>2]|0)!=1):0)c[h>>2]=f}else{if((b|0)!=(c[d>>2]|0)){p=c[b+12>>2]|0;j=b+16+(p<<3)|0;Ku(b+16|0,d,e,f,g);h=b+24|0;if((p|0)<=1)break;i=c[b+8>>2]|0;if((i&2|0)==0?(k=d+36|0,(c[k>>2]|0)!=1):0){if(!(i&1)){i=d+54|0;while(1){if(a[i>>0]|0)break a;if((c[k>>2]|0)==1)break a;Ku(h,d,e,f,g);h=h+8|0;if(h>>>0>=j>>>0)break a}}i=d+24|0;b=d+54|0;while(1){if(a[b>>0]|0)break a;if((c[k>>2]|0)==1?(c[i>>2]|0)==1:0)break a;Ku(h,d,e,f,g);h=h+8|0;if(h>>>0>=j>>>0)break a}}i=d+54|0;while(1){if(a[i>>0]|0)break a;Ku(h,d,e,f,g);h=h+8|0;if(h>>>0>=j>>>0)break a}}if((c[d+16>>2]|0)!=(e|0)?(p=d+20|0,(c[p>>2]|0)!=(e|0)):0){c[d+32>>2]=f;o=d+44|0;if((c[o>>2]|0)==4)break;j=b+16+(c[b+12>>2]<<3)|0;k=d+52|0;f=d+53|0;m=d+54|0;l=b+8|0;n=d+24|0;i=0;h=0;b=b+16|0;b:while(1){if(b>>>0>=j>>>0){b=20;break}a[k>>0]=0;a[f>>0]=0;Iu(b,d,e,e,1,g);if(a[m>>0]|0){b=20;break}do if(a[f>>0]|0){if(!(a[k>>0]|0))if(!(c[l>>2]&1)){h=1;b=20;break b}else{h=1;break}if((c[n>>2]|0)==1){b=25;break b}if(!(c[l>>2]&2)){b=25;break b}else{i=1;h=1}}while(0);b=b+8|0}do if((b|0)==20){if((!i?(c[p>>2]=e,e=d+40|0,c[e>>2]=(c[e>>2]|0)+1,(c[d+36>>2]|0)==1):0)?(c[n>>2]|0)==2:0){a[m>>0]=1;if(h){b=25;break}else{h=4;break}}if(h)b=25;else h=4}while(0);if((b|0)==25)h=3;c[o>>2]=h;break}if((f|0)==1)c[d+32>>2]=1}while(0);return}function Ku(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0;h=c[a+4>>2]|0;g=h>>8;if(h&1)g=c[(c[d>>2]|0)+g>>2]|0;a=c[a>>2]|0;zb[c[(c[a>>2]|0)+24>>2]&3](a,b,d+g|0,h&2|0?e:2,f);return}function Lu(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0;a:do if((b|0)!=(c[d+8>>2]|0)){h=c[b+12>>2]|0;g=b+16+(h<<3)|0;Mu(b+16|0,d,e,f);if((h|0)>1){h=d+54|0;b=b+24|0;do{Mu(b,d,e,f);if(a[h>>0]|0)break a;b=b+8|0}while(b>>>0<g>>>0)}}else vu(0,d,e,f);while(0);return}function Mu(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0;g=c[a+4>>2]|0;f=g>>8;if(g&1)f=c[(c[d>>2]|0)+f>>2]|0;a=c[a>>2]|0;Nb[c[(c[a>>2]|0)+28>>2]&15](a,b,d+f|0,g&2|0?e:2);return}function Nu(a){a=a|0;var b=0;b=(a|0)==0?1:a;while(1){a=zj(b)|0;if(a|0){b=6;break}a=Ou()|0;if(!a){b=5;break}Hb[a&3]()}if((b|0)==5){b=Ga(4)|0;c[b>>2]=15188;jb(b|0,1544,148)}else if((b|0)==6)return a|0;return 0}function Ou(){var a=0;a=c[287987]|0;c[287987]=a+0;return a|0}function Pu(a,b){a=a|0;b=b|0;return Nu(a)|0}function Qu(a){a=a|0;return Nu(a)|0}function Ru(a){a=a|0;mu(a);return}function Su(a){a=a|0;c[a>>2]=15188;return}function Tu(){var a=0;a=Ga(4)|0;Su(a);jb(a|0,1544,148)}function Uu(){}function Vu(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;d=b-d-(c>>>0>a>>>0|0)>>>0;return (C=d,a-c>>>0|0)|0}function Wu(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0;f=b+e|0;if((e|0)>=20){d=d&255;h=b&3;i=d|d<<8|d<<16|d<<24;g=f&~3;if(h){h=b+4-h|0;while((b|0)<(h|0)){a[b>>0]=d;b=b+1|0}}while((b|0)<(g|0)){c[b>>2]=i;b=b+4|0}}while((b|0)<(f|0)){a[b>>0]=d;b=b+1|0}return b-e|0}function Xu(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;c=a+c>>>0;return (C=b+d+(c>>>0<a>>>0|0)>>>0,c|0)|0}function Yu(a,b,c){a=a|0;b=b|0;c=c|0;if((c|0)<32){C=b>>>c;return a>>>c|(b&(1<<c)-1)<<32-c}C=0;return b>>>c-32|0}function Zu(a,b,c){a=a|0;b=b|0;c=c|0;if((c|0)<32){C=b<<c|(a&(1<<c)-1<<32-c)>>>32-c;return a<<c}C=a<<c-32;return 0}function _u(b,d,e){b=b|0;d=d|0;e=e|0;var f=0;if((e|0)>=4096)return Ra(b|0,d|0,e|0)|0;f=b|0;if((b&3)==(d&3)){while(b&3){if(!e)return f|0;a[b>>0]=a[d>>0]|0;b=b+1|0;d=d+1|0;e=e-1|0}while((e|0)>=4){c[b>>2]=c[d>>2];b=b+4|0;d=d+4|0;e=e-4|0}}while((e|0)>0){a[b>>0]=a[d>>0]|0;b=b+1|0;d=d+1|0;e=e-1|0}return f|0}function $u(b,c,d){b=b|0;c=c|0;d=d|0;var e=0;if((c|0)<(b|0)&(b|0)<(c+d|0)){e=b;c=c+d|0;b=b+d|0;while((d|0)>0){b=b-1|0;c=c-1|0;d=d-1|0;a[b>>0]=a[c>>0]|0}b=e}else _u(b,c,d)|0;return b|0}function av(b){b=b|0;var c=0;c=a[m+(b&255)>>0]|0;if((c|0)<8)return c|0;c=a[m+(b>>8&255)>>0]|0;if((c|0)<8)return c+8|0;c=a[m+(b>>16&255)>>0]|0;if((c|0)<8)return c+16|0;return (a[m+(b>>>24)>>0]|0)+24|0}function bv(a,b,c){a=a|0;b=b|0;c=c|0;b=aa(b)|0;if((b|0)==32)b=b+(aa(a)|0)|0;C=0;return b|0}function cv(a){a=+a;return a>=0.0?+M(a+.5):+Z(a-.5)}function dv(a,b,c){a=a|0;b=b|0;c=c|0;if((c|0)<32){C=b>>c;return a>>>c|(b&(1<<c)-1)<<32-c}C=(b|0)<0?-1:0;return b>>c-32|0}function ev(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0;f=a&65535;e=b&65535;c=_(e,f)|0;d=a>>>16;a=(c>>>16)+(_(e,d)|0)|0;e=b>>>16;b=_(e,f)|0;return (C=(a>>>16)+(_(e,d)|0)+(((a&65535)+b|0)>>>16)|0,a+b<<16|c&65535|0)|0}function fv(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0;j=b>>31|((b|0)<0?-1:0)<<1;i=((b|0)<0?-1:0)>>31|((b|0)<0?-1:0)<<1;f=d>>31|((d|0)<0?-1:0)<<1;e=((d|0)<0?-1:0)>>31|((d|0)<0?-1:0)<<1;h=Vu(j^a|0,i^b|0,j|0,i|0)|0;g=C;a=f^j;b=e^i;return Vu((kv(h,g,Vu(f^c|0,e^d|0,f|0,e|0)|0,C,0)|0)^a|0,C^b|0,a|0,b|0)|0}function gv(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0;f=i;i=i+16|0;j=f|0;h=b>>31|((b|0)<0?-1:0)<<1;g=((b|0)<0?-1:0)>>31|((b|0)<0?-1:0)<<1;l=e>>31|((e|0)<0?-1:0)<<1;k=((e|0)<0?-1:0)>>31|((e|0)<0?-1:0)<<1;a=Vu(h^a|0,g^b|0,h|0,g|0)|0;b=C;kv(a,b,Vu(l^d|0,k^e|0,l|0,k|0)|0,C,j)|0;e=Vu(c[j>>2]^h|0,c[j+4>>2]^g|0,h|0,g|0)|0;d=C;i=f;return (C=d,e)|0}function hv(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0;e=a;f=c;c=ev(e,f)|0;a=C;return (C=(_(b,f)|0)+(_(d,e)|0)+a|a&0,c|0|0)|0}function iv(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return kv(a,b,c,d,0)|0}function jv(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0;g=i;i=i+16|0;f=g|0;kv(a,b,d,e,f)|0;i=g;return (C=c[f+4>>2]|0,c[f>>2]|0)|0}function kv(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;l=a;j=b;k=j;h=d;n=e;i=n;if(!k){g=(f|0)!=0;if(!i){if(g){c[f>>2]=(l>>>0)%(h>>>0);c[f+4>>2]=0}n=0;f=(l>>>0)/(h>>>0)>>>0;return (C=n,f)|0}else{if(!g){n=0;f=0;return (C=n,f)|0}c[f>>2]=a|0;c[f+4>>2]=b&0;n=0;f=0;return (C=n,f)|0}}g=(i|0)==0;do if(h){if(!g){g=(aa(i|0)|0)-(aa(k|0)|0)|0;if(g>>>0<=31){m=g+1|0;i=31-g|0;b=g-31>>31;h=m;a=l>>>(m>>>0)&b|k<<i;b=k>>>(m>>>0)&b;g=0;i=l<<i;break}if(!f){n=0;f=0;return (C=n,f)|0}c[f>>2]=a|0;c[f+4>>2]=j|b&0;n=0;f=0;return (C=n,f)|0}g=h-1|0;if(g&h|0){i=(aa(h|0)|0)+33-(aa(k|0)|0)|0;p=64-i|0;m=32-i|0;j=m>>31;o=i-32|0;b=o>>31;h=i;a=m-1>>31&k>>>(o>>>0)|(k<<m|l>>>(i>>>0))&b;b=b&k>>>(i>>>0);g=l<<p&j;i=(k<<p|l>>>(o>>>0))&j|l<<m&i-33>>31;break}if(f|0){c[f>>2]=g&l;c[f+4>>2]=0}if((h|0)==1){o=j|b&0;p=a|0|0;return (C=o,p)|0}else{p=av(h|0)|0;o=k>>>(p>>>0)|0;p=k<<32-p|l>>>(p>>>0)|0;return (C=o,p)|0}}else{if(g){if(f|0){c[f>>2]=(k>>>0)%(h>>>0);c[f+4>>2]=0}o=0;p=(k>>>0)/(h>>>0)>>>0;return (C=o,p)|0}if(!l){if(f|0){c[f>>2]=0;c[f+4>>2]=(k>>>0)%(i>>>0)}o=0;p=(k>>>0)/(i>>>0)>>>0;return (C=o,p)|0}g=i-1|0;if(!(g&i)){if(f|0){c[f>>2]=a|0;c[f+4>>2]=g&k|b&0}o=0;p=k>>>((av(i|0)|0)>>>0);return (C=o,p)|0}g=(aa(i|0)|0)-(aa(k|0)|0)|0;if(g>>>0<=30){b=g+1|0;i=31-g|0;h=b;a=k<<i|l>>>(b>>>0);b=k>>>(b>>>0);g=0;i=l<<i;break}if(!f){o=0;p=0;return (C=o,p)|0}c[f>>2]=a|0;c[f+4>>2]=j|b&0;o=0;p=0;return (C=o,p)|0}while(0);if(!h){k=i;j=0;i=0}else{m=d|0|0;l=n|e&0;k=Xu(m|0,l|0,-1,-1)|0;d=C;j=i;i=0;do{e=j;j=g>>>31|j<<1;g=i|g<<1;e=a<<1|e>>>31|0;n=a>>>31|b<<1|0;Vu(k|0,d|0,e|0,n|0)|0;p=C;o=p>>31|((p|0)<0?-1:0)<<1;i=o&1;a=Vu(e|0,n|0,o&m|0,(((p|0)<0?-1:0)>>31|((p|0)<0?-1:0)<<1)&l|0)|0;b=C;h=h-1|0}while((h|0)!=0);k=j;j=0}h=0;if(f|0){c[f>>2]=a;c[f+4>>2]=b}o=(g|0)>>>31|(k|h)<<1|(h<<1|g>>>31)&0|j;p=(g<<1|0>>>31)&-2|i;return (C=o,p)|0}function lv(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;return xb[a&7](b|0,c|0,d|0,e|0,f|0,g|0,h|0)|0}function mv(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return yb[a&31](b|0,c|0,d|0)|0}function nv(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;zb[a&3](b|0,c|0,d|0,e|0,f|0)}function ov(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=+g;return Ab[a&3](b|0,c|0,d|0,e|0,f|0,+g)|0}function pv(a,b){a=a|0;b=b|0;Bb[a&255](b|0)}function qv(a,b,c){a=a|0;b=b|0;c=c|0;Cb[a&63](b|0,c|0)}function rv(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;return Db[a&63](b|0,c|0,d|0,e|0,f|0,g|0)|0}function sv(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=+f;return Eb[a&7](b|0,c|0,d|0,e|0,+f)|0}function tv(a,b){a=a|0;b=b|0;return Fb[a&127](b|0)|0}function uv(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;Gb[a&0](b|0,c|0,d|0)}function vv(a){a=a|0;Hb[a&3]()}function wv(a,b,c,d,e,f,g,h,i){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;return Ib[a&15](b|0,c|0,d|0,e|0,f|0,g|0,h|0,i|0)|0}function xv(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return Jb[a&7](b|0,c|0,d|0,e|0)|0}function yv(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;Kb[a&15](b|0,c|0,d|0,e|0,f|0,g|0)}function zv(a,b,c){a=a|0;b=b|0;c=c|0;return Lb[a&63](b|0,c|0)|0}function Av(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;return Mb[a&31](b|0,c|0,d|0,e|0,f|0)|0}function Bv(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;Nb[a&15](b|0,c|0,d|0,e|0)}function Cv(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;ba(0);return 0}function Dv(a,b,c){a=a|0;b=b|0;c=c|0;ba(1);return 0}function Ev(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;ba(2)}function Fv(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=+f;ba(3);return 0}function Gv(a){a=a|0;ba(4)}function Hv(a,b){a=a|0;b=b|0;ba(5)}function Iv(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;ba(6);return 0}function Jv(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;ba(7);return 0}function Kv(a){a=a|0;ba(8);return 0}function Lv(a,b,c){a=a|0;b=b|0;c=c|0;ba(9)}function Mv(){ba(10)}function Nv(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;ba(11);return 0}function Ov(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;ba(12);return 0}function Pv(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;ba(13)}function Qv(a,b){a=a|0;b=b|0;ba(14);return 0}function Rv(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;ba(15);return 0}function Sv(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;ba(16)}
function Nf(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0;L=i;i=i+16|0;K=L+8|0;k=L+4|0;l=L;E=b+5336|0;h=E;h=Xu(c[h>>2]|0,c[h+4>>2]|0,1,0)|0;c[E>>2]=h;c[E+4>>2]=C;E=b+5356|0;h=c[E>>2]|0;m=h+56|0;g=981520;s=c[g>>2]^c[m>>2];m=c[g+4>>2]^c[m+4>>2];g=e;j=g+56|0;do{c[g>>2]=c[h>>2];g=g+4|0;h=h+4|0}while((g|0)<(j|0));c[e+336>>2]=c[E>>2];c[E>>2]=e;J=b+5344|0;c[J>>2]=(c[J>>2]|0)+1;J=e+28|0;c[J>>2]=(c[J>>2]|0)+1;J=e+32|0;c[J>>2]=(c[J>>2]|0)+1;J=b+5348|0;G=c[J>>2]|0;F=G^1;B=(d&131072|0)==0;I=B?d>>>6&63:64;p=d&63;c[K>>2]=p;B=B?d&49152:131072;H=(B|0)==131072;do if(!H){h=c[b+(I<<2)>>2]|0;if((B|0)==32768){j=1;n=h;x=F<<3|1;D=9;break}g=c[b+(p<<2)>>2]|0;if((B|0)==49152){Of(b,G,I,K,k,l);n=c[E>>2]|0;p=n+44|0;j=c[l>>2]|0;o=b+5364|0;e=c[o>>2]|0;l=c[k>>2]|0;c[p>>2]=(c[1035344+(e*4160|0)+(g*260|0)+(j<<2)>>2]|0)-(c[1035344+(e*4160|0)+(g*260|0)+(l<<2)>>2]|0)+(c[p>>2]|0);l=973136+(g<<9)+(l<<3)|0;j=973136+(g<<9)+(j<<3)|0;p=0;e=1;k=n;n=h;g=c[l>>2]^s^c[j>>2];j=c[l+4>>2]^m^c[j+4>>2];l=0;D=38}else D=7}else{h=d>>>18&15;g=c[b+(p<<2)>>2]|0;D=7}while(0);if((D|0)==7)if(!g){o=b+5364|0;p=0;n=h;g=s;k=e;l=0;D=35}else{j=0;n=h;x=g;D=9}if((D|0)==9){k=x&7;if((k|0)==1){if(j){h=p-((G|0)==0?8:-8)|0;c[b+(h<<2)>>2]=0;g=c[E>>2]|0}else{g=e;h=p}o=973136+(x<<9)+(h<<3)|0;e=g;t=c[e+4>>2]^c[o+4>>2];u=g;c[u>>2]=c[e>>2]^c[o>>2];c[u+4>>2]=t;u=h}else{u=e+16+(F<<2)|0;c[u>>2]=(c[u>>2]|0)-(c[6728+(x<<2)>>2]|0);u=p}t=b+256|0;l=26112+(u<<3)|0;o=l;j=t;e=c[j+4>>2]^c[o+4>>2];g=t;c[g>>2]=c[j>>2]^c[o>>2];c[g+4>>2]=e;g=b+256+(k<<3)|0;k=l;e=g;o=c[e+4>>2]^c[k+4>>2];c[g>>2]=c[e>>2]^c[k>>2];c[g+4>>2]=o;g=x>>3;o=b+320+(g<<3)|0;k=o;e=c[k+4>>2]^c[l+4>>2];c[o>>2]=c[k>>2]^c[l>>2];c[o+4>>2]=e;o=b+5364|0;if((c[o>>2]|0)==2)c[b+(u<<2)>>2]=0;k=b+336+(x<<2)|0;e=(c[k>>2]|0)+-1|0;c[k>>2]=e;e=c[b+400+(x<<8)+(e<<2)>>2]|0;j=c[b+4568+(u<<2)>>2]|0;c[b+4568+(e<<2)>>2]=j;c[b+400+(x<<8)+(j<<2)>>2]=e;c[b+400+(x<<8)+(c[k>>2]<<2)>>2]=64;g=g<<3;j=b+336+(g<<2)|0;c[j>>2]=(c[j>>2]|0)+-1;j=c[o>>2]|0;if((j|0)==3){N=b+4560|0;l=N;O=26112+(p<<3)|0;e=c[O>>2]|0;O=c[O+4>>2]|0;M=e&c[l>>2];l=O&c[l+4>>2];a[(c[E>>2]|0)+332>>0]=((M|0)!=0|(l|0)!=0)&1;l=(M|0)==0&(l|0)==0?x:g|1;g=l^8;l=b+4496+(g>>3<<5)+((l&7)<<2)|0;M=c[l>>2]|0;h=M+1|0;c[l>>2]=h;l=c[E>>2]|0;P=l+44|0;j=c[o>>2]|0;c[P>>2]=(c[P>>2]|0)+(c[1035344+(j*4160|0)+(g*260|0)+256>>2]|0);M=981600+(g*136|0)+(M<<3)|0;h=981600+(g*136|0)+(h<<3)|0;g=c[M>>2]^s^c[h>>2];h=c[M+4>>2]^m^c[h+4>>2];M=N;m=c[M+4>>2]&~O;s=N;c[s>>2]=c[M>>2]&~e;c[s+4>>2]=m}else{g=s;h=m;l=c[E>>2]|0}N=973136+(x<<9)+(u<<3)|0;g=c[N>>2]^g;h=c[N+4>>2]^h;N=973136+(x<<9)+(c[k>>2]<<3)|0;P=l+8|0;M=P;O=c[M+4>>2]^c[N+4>>2];c[P>>2]=c[M>>2]^c[N>>2];c[P+4>>2]=O;a:do if((j|0)==2?(P=30016+(p<<3)|0,r=26112+(I<<3)|0,q=c[P>>2]&~c[r>>2],r=c[P+4>>2]&~c[r+4>>2],!((q|0)==0&(r|0)==0)):0){k=q;j=r;r=l;while(1){e=k;p=j;while(1){j=hb(e|0,p|0,0)|0;k=Xu(e|0,p|0,-1,-1)|0;e=k&e;p=C&p;k=b+(j<<2)|0;l=c[k>>2]|0;c[r+76+(j<<2)>>2]=l;if(l|0?(v=l&7,(v|0)!=1):0){m=v;q=e;break}if((e|0)==0&(p|0)==0){j=h;break a}}e=l>>3;N=r+16+(e<<2)|0;c[N>>2]=(c[N>>2]|0)-(c[6728+(m<<2)>>2]|0);N=26112+(j<<3)|0;s=N;M=t;O=c[M+4>>2]^c[s+4>>2];P=t;c[P>>2]=c[M>>2]^c[s>>2];c[P+4>>2]=O;P=b+256+(m<<3)|0;O=N;s=P;M=c[s+4>>2]^c[O+4>>2];c[P>>2]=c[s>>2]^c[O>>2];c[P+4>>2]=M;P=b+320+(e<<3)|0;M=P;O=c[M+4>>2]^c[N+4>>2];c[P>>2]=c[M>>2]^c[N>>2];c[P+4>>2]=O;if((c[o>>2]|0)==2)c[k>>2]=0;O=b+336+(l<<2)|0;N=(c[O>>2]|0)+-1|0;c[O>>2]=N;N=c[b+400+(l<<8)+(N<<2)>>2]|0;k=c[b+4568+(j<<2)>>2]|0;c[b+4568+(N<<2)>>2]=k;c[b+400+(l<<8)+(k<<2)>>2]=N;c[b+400+(l<<8)+(c[O>>2]<<2)>>2]=64;e=b+336+(e<<3<<2)|0;c[e>>2]=(c[e>>2]|0)+-1;e=973136+(l<<9)+(j<<3)|0;g=c[e>>2]^g;h=c[e+4>>2]^h;O=973136+(l<<9)+(c[O>>2]<<3)|0;e=c[E>>2]|0;k=e+8|0;N=k;P=c[N+4>>2]^c[O+4>>2];c[k>>2]=c[N>>2]^c[O>>2];c[k+4>>2]=P;k=e+44|0;c[k>>2]=(c[k>>2]|0)-(c[1035344+((c[o>>2]|0)*4160|0)+(l*260|0)+(j<<2)>>2]|0);k=e+24|0;l=c[k>>2]|0;if((l|0)!=0?(w=c[b+4824+(j<<2)>>2]|0,(w|0)!=0):0){P=981392+((w&l)<<3)|0;g=c[P>>2]^g;h=c[P+4>>2]^h;c[k>>2]=l&~w}if((q|0)==0&(p|0)==0)break;else{k=q;j=p;r=e}}j=h}else j=h;while(0);h=c[E>>2]|0;O=h+44|0;P=c[o>>2]|0;c[O>>2]=(c[O>>2]|0)-(c[1035344+(P*4160|0)+(x*260|0)+(u<<2)>>2]|0);c[h+28>>2]=0;if((P|0)==2){s=973136+(n<<9)+(I<<3)|0;e=0;m=h;h=c[s>>2]^g;g=c[s+4>>2]^j;s=o;v=1;u=n;t=x}else{p=1;m=j;k=h;l=x;D=35}}if((D|0)==35)if(H){N=973136+(n<<9)+(c[K>>2]<<3)|0;j=n&7;P=c[b+4496+(n>>3<<5)+(j<<2)>>2]|0;O=981600+(n*136|0)+(P<<3)|0;P=981600+(n*136|0)+(P+1<<3)|0;h=c[N>>2]^g^c[O>>2]^c[P>>2];g=c[N+4>>2]^m^c[O+4>>2]^c[P+4>>2];if((j|0)==1){e=0;m=k;s=o;v=p;u=n;t=l}else{e=k+16+(G<<2)|0;c[e>>2]=(c[e>>2]|0)+(c[6728+(j<<2)>>2]|0);e=0;m=k;s=o;v=p;u=n;t=l}}else{e=0;j=m;D=38}if((D|0)==38){v=973136+(n<<9)+(I<<3)|0;s=973136+(n<<9)+(c[K>>2]<<3)|0;m=k;h=c[v>>2]^g^c[s>>2];g=c[v+4>>2]^j^c[s+4>>2];s=o;v=p;u=n;t=l}j=m+48|0;k=c[j>>2]|0;if((k|0)!=64){P=981328+((k&7)<<3)|0;h=c[P>>2]^h;g=c[P+4>>2]^g;c[j>>2]=64}if((!H?(y=m+24|0,z=c[y>>2]|0,(z|0)!=0):0)?(A=c[b+4824+(c[K>>2]<<2)>>2]|c[b+4824+(I<<2)>>2],(A|0)!=0):0){P=981392+((A&z)<<3)|0;h=c[P>>2]^h;g=c[P+4>>2]^g;c[y>>2]=z&~A}q=c[s>>2]|0;if(!((q|0)!=7|f^1)){O=m+36+(G<<2)|0;N=c[O>>2]|0;P=983776+(G<<5)+(N<<3)|0;h=c[P>>2]^h;P=c[P+4>>2]^g;g=N+1|0;c[O>>2]=g;g=983776+(G<<5)+(g<<3)|0;h=h^c[g>>2];g=P^c[g+4>>2]}p=(q|0)==2;r=v&p;if(r){N=b+(I<<2)|0;c[m+76+(I<<2)>>2]=c[N>>2];j=b+256|0;O=26112+(I<<3)|0;D=O;P=j;k=c[P+4>>2]^c[D+4>>2];c[j>>2]=c[P>>2]^c[D>>2];c[j+4>>2]=k;j=u&7;k=b+256+(j<<3)|0;D=O;P=k;M=c[P+4>>2]^c[D+4>>2];c[k>>2]=c[P>>2]^c[D>>2];c[k+4>>2]=M;k=u>>3;M=b+320+(k<<3)|0;D=M;P=c[D+4>>2]^c[O+4>>2];c[M>>2]=c[D>>2]^c[O>>2];c[M+4>>2]=P;c[N>>2]=0;N=b+336+(u<<2)|0;M=(c[N>>2]|0)+-1|0;c[N>>2]=M;M=c[b+400+(u<<8)+(M<<2)>>2]|0;P=c[b+4568+(I<<2)>>2]|0;c[b+4568+(M<<2)>>2]=P;c[b+400+(u<<8)+(P<<2)>>2]=M;c[b+400+(u<<8)+(c[N>>2]<<2)>>2]=64;k=b+336+(k<<3<<2)|0;c[k>>2]=(c[k>>2]|0)+-1;N=973136+(u<<9)+(c[N>>2]<<3)|0;k=c[E>>2]|0;P=k+8|0;M=P;O=c[M+4>>2]^c[N+4>>2];c[P>>2]=c[M>>2]^c[N>>2];c[P+4>>2]=O;if((j|0)==1)D=57;else{D=k+16+(G<<2)|0;c[D>>2]=(c[D>>2]|0)-(c[6728+(j<<2)>>2]|0);D=56}}else{do if(!H)if(e){j=u&7;break}else{O=c[K>>2]|0;N=26112+(I<<3)|0;j=26112+(O<<3)|0;M=c[j>>2]^c[N>>2];N=c[j+4>>2]^c[N+4>>2];j=b+256|0;A=j;P=c[A+4>>2]^N;c[j>>2]=c[A>>2]^M;c[j+4>>2]=P;j=u&7;P=b+256+(j<<3)|0;A=P;D=c[A+4>>2]^N;c[P>>2]=c[A>>2]^M;c[P+4>>2]=D;P=b+320+(u>>3<<3)|0;D=P;N=c[D+4>>2]^N;c[P>>2]=c[D>>2]^M;c[P+4>>2]=N;c[b+(I<<2)>>2]=0;c[b+(O<<2)>>2]=u;P=c[b+4568+(I<<2)>>2]|0;c[b+4568+(O<<2)>>2]=P;c[b+400+(u<<8)+(P<<2)>>2]=O;break}else{N=c[K>>2]|0;c[b+(N<<2)>>2]=u;j=b+256|0;D=26112+(N<<3)|0;A=D;O=j;P=c[O+4>>2]|c[A+4>>2];c[j>>2]=c[O>>2]|c[A>>2];c[j+4>>2]=P;j=u&7;P=b+256+(j<<3)|0;A=D;O=P;M=c[O+4>>2]|c[A+4>>2];c[P>>2]=c[O>>2]|c[A>>2];c[P+4>>2]=M;P=u>>3;M=b+320+(P<<3)|0;A=M;O=c[A+4>>2]|c[D+4>>2];c[M>>2]=c[A>>2]|c[D>>2];c[M+4>>2]=O;M=b+336+(u<<2)|0;O=c[M>>2]|0;c[M>>2]=O+1;c[b+4568+(N<<2)>>2]=O;c[b+400+(u<<8)+(O<<2)>>2]=N;O=b+336+(P<<3<<2)|0;c[O>>2]=(c[O>>2]|0)+1;P=b+4496+(P<<5)+(j<<2)|0;c[P>>2]=(c[P>>2]|0)+-1}while(0);if((j|0)==1)D=57;else D=56}if((D|0)==56){e=q;m=c[E>>2]|0}else if((D|0)==57){if((q|0)==4?(I>>>3|0)==(G*7|0):0)D=71;else D=59;do if((D|0)==59)if(!r){o=c[K>>2]|0;if((o^I|0)==16?(O=26944+((G<<3|1)<<9)+(o-((G|0)==0?8:-8)<<3)|0,N=b+320+(F<<3)|0,P=b+264|0,!((c[N>>2]&c[O>>2]&c[P>>2]|0)==0?(c[N+4>>2]&c[O+4>>2]&c[P+4>>2]|0)==0:0)):0){D=(o+I|0)/2|0;c[(c[E>>2]|0)+48>>2]=D;D=981328+((D&7)<<3)|0;h=c[D>>2]^h;g=c[D+4>>2]^g;D=73;break}if((B|0)==16384){if(!(d&65536))j=(d>>>12&3)+2|0;else j=6;m=j+(G<<3)|0;l=b+256|0;n=26112+(o<<3)|0;N=n;j=l;O=c[j+4>>2]^c[N+4>>2];e=l;c[e>>2]=c[j>>2]^c[N>>2];c[e+4>>2]=O;e=b+264|0;O=n;N=e;j=c[N+4>>2]^c[O+4>>2];c[e>>2]=c[N>>2]^c[O>>2];c[e+4>>2]=j;e=u>>3;j=b+320+(e<<3)|0;O=n;N=j;P=c[N+4>>2]^c[O+4>>2];c[j>>2]=c[N>>2]^c[O>>2];c[j+4>>2]=P;j=b+(o<<2)|0;if(p)c[j>>2]=0;k=b+336+(u<<2)|0;M=(c[k>>2]|0)+-1|0;c[k>>2]=M;M=c[b+400+(u<<8)+(M<<2)>>2]|0;N=b+4568+(o<<2)|0;D=c[N>>2]|0;c[b+4568+(M<<2)>>2]=D;c[b+400+(u<<8)+(D<<2)>>2]=M;c[b+400+(u<<8)+(c[k>>2]<<2)>>2]=64;D=b+336+(e<<3<<2)|0;c[D>>2]=(c[D>>2]|0)+-1;c[j>>2]=m;D=n;j=l;M=c[j+4>>2]|c[D+4>>2];P=l;c[P>>2]=c[j>>2]|c[D>>2];c[P+4>>2]=M;P=b+256+((m&7)<<3)|0;M=n;D=P;j=c[D+4>>2]|c[M+4>>2];c[P>>2]=c[D>>2]|c[M>>2];c[P+4>>2]=j;P=m>>3;j=b+320+(P<<3)|0;M=n;D=j;O=c[D+4>>2]|c[M+4>>2];c[j>>2]=c[D>>2]|c[M>>2];c[j+4>>2]=O;j=b+336+(m<<2)|0;O=c[j>>2]|0;c[j>>2]=O+1;c[N>>2]=O;c[b+400+(m<<8)+(O<<2)>>2]=o;P=b+336+(P<<3<<2)|0;c[P>>2]=(c[P>>2]|0)+1;if((q|0)==3){P=b+4560|0;N=P;M=n;O=c[M+4>>2]|c[N+4>>2];c[P>>2]=c[M>>2]|c[N>>2];c[P+4>>2]=O}d=973136+(u<<9)+(o<<3)|0;P=c[d>>2]|0;d=c[d+4>>2]|0;D=973136+(m<<9)+(o<<3)|0;h=P^h^c[D>>2];g=d^g^c[D+4>>2];D=c[E>>2]|0;N=D;d=c[N+4>>2]^d;M=D;c[M>>2]=c[N>>2]^P;c[M+4>>2]=d;M=973136+(m<<9)+((c[j>>2]|0)+-1<<3)|0;d=973136+(u<<9)+(c[k>>2]<<3)|0;P=D+8|0;N=P;O=c[d+4>>2]^c[M+4>>2]^c[N+4>>2];c[P>>2]=c[d>>2]^c[M>>2]^c[N>>2];c[P+4>>2]=O;P=D+44|0;c[P>>2]=(c[1035344+(q*4160|0)+(m*260|0)+(o<<2)>>2]|0)-(c[1035344+(q*4160|0)+(u*260|0)+(o<<2)>>2]|0)+(c[P>>2]|0);D=D+16+(G<<2)|0;c[D>>2]=(c[D>>2]|0)+(c[6728+(m<<2)>>2]|0);D=71}else D=73}else D=72;while(0);if((D|0)==71)if(r)D=72;else D=73;do if((D|0)==72){N=973136+((G<<3|1)<<9)+(I<<3)|0;P=c[E>>2]|0;M=P;O=c[M+4>>2]^c[N+4>>2];c[P>>2]=c[M>>2]^c[N>>2];c[P+4>>2]=O}else if((D|0)==73)if(H){N=973136+(u<<9)+(c[K>>2]<<3)|0;P=c[E>>2]|0;M=P;O=c[M+4>>2]^c[N+4>>2];c[P>>2]=c[M>>2]^c[N>>2];c[P+4>>2]=O;break}else{M=973136+(u<<9)+(I<<3)|0;d=973136+(u<<9)+(c[K>>2]<<3)|0;P=c[E>>2]|0;N=P;O=c[d+4>>2]^c[M+4>>2]^c[N+4>>2];c[P>>2]=c[d>>2]^c[M>>2]^c[N>>2];c[P+4>>2]=O;break}while(0);m=c[E>>2]|0;c[m+28>>2]=0;e=c[s>>2]|0}l=v&(e|0)==2;k=m+44|0;j=c[1035344+(e*4160|0)+(u*260|0)+(I<<2)>>2]|0;if(l)j=(c[k>>2]|0)-j|0;else j=(c[1035344+(e*4160|0)+(u*260|0)+(c[K>>2]<<2)>>2]|0)-j+(c[k>>2]|0)|0;c[k>>2]=j;c[m+72>>2]=t;j=(e|0)!=3;if(!(v|j))a[m+332>>0]=0;P=m+56|0;c[P>>2]=h;c[P+4>>2]=g;if(l)f=(c[b+336+((c[J>>2]<<3^14)<<2)>>2]|0)!=0&f;switch(e|0){case 6:{O=c[26112+(c[b+400+((G<<3|6)<<8)>>2]<<3)+4>>2]&-16777216;P=m+64|0;c[P>>2]=0;c[P+4>>2]=O;break}case 1:{P=m+64|0;c[P>>2]=0;c[P+4>>2]=0;break}default:{if(f){switch(e|0){case 4:{f=F<<3|6;if(!(c[b+336+(f<<2)>>2]|0))f=64;else D=92;break}case 2:{f=F<<3|6;if(!(c[b+336+(f<<2)>>2]|0))f=64;else D=92;break}default:{f=F<<3|6;D=92}}if((D|0)==92)f=c[b+400+(f<<8)>>2]|0;O=b+256|0;F=c[O>>2]|0;O=c[O+4>>2]|0;z=31552+(f<<3)|0;y=b+320|0;A=b+264|0;u=c[A>>2]|0;A=c[A+4>>2]|0;w=27456+(f<<3)|0;x=b+328|0;d=27968+(f<<3)|0;B=b+272|0;D=24064+(f<<3)|0;E=24576+(f<<3)|0;E=(_(c[D+4>>2]&O,c[E+4>>2]|0)|0)^(_(c[D>>2]&F,c[E>>2]|0)|0);E=(c[1031004+(f<<2)>>2]|0)+(E>>>(c[1031260+(f<<2)>>2]|0)<<3)|0;D=b+288|0;M=b+296|0;v=c[M>>2]|0;M=c[M+4>>2]|0;P=25088+(f<<3)|0;N=25600+(f<<3)|0;N=(_(c[P+4>>2]&O,c[N+4>>2]|0)|0)^(_(c[P>>2]&F,c[N>>2]|0)|0);N=(c[1031516+(f<<2)>>2]|0)+(N>>>(c[1031772+(f<<2)>>2]|0)<<3)|0;F=b+280|0;P=30016+(f<<3)|0;O=b+304|0;g=b+320+(G<<3)|0;f=(c[w>>2]&u&c[x>>2]|c[y>>2]&c[z>>2]&u|c[B>>2]&c[d>>2]|(v|c[D>>2])&c[E>>2]|(c[F>>2]|v)&c[N>>2]|c[O>>2]&c[P>>2])&c[g>>2];g=(c[w+4>>2]&A&c[x+4>>2]|c[y+4>>2]&c[z+4>>2]&A|c[B+4>>2]&c[d+4>>2]|(M|c[D+4>>2])&c[E+4>>2]|(c[F+4>>2]|M)&c[N+4>>2]|c[O+4>>2]&c[P+4>>2])&c[g+4>>2]}else{f=0;g=0}P=m+64|0;c[P>>2]=f;c[P+4>>2]=g}}if(H|j){P=c[J>>2]|0;P=P^1;c[J>>2]=P;Ef(b,m);i=L;return}h=b+4560|0;k=h;j=c[k>>2]|0;k=c[k+4>>2]|0;g=26112+(I<<3)|0;f=c[g>>2]|0;g=c[g+4>>2]|0;if((f&j|0)==0&(g&k|0)==0){P=c[J>>2]|0;P=P^1;c[J>>2]=P;Ef(b,m);i=L;return}N=26112+(c[K>>2]<<3)|0;O=c[N+4>>2]|k&~g;P=h;c[P>>2]=c[N>>2]|j&~f;c[P+4>>2]=O;P=c[J>>2]|0;P=P^1;c[J>>2]=P;Ef(b,m);i=L;return}function Of(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0;n=c[e>>2]|0;p=(n|0)>(d|0);c[f>>2]=n;n=b*56|0;c[g>>2]=(p?5:3)|n;c[e>>2]=(p?6:2)|n;b=b<<3;n=b|6;p=a+256|0;m=26112+(d<<3)|0;l=m;i=p;o=c[i+4>>2]^c[l+4>>2];j=p;c[j>>2]=c[i>>2]^c[l>>2];c[j+4>>2]=o;j=a+304|0;o=m;l=j;i=c[l+4>>2]^c[o+4>>2];k=j;c[k>>2]=c[l>>2]^c[o>>2];c[k+4>>2]=i;k=a+320+(b>>3<<3)|0;i=k;o=c[i+4>>2]^c[m+4>>2];l=k;c[l>>2]=c[i>>2]^c[m>>2];c[l+4>>2]=o;l=a+5364|0;if((c[l>>2]|0)==2)c[a+(d<<2)>>2]=0;m=a+336+(n<<2)|0;h=(c[m>>2]|0)+-1|0;c[m>>2]=h;h=c[a+400+(n<<8)+(h<<2)>>2]|0;o=c[a+4568+(d<<2)>>2]|0;c[a+4568+(h<<2)>>2]=o;c[a+400+(n<<8)+(o<<2)>>2]=h;c[a+400+(n<<8)+(c[m>>2]<<2)>>2]=64;o=a+336+(b<<2)|0;c[o>>2]=(c[o>>2]|0)+-1;h=b|4;i=c[f>>2]|0;s=26112+(i<<3)|0;u=s;r=p;q=c[r+4>>2]^c[u+4>>2];b=p;c[b>>2]=c[r>>2]^c[u>>2];c[b+4>>2]=q;b=a+288|0;q=s;u=b;r=c[u+4>>2]^c[q+4>>2];t=b;c[t>>2]=c[u>>2]^c[q>>2];c[t+4>>2]=r;t=k;r=c[t+4>>2]^c[s+4>>2];q=k;c[q>>2]=c[t>>2]^c[s>>2];c[q+4>>2]=r;if((c[l>>2]|0)==2)c[a+(i<<2)>>2]=0;s=a+336+(h<<2)|0;r=(c[s>>2]|0)+-1|0;c[s>>2]=r;r=c[a+400+(h<<8)+(r<<2)>>2]|0;q=c[a+4568+(i<<2)>>2]|0;c[a+4568+(r<<2)>>2]=q;c[a+400+(h<<8)+(q<<2)>>2]=r;c[a+400+(h<<8)+(c[s>>2]<<2)>>2]=64;c[o>>2]=(c[o>>2]|0)+-1;c[a+(c[f>>2]<<2)>>2]=0;c[a+(d<<2)>>2]=0;q=c[e>>2]|0;c[a+(q<<2)>>2]=n;e=26112+(q<<3)|0;r=e;u=p;f=c[u+4>>2]|c[r+4>>2];t=p;c[t>>2]=c[u>>2]|c[r>>2];c[t+4>>2]=f;t=e;f=j;r=c[f+4>>2]|c[t+4>>2];u=j;c[u>>2]=c[f>>2]|c[t>>2];c[u+4>>2]=r;u=k;r=c[u+4>>2]|c[e+4>>2];t=k;c[t>>2]=c[u>>2]|c[e>>2];c[t+4>>2]=r;t=c[m>>2]|0;c[m>>2]=t+1;c[a+4568+(q<<2)>>2]=t;c[a+400+(n<<8)+(t<<2)>>2]=q;c[o>>2]=(c[o>>2]|0)+1;t=c[g>>2]|0;c[a+(t<<2)>>2]=h;q=26112+(t<<3)|0;r=q;e=p;g=c[e+4>>2]|c[r+4>>2];u=p;c[u>>2]=c[e>>2]|c[r>>2];c[u+4>>2]=g;u=q;g=b;r=c[g+4>>2]|c[u+4>>2];e=b;c[e>>2]=c[g>>2]|c[u>>2];c[e+4>>2]=r;e=k;r=c[e+4>>2]|c[q+4>>2];u=k;c[u>>2]=c[e>>2]|c[q>>2];c[u+4>>2]=r;u=c[s>>2]|0;c[s>>2]=u+1;c[a+4568+(t<<2)>>2]=u;c[a+400+(h<<8)+(u<<2)>>2]=t;c[o>>2]=(c[o>>2]|0)+1;return}function Pf(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,D=0,E=0,F=0,G=0,H=0;E=i;i=i+16|0;o=E+8|0;m=E+4|0;n=E;j=b+5348|0;w=c[j>>2]|0;l=w^1;c[j>>2]=l;j=(d&131072|0)==0;y=j?d>>>6&63:64;D=d&63;c[o>>2]=D;q=b+(D<<2)|0;e=c[q>>2]|0;B=b+5364|0;f=c[B>>2]|0;k=(f|0)==2;if(k?(h=c[b+5356>>2]|0,(c[h+72>>2]|0)!=0):0)e=c[h+76+(y<<2)>>2]|0;p=j?d&49152:131072;do if((p|0)==16384){if(k?c[(c[b+5356>>2]|0)+72>>2]|0:0){h=14;break}h=b+256|0;j=26112+(D<<3)|0;G=j;k=h;F=c[k+4>>2]^c[G+4>>2];f=h;c[f>>2]=c[k>>2]^c[G>>2];c[f+4>>2]=F;f=b+256+((e&7)<<3)|0;F=j;G=f;k=c[G+4>>2]^c[F+4>>2];c[f>>2]=c[G>>2]^c[F>>2];c[f+4>>2]=k;f=e>>3;k=b+320+(f<<3)|0;F=j;G=k;d=c[G+4>>2]^c[F+4>>2];c[k>>2]=c[G>>2]^c[F>>2];c[k+4>>2]=d;if((c[B>>2]|0)==2)c[q>>2]=0;d=b+336+(e<<2)|0;G=(c[d>>2]|0)+-1|0;c[d>>2]=G;G=c[b+400+(e<<8)+(G<<2)>>2]|0;F=b+4568+(D<<2)|0;H=c[F>>2]|0;c[b+4568+(G<<2)>>2]=H;c[b+400+(e<<8)+(H<<2)>>2]=G;c[b+400+(e<<8)+(c[d>>2]<<2)>>2]=64;f=b+336+(f<<3<<2)|0;c[f>>2]=(c[f>>2]|0)+-1;f=l<<3;e=f|1;c[q>>2]=e;d=j;H=h;G=c[H+4>>2]|c[d+4>>2];k=h;c[k>>2]=c[H>>2]|c[d>>2];c[k+4>>2]=G;k=b+264|0;h=j;G=k;d=c[G+4>>2]|c[h+4>>2];c[k>>2]=c[G>>2]|c[h>>2];c[k+4>>2]=d;k=b+320+(f>>3<<3)|0;d=j;h=k;G=c[h+4>>2]|c[d+4>>2];c[k>>2]=c[h>>2]|c[d>>2];c[k+4>>2]=G;k=b+336+(e<<2)|0;G=c[k>>2]|0;c[k>>2]=G+1;c[F>>2]=G;c[b+400+(e<<8)+(G<<2)>>2]=D;f=b+336+(f<<2)|0;c[f>>2]=(c[f>>2]|0)+1;f=c[B>>2]|0;if((f|0)==3){f=b+4560|0;H=j;G=f;h=c[G+4>>2]&~c[H+4>>2];c[f>>2]=c[G>>2]&~c[H>>2];c[f+4>>2]=h;f=3;h=11}else h=11}else h=11;while(0);do if((h|0)==11){if((p|0)!=49152)if((f|0)==2){h=14;break}else{h=16;break}Qf(b,l,y,o,m,n);H=b+5356|0;G=c[H>>2]|0;G=G+336|0;G=c[G>>2]|0;c[H>>2]=G;H=b+5344|0;G=c[H>>2]|0;G=G+-1|0;c[H>>2]=G;i=E;return}while(0);if((h|0)==14)if(!(c[(c[b+5356>>2]|0)+72>>2]|0))h=16;else{c[b+(y<<2)>>2]=e;H=b+256|0;q=26112+(y<<3)|0;G=q;F=H;o=c[F+4>>2]|c[G+4>>2];c[H>>2]=c[F>>2]|c[G>>2];c[H+4>>2]=o;H=b+256+((e&7)<<3)|0;o=q;G=H;F=c[G+4>>2]|c[o+4>>2];c[H>>2]=c[G>>2]|c[o>>2];c[H+4>>2]=F;H=e>>3;F=b+320+(H<<3)|0;o=F;G=c[o+4>>2]|c[q+4>>2];c[F>>2]=c[o>>2]|c[q>>2];c[F+4>>2]=G;F=b+336+(e<<2)|0;G=c[F>>2]|0;c[F>>2]=G+1;c[b+4568+(y<<2)>>2]=G;c[b+400+(e<<8)+(G<<2)>>2]=y;H=b+336+(H<<3<<2)|0;c[H>>2]=(c[H>>2]|0)+1}do if((h|0)==16){if((p|0)!=131072){G=26112+(D<<3)|0;H=26112+(y<<3)|0;F=c[H>>2]^c[G>>2];G=c[H+4>>2]^c[G+4>>2];H=b+256|0;o=H;n=c[o+4>>2]^G;c[H>>2]=c[o>>2]^F;c[H+4>>2]=n;H=b+256+((e&7)<<3)|0;n=H;o=c[n+4>>2]^G;c[H>>2]=c[n>>2]^F;c[H+4>>2]=o;H=b+320+(e>>3<<3)|0;o=H;G=c[o+4>>2]^G;c[H>>2]=c[o>>2]^F;c[H+4>>2]=G;c[q>>2]=0;c[b+(y<<2)>>2]=e;H=c[b+4568+(D<<2)>>2]|0;c[b+4568+(y<<2)>>2]=H;c[b+400+(e<<8)+(H<<2)>>2]=y;break}f=b+256|0;F=26112+(D<<3)|0;o=F;G=f;h=c[G+4>>2]^c[o+4>>2];c[f>>2]=c[G>>2]^c[o>>2];c[f+4>>2]=h;f=e&7;h=b+256+(f<<3)|0;o=F;G=h;H=c[G+4>>2]^c[o+4>>2];c[h>>2]=c[G>>2]^c[o>>2];c[h+4>>2]=H;h=e>>3;H=b+320+(h<<3)|0;o=H;G=c[o+4>>2]^c[F+4>>2];c[H>>2]=c[o>>2]^c[F>>2];c[H+4>>2]=G;if((c[B>>2]|0)==2)c[q>>2]=0;H=b+336+(e<<2)|0;F=(c[H>>2]|0)+-1|0;c[H>>2]=F;F=c[b+400+(e<<8)+(F<<2)>>2]|0;G=c[b+4568+(D<<2)>>2]|0;c[b+4568+(F<<2)>>2]=G;c[b+400+(e<<8)+(G<<2)>>2]=F;c[b+400+(e<<8)+(c[H>>2]<<2)>>2]=64;H=b+336+(h<<3<<2)|0;c[H>>2]=(c[H>>2]|0)+-1;c[q>>2]=0;H=b+4496+(h<<5)+(f<<2)|0;c[H>>2]=(c[H>>2]|0)+1}while(0);f=c[B>>2]|0;if((f|0)==3?(r=b+4560|0,t=r,s=c[t>>2]|0,t=c[t+4>>2]|0,v=26112+(D<<3)|0,u=c[v>>2]|0,v=c[v+4>>2]|0,!((u&s|0)==0&(v&t|0)==0)):0){F=26112+(y<<3)|0;G=c[F+4>>2]|t&~v;H=r;c[H>>2]=c[F>>2]|s&~u;c[H+4>>2]=G}d=b+5356|0;e=c[(c[d>>2]|0)+72>>2]|0;if(!e){H=d;G=c[H>>2]|0;G=G+336|0;G=c[G>>2]|0;c[H>>2]=G;H=b+5344|0;G=c[H>>2]|0;G=G+-1|0;c[H>>2]=G;i=E;return}if((p|0)==32768)j=D-((w|0)==1?8:-8)|0;else j=D;if((f|0)==2?(x=30016+(D<<3)|0,g=c[x>>2]|0,x=c[x+4>>2]|0,!((g|0)==0&(x|0)==0)):0){h=b+256|0;e=x;do{f=hb(g|0,e|0,0)|0;H=Xu(g|0,e|0,-1,-1)|0;g=H&g;e=C&e;if(((f|0)!=(y|0)?(z=c[(c[d>>2]|0)+76+(f<<2)>>2]|0,z|0):0)?(A=z&7,(A|0)!=1):0){c[b+(f<<2)>>2]=z;x=26112+(f<<3)|0;G=x;F=h;w=c[F+4>>2]|c[G+4>>2];H=h;c[H>>2]=c[F>>2]|c[G>>2];c[H+4>>2]=w;H=b+256+(A<<3)|0;w=x;G=H;F=c[G+4>>2]|c[w+4>>2];c[H>>2]=c[G>>2]|c[w>>2];c[H+4>>2]=F;H=z>>3;F=b+320+(H<<3)|0;w=F;G=c[w+4>>2]|c[x+4>>2];c[F>>2]=c[w>>2]|c[x>>2];c[F+4>>2]=G;F=b+336+(z<<2)|0;G=c[F>>2]|0;c[F>>2]=G+1;c[b+4568+(f<<2)>>2]=G;c[b+400+(z<<8)+(G<<2)>>2]=f;H=b+336+(H<<3<<2)|0;c[H>>2]=(c[H>>2]|0)+1}}while(!((g|0)==0&(e|0)==0));e=c[(c[d>>2]|0)+72>>2]|0}c[b+(j<<2)>>2]=e;H=b+256|0;A=26112+(j<<3)|0;G=A;F=H;z=c[F+4>>2]|c[G+4>>2];c[H>>2]=c[F>>2]|c[G>>2];c[H+4>>2]=z;H=b+256+((e&7)<<3)|0;z=A;G=H;F=c[G+4>>2]|c[z+4>>2];c[H>>2]=c[G>>2]|c[z>>2];c[H+4>>2]=F;H=e>>3;F=b+320+(H<<3)|0;z=F;G=c[z+4>>2]|c[A+4>>2];c[F>>2]=c[z>>2]|c[A>>2];c[F+4>>2]=G;F=b+336+(e<<2)|0;G=c[F>>2]|0;c[F>>2]=G+1;c[b+4568+(j<<2)>>2]=G;c[b+400+(e<<8)+(G<<2)>>2]=j;H=b+336+(H<<3<<2)|0;c[H>>2]=(c[H>>2]|0)+1;if((c[B>>2]|0)!=3){H=d;G=c[H>>2]|0;G=G+336|0;G=c[G>>2]|0;c[H>>2]=G;H=b+5344|0;G=c[H>>2]|0;G=G+-1|0;c[H>>2]=G;i=E;return}G=c[d>>2]|0;H=c[G+72>>2]|0;H=b+4496+((H>>3^1)<<5)+(((a[G+332>>0]|0)==0?H&7:1)<<2)|0;c[H>>2]=(c[H>>2]|0)+-1;if(!(a[(c[d>>2]|0)+332>>0]|0)){H=d;G=c[H>>2]|0;G=G+336|0;G=c[G>>2]|0;c[H>>2]=G;H=b+5344|0;G=c[H>>2]|0;G=G+-1|0;c[H>>2]=G;i=E;return}H=b+4560|0;F=26112+(D<<3)|0;D=H;G=c[D+4>>2]|c[F+4>>2];c[H>>2]=c[D>>2]|c[F>>2];c[H+4>>2]=G;H=d;G=c[H>>2]|0;G=G+336|0;G=c[G>>2]|0;c[H>>2]=G;H=b+5344|0;G=c[H>>2]|0;G=G+-1|0;c[H>>2]=G;i=E;return}function Qf(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0;h=c[e>>2]|0;o=(h|0)>(d|0);c[f>>2]=h;h=b*56|0;c[g>>2]=(o?5:3)|h;h=(o?6:2)|h;c[e>>2]=h;b=b<<3;o=b|6;p=a+256|0;j=26112+(h<<3)|0;m=j;i=p;n=c[i+4>>2]^c[m+4>>2];k=p;c[k>>2]=c[i>>2]^c[m>>2];c[k+4>>2]=n;k=a+304|0;n=j;m=k;i=c[m+4>>2]^c[n+4>>2];l=k;c[l>>2]=c[m>>2]^c[n>>2];c[l+4>>2]=i;l=a+320+(b>>3<<3)|0;i=l;n=c[i+4>>2]^c[j+4>>2];m=l;c[m>>2]=c[i>>2]^c[j>>2];c[m+4>>2]=n;m=a+5364|0;if((c[m>>2]|0)==2)c[a+(h<<2)>>2]=0;n=a+336+(o<<2)|0;i=(c[n>>2]|0)+-1|0;c[n>>2]=i;i=c[a+400+(o<<8)+(i<<2)>>2]|0;j=c[a+4568+(h<<2)>>2]|0;c[a+4568+(i<<2)>>2]=j;c[a+400+(o<<8)+(j<<2)>>2]=i;c[a+400+(o<<8)+(c[n>>2]<<2)>>2]=64;j=a+336+(b<<2)|0;c[j>>2]=(c[j>>2]|0)+-1;h=b|4;i=c[g>>2]|0;s=26112+(i<<3)|0;u=s;r=p;q=c[r+4>>2]^c[u+4>>2];b=p;c[b>>2]=c[r>>2]^c[u>>2];c[b+4>>2]=q;b=a+288|0;q=s;u=b;r=c[u+4>>2]^c[q+4>>2];t=b;c[t>>2]=c[u>>2]^c[q>>2];c[t+4>>2]=r;t=l;r=c[t+4>>2]^c[s+4>>2];q=l;c[q>>2]=c[t>>2]^c[s>>2];c[q+4>>2]=r;if((c[m>>2]|0)==2)c[a+(i<<2)>>2]=0;s=a+336+(h<<2)|0;q=(c[s>>2]|0)+-1|0;c[s>>2]=q;q=c[a+400+(h<<8)+(q<<2)>>2]|0;r=c[a+4568+(i<<2)>>2]|0;c[a+4568+(q<<2)>>2]=r;c[a+400+(h<<8)+(r<<2)>>2]=q;c[a+400+(h<<8)+(c[s>>2]<<2)>>2]=64;c[j>>2]=(c[j>>2]|0)+-1;c[a+(c[g>>2]<<2)>>2]=0;c[a+(c[e>>2]<<2)>>2]=0;c[a+(d<<2)>>2]=o;r=26112+(d<<3)|0;q=r;e=p;g=c[e+4>>2]|c[q+4>>2];t=p;c[t>>2]=c[e>>2]|c[q>>2];c[t+4>>2]=g;t=r;g=k;q=c[g+4>>2]|c[t+4>>2];e=k;c[e>>2]=c[g>>2]|c[t>>2];c[e+4>>2]=q;e=l;q=c[e+4>>2]|c[r+4>>2];t=l;c[t>>2]=c[e>>2]|c[r>>2];c[t+4>>2]=q;t=c[n>>2]|0;c[n>>2]=t+1;c[a+4568+(d<<2)>>2]=t;c[a+400+(o<<8)+(t<<2)>>2]=d;c[j>>2]=(c[j>>2]|0)+1;t=c[f>>2]|0;c[a+(t<<2)>>2]=h;q=26112+(t<<3)|0;r=q;e=p;g=c[e+4>>2]|c[r+4>>2];u=p;c[u>>2]=c[e>>2]|c[r>>2];c[u+4>>2]=g;u=q;g=b;r=c[g+4>>2]|c[u+4>>2];e=b;c[e>>2]=c[g>>2]|c[u>>2];c[e+4>>2]=r;e=l;r=c[e+4>>2]|c[q+4>>2];u=l;c[u>>2]=c[e>>2]|c[q>>2];c[u+4>>2]=r;u=c[s>>2]|0;c[s>>2]=u+1;c[a+4568+(t<<2)>>2]=u;c[a+400+(h<<8)+(u<<2)>>2]=t;c[j>>2]=(c[j>>2]|0)+1;return}function Rf(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0;f=a+5356|0;_u(b|0,c[f>>2]|0,440)|0;c[b+336>>2]=c[f>>2];c[f>>2]=b;d=b+48|0;e=c[d>>2]|0;if((e|0)==64){d=b+56|0;b=d;e=c[b>>2]|0;b=c[b+4>>2]|0}else{h=981328+((e&7)<<3)|0;g=b+56|0;b=g;e=c[b>>2]^c[h>>2];b=c[b+4>>2]^c[h+4>>2];h=g;c[h>>2]=e;c[h+4>>2]=b;c[d>>2]=64;d=g}i=981520;g=b^c[i+4>>2];h=d;c[h>>2]=e^c[i>>2];c[h+4>>2]=g;h=c[f>>2]|0;g=h+28|0;c[g>>2]=(c[g>>2]|0)+1;c[h+32>>2]=0;g=a+5348|0;c[g>>2]=c[g>>2]^1;Ef(a,h);return}function Sf(a){a=a|0;var b=0;b=a+5356|0;c[b>>2]=c[(c[b>>2]|0)+336>>2];a=a+5348|0;c[a>>2]=c[a>>2]^1;return}function Tf(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0;g=(b&131072|0)==0;i=g?b>>>6&63:64;f=b&63;if(g)h=c[a+(i<<2)>>2]|0;else h=b>>>18&15;e=c[a+(f<<2)>>2]|0;b=(c[a+5356>>2]|0)+56|0;j=981520;d=c[j>>2]^c[b>>2];b=c[j+4>>2]^c[b+4>>2];a:do if(e){j=973136+(e<<9)+(f<<3)|0;d=c[j>>2]^d;b=c[j+4>>2]^b;switch(c[a+5364>>2]|0){case 2:break;case 3:{j=a+4560|0;k=26112+(f<<3)|0;j=((c[k>>2]&c[j>>2]|0)==0?(c[k+4>>2]&c[j+4>>2]|0)==0:0)?e:e&-8|1;k=j^8;j=c[a+4496+(k>>3<<5)+((j&7)<<2)>>2]|0;e=981600+(k*136|0)+(j+1<<3)|0;j=981600+(k*136|0)+(j<<3)|0;d=c[e>>2]^d^c[j>>2];b=c[e+4>>2]^b^c[j+4>>2];break a}default:break a}k=30016+(f<<3)|0;j=a+256|0;g=a+264|0;f=26112+(i<<3)|0;e=(c[g>>2]^c[j>>2])&c[k>>2]&~c[f>>2];f=(c[g+4>>2]^c[j+4>>2])&c[k+4>>2]&~c[f+4>>2];if(!((e|0)==0&(f|0)==0))do{k=hb(e|0,f|0,0)|0;j=Xu(e|0,f|0,-1,-1)|0;e=j&e;f=C&f;k=973136+(c[a+(k<<2)>>2]<<9)+(k<<3)|0;d=c[k>>2]^d;b=c[k+4>>2]^b}while(!((e|0)==0&(f|0)==0));k=973136+(h<<9)+(i<<3)|0;j=c[k+4>>2]^b;k=c[k>>2]^d;C=j;return k|0}while(0);k=973136+(h<<9)+(f<<3)|0;d=c[k>>2]^d;b=c[k+4>>2]^b;if(g){k=973136+(h<<9)+(i<<3)|0;j=c[k+4>>2]^b;k=c[k>>2]^d;C=j;return k|0}else{k=c[a+4496+(h>>3<<5)+((h&7)<<2)>>2]|0;i=981600+(h*136|0)+(k<<3)|0;k=981600+(h*136|0)+(k+-1<<3)|0;j=c[i+4>>2]^b^c[k+4>>2];k=c[i>>2]^d^c[k>>2];C=j;return k|0}return 0}function Uf(a,b,e){a=a|0;b=b|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0;X=i;i=i+16|0;O=X+8|0;M=X;W=a+5364|0;p=c[W>>2]|0;if((p|0)==7?Lf(a,b)|0:0){a=1;i=X;return a|0}V=(b&131072|0)==0;h=V?b&49152:131072;if((h|0)==49152){a=(e|0)<1;i=X;return a|0}E=b>>>6&63;o=V?E:64;T=b&63;n=(h|0)==131072;if(n)f=b>>>18&15;else f=c[a+(o<<2)>>2]|0;j=f&7;g=f>>3;a:do if((p|0)==2){U=c[a+(o<<2)>>2]>>3;D=a+(T<<2)|0;S=b&180224;if((S|0)==32768|(S|0)!=49152&(c[D>>2]|0)!=0){T=30016+(T<<3)|0;S=a+256|0;R=a+264|0;l=26112+(o<<3)|0;k=(c[R>>2]^c[S>>2])&c[T>>2]&~c[l>>2];l=(c[R+4>>2]^c[S+4>>2])&c[T+4>>2]&~c[l+4>>2];T=a+320+((U^1)<<3)|0;S=a+304|0;if(!((c[S>>2]&c[T>>2]&k|0)==0?(c[S+4>>2]&c[T+4>>2]&l|0)==0:0)){f=1;break}m=a+272|0;n=c[1748]|0;o=a+280|0;p=c[1749]|0;q=a+288|0;r=c[1750]|0;s=a+296|0;t=c[1751]|0;u=a+272|0;v=c[1748]|0;w=a+280|0;x=c[1749]|0;y=a+288|0;z=c[1750]|0;A=a+296|0;j=c[1751]|0;h=0;B=0;do{g=a+320+(B<<3)|0;f=c[g>>2]&k;g=c[g+4>>2]&l;if((B|0)==(U|0)){T=m;S=f&c[T>>2];T=g&c[T+4>>2];R=Yu(S|0,T|0,16)|0;Q=Yu(S|0,T|0,48)|0;Q=h-(_(n,(d[1151952+(R&65535)>>0]|0)+(d[1151952+(S&65535)>>0]|0)+(d[1151952+(T&65535)>>0]|0)+(d[1151952+Q>>0]|0)|0)|0)|0;T=o;S=f&c[T>>2];T=g&c[T+4>>2];R=Yu(S|0,T|0,16)|0;h=Yu(S|0,T|0,48)|0;h=Q-(_(p,(d[1151952+(R&65535)>>0]|0)+(d[1151952+(S&65535)>>0]|0)+(d[1151952+(T&65535)>>0]|0)+(d[1151952+h>>0]|0)|0)|0)|0;T=q;S=f&c[T>>2];T=g&c[T+4>>2];R=Yu(S|0,T|0,16)|0;Q=Yu(S|0,T|0,48)|0;Q=h-(_(r,(d[1151952+(R&65535)>>0]|0)+(d[1151952+(S&65535)>>0]|0)+(d[1151952+(T&65535)>>0]|0)+(d[1151952+Q>>0]|0)|0)|0)|0;T=s;S=f&c[T>>2];T=g&c[T+4>>2];R=Yu(S|0,T|0,16)|0;h=Yu(S|0,T|0,48)|0;h=Q-(_(t,(d[1151952+(R&65535)>>0]|0)+(d[1151952+(S&65535)>>0]|0)+(d[1151952+(T&65535)>>0]|0)+(d[1151952+h>>0]|0)|0)|0)|0}else{T=u;S=f&c[T>>2];T=g&c[T+4>>2];R=Yu(S|0,T|0,16)|0;Q=Yu(S|0,T|0,48)|0;h=(_(v,(d[1151952+(R&65535)>>0]|0)+(d[1151952+(S&65535)>>0]|0)+(d[1151952+(T&65535)>>0]|0)+(d[1151952+Q>>0]|0)|0)|0)+h|0;Q=w;T=f&c[Q>>2];Q=g&c[Q+4>>2];S=Yu(T|0,Q|0,16)|0;R=Yu(T|0,Q|0,48)|0;h=(_(x,(d[1151952+(S&65535)>>0]|0)+(d[1151952+(T&65535)>>0]|0)+(d[1151952+(Q&65535)>>0]|0)+(d[1151952+R>>0]|0)|0)|0)+h|0;R=y;Q=f&c[R>>2];R=g&c[R+4>>2];T=Yu(Q|0,R|0,16)|0;S=Yu(Q|0,R|0,48)|0;h=(_(z,(d[1151952+(T&65535)>>0]|0)+(d[1151952+(Q&65535)>>0]|0)+(d[1151952+(R&65535)>>0]|0)+(d[1151952+S>>0]|0)|0)|0)+h|0;S=A;R=f&c[S>>2];S=g&c[S+4>>2];Q=Yu(R|0,S|0,16)|0;T=Yu(R|0,S|0,48)|0;h=(_(j,(d[1151952+(Q&65535)>>0]|0)+(d[1151952+(R&65535)>>0]|0)+(d[1151952+(S&65535)>>0]|0)+(d[1151952+T>>0]|0)|0)|0)+h|0}B=B+1|0}while((B|0)!=2);g=c[W>>2]|0;if(V)f=c[a+(E<<2)>>2]|0;else f=b>>>18&15;f=((c[6728+(g<<7)+(c[D>>2]<<2)>>2]|0)+h-(c[6728+(g<<7)+(f<<2)>>2]|0)|0)>=(e|0);break}if((e|0)<=0){r=a+256|0;p=c[r>>2]|0;r=c[r+4>>2]|0;o=26112+(o<<3)|0;l=c[o>>2]|0;o=c[o+4>>2]|0;w=l^p;F=o^r;J=O;c[J>>2]=w;c[J+4>>2]=F;J=31552+(T<<3)|0;I=a+320|0;m=a+264|0;g=c[m>>2]|0;m=c[m+4>>2]|0;G=27456+(T<<3)|0;H=a+328|0;L=27968+(T<<3)|0;P=a+272|0;K=P;Q=24064+(T<<3)|0;O=24576+(T<<3)|0;O=(_(c[Q+4>>2]&F,c[O+4>>2]|0)|0)^(_(c[Q>>2]&w,c[O>>2]|0)|0);O=(c[1031004+(T<<2)>>2]|0)+(O>>>(c[1031260+(T<<2)>>2]|0)<<3)|0;Q=a+288|0;t=Q;s=c[t>>2]|0;t=c[t+4>>2]|0;R=a+296|0;j=R;h=c[j>>2]|0;j=c[j+4>>2]|0;S=25088+(T<<3)|0;x=25600+(T<<3)|0;x=(_(c[S+4>>2]&F,c[x+4>>2]|0)|0)^(_(c[S>>2]&w,c[x>>2]|0)|0);x=(c[1031516+(T<<2)>>2]|0)+(x>>>(c[1031772+(T<<2)>>2]|0)<<3)|0;S=a+280|0;v=S;u=c[v>>2]|0;v=c[v+4>>2]|0;k=30016+(T<<3)|0;f=c[k>>2]|0;k=c[k+4>>2]|0;N=a+304|0;M=c[N>>2]|0;N=c[N+4>>2]|0;q=a+320+((U^1)<<3)|0;n=c[q>>2]|0;q=c[q+4>>2]|0;w=w&~M&n&(c[G>>2]&g&c[H>>2]|c[I>>2]&c[J>>2]&g|c[K>>2]&c[L>>2]|(h|s)&c[O>>2]|(u|h)&c[x>>2]|M&f);x=F&~N&q&(c[G+4>>2]&m&c[H+4>>2]|c[I+4>>2]&c[J+4>>2]&m|c[K+4>>2]&c[L+4>>2]|(j|t)&c[O+4>>2]|(v|j)&c[x+4>>2]|N&k);O=a+320+(U<<3)|0;if((w|0)==0&(x|0)==0)f=1;else{L=(g^p)&f&~l;K=(m^r)&k&~o;J=M&n;I=N&q;H=a+(E<<2)|0;G=b>>>18&15;m=s;l=t;k=u;g=v;f=2;while(1){F=hb(w|0,x|0,0)|0;v=Xu(w|0,x|0,-1,-1)|0;w=v&w;x=C&x;v=26112+(F<<3)|0;u=L&~c[v>>2];v=K&~c[v+4>>2];if((J&u|0)==0&(I&v|0)==0){T=O;if(!((u&M&c[T>>2]|0)==0?(v&N&c[T+4>>2]|0)==0:0)){f=0;break a}y=6728+(f<<7)+8|0;z=6728+(f<<7)+12|0;A=6728+(f<<7)+16|0;B=6728+(f<<7)+20|0;D=6728+(f<<7)+8|0;E=6728+(f<<7)+12|0;b=6728+(f<<7)+16|0;r=6728+(f<<7)+20|0;t=P;s=c[t>>2]|0;t=c[t+4>>2]|0;o=g;g=0;q=0;do{n=a+320+(q<<3)|0;f=c[n>>2]&u;n=c[n+4>>2]&v;Y=f&s;T=n&t;Z=Yu(Y|0,T|0,16)|0;p=Yu(Y|0,T|0,48)|0;p=(d[1151952+(Z&65535)>>0]|0)+(d[1151952+(Y&65535)>>0]|0)+(d[1151952+(T&65535)>>0]|0)+(d[1151952+p>>0]|0)|0;if((q|0)==(U|0)){j=g-(_(c[y>>2]|0,p)|0)|0;o=S;k=c[o>>2]|0;o=c[o+4>>2]|0;m=f&k;l=n&o;h=Yu(m|0,l|0,16)|0;Z=Yu(m|0,l|0,48)|0;Z=j-(_(c[z>>2]|0,(d[1151952+(h&65535)>>0]|0)+(d[1151952+(m&65535)>>0]|0)+(d[1151952+(l&65535)>>0]|0)+(d[1151952+Z>>0]|0)|0)|0)|0;l=Q;m=c[l>>2]|0;l=c[l+4>>2]|0;h=f&m;j=n&l;Y=Yu(h|0,j|0,16)|0;p=Yu(h|0,j|0,48)|0;p=Z-(_(c[A>>2]|0,(d[1151952+(Y&65535)>>0]|0)+(d[1151952+(h&65535)>>0]|0)+(d[1151952+(j&65535)>>0]|0)+(d[1151952+p>>0]|0)|0)|0)|0;j=R;h=c[j>>2]|0;j=c[j+4>>2]|0;Y=f&h;Z=n&j;T=Yu(Y|0,Z|0,16)|0;g=Yu(Y|0,Z|0,48)|0;g=p-(_(c[B>>2]|0,(d[1151952+(T&65535)>>0]|0)+(d[1151952+(Y&65535)>>0]|0)+(d[1151952+(Z&65535)>>0]|0)+(d[1151952+g>>0]|0)|0)|0)|0}else{g=(_(c[D>>2]|0,p)|0)+g|0;Z=f&k;Y=n&o;T=Yu(Z|0,Y|0,16)|0;p=Yu(Z|0,Y|0,48)|0;g=(_(c[E>>2]|0,(d[1151952+(T&65535)>>0]|0)+(d[1151952+(Z&65535)>>0]|0)+(d[1151952+(Y&65535)>>0]|0)+(d[1151952+p>>0]|0)|0)|0)+g|0;p=f&m;Y=n&l;Z=Yu(p|0,Y|0,16)|0;T=Yu(p|0,Y|0,48)|0;g=(_(c[b>>2]|0,(d[1151952+(Z&65535)>>0]|0)+(d[1151952+(p&65535)>>0]|0)+(d[1151952+(Y&65535)>>0]|0)+(d[1151952+T>>0]|0)|0)|0)+g|0;T=f&h;Y=n&j;p=Yu(T|0,Y|0,16)|0;Z=Yu(T|0,Y|0,48)|0;g=(_(c[r>>2]|0,(d[1151952+(p&65535)>>0]|0)+(d[1151952+(T&65535)>>0]|0)+(d[1151952+(Y&65535)>>0]|0)+(d[1151952+Z>>0]|0)|0)|0)+g|0}q=q+1|0}while((q|0)!=2);n=c[W>>2]|0;if(V)f=c[H>>2]|0;else f=G;if(((c[6728+(n<<7)+(c[a+(F<<2)>>2]<<2)>>2]|0)+g-(c[6728+(n<<7)+(f<<2)>>2]|0)|0)<(e|0)){f=0;break a}else{g=o;f=n}}if((w|0)==0&(x|0)==0){f=1;break}}}}else f=0}else{if((h|0)==32768){m=26112+(T-((g|0)==0?8:-8)<<3)|0;l=c[m>>2]|0;m=c[m+4>>2]|0;f=O;c[f>>2]=l;c[f+4>>2]=m;f=c[6728+(p<<7)+4>>2]|0}else{f=c[6728+(p<<7)+(c[a+(T<<2)>>2]<<2)>>2]|0;l=O;c[l>>2]=0;c[l+4>>2]=0;l=0;m=0}if((f|0)>=(e|0))if(!((j|0)==6&(p|0)!=1)?(q=f-(c[6728+(p<<7)+(j<<2)>>2]|0)|0,(q|0)<(e|0)):0){K=a+256|0;j=K;f=c[j>>2]|0;j=c[j+4>>2]|0;k=26112+(T<<3)|0;h=c[k>>2]|0;k=c[k+4>>2]|0;if(n){h=h^f;f=k^j}else{Z=26112+(o<<3)|0;h=c[Z>>2]^f^h;f=c[Z+4>>2]^j^k}s=h^l;t=f^m;Q=O;c[Q>>2]=s;c[Q+4>>2]=t;Q=31552+(T<<3)|0;P=a+320|0;J=a+264|0;R=J;n=c[R>>2]|0;R=c[R+4>>2]|0;r=27456+(T<<3)|0;v=a+328|0;U=27968+(T<<3)|0;w=a+272|0;S=w;x=24064+(T<<3)|0;z=x;y=24576+(T<<3)|0;Y=y;Y=(_(c[z+4>>2]&t,c[Y+4>>2]|0)|0)^(_(c[z>>2]&s,c[Y>>2]|0)|0);z=1031260+(T<<2)|0;A=1031004+(T<<2)|0;Y=(c[A>>2]|0)+(Y>>>(c[z>>2]|0)<<3)|0;B=a+288|0;V=B;D=a+296|0;f=D;o=c[f>>2]|0;f=c[f+4>>2]|0;E=25088+(T<<3)|0;F=E;b=25600+(T<<3)|0;u=b;u=(_(c[F+4>>2]&t,c[u+4>>2]|0)|0)^(_(c[F>>2]&s,c[u>>2]|0)|0);F=1031772+(T<<2)|0;G=1031516+(T<<2)|0;u=(c[G>>2]|0)+(u>>>(c[F>>2]|0)<<3)|0;H=a+280|0;Z=H;I=30016+(T<<3)|0;h=a+304|0;s=(c[r>>2]&n&c[v>>2]|c[P>>2]&c[Q>>2]&n|c[S>>2]&c[U>>2]|(o|c[V>>2])&c[Y>>2]|(c[Z>>2]|o)&c[u>>2]|c[h>>2]&c[I>>2])&s;t=(c[r+4>>2]&R&c[v+4>>2]|c[P+4>>2]&c[Q+4>>2]&R|c[S+4>>2]&c[U+4>>2]|(f|c[V+4>>2])&c[Y+4>>2]|(c[Z+4>>2]|f)&c[u+4>>2]|c[h+4>>2]&c[I+4>>2])&t;I=M;c[I>>2]=s;c[I+4>>2]=t;I=a+5356|0;h=p;u=q;f=1;while(1){v=g^1;k=a+320+(v<<3)|0;j=c[k>>2]&s;k=c[k+4>>2]&t;l=(h|0)==1;if(!l?(L=c[I>>2]|0,Y=L+360+(v<<3)|0,Z=O,(c[Y>>2]&~c[Z>>2]|0)==0?(c[Y+4>>2]&~c[Z+4>>2]|0)==0:0):0){Z=L+344+(v<<3)|0;j=j&~c[Z>>2];k=k&~c[Z+4>>2]}if((j|0)==0&(k|0)==0)break;do if(!l){m=J;l=c[m>>2]&j;m=c[m+4>>2]&k;if(!((l|0)==0&(m|0)==0)){Y=Vu(0,0,l|0,m|0)|0;Z=O;Y=c[Z>>2]^l&Y;Z=c[Z+4>>2]^m&C;U=O;c[U>>2]=Y;c[U+4>>2]=Z;U=E;V=b;V=(_(c[U+4>>2]&Z,c[V+4>>2]|0)|0)^(_(c[U>>2]&Y,c[V>>2]|0)|0);V=(c[G>>2]|0)+(V>>>(c[F>>2]|0)<<3)|0;U=H;S=D;Z=((c[S+4>>2]|c[U+4>>2])&c[V+4>>2]|t)&Z;g=M;c[g>>2]=((c[S>>2]|c[U>>2])&c[V>>2]|s)&Y;c[g+4>>2]=Z;g=1;break}m=w;l=c[m>>2]&j;m=c[m+4>>2]&k;if(!((l|0)==0&(m|0)==0)){Y=Vu(0,0,l|0,m|0)|0;Z=O;Y=c[Z>>2]^l&Y;Z=c[Z+4>>2]^m&C;g=O;c[g>>2]=Y;c[g+4>>2]=Z;g=M;c[g>>2]=s&Y;c[g+4>>2]=t&Z;g=2;break}r=H;q=c[r>>2]|0;r=c[r+4>>2]|0;l=q&j;m=r&k;if(!((l|0)==0&(m|0)==0)){Y=Vu(0,0,l|0,m|0)|0;Z=O;Y=c[Z>>2]^l&Y;Z=c[Z+4>>2]^m&C;U=O;c[U>>2]=Y;c[U+4>>2]=Z;U=E;V=b;V=(_(c[U+4>>2]&Z,c[V+4>>2]|0)|0)^(_(c[U>>2]&Y,c[V>>2]|0)|0);V=(c[G>>2]|0)+(V>>>(c[F>>2]|0)<<3)|0;U=D;Z=((c[U+4>>2]|r)&c[V+4>>2]|t)&Z;g=M;c[g>>2]=((c[U>>2]|q)&c[V>>2]|s)&Y;c[g+4>>2]=Z;g=3;break}p=B;o=c[p>>2]|0;p=c[p+4>>2]|0;l=o&j;m=p&k;if(!((l|0)==0&(m|0)==0)){Y=Vu(0,0,l|0,m|0)|0;Z=O;Y=c[Z>>2]^l&Y;Z=c[Z+4>>2]^m&C;U=O;c[U>>2]=Y;c[U+4>>2]=Z;U=x;V=y;V=(_(c[U+4>>2]&Z,c[V+4>>2]|0)|0)^(_(c[U>>2]&Y,c[V>>2]|0)|0);V=(c[A>>2]|0)+(V>>>(c[z>>2]|0)<<3)|0;U=D;Z=((c[U+4>>2]|p)&c[V+4>>2]|t)&Z;g=M;c[g>>2]=((c[U>>2]|o)&c[V>>2]|s)&Y;c[g+4>>2]=Z;g=4;break}n=D;m=c[n>>2]|0;n=c[n+4>>2]|0;l=m&j;j=n&k;if((l|0)==0&(j|0)==0){j=6;N=60}else{Y=Vu(0,0,l|0,j|0)|0;Z=O;Y=c[Z>>2]^l&Y;Z=c[Z+4>>2]^j&C;g=O;c[g>>2]=Y;c[g+4>>2]=Z;g=E;V=b;V=(_(c[g+4>>2]&Z,c[V+4>>2]|0)|0)^(_(c[g>>2]&Y,c[V>>2]|0)|0);V=(c[G>>2]|0)+(V>>>(c[F>>2]|0)<<3)|0;g=x;U=y;U=(_(c[g+4>>2]&Z,c[U+4>>2]|0)|0)^(_(c[g>>2]&Y,c[U>>2]|0)|0);U=(c[A>>2]|0)+(U>>>(c[z>>2]|0)<<3)|0;Z=((n|p)&c[U+4>>2]|((n|r)&c[V+4>>2]|t))&Z;g=M;c[g>>2]=((m|o)&c[U>>2]|((m|q)&c[V>>2]|s))&Y;c[g+4>>2]=Z;g=5}}else{j=Vf(K,T,j,k,O,M)|0;h=c[W>>2]|0;N=60}while(0);if((N|0)==60){N=0;if((j|0)==6&(h|0)!=1){N=61;break}else g=j}g=c[6728+(h<<7)+(g<<2)>>2]|0;if(f){f=g+u|0;if((f|0)<(e|0)){f=0;break}else{g=f;f=0}}else{f=u-g|0;if((f|0)<(e|0)){g=f;f=1}else{f=1;break}}t=M;s=c[t>>2]|0;t=c[t+4>>2]|0;u=g;g=v}if((N|0)==61){Z=M;Y=a+320+(g<<3)|0;f=f^(c[Y>>2]&c[Z>>2]|0?1:(c[Y+4>>2]&c[Z+4>>2]|0)!=0)^1}}else f=1;else f=0}while(0);Z=f;i=X;return Z|0}function Vf(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0;k=a+40|0;h=k;i=c[h>>2]&d;h=c[h+4>>2]&e;if(!((i|0)==0&(h|0)==0)){d=Vu(0,0,i|0,h|0)|0;e=f;d=c[e>>2]^i&d;e=c[e+4>>2]^h&C;h=f;c[h>>2]=d;c[h+4>>2]=e;h=25088+(b<<3)|0;i=25600+(b<<3)|0;i=(_(c[h+4>>2]&e,c[i+4>>2]|0)|0)^(_(c[h>>2]&d,c[i>>2]|0)|0);i=(c[1031516+(b<<2)>>2]|0)+(i>>>(c[1031772+(b<<2)>>2]|0)<<3)|0;h=a+24|0;d=k;e=g;j=(c[d>>2]|c[h>>2])&c[i>>2]|c[e>>2];e=(c[d+4>>2]|c[h+4>>2])&c[i+4>>2]|c[e+4>>2];i=g;c[i>>2]=j;c[i+4>>2]=e;i=f;h=24064+(b<<3)|0;d=24576+(b<<3)|0;d=(_(c[h+4>>2]&c[i+4>>2],c[d+4>>2]|0)|0)^(_(c[h>>2]&c[i>>2],c[d>>2]|0)|0);b=(c[1031004+(b<<2)>>2]|0)+(d>>>(c[1031260+(b<<2)>>2]|0)<<3)|0;a=a+32|0;d=k;k=(c[d>>2]|c[a>>2])&c[b>>2]|j;b=(c[d+4>>2]|c[a+4>>2])&c[b+4>>2]|e;a=g;c[a>>2]=k;c[a+4>>2]=b;a=f;f=b&c[a+4>>2];b=g;c[b>>2]=k&c[a>>2];c[b+4>>2]=f;b=5;return b|0}h=a+32|0;j=h;i=c[j>>2]&d;j=c[j+4>>2]&e;if(!((i|0)==0&(j|0)==0)){e=Vu(0,0,i|0,j|0)|0;d=f;e=c[d>>2]^i&e;j=c[d+4>>2]^j&C;d=f;c[d>>2]=e;c[d+4>>2]=j;d=24064+(b<<3)|0;a=24576+(b<<3)|0;a=(_(c[d+4>>2]&j,c[a+4>>2]|0)|0)^(_(c[d>>2]&e,c[a>>2]|0)|0);a=(c[1031004+(b<<2)>>2]|0)+(a>>>(c[1031260+(b<<2)>>2]|0)<<3)|0;e=h;d=k;b=g;k=(c[d>>2]|c[e>>2])&c[a>>2]|c[b>>2];b=(c[d+4>>2]|c[e+4>>2])&c[a+4>>2]|c[b+4>>2];a=g;c[a>>2]=k;c[a+4>>2]=b;a=f;f=b&c[a+4>>2];b=g;c[b>>2]=k&c[a>>2];c[b+4>>2]=f;b=4;return b|0}j=a+24|0;i=j;h=c[i>>2]&d;i=c[i+4>>2]&e;if(!((h|0)==0&(i|0)==0)){e=Vu(0,0,h|0,i|0)|0;d=f;e=c[d>>2]^h&e;i=c[d+4>>2]^i&C;d=f;c[d>>2]=e;c[d+4>>2]=i;d=25088+(b<<3)|0;a=25600+(b<<3)|0;a=(_(c[d+4>>2]&i,c[a+4>>2]|0)|0)^(_(c[d>>2]&e,c[a>>2]|0)|0);a=(c[1031516+(b<<2)>>2]|0)+(a>>>(c[1031772+(b<<2)>>2]|0)<<3)|0;e=j;d=k;b=g;k=(c[d>>2]|c[e>>2])&c[a>>2]|c[b>>2];b=(c[d+4>>2]|c[e+4>>2])&c[a+4>>2]|c[b+4>>2];a=g;c[a>>2]=k;c[a+4>>2]=b;a=f;f=b&c[a+4>>2];b=g;c[b>>2]=k&c[a>>2];c[b+4>>2]=f;b=3;return b|0}i=a+16|0;h=c[i>>2]&d;i=c[i+4>>2]&e;if(!((h|0)==0&(i|0)==0)){a=Vu(0,0,h|0,i|0)|0;b=f;a=c[b>>2]^h&a;b=c[b+4>>2]^i&C;k=f;c[k>>2]=a;c[k+4>>2]=b;k=g;f=c[k+4>>2]&b;b=g;c[b>>2]=c[k>>2]&a;c[b+4>>2]=f;b=2;return b|0}i=a+8|0;h=c[i>>2]&d;i=c[i+4>>2]&e;if(!((h|0)==0&(i|0)==0)){e=Vu(0,0,h|0,i|0)|0;d=f;e=c[d>>2]^h&e;i=c[d+4>>2]^i&C;d=f;c[d>>2]=e;c[d+4>>2]=i;d=25088+(b<<3)|0;a=25600+(b<<3)|0;a=(_(c[d+4>>2]&i,c[a+4>>2]|0)|0)^(_(c[d>>2]&e,c[a>>2]|0)|0);a=(c[1031516+(b<<2)>>2]|0)+(a>>>(c[1031772+(b<<2)>>2]|0)<<3)|0;e=j;d=k;b=g;k=(c[d>>2]|c[e>>2])&c[a>>2]|c[b>>2];b=(c[d+4>>2]|c[e+4>>2])&c[a+4>>2]|c[b+4>>2];a=g;c[a>>2]=k;c[a+4>>2]=b;a=f;f=b&c[a+4>>2];b=g;c[b>>2]=k&c[a>>2];c[b+4>>2]=f;b=1;return b|0}k=a+48|0;if((c[k>>2]&d|0)==0?(c[k+4>>2]&e|0)==0:0){b=0;return b|0}b=Wf(a,b,d,e,f,g)|0;return b|0}function Wf(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0;h=a+48|0;i=c[h>>2]&d;h=c[h+4>>2]&e;if((i|0)==0&(h|0)==0){b=Vf(a,b,d,e,f,g)|0;return b|0}else{k=Vu(0,0,i|0,h|0)|0;d=f;k=c[d>>2]^i&k;d=c[d+4>>2]^h&C;e=f;c[e>>2]=k;c[e+4>>2]=d;e=25088+(b<<3)|0;j=25600+(b<<3)|0;j=(_(c[e+4>>2]&d,c[j+4>>2]|0)|0)^(_(c[e>>2]&k,c[j>>2]|0)|0);j=(c[1031516+(b<<2)>>2]|0)+(j>>>(c[1031772+(b<<2)>>2]|0)<<3)|0;k=a+24|0;e=a+40|0;d=e;h=g;i=(c[d>>2]|c[k>>2])&c[j>>2]|c[h>>2];h=(c[d+4>>2]|c[k+4>>2])&c[j+4>>2]|c[h+4>>2];j=g;c[j>>2]=i;c[j+4>>2]=h;j=f;k=24064+(b<<3)|0;d=24576+(b<<3)|0;d=(_(c[k+4>>2]&c[j+4>>2],c[d+4>>2]|0)|0)^(_(c[k>>2]&c[j>>2],c[d>>2]|0)|0);b=(c[1031004+(b<<2)>>2]|0)+(d>>>(c[1031260+(b<<2)>>2]|0)<<3)|0;a=a+32|0;i=(c[e>>2]|c[a>>2])&c[b>>2]|i;b=(c[e+4>>2]|c[a+4>>2])&c[b+4>>2]|h;a=g;c[a>>2]=i;c[a+4>>2]=b;a=f;f=b&c[a+4>>2];b=g;c[b>>2]=i&c[a>>2];c[b+4>>2]=f;b=6;return b|0}return 0}function Xf(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0;j=i;i=i+4112|0;b=j;d=a+5356|0;e=c[d>>2]|0;do if((c[e+28>>2]|0)>99){h=e+64|0;if((c[h>>2]|0)==0&(c[h+4>>2]|0)==0){h=1;i=j;return h|0}h=df(a,b)|0;c[b+4096>>2]=h;if((h|0)==(b|0)){e=c[d>>2]|0;break}else{h=1;i=j;return h|0}}while(0);if((c[a+5364>>2]|0)==3)b=e+32|0;else{b=e+28|0;h=e+32|0;b=(c[h>>2]|0)<(c[b>>2]|0)?h:b}b=c[b>>2]|0;if((b|0)<4){h=0;i=j;return h|0}g=e+56|0;f=c[g>>2]|0;g=c[g+4>>2]|0;h=a+5344|0;a=a+5352|0;d=1;e=c[(c[e+336>>2]|0)+336>>2]|0;while(1){e=c[(c[e+336>>2]|0)+336>>2]|0;k=e+56|0;if((c[k>>2]|0)==(f|0)?(c[k+4>>2]|0)==(g|0):0){d=d+1|0;if((d|0)>=((((c[h>>2]|0)-b|0)<(c[(c[a>>2]|0)+5528>>2]|0)?3:2)|0)){b=1;d=13;break}}b=b+-2|0;if((b|0)<=3){b=0;d=13;break}}if((d|0)==13){i=j;return b|0}return 0}function Yf(){var a=0,b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0;b=i;i=i+96|0;a=b;rk(a,17165,5);d=a+12|0;rk(d,17171,8);e=a+24|0;rk(e,17180,6);f=a+36|0;rk(f,17187,10);g=a+48|0;rk(g,17198,5);h=a+60|0;rk(h,17204,13);j=a+72|0;rk(j,17218,11);k=a+84|0;rk(k,17230,10);l=Nu(96)|0;c[267157]=l;c[267156]=l;c[267158]=l+96;qk(l,a);l=(c[267157]|0)+12|0;c[267157]=l;qk(l,d);l=(c[267157]|0)+12|0;c[267157]=l;qk(l,e);l=(c[267157]|0)+12|0;c[267157]=l;qk(l,f);l=(c[267157]|0)+12|0;c[267157]=l;qk(l,g);l=(c[267157]|0)+12|0;c[267157]=l;qk(l,h);l=(c[267157]|0)+12|0;c[267157]=l;qk(l,j);l=(c[267157]|0)+12|0;c[267157]=l;qk(l,k);c[267157]=(c[267157]|0)+12;vk(k);vk(j);vk(h);vk(g);vk(f);vk(e);vk(d);vk(a);Wu(1068636,0,144)|0;c[267195]=458741;c[267196]=-262138;c[267197]=524295;c[267198]=-131069;c[267199]=-262162;c[267200]=-327682;c[267201]=327699;c[267202]=262168;c[267203]=196591;c[267204]=196599;c[267205]=-524268;c[267206]=-196573;c[267207]=524282;c[267208]=589829;c[267209]=458755;c[267210]=-393195;c[267211]=524282;c[267212]=-327688;c[267213]=131066;c[267214]=262142;c[267215]=196604;c[267216]=-589804;c[267217]=65528;c[267218]=1179644;c[267219]=0;c[267220]=0;c[267221]=0;c[267222]=0;c[267223]=-6357135;c[267224]=-5374048;c[267225]=-3014736;c[267226]=-917577;c[267227]=-4522067;c[267228]=-3604523;c[267229]=-1114133;c[267230]=589814;c[267231]=-3276871;c[267232]=-2555926;c[267233]=-524288;c[267234]=1835017;c[267235]=-2687001;c[267236]=-1638382;c[267237]=458795;c[267238]=2490415;c[267239]=-3014682;c[267240]=-1638384;c[267241]=131110;c[267242]=2687026;c[267243]=-3604491;c[267244]=-2490331;c[267245]=-524232;c[267246]=1769543;c[267247]=-4194366;c[267248]=-3276817;c[267249]=-1572859;c[267250]=851982;c[267251]=-7209155;c[267252]=-5898306;c[267253]=-3276842;c[267254]=-851997;c[267255]=-4456502;c[267256]=-2621463;c[267257]=-3014691;c[267258]=-1835052;c[267259]=-2818078;c[267260]=-1114102;c[267261]=-1507326;c[267262]=-327689;c[267263]=-2097171;c[267264]=-589807;c[267265]=-851957;c[267266]=524289;c[267267]=-2359317;c[267268]=-851950;c[267269]=-983029;c[267270]=458752;c[267271]=-2359317;c[267272]=-917490;c[267273]=-1114106;c[267274]=196607;c[267275]=-2293787;c[267276]=-851962;c[267277]=-655358;c[267278]=65528;c[267279]=-2883617;c[267280]=-1376249;c[267281]=-1441796;c[267282]=-262156;c[267283]=-4259885;c[267284]=-2752533;c[267285]=-3014685;c[267286]=-1769511;c[267287]=-25;c[267288]=-16;c[267289]=-16;c[267290]=-9;c[267291]=-21;c[267292]=-8;c[267293]=-3;c[267294]=0;c[267295]=-21;c[267296]=-9;c[267297]=-4;c[267298]=2;c[267299]=-22;c[267300]=-6;c[267301]=-1;c[267302]=2;c[267303]=-22;c[267304]=-7;c[267305]=0;c[267306]=1;c[267307]=-21;c[267308]=-7;c[267309]=0;c[267310]=2;c[267311]=-12;c[267312]=4;c[267313]=8;c[267314]=12;c[267315]=-23;c[267316]=-15;c[267317]=-11;c[267318]=-5;c[267319]=-4587520;c[267320]=-3735555;c[267321]=-2686980;c[267322]=-1900545;c[267323]=-3801092;c[267324]=-1966074;c[267325]=-1376247;c[267326]=-262136;c[267327]=-2555906;c[267328]=-1114106;c[267329]=-458743;c[267330]=327689;c[267331]=-1900545;c[267332]=-327672;c[267333]=589834;c[267334]=1114119;c[267335]=-1769475;c[267336]=-327671;c[267337]=655368;c[267338]=1507335;c[267339]=-2621442;c[267340]=-1048570;c[267341]=-720888;c[267342]=196618;c[267343]=-3538946;c[267344]=-1966073;c[267345]=-1376249;c[267346]=-458746;c[267347]=-4915201;c[267348]=-3538948;c[267349]=-2883585;c[267350]=-1966080;c[267351]=1835299;c[267352]=4981080;c[267353]=6750502;c[267354]=7340251;c[267355]=4587809;c[267356]=7799113;c[267357]=11141383;c[267358]=10420429;c[267359]=7143650;c[267360]=10748175;c[267361]=12779722;c[267362]=12517512;c[267363]=8585420;c[267364]=12714196;c[267365]=12714159;c[267366]=13369481;c[267367]=8650929;c[267368]=12255437;c[267369]=14680207;c[267370]=14876766;c[267371]=7733395;c[267372]=11665596;c[267373]=13041777;c[267374]=12910662;c[267375]=4718708;c[267376]=7930014;c[267377]=9306205;c[267378]=10551344;c[267379]=1966174;c[267380]=4980856;c[267381]=6619214;c[267382]=7274527;Wu(1069532,0,272)|0;c[267451]=458741;c[267452]=-262138;c[267453]=524295;c[267454]=-131069;c[267455]=-262162;c[267456]=-327682;c[267457]=327699;c[267458]=262168;c[267459]=196591;c[267460]=196599;c[267461]=-524268;c[267462]=-196573;c[267463]=524282;c[267464]=589829;c[267465]=458755;c[267466]=-393195;c[267467]=524282;c[267468]=-327688;c[267469]=131066;c[267470]=262142;c[267471]=196604;c[267472]=-589804;c[267473]=65528;c[267474]=1179644;c[267475]=0;c[267476]=0;c[267477]=0;c[267478]=0;c[267479]=-6357135;c[267480]=-5374048;c[267481]=-3014736;c[267482]=-917577;c[267483]=-4522067;c[267484]=-3604523;c[267485]=-1114133;c[267486]=589814;c[267487]=-3276871;c[267488]=-2555926;c[267489]=-524288;c[267490]=1835017;c[267491]=-2687001;c[267492]=-1638382;c[267493]=458795;c[267494]=2490415;c[267495]=-3014682;c[267496]=-1638384;c[267497]=131110;c[267498]=2687026;c[267499]=-3604491;c[267500]=-2490331;c[267501]=-524232;c[267502]=1769543;c[267503]=-4194366;c[267504]=-3276817;c[267505]=-1572859;c[267506]=851982;c[267507]=-7209155;c[267508]=-5898306;c[267509]=-3276842;c[267510]=-851997;c[267511]=-4456502;c[267512]=-2621463;c[267513]=-3014691;c[267514]=-1835052;c[267515]=-2818078;c[267516]=-1114102;c[267517]=-1507326;c[267518]=-327689;c[267519]=-2097171;c[267520]=-589807;c[267521]=-851957;c[267522]=524289;c[267523]=-2359317;c[267524]=-851950;c[267525]=-983029;c[267526]=458752;c[267527]=-2359317;c[267528]=-917490;c[267529]=-1114106;c[267530]=196607;c[267531]=-2293787;c[267532]=-851962;c[267533]=-655358;c[267534]=65528;c[267535]=-2883617;c[267536]=-1376249;c[267537]=-1441796;c[267538]=-262156;c[267539]=-4259885;c[267540]=-2752533;c[267541]=-3014685;c[267542]=-1769511;c[267543]=-25;c[267544]=-16;c[267545]=-16;c[267546]=-9;c[267547]=-21;c[267548]=-8;c[267549]=-3;c[267550]=0;c[267551]=-21;c[267552]=-9;c[267553]=-4;c[267554]=2;c[267555]=-22;c[267556]=-6;c[267557]=-1;c[267558]=2;c[267559]=-22;c[267560]=-7;c[267561]=0;c[267562]=1;c[267563]=-21;c[267564]=-7;c[267565]=0;c[267566]=2;c[267567]=-12;c[267568]=4;c[267569]=8;c[267570]=12;c[267571]=-23;c[267572]=-15;c[267573]=-11;c[267574]=-5;c[267575]=-4587520;c[267576]=-3735555;c[267577]=-2686980;c[267578]=-1900545;c[267579]=-3801092;c[267580]=-1966074;c[267581]=-1376247;c[267582]=-262136;c[267583]=-2555906;c[267584]=-1114106;c[267585]=-458743;c[267586]=327689;c[267587]=-1900545;c[267588]=-327672;c[267589]=589834;c[267590]=1114119;c[267591]=-1769475;c[267592]=-327671;c[267593]=655368;c[267594]=1507335;c[267595]=-2621442;c[267596]=-1048570;c[267597]=-720888;c[267598]=196618;c[267599]=-3538946;c[267600]=-1966073;c[267601]=-1376249;c[267602]=-458746;c[267603]=-4915201;c[267604]=-3538948;c[267605]=-2883585;c[267606]=-1966080;c[267607]=1835299;c[267608]=4981080;c[267609]=6750502;c[267610]=7340251;c[267611]=4587809;c[267612]=7799113;c[267613]=11141383;c[267614]=10420429;c[267615]=7143650;c[267616]=10748175;c[267617]=12779722;c[267618]=12517512;c[267619]=8585420;c[267620]=12714196;c[267621]=12714159;c[267622]=13369481;c[267623]=8650929;c[267624]=12255437;c[267625]=14680207;c[267626]=14876766;c[267627]=7733395;c[267628]=11665596;c[267629]=13041777;c[267630]=12910662;c[267631]=4718708;c[267632]=7930014;c[267633]=9306205;c[267634]=10551344;c[267635]=1966174;c[267636]=4980856;c[267637]=6619214;c[267638]=7274527;Wu(1070556,0,272)|0;c[267707]=458741;c[267708]=-262138;c[267709]=524295;c[267710]=-131069;c[267711]=-262162;c[267712]=-327682;c[267713]=327699;c[267714]=262168;c[267715]=196591;c[267716]=196599;c[267717]=-524268;c[267718]=-196573;c[267719]=524282;c[267720]=589829;c[267721]=458755;c[267722]=-393195;c[267723]=524282;c[267724]=-327688;c[267725]=131066;c[267726]=262142;c[267727]=196604;c[267728]=-589804;c[267729]=65528;c[267730]=1179644;c[267731]=0;c[267732]=0;c[267733]=0;c[267734]=0;c[267735]=-6357135;c[267736]=-5374048;c[267737]=-3014736;c[267738]=-917577;c[267739]=-4522067;c[267740]=-3604523;c[267741]=-1114133;c[267742]=589814;c[267743]=-3276871;c[267744]=-2555926;c[267745]=-524288;c[267746]=1835017;c[267747]=-2687001;c[267748]=-1638382;c[267749]=458795;c[267750]=2490415;c[267751]=-3014682;c[267752]=-1638384;c[267753]=131110;c[267754]=2687026;c[267755]=-3604491;c[267756]=-2490331;c[267757]=-524232;c[267758]=1769543;c[267759]=-4194366;c[267760]=-3276817;c[267761]=-1572859;c[267762]=851982;c[267763]=-7209155;c[267764]=-5898306;c[267765]=-3276842;c[267766]=-851997;c[267767]=-4456502;c[267768]=-2621463;c[267769]=-3014691;c[267770]=-1835052;c[267771]=-2818078;c[267772]=-1114102;c[267773]=-1507326;c[267774]=-327689;c[267775]=-2097171;c[267776]=-589807;c[267777]=-851957;c[267778]=524289;c[267779]=-2359317;c[267780]=-851950;c[267781]=-983029;c[267782]=458752;c[267783]=-2359317;c[267784]=-917490;c[267785]=-1114106;c[267786]=196607;c[267787]=-2293787;c[267788]=-851962;c[267789]=-655358;c[267790]=65528;c[267791]=-2883617;c[267792]=-1376249;c[267793]=-1441796;c[267794]=-262156;c[267795]=-4259885;c[267796]=-2752533;c[267797]=-3014685;c[267798]=-1769511;c[267799]=-25;c[267800]=-16;c[267801]=-16;c[267802]=-9;c[267803]=-21;c[267804]=-8;c[267805]=-3;c[267806]=0;c[267807]=-21;c[267808]=-9;c[267809]=-4;c[267810]=2;c[267811]=-22;c[267812]=-6;c[267813]=-1;c[267814]=2;c[267815]=-22;c[267816]=-7;c[267817]=0;c[267818]=1;c[267819]=-21;c[267820]=-7;c[267821]=0;c[267822]=2;c[267823]=-12;c[267824]=4;c[267825]=8;c[267826]=12;c[267827]=-23;c[267828]=-15;c[267829]=-11;c[267830]=-5;c[267831]=-4587520;c[267832]=-3735555;c[267833]=-2686980;c[267834]=-1900545;c[267835]=-3801092;c[267836]=-1966074;c[267837]=-1376247;c[267838]=-262136;c[267839]=-2555906;c[267840]=-1114106;c[267841]=-458743;c[267842]=327689;c[267843]=-1900545;c[267844]=-327672;c[267845]=589834;c[267846]=1114119;c[267847]=-1769475;c[267848]=-327671;c[267849]=655368;c[267850]=1507335;c[267851]=-2621442;c[267852]=-1048570;c[267853]=-720888;c[267854]=196618;c[267855]=-3538946;c[267856]=-1966073;c[267857]=-1376249;c[267858]=-458746;c[267859]=-4915201;c[267860]=-3538948;c[267861]=-2883585;c[267862]=-1966080;c[267863]=1835299;c[267864]=4981080;c[267865]=6750502;c[267866]=7340251;c[267867]=4587809;c[267868]=7799113;c[267869]=11141383;c[267870]=10420429;c[267871]=7143650;c[267872]=10748175;c[267873]=12779722;c[267874]=12517512;c[267875]=8585420;c[267876]=12714196;c[267877]=12714159;c[267878]=13369481;c[267879]=8650929;c[267880]=12255437;c[267881]=14680207;c[267882]=14876766;c[267883]=7733395;c[267884]=11665596;c[267885]=13041777;c[267886]=12910662;c[267887]=4718708;c[267888]=7930014;c[267889]=9306205;c[267890]=10551344;c[267891]=1966174;c[267892]=4980856;c[267893]=6619214;c[267894]=7274527;Wu(1071580,0,272)|0;c[267963]=458741;c[267964]=-262138;c[267965]=524295;c[267966]=-131069;c[267967]=-262162;c[267968]=-327682;c[267969]=327699;c[267970]=262168;c[267971]=196591;c[267972]=196599;c[267973]=-524268;c[267974]=-196573;c[267975]=524282;c[267976]=589829;c[267977]=458755;c[267978]=-393195;c[267979]=524282;c[267980]=-327688;c[267981]=131066;c[267982]=262142;c[267983]=196604;c[267984]=-589804;c[267985]=65528;c[267986]=1179644;c[267987]=0;c[267988]=0;c[267989]=0;c[267990]=0;c[267991]=-6357135;c[267992]=-5374048;c[267993]=-3014736;c[267994]=-917577;c[267995]=-4522067;c[267996]=-3604523;c[267997]=-1114133;c[267998]=589814;c[267999]=-3276871;c[268e3]=-2555926;c[268001]=-524288;c[268002]=1835017;c[268003]=-2687001;c[268004]=-1638382;c[268005]=458795;c[268006]=2490415;c[268007]=-3014682;c[268008]=-1638384;c[268009]=131110;c[268010]=2687026;c[268011]=-3604491;c[268012]=-2490331;c[268013]=-524232;c[268014]=1769543;c[268015]=-4194366;c[268016]=-3276817;c[268017]=-1572859;c[268018]=851982;c[268019]=-7209155;c[268020]=-5898306;c[268021]=-3276842;c[268022]=-851997;c[268023]=-4456502;c[268024]=-2621463;c[268025]=-3014691;c[268026]=-1835052;c[268027]=-2818078;c[268028]=-1114102;c[268029]=-1507326;c[268030]=-327689;c[268031]=-2097171;c[268032]=-589807;c[268033]=-851957;c[268034]=524289;c[268035]=-2359317;c[268036]=-851950;c[268037]=-983029;c[268038]=458752;c[268039]=-2359317;c[268040]=-917490;c[268041]=-1114106;c[268042]=196607;c[268043]=-2293787;c[268044]=-851962;c[268045]=-655358;c[268046]=65528;c[268047]=-2883617;c[268048]=-1376249;c[268049]=-1441796;c[268050]=-262156;c[268051]=-4259885;c[268052]=-2752533;c[268053]=-3014685;c[268054]=-1769511;c[268055]=-25;c[268056]=-16;c[268057]=-16;c[268058]=-9;c[268059]=-21;c[268060]=-8;c[268061]=-3;c[268062]=0;c[268063]=-21;c[268064]=-9;c[268065]=-4;c[268066]=2;c[268067]=-22;c[268068]=-6;c[268069]=-1;c[268070]=2;c[268071]=-22;c[268072]=-7;c[268073]=0;c[268074]=1;c[268075]=-21;c[268076]=-7;c[268077]=0;c[268078]=2;c[268079]=-12;c[268080]=4;c[268081]=8;c[268082]=12;c[268083]=-23;c[268084]=-15;c[268085]=-11;c[268086]=-5;c[268087]=-4587520;c[268088]=-3735555;c[268089]=-2686980;c[268090]=-1900545;c[268091]=-3801092;c[268092]=-1966074;c[268093]=-1376247;c[268094]=-262136;c[268095]=-2555906;c[268096]=-1114106;c[268097]=-458743;c[268098]=327689;c[268099]=-1900545;c[268100]=-327672;c[268101]=589834;c[268102]=1114119;c[268103]=-1769475;c[268104]=-327671;c[268105]=655368;c[268106]=1507335;c[268107]=-2621442;c[268108]=-1048570;c[268109]=-720888;c[268110]=196618;c[268111]=-3538946;c[268112]=-1966073;c[268113]=-1376249;c[268114]=-458746;c[268115]=-4915201;c[268116]=-3538948;c[268117]=-2883585;c[268118]=-1966080;c[268119]=13893952;c[268120]=26870234;c[268121]=4194541;c[268122]=4259973;c[268123]=7012599;c[268124]=5046593;c[268125]=3277092;c[268126]=-261953;c[268127]=1245382;c[268128]=5177625;c[268129]=5964007;c[268130]=5701773;c[268131]=5964039;c[268132]=12452063;c[268133]=13107357;c[268134]=9502962;c[268135]=8650929;c[268136]=12255437;c[268137]=14680207;c[268138]=14876766;c[268139]=7733395;c[268140]=11665596;c[268141]=13041777;c[268142]=12910662;c[268143]=4718708;c[268144]=7930014;c[268145]=9306205;c[268146]=10551344;c[268147]=1966174;c[268148]=4980856;c[268149]=6619214;c[268150]=7274527;Wu(1072604,0,272)|0;c[268219]=458741;c[268220]=-262138;c[268221]=524295;c[268222]=-131069;c[268223]=-262162;c[268224]=-327682;c[268225]=327699;c[268226]=262168;c[268227]=196591;c[268228]=196599;c[268229]=-524268;c[268230]=-196573;c[268231]=524282;c[268232]=589829;c[268233]=458755;c[268234]=-393195;c[268235]=524282;c[268236]=-327688;c[268237]=131066;c[268238]=262142;c[268239]=196604;c[268240]=-589804;c[268241]=65528;c[268242]=1179644;c[268243]=0;c[268244]=0;c[268245]=0;c[268246]=0;c[268247]=-6357135;c[268248]=-5374048;c[268249]=-3014736;c[268250]=-917577;c[268251]=-4522067;c[268252]=-3604523;c[268253]=-1114133;c[268254]=589814;c[268255]=-3276871;c[268256]=-2555926;c[268257]=-524288;c[268258]=1835017;c[268259]=-2687001;c[268260]=-1638382;c[268261]=458795;c[268262]=2490415;c[268263]=-3014682;c[268264]=-1638384;c[268265]=131110;c[268266]=2687026;c[268267]=-3604491;c[268268]=-2490331;c[268269]=-524232;c[268270]=1769543;c[268271]=-4194366;c[268272]=-3276817;c[268273]=-1572859;c[268274]=851982;c[268275]=-7209155;c[268276]=-5898306;c[268277]=-3276842;c[268278]=-851997;c[268279]=-4456502;c[268280]=-2621463;c[268281]=-3014691;c[268282]=-1835052;c[268283]=-2818078;c[268284]=-1114102;c[268285]=-1507326;c[268286]=-327689;c[268287]=-2097171;c[268288]=-589807;c[268289]=-851957;c[268290]=524289;c[268291]=-2359317;c[268292]=-851950;c[268293]=-983029;c[268294]=458752;c[268295]=-2359317;c[268296]=-917490;c[268297]=-1114106;c[268298]=196607;c[268299]=-2293787;c[268300]=-851962;c[268301]=-655358;c[268302]=65528;c[268303]=-2883617;c[268304]=-1376249;c[268305]=-1441796;c[268306]=-262156;c[268307]=-4259885;c[268308]=-2752533;c[268309]=-3014685;c[268310]=-1769511;c[268311]=-25;c[268312]=-16;c[268313]=-16;c[268314]=-9;c[268315]=-21;c[268316]=-8;c[268317]=-3;c[268318]=0;c[268319]=-21;c[268320]=-9;c[268321]=-4;c[268322]=2;c[268323]=-22;c[268324]=-6;c[268325]=-1;c[268326]=2;c[268327]=-22;c[268328]=-7;c[268329]=0;c[268330]=1;c[268331]=-21;c[268332]=-7;c[268333]=0;c[268334]=2;c[268335]=-12;c[268336]=4;c[268337]=8;c[268338]=12;c[268339]=-23;c[268340]=-15;c[268341]=-11;c[268342]=-5;c[268343]=-4587520;c[268344]=-3735555;c[268345]=-2686980;c[268346]=-1900545;c[268347]=-3801092;c[268348]=-1966074;c[268349]=-1376247;c[268350]=-262136;c[268351]=-2555906;c[268352]=-1114106;c[268353]=-458743;c[268354]=327689;c[268355]=-1900545;c[268356]=-327672;c[268357]=589834;c[268358]=1114119;c[268359]=-1769475;c[268360]=-327671;c[268361]=655368;c[268362]=1507335;c[268363]=-2621442;c[268364]=-1048570;c[268365]=-720888;c[268366]=196618;c[268367]=-3538946;c[268368]=-1966073;c[268369]=-1376249;c[268370]=-458746;c[268371]=-4915201;c[268372]=-3538948;c[268373]=-2883585;c[268374]=-1966080;c[268375]=1835238;c[268376]=-2293370;c[268377]=9568653;c[268378]=5439840;c[268379]=2425075;c[268380]=4849938;c[268381]=15008092;c[268382]=25755944;c[268383]=1638636;c[268384]=6881585;c[268385]=6226175;c[268386]=12321022;c[268387]=11469046;c[268388]=16056587;c[268389]=16318644;c[268390]=0;c[268391]=7864471;c[268392]=13566151;c[268393]=15138972;c[268394]=0;c[268395]=7012529;c[268396]=15073469;c[268397]=11272333;c[268398]=16449747;c[268399]=2359322;c[268400]=9502884;c[268401]=9109606;c[268402]=8716246;c[268403]=131219;c[268404]=458938;c[268405]=5177393;c[268406]=3276848;Wu(1073628,0,272)|0;c[268475]=458741;c[268476]=-262138;c[268477]=524295;c[268478]=-131069;c[268479]=-262162;c[268480]=-327682;c[268481]=327699;c[268482]=262168;c[268483]=196591;c[268484]=196599;c[268485]=-524268;c[268486]=-196573;c[268487]=524282;c[268488]=589829;c[268489]=458755;c[268490]=-393195;c[268491]=524282;c[268492]=-327688;c[268493]=131066;c[268494]=262142;c[268495]=196604;c[268496]=-589804;c[268497]=65528;c[268498]=1179644;c[268499]=0;c[268500]=0;c[268501]=0;c[268502]=0;c[268503]=-6357135;c[268504]=-5374048;c[268505]=-3014736;c[268506]=-917577;c[268507]=-4522067;c[268508]=-3604523;c[268509]=-1114133;c[268510]=589814;c[268511]=-3276871;c[268512]=-2555926;c[268513]=-524288;c[268514]=1835017;c[268515]=-2687001;c[268516]=-1638382;c[268517]=458795;c[268518]=2490415;c[268519]=-3014682;c[268520]=-1638384;c[268521]=131110;c[268522]=2687026;c[268523]=-3604491;c[268524]=-2490331;c[268525]=-524232;c[268526]=1769543;c[268527]=-4194366;c[268528]=-3276817;c[268529]=-1572859;c[268530]=851982;c[268531]=-7209155;c[268532]=-5898306;c[268533]=-3276842;c[268534]=-851997;c[268535]=-4456502;c[268536]=-2621463;c[268537]=-3014691;c[268538]=-1835052;c[268539]=-2818078;c[268540]=-1114102;c[268541]=-1507326;c[268542]=-327689;c[268543]=-2097171;c[268544]=-589807;c[268545]=-851957;c[268546]=524289;c[268547]=-2359317;c[268548]=-851950;c[268549]=-983029;c[268550]=458752;c[268551]=-2359317;c[268552]=-917490;c[268553]=-1114106;c[268554]=196607;c[268555]=-2293787;c[268556]=-851962;c[268557]=-655358;c[268558]=65528;c[268559]=-2883617;c[268560]=-1376249;c[268561]=-1441796;c[268562]=-262156;c[268563]=-4259885;c[268564]=-2752533;c[268565]=-3014685;c[268566]=-1769511;c[268567]=-25;c[268568]=-16;c[268569]=-16;c[268570]=-9;c[268571]=-21;c[268572]=-8;c[268573]=-3;c[268574]=0;c[268575]=-21;c[268576]=-9;c[268577]=-4;c[268578]=2;c[268579]=-22;c[268580]=-6;c[268581]=-1;c[268582]=2;c[268583]=-22;c[268584]=-7;c[268585]=0;c[268586]=1;c[268587]=-21;c[268588]=-7;c[268589]=0;c[268590]=2;c[268591]=-12;c[268592]=4;c[268593]=8;c[268594]=12;c[268595]=-23;c[268596]=-15;c[268597]=-11;c[268598]=-5;c[268599]=-4587520;c[268600]=-3735555;c[268601]=-2686980;c[268602]=-1900545;c[268603]=-3801092;c[268604]=-1966074;c[268605]=-1376247;c[268606]=-262136;c[268607]=-2555906;c[268608]=-1114106;c[268609]=-458743;c[268610]=327689;c[268611]=-1900545;c[268612]=-327672;c[268613]=589834;c[268614]=1114119;c[268615]=-1769475;c[268616]=-327671;c[268617]=655368;c[268618]=1507335;c[268619]=-2621442;c[268620]=-1048570;c[268621]=-720888;c[268622]=196618;c[268623]=-3538946;c[268624]=-1966073;c[268625]=-1376249;c[268626]=-458746;c[268627]=-4915201;c[268628]=-3538948;c[268629]=-2883585;c[268630]=-1966080;c[268631]=1835238;c[268632]=-2293370;c[268633]=9568653;c[268634]=5439840;c[268635]=2425075;c[268636]=4849938;c[268637]=15008092;c[268638]=25755944;c[268639]=1638636;c[268640]=6881585;c[268641]=6226175;c[268642]=12321022;c[268643]=11469046;c[268644]=16056587;c[268645]=16318644;c[268646]=0;c[268647]=7864471;c[268648]=13566151;c[268649]=15138972;c[268650]=0;c[268651]=7012529;c[268652]=15073469;c[268653]=11272333;c[268654]=16449747;c[268655]=2359322;c[268656]=9502884;c[268657]=9109606;c[268658]=8716246;c[268659]=131219;c[268660]=458938;c[268661]=5177393;c[268662]=3276848;Wu(1074652,0,384)|0;c[268759]=-6357135;c[268760]=-5374048;c[268761]=-3014736;c[268762]=-917577;c[268763]=-4522067;c[268764]=-3604523;c[268765]=-1114133;c[268766]=589814;c[268767]=-3276871;c[268768]=-2555926;c[268769]=-524288;c[268770]=1835017;c[268771]=-2687001;c[268772]=-1638382;c[268773]=458795;c[268774]=2490415;c[268775]=-3014682;c[268776]=-1638384;c[268777]=131110;c[268778]=2687026;c[268779]=-3604491;c[268780]=-2490331;c[268781]=-524232;c[268782]=1769543;c[268783]=-4194366;c[268784]=-3276817;c[268785]=-1572859;c[268786]=851982;c[268787]=-7209155;c[268788]=-5898306;c[268789]=-3276842;c[268790]=-851997;c[268791]=-4456502;c[268792]=-2621463;c[268793]=-3014691;c[268794]=-1835052;c[268795]=-2818078;c[268796]=-1114102;c[268797]=-1507326;c[268798]=-327689;c[268799]=-2097171;c[268800]=-589807;c[268801]=-851957;c[268802]=524289;c[268803]=-2359317;c[268804]=-851950;c[268805]=-983029;c[268806]=458752;c[268807]=-2359317;c[268808]=-917490;c[268809]=-1114106;c[268810]=196607;c[268811]=-2293787;c[268812]=-851962;c[268813]=-655358;c[268814]=65528;c[268815]=-2883617;c[268816]=-1376249;c[268817]=-1441796;c[268818]=-262156;c[268819]=-4259885;c[268820]=-2752533;c[268821]=-3014685;c[268822]=-1769511;c[268823]=-25;c[268824]=-16;c[268825]=-16;c[268826]=-9;c[268827]=-21;c[268828]=-8;c[268829]=-3;c[268830]=0;c[268831]=-21;c[268832]=-9;c[268833]=-4;c[268834]=2;c[268835]=-22;c[268836]=-6;c[268837]=-1;c[268838]=2;c[268839]=-22;c[268840]=-7;c[268841]=0;c[268842]=1;c[268843]=-21;c[268844]=-7;c[268845]=0;c[268846]=2;c[268847]=-12;c[268848]=4;c[268849]=8;c[268850]=12;c[268851]=-23;c[268852]=-15;c[268853]=-11;c[268854]=-5;c[268855]=-4587520;c[268856]=-3735555;c[268857]=-2686980;c[268858]=-1900545;c[268859]=-3801092;c[268860]=-1966074;c[268861]=-1376247;c[268862]=-262136;c[268863]=-2555906;c[268864]=-1114106;c[268865]=-458743;c[268866]=327689;c[268867]=-1900545;c[268868]=-327672;c[268869]=589834;c[268870]=1114119;c[268871]=-1769475;c[268872]=-327671;c[268873]=655368;c[268874]=1507335;c[268875]=-2621442;c[268876]=-1048570;c[268877]=-720888;c[268878]=196618;c[268879]=-3538946;c[268880]=-1966073;c[268881]=-1376249;c[268882]=-458746;c[268883]=-4915201;c[268884]=-3538948;c[268885]=-2883585;c[268886]=-1966080;c[268887]=1835299;c[268888]=4981080;c[268889]=6750502;c[268890]=7340251;c[268891]=4587809;c[268892]=7799113;c[268893]=11141383;c[268894]=10420429;c[268895]=7143650;c[268896]=10748175;c[268897]=12779722;c[268898]=12517512;c[268899]=8585420;c[268900]=12714196;c[268901]=12714159;c[268902]=13369481;c[268903]=8650929;c[268904]=12255437;c[268905]=14680207;c[268906]=14876766;c[268907]=7733395;c[268908]=11665596;c[268909]=13041777;c[268910]=12910662;c[268911]=4718708;c[268912]=7930014;c[268913]=9306205;c[268914]=10551344;c[268915]=1966174;c[268916]=4980856;c[268917]=6619214;c[268918]=7274527;Wu(1075676,0,272)|0;c[268987]=458741;c[268988]=-262138;c[268989]=524295;c[268990]=-131069;c[268991]=-262162;c[268992]=-327682;c[268993]=327699;c[268994]=262168;c[268995]=196591;c[268996]=196599;c[268997]=-524268;c[268998]=-196573;c[268999]=524282;c[269e3]=589829;c[269001]=458755;c[269002]=-393195;c[269003]=524282;c[269004]=-327688;c[269005]=131066;c[269006]=262142;c[269007]=196604;c[269008]=-589804;c[269009]=65528;c[269010]=1179644;c[269011]=0;c[269012]=0;c[269013]=0;c[269014]=0;c[269015]=-6357135;c[269016]=-5374048;c[269017]=-3014736;c[269018]=-917577;c[269019]=-4522067;c[269020]=-3604523;c[269021]=-1114133;c[269022]=589814;c[269023]=-3276871;c[269024]=-2555926;c[269025]=-524288;c[269026]=1835017;c[269027]=-2687001;c[269028]=-1638382;c[269029]=458795;c[269030]=2490415;c[269031]=-3014682;c[269032]=-1638384;c[269033]=131110;c[269034]=2687026;c[269035]=-3604491;c[269036]=-2490331;c[269037]=-524232;c[269038]=1769543;c[269039]=-4194366;c[269040]=-3276817;c[269041]=-1572859;c[269042]=851982;c[269043]=-7209155;c[269044]=-5898306;c[269045]=-3276842;c[269046]=-851997;c[269047]=-4456502;c[269048]=-2621463;c[269049]=-3014691;c[269050]=-1835052;c[269051]=-2818078;c[269052]=-1114102;c[269053]=-1507326;c[269054]=-327689;c[269055]=-2097171;c[269056]=-589807;c[269057]=-851957;c[269058]=524289;c[269059]=-2359317;c[269060]=-851950;c[269061]=-983029;c[269062]=458752;c[269063]=-2359317;c[269064]=-917490;c[269065]=-1114106;c[269066]=196607;c[269067]=-2293787;c[269068]=-851962;c[269069]=-655358;c[269070]=65528;c[269071]=-2883617;c[269072]=-1376249;c[269073]=-1441796;c[269074]=-262156;c[269075]=-4259885;c[269076]=-2752533;c[269077]=-3014685;c[269078]=-1769511;c[269079]=-25;c[269080]=-16;c[269081]=-16;c[269082]=-9;c[269083]=-21;c[269084]=-8;c[269085]=-3;c[269086]=0;c[269087]=-21;c[269088]=-9;c[269089]=-4;c[269090]=2;c[269091]=-22;c[269092]=-6;c[269093]=-1;c[269094]=2;c[269095]=-22;c[269096]=-7;c[269097]=0;c[269098]=1;c[269099]=-21;c[269100]=-7;c[269101]=0;c[269102]=2;c[269103]=-12;c[269104]=4;c[269105]=8;c[269106]=12;c[269107]=-23;c[269108]=-15;c[269109]=-11;c[269110]=-5;c[269111]=-4587520;c[269112]=-3735555;c[269113]=-2686980;c[269114]=-1900545;c[269115]=-3801092;c[269116]=-1966074;c[269117]=-1376247;c[269118]=-262136;c[269119]=-2555906;c[269120]=-1114106;c[269121]=-458743;c[269122]=327689;c[269123]=-1900545;c[269124]=-327672;c[269125]=589834;c[269126]=1114119;c[269127]=-1769475;c[269128]=-327671;c[269129]=655368;c[269130]=1507335;c[269131]=-2621442;c[269132]=-1048570;c[269133]=-720888;c[269134]=196618;c[269135]=-3538946;c[269136]=-1966073;c[269137]=-1376249;c[269138]=-458746;c[269139]=-4915201;c[269140]=-3538948;c[269141]=-2883585;c[269142]=-1966080;c[269143]=1835299;c[269144]=4981080;c[269145]=6750502;c[269146]=7340251;c[269147]=4587809;c[269148]=7799113;c[269149]=11141383;c[269150]=10420429;c[269151]=7143650;c[269152]=10748175;c[269153]=12779722;c[269154]=12517512;c[269155]=8585420;c[269156]=12714196;c[269157]=12714159;c[269158]=13369481;c[269159]=8650929;c[269160]=12255437;c[269161]=14680207;c[269162]=14876766;c[269163]=7733395;c[269164]=11665596;c[269165]=13041777;c[269166]=12910662;c[269167]=4718708;c[269168]=7930014;c[269169]=9306205;c[269170]=10551344;c[269171]=1966174;c[269172]=4980856;c[269173]=6619214;c[269174]=7274527;a=1076700;d=a+128|0;do{c[a>>2]=0;a=a+4|0}while((a|0)<(d|0));c[269207]=0;c[269208]=1179692;c[269209]=2031657;c[269210]=131083;c[269211]=14;c[269212]=983065;l=1076852;c[l>>2]=0;c[l+4>>2]=0;i=b;return}function Zf(){var a=0,b=0,d=0,e=0,f=0,g=0,h=0;f=0;do{d=1;do{a=6728+(f<<7)+(d<<2)|0;b=d^8;c[6728+(f<<7)+(b<<2)>>2]=c[a>>2];e=6728+(f<<7)+64+(d<<2)|0;c[6728+(f<<7)+64+(b<<2)>>2]=c[e>>2];a=(c[e>>2]<<16)+(c[a>>2]|0)|0;e=0;do{g=e&7;h=g^7;g=(c[1068636+(f<<10)+(d<<7)+(e>>3<<4)+((h>>>0<g>>>0?h:g)<<2)>>2]|0)+a|0;c[1035344+(f*4160|0)+(d*260|0)+(e<<2)>>2]=g;c[1035344+(f*4160|0)+(b*260|0)+((e^56)<<2)>>2]=0-g;e=e+1|0}while((e|0)!=64);h=(c[1076828+(d<<2)>>2]|0)+a|0;c[1035344+(f*4160|0)+(d*260|0)+256>>2]=h;c[1035344+(f*4160|0)+(b*260|0)+256>>2]=0-h;d=d+1|0}while((d|0)!=7);f=f+1|0}while((f|0)!=8);return}function _f(a){a=a|0;Gg(a);mu(a);return}function $f(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;s=i;i=i+48|0;p=s+44|0;d=s+32|0;e=s;q=s+20|0;n=b+160|0;o=b+5508|0;g=c[o>>2]|0;c[269215]=g;f=c[b+5504>>2]|0;c[b+5528>>2]=f;Xg(983976,983840,g,f);rk(d,17268,8);f=((qh(Zd(1148396,d)|0)|0)*248|0)/100|0;vk(d);d=c[269215]|0;c[1082292+(d<<2)>>2]=0-f;c[1082292+((d^1)<<2)>>2]=f;d=b+5532|0;f=c[d>>2]|0;g=b+5536|0;if((f|0)!=(c[g>>2]|0)){d=c[287054]|0;f=c[287055]|0;if((d|0)!=(f|0))do{e=c[d>>2]|0;if((e|0)!=(b|0))Ng(e,0);d=d+4|0}while((d|0)!=(f|0));bg(b);i=s;return}c[e>>2]=-32001;c[e+4>>2]=-32001;h=e+8|0;m=e+12|0;j=Nu(4)|0;c[h>>2]=j;l=j+4|0;k=e+16|0;c[k>>2]=l;c[j>>2]=0;c[m>>2]=l;if(f>>>0>=(c[b+5540>>2]|0)>>>0){ag(d,e);d=c[e+8>>2]|0;e=d;if(d|0){f=c[m>>2]|0;if((f|0)!=(d|0))c[m>>2]=f+(~((f+-4-e|0)>>>2)<<2);mu(d)}}else{t=e;d=c[t+4>>2]|0;e=f;c[e>>2]=c[t>>2];c[e+4>>2]=d;c[f+8>>2]=j;c[f+12>>2]=l;c[f+16>>2]=l;c[k>>2]=0;c[m>>2]=0;c[h>>2]=0;c[g>>2]=(c[g>>2]|0)+20}d=(c[b+5516>>2]|0)+64|0;d=(c[d>>2]|0)==0&(c[d+4>>2]|0)==0?0:-32e3;f=b+5524|0;e=c[f>>2]|0;a:do switch(e|0){case 5:{e=c[b+560+((c[o>>2]<<3^14)<<8)>>2]|0;if(((e>>3)+-3|0)>>>0<2)d=((e&7)+-3|0)>>>0<2?-32e3:d;break}case 6:{t=c[o>>2]<<3;if((c[b+560+((t|6)<<8)>>2]&-8|0)==56?(c[b+560+((t^14)<<8)>>2]&-8|0)==56:0){d=0;break a}d=Ad(n)|0;e=c[f>>2]|0;d=d?-32e3:32e3;r=14;break}default:r=14}while(0);b:do if((r|0)==14)switch(e|0){case 4:{d=(c[b+496+(((c[b+520>>2]|0)!=0&1)<<3<<2)>>2]|0)==0?-32e3:d;break b}case 2:{d=(c[b+496+((c[o>>2]<<3|6)<<2)>>2]|0)==0?-32e3:d;break b}case 1:{d=(c[b+496+((c[o>>2]<<3^8)<<2)>>2]|0)==0?-32e3:32e3;break b}default:break b}while(0);r=Ud(oe(1149064,0)|0,16317,19)|0;lh(q,d);t=a[q>>0]|0;b=(t&1)==0;t=Ud(r,b?q+1|0:c[q+8>>2]|0,b?(t&255)>>>1:c[q+4>>2]|0)|0;c[p>>2]=gm(t+(c[(c[t>>2]|0)+-12>>2]|0)|0)|0;b=Om(p,1150100)|0;b=Lb[c[(c[b>>2]|0)+28>>2]&63](b,10)|0;_t(p);ym(t,b)|0;lm(t)|0;oe(t,1)|0;vk(q);i=s;return}function ag(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;j=a+4|0;f=c[a>>2]|0;e=(((c[j>>2]|0)-f|0)/20|0)+1|0;if(e>>>0>214748364)ft(a);k=a+8|0;d=((c[k>>2]|0)-f|0)/20|0;if(d>>>0<107374182){d=d<<1;d=d>>>0<e>>>0?e:d;e=((c[j>>2]|0)-f|0)/20|0;if(!d){g=0;h=0}else i=6}else{d=214748364;e=((c[j>>2]|0)-f|0)/20|0;i=6}if((i|0)==6){g=d;h=Nu(d*20|0)|0}f=h+(e*20|0)|0;d=f;i=h+(g*20|0)|0;m=b;l=c[m+4>>2]|0;g=f;c[g>>2]=c[m>>2];c[g+4>>2]=l;g=b+8|0;c[h+(e*20|0)+16>>2]=0;c[h+(e*20|0)+8>>2]=c[g>>2];l=b+12|0;c[h+(e*20|0)+12>>2]=c[l>>2];b=b+16|0;c[h+(e*20|0)+16>>2]=c[b>>2];c[b>>2]=0;c[l>>2]=0;c[g>>2]=0;h=f+20|0;g=c[a>>2]|0;e=c[j>>2]|0;if((e|0)==(g|0)){b=g;e=g}else{do{b=e;e=e+-20|0;n=e;m=c[n+4>>2]|0;l=f+-20|0;c[l>>2]=c[n>>2];c[l+4>>2]=m;l=f+-12|0;m=b+-12|0;c[l>>2]=0;n=f+-8|0;c[n>>2]=0;c[f+-4>>2]=0;c[l>>2]=c[m>>2];l=b+-8|0;c[n>>2]=c[l>>2];b=b+-4|0;c[f+-4>>2]=c[b>>2];c[b>>2]=0;c[l>>2]=0;c[m>>2]=0;f=d+-20|0;d=f}while((e|0)!=(g|0));b=c[a>>2]|0;e=c[j>>2]|0}c[a>>2]=d;c[j>>2]=h;c[k>>2]=i;i=b;if((e|0)!=(i|0)){d=e;do{e=c[d+-12>>2]|0;f=e;if(e|0){g=d+-8|0;h=c[g>>2]|0;if((h|0)!=(e|0))c[g>>2]=h+(~((h+-4-f|0)>>>2)<<2);mu(e)}d=d+-20|0}while((d|0)!=(i|0))}if(!b)return;mu(b);return}function bg(b){b=b|0;var e=0,f=0,g=0,j=0,k=0,l=0;k=i;i=i+32|0;e=k+12|0;f=k;c[270570]=0;j=c[287054]|0;if((c[287055]|0)==(j|0))gt(1148216);do if((c[j>>2]|0)==(b|0))if((c[287055]|0)==(j|0))gt(1148216);else{g=c[j>>2]|0;break}else g=0;while(0);c[270571]=g;Wu(1077024+-160|0,0,280)|0;c[270567]=-32001;c[270569]=-32001;c[270566]=-32001;c[270568]=32001;c[b+5548>>2]=0;if(g|0){j=(c[b+5516>>2]|0)+56|0;l=983920;c[270570]=((c[l>>2]|0)==(c[j>>2]|0)?(c[l+4>>2]|0)==(c[j+4>>2]|0):0)?c[245984]|0:0;c[245978]=0;c[245980]=0;c[245981]=0;c[245982]=0;c[245983]=0;c[245984]=0;a[g+4241333>>0]=0;a[g+4241332>>0]=0;h[g+4241336>>3]=0.0;a[1148268]=(d[1148268]|0)+4}rk(e,17321,7);c[270572]=qh(Zd(1148396,e)|0)|0;vk(e);rk(f,17329,11);e=983944;c[e>>2]=qh(Zd(1148396,f)|0)|0;c[e+4>>2]=0;vk(f);e=c[270572]|0;if((c[245986]|0)>=20){l=e;j=b+5532|0;g=b+5536|0;g=c[g>>2]|0;j=c[j>>2]|0;j=g-j|0;j=(j|0)/20|0;g=j>>>0<l>>>0;l=g?j:l;c[270572]=l;ub(151,b|0,30);i=k;return}l=e>>>0<4?4:e;c[270572]=l;j=b+5532|0;g=b+5536|0;g=c[g>>2]|0;j=c[j>>2]|0;j=g-j|0;j=(j|0)/20|0;g=j>>>0<l>>>0;l=g?j:l;c[270572]=l;ub(151,b|0,30);i=k;return}function cg(a){a=a|0;dg(a);return}function dg(b){b=b|0;var e=0,f=0,g=0,j=0,k=0,l=0,m=0.0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,D=0,E=0,F=0,G=0,H=0,I=0.0;H=i;i=i+928|0;G=H+8|0;v=H+920|0;w=H+904|0;x=H+888|0;y=H;z=H+908|0;A=H+892|0;B=b+5544|0;F=(c[B>>2]|0)+1|0;c[B>>2]=F;a:do if((F|0)<128?(a[1217488]&1)==0:0){f=c[245969]|0;do if(!f){e=c[270571]|0;if(!e)D=10;else D=12}else{g=c[287054]|0;if((c[287055]|0)==(g|0))gt(1148216);e=c[270571]|0;j=(e|0)!=0;if((c[(c[g>>2]|0)+5544>>2]|0)<=(f|0))if(j){D=12;break}else{D=10;break}if(j)break a;i=H;return}while(0);if((D|0)==10){E=(((c[b+136>>2]|0)+-1|0)>>>0)%20|0;F=c[1082300+(E*12|0)>>2]|0;if(c[F+(((((c[b+5504>>2]|0)+(c[B>>2]|0)|0)>>>0)%((c[1082300+(E*12|0)+4>>2]|0)-F>>2>>>0)|0)<<2)>>2]|0){ub(151,b|0,30);i=H;return}}else if((D|0)==12){F=e+4241336|0;h[F>>3]=+h[F>>3]*.505;a[e+4241333>>0]=0}F=b+5532|0;e=c[F>>2]|0;E=b+5536|0;f=c[E>>2]|0;if((e|0)!=(f|0))do{c[e+4>>2]=c[e>>2];e=e+20|0}while((e|0)!=(f|0));n=b+140|0;c[n>>2]=0;b:do if(c[270572]|0){o=b+160|0;p=z+8|0;q=z+1|0;r=z+4|0;s=A+8|0;t=A+1|0;u=A+4|0;do{if(a[1217488]&1)break b;e=c[B>>2]|0;if((e|0)>=5){c[270569]=18;l=(c[F>>2]|0)+((c[n>>2]|0)*20|0)+4|0;k=(c[l>>2]|0)+-18|0;c[270567]=(k|0)<-32001?-32001:k;l=(c[l>>2]|0)+18|0;c[270568]=(l|0)>32001?32001:l}while(1){c[270566]=eg(o,1077024,c[270567]|0,c[270568]|0,e,0)|0;j=c[E>>2]|0;k=(c[F>>2]|0)+((c[n>>2]|0)*20|0)|0;g=j-k|0;l=(g|0)/20|0;if((g|0)>0){e=l;while(1){f=Pu(e*20|0,1219564)|0;if(f|0){D=22;break}if((e|0)>1)e=(e|0)/2|0;else{f=0;e=0;break}}if((D|0)==22)D=0;g=f}else{g=0;e=0;f=0}c[w>>2]=k;c[x>>2]=j;c[v>>2]=c[w>>2];c[G>>2]=c[x>>2];og(v,G,y,l,g,e);if(f|0)mu(f);if(a[1217488]&1)break;if((c[270571]|0)!=0&(c[270572]|0)==1?(l=c[270566]|0,!((l|0)>(c[270567]|0)&(l|0)<(c[270568]|0))):0){if(!(c[245967]|0)){l=dl()|0;l=fv(l|0,C|0,1e6,0)|0;e=983984;e=Vu(l|0,C|0,c[e>>2]|0,c[e+4>>2]|0)|0}else e=Rg(1148216)|0;if((e|0)>3e3){j=oe(1149064,0)|0;yg(z,o,c[B>>2]|0,c[270567]|0,c[270568]|0);l=a[z>>0]|0;k=(l&1)==0;l=Ud(j,k?q:c[p>>2]|0,k?(l&255)>>>1:c[r>>2]|0)|0;c[G>>2]=gm(l+(c[(c[l>>2]|0)+-12>>2]|0)|0)|0;k=Om(G,1150100)|0;k=Lb[c[(c[k>>2]|0)+28>>2]&63](k,10)|0;_t(G);ym(l,k)|0;lm(l)|0;oe(l,1)|0;vk(z)}}g=c[270566]|0;e=c[270567]|0;f=c[270568]|0;if((g|0)<=(e|0)){c[270568]=(f+e|0)/2|0;e=c[270569]|0;f=g-e|0;c[270567]=(f|0)<-32001?-32001:f;f=c[270571]|0;if(f){a[f+4241333>>0]=1;a[1217489]=0;e=c[270569]|0}}else{if((g|0)<(f|0))break;c[270567]=(f+e|0)/2|0;e=c[270569]|0;l=e+g|0;c[270568]=(l|0)>32001?32001:l}c[270569]=e+5+((e|0)/4|0);e=c[B>>2]|0}k=c[F>>2]|0;j=k+((c[n>>2]|0)*20|0)+20|0;g=j-k|0;l=(g|0)/20|0;if((g|0)>0){e=l;while(1){f=Pu(e*20|0,1219564)|0;if(f|0){D=43;break}if((e|0)>1)e=(e|0)/2|0;else{f=0;e=0;break}}if((D|0)==43)D=0;g=f}else{g=0;e=0;f=0}c[w>>2]=k;c[x>>2]=j;c[v>>2]=c[w>>2];c[G>>2]=c[x>>2];og(v,G,y,l,g,e);if(f|0)mu(f);do if(c[270571]|0){if((a[1217488]&1)==0?((c[n>>2]|0)+1|0)!=(c[270572]|0):0){if(!(c[245967]|0)){l=dl()|0;l=fv(l|0,C|0,1e6,0)|0;e=983984;e=Vu(l|0,C|0,c[e>>2]|0,c[e+4>>2]|0)|0}else e=Rg(1148216)|0;if((e|0)<=3e3)break}j=oe(1149064,0)|0;yg(A,o,c[B>>2]|0,c[270567]|0,c[270568]|0);l=a[A>>0]|0;k=(l&1)==0;l=Ud(j,k?t:c[s>>2]|0,k?(l&255)>>>1:c[u>>2]|0)|0;c[G>>2]=gm(l+(c[(c[l>>2]|0)+-12>>2]|0)|0)|0;k=Om(G,1150100)|0;k=Lb[c[(c[k>>2]|0)+28>>2]&63](k,10)|0;_t(G);ym(l,k)|0;lm(l)|0;oe(l,1)|0;vk(A)}while(0);l=(c[n>>2]|0)+1|0;c[n>>2]=l}while(l>>>0<(c[270572]|0)>>>0)}while(0);if(!(a[1217488]&1))c[b+5548>>2]=c[B>>2];if(!(c[270571]|0)){ub(151,b|0,30);i=H;return}D=c[245986]|0;if((D|0)<20?(D+1|0)==(c[B>>2]|0):0)zg(c[270572]|0)|0;e=c[245971]|0;D=c[270566]|0;if((e|0)!=0&(D|0)>31743?(32e3-D|0)<=(e<<1|0):0){a[1217488]=1;e=c[245971]|0}A=c[245970]|e|c[245969];B=983896;D=c[245972]|0;do if((A|c[B>>2]|D|0)==0?(((A|0)<0)<<31>>31|c[B+4>>2]|((D|0)<0)<<31>>31|0)==0:0){do if((a[1217488]&1)==0?(a[1217489]&1)==0:0){e=c[270571]|0;g=(0-(d[e+4241333>>0]|0)&119)+357+(_((c[270566]|0)-(c[e+4241344>>2]|0)|0,-6)|0)|0;g=(g|0)<715?g:715;g=(g|0)>229?g:229;I=+h[e+4241336>>3];m=I+1.0;e=c[F>>2]|0;if(I<.03?(c[c[e+8>>2]>>2]|0)==(c[270570]|0):0){if(!(c[245967]|0)){D=dl()|0;D=fv(D|0,C|0,1e6,0)|0;f=983984;f=Vu(D|0,C|0,c[f>>2]|0,c[f+4>>2]|0)|0}else f=Rg(1148216)|0;e=c[F>>2]|0;f=(f|0)>(((c[245998]|0)*5|0)/42|0|0)}else f=0;if(((c[E>>2]|0)-e|0)!=20){if(!(c[245967]|0)){E=dl()|0;E=fv(E|0,C|0,1e6,0)|0;e=983984;e=Vu(E|0,C|0,c[e>>2]|0,c[e+4>>2]|0)|0}else e=Rg(1148216)|0;if(!(+(e|0)>+(g|0)*(m*+(c[245998]|0))/628.0)?(a[(c[270571]|0)+4241332>>0]=f&1,!f):0)break}if(!(c[245973]|0)){a[1217488]=1;break}else{a[1217489]=1;break}}while(0);E=c[F>>2]|0;e=E+8|0;F=c[e>>2]|0;f=F;if((c[E+12>>2]|0)-F>>2>>>0<=2){c[245978]=0;c[245980]=0;c[245981]=0;c[245982]=0;c[245983]=0;c[245984]=0;break}g=b+160|0;j=f+8|0;F=(c[j>>2]|0)==(c[245984]|0);c[245978]=F?(c[245978]|0)+1|0:0;k=c[f>>2]|0;l=f+4|0;if((k|0)==(c[245982]|0)?!((c[l>>2]|0)!=(c[245983]|0)|F^1):0)break;c[245982]=k;c[245983]=c[l>>2];c[245984]=c[j>>2];E=c[f>>2]|0;Nf(g,E,G,Lf(g,E)|0);E=c[(c[e>>2]|0)+4>>2]|0;Nf(g,E,G+440|0,Lf(g,E)|0);E=(c[b+5516>>2]|0)+56|0;F=c[E+4>>2]|0;G=983920;c[G>>2]=c[E>>2];c[G+4>>2]=F;Pf(g,c[(c[e>>2]|0)+4>>2]|0);Pf(g,c[c[e>>2]>>2]|0)}while(0);ub(151,b|0,30);i=H;return}else D=8;while(0);if((D|0)==8){e=c[270571]|0;if(!e){i=H;return}}if(!((c[245978]|0)>=6?!(a[e+4241332>>0]|0):0)){c[245978]=0;c[245980]=0;c[245981]=0;c[245982]=0;c[245983]=0;c[245984]=0}if((c[245986]|0)<20){j=c[b+5532>>2]|0;e=c[b+5536>>2]|0;f=c[245987]|0;if(!f)f=zg(c[270572]|0)|0;c:do if((j|0)==(e|0))e=j;else{g=j;do{if((c[c[g+8>>2]>>2]|0)==(f|0)){e=g;break c}g=g+20|0}while((g|0)!=(e|0))}while(0);A=j;z=c[A>>2]|0;A=c[A+4>>2]|0;F=j+8|0;B=c[F>>2]|0;b=j+12|0;E=c[b>>2]|0;y=j+16|0;G=c[y>>2]|0;c[y>>2]=0;c[b>>2]=0;c[F>>2]=0;w=e;x=c[w+4>>2]|0;D=j;c[D>>2]=c[w>>2];c[D+4>>2]=x;D=e+8|0;c[F>>2]=c[D>>2];F=e+12|0;c[b>>2]=c[F>>2];b=e+16|0;c[y>>2]=c[b>>2];c[e>>2]=z;c[e+4>>2]=A;c[D>>2]=B;c[F>>2]=E;c[b>>2]=G;e=c[270571]|0}if(!e){i=H;return}ub(152,e|0,30);i=H;return}function eg(f,g,j,k,l,m){f=f|0;g=g|0;j=j|0;k=k|0;l=l|0;m=m|0;var n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ia=0,ja=0,ka=0,la=0,ma=0,na=0,oa=0,pa=0,qa=0,ra=0,sa=0,ta=0,ua=0,va=0,wa=0,xa=0,ya=0,za=0,Aa=0,Ba=0,Ca=0,Da=0,Ea=0,Fa=0,Ga=0,Ha=0,Ia=0,Ja=0,Ka=0,La=0,Ma=0,Na=0,Oa=0,Pa=0,Qa=0,Ra=0,Sa=0,Ta=0;Ta=i;i=i+5376|0;ya=Ta+5364|0;Fa=Ta+4848|0;Ia=Ta+4592|0;Ga=Ta;w=Ta+5368|0;Ea=Ta+452|0;za=Ta+440|0;n=c[g+-32>>2]|0;Ca=(n|0)==0;Da=c[f+5352>>2]|0;Ha=f+5356|0;Ma=(c[Ha>>2]|0)+64|0;Ma=(c[Ma>>2]|0)!=0|(c[Ma+4>>2]|0)!=0;Aa=g+36|0;c[Aa>>2]=0;Ba=g+32|0;c[Ba>>2]=0;Sa=g+8|0;c[Sa>>2]=n+1;n=Da+5552|0;if(!(a[n>>0]&1)){n=Da+148|0;o=n;n=c[n>>2]|0}else{a[n>>0]=0;o=983896;n=c[o>>2]|0;o=c[o+4>>2]|0;if((n|0)==0&(o|0)==0)n=4096;else{n=fv(n|0,o|0,1024,0)|0;Qa=C;Pa=(Qa|0)<0|(Qa|0)==0&n>>>0<4096;n=Pa?n:4096}o=Da+148|0;c[o>>2]=n}c[o>>2]=n+-1;if((n|0)<2){n=c[287054]|0;o=c[287055]|0;if((n|0)!=(o|0))do{a[(c[n>>2]|0)+5552>>0]=1;n=n+4|0}while((n|0)!=(o|0));fg()}n=Da+144|0;q=c[Sa>>2]|0;if((c[n>>2]|0)<(q|0))c[n>>2]=q;do if(!Ca){p=f+5364|0;n=c[p>>2]|0;switch(n|0){case 5:{o=c[f+5348>>2]|0;Qa=c[f+400+((o<<3|6)<<8)>>2]|0;if(((Qa>>3)+-3|0)>>>0<2?((Qa&7)+-3|0)>>>0<2:0){l=31999-q|0;i=Ta;return l|0}Qa=c[f+400+((o<<3^14)<<8)>>2]|0;if(((Qa>>3)+-3|0)>>>0<2?((Qa&7)+-3|0)>>>0<2:0){l=q+-32e3|0;i=Ta;return l|0}if((n|0)==6)Ra=21;break}case 6:{Ra=21;break}default:{}}do if((Ra|0)==21){o=c[f+5348>>2]|0;n=o<<3;if((c[f+400+((n|6)<<8)>>2]&-8|0)==56){if((c[f+400+((n^14)<<8)>>2]&-8|0)==56){l=c[1082292+(o<<2)>>2]|0;i=Ta;return l|0}if((c[f+400+((o<<3^14)<<8)>>2]>>3|0)<7){l=31999-q|0;i=Ta;return l|0}}if(!(Ad(f)|0)){n=c[p>>2]|0;break}l=(c[Sa>>2]|0)+-32e3|0;i=Ta;return l|0}while(0);switch(n|0){case 7:{n=c[f+5348>>2]|0;o=c[Ha>>2]|0;if((c[o+36+(n<<2)>>2]|0)==3){l=31999-(c[Sa>>2]|0)|0;i=Ta;return l|0}if((c[o+36+((n^1)<<2)>>2]|0)==3){l=(c[Sa>>2]|0)+-32e3|0;i=Ta;return l|0}break}case 4:{if(!(c[f+336+(((c[f+360>>2]|0)!=0&1)<<3<<2)>>2]|0)){l=(c[Sa>>2]|0)+-32e3|0;i=Ta;return l|0}break}case 1:{n=c[f+5348>>2]<<3;if(!(c[f+336+(n<<2)>>2]|0)){l=31999-(c[Sa>>2]|0)|0;i=Ta;return l|0}if(!(c[f+336+((n^8)<<2)>>2]|0)){l=(c[Sa>>2]|0)+-32e3|0;i=Ta;return l|0}break}case 2:{if(!(c[f+336+((c[f+5348>>2]<<3|6)<<2)>>2]|0)){l=(c[Sa>>2]|0)+-32e3|0;i=Ta;return l|0}break}default:{}}if(((a[1217488]&1)==0?!(Xf(f)|0):0)?(r=c[Sa>>2]|0,(r|0)<=127):0){n=r+-32e3|0;j=(n|0)<(j|0)?j:n;n=31999-r|0;n=(n|0)>(k|0)?k:n;if((j|0)<(n|0)){Oa=n;break}i=Ta;return j|0}if(Ma|(c[Sa>>2]|0)<128){l=c[1082292+(c[f+5348>>2]<<2)>>2]|0;i=Ta;return l|0}else{l=Fd(f)|0;i=Ta;return l|0}}else Oa=k;while(0);pa=g+40|0;c[g+56>>2]=0;qa=g+12|0;c[qa>>2]=0;ra=g+4|0;c[ra>>2]=0;c[g+104>>2]=0;c[g+100>>2]=0;ta=g+-28|0;wa=c[ta>>2]&63;sa=g+16|0;ua=c[sa>>2]|0;Qa=(c[Ha>>2]|0)+56|0;Pa=c[Qa>>2]^ua;Qa=c[Qa+4>>2]^((ua|0)<0)<<31>>31;v=$g(1148256,Pa,Qa,w)|0;n=(a[w>>0]|0)==0;do if(!n?(s=b[v+4>>1]|0,t=s<<16>>16,u=c[Sa>>2]|0,s<<16>>16!=32002):0)if(s<<16>>16>31743){u=t-u|0;break}else{u=(s<<16>>16<-31743?u:0)+t|0;break}else u=32002;while(0);if(!Ca)if(n)t=0;else t=e[v+2>>1]|0;else t=c[c[(c[Da+5532>>2]|0)+((c[Da+140>>2]|0)*20|0)+8>>2]>>2]|0;a:do if(!Ma){do if(!n){va=b[v+6>>1]|0;n=va<<16>>16;o=g+28|0;c[o>>2]=n;if(va<<16>>16==32002){n=Fd(f)|0;c[o>>2]=n}if((u|0)!=32002)n=(d[v+8>>0]&((u|0)>(n|0)?2:1)|0)==0?n:u}else{if((c[ta>>2]|0)==65)n=(c[7772+(c[f+5364>>2]<<2)>>2]<<1)-(c[g+-12>>2]|0)|0;else n=Fd(f)|0;c[g+28>>2]=n;p=a[1148268]|0;q=Yu(Pa|0,Qa|0,48)|0;if((C|0)==0?(q|0)==(e[v>>1]|0):0){o=v+9|0;if(((a[o>>0]|0)+-4|0)>=-6)break}else{b[v+2>>1]=0;o=v+9|0}b[v>>1]=q;b[v+4>>1]=32002;b[v+6>>1]=n;a[v+8>>0]=p;a[o>>0]=-6}while(0);s=f+5364|0;if((c[s>>2]|0)==1){o=c[(c[Ha>>2]|0)+48>>2]|0;if((o|0)!=64){p=f+256|0;oa=p;oa=Jf(f,o,c[oa>>2]|0,c[oa+4>>2]|0)|0;o=c[f+5348>>2]|0;r=f+320+(o<<3)|0;q=c[r>>2]|0;r=c[r+4>>2]|0;va=f+264|0;if(!((q&oa&c[va>>2]|0)==0?(r&C&c[va+4>>2]|0)==0:0))break}else{o=c[f+5348>>2]|0;r=f+320+(o<<3)|0;p=f+256|0;q=c[r>>2]|0;r=c[r+4>>2]|0}k=f+320+((o^1)<<3)|0;o=r;while(1){if((q|0)==0&(o|0)==0)break;va=hb(q|0,o|0,0)|0;r=Xu(q|0,o|0,-1,-1)|0;o=C&o;oa=p;oa=ac(c[f+(va<<2)>>2]|0,va,c[oa>>2]|0,c[oa+4>>2]|0)|0;va=k;if(!((c[va>>2]&oa|0)==0?(c[va+4>>2]&C|0)==0:0))break a;else q=r&q}if(m)break}else if(m)break;if(((l|0)<7&(Ca^1)?((n|0)<1e4?(n-(_(c[7804+(c[s>>2]<<2)>>2]|0,l)|0)|0)>=(Oa|0):0):0)?c[(c[Ha>>2]|0)+16+(c[f+5348>>2]<<2)>>2]|0:0){l=n;i=Ta;return l|0}if(!((l|0)<6|(t|0)!=0)){eg(f,g,j,Oa,((l*3|0)/4|0)+-2|0,1)|0;n=$g(1148256,Pa,Qa,w)|0;if(!(a[w>>0]|0)){t=0;v=n}else{t=e[n+2>>1]|0;v=n}}}else c[g+28>>2]=32002;while(0);la=c[g+-36>>2]|0;oa=g+-76|0;ma=c[oa>>2]|0;na=c[g+-156>>2]|0;ff(Ea,f,t,l,g);va=g+28|0;n=c[g+-52>>2]|0;n=(n|0)==32002?1:(c[va>>2]|0)>=(n|0);if((!Ca?!((ua|0)!=0|(u|0)!=32002&((l|0)>7&(t|0)!=0)^1):0)?(x=b[v+8>>1]|0,(x&2)!=0):0)aa=(((x&65535)>>>8&65535)<<24>>24|0)>=(l+-3|0);else aa=0;k=kf(Ea)|0;b:do if(k){ba=Da+5532|0;ca=Da+140|0;da=Da+5536|0;ea=f+5360|0;fa=za+8|0;ga=za+1|0;ha=za+4|0;ia=f+5364|0;ja=f+5348|0;ka=(l|0)<16;Z=n&1;$=1082540+(Z<<6)+(l<<2)|0;I=u-(l<<1)|0;I=(I|0)<-32e3?-32e3:I;J=(l|0)/2|0;K=I+-1|0;L=l+-1|0;M=(l|0)>2;N=(l|0)>63?63:l;O=(la|0)==0;P=(ma|0)==0;Q=(na|0)==0;R=g+-8|0;S=0-Oa|0;T=Da+4241336|0;H=Ca^1;U=(l|0)>6;V=_(l,-248)|0;W=(la|0)!=0;X=(ma|0)!=0;Y=W&X;G=0;s=-32001;E=0;o=0;u=-32001;c:while(1){d:do if((k|0)==(ua|0)){p=G;n=E;q=u}else{do if(Ca){n=(c[ba>>2]|0)+((c[ca>>2]|0)*20|0)|0;q=c[da>>2]|0;if((n|0)==(q|0)){p=G;n=E;q=u;break d}else{p=n;n=0}do{n=((c[c[p+8>>2]>>2]|0)==(k|0)&1)+n|0;p=p+20|0}while((p|0)!=(q|0));if(!n){p=G;n=E;q=u;break d}n=E+1|0;c[Aa>>2]=n;p=c[287054]|0;if((c[287055]|0)==(p|0)){Ra=101;break c}if((Da|0)==(c[p>>2]|0)){if(!(c[245967]|0)){F=dl()|0;F=fv(F|0,C|0,1e6,0)|0;p=983984;p=Vu(F|0,C|0,c[p>>2]|0,c[p+4>>2]|0)|0}else p=Rg(1148216)|0;if((p|0)<=3e3)break;B=Ud(tm(Ud(oe(1149064,0)|0,16337,11)|0,l)|0,16349,10)|0;hh(za,k,(a[ea>>0]|0)!=0);F=a[za>>0]|0;D=(F&1)==0;F=Ud(Ud(B,D?ga:c[fa>>2]|0,D?(F&255)>>>1:c[ha>>2]|0)|0,16360,16)|0;F=um(F,(c[ca>>2]|0)+n|0)|0;c[ya>>2]=gm(F+(c[(c[F>>2]|0)+-12>>2]|0)|0)|0;D=Om(ya,1150100)|0;D=Lb[c[(c[D>>2]|0)+28>>2]&63](D,10)|0;_t(ya);ym(F,D)|0;lm(F)|0;oe(F,1)|0;vk(za)}}else{n=E+1|0;c[Aa>>2]=n}while(0);c[pa>>2]=0;r=c[ia>>2]|0;z=(k&131072|0)==0;e:do if((r|0)==6){F=z?k>>>6&63:64;p=k&63;if((c[f+(F<<2)>>2]&7|0)==6?p>>>3>>>0>=F>>>3>>>0:0){F=1;break}F=(c[f+(p<<2)>>2]|0)!=0}else{p=z?k&49152:131072;f:do if((p|0)>=49152)if((p|0)<131072)switch(p|0){case 49152:{F=0;break e}default:break f}else switch(p|0){case 131072:{F=0;break e}default:break f}else{switch(p|0){case 0:break;default:break f}F=(c[f+((k&63)<<2)>>2]|0)!=0;break e}while(0);F=1}while(0);if(z){p=c[f+((k>>>6&63)<<2)>>2]|0;if(!(k&49152)){B=c[ja>>2]|0;q=c[Ha>>2]|0;D=q+344+((B^1)<<3)|0;B=f+320+(B<<3)|0;if((c[B>>2]&c[D>>2]|0?1:(c[B+4>>2]&c[D+4>>2]|0)!=0)|(r+-1|0)>>>0<2){q=1;Ra=119}else{r=q+376+((p&7)<<3)|0;D=26112+((k&63)<<3)|0;y=1;q=c[D>>2]&c[r>>2];r=c[D+4>>2]&c[r+4>>2]}}else{q=0;Ra=119}}else{p=k>>>18&15;q=0;Ra=119}if((Ra|0)==119){Ra=0;y=q;q=(Lf(f,k)|0)&1;r=0}B=(q|0)!=0|(r|0)!=0;if(ka)x=(n|0)>=(c[$>>2]|0);else x=0;if(x|B^1)q=0;else q=(Uf(f,k,0)|0)&1;do if(aa){if((k|0)!=(t|0)|(q|0)!=0){w=q;q=u;break}if(!(Kf(f,t)|0)){w=0;q=u;break}c[sa>>2]=t;q=gg(f,g,K,I,J,0,1)|0;c[sa>>2]=0;w=(q|0)<(I|0)&1}else{w=q;q=u}while(0);A=L+w|0;m=c[ia>>2]|0;u=(m|0)==6;if((p&7|0)==6&u){if((k>>>3&7)>>>0<=(z?k>>>9&7:8)>>>0&((s|0)>-31744&H))Ra=131}else if((s|0)>-31744&H)Ra=131;g:do if((Ra|0)==131){Ra=0;h:do if(!(F|B)){if(z)r=c[f+((k>>>6&63)<<2)>>2]|0;else r=k>>>18&15;r=r&7;do if(u){if((r|0)!=6)break;if((k&2048)>>>0>1536|z^1)break h}else{if((r|0)!=1)break;if(((c[ja>>2]|0)*7^(z?k>>>9&7:8)|0)>3)break h}while(0);if(x){p=G;break d}r=A-(c[1115436+(Z<<14)+(N<<8)+(((n|0)>63?63:n)<<2)>>2]|0)|0;r=(r|0)<0?0:r;do if((r|0)<3){if(W?(c[la+(p<<8)+((k&63)<<2)>>2]|0)>=0:0)break;if(X?(c[ma+(p<<8)+((k&63)<<2)>>2]|0)>=0:0)break;if(Q){p=G;break d}if(Y|(c[na+(p<<8)+((k&63)<<2)>>2]|0)<0){p=G;break d}}while(0);if(!(Ma|(r|0)>6)?((r*200|0)+256+(c[va>>2]|0)|0)<=(j|0):0){p=G;break d}if((m|0)==1)break g;if(!((r|0)<8&(m|0)!=6))break g;if(Uf(f,k,_(_(r,-35)|0,r)|0)|0)break g;else{p=G;break d}}while(0);if(U|(w|0)!=0)break;if(!(Uf(f,k,V)|0)){p=G;break d}}while(0);do if(!Ca){if(Kf(f,k)|0)break;c[Aa>>2]=E;p=G;n=E;break d}while(0);c[qa>>2]=k;w=k&63;c[ra>>2]=Da+47028+(p<<18)+(w<<12);Nf(f,k,Ga,B);D=(E|0)>0;do if(M&D&(x|F^1)){q=c[1115436+(Z<<14)+(N<<8)+(((n|0)>63?63:n)<<2)>>2]|0;if(F)p=q-((q|0)!=0&1)|0;else{if(y){m=Uf(f,(z?k>>>6&63:64)+(w<<6)|0,0)|0;m=m?q:q+-2|0}else m=q;if(O)q=0;else q=c[la+(p<<8)+(w<<2)>>2]|0;if(P)r=0;else r=c[ma+(p<<8)+(w<<2)>>2]|0;if(Q)u=0;else u=c[na+(p<<8)+(w<<2)>>2]|0;p=q+(c[Da+5556+(p<<8)+(w<<2)>>2]|0)+r+u+(c[Da+13748+((c[ja>>2]^1)*16640|0)+((z?k>>>6&63:64)<<8)+(w<<2)>>2]|0)|0;q=p+-8e3|0;c[Ba>>2]=q;do if((p|0)>8e3)p=m+(c[R>>2]>>31)|0;else{if((p|0)>=8e3){p=m;break}p=((c[R>>2]|0)>0&1)+m|0}while(0);p=p-((q|0)/2e4|0)|0;p=(p|0)>0?p:0}z=A-p|0;z=(z|0)<1?1:z;r=~j;p=0-j|0;q=0-(gg(f,pa,r,p,z,1,0)|0)|0;if((j|0)<(q|0)&(z|0)!=(A|0)){q=r;Ra=178}}else{if(!D)break;q=~j;p=0-j|0;Ra=178}while(0);do if((Ra|0)==178){Ra=0;if((A|0)>=1){q=0-(gg(f,pa,q,p,A,1,0)|0)|0;break}if(B){q=0-(jg(f,pa,q,p,0)|0)|0;break}else{q=0-(ig(f,pa,q,p,0)|0)|0;break}}while(0);r=(E|0)==0;if(!r?!((q|0)>(j|0)&(Ca|(q|0)<(Oa|0))):0)x=q;else Ra=185;do if((Ra|0)==185){Ra=0;c[pa>>2]=Fa;c[Fa>>2]=0;p=0-j|0;if((A|0)>=1){x=0-(eg(f,pa,S,p,A,0)|0)|0;break}if(B){x=0-(kg(f,pa,S,p,0)|0)|0;break}else{x=0-(lg(f,pa,S,p,0)|0)|0;break}}while(0);Pf(f,k);if(a[1217488]&1){xa=0;break b}do if(Ca){p=c[ba>>2]|0;q=c[da>>2]|0;i:do if((p|0)!=(q|0))while(1){if((c[c[p+8>>2]>>2]|0)==(k|0))break i;p=p+20|0;if((p|0)==(q|0)){p=q;break}}while(0);if(!(r|(x|0)>(j|0))){c[p>>2]=-32001;break}c[p>>2]=x;m=p+8|0;w=p+12|0;u=c[w>>2]|0;r=c[m>>2]|0;q=u-r>>2;do if(!q)mg(m,1);else{if(q>>>0<=1)break;q=r+4|0;if((u|0)==(q|0))break;c[w>>2]=u+(~((u+-4-q|0)>>>2)<<2)}while(0);r=c[pa>>2]|0;q=c[r>>2]|0;if(q|0){u=p+16|0;do{p=c[w>>2]|0;if((p|0)==(c[u>>2]|0))ng(m,r);else{c[p>>2]=q;c[w>>2]=p+4}r=r+4|0;q=c[r>>2]|0}while((q|0)!=0)}if(!D)break;p=c[287054]|0;if((c[287055]|0)==(p|0)){Ra=210;break c}if((Da|0)!=(c[p>>2]|0))break;h[T>>3]=+h[T>>3]+1.0}while(0);do if((x|0)>(s|0)){if((x|0)<=(j|0)){p=G;s=x;break}p=c[287054]|0;if((c[287055]|0)==(p|0)){Ra=217;break c}do if((Da|0)==(c[p>>2]|0)){G=(c[Ha>>2]|0)+56|0;E=983920;G=((c[E>>2]|0)==(c[G>>2]|0)?(c[E+4>>2]|0)==(c[G+4>>2]|0):0)?c[245984]|0:0;if(!((G|0)!=0&(D|(k|0)!=(G|0))))break;c[245978]=0;c[245980]=0;c[245981]=0;c[245982]=0;c[245983]=0;c[245984]=0}while(0);if(!Ca){p=c[g>>2]|0;q=c[pa>>2]|0;c[p>>2]=k;p=p+4|0;do if(q){r=c[q>>2]|0;if(!r)break;do{q=q+4|0;c[p>>2]=r;p=p+4|0;r=c[q>>2]|0}while((r|0)!=0)}while(0);c[p>>2]=0}if((x|0)<(Oa|0)){j=x;p=k;s=x}else{s=x;Ra=229;break c}}else p=G;while(0);if(F){q=x;break}if(!((o|0)<64&(k|0)!=(p|0))){q=x;break}c[Ia+(o<<2)>>2]=k;o=o+1|0;q=x}while(0);k=kf(Ea)|0;if(!k){k=p;Ra=229;break}else{G=p;E=n;u=q}}if((Ra|0)==101)gt(1148216);else if((Ra|0)==210)gt(1148216);else if((Ra|0)==217)gt(1148216);else if((Ra|0)==229){if(!n){Ra=230;break}if(!k){if((l|0)<3){r=0;j=s;Ra=304;break}if(c[(c[Ha>>2]|0)+72>>2]|0){r=0;j=s;Ra=304;break}Ra=c[ta>>2]|0;if((((Ra&131072|0)==0?Ra>>>6&63:64)|0)==(Ra&63|0)){r=k;j=s;Ra=304;break}q=c[f+(wa<<2)>>2]|0;o=_(l+2|0,l)|0;r=o+-2|0;p=c[g+-196>>2]|0;n=c[g+-116>>2]|0;j=c[oa>>2]|0;if(j|0?(Ja=(r|0)>-1?r:2-o|0,(Ja|0)<=323):0){Ra=j+(q<<8)+(wa<<2)|0;f=c[Ra>>2]|0;c[Ra>>2]=f+(r<<5)+((_(f,Ja)|0)/-936|0)}do if(n|0){j=(r|0)>-1?r:2-o|0;if((j|0)>323)break;Ra=n+(q<<8)+(wa<<2)|0;f=c[Ra>>2]|0;c[Ra>>2]=f+(r<<5)+((_(f,j)|0)/-936|0)}while(0);if(!p){r=k;j=s;Ra=304;break}j=(r|0)>-1?r:2-o|0;if((j|0)>323){r=k;j=s;Ra=304;break}Ra=p+(q<<8)+(wa<<2)|0;f=c[Ra>>2]|0;c[Ra>>2]=f+(r<<5)+((_(f,j)|0)/-936|0);r=k;j=s;Ra=304;break}j=(k&131072|0)==0;j:do if((c[f+5364>>2]|0)==6){Na=j?k>>>6&63:64;j=k&63;if((c[f+(Na<<2)>>2]&7|0)==6?j>>>3>>>0>=Na>>>3>>>0:0)break;if(!(c[f+(j<<2)>>2]|0))Ra=280}else{j=j?k&49152:131072;if((j|0)<49152){switch(j|0){case 0:break;default:break j}if(!(c[f+((k&63)<<2)>>2]|0)){Ra=280;break}else break}if((j|0)<131072)switch(j|0){case 49152:{Ra=280;break j}default:break j}else switch(j|0){case 131072:{Ra=280;break j}default:break j}}while(0);if((Ra|0)==280)hg(f,g,k,Ia,o,(_(l+2|0,l)|0)+-2|0);if((c[g+-4>>2]|0)!=1){r=k;j=s;Ra=304;break}if(c[(c[Ha>>2]|0)+72>>2]|0){r=k;j=s;Ra=304;break}q=c[f+(wa<<2)>>2]|0;o=_(l+4|0,l)|0;r=~o;p=c[g+-196>>2]|0;n=c[g+-116>>2]|0;j=c[oa>>2]|0;if(j|0?(Ka=(o|0)<0?r:o+1|0,(Ka|0)<=323):0){Ra=j+(q<<8)+(wa<<2)|0;f=c[Ra>>2]|0;c[Ra>>2]=f+(r<<5)+((_(f,Ka)|0)/-936|0)}if(n|0?(La=(o|0)<0?r:o+1|0,(La|0)<=323):0){Ra=n+(q<<8)+(wa<<2)|0;f=c[Ra>>2]|0;c[Ra>>2]=f+(r<<5)+((_(f,La)|0)/-936|0)}if(!p){r=k;j=s;Ra=304;break}j=(o|0)<0?r:o+1|0;if((j|0)>323){r=k;j=s;Ra=304;break}Ra=p+(q<<8)+(wa<<2)|0;f=c[Ra>>2]|0;c[Ra>>2]=f+(r<<5)+((_(f,j)|0)/-936|0);r=k;j=s;Ra=304;break}}else{k=0;Ra=230}while(0);k:do if((Ra|0)==230){r=f+5364|0;o=c[r>>2]|0;l:do if((o|0)==6){q=f+5348|0;g=c[q>>2]<<3;if(!((c[f+400+((g|6)<<8)>>2]&-8|0)==56?(c[f+400+((g^14)<<8)>>2]&-8|0)==56:0))Ra=233;m:do if((Ra|0)==233?!(Ad(f)|0):0){p=c[q>>2]|0;o=c[r>>2]|0;switch(o|0){case 4:{n=p<<3|6;if(!(c[f+336+(n<<2)>>2]|0)){Ra=261;break l}else Ra=239;break}case 2:{n=p<<3|6;if(c[f+336+(n<<2)>>2]|0)Ra=239;break}case 1:if(!ua){Ra=268;break l}else{r=k;Ra=304;break k}default:{n=p<<3|6;Ra=239}}n:do if((Ra|0)==239){if((c[f+400+(n<<8)>>2]&-8|0)!=56){Ra=260;break l}n=p^1;switch(o|0){case 4:{n=n<<3|6;if(!(c[f+336+(n<<2)>>2]|0)){Ra=261;break l}break}case 2:{n=n<<3|6;if(!(c[f+336+(n<<2)>>2]|0))break n;break}default:n=n<<3|6}if((c[f+400+(n<<8)>>2]>>3|0)<7)break m;else{Ra=260;break l}}while(0);if(!ua)break l;else{r=k;Ra=304;break k}}while(0);if(ua|0){r=k;Ra=304;break k}o=c[q>>2]|0;n=c[r>>2]|0;switch(n|0){case 4:{j=o<<3|6;if(c[f+336+(j<<2)>>2]|0){Na=j;Ra=250}break}case 2:{j=o<<3|6;if(c[f+336+(j<<2)>>2]|0){Na=j;Ra=250}break}case 1:break;default:{Na=o<<3|6;Ra=250}}o:do if((Ra|0)==250?(c[f+400+(Na<<8)>>2]&-8|0)==56:0){j=o^1;switch(n|0){case 4:{j=j<<3|6;if(!(c[f+336+(j<<2)>>2]|0))break o;break}case 2:{j=j<<3|6;if(!(c[f+336+(j<<2)>>2]|0))break o;break}default:j=j<<3|6}if((c[f+400+(j<<8)>>2]&-8|0)==56){r=k;j=c[1082292+(o<<2)>>2]|0;Ra=304;break k}}while(0);Ra=Ad(f)|0;j=c[Sa>>2]|0;if(Ra){r=k;j=j+-32e3|0;Ra=304;break k}else{r=k;j=31999-j|0;Ra=304;break k}}else Ra=260;while(0);do if((Ra|0)==260)if((o|0)!=4){n=(ua|0)!=0;if((o|0)==1)if(n){r=k;Ra=304;break k}else{Ra=268;break}else if(n){r=k;Ra=304;break k}else break}else Ra=261;while(0);if((Ra|0)==268){r=k;j=31999-(c[Sa>>2]|0)|0;Ra=304;break}do if((Ra|0)==261){n=(ua|0)==0;if(c[f+336+(((c[f+360>>2]|0)!=0&1)<<3<<2)>>2]|0)if(n)break;else{r=k;Ra=304;break k}if(!n){r=k;Ra=304;break k}r=k;j=(c[Sa>>2]|0)+-32e3|0;Ra=304;break k}while(0);if(Ma){r=k;j=(c[Sa>>2]|0)+-32e3|0;Ra=304;break}else{r=k;j=c[1082292+(c[f+5348>>2]<<2)>>2]|0;Ra=304;break}}while(0);do if((Ra|0)==304){n=c[Sa>>2]|0;if((j|0)>31743)u=n+j|0;else u=j-((j|0)<-31743?n:0)|0;t=(j|0)<(Oa|0)?(r|0?3:1):2;k=c[va>>2]|0;s=a[1148268]|0;if(!r){p=Yu(Pa|0,Qa|0,48)|0;o=C;n=b[v>>1]|0;if((p|0)==(n&65535|0)&(o|0)==0){q=v;r=n}else{q=v;Ra=310}}else{n=b[v>>1]|0;p=Yu(Pa|0,Qa|0,48)|0;q=v;o=C;Ra=310}if((Ra|0)==310){b[v+2>>1]=r;r=n}n=v+9|0;if((p|0)==(r&65535|0)&(o|0)==0?!((t|0)==3?1:((a[n>>0]|0)+-4|0)<(l|0)):0){xa=j;break}b[q>>1]=p;b[v+4>>1]=u;b[v+6>>1]=k;a[v+8>>0]=s&255|t;a[n>>0]=l;xa=j}while(0);l=xa;i=Ta;return l|0}function fg(){var b=0,d=0,e=0,f=0,g=0,h=0,i=0;if((a[983952]|0)==0?Ca(983952)|0:0){e=dl()|0;e=fv(e|0,C|0,1e6,0)|0;f=983960;c[f>>2]=e;c[f+4>>2]=C;Ja(983952)}if(!(c[245967]|0)){e=dl()|0;e=fv(e|0,C|0,1e6,0)|0;f=983984;f=Vu(e|0,C|0,c[f>>2]|0,c[f+4>>2]|0)|0}else f=Rg(1148216)|0;b=983904;b=Xu(f|0,((f|0)<0)<<31>>31|0,c[b>>2]|0,c[b+4>>2]|0)|0;d=C;e=983960;e=Vu(b|0,d|0,c[e>>2]|0,c[e+4>>2]|0)|0;h=C;if((h|0)>0|(h|0)==0&e>>>0>999){h=983960;c[h>>2]=b;c[h+4>>2]=d;ne()}if(c[245973]|0)return;b=c[245970]|0;i=b|c[245971]|c[245969];e=983896;d=c[e>>2]|0;e=c[e+4>>2]|0;h=c[245972]|0;if(!(((i|d|h|0)==0?(((i|0)<0)<<31>>31|e|((h|0)<0)<<31>>31|0)==0:0)?(f|0)>((c[245999]|0)+-10|0):0))g=12;if((g|0)==12?(b|0)==0|(f|0)<(b|0):0){if((d|0)==0&(e|0)==0)return;h=Rg(1148216)|0;f=C;i=983896;g=c[i+4>>2]|0;if(f>>>0<g>>>0|((f|0)==(g|0)?h>>>0<(c[i>>2]|0)>>>0:0))return}a[1217488]=1;return}function gg(f,g,h,j,k,l,m){f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;var n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ia=0,ja=0,ka=0,la=0,ma=0,na=0,oa=0,pa=0,qa=0,ra=0,sa=0,ta=0,ua=0,va=0,wa=0,xa=0,ya=0,za=0,Aa=0,Ba=0,Ca=0,Da=0,Ea=0;Ea=i;i=i+4848|0;sa=Ea+4584|0;ra=Ea;x=Ea+4840|0;qa=Ea+440|0;ma=c[f+5352>>2]|0;ta=f+5356|0;xa=(c[ta>>2]|0)+64|0;xa=(c[xa>>2]|0)!=0|(c[xa+4>>2]|0)!=0;na=g+36|0;c[na>>2]=0;pa=g+32|0;c[pa>>2]=0;Da=g+8|0;c[Da>>2]=(c[g+-32>>2]|0)+1;n=ma+5552|0;if(!(a[n>>0]&1)){n=ma+148|0;o=n;n=c[n>>2]|0}else{a[n>>0]=0;o=983896;n=c[o>>2]|0;o=c[o+4>>2]|0;if((n|0)==0&(o|0)==0)n=4096;else{n=fv(n|0,o|0,1024,0)|0;Ba=C;Aa=(Ba|0)<0|(Ba|0)==0&n>>>0<4096;n=Aa?n:4096}o=ma+148|0;c[o>>2]=n}c[o>>2]=n+-1;if((n|0)<2){n=c[287054]|0;o=c[287055]|0;if((n|0)!=(o|0))do{a[(c[n>>2]|0)+5552>>0]=1;n=n+4|0}while((n|0)!=(o|0));fg()}ua=f+5364|0;n=c[ua>>2]|0;switch(n|0){case 5:{o=c[f+5348>>2]|0;Ba=c[f+400+((o<<3|6)<<8)>>2]|0;if(((Ba>>3)+-3|0)>>>0<2?((Ba&7)+-3|0)>>>0<2:0){k=31999-(c[Da>>2]|0)|0;i=Ea;return k|0}Ba=c[f+400+((o<<3^14)<<8)>>2]|0;if(((Ba>>3)+-3|0)>>>0<2?((Ba&7)+-3|0)>>>0<2:0){k=(c[Da>>2]|0)+-32e3|0;i=Ea;return k|0}if((n|0)==6)Ca=18;break}case 6:{Ca=18;break}default:{}}do if((Ca|0)==18){o=c[f+5348>>2]|0;n=o<<3;if((c[f+400+((n|6)<<8)>>2]&-8|0)==56){if((c[f+400+((n^14)<<8)>>2]&-8|0)==56){k=c[1082292+(o<<2)>>2]|0;i=Ea;return k|0}if((c[f+400+((o<<3^14)<<8)>>2]>>3|0)<7){k=31999-(c[Da>>2]|0)|0;i=Ea;return k|0}}if(!(Ad(f)|0)){n=c[ua>>2]|0;break}k=(c[Da>>2]|0)+-32e3|0;i=Ea;return k|0}while(0);switch(n|0){case 7:{n=c[f+5348>>2]|0;o=c[ta>>2]|0;if((c[o+36+(n<<2)>>2]|0)==3){k=31999-(c[Da>>2]|0)|0;i=Ea;return k|0}if((c[o+36+((n^1)<<2)>>2]|0)==3){k=(c[Da>>2]|0)+-32e3|0;i=Ea;return k|0}break}case 4:{if(!(c[f+336+(((c[f+360>>2]|0)!=0&1)<<3<<2)>>2]|0)){k=(c[Da>>2]|0)+-32e3|0;i=Ea;return k|0}break}case 1:{n=c[f+5348>>2]<<3;if(!(c[f+336+(n<<2)>>2]|0)){k=31999-(c[Da>>2]|0)|0;i=Ea;return k|0}if(!(c[f+336+((n^8)<<2)>>2]|0)){k=(c[Da>>2]|0)+-32e3|0;i=Ea;return k|0}break}case 2:{if(!(c[f+336+((c[f+5348>>2]<<3|6)<<2)>>2]|0)){k=(c[Da>>2]|0)+-32e3|0;i=Ea;return k|0}break}default:{}}if(((a[1217488]&1)==0?!(Xf(f)|0):0)?(p=c[Da>>2]|0,(p|0)<=127):0){oa=p+-32e3|0;oa=(oa|0)<(h|0)?h:oa;za=31999-p|0;za=(za|0)>(j|0)?j:za;if((oa|0)>=(za|0)){k=oa;i=Ea;return k|0}fa=g+40|0;c[g+56>>2]=0;ga=g+12|0;c[ga>>2]=0;ha=g+4|0;c[ha>>2]=0;c[g+104>>2]=0;c[g+100>>2]=0;ka=g+-28|0;va=c[ka>>2]&63;ia=g+16|0;ja=c[ia>>2]|0;Ba=(c[ta>>2]|0)+56|0;Aa=c[Ba>>2]^ja;Ba=c[Ba+4>>2]^((ja|0)<0)<<31>>31;v=$g(1148256,Aa,Ba,x)|0;p=(a[x>>0]|0)==0;if(!p){n=b[v+4>>1]|0;o=n<<16>>16;h=c[Da>>2]|0;do if(n<<16>>16!=32002)if(n<<16>>16>31743){r=o-h|0;break}else{r=(n<<16>>16<-31743?h:0)+o|0;break}else r=32002;while(0);n=b[v+2>>1]|0;o=n&65535;if(((r|0)!=32002?(a[v+9>>0]|0)>=(k|0):0)?(q=(r|0)>=(za|0),(d[v+8>>0]&(q?2:1)|0)!=0):0){if(!(q&n<<16>>16!=0)){k=r;i=Ea;return k|0}a:do if((c[ua>>2]|0)==6){Da=o>>>6&63;n=o&63;if((c[f+(Da<<2)>>2]&7|0)==6?n>>>3>>>0>=Da>>>3>>>0:0)break;if(!(c[f+(n<<2)>>2]|0))Ca=60}else{n=o&49152;if((n|0)>=49152)switch(n|0){case 49152:{Ca=60;break a}default:break a}switch(n|0){case 0:break;default:break a}if(!(c[f+((o&63)<<2)>>2]|0))Ca=60}while(0);if((Ca|0)==60)hg(f,g,o,0,0,(_(k+2|0,k)|0)+-2|0);if((c[g+-4>>2]|0)!=1){k=r;i=Ea;return k|0}if(c[(c[ta>>2]|0)+72>>2]|0){k=r;i=Ea;return k|0}q=c[f+(va<<2)>>2]|0;h=_(k+4|0,k)|0;j=~h;p=c[g+-196>>2]|0;o=c[g+-116>>2]|0;n=c[g+-76>>2]|0;if(n|0?(s=(h|0)<0?j:h+1|0,(s|0)<=323):0){k=n+(q<<8)+(va<<2)|0;Da=c[k>>2]|0;c[k>>2]=Da+(j<<5)+((_(Da,s)|0)/-936|0)}if(o|0?(t=(h|0)<0?j:h+1|0,(t|0)<=323):0){k=o+(q<<8)+(va<<2)|0;Da=c[k>>2]|0;c[k>>2]=Da+(j<<5)+((_(Da,t)|0)/-936|0)}if(!p){k=r;i=Ea;return k|0}n=(h|0)<0?j:h+1|0;if((n|0)>323){k=r;i=Ea;return k|0}k=p+(q<<8)+(va<<2)|0;Da=c[k>>2]|0;c[k>>2]=Da+(j<<5)+((_(Da,n)|0)/-936|0);k=r;i=Ea;return k|0}else{w=r;s=o}}else{w=32002;s=0}b:do if(!xa){do if(!p){la=b[v+6>>1]|0;n=la<<16>>16;o=g+28|0;c[o>>2]=n;if(la<<16>>16==32002){n=Fd(f)|0;c[o>>2]=n}if((w|0)==32002)o=n;else o=(d[v+8>>0]&((w|0)>(n|0)?2:1)|0)==0?n:w}else{if((c[ka>>2]|0)==65)o=(c[7772+(c[ua>>2]<<2)>>2]<<1)-(c[g+-12>>2]|0)|0;else o=Fd(f)|0;c[g+28>>2]=o;h=a[1148268]|0;p=Yu(Aa|0,Ba|0,48)|0;if((C|0)==0?(p|0)==(e[v>>1]|0):0){n=v+9|0;if(((a[n>>0]|0)+-4|0)>=-6)break}else{b[v+2>>1]=0;n=v+9|0}b[v>>1]=p;b[v+4>>1]=32002;b[v+6>>1]=o;a[v+8>>0]=h;a[n>>0]=-6}while(0);if((c[ua>>2]|0)==1){n=c[(c[ta>>2]|0)+48>>2]|0;if((n|0)!=64){h=f+256|0;ea=h;ea=Jf(f,n,c[ea>>2]|0,c[ea+4>>2]|0)|0;n=c[f+5348>>2]|0;j=f+320+(n<<3)|0;p=c[j>>2]|0;j=c[j+4>>2]|0;la=f+264|0;if(!((p&ea&c[la>>2]|0)==0?(j&C&c[la+4>>2]|0)==0:0)){ba=s;la=v;break}}else{n=c[f+5348>>2]|0;j=f+320+(n<<3)|0;h=f+256|0;p=c[j>>2]|0;j=c[j+4>>2]|0}q=f+320+((n^1)<<3)|0;n=j;while(1){if((p|0)==0&(n|0)==0)break;la=hb(p|0,n|0,0)|0;j=Xu(p|0,n|0,-1,-1)|0;n=C&n;ea=h;ea=ac(c[f+(la<<2)>>2]|0,la,c[ea>>2]|0,c[ea+4>>2]|0)|0;la=q;if(!((c[la>>2]&ea|0)==0?(c[la+4>>2]&C|0)==0:0)){ba=s;la=v;break b}else p=j&p}if(m){ba=s;la=v;break}}else if(m){ba=s;la=v;break}do if((k|0)<4&(s|0)==0?(u=c[7836+(c[ua>>2]<<4)+(k<<2)>>2]|0,(u+o|0)<=(oa|0)):0)if((k|0)<2){k=ig(f,g,oa,za,0)|0;i=Ea;return k|0}else{la=oa-u|0;n=ig(f,g,la,la+1|0,0)|0;if((n|0)>(la|0))break;i=Ea;return n|0}while(0);n=c[ua>>2]|0;if(((k|0)<7?((o|0)<1e4?(o-(_(c[7804+(n<<2)>>2]|0,k)|0)|0)>=(za|0):0):0)?c[(c[ta>>2]|0)+16+(c[f+5348>>2]<<2)>>2]|0:0){k=o;i=Ea;return k|0}if((n|0)==4)if((k|0)<5){ba=s;la=v;break}else Ca=119;else{do if(((o|0)>=(za|0)?!((k|0)<13?(c[g+28>>2]|0)<((_(k,-35)|0)+210+za|0):0):0)?c[(c[ta>>2]|0)+16+(c[f+5348>>2]<<2)>>2]|0:0){c[ga>>2]=65;c[ha>>2]=0;p=(o-za|0)/188|0;Rf(f,ra);p=(((k*67|0)+823|0)/-256|0)+k-((p|0)>3?3:p)|0;j=(p|0)<1;h=0-za|0;n=1-za|0;if(j)n=ig(f,fa,h,n,0)|0;else n=gg(f,fa,h,n,p,l^1,1)|0;o=0-n|0;Sf(f);if((za|0)>(o|0))break;n=(n|0)<-31743?za:o;do if((k|0)<12){if((((za|0)>-1?za:h)|0)>=1e4)break;i=Ea;return n|0}while(0);o=za+-1|0;if(j)o=ig(f,g,o,za,0)|0;else o=gg(f,g,o,za,p,0,1)|0;if((o|0)<(za|0))break;i=Ea;return n|0}while(0);if(!((k|0)<5|(c[ua>>2]|0)==1))Ca=119}if((Ca|0)==119?(((za|0)>-1?za:0-za|0)|0)<31744:0){h=za+200|0;h=(h|0)>32001?32001:h;p=k+-4|0;hf(qa,f,s,h-(c[g+28>>2]|0)|0);n=kf(qa)|0;c:do if(n|0){j=0-h|0;q=1-h|0;r=l^1;o=n;while(1){if(Kf(f,o)|0){c[ga>>2]=o;if(!(o&131072))n=c[f+((o>>>6&63)<<2)>>2]|0;else n=o>>>18&15;c[ha>>2]=ma+47028+(n<<18)+((o&63)<<12);Nf(f,o,ra,Lf(f,o)|0);n=0-(gg(f,fa,j,q,p,r,0)|0)|0;Pf(f,o);if((h|0)<=(n|0))break}o=kf(qa)|0;if(!o)break c}k=n;i=Ea;return k|0}while(0)}if(!((k|0)<6|(s|0)!=0))if(((c[g+28>>2]|0)+256|0)>=(za|0)){gg(f,g,oa,za,((k*3|0)/4|0)+-2|0,l,1)|0;n=$g(1148256,Aa,Ba,x)|0;if(!(a[x>>0]|0)){ba=0;la=n}else{ba=e[n+2>>1]|0;la=n}}else{ba=0;la=v}else{ba=s;la=v}}else{c[g+28>>2]=32002;ba=s;la=v}while(0);Z=c[g+-36>>2]|0;ca=g+-76|0;$=c[ca>>2]|0;aa=c[g+-156>>2]|0;ff(qa,f,ba,k,g);ea=g+28|0;n=c[g+-52>>2]|0;n=(n|0)==32002?1:(c[ea>>2]|0)>=(n|0);da=(ja|0)!=0;if(!(da|(w|0)!=32002&((k|0)>7&(ba|0)!=0)^1)?(y=b[la+8>>1]|0,(y&2)!=0):0)W=(((y&65535)>>>8&65535)<<24>>24|0)>=(k+-3|0);else W=0;t=kf(qa)|0;d:do if(t){X=f+5348|0;Y=(k|0)<16;U=n&1;V=1082540+(U<<6)+(k<<2)|0;B=w-(k<<1)|0;B=(B|0)<-32e3?-32e3:B;D=(k|0)/2|0;E=B+-1|0;F=k+-1|0;G=(k|0)>6;H=_(k,-248)|0;I=(k|0)>63?63:k;J=(Z|0)!=0;K=($|0)!=0;L=(aa|0)==0;T=J&K;M=(k|0)>2;N=~oa;O=0-oa|0;P=(Z|0)==0;Q=($|0)==0;R=g+-8|0;S=l^1;n=-32001;z=0;h=0;e:while(1){f:do if((t|0)==(ja|0))o=z;else{o=z+1|0;c[na>>2]=o;q=c[ua>>2]|0;A=(t&131072|0)==0;g:do if((q|0)==6){y=A?t>>>6&63:64;p=t&63;if((c[f+(y<<2)>>2]&7|0)==6?p>>>3>>>0>=y>>>3>>>0:0){w=1;break}w=(c[f+(p<<2)>>2]|0)!=0}else{p=A?t&49152:131072;h:do if((p|0)>=49152)if((p|0)<131072)switch(p|0){case 49152:{w=0;break g}default:break h}else switch(p|0){case 131072:{w=0;break g}default:break h}else{switch(p|0){case 0:break;default:break h}w=(c[f+((t&63)<<2)>>2]|0)!=0;break g}while(0);w=1}while(0);if(A){p=c[f+((t>>>6&63)<<2)>>2]|0;if(!(t&49152)){x=c[X>>2]|0;j=c[ta>>2]|0;y=j+344+((x^1)<<3)|0;x=f+320+(x<<3)|0;if((c[x>>2]&c[y>>2]|0?1:(c[x+4>>2]&c[y+4>>2]|0)!=0)|(q+-1|0)>>>0<2){j=1;Ca=152}else{r=j+376+((p&7)<<3)|0;y=26112+((t&63)<<3)|0;j=1;q=c[y>>2]&c[r>>2];r=c[y+4>>2]&c[r+4>>2]}}else{j=0;Ca=152}}else{p=t>>>18&15;j=0;Ca=152}if((Ca|0)==152){Ca=0;q=(Lf(f,t)|0)&1;r=0}y=(q|0)!=0|(r|0)!=0;if(Y)m=(o|0)>=(c[V>>2]|0);else m=0;if(m|y^1)q=0;else q=(Uf(f,t,0)|0)&1;do if(W){if((t|0)!=(ba|0)|(q|0)!=0)break;if(!(Kf(f,ba)|0)){q=0;break}c[ia>>2]=ba;q=gg(f,g,E,B,D,l,1)|0;c[ia>>2]=0;q=(q|0)<(B|0)&1}while(0);x=F+q|0;u=c[ua>>2]|0;s=(u|0)==6;if((p&7|0)==6&s){if((n|0)>-31744?(t>>>3&7)>>>0<=(A?t>>>9&7:8)>>>0:0)Ca=164}else if((n|0)>-31744)Ca=164;i:do if((Ca|0)==164){Ca=0;j:do if(!(w|y)){if(A)r=c[f+((t>>>6&63)<<2)>>2]|0;else r=t>>>18&15;r=r&7;do if(s){if((r|0)!=6)break;if((t&2048)>>>0>1536|A^1)break j}else{if((r|0)!=1)break;if(((c[X>>2]|0)*7^(A?t>>>9&7:8)|0)>3)break j}while(0);if(m)break f;q=x-(c[1082668+(U<<14)+(I<<8)+(((o|0)>63?63:o)<<2)>>2]|0)|0;q=(q|0)<0?0:q;do if((q|0)<3){if(J?(c[Z+(p<<8)+((t&63)<<2)>>2]|0)>=0:0)break;if(K?(c[$+(p<<8)+((t&63)<<2)>>2]|0)>=0:0)break;if(L)break f;if(T|(c[aa+(p<<8)+((t&63)<<2)>>2]|0)<0)break f}while(0);if(!(xa|(q|0)>6)?((q*200|0)+256+(c[ea>>2]|0)|0)<=(oa|0):0)break f;if((u|0)==1)break i;if(!((q|0)<8&(u|0)!=6))break i;if(Uf(f,t,_(_(q,-35)|0,q)|0)|0)break i;else break f}while(0);if(G|(q|0)!=0)break;if(!(Uf(f,t,H)|0))break f}while(0);if(!(Kf(f,t)|0)){c[na>>2]=z;o=z;break}c[ga>>2]=t;u=t&63;c[ha>>2]=ma+47028+(p<<18)+(u<<12);Nf(f,t,ra,y);v=w^1;if(M&(z|0)>0&(m|v)){q=c[1082668+(U<<14)+(I<<8)+(((o|0)>63?63:o)<<2)>>2]|0;if(w)p=q-((q|0)!=0&1)|0;else{do if(l)q=q+2|0;else{if(!j)break;z=Uf(f,(A?t>>>6&63:64)+(u<<6)|0,0)|0;q=z?q:q+-2|0}while(0);if(P)j=0;else j=c[Z+(p<<8)+(u<<2)>>2]|0;if(Q)r=0;else r=c[$+(p<<8)+(u<<2)>>2]|0;if(L)s=0;else s=c[aa+(p<<8)+(u<<2)>>2]|0;p=j+(c[ma+5556+(p<<8)+(u<<2)>>2]|0)+r+s+(c[ma+13748+((c[X>>2]^1)*16640|0)+((A?t>>>6&63:64)<<8)+(u<<2)>>2]|0)|0;j=p+-8e3|0;c[pa>>2]=j;do if((p|0)>8e3)p=q+(c[R>>2]>>31)|0;else{if((p|0)>=8e3){p=q;break}p=((c[R>>2]|0)>0&1)+q|0}while(0);p=p-((j|0)/2e4|0)|0;p=(p|0)>0?p:0}A=x-p|0;A=(A|0)<1?1:A;p=0-(gg(f,fa,N,O,A,1,0)|0)|0;if((oa|0)<(p|0)&(A|0)!=(x|0))Ca=210}else Ca=210;do if((Ca|0)==210){Ca=0;if((x|0)>=1){p=0-(gg(f,fa,N,O,x,S,0)|0)|0;break}if(y){p=0-(jg(f,fa,N,O,0)|0)|0;break}else{p=0-(ig(f,fa,N,O,0)|0)|0;break}}while(0);Pf(f,t);if(a[1217488]&1){n=0;break d}if((p|0)>(n|0))if((p|0)>(oa|0)){n=p;break e}else n=p;if(!((h|0)<64&v))break;c[sa+(h<<2)>>2]=t;h=h+1|0}while(0);t=kf(qa)|0;if(!t){t=0;break}else z=o}if(o){if(!t){if((k|0)<3){q=0;Ca=291;break}if(c[(c[ta>>2]|0)+72>>2]|0){q=0;Ca=291;break}Ca=c[ka>>2]|0;if((((Ca&131072|0)==0?Ca>>>6&63:64)|0)==(Ca&63|0)){q=t;Ca=291;break}r=c[f+(va<<2)>>2]|0;j=_(k+2|0,k)|0;s=j+-2|0;q=c[g+-196>>2]|0;p=c[g+-116>>2]|0;o=c[ca>>2]|0;do if(o|0){h=(s|0)>-1?s:2-j|0;if((h|0)>323)break;Ca=o+(r<<8)+(va<<2)|0;f=c[Ca>>2]|0;c[Ca>>2]=f+(s<<5)+((_(f,h)|0)/-936|0)}while(0);do if(p|0){o=(s|0)>-1?s:2-j|0;if((o|0)>323)break;Ca=p+(r<<8)+(va<<2)|0;f=c[Ca>>2]|0;c[Ca>>2]=f+(s<<5)+((_(f,o)|0)/-936|0)}while(0);if(!q){q=t;Ca=291;break}o=(s|0)>-1?s:2-j|0;if((o|0)>323){q=t;Ca=291;break}q=q+(r<<8)+(va<<2)|0;Ca=c[q>>2]|0;c[q>>2]=Ca+(s<<5)+((_(Ca,o)|0)/-936|0);q=t;Ca=291;break}o=(t&131072|0)==0;k:do if((c[ua>>2]|0)==6){ya=o?t>>>6&63:64;o=t&63;if((c[f+(ya<<2)>>2]&7|0)==6?o>>>3>>>0>=ya>>>3>>>0:0)break;if(!(c[f+(o<<2)>>2]|0))Ca=267}else{o=o?t&49152:131072;if((o|0)<49152){switch(o|0){case 0:break;default:break k}if(!(c[f+((t&63)<<2)>>2]|0)){Ca=267;break}else break}if((o|0)<131072)switch(o|0){case 49152:{Ca=267;break k}default:break k}else switch(o|0){case 131072:{Ca=267;break k}default:break k}}while(0);if((Ca|0)==267)hg(f,g,t,sa,h,(_(k+2|0,k)|0)+-2|0);if((c[g+-4>>2]|0)==1?(c[(c[ta>>2]|0)+72>>2]|0)==0:0){q=c[f+(va<<2)>>2]|0;p=_(k+4|0,k)|0;r=~p;j=c[g+-196>>2]|0;h=c[g+-116>>2]|0;o=c[ca>>2]|0;if(o|0?(wa=(p|0)<0?r:p+1|0,(wa|0)<=323):0){Ca=o+(q<<8)+(va<<2)|0;f=c[Ca>>2]|0;c[Ca>>2]=f+(r<<5)+((_(f,wa)|0)/-936|0)}do if(h|0){o=(p|0)<0?r:p+1|0;if((o|0)>323)break;Ca=h+(q<<8)+(va<<2)|0;f=c[Ca>>2]|0;c[Ca>>2]=f+(r<<5)+((_(f,o)|0)/-936|0)}while(0);if(j){o=(p|0)<0?r:p+1|0;if((o|0)>323){q=t;Ca=291;break}q=j+(q<<8)+(va<<2)|0;Ca=c[q>>2]|0;c[q>>2]=Ca+(r<<5)+((_(Ca,o)|0)/-936|0);q=t;Ca=291}else{q=t;Ca=291}}else{q=t;Ca=291}}else{q=t;Ca=221}}else{q=0;Ca=221}while(0);l:do if((Ca|0)==221){n=c[ua>>2]|0;m:do if((n|0)==6){p=f+5348|0;g=c[p>>2]<<3;if(!((c[f+400+((g|6)<<8)>>2]&-8|0)==56?(c[f+400+((g^14)<<8)>>2]&-8|0)==56:0))Ca=224;if((Ca|0)==224?!(Ad(f)|0):0){h=c[p>>2]|0;n=c[ua>>2]|0;switch(n|0){case 1:{Ca=254;break m}case 4:{o=h<<3|6;if(!(c[f+336+(o<<2)>>2]|0)){Ca=251;break m}break}case 2:{o=h<<3|6;if(!(c[f+336+(o<<2)>>2]|0))break m;break}default:o=h<<3|6}if((c[f+400+(o<<8)>>2]&-8|0)!=56){Ca=250;break}o=h^1;switch(n|0){case 4:{o=o<<3|6;if(!(c[f+336+(o<<2)>>2]|0)){Ca=251;break m}break}case 2:{o=o<<3|6;if(!(c[f+336+(o<<2)>>2]|0))break m;break}default:o=o<<3|6}if((c[f+400+(o<<8)>>2]>>3|0)>=7){Ca=250;break}}if(da){n=oa;Ca=291;break l}h=c[p>>2]|0;o=c[ua>>2]|0;switch(o|0){case 4:{n=h<<3|6;if(c[f+336+(n<<2)>>2]|0){ya=n;Ca=240}break}case 2:{n=h<<3|6;if(c[f+336+(n<<2)>>2]|0){ya=n;Ca=240}break}case 1:break;default:{ya=h<<3|6;Ca=240}}n:do if((Ca|0)==240?(c[f+400+(ya<<8)>>2]&-8|0)==56:0){n=h^1;switch(o|0){case 4:{n=n<<3|6;if(!(c[f+336+(n<<2)>>2]|0))break n;break}case 2:{n=n<<3|6;if(!(c[f+336+(n<<2)>>2]|0))break n;break}default:n=n<<3|6}if((c[f+400+(n<<8)>>2]&-8|0)==56){n=c[1082292+(h<<2)>>2]|0;Ca=291;break l}}while(0);Ca=Ad(f)|0;n=c[Da>>2]|0;if(Ca){n=n+-32e3|0;Ca=291;break l}else{n=31999-n|0;Ca=291;break l}}else Ca=250;while(0);if((Ca|0)==250)switch(n|0){case 4:{Ca=251;break}case 1:{Ca=254;break}default:{}}if((Ca|0)==254){if(da){n=oa;Ca=291;break}n=31999-(c[Da>>2]|0)|0;Ca=291;break}if((Ca|0)==251?(c[f+336+(((c[f+360>>2]|0)!=0&1)<<3<<2)>>2]|0)==0:0){if(da){n=oa;Ca=291;break}n=(c[Da>>2]|0)+-32e3|0;Ca=291;break}if(!da)if(xa){n=(c[Da>>2]|0)+-32e3|0;Ca=291;break}else{n=c[1082292+(c[f+5348>>2]<<2)>>2]|0;Ca=291;break}else{n=oa;Ca=291}}while(0);do if((Ca|0)==291){o=c[Da>>2]|0;if((n|0)>31743)u=o+n|0;else u=n-((n|0)<-31743?o:0)|0;t=(n|0)>=(za|0)?2:1;r=c[ea>>2]|0;s=a[1148268]|0;if(!q){p=Yu(Aa|0,Ba|0,48)|0;h=C;o=b[la>>1]|0;if((p|0)==(o&65535|0)&(h|0)==0){j=la;q=o}else{j=la;Ca=297}}else{o=b[la>>1]|0;p=Yu(Aa|0,Ba|0,48)|0;j=la;h=C;Ca=297}if((Ca|0)==297){b[la+2>>1]=q;q=o}o=la+9|0;if((p|0)==(q&65535|0)&(h|0)==0?((a[o>>0]|0)+-4|0)>=(k|0):0)break;b[j>>1]=p;b[la+4>>1]=u;b[la+6>>1]=r;a[la+8>>0]=s&255|t;a[o>>0]=k}while(0);k=n;i=Ea;return k|0}if(xa|(c[Da>>2]|0)<128){k=c[1082292+(c[f+5348>>2]<<2)>>2]|0;i=Ea;return k|0}else{k=Fd(f)|0;i=Ea;return k|0}return 0}function hg(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0;h=b+20|0;i=c[h>>2]|0;if((i|0)!=(d|0)){c[b+24>>2]=i;c[h>>2]=d}t=c[a+5348>>2]|0;u=c[a+5352>>2]|0;s=0-g|0;p=(g|0)>-1?g:s;q=(p|0)>323;h=d&131072;if(!q){r=u+13748+(t*16640|0)+(((h|0)==0?d>>>6&63:64)<<8)+((d&63)<<2)|0;o=c[r>>2]|0;c[r>>2]=o+(g<<5)+((_(o,p)|0)/-324|0)}i=(h|0)==0;if(i)h=c[a+((d>>>6&63)<<2)>>2]|0;else h=d>>>18&15;n=d&63;if(!q){r=u+5556+(h<<8)+(n<<2)|0;o=c[r>>2]|0;c[r>>2]=o+(g<<5)+((_(o,p)|0)/-324|0)}if(i)h=c[a+((d>>>6&63)<<2)>>2]|0;else h=d>>>18&15;m=b+-156|0;j=c[m>>2]|0;o=b+-76|0;k=c[o>>2]|0;r=b+-36|0;l=c[r>>2]|0;i=(l|0)==0;if(!(q|i)){l=l+(h<<8)+(n<<2)|0;v=c[l>>2]|0;c[l>>2]=v+(g<<5)+((_(v,p)|0)/-936|0)}if(!(q|(k|0)==0)){v=k+(h<<8)+(n<<2)|0;l=c[v>>2]|0;c[v>>2]=l+(g<<5)+((_(l,p)|0)/-936|0)}if(!(q|(j|0)==0)){v=j+(h<<8)+(n<<2)|0;q=c[v>>2]|0;c[v>>2]=q+(g<<5)+((_(q,p)|0)/-936|0)}if(!i){v=c[b+-28>>2]&63;c[u+9652+(c[a+(v<<2)>>2]<<8)+(v<<2)>>2]=d}if((f|0)<=0)return;b=(g|0)<1?s:g;v=(b|0)>323;d=c[m>>2]|0;g=c[o>>2]|0;r=c[r>>2]|0;o=v|(r|0)==0;p=v|(g|0)==0;q=v|(d|0)==0;n=s<<5;if(v){j=0;do{h=c[e+(j<<2)>>2]|0;if(!(h&131072))i=c[a+((h>>>6&63)<<2)>>2]|0;else i=h>>>18&15;h=h&63;if(!o){v=r+(i<<8)+(h<<2)|0;u=c[v>>2]|0;c[v>>2]=u+n+((_(u,b)|0)/-936|0)}if(!p){v=g+(i<<8)+(h<<2)|0;u=c[v>>2]|0;c[v>>2]=u+n+((_(u,b)|0)/-936|0)}if(!q){v=d+(i<<8)+(h<<2)|0;u=c[v>>2]|0;c[v>>2]=u+n+((_(u,b)|0)/-936|0)}j=j+1|0}while((j|0)!=(f|0));return}else m=0;do{i=c[e+(m<<2)>>2]|0;j=(i&131072|0)==0;k=i>>>6&63;l=i&63;v=u+13748+(t*16640|0)+((j?k:64)<<8)+(l<<2)|0;s=c[v>>2]|0;c[v>>2]=s+n+((_(s,b)|0)/-324|0);if(j)h=c[a+(k<<2)>>2]|0;else h=i>>>18&15;v=u+5556+(h<<8)+(l<<2)|0;s=c[v>>2]|0;c[v>>2]=s+n+((_(s,b)|0)/-324|0);if(j)h=c[a+(k<<2)>>2]|0;else h=i>>>18&15;if(!o){v=r+(h<<8)+(l<<2)|0;s=c[v>>2]|0;c[v>>2]=s+n+((_(s,b)|0)/-936|0)}if(!p){v=g+(h<<8)+(l<<2)|0;s=c[v>>2]|0;c[v>>2]=s+n+((_(s,b)|0)/-936|0)}if(!q){v=d+(h<<8)+(l<<2)|0;s=c[v>>2]|0;c[v>>2]=s+n+((_(s,b)|0)/-936|0)}m=m+1|0}while((m|0)!=(f|0));return}
function zh(a,b){a=a|0;b=b|0;var d=0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0;c[a+16>>2]=0;c[a+20>>2]=0;rk(a+24|0,17301,6);d=a+36|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[d+16>>2]=0;c[a+60>>2]=b;return}function Ah(d,e){d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;m=d+24|0;if(Lk(m,17301)|0?(n=a[e>>0]|0,(((n&1)==0?(n&255)>>>1:c[e+4>>2]|0)|0)==0):0)return d|0;if(((Lk(m,17315)|0)==0?Lk(e,23296)|0:0)?Lk(e,23301)|0:0)return d|0;if(!(Lk(m,17423)|0)){f=c[d+44>>2]|0;n=c[d+48>>2]|0;a:do if((f|0)!=(n|0)){j=a[e>>0]|0;k=(j&1)==0;j=k?(j&255)>>>1:c[e+4>>2]|0;k=k?e+1|0:c[e+8>>2]|0;l=(j|0)==0;do{i=b[f>>1]|0;g=(i&1)==0;h=(i&254)>>>1;i=(i&65535)>>>8&255;do if(((g?h:c[f+4>>2]|0)|0)==(j|0)){if(!g)if(!(rj(c[f+8>>2]|0,k,j)|0))break a;else break;if(l)break a;if(i<<24>>24==(a[k>>0]|0)){g=f+1|0;i=k;do{h=h+-1|0;g=g+1|0;if(!h)break a;i=i+1|0}while((a[g>>0]|0)==(a[i>>0]|0))}}while(0);f=f+12|0}while((f|0)!=(n|0));return d|0}while(0);if((f|0)==(n|0))return d|0}if(!(Lk(m,17241)|0)){n=Xk(e,0,10)|0;if((n|0)<(c[d+36>>2]|0))return d|0;n=Xk(e,0,10)|0;if((n|0)>(c[d+40>>2]|0))return d|0}if(Lk(m,17301)|0)wk(d+12|0,e)|0;f=c[d+60>>2]|0;if(!f)return d|0;Bb[f&255](d);return d|0}function Bh(a){a=a|0;var b=0,d=0;b=i;i=i+16|0;d=b;c[d>>2]=c[a+60>>2];a=Ch(mb(6,d|0)|0)|0;i=b;return a|0}function Ch(a){a=a|0;if(a>>>0>4294963200){c[(Dh()|0)>>2]=0-a;a=-1}return a|0}function Dh(){var a=0;if(!(c[287106]|0))a=1148468;else a=c[(Za()|0)+64>>2]|0;return a|0}function Eh(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;q=i;i=i+48|0;n=q+16|0;m=q;e=q+32|0;o=a+28|0;f=c[o>>2]|0;c[e>>2]=f;p=a+20|0;f=(c[p>>2]|0)-f|0;c[e+4>>2]=f;c[e+8>>2]=b;c[e+12>>2]=d;k=a+60|0;l=a+44|0;b=2;f=f+d|0;while(1){if(!(c[287106]|0)){c[n>>2]=c[k>>2];c[n+4>>2]=e;c[n+8>>2]=b;h=Ch(vb(146,n|0)|0)|0}else{Aa(157,a|0);c[m>>2]=c[k>>2];c[m+4>>2]=e;c[m+8>>2]=b;h=Ch(vb(146,m|0)|0)|0;ua(0)}if((f|0)==(h|0)){f=6;break}if((h|0)<0){f=8;break}f=f-h|0;g=c[e+4>>2]|0;if(h>>>0<=g>>>0)if((b|0)==2){c[o>>2]=(c[o>>2]|0)+h;j=g;b=2}else j=g;else{j=c[l>>2]|0;c[o>>2]=j;c[p>>2]=j;j=c[e+12>>2]|0;h=h-g|0;e=e+8|0;b=b+-1|0}c[e>>2]=(c[e>>2]|0)+h;c[e+4>>2]=j-h}if((f|0)==6){n=c[l>>2]|0;c[a+16>>2]=n+(c[a+48>>2]|0);a=n;c[o>>2]=a;c[p>>2]=a}else if((f|0)==8){c[a+16>>2]=0;c[o>>2]=0;c[p>>2]=0;c[a>>2]=c[a>>2]|32;if((b|0)==2)d=0;else d=d-(c[e+4>>2]|0)|0}i=q;return d|0}function Fh(a){a=a|0;if(!(c[a+68>>2]|0))Gh(a);return}function Gh(a){a=a|0;return}function Hh(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;f=i;i=i+32|0;g=f;e=f+20|0;c[g>>2]=c[a+60>>2];c[g+4>>2]=0;c[g+8>>2]=b;c[g+12>>2]=e;c[g+16>>2]=d;if((Ch(rb(140,g|0)|0)|0)<0){c[e>>2]=-1;a=-1}else a=c[e>>2]|0;i=f;return a|0}function Ih(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0;g=i;i=i+80|0;f=g;c[b+36>>2]=5;if((c[b>>2]&64|0)==0?(c[f>>2]=c[b+60>>2],c[f+4>>2]=21505,c[f+8>>2]=g+12,cb(54,f|0)|0):0)a[b+75>>0]=-1;f=Eh(b,d,e)|0;i=g;return f|0}function Jh(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;m=i;i=i+48|0;h=m+16|0;g=m;f=m+32|0;c[f>>2]=d;j=f+4|0;l=b+48|0;n=c[l>>2]|0;c[j>>2]=e-((n|0)!=0&1);k=b+44|0;c[f+8>>2]=c[k>>2];c[f+12>>2]=n;if(!(c[287106]|0)){c[h>>2]=c[b+60>>2];c[h+4>>2]=f;c[h+8>>2]=2;f=Ch(ob(145,h|0)|0)|0}else{Aa(158,b|0);c[g>>2]=c[b+60>>2];c[g+4>>2]=f;c[g+8>>2]=2;f=Ch(ob(145,g|0)|0)|0;ua(0)}if((f|0)>=1){j=c[j>>2]|0;if(f>>>0>j>>>0){g=c[k>>2]|0;h=b+4|0;c[h>>2]=g;c[b+8>>2]=g+(f-j);if(!(c[l>>2]|0))f=e;else{c[h>>2]=g+1;a[d+(e+-1)>>0]=a[g>>0]|0;f=e}}}else{c[b>>2]=c[b>>2]|f&48^16;c[b+8>>2]=0;c[b+4>>2]=0}i=m;return f|0}function Kh(a){a=a|0;if(!(c[a+68>>2]|0))Gh(a);return}function Lh(a,b){a=+a;b=+b;var d=0;h[k>>3]=b;d=c[k+4>>2]|0;b=+N(+a);h[k>>3]=b;d=d&-2147483648|c[k+4>>2];c[k>>2]=c[k>>2];c[k+4>>2]=d;return +(+h[k>>3])}function Mh(b){b=b|0;var d=0,e=0,f=0;f=b;a:do if(!(f&3))e=4;else{d=b;b=f;while(1){if(!(a[d>>0]|0))break a;d=d+1|0;b=d;if(!(b&3)){b=d;e=4;break}}}while(0);if((e|0)==4){while(1){d=c[b>>2]|0;if(!((d&-2139062144^-2139062144)&d+-16843009))b=b+4|0;else break}if((d&255)<<24>>24)do b=b+1|0;while((a[b>>0]|0)!=0)}return b-f|0}function Nh(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0;f=i;i=i+16|0;g=f;c[g>>2]=e;e=Oh(a,b,d,g)|0;i=f;return e|0}function Oh(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0;n=i;i=i+128|0;g=n+112|0;m=n;h=m;j=8544;k=h+112|0;do{c[h>>2]=c[j>>2];h=h+4|0;j=j+4|0}while((h|0)<(k|0));if((d+-1|0)>>>0>2147483646)if(!d){d=1;l=4}else{c[(Dh()|0)>>2]=75;d=-1}else{g=b;l=4}if((l|0)==4){l=-2-g|0;l=d>>>0>l>>>0?l:d;c[m+48>>2]=l;b=m+20|0;c[b>>2]=g;c[m+44>>2]=g;d=g+l|0;g=m+16|0;c[g>>2]=d;c[m+28>>2]=d;d=Qh(m,e,f)|0;if(l){e=c[b>>2]|0;a[e+(((e|0)==(c[g>>2]|0))<<31>>31)>>0]=0}}i=n;return d|0}function Ph(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=a+20|0;f=c[e>>2]|0;a=(c[a+16>>2]|0)-f|0;a=a>>>0>d>>>0?d:a;_u(f|0,b|0,a|0)|0;c[e>>2]=(c[e>>2]|0)+a;return d|0}function Qh(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;s=i;i=i+224|0;o=s+120|0;r=s+80|0;q=s;p=s+136|0;f=r;g=f+40|0;do{c[f>>2]=0;f=f+4|0}while((f|0)<(g|0));c[o>>2]=c[e>>2];if((Rh(0,d,o,q,r)|0)<0)e=-1;else{if((c[b+76>>2]|0)>-1)m=bi(b)|0;else m=0;e=c[b>>2]|0;n=e&32;if((a[b+74>>0]|0)<1)c[b>>2]=e&-33;e=b+48|0;if(!(c[e>>2]|0)){g=b+44|0;h=c[g>>2]|0;c[g>>2]=p;j=b+28|0;c[j>>2]=p;k=b+20|0;c[k>>2]=p;c[e>>2]=80;l=b+16|0;c[l>>2]=p+80;f=Rh(b,d,o,q,r)|0;if(h){yb[c[b+36>>2]&31](b,0,0)|0;f=(c[k>>2]|0)==0?-1:f;c[g>>2]=h;c[e>>2]=0;c[l>>2]=0;c[j>>2]=0;c[k>>2]=0}}else f=Rh(b,d,o,q,r)|0;e=c[b>>2]|0;c[b>>2]=e|n;if(m|0)Gh(b);e=(e&32|0)==0?f:-1}i=s;return e|0}function Rh(e,f,g,j,l){e=e|0;f=f|0;g=g|0;j=j|0;l=l|0;var m=0,n=0,o=0,p=0,q=0.0,r=0,s=0,t=0,u=0,v=0,w=0,x=0.0,y=0,z=0,A=0,B=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ia=0;ia=i;i=i+624|0;da=ia+24|0;fa=ia+16|0;ea=ia+588|0;aa=ia+576|0;ca=ia;W=ia+536|0;ha=ia+8|0;ga=ia+528|0;M=(e|0)!=0;N=W+40|0;V=N;W=W+39|0;X=ha+4|0;Y=ea;Z=0-Y|0;$=aa+12|0;aa=aa+11|0;ba=$;O=ba-Y|0;P=-2-Y|0;Q=ba+2|0;R=da+288|0;S=ea+9|0;T=S;U=ea+8|0;m=0;o=0;n=0;y=f;a:while(1){do if((m|0)>-1)if((o|0)>(2147483647-m|0)){c[(Dh()|0)>>2]=75;m=-1;break}else{m=o+m|0;break}while(0);f=a[y>>0]|0;if(!(f<<24>>24)){L=244;break}else o=y;b:while(1){switch(f<<24>>24){case 37:{f=o;L=9;break b}case 0:{f=o;break b}default:{}}K=o+1|0;f=a[K>>0]|0;o=K}c:do if((L|0)==9)while(1){L=0;if((a[f+1>>0]|0)!=37)break c;o=o+1|0;f=f+2|0;if((a[f>>0]|0)==37)L=9;else break}while(0);w=o-y|0;if(M?(c[e>>2]&32|0)==0:0)Sh(y,w,e)|0;if((o|0)!=(y|0)){o=w;y=f;continue}r=f+1|0;o=a[r>>0]|0;p=(o<<24>>24)+-48|0;if(p>>>0<10){K=(a[f+2>>0]|0)==36;r=K?f+3|0:r;o=a[r>>0]|0;u=K?p:-1;n=K?1:n}else u=-1;f=o<<24>>24;d:do if((f&-32|0)==32){p=0;while(1){if(!(1<<f+-32&75913)){s=p;break d}p=1<<(o<<24>>24)+-32|p;r=r+1|0;o=a[r>>0]|0;f=o<<24>>24;if((f&-32|0)!=32){s=p;break}}}else s=0;while(0);do if(o<<24>>24==42){o=r+1|0;f=(a[o>>0]|0)+-48|0;if(f>>>0<10?(a[r+2>>0]|0)==36:0){c[l+(f<<2)>>2]=10;n=1;r=r+3|0;f=c[j+((a[o>>0]|0)+-48<<3)>>2]|0}else{if(n|0){m=-1;break a}if(!M){v=s;n=0;r=o;K=0;break}n=(c[g>>2]|0)+(4-1)&~(4-1);f=c[n>>2]|0;c[g>>2]=n+4;n=0;r=o}if((f|0)<0){v=s|8192;K=0-f|0}else{v=s;K=f}}else{p=(o<<24>>24)+-48|0;if(p>>>0<10){f=r;o=0;do{o=(o*10|0)+p|0;f=f+1|0;p=(a[f>>0]|0)+-48|0}while(p>>>0<10);if((o|0)<0){m=-1;break a}else{v=s;r=f;K=o}}else{v=s;K=0}}while(0);e:do if((a[r>>0]|0)==46){f=r+1|0;o=a[f>>0]|0;if(o<<24>>24!=42){p=(o<<24>>24)+-48|0;if(p>>>0<10)o=0;else{s=0;break}while(1){o=(o*10|0)+p|0;f=f+1|0;p=(a[f>>0]|0)+-48|0;if(p>>>0>=10){s=o;break e}}}f=r+2|0;o=(a[f>>0]|0)+-48|0;if(o>>>0<10?(a[r+3>>0]|0)==36:0){c[l+(o<<2)>>2]=10;s=c[j+((a[f>>0]|0)+-48<<3)>>2]|0;f=r+4|0;break}if(n|0){m=-1;break a}if(M){J=(c[g>>2]|0)+(4-1)&~(4-1);s=c[J>>2]|0;c[g>>2]=J+4}else s=0}else{s=-1;f=r}while(0);t=0;while(1){o=(a[f>>0]|0)+-65|0;if(o>>>0>57){m=-1;break a}p=f+1|0;o=a[17478+(t*58|0)+o>>0]|0;r=o&255;if((r+-1|0)>>>0<8){f=p;t=r}else{J=p;break}}if(!(o<<24>>24)){m=-1;break}p=(u|0)>-1;do if(o<<24>>24==19)if(p){m=-1;break a}else L=52;else{if(p){c[l+(u<<2)>>2]=r;H=j+(u<<3)|0;I=c[H+4>>2]|0;L=ca;c[L>>2]=c[H>>2];c[L+4>>2]=I;L=52;break}if(!M){m=0;break a}Uh(ca,r,g)}while(0);if((L|0)==52?(L=0,!M):0){o=w;y=J;continue}u=a[f>>0]|0;u=(t|0)!=0&(u&15|0)==3?u&-33:u;p=v&-65537;I=(v&8192|0)==0?v:p;f:do switch(u|0){case 110:switch(t|0){case 0:{c[c[ca>>2]>>2]=m;o=w;y=J;continue a}case 1:{c[c[ca>>2]>>2]=m;o=w;y=J;continue a}case 2:{o=c[ca>>2]|0;c[o>>2]=m;c[o+4>>2]=((m|0)<0)<<31>>31;o=w;y=J;continue a}case 3:{b[c[ca>>2]>>1]=m;o=w;y=J;continue a}case 4:{a[c[ca>>2]>>0]=m;o=w;y=J;continue a}case 6:{c[c[ca>>2]>>2]=m;o=w;y=J;continue a}case 7:{o=c[ca>>2]|0;c[o>>2]=m;c[o+4>>2]=((m|0)<0)<<31>>31;o=w;y=J;continue a}default:{o=w;y=J;continue a}}case 112:{t=I|8;s=s>>>0>8?s:8;u=120;L=64;break}case 88:case 120:{t=I;L=64;break}case 111:{p=ca;o=c[p>>2]|0;p=c[p+4>>2]|0;if((o|0)==0&(p|0)==0)f=N;else{f=N;do{f=f+-1|0;a[f>>0]=o&7|48;o=Yu(o|0,p|0,3)|0;p=C}while(!((o|0)==0&(p|0)==0))}if(!(I&8)){o=I;t=0;r=17958;L=77}else{t=V-f|0;o=I;s=(s|0)>(t|0)?s:t+1|0;t=0;r=17958;L=77}break}case 105:case 100:{o=ca;f=c[o>>2]|0;o=c[o+4>>2]|0;if((o|0)<0){f=Vu(0,0,f|0,o|0)|0;o=C;p=ca;c[p>>2]=f;c[p+4>>2]=o;p=1;r=17958;L=76;break f}if(!(I&2048)){r=I&1;p=r;r=(r|0)==0?17958:17960;L=76}else{p=1;r=17959;L=76}break}case 117:{o=ca;f=c[o>>2]|0;o=c[o+4>>2]|0;p=0;r=17958;L=76;break}case 99:{a[W>>0]=c[ca>>2];f=W;u=1;w=0;v=17958;o=N;break}case 109:{o=Wh(c[(Dh()|0)>>2]|0)|0;L=82;break}case 115:{o=c[ca>>2]|0;o=o|0?o:19860;L=82;break}case 67:{c[ha>>2]=c[ca>>2];c[X>>2]=0;c[ca>>2]=ha;f=ha;s=-1;L=86;break}case 83:{f=c[ca>>2]|0;if(!s){Yh(e,32,K,0,I);f=0;L=97}else L=86;break}case 65:case 71:case 70:case 69:case 97:case 103:case 102:case 101:{q=+h[ca>>3];c[fa>>2]=0;h[k>>3]=q;if((c[k+4>>2]|0)>=0)if(!(I&2048)){H=I&1;G=H;H=(H|0)==0?19868:19873}else{G=1;H=19870}else{q=-q;G=1;H=19867}h[k>>3]=q;F=c[k+4>>2]&2146435072;do if(F>>>0<2146435072|(F|0)==2146435072&0<0){x=+$h(q,fa)*2.0;o=x!=0.0;if(o)c[fa>>2]=(c[fa>>2]|0)+-1;D=u|32;if((D|0)==97){v=u&32;y=(v|0)==0?H:H+9|0;w=G|2;f=12-s|0;do if(!(s>>>0>11|(f|0)==0)){q=8.0;do{f=f+-1|0;q=q*16.0}while((f|0)!=0);if((a[y>>0]|0)==45){q=-(q+(-x-q));break}else{q=x+q-q;break}}else q=x;while(0);o=c[fa>>2]|0;f=(o|0)<0?0-o|0:o;f=Vh(f,((f|0)<0)<<31>>31,$)|0;if((f|0)==($|0)){a[aa>>0]=48;f=aa}a[f+-1>>0]=(o>>31&2)+43;t=f+-2|0;a[t>>0]=u+15;r=(s|0)<1;p=(I&8|0)==0;o=ea;while(1){H=~~q;f=o+1|0;a[o>>0]=d[17942+H>>0]|v;q=(q-+(H|0))*16.0;do if((f-Y|0)==1){if(p&(r&q==0.0))break;a[f>>0]=46;f=o+2|0}while(0);if(!(q!=0.0))break;else o=f}p=t;s=(s|0)!=0&(P+f|0)<(s|0)?Q+s-p|0:O-p+f|0;r=s+w|0;Yh(e,32,K,r,I);if(!(c[e>>2]&32))Sh(y,w,e)|0;Yh(e,48,K,r,I^65536);o=f-Y|0;if(!(c[e>>2]&32))Sh(ea,o,e)|0;f=ba-p|0;Yh(e,48,s-(o+f)|0,0,0);if(!(c[e>>2]&32))Sh(t,f,e)|0;Yh(e,32,K,r,I^8192);f=(r|0)<(K|0)?K:r;break}f=(s|0)<0?6:s;if(o){o=(c[fa>>2]|0)+-28|0;c[fa>>2]=o;q=x*268435456.0}else{q=x;o=c[fa>>2]|0}F=(o|0)<0?da:R;E=F;o=F;do{B=~~q>>>0;c[o>>2]=B;o=o+4|0;q=(q-+(B>>>0))*1.0e9}while(q!=0.0);p=o;o=c[fa>>2]|0;if((o|0)>0){s=F;while(1){t=(o|0)>29?29:o;r=p+-4|0;do if(r>>>0<s>>>0)r=s;else{o=0;do{B=Zu(c[r>>2]|0,0,t|0)|0;B=Xu(B|0,C|0,o|0,0)|0;o=C;A=jv(B|0,o|0,1e9,0)|0;c[r>>2]=A;o=iv(B|0,o|0,1e9,0)|0;r=r+-4|0}while(r>>>0>=s>>>0);if(!o){r=s;break}r=s+-4|0;c[r>>2]=o}while(0);while(1){if(p>>>0<=r>>>0)break;o=p+-4|0;if(!(c[o>>2]|0))p=o;else break}o=(c[fa>>2]|0)-t|0;c[fa>>2]=o;if((o|0)>0)s=r;else break}}else r=F;if((o|0)<0){y=((f+25|0)/9|0)+1|0;z=(D|0)==102;v=r;while(1){w=0-o|0;w=(w|0)>9?9:w;do if(v>>>0<p>>>0){o=(1<<w)+-1|0;s=1e9>>>w;r=0;t=v;do{B=c[t>>2]|0;c[t>>2]=(B>>>w)+r;r=_(B&o,s)|0;t=t+4|0}while(t>>>0<p>>>0);o=(c[v>>2]|0)==0?v+4|0:v;if(!r){r=o;break}c[p>>2]=r;r=o;p=p+4|0}else r=(c[v>>2]|0)==0?v+4|0:v;while(0);o=z?F:r;p=(p-o>>2|0)>(y|0)?o+(y<<2)|0:p;o=(c[fa>>2]|0)+w|0;c[fa>>2]=o;if((o|0)>=0){z=r;break}else v=r}}else z=r;do if(z>>>0<p>>>0){o=(E-z>>2)*9|0;s=c[z>>2]|0;if(s>>>0<10)break;else r=10;do{r=r*10|0;o=o+1|0}while(s>>>0>=r>>>0)}else o=0;while(0);A=(D|0)==103;B=(f|0)!=0;r=f-((D|0)!=102?o:0)+((B&A)<<31>>31)|0;if((r|0)<(((p-E>>2)*9|0)+-9|0)){t=r+9216|0;r=F+4+(((t|0)/9|0)+-1024<<2)|0;t=((t|0)%9|0)+1|0;if((t|0)<9){s=10;do{s=s*10|0;t=t+1|0}while((t|0)!=9)}else s=10;w=c[r>>2]|0;y=(w>>>0)%(s>>>0)|0;t=(r+4|0)==(p|0);do if(t&(y|0)==0)s=z;else{x=(((w>>>0)/(s>>>0)|0)&1|0)==0?9007199254740992.0:9007199254740994.0;v=(s|0)/2|0;if(y>>>0<v>>>0)q=.5;else q=t&(y|0)==(v|0)?1.0:1.5;do if(G){if((a[H>>0]|0)!=45)break;x=-x;q=-q}while(0);t=w-y|0;c[r>>2]=t;if(!(x+q!=x)){s=z;break}D=t+s|0;c[r>>2]=D;if(D>>>0>999999999){o=z;while(1){s=r+-4|0;c[r>>2]=0;if(s>>>0<o>>>0){o=o+-4|0;c[o>>2]=0}D=(c[s>>2]|0)+1|0;c[s>>2]=D;if(D>>>0>999999999)r=s;else{v=o;r=s;break}}}else v=z;o=(E-v>>2)*9|0;t=c[v>>2]|0;if(t>>>0<10){s=v;break}else s=10;do{s=s*10|0;o=o+1|0}while(t>>>0>=s>>>0);s=v}while(0);D=r+4|0;z=s;p=p>>>0>D>>>0?D:p}w=0-o|0;while(1){if(p>>>0<=z>>>0){y=0;D=p;break}r=p+-4|0;if(!(c[r>>2]|0))p=r;else{y=1;D=p;break}}do if(A){f=(B&1^1)+f|0;if((f|0)>(o|0)&(o|0)>-5){u=u+-1|0;f=f+-1-o|0}else{u=u+-2|0;f=f+-1|0}p=I&8;if(p|0)break;do if(y){p=c[D+-4>>2]|0;if(!p){r=9;break}if(!((p>>>0)%10|0)){s=10;r=0}else{r=0;break}do{s=s*10|0;r=r+1|0}while(!((p>>>0)%(s>>>0)|0|0))}else r=9;while(0);p=((D-E>>2)*9|0)+-9|0;if((u|32|0)==102){p=p-r|0;p=(p|0)<0?0:p;f=(f|0)<(p|0)?f:p;p=0;break}else{p=p+o-r|0;p=(p|0)<0?0:p;f=(f|0)<(p|0)?f:p;p=0;break}}else p=I&8;while(0);v=f|p;s=(v|0)!=0&1;t=(u|32|0)==102;if(t){o=(o|0)>0?o:0;u=0}else{r=(o|0)<0?w:o;r=Vh(r,((r|0)<0)<<31>>31,$)|0;if((ba-r|0)<2)do{r=r+-1|0;a[r>>0]=48}while((ba-r|0)<2);a[r+-1>>0]=(o>>31&2)+43;E=r+-2|0;a[E>>0]=u;o=ba-E|0;u=E}w=G+1+f+s+o|0;Yh(e,32,K,w,I);if(!(c[e>>2]&32))Sh(H,G,e)|0;Yh(e,48,K,w,I^65536);do if(t){r=z>>>0>F>>>0?F:z;o=r;do{p=Vh(c[o>>2]|0,0,S)|0;do if((o|0)==(r|0)){if((p|0)!=(S|0))break;a[U>>0]=48;p=U}else{if(p>>>0<=ea>>>0)break;Wu(ea|0,48,p-Y|0)|0;do p=p+-1|0;while(p>>>0>ea>>>0)}while(0);if(!(c[e>>2]&32))Sh(p,T-p|0,e)|0;o=o+4|0}while(o>>>0<=F>>>0);do if(v|0){if(c[e>>2]&32|0)break;Sh(19898,1,e)|0}while(0);if((f|0)>0&o>>>0<D>>>0){p=o;while(1){o=Vh(c[p>>2]|0,0,S)|0;if(o>>>0>ea>>>0){Wu(ea|0,48,o-Y|0)|0;do o=o+-1|0;while(o>>>0>ea>>>0)}if(!(c[e>>2]&32))Sh(o,(f|0)>9?9:f,e)|0;p=p+4|0;o=f+-9|0;if(!((f|0)>9&p>>>0<D>>>0)){f=o;break}else f=o}}Yh(e,48,f+9|0,9,0)}else{t=y?D:z+4|0;if((f|0)>-1){s=(p|0)==0;r=z;do{o=Vh(c[r>>2]|0,0,S)|0;if((o|0)==(S|0)){a[U>>0]=48;o=U}do if((r|0)==(z|0)){p=o+1|0;if(!(c[e>>2]&32))Sh(o,1,e)|0;if(s&(f|0)<1){o=p;break}if(c[e>>2]&32|0){o=p;break}Sh(19898,1,e)|0;o=p}else{if(o>>>0<=ea>>>0)break;Wu(ea|0,48,o+Z|0)|0;do o=o+-1|0;while(o>>>0>ea>>>0)}while(0);p=T-o|0;if(!(c[e>>2]&32))Sh(o,(f|0)>(p|0)?p:f,e)|0;f=f-p|0;r=r+4|0}while(r>>>0<t>>>0&(f|0)>-1)}Yh(e,48,f+18|0,18,0);if(c[e>>2]&32|0)break;Sh(u,ba-u|0,e)|0}while(0);Yh(e,32,K,w,I^8192);f=(w|0)<(K|0)?K:w}else{t=(u&32|0)!=0;s=q!=q|0.0!=0.0;o=s?0:G;r=o+3|0;Yh(e,32,K,r,p);f=c[e>>2]|0;if(!(f&32)){Sh(H,o,e)|0;f=c[e>>2]|0}if(!(f&32))Sh(s?(t?20175:19894):t?19886:19890,3,e)|0;Yh(e,32,K,r,I^8192);f=(r|0)<(K|0)?K:r}while(0);o=f;y=J;continue a}default:{f=y;p=I;u=s;w=0;v=17958;o=N}}while(0);g:do if((L|0)==64){p=ca;o=c[p>>2]|0;p=c[p+4>>2]|0;r=u&32;if(!((o|0)==0&(p|0)==0)){f=N;do{f=f+-1|0;a[f>>0]=d[17942+(o&15)>>0]|r;o=Yu(o|0,p|0,4)|0;p=C}while(!((o|0)==0&(p|0)==0));L=ca;if((t&8|0)==0|(c[L>>2]|0)==0&(c[L+4>>2]|0)==0){o=t;t=0;r=17958;L=77}else{o=t;t=2;r=17958+(u>>4)|0;L=77}}else{f=N;o=t;t=0;r=17958;L=77}}else if((L|0)==76){f=Vh(f,o,N)|0;o=I;t=p;L=77}else if((L|0)==82){L=0;I=Xh(o,0,s)|0;H=(I|0)==0;f=o;u=H?s:I-o|0;w=0;v=17958;o=H?o+s|0:I}else if((L|0)==86){L=0;p=0;o=0;t=f;while(1){r=c[t>>2]|0;if(!r)break;o=Zh(ga,r)|0;if((o|0)<0|o>>>0>(s-p|0)>>>0)break;p=o+p|0;if(s>>>0>p>>>0)t=t+4|0;else break}if((o|0)<0){m=-1;break a}Yh(e,32,K,p,I);if(!p){f=0;L=97}else{r=0;while(1){o=c[f>>2]|0;if(!o){f=p;L=97;break g}o=Zh(ga,o)|0;r=o+r|0;if((r|0)>(p|0)){f=p;L=97;break g}if(!(c[e>>2]&32))Sh(ga,o,e)|0;if(r>>>0>=p>>>0){f=p;L=97;break}else f=f+4|0}}}while(0);if((L|0)==97){L=0;Yh(e,32,K,f,I^8192);o=(K|0)>(f|0)?K:f;y=J;continue}if((L|0)==77){L=0;p=(s|0)>-1?o&-65537:o;o=ca;o=(c[o>>2]|0)!=0|(c[o+4>>2]|0)!=0;if((s|0)!=0|o){u=(o&1^1)+(V-f)|0;u=(s|0)>(u|0)?s:u;w=t;v=r;o=N}else{f=N;u=0;w=t;v=r;o=N}}t=o-f|0;r=(u|0)<(t|0)?t:u;s=w+r|0;o=(K|0)<(s|0)?s:K;Yh(e,32,o,s,p);if(!(c[e>>2]&32))Sh(v,w,e)|0;Yh(e,48,o,s,p^65536);Yh(e,48,r,t,0);if(!(c[e>>2]&32))Sh(f,t,e)|0;Yh(e,32,o,s,p^8192);y=J}h:do if((L|0)==244)if(!e)if(n){m=1;while(1){n=c[l+(m<<2)>>2]|0;if(!n)break;Uh(j+(m<<3)|0,n,g);m=m+1|0;if((m|0)>=10){m=1;break h}}if((m|0)<10)while(1){if(c[l+(m<<2)>>2]|0){m=-1;break h}m=m+1|0;if((m|0)>=10){m=1;break}}else m=1}else m=0;while(0);i=ia;return m|0}function Sh(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0;f=e+16|0;g=c[f>>2]|0;if(!g)if(!(Th(e)|0)){g=c[f>>2]|0;h=5}else f=0;else h=5;a:do if((h|0)==5){i=e+20|0;f=c[i>>2]|0;h=f;if((g-f|0)>>>0<d>>>0){f=yb[c[e+36>>2]&31](e,b,d)|0;break}b:do if((a[e+75>>0]|0)>-1){f=d;while(1){if(!f){g=h;f=0;break b}g=f+-1|0;if((a[b+g>>0]|0)==10)break;else f=g}if((yb[c[e+36>>2]&31](e,b,f)|0)>>>0<f>>>0)break a;d=d-f|0;b=b+f|0;g=c[i>>2]|0}else{g=h;f=0}while(0);_u(g|0,b|0,d|0)|0;c[i>>2]=(c[i>>2]|0)+d;f=f+d|0}while(0);return f|0}function Th(b){b=b|0;var d=0,e=0;d=b+74|0;e=a[d>>0]|0;a[d>>0]=e+255|e;d=c[b>>2]|0;if(!(d&8)){c[b+8>>2]=0;c[b+4>>2]=0;d=c[b+44>>2]|0;c[b+28>>2]=d;c[b+20>>2]=d;c[b+16>>2]=d+(c[b+48>>2]|0);d=0}else{c[b>>2]=d|32;d=-1}return d|0}function Uh(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0.0;a:do if(b>>>0<=20)do switch(b|0){case 9:{e=(c[d>>2]|0)+(4-1)&~(4-1);b=c[e>>2]|0;c[d>>2]=e+4;c[a>>2]=b;break a}case 10:{e=(c[d>>2]|0)+(4-1)&~(4-1);b=c[e>>2]|0;c[d>>2]=e+4;e=a;c[e>>2]=b;c[e+4>>2]=((b|0)<0)<<31>>31;break a}case 11:{e=(c[d>>2]|0)+(4-1)&~(4-1);b=c[e>>2]|0;c[d>>2]=e+4;e=a;c[e>>2]=b;c[e+4>>2]=0;break a}case 12:{e=(c[d>>2]|0)+(8-1)&~(8-1);b=e;f=c[b>>2]|0;b=c[b+4>>2]|0;c[d>>2]=e+8;e=a;c[e>>2]=f;c[e+4>>2]=b;break a}case 13:{f=(c[d>>2]|0)+(4-1)&~(4-1);e=c[f>>2]|0;c[d>>2]=f+4;e=(e&65535)<<16>>16;f=a;c[f>>2]=e;c[f+4>>2]=((e|0)<0)<<31>>31;break a}case 14:{f=(c[d>>2]|0)+(4-1)&~(4-1);e=c[f>>2]|0;c[d>>2]=f+4;f=a;c[f>>2]=e&65535;c[f+4>>2]=0;break a}case 15:{f=(c[d>>2]|0)+(4-1)&~(4-1);e=c[f>>2]|0;c[d>>2]=f+4;e=(e&255)<<24>>24;f=a;c[f>>2]=e;c[f+4>>2]=((e|0)<0)<<31>>31;break a}case 16:{f=(c[d>>2]|0)+(4-1)&~(4-1);e=c[f>>2]|0;c[d>>2]=f+4;f=a;c[f>>2]=e&255;c[f+4>>2]=0;break a}case 17:{f=(c[d>>2]|0)+(8-1)&~(8-1);g=+h[f>>3];c[d>>2]=f+8;h[a>>3]=g;break a}case 18:{f=(c[d>>2]|0)+(8-1)&~(8-1);g=+h[f>>3];c[d>>2]=f+8;h[a>>3]=g;break a}default:break a}while(0);while(0);return}function Vh(b,c,d){b=b|0;c=c|0;d=d|0;var e=0;if(c>>>0>0|(c|0)==0&b>>>0>4294967295)while(1){e=jv(b|0,c|0,10,0)|0;d=d+-1|0;a[d>>0]=e|48;e=iv(b|0,c|0,10,0)|0;if(c>>>0>9|(c|0)==9&b>>>0>4294967295){b=e;c=C}else{b=e;break}}if(b)while(1){d=d+-1|0;a[d>>0]=(b>>>0)%10|0|48;if(b>>>0<10)break;else b=(b>>>0)/10|0}return d|0}function Wh(b){b=b|0;var c=0,e=0;c=0;while(1){if((d[17968+c>>0]|0)==(b|0)){e=2;break}c=c+1|0;if((c|0)==87){c=87;b=18056;e=5;break}}if((e|0)==2)if(!c)b=18056;else{b=18056;e=5}if((e|0)==5)while(1){e=b;while(1){b=e+1|0;if(!(a[e>>0]|0))break;else e=b}c=c+-1|0;if(!c)break;else e=5}return b|0}function Xh(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0;h=d&255;f=(e|0)!=0;a:do if(f&(b&3|0)!=0){g=d&255;while(1){if((a[b>>0]|0)==g<<24>>24){i=6;break a}b=b+1|0;e=e+-1|0;f=(e|0)!=0;if(!(f&(b&3|0)!=0)){i=5;break}}}else i=5;while(0);if((i|0)==5)if(f)i=6;else e=0;b:do if((i|0)==6){g=d&255;if((a[b>>0]|0)!=g<<24>>24){f=_(h,16843009)|0;c:do if(e>>>0>3)while(1){h=c[b>>2]^f;if((h&-2139062144^-2139062144)&h+-16843009|0)break;b=b+4|0;e=e+-4|0;if(e>>>0<=3){i=11;break c}}else i=11;while(0);if((i|0)==11)if(!e){e=0;break}while(1){if((a[b>>0]|0)==g<<24>>24)break b;b=b+1|0;e=e+-1|0;if(!e){e=0;break}}}}while(0);return (e|0?b:0)|0}function Yh(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0;j=i;i=i+256|0;h=j;do if((d|0)>(e|0)&(f&73728|0)==0){f=d-e|0;Wu(h|0,b|0,(f>>>0>256?256:f)|0)|0;b=c[a>>2]|0;g=(b&32|0)==0;if(f>>>0>255){e=d-e|0;do{if(g){Sh(h,256,a)|0;b=c[a>>2]|0}f=f+-256|0;g=(b&32|0)==0}while(f>>>0>255);if(g)f=e&255;else break}else if(!g)break;Sh(h,f,a)|0}while(0);i=j;return}function Zh(a,b){a=a|0;b=b|0;if(!a)a=0;else a=_h(a,b,0)|0;return a|0}function _h(b,d,e){b=b|0;d=d|0;e=e|0;do if(b){if(d>>>0<128){a[b>>0]=d;b=1;break}if(d>>>0<2048){a[b>>0]=d>>>6|192;a[b+1>>0]=d&63|128;b=2;break}if(d>>>0<55296|(d&-8192|0)==57344){a[b>>0]=d>>>12|224;a[b+1>>0]=d>>>6&63|128;a[b+2>>0]=d&63|128;b=3;break}if((d+-65536|0)>>>0<1048576){a[b>>0]=d>>>18|240;a[b+1>>0]=d>>>12&63|128;a[b+2>>0]=d>>>6&63|128;a[b+3>>0]=d&63|128;b=4;break}else{c[(Dh()|0)>>2]=84;b=-1;break}}else b=1;while(0);return b|0}function $h(a,b){a=+a;b=b|0;return +(+ai(a,b))}function ai(a,b){a=+a;b=b|0;var d=0,e=0,f=0;h[k>>3]=a;d=c[k>>2]|0;e=c[k+4>>2]|0;f=Yu(d|0,e|0,52)|0;f=f&2047;switch(f|0){case 0:{if(a!=0.0){a=+ai(a*18446744073709551616.0,b);d=(c[b>>2]|0)+-64|0}else d=0;c[b>>2]=d;break}case 2047:break;default:{c[b>>2]=f+-1022;c[k>>2]=d;c[k+4>>2]=e&-2146435073|1071644672;a=+h[k>>3]}}return +a}function bi(a){a=a|0;return 0}function ci(b,c){b=b|0;c=c|0;b=di(b,c)|0;return ((a[b>>0]|0)==(c&255)<<24>>24?b:0)|0}function di(b,d){b=b|0;d=d|0;var e=0,f=0,g=0;f=d&255;a:do if(!f)b=b+(Mh(b)|0)|0;else{if(b&3){e=d&255;do{g=a[b>>0]|0;if(g<<24>>24==0?1:g<<24>>24==e<<24>>24)break a;b=b+1|0}while((b&3|0)!=0)}f=_(f,16843009)|0;e=c[b>>2]|0;b:do if(!((e&-2139062144^-2139062144)&e+-16843009))do{g=e^f;if((g&-2139062144^-2139062144)&g+-16843009|0)break b;b=b+4|0;e=c[b>>2]|0}while(!((e&-2139062144^-2139062144)&e+-16843009|0));while(0);e=d&255;while(1){g=a[b>>0]|0;if(g<<24>>24==0?1:g<<24>>24==e<<24>>24)break;else b=b+1|0}}while(0);return b|0}function ei(b,e,f){b=b|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0;k=i;i=i+16|0;g=k;a:do if(!e)g=0;else{do if(f|0){j=(b|0)==0?g:b;g=a[e>>0]|0;b=g&255;if(g<<24>>24>-1){c[j>>2]=b;g=g<<24>>24!=0&1;break a}g=b+-194|0;if(g>>>0<=50){b=e+1|0;h=c[8340+(g<<2)>>2]|0;if(f>>>0<4?h&-2147483648>>>((f*6|0)+-6|0)|0:0)break;g=d[b>>0]|0;f=g>>>3;if((f+-16|f+(h>>26))>>>0<=7){g=g+-128|h<<6;if((g|0)>=0){c[j>>2]=g;g=2;break a}b=d[e+2>>0]|0;if((b&192|0)==128){b=b+-128|g<<6;if((b|0)>=0){c[j>>2]=b;g=3;break a}g=d[e+3>>0]|0;if((g&192|0)==128){c[j>>2]=g+-128|b<<6;g=4;break a}}}}}while(0);c[(Dh()|0)>>2]=84;g=-1}while(0);i=k;return g|0}function fi(b,c){b=b|0;c=c|0;var d=0,e=0;e=a[b>>0]|0;d=a[c>>0]|0;if(e<<24>>24==0?1:e<<24>>24!=d<<24>>24)c=e;else{do{b=b+1|0;c=c+1|0;e=a[b>>0]|0;d=a[c>>0]|0}while(!(e<<24>>24==0?1:e<<24>>24!=d<<24>>24));c=e}return (c&255)-(d&255)|0}function gi(a){a=a|0;var b=0;b=a;while(1)if(!(c[b>>2]|0))break;else b=b+4|0;return b-a>>2|0}function hi(a,b,c){a=a|0;b=b|0;c=c|0;a=ii(a,b,c,-2147483648,0)|0;return a|0}function ii(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0;k=i;i=i+112|0;j=k;c[j>>2]=0;g=j+4|0;c[g>>2]=a;c[j+44>>2]=a;h=j+8|0;c[h>>2]=(a|0)<0?-1:a+2147483647|0;c[j+76>>2]=-1;ji(j,0);e=ki(j,d,1,e,f)|0;if(b|0)c[b>>2]=a+((c[g>>2]|0)+(c[j+108>>2]|0)-(c[h>>2]|0));i=k;return e|0}function ji(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;c[a+104>>2]=b;d=c[a+8>>2]|0;e=c[a+4>>2]|0;f=d-e|0;c[a+108>>2]=f;if((b|0)!=0&(f|0)>(b|0))c[a+100>>2]=e+b;else c[a+100>>2]=d;return}function ki(b,e,f,g,h){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;a:do if(e>>>0>36){c[(Dh()|0)>>2]=22;h=0;g=0}else{r=b+4|0;q=b+100|0;do{i=c[r>>2]|0;if(i>>>0<(c[q>>2]|0)>>>0){c[r>>2]=i+1;i=d[i>>0]|0}else i=li(b)|0}while((oi(i)|0)!=0);b:do switch(i|0){case 43:case 45:{j=((i|0)==45)<<31>>31;i=c[r>>2]|0;if(i>>>0<(c[q>>2]|0)>>>0){c[r>>2]=i+1;i=d[i>>0]|0;p=j;break b}else{i=li(b)|0;p=j;break b}}default:p=0}while(0);j=(e|0)==0;do if((e|16|0)==16&(i|0)==48){i=c[r>>2]|0;if(i>>>0<(c[q>>2]|0)>>>0){c[r>>2]=i+1;i=d[i>>0]|0}else i=li(b)|0;if((i|32|0)!=120)if(j){e=8;n=46;break}else{n=32;break}e=c[r>>2]|0;if(e>>>0<(c[q>>2]|0)>>>0){c[r>>2]=e+1;i=d[e>>0]|0}else i=li(b)|0;if((d[19901+i>>0]|0)>15){g=(c[q>>2]|0)==0;if(!g)c[r>>2]=(c[r>>2]|0)+-1;if(!f){ji(b,0);h=0;g=0;break a}if(g){h=0;g=0;break a}c[r>>2]=(c[r>>2]|0)+-1;h=0;g=0;break a}else{e=16;n=46}}else{e=j?10:e;if((d[19901+i>>0]|0)>>>0<e>>>0)n=32;else{if(c[q>>2]|0)c[r>>2]=(c[r>>2]|0)+-1;ji(b,0);c[(Dh()|0)>>2]=22;h=0;g=0;break a}}while(0);if((n|0)==32)if((e|0)==10){e=i+-48|0;if(e>>>0<10){i=0;while(1){j=(i*10|0)+e|0;e=c[r>>2]|0;if(e>>>0<(c[q>>2]|0)>>>0){c[r>>2]=e+1;i=d[e>>0]|0}else i=li(b)|0;e=i+-48|0;if(!(e>>>0<10&j>>>0<429496729)){e=j;break}else i=j}j=0}else{e=0;j=0}f=i+-48|0;if(f>>>0<10){while(1){k=hv(e|0,j|0,10,0)|0;l=C;m=((f|0)<0)<<31>>31;o=~m;if(l>>>0>o>>>0|(l|0)==(o|0)&k>>>0>~f>>>0){k=e;break}e=Xu(k|0,l|0,f|0,m|0)|0;j=C;i=c[r>>2]|0;if(i>>>0<(c[q>>2]|0)>>>0){c[r>>2]=i+1;i=d[i>>0]|0}else i=li(b)|0;f=i+-48|0;if(!(f>>>0<10&(j>>>0<429496729|(j|0)==429496729&e>>>0<2576980378))){k=e;break}}if(f>>>0>9){i=k;e=p}else{e=10;n=72}}else{i=e;e=p}}else n=46;c:do if((n|0)==46){if(!(e+-1&e)){n=a[20157+((e*23|0)>>>5&7)>>0]|0;j=a[19901+i>>0]|0;f=j&255;if(f>>>0<e>>>0){i=0;while(1){k=f|i<<n;i=c[r>>2]|0;if(i>>>0<(c[q>>2]|0)>>>0){c[r>>2]=i+1;i=d[i>>0]|0}else i=li(b)|0;j=a[19901+i>>0]|0;f=j&255;if(!(k>>>0<134217728&f>>>0<e>>>0))break;else i=k}f=0}else{f=0;k=0}l=Yu(-1,-1,n|0)|0;m=C;if((j&255)>>>0>=e>>>0|(f>>>0>m>>>0|(f|0)==(m|0)&k>>>0>l>>>0)){j=f;n=72;break}else i=f;while(1){k=Zu(k|0,i|0,n|0)|0;f=C;k=j&255|k;i=c[r>>2]|0;if(i>>>0<(c[q>>2]|0)>>>0){c[r>>2]=i+1;i=d[i>>0]|0}else i=li(b)|0;j=a[19901+i>>0]|0;if((j&255)>>>0>=e>>>0|(f>>>0>m>>>0|(f|0)==(m|0)&k>>>0>l>>>0)){j=f;n=72;break c}else i=f}}j=a[19901+i>>0]|0;f=j&255;if(f>>>0<e>>>0){i=0;while(1){k=f+(_(i,e)|0)|0;i=c[r>>2]|0;if(i>>>0<(c[q>>2]|0)>>>0){c[r>>2]=i+1;i=d[i>>0]|0}else i=li(b)|0;j=a[19901+i>>0]|0;f=j&255;if(!(k>>>0<119304647&f>>>0<e>>>0))break;else i=k}f=0}else{k=0;f=0}if((j&255)>>>0<e>>>0){n=iv(-1,-1,e|0,0)|0;o=C;m=f;while(1){if(m>>>0>o>>>0|(m|0)==(o|0)&k>>>0>n>>>0){j=m;n=72;break c}f=hv(k|0,m|0,e|0,0)|0;l=C;j=j&255;if(l>>>0>4294967295|(l|0)==-1&f>>>0>~j>>>0){j=m;n=72;break c}k=Xu(j|0,0,f|0,l|0)|0;f=C;i=c[r>>2]|0;if(i>>>0<(c[q>>2]|0)>>>0){c[r>>2]=i+1;i=d[i>>0]|0}else i=li(b)|0;j=a[19901+i>>0]|0;if((j&255)>>>0>=e>>>0){j=f;n=72;break}else m=f}}else{j=f;n=72}}while(0);if((n|0)==72)if((d[19901+i>>0]|0)>>>0<e>>>0){do{i=c[r>>2]|0;if(i>>>0<(c[q>>2]|0)>>>0){c[r>>2]=i+1;i=d[i>>0]|0}else i=li(b)|0}while((d[19901+i>>0]|0)>>>0<e>>>0);c[(Dh()|0)>>2]=34;j=h;i=g;e=(g&1|0)==0&0==0?p:0}else{i=k;e=p}if(c[q>>2]|0)c[r>>2]=(c[r>>2]|0)+-1;if(!(j>>>0<h>>>0|(j|0)==(h|0)&i>>>0<g>>>0)){if(!((g&1|0)!=0|0!=0|(e|0)!=0)){c[(Dh()|0)>>2]=34;g=Xu(g|0,h|0,-1,-1)|0;h=C;break}if(j>>>0>h>>>0|(j|0)==(h|0)&i>>>0>g>>>0){c[(Dh()|0)>>2]=34;break}}g=((e|0)<0)<<31>>31;g=Vu(i^e|0,j^g|0,e|0,g|0)|0;h=C}while(0);C=h;return g|0}function li(b){b=b|0;var e=0,f=0,g=0,h=0,i=0,j=0;f=b+104|0;i=c[f>>2]|0;if((i|0)!=0?(c[b+108>>2]|0)>=(i|0):0)j=4;else{e=mi(b)|0;if((e|0)>=0){f=c[f>>2]|0;i=c[b+8>>2]|0;if(f){h=c[b+4>>2]|0;f=f-(c[b+108>>2]|0)|0;g=i;if((i-h|0)<(f|0))j=9;else c[b+100>>2]=h+(f+-1)}else{g=i;j=9}if((j|0)==9)c[b+100>>2]=i;f=b+4|0;if(!g)f=c[f>>2]|0;else{f=c[f>>2]|0;b=b+108|0;c[b>>2]=g+1-f+(c[b>>2]|0)}f=f+-1|0;if((d[f>>0]|0|0)!=(e|0))a[f>>0]=e}else j=4}if((j|0)==4){c[b+100>>2]=0;e=-1}return e|0}function mi(a){a=a|0;var b=0,e=0;e=i;i=i+16|0;b=e;if((c[a+8>>2]|0)==0?(ni(a)|0)!=0:0)b=-1;else if((yb[c[a+32>>2]&31](a,b,1)|0)==1)b=d[b>>0]|0;else b=-1;i=e;return b|0}function ni(b){b=b|0;var d=0,e=0;d=b+74|0;e=a[d>>0]|0;a[d>>0]=e+255|e;d=b+20|0;e=b+44|0;if((c[d>>2]|0)>>>0>(c[e>>2]|0)>>>0)yb[c[b+36>>2]&31](b,0,0)|0;c[b+16>>2]=0;c[b+28>>2]=0;c[d>>2]=0;d=c[b>>2]|0;if(d&20)if(!(d&4))d=-1;else{c[b>>2]=d|32;d=-1}else{d=c[e>>2]|0;c[b+8>>2]=d;c[b+4>>2]=d;d=0}return d|0}function oi(a){a=a|0;return ((a|0)==32|(a+-9|0)>>>0<5)&1|0}function pi(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0;l=i;i=i+16|0;g=l;j=(f|0)==0?1148472:f;f=c[j>>2]|0;a:do if(!d)if(!f)f=0;else k=15;else{h=(b|0)==0?g:b;if(!e)f=-2;else{if(!f){f=a[d>>0]|0;g=f&255;if(f<<24>>24>-1){c[h>>2]=g;f=f<<24>>24!=0&1;break}f=g+-194|0;if(f>>>0>50){k=15;break}f=c[8340+(f<<2)>>2]|0;g=e+-1|0;if(g){d=d+1|0;k=9}}else{g=e;k=9}b:do if((k|0)==9){b=a[d>>0]|0;m=(b&255)>>>3;if((m+-16|m+(f>>26))>>>0>7){k=15;break a}while(1){d=d+1|0;f=(b&255)+-128|f<<6;g=g+-1|0;if((f|0)>=0)break;if(!g)break b;b=a[d>>0]|0;if((b&-64)<<24>>24!=-128){k=15;break a}}c[j>>2]=0;c[h>>2]=f;f=e-g|0;break a}while(0);c[j>>2]=f;f=-2}}while(0);if((k|0)==15){c[j>>2]=0;c[(Dh()|0)>>2]=84;f=-1}i=l;return f|0}function qi(a){a=a|0;if(!a)a=1;else a=(c[a>>2]|0)==0;return a&1|0}function ri(e,f,j){e=e|0;f=f|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0.0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0;P=i;i=i+304|0;H=P+16|0;J=P+8|0;I=P+33|0;K=P;y=P+32|0;if((c[e+76>>2]|0)>-1)O=bi(e)|0;else O=0;k=a[f>>0]|0;a:do if(k<<24>>24){L=e+4|0;M=e+100|0;G=e+108|0;z=e+8|0;A=I+10|0;B=I+33|0;D=J+4|0;E=I+46|0;F=I+94|0;m=k;k=0;n=f;s=0;l=0;f=0;b:while(1){c:do if(!(oi(m&255)|0)){m=(a[n>>0]|0)==37;d:do if(m){q=n+1|0;o=a[q>>0]|0;e:do switch(o<<24>>24){case 37:break d;case 42:{x=0;o=n+2|0;break}default:{o=(o&255)+-48|0;if(o>>>0<10?(a[n+2>>0]|0)==36:0){c[H>>2]=c[j>>2];while(1){x=(c[H>>2]|0)+(4-1)&~(4-1);m=c[x>>2]|0;c[H>>2]=x+4;if(o>>>0>1)o=o+-1|0;else break}x=m;o=n+3|0;break e}o=(c[j>>2]|0)+(4-1)&~(4-1);x=c[o>>2]|0;c[j>>2]=o+4;o=q}}while(0);m=a[o>>0]|0;n=m&255;if((n+-48|0)>>>0<10){m=0;while(1){q=(m*10|0)+-48+n|0;o=o+1|0;m=a[o>>0]|0;n=m&255;if((n+-48|0)>>>0>=10)break;else m=q}}else q=0;if(m<<24>>24==109){o=o+1|0;r=a[o>>0]|0;m=(x|0)!=0&1;l=0;f=0}else{r=m;m=0}n=o+1|0;switch(r&255|0){case 104:{w=(a[n>>0]|0)==104;n=w?o+2|0:n;o=w?-2:-1;break}case 108:{w=(a[n>>0]|0)==108;n=w?o+2|0:n;o=w?3:1;break}case 106:{o=3;break}case 116:case 122:{o=1;break}case 76:{o=2;break}case 110:case 112:case 67:case 83:case 91:case 99:case 115:case 88:case 71:case 70:case 69:case 65:case 103:case 102:case 101:case 97:case 120:case 117:case 111:case 105:case 100:{n=o;o=0;break}default:{N=154;break b}}r=d[n>>0]|0;t=(r&47|0)==3;r=t?r|32:r;t=t?1:o;switch(r|0){case 99:{w=s;v=(q|0)<1?1:q;break}case 91:{w=s;v=q;break}case 110:{if(!x){o=s;break c}switch(t|0){case -2:{a[x>>0]=s;o=s;break c}case -1:{b[x>>1]=s;o=s;break c}case 0:{c[x>>2]=s;o=s;break c}case 1:{c[x>>2]=s;o=s;break c}case 3:{o=x;c[o>>2]=s;c[o+4>>2]=((s|0)<0)<<31>>31;o=s;break c}default:{o=s;break c}}}default:{ji(e,0);do{o=c[L>>2]|0;if(o>>>0<(c[M>>2]|0)>>>0){c[L>>2]=o+1;o=d[o>>0]|0}else o=li(e)|0}while((oi(o)|0)!=0);if(!(c[M>>2]|0))o=c[L>>2]|0;else{o=(c[L>>2]|0)+-1|0;c[L>>2]=o}w=(c[G>>2]|0)+s+o-(c[z>>2]|0)|0;v=q}}ji(e,v);o=c[L>>2]|0;q=c[M>>2]|0;if(o>>>0<q>>>0)c[L>>2]=o+1;else{if((li(e)|0)<0){N=154;break b}q=c[M>>2]|0}if(q|0)c[L>>2]=(c[L>>2]|0)+-1;f:do switch(r|0){case 91:case 99:case 115:{u=(r|0)==99;g:do if((r|16|0)==115){Wu(I|0,-1,257)|0;a[I>>0]=0;if((r|0)==115){a[B>>0]=0;a[A>>0]=0;a[A+1>>0]=0;a[A+2>>0]=0;a[A+3>>0]=0;a[A+4>>0]=0}}else{r=n+1|0;s=(a[r>>0]|0)==94;o=s&1;n=s?n+2|0:r;Wu(I|0,s&1|0,257)|0;a[I>>0]=0;switch(a[n>>0]|0){case 45:{s=(o^1)&255;a[E>>0]=s;n=n+1|0;break}case 93:{s=(o^1)&255;a[F>>0]=s;n=n+1|0;break}default:s=(o^1)&255}while(1){o=a[n>>0]|0;h:do switch(o<<24>>24){case 0:{N=154;break b}case 93:break g;case 45:{r=n+1|0;o=a[r>>0]|0;switch(o<<24>>24){case 93:case 0:{o=45;break h}default:{}}n=a[n+-1>>0]|0;if((n&255)<(o&255)){n=n&255;do{n=n+1|0;a[I+n>>0]=s;o=a[r>>0]|0}while((n|0)<(o&255|0));n=r}else n=r;break}default:{}}while(0);a[I+((o&255)+1)>>0]=s;n=n+1|0}}while(0);r=u?v+1|0:31;s=(t|0)==1;t=(m|0)!=0;i:do if(s){if(t){f=zj(r<<2)|0;if(!f){l=0;N=154;break b}}else f=x;c[J>>2]=0;c[D>>2]=0;l=0;j:while(1){q=(f|0)==0;do{k:while(1){o=c[L>>2]|0;if(o>>>0<(c[M>>2]|0)>>>0){c[L>>2]=o+1;o=d[o>>0]|0}else o=li(e)|0;if(!(a[I+(o+1)>>0]|0))break j;a[y>>0]=o;switch(pi(K,y,1,J)|0){case -1:{l=0;N=154;break b}case -2:break;default:break k}}if(!q){c[f+(l<<2)>>2]=c[K>>2];l=l+1|0}}while(!(t&(l|0)==(r|0)));l=r<<1|1;o=Cj(f,l<<2)|0;if(!o){l=0;N=154;break b}else{q=r;r=l;f=o;l=q}}if(!(qi(J)|0)){l=0;N=154;break b}else{q=l;l=0}}else{if(t){l=zj(r)|0;if(!l){l=0;f=0;N=154;break b}else o=0;while(1){do{f=c[L>>2]|0;if(f>>>0<(c[M>>2]|0)>>>0){c[L>>2]=f+1;f=d[f>>0]|0}else f=li(e)|0;if(!(a[I+(f+1)>>0]|0)){q=o;f=0;break i}a[l+o>>0]=f;o=o+1|0}while((o|0)!=(r|0));f=r<<1|1;o=Cj(l,f)|0;if(!o){f=0;N=154;break b}else{q=r;r=f;l=o;o=q}}}if(!x){l=q;while(1){f=c[L>>2]|0;if(f>>>0<l>>>0){c[L>>2]=f+1;f=d[f>>0]|0}else f=li(e)|0;if(!(a[I+(f+1)>>0]|0)){q=0;l=0;f=0;break i}l=c[M>>2]|0}}else{l=0;while(1){f=c[L>>2]|0;if(f>>>0<q>>>0){c[L>>2]=f+1;f=d[f>>0]|0}else f=li(e)|0;if(!(a[I+(f+1)>>0]|0)){q=l;l=x;f=0;break i}a[x+l>>0]=f;q=c[M>>2]|0;l=l+1|0}}}while(0);if(!(c[M>>2]|0))o=c[L>>2]|0;else{o=(c[L>>2]|0)+-1|0;c[L>>2]=o}o=o-(c[z>>2]|0)+(c[G>>2]|0)|0;if(!o)break b;if(!((o|0)==(v|0)|u^1))break b;do if(t)if(s){c[x>>2]=f;break}else{c[x>>2]=l;break}while(0);if(!u){if(f|0)c[f+(q<<2)>>2]=0;if(!l){l=0;break f}a[l+q>>0]=0}break}case 120:case 88:case 112:{o=16;N=136;break}case 111:{o=8;N=136;break}case 117:case 100:{o=10;N=136;break}case 105:{o=0;N=136;break}case 71:case 103:case 70:case 102:case 69:case 101:case 65:case 97:{p=+si(e,t,0);if((c[G>>2]|0)==((c[z>>2]|0)-(c[L>>2]|0)|0))break b;if(x)switch(t|0){case 0:{g[x>>2]=p;break f}case 1:{h[x>>3]=p;break f}case 2:{h[x>>3]=p;break f}default:break f}break}default:{}}while(0);l:do if((N|0)==136){N=0;o=ki(e,o,0,-1,-1)|0;if((c[G>>2]|0)==((c[z>>2]|0)-(c[L>>2]|0)|0))break b;if((x|0)!=0&(r|0)==112){c[x>>2]=o;break}if(x)switch(t|0){case -2:{a[x>>0]=o;break l}case -1:{b[x>>1]=o;break l}case 0:{c[x>>2]=o;break l}case 1:{c[x>>2]=o;break l}case 3:{v=x;c[v>>2]=o;c[v+4>>2]=C;break l}default:break l}}while(0);k=((x|0)!=0&1)+k|0;o=(c[G>>2]|0)+w+(c[L>>2]|0)-(c[z>>2]|0)|0;break c}while(0);n=n+(m&1)|0;ji(e,0);m=c[L>>2]|0;if(m>>>0<(c[M>>2]|0)>>>0){c[L>>2]=m+1;m=d[m>>0]|0}else m=li(e)|0;if((m|0)!=(d[n>>0]|0)){N=22;break b}o=s+1|0}else{while(1){m=n+1|0;if(!(oi(d[m>>0]|0)|0))break;else n=m}ji(e,0);do{m=c[L>>2]|0;if(m>>>0<(c[M>>2]|0)>>>0){c[L>>2]=m+1;m=d[m>>0]|0}else m=li(e)|0}while((oi(m)|0)!=0);if(!(c[M>>2]|0))m=c[L>>2]|0;else{m=(c[L>>2]|0)+-1|0;c[L>>2]=m}o=(c[G>>2]|0)+s+m-(c[z>>2]|0)|0}while(0);n=n+1|0;m=a[n>>0]|0;if(!(m<<24>>24))break a;else s=o}if((N|0)==22){if(c[M>>2]|0)c[L>>2]=(c[L>>2]|0)+-1;if((k|0)!=0|(m|0)>-1)break;else{k=0;N=155}}else if((N|0)==154)if(!k){k=m;N=155}if((N|0)==155){m=k;k=-1}if(m){Aj(l);Aj(f)}}else k=0;while(0);if(O|0)Gh(e);i=P;return k|0}function si(b,e,f){b=b|0;e=e|0;f=f|0;var g=0.0,h=0,j=0.0,k=0,l=0,m=0.0,n=0,o=0,p=0,q=0.0,t=0.0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0.0;L=i;i=i+512|0;H=L;switch(e|0){case 0:{K=24;J=-149;A=4;break}case 1:{K=53;J=-1074;A=4;break}case 2:{K=53;J=-1074;A=4;break}default:g=0.0}a:do if((A|0)==4){E=b+4|0;D=b+100|0;do{e=c[E>>2]|0;if(e>>>0<(c[D>>2]|0)>>>0){c[E>>2]=e+1;e=d[e>>0]|0}else e=li(b)|0}while((oi(e)|0)!=0);b:do switch(e|0){case 43:case 45:{h=1-(((e|0)==45&1)<<1)|0;e=c[E>>2]|0;if(e>>>0<(c[D>>2]|0)>>>0){c[E>>2]=e+1;e=d[e>>0]|0;I=h;break b}else{e=li(b)|0;I=h;break b}}default:I=1}while(0);h=e;e=0;do{if((h|32|0)!=(a[20166+e>>0]|0))break;do if(e>>>0<7){h=c[E>>2]|0;if(h>>>0<(c[D>>2]|0)>>>0){c[E>>2]=h+1;h=d[h>>0]|0;break}else{h=li(b)|0;break}}while(0);e=e+1|0}while(e>>>0<8);c:do switch(e|0){case 8:break;case 3:{A=23;break}default:{k=(f|0)!=0;if(k&e>>>0>3)if((e|0)==8)break c;else{A=23;break c}d:do if(!e){e=0;do{if((h|32|0)!=(a[20175+e>>0]|0))break d;do if(e>>>0<2){h=c[E>>2]|0;if(h>>>0<(c[D>>2]|0)>>>0){c[E>>2]=h+1;h=d[h>>0]|0;break}else{h=li(b)|0;break}}while(0);e=e+1|0}while(e>>>0<3)}while(0);switch(e|0){case 3:{e=c[E>>2]|0;if(e>>>0<(c[D>>2]|0)>>>0){c[E>>2]=e+1;e=d[e>>0]|0}else e=li(b)|0;if((e|0)==40)e=1;else{if(!(c[D>>2]|0)){g=r;break a}c[E>>2]=(c[E>>2]|0)+-1;g=r;break a}while(1){h=c[E>>2]|0;if(h>>>0<(c[D>>2]|0)>>>0){c[E>>2]=h+1;h=d[h>>0]|0}else h=li(b)|0;if(!((h+-48|0)>>>0<10|(h+-65|0)>>>0<26)?!((h|0)==95|(h+-97|0)>>>0<26):0)break;e=e+1|0}if((h|0)==41){g=r;break a}h=(c[D>>2]|0)==0;if(!h)c[E>>2]=(c[E>>2]|0)+-1;if(!k){c[(Dh()|0)>>2]=22;ji(b,0);g=0.0;break a}if(!e){g=r;break a}while(1){e=e+-1|0;if(!h)c[E>>2]=(c[E>>2]|0)+-1;if(!e){g=r;break a}}}case 0:{do if((h|0)==48){e=c[E>>2]|0;if(e>>>0<(c[D>>2]|0)>>>0){c[E>>2]=e+1;e=d[e>>0]|0}else e=li(b)|0;if((e|32|0)!=120){if(!(c[D>>2]|0)){e=48;break}c[E>>2]=(c[E>>2]|0)+-1;e=48;break}e=c[E>>2]|0;if(e>>>0<(c[D>>2]|0)>>>0){c[E>>2]=e+1;e=d[e>>0]|0;k=0}else{e=li(b)|0;k=0}e:while(1){switch(e|0){case 46:{A=74;break e}case 48:break;default:{y=0;l=0;x=0;h=0;n=k;o=0;w=0;m=1.0;k=0;g=0.0;break e}}e=c[E>>2]|0;if(e>>>0<(c[D>>2]|0)>>>0){c[E>>2]=e+1;e=d[e>>0]|0;k=1;continue}else{e=li(b)|0;k=1;continue}}if((A|0)==74){e=c[E>>2]|0;if(e>>>0<(c[D>>2]|0)>>>0){c[E>>2]=e+1;e=d[e>>0]|0}else e=li(b)|0;if((e|0)==48){k=0;h=0;do{e=c[E>>2]|0;if(e>>>0<(c[D>>2]|0)>>>0){c[E>>2]=e+1;e=d[e>>0]|0}else e=li(b)|0;k=Xu(k|0,h|0,-1,-1)|0;h=C}while((e|0)==48);y=0;l=0;x=k;n=1;o=1;w=0;m=1.0;k=0;g=0.0}else{y=0;l=0;x=0;h=0;n=k;o=1;w=0;m=1.0;k=0;g=0.0}}while(1){u=e+-48|0;p=e|32;if(u>>>0>=10){v=(e|0)==46;if(!(v|(p+-97|0)>>>0<6)){p=x;u=y;break}if(v)if(!o){v=l;h=y;u=y;o=1;p=w;j=m}else{p=x;u=y;e=46;break}else A=86}else A=86;if((A|0)==86){A=0;e=(e|0)>57?p+-87|0:u;do if(!((y|0)<0|(y|0)==0&l>>>0<8)){if((y|0)<0|(y|0)==0&l>>>0<14){t=m*.0625;p=w;j=t;g=g+t*+(e|0);break}if((w|0)!=0|(e|0)==0){p=w;j=m}else{p=1;j=m;g=g+m*.5}}else{p=w;j=m;k=e+(k<<4)|0}while(0);l=Xu(l|0,y|0,1,0)|0;v=x;u=C;n=1}e=c[E>>2]|0;if(e>>>0<(c[D>>2]|0)>>>0){c[E>>2]=e+1;y=u;x=v;e=d[e>>0]|0;w=p;m=j;continue}else{y=u;x=v;e=li(b)|0;w=p;m=j;continue}}if(!n){e=(c[D>>2]|0)==0;if(!e)c[E>>2]=(c[E>>2]|0)+-1;if(f){if(!e?(z=c[E>>2]|0,c[E>>2]=z+-1,o|0):0)c[E>>2]=z+-2}else ji(b,0);g=+(I|0)*0.0;break a}n=(o|0)==0;o=n?l:p;n=n?u:h;if((u|0)<0|(u|0)==0&l>>>0<8){h=u;do{k=k<<4;l=Xu(l|0,h|0,1,0)|0;h=C}while((h|0)<0|(h|0)==0&l>>>0<8)}if((e|32|0)==112){h=ti(b,f)|0;e=C;if((h|0)==0&(e|0)==-2147483648){if(!f){ji(b,0);g=0.0;break a}if(!(c[D>>2]|0)){h=0;e=0}else{c[E>>2]=(c[E>>2]|0)+-1;h=0;e=0}}}else if(!(c[D>>2]|0)){h=0;e=0}else{c[E>>2]=(c[E>>2]|0)+-1;h=0;e=0}H=Zu(o|0,n|0,2)|0;H=Xu(H|0,C|0,-32,-1)|0;e=Xu(H|0,C|0,h|0,e|0)|0;h=C;if(!k){g=+(I|0)*0.0;break a}if((h|0)>0|(h|0)==0&e>>>0>(0-J|0)>>>0){c[(Dh()|0)>>2]=34;g=+(I|0)*1797693134862315708145274.0e284*1797693134862315708145274.0e284;break a}H=J+-106|0;G=((H|0)<0)<<31>>31;if((h|0)<(G|0)|(h|0)==(G|0)&e>>>0<H>>>0){c[(Dh()|0)>>2]=34;g=+(I|0)*2.2250738585072014e-308*2.2250738585072014e-308;break a}if((k|0)>-1){do{G=!(g>=.5);H=G&1|k<<1;k=H^1;g=g+(G?g:g+-1.0);e=Xu(e|0,h|0,-1,-1)|0;h=C}while((H|0)>-1);l=e;m=g}else{l=e;m=g}e=Vu(32,0,J|0,((J|0)<0)<<31>>31|0)|0;e=Xu(l|0,h|0,e|0,C|0)|0;J=C;if(0>(J|0)|0==(J|0)&K>>>0>e>>>0)if((e|0)<0){e=0;A=127}else A=125;else{e=K;A=125}if((A|0)==125)if((e|0)<53)A=127;else{h=e;j=+(I|0);g=0.0}if((A|0)==127){g=+(I|0);h=e;j=g;g=+vi(+ui(1.0,84-e|0),g)}K=(k&1|0)==0&(m!=0.0&(h|0)<32);g=j*(K?0.0:m)+(g+j*+(((K&1)+k|0)>>>0))-g;if(!(g!=0.0))c[(Dh()|0)>>2]=34;g=+wi(g,l);break a}else e=h;while(0);F=J+K|0;G=0-F|0;k=0;f:while(1){switch(e|0){case 46:{A=138;break f}case 48:break;default:{h=0;p=0;o=0;break f}}e=c[E>>2]|0;if(e>>>0<(c[D>>2]|0)>>>0){c[E>>2]=e+1;e=d[e>>0]|0;k=1;continue}else{e=li(b)|0;k=1;continue}}if((A|0)==138){e=c[E>>2]|0;if(e>>>0<(c[D>>2]|0)>>>0){c[E>>2]=e+1;e=d[e>>0]|0}else e=li(b)|0;if((e|0)==48){h=0;e=0;while(1){h=Xu(h|0,e|0,-1,-1)|0;k=C;e=c[E>>2]|0;if(e>>>0<(c[D>>2]|0)>>>0){c[E>>2]=e+1;e=d[e>>0]|0}else e=li(b)|0;if((e|0)==48)e=k;else{p=k;k=1;o=1;break}}}else{h=0;p=0;o=1}}c[H>>2]=0;n=e+-48|0;l=(e|0)==46;g:do if(l|n>>>0<10){B=H+496|0;y=0;v=0;w=l;A=p;u=k;z=o;k=0;l=0;o=0;h:while(1){do if(w)if(!z){h=y;p=v;z=1}else{p=A;e=y;n=v;break h}else{w=Xu(y|0,v|0,1,0)|0;v=C;x=(e|0)!=48;if((l|0)>=125){if(!x){p=A;y=w;break}c[B>>2]=c[B>>2]|1;p=A;y=w;break}p=H+(l<<2)|0;if(k)n=e+-48+((c[p>>2]|0)*10|0)|0;c[p>>2]=n;k=k+1|0;n=(k|0)==9;p=A;y=w;u=1;k=n?0:k;l=(n&1)+l|0;o=x?w:o}while(0);e=c[E>>2]|0;if(e>>>0<(c[D>>2]|0)>>>0){c[E>>2]=e+1;e=d[e>>0]|0}else e=li(b)|0;n=e+-48|0;w=(e|0)==46;if(!(w|n>>>0<10)){n=z;A=161;break g}else A=p}u=(u|0)!=0;A=169}else{y=0;v=0;u=k;n=o;k=0;l=0;o=0;A=161}while(0);do if((A|0)==161){B=(n|0)==0;h=B?y:h;p=B?v:p;u=(u|0)!=0;if(!((e|32|0)==101&u))if((e|0)>-1){e=y;n=v;A=169;break}else{e=y;n=v;A=171;break}n=ti(b,f)|0;e=C;if((n|0)==0&(e|0)==-2147483648){if(!f){ji(b,0);g=0.0;break}if(!(c[D>>2]|0)){n=0;e=0}else{c[E>>2]=(c[E>>2]|0)+-1;n=0;e=0}}h=Xu(n|0,e|0,h|0,p|0)|0;u=y;p=C;n=v;A=173}while(0);if((A|0)==169)if(c[D>>2]|0){c[E>>2]=(c[E>>2]|0)+-1;if(u){u=e;A=173}else A=172}else A=171;if((A|0)==171)if(u){u=e;A=173}else A=172;do if((A|0)==172){c[(Dh()|0)>>2]=22;ji(b,0);g=0.0}else if((A|0)==173){e=c[H>>2]|0;if(!e){g=+(I|0)*0.0;break}if(((n|0)<0|(n|0)==0&u>>>0<10)&((h|0)==(u|0)&(p|0)==(n|0))?K>>>0>30|(e>>>K|0)==0:0){g=+(I|0)*+(e>>>0);break}b=(J|0)/-2|0;E=((b|0)<0)<<31>>31;if((p|0)>(E|0)|(p|0)==(E|0)&h>>>0>b>>>0){c[(Dh()|0)>>2]=34;g=+(I|0)*1797693134862315708145274.0e284*1797693134862315708145274.0e284;break}b=J+-106|0;E=((b|0)<0)<<31>>31;if((p|0)<(E|0)|(p|0)==(E|0)&h>>>0<b>>>0){c[(Dh()|0)>>2]=34;g=+(I|0)*2.2250738585072014e-308*2.2250738585072014e-308;break}if(k){if((k|0)<9){n=H+(l<<2)|0;e=c[n>>2]|0;do{e=e*10|0;k=k+1|0}while((k|0)!=9);c[n>>2]=e}l=l+1|0}if((o|0)<9?(o|0)<=(h|0)&(h|0)<18:0){if((h|0)==9){g=+(I|0)*+((c[H>>2]|0)>>>0);break}if((h|0)<9){g=+(I|0)*+((c[H>>2]|0)>>>0)/+(c[8656+(8-h<<2)>>2]|0);break}b=K+27+(_(h,-3)|0)|0;e=c[H>>2]|0;if((b|0)>30|(e>>>b|0)==0){g=+(I|0)*+(e>>>0)*+(c[8656+(h+-10<<2)>>2]|0);break}}e=(h|0)%9|0;if(!e){k=0;e=0}else{u=(h|0)>-1?e:e+9|0;n=c[8656+(8-u<<2)>>2]|0;if(l){o=1e9/(n|0)|0;k=0;e=0;p=0;do{D=H+(p<<2)|0;E=c[D>>2]|0;b=((E>>>0)/(n>>>0)|0)+e|0;c[D>>2]=b;e=_((E>>>0)%(n>>>0)|0,o)|0;b=(p|0)==(k|0)&(b|0)==0;p=p+1|0;h=b?h+-9|0:h;k=b?p&127:k}while((p|0)!=(l|0));if(e){c[H+(l<<2)>>2]=e;l=l+1|0}}else{k=0;l=0}e=0;h=9-u+h|0}i:while(1){v=(h|0)<18;w=(h|0)==18;x=H+(k<<2)|0;do{if(!v){if(!w){y=l;break i}if((c[x>>2]|0)>>>0>=9007199){h=18;y=l;break i}}n=0;o=l+127|0;while(1){u=o&127;p=H+(u<<2)|0;o=Zu(c[p>>2]|0,0,29)|0;o=Xu(o|0,C|0,n|0,0)|0;n=C;if(n>>>0>0|(n|0)==0&o>>>0>1e9){b=iv(o|0,n|0,1e9,0)|0;o=jv(o|0,n|0,1e9,0)|0;n=b}else n=0;c[p>>2]=o;b=(u|0)==(k|0);l=(u|0)!=(l+127&127|0)|b?l:(o|0)==0?u:l;if(b)break;else o=u+-1|0}e=e+-29|0}while((n|0)==0);k=k+127&127;if((k|0)==(l|0)){b=l+127&127;l=H+((l+126&127)<<2)|0;c[l>>2]=c[l>>2]|c[H+(b<<2)>>2];l=b}c[H+(k<<2)>>2]=n;h=h+9|0}j:while(1){l=y+1&127;x=H+((y+127&127)<<2)|0;while(1){v=(h|0)==18;w=(h|0)>27?9:1;u=v^1;while(1){o=k&127;p=(o|0)==(y|0);do if(!p){n=c[H+(o<<2)>>2]|0;if(n>>>0<9007199){A=219;break}if(n>>>0>9007199)break;n=k+1&127;if((n|0)==(y|0)){A=219;break}n=c[H+(n<<2)>>2]|0;if(n>>>0<254740991){A=219;break}if(!(n>>>0>254740991|u)){h=o;l=y;break j}}else A=219;while(0);if((A|0)==219?(A=0,v):0){A=220;break j}e=e+w|0;if((k|0)==(y|0))k=y;else break}u=(1<<w)+-1|0;v=1e9>>>w;o=k;n=0;p=k;while(1){E=H+(p<<2)|0;b=c[E>>2]|0;k=(b>>>w)+n|0;c[E>>2]=k;n=_(b&u,v)|0;k=(p|0)==(o|0)&(k|0)==0;p=p+1&127;h=k?h+-9|0:h;k=k?p:o;if((p|0)==(y|0))break;else o=k}if(!n)continue;if((l|0)!=(k|0))break;c[x>>2]=c[x>>2]|1}c[H+(y<<2)>>2]=n;y=l}if((A|0)==220)if(p){c[H+(l+-1<<2)>>2]=0;h=y}else{h=o;l=y}g=+((c[H+(h<<2)>>2]|0)>>>0);h=k+1&127;if((h|0)==(l|0)){l=k+2&127;c[H+(l+-1<<2)>>2]=0}t=+(I|0);j=t*(g*1.0e9+ +((c[H+(h<<2)>>2]|0)>>>0));v=e+53|0;p=v-J|0;u=(p|0)<(K|0);h=u&1;o=u?((p|0)<0?0:p):K;if((o|0)<53){M=+vi(+ui(1.0,105-o|0),j);m=+xi(j,+ui(1.0,53-o|0));q=M;g=m;m=M+(j-m)}else{q=0.0;g=0.0;m=j}n=k+2&127;do if((n|0)==(l|0))j=g;else{n=c[H+(n<<2)>>2]|0;do if(n>>>0>=5e8){if(n>>>0>5e8){g=t*.75+g;break}if((k+3&127|0)==(l|0)){g=t*.5+g;break}else{g=t*.75+g;break}}else{if((n|0)==0?(k+3&127|0)==(l|0):0)break;g=t*.25+g}while(0);if((53-o|0)<=1){j=g;break}if(+xi(g,1.0)!=0.0){j=g;break}j=g+1.0}while(0);g=m+j-q;do if((v&2147483647|0)>(-2-F|0)){if(+N(+g)>=9007199254740992.0){h=u&(o|0)==(p|0)?0:h;e=e+1|0;g=g*.5}if((e+50|0)<=(G|0)?!(j!=0.0&(h|0)!=0):0)break;c[(Dh()|0)>>2]=34}while(0);g=+wi(g,e)}while(0);break a}default:{if(c[D>>2]|0)c[E>>2]=(c[E>>2]|0)+-1;c[(Dh()|0)>>2]=22;ji(b,0);g=0.0;break a}}}}while(0);if((A|0)==23){h=(c[D>>2]|0)==0;if(!h)c[E>>2]=(c[E>>2]|0)+-1;if((f|0)!=0&e>>>0>3)do{if(!h)c[E>>2]=(c[E>>2]|0)+-1;e=e+-1|0}while(e>>>0>3)}g=+(I|0)*s}while(0);i=L;return +g}function ti(a,b){a=a|0;b=b|0;var e=0,f=0,g=0,h=0,i=0,j=0;i=a+4|0;e=c[i>>2]|0;j=a+100|0;if(e>>>0<(c[j>>2]|0)>>>0){c[i>>2]=e+1;e=d[e>>0]|0}else e=li(a)|0;switch(e|0){case 43:case 45:{f=(e|0)==45&1;e=c[i>>2]|0;if(e>>>0<(c[j>>2]|0)>>>0){c[i>>2]=e+1;e=d[e>>0]|0}else e=li(a)|0;if((b|0)!=0&(e+-48|0)>>>0>9?(c[j>>2]|0)!=0:0){c[i>>2]=(c[i>>2]|0)+-1;h=f}else h=f;break}default:h=0}if((e+-48|0)>>>0>9)if(!(c[j>>2]|0)){f=-2147483648;e=0}else{c[i>>2]=(c[i>>2]|0)+-1;f=-2147483648;e=0}else{f=0;do{f=e+-48+(f*10|0)|0;e=c[i>>2]|0;if(e>>>0<(c[j>>2]|0)>>>0){c[i>>2]=e+1;e=d[e>>0]|0}else e=li(a)|0}while((e+-48|0)>>>0<10&(f|0)<214748364);b=((f|0)<0)<<31>>31;if((e+-48|0)>>>0<10){do{b=hv(f|0,b|0,10,0)|0;f=C;e=Xu(e|0,((e|0)<0)<<31>>31|0,-48,-1)|0;f=Xu(e|0,C|0,b|0,f|0)|0;b=C;e=c[i>>2]|0;if(e>>>0<(c[j>>2]|0)>>>0){c[i>>2]=e+1;e=d[e>>0]|0}else e=li(a)|0}while((e+-48|0)>>>0<10&((b|0)<21474836|(b|0)==21474836&f>>>0<2061584302));g=f}else g=f;if((e+-48|0)>>>0<10)do{e=c[i>>2]|0;if(e>>>0<(c[j>>2]|0)>>>0){c[i>>2]=e+1;e=d[e>>0]|0}else e=li(a)|0}while((e+-48|0)>>>0<10);if(c[j>>2]|0)c[i>>2]=(c[i>>2]|0)+-1;a=(h|0)!=0;e=Vu(0,0,g|0,b|0)|0;f=a?C:b;e=a?e:g}C=f;return e|0}function ui(a,b){a=+a;b=b|0;var d=0;if((b|0)>1023){a=a*8988465674311579538646525.0e283;d=b+-1023|0;if((d|0)>1023){d=b+-2046|0;d=(d|0)>1023?1023:d;a=a*8988465674311579538646525.0e283}}else if((b|0)<-1022){a=a*2.2250738585072014e-308;d=b+1022|0;if((d|0)<-1022){d=b+2044|0;d=(d|0)<-1022?-1022:d;a=a*2.2250738585072014e-308}}else d=b;d=Zu(d+1023|0,0,52)|0;b=C;c[k>>2]=d;c[k+4>>2]=b;return +(a*+h[k>>3])}function vi(a,b){a=+a;b=+b;return +(+Lh(a,b))}function wi(a,b){a=+a;b=b|0;return +(+ui(a,b))}function xi(a,b){a=+a;b=+b;return +(+yi(a,b))}function yi(a,b){a=+a;b=+b;var d=0,e=0,f=0,g=0,i=0,j=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0.0;h[k>>3]=a;d=c[k>>2]|0;m=c[k+4>>2]|0;h[k>>3]=b;n=c[k>>2]|0;o=c[k+4>>2]|0;e=Yu(d|0,m|0,52)|0;e=e&2047;j=Yu(n|0,o|0,52)|0;j=j&2047;p=m&-2147483648;i=Zu(n|0,o|0,1)|0;l=C;a:do if(!((i|0)==0&(l|0)==0)?(r=+N(+b),h[k>>3]=r,g=c[k+4>>2]|0,!(g>>>0>2146435072|(g|0)==2146435072&(c[k>>2]|0)>>>0>0|(e|0)==2047)):0){f=Zu(d|0,m|0,1)|0;g=C;if(!(g>>>0>l>>>0|(g|0)==(l|0)&f>>>0>i>>>0))return +((f|0)==(i|0)&(g|0)==(l|0)?a*0.0:a);if(!e){e=Zu(d|0,m|0,12)|0;f=C;if((f|0)>-1|(f|0)==-1&e>>>0>4294967295){g=e;e=0;do{e=e+-1|0;g=Zu(g|0,f|0,1)|0;f=C}while((f|0)>-1|(f|0)==-1&g>>>0>4294967295)}else e=0;d=Zu(d|0,m|0,1-e|0)|0;f=C}else f=m&1048575|1048576;if(!j){g=Zu(n|0,o|0,12)|0;i=C;if((i|0)>-1|(i|0)==-1&g>>>0>4294967295){j=0;do{j=j+-1|0;g=Zu(g|0,i|0,1)|0;i=C}while((i|0)>-1|(i|0)==-1&g>>>0>4294967295)}else j=0;n=Zu(n|0,o|0,1-j|0)|0;m=C}else m=o&1048575|1048576;l=Vu(d|0,f|0,n|0,m|0)|0;i=C;g=(i|0)>-1|(i|0)==-1&l>>>0>4294967295;b:do if((e|0)>(j|0)){while(1){if(g)if((d|0)==(n|0)&(f|0)==(m|0))break;else{d=l;f=i}d=Zu(d|0,f|0,1)|0;f=C;e=e+-1|0;l=Vu(d|0,f|0,n|0,m|0)|0;i=C;g=(i|0)>-1|(i|0)==-1&l>>>0>4294967295;if((e|0)<=(j|0))break b}b=a*0.0;break a}while(0);if(g)if((d|0)==(n|0)&(f|0)==(m|0)){b=a*0.0;break}else{f=i;d=l}if(f>>>0<1048576|(f|0)==1048576&d>>>0<0)do{d=Zu(d|0,f|0,1)|0;f=C;e=e+-1|0}while(f>>>0<1048576|(f|0)==1048576&d>>>0<0);if((e|0)>0){o=Xu(d|0,f|0,0,-1048576)|0;d=C;e=Zu(e|0,0,52)|0;d=d|C;e=o|e}else{e=Yu(d|0,f|0,1-e|0)|0;d=C}c[k>>2]=e;c[k+4>>2]=d|p;b=+h[k>>3]}else q=3;while(0);if((q|0)==3){b=a*b;b=b/b}return +b}function zi(a){a=a|0;var b=0;if(!(c[a>>2]&128))b=1;else b=(c[a+20>>2]|0)>>>0>(c[a+28>>2]|0)>>>0?2:1;b=yb[c[a+40>>2]&31](a,0,b)|0;if((b|0)>=0)b=b-(c[a+8>>2]|0)+(c[a+4>>2]|0)+(c[a+20>>2]|0)-(c[a+28>>2]|0)|0;return b|0}function Ai(a){a=a|0;var b=0,d=0;if((c[a+76>>2]|0)>-1){d=(bi(a)|0)==0;b=zi(a)|0;if(!d)Gh(a)}else b=zi(a)|0;return b|0}function Bi(b,e){b=b|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0;m=i;i=i+16|0;l=m;k=e&255;a[l>>0]=k;g=b+16|0;h=c[g>>2]|0;if(!h)if(!(Th(b)|0)){h=c[g>>2]|0;j=4}else f=-1;else j=4;do if((j|0)==4){g=b+20|0;j=c[g>>2]|0;if(j>>>0<h>>>0?(f=e&255,(f|0)!=(a[b+75>>0]|0)):0){c[g>>2]=j+1;a[j>>0]=k;break}if((yb[c[b+36>>2]&31](b,l,1)|0)==1)f=d[l>>0]|0;else f=-1}while(0);i=m;return f|0}function Ci(a){a=a|0;var b=0,d=0,e=0;if((c[a+76>>2]|0)>-1)bi(a)|0;e=(c[a>>2]&1|0)!=0;if(!e){lb(1148452);d=c[a+52>>2]|0;b=a+56|0;if(d|0)c[d+56>>2]=c[b>>2];b=c[b>>2]|0;if(b|0)c[b+52>>2]=d;if((c[287112]|0)==(a|0))c[287112]=b;db(1148452)}b=Di(a)|0;b=Fb[c[a+12>>2]&127](a)|0|b;d=c[a+92>>2]|0;if(d|0)Aj(d);if(!e)Aj(a);return b|0}function Di(a){a=a|0;var b=0,d=0;do if(a){if((c[a+76>>2]|0)<=-1){b=Ei(a)|0;break}d=(bi(a)|0)==0;b=Ei(a)|0;if(!d)Gh(a)}else{if(!(c[2055]|0))b=0;else b=Di(c[2055]|0)|0;lb(1148452);a=c[287112]|0;if(a)do{if((c[a+76>>2]|0)>-1)d=bi(a)|0;else d=0;if((c[a+20>>2]|0)>>>0>(c[a+28>>2]|0)>>>0)b=Ei(a)|0|b;if(d|0)Gh(a);a=c[a+56>>2]|0}while((a|0)!=0);db(1148452)}while(0);return b|0}function Ei(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0;b=a+20|0;g=a+28|0;if((c[b>>2]|0)>>>0>(c[g>>2]|0)>>>0?(yb[c[a+36>>2]&31](a,0,0)|0,(c[b>>2]|0)==0):0)b=-1;else{h=a+4|0;d=c[h>>2]|0;e=a+8|0;f=c[e>>2]|0;if(d>>>0<f>>>0)yb[c[a+40>>2]&31](a,d-f|0,1)|0;c[a+16>>2]=0;c[g>>2]=0;c[b>>2]=0;c[e>>2]=0;c[h>>2]=0;b=0}return b|0}function Fi(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0;f=_(d,b)|0;if((c[e+76>>2]|0)>-1){g=(bi(e)|0)==0;a=Sh(a,f,e)|0;if(!g)Gh(e)}else a=Sh(a,f,e)|0;if((a|0)!=(f|0))d=(a>>>0)/(b>>>0)|0;return d|0}function Gi(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0;if((c[d+76>>2]|0)>=0?(bi(d)|0)!=0:0){if((a[d+75>>0]|0)!=(b|0)?(f=d+20|0,g=c[f>>2]|0,g>>>0<(c[d+16>>2]|0)>>>0):0){c[f>>2]=g+1;a[g>>0]=b;e=b&255}else e=Bi(d,b)|0;Gh(d)}else i=3;do if((i|0)==3){if((a[d+75>>0]|0)!=(b|0)?(h=d+20|0,e=c[h>>2]|0,e>>>0<(c[d+16>>2]|0)>>>0):0){c[h>>2]=e+1;a[e>>0]=b;e=b&255;break}e=Bi(d,b)|0}while(0);return e|0}function Hi(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0;do if((b|0)!=-1){if((c[d+76>>2]|0)>-1)g=bi(d)|0;else g=0;if(!((c[d+8>>2]|0)==0?(ni(d)|0)!=0:0))h=6;if((h|0)==6?(e=d+4|0,f=c[e>>2]|0,f>>>0>((c[d+44>>2]|0)+-8|0)>>>0):0){h=f+-1|0;c[e>>2]=h;a[h>>0]=b;c[d>>2]=c[d>>2]&-17;if(!g)break;Gh(d);break}if(g){Gh(d);b=-1}else b=-1}else b=-1;while(0);return b|0}function Ii(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0;j=_(e,d)|0;if((c[f+76>>2]|0)>-1)k=bi(f)|0;else k=0;g=f+74|0;i=a[g>>0]|0;a[g>>0]=i+255|i;g=f+4|0;i=c[g>>2]|0;h=(c[f+8>>2]|0)-i|0;if((h|0)>0){h=h>>>0<j>>>0?h:j;_u(b|0,i|0,h|0)|0;c[g>>2]=i+h;b=b+h|0;g=j-h|0}else g=j;a:do if(!g)l=13;else{i=f+32|0;h=g;while(1){if(ni(f)|0){e=h;break}g=yb[c[i>>2]&31](f,b,h)|0;if((g+1|0)>>>0<2){e=h;break}if((h|0)==(g|0)){l=13;break a}else{b=b+g|0;h=h-g|0}}if(k|0)Gh(f);e=((j-e|0)>>>0)/(d>>>0)|0}while(0);if((l|0)==13)if(k)Gh(f);return e|0}function Ji(a,b){a=a|0;b=b|0;return (Fi(a,Mh(a)|0,1,b)|0)+-1|0}function Ki(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0;k=i;i=i+16|0;j=k;a:do if(!b){b=c[d>>2]|0;f=c[b>>2]|0;if(!f)e=0;else{e=0;do{if(f>>>0>127){f=_h(j,f,0)|0;if((f|0)==-1){e=-1;break a}}else f=1;e=f+e|0;b=b+4|0;f=c[b>>2]|0}while((f|0)!=0)}}else{b:do if(e>>>0>3){f=e;g=c[d>>2]|0;while(1){h=c[g>>2]|0;if((h+-1|0)>>>0>126){if(!h)break;h=_h(b,h,0)|0;if((h|0)==-1){e=-1;break a}b=b+h|0;f=f-h|0}else{a[b>>0]=h;b=b+1|0;f=f+-1|0;g=c[d>>2]|0}g=g+4|0;c[d>>2]=g;if(f>>>0<=3)break b}a[b>>0]=0;c[d>>2]=0;e=e-f|0;break a}else f=e;while(0);if(f){g=c[d>>2]|0;while(1){h=c[g>>2]|0;if((h+-1|0)>>>0>126){if(!h){g=19;break}h=_h(j,h,0)|0;if((h|0)==-1){e=-1;break a}if(f>>>0<h>>>0){g=22;break}_h(b,c[g>>2]|0,0)|0;b=b+h|0;f=f-h|0}else{a[b>>0]=h;b=b+1|0;f=f+-1|0;g=c[d>>2]|0}g=g+4|0;c[d>>2]=g;if(!f)break a}if((g|0)==19){a[b>>0]=0;c[d>>2]=0;e=e-f|0;break}else if((g|0)==22){e=e-f|0;break}}}while(0);i=k;return e|0}function Li(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;o=i;i=i+112|0;n=o+40|0;l=o+24|0;k=o+16|0;g=o;m=o+52|0;f=a[d>>0]|0;if(Xh(20179,f<<24>>24,4)|0){e=zj(1144)|0;if(!e)e=0;else{h=e;j=h+112|0;do{c[h>>2]=0;h=h+4|0}while((h|0)<(j|0));if(!(ci(d,43)|0))c[e>>2]=f<<24>>24==114?8:4;if(ci(d,101)|0){c[g>>2]=b;c[g+4>>2]=2;c[g+8>>2]=1;Xa(221,g|0)|0;f=a[d>>0]|0}if(f<<24>>24==97){c[k>>2]=b;c[k+4>>2]=3;f=Xa(221,k|0)|0;if(!(f&1024)){c[l>>2]=b;c[l+4>>2]=4;c[l+8>>2]=f|1024;Xa(221,l|0)|0}d=c[e>>2]|128;c[e>>2]=d}else d=c[e>>2]|0;c[e+60>>2]=b;c[e+44>>2]=e+120;c[e+48>>2]=1024;f=e+75|0;a[f>>0]=-1;if((d&8|0)==0?(c[n>>2]=b,c[n+4>>2]=21505,c[n+8>>2]=m,(cb(54,n|0)|0)==0):0)a[f>>0]=10;c[e+32>>2]=8;c[e+36>>2]=5;c[e+40>>2]=6;c[e+12>>2]=31;if(!(c[287107]|0))c[e+76>>2]=-1;lb(1148452);f=c[287112]|0;c[e+56>>2]=f;if(f|0)c[f+52>>2]=e;c[287112]=e;db(1148452)}}else{c[(Dh()|0)>>2]=22;e=0}i=o;return e|0}function Mi(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0;g=i;i=i+32|0;f=g+16|0;e=g;if(Xh(20179,a[d>>0]|0,4)|0){h=Ni(d)|0|32768;c[e>>2]=b;c[e+4>>2]=h;c[e+8>>2]=438;e=Ch(nb(5,e|0)|0)|0;if((e|0)>=0){b=Li(e,d)|0;if(!b){c[f>>2]=e;mb(6,f|0)|0;b=0}}else b=0}else{c[(Dh()|0)>>2]=22;b=0}i=g;return b|0}function Ni(b){b=b|0;var c=0,d=0,e=0;d=(ci(b,43)|0)==0;c=a[b>>0]|0;d=d?c<<24>>24!=114&1:2;e=(ci(b,120)|0)==0;d=e?d:d|128;b=(ci(b,101)|0)==0;b=b?d:d|524288;b=c<<24>>24==114?b:b|64;b=c<<24>>24==119?b|512:b;return (c<<24>>24==97?b|1024:b)|0}function Oi(b){b=b|0;var d=0,e=0,f=0,g=0;f=c[2026]|0;if((c[f+76>>2]|0)>-1)g=bi(f)|0;else g=0;do if((Ji(b,f)|0)<0)d=1;else{if((a[f+75>>0]|0)!=10?(d=f+20|0,e=c[d>>2]|0,e>>>0<(c[f+16>>2]|0)>>>0):0){c[d>>2]=e+1;a[e>>0]=10;d=0;break}d=(Bi(f,10)|0)<0}while(0);if(g|0)Gh(f);return d<<31>>31|0}function Pi(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0;j=i;i=i+16|0;e=j;f=zj(240)|0;do if(f){c[e>>2]=c[d>>2];e=Oh(f,240,b,e)|0;if(e>>>0<240){b=Cj(f,e+1|0)|0;c[a>>2]=b|0?b:f;break}Aj(f);if((e|0)>=0?(h=e+1|0,g=zj(h)|0,c[a>>2]=g,(g|0)!=0):0)e=Oh(g,h,b,d)|0;else e=-1}else e=-1;while(0);i=j;return e|0}function Qi(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e;c[f>>2]=d;d=Ri(a,b,f)|0;i=e;return d|0}function Ri(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0;g=i;i=i+112|0;e=g;f=e;h=f+112|0;do{c[f>>2]=0;f=f+4|0}while((f|0)<(h|0));c[e+32>>2]=29;c[e+44>>2]=a;c[e+76>>2]=-1;c[e+84>>2]=a;h=ri(e,b,d)|0;i=g;return h|0}function Si(a,b,c){a=a|0;b=b|0;c=c|0;return Ti(a,b,c)|0}function Ti(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0;e=a+84|0;g=c[e>>2]|0;h=d+256|0;f=Xh(g,0,h)|0;f=(f|0)==0?h:f-g|0;d=f>>>0<d>>>0?f:d;_u(b|0,g|0,d|0)|0;c[a+4>>2]=g+d;b=g+f|0;c[a+8>>2]=b;c[e>>2]=b;return d|0}function Ui(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;if((c[a+76>>2]|0)>-1){e=(bi(a)|0)==0;b=Vi(a,b,d)|0;if(!e)Gh(a)}else b=Vi(a,b,d)|0;return b|0}function Vi(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;if((d|0)==1)b=b-(c[a+8>>2]|0)+(c[a+4>>2]|0)|0;e=a+20|0;f=a+28|0;if((c[e>>2]|0)>>>0>(c[f>>2]|0)>>>0?(yb[c[a+36>>2]&31](a,0,0)|0,(c[e>>2]|0)==0):0)b=-1;else{c[a+16>>2]=0;c[f>>2]=0;c[e>>2]=0;if((yb[c[a+40>>2]&31](a,b,d)|0)<0)b=-1;else{c[a+8>>2]=0;c[a+4>>2]=0;c[a>>2]=c[a>>2]&-17;b=0}}return b|0}function Wi(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;o=i;i=i+1040|0;l=o+8|0;n=o;k=c[b>>2]|0;c[n>>2]=k;m=(a|0)!=0;e=m?e:256;a=m?a:l;g=k;a:do if((e|0)!=0&(k|0)!=0){j=e;k=g;e=0;while(1){g=d>>>2;h=g>>>0>=j>>>0;if(!(d>>>0>131|h)){g=k;break a}g=h?j:g;d=d-g|0;g=Xi(a,n,g,f)|0;if((g|0)==-1){e=d;break}p=(a|0)==(l|0);k=p?0:g;h=j-k|0;a=p?a:a+(g<<2)|0;e=g+e|0;g=c[n>>2]|0;if((j|0)!=(k|0)&(g|0)!=0){j=h;k=g}else{j=h;break a}}d=e;j=0;g=c[n>>2]|0;e=-1}else{j=e;e=0}while(0);b:do if((g|0)!=0?(j|0)!=0&(d|0)!=0:0){h=g;g=a;while(1){a=pi(g,h,d,f)|0;if((a+2|0)>>>0<3)break;h=(c[n>>2]|0)+a|0;c[n>>2]=h;j=j+-1|0;e=e+1|0;if(!((j|0)!=0&(d|0)!=(a|0)))break b;else{d=d-a|0;g=g+4|0}}switch(a|0){case -1:{e=-1;break b}case 0:{c[n>>2]=0;break b}default:{c[f>>2]=0;break b}}}while(0);if(m)c[b>>2]=c[n>>2];i=o;return e|0}function Xi(b,e,f,g){b=b|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0;h=c[e>>2]|0;if((g|0)!=0?(i=c[g>>2]|0,(i|0)!=0):0)if(!b){g=f;j=h;m=16}else{c[g>>2]=0;l=b;g=f;k=i;m=37}else if(!b){g=f;m=7}else{i=b;g=f;m=6}a:while(1)if((m|0)==6){if(!g){m=26;break}else b=i;while(1){i=a[h>>0]|0;do if(((i&255)+-1|0)>>>0<127?g>>>0>4&(h&3|0)==0:0){j=h;while(1){h=c[j>>2]|0;if((h+-16843009|h)&-2139062144|0){i=h;h=j;m=32;break}c[b>>2]=h&255;c[b+4>>2]=d[j+1>>0];c[b+8>>2]=d[j+2>>0];h=j+4|0;i=b+16|0;c[b+12>>2]=d[j+3>>0];g=g+-4|0;if(g>>>0>4){b=i;j=h}else{m=31;break}}if((m|0)==31){b=i;i=a[h>>0]|0;break}else if((m|0)==32){i=i&255;break}}while(0);i=i&255;if((i+-1|0)>>>0>=127)break;h=h+1|0;c[b>>2]=i;g=g+-1|0;if(!g){m=26;break a}else b=b+4|0}i=i+-194|0;if(i>>>0>50){m=48;break}l=b;k=c[8340+(i<<2)>>2]|0;h=h+1|0;m=37;continue}else if((m|0)==7){i=a[h>>0]|0;if(((i&255)+-1|0)>>>0<127?(h&3|0)==0:0){m=c[h>>2]|0;i=m&255;if(!((m+-16843009|m)&-2139062144)){do{h=h+4|0;g=g+-4|0;i=c[h>>2]|0}while(((i+-16843009|i)&-2139062144|0)==0);i=i&255}}i=i&255;if((i+-1|0)>>>0<127){g=g+-1|0;h=h+1|0;m=7;continue}i=i+-194|0;if(i>>>0>50){m=48;break}i=c[8340+(i<<2)>>2]|0;j=h+1|0;m=16;continue}else if((m|0)==16){m=(d[j>>0]|0)>>>3;if((m+-16|m+(i>>26))>>>0>7){m=17;break}h=j+1|0;if(i&33554432){if((a[h>>0]&-64)<<24>>24!=-128){m=20;break}h=j+2|0;if(i&524288){if((a[h>>0]&-64)<<24>>24!=-128){m=23;break}h=j+3|0}}g=g+-1|0;m=7;continue}else if((m|0)==37){i=d[h>>0]|0;m=i>>>3;if((m+-16|m+(k>>26))>>>0>7){m=38;break}j=h+1|0;b=i+-128|k<<6;if((b|0)<0){i=d[j>>0]|0;if((i&192|0)!=128){m=41;break}j=h+2|0;b=i+-128|b<<6;if((b|0)<0){i=d[j>>0]|0;if((i&192|0)!=128){m=44;break}b=i+-128|b<<6;h=h+3|0}else h=j}else h=j;c[l>>2]=b;i=l+4|0;g=g+-1|0;m=6;continue}if((m|0)==17){h=j+-1|0;m=47}else if((m|0)==20){h=j+-1|0;m=47}else if((m|0)==23){h=j+-1|0;m=47}else if((m|0)==26)c[e>>2]=h;else if((m|0)==38){b=l;i=k;h=h+-1|0;m=47}else if((m|0)==41){g=l;f=h+-1|0;m=52}else if((m|0)==44){g=l;f=h+-1|0;m=52}if((m|0)==47)if(!i)m=48;else{g=b;f=h;m=52}if((m|0)==48)if(!(a[h>>0]|0)){if(b|0){c[b>>2]=0;c[e>>2]=0}f=f-g|0}else{g=b;f=h;m=52}if((m|0)==52){c[(Dh()|0)>>2]=84;if(!g)f=-1;else{c[e>>2]=f;f=-1}}return f|0}function Yi(a){a=a|0;var b=0,e=0,f=0;if((c[a+76>>2]|0)>=0?(bi(a)|0)!=0:0){b=a+4|0;e=c[b>>2]|0;if(e>>>0<(c[a+8>>2]|0)>>>0){c[b>>2]=e+1;b=d[e>>0]|0}else b=mi(a)|0}else f=3;do if((f|0)==3){b=a+4|0;e=c[b>>2]|0;if(e>>>0<(c[a+8>>2]|0)>>>0){c[b>>2]=e+1;b=d[e>>0]|0;break}else{b=mi(a)|0;break}}while(0);return b|0}function Zi(a,b,c){a=a|0;b=b|0;c=c|0;return pi(0,a,b,c|0?c:1148476)|0}function _i(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;m=i;i=i+272|0;j=m+8|0;l=m;h=c[b>>2]|0;c[l>>2]=h;k=(a|0)!=0;f=k?e:256;e=k?a:j;a=h;a:do if((f|0)!=0&(h|0)!=0){h=f;g=a;f=0;while(1){a=d>>>0>=h>>>0;if(!(a|d>>>0>32)){a=g;break a}a=a?h:d;d=d-a|0;a=Ki(e,l,a,0)|0;if((a|0)==-1){f=d;break}o=(e|0)==(j|0);n=o?0:a;g=h-n|0;e=o?e:e+a|0;f=a+f|0;a=c[l>>2]|0;if((h|0)!=(n|0)&(a|0)!=0){h=g;g=a}else{h=g;break a}}d=f;h=0;a=c[l>>2]|0;f=-1}else{h=f;f=0}while(0);b:do if((a|0)!=0?(h|0)!=0&(d|0)!=0:0){g=a;a=e;while(1){e=_h(a,c[g>>2]|0,0)|0;if((e+1|0)>>>0<2)break;g=(c[l>>2]|0)+4|0;c[l>>2]=g;d=d+-1|0;f=f+1|0;if(!((h|0)!=(e|0)&(d|0)!=0))break b;else{h=h-e|0;a=a+e|0}}if(!e)c[l>>2]=0;else f=-1}while(0);if(k)c[b>>2]=c[l>>2];i=m;return f|0}function $i(b,c,d){b=b|0;c=c|0;d=d|0;if(((a[c>>0]|0)!=0?(fi(c,21332)|0)!=0:0)?(fi(c,20183)|0)!=0:0)d=0;else if(!d)d=Bj(1,4)|0;return d|0}function aj(a){a=a|0;var b=0;b=(bj(a)|0)==0;return (b?a:a|32)|0}function bj(a){a=a|0;return (a+-65|0)>>>0<26|0}function cj(a){a=a|0;return 0}function dj(a){a=a|0;var b=0;b=(ej(a)|0)==0;return (b?a:a&95)|0}function ej(a){a=a|0;return (a+-97|0)>>>0<26|0}function fj(a,b){a=a|0;b=b|0;return gj(a)|0}function gj(a){a=a|0;if((a+-48|0)>>>0<10)a=1;else a=((a|32)+-97|0)>>>0<6;return a&1|0}function hj(a){a=a|0;var b=0,d=0;b=(Za()|0)+180|0;d=c[b>>2]|0;if(a|0)c[b>>2]=a;return d|0}function ij(a,b){a=a|0;b=b|0;return -1|0}function jj(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return d|0}function kj(a){a=a|0;Aj(a);return}function lj(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;if(d|0){e=a;while(1){d=d+-1|0;c[e>>2]=c[b>>2];if(!d)break;else{b=b+4|0;e=e+4|0}}}return a|0}function mj(a,b){a=a|0;b=b|0;return (a+-48|0)>>>0<10|0}function nj(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0,g=0,h=0,j=0;j=i;i=i+112|0;h=j;f=h;g=f+112|0;do{c[f>>2]=0;f=f+4|0}while((f|0)<(g|0));f=h+4|0;c[f>>2]=a;g=h+8|0;c[g>>2]=-1;c[h+44>>2]=a;c[h+76>>2]=-1;ji(h,0);e=+si(h,d,1);d=(c[f>>2]|0)-(c[g>>2]|0)+(c[h+108>>2]|0)|0;if(b|0)c[b>>2]=d|0?a+d|0:a;i=j;return +e}function oj(a,b,c){a=a|0;b=b|0;c=c|0;return +(+nj(a,b,2))}function pj(a,b,c){a=a|0;b=b|0;c=c|0;a=ii(a,b,c,-1,-1)|0;return a|0}function qj(a,b,c){a=a|0;b=b|0;c=c|0;a=ii(a,b,c,0,-2147483648)|0;return a|0}function rj(b,c,d){b=b|0;c=c|0;d=d|0;var e=0,f=0;a:do if(!d)d=0;else{f=d;e=b;while(1){b=a[e>>0]|0;d=a[c>>0]|0;if(b<<24>>24!=d<<24>>24)break;f=f+-1|0;if(!f){d=0;break a}else{e=e+1|0;c=c+1|0}}d=(b&255)-(d&255)|0}while(0);return d|0}function sj(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;a=pj(a,b,c)|0;return a|0}function tj(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;a=qj(a,b,c)|0;return a|0}function uj(){return 8688}function vj(){return 8692}function wj(){return 10232}function xj(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;if(d|0){e=a;while(1){d=d+-1|0;c[e>>2]=b;if(!d)break;else e=e+4|0}}return a|0}function yj(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;e=(d|0)==0;if(a-b>>2>>>0<d>>>0){if(!e)do{d=d+-1|0;c[a+(d<<2)>>2]=c[b+(d<<2)>>2]}while((d|0)!=0)}else if(!e){e=b;b=a;while(1){d=d+-1|0;c[b>>2]=c[e>>2];if(!d)break;else{e=e+4|0;b=b+4|0}}}return a|0}function zj(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0;do if(a>>>0<245){o=a>>>0<11?16:a+11&-8;a=o>>>3;j=c[287120]|0;b=j>>>a;if(b&3|0){b=(b&1^1)+a|0;d=1148520+(b<<1<<2)|0;e=d+8|0;f=c[e>>2]|0;g=f+8|0;h=c[g>>2]|0;do if((d|0)!=(h|0)){if(h>>>0<(c[287124]|0)>>>0)Ba();a=h+12|0;if((c[a>>2]|0)==(f|0)){c[a>>2]=d;c[e>>2]=h;break}else Ba()}else c[287120]=j&~(1<<b);while(0);L=b<<3;c[f+4>>2]=L|3;L=f+L+4|0;c[L>>2]=c[L>>2]|1;L=g;return L|0}h=c[287122]|0;if(o>>>0>h>>>0){if(b|0){d=2<<a;d=b<<a&(d|0-d);d=(d&0-d)+-1|0;i=d>>>12&16;d=d>>>i;f=d>>>5&8;d=d>>>f;g=d>>>2&4;d=d>>>g;e=d>>>1&2;d=d>>>e;b=d>>>1&1;b=(f|i|g|e|b)+(d>>>b)|0;d=1148520+(b<<1<<2)|0;e=d+8|0;g=c[e>>2]|0;i=g+8|0;f=c[i>>2]|0;do if((d|0)!=(f|0)){if(f>>>0<(c[287124]|0)>>>0)Ba();a=f+12|0;if((c[a>>2]|0)==(g|0)){c[a>>2]=d;c[e>>2]=f;k=c[287122]|0;break}else Ba()}else{c[287120]=j&~(1<<b);k=h}while(0);h=(b<<3)-o|0;c[g+4>>2]=o|3;e=g+o|0;c[e+4>>2]=h|1;c[e+h>>2]=h;if(k|0){f=c[287125]|0;b=k>>>3;d=1148520+(b<<1<<2)|0;a=c[287120]|0;b=1<<b;if(a&b){a=d+8|0;b=c[a>>2]|0;if(b>>>0<(c[287124]|0)>>>0)Ba();else{l=a;m=b}}else{c[287120]=a|b;l=d+8|0;m=d}c[l>>2]=f;c[m+12>>2]=f;c[f+8>>2]=m;c[f+12>>2]=d}c[287122]=h;c[287125]=e;L=i;return L|0}a=c[287121]|0;if(a){d=(a&0-a)+-1|0;K=d>>>12&16;d=d>>>K;J=d>>>5&8;d=d>>>J;L=d>>>2&4;d=d>>>L;b=d>>>1&2;d=d>>>b;e=d>>>1&1;e=c[1148784+((J|K|L|b|e)+(d>>>e)<<2)>>2]|0;d=(c[e+4>>2]&-8)-o|0;b=e;while(1){a=c[b+16>>2]|0;if(!a){a=c[b+20>>2]|0;if(!a){j=e;break}}b=(c[a+4>>2]&-8)-o|0;L=b>>>0<d>>>0;d=L?b:d;b=a;e=L?a:e}g=c[287124]|0;if(j>>>0<g>>>0)Ba();i=j+o|0;if(j>>>0>=i>>>0)Ba();h=c[j+24>>2]|0;e=c[j+12>>2]|0;do if((e|0)==(j|0)){b=j+20|0;a=c[b>>2]|0;if(!a){b=j+16|0;a=c[b>>2]|0;if(!a){n=0;break}}while(1){e=a+20|0;f=c[e>>2]|0;if(f|0){a=f;b=e;continue}e=a+16|0;f=c[e>>2]|0;if(!f)break;else{a=f;b=e}}if(b>>>0<g>>>0)Ba();else{c[b>>2]=0;n=a;break}}else{f=c[j+8>>2]|0;if(f>>>0<g>>>0)Ba();a=f+12|0;if((c[a>>2]|0)!=(j|0))Ba();b=e+8|0;if((c[b>>2]|0)==(j|0)){c[a>>2]=e;c[b>>2]=f;n=e;break}else Ba()}while(0);do if(h|0){a=c[j+28>>2]|0;b=1148784+(a<<2)|0;if((j|0)==(c[b>>2]|0)){c[b>>2]=n;if(!n){c[287121]=c[287121]&~(1<<a);break}}else{if(h>>>0<(c[287124]|0)>>>0)Ba();a=h+16|0;if((c[a>>2]|0)==(j|0))c[a>>2]=n;else c[h+20>>2]=n;if(!n)break}b=c[287124]|0;if(n>>>0<b>>>0)Ba();c[n+24>>2]=h;a=c[j+16>>2]|0;do if(a|0)if(a>>>0<b>>>0)Ba();else{c[n+16>>2]=a;c[a+24>>2]=n;break}while(0);a=c[j+20>>2]|0;if(a|0)if(a>>>0<(c[287124]|0)>>>0)Ba();else{c[n+20>>2]=a;c[a+24>>2]=n;break}}while(0);if(d>>>0<16){L=d+o|0;c[j+4>>2]=L|3;L=j+L+4|0;c[L>>2]=c[L>>2]|1}else{c[j+4>>2]=o|3;c[i+4>>2]=d|1;c[i+d>>2]=d;a=c[287122]|0;if(a|0){f=c[287125]|0;b=a>>>3;e=1148520+(b<<1<<2)|0;a=c[287120]|0;b=1<<b;if(a&b){a=e+8|0;b=c[a>>2]|0;if(b>>>0<(c[287124]|0)>>>0)Ba();else{p=a;q=b}}else{c[287120]=a|b;p=e+8|0;q=e}c[p>>2]=f;c[q+12>>2]=f;c[f+8>>2]=q;c[f+12>>2]=e}c[287122]=d;c[287125]=i}L=j+8|0;return L|0}}}else if(a>>>0<=4294967231){a=a+11|0;o=a&-8;j=c[287121]|0;if(j){d=0-o|0;a=a>>>8;if(a)if(o>>>0>16777215)i=31;else{q=(a+1048320|0)>>>16&8;E=a<<q;p=(E+520192|0)>>>16&4;E=E<<p;i=(E+245760|0)>>>16&2;i=14-(p|q|i)+(E<<i>>>15)|0;i=o>>>(i+7|0)&1|i<<1}else i=0;b=c[1148784+(i<<2)>>2]|0;a:do if(!b){a=0;b=0;E=86}else{f=d;a=0;g=o<<((i|0)==31?0:25-(i>>>1)|0);h=b;b=0;while(1){e=c[h+4>>2]&-8;d=e-o|0;if(d>>>0<f>>>0)if((e|0)==(o|0)){a=h;b=h;E=90;break a}else b=h;else d=f;e=c[h+20>>2]|0;h=c[h+16+(g>>>31<<2)>>2]|0;a=(e|0)==0|(e|0)==(h|0)?a:e;e=(h|0)==0;if(e){E=86;break}else{f=d;g=g<<(e&1^1)}}}while(0);if((E|0)==86){if((a|0)==0&(b|0)==0){a=2<<i;a=j&(a|0-a);if(!a)break;q=(a&0-a)+-1|0;m=q>>>12&16;q=q>>>m;l=q>>>5&8;q=q>>>l;n=q>>>2&4;q=q>>>n;p=q>>>1&2;q=q>>>p;a=q>>>1&1;a=c[1148784+((l|m|n|p|a)+(q>>>a)<<2)>>2]|0}if(!a){i=d;j=b}else E=90}if((E|0)==90)while(1){E=0;q=(c[a+4>>2]&-8)-o|0;e=q>>>0<d>>>0;d=e?q:d;b=e?a:b;e=c[a+16>>2]|0;if(e|0){a=e;E=90;continue}a=c[a+20>>2]|0;if(!a){i=d;j=b;break}else E=90}if((j|0)!=0?i>>>0<((c[287122]|0)-o|0)>>>0:0){f=c[287124]|0;if(j>>>0<f>>>0)Ba();h=j+o|0;if(j>>>0>=h>>>0)Ba();g=c[j+24>>2]|0;d=c[j+12>>2]|0;do if((d|0)==(j|0)){b=j+20|0;a=c[b>>2]|0;if(!a){b=j+16|0;a=c[b>>2]|0;if(!a){s=0;break}}while(1){d=a+20|0;e=c[d>>2]|0;if(e|0){a=e;b=d;continue}d=a+16|0;e=c[d>>2]|0;if(!e)break;else{a=e;b=d}}if(b>>>0<f>>>0)Ba();else{c[b>>2]=0;s=a;break}}else{e=c[j+8>>2]|0;if(e>>>0<f>>>0)Ba();a=e+12|0;if((c[a>>2]|0)!=(j|0))Ba();b=d+8|0;if((c[b>>2]|0)==(j|0)){c[a>>2]=d;c[b>>2]=e;s=d;break}else Ba()}while(0);do if(g|0){a=c[j+28>>2]|0;b=1148784+(a<<2)|0;if((j|0)==(c[b>>2]|0)){c[b>>2]=s;if(!s){c[287121]=c[287121]&~(1<<a);break}}else{if(g>>>0<(c[287124]|0)>>>0)Ba();a=g+16|0;if((c[a>>2]|0)==(j|0))c[a>>2]=s;else c[g+20>>2]=s;if(!s)break}b=c[287124]|0;if(s>>>0<b>>>0)Ba();c[s+24>>2]=g;a=c[j+16>>2]|0;do if(a|0)if(a>>>0<b>>>0)Ba();else{c[s+16>>2]=a;c[a+24>>2]=s;break}while(0);a=c[j+20>>2]|0;if(a|0)if(a>>>0<(c[287124]|0)>>>0)Ba();else{c[s+20>>2]=a;c[a+24>>2]=s;break}}while(0);do if(i>>>0>=16){c[j+4>>2]=o|3;c[h+4>>2]=i|1;c[h+i>>2]=i;a=i>>>3;if(i>>>0<256){d=1148520+(a<<1<<2)|0;b=c[287120]|0;a=1<<a;if(b&a){a=d+8|0;b=c[a>>2]|0;if(b>>>0<(c[287124]|0)>>>0)Ba();else{u=a;v=b}}else{c[287120]=b|a;u=d+8|0;v=d}c[u>>2]=h;c[v+12>>2]=h;c[h+8>>2]=v;c[h+12>>2]=d;break}a=i>>>8;if(a)if(i>>>0>16777215)d=31;else{K=(a+1048320|0)>>>16&8;L=a<<K;J=(L+520192|0)>>>16&4;L=L<<J;d=(L+245760|0)>>>16&2;d=14-(J|K|d)+(L<<d>>>15)|0;d=i>>>(d+7|0)&1|d<<1}else d=0;e=1148784+(d<<2)|0;c[h+28>>2]=d;a=h+16|0;c[a+4>>2]=0;c[a>>2]=0;a=c[287121]|0;b=1<<d;if(!(a&b)){c[287121]=a|b;c[e>>2]=h;c[h+24>>2]=e;c[h+12>>2]=h;c[h+8>>2]=h;break}f=i<<((d|0)==31?0:25-(d>>>1)|0);a=c[e>>2]|0;while(1){if((c[a+4>>2]&-8|0)==(i|0)){d=a;E=148;break}b=a+16+(f>>>31<<2)|0;d=c[b>>2]|0;if(!d){E=145;break}else{f=f<<1;a=d}}if((E|0)==145)if(b>>>0<(c[287124]|0)>>>0)Ba();else{c[b>>2]=h;c[h+24>>2]=a;c[h+12>>2]=h;c[h+8>>2]=h;break}else if((E|0)==148){a=d+8|0;b=c[a>>2]|0;L=c[287124]|0;if(b>>>0>=L>>>0&d>>>0>=L>>>0){c[b+12>>2]=h;c[a>>2]=h;c[h+8>>2]=b;c[h+12>>2]=d;c[h+24>>2]=0;break}else Ba()}}else{L=i+o|0;c[j+4>>2]=L|3;L=j+L+4|0;c[L>>2]=c[L>>2]|1}while(0);L=j+8|0;return L|0}}}else o=-1;while(0);d=c[287122]|0;if(d>>>0>=o>>>0){a=d-o|0;b=c[287125]|0;if(a>>>0>15){L=b+o|0;c[287125]=L;c[287122]=a;c[L+4>>2]=a|1;c[L+a>>2]=a;c[b+4>>2]=o|3}else{c[287122]=0;c[287125]=0;c[b+4>>2]=d|3;L=b+d+4|0;c[L>>2]=c[L>>2]|1}L=b+8|0;return L|0}a=c[287123]|0;if(a>>>0>o>>>0){J=a-o|0;c[287123]=J;L=c[287126]|0;K=L+o|0;c[287126]=K;c[K+4>>2]=J|1;c[L+4>>2]=o|3;L=L+8|0;return L|0}do if(!(c[287238]|0)){a=Ua(30)|0;if(!(a+-1&a)){c[287240]=a;c[287239]=a;c[287241]=-1;c[287242]=-1;c[287243]=0;c[287231]=0;c[287238]=(pb(0)|0)&-16^1431655768;break}else Ba()}while(0);h=o+48|0;g=c[287240]|0;i=o+47|0;f=g+i|0;g=0-g|0;j=f&g;if(j>>>0<=o>>>0){L=0;return L|0}a=c[287230]|0;if(a|0?(u=c[287228]|0,v=u+j|0,v>>>0<=u>>>0|v>>>0>a>>>0):0){L=0;return L|0}b:do if(!(c[287231]&4)){a=c[287126]|0;c:do if(a){d=1148928;while(1){b=c[d>>2]|0;if(b>>>0<=a>>>0?(r=d+4|0,(b+(c[r>>2]|0)|0)>>>0>a>>>0):0){e=d;d=r;break}d=c[d+8>>2]|0;if(!d){E=173;break c}}a=f-(c[287123]|0)&g;if(a>>>0<2147483647){b=Oa(a|0)|0;if((b|0)==((c[e>>2]|0)+(c[d>>2]|0)|0)){if((b|0)!=(-1|0)){h=b;f=a;E=193;break b}}else E=183}}else E=173;while(0);do if((E|0)==173?(t=Oa(0)|0,(t|0)!=(-1|0)):0){a=t;b=c[287239]|0;d=b+-1|0;if(!(d&a))a=j;else a=j-a+(d+a&0-b)|0;b=c[287228]|0;d=b+a|0;if(a>>>0>o>>>0&a>>>0<2147483647){v=c[287230]|0;if(v|0?d>>>0<=b>>>0|d>>>0>v>>>0:0)break;b=Oa(a|0)|0;if((b|0)==(t|0)){h=t;f=a;E=193;break b}else E=183}}while(0);d:do if((E|0)==183){d=0-a|0;do if(h>>>0>a>>>0&(a>>>0<2147483647&(b|0)!=(-1|0))?(w=c[287240]|0,w=i-a+w&0-w,w>>>0<2147483647):0)if((Oa(w|0)|0)==(-1|0)){Oa(d|0)|0;break d}else{a=w+a|0;break}while(0);if((b|0)!=(-1|0)){h=b;f=a;E=193;break b}}while(0);c[287231]=c[287231]|4;E=190}else E=190;while(0);if((((E|0)==190?j>>>0<2147483647:0)?(x=Oa(j|0)|0,y=Oa(0)|0,x>>>0<y>>>0&((x|0)!=(-1|0)&(y|0)!=(-1|0))):0)?(z=y-x|0,z>>>0>(o+40|0)>>>0):0){h=x;f=z;E=193}if((E|0)==193){a=(c[287228]|0)+f|0;c[287228]=a;if(a>>>0>(c[287229]|0)>>>0)c[287229]=a;i=c[287126]|0;do if(i){e=1148928;do{a=c[e>>2]|0;b=e+4|0;d=c[b>>2]|0;if((h|0)==(a+d|0)){A=a;B=b;C=d;D=e;E=203;break}e=c[e+8>>2]|0}while((e|0)!=0);if(((E|0)==203?(c[D+12>>2]&8|0)==0:0)?i>>>0<h>>>0&i>>>0>=A>>>0:0){c[B>>2]=C+f;L=i+8|0;L=(L&7|0)==0?0:0-L&7;K=i+L|0;L=f-L+(c[287123]|0)|0;c[287126]=K;c[287123]=L;c[K+4>>2]=L|1;c[K+L+4>>2]=40;c[287127]=c[287242];break}a=c[287124]|0;if(h>>>0<a>>>0){c[287124]=h;j=h}else j=a;d=h+f|0;a=1148928;while(1){if((c[a>>2]|0)==(d|0)){b=a;E=211;break}a=c[a+8>>2]|0;if(!a){b=1148928;break}}if((E|0)==211)if(!(c[a+12>>2]&8)){c[b>>2]=h;l=a+4|0;c[l>>2]=(c[l>>2]|0)+f;l=h+8|0;l=h+((l&7|0)==0?0:0-l&7)|0;a=d+8|0;a=d+((a&7|0)==0?0:0-a&7)|0;k=l+o|0;g=a-l-o|0;c[l+4>>2]=o|3;do if((a|0)!=(i|0)){if((a|0)==(c[287125]|0)){L=(c[287122]|0)+g|0;c[287122]=L;c[287125]=k;c[k+4>>2]=L|1;c[k+L>>2]=L;break}b=c[a+4>>2]|0;if((b&3|0)==1){i=b&-8;f=b>>>3;e:do if(b>>>0>=256){h=c[a+24>>2]|0;e=c[a+12>>2]|0;do if((e|0)==(a|0)){d=a+16|0;e=d+4|0;b=c[e>>2]|0;if(!b){b=c[d>>2]|0;if(!b){J=0;break}}else d=e;while(1){e=b+20|0;f=c[e>>2]|0;if(f|0){b=f;d=e;continue}e=b+16|0;f=c[e>>2]|0;if(!f)break;else{b=f;d=e}}if(d>>>0<j>>>0)Ba();else{c[d>>2]=0;J=b;break}}else{f=c[a+8>>2]|0;if(f>>>0<j>>>0)Ba();b=f+12|0;if((c[b>>2]|0)!=(a|0))Ba();d=e+8|0;if((c[d>>2]|0)==(a|0)){c[b>>2]=e;c[d>>2]=f;J=e;break}else Ba()}while(0);if(!h)break;b=c[a+28>>2]|0;d=1148784+(b<<2)|0;do if((a|0)!=(c[d>>2]|0)){if(h>>>0<(c[287124]|0)>>>0)Ba();b=h+16|0;if((c[b>>2]|0)==(a|0))c[b>>2]=J;else c[h+20>>2]=J;if(!J)break e}else{c[d>>2]=J;if(J|0)break;c[287121]=c[287121]&~(1<<b);break e}while(0);e=c[287124]|0;if(J>>>0<e>>>0)Ba();c[J+24>>2]=h;b=a+16|0;d=c[b>>2]|0;do if(d|0)if(d>>>0<e>>>0)Ba();else{c[J+16>>2]=d;c[d+24>>2]=J;break}while(0);b=c[b+4>>2]|0;if(!b)break;if(b>>>0<(c[287124]|0)>>>0)Ba();else{c[J+20>>2]=b;c[b+24>>2]=J;break}}else{d=c[a+8>>2]|0;e=c[a+12>>2]|0;b=1148520+(f<<1<<2)|0;do if((d|0)!=(b|0)){if(d>>>0<j>>>0)Ba();if((c[d+12>>2]|0)==(a|0))break;Ba()}while(0);if((e|0)==(d|0)){c[287120]=c[287120]&~(1<<f);break}do if((e|0)==(b|0))G=e+8|0;else{if(e>>>0<j>>>0)Ba();b=e+8|0;if((c[b>>2]|0)==(a|0)){G=b;break}Ba()}while(0);c[d+12>>2]=e;c[G>>2]=d}while(0);a=a+i|0;g=i+g|0}a=a+4|0;c[a>>2]=c[a>>2]&-2;c[k+4>>2]=g|1;c[k+g>>2]=g;a=g>>>3;if(g>>>0<256){d=1148520+(a<<1<<2)|0;b=c[287120]|0;a=1<<a;do if(!(b&a)){c[287120]=b|a;K=d+8|0;L=d}else{a=d+8|0;b=c[a>>2]|0;if(b>>>0>=(c[287124]|0)>>>0){K=a;L=b;break}Ba()}while(0);c[K>>2]=k;c[L+12>>2]=k;c[k+8>>2]=L;c[k+12>>2]=d;break}a=g>>>8;do if(!a)d=0;else{if(g>>>0>16777215){d=31;break}K=(a+1048320|0)>>>16&8;L=a<<K;J=(L+520192|0)>>>16&4;L=L<<J;d=(L+245760|0)>>>16&2;d=14-(J|K|d)+(L<<d>>>15)|0;d=g>>>(d+7|0)&1|d<<1}while(0);e=1148784+(d<<2)|0;c[k+28>>2]=d;a=k+16|0;c[a+4>>2]=0;c[a>>2]=0;a=c[287121]|0;b=1<<d;if(!(a&b)){c[287121]=a|b;c[e>>2]=k;c[k+24>>2]=e;c[k+12>>2]=k;c[k+8>>2]=k;break}f=g<<((d|0)==31?0:25-(d>>>1)|0);a=c[e>>2]|0;while(1){if((c[a+4>>2]&-8|0)==(g|0)){d=a;E=281;break}b=a+16+(f>>>31<<2)|0;d=c[b>>2]|0;if(!d){E=278;break}else{f=f<<1;a=d}}if((E|0)==278)if(b>>>0<(c[287124]|0)>>>0)Ba();else{c[b>>2]=k;c[k+24>>2]=a;c[k+12>>2]=k;c[k+8>>2]=k;break}else if((E|0)==281){a=d+8|0;b=c[a>>2]|0;L=c[287124]|0;if(b>>>0>=L>>>0&d>>>0>=L>>>0){c[b+12>>2]=k;c[a>>2]=k;c[k+8>>2]=b;c[k+12>>2]=d;c[k+24>>2]=0;break}else Ba()}}else{L=(c[287123]|0)+g|0;c[287123]=L;c[287126]=k;c[k+4>>2]=L|1}while(0);L=l+8|0;return L|0}else b=1148928;while(1){a=c[b>>2]|0;if(a>>>0<=i>>>0?(F=a+(c[b+4>>2]|0)|0,F>>>0>i>>>0):0){b=F;break}b=c[b+8>>2]|0}g=b+-47|0;d=g+8|0;d=g+((d&7|0)==0?0:0-d&7)|0;g=i+16|0;d=d>>>0<g>>>0?i:d;a=d+8|0;e=h+8|0;e=(e&7|0)==0?0:0-e&7;L=h+e|0;e=f+-40-e|0;c[287126]=L;c[287123]=e;c[L+4>>2]=e|1;c[L+e+4>>2]=40;c[287127]=c[287242];e=d+4|0;c[e>>2]=27;c[a>>2]=c[287232];c[a+4>>2]=c[287233];c[a+8>>2]=c[287234];c[a+12>>2]=c[287235];c[287232]=h;c[287233]=f;c[287235]=0;c[287234]=a;a=d+24|0;do{a=a+4|0;c[a>>2]=7}while((a+4|0)>>>0<b>>>0);if((d|0)!=(i|0)){h=d-i|0;c[e>>2]=c[e>>2]&-2;c[i+4>>2]=h|1;c[d>>2]=h;a=h>>>3;if(h>>>0<256){d=1148520+(a<<1<<2)|0;b=c[287120]|0;a=1<<a;if(b&a){a=d+8|0;b=c[a>>2]|0;if(b>>>0<(c[287124]|0)>>>0)Ba();else{H=a;I=b}}else{c[287120]=b|a;H=d+8|0;I=d}c[H>>2]=i;c[I+12>>2]=i;c[i+8>>2]=I;c[i+12>>2]=d;break}a=h>>>8;if(a)if(h>>>0>16777215)d=31;else{K=(a+1048320|0)>>>16&8;L=a<<K;J=(L+520192|0)>>>16&4;L=L<<J;d=(L+245760|0)>>>16&2;d=14-(J|K|d)+(L<<d>>>15)|0;d=h>>>(d+7|0)&1|d<<1}else d=0;f=1148784+(d<<2)|0;c[i+28>>2]=d;c[i+20>>2]=0;c[g>>2]=0;a=c[287121]|0;b=1<<d;if(!(a&b)){c[287121]=a|b;c[f>>2]=i;c[i+24>>2]=f;c[i+12>>2]=i;c[i+8>>2]=i;break}e=h<<((d|0)==31?0:25-(d>>>1)|0);a=c[f>>2]|0;while(1){if((c[a+4>>2]&-8|0)==(h|0)){d=a;E=307;break}b=a+16+(e>>>31<<2)|0;d=c[b>>2]|0;if(!d){E=304;break}else{e=e<<1;a=d}}if((E|0)==304)if(b>>>0<(c[287124]|0)>>>0)Ba();else{c[b>>2]=i;c[i+24>>2]=a;c[i+12>>2]=i;c[i+8>>2]=i;break}else if((E|0)==307){a=d+8|0;b=c[a>>2]|0;L=c[287124]|0;if(b>>>0>=L>>>0&d>>>0>=L>>>0){c[b+12>>2]=i;c[a>>2]=i;c[i+8>>2]=b;c[i+12>>2]=d;c[i+24>>2]=0;break}else Ba()}}}else{L=c[287124]|0;if((L|0)==0|h>>>0<L>>>0)c[287124]=h;c[287232]=h;c[287233]=f;c[287235]=0;c[287129]=c[287238];c[287128]=-1;a=0;do{L=1148520+(a<<1<<2)|0;c[L+12>>2]=L;c[L+8>>2]=L;a=a+1|0}while((a|0)!=32);L=h+8|0;L=(L&7|0)==0?0:0-L&7;K=h+L|0;L=f+-40-L|0;c[287126]=K;c[287123]=L;c[K+4>>2]=L|1;c[K+L+4>>2]=40;c[287127]=c[287242]}while(0);a=c[287123]|0;if(a>>>0>o>>>0){J=a-o|0;c[287123]=J;L=c[287126]|0;K=L+o|0;c[287126]=K;c[K+4>>2]=J|1;c[L+4>>2]=o|3;L=L+8|0;return L|0}}c[(Dh()|0)>>2]=12;L=0;return L|0}function Aj(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;if(!a)return;d=a+-8|0;h=c[287124]|0;if(d>>>0<h>>>0)Ba();a=c[a+-4>>2]|0;b=a&3;if((b|0)==1)Ba();e=a&-8;m=d+e|0;do if(!(a&1)){a=c[d>>2]|0;if(!b)return;k=d+(0-a)|0;j=a+e|0;if(k>>>0<h>>>0)Ba();if((k|0)==(c[287125]|0)){a=m+4|0;b=c[a>>2]|0;if((b&3|0)!=3){q=k;g=j;break}c[287122]=j;c[a>>2]=b&-2;c[k+4>>2]=j|1;c[k+j>>2]=j;return}e=a>>>3;if(a>>>0<256){b=c[k+8>>2]|0;d=c[k+12>>2]|0;a=1148520+(e<<1<<2)|0;if((b|0)!=(a|0)){if(b>>>0<h>>>0)Ba();if((c[b+12>>2]|0)!=(k|0))Ba()}if((d|0)==(b|0)){c[287120]=c[287120]&~(1<<e);q=k;g=j;break}if((d|0)!=(a|0)){if(d>>>0<h>>>0)Ba();a=d+8|0;if((c[a>>2]|0)==(k|0))f=a;else Ba()}else f=d+8|0;c[b+12>>2]=d;c[f>>2]=b;q=k;g=j;break}f=c[k+24>>2]|0;d=c[k+12>>2]|0;do if((d|0)==(k|0)){b=k+16|0;d=b+4|0;a=c[d>>2]|0;if(!a){a=c[b>>2]|0;if(!a){i=0;break}}else b=d;while(1){d=a+20|0;e=c[d>>2]|0;if(e|0){a=e;b=d;continue}d=a+16|0;e=c[d>>2]|0;if(!e)break;else{a=e;b=d}}if(b>>>0<h>>>0)Ba();else{c[b>>2]=0;i=a;break}}else{e=c[k+8>>2]|0;if(e>>>0<h>>>0)Ba();a=e+12|0;if((c[a>>2]|0)!=(k|0))Ba();b=d+8|0;if((c[b>>2]|0)==(k|0)){c[a>>2]=d;c[b>>2]=e;i=d;break}else Ba()}while(0);if(f){a=c[k+28>>2]|0;b=1148784+(a<<2)|0;if((k|0)==(c[b>>2]|0)){c[b>>2]=i;if(!i){c[287121]=c[287121]&~(1<<a);q=k;g=j;break}}else{if(f>>>0<(c[287124]|0)>>>0)Ba();a=f+16|0;if((c[a>>2]|0)==(k|0))c[a>>2]=i;else c[f+20>>2]=i;if(!i){q=k;g=j;break}}d=c[287124]|0;if(i>>>0<d>>>0)Ba();c[i+24>>2]=f;a=k+16|0;b=c[a>>2]|0;do if(b|0)if(b>>>0<d>>>0)Ba();else{c[i+16>>2]=b;c[b+24>>2]=i;break}while(0);a=c[a+4>>2]|0;if(a)if(a>>>0<(c[287124]|0)>>>0)Ba();else{c[i+20>>2]=a;c[a+24>>2]=i;q=k;g=j;break}else{q=k;g=j}}else{q=k;g=j}}else{q=d;g=e}while(0);if(q>>>0>=m>>>0)Ba();a=m+4|0;b=c[a>>2]|0;if(!(b&1))Ba();if(!(b&2)){if((m|0)==(c[287126]|0)){p=(c[287123]|0)+g|0;c[287123]=p;c[287126]=q;c[q+4>>2]=p|1;if((q|0)!=(c[287125]|0))return;c[287125]=0;c[287122]=0;return}if((m|0)==(c[287125]|0)){p=(c[287122]|0)+g|0;c[287122]=p;c[287125]=q;c[q+4>>2]=p|1;c[q+p>>2]=p;return}g=(b&-8)+g|0;e=b>>>3;do if(b>>>0>=256){f=c[m+24>>2]|0;a=c[m+12>>2]|0;do if((a|0)==(m|0)){b=m+16|0;d=b+4|0;a=c[d>>2]|0;if(!a){a=c[b>>2]|0;if(!a){n=0;break}}else b=d;while(1){d=a+20|0;e=c[d>>2]|0;if(e|0){a=e;b=d;continue}d=a+16|0;e=c[d>>2]|0;if(!e)break;else{a=e;b=d}}if(b>>>0<(c[287124]|0)>>>0)Ba();else{c[b>>2]=0;n=a;break}}else{b=c[m+8>>2]|0;if(b>>>0<(c[287124]|0)>>>0)Ba();d=b+12|0;if((c[d>>2]|0)!=(m|0))Ba();e=a+8|0;if((c[e>>2]|0)==(m|0)){c[d>>2]=a;c[e>>2]=b;n=a;break}else Ba()}while(0);if(f|0){a=c[m+28>>2]|0;b=1148784+(a<<2)|0;if((m|0)==(c[b>>2]|0)){c[b>>2]=n;if(!n){c[287121]=c[287121]&~(1<<a);break}}else{if(f>>>0<(c[287124]|0)>>>0)Ba();a=f+16|0;if((c[a>>2]|0)==(m|0))c[a>>2]=n;else c[f+20>>2]=n;if(!n)break}d=c[287124]|0;if(n>>>0<d>>>0)Ba();c[n+24>>2]=f;a=m+16|0;b=c[a>>2]|0;do if(b|0)if(b>>>0<d>>>0)Ba();else{c[n+16>>2]=b;c[b+24>>2]=n;break}while(0);a=c[a+4>>2]|0;if(a|0)if(a>>>0<(c[287124]|0)>>>0)Ba();else{c[n+20>>2]=a;c[a+24>>2]=n;break}}}else{b=c[m+8>>2]|0;d=c[m+12>>2]|0;a=1148520+(e<<1<<2)|0;if((b|0)!=(a|0)){if(b>>>0<(c[287124]|0)>>>0)Ba();if((c[b+12>>2]|0)!=(m|0))Ba()}if((d|0)==(b|0)){c[287120]=c[287120]&~(1<<e);break}if((d|0)!=(a|0)){if(d>>>0<(c[287124]|0)>>>0)Ba();a=d+8|0;if((c[a>>2]|0)==(m|0))l=a;else Ba()}else l=d+8|0;c[b+12>>2]=d;c[l>>2]=b}while(0);c[q+4>>2]=g|1;c[q+g>>2]=g;if((q|0)==(c[287125]|0)){c[287122]=g;return}}else{c[a>>2]=b&-2;c[q+4>>2]=g|1;c[q+g>>2]=g}a=g>>>3;if(g>>>0<256){d=1148520+(a<<1<<2)|0;b=c[287120]|0;a=1<<a;if(b&a){a=d+8|0;b=c[a>>2]|0;if(b>>>0<(c[287124]|0)>>>0)Ba();else{o=a;p=b}}else{c[287120]=b|a;o=d+8|0;p=d}c[o>>2]=q;c[p+12>>2]=q;c[q+8>>2]=p;c[q+12>>2]=d;return}a=g>>>8;if(a)if(g>>>0>16777215)d=31;else{o=(a+1048320|0)>>>16&8;p=a<<o;n=(p+520192|0)>>>16&4;p=p<<n;d=(p+245760|0)>>>16&2;d=14-(n|o|d)+(p<<d>>>15)|0;d=g>>>(d+7|0)&1|d<<1}else d=0;e=1148784+(d<<2)|0;c[q+28>>2]=d;c[q+20>>2]=0;c[q+16>>2]=0;a=c[287121]|0;b=1<<d;do if(a&b){f=g<<((d|0)==31?0:25-(d>>>1)|0);a=c[e>>2]|0;while(1){if((c[a+4>>2]&-8|0)==(g|0)){d=a;e=130;break}b=a+16+(f>>>31<<2)|0;d=c[b>>2]|0;if(!d){e=127;break}else{f=f<<1;a=d}}if((e|0)==127)if(b>>>0<(c[287124]|0)>>>0)Ba();else{c[b>>2]=q;c[q+24>>2]=a;c[q+12>>2]=q;c[q+8>>2]=q;break}else if((e|0)==130){a=d+8|0;b=c[a>>2]|0;p=c[287124]|0;if(b>>>0>=p>>>0&d>>>0>=p>>>0){c[b+12>>2]=q;c[a>>2]=q;c[q+8>>2]=b;c[q+12>>2]=d;c[q+24>>2]=0;break}else Ba()}}else{c[287121]=a|b;c[e>>2]=q;c[q+24>>2]=e;c[q+12>>2]=q;c[q+8>>2]=q}while(0);q=(c[287128]|0)+-1|0;c[287128]=q;if(!q)a=1148936;else return;while(1){a=c[a>>2]|0;if(!a)break;else a=a+8|0}c[287128]=-1;return}function Bj(a,b){a=a|0;b=b|0;var d=0;if(a){d=_(b,a)|0;if((b|a)>>>0>65535)d=((d>>>0)/(a>>>0)|0|0)==(b|0)?d:-1}else d=0;b=zj(d)|0;if(!b)return b|0;if(!(c[b+-4>>2]&3))return b|0;Wu(b|0,0,d|0)|0;return b|0}function Cj(a,b){a=a|0;b=b|0;var d=0,e=0;if(!a){a=zj(b)|0;return a|0}if(b>>>0>4294967231){c[(Dh()|0)>>2]=12;a=0;return a|0}d=Dj(a+-8|0,b>>>0<11?16:b+11&-8)|0;if(d|0){a=d+8|0;return a|0}d=zj(b)|0;if(!d){a=0;return a|0}e=c[a+-4>>2]|0;e=(e&-8)-((e&3|0)==0?8:4)|0;_u(d|0,a|0,(e>>>0<b>>>0?e:b)|0)|0;Aj(a);a=d;return a|0}function Dj(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;n=a+4|0;o=c[n>>2]|0;d=o&-8;k=a+d|0;i=c[287124]|0;e=o&3;if(!((e|0)!=1&a>>>0>=i>>>0&a>>>0<k>>>0))Ba();f=c[k+4>>2]|0;if(!(f&1))Ba();if(!e){if(b>>>0<256){a=0;return a|0}if(d>>>0>=(b+4|0)>>>0?(d-b|0)>>>0<=c[287240]<<1>>>0:0)return a|0;a=0;return a|0}if(d>>>0>=b>>>0){d=d-b|0;if(d>>>0<=15)return a|0;m=a+b|0;c[n>>2]=o&1|b|2;c[m+4>>2]=d|3;b=m+d+4|0;c[b>>2]=c[b>>2]|1;Ej(m,d);return a|0}if((k|0)==(c[287126]|0)){d=(c[287123]|0)+d|0;if(d>>>0<=b>>>0){a=0;return a|0}m=d-b|0;l=a+b|0;c[n>>2]=o&1|b|2;c[l+4>>2]=m|1;c[287126]=l;c[287123]=m;return a|0}if((k|0)==(c[287125]|0)){e=(c[287122]|0)+d|0;if(e>>>0<b>>>0){a=0;return a|0}d=e-b|0;if(d>>>0>15){e=a+b|0;m=e+d|0;c[n>>2]=o&1|b|2;c[e+4>>2]=d|1;c[m>>2]=d;b=m+4|0;c[b>>2]=c[b>>2]&-2}else{c[n>>2]=o&1|e|2;e=a+e+4|0;c[e>>2]=c[e>>2]|1;e=0;d=0}c[287122]=d;c[287125]=e;return a|0}if(f&2|0){a=0;return a|0}l=(f&-8)+d|0;if(l>>>0<b>>>0){a=0;return a|0}m=l-b|0;g=f>>>3;do if(f>>>0>=256){h=c[k+24>>2]|0;f=c[k+12>>2]|0;do if((f|0)==(k|0)){e=k+16|0;f=e+4|0;d=c[f>>2]|0;if(!d){d=c[e>>2]|0;if(!d){j=0;break}}else e=f;while(1){f=d+20|0;g=c[f>>2]|0;if(g|0){d=g;e=f;continue}f=d+16|0;g=c[f>>2]|0;if(!g)break;else{d=g;e=f}}if(e>>>0<i>>>0)Ba();else{c[e>>2]=0;j=d;break}}else{g=c[k+8>>2]|0;if(g>>>0<i>>>0)Ba();d=g+12|0;if((c[d>>2]|0)!=(k|0))Ba();e=f+8|0;if((c[e>>2]|0)==(k|0)){c[d>>2]=f;c[e>>2]=g;j=f;break}else Ba()}while(0);if(h|0){d=c[k+28>>2]|0;e=1148784+(d<<2)|0;if((k|0)==(c[e>>2]|0)){c[e>>2]=j;if(!j){c[287121]=c[287121]&~(1<<d);break}}else{if(h>>>0<(c[287124]|0)>>>0)Ba();d=h+16|0;if((c[d>>2]|0)==(k|0))c[d>>2]=j;else c[h+20>>2]=j;if(!j)break}f=c[287124]|0;if(j>>>0<f>>>0)Ba();c[j+24>>2]=h;d=k+16|0;e=c[d>>2]|0;do if(e|0)if(e>>>0<f>>>0)Ba();else{c[j+16>>2]=e;c[e+24>>2]=j;break}while(0);d=c[d+4>>2]|0;if(d|0)if(d>>>0<(c[287124]|0)>>>0)Ba();else{c[j+20>>2]=d;c[d+24>>2]=j;break}}}else{e=c[k+8>>2]|0;f=c[k+12>>2]|0;d=1148520+(g<<1<<2)|0;if((e|0)!=(d|0)){if(e>>>0<i>>>0)Ba();if((c[e+12>>2]|0)!=(k|0))Ba()}if((f|0)==(e|0)){c[287120]=c[287120]&~(1<<g);break}if((f|0)!=(d|0)){if(f>>>0<i>>>0)Ba();d=f+8|0;if((c[d>>2]|0)==(k|0))h=d;else Ba()}else h=f+8|0;c[e+12>>2]=f;c[h>>2]=e}while(0);if(m>>>0<16){c[n>>2]=l|o&1|2;b=a+l+4|0;c[b>>2]=c[b>>2]|1;return a|0}else{l=a+b|0;c[n>>2]=o&1|b|2;c[l+4>>2]=m|3;b=l+m+4|0;c[b>>2]=c[b>>2]|1;Ej(l,m);return a|0}return 0}function Ej(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;o=a+b|0;d=c[a+4>>2]|0;do if(!(d&1)){f=c[a>>2]|0;if(!(d&3))return;l=a+(0-f)|0;k=f+b|0;i=c[287124]|0;if(l>>>0<i>>>0)Ba();if((l|0)==(c[287125]|0)){a=o+4|0;d=c[a>>2]|0;if((d&3|0)!=3){r=l;g=k;break}c[287122]=k;c[a>>2]=d&-2;c[l+4>>2]=k|1;c[l+k>>2]=k;return}e=f>>>3;if(f>>>0<256){a=c[l+8>>2]|0;b=c[l+12>>2]|0;d=1148520+(e<<1<<2)|0;if((a|0)!=(d|0)){if(a>>>0<i>>>0)Ba();if((c[a+12>>2]|0)!=(l|0))Ba()}if((b|0)==(a|0)){c[287120]=c[287120]&~(1<<e);r=l;g=k;break}if((b|0)!=(d|0)){if(b>>>0<i>>>0)Ba();d=b+8|0;if((c[d>>2]|0)==(l|0))h=d;else Ba()}else h=b+8|0;c[a+12>>2]=b;c[h>>2]=a;r=l;g=k;break}f=c[l+24>>2]|0;b=c[l+12>>2]|0;do if((b|0)==(l|0)){a=l+16|0;b=a+4|0;d=c[b>>2]|0;if(!d){d=c[a>>2]|0;if(!d){j=0;break}}else a=b;while(1){b=d+20|0;e=c[b>>2]|0;if(e|0){d=e;a=b;continue}b=d+16|0;e=c[b>>2]|0;if(!e)break;else{d=e;a=b}}if(a>>>0<i>>>0)Ba();else{c[a>>2]=0;j=d;break}}else{e=c[l+8>>2]|0;if(e>>>0<i>>>0)Ba();d=e+12|0;if((c[d>>2]|0)!=(l|0))Ba();a=b+8|0;if((c[a>>2]|0)==(l|0)){c[d>>2]=b;c[a>>2]=e;j=b;break}else Ba()}while(0);if(f){d=c[l+28>>2]|0;a=1148784+(d<<2)|0;if((l|0)==(c[a>>2]|0)){c[a>>2]=j;if(!j){c[287121]=c[287121]&~(1<<d);r=l;g=k;break}}else{if(f>>>0<(c[287124]|0)>>>0)Ba();d=f+16|0;if((c[d>>2]|0)==(l|0))c[d>>2]=j;else c[f+20>>2]=j;if(!j){r=l;g=k;break}}b=c[287124]|0;if(j>>>0<b>>>0)Ba();c[j+24>>2]=f;d=l+16|0;a=c[d>>2]|0;do if(a|0)if(a>>>0<b>>>0)Ba();else{c[j+16>>2]=a;c[a+24>>2]=j;break}while(0);d=c[d+4>>2]|0;if(d)if(d>>>0<(c[287124]|0)>>>0)Ba();else{c[j+20>>2]=d;c[d+24>>2]=j;r=l;g=k;break}else{r=l;g=k}}else{r=l;g=k}}else{r=a;g=b}while(0);h=c[287124]|0;if(o>>>0<h>>>0)Ba();d=o+4|0;a=c[d>>2]|0;if(!(a&2)){if((o|0)==(c[287126]|0)){q=(c[287123]|0)+g|0;c[287123]=q;c[287126]=r;c[r+4>>2]=q|1;if((r|0)!=(c[287125]|0))return;c[287125]=0;c[287122]=0;return}if((o|0)==(c[287125]|0)){q=(c[287122]|0)+g|0;c[287122]=q;c[287125]=r;c[r+4>>2]=q|1;c[r+q>>2]=q;return}g=(a&-8)+g|0;e=a>>>3;do if(a>>>0>=256){f=c[o+24>>2]|0;b=c[o+12>>2]|0;do if((b|0)==(o|0)){a=o+16|0;b=a+4|0;d=c[b>>2]|0;if(!d){d=c[a>>2]|0;if(!d){n=0;break}}else a=b;while(1){b=d+20|0;e=c[b>>2]|0;if(e|0){d=e;a=b;continue}b=d+16|0;e=c[b>>2]|0;if(!e)break;else{d=e;a=b}}if(a>>>0<h>>>0)Ba();else{c[a>>2]=0;n=d;break}}else{e=c[o+8>>2]|0;if(e>>>0<h>>>0)Ba();d=e+12|0;if((c[d>>2]|0)!=(o|0))Ba();a=b+8|0;if((c[a>>2]|0)==(o|0)){c[d>>2]=b;c[a>>2]=e;n=b;break}else Ba()}while(0);if(f|0){d=c[o+28>>2]|0;a=1148784+(d<<2)|0;if((o|0)==(c[a>>2]|0)){c[a>>2]=n;if(!n){c[287121]=c[287121]&~(1<<d);break}}else{if(f>>>0<(c[287124]|0)>>>0)Ba();d=f+16|0;if((c[d>>2]|0)==(o|0))c[d>>2]=n;else c[f+20>>2]=n;if(!n)break}b=c[287124]|0;if(n>>>0<b>>>0)Ba();c[n+24>>2]=f;d=o+16|0;a=c[d>>2]|0;do if(a|0)if(a>>>0<b>>>0)Ba();else{c[n+16>>2]=a;c[a+24>>2]=n;break}while(0);d=c[d+4>>2]|0;if(d|0)if(d>>>0<(c[287124]|0)>>>0)Ba();else{c[n+20>>2]=d;c[d+24>>2]=n;break}}}else{a=c[o+8>>2]|0;b=c[o+12>>2]|0;d=1148520+(e<<1<<2)|0;if((a|0)!=(d|0)){if(a>>>0<h>>>0)Ba();if((c[a+12>>2]|0)!=(o|0))Ba()}if((b|0)==(a|0)){c[287120]=c[287120]&~(1<<e);break}if((b|0)!=(d|0)){if(b>>>0<h>>>0)Ba();d=b+8|0;if((c[d>>2]|0)==(o|0))m=d;else Ba()}else m=b+8|0;c[a+12>>2]=b;c[m>>2]=a}while(0);c[r+4>>2]=g|1;c[r+g>>2]=g;if((r|0)==(c[287125]|0)){c[287122]=g;return}}else{c[d>>2]=a&-2;c[r+4>>2]=g|1;c[r+g>>2]=g}d=g>>>3;if(g>>>0<256){b=1148520+(d<<1<<2)|0;a=c[287120]|0;d=1<<d;if(a&d){d=b+8|0;a=c[d>>2]|0;if(a>>>0<(c[287124]|0)>>>0)Ba();else{p=d;q=a}}else{c[287120]=a|d;p=b+8|0;q=b}c[p>>2]=r;c[q+12>>2]=r;c[r+8>>2]=q;c[r+12>>2]=b;return}d=g>>>8;if(d)if(g>>>0>16777215)b=31;else{p=(d+1048320|0)>>>16&8;q=d<<p;o=(q+520192|0)>>>16&4;q=q<<o;b=(q+245760|0)>>>16&2;b=14-(o|p|b)+(q<<b>>>15)|0;b=g>>>(b+7|0)&1|b<<1}else b=0;e=1148784+(b<<2)|0;c[r+28>>2]=b;c[r+20>>2]=0;c[r+16>>2]=0;d=c[287121]|0;a=1<<b;if(!(d&a)){c[287121]=d|a;c[e>>2]=r;c[r+24>>2]=e;c[r+12>>2]=r;c[r+8>>2]=r;return}f=g<<((b|0)==31?0:25-(b>>>1)|0);d=c[e>>2]|0;while(1){if((c[d+4>>2]&-8|0)==(g|0)){b=d;e=127;break}a=d+16+(f>>>31<<2)|0;b=c[a>>2]|0;if(!b){e=124;break}else{f=f<<1;d=b}}if((e|0)==124){if(a>>>0<(c[287124]|0)>>>0)Ba();c[a>>2]=r;c[r+24>>2]=d;c[r+12>>2]=r;c[r+8>>2]=r;return}else if((e|0)==127){d=b+8|0;a=c[d>>2]|0;q=c[287124]|0;if(!(a>>>0>=q>>>0&b>>>0>=q>>>0))Ba();c[a+12>>2]=r;c[d>>2]=r;c[r+8>>2]=a;c[r+12>>2]=b;c[r+24>>2]=0;return}}function Fj(a){a=a|0;Ma(a|0)|0;return}function Gj(a){a=a|0;Ya(a|0)|0;return}function Hj(a,b){a=a|0;b=b|0;wa(a|0,c[b>>2]|0)|0;return}function Ij(){Jj(0);return}function Jj(a){a=a|0;var b=0,d=0,e=0;d=c[2056]|0;Kj(1149656,d,1149712);c[287244]=12184;c[287246]=12204;c[287245]=0;fm(1148984,1149656);c[287264]=0;c[287265]=-1;b=c[2026]|0;Rj(1149760,b,1149720);c[287266]=12264;c[287267]=12284;fm(1149068,1149760);c[287285]=0;c[287286]=-1;a=c[1997]|0;Rj(1149808,a,1149728);c[287287]=12264;c[287288]=12284;fm(1149152,1149808);c[287306]=0;c[287307]=-1;e=c[1149148+(c[(c[287287]|0)+-12>>2]|0)+24>>2]|0;c[287308]=12264;c[287309]=12284;fm(1149236,e);c[287327]=0;c[287328]=-1;c[1148976+(c[(c[287244]|0)+-12>>2]|0)+72>>2]=1149064;e=1149148+(c[(c[287287]|0)+-12>>2]|0)+4|0;c[e>>2]=c[e>>2]|8192;c[1149148+(c[(c[287287]|0)+-12>>2]|0)+72>>2]=1149064;Xj(1149856,d,1149736);c[287329]=12224;c[287331]=12244;c[287330]=0;fm(1149324,1149856);c[287349]=0;c[287350]=-1;ck(1149912,b,1149744);c[287351]=12304;c[287352]=12324;fm(1149408,1149912);c[287370]=0;c[287371]=-1;ck(1149960,a,1149752);c[287372]=12304;c[287373]=12324;fm(1149492,1149960);c[287391]=0;c[287392]=-1;a=c[1149488+(c[(c[287372]|0)+-12>>2]|0)+24>>2]|0;c[287393]=12304;c[287394]=12324;fm(1149576,a);c[287412]=0;c[287413]=-1;c[1149316+(c[(c[287329]|0)+-12>>2]|0)+72>>2]=1149404;a=1149488+(c[(c[287372]|0)+-12>>2]|0)+4|0;c[a>>2]=c[a>>2]|8192;c[1149488+(c[(c[287372]|0)+-12>>2]|0)+72>>2]=1149404;return}function Kj(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;f=i;i=i+16|0;h=f+4|0;g=f;hm(b);c[b>>2]=11780;c[b+32>>2]=d;c[b+40>>2]=e;c[b+48>>2]=-1;a[b+52>>0]=0;Zt(h,b+4|0);c[g>>2]=c[h>>2];Mj(b,g);_t(g);i=f;return}function Lj(a){a=a|0;il(a);mu(a);return}function Mj(b,d){b=b|0;d=d|0;var e=0,f=0;f=Om(d,1151892)|0;e=b+36|0;c[e>>2]=f;d=b+44|0;c[d>>2]=Fb[c[(c[f>>2]|0)+24>>2]&127](f)|0;e=c[e>>2]|0;a[b+53>>0]=(Fb[c[(c[e>>2]|0)+28>>2]&127](e)|0)&1;return}function Nj(a){a=a|0;return Oj(a,0)|0}function Oj(b,e){b=b|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0;t=i;i=i+32|0;r=t+16|0;q=t+8|0;n=t+4|0;o=t;h=b+52|0;if(a[h>>0]|0){g=b+48|0;f=c[g>>2]|0;if(e){c[g>>2]=-1;a[h>>0]=0}}else{f=c[b+44>>2]|0;f=(f|0)>1?f:1;p=b+32|0;h=0;while(1){if((h|0)>=(f|0)){s=8;break}g=Yi(c[p>>2]|0)|0;if((g|0)==-1){f=-1;break}a[r+h>>0]=g;h=h+1|0}if((s|0)==8){do if(!(a[b+53>>0]|0)){k=b+40|0;l=b+36|0;m=q+1|0;a:while(1){u=c[k>>2]|0;h=u;g=c[h>>2]|0;h=c[h+4>>2]|0;v=c[l>>2]|0;j=r+f|0;switch(Ib[c[(c[v>>2]|0)+16>>2]&15](v,u,r,j,n,q,m,o)|0){case 3:{s=15;break a}case 2:{s=17;break a}case 1:break;default:break a}v=c[k>>2]|0;c[v>>2]=g;c[v+4>>2]=h;if((f|0)==8){s=17;break}g=Yi(c[p>>2]|0)|0;if((g|0)==-1){s=17;break}a[j>>0]=g;f=f+1|0}if((s|0)==15)a[q>>0]=a[r>>0]|0;else if((s|0)==17){f=-1;break}s=18}else{a[q>>0]=a[r>>0]|0;s=18}while(0);b:do if((s|0)==18){if(e){f=a[q>>0]|0;c[b+48>>2]=f&255}else{while(1){if((f|0)<=0)break;f=f+-1|0;if((Hi(d[r+f>>0]|0,c[p>>2]|0)|0)==-1){f=-1;break b}}f=a[q>>0]|0}f=f&255}while(0)}}i=t;return f|0}function Pj(a){a=a|0;return Oj(a,1)|0}function Qj(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;l=i;i=i+32|0;j=l+16|0;h=l+4|0;f=l+8|0;g=l;k=b+52|0;e=(a[k>>0]|0)!=0;a:do if((d|0)==-1)if(e)d=-1;else{d=c[b+48>>2]|0;a[k>>0]=(d|0)!=-1&1}else{do if(e){e=b+48|0;a[f>>0]=c[e>>2];m=c[b+36>>2]|0;switch(Ib[c[(c[m>>2]|0)+12>>2]&15](m,c[b+40>>2]|0,f,f+1|0,g,j,j+8|0,h)|0){case 1:case 2:{d=-1;break a}case 3:{a[j>>0]=c[e>>2];c[h>>2]=j+1;break}default:{}}f=b+32|0;while(1){g=c[h>>2]|0;if(g>>>0<=j>>>0){f=13;break}m=g+-1|0;c[h>>2]=m;if((Hi(a[m>>0]|0,c[f>>2]|0)|0)==-1){f=12;break}}if((f|0)==12){d=-1;break a}else if((f|0)==13)break}else e=b+48|0;while(0);c[e>>2]=d;a[k>>0]=1}while(0);i=l;return d|0}function Rj(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;f=i;i=i+16|0;h=f+4|0;g=f;hm(b);c[b>>2]=11844;c[b+32>>2]=d;Zt(h,b+4|0);c[g>>2]=c[h>>2];d=Om(g,1151892)|0;_t(g);c[b+36>>2]=d;c[b+40>>2]=e;a[b+44>>0]=(Fb[c[(c[d>>2]|0)+28>>2]&127](d)|0)&1;i=f;return}function Sj(a){a=a|0;il(a);mu(a);return}function Tj(b,d){b=b|0;d=d|0;Fb[c[(c[b>>2]|0)+24>>2]&127](b)|0;d=Om(d,1151892)|0;c[b+36>>2]=d;a[b+44>>0]=(Fb[c[(c[d>>2]|0)+28>>2]&127](d)|0)&1;return}function Uj(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;l=i;i=i+16|0;j=l+8|0;h=l;d=a+36|0;e=a+40|0;f=j+8|0;g=j;b=a+32|0;a:while(1){a=c[d>>2]|0;a=Mb[c[(c[a>>2]|0)+20>>2]&31](a,c[e>>2]|0,j,f,h)|0;m=(c[h>>2]|0)-g|0;if((Fi(j,1,m,c[b>>2]|0)|0)!=(m|0)){a=-1;break}switch(a|0){case 1:break;case 2:{a=-1;break a}default:{k=4;break a}}}if((k|0)==4)a=((Di(c[b>>2]|0)|0)!=0)<<31>>31;i=l;return a|0}function Vj(b,e,f){b=b|0;e=e|0;f=f|0;var g=0;a:do if(!(a[b+44>>0]|0)){g=e;e=0;while(1){if((e|0)>=(f|0))break a;if((Lb[c[(c[b>>2]|0)+52>>2]&63](b,d[g>>0]|0)|0)==-1)break a;g=g+1|0;e=e+1|0}}else e=Fi(e,1,f,c[b+32>>2]|0)|0;while(0);return e|0}function Wj(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;q=i;i=i+32|0;o=q+16|0;e=q+8|0;n=q+4|0;m=q;p=(d|0)==-1;do if(!p){a[e>>0]=d;if(a[b+44>>0]|0)if((Fi(e,1,1,c[b+32>>2]|0)|0)==1){f=14;break}else{e=-1;break}c[n>>2]=o;l=e+1|0;g=b+36|0;h=b+40|0;j=o+8|0;k=o;b=b+32|0;while(1){f=c[g>>2]|0;f=Ib[c[(c[f>>2]|0)+12>>2]&15](f,c[h>>2]|0,e,l,m,o,j,n)|0;if((c[m>>2]|0)==(e|0)){f=13;break}if((f|0)==3){f=7;break}if((f|1|0)!=1){f=13;break}e=(c[n>>2]|0)-k|0;if((Fi(o,1,e,c[b>>2]|0)|0)!=(e|0)){f=13;break}if((f|0)==1)e=c[m>>2]|0;else{f=12;break}}if((f|0)==7)if((Fi(e,1,1,c[b>>2]|0)|0)==1)f=12;else f=13;if((f|0)==12){f=14;break}else if((f|0)==13){e=-1;break}}else f=14;while(0);if((f|0)==14)e=p?0:d;i=q;return e|0}function Xj(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;f=i;i=i+16|0;h=f+4|0;g=f;im(b);c[b>>2]=11908;c[b+32>>2]=d;c[b+40>>2]=e;c[b+48>>2]=-1;a[b+52>>0]=0;Zt(h,b+4|0);c[g>>2]=c[h>>2];Zj(b,g);_t(g);i=f;return}function Yj(a){a=a|0;wl(a);mu(a);return}function Zj(b,d){b=b|0;d=d|0;var e=0,f=0;f=Om(d,1151900)|0;e=b+36|0;c[e>>2]=f;d=b+44|0;c[d>>2]=Fb[c[(c[f>>2]|0)+24>>2]&127](f)|0;e=c[e>>2]|0;a[b+53>>0]=(Fb[c[(c[e>>2]|0)+28>>2]&127](e)|0)&1;return}function _j(a){a=a|0;return $j(a,0)|0}function $j(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0;s=i;i=i+32|0;q=s+16|0;p=s+8|0;m=s+4|0;n=s;g=b+52|0;if(a[g>>0]|0){f=b+48|0;e=c[f>>2]|0;if(d){c[f>>2]=-1;a[g>>0]=0}}else{e=c[b+44>>2]|0;e=(e|0)>1?e:1;o=b+32|0;g=0;while(1){if((g|0)>=(e|0)){r=8;break}f=Yi(c[o>>2]|0)|0;if((f|0)==-1){e=-1;break}a[q+g>>0]=f;g=g+1|0}if((r|0)==8){do if(!(a[b+53>>0]|0)){j=b+40|0;k=b+36|0;l=p+4|0;a:while(1){t=c[j>>2]|0;g=t;f=c[g>>2]|0;g=c[g+4>>2]|0;u=c[k>>2]|0;h=q+e|0;switch(Ib[c[(c[u>>2]|0)+16>>2]&15](u,t,q,h,m,p,l,n)|0){case 3:{r=15;break a}case 2:{r=17;break a}case 1:break;default:break a}u=c[j>>2]|0;c[u>>2]=f;c[u+4>>2]=g;if((e|0)==8){r=17;break}f=Yi(c[o>>2]|0)|0;if((f|0)==-1){r=17;break}a[h>>0]=f;e=e+1|0}if((r|0)==15)c[p>>2]=a[q>>0];else if((r|0)==17){e=-1;break}r=18}else{c[p>>2]=a[q>>0];r=18}while(0);b:do if((r|0)==18){if(d){e=c[p>>2]|0;c[b+48>>2]=e;break}while(1){if((e|0)<=0)break;e=e+-1|0;if((Hi(a[q+e>>0]|0,c[o>>2]|0)|0)==-1){e=-1;break b}}e=c[p>>2]|0}while(0)}}i=s;return e|0}function ak(a){a=a|0;return $j(a,1)|0}function bk(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;l=i;i=i+32|0;j=l+16|0;h=l+8|0;f=l+4|0;g=l;k=b+52|0;e=(a[k>>0]|0)!=0;a:do if((d|0)==-1)if(e)d=-1;else{d=c[b+48>>2]|0;a[k>>0]=(d|0)!=-1&1}else{do if(e){e=b+48|0;c[f>>2]=c[e>>2];m=c[b+36>>2]|0;switch(Ib[c[(c[m>>2]|0)+12>>2]&15](m,c[b+40>>2]|0,f,f+4|0,g,j,j+8|0,h)|0){case 1:case 2:{d=-1;break a}case 3:{a[j>>0]=c[e>>2];c[h>>2]=j+1;break}default:{}}f=b+32|0;while(1){g=c[h>>2]|0;if(g>>>0<=j>>>0){f=13;break}m=g+-1|0;c[h>>2]=m;if((Hi(a[m>>0]|0,c[f>>2]|0)|0)==-1){f=12;break}}if((f|0)==12){d=-1;break a}else if((f|0)==13)break}else e=b+48|0;while(0);c[e>>2]=d;a[k>>0]=1}while(0);i=l;return d|0}function ck(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;f=i;i=i+16|0;h=f+4|0;g=f;im(b);c[b>>2]=11972;c[b+32>>2]=d;Zt(h,b+4|0);c[g>>2]=c[h>>2];d=Om(g,1151900)|0;_t(g);c[b+36>>2]=d;c[b+40>>2]=e;a[b+44>>0]=(Fb[c[(c[d>>2]|0)+28>>2]&127](d)|0)&1;i=f;return}function dk(a){a=a|0;wl(a);mu(a);return}function ek(b,d){b=b|0;d=d|0;Fb[c[(c[b>>2]|0)+24>>2]&127](b)|0;d=Om(d,1151900)|0;c[b+36>>2]=d;a[b+44>>0]=(Fb[c[(c[d>>2]|0)+28>>2]&127](d)|0)&1;return}function fk(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;l=i;i=i+16|0;j=l+8|0;h=l;d=a+36|0;e=a+40|0;f=j+8|0;g=j;b=a+32|0;a:while(1){a=c[d>>2]|0;a=Mb[c[(c[a>>2]|0)+20>>2]&31](a,c[e>>2]|0,j,f,h)|0;m=(c[h>>2]|0)-g|0;if((Fi(j,1,m,c[b>>2]|0)|0)!=(m|0)){a=-1;break}switch(a|0){case 1:break;case 2:{a=-1;break a}default:{k=4;break a}}}if((k|0)==4)a=((Di(c[b>>2]|0)|0)!=0)<<31>>31;i=l;return a|0}function gk(b,d,e){b=b|0;d=d|0;e=e|0;var f=0;a:do if(!(a[b+44>>0]|0)){f=d;d=0;while(1){if((d|0)>=(e|0))break a;if((Lb[c[(c[b>>2]|0)+52>>2]&63](b,c[f>>2]|0)|0)==-1)break a;f=f+4|0;d=d+1|0}}else d=Fi(d,4,e,c[b+32>>2]|0)|0;while(0);return d|0}function hk(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;q=i;i=i+32|0;o=q+16|0;e=q+8|0;n=q+4|0;m=q;p=(d|0)==-1;do if(!p){c[e>>2]=d;if(a[b+44>>0]|0)if((Fi(e,4,1,c[b+32>>2]|0)|0)==1){f=14;break}else{e=-1;break}c[n>>2]=o;k=e+4|0;l=b+36|0;g=b+40|0;h=o+8|0;j=o;b=b+32|0;while(1){f=c[l>>2]|0;f=Ib[c[(c[f>>2]|0)+12>>2]&15](f,c[g>>2]|0,e,k,m,o,h,n)|0;if((c[m>>2]|0)==(e|0)){f=13;break}if((f|0)==3){f=7;break}if((f|1|0)!=1){f=13;break}e=(c[n>>2]|0)-j|0;if((Fi(o,1,e,c[b>>2]|0)|0)!=(e|0)){f=13;break}if((f|0)==1)e=c[m>>2]|0;else{f=12;break}}if((f|0)==7)if((Fi(e,1,1,c[b>>2]|0)|0)==1)f=12;else f=13;if((f|0)==12){f=14;break}else if((f|0)==13){e=-1;break}}else f=14;while(0);if((f|0)==14)e=p?0:d;i=q;return e|0}function ik(){return}function jk(a,b){a=a|0;b=b|0;return}function kk(a){a=a|0;_a(a|0)|0;return}function lk(a){a=a|0;qb(a|0)|0;return}function mk(a){a=a|0;if(!($a(a|0)|0))return;else Fa(20417,20425,47,20508)}function nk(a,b,d){a=a|0;b=b|0;d=d|0;qb(1150008)|0;while(1){if((c[a>>2]|0)!=1)break;wa(1150036,1150008)|0}if(!(c[a>>2]|0)){c[a>>2]=1;$a(1150008)|0;Bb[d&255](b);qb(1150008)|0;c[a>>2]=-1;$a(1150008)|0;eb(1150036)|0}else $a(1150008)|0;return}function ok(a){a=a|0;Fa(20515,20544,1164,23435)}function pk(a){a=a|0;Fa(20628,20544,1175,23479)}function qk(b,d){b=b|0;d=d|0;if(!(a[d>>0]&1)){c[b>>2]=c[d>>2];c[b+4>>2]=c[d+4>>2];c[b+8>>2]=c[d+8>>2]}else rk(b,c[d+8>>2]|0,c[d+4>>2]|0);return}function rk(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0;if(e>>>0>4294967279)ok(b);if(e>>>0<11){a[b>>0]=e<<1;b=b+1|0}else{g=e+16&-16;f=Nu(g)|0;c[b+8>>2]=f;c[b>>2]=g|1;c[b+4>>2]=e;b=f}_u(b|0,d|0,e|0)|0;a[b+e>>0]=0;return}function sk(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0;if(d>>>0>4294967279)ok(b);if(d>>>0<11){a[b>>0]=d<<1;b=b+1|0}else{g=d+16&-16;f=Nu(g)|0;c[b+8>>2]=f;c[b>>2]=g|1;c[b+4>>2]=d;b=f}Wu(b|0,e|0,d|0)|0;a[b+d>>0]=0;return}function tk(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0;h=a[d>>0]|0;g=(h&1)==0;h=g?(h&255)>>>1:c[d+4>>2]|0;if(h>>>0<e>>>0)pk(b);else{h=h-e|0;rk(b,(g?d+1|0:c[d+8>>2]|0)+e|0,h>>>0<f>>>0?h:f);return}}function uk(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0;g=d;f=e-g|0;if(f>>>0>4294967279)ok(b);if(f>>>0<11){a[b>>0]=f<<1;h=b+1|0}else{i=f+16&-16;h=Nu(i)|0;c[b+8>>2]=h;c[b>>2]=i|1;c[b+4>>2]=f}b=e-g|0;f=h;while(1){if((d|0)==(e|0))break;a[f>>0]=a[d>>0]|0;d=d+1|0;f=f+1|0}a[h+b>>0]=0;return}function vk(b){b=b|0;if(a[b>>0]&1)mu(c[b+8>>2]|0);return}function wk(b,d){b=b|0;d=d|0;var e=0,f=0;if((b|0)!=(d|0)){e=a[d>>0]|0;f=(e&1)==0;xk(b,f?d+1|0:c[d+8>>2]|0,f?(e&255)>>>1:c[d+4>>2]|0)|0}return b|0}function xk(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;f=a[b>>0]|0;if(!(f&1))h=10;else{f=c[b>>2]|0;h=(f&-2)+-1|0;f=f&255}g=(f&1)==0;do if(h>>>0>=e>>>0){if(g)f=b+1|0;else f=c[b+8>>2]|0;$u(f|0,d|0,e|0)|0;a[f+e>>0]=0;if(!(a[b>>0]&1)){a[b>>0]=e<<1;break}else{c[b+4>>2]=e;break}}else{if(g)f=(f&255)>>>1;else f=c[b+4>>2]|0;yk(b,h,e-h|0,f,0,f,e,d)}while(0);return b|0}function yk(b,d,e,f,g,h,i,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;var k=0,l=0,m=0;if((-18-d|0)>>>0<e>>>0)ok(b);if(!(a[b>>0]&1))m=b+1|0;else m=c[b+8>>2]|0;if(d>>>0<2147483623){k=e+d|0;l=d<<1;k=k>>>0<l>>>0?l:k;k=k>>>0<11?11:k+16&-16}else k=-17;l=Nu(k)|0;if(g|0)_u(l|0,m|0,g|0)|0;if(i|0)_u(l+g|0,j|0,i|0)|0;e=f-h|0;if((e|0)!=(g|0))_u(l+g+i|0,m+g+h|0,e-g|0)|0;if((d|0)!=10)mu(m);c[b+8>>2]=l;c[b>>2]=k|1;d=e+i|0;c[b+4>>2]=d;a[l+d>>0]=0;return}function zk(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0;if(d>>>0>4294967279)ok(b);e=a[b>>0]|0;if(!(e&1))f=10;else{e=c[b>>2]|0;f=(e&-2)+-1|0;e=e&255}if(!(e&1))j=(e&255)>>>1;else j=c[b+4>>2]|0;d=j>>>0>d>>>0?j:d;if(d>>>0<11)i=10;else i=(d+16&-16)+-1|0;do if((i|0)!=(f|0)){do if((i|0)!=10){d=Nu(i+1|0)|0;if(!(e&1)){f=1;g=b+1|0;h=0;break}else{f=1;g=c[b+8>>2]|0;h=1;break}}else{d=b+1|0;f=0;g=c[b+8>>2]|0;h=1}while(0);if(!(e&1))e=(e&255)>>>1;else e=c[b+4>>2]|0;_u(d|0,g|0,e+1|0)|0;if(h)mu(g);if(f){c[b>>2]=i+1|1;c[b+4>>2]=j;c[b+8>>2]=d;break}else{a[b>>0]=j<<1;break}}while(0);return}function Ak(a,b){a=a|0;b=b|0;return xk(a,b,Mh(b)|0)|0}function Bk(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0;f=a[b>>0]|0;g=(f&1)==0;if(g)f=(f&255)>>>1;else f=c[b+4>>2]|0;do if(f>>>0>=d>>>0)if(g){a[b+1+d>>0]=0;a[b>>0]=d<<1;break}else{a[(c[b+8>>2]|0)+d>>0]=0;c[b+4>>2]=d;break}else Ck(b,d-f|0,e)|0;while(0);return}function Ck(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;if(d|0){f=a[b>>0]|0;if(!(f&1))g=10;else{f=c[b>>2]|0;g=(f&-2)+-1|0;f=f&255}if(!(f&1))h=(f&255)>>>1;else h=c[b+4>>2]|0;if((g-h|0)>>>0<d>>>0){Dk(b,g,d-g+h|0,h,h,0,0);f=a[b>>0]|0}if(!(f&1))g=b+1|0;else g=c[b+8>>2]|0;Wu(g+h|0,e|0,d|0)|0;f=h+d|0;if(!(a[b>>0]&1))a[b>>0]=f<<1;else c[b+4>>2]=f;a[g+f>>0]=0}return b|0}function Dk(b,d,e,f,g,h,i){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0,k=0,l=0;if((-17-d|0)>>>0<e>>>0)ok(b);if(!(a[b>>0]&1))l=b+1|0;else l=c[b+8>>2]|0;if(d>>>0<2147483623){j=e+d|0;k=d<<1;j=j>>>0<k>>>0?k:j;j=j>>>0<11?11:j+16&-16}else j=-17;k=Nu(j)|0;if(g|0)_u(k|0,l|0,g|0)|0;e=f-h|0;if((e|0)!=(g|0))_u(k+g+i|0,l+g+h|0,e-g|0)|0;if((d|0)!=10)mu(l);c[b+8>>2]=k;c[b>>2]=j|1;return}function Ek(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;f=a[b>>0]|0;if(!(f&1))g=10;else{f=c[b>>2]|0;g=(f&-2)+-1|0;f=f&255}if(!(f&1))h=(f&255)>>>1;else h=c[b+4>>2]|0;if((g-h|0)>>>0>=e>>>0){if(e|0){if(!(f&1))g=b+1|0;else g=c[b+8>>2]|0;_u(g+h|0,d|0,e|0)|0;f=h+e|0;if(!(a[b>>0]&1))a[b>>0]=f<<1;else c[b+4>>2]=f;a[g+f>>0]=0}}else yk(b,g,e-g+h|0,h,h,0,e,d);return b|0}function Fk(a,b){a=a|0;b=b|0;return Ek(a,b,Mh(b)|0)|0}function Gk(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0;e=a[b>>0]|0;f=(e&1)!=0;if(f){g=(c[b>>2]&-2)+-1|0;h=c[b+4>>2]|0}else{g=10;h=(e&255)>>>1}if((h|0)==(g|0)){Dk(b,g,1,g,g,0,0);if(!(a[b>>0]&1))f=7;else f=8}else if(f)f=8;else f=7;if((f|0)==7){a[b>>0]=(h<<1)+2;e=b+1|0}else if((f|0)==8){e=c[b+8>>2]|0;c[b+4>>2]=h+1}b=e+h|0;a[b>>0]=d;a[b+1>>0]=0;return}function Hk(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0;g=a[b>>0]|0;h=(g&1)==0;if(h)i=(g&255)>>>1;else i=c[b+4>>2]|0;if(i>>>0<d>>>0)pk(b);if(h)h=10;else{g=c[b>>2]|0;h=(g&-2)+-1|0;g=g&255}if((h-i|0)>>>0>=f>>>0){if(f|0){if(!(g&1))h=b+1|0;else h=c[b+8>>2]|0;if((i|0)==(d|0))g=h+d|0;else{g=h+d|0;$u(g+f|0,g|0,i-d|0)|0;e=g>>>0<=e>>>0&(h+i|0)>>>0>e>>>0?e+f|0:e}$u(g|0,e|0,f|0)|0;g=i+f|0;if(!(a[b>>0]&1))a[b>>0]=g<<1;else c[b+4>>2]=g;a[h+g>>0]=0}}else yk(b,h,i+f-h|0,i,d,0,f,e);return b|0}function Ik(a,b,c){a=a|0;b=b|0;c=c|0;return Hk(a,b,c,Mh(c)|0)|0}function Jk(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0;f=a[b>>0]|0;if(!(f&1)){g=(f&255)>>>1;f=b+1|0}else{g=c[b+4>>2]|0;f=c[b+8>>2]|0}if(g>>>0>e>>>0){e=Xh(f+e|0,d&255,g-e|0)|0;f=(e|0)==0?-1:e-f|0}else f=-1;return f|0}function Kk(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0;h=a[b>>0]|0;j=(h&1)==0;if(j)h=(h&255)>>>1;else h=c[b+4>>2]|0;if((g|0)==-1|h>>>0<d>>>0)pk(b);i=h-d|0;i=i>>>0<e>>>0?i:e;if(j)h=b+1|0;else h=c[b+8>>2]|0;e=i>>>0>g>>>0;h=rj(h+d|0,f,e?g:i)|0;if(!h)return (i>>>0<g>>>0?-1:e&1)|0;else return h|0;return 0}function Lk(a,b){a=a|0;b=b|0;return Kk(a,0,-1,b,Mh(b)|0)|0}function Mk(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0;if(f>>>0>4294967279)ok(b);if(f>>>0<11){a[b>>0]=e<<1;f=b+1|0}else{g=f+16&-16;f=Nu(g)|0;c[b+8>>2]=f;c[b>>2]=g|1;c[b+4>>2]=e}_u(f|0,d|0,e|0)|0;a[f+e>>0]=0;return}function Nk(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0;if(e>>>0>1073741807)ok(b);if(e>>>0<2){a[b>>0]=e<<1;b=b+4|0}else{g=e+4&-4;f=Nu(g<<2)|0;c[b+8>>2]=f;c[b>>2]=g|1;c[b+4>>2]=e;b=f}lj(b,d,e)|0;c[b+(e<<2)>>2]=0;return}function Ok(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0;if(d>>>0>1073741807)ok(b);if(d>>>0<2){a[b>>0]=d<<1;b=b+4|0}else{g=d+4&-4;f=Nu(g<<2)|0;c[b+8>>2]=f;c[b>>2]=g|1;c[b+4>>2]=d;b=f}xj(b,e,d)|0;c[b+(d<<2)>>2]=0;return}function Pk(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0;h=d;f=e-h|0;g=f>>2;if(g>>>0>1073741807)ok(b);if(g>>>0<2){a[b>>0]=f>>>1;b=b+4|0}else{i=g+4&-4;f=Nu(i<<2)|0;c[b+8>>2]=f;c[b>>2]=i|1;c[b+4>>2]=g;b=f}g=(e-h|0)>>>2;f=b;while(1){if((d|0)==(e|0))break;c[f>>2]=c[d>>2];d=d+4|0;f=f+4|0}c[b+(g<<2)>>2]=0;return}function Qk(b){b=b|0;if(a[b>>0]&1)mu(c[b+8>>2]|0);return}function Rk(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;f=a[b>>0]|0;if(!(f&1))h=1;else{f=c[b>>2]|0;h=(f&-2)+-1|0;f=f&255}g=(f&1)==0;do if(h>>>0>=e>>>0){if(g)f=b+4|0;else f=c[b+8>>2]|0;yj(f,d,e)|0;c[f+(e<<2)>>2]=0;if(!(a[b>>0]&1)){a[b>>0]=e<<1;break}else{c[b+4>>2]=e;break}}else{if(g)f=(f&255)>>>1;else f=c[b+4>>2]|0;Sk(b,h,e-h|0,f,0,f,e,d)}while(0);return b|0}function Sk(b,d,e,f,g,h,i,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;var k=0,l=0,m=0;if((1073741806-d|0)>>>0<e>>>0)ok(b);if(!(a[b>>0]&1))m=b+4|0;else m=c[b+8>>2]|0;if(d>>>0<536870887){k=e+d|0;l=d<<1;k=k>>>0<l>>>0?l:k;k=k>>>0<2?2:k+4&-4}else k=1073741807;l=Nu(k<<2)|0;if(g|0)lj(l,m,g)|0;if(i|0)lj(l+(g<<2)|0,j,i)|0;e=f-h|0;if((e|0)!=(g|0))lj(l+(g<<2)+(i<<2)|0,m+(g<<2)+(h<<2)|0,e-g|0)|0;if((d|0)!=1)mu(m);c[b+8>>2]=l;c[b>>2]=k|1;d=e+i|0;c[b+4>>2]=d;c[l+(d<<2)>>2]=0;return}function Tk(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0;if(d>>>0>1073741807)ok(b);e=a[b>>0]|0;if(!(e&1))f=1;else{e=c[b>>2]|0;f=(e&-2)+-1|0;e=e&255}if(!(e&1))j=(e&255)>>>1;else j=c[b+4>>2]|0;d=j>>>0>d>>>0?j:d;if(d>>>0<2)i=1;else i=(d+4&-4)+-1|0;do if((i|0)!=(f|0)){do if((i|0)!=1){d=Nu((i<<2)+4|0)|0;if(!(e&1)){f=1;g=b+4|0;h=0;break}else{f=1;g=c[b+8>>2]|0;h=1;break}}else{d=b+4|0;f=0;g=c[b+8>>2]|0;h=1}while(0);if(!(e&1))e=(e&255)>>>1;else e=c[b+4>>2]|0;lj(d,g,e+1|0)|0;if(h)mu(g);if(f){c[b>>2]=i+1|1;c[b+4>>2]=j;c[b+8>>2]=d;break}else{a[b>>0]=j<<1;break}}while(0);return}function Uk(a,b){a=a|0;b=b|0;return Rk(a,b,gi(b)|0)|0}function Vk(b,d,e,f,g,h,i){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0,k=0,l=0;if((1073741807-d|0)>>>0<e>>>0)ok(b);if(!(a[b>>0]&1))l=b+4|0;else l=c[b+8>>2]|0;if(d>>>0<536870887){j=e+d|0;k=d<<1;j=j>>>0<k>>>0?k:j;j=j>>>0<2?2:j+4&-4}else j=1073741807;k=Nu(j<<2)|0;if(g|0)lj(k,l,g)|0;e=f-h|0;if((e|0)!=(g|0))lj(k+(g<<2)+(i<<2)|0,l+(g<<2)+(h<<2)|0,e-g|0)|0;if((d|0)!=1)mu(l);c[b+8>>2]=k;c[b>>2]=j|1;return}function Wk(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0;e=a[b>>0]|0;f=(e&1)!=0;if(f){g=(c[b>>2]&-2)+-1|0;h=c[b+4>>2]|0}else{g=1;h=(e&255)>>>1}if((h|0)==(g|0)){Vk(b,g,1,g,g,0,0);if(!(a[b>>0]&1))f=7;else f=8}else if(f)f=8;else f=7;if((f|0)==7){a[b>>0]=(h<<1)+2;e=b+4|0}else if((f|0)==8){e=c[b+8>>2]|0;c[b+4>>2]=h+1}b=e+(h<<2)|0;c[b>>2]=d;c[b+4>>2]=0;return}
function ig(f,g,h,j,k){f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0;K=i;i=i+4592|0;D=K;p=K+4580|0;B=K+440|0;y=g+12|0;c[y>>2]=0;n=c[g+-32>>2]|0;G=g+8|0;c[G>>2]=n+1;A=f+5364|0;l=c[A>>2]|0;switch(l|0){case 5:{m=c[f+5348>>2]|0;J=c[f+400+((m<<3|6)<<8)>>2]|0;if(((J>>3)+-3|0)>>>0<2?((J&7)+-3|0)>>>0<2:0){J=31998-n|0;i=K;return J|0}J=c[f+400+((m<<3^14)<<8)>>2]|0;if(((J>>3)+-3|0)>>>0<2?((J&7)+-3|0)>>>0<2:0){J=n+-31999|0;i=K;return J|0}if((l|0)==6)I=9;break}case 6:{I=9;break}default:{}}do if((I|0)==9){m=c[f+5348>>2]|0;l=m<<3;if((c[f+400+((l|6)<<8)>>2]&-8|0)==56){if((c[f+400+((l^14)<<8)>>2]&-8|0)==56){J=c[1082292+(m<<2)>>2]|0;i=K;return J|0}if((c[f+400+((m<<3^14)<<8)>>2]>>3|0)<7){J=31998-n|0;i=K;return J|0}}if(!(Ad(f)|0)){l=c[A>>2]|0;break}J=(c[G>>2]|0)+-32e3|0;i=K;return J|0}while(0);switch(l|0){case 7:{l=c[f+5348>>2]|0;m=c[f+5356>>2]|0;if((c[m+36+(l<<2)>>2]|0)==3){J=31999-(c[G>>2]|0)|0;i=K;return J|0}if((c[m+36+((l^1)<<2)>>2]|0)==3){J=(c[G>>2]|0)+-32e3|0;i=K;return J|0}break}case 4:{if(!(c[f+336+(((c[f+360>>2]|0)!=0&1)<<3<<2)>>2]|0)){J=(c[G>>2]|0)+-32e3|0;i=K;return J|0}break}case 2:{l=c[f+5348>>2]<<3;if(!(c[f+336+((l^14)<<2)>>2]|0)){J=31999-(c[G>>2]|0)|0;i=K;return J|0}if(!(c[f+336+((l|6)<<2)>>2]|0)){J=(c[G>>2]|0)+-32e3|0;i=K;return J|0}break}case 1:{l=c[f+5348>>2]<<3;if(!(c[f+336+(l<<2)>>2]|0)){J=31999-(c[G>>2]|0)|0;i=K;return J|0}if(!(c[f+336+((l^8)<<2)>>2]|0)){J=(c[G>>2]|0)+-32e3|0;i=K;return J|0}break}default:{}}J=Xf(f)|0;l=(c[G>>2]|0)>127;if(J){if(!l){J=c[1082292+(c[f+5348>>2]<<2)>>2]|0;i=K;return J|0}}else if(!l){H=k>>31;x=f+5356|0;F=(c[x>>2]|0)+56|0;E=c[F>>2]|0;F=c[F+4>>2]|0;J=$g(1148256,E,F,p)|0;if(a[p>>0]|0){o=e[J+2>>1]|0;l=b[J+4>>1]|0;m=l<<16>>16;n=c[G>>2]|0;if(l<<16>>16!=32002){if(l<<16>>16>31743)l=m-n|0;else l=(l<<16>>16<-31743?n:0)+m|0;if(((l|0)!=32002?(a[J+9>>0]|0)>=(H|0):0)?(d[J+8>>0]&((l|0)>=(j|0)?2:1)|0)!=0:0){J=l;i=K;return J|0}}else l=32002;w=b[J+6>>1]|0;m=w<<16>>16;n=g+28|0;c[n>>2]=m;if(w<<16>>16==32002){m=Fd(f)|0;c[n>>2]=m}if((l|0)==32002){q=m;n=o;l=m}else{q=m;n=o;l=(d[J+8>>0]&((l|0)>(m|0)?2:1)|0)==0?m:l}}else{if((c[g+-28>>2]|0)==65)l=(c[7772+(c[A>>2]<<2)>>2]<<1)-(c[g+-12>>2]|0)|0;else l=Fd(f)|0;c[g+28>>2]=l;q=l;n=0}if((l|0)>=(j|0)){if(a[p>>0]|0){J=l;i=K;return J|0}n=(c[x>>2]|0)+56|0;m=c[G>>2]|0;if((l|0)>31743)p=m+l|0;else p=l-((l|0)<-31743?m:0)|0;o=a[1148268]|0;n=Yu(c[n>>2]|0,c[n+4>>2]|0,48)|0;if((C|0)==0?(n|0)==(e[J>>1]|0):0){m=J+9|0;if(((a[m>>0]|0)+-4|0)>=-6){J=l;i=K;return J|0}}else{b[J+2>>1]=0;m=J+9|0}b[J>>1]=n;b[J+4>>1]=p;b[J+6>>1]=q;a[J+8>>0]=o&255|2;a[m>>0]=-6;J=l;i=K;return J|0}w=l+128|0;gf(B,f,n,k,c[g+-28>>2]&63);r=kf(B)|0;a:do if(!r)I=101;else{v=g+40|0;t=0-j|0;u=0-h|0;j=k+-1|0;p=(w|0)>-1e4;k=(w|0)>(h|0);s=f+5348|0;q=p^1;p=p^1;o=l;while(1){b:while(1){l=c[A>>2]|0;n=(r&131072|0)==0;if((l|0)==6){l=(r&56|0)==56?(c[f+((n?r>>>6&63:64)<<2)>>2]&7|0)==6:0;if(!(l|q)){m=6;I=72}}else{if((r&180224|0)==0?(L=c[s>>2]|0,z=c[x>>2]|0,m=z+344+((L^1)<<3)|0,L=f+320+(L<<3)|0,!((l+-1|0)>>>0<2|(c[L>>2]&c[m>>2]|0?1:(c[L+4>>2]&c[m+4>>2]|0)!=0))):0){m=z+376+((c[f+((n?r>>>6&63:64)<<2)>>2]&7)<<3)|0;L=26112+((r&63)<<3)|0;l=c[L>>2]&c[m>>2];m=c[L+4>>2]&c[m+4>>2]}else{l=(Lf(f,r)|0)&1;m=0}l=(l|0)!=0|(m|0)!=0;if(!(l|p)){m=c[A>>2]|0;I=72}}do if((I|0)==72){I=0;if(n)l=c[f+((r>>>6&63)<<2)>>2]|0;else l=r>>>18&15;l=l&7;if((m|0)==6){if((l|0)==6?(r&2048)>>>0>1536|n^1:0){l=0;break}}else if((l|0)==1?((c[s>>2]|0)*7^(n?r>>>9&7:8)|0)>3:0){l=0;break}l=(c[6728+(m<<7)+64+(c[f+((r&63)<<2)>>2]<<2)>>2]<<((m|0)==3&1))+w|0;if((l|0)<=(h|0)){I=81;break b}if(!k?!(Uf(f,r,1)|0):0){I=84;break b}else l=0}while(0);if(!((r&180224|0)!=16384?!(Uf(f,r,0)|0):0))I=88;if((I|0)==88?(I=0,Kf(f,r)|0):0){c[y>>2]=r;Nf(f,r,D,l);if(l)n=jg(f,v,t,u,j)|0;else n=ig(f,v,t,u,j)|0;l=0-n|0;Pf(f,r);if((o|0)<(l|0)){I=93;break}}r=kf(B)|0;if(!r){l=o;I=101;break a}}if((I|0)==81){I=0;l=(o|0)<(l|0)?l:o}else if((I|0)==84){I=0;l=(o|0)<(w|0)?w:o}else if((I|0)==93){I=0;if((l|0)>(h|0))break}r=kf(B)|0;if(!r){I=101;break a}else o=l}m=c[G>>2]|0;if((n|0)<-31743)q=m-n|0;else q=l-((n|0)>31743?m:0)|0;o=c[g+28>>2]|0;p=a[1148268]|0;L=b[J>>1]|0;n=Yu(E|0,F|0,48)|0;b[J+2>>1]=r;m=J+9|0;if((n|0)==(L&65535|0)&(C|0)==0?((a[m>>0]|0)+-4|0)>=(H|0):0)break;b[J>>1]=n;b[J+4>>1]=q;b[J+6>>1]=o;a[J+8>>0]=p&255|2;a[m>>0]=H}while(0);do if((I|0)==101){m=c[G>>2]|0;if((l|0)>31743)q=m+l|0;else q=l-((l|0)<-31743?m:0)|0;o=c[g+28>>2]|0;p=a[1148268]|0;n=Yu(E|0,F|0,48)|0;if((C|0)==0?(n|0)==(e[J>>1]|0):0){m=J+9|0;if(((a[m>>0]|0)+-4|0)>=(H|0))break}else{b[J+2>>1]=0;m=J+9|0}b[J>>1]=n;b[J+4>>1]=q;b[J+6>>1]=o;a[J+8>>0]=p&255|1;a[m>>0]=H}while(0);L=l;i=K;return L|0}L=Fd(f)|0;i=K;return L|0}function jg(f,g,h,j,k){f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,D=0,E=0,F=0,G=0,H=0,I=0;H=i;i=i+4592|0;A=H;o=H+4580|0;z=H+440|0;v=g+12|0;c[v>>2]=0;n=c[g+-32>>2]|0;E=g+8|0;c[E>>2]=n+1;y=f+5364|0;l=c[y>>2]|0;switch(l|0){case 5:{m=c[f+5348>>2]|0;G=c[f+400+((m<<3|6)<<8)>>2]|0;if(((G>>3)+-3|0)>>>0<2?((G&7)+-3|0)>>>0<2:0){G=31998-n|0;i=H;return G|0}G=c[f+400+((m<<3^14)<<8)>>2]|0;if(((G>>3)+-3|0)>>>0<2?((G&7)+-3|0)>>>0<2:0){G=n+-31999|0;i=H;return G|0}if((l|0)==6)F=9;break}case 6:{F=9;break}default:{}}do if((F|0)==9){m=c[f+5348>>2]|0;l=m<<3;if((c[f+400+((l|6)<<8)>>2]&-8|0)==56){if((c[f+400+((l^14)<<8)>>2]&-8|0)==56){G=c[1082292+(m<<2)>>2]|0;i=H;return G|0}if((c[f+400+((m<<3^14)<<8)>>2]>>3|0)<7){G=31998-n|0;i=H;return G|0}}if(!(Ad(f)|0)){l=c[y>>2]|0;break}G=(c[E>>2]|0)+-32e3|0;i=H;return G|0}while(0);switch(l|0){case 7:{l=c[f+5348>>2]|0;m=c[f+5356>>2]|0;if((c[m+36+(l<<2)>>2]|0)==3){G=31999-(c[E>>2]|0)|0;i=H;return G|0}if((c[m+36+((l^1)<<2)>>2]|0)==3){G=(c[E>>2]|0)+-32e3|0;i=H;return G|0}break}case 4:{if(!(c[f+336+(((c[f+360>>2]|0)!=0&1)<<3<<2)>>2]|0)){G=(c[E>>2]|0)+-32e3|0;i=H;return G|0}break}case 2:{l=c[f+5348>>2]<<3;if(!(c[f+336+((l^14)<<2)>>2]|0)){G=31999-(c[E>>2]|0)|0;i=H;return G|0}if(!(c[f+336+((l|6)<<2)>>2]|0)){G=(c[E>>2]|0)+-32e3|0;i=H;return G|0}break}case 1:{l=c[f+5348>>2]<<3;if(!(c[f+336+(l<<2)>>2]|0)){G=31999-(c[E>>2]|0)|0;i=H;return G|0}if(!(c[f+336+((l^8)<<2)>>2]|0)){G=(c[E>>2]|0)+-32e3|0;i=H;return G|0}break}default:{}}if(!(Xf(f)|0)?(c[E>>2]|0)<=127:0){t=f+5356|0;D=(c[t>>2]|0)+56|0;B=c[D>>2]|0;D=c[D+4>>2]|0;G=$g(1148256,B,D,o)|0;if(a[o>>0]|0){o=e[G+2>>1]|0;l=b[G+4>>1]|0;m=l<<16>>16;n=c[E>>2]|0;if(l<<16>>16!=32002){if(l<<16>>16>31743)l=m-n|0;else l=(l<<16>>16<-31743?n:0)+m|0;if((l|0)!=32002&(a[G+9>>0]|0)>-1?(d[G+8>>0]&((l|0)>=(j|0)?2:1)|0)!=0:0){G=l;i=H;return G|0}else l=o}else l=o}else l=0;u=g+28|0;c[u>>2]=32002;gf(z,f,l,k,c[g+-28>>2]&63);s=g+40|0;q=0-j|0;r=0-h|0;j=k+-1|0;p=f+5348|0;g=-32001;a:while(1){k=kf(z)|0;if(!k){l=g;F=70;break}o=(g|0)>-31744;while(1){l=c[y>>2]|0;m=(k&131072|0)==0;if((l|0)==6)if((c[f+((m?k>>>6&63:64)<<2)>>2]&7|0)==6)l=(k&56|0)==56;else l=0;else{if((k&180224|0)==0?(I=c[p>>2]|0,w=c[t>>2]|0,n=w+344+((I^1)<<3)|0,I=f+320+(I<<3)|0,!((l+-1|0)>>>0<2|(c[I>>2]&c[n>>2]|0?1:(c[I+4>>2]&c[n+4>>2]|0)!=0))):0){m=w+376+((c[f+((m?k>>>6&63:64)<<2)>>2]&7)<<3)|0;I=26112+((k&63)<<3)|0;l=c[I>>2]&c[m>>2];m=c[I+4>>2]&c[m+4>>2]}else{l=(Lf(f,k)|0)&1;m=0}l=(l|0)!=0|(m|0)!=0}b:do if(o?(x=k&180224,!((x|0)!=49152?(c[f+((k&63)<<2)>>2]|0)!=0:0)):0){if((x|0)<32768)switch(x|0){case 16384:{F=58;break b}default:{}}else switch(x|0){case 32768:{F=58;break b}default:{}}if(Uf(f,k,0)|0)F=58}else F=58;while(0);if((F|0)==58?(F=0,Kf(f,k)|0):0){c[v>>2]=k;Nf(f,k,A,l);if(l)n=jg(f,s,q,r,j)|0;else n=ig(f,s,q,r,j)|0;l=0-n|0;Pf(f,k);if((g|0)<(l|0))break}k=kf(z)|0;if(!k){l=g;F=70;break a}}if((l|0)>(h|0)){F=64;break}else g=l}do if((F|0)==64){m=c[E>>2]|0;if((n|0)<-31743)j=m-n|0;else j=l-((n|0)>31743?m:0)|0;o=c[u>>2]|0;g=a[1148268]|0;I=b[G>>1]|0;n=Yu(B|0,D|0,48)|0;b[G+2>>1]=k;m=G+9|0;if((n|0)==(I&65535|0)&(C|0)==0?(a[m>>0]|0)>=4:0)break;b[G>>1]=n;b[G+4>>1]=j;b[G+6>>1]=o;a[G+8>>0]=g&255|2;a[m>>0]=0}else if((F|0)==70){m=c[E>>2]|0;if((l|0)==-32001){l=m+-32e3|0;break}if((l|0)>31743)j=m+l|0;else j=l-((l|0)<-31743?m:0)|0;o=c[u>>2]|0;g=a[1148268]|0;n=Yu(B|0,D|0,48)|0;if((C|0)==0?(n|0)==(e[G>>1]|0):0){m=G+9|0;if((a[m>>0]|0)>=4)break}else{b[G+2>>1]=0;m=G+9|0}b[G>>1]=n;b[G+4>>1]=j;b[G+6>>1]=o;a[G+8>>0]=g&255|1;a[m>>0]=0}while(0);I=l;i=H;return I|0}I=c[1082292+(c[f+5348>>2]<<2)>>2]|0;i=H;return I|0}function kg(d,f,g,h,j){d=d|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0;L=i;i=i+5104|0;F=L;n=L+5096|0;E=L+440|0;w=f+40|0;c[w>>2]=L+4580;c[c[f>>2]>>2]=0;A=f+12|0;c[A>>2]=0;m=c[f+-32>>2]|0;I=f+8|0;c[I>>2]=m+1;D=d+5364|0;k=c[D>>2]|0;switch(k|0){case 5:{l=c[d+5348>>2]|0;J=c[d+400+((l<<3|6)<<8)>>2]|0;if(((J>>3)+-3|0)>>>0<2?((J&7)+-3|0)>>>0<2:0){K=31998-m|0;i=L;return K|0}J=c[d+400+((l<<3^14)<<8)>>2]|0;if(((J>>3)+-3|0)>>>0<2?((J&7)+-3|0)>>>0<2:0){K=m+-31999|0;i=L;return K|0}if((k|0)==6)K=9;break}case 6:{K=9;break}default:{}}do if((K|0)==9){l=c[d+5348>>2]|0;k=l<<3;if((c[d+400+((k|6)<<8)>>2]&-8|0)==56){if((c[d+400+((k^14)<<8)>>2]&-8|0)==56){K=c[1082292+(l<<2)>>2]|0;i=L;return K|0}if((c[d+400+((l<<3^14)<<8)>>2]>>3|0)<7){K=31998-m|0;i=L;return K|0}}if(!(Ad(d)|0)){k=c[D>>2]|0;break}K=(c[I>>2]|0)+-32e3|0;i=L;return K|0}while(0);switch(k|0){case 7:{k=c[d+5348>>2]|0;l=c[d+5356>>2]|0;if((c[l+36+(k<<2)>>2]|0)==3){K=31999-(c[I>>2]|0)|0;i=L;return K|0}if((c[l+36+((k^1)<<2)>>2]|0)==3){K=(c[I>>2]|0)+-32e3|0;i=L;return K|0}break}case 4:{if(!(c[d+336+(((c[d+360>>2]|0)!=0&1)<<3<<2)>>2]|0)){K=(c[I>>2]|0)+-32e3|0;i=L;return K|0}break}case 2:{k=c[d+5348>>2]<<3;if(!(c[d+336+((k^14)<<2)>>2]|0)){K=31999-(c[I>>2]|0)|0;i=L;return K|0}if(!(c[d+336+((k|6)<<2)>>2]|0)){K=(c[I>>2]|0)+-32e3|0;i=L;return K|0}break}case 1:{k=c[d+5348>>2]<<3;if(!(c[d+336+(k<<2)>>2]|0)){K=31999-(c[I>>2]|0)|0;i=L;return K|0}if(!(c[d+336+((k^8)<<2)>>2]|0)){K=(c[I>>2]|0)+-32e3|0;i=L;return K|0}break}default:{}}if(!(Xf(d)|0)?(c[I>>2]|0)<=127:0){v=d+5356|0;H=(c[v>>2]|0)+56|0;G=c[H>>2]|0;H=c[H+4>>2]|0;J=$g(1148256,G,H,n)|0;if(!(a[n>>0]|0))k=0;else k=e[J+2>>1]|0;x=f+28|0;c[x>>2]=32002;gf(E,d,k,j,c[f+-28>>2]&63);u=0-h|0;s=j+-1|0;t=d+5348|0;r=g;o=0;k=-32001;a:while(1){q=0-r|0;j=k;while(1){p=kf(E)|0;if(!p){k=j;K=70;break a}n=(j|0)>-31744;while(1){k=c[D>>2]|0;l=(p&131072|0)==0;if((k|0)==6)if((c[d+((l?p>>>6&63:64)<<2)>>2]&7|0)==6)k=(p&56|0)==56;else k=0;else{if((p&180224|0)==0?(M=c[t>>2]|0,y=c[v>>2]|0,m=y+344+((M^1)<<3)|0,M=d+320+(M<<3)|0,!((k+-1|0)>>>0<2|(c[M>>2]&c[m>>2]|0?1:(c[M+4>>2]&c[m+4>>2]|0)!=0))):0){l=y+376+((c[d+((l?p>>>6&63:64)<<2)>>2]&7)<<3)|0;M=26112+((p&63)<<3)|0;k=c[M>>2]&c[l>>2];l=c[M+4>>2]&c[l+4>>2]}else{k=(Lf(d,p)|0)&1;l=0}k=(k|0)!=0|(l|0)!=0}b:do if(n?(z=p&180224,!((z|0)!=49152?(c[d+((p&63)<<2)>>2]|0)!=0:0)):0){if((z|0)<32768)switch(z|0){case 16384:{K=54;break b}default:{}}else switch(z|0){case 32768:{K=54;break b}default:{}}if(Uf(d,p,0)|0)K=54}else K=54;while(0);if((K|0)==54?(K=0,Kf(d,p)|0):0){c[A>>2]=p;Nf(d,p,F,k);if(k)m=kg(d,w,u,q,s)|0;else m=lg(d,w,u,q,s)|0;k=0-m|0;Pf(d,p);if((j|0)<(k|0))break}p=kf(E)|0;if(!p){k=j;K=70;break a}}if((r|0)<(k|0))break;else j=k}l=c[f>>2]|0;n=c[w>>2]|0;c[l>>2]=p;l=l+4|0;if((n|0)!=0?(B=c[n>>2]|0,(B|0)!=0):0){j=B;do{n=n+4|0;c[l>>2]=j;l=l+4|0;j=c[n>>2]|0}while((j|0)!=0)}c[l>>2]=0;if((k|0)<(h|0)){r=k;o=p}else{K=64;break}}do if((K|0)==64){l=c[I>>2]|0;if((m|0)<-31743)o=l-m|0;else o=k-((m|0)>31743?l:0)|0;n=c[x>>2]|0;j=a[1148268]|0;M=b[J>>1]|0;m=Yu(G|0,H|0,48)|0;b[J+2>>1]=p;l=J+9|0;if((m|0)==(M&65535|0)&(C|0)==0?(a[l>>0]|0)>=4:0)break;b[J>>1]=m;b[J+4>>1]=o;b[J+6>>1]=n;a[J+8>>0]=j&255|2;a[l>>0]=0}else if((K|0)==70){l=c[I>>2]|0;if((k|0)==-32001){k=l+-32e3|0;break}if((k|0)>31743)t=l+k|0;else t=k-((k|0)<-31743?l:0)|0;r=(k|0)>(g|0);s=r?3:1;p=c[x>>2]|0;q=a[1148268]|0;if(!o){n=Yu(G|0,H|0,48)|0;m=C;l=b[J>>1]|0;if((n|0)==(l&65535|0)&(m|0)==0){j=J;o=l}else{j=J;K=78}}else{l=b[J>>1]|0;n=Yu(G|0,H|0,48)|0;j=J;m=C;K=78}if((K|0)==78){b[J+2>>1]=o;o=l}l=J+9|0;if((n|0)==(o&65535|0)&(m|0)==0?!(r|(a[l>>0]|0)<4):0)break;b[j>>1]=n;b[J+4>>1]=t;b[J+6>>1]=p;a[J+8>>0]=q&255|s;a[l>>0]=0}while(0);M=k;i=L;return M|0}M=c[1082292+(c[d+5348>>2]<<2)>>2]|0;i=L;return M|0}function lg(f,g,h,j,k){f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0;O=i;i=i+5104|0;H=O;p=O+5096|0;G=O+440|0;A=g+40|0;c[A>>2]=O+4580;c[c[g>>2]>>2]=0;B=g+12|0;c[B>>2]=0;n=c[g+-32>>2]|0;K=g+8|0;c[K>>2]=n+1;F=f+5364|0;l=c[F>>2]|0;switch(l|0){case 5:{m=c[f+5348>>2]|0;N=c[f+400+((m<<3|6)<<8)>>2]|0;if(((N>>3)+-3|0)>>>0<2?((N&7)+-3|0)>>>0<2:0){N=31998-n|0;i=O;return N|0}N=c[f+400+((m<<3^14)<<8)>>2]|0;if(((N>>3)+-3|0)>>>0<2?((N&7)+-3|0)>>>0<2:0){N=n+-31999|0;i=O;return N|0}if((l|0)==6)M=9;break}case 6:{M=9;break}default:{}}do if((M|0)==9){m=c[f+5348>>2]|0;l=m<<3;if((c[f+400+((l|6)<<8)>>2]&-8|0)==56){if((c[f+400+((l^14)<<8)>>2]&-8|0)==56){N=c[1082292+(m<<2)>>2]|0;i=O;return N|0}if((c[f+400+((m<<3^14)<<8)>>2]>>3|0)<7){N=31998-n|0;i=O;return N|0}}if(!(Ad(f)|0)){l=c[F>>2]|0;break}N=(c[K>>2]|0)+-32e3|0;i=O;return N|0}while(0);switch(l|0){case 7:{l=c[f+5348>>2]|0;m=c[f+5356>>2]|0;if((c[m+36+(l<<2)>>2]|0)==3){N=31999-(c[K>>2]|0)|0;i=O;return N|0}if((c[m+36+((l^1)<<2)>>2]|0)==3){N=(c[K>>2]|0)+-32e3|0;i=O;return N|0}break}case 4:{if(!(c[f+336+(((c[f+360>>2]|0)!=0&1)<<3<<2)>>2]|0)){N=(c[K>>2]|0)+-32e3|0;i=O;return N|0}break}case 2:{l=c[f+5348>>2]<<3;if(!(c[f+336+((l^14)<<2)>>2]|0)){N=31999-(c[K>>2]|0)|0;i=O;return N|0}if(!(c[f+336+((l|6)<<2)>>2]|0)){N=(c[K>>2]|0)+-32e3|0;i=O;return N|0}break}case 1:{l=c[f+5348>>2]<<3;if(!(c[f+336+(l<<2)>>2]|0)){N=31999-(c[K>>2]|0)|0;i=O;return N|0}if(!(c[f+336+((l^8)<<2)>>2]|0)){N=(c[K>>2]|0)+-32e3|0;i=O;return N|0}break}default:{}}N=Xf(f)|0;l=(c[K>>2]|0)>127;if(N){if(!l){N=c[1082292+(c[f+5348>>2]<<2)>>2]|0;i=O;return N|0}}else if(!l){L=k>>31;z=f+5356|0;J=(c[z>>2]|0)+56|0;I=c[J>>2]|0;J=c[J+4>>2]|0;N=$g(1148256,I,J,p)|0;if(a[p>>0]|0){o=e[N+2>>1]|0;l=b[N+4>>1]|0;m=l<<16>>16;n=c[K>>2]|0;do if(l<<16>>16!=32002)if(l<<16>>16>31743){n=m-n|0;break}else{n=(l<<16>>16<-31743?n:0)+m|0;break}else n=32002;while(0);y=b[N+6>>1]|0;l=y<<16>>16;m=g+28|0;c[m>>2]=l;if(y<<16>>16==32002){l=Fd(f)|0;c[m>>2]=l}if((n|0)==32002){q=l;m=o}else{q=l;m=o;l=(d[N+8>>0]&((n|0)>(l|0)?2:1)|0)==0?l:n}}else{if((c[g+-28>>2]|0)==65)l=(c[7772+(c[F>>2]<<2)>>2]<<1)-(c[g+-12>>2]|0)|0;else l=Fd(f)|0;c[g+28>>2]=l;q=l;m=0}if((l|0)>=(j|0)){if(a[p>>0]|0){N=l;i=O;return N|0}n=(c[z>>2]|0)+56|0;m=c[K>>2]|0;if((l|0)>31743)p=m+l|0;else p=l-((l|0)<-31743?m:0)|0;o=a[1148268]|0;n=Yu(c[n>>2]|0,c[n+4>>2]|0,48)|0;if((C|0)==0?(n|0)==(e[N>>1]|0):0){m=N+9|0;if(((a[m>>0]|0)+-4|0)>=-6){N=l;i=O;return N|0}}else{b[N+2>>1]=0;m=N+9|0}b[N>>1]=n;b[N+4>>1]=p;b[N+6>>1]=q;a[N+8>>0]=o&255|2;a[m>>0]=-6;N=l;i=O;return N|0}y=l+128|0;gf(G,f,m,k,c[g+-28>>2]&63);x=0-j|0;v=k+-1|0;t=(y|0)>-1e4;w=f+5348|0;u=t^1;t=t^1;s=(l|0)>(h|0)?l:h;q=0;a:while(1){k=kf(G)|0;if(!k){M=104;break}p=0-s|0;r=(y|0)>(s|0);o=l;while(1){b:while(1){l=c[F>>2]|0;n=(k&131072|0)==0;if((l|0)==6){l=(k&56|0)==56?(c[f+((n?k>>>6&63:64)<<2)>>2]&7|0)==6:0;if(!(l|u)){m=6;M=71}}else{if((k&180224|0)==0?(P=c[w>>2]|0,D=c[z>>2]|0,m=D+344+((P^1)<<3)|0,P=f+320+(P<<3)|0,!((l+-1|0)>>>0<2|(c[P>>2]&c[m>>2]|0?1:(c[P+4>>2]&c[m+4>>2]|0)!=0))):0){m=D+376+((c[f+((n?k>>>6&63:64)<<2)>>2]&7)<<3)|0;P=26112+((k&63)<<3)|0;l=c[P>>2]&c[m>>2];m=c[P+4>>2]&c[m+4>>2]}else{l=(Lf(f,k)|0)&1;m=0}l=(l|0)!=0|(m|0)!=0;if(!(l|t)){m=c[F>>2]|0;M=71}}do if((M|0)==71){M=0;if(n)l=c[f+((k>>>6&63)<<2)>>2]|0;else l=k>>>18&15;l=l&7;if((m|0)==6){if((l|0)==6?(k&2048)>>>0>1536|n^1:0){l=0;break}}else if((l|0)==1?((c[w>>2]|0)*7^(n?k>>>9&7:8)|0)>3:0){l=0;break}l=(c[6728+(m<<7)+64+(c[f+((k&63)<<2)>>2]<<2)>>2]<<((m|0)==3&1))+y|0;if((l|0)<=(s|0)){M=80;break b}if(!r?!(Uf(f,k,1)|0):0){M=83;break b}else l=0}while(0);if(!((k&180224|0)!=16384?!(Uf(f,k,0)|0):0))M=87;if((M|0)==87?(M=0,Kf(f,k)|0):0){c[B>>2]=k;Nf(f,k,H,l);if(l)n=kg(f,A,x,p,v)|0;else n=lg(f,A,x,p,v)|0;l=0-n|0;Pf(f,k);if((o|0)<(l|0)){M=92;break}}k=kf(G)|0;if(!k){l=o;M=104;break a}}if((M|0)==80){M=0;l=(o|0)<(l|0)?l:o}else if((M|0)==83){M=0;l=(o|0)<(y|0)?y:o}else if((M|0)==92){M=0;if((s|0)<(l|0))break}k=kf(G)|0;if(!k){M=104;break a}else o=l}m=c[g>>2]|0;o=c[A>>2]|0;c[m>>2]=k;m=m+4|0;if((o|0)!=0?(E=c[o>>2]|0,(E|0)!=0):0){p=E;do{o=o+4|0;c[m>>2]=p;m=m+4|0;p=c[o>>2]|0}while((p|0)!=0)}c[m>>2]=0;if((l|0)<(j|0)){s=l;q=k}else{M=98;break}}do if((M|0)==98){m=c[K>>2]|0;if((n|0)<-31743)q=m-n|0;else q=l-((n|0)>31743?m:0)|0;o=c[g+28>>2]|0;p=a[1148268]|0;P=b[N>>1]|0;n=Yu(I|0,J|0,48)|0;b[N+2>>1]=k;m=N+9|0;if((n|0)==(P&65535|0)&(C|0)==0?((a[m>>0]|0)+-4|0)>=(L|0):0)break;b[N>>1]=n;b[N+4>>1]=q;b[N+6>>1]=o;a[N+8>>0]=p&255|2;a[m>>0]=L}else if((M|0)==104){m=c[K>>2]|0;if((l|0)>31743)u=m+l|0;else u=l-((l|0)<-31743?m:0)|0;s=(l|0)>(h|0);t=s?3:1;k=c[g+28>>2]|0;r=a[1148268]|0;if(!q){o=Yu(I|0,J|0,48)|0;n=C;m=b[N>>1]|0;if((o|0)==(m&65535|0)&(n|0)==0){p=N;q=m}else{p=N;M=110}}else{m=b[N>>1]|0;o=Yu(I|0,J|0,48)|0;p=N;n=C;M=110}if((M|0)==110){b[N+2>>1]=q;q=m}m=N+9|0;if((o|0)==(q&65535|0)&(n|0)==0?!(s|((a[m>>0]|0)+-4|0)<(L|0)):0)break;b[p>>1]=o;b[N+4>>1]=u;b[N+6>>1]=k;a[N+8>>0]=r&255|t;a[m>>0]=L}while(0);P=l;i=O;return P|0}P=Fd(f)|0;i=O;return P|0}function mg(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;i=a+8|0;e=c[i>>2]|0;j=a+4|0;d=c[j>>2]|0;if(e-d>>2>>>0>=b>>>0){Wu(d|0,0,b<<2|0)|0;c[j>>2]=d+(b<<2);return}k=c[a>>2]|0;f=(d-k>>2)+b|0;if(f>>>0>1073741823)ft(a);d=e-k|0;if(d>>2>>>0<536870911){d=d>>1;d=d>>>0<f>>>0?f:d;f=c[j>>2]|0;e=f-k>>2;if(!d){h=0;g=0;d=f}else l=8}else{e=c[j>>2]|0;d=1073741823;f=e;e=e-k>>2;l=8}if((l|0)==8){h=d;g=Nu(d<<2)|0;d=f}l=g+(e<<2)|0;Wu(l|0,0,b<<2|0)|0;e=d-k|0;f=l+(0-(e>>2)<<2)|0;_u(f|0,k|0,e|0)|0;c[a>>2]=f;c[j>>2]=l+(b<<2);c[i>>2]=g+(h<<2);if(!k)return;mu(k);return}function ng(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;i=a+4|0;j=c[a>>2]|0;d=((c[i>>2]|0)-j>>2)+1|0;if(d>>>0>1073741823)ft(a);k=a+8|0;e=(c[k>>2]|0)-j|0;if(e>>2>>>0<536870911){f=e>>1;d=f>>>0<d>>>0?d:f;f=c[i>>2]|0;e=f-j>>2;if(!d){h=0;g=0;d=f}else l=6}else{e=c[i>>2]|0;d=1073741823;f=e;e=e-j>>2;l=6}if((l|0)==6){h=d;g=Nu(d<<2)|0;d=f}l=g+(e<<2)|0;c[l>>2]=c[b>>2];f=d-j|0;b=l+(0-(f>>2)<<2)|0;_u(b|0,j|0,f|0)|0;c[a>>2]=b;c[i>>2]=l+4;c[k>>2]=g+(h<<2);if(!j)return;mu(j);return}function og(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0;A=i;i=i+80|0;n=A+64|0;m=A+60|0;l=A+56|0;h=A+52|0;j=A+48|0;s=A+44|0;t=A+40|0;u=A+36|0;v=A+32|0;w=A+28|0;x=A+24|0;y=A+20|0;z=A+16|0;o=A+12|0;p=A+8|0;q=A+4|0;r=A;switch(e|0){case 2:{h=c[b>>2]|0;j=h+-20|0;c[b>>2]=j;f=c[a>>2]|0;if((c[f>>2]|0)>=(c[j>>2]|0)){i=A;return}x=f;w=c[x>>2]|0;x=c[x+4>>2]|0;a=f+8|0;z=c[a>>2]|0;e=f+12|0;d=c[e>>2]|0;y=f+16|0;b=c[y>>2]|0;c[y>>2]=0;c[e>>2]=0;c[a>>2]=0;u=j;v=c[u+4>>2]|0;g=f;c[g>>2]=c[u>>2];c[g+4>>2]=v;g=h+-12|0;c[a>>2]=c[g>>2];a=h+-8|0;c[e>>2]=c[a>>2];e=h+-4|0;c[y>>2]=c[e>>2];y=j;c[y>>2]=w;c[y+4>>2]=x;c[g>>2]=z;c[a>>2]=d;c[e>>2]=b;i=A;return}case 1:case 0:{i=A;return}default:{if((e|0)<1){c[h>>2]=c[a>>2];c[j>>2]=c[b>>2];c[m>>2]=c[h>>2];c[n>>2]=c[j>>2];pg(m,n,d);i=A;return}k=(e|0)/2|0;h=c[a>>2]|0;j=h+(k*20|0)|0;if((e|0)>(g|0)){c[x>>2]=h;c[y>>2]=j;c[m>>2]=c[x>>2];c[n>>2]=c[y>>2];og(m,n,d,k,f,g);c[z>>2]=j;b=c[b>>2]|0;c[o>>2]=b;e=e-k|0;c[m>>2]=c[z>>2];c[n>>2]=c[o>>2];og(m,n,d,e,f,g);c[p>>2]=h;c[q>>2]=j;c[r>>2]=b;c[l>>2]=c[p>>2];c[m>>2]=c[q>>2];c[n>>2]=c[r>>2];ug(l,m,n,d,k,e,f,g);i=A;return}c[s>>2]=h;c[t>>2]=j;c[m>>2]=c[s>>2];c[n>>2]=c[t>>2];qg(m,n,d,k,f);c[u>>2]=j;c[v>>2]=c[b>>2];b=f+(k*20|0)|0;c[m>>2]=c[u>>2];c[n>>2]=c[v>>2];qg(m,n,d,e-k|0,b);c[w>>2]=h;c[n>>2]=c[w>>2];tg(f,b,b,f+(e*20|0)|0,n,d);if(!f){i=A;return}else m=0;while(1){h=c[f+8>>2]|0;j=h;if(h|0){k=f+12|0;l=c[k>>2]|0;if((l|0)!=(h|0))c[k>>2]=l+(~((l+-4-j|0)>>>2)<<2);mu(h)}m=m+1|0;if((m|0)==(e|0))break;else f=f+20|0}i=A;return}}}function pg(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;d=c[a>>2]|0;e=c[b>>2]|0;if((d|0)==(e|0))return;f=d+20|0;if((f|0)==(e|0))return;while(1){e=f;n=f;o=c[n>>2]|0;n=c[n+4>>2]|0;m=d+28|0;q=c[m>>2]|0;l=d+32|0;r=c[l>>2]|0;k=d+36|0;p=c[k>>2]|0;c[k>>2]=0;c[l>>2]=0;c[m>>2]=0;a:do if((f|0)==(c[a>>2]|0))d=e;else{m=f;d=e;do{k=m;m=m+-20|0;if((c[m>>2]|0)>=(o|0))break a;l=d;e=m;j=c[e+4>>2]|0;i=d;c[i>>2]=c[e>>2];c[i+4>>2]=j;i=l+8|0;j=k+-12|0;d=c[i>>2]|0;e=d;h=l+12|0;if(!d)d=l+16|0;else{g=c[h>>2]|0;if((g|0)!=(d|0))c[h>>2]=g+(~((g+-4-e|0)>>>2)<<2);mu(d);d=l+16|0;c[d>>2]=0;c[h>>2]=0;c[i>>2]=0}c[i>>2]=c[j>>2];i=k+-8|0;c[h>>2]=c[i>>2];k=k+-4|0;c[d>>2]=c[k>>2];c[k>>2]=0;c[i>>2]=0;c[j>>2]=0;d=l+-20|0}while((m|0)!=(c[a>>2]|0))}while(0);j=d;i=d;c[i>>2]=o;c[i+4>>2]=n;i=j+8|0;d=c[i>>2]|0;e=d;h=j+12|0;if(!d)d=j+16|0;else{g=c[h>>2]|0;if((g|0)!=(d|0))c[h>>2]=g+(~((g+-4-e|0)>>>2)<<2);mu(d);d=j+16|0;c[d>>2]=0;c[h>>2]=0;c[i>>2]=0}c[i>>2]=q;c[h>>2]=r;c[d>>2]=p;d=f+20|0;if((d|0)==(c[b>>2]|0))break;else{r=f;f=d;d=r}}return}function qg(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0;v=i;i=i+64|0;k=v+52|0;j=v+48|0;h=v+44|0;g=v+40|0;l=v+36|0;m=v+32|0;n=v+28|0;o=v+24|0;p=v+20|0;q=v+16|0;r=v+12|0;s=v+8|0;t=v+4|0;u=v;switch(e|0){case 1:{e=c[a>>2]|0;d=e;b=c[d+4>>2]|0;a=f;c[a>>2]=c[d>>2];c[a+4>>2]=b;a=f+8|0;b=e+8|0;c[a>>2]=0;d=f+12|0;c[d>>2]=0;c[f+16>>2]=0;c[a>>2]=c[b>>2];a=e+12|0;c[d>>2]=c[a>>2];e=e+16|0;c[f+16>>2]=c[e>>2];c[e>>2]=0;c[a>>2]=0;c[b>>2]=0;i=v;return}case 2:{h=c[b>>2]|0;j=h+-20|0;c[b>>2]=j;g=c[a>>2]|0;if((c[g>>2]|0)<(c[j>>2]|0)){a=j;e=c[a+4>>2]|0;b=f;c[b>>2]=c[a>>2];c[b+4>>2]=e;b=f+8|0;e=h+-12|0;c[b>>2]=0;a=f+12|0;c[a>>2]=0;c[f+16>>2]=0;c[b>>2]=c[e>>2];b=h+-8|0;c[a>>2]=c[b>>2];a=h+-4|0;c[f+16>>2]=c[a>>2];c[a>>2]=0;c[b>>2]=0;c[e>>2]=0;e=g;b=c[e+4>>2]|0;a=f+20|0;c[a>>2]=c[e>>2];c[a+4>>2]=b;a=f+28|0;b=g+8|0;c[a>>2]=0;e=f+32|0;c[e>>2]=0;c[f+36>>2]=0;c[a>>2]=c[b>>2];a=g+12|0;c[e>>2]=c[a>>2];e=g+16|0;c[f+36>>2]=c[e>>2];c[e>>2]=0;c[a>>2]=0;c[b>>2]=0;i=v;return}else{a=g;e=c[a+4>>2]|0;b=f;c[b>>2]=c[a>>2];c[b+4>>2]=e;b=f+8|0;e=g+8|0;c[b>>2]=0;a=f+12|0;c[a>>2]=0;c[f+16>>2]=0;c[b>>2]=c[e>>2];b=g+12|0;c[a>>2]=c[b>>2];a=g+16|0;c[f+16>>2]=c[a>>2];c[a>>2]=0;c[b>>2]=0;c[e>>2]=0;e=j;b=c[e+4>>2]|0;a=f+20|0;c[a>>2]=c[e>>2];c[a+4>>2]=b;a=f+28|0;b=h+-12|0;c[a>>2]=0;e=f+32|0;c[e>>2]=0;c[f+36>>2]=0;c[a>>2]=c[b>>2];a=h+-8|0;c[e>>2]=c[a>>2];e=h+-4|0;c[f+36>>2]=c[e>>2];c[e>>2]=0;c[a>>2]=0;c[b>>2]=0;i=v;return}}case 0:{i=v;return}default:if((e|0)<9){c[l>>2]=c[a>>2];c[m>>2]=c[b>>2];c[j>>2]=c[l>>2];c[k>>2]=c[m>>2];rg(j,k,f,d);i=v;return}else{l=(e|0)/2|0;m=c[a>>2]|0;a=m+(l*20|0)|0;c[n>>2]=m;c[o>>2]=a;c[j>>2]=c[n>>2];c[k>>2]=c[o>>2];og(j,k,d,l,f,l);c[p>>2]=a;b=c[b>>2]|0;c[q>>2]=b;e=e-l|0;c[j>>2]=c[p>>2];c[k>>2]=c[q>>2];og(j,k,d,e,f+(l*20|0)|0,e);c[r>>2]=m;c[s>>2]=a;c[t>>2]=a;c[u>>2]=b;c[g>>2]=c[r>>2];c[h>>2]=c[s>>2];c[j>>2]=c[t>>2];c[k>>2]=c[u>>2];sg(g,h,j,k,f,d);i=v;return}}}function rg(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;e=c[a>>2]|0;f=c[b>>2]|0;if((e|0)==(f|0))return;l=e;g=c[l+4>>2]|0;m=d;c[m>>2]=c[l>>2];c[m+4>>2]=g;m=d+8|0;g=e+8|0;c[m>>2]=0;l=d+12|0;c[l>>2]=0;c[d+16>>2]=0;c[m>>2]=c[g>>2];m=e+12|0;c[l>>2]=c[m>>2];l=e+16|0;c[d+16>>2]=c[l>>2];c[l>>2]=0;c[m>>2]=0;c[g>>2]=0;g=e+20|0;c[a>>2]=g;if((g|0)==(f|0))return;else m=d;do{f=m;m=m+20|0;if((c[f>>2]|0)<(c[g>>2]|0)){j=f;k=c[j+4>>2]|0;l=m;c[l>>2]=c[j>>2];c[l+4>>2]=k;l=f+8|0;c[f+28>>2]=c[l>>2];k=f+12|0;c[f+32>>2]=c[k>>2];j=f+16|0;c[f+36>>2]=c[j>>2];c[j>>2]=0;c[k>>2]=0;c[l>>2]=0;a:do if((f|0)==(d|0))h=d;else while(1){l=f;f=f+-20|0;if((c[f>>2]|0)>=(c[c[a>>2]>>2]|0)){h=l;break a}e=f;k=c[e+4>>2]|0;j=l;c[j>>2]=c[e>>2];c[j+4>>2]=k;j=l+8|0;k=l+-12|0;e=c[j>>2]|0;g=e;i=l+12|0;if(!e)e=l+16|0;else{h=c[i>>2]|0;if((h|0)!=(e|0))c[i>>2]=h+(~((h+-4-g|0)>>>2)<<2);mu(e);e=l+16|0;c[e>>2]=0;c[i>>2]=0;c[j>>2]=0}c[j>>2]=c[k>>2];j=l+-8|0;c[i>>2]=c[j>>2];l=l+-4|0;c[e>>2]=c[l>>2];c[l>>2]=0;c[j>>2]=0;c[k>>2]=0;if((f|0)==(d|0)){h=d;break}}while(0);j=c[a>>2]|0;e=j;l=c[e+4>>2]|0;k=h;c[k>>2]=c[e>>2];c[k+4>>2]=l;k=h+8|0;l=j+8|0;e=c[k>>2]|0;f=e;i=h+12|0;if(!e)e=h+16|0;else{g=c[i>>2]|0;if((g|0)!=(e|0))c[i>>2]=g+(~((g+-4-f|0)>>>2)<<2);mu(e);e=h+16|0;c[e>>2]=0;c[i>>2]=0;c[k>>2]=0}c[k>>2]=c[l>>2];k=j+12|0;c[i>>2]=c[k>>2];j=j+16|0;c[e>>2]=c[j>>2];c[j>>2]=0;c[k>>2]=0;c[l>>2]=0}else{j=g;l=c[j+4>>2]|0;k=m;c[k>>2]=c[j>>2];c[k+4>>2]=l;k=f+28|0;l=e+28|0;c[k>>2]=0;j=f+32|0;c[j>>2]=0;c[f+36>>2]=0;c[k>>2]=c[l>>2];k=e+32|0;c[j>>2]=c[k>>2];j=e+36|0;c[f+36>>2]=c[j>>2];c[j>>2]=0;c[k>>2]=0;c[l>>2]=0}e=c[a>>2]|0;g=e+20|0;c[a>>2]=g}while((g|0)!=(c[b>>2]|0));return}function sg(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0;g=c[a>>2]|0;h=c[b>>2]|0;a:do if((g|0)!=(h|0)){while(1){i=c[d>>2]|0;if((i|0)==(c[e>>2]|0))break;if((c[g>>2]|0)<(c[i>>2]|0)){j=i;g=c[j+4>>2]|0;h=f;c[h>>2]=c[j>>2];c[h+4>>2]=g;h=f+8|0;g=i+8|0;c[h>>2]=0;j=f+12|0;c[j>>2]=0;c[f+16>>2]=0;c[h>>2]=c[g>>2];h=i+12|0;c[j>>2]=c[h>>2];i=i+16|0;c[f+16>>2]=c[i>>2];c[i>>2]=0;c[h>>2]=0;c[g>>2]=0;c[d>>2]=(c[d>>2]|0)+20;g=c[a>>2]|0}else{h=g;j=c[h+4>>2]|0;i=f;c[i>>2]=c[h>>2];c[i+4>>2]=j;i=f+8|0;j=g+8|0;c[i>>2]=0;h=f+12|0;c[h>>2]=0;c[f+16>>2]=0;c[i>>2]=c[j>>2];i=g+12|0;c[h>>2]=c[i>>2];g=g+16|0;c[f+16>>2]=c[g>>2];c[g>>2]=0;c[i>>2]=0;c[j>>2]=0;g=(c[a>>2]|0)+20|0;c[a>>2]=g}f=f+20|0;h=c[b>>2]|0;if((g|0)==(h|0))break a}if((g|0)==(h|0))return;while(1){d=g;j=c[d+4>>2]|0;e=f;c[e>>2]=c[d>>2];c[e+4>>2]=j;e=f+8|0;j=g+8|0;c[e>>2]=0;d=f+12|0;c[d>>2]=0;c[f+16>>2]=0;c[e>>2]=c[j>>2];e=g+12|0;c[d>>2]=c[e>>2];d=g+16|0;c[f+16>>2]=c[d>>2];c[d>>2]=0;c[e>>2]=0;c[j>>2]=0;g=(c[a>>2]|0)+20|0;c[a>>2]=g;if((g|0)==(c[b>>2]|0))break;else f=f+20|0}return}while(0);g=c[d>>2]|0;if((g|0)==(c[e>>2]|0))return;while(1){a=g;j=c[a+4>>2]|0;b=f;c[b>>2]=c[a>>2];c[b+4>>2]=j;b=f+8|0;j=g+8|0;c[b>>2]=0;a=f+12|0;c[a>>2]=0;c[f+16>>2]=0;c[b>>2]=c[j>>2];b=g+12|0;c[a>>2]=c[b>>2];a=g+16|0;c[f+16>>2]=c[a>>2];c[a>>2]=0;c[b>>2]=0;c[j>>2]=0;g=(c[d>>2]|0)+20|0;c[d>>2]=g;if((g|0)==(c[e>>2]|0))break;else f=f+20|0}return}function tg(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0;a:do if((a|0)!=(b|0)){while(1){if((d|0)==(e|0)){d=a;break}m=c[f>>2]|0;if((c[a>>2]|0)<(c[d>>2]|0)){g=d;l=c[g+4>>2]|0;k=m;c[k>>2]=c[g>>2];c[k+4>>2]=l;k=m+8|0;l=d+8|0;g=c[k>>2]|0;h=g;j=m+12|0;if(!g)g=m+16|0;else{i=c[j>>2]|0;if((i|0)!=(g|0))c[j>>2]=i+(~((i+-4-h|0)>>>2)<<2);mu(g);g=m+16|0;c[g>>2]=0;c[j>>2]=0;c[k>>2]=0}c[k>>2]=c[l>>2];m=d+12|0;c[j>>2]=c[m>>2];k=d+16|0;c[g>>2]=c[k>>2];c[k>>2]=0;c[m>>2]=0;c[l>>2]=0;d=d+20|0}else{g=a;l=c[g+4>>2]|0;k=m;c[k>>2]=c[g>>2];c[k+4>>2]=l;k=m+8|0;l=a+8|0;g=c[k>>2]|0;h=g;j=m+12|0;if(!g)g=m+16|0;else{i=c[j>>2]|0;if((i|0)!=(g|0))c[j>>2]=i+(~((i+-4-h|0)>>>2)<<2);mu(g);g=m+16|0;c[g>>2]=0;c[j>>2]=0;c[k>>2]=0}c[k>>2]=c[l>>2];m=a+12|0;c[j>>2]=c[m>>2];k=a+16|0;c[g>>2]=c[k>>2];c[k>>2]=0;c[m>>2]=0;c[l>>2]=0;a=a+20|0}c[f>>2]=(c[f>>2]|0)+20;if((a|0)==(b|0))break a}if((d|0)==(b|0))return;a=c[f>>2]|0;do{g=d;l=c[g+4>>2]|0;k=a;c[k>>2]=c[g>>2];c[k+4>>2]=l;k=a+8|0;l=d+8|0;g=c[k>>2]|0;h=g;j=a+12|0;if(!g)a=a+16|0;else{i=c[j>>2]|0;if((i|0)!=(g|0))c[j>>2]=i+(~((i+-4-h|0)>>>2)<<2);mu(g);a=a+16|0;c[a>>2]=0;c[j>>2]=0;c[k>>2]=0}c[k>>2]=c[l>>2];e=d+12|0;c[j>>2]=c[e>>2];m=d+16|0;c[a>>2]=c[m>>2];c[m>>2]=0;c[e>>2]=0;c[l>>2]=0;d=d+20|0;a=(c[f>>2]|0)+20|0;c[f>>2]=a}while((d|0)!=(b|0));return}while(0);if((d|0)==(e|0))return;a=c[f>>2]|0;do{g=d;l=c[g+4>>2]|0;k=a;c[k>>2]=c[g>>2];c[k+4>>2]=l;k=a+8|0;l=d+8|0;g=c[k>>2]|0;h=g;j=a+12|0;if(!g)a=a+16|0;else{i=c[j>>2]|0;if((i|0)!=(g|0))c[j>>2]=i+(~((i+-4-h|0)>>>2)<<2);mu(g);a=a+16|0;c[a>>2]=0;c[j>>2]=0;c[k>>2]=0}c[k>>2]=c[l>>2];b=d+12|0;c[j>>2]=c[b>>2];m=d+16|0;c[a>>2]=c[m>>2];c[m>>2]=0;c[b>>2]=0;c[l>>2]=0;d=d+20|0;a=(c[f>>2]|0)+20|0;c[f>>2]=a}while((d|0)!=(e|0));return}function ug(a,b,d,e,f,g,h,j){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0;I=i;i=i+48|0;E=I+44|0;D=I+40|0;C=I+36|0;F=I+32|0;G=I+28|0;H=I+24|0;w=I+20|0;x=I+16|0;y=I+12|0;z=I+8|0;A=I+4|0;B=I;if((f|0)==0|(g|0)==0){i=I;return}u=c[b>>2]|0;k=u;a:while(1){m=c[k>>2]|0;l=c[a>>2]|0;while(1){if((c[l>>2]|0)<(m|0))break;l=l+20|0;c[a>>2]=l;f=f+-1|0;if(!f){m=32;break a}}t=l;if(!((g|0)>(j|0)&(f|0)>(j|0))){l=t;k=u;m=7;break}if((f|0)<(g|0)){s=(g|0)/2|0;n=u+(s*20|0)|0;m=n;if((u|0)!=(t|0)){q=c[n>>2]|0;r=l;p=(u-t|0)/20|0;while(1){v=(p|0)/2|0;o=r+(v*20|0)|0;n=(c[o>>2]|0)<(q|0);o=o+20|0;l=n?l:o;p=n?v:p+-1-v|0;if(!p)break;else r=n?r:o}}v=(l-t|0)/20|0}else{if((f|0)==1){m=14;break}s=(f|0)/2|0;n=l+(s*20|0)|0;l=n;o=c[d>>2]|0;m=u;if((o|0)!=(u|0)){q=c[n>>2]|0;r=m;p=(o-u|0)/20|0;while(1){v=(p|0)/2|0;o=r+(v*20|0)|0;n=(q|0)<(c[o>>2]|0);o=o+20|0;m=n?o:m;p=n?p+-1-v|0:v;if(!p)break;else r=n?o:r}}v=s;s=(m-u|0)/20|0}f=f-v|0;g=g-s|0;n=l;u=m;o=k;b:do if((n|0)!=(k|0))if((k|0)!=(u|0)){q=l;r=o;k=n;n=o;while(1){t=n;M=k;N=c[M>>2]|0;M=c[M+4>>2]|0;Q=k+8|0;K=c[Q>>2]|0;P=k+12|0;p=c[P>>2]|0;O=k+16|0;o=c[O>>2]|0;c[O>>2]=0;c[P>>2]=0;c[Q>>2]=0;L=n;R=L;n=c[R+4>>2]|0;J=k;c[J>>2]=c[R>>2];c[J+4>>2]=n;J=t+8|0;c[Q>>2]=c[J>>2];n=t+12|0;c[P>>2]=c[n>>2];k=t+16|0;c[O>>2]=c[k>>2];c[L>>2]=N;c[L+4>>2]=M;c[J>>2]=K;c[n>>2]=p;c[k>>2]=o;k=q+20|0;o=k;t=t+20|0;n=t;p=(k|0)==(r|0);if((t|0)==(u|0))break;q=o;r=p?n:r}if(!p){q=k;t=r;n=r;while(1){r=t;while(1){p=n;L=q;K=c[L>>2]|0;L=c[L+4>>2]|0;Q=q+8|0;N=c[Q>>2]|0;S=q+12|0;P=c[S>>2]|0;J=q+16|0;R=c[J>>2]|0;c[J>>2]=0;c[S>>2]=0;c[Q>>2]=0;M=n;T=M;n=c[T+4>>2]|0;O=q;c[O>>2]=c[T>>2];c[O+4>>2]=n;O=p+8|0;c[Q>>2]=c[O>>2];Q=p+12|0;c[S>>2]=c[Q>>2];n=p+16|0;c[J>>2]=c[n>>2];c[M>>2]=K;c[M+4>>2]=L;c[O>>2]=N;c[Q>>2]=P;c[n>>2]=R;q=o+20|0;o=q;n=p+20|0;p=(q|0)==(r|0);if((n|0)!=(u|0))break;if(p)break b;else n=t}t=p?n:t}}}else k=n;else k=u;while(0);c[b>>2]=k;if((v+s|0)<(f+g|0)){c[w>>2]=c[a>>2];c[x>>2]=l;c[y>>2]=k;c[C>>2]=c[w>>2];c[D>>2]=c[x>>2];c[E>>2]=c[y>>2];ug(C,D,E,e,v,s,h,j);c[a>>2]=k;l=m}else{c[z>>2]=k;c[A>>2]=m;c[B>>2]=c[d>>2];c[C>>2]=c[z>>2];c[D>>2]=c[A>>2];c[E>>2]=c[B>>2];ug(C,D,E,e,f,g,h,j);c[d>>2]=k;f=v;g=s}c[b>>2]=l;if((g|0)==0|(f|0)==0){m=32;break}else{k=l;u=l}}if((m|0)==7){c[F>>2]=l;c[G>>2]=k;c[H>>2]=c[d>>2];c[C>>2]=c[F>>2];c[D>>2]=c[G>>2];c[E>>2]=c[H>>2];vg(C,D,E,e,f,g,h);i=I;return}else if((m|0)==14){M=l;L=c[M>>2]|0;M=c[M+4>>2]|0;R=l+8|0;O=c[R>>2]|0;T=l+12|0;Q=c[T>>2]|0;N=l+16|0;S=c[N>>2]|0;c[N>>2]=0;c[T>>2]=0;c[R>>2]=0;J=k;K=c[J+4>>2]|0;P=l;c[P>>2]=c[J>>2];c[P+4>>2]=K;P=k+8|0;c[R>>2]=c[P>>2];R=k+12|0;c[T>>2]=c[R>>2];T=k+16|0;c[N>>2]=c[T>>2];N=k;c[N>>2]=L;c[N+4>>2]=M;c[P>>2]=O;c[R>>2]=Q;c[T>>2]=S;i=I;return}else if((m|0)==32){i=I;return}}function vg(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0;E=i;i=i+128|0;C=E+120|0;B=E+112|0;A=E+104|0;z=E+96|0;D=E+88|0;y=E+80|0;k=E+72|0;l=E+68|0;q=E+64|0;r=E+60|0;s=E+56|0;t=E+8|0;u=E;v=E+40|0;w=E+32|0;x=E+24|0;n=E+16|0;o=E+48|0;p=h;if((f|0)>(g|0)){j=c[b>>2]|0;g=j;f=c[d>>2]|0;if((g|0)==(f|0)){m=0;g=h}else{f=g;m=0;g=h;while(1){r=j;j=c[r+4>>2]|0;s=g;c[s>>2]=c[r>>2];c[s+4>>2]=j;s=g+8|0;j=f+8|0;c[s>>2]=0;r=g+12|0;c[r>>2]=0;c[g+16>>2]=0;c[s>>2]=c[j>>2];s=f+12|0;c[r>>2]=c[s>>2];r=f+16|0;c[g+16>>2]=c[r>>2];c[r>>2]=0;c[s>>2]=0;c[j>>2]=0;m=m+1|0;j=f+20|0;g=g+20|0;f=c[d>>2]|0;if((j|0)==(f|0))break;else f=j}j=c[b>>2]|0}d=f;b=t;c[b>>2]=j;c[b+4>>2]=j;b=c[a>>2]|0;a=u;c[a>>2]=b;c[a+4>>2]=b;a=g;c[v>>2]=a;c[v+4>>2]=a;c[w>>2]=p;c[w+4>>2]=p;c[x>>2]=d;c[x+4>>2]=d;c[n>>2]=e;c[y>>2]=c[t>>2];c[y+4>>2]=c[t+4>>2];c[D>>2]=c[u>>2];c[D+4>>2]=c[u+4>>2];c[z>>2]=c[v>>2];c[z+4>>2]=c[v+4>>2];c[A>>2]=c[w>>2];c[A+4>>2]=c[w+4>>2];c[B>>2]=c[x>>2];c[B+4>>2]=c[x+4>>2];c[C>>2]=c[n>>2];xg(o,y,D,z,A,B,C)}else{j=c[a>>2]|0;g=j;f=c[b>>2]|0;if((g|0)==(f|0)){m=0;g=h}else{f=g;m=0;g=h;while(1){x=j;j=c[x+4>>2]|0;y=g;c[y>>2]=c[x>>2];c[y+4>>2]=j;y=g+8|0;j=f+8|0;c[y>>2]=0;x=g+12|0;c[x>>2]=0;c[g+16>>2]=0;c[y>>2]=c[j>>2];y=f+12|0;c[x>>2]=c[y>>2];x=f+16|0;c[g+16>>2]=c[x>>2];c[x>>2]=0;c[y>>2]=0;c[j>>2]=0;m=m+1|0;j=f+20|0;g=g+20|0;f=c[b>>2]|0;if((j|0)==(f|0))break;else f=j}j=c[a>>2]|0}c[k>>2]=h;c[l>>2]=g;c[q>>2]=f;c[r>>2]=c[d>>2];c[s>>2]=j;c[D>>2]=c[k>>2];c[z>>2]=c[l>>2];c[A>>2]=c[q>>2];c[B>>2]=c[r>>2];c[C>>2]=c[s>>2];wg(D,z,A,B,C,e)|0}if((h|0)==0|(m|0)==0){i=E;return}else{f=m;l=0}while(1){k=c[h+8>>2]|0;j=k;if(k){f=h+12|0;g=c[f>>2]|0;if((g|0)!=(k|0))c[f>>2]=g+(~((g+-4-j|0)>>>2)<<2);mu(k);f=m}l=l+1|0;if(l>>>0>=f>>>0)break;else h=h+20|0}i=E;return}function wg(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;g=c[a>>2]|0;o=c[b>>2]|0;h=c[d>>2]|0;p=c[e>>2]|0;a:do if((g|0)==(o|0))g=c[f>>2]|0;else{while(1){if((h|0)==(p|0))break;n=c[f>>2]|0;if((c[g>>2]|0)<(c[h>>2]|0)){e=h;m=c[e+4>>2]|0;l=n;c[l>>2]=c[e>>2];c[l+4>>2]=m;l=n+8|0;m=h+8|0;e=c[l>>2]|0;i=e;k=n+12|0;if(!e)e=n+16|0;else{j=c[k>>2]|0;if((j|0)!=(e|0))c[k>>2]=j+(~((j+-4-i|0)>>>2)<<2);mu(e);e=n+16|0;c[e>>2]=0;c[k>>2]=0;c[l>>2]=0}c[l>>2]=c[m>>2];l=h+12|0;c[k>>2]=c[l>>2];k=h+16|0;c[e>>2]=c[k>>2];c[k>>2]=0;c[l>>2]=0;c[m>>2]=0;h=h+20|0;c[d>>2]=h;e=g}else{h=g;l=c[h+4>>2]|0;k=n;c[k>>2]=c[h>>2];c[k+4>>2]=l;k=n+8|0;l=g+8|0;h=c[k>>2]|0;e=h;j=n+12|0;if(!h)h=n+16|0;else{i=c[j>>2]|0;if((i|0)!=(h|0))c[j>>2]=i+(~((i+-4-e|0)>>>2)<<2);mu(h);h=n+16|0;c[h>>2]=0;c[j>>2]=0;c[k>>2]=0}c[k>>2]=c[l>>2];e=g+12|0;c[j>>2]=c[e>>2];m=g+16|0;c[h>>2]=c[m>>2];c[m>>2]=0;c[e>>2]=0;c[l>>2]=0;e=g+20|0;c[a>>2]=e;h=c[d>>2]|0}g=n+20|0;c[f>>2]=g;if((e|0)==(o|0))break a;else g=e}h=c[a>>2]|0;n=c[b>>2]|0;g=c[f>>2]|0;if((h|0)==(n|0)){p=g;return p|0}do{e=h;m=c[e+4>>2]|0;l=g;c[l>>2]=c[e>>2];c[l+4>>2]=m;l=g+8|0;m=h+8|0;e=c[l>>2]|0;i=e;k=g+12|0;if(!e)e=g+16|0;else{j=c[k>>2]|0;if((j|0)!=(e|0))c[k>>2]=j+(~((j+-4-i|0)>>>2)<<2);mu(e);e=g+16|0;c[e>>2]=0;c[k>>2]=0;c[l>>2]=0}c[l>>2]=c[m>>2];p=h+12|0;c[k>>2]=c[p>>2];f=h+16|0;c[e>>2]=c[f>>2];c[f>>2]=0;c[p>>2]=0;c[m>>2]=0;h=h+20|0;g=g+20|0}while((h|0)!=(n|0));return g|0}while(0);if((h|0)==(p|0)){p=g;return p|0}do{e=h;m=c[e+4>>2]|0;l=g;c[l>>2]=c[e>>2];c[l+4>>2]=m;l=g+8|0;m=h+8|0;e=c[l>>2]|0;i=e;k=g+12|0;if(!e)e=g+16|0;else{j=c[k>>2]|0;if((j|0)!=(e|0))c[k>>2]=j+(~((j+-4-i|0)>>>2)<<2);mu(e);e=g+16|0;c[e>>2]=0;c[k>>2]=0;c[l>>2]=0}c[l>>2]=c[m>>2];f=h+12|0;c[k>>2]=c[f>>2];b=h+16|0;c[e>>2]=c[b>>2];c[b>>2]=0;c[f>>2]=0;c[m>>2]=0;h=h+20|0;g=g+20|0}while((h|0)!=(p|0));return g|0}function xg(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0;r=b+4|0;h=c[r>>2]|0;s=c[d+4>>2]|0;a:do if((h|0)!=(s|0)){t=e+4|0;u=c[f+4>>2]|0;v=g+4|0;i=c[t>>2]|0;while(1){if((i|0)==(u|0))break;k=i+-20|0;q=h+-20|0;j=c[v>>2]|0;l=j+-20|0;if((c[q>>2]|0)<(c[k>>2]|0)){k=q;p=c[k+4>>2]|0;o=l;c[o>>2]=c[k>>2];c[o+4>>2]=p;o=j+-12|0;p=h+-12|0;k=c[o>>2]|0;l=k;n=j+-8|0;if(!k)k=j+-4|0;else{m=c[n>>2]|0;if((m|0)!=(k|0))c[n>>2]=m+(~((m+-4-l|0)>>>2)<<2);mu(k);k=j+-4|0;c[k>>2]=0;c[n>>2]=0;c[o>>2]=0}c[o>>2]=c[p>>2];o=h+-8|0;c[n>>2]=c[o>>2];h=h+-4|0;c[k>>2]=c[h>>2];c[h>>2]=0;c[o>>2]=0;c[p>>2]=0;c[r>>2]=q;h=q}else{h=k;o=c[h+4>>2]|0;n=l;c[n>>2]=c[h>>2];c[n+4>>2]=o;n=j+-12|0;o=i+-12|0;h=c[n>>2]|0;k=h;m=j+-8|0;if(!h)h=j+-4|0;else{l=c[m>>2]|0;if((l|0)!=(h|0))c[m>>2]=l+(~((l+-4-k|0)>>>2)<<2);mu(h);h=j+-4|0;c[h>>2]=0;c[m>>2]=0;c[n>>2]=0}c[n>>2]=c[o>>2];j=i+-8|0;c[m>>2]=c[j>>2];i=i+-4|0;c[h>>2]=c[i>>2];c[i>>2]=0;c[j>>2]=0;c[o>>2]=0;i=(c[t>>2]|0)+-20|0;c[t>>2]=i;j=c[v>>2]|0;h=c[r>>2]|0}c[v>>2]=j+-20;if((h|0)==(s|0))break a}h=g;s=c[h>>2]|0;h=c[h+4>>2]|0;i=c[b+4>>2]|0;r=c[d+4>>2]|0;if((i|0)!=(r|0))while(1){n=h+-20|0;o=i;i=i+-20|0;j=i;q=c[j+4>>2]|0;p=n;c[p>>2]=c[j>>2];c[p+4>>2]=q;p=h+-12|0;q=o+-12|0;j=c[p>>2]|0;k=j;m=h+-8|0;if(!j)h=h+-4|0;else{l=c[m>>2]|0;if((l|0)!=(j|0))c[m>>2]=l+(~((l+-4-k|0)>>>2)<<2);mu(j);h=h+-4|0;c[h>>2]=0;c[m>>2]=0;c[p>>2]=0}c[p>>2]=c[q>>2];f=o+-8|0;c[m>>2]=c[f>>2];d=o+-4|0;c[h>>2]=c[d>>2];c[d>>2]=0;c[f>>2]=0;c[q>>2]=0;if((i|0)==(r|0)){h=n;break}else h=n}c[a>>2]=s;c[a+4>>2]=h;return}while(0);h=g;s=c[h>>2]|0;h=c[h+4>>2]|0;i=c[e+4>>2]|0;r=c[f+4>>2]|0;if((i|0)!=(r|0))while(1){n=h+-20|0;o=i;i=i+-20|0;j=i;q=c[j+4>>2]|0;p=n;c[p>>2]=c[j>>2];c[p+4>>2]=q;p=h+-12|0;q=o+-12|0;j=c[p>>2]|0;k=j;m=h+-8|0;if(!j)h=h+-4|0;else{l=c[m>>2]|0;if((l|0)!=(j|0))c[m>>2]=l+(~((l+-4-k|0)>>>2)<<2);mu(j);h=h+-4|0;c[h>>2]=0;c[m>>2]=0;c[p>>2]=0}c[p>>2]=c[q>>2];f=o+-8|0;c[m>>2]=c[f>>2];d=o+-4|0;c[h>>2]=c[d>>2];c[d>>2]=0;c[f>>2]=0;c[q>>2]=0;if((i|0)==(r|0)){h=n;break}else h=n}c[a>>2]=s;c[a+4>>2]=h;return}function yg(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0;S=i;i=i+208|0;N=S+184|0;R=S+40|0;h=S+24|0;H=S+12|0;I=S;O=R+8|0;c[O>>2]=3508;P=R+12|0;c[R>>2]=3712;Q=R+64|0;c[Q>>2]=3732;c[R+4>>2]=0;fm(R+64|0,P);c[R+136>>2]=0;c[R+140>>2]=-1;c[R>>2]=3488;c[R+64>>2]=3528;c[O>>2]=3508;hm(P);c[P>>2]=3544;O=R+44|0;c[O>>2]=0;c[O+4>>2]=0;c[O+8>>2]=0;c[O+12>>2]=0;c[R+60>>2]=24;c[N>>2]=0;c[N+4>>2]=0;c[N+8>>2]=0;Td(P,N);vk(N);if(!(c[245967]|0)){N=dl()|0;N=fv(N|0,C|0,1e6,0)|0;l=983984;l=Vu(N|0,C|0,c[l>>2]|0,c[l+4>>2]|0)|0}else l=Rg(1148216)|0;J=l+1|0;K=d+5352|0;j=c[K>>2]|0;L=j+5532|0;M=c[j+140>>2]|0;rk(h,17321,7);N=qh(Zd(1148396,h)|0)|0;j=j+5536|0;F=((c[j>>2]|0)-(c[L>>2]|0)|0)/20|0;N=F>>>0<N>>>0?F:N;vk(h);F=Rg(1148216)|0;G=C;k=Sg(1148216)|0;if(!0){h=0;j=0}else{h=((c[j>>2]|0)-(c[L>>2]|0)|0)/20|0;j=0}u=Xu(h|0,j|0,k|0,C|0)|0;v=C;if(!N){e=R+8|0;Wd(b,P);c[R>>2]=3488;c[Q>>2]=3528;c[e>>2]=3508;c[P>>2]=3544;vk(O);il(P);el(Q);i=S;return}t=(e|0)!=1;w=R+24|0;x=R+28|0;h=R+8|0;y=H+8|0;z=H+1|0;A=H+4|0;B=hv(F|0,G|0,1e3,0)|0;D=C;E=((J|0)<0)<<31>>31;s=(l|0)>999;o=d+5360|0;p=I+8|0;q=I+1|0;r=I+4|0;n=0;while(1){l=n>>>0<=M>>>0;if(t|l){j=c[L>>2]|0;j=l?c[j+(n*20|0)>>2]|0:c[j+(n*20|0)+4>>2]|0;if(!0)m=0;else m=(((j|0)>-1?j:0-j|0)|0)<31872;d=m?0:j;j=c[w>>2]|0;k=c[x>>2]|0;if(j>>>0<k>>>0)j=k-j|0;else j=Fb[c[(c[P>>2]|0)+28>>2]&127](P)|0;if(j|0)Ud(h,16880,1)|0;T=Ud(tm(Ud(Ud(h,16377,4)|0,16382,7)|0,((l^1)<<31>>31)+e|0)|0,16390,10)|0;j=n+1|0;T=Ud(um(Ud(tm(T,c[(c[K>>2]|0)+144>>2]|0)|0,16401,9)|0,j)|0,16411,7)|0;lh(H,d);l=a[H>>0]|0;k=(l&1)==0;Ud(T,k?z:c[y>>2]|0,k?(l&255)>>>1:c[A>>2]|0)|0;vk(H);if((n|0)==(M|0)&(m^1)){T=(d|0)<(g|0)?((d|0)<=(f|0)?16419:1219563):16431;Ud(h,T,Mh(T)|0)|0}m=Ud(wm(Ud(h,16443,7)|0,F,G)|0,16451,5)|0;T=iv(B|0,D|0,J|0,E|0)|0;wm(m,T,C)|0;if(s){T=Ud(h,16457,10)|0;tm(T,ah(1148256)|0)|0}Ud(tm(Ud(wm(Ud(h,16468,8)|0,u,v)|0,16477,6)|0,J)|0,16484,3)|0;l=c[L>>2]|0;k=c[l+(n*20|0)+8>>2]|0;l=c[l+(n*20|0)+12>>2]|0;if((k|0)!=(l|0))do{T=c[k>>2]|0;m=Ud(h,17070,1)|0;hh(I,T,(a[o>>0]|0)!=0);T=a[I>>0]|0;n=(T&1)==0;Ud(m,n?q:c[p>>2]|0,n?(T&255)>>>1:c[r>>2]|0)|0;vk(I);k=k+4|0}while((k|0)!=(l|0))}else j=n+1|0;if(j>>>0<N>>>0)n=j;else break}Wd(b,P);c[R>>2]=3488;c[Q>>2]=3528;c[h>>2]=3508;c[P>>2]=3544;vk(O);il(P);el(Q);i=S;return}function zg(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;d=c[287054]|0;if((c[287055]|0)==(d|0))gt(1148216);d=c[d>>2]|0;if((a[983968]|0)==0?Ca(983968)|0:0){l=dl()|0;l=fv(l|0,C|0,1e6,0)|0;m=990024;c[m>>2]=l;c[m+4>>2]=C;Ja(983968)}j=c[d+5532>>2]|0;k=c[j>>2]|0;l=k-(c[j+((b+-1|0)*20|0)>>2]|0)|0;l=(l|0)>188?188:l;m=125-(((c[245986]|0)*9|0)/4|0)|0;if(!b){b=c[245987]|0;return b|0}d=990024;i=k;e=c[d>>2]|0;d=c[d+4>>2]|0;g=0;h=-32001;while(1){f=_(k-i|0,m)|0;n=Yu(e|0,d|0,12)|0;e=n^e;d=C^d;n=Zu(e|0,d|0,25)|0;e=n^e;d=C^d;n=Yu(e|0,d|0,27)|0;e=n^e;d=C^d;n=hv(e|0,d|0,1332534557,625341585)|0;f=(((_((n>>>0)%(m>>>0)|0,l)|0)+f|0)>>>7)+i|0;if((f|0)>(h|0))c[245987]=c[c[j+(g*20|0)+8>>2]>>2];else f=h;g=g+1|0;if((g|0)==(b|0))break;i=c[j+(g*20|0)>>2]|0;h=f}n=990024;c[n>>2]=e;c[n+4>>2]=d;n=c[245987]|0;return n|0}function Ag(a){a=a|0;Bg(a);return}function Bg(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;p=i;i=i+64|0;n=p+60|0;g=p+48|0;h=p+36|0;l=p+24|0;m=p+12|0;o=p;if(c[245967]|0){e=c[983860+(c[269215]<<2)>>2]|0;j=Rg(1148216)|0;j=Vu(e|0,((e|0)<0)<<31>>31|0,j|0,C|0)|0;e=983976;e=Xu(j|0,C|0,c[e>>2]|0,c[e+4>>2]|0)|0;j=983976;c[j>>2]=e;c[j+4>>2]=C}if((a[1217488]&1)==0?c[245972]|c[245973]|0:0){a[1217489]=1;Mg(b,1217488)}a[1217488]=1;d=c[287054]|0;j=c[287055]|0;if((d|0)!=(j|0))do{e=c[d>>2]|0;if((e|0)!=(b|0))Lg(e);d=d+4|0}while((d|0)!=(j|0));do if(!(a[b+4241332>>0]|0)){rk(g,17321,7);j=(qh(Zd(1148396,g)|0)|0)!=1;if(j|(c[245969]|0)!=0){vk(g);d=b;break}rk(h,17329,11);if((qh(Zd(1148396,h)|0)|0)<20){vk(h);vk(g);d=b;break}j=(c[c[(c[b+5532>>2]|0)+8>>2]>>2]|0)==0;vk(h);vk(g);if(!j?(f=c[287054]|0,k=c[287055]|0,(f|0)!=(k|0)):0){d=b;do{e=c[f>>2]|0;if((c[e+5548>>2]|0)>(c[d+5548>>2]|0))d=(c[c[e+5532>>2]>>2]|0)>(c[c[d+5532>>2]>>2]|0)?e:d;f=f+4|0}while((f|0)!=(k|0))}else d=b}else d=b;while(0);f=d+5532|0;c[b+4241344>>2]=c[c[f>>2]>>2];if((d|0)!=(b|0)){h=oe(1149064,0)|0;yg(l,d+160|0,c[d+5548>>2]|0,-32001,32001);k=a[l>>0]|0;j=(k&1)==0;k=Ud(h,j?l+1|0:c[l+8>>2]|0,j?(k&255)>>>1:c[l+4>>2]|0)|0;c[n>>2]=gm(k+(c[(c[k>>2]|0)+-12>>2]|0)|0)|0;j=Om(n,1150100)|0;j=Lb[c[(c[j>>2]|0)+28>>2]&63](j,10)|0;_t(n);ym(k,j)|0;lm(k)|0;oe(k,1)|0;vk(l)}k=Ud(oe(1149064,0)|0,16488,9)|0;e=b+5520|0;hh(m,c[c[(c[f>>2]|0)+8>>2]>>2]|0,(a[e>>0]|0)!=0);d=a[m>>0]|0;l=(d&1)==0;Ud(k,l?m+1|0:c[m+8>>2]|0,l?(d&255)>>>1:c[m+4>>2]|0)|0;vk(m);d=c[f>>2]|0;if((c[d+12>>2]|0)-(c[d+8>>2]|0)>>2>>>0<=1?!(Cg(d,b+160|0)|0):0){b=c[287266]|0;b=b+-12|0;b=c[b>>2]|0;b=1149064+b|0;b=gm(b)|0;c[n>>2]=b;b=Om(n,1150100)|0;o=c[b>>2]|0;o=o+28|0;o=c[o>>2]|0;b=Lb[o&63](b,10)|0;_t(n);ym(1149064,b)|0;lm(1149064)|0;oe(1149064,1)|0;i=p;return}l=Ud(1149064,16498,8)|0;hh(o,c[(c[(c[f>>2]|0)+8>>2]|0)+4>>2]|0,(a[e>>0]|0)!=0);b=a[o>>0]|0;m=(b&1)==0;Ud(l,m?o+1|0:c[o+8>>2]|0,m?(b&255)>>>1:c[o+4>>2]|0)|0;vk(o);b=c[287266]|0;b=b+-12|0;b=c[b>>2]|0;b=1149064+b|0;b=gm(b)|0;c[n>>2]=b;b=Om(n,1150100)|0;o=c[b>>2]|0;o=o+28|0;o=c[o>>2]|0;b=Lb[o&63](b,10)|0;_t(n);ym(1149064,b)|0;lm(1149064)|0;oe(1149064,1)|0;i=p;return}function Cg(b,d){b=b|0;d=d|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0;m=i;i=i+4560|0;g=m+4544|0;l=m+4540|0;h=m+440|0;k=b+8|0;f=c[c[k>>2]>>2]|0;if(!f){b=0;i=m;return b|0}Nf(d,f,m,Lf(d,f)|0);f=(c[d+5356>>2]|0)+56|0;f=$g(1148256,c[f>>2]|0,c[f+4>>2]|0,g)|0;if(a[g>>0]|0){j=e[f+2>>1]|0;c[l>>2]=j;g=df(d,h)|0;c[h+4096>>2]=g;a:do if((h|0)!=(g|0)){f=h;while(1){if((c[f>>2]|0)==(j|0))break;f=f+8|0;if((f|0)==(g|0))break a}f=b+12|0;g=c[f>>2]|0;if((g|0)==(c[b+16>>2]|0)){ng(k,l);break}else{c[g>>2]=j;c[f>>2]=g+4;break}}while(0)}Pf(d,c[c[k>>2]>>2]|0);b=(c[b+12>>2]|0)-(c[k>>2]|0)>>2>>>0>1;i=m;return b|0}function Dg(){var a=0,b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0;d=i;i=i+96|0;a=d;rk(a,17165,5);b=a+12|0;rk(b,17171,8);e=a+24|0;rk(e,17180,6);f=a+36|0;rk(f,17187,10);g=a+48|0;rk(g,17198,5);h=a+60|0;rk(h,17204,13);j=a+72|0;rk(j,17218,11);k=a+84|0;rk(k,17230,10);l=Nu(96)|0;c[287052]=l;c[287051]=l;c[287053]=l+96;qk(l,a);l=(c[287052]|0)+12|0;c[287052]=l;qk(l,b);l=(c[287052]|0)+12|0;c[287052]=l;qk(l,e);l=(c[287052]|0)+12|0;c[287052]=l;qk(l,f);l=(c[287052]|0)+12|0;c[287052]=l;qk(l,g);l=(c[287052]|0)+12|0;c[287052]=l;qk(l,h);l=(c[287052]|0)+12|0;c[287052]=l;qk(l,j);l=(c[287052]|0)+12|0;c[287052]=l;qk(l,k);c[287052]=(c[287052]|0)+12;vk(k);vk(j);vk(h);vk(g);vk(f);vk(e);vk(b);vk(a);b=983840;e=b+64|0;do{c[b>>2]=0;b=b+4|0}while((b|0)<(e|0));l=Nu(8)|0;c[270575]=l;k=l+8|0;c[270577]=k;c[l>>2]=0;c[l+4>>2]=1;c[270576]=k;k=Nu(8)|0;c[270578]=k;l=k+8|0;c[270580]=l;c[k>>2]=1;c[k+4>>2]=0;c[270579]=l;l=Nu(16)|0;c[270581]=l;k=l+16|0;c[270583]=k;c[l>>2]=0;c[l+4>>2]=0;c[l+8>>2]=1;c[l+12>>2]=1;c[270582]=k;k=Nu(16)|0;c[270584]=k;l=k+16|0;c[270586]=l;c[k>>2]=0;c[k+4>>2]=1;c[k+8>>2]=1;c[k+12>>2]=0;c[270585]=l;l=Nu(16)|0;c[270587]=l;k=l+16|0;c[270589]=k;c[l>>2]=1;c[l+4>>2]=1;c[l+8>>2]=0;c[l+12>>2]=0;c[270588]=k;k=Nu(16)|0;c[270590]=k;l=k+16|0;c[270592]=l;c[k>>2]=1;c[k+4>>2]=0;c[k+8>>2]=0;c[k+12>>2]=1;c[270591]=l;l=Nu(24)|0;c[270593]=l;k=l+24|0;c[270595]=k;c[l>>2]=0;c[l+4>>2]=0;c[l+8>>2]=0;c[l+12>>2]=1;c[l+16>>2]=1;c[l+20>>2]=1;c[270594]=k;k=Nu(24)|0;c[270596]=k;l=k+24|0;c[270598]=l;c[k>>2]=0;c[k+4>>2]=0;c[k+8>>2]=1;c[k+12>>2]=1;c[k+16>>2]=1;c[k+20>>2]=0;c[270597]=l;l=Nu(24)|0;c[270599]=l;k=l+24|0;c[270601]=k;c[l>>2]=0;c[l+4>>2]=1;c[l+8>>2]=1;c[l+12>>2]=1;c[l+16>>2]=0;c[l+20>>2]=0;c[270600]=k;k=Nu(24)|0;c[270602]=k;l=k+24|0;c[270604]=l;c[k>>2]=1;c[k+4>>2]=1;c[k+8>>2]=1;c[k+12>>2]=0;c[k+16>>2]=0;c[k+20>>2]=0;c[270603]=l;l=Nu(24)|0;c[270605]=l;k=l+24|0;c[270607]=k;c[l>>2]=1;c[l+4>>2]=1;c[l+8>>2]=0;c[l+12>>2]=0;c[l+16>>2]=0;c[l+20>>2]=1;c[270606]=k;k=Nu(24)|0;c[270608]=k;l=k+24|0;c[270610]=l;c[k>>2]=1;c[k+4>>2]=0;c[k+8>>2]=0;c[k+12>>2]=0;c[k+16>>2]=1;c[k+20>>2]=1;c[270609]=l;l=Nu(32)|0;c[270611]=l;k=l+32|0;c[270613]=k;c[l>>2]=0;c[l+4>>2]=0;c[l+8>>2]=0;c[l+12>>2]=0;c[l+16>>2]=1;c[l+20>>2]=1;c[l+24>>2]=1;c[l+28>>2]=1;c[270612]=k;k=Nu(32)|0;c[270614]=k;l=k+32|0;c[270616]=l;c[k>>2]=0;c[k+4>>2]=0;c[k+8>>2]=0;c[k+12>>2]=1;c[k+16>>2]=1;c[k+20>>2]=1;c[k+24>>2]=1;c[k+28>>2]=0;c[270615]=l;l=Nu(32)|0;c[270617]=l;k=l+32|0;c[270619]=k;c[l>>2]=0;c[l+4>>2]=0;c[l+8>>2]=1;c[l+12>>2]=1;c[l+16>>2]=1;c[l+20>>2]=1;c[l+24>>2]=0;c[l+28>>2]=0;c[270618]=k;k=Nu(32)|0;c[270620]=k;l=k+32|0;c[270622]=l;c[k>>2]=0;c[k+4>>2]=1;c[k+8>>2]=1;c[k+12>>2]=1;c[k+16>>2]=1;c[k+20>>2]=0;c[k+24>>2]=0;c[k+28>>2]=0;c[270621]=l;l=Nu(32)|0;c[270623]=l;k=l+32|0;c[270625]=k;c[l>>2]=1;c[l+4>>2]=1;c[l+8>>2]=1;c[l+12>>2]=1;l=l+16|0;c[l>>2]=0;c[l+4>>2]=0;c[l+8>>2]=0;c[l+12>>2]=0;c[270624]=k;k=Nu(32)|0;c[270626]=k;l=k+32|0;c[270628]=l;c[k>>2]=1;c[k+4>>2]=1;c[k+8>>2]=1;j=k+12|0;c[j>>2]=0;c[j+4>>2]=0;c[j+8>>2]=0;c[j+12>>2]=0;c[k+28>>2]=1;c[270627]=l;l=Nu(32)|0;c[270629]=l;k=l+32|0;c[270631]=k;c[l>>2]=1;c[l+4>>2]=1;j=l+8|0;c[j>>2]=0;c[j+4>>2]=0;c[j+8>>2]=0;c[j+12>>2]=0;c[l+24>>2]=1;c[l+28>>2]=1;c[270630]=k;k=Nu(32)|0;c[270632]=k;l=k+32|0;c[270634]=l;c[k>>2]=1;j=k+4|0;c[j>>2]=0;c[j+4>>2]=0;c[j+8>>2]=0;c[j+12>>2]=0;c[k+20>>2]=1;c[k+24>>2]=1;c[k+28>>2]=1;c[270633]=l;rk(a,17329,11);c[245986]=qh(Zd(1148396,a)|0)|0;c[245987]=0;vk(a);i=d;return}function Eg(){var a=0,b=0.0,d=0,e=0,f=0,g=0;e=1;do{b=+Y(+(+(e|0)));f=1;do{a=~~+cv(+(b*+Y(+(+(f|0)))*.5));d=1082668+(e<<8)+(f<<2)|0;c[d>>2]=a;g=a+-1|0;c[1115436+(e<<8)+(f<<2)>>2]=(g|0)<0?0:g;if((a|0)>1)c[d>>2]=a+1;f=f+1|0}while((f|0)!=64);e=e+1|0}while((e|0)!=64);a=1;do{b=+Y(+(+(a|0)));d=1;do{g=~~+cv(+(b*+Y(+(+(d|0)))*.5));c[1099052+(a<<8)+(d<<2)>>2]=g;g=g+-1|0;c[1131820+(a<<8)+(d<<2)>>2]=(g|0)<0?0:g;d=d+1|0}while((d|0)!=64);a=a+1|0}while((a|0)!=64);a=0;do{b=+(a|0);c[1082540+(a<<2)>>2]=~~(+P(+b,1.8)*.773+2.4);c[1082604+(a<<2)>>2]=~~(+P(+(b+.49),1.8)*1.045+2.9);a=a+1|0}while((a|0)!=16);return}function Fg(){var b=0,d=0,e=0;_g(1148256);b=c[287054]|0;d=c[287055]|0;if((b|0)!=(d|0)){do{e=c[b>>2]|0;Wu(e+5556|0,0,4235776)|0;a[e+5552>>0]=1;b=b+4|0}while((b|0)!=(d|0));d=c[287055]|0;b=c[287054]|0}if((d|0)==(b|0))gt(1148216);else{c[(c[b>>2]|0)+4241344>>2]=32001;return}}function Gg(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;c[b>>2]=7972;k=b+8|0;lk(k);a[b+84>>0]=1;l=b+36|0;Gj(l);mk(k);m=b+4|0;cl(m);i=b+5532|0;d=c[i>>2]|0;if(d|0){j=b+5536|0;e=c[j>>2]|0;if((e|0)!=(d|0)){f=e;while(1){e=f+-20|0;c[j>>2]=e;g=c[f+-12>>2]|0;h=g;if(g){e=f+-8|0;f=c[e>>2]|0;if((f|0)!=(g|0))c[e>>2]=f+(~((f+-4-h|0)>>>2)<<2);mu(g);e=c[j>>2]|0}if((e|0)==(d|0))break;else f=e}d=c[i>>2]|0}mu(d)}Hg(b+124|0,c[b+128>>2]|0);Ig(b+112|0,c[b+116>>2]|0);d=c[b+100>>2]|0;e=d;if(d|0){f=b+104|0;g=c[f>>2]|0;if((g|0)!=(d|0))c[f>>2]=g+(~((g+-32-e|0)>>>5)<<5);mu(d)}f=c[b+88>>2]|0;if(!f){Fj(l);kk(k);bl(m);return}d=b+92|0;e=c[d>>2]|0;if((e|0)!=(f|0))c[d>>2]=e+(~(((e+-120-f|0)>>>0)/120|0)*120|0);mu(f);Fj(l);kk(k);bl(m);return}function Hg(a,b){a=a|0;b=b|0;var d=0;if(!b)return;Hg(a,c[b>>2]|0);Hg(a,c[b+4>>2]|0);d=b+24|0;a=c[d>>2]|0;c[d>>2]=0;if(a|0)Bb[c[(c[a>>2]|0)+4>>2]&255](a);mu(b);return}function Ig(a,b){a=a|0;b=b|0;var d=0;if(!b)return;Ig(a,c[b>>2]|0);Ig(a,c[b+4>>2]|0);d=b+24|0;a=c[d>>2]|0;c[d>>2]=0;if(a|0)Bb[c[(c[a>>2]|0)+4>>2]&255](a);mu(b);return}function Jg(a){a=a|0;Gg(a);mu(a);return}function Kg(){var a=0,b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0;a=i;i=i+96|0;b=a;rk(b,17165,5);d=b+12|0;rk(d,17171,8);e=b+24|0;rk(e,17180,6);f=b+36|0;rk(f,17187,10);g=b+48|0;rk(g,17198,5);h=b+60|0;rk(h,17204,13);j=b+72|0;rk(j,17218,11);k=b+84|0;rk(k,17230,10);l=Nu(96)|0;c[287059]=l;c[287058]=l;c[287060]=l+96;qk(l,b);l=(c[287059]|0)+12|0;c[287059]=l;qk(l,d);l=(c[287059]|0)+12|0;c[287059]=l;qk(l,e);l=(c[287059]|0)+12|0;c[287059]=l;qk(l,f);l=(c[287059]|0)+12|0;c[287059]=l;qk(l,g);l=(c[287059]|0)+12|0;c[287059]=l;qk(l,h);l=(c[287059]|0)+12|0;c[287059]=l;qk(l,j);l=(c[287059]|0)+12|0;c[287059]=l;qk(l,k);c[287059]=(c[287059]|0)+12;vk(k);vk(j);vk(h);vk(g);vk(f);vk(e);vk(d);vk(b);c[287054]=0;c[287055]=0;c[287056]=0;c[287057]=0;i=a;return}function Lg(b){b=b|0;var d=0,e=0,f=0,g=0;g=i;i=i+16|0;f=g;e=b+8|0;c[f>>2]=e;d=f+4|0;a[d>>0]=1;lk(e);e=b+36|0;b=b+85|0;if(a[b>>0]|0){do Hj(e,f);while((a[b>>0]|0)!=0);if(!(a[d>>0]|0)){i=g;return}}mk(c[f>>2]|0);i=g;return}function Mg(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0;g=i;i=i+16|0;f=g;h=b+8|0;c[f>>2]=h;e=f+4|0;a[e>>0]=1;lk(h);b=b+36|0;if(!(a[d>>0]&1))do Hj(b,f);while(!(a[d>>0]&1));if(!(a[e>>0]|0)){i=g;return}mk(c[f>>2]|0);i=g;return}function Ng(b,c){b=b|0;c=c|0;var d=0;d=b+8|0;lk(d);if(!c)a[b+85>>0]=1;Gj(b+36|0);mk(d);return}function Og(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0;k=i;i=i+16|0;h=k;j=Nu(4241352)|0;c[j>>2]=7972;e=j+88|0;g=j+92|0;d=j+4|0;f=d+80|0;do{c[d>>2]=0;d=d+4|0}while((d|0)<(f|0));d=Nu(1966080)|0;c[g>>2]=d;c[e>>2]=d;c[j+96>>2]=d+1966080;e=16384;do{f=d+120|0;do{c[d>>2]=0;d=d+4|0}while((d|0)<(f|0));d=(c[g>>2]|0)+120|0;c[g>>2]=d;e=e+-1|0}while((e|0)!=0);e=j+104|0;f=Nu(262144)|0;c[e>>2]=f;c[j+100>>2]=f;c[j+108>>2]=f+262144;d=8192;do{c[f>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;c[f+16>>2]=0;c[f+20>>2]=0;c[f+24>>2]=0;c[f+28>>2]=0;f=(c[e>>2]|0)+32|0;c[e>>2]=f;d=d+-1|0}while((d|0)!=0);gc(j+112|0);c[j+5532>>2]=0;c[j+5536>>2]=0;c[j+5540>>2]=0;a[j+84>>0]=0;a[j+5552>>0]=0;d=j+144|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;Wu(j+5556|0,0,8192)|0;c[j+136>>2]=(c[287055]|0)-(c[287054]|0)>>2;a[j+85>>0]=0;c[j>>2]=7760;c[h>>2]=j;d=b+4|0;e=c[d>>2]|0;if(e>>>0<(c[b+8>>2]|0)>>>0){c[e>>2]=j;c[d>>2]=(c[d>>2]|0)+4;Qg(b);i=k;return}else{Pg(b,h);Qg(b);i=k;return}}function Pg(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;i=a+4|0;j=c[a>>2]|0;d=((c[i>>2]|0)-j>>2)+1|0;if(d>>>0>1073741823)ft(a);k=a+8|0;e=(c[k>>2]|0)-j|0;if(e>>2>>>0<536870911){f=e>>1;d=f>>>0<d>>>0?d:f;f=c[i>>2]|0;e=f-j>>2;if(!d){h=0;g=0;d=f}else l=6}else{e=c[i>>2]|0;d=1073741823;f=e;e=e-j>>2;l=6}if((l|0)==6){h=d;g=Nu(d<<2)|0;d=f}l=g+(e<<2)|0;c[l>>2]=c[b>>2];f=d-j|0;b=l+(0-(f>>2)<<2)|0;_u(b|0,j|0,f|0)|0;c[a>>2]=b;c[i>>2]=l+4;c[k>>2]=g+(h<<2);if(!j)return;mu(j);return}function Qg(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;n=i;i=i+16|0;m=n+4|0;k=n;rk(m,17277,7);l=qh(Zd(1148396,m)|0)|0;vk(m);m=b+4|0;f=c[m>>2]|0;e=c[b>>2]|0;d=f;if(f-e>>2>>>0<l>>>0){j=b+8|0;do{h=Nu(4241336)|0;c[h>>2]=7972;e=h+88|0;g=h+92|0;d=h+4|0;f=d+80|0;do{c[d>>2]=0;d=d+4|0}while((d|0)<(f|0));d=Nu(1966080)|0;c[g>>2]=d;c[e>>2]=d;c[h+96>>2]=d+1966080;e=16384;do{f=d+120|0;do{c[d>>2]=0;d=d+4|0}while((d|0)<(f|0));d=(c[g>>2]|0)+120|0;c[g>>2]=d;e=e+-1|0}while((e|0)!=0);e=h+104|0;f=Nu(262144)|0;c[e>>2]=f;c[h+100>>2]=f;c[h+108>>2]=f+262144;d=8192;do{c[f>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;c[f+16>>2]=0;c[f+20>>2]=0;c[f+24>>2]=0;c[f+28>>2]=0;f=(c[e>>2]|0)+32|0;c[e>>2]=f;d=d+-1|0}while((d|0)!=0);gc(h+112|0);c[h+5532>>2]=0;c[h+5536>>2]=0;c[h+5540>>2]=0;a[h+84>>0]=0;a[h+5552>>0]=0;d=h+144|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;Wu(h+5556|0,0,8192)|0;c[h+136>>2]=(c[287055]|0)-(c[287054]|0)>>2;a[h+85>>0]=0;c[k>>2]=h;d=c[m>>2]|0;if(d>>>0<(c[j>>2]|0)>>>0){c[d>>2]=h;d=(c[m>>2]|0)+4|0;c[m>>2]=d;f=d}else{Pg(b,k);d=c[m>>2]|0;f=d}e=c[b>>2]|0}while(f-e>>2>>>0<l>>>0)}if(f-e>>2>>>0>l>>>0)f=d;else{i=n;return}do{d=c[f+-4>>2]|0;if(!d)d=f;else{Bb[c[(c[d>>2]|0)+4>>2]&255](d);d=c[m>>2]|0;e=c[b>>2]|0}f=d+-4|0;c[m>>2]=f}while(f-e>>2>>>0>l>>>0);i=n;return}function Rg(a){a=a|0;var b=0,d=0,e=0,f=0;d=c[a>>2]|0;e=c[a+4>>2]|0;if((d|0)==(e|0)){d=0;e=0;C=d;return e|0}else{a=0;b=0}do{f=(c[d>>2]|0)+5496|0;a=Xu(c[f>>2]|0,c[f+4>>2]|0,a|0,b|0)|0;b=C;d=d+4|0}while((d|0)!=(e|0));C=b;return a|0}function Sg(a){a=a|0;var b=0,d=0,e=0,f=0;d=c[a>>2]|0;e=c[a+4>>2]|0;if((d|0)==(e|0)){d=0;e=0;C=d;return e|0}else{a=0;b=0}do{f=(c[d>>2]|0)+152|0;a=Xu(c[f>>2]|0,c[f+4>>2]|0,a|0,b|0)|0;b=C;d=d+4|0}while((d|0)!=(e|0));C=b;return a|0}function Tg(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0;B=i;i=i+4592|0;A=B+4576|0;k=B+476|0;u=B;y=B+24|0;x=B+464|0;a[1217488]=0;a[1217489]=0;if((f|0)!=983840)Ug(983840,c[f>>2]|0,c[f+4>>2]|0);g=983852;h=f+12|0;j=g+60|0;do{c[g>>2]=c[h>>2];g=g+4|0;h=h+4|0}while((g|0)<(j|0));c[A>>2]=0;z=A+4|0;c[z>>2]=0;c[A+8>>2]=0;m=df(d,k)|0;c[k+4096>>2]=m;if((k|0)!=(m|0)){n=f+4|0;o=u+4|0;p=u+8|0;q=u+12|0;r=u+16|0;s=A+8|0;t=u+8|0;do{g=c[f>>2]|0;j=c[n>>2]|0;l=c[k>>2]|0;if((g|0)!=(j|0)){h=g;g=0;do{g=((c[h>>2]|0)==(l|0)&1)+g|0;h=h+4|0}while((h|0)!=(j|0));if(g|0)v=9}else v=9;do if((v|0)==9){v=0;c[u>>2]=-32001;c[o>>2]=-32001;j=Nu(4)|0;c[p>>2]=j;h=j+4|0;c[r>>2]=h;c[j>>2]=l;c[q>>2]=h;g=c[z>>2]|0;if(g>>>0<(c[s>>2]|0)>>>0){D=u;C=c[D+4>>2]|0;l=g;c[l>>2]=c[D>>2];c[l+4>>2]=C;c[g+8>>2]=j;c[g+12>>2]=h;c[g+16>>2]=h;c[r>>2]=0;c[q>>2]=0;c[p>>2]=0;c[z>>2]=(c[z>>2]|0)+20;break}ag(A,u);g=c[t>>2]|0;h=g;if(g|0){j=c[q>>2]|0;if((j|0)!=(g|0))c[q>>2]=j+(~((j+-4-h|0)>>>2)<<2);mu(g)}}while(0);k=k+8|0}while((k|0)!=(m|0))}g=c[e>>2]|0;if(g|0?(D=b+12|0,c[e>>2]=0,w=c[D>>2]|0,c[D>>2]=g,w|0):0){p=w+4|0;h=c[p>>2]|0;o=w+16|0;g=c[o>>2]|0;j=h+(g>>>4<<2)|0;q=w+8|0;D=c[q>>2]|0;m=D;n=h;if((D|0)==(h|0)){g=0;k=0;l=w+20|0}else{l=w+20|0;k=(c[l>>2]|0)+g|0;g=(c[j>>2]|0)+((g&15)*440|0)|0;k=(c[h+(k>>>4<<2)>>2]|0)+((k&15)*440|0)|0}a:while(1){do{if((g|0)==(k|0))break a;g=g+440|0}while((g-(c[j>>2]|0)|0)!=7040);g=j+4|0;j=g;g=c[g>>2]|0}c[l>>2]=0;g=m-n>>2;if(g>>>0>2)do{mu(c[h>>2]|0);h=(c[p>>2]|0)+4|0;c[p>>2]=h;g=(c[q>>2]|0)-h>>2}while(g>>>0>2);switch(g|0){case 1:{c[o>>2]=8;break}case 2:{c[o>>2]=16;break}default:{}}g=c[p>>2]|0;h=c[q>>2]|0;if((g|0)!=(h|0)){do{mu(c[g>>2]|0);g=g+4|0}while((g|0)!=(h|0));g=c[p>>2]|0;h=c[q>>2]|0;if((h|0)!=(g|0))c[q>>2]=h+(~((h+-4-g|0)>>>2)<<2)}g=c[w>>2]|0;if(g|0)mu(g);mu(w)}n=b+12|0;g=c[n>>2]|0;j=c[g+20>>2]|0;h=c[g+16>>2]|0;k=j+-1+h|0;g=c[g+4>>2]|0;_u(y|0,(c[g+(k>>>4<<2)>>2]|0)+((k&15)*440|0)|0,440)|0;k=c[287054]|0;o=c[287055]|0;if((k|0)!=(o|0)){l=d+5360|0;m=d+5364|0;j=k;do{g=c[j>>2]|0;c[g+144>>2]=0;h=g+152|0;c[h>>2]=0;c[h+4>>2]=0;c[g+5544>>2]=0;h=g+5532|0;if((h|0)!=(A|0))Vg(h,c[A>>2]|0,c[z>>2]|0);tf(x,d);C=c[n>>2]|0;D=(c[C+20>>2]|0)+-1+(c[C+16>>2]|0)|0;yf(g+160|0,x,(a[l>>0]|0)!=0,c[m>>2]|0,(c[(c[C+4>>2]|0)+(D>>>4<<2)>>2]|0)+((D&15)*440|0)|0,g)|0;vk(x);j=j+4|0}while((j|0)!=(o|0));g=c[n>>2]|0;j=c[g+20>>2]|0;h=c[g+16>>2]|0;g=c[g+4>>2]|0}D=j+-1+h|0;_u((c[g+(D>>>4<<2)>>2]|0)+((D&15)*440|0)|0,y|0,440)|0;g=c[b>>2]|0;if((c[b+4>>2]|0)==(g|0))gt(b);g=c[g>>2]|0;Bb[c[(c[g>>2]|0)+8>>2]&255](g);g=c[A>>2]|0;if(!g){i=B;return}h=c[z>>2]|0;if((h|0)!=(g|0)){do{j=h+-20|0;c[z>>2]=j;k=c[h+-12>>2]|0;l=k;if(!k)h=j;else{h=h+-8|0;j=c[h>>2]|0;if((j|0)!=(k|0))c[h>>2]=j+(~((j+-4-l|0)>>>2)<<2);mu(k);h=c[z>>2]|0}}while((h|0)!=(g|0));g=c[A>>2]|0}mu(g);i=B;return}function Ug(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;m=b;h=d-m>>2;j=a+8|0;e=c[j>>2]|0;l=c[a>>2]|0;k=l;if(h>>>0<=e-l>>2>>>0){j=a+4|0;i=(c[j>>2]|0)-l>>2;a=h>>>0>i>>>0;i=b+(i<<2)|0;f=a?i:d;h=f;e=h-m|0;$u(l|0,b|0,e|0)|0;e=k+(e>>2<<2)|0;if(!a){b=c[j>>2]|0;if((b|0)==(e|0))return;c[j>>2]=b+(~((b+-4-e|0)>>>2)<<2);return}if((f|0)==(d|0))return;g=c[j>>2]|0;f=(d+-4-h|0)>>>2;b=i;e=g;while(1){c[e>>2]=c[b>>2];b=b+4|0;if((b|0)==(d|0))break;else e=e+4|0}c[j>>2]=g+(f+1<<2);return}g=l;if(l){e=a+4|0;f=c[e>>2]|0;if((f|0)!=(k|0))c[e>>2]=f+(~((f+-4-l|0)>>>2)<<2);mu(g);c[j>>2]=0;c[e>>2]=0;c[a>>2]=0;e=0}if(h>>>0>1073741823)ft(a);e=e-0|0;if(e>>2>>>0<536870911){e=e>>1;e=e>>>0<h>>>0?h:e;if(e>>>0>1073741823)ft(a);else i=e}else i=1073741823;g=Nu(i<<2)|0;h=a+4|0;c[h>>2]=g;c[a>>2]=g;c[j>>2]=g+(i<<2);if((b|0)==(d|0))return;f=(d+-4-m|0)>>>2;e=g;while(1){c[e>>2]=c[b>>2];b=b+4|0;if((b|0)==(d|0))break;else e=e+4|0}c[h>>2]=g+(f+1<<2);return}function Vg(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;r=(d-b|0)/20|0;t=a+8|0;o=c[t>>2]|0;e=c[a>>2]|0;q=e;if(r>>>0<=((o-e|0)/20|0)>>>0){p=a+4|0;j=((c[p>>2]|0)-e|0)/20|0;i=r>>>0>j>>>0;j=b+(j*20|0)|0;h=i?j:d;if((h|0)==(b|0))k=q;else{g=b;f=q;do{l=g;m=c[l+4>>2]|0;n=f;c[n>>2]=c[l>>2];c[n+4>>2]=m;if((f|0)!=(g|0))Ug(f+8|0,c[g+8>>2]|0,c[g+12>>2]|0);g=g+20|0;f=f+20|0}while((g|0)!=(h|0));k=f}if(!i){e=c[p>>2]|0;if((e|0)==(k|0))return;do{f=e+-20|0;c[p>>2]=f;g=c[e+-12>>2]|0;h=g;if(!g)e=f;else{e=e+-8|0;f=c[e>>2]|0;if((f|0)!=(g|0))c[e>>2]=f+(~((f+-4-h|0)>>>2)<<2);mu(g);e=c[p>>2]|0}}while((e|0)!=(k|0));return}if((h|0)==(d|0))return;g=c[p>>2]|0;while(1){m=j;h=c[m+4>>2]|0;n=g;c[n>>2]=c[m>>2];c[n+4>>2]=h;n=g+8|0;h=j+8|0;c[n>>2]=0;m=g+12|0;c[m>>2]=0;c[g+16>>2]=0;k=j+12|0;f=(c[k>>2]|0)-(c[h>>2]|0)|0;i=f>>2;if(i|0){if(i>>>0>1073741823){f=11;break}l=Nu(f)|0;c[m>>2]=l;c[n>>2]=l;c[g+16>>2]=l+(i<<2);i=c[h>>2]|0;g=c[k>>2]|0;if((i|0)!=(g|0)){f=i;h=l;while(1){c[h>>2]=c[f>>2];f=f+4|0;if((f|0)==(g|0))break;else h=h+4|0}c[m>>2]=l+(((g+-4-i|0)>>>2)+1<<2)}}g=(c[p>>2]|0)+20|0;c[p>>2]=g;j=j+20|0;if((j|0)==(d|0)){f=45;break}}if((f|0)==11)ft(n);else if((f|0)==45)return}if(!e)e=o;else{i=a+4|0;f=c[i>>2]|0;if((f|0)!=(q|0)){while(1){e=f+-20|0;c[i>>2]=e;g=c[f+-12>>2]|0;h=g;if(g){e=f+-8|0;f=c[e>>2]|0;if((f|0)!=(g|0))c[e>>2]=f+(~((f+-4-h|0)>>>2)<<2);mu(g);e=c[i>>2]|0}if((e|0)==(q|0))break;else f=e}e=c[a>>2]|0}mu(e);c[t>>2]=0;c[i>>2]=0;c[a>>2]=0;e=0}g=r>>>0>214748364;if(g)ft(a);e=(e-0|0)/20|0;if(e>>>0<107374182){f=e<<1;e=f>>>0>=r>>>0;if(e|g^1)s=e?f:r;else ft(a)}else s=214748364;e=Nu(s*20|0)|0;m=a+4|0;c[m>>2]=e;c[a>>2]=e;c[t>>2]=e+(s*20|0);if((b|0)==(d|0))return;while(1){k=b;g=c[k+4>>2]|0;l=e;c[l>>2]=c[k>>2];c[l+4>>2]=g;l=e+8|0;g=b+8|0;c[l>>2]=0;k=e+12|0;c[k>>2]=0;c[e+16>>2]=0;i=b+12|0;f=(c[i>>2]|0)-(c[g>>2]|0)|0;h=f>>2;if(h|0){if(h>>>0>1073741823){f=40;break}j=Nu(f)|0;c[k>>2]=j;c[l>>2]=j;c[e+16>>2]=j+(h<<2);h=c[g>>2]|0;f=c[i>>2]|0;if((h|0)!=(f|0)){e=h;g=j;while(1){c[g>>2]=c[e>>2];e=e+4|0;if((e|0)==(f|0))break;else g=g+4|0}c[k>>2]=j+(((f+-4-h|0)>>>2)+1<<2)}}e=(c[m>>2]|0)+20|0;c[m>>2]=e;b=b+20|0;if((b|0)==(d|0)){f=45;break}}if((f|0)==40)ft(l);else if((f|0)==45)return}function Wg(){var a=0,b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0;a=i;i=i+96|0;b=a;rk(b,17165,5);d=b+12|0;rk(d,17171,8);e=b+24|0;rk(e,17180,6);f=b+36|0;rk(f,17187,10);g=b+48|0;rk(g,17198,5);h=b+60|0;rk(h,17204,13);j=b+72|0;rk(j,17218,11);k=b+84|0;rk(k,17230,10);l=Nu(96)|0;c[287062]=l;c[287061]=l;c[287063]=l+96;qk(l,b);l=(c[287062]|0)+12|0;c[287062]=l;qk(l,d);l=(c[287062]|0)+12|0;c[287062]=l;qk(l,e);l=(c[287062]|0)+12|0;c[287062]=l;qk(l,f);l=(c[287062]|0)+12|0;c[287062]=l;qk(l,g);l=(c[287062]|0)+12|0;c[287062]=l;qk(l,h);l=(c[287062]|0)+12|0;c[287062]=l;qk(l,j);l=(c[287062]|0)+12|0;c[287062]=l;qk(l,k);c[287062]=(c[287062]|0)+12;vk(k);vk(j);vk(h);vk(g);vk(f);vk(e);vk(d);vk(b);i=a;return}function Xg(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0.0,k=0.0,l=0,m=0,n=0,o=0.0,p=0.0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0.0;w=i;i=i+64|0;v=w+48|0;n=w+36|0;g=w+24|0;s=w+12|0;t=w;rk(v,17355,21);u=qh(Zd(1148396,v)|0)|0;vk(v);rk(n,17341,13);v=qh(Zd(1148396,n)|0)|0;vk(n);rk(g,17377,10);n=qh(Zd(1148396,g)|0)|0;vk(g);rk(s,17388,9);g=qh(Zd(1148396,s)|0)|0;vk(s);if(!g)h=b+12+(d<<2)|0;else{s=a;f=c[s>>2]|0;h=b+12+(d<<2)|0;if((f|0)==0&(c[s+4>>2]|0)==0){f=_(c[h>>2]|0,g)|0;s=a;c[s>>2]=f;c[s+4>>2]=((f|0)<0)<<31>>31}c[h>>2]=f;s=b+20+(d<<2)|0;c[s>>2]=_(c[s>>2]|0,g)|0;c[b+28>>2]=g}r=b+64|0;s=c[r+4>>2]|0;l=a+8|0;c[l>>2]=c[r>>2];c[l+4>>2]=s;l=c[h>>2]|0;l=(l|0)<(u|0)?u:l;s=a+20|0;c[s>>2]=l;r=a+16|0;c[r>>2]=l;f=b+32|0;g=c[f>>2]|0;if(g){f=c[((g|0)>50?7984:f)>>2]|0;if((f|0)>=1)m=9}else{f=50;m=9}if((m|0)==9){q=b+20+(d<<2)|0;o=+(n|0)*(+P(+(+X(+((+(e|0)+-58.4)/7.64))+1.0),-.183)+2.2250738585072014e-308)/100.0;p=o*7.09;m=l;b=l;d=1;while(1){a=_(c[q>>2]|0,d+-1|0)|0;a=(c[h>>2]|0)-(_(((d|0)>40?40:d)+2|0,v)|0)+a|0;a=(a|0)<0?0:a;l=(d|0)>1;if(l){g=1;j=0.0;do{j=j+(+P(+(+X(+((+((g<<1)+e|0)+-58.4)/7.64))+1.0),-.183)+2.2250738585072014e-308);g=g+1|0}while((g|0)!=(d|0))}else j=0.0;k=o+j;x=o/k;j=(o+j*0.0)/k;k=+(a|0);a=~~(k*(j<x?j:x))+u|0;if(l){g=1;j=0.0;do{j=j+(+P(+(+X(+((+((g<<1)+e|0)+-58.4)/7.64))+1.0),-.183)+2.2250738585072014e-308);g=g+1|0}while((g|0)!=(d|0))}else j=0.0;x=p/(p+j);j=(o+j*.35)/(o+j);n=~~(k*(j<x?j:x))+u|0;m=(m|0)<(a|0)?m:a;c[r>>2]=m;b=(b|0)<(n|0)?b:n;c[s>>2]=b;if((d|0)==(f|0))break;else d=d+1|0}}rk(t,17308,6);e=(qh(Zd(1148396,t)|0)|0)==0;vk(t);if(e){i=w;return}e=c[r>>2]|0;c[r>>2]=((e|0)/4|0)+e;i=w;return}function Yg(){var a=0,b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0;a=i;i=i+96|0;b=a;rk(b,17165,5);d=b+12|0;rk(d,17171,8);e=b+24|0;rk(e,17180,6);f=b+36|0;rk(f,17187,10);g=b+48|0;rk(g,17198,5);h=b+60|0;rk(h,17204,13);j=b+72|0;rk(j,17218,11);k=b+84|0;rk(k,17230,10);l=Nu(96)|0;c[287069]=l;c[287068]=l;c[287070]=l+96;qk(l,b);l=(c[287069]|0)+12|0;c[287069]=l;qk(l,d);l=(c[287069]|0)+12|0;c[287069]=l;qk(l,e);l=(c[287069]|0)+12|0;c[287069]=l;qk(l,f);l=(c[287069]|0)+12|0;c[287069]=l;qk(l,g);l=(c[287069]|0)+12|0;c[287069]=l;qk(l,h);l=(c[287069]|0)+12|0;c[287069]=l;qk(l,j);l=(c[287069]|0)+12|0;c[287069]=l;qk(l,k);c[287069]=(c[287069]|0)+12;vk(k);vk(j);vk(h);vk(g);vk(f);vk(e);vk(d);vk(b);i=a;return}function Zg(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;f=i;i=i+16|0;e=f;d=bv(b<<15&134184960|0,0,0)|0;d=1<<(d^63);if((d|0)==(c[a>>2]|0)){i=f;return}c[a>>2]=d;g=a+8|0;Aj(c[g>>2]|0);d=Bj((c[a>>2]<<5)+63|0,1)|0;c[g>>2]=d;if(!d){g=Ud(um(Ud(1149148,16507,19)|0,b)|0,16527,27)|0;c[e>>2]=gm(g+(c[(c[g>>2]|0)+-12>>2]|0)|0)|0;b=Om(e,1150100)|0;b=Lb[c[(c[b>>2]|0)+28>>2]&63](b,10)|0;_t(e);ym(g,b)|0;lm(g)|0;sb(1)}c[a+4>>2]=d+63&-64;i=f;return}function _g(a){a=a|0;Wu(c[a+4>>2]|0,0,c[a>>2]<<5|0)|0;return}function $g(e,f,g,h){e=e|0;f=f|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0;m=(c[e>>2]|0)+-1&f;n=c[e+4>>2]|0;l=n+(m<<5)|0;k=Yu(f|0,g|0,48)|0;f=b[l>>1]|0;g=f<<16>>16==0;if(!(g|(f&65535|0)==(k|0))){j=n+(m<<5)+10|0;f=b[j>>1]|0;g=f<<16>>16==0;if(!(g|(f&65535|0)==(k|0))){g=n+(m<<5)+20|0;f=b[g>>1]|0;i=f<<16>>16==0;if(i|(f&65535|0)==(k|0)){o=g;l=g;k=i;g=2}else{o=(d[e+12>>0]|0)+259|0;e=((a[n+(m<<5)+9>>0]|0)-(o-(d[n+(m<<5)+8>>0]|0)<<1&504)|0)>((a[n+(m<<5)+19>>0]|0)-(o-(d[n+(m<<5)+18>>0]|0)<<1&504)|0)?j:l;e=((a[e+9>>0]|0)-(o-(d[e+8>>0]|0)<<1&504)|0)>((a[n+(m<<5)+29>>0]|0)-(o-(d[n+(m<<5)+28>>0]|0)<<1&504)|0)?g:e;o=0;a[h>>0]=o;return e|0}}else{o=j;l=j;k=g;g=1}}else{o=l;k=g;g=0}i=n+(m<<5)+(g*10|0)+8|0;j=d[i>>0]|0;g=d[e+12>>0]|0;if(!(k|(j&252|0)==(g|0))){a[i>>0]=j&3|g;f=b[l>>1]|0}e=o;o=f<<16>>16!=0&1;a[h>>0]=o;return e|0}function ah(a){a=a|0;var b=0,e=0,f=0;f=c[a+4>>2]|0;b=d[a+12>>0]|0;a=0;e=0;do{a=(((d[f+(e<<5)+28>>0]|0)&252|0)==(b|0)&1)+((((d[f+(e<<5)+18>>0]|0)&252|0)==(b|0)&1)+((((d[f+(e<<5)+8>>0]|0)&252|0)==(b|0)&1)+a))|0;e=e+1|0}while((e|0)!=333);return a|0}function bh(){var a=0,b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0;g=i;i=i+96|0;d=g;rk(d,17165,5);e=d+12|0;rk(e,17171,8);a=d+24|0;rk(a,17180,6);b=d+36|0;rk(b,17187,10);f=d+48|0;rk(f,17198,5);h=d+60|0;rk(h,17204,13);j=d+72|0;rk(j,17218,11);k=d+84|0;rk(k,17230,10);l=Nu(96)|0;c[287072]=l;c[287071]=l;c[287073]=l+96;qk(l,d);l=(c[287072]|0)+12|0;c[287072]=l;qk(l,e);l=(c[287072]|0)+12|0;c[287072]=l;qk(l,a);l=(c[287072]|0)+12|0;c[287072]=l;qk(l,b);l=(c[287072]|0)+12|0;c[287072]=l;qk(l,f);l=(c[287072]|0)+12|0;c[287072]=l;qk(l,h);l=(c[287072]|0)+12|0;c[287072]=l;qk(l,j);l=(c[287072]|0)+12|0;c[287072]=l;qk(l,k);c[287072]=(c[287072]|0)+12;vk(k);vk(j);vk(h);vk(f);vk(b);vk(a);vk(e);vk(d);rk(1148296,16555,56);rk(1148308,16555,56);rk(1148320,16555,56);rk(1148332,16612,58);rk(1148344,16671,74);rk(1148356,16555,56);rk(1148368,16746,39);rk(1148380,16786,60);d=Nu(24)|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[d+16>>2]=0;c[d+20>>2]=0;e=d+20|0;ch(d,1);a=c[e>>2]|0;b=c[d+4>>2]|0;f=(c[d+16>>2]|0)+a|0;if((c[d+8>>2]|0)==(b|0)){l=0;Wu(l|0,0,440)|0;l=a+1|0;c[e>>2]=l;l=d;c[287098]=l;i=g;return}l=(c[b+(f>>>4<<2)>>2]|0)+((f&15)*440|0)|0;Wu(l|0,0,440)|0;l=a+1|0;c[e>>2]=l;l=d;c[287098]=l;i=g;return}function ch(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;t=i;i=i+16|0;h=t+4|0;k=t;r=a+8|0;d=c[r>>2]|0;s=a+4|0;e=c[s>>2]|0;b=((d|0)==(e|0)&1)+b|0;b=((b&15|0)!=0&1)+(b>>>4)|0;p=a+16|0;f=c[p>>2]|0;l=f>>>4;l=b>>>0<l>>>0?b:l;j=b-l|0;g=d;if((b|0)==(l|0)){c[p>>2]=f-(b<<4);if(!b){i=t;return}o=a+12|0;while(1){n=c[e>>2]|0;j=e+4|0;c[s>>2]=j;q=c[o>>2]|0;e=q;f=d;do if((d|0)==(q|0)){h=c[a>>2]|0;g=h;if(j>>>0>h>>>0){d=j;q=((d-g>>2)+1|0)/-2|0;p=j+(q<<2)|0;d=f-d|0;$u(p|0,j|0,d|0)|0;d=p+(d>>2<<2)|0;c[r>>2]=d;c[s>>2]=(c[s>>2]|0)+(q<<2);break}m=e-g>>1;m=(m|0)==0?1:m;q=Nu(m<<2)|0;k=q;e=q+(m>>>2<<2)|0;l=e;m=q+(m<<2)|0;if((j|0)==(d|0)){e=h;d=l}else{g=j;f=l;do{c[e>>2]=c[g>>2];e=f+4|0;f=e;g=g+4|0}while((g|0)!=(d|0));d=f;e=c[a>>2]|0}c[a>>2]=k;c[s>>2]=l;c[r>>2]=d;c[o>>2]=m;if(e){mu(e);d=c[r>>2]|0}}while(0);c[d>>2]=n;d=(c[r>>2]|0)+4|0;c[r>>2]=d;b=b+-1|0;if(!b)break;e=c[s>>2]|0}i=t;return}q=a+12|0;d=c[q>>2]|0;b=d-(c[a>>2]|0)|0;e=g-e>>2;if(j>>>0<=((b>>2)-e|0)>>>0){a:do if((d|0)==(g|0)){d=j;f=16}else{d=j;while(1){c[h>>2]=Nu(7040)|0;dh(a,h);d=d+-1|0;if(!d){f=17;break a}if((c[q>>2]|0)==(c[r>>2]|0)){f=16;break}}}while(0);if((f|0)==16)if(!d)f=17;else{b=l;do{c[k>>2]=Nu(7040)|0;eh(a,k);d=d+-1|0;b=b+1|0;e=(c[p>>2]|0)+16+((((c[r>>2]|0)-(c[s>>2]|0)|0)==4)<<31>>31)|0;c[p>>2]=e}while((d|0)!=0)}if((f|0)==17){e=c[p>>2]|0;b=l}c[p>>2]=e-(b<<4);if(!b){i=t;return}d=c[r>>2]|0;do{j=c[s>>2]|0;n=c[j>>2]|0;j=j+4|0;c[s>>2]=j;p=c[q>>2]|0;e=p;f=d;do if((d|0)==(p|0)){h=c[a>>2]|0;g=h;if(j>>>0>h>>>0){d=j;p=((d-g>>2)+1|0)/-2|0;o=j+(p<<2)|0;d=f-d|0;$u(o|0,j|0,d|0)|0;d=o+(d>>2<<2)|0;c[r>>2]=d;c[s>>2]=(c[s>>2]|0)+(p<<2);break}m=e-g>>1;m=(m|0)==0?1:m;p=Nu(m<<2)|0;k=p;e=p+(m>>>2<<2)|0;l=e;m=p+(m<<2)|0;if((j|0)==(d|0)){e=h;d=l}else{g=j;f=l;do{c[e>>2]=c[g>>2];e=f+4|0;f=e;g=g+4|0}while((g|0)!=(d|0));d=f;e=c[a>>2]|0}c[a>>2]=k;c[s>>2]=l;c[r>>2]=d;c[q>>2]=m;if(e){mu(e);d=c[r>>2]|0}}while(0);c[d>>2]=n;d=(c[r>>2]|0)+4|0;c[r>>2]=d;b=b+-1|0}while((b|0)!=0);i=t;return}o=l<<4;d=b>>1;n=e+j|0;d=d>>>0<n>>>0?n:d;if(!d)b=0;else b=Nu(d<<2)|0;e=b+(e-l<<2)|0;n=b;g=e;b=b+(d<<2)|0;m=j;while(1){k=Nu(7040)|0;j=e;d=e;do if((j|0)==(b|0)){h=g;if(h>>>0>n>>>0){j=h+((((g-n>>2)+1|0)/-2|0)<<2)|0;e=e-g|0;$u(j|0,g|0,e|0)|0;e=j+(e>>2<<2)|0;d=e;f=n;g=j;break}b=b-n>>1;b=(b|0)==0?1:b;e=Nu(b<<2)|0;f=e;d=e+(b>>>2<<2)|0;g=d;b=e+(b<<2)|0;if((h|0)==(j|0))e=g;else{e=g;do{c[d>>2]=c[h>>2];d=e+4|0;e=d;h=h+4|0}while((h|0)!=(j|0))}d=e;if(n)mu(n)}else f=n;while(0);c[d>>2]=k;e=e+4|0;m=m+-1|0;if(!m)break;else n=f}if(!l)d=c[s>>2]|0;else{d=c[s>>2]|0;m=f;while(1){k=e;f=e;do if((k|0)==(b|0)){f=g;if(f>>>0>m>>>0){n=f+((((g-m>>2)+1|0)/-2|0)<<2)|0;e=e-g|0;$u(n|0,g|0,e|0)|0;e=n+(e>>2<<2)|0;f=e;j=m;g=n;break}b=b-m>>1;b=(b|0)==0?1:b;n=Nu(b<<2)|0;j=n;e=n+(b>>>2<<2)|0;g=e;b=n+(b<<2)|0;if((f|0)==(k|0))e=g;else{h=e;e=g;do{c[h>>2]=c[f>>2];h=e+4|0;e=h;f=f+4|0}while((f|0)!=(k|0))}f=e;if(m)mu(m)}else j=m;while(0);c[f>>2]=c[d>>2];e=e+4|0;d=(c[s>>2]|0)+4|0;c[s>>2]=d;l=l+-1|0;if(!l){f=j;break}else m=j}}h=c[r>>2]|0;if((h|0)!=(d|0)){d=g;do{h=h+-4|0;g=d;do if((g|0)==(f|0)){l=e;if(l>>>0<b>>>0){n=l+((((b-e>>2)+1|0)/2|0)<<2)|0;g=e-d|0;e=n+(0-(g>>2)<<2)|0;$u(e|0,d|0,g|0)|0;g=e;d=e;e=n;break}b=b-f>>1;b=(b|0)==0?1:b;n=Nu(b<<2)|0;f=n;k=n+((b+3|0)>>>2<<2)|0;m=k;b=n+(b<<2)|0;if((g|0)==(l|0))e=m;else{j=k;e=m;do{c[j>>2]=c[g>>2];j=e+4|0;e=j;g=g+4|0}while((g|0)!=(l|0))}if(!d){g=k;d=m}else{mu(d);g=k;d=m}}while(0);c[g+-4>>2]=c[h>>2];d=d+-4|0}while((h|0)!=(c[s>>2]|0));g=d}d=c[a>>2]|0;c[a>>2]=f;c[s>>2]=g;c[r>>2]=e;c[q>>2]=b;c[p>>2]=(c[p>>2]|0)-o;if(!d){i=t;return}mu(d);i=t;return}function dh(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;o=a+8|0;d=c[o>>2]|0;m=a+12|0;n=c[m>>2]|0;f=n;g=d;do if((d|0)==(n|0)){n=a+4|0;i=c[n>>2]|0;h=c[a>>2]|0;e=h;if(i>>>0>h>>>0){d=i;a=((d-e>>2)+1|0)/-2|0;m=i+(a<<2)|0;d=g-d|0;$u(m|0,i|0,d|0)|0;d=m+(d>>2<<2)|0;c[o>>2]=d;c[n>>2]=(c[n>>2]|0)+(a<<2);break}l=f-e>>1;l=(l|0)==0?1:l;g=Nu(l<<2)|0;j=g;e=g+(l>>>2<<2)|0;k=e;l=g+(l<<2)|0;if((i|0)==(d|0)){e=h;d=k}else{g=i;f=k;do{c[e>>2]=c[g>>2];e=f+4|0;f=e;g=g+4|0}while((g|0)!=(d|0));d=f;e=c[a>>2]|0}c[a>>2]=j;c[n>>2]=k;c[o>>2]=d;c[m>>2]=l;if(e){mu(e);d=c[o>>2]|0}}while(0);c[d>>2]=c[b>>2];c[o>>2]=(c[o>>2]|0)+4;return}function eh(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;n=a+4|0;d=c[n>>2]|0;m=c[a>>2]|0;f=m;do if((d|0)==(m|0)){l=a+8|0;g=c[l>>2]|0;m=a+12|0;k=c[m>>2]|0;e=k;if(g>>>0<k>>>0){k=g;m=((e-k>>2)+1|0)/2|0;k=k-d|0;a=g+(m<<2)+(0-(k>>2)<<2)|0;$u(a|0,d|0,k|0)|0;c[n>>2]=a;c[l>>2]=(c[l>>2]|0)+(m<<2);d=a;break}k=e-f>>1;k=(k|0)==0?1:k;f=Nu(k<<2)|0;h=f;i=f+((k+3|0)>>>2<<2)|0;j=i;k=f+(k<<2)|0;if((d|0)==(g|0))e=j;else{f=i;e=j;do{c[f>>2]=c[d>>2];f=e+4|0;e=f;d=d+4|0}while((d|0)!=(g|0));d=c[a>>2]|0}c[a>>2]=h;c[n>>2]=j;c[l>>2]=e;c[m>>2]=k;if(!d)d=i;else{mu(d);d=c[n>>2]|0}}while(0);c[d+-4>>2]=c[b>>2];c[n>>2]=(c[n>>2]|0)+-4;return}function fh(d){d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,D=0,E=0,F=0;D=i;i=i+784|0;v=D+440|0;u=D+772|0;t=D+760|0;p=D+748|0;m=D+736|0;r=D+724|0;s=D;l=D+712|0;n=D+700|0;o=D+676|0;B=D+664|0;z=D+652|0;A=D+512|0;g=D+688|0;do if(!(a[1217490]|0)){f=c[287098]|0;e=(c[f+20>>2]|0)+-1+(c[f+16>>2]|0)|0;e=(c[(c[f+4>>2]|0)+(e>>>4<<2)>>2]|0)+((e&15)*440|0)|0;f=c[287054]|0;if((c[287055]|0)==(f|0))gt(1148216);else{yf(984e3,1148296,0,0,e,c[f>>2]|0)|0;a[1217490]=1;break}}while(0);c[B>>2]=0;c[B+4>>2]=0;c[B+8>>2]=0;rk(z,d,Mh(d)|0);w=A+8|0;c[A>>2]=6596;x=A+60|0;c[x>>2]=6616;c[A+4>>2]=0;fm(A+60|0,w);c[A+132>>2]=0;c[A+136>>2]=-1;c[A>>2]=6636;c[A+60>>2]=6656;hm(w);c[w>>2]=3544;y=A+40|0;c[y>>2]=0;c[y+4>>2]=0;c[y+8>>2]=0;c[y+12>>2]=0;c[A+56>>2]=8;Td(w,z);if(!(a[B>>0]&1)){a[B+1>>0]=0;a[B>>0]=0}else{a[c[B+8>>2]>>0]=0;c[B+4>>2]=0}k=A+(c[(c[A>>2]|0)+-12>>2]|0)+4|0;c[k>>2]=c[k>>2]|4096;me(A,B)|0;do if(Lk(B,16847)|0?Lk(B,16852)|0:0){if((Lk(B,16857)|0)==0?a[1217489]&1:0)break;if(!(Lk(B,16857)|0)){c[245973]=0;c[A>>2]=6636;c[x>>2]=6656;c[w>>2]=3544;vk(y);il(w);el(x);vk(z);vk(B);i=D;return}if(!(Lk(B,16867)|0)){s=Ud(oe(1149064,0)|0,16871,8)|0;le(g,1);u=a[g>>0]|0;t=(u&1)==0;u=Ud(yh(Ud(Ud(s,t?g+1|0:c[g+8>>2]|0,t?(u&255)>>>1:c[g+4>>2]|0)|0,16880,1)|0,1148396)|0,16882,6)|0;c[v>>2]=gm(u+(c[(c[u>>2]|0)+-12>>2]|0)|0)|0;t=Om(v,1150100)|0;t=Lb[c[(c[t>>2]|0)+28>>2]&63](t,10)|0;_t(v);ym(u,t)|0;lm(u)|0;oe(u,1)|0;vk(g);c[A>>2]=6636;c[x>>2]=6656;c[w>>2]=3544;vk(y);il(w);el(x);vk(z);vk(B);i=D;return}if(!(Lk(B,16889)|0)){Fg();v=983976;c[v>>2]=0;c[v+4>>2]=0;c[A>>2]=6636;c[x>>2]=6656;c[w>>2]=3544;vk(y);il(w);el(x);vk(z);vk(B);i=D;return}if(!(Lk(B,16900)|0)){u=Ud(oe(1149064,0)|0,16908,7)|0;c[v>>2]=gm(u+(c[(c[u>>2]|0)+-12>>2]|0)|0)|0;t=Om(v,1150100)|0;t=Lb[c[(c[t>>2]|0)+28>>2]&63](t,10)|0;_t(v);ym(u,t)|0;lm(u)|0;oe(u,1)|0;c[A>>2]=6636;c[x>>2]=6656;c[w>>2]=3544;vk(y);il(w);el(x);vk(z);vk(B);i=D;return}if(!(Lk(B,16916)|0)){e=v;f=e+64|0;do{c[e>>2]=0;e=e+4|0}while((e|0)<(f|0));c[u>>2]=0;c[u+4>>2]=0;c[u+8>>2]=0;r=dl()|0;r=fv(r|0,C|0,1e6,0)|0;s=v+64|0;c[s>>2]=r;c[s+4>>2]=C;s=me(A,u)|0;if(!(c[s+(c[(c[s>>2]|0)+-12>>2]|0)+16>>2]&5)){e=v+12|0;f=v+16|0;d=v+20|0;g=v+24|0;h=v+32|0;j=v+36|0;k=v+56|0;l=v+40|0;m=v+44|0;n=v+48|0;o=v+52|0;p=v+4|0;q=v+8|0;do{do if(!(Lk(u,16919)|0)){s=me(A,u)|0;if(!(c[s+(c[(c[s>>2]|0)+-12>>2]|0)+16>>2]&5))do{r=gh(984e3,u)|0;c[t>>2]=r;s=c[p>>2]|0;if(s>>>0<(c[q>>2]|0)>>>0){c[s>>2]=r;c[p>>2]=s+4}else ih(v,t);s=me(A,u)|0}while(!(c[s+(c[(c[s>>2]|0)+-12>>2]|0)+16>>2]&5|0))}else{if(!(Lk(u,16968)|0)){om(A,e)|0;break}if(!(Lk(u,16974)|0)){om(A,f)|0;break}if(!(Lk(u,16980)|0)){om(A,d)|0;break}if(!(Lk(u,16985)|0)){om(A,g)|0;break}if(!(Lk(u,16990)|0)){om(A,h)|0;break}if(!(Lk(u,17e3)|0)){om(A,j)|0;break}if(!(Lk(u,17006)|0)){pm(A,k)|0;break}if(!(Lk(u,17012)|0)){om(A,l)|0;break}if(!(Lk(u,17021)|0)){om(A,m)|0;break}if(!(Lk(u,17026)|0)){c[n>>2]=1;break}if(Lk(u,17035)|0)break;c[o>>2]=1}while(0);s=me(A,u)|0}while(!(c[s+(c[(c[s>>2]|0)+-12>>2]|0)+16>>2]&5|0))}Tg(1148216,984e3,1148392,v);vk(u);d=c[v>>2]|0;g=d;if(d|0){e=v+4|0;f=c[e>>2]|0;if((f|0)!=(d|0))c[e>>2]=f+(~((f+-4-g|0)>>>2)<<2);mu(d)}c[A>>2]=6636;c[x>>2]=6656;c[w>>2]=3544;vk(y);il(w);el(x);vk(z);vk(B);i=D;return}if(Lk(B,17042)|0){if(Lk(B,17072)|0){s=Ud(oe(1149064,0)|0,17137,17)|0;u=a[z>>0]|0;t=(u&1)==0;u=Ud(s,t?z+1|0:c[z+8>>2]|0,t?(u&255)>>>1:c[z+4>>2]|0)|0;c[v>>2]=gm(u+(c[(c[u>>2]|0)+-12>>2]|0)|0)|0;t=Om(v,1150100)|0;t=Lb[c[(c[t>>2]|0)+28>>2]&63](t,10)|0;_t(v);ym(u,t)|0;lm(u)|0;oe(u,1)|0;c[A>>2]=6636;c[x>>2]=6656;c[w>>2]=3544;vk(y);il(w);el(x);vk(z);vk(B);i=D;return};c[u>>2]=0;c[u+4>>2]=0;c[u+8>>2]=0;c[t>>2]=0;c[t+4>>2]=0;c[t+8>>2]=0;c[p>>2]=0;c[p+4>>2]=0;c[p+8>>2]=0;me(A,u)|0;k=me(A,u)|0;a:do if(!(c[k+(c[(c[k>>2]|0)+-12>>2]|0)+16>>2]&5)){e=t+4|0;f=u+8|0;d=u+1|0;g=u+4|0;h=m+8|0;j=m+1|0;k=m+4|0;do{if(!(Lk(u,17082)|0))break a;E=a[t>>0]|0;rk(r,17070,(((E&1)==0?(E&255)>>>1:c[e>>2]|0)|0)!=0&1);E=a[u>>0]|0;F=(E&1)==0;E=Ek(r,F?d:c[f>>2]|0,F?(E&255)>>>1:c[g>>2]|0)|0;c[m>>2]=c[E>>2];c[m+4>>2]=c[E+4>>2];c[m+8>>2]=c[E+8>>2];c[E>>2]=0;c[E+4>>2]=0;c[E+8>>2]=0;E=a[m>>0]|0;F=(E&1)==0;Ek(t,F?j:c[h>>2]|0,F?(E&255)>>>1:c[k>>2]|0)|0;vk(m);vk(r);E=me(A,u)|0}while(!(c[E+(c[(c[E>>2]|0)+-12>>2]|0)+16>>2]&5|0))}while(0);F=me(A,u)|0;if(!(c[F+(c[(c[F>>2]|0)+-12>>2]|0)+16>>2]&5)){e=p+4|0;f=u+8|0;d=u+1|0;g=u+4|0;h=s+8|0;j=s+1|0;k=s+4|0;do{F=a[p>>0]|0;rk(l,17070,(((F&1)==0?(F&255)>>>1:c[e>>2]|0)|0)!=0&1);F=a[u>>0]|0;E=(F&1)==0;F=Ek(l,E?d:c[f>>2]|0,E?(F&255)>>>1:c[g>>2]|0)|0;c[s>>2]=c[F>>2];c[s+4>>2]=c[F+4>>2];c[s+8>>2]=c[F+8>>2];c[F>>2]=0;c[F+4>>2]=0;c[F+8>>2]=0;F=a[s>>0]|0;E=(F&1)==0;Ek(p,E?j:c[h>>2]|0,E?(F&255)>>>1:c[k>>2]|0)|0;vk(s);vk(l);F=me(A,u)|0}while(!(c[F+(c[(c[F>>2]|0)+-12>>2]|0)+16>>2]&5|0))}e=c[287100]|0;b:do if(e){while(1){f=e+16|0;if(!(uh(1148404,t,f)|0)){if(!(uh(1148404,f,t)|0))break;e=e+4|0}e=c[e>>2]|0;if(!e){q=139;break b}}Ah(kh(1148396,t)|0,p)|0;if(!(Lk(t,17411)|0)){j=c[287071]|0;k=a[p>>0]|0;l=(k&1)==0;k=l?(k&255)>>>1:c[p+4>>2]|0;l=l?p+1|0:c[p+8>>2]|0;c:do if(!k){F=b[j>>1]|0;if(!(((F&1)==0?(F&254)>>>1:c[j+4>>2]|0)|0)){e=0;break}F=b[j+12>>1]|0;if(!(((F&1)==0?(F&254)>>>1:c[j+16>>2]|0)|0)){e=1;break}F=b[j+24>>1]|0;if(!(((F&1)==0?(F&254)>>>1:c[j+28>>2]|0)|0)){e=2;break}F=b[j+36>>1]|0;if(!(((F&1)==0?(F&254)>>>1:c[j+40>>2]|0)|0)){e=3;break}F=b[j+48>>1]|0;if(!(((F&1)==0?(F&254)>>>1:c[j+52>>2]|0)|0)){e=4;break}F=b[j+60>>1]|0;if(!(((F&1)==0?(F&254)>>>1:c[j+64>>2]|0)|0)){e=5;break}F=b[j+72>>1]|0;if(!(((F&1)==0?(F&254)>>>1:c[j+76>>2]|0)|0)){e=6;break}e=b[j+84>>1]|0;e=(((e&1)==0?(e&254)>>>1:c[j+88>>2]|0)|0)==0?7:0}else{e=0;while(1){h=j+(e*12|0)|0;g=b[h>>1]|0;f=(g&1)==0;d=(g&254)>>>1;g=(g&65535)>>>8&255;do if(((f?d:c[j+(e*12|0)+4>>2]|0)|0)==(k|0)){if(!f)if(!(rj(c[j+(e*12|0)+8>>2]|0,l,k)|0))break c;else break;if(g<<24>>24!=(a[l>>0]|0))break;g=d;f=h+1|0;d=l;do{g=g+-1|0;f=f+1|0;if(!g)break c;d=d+1|0}while((a[f>>0]|0)==(a[d>>0]|0))}while(0);e=e+1|0;if((e|0)>=8){e=0;break}}}while(0);F=Ud(oe(1149064,0)|0,17088,20)|0;rk(o,17411,11);sh(n,Zd(1148396,o)|0);r=a[n>>0]|0;s=(r&1)==0;r=Ud(Ud(F,s?n+1|0:c[n+8>>2]|0,s?(r&255)>>>1:c[n+4>>2]|0)|0,17109,10)|0;s=1148296+(e*12|0)|0;F=a[s>>0]|0;E=(F&1)==0;F=Ud(r,E?s+1|0:c[1148296+(e*12|0)+8>>2]|0,E?(F&255)>>>1:c[1148296+(e*12|0)+4>>2]|0)|0;c[v>>2]=gm(F+(c[(c[F>>2]|0)+-12>>2]|0)|0)|0;E=Om(v,1150100)|0;E=Lb[c[(c[E>>2]|0)+28>>2]&63](E,10)|0;_t(v);ym(F,E)|0;lm(F)|0;oe(F,1)|0;vk(n);vk(o)}}else q=139;while(0);if((q|0)==139){s=Ud(oe(1149064,0)|0,17120,16)|0;F=a[t>>0]|0;E=(F&1)==0;F=Ud(s,E?t+1|0:c[t+8>>2]|0,E?(F&255)>>>1:c[t+4>>2]|0)|0;c[v>>2]=gm(F+(c[(c[F>>2]|0)+-12>>2]|0)|0)|0;E=Om(v,1150100)|0;E=Lb[c[(c[E>>2]|0)+28>>2]&63](E,10)|0;_t(v);ym(F,E)|0;lm(F)|0;oe(F,1)|0}vk(p);vk(t);vk(u);c[A>>2]=6636;c[x>>2]=6656;c[w>>2]=3544;vk(y);il(w);el(x);vk(z);vk(B);i=D;return};c[v>>2]=0;c[v+4>>2]=0;c[v+8>>2]=0;c[u>>2]=0;c[u+4>>2]=0;c[u+8>>2]=0;rk(p,17411,11);sh(t,Zd(1148396,p)|0);h=c[287071]|0;j=a[t>>0]|0;k=(j&1)==0;j=k?(j&255)>>>1:c[t+4>>2]|0;k=k?t+1|0:c[t+8>>2]|0;d:do if(!j){F=b[h>>1]|0;if(((F&1)==0?(F&254)>>>1:c[h+4>>2]|0)|0){F=b[h+12>>1]|0;if(((F&1)==0?(F&254)>>>1:c[h+16>>2]|0)|0){F=b[h+24>>1]|0;if(((F&1)==0?(F&254)>>>1:c[h+28>>2]|0)|0){F=b[h+36>>1]|0;if(((F&1)==0?(F&254)>>>1:c[h+40>>2]|0)|0){F=b[h+48>>1]|0;if(((F&1)==0?(F&254)>>>1:c[h+52>>2]|0)|0){F=b[h+60>>1]|0;if(!(((F&1)==0?(F&254)>>>1:c[h+64>>2]|0)|0))l=5;else{F=b[h+72>>1]|0;if(!(((F&1)==0?(F&254)>>>1:c[h+76>>2]|0)|0)){l=6;break}l=b[h+84>>1]|0;l=(((l&1)==0?(l&254)>>>1:c[h+88>>2]|0)|0)==0?7:0}}else l=4}else l=3}else l=2}else l=1}else l=0}else{l=0;while(1){g=h+(l*12|0)|0;d=b[g>>1]|0;e=(d&1)==0;f=(d&254)>>>1;d=(d&65535)>>>8&255;do if(((e?f:c[h+(l*12|0)+4>>2]|0)|0)==(j|0)){if(!e)if(!(rj(c[h+(l*12|0)+8>>2]|0,k,j)|0))break d;else break;if(d<<24>>24==(a[k>>0]|0)){d=f;e=g+1|0;f=k;do{d=d+-1|0;e=e+1|0;if(!d)break d;f=f+1|0}while((a[e>>0]|0)==(a[f>>0]|0))}}while(0);l=l+1|0;if((l|0)>=8){l=0;break}}}while(0);vk(t);vk(p);me(A,v)|0;e:do if(Lk(v,17051)|0){if(!(Lk(v,17060)|0)){F=me(A,v)|0;if(!(c[F+(c[(c[F>>2]|0)+-12>>2]|0)+16>>2]&5)){e=v+4|0;f=v+8|0;d=v+1|0;g=m+8|0;h=m+1|0;j=m+4|0;while(1){if(!(Lk(v,17064)|0)){q=79;break e};c[m>>2]=0;c[m+4>>2]=0;c[m+8>>2]=0;F=a[v>>0]|0;E=(F&1)==0;F=E?(F&255)>>>1:c[e>>2]|0;Mk(m,E?d:c[f>>2]|0,F,F+1|0);Ek(m,17070,1)|0;F=a[m>>0]|0;E=(F&1)==0;Ek(u,E?h:c[g>>2]|0,E?(F&255)>>>1:c[j>>2]|0)|0;vk(m);F=me(A,v)|0;if(c[F+(c[(c[F>>2]|0)+-12>>2]|0)+16>>2]&5|0){q=79;break}}}else q=79}}else{wk(u,1148296+(l*12|0)|0)|0;me(A,v)|0;q=79}while(0);f:do if((q|0)==79){h=Nu(24)|0;c[h>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;c[h+16>>2]=0;c[h+20>>2]=0;g=h+20|0;ch(h,1);d=c[g>>2]|0;e=c[h+4>>2]|0;f=(c[h+16>>2]|0)+d|0;if((c[h+8>>2]|0)==(e|0))e=0;else e=(c[e+(f>>>4<<2)>>2]|0)+((f&15)*440|0)|0;Wu(e|0,0,440)|0;c[g>>2]=d+1;p=c[287098]|0;c[287098]=h;if(p|0){n=p+4|0;f=c[n>>2]|0;m=p+16|0;e=c[m>>2]|0;d=f+(e>>>4<<2)|0;o=p+8|0;F=c[o>>2]|0;g=F;h=f;if((F|0)==(f|0)){j=0;k=p+20|0;e=0}else{k=p+20|0;j=(c[k>>2]|0)+e|0;j=(c[f+(j>>>4<<2)>>2]|0)+((j&15)*440|0)|0;e=(c[d>>2]|0)+((e&15)*440|0)|0}g:while(1){do{if((e|0)==(j|0))break g;e=e+440|0}while((e-(c[d>>2]|0)|0)!=7040);e=d+4|0;d=e;e=c[e>>2]|0}c[k>>2]=0;e=g-h>>2;if(e>>>0>2)do{mu(c[f>>2]|0);f=(c[n>>2]|0)+4|0;c[n>>2]=f;e=(c[o>>2]|0)-f>>2}while(e>>>0>2);switch(e|0){case 1:{c[m>>2]=8;break}case 2:{c[m>>2]=16;break}default:{}}e=c[n>>2]|0;f=c[o>>2]|0;do if((e|0)!=(f|0)){do{mu(c[e>>2]|0);e=e+4|0}while((e|0)!=(f|0));e=c[n>>2]|0;f=c[o>>2]|0;if((f|0)==(e|0))break;c[o>>2]=f+(~((f+-4-e|0)>>>2)<<2)}while(0);e=c[p>>2]|0;if(e|0)mu(e);mu(p)}rk(r,17398,12);e=(qh(Zd(1148396,r)|0)|0)!=0;d=c[287098]|0;f=(c[d+20>>2]|0)+-1+(c[d+16>>2]|0)|0;f=(c[(c[d+4>>2]|0)+(f>>>4<<2)>>2]|0)+((f&15)*440|0)|0;d=c[287054]|0;if((c[287055]|0)==(d|0))gt(1148216);yf(984e3,u,e,l,f,c[d>>2]|0)|0;vk(r);F=me(A,v)|0;if(!(c[F+(c[(c[F>>2]|0)+-12>>2]|0)+16>>2]&5))do{m=gh(984e3,v)|0;if(!m)break f;e=c[287098]|0;Wu(s|0,0,440)|0;k=e+8|0;d=c[k>>2]|0;l=e+4|0;f=c[l>>2]|0;g=e+16|0;h=c[g>>2]|0;n=e+20|0;j=c[n>>2]|0;if((((d|0)==(f|0)?0:(d-f<<2)+-1|0)|0)==(j+h|0)){jh(e);h=c[g>>2]|0;e=c[n>>2]|0;d=c[k>>2]|0;f=c[l>>2]|0}else e=j;e=e+h|0;if((d|0)==(f|0))e=0;else e=(c[f+(e>>>4<<2)>>2]|0)+((e&15)*440|0)|0;_u(e|0,s|0,440)|0;c[n>>2]=(c[n>>2]|0)+1;E=c[287098]|0;F=(c[E+20>>2]|0)+-1+(c[E+16>>2]|0)|0;F=(c[(c[E+4>>2]|0)+(F>>>4<<2)>>2]|0)+((F&15)*440|0)|0;Nf(984e3,m,F,Lf(984e3,m)|0);F=me(A,v)|0}while(!(c[F+(c[(c[F>>2]|0)+-12>>2]|0)+16>>2]&5|0))}while(0);vk(u);vk(v);c[A>>2]=6636;c[x>>2]=6656;c[w>>2]=3544;vk(y);il(w);el(x);vk(z);vk(B);i=D;return}while(0);a[1217488]=1;e=c[287054]|0;if((c[287055]|0)==(e|0))gt(1148216);Ng(c[e>>2]|0,1);c[A>>2]=6636;c[x>>2]=6656;c[w>>2]=3544;vk(y);il(w);el(x);vk(z);vk(B);i=D;return}function gh(d,e){d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;v=i;i=i+4112|0;f=v+12|0;u=v;r=a[e>>0]|0;g=(r&1)==0;s=e+4|0;if(((g?(r&255)>>>1:c[s>>2]|0)|0)==5){r=e+8|0;q=e+1|0;p=(aj(a[(g?q:c[r>>2]|0)+4>>0]|0)|0)&255;a[((a[e>>0]&1)==0?q:c[r>>2]|0)+4>>0]=p}r=df(d,f)|0;c[f+4096>>2]=r;if((f|0)==(r|0)){u=0;i=v;return u|0}l=d+5360|0;m=u+4|0;n=u+8|0;o=u+1|0;p=e+1|0;q=e+8|0;a:while(1){hh(u,c[f>>2]|0,(a[l>>0]|0)!=0);k=b[e>>1]|0;h=(k&1)==0;d=(k&254)>>>1;j=h?d:c[s>>2]|0;w=a[u>>0]|0;g=(w&1)==0;k=(k&65535)>>>8&255;do if((j|0)==((g?(w&255)>>>1:c[m>>2]|0)|0)){g=g?o:c[n>>2]|0;if(!h){w=(rj(c[q>>2]|0,g,j)|0)==0;vk(u);if(w)break a;else break}if(!j){t=11;break a}if(k<<24>>24==(a[g>>0]|0)){h=p;while(1){d=d+-1|0;h=h+1|0;if(!d){t=11;break a}g=g+1|0;if((a[h>>0]|0)!=(a[g>>0]|0)){t=12;break}}}else t=12}else t=12;while(0);if((t|0)==12){t=0;vk(u)}f=f+8|0;if((f|0)==(r|0)){f=0;t=16;break}}if((t|0)==11)vk(u);else if((t|0)==16){i=v;return f|0}w=c[f>>2]|0;i=v;return w|0}function hh(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0;m=i;i=i+48|0;l=m+24|0;j=m+12|0;k=m;g=(d&131072|0)==0;h=g?d>>>6&63:64;f=d&63;switch(d|0){case 0:{rk(b,16931,6);i=m;return}case 65:{rk(b,16938,4);i=m;return}default:{g=g?d&49152:131072;if(!((g|0)!=49152|e))f=(f>>>0>h>>>0?6:2)|h&120;if((g|0)==131072){h=a[16943+(d>>>18&15)>>0]|0;a[j>>0]=4;a[j+1>>0]=h;a[j+2>>0]=64;a[j+3>>0]=0}else{a[j>>0]=4;a[j+1>>0]=(h&7)+97;a[j+2>>0]=(h>>>3)+49;a[j+3>>0]=0}a[k>>0]=4;h=k+1|0;a[h>>0]=(f&7)+97;a[k+2>>0]=(f>>>3)+49;a[k+3>>0]=0;h=Ek(j,h,2)|0;c[l>>2]=c[h>>2];c[l+4>>2]=c[h+4>>2];c[l+8>>2]=c[h+8>>2];c[h>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;vk(k);vk(j);if((g|0)==16384){if(!(d&65536))f=(d>>>12&3)+2|0;else f=6;Gk(l,a[16960+f>>0]|0)};c[b>>2]=c[l>>2];c[b+4>>2]=c[l+4>>2];c[b+8>>2]=c[l+8>>2];c[l>>2]=0;c[l+4>>2]=0;c[l+8>>2]=0;vk(l);i=m;return}}}function ih(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;i=a+4|0;j=c[a>>2]|0;d=((c[i>>2]|0)-j>>2)+1|0;if(d>>>0>1073741823)ft(a);k=a+8|0;e=(c[k>>2]|0)-j|0;if(e>>2>>>0<536870911){f=e>>1;d=f>>>0<d>>>0?d:f;f=c[i>>2]|0;e=f-j>>2;if(!d){h=0;g=0;d=f}else l=6}else{e=c[i>>2]|0;d=1073741823;f=e;e=e-j>>2;l=6}if((l|0)==6){h=d;g=Nu(d<<2)|0;d=f}l=g+(e<<2)|0;c[l>>2]=c[b>>2];f=d-j|0;b=l+(0-(f>>2)<<2)|0;_u(b|0,j|0,f|0)|0;c[a>>2]=b;c[i>>2]=l+4;c[k>>2]=g+(h<<2);if(!j)return;mu(j);return}function jh(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;q=i;i=i+16|0;f=q+4|0;g=q;b=a+16|0;d=c[b>>2]|0;if(d>>>0>15){c[b>>2]=d+-16;n=a+4|0;h=c[n>>2]|0;p=c[h>>2]|0;h=h+4|0;c[n>>2]=h;o=a+8|0;b=c[o>>2]|0;m=a+12|0;l=c[m>>2]|0;d=l;e=b;do if((b|0)==(l|0)){g=c[a>>2]|0;f=g;if(h>>>0>g>>>0){b=h;a=((b-f>>2)+1|0)/-2|0;m=h+(a<<2)|0;b=e-b|0;$u(m|0,h|0,b|0)|0;b=m+(b>>2<<2)|0;c[o>>2]=b;c[n>>2]=(c[n>>2]|0)+(a<<2);break}l=d-f>>1;l=(l|0)==0?1:l;f=Nu(l<<2)|0;j=f;d=f+(l>>>2<<2)|0;k=d;l=f+(l<<2)|0;if((h|0)==(b|0)){d=g;b=k}else{f=h;e=k;do{c[d>>2]=c[f>>2];d=e+4|0;e=d;f=f+4|0}while((f|0)!=(b|0));b=e;d=c[a>>2]|0}c[a>>2]=j;c[n>>2]=k;c[o>>2]=b;c[m>>2]=l;if(d){mu(d);b=c[o>>2]|0}}while(0);c[b>>2]=p;c[o>>2]=(c[o>>2]|0)+4;i=q;return}p=a+8|0;d=c[p>>2]|0;n=a+4|0;l=c[n>>2]|0;h=d-l|0;m=h>>2;o=a+12|0;e=c[o>>2]|0;b=e-(c[a>>2]|0)|0;j=d;if(m>>>0<b>>2>>>0){b=Nu(7040)|0;if((e|0)!=(d|0)){c[f>>2]=b;dh(a,f);i=q;return}c[g>>2]=b;eh(a,g);h=c[n>>2]|0;l=c[h>>2]|0;h=h+4|0;c[n>>2]=h;b=c[p>>2]|0;m=c[o>>2]|0;e=m;f=b;do if((b|0)==(m|0)){d=c[a>>2]|0;g=d;if(h>>>0>d>>>0){b=h;a=((b-g>>2)+1|0)/-2|0;o=h+(a<<2)|0;b=f-b|0;$u(o|0,h|0,b|0)|0;b=o+(b>>2<<2)|0;c[p>>2]=b;c[n>>2]=(c[n>>2]|0)+(a<<2);break}k=e-g>>1;k=(k|0)==0?1:k;m=Nu(k<<2)|0;g=m;e=m+(k>>>2<<2)|0;j=e;k=m+(k<<2)|0;if((h|0)==(b|0))b=j;else{f=h;d=j;do{c[e>>2]=c[f>>2];e=d+4|0;d=e;f=f+4|0}while((f|0)!=(b|0));b=d;d=c[a>>2]|0}c[a>>2]=g;c[n>>2]=j;c[p>>2]=b;c[o>>2]=k;if(d){mu(d);b=c[p>>2]|0}}while(0);c[b>>2]=l;c[p>>2]=(c[p>>2]|0)+4;i=q;return}g=b>>1;g=(g|0)==0?1:g;b=Nu(g<<2)|0;f=b;e=b+(m<<2)|0;d=b+(g<<2)|0;k=Nu(7040)|0;do if((m|0)==(g|0))if((h|0)>0){g=l;e=e+(((m+1|0)/-2|0)<<2)|0;break}else{d=h>>1;d=(d|0)==0?1:d;m=Nu(d<<2)|0;mu(b);j=c[p>>2]|0;g=c[n>>2]|0;f=m;e=m+(d>>>2<<2)|0;d=m+(d<<2)|0;break}else g=l;while(0);b=e;c[e>>2]=k;e=e+4|0;if((j|0)==(g|0)){g=f;f=b}else{m=j;do{m=m+-4|0;g=b;do if((g|0)==(f|0)){k=e;if(k>>>0<d>>>0){l=k+((((d-e>>2)+1|0)/2|0)<<2)|0;g=e-b|0;e=l+(0-(g>>2)<<2)|0;$u(e|0,b|0,g|0)|0;g=e;b=e;e=l;break}d=d-f>>1;d=(d|0)==0?1:d;h=Nu(d<<2)|0;f=h;j=h+((d+3|0)>>>2<<2)|0;l=j;d=h+(d<<2)|0;if((g|0)==(k|0))e=l;else{h=j;e=l;do{c[h>>2]=c[g>>2];h=e+4|0;e=h;g=g+4|0}while((g|0)!=(k|0))}if(!b){g=j;b=l}else{mu(b);g=j;b=l}}while(0);c[g+-4>>2]=c[m>>2];b=b+-4|0}while((m|0)!=(c[n>>2]|0));g=f;f=b}b=c[a>>2]|0;c[a>>2]=g;c[n>>2]=f;c[p>>2]=e;c[o>>2]=d;if(!b){i=q;return}mu(b);i=q;return}function kh(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0;j=i;i=i+16|0;h=j;d=a+4|0;f=c[d>>2]|0;do if(f){g=a+8|0;while(1){d=f+16|0;if(uh(g,b,d)|0){d=c[f>>2]|0;if(!d){e=f;d=f;g=5;break}}else{if(!(uh(g,d,b)|0)){d=f;g=10;break}e=f+4|0;d=c[e>>2]|0;if(!d){d=f;g=9;break}}f=d}if((g|0)==5){c[h>>2]=d;break}else if((g|0)==9){c[h>>2]=d;break}else if((g|0)==10){c[h>>2]=d;e=h;f=d;g=12;break}}else{c[h>>2]=d;e=d;g=12}while(0);if((g|0)==12)if(f){a=f;a=a+28|0;i=j;return a|0}f=Nu(92)|0;qk(f+16|0,b);zh(f+28|0,0);c[f>>2]=0;c[f+4>>2]=0;c[f+8>>2]=d;c[e>>2]=f;d=c[c[a>>2]>>2]|0;if(!d)d=f;else{c[a>>2]=d;d=c[e>>2]|0}ic(c[a+4>>2]|0,d);a=a+8|0;c[a>>2]=(c[a>>2]|0)+1;a=f;a=a+28|0;i=j;return a|0}function lh(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0;j=i;i=i+160|0;d=j+144|0;h=j;g=h+8|0;c[g>>2]=3508;e=h+12|0;c[h>>2]=3712;f=h+64|0;c[f>>2]=3732;c[h+4>>2]=0;fm(h+64|0,e);c[h+136>>2]=0;c[h+140>>2]=-1;c[h>>2]=3488;c[h+64>>2]=3528;c[g>>2]=3508;hm(e);c[e>>2]=3544;g=h+44|0;c[g>>2]=0;c[g+4>>2]=0;c[g+8>>2]=0;c[g+12>>2]=0;c[h+60>>2]=24;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;Td(e,d);vk(d);d=h+8|0;if((((b|0)>-1?b:0-b|0)|0)<31872)tm(Ud(d,17155,3)|0,(b*100|0)/248|0)|0;else{k=Ud(d,17159,5)|0;tm(k,(((b|0)>0?32001:-32e3)-b|0)/2|0)|0}Wd(a,e);c[h>>2]=3488;c[f>>2]=3528;c[d>>2]=3508;c[e>>2]=3544;vk(g);il(e);el(f);i=j;return}function mh(b,c){b=b|0;c=c|0;a[b>>0]=4;a[b+1>>0]=(c&7)+97;a[b+2>>0]=(c>>>3)+49;a[b+3>>0]=0;return}function nh(){var a=0,b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0;a=i;i=i+96|0;b=a;rk(b,17165,5);d=b+12|0;rk(d,17171,8);e=b+24|0;rk(e,17180,6);f=b+36|0;rk(f,17187,10);g=b+48|0;rk(g,17198,5);h=b+60|0;rk(h,17204,13);j=b+72|0;rk(j,17218,11);k=b+84|0;rk(k,17230,10);l=Nu(96)|0;c[287103]=l;c[287102]=l;c[287104]=l+96;qk(l,b);l=(c[287103]|0)+12|0;c[287103]=l;qk(l,d);l=(c[287103]|0)+12|0;c[287103]=l;qk(l,e);l=(c[287103]|0)+12|0;c[287103]=l;qk(l,f);l=(c[287103]|0)+12|0;c[287103]=l;qk(l,g);l=(c[287103]|0)+12|0;c[287103]=l;qk(l,h);l=(c[287103]|0)+12|0;c[287103]=l;qk(l,j);l=(c[287103]|0)+12|0;c[287103]=l;qk(l,k);c[287103]=(c[287103]|0)+12;vk(k);vk(j);vk(h);vk(g);vk(f);vk(e);vk(d);vk(b);c[287100]=0;c[287101]=0;c[287099]=1148400;i=a;return}function oh(a){a=a|0;Fg();return}function ph(a){a=a|0;var b=0;b=a+12|0;if(!(Lk(a+24|0,17241)|0)){a=Xk(b,0,10)|0;Zg(1148256,a);return}else{a=(Lk(b,23296)|0)==0&1;Zg(1148256,a);return}}function qh(a){a=a|0;var b=0;b=a+12|0;if(!(Lk(a+24|0,17241)|0)){a=Xk(b,0,10)|0;return a|0}else{a=(Lk(b,23296)|0)==0&1;return a|0}return 0}function rh(a){a=a|0;var b=0,c=0;b=i;i=i+16|0;c=b;qk(c,a+12|0);pe(c);vk(c);i=b;return}function sh(a,b){a=a|0;b=b|0;qk(a,b+12|0);return}function th(a){a=a|0;Qg(1148216);return}function uh(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;g=a[d>>0]|0;h=(g&1)==0;f=h?d+1|0:c[d+8>>2]|0;g=f+(h?(g&255)>>>1:c[d+4>>2]|0)|0;d=a[e>>0]|0;h=(d&1)==0;b=h?e+1|0:c[e+8>>2]|0;d=h?(d&255)>>>1:c[e+4>>2]|0;e=b+d|0;if(!d){h=0;return h|0}else d=f;while(1){if((d|0)==(g|0)){b=1;d=6;break}h=a[b>>0]|0;f=aj(a[d>>0]|0)|0;if((f|0)<(aj(h<<24>>24)|0)){b=1;d=6;break}h=a[d>>0]|0;f=aj(a[b>>0]|0)|0;if((f|0)<(aj(h<<24>>24)|0)){b=0;d=6;break}b=b+1|0;if((b|0)==(e|0)){b=0;d=6;break}else d=d+1|0}if((d|0)==6)return b|0;return 0}function vh(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0;N=i;i=i+1136|0;G=N+1116|0;h=N+1104|0;j=N+1040|0;m=N+1024|0;n=N+960|0;o=N+944|0;p=N+880|0;q=N+864|0;r=N+800|0;t=N+784|0;s=N+720|0;u=N+704|0;v=N+640|0;w=N+624|0;x=N+560|0;y=N+544|0;z=N+480|0;A=N+464|0;B=N+400|0;C=N+384|0;D=N+320|0;E=N+304|0;F=N+240|0;H=N+224|0;I=N+160|0;J=N+144|0;K=N+80|0;L=N+64|0;M=N;rk(h,17246,14);d=Zd(b,h)|0;k=j+12|0;l=j+24|0;c[j>>2]=0;c[j+4>>2]=0;c[j+8>>2]=0;c[j+12>>2]=0;c[j+16>>2]=0;c[j+20>>2]=0;rk(l,17261,6);e=j+36|0;c[e>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;c[e+16>>2]=0;c[j+60>>2]=153;wk(j,Ak(k,1219563)|0)|0;wk(d,j)|0;wk(d+12|0,k)|0;wk(d+24|0,l)|0;f=c[e+4>>2]|0;g=d+36|0;c[g>>2]=c[e>>2];c[g+4>>2]=f;if((d|0)!=(j|0))wh(d+44|0,c[j+44>>2]|0,c[j+48>>2]|0);f=d+56|0;e=j+56|0;g=c[e+4>>2]|0;d=f;c[d>>2]=c[e>>2];c[d+4>>2]=g;d=c[287105]|0;c[287105]=d+1;c[f>>2]=d;f=j+44|0;d=c[f>>2]|0;if(d|0){g=j+48|0;e=c[g>>2]|0;if((e|0)!=(d|0)){do{O=e+-12|0;c[g>>2]=O;vk(O);e=c[g>>2]|0}while((e|0)!=(d|0));d=c[f>>2]|0}mu(d)}vk(l);vk(k);vk(j);vk(h);rk(m,17268,8);d=Zd(b,m)|0;h=n+12|0;j=n+24|0;c[n>>2]=0;c[n+4>>2]=0;c[n+8>>2]=0;c[n+12>>2]=0;c[n+16>>2]=0;c[n+20>>2]=0;rk(j,17241,4);e=n+36|0;c[e>>2]=-100;c[n+40>>2]=100;f=n+44|0;c[f>>2]=0;g=n+48|0;c[g>>2]=0;c[n+52>>2]=0;c[n+60>>2]=0;al(G,0);if(!(a[h>>0]&1)){a[h+1>>0]=0;a[h>>0]=0}else{a[c[n+20>>2]>>0]=0;c[n+16>>2]=0}zk(h,0);c[h>>2]=c[G>>2];c[h+4>>2]=c[G+4>>2];c[h+8>>2]=c[G+8>>2];c[G>>2]=0;c[G+4>>2]=0;c[G+8>>2]=0;wk(n,h)|0;vk(G);wk(d,n)|0;wk(d+12|0,h)|0;wk(d+24|0,j)|0;k=e;l=c[k+4>>2]|0;O=d+36|0;c[O>>2]=c[k>>2];c[O+4>>2]=l;if((d|0)!=(n|0))wh(d+44|0,c[f>>2]|0,c[g>>2]|0);f=d+56|0;l=n+56|0;O=c[l+4>>2]|0;d=f;c[d>>2]=c[l>>2];c[d+4>>2]=O;d=c[287105]|0;c[287105]=d+1;c[f>>2]=d;f=n+44|0;d=c[f>>2]|0;if(d|0){e=c[g>>2]|0;if((e|0)!=(d|0)){do{O=e+-12|0;c[g>>2]=O;vk(O);e=c[g>>2]|0}while((e|0)!=(d|0));d=c[f>>2]|0}mu(d)}vk(j);vk(h);vk(n);vk(m);rk(o,17277,7);d=Zd(b,o)|0;h=p+12|0;j=p+24|0;c[p>>2]=0;c[p+4>>2]=0;c[p+8>>2]=0;c[p+12>>2]=0;c[p+16>>2]=0;c[p+20>>2]=0;rk(j,17241,4);e=p+36|0;c[e>>2]=1;c[p+40>>2]=1;f=p+44|0;c[f>>2]=0;g=p+48|0;c[g>>2]=0;c[p+52>>2]=0;c[p+60>>2]=154;al(G,1);if(!(a[h>>0]&1)){a[h+1>>0]=0;a[h>>0]=0}else{a[c[p+20>>2]>>0]=0;c[p+16>>2]=0}zk(h,0);c[h>>2]=c[G>>2];c[h+4>>2]=c[G+4>>2];c[h+8>>2]=c[G+8>>2];c[G>>2]=0;c[G+4>>2]=0;c[G+8>>2]=0;wk(p,h)|0;vk(G);wk(d,p)|0;wk(d+12|0,h)|0;wk(d+24|0,j)|0;m=e;n=c[m+4>>2]|0;O=d+36|0;c[O>>2]=c[m>>2];c[O+4>>2]=n;if((d|0)!=(p|0))wh(d+44|0,c[f>>2]|0,c[g>>2]|0);f=d+56|0;n=p+56|0;O=c[n+4>>2]|0;d=f;c[d>>2]=c[n>>2];c[d+4>>2]=O;d=c[287105]|0;c[287105]=d+1;c[f>>2]=d;f=p+44|0;d=c[f>>2]|0;if(d|0){e=c[g>>2]|0;if((e|0)!=(d|0)){do{O=e+-12|0;c[g>>2]=O;vk(O);e=c[g>>2]|0}while((e|0)!=(d|0));d=c[f>>2]|0}mu(d)}vk(j);vk(h);vk(p);vk(o);rk(q,17285,4);d=Zd(b,q)|0;h=r+12|0;j=r+24|0;c[r>>2]=0;c[r+4>>2]=0;c[r+8>>2]=0;c[r+12>>2]=0;c[r+16>>2]=0;c[r+20>>2]=0;rk(j,17241,4);e=r+36|0;c[e>>2]=1;c[r+40>>2]=2048;f=r+44|0;c[f>>2]=0;g=r+48|0;c[g>>2]=0;c[r+52>>2]=0;c[r+60>>2]=155;al(G,16);if(!(a[h>>0]&1)){a[h+1>>0]=0;a[h>>0]=0}else{a[c[r+20>>2]>>0]=0;c[r+16>>2]=0}zk(h,0);c[h>>2]=c[G>>2];c[h+4>>2]=c[G+4>>2];c[h+8>>2]=c[G+8>>2];c[G>>2]=0;c[G+4>>2]=0;c[G+8>>2]=0;wk(r,h)|0;vk(G);wk(d,r)|0;wk(d+12|0,h)|0;wk(d+24|0,j)|0;o=e;p=c[o+4>>2]|0;O=d+36|0;c[O>>2]=c[o>>2];c[O+4>>2]=p;if((d|0)!=(r|0))wh(d+44|0,c[f>>2]|0,c[g>>2]|0);f=d+56|0;p=r+56|0;O=c[p+4>>2]|0;d=f;c[d>>2]=c[p>>2];c[d+4>>2]=O;d=c[287105]|0;c[287105]=d+1;c[f>>2]=d;f=r+44|0;d=c[f>>2]|0;if(d|0){e=c[g>>2]|0;if((e|0)!=(d|0)){do{O=e+-12|0;c[g>>2]=O;vk(O);e=c[g>>2]|0}while((e|0)!=(d|0));d=c[f>>2]|0}mu(d)}vk(j);vk(h);vk(r);vk(q);rk(t,17290,10);d=Zd(b,t)|0;h=s+24|0;c[s>>2]=0;c[s+4>>2]=0;c[s+8>>2]=0;c[s+12>>2]=0;c[s+16>>2]=0;c[s+20>>2]=0;rk(h,17301,6);q=s+36|0;c[q>>2]=0;c[q+4>>2]=0;c[q+8>>2]=0;c[q+12>>2]=0;c[q+16>>2]=0;c[s+60>>2]=156;wk(d,s)|0;j=s+12|0;wk(d+12|0,j)|0;wk(d+24|0,h)|0;r=c[q+4>>2]|0;O=d+36|0;c[O>>2]=c[q>>2];c[O+4>>2]=r;if((d|0)!=(s|0))wh(d+44|0,c[s+44>>2]|0,c[s+48>>2]|0);f=d+56|0;r=s+56|0;O=c[r+4>>2]|0;d=f;c[d>>2]=c[r>>2];c[d+4>>2]=O;d=c[287105]|0;c[287105]=d+1;c[f>>2]=d;f=s+44|0;d=c[f>>2]|0;if(d|0){g=s+48|0;e=c[g>>2]|0;if((e|0)!=(d|0)){do{O=e+-12|0;c[g>>2]=O;vk(O);e=c[g>>2]|0}while((e|0)!=(d|0));d=c[f>>2]|0}mu(d)}vk(h);vk(j);vk(s);vk(t);rk(u,17308,6);d=Zd(b,u)|0;h=v+12|0;j=v+24|0;c[v>>2]=0;c[v+4>>2]=0;c[v+8>>2]=0;c[v+12>>2]=0;c[v+16>>2]=0;c[v+20>>2]=0;rk(j,17315,5);s=v+36|0;c[s>>2]=0;c[s+4>>2]=0;c[s+8>>2]=0;c[s+12>>2]=0;c[s+16>>2]=0;c[v+60>>2]=0;wk(v,Ak(h,23301)|0)|0;wk(d,v)|0;wk(d+12|0,h)|0;wk(d+24|0,j)|0;t=c[s+4>>2]|0;O=d+36|0;c[O>>2]=c[s>>2];c[O+4>>2]=t;if((d|0)!=(v|0))wh(d+44|0,c[v+44>>2]|0,c[v+48>>2]|0);f=d+56|0;t=v+56|0;O=c[t+4>>2]|0;d=f;c[d>>2]=c[t>>2];c[d+4>>2]=O;d=c[287105]|0;c[287105]=d+1;c[f>>2]=d;f=v+44|0;d=c[f>>2]|0;if(d|0){g=v+48|0;e=c[g>>2]|0;if((e|0)!=(d|0)){do{O=e+-12|0;c[g>>2]=O;vk(O);e=c[g>>2]|0}while((e|0)!=(d|0));d=c[f>>2]|0}mu(d)}vk(j);vk(h);vk(v);vk(u);rk(w,17321,7);d=Zd(b,w)|0;h=x+12|0;j=x+24|0;c[x>>2]=0;c[x+4>>2]=0;c[x+8>>2]=0;c[x+12>>2]=0;c[x+16>>2]=0;c[x+20>>2]=0;rk(j,17241,4);e=x+36|0;c[e>>2]=1;c[x+40>>2]=500;f=x+44|0;c[f>>2]=0;g=x+48|0;c[g>>2]=0;c[x+52>>2]=0;c[x+60>>2]=0;al(G,1);if(!(a[h>>0]&1)){a[h+1>>0]=0;a[h>>0]=0}else{a[c[x+20>>2]>>0]=0;c[x+16>>2]=0}zk(h,0);c[h>>2]=c[G>>2];c[h+4>>2]=c[G+4>>2];c[h+8>>2]=c[G+8>>2];c[G>>2]=0;c[G+4>>2]=0;c[G+8>>2]=0;wk(x,h)|0;vk(G);wk(d,x)|0;wk(d+12|0,h)|0;wk(d+24|0,j)|0;u=e;v=c[u+4>>2]|0;O=d+36|0;c[O>>2]=c[u>>2];c[O+4>>2]=v;if((d|0)!=(x|0))wh(d+44|0,c[f>>2]|0,c[g>>2]|0);f=d+56|0;v=x+56|0;O=c[v+4>>2]|0;d=f;c[d>>2]=c[v>>2];c[d+4>>2]=O;d=c[287105]|0;c[287105]=d+1;c[f>>2]=d;f=x+44|0;d=c[f>>2]|0;if(d|0){e=c[g>>2]|0;if((e|0)!=(d|0)){do{O=e+-12|0;c[g>>2]=O;vk(O);e=c[g>>2]|0}while((e|0)!=(d|0));d=c[f>>2]|0}mu(d)}vk(j);vk(h);vk(x);vk(w);rk(y,17329,11);d=Zd(b,y)|0;h=z+12|0;j=z+24|0;c[z>>2]=0;c[z+4>>2]=0;c[z+8>>2]=0;c[z+12>>2]=0;c[z+16>>2]=0;c[z+20>>2]=0;rk(j,17241,4);e=z+36|0;c[e>>2]=0;c[z+40>>2]=20;f=z+44|0;c[f>>2]=0;g=z+48|0;c[g>>2]=0;c[z+52>>2]=0;c[z+60>>2]=0;al(G,20);if(!(a[h>>0]&1)){a[h+1>>0]=0;a[h>>0]=0}else{a[c[z+20>>2]>>0]=0;c[z+16>>2]=0}zk(h,0);c[h>>2]=c[G>>2];c[h+4>>2]=c[G+4>>2];c[h+8>>2]=c[G+8>>2];c[G>>2]=0;c[G+4>>2]=0;c[G+8>>2]=0;wk(z,h)|0;vk(G);wk(d,z)|0;wk(d+12|0,h)|0;wk(d+24|0,j)|0;w=e;x=c[w+4>>2]|0;O=d+36|0;c[O>>2]=c[w>>2];c[O+4>>2]=x;if((d|0)!=(z|0))wh(d+44|0,c[f>>2]|0,c[g>>2]|0);f=d+56|0;x=z+56|0;O=c[x+4>>2]|0;d=f;c[d>>2]=c[x>>2];c[d+4>>2]=O;d=c[287105]|0;c[287105]=d+1;c[f>>2]=d;f=z+44|0;d=c[f>>2]|0;if(d|0){e=c[g>>2]|0;if((e|0)!=(d|0)){do{O=e+-12|0;c[g>>2]=O;vk(O);e=c[g>>2]|0}while((e|0)!=(d|0));d=c[f>>2]|0}mu(d)}vk(j);vk(h);vk(z);vk(y);rk(A,17341,13);d=Zd(b,A)|0;h=B+12|0;j=B+24|0;c[B>>2]=0;c[B+4>>2]=0;c[B+8>>2]=0;c[B+12>>2]=0;c[B+16>>2]=0;c[B+20>>2]=0;rk(j,17241,4);e=B+36|0;c[e>>2]=0;c[B+40>>2]=5e3;f=B+44|0;c[f>>2]=0;g=B+48|0;c[g>>2]=0;c[B+52>>2]=0;c[B+60>>2]=0;al(G,30);if(!(a[h>>0]&1)){a[h+1>>0]=0;a[h>>0]=0}else{a[c[B+20>>2]>>0]=0;c[B+16>>2]=0}zk(h,0);c[h>>2]=c[G>>2];c[h+4>>2]=c[G+4>>2];c[h+8>>2]=c[G+8>>2];c[G>>2]=0;c[G+4>>2]=0;c[G+8>>2]=0;wk(B,h)|0;vk(G);wk(d,B)|0;wk(d+12|0,h)|0;wk(d+24|0,j)|0;y=e;z=c[y+4>>2]|0;O=d+36|0;c[O>>2]=c[y>>2];c[O+4>>2]=z;if((d|0)!=(B|0))wh(d+44|0,c[f>>2]|0,c[g>>2]|0);f=d+56|0;z=B+56|0;O=c[z+4>>2]|0;d=f;c[d>>2]=c[z>>2];c[d+4>>2]=O;d=c[287105]|0;c[287105]=d+1;c[f>>2]=d;f=B+44|0;d=c[f>>2]|0;if(d|0){e=c[g>>2]|0;if((e|0)!=(d|0)){do{O=e+-12|0;c[g>>2]=O;vk(O);e=c[g>>2]|0}while((e|0)!=(d|0));d=c[f>>2]|0}mu(d)}vk(j);vk(h);vk(B);vk(A);rk(C,17355,21);d=Zd(b,C)|0;h=D+12|0;j=D+24|0;c[D>>2]=0;c[D+4>>2]=0;c[D+8>>2]=0;c[D+12>>2]=0;c[D+16>>2]=0;c[D+20>>2]=0;rk(j,17241,4);e=D+36|0;c[e>>2]=0;c[D+40>>2]=5e3;f=D+44|0;c[f>>2]=0;g=D+48|0;c[g>>2]=0;c[D+52>>2]=0;c[D+60>>2]=0;al(G,20);if(!(a[h>>0]&1)){a[h+1>>0]=0;a[h>>0]=0}else{a[c[D+20>>2]>>0]=0;c[D+16>>2]=0}zk(h,0);c[h>>2]=c[G>>2];c[h+4>>2]=c[G+4>>2];c[h+8>>2]=c[G+8>>2];c[G>>2]=0;c[G+4>>2]=0;c[G+8>>2]=0;wk(D,h)|0;vk(G);wk(d,D)|0;wk(d+12|0,h)|0;wk(d+24|0,j)|0;A=e;B=c[A+4>>2]|0;O=d+36|0;c[O>>2]=c[A>>2];c[O+4>>2]=B;if((d|0)!=(D|0))wh(d+44|0,c[f>>2]|0,c[g>>2]|0);f=d+56|0;B=D+56|0;O=c[B+4>>2]|0;d=f;c[d>>2]=c[B>>2];c[d+4>>2]=O;d=c[287105]|0;c[287105]=d+1;c[f>>2]=d;f=D+44|0;d=c[f>>2]|0;if(d|0){e=c[g>>2]|0;if((e|0)!=(d|0)){do{O=e+-12|0;c[g>>2]=O;vk(O);e=c[g>>2]|0}while((e|0)!=(d|0));d=c[f>>2]|0}mu(d)}vk(j);vk(h);vk(D);vk(C);rk(E,17377,10);d=Zd(b,E)|0;h=F+12|0;j=F+24|0;c[F>>2]=0;c[F+4>>2]=0;c[F+8>>2]=0;c[F+12>>2]=0;c[F+16>>2]=0;c[F+20>>2]=0;rk(j,17241,4);e=F+36|0;c[e>>2]=10;c[F+40>>2]=1e3;f=F+44|0;c[f>>2]=0;g=F+48|0;c[g>>2]=0;c[F+52>>2]=0;c[F+60>>2]=0;al(G,89);if(!(a[h>>0]&1)){a[h+1>>0]=0;a[h>>0]=0}else{a[c[F+20>>2]>>0]=0;c[F+16>>2]=0}zk(h,0);c[h>>2]=c[G>>2];c[h+4>>2]=c[G+4>>2];c[h+8>>2]=c[G+8>>2];c[G>>2]=0;c[G+4>>2]=0;c[G+8>>2]=0;wk(F,h)|0;vk(G);wk(d,F)|0;wk(d+12|0,h)|0;wk(d+24|0,j)|0;C=e;D=c[C+4>>2]|0;O=d+36|0;c[O>>2]=c[C>>2];c[O+4>>2]=D;if((d|0)!=(F|0))wh(d+44|0,c[f>>2]|0,c[g>>2]|0);f=d+56|0;D=F+56|0;O=c[D+4>>2]|0;d=f;c[d>>2]=c[D>>2];c[d+4>>2]=O;d=c[287105]|0;c[287105]=d+1;c[f>>2]=d;f=F+44|0;d=c[f>>2]|0;if(d|0){e=c[g>>2]|0;if((e|0)!=(d|0)){do{O=e+-12|0;c[g>>2]=O;vk(O);e=c[g>>2]|0}while((e|0)!=(d|0));d=c[f>>2]|0}mu(d)}vk(j);vk(h);vk(F);vk(E);rk(H,17388,9);d=Zd(b,H)|0;h=I+12|0;j=I+24|0;c[I>>2]=0;c[I+4>>2]=0;c[I+8>>2]=0;c[I+12>>2]=0;c[I+16>>2]=0;c[I+20>>2]=0;rk(j,17241,4);e=I+36|0;c[e>>2]=0;c[I+40>>2]=1e4;f=I+44|0;c[f>>2]=0;g=I+48|0;c[g>>2]=0;c[I+52>>2]=0;c[I+60>>2]=0;al(G,0);if(!(a[h>>0]&1)){a[h+1>>0]=0;a[h>>0]=0}else{a[c[I+20>>2]>>0]=0;c[I+16>>2]=0}zk(h,0);c[h>>2]=c[G>>2];c[h+4>>2]=c[G+4>>2];c[h+8>>2]=c[G+8>>2];c[G>>2]=0;c[G+4>>2]=0;c[G+8>>2]=0;wk(I,h)|0;vk(G);wk(d,I)|0;wk(d+12|0,h)|0;wk(d+24|0,j)|0;F=e;G=c[F+4>>2]|0;O=d+36|0;c[O>>2]=c[F>>2];c[O+4>>2]=G;if((d|0)!=(I|0))wh(d+44|0,c[f>>2]|0,c[g>>2]|0);f=d+56|0;G=I+56|0;O=c[G+4>>2]|0;d=f;c[d>>2]=c[G>>2];c[d+4>>2]=O;d=c[287105]|0;c[287105]=d+1;c[f>>2]=d;f=I+44|0;d=c[f>>2]|0;if(d|0){e=c[g>>2]|0;if((e|0)!=(d|0)){do{O=e+-12|0;c[g>>2]=O;vk(O);e=c[g>>2]|0}while((e|0)!=(d|0));d=c[f>>2]|0}mu(d)}vk(j);vk(h);vk(I);vk(H);rk(J,17398,12);d=Zd(b,J)|0;h=K+12|0;j=K+24|0;c[K>>2]=0;c[K+4>>2]=0;c[K+8>>2]=0;c[K+12>>2]=0;c[K+16>>2]=0;c[K+20>>2]=0;rk(j,17315,5);H=K+36|0;c[H>>2]=0;c[H+4>>2]=0;c[H+8>>2]=0;c[H+12>>2]=0;c[H+16>>2]=0;c[K+60>>2]=0;wk(K,Ak(h,23301)|0)|0;wk(d,K)|0;wk(d+12|0,h)|0;wk(d+24|0,j)|0;I=c[H+4>>2]|0;O=d+36|0;c[O>>2]=c[H>>2];c[O+4>>2]=I;if((d|0)!=(K|0))wh(d+44|0,c[K+44>>2]|0,c[K+48>>2]|0);f=d+56|0;I=K+56|0;O=c[I+4>>2]|0;d=f;c[d>>2]=c[I>>2];c[d+4>>2]=O;d=c[287105]|0;c[287105]=d+1;c[f>>2]=d;f=K+44|0;d=c[f>>2]|0;if(d|0){g=K+48|0;e=c[g>>2]|0;if((e|0)!=(d|0)){do{O=e+-12|0;c[g>>2]=O;vk(O);e=c[g>>2]|0}while((e|0)!=(d|0));d=c[f>>2]|0}mu(d)}vk(j);vk(h);vk(K);vk(J);rk(L,17411,11);e=Zd(b,L)|0;d=c[287102]|0;if(!(a[d>>0]&1))d=d+1|0;else d=c[d+8>>2]|0;xh(M,d,1148408,0);wk(e,M)|0;h=M+12|0;wk(e+12|0,h)|0;j=M+24|0;wk(e+24|0,j)|0;K=M+36|0;b=c[K+4>>2]|0;O=e+36|0;c[O>>2]=c[K>>2];c[O+4>>2]=b;if((e|0)!=(M|0))wh(e+44|0,c[M+44>>2]|0,c[M+48>>2]|0);f=e+56|0;b=M+56|0;O=c[b+4>>2]|0;d=f;c[d>>2]=c[b>>2];c[d+4>>2]=O;d=c[287105]|0;c[287105]=d+1;c[f>>2]=d;f=M+44|0;d=c[f>>2]|0;if(!d){vk(j);vk(h);vk(M);vk(L);i=N;return}g=M+48|0;e=c[g>>2]|0;if((e|0)!=(d|0)){do{O=e+-12|0;c[g>>2]=O;vk(O);e=c[g>>2]|0}while((e|0)!=(d|0));d=c[f>>2]|0}mu(d);vk(j);vk(h);vk(M);vk(L);i=N;return}function wh(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0;j=(d-b|0)/12|0;k=a+8|0;g=c[k>>2]|0;e=c[a>>2]|0;f=e;if(j>>>0<=((g-e|0)/12|0)>>>0){i=a+4|0;e=((c[i>>2]|0)-e|0)/12|0;h=j>>>0>e>>>0;e=b+(e*12|0)|0;g=h?e:d;if((g|0)!=(b|0))do{wk(f,b)|0;b=b+12|0;f=f+12|0}while((b|0)!=(g|0));if(!h){e=c[i>>2]|0;if((e|0)==(f|0))return;do{d=e+-12|0;c[i>>2]=d;vk(d);e=c[i>>2]|0}while((e|0)!=(f|0));return}if((g|0)==(d|0))return;b=c[i>>2]|0;do{qk(b,e);b=(c[i>>2]|0)+12|0;c[i>>2]=b;e=e+12|0}while((e|0)!=(d|0));return}if(!e)e=g;else{h=a+4|0;g=c[h>>2]|0;if((g|0)!=(f|0)){e=g;do{g=e+-12|0;c[h>>2]=g;vk(g);e=c[h>>2]|0}while((e|0)!=(f|0));e=c[a>>2]|0}mu(e);c[k>>2]=0;c[h>>2]=0;c[a>>2]=0;e=0}g=j>>>0>357913941;if(g)ft(a);e=(e-0|0)/12|0;if(e>>>0<178956970){f=e<<1;e=f>>>0>=j>>>0;if(e|g^1)i=e?f:j;else ft(a)}else i=357913941;e=Nu(i*12|0)|0;f=a+4|0;c[f>>2]=e;c[a>>2]=e;c[k>>2]=e+(i*12|0);if((b|0)==(d|0))return;do{qk(e,b);e=(c[f>>2]|0)+12|0;c[f>>2]=e;b=b+12|0}while((b|0)!=(d|0));return}function xh(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;j=a+12|0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0;c[a+16>>2]=0;c[a+20>>2]=0;rk(a+24|0,17423,5);m=a+36|0;g=a+44|0;k=a+48|0;i=d+4|0;c[m>>2]=0;c[m+4>>2]=0;c[m+8>>2]=0;c[m+12>>2]=0;c[m+16>>2]=0;m=c[i>>2]|0;l=c[d>>2]|0;f=m-l|0;h=(f|0)/12|0;if((m|0)!=(l|0)){if(h>>>0>357913941)ft(g);f=Nu(f)|0;c[k>>2]=f;c[g>>2]=f;c[a+52>>2]=f+(h*12|0);g=c[d>>2]|0;h=c[i>>2]|0;if((g|0)!=(h|0))do{qk(f,g);f=(c[k>>2]|0)+12|0;c[k>>2]=f;g=g+12|0}while((g|0)!=(h|0))}c[a+60>>2]=e;wk(a,Ak(j,b)|0)|0;return}function yh(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0;r=i;i=i+16|0;q=r;h=d+8|0;if(!(c[h>>2]|0)){i=r;return b|0}j=d+4|0;k=q+8|0;l=q+1|0;m=q+4|0;p=0;do{e=c[d>>2]|0;a:do if((e|0)!=(j|0)){f=e;while(1){if((c[f+84>>2]|0)==(p|0))break;e=c[f+4>>2]|0;if(!e)while(1){e=c[f+8>>2]|0;if((c[e>>2]|0)==(f|0))break;else f=e}else while(1){f=c[e>>2]|0;if(!f)break;else e=f}if((e|0)==(j|0))break a;else f=e}g=f+16|0;s=Ud(b,17429,13)|0;t=a[g>>0]|0;e=(t&1)==0;t=Ud(Ud(s,e?g+1|0:c[f+24>>2]|0,e?(t&255)>>>1:c[f+20>>2]|0)|0,17443,6)|0;e=f+52|0;g=a[e>>0]|0;s=(g&1)==0;Ud(t,s?e+1|0:c[f+60>>2]|0,s?(g&255)>>>1:c[f+56>>2]|0)|0;if(Lk(e,17301)|0){u=Ud(b,17450,9)|0;g=f+28|0;t=a[g>>0]|0;s=(t&1)==0;Ud(u,s?g+1|0:c[f+36>>2]|0,s?(t&255)>>>1:c[f+32>>2]|0)|0}if((Lk(e,17423)|0)==0?(n=c[f+72>>2]|0,o=c[f+76>>2]|0,(n|0)!=(o|0)):0){g=n;do{qk(q,g);s=Ud(b,17460,5)|0;u=a[q>>0]|0;t=(u&1)==0;Ud(s,t?l:c[k>>2]|0,t?(u&255)>>>1:c[m>>2]|0)|0;vk(q);g=g+12|0}while((g|0)!=(o|0))}if(!(Lk(e,17241)|0)){u=Ud(b,17466,5)|0;u=Ud(tm(u,c[f+64>>2]|0)|0,17472,5)|0;tm(u,c[f+68>>2]|0)|0}}while(0);p=p+1|0}while(p>>>0<(c[h>>2]|0)>>>0);i=r;return b|0}
function cf(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0;X=a+5364|0;k=c[X>>2]|0;if((k|0)==1){a=b;return a|0}Y=a+5348|0;w=c[Y>>2]|0;switch(k|0){case 4:{i=w<<3|6;if(!(c[a+336+(i<<2)>>2]|0))v=64;else{j=i;S=6}break}case 2:{i=w<<3|6;if(!(c[a+336+(i<<2)>>2]|0))v=64;else{j=i;S=6}break}default:{j=w<<3|6;S=6}}if((S|0)==6)v=c[a+400+(j<<8)>>2]|0;u=a+5356|0;o=(c[u>>2]|0)+64|0;j=c[o>>2]|0;o=c[o+4>>2]|0;t=a+272|0;Z=a+264|0;W=Z;l=j&~(c[W>>2]|c[t>>2]);t=o&~(c[W+4>>2]|c[t+4>>2]);do if((k|0)==2){i=w<<3^14;if(!(c[a+336+(i<<2)>>2]|0))i=64;else i=c[a+400+(i<<8)>>2]|0;s=30016+(i<<3)|0;r=c[s>>2]|0;s=c[s+4>>2]|0;q=a+320+((w^1)<<3)|0;p=c[q>>2]|0;q=c[q+4>>2]|0;if((j|0)==0&(o|0)==0){i=p;k=q}else{i=p;k=q;do{V=hb(j|0,o|0,0)|0;W=Xu(j|0,o|0,-1,-1)|0;j=W&j;o=C&o;W=30016+(V<<3)|0;V=26112+(V<<3)|0;i=(c[V>>2]|c[W>>2])&i;k=(c[V+4>>2]|c[W+4>>2])&k}while(!((j|0)==0&(o|0)==0))}W=30016+(v<<3)|0;j=p&(i|r)&~c[W>>2];i=q&(k|s)&~c[W+4>>2];if(!w){b=Oe(a,b,j,i)|0;o=r;p=s;break}else{b=Pe(a,b,j,i)|0;o=r;p=s;break}}else{o=0;p=0}while(0);if((l|0)==0&(t|0)==0){i=0;j=0}else{k=t;i=0;j=0;do{V=hb(l|0,k|0,0)|0;W=Xu(l|0,k|0,-1,-1)|0;l=W&l;k=C&k;W=67904+(V<<9)+(v<<3)|0;V=26112+(V<<3)|0;i=c[V>>2]^c[W>>2]|i;j=c[V+4>>2]^c[W+4>>2]|j}while(!((l|0)==0&(k|0)==0))}r=c[X>>2]|0;q=(r|0)==2;l=30016+(v<<3)|0;k=c[l>>2]|0;l=c[l+4>>2]|0;if(q){W=a+256|0;k=k&(o|~i)&~c[W>>2];j=l&(p|~j)&~c[W+4>>2]}else{W=a+320+(w<<3)|0;k=k&~i&~c[W>>2];j=l&~j&~c[W+4>>2]}if(!((k|0)==0&(j|0)==0)){l=v<<6;while(1){i=b+8|0;W=hb(k|0,j|0,0)|0;V=Xu(k|0,j|0,-1,-1)|0;k=V&k;j=C&j;c[b>>2]=W+l;if((k|0)==0&(j|0)==0){b=i;break}else b=i}}R=c[u>>2]|0;U=R+64|0;T=c[U>>2]|0;U=c[U+4>>2]|0;W=Xu(T|0,U|0,-1,-1)|0;if(!((W&T|0)==0&(C&U|0)==0)){a=b;return a|0}j=hb(T|0,U|0,0)|0;k=35136+(j<<9)+(v<<3)|0;i=c[k>>2]|0;k=c[k+4>>2]|0;if(q){W=i;V=k}else{V=26112+(j<<3)|0;W=c[V>>2]|i;V=c[V+4>>2]|k}if(!w){s=a+320|0;r=c[s>>2]|0;s=c[s+4>>2]|0;m=Z;p=c[m>>2]&r;m=c[m+4>>2]&s;j=m&16711680;q=m&-16711681;o=a+328|0;n=c[o>>2]&W;o=c[o+4>>2]&V;t=a+256|0;d=t;L=~c[d>>2];d=~c[d+4>>2];N=c[X>>2]|0;I=(N|0)==1;k=W&L;l=V&d;f=Zu(p|0,q|0,8)|0;e=C;d=Zu((I?k:L)&f|0,(I?l:d)&e|0,8)|0;I=(N|0)==4;L=I?-65536:-16777216;f=f&k;e=e&l;d=L&k&d;if((N|0)==3?(x=k&-256,y=l&16777215,((x|0)!=0|(y|0)!=0)&(c[a+4500>>2]|0)!=0):0){i=x;h=y;while(1){g=b+8|0;N=hb(i|0,h|0,0)|0;L=Xu(i|0,h|0,-1,-1)|0;i=L&i;h=C&h;c[b>>2]=N|393216;if((i|0)==0&(h|0)==0){b=g;break}else b=g}}if(!((f|0)==0&(e|0)==0)){g=b;while(1){N=hb(f|0,e|0,0)|0;b=Xu(f|0,e|0,-1,-1)|0;f=b&f;e=C&e;b=g+8|0;c[g>>2]=(N|-512)+(N<<6);if((f|0)==0&(e|0)==0)break;else g=b}}if(!((d|0)==0&0==0)){f=b;e=0;while(1){N=hb(d|0,e|0,0)|0;b=Xu(d|0,e|0,-1,-1)|0;d=b&d;e=C&e;b=f+8|0;c[f>>2]=(N|-1024)+(N<<6);if((d|0)==0&(e|0)==0)break;else f=b}}a:do if((V>>>0>16777215|(V|0)==16777215&W>>>0>4294967295)&(0!=0|(j|0)!=0)){e=Zu(0,j|0,9)|0;e=e&n;d=C&o;Zu(0,j|0,7)|0;i=o&2130706432&C;j=Zu(0,j|0,8)|0;j=j&k;h=C&l;b:do if((c[X>>2]|0)==1){M=b;F=e;J=d;S=36}else{while(1){if((e|0)==0&(d|0)==0){d=0;e=i;break}f=Xu(e|0,d|0,-1,-1)|0;f=f&e;g=C&d;N=hb(e|0,d|0,0)|0;N=N+7616+(N<<6)|0;c[b>>2]=N+20480;c[b+8>>2]=N|16384;c[b+16>>2]=N+12288;d=b+32|0;c[b+24>>2]=N+8192;if((c[X>>2]|0)==1){M=d;F=f;J=g;S=36;break b}else{b=d;e=f;d=g}}while(1){if((d|0)==0&(e|0)==0){d=j;e=h;break}f=Xu(d|0,e|0,-1,-1)|0;f=f&d;g=C&e;N=hb(d|0,e|0,0)|0;N=N+7744+(N<<6)|0;c[b>>2]=N+20480;c[b+8>>2]=N|16384;c[b+16>>2]=N+12288;d=b+32|0;c[b+24>>2]=N+8192;if((c[X>>2]|0)==1){O=d;G=f;K=g;S=41;break b}else{b=d;d=f;e=g}}while(1){if((d|0)==0&(e|0)==0)break a;f=Xu(d|0,e|0,-1,-1)|0;f=f&d;g=C&e;N=hb(d|0,e|0,0)|0;N=(N|7680)+(N<<6)|0;c[b>>2]=N+20480;c[b+8>>2]=N|16384;c[b+16>>2]=N+12288;d=b+32|0;c[b+24>>2]=N+8192;if((c[X>>2]|0)==1){D=d;A=f;B=g;break}else{b=d;d=f;e=g}}}while(0);if((S|0)==36)if((F|0)==0&(J|0)==0){O=M;G=0;K=i;S=41}else{d=F;b=J;do{S=Xu(d|0,b|0,-1,-1)|0;d=S&d;b=C&b}while(!((d|0)==0&(b|0)==0));O=M;G=0;K=i;S=41}if((S|0)==41)if((G|0)==0&(K|0)==0){D=O;A=j;B=h}else{d=G;b=K;do{S=Xu(d|0,b|0,-1,-1)|0;d=S&d;b=C&b}while(!((d|0)==0&(b|0)==0));D=O;A=j;B=h}if((A|0)==0&(B|0)==0)b=D;else{d=A;b=B;do{S=Xu(d|0,b|0,-1,-1)|0;d=S&d;b=C&b}while(!((d|0)==0&(b|0)==0));b=D}}while(0);g=Zu(p|0,m|0,9)|0;g=g&-16843264&n;f=C&16711422&o;e=Zu(p|0,m|0,7)|0;e=e&2139062016&n;d=C&8355711&o;if(!((g|0)==0&(f|0)==0)){h=b;while(1){S=hb(g|0,f|0,0)|0;b=Xu(g|0,f|0,-1,-1)|0;g=b&g;f=C&f;b=h+8|0;c[h>>2]=S+-576+(S<<6);if((g|0)==0&(f|0)==0)break;else h=b}}if(!((e|0)==0&(d|0)==0)){f=b;while(1){S=hb(e|0,d|0,0)|0;b=Xu(e|0,d|0,-1,-1)|0;e=b&e;d=C&d;b=f+8|0;c[f>>2]=S+-448+(S<<6);if((e|0)==0&(d|0)==0)break;else f=b}}k=c[R+48>>2]|0;l=(k|0)==64;if((!l?(S=26112+(k+-8<<3)|0,!((c[S>>2]&W|0)==0?(c[S+4>>2]&V|0)==0:0)):0)?(Q=31552+(k<<3)|0,P=c[Q>>2]&p,Q=c[Q+4>>2]&q,!((P|0)==0&(Q|0)==0)):0){g=k+8192|0;f=P;e=Q;while(1){d=b+8|0;S=hb(f|0,e|0,0)|0;R=Xu(f|0,e|0,-1,-1)|0;f=R&f;e=C&e;c[b>>2]=g+(S<<6|24576);if((f|0)==0&(e|0)==0){b=d;break}else b=d}}do if((c[X>>2]|0)==3){f=T^W;e=U^V;i=(T|0)!=(W|0)|(U|0)!=(V|0);if(i&(c[a+4504>>2]|0)!=0){g=f;h=e;while(1){d=b+8|0;U=hb(g|0,h|0,0)|0;T=Xu(g|0,h|0,-1,-1)|0;g=T&g;h=C&h;c[b>>2]=U|655360;if((g|0)==0&(h|0)==0){b=d;break}else b=d}}if(i&(c[a+4508>>2]|0)!=0){g=f;h=e;while(1){d=b+8|0;U=hb(g|0,h|0,0)|0;T=Xu(g|0,h|0,-1,-1)|0;g=T&g;h=C&h;c[b>>2]=U|917504;if((g|0)==0&(h|0)==0){b=d;break}else b=d}}if(i&(c[a+4512>>2]|0)!=0){g=f;h=e;while(1){d=b+8|0;U=hb(g|0,h|0,0)|0;T=Xu(g|0,h|0,-1,-1)|0;g=T&g;h=C&h;c[b>>2]=U|1179648;if((g|0)==0&(h|0)==0){b=d;break}else b=d}}if(!(i&(c[a+4516>>2]|0)!=0))break;while(1){d=b+8|0;U=hb(f|0,e|0,0)|0;T=Xu(f|0,e|0,-1,-1)|0;f=T&f;e=C&e;c[b>>2]=U|1441792;if((f|0)==0&(e|0)==0){b=d;break}else b=d}}while(0);e=a+912|0;d=c[e>>2]|0;if((d|0)!=64)do{f=27968+(d<<3)|0;g=c[f>>2]&W;f=c[f+4>>2]&V;if(!((g|0)==0&(f|0)==0)){h=d<<6;while(1){d=b+8|0;U=hb(g|0,f|0,0)|0;T=Xu(g|0,f|0,-1,-1)|0;g=T&g;f=C&f;c[b>>2]=U+h;if((g|0)==0&(f|0)==0){b=d;break}else b=d}}e=e+4|0;d=c[e>>2]|0}while((d|0)!=64);e=a+1168|0;d=c[e>>2]|0;if((d|0)!=64){j=t;i=c[j>>2]|0;j=c[j+4>>2]|0;do{g=25088+(d<<3)|0;f=25600+(d<<3)|0;f=(_(c[g+4>>2]&j,c[f+4>>2]|0)|0)^(_(c[g>>2]&i,c[f>>2]|0)|0);f=(c[1031516+(d<<2)>>2]|0)+(f>>>(c[1031772+(d<<2)>>2]|0)<<3)|0;g=c[f>>2]&W;f=c[f+4>>2]&V;if(!((g|0)==0&(f|0)==0)){h=d<<6;while(1){d=b+8|0;U=hb(g|0,f|0,0)|0;T=Xu(g|0,f|0,-1,-1)|0;g=T&g;f=C&f;c[b>>2]=U+h;if((g|0)==0&(f|0)==0){b=d;break}else b=d}}e=e+4|0;d=c[e>>2]|0}while((d|0)!=64)}e=a+1424|0;d=c[e>>2]|0;if((d|0)!=64){j=t;i=c[j>>2]|0;j=c[j+4>>2]|0;do{g=24064+(d<<3)|0;f=24576+(d<<3)|0;f=(_(c[g+4>>2]&j,c[f+4>>2]|0)|0)^(_(c[g>>2]&i,c[f>>2]|0)|0);f=(c[1031004+(d<<2)>>2]|0)+(f>>>(c[1031260+(d<<2)>>2]|0)<<3)|0;g=c[f>>2]&W;f=c[f+4>>2]&V;if(!((g|0)==0&(f|0)==0)){h=d<<6;while(1){d=b+8|0;U=hb(g|0,f|0,0)|0;T=Xu(g|0,f|0,-1,-1)|0;g=T&g;f=C&f;c[b>>2]=U+h;if((g|0)==0&(f|0)==0){b=d;break}else b=d}}e=e+4|0;d=c[e>>2]|0}while((d|0)!=64)}e=a+1680|0;d=c[e>>2]|0;if((d|0)!=64){j=t;i=c[j>>2]|0;j=c[j+4>>2]|0;do{g=24064+(d<<3)|0;f=24576+(d<<3)|0;f=(_(c[g+4>>2]&j,c[f+4>>2]|0)|0)^(_(c[g>>2]&i,c[f>>2]|0)|0);f=(c[1031004+(d<<2)>>2]|0)+(f>>>(c[1031260+(d<<2)>>2]|0)<<3)|0;g=25088+(d<<3)|0;U=25600+(d<<3)|0;U=(_(c[g+4>>2]&j,c[U+4>>2]|0)|0)^(_(c[g>>2]&i,c[U>>2]|0)|0);U=(c[1031516+(d<<2)>>2]|0)+(U>>>(c[1031772+(d<<2)>>2]|0)<<3)|0;g=(c[U>>2]|c[f>>2])&W;f=(c[U+4>>2]|c[f+4>>2])&V;if(!((g|0)==0&(f|0)==0)){h=d<<6;while(1){d=b+8|0;U=hb(g|0,f|0,0)|0;T=Xu(g|0,f|0,-1,-1)|0;g=T&g;f=C&f;c[b>>2]=U+h;if((g|0)==0&(f|0)==0){b=d;break}else b=d}}e=e+4|0;d=c[e>>2]|0}while((d|0)!=64)}if((c[X>>2]|0)!=1){a=b;return a|0}e=a+304|0;d=c[e>>2]&r;e=c[e+4>>2]&s;if(!((d|0)==0&(e|0)==0))do{f=hb(d|0,e|0,0)|0;g=Xu(d|0,e|0,-1,-1)|0;d=g&d;e=C&e;g=30016+(f<<3)|0;h=c[g>>2]&W;g=c[g+4>>2]&V;if(!((h|0)==0&(g|0)==0)){i=f<<6;while(1){f=b+8|0;X=hb(h|0,g|0,0)|0;U=Xu(h|0,g|0,-1,-1)|0;h=U&h;g=C&g;c[b>>2]=X+i;if((h|0)==0&(g|0)==0){b=f;break}else b=f}}}while(!((d|0)==0&(e|0)==0));do if(l){d=c[Y>>2]|0;f=a+320+(d<<3)|0;e=c[f>>2]|0;f=c[f+4>>2]|0}else{X=t;X=Jf(a,k,c[X>>2]|0,c[X+4>>2]|0)|0;d=c[Y>>2]|0;f=a+320+(d<<3)|0;e=c[f>>2]|0;f=c[f+4>>2]|0;if((e&X&c[Z>>2]|0)==0?(f&C&c[Z+4>>2]|0)==0:0)break;return b|0}while(0);i=a+320+((d^1)<<3)|0;h=t;g=c[h>>2]|0;h=c[h+4>>2]|0;while(1){if((e|0)==0&(f|0)==0){S=175;break}Y=hb(e|0,f|0,0)|0;d=Xu(e|0,f|0,-1,-1)|0;f=C&f;Y=ac(c[a+(Y<<2)>>2]|0,Y,g,h)|0;Z=i;if(!((c[Z>>2]&Y|0)==0?(c[Z+4>>2]&C|0)==0:0)){S=175;break}else e=d&e}if((S|0)==175)return b|0}else{y=a+328|0;x=c[y>>2]|0;y=c[y+4>>2]|0;v=Z;s=c[v>>2]&x;v=c[v+4>>2]&y;o=s&65280;w=s&-65281;u=a+320|0;t=c[u>>2]&W;u=c[u+4>>2]&V;A=a+256|0;i=A;P=~c[i>>2];i=~c[i+4>>2];Q=(r|0)==1;p=W&P;q=V&i;l=Yu(w|0,v|0,8)|0;j=C;Yu((Q?p:P)&l|0,(Q?q:i)&j|0,8)|0;i=C;Q=(r|0)==4;l=l&p;j=j&q;i=(Q?65535:255)&q&i;if((r|0)==3?(n=p&-256,m=q&16777215,((n|0)!=0|(m|0)!=0)&(c[a+4532>>2]|0)!=0):0)while(1){k=b+8|0;Q=hb(n|0,m|0,0)|0;P=Xu(n|0,m|0,-1,-1)|0;n=P&n;m=C&m;c[b>>2]=Q|2490368;if((n|0)==0&(m|0)==0){b=k;break}else b=k}if(!((l|0)==0&(j|0)==0))while(1){Q=hb(l|0,j|0,0)|0;k=Xu(l|0,j|0,-1,-1)|0;l=k&l;j=C&j;k=b+8|0;c[b>>2]=(Q|512)+(Q<<6);if((l|0)==0&(j|0)==0){b=k;break}else b=k}if(!(0==0&(i|0)==0)){k=0;while(1){Q=hb(k|0,i|0,0)|0;j=Xu(k|0,i|0,-1,-1)|0;k=j&k;i=C&i;j=b+8|0;c[b>>2]=(Q|1024)+(Q<<6);if((k|0)==0&(i|0)==0){b=j;break}else b=j}}c:do if(!((W&255|0)==0&0==0|(o|0)==0&0==0)){j=Yu(o|0,0,9)|0;j=j&t;i=C&u;n=Yu(o|0,0,7)|0;n=t&254&n;o=Yu(o|0,0,8)|0;o=o&p;m=C&q;d:do if((c[X>>2]|0)==1){L=b;g=j;H=i;S=110}else{while(1){if((j|0)==0&(i|0)==0){i=n;j=0;break}k=Xu(j|0,i|0,-1,-1)|0;k=k&j;l=C&i;Q=hb(j|0,i|0,0)|0;Q=Q+8768+(Q<<6)|0;c[b>>2]=Q+20480;c[b+8>>2]=Q+16384;c[b+16>>2]=Q+12288;i=b+32|0;c[b+24>>2]=Q+8192;if((c[X>>2]|0)==1){L=i;g=k;H=l;S=110;break d}else{b=i;j=k;i=l}}while(1){if((i|0)==0&(j|0)==0){h=o;i=m;break}k=Xu(i|0,j|0,-1,-1)|0;k=k&i;l=C&j;Q=hb(i|0,j|0,0)|0;Q=Q+8640+(Q<<6)|0;c[b>>2]=Q+20480;c[b+8>>2]=Q+16384;c[b+16>>2]=Q+12288;i=b+32|0;c[b+24>>2]=Q+8192;if((c[X>>2]|0)==1){N=i;E=k;I=l;S=115;break d}else{b=i;i=k;j=l}}while(1){if((h|0)==0&(i|0)==0)break c;d=Xu(h|0,i|0,-1,-1)|0;d=d&h;j=C&i;Q=hb(h|0,i|0,0)|0;Q=(Q|8704)+(Q<<6)|0;c[b>>2]=Q+20480;c[b+8>>2]=Q+16384;c[b+16>>2]=Q+12288;h=b+32|0;c[b+24>>2]=Q+8192;if((c[X>>2]|0)==1){z=j;break}else{b=h;h=d;i=j}}}while(0);if((S|0)==110)if((g|0)==0&(H|0)==0){N=L;E=n;I=0;S=115}else{b=H;do{S=Xu(g|0,b|0,-1,-1)|0;g=S&g;b=C&b}while(!((g|0)==0&(b|0)==0));N=L;E=n;I=0;S=115}if((S|0)==115)if((E|0)==0&(I|0)==0){h=N;d=o;z=m}else{d=E;b=I;do{S=Xu(d|0,b|0,-1,-1)|0;d=S&d;b=C&b}while(!((d|0)==0&(b|0)==0));h=N;d=o;z=m}if((d|0)==0&(z|0)==0)b=h;else{b=z;do{S=Xu(d|0,b|0,-1,-1)|0;d=S&d;b=C&b}while(!((d|0)==0&(b|0)==0));b=h}}while(0);j=Yu(s|0,v|0,9)|0;j=j&2139062016&t;g=C&8355711&u;h=Yu(s|0,v|0,7)|0;h=h&-16843264&t;d=C&16711422&u;if(!((j|0)==0&(g|0)==0))while(1){S=hb(j|0,g|0,0)|0;i=Xu(j|0,g|0,-1,-1)|0;j=i&j;g=C&g;i=b+8|0;c[b>>2]=S+576+(S<<6);if((j|0)==0&(g|0)==0){b=i;break}else b=i}if(!((h|0)==0&(d|0)==0))while(1){S=hb(h|0,d|0,0)|0;g=Xu(h|0,d|0,-1,-1)|0;h=g&h;d=C&d;g=b+8|0;c[b>>2]=S+448+(S<<6);if((h|0)==0&(d|0)==0){b=g;break}else b=g}l=c[R+48>>2]|0;m=(l|0)==64;if((!m?(S=26112+(l+8<<3)|0,!((c[S>>2]&W|0)==0?(c[S+4>>2]&V|0)==0:0)):0)?(e=27456+(l<<3)|0,f=c[e>>2]&w,e=c[e+4>>2]&v,!((f|0)==0&(e|0)==0)):0){g=l+8192|0;while(1){d=b+8|0;S=hb(f|0,e|0,0)|0;R=Xu(f|0,e|0,-1,-1)|0;f=R&f;e=C&e;c[b>>2]=g+(S<<6|24576);if((f|0)==0&(e|0)==0){b=d;break}else b=d}}do if((c[X>>2]|0)==3){f=T^W;e=U^V;i=(T|0)!=(W|0)|(U|0)!=(V|0);if(i&(c[a+4536>>2]|0)!=0){d=b;g=f;h=e;while(1){b=d+8|0;U=hb(g|0,h|0,0)|0;T=Xu(g|0,h|0,-1,-1)|0;g=T&g;h=C&h;c[d>>2]=U|2752512;if((g|0)==0&(h|0)==0)break;else d=b}}if(i&(c[a+4540>>2]|0)!=0){g=f;h=e;while(1){d=b+8|0;U=hb(g|0,h|0,0)|0;T=Xu(g|0,h|0,-1,-1)|0;g=T&g;h=C&h;c[b>>2]=U|3014656;if((g|0)==0&(h|0)==0){b=d;break}else b=d}}if(i&(c[a+4544>>2]|0)!=0){g=f;h=e;while(1){d=b+8|0;U=hb(g|0,h|0,0)|0;T=Xu(g|0,h|0,-1,-1)|0;g=T&g;h=C&h;c[b>>2]=U|3276800;if((g|0)==0&(h|0)==0){b=d;break}else b=d}}if(!(i&(c[a+4548>>2]|0)!=0))break;while(1){d=b+8|0;U=hb(f|0,e|0,0)|0;T=Xu(f|0,e|0,-1,-1)|0;f=T&f;e=C&e;c[b>>2]=U|3538944;if((f|0)==0&(e|0)==0){b=d;break}else b=d}}while(0);e=a+2960|0;d=c[e>>2]|0;if((d|0)!=64)do{h=27968+(d<<3)|0;f=c[h>>2]&W;h=c[h+4>>2]&V;if(!((f|0)==0&(h|0)==0)){i=d<<6;g=b;d=h;while(1){b=g+8|0;U=hb(f|0,d|0,0)|0;T=Xu(f|0,d|0,-1,-1)|0;f=T&f;d=C&d;c[g>>2]=U+i;if((f|0)==0&(d|0)==0)break;else g=b}}e=e+4|0;d=c[e>>2]|0}while((d|0)!=64);e=a+3216|0;d=c[e>>2]|0;if((d|0)!=64){k=A;j=c[k>>2]|0;k=c[k+4>>2]|0;do{f=25088+(d<<3)|0;h=25600+(d<<3)|0;h=(_(c[f+4>>2]&k,c[h+4>>2]|0)|0)^(_(c[f>>2]&j,c[h>>2]|0)|0);h=(c[1031516+(d<<2)>>2]|0)+(h>>>(c[1031772+(d<<2)>>2]|0)<<3)|0;f=c[h>>2]&W;h=c[h+4>>2]&V;if(!((f|0)==0&(h|0)==0)){i=d<<6;g=b;d=h;while(1){b=g+8|0;U=hb(f|0,d|0,0)|0;T=Xu(f|0,d|0,-1,-1)|0;f=T&f;d=C&d;c[g>>2]=U+i;if((f|0)==0&(d|0)==0)break;else g=b}}e=e+4|0;d=c[e>>2]|0}while((d|0)!=64)}e=a+3472|0;d=c[e>>2]|0;if((d|0)!=64){k=A;j=c[k>>2]|0;k=c[k+4>>2]|0;do{f=24064+(d<<3)|0;h=24576+(d<<3)|0;h=(_(c[f+4>>2]&k,c[h+4>>2]|0)|0)^(_(c[f>>2]&j,c[h>>2]|0)|0);h=(c[1031004+(d<<2)>>2]|0)+(h>>>(c[1031260+(d<<2)>>2]|0)<<3)|0;f=c[h>>2]&W;h=c[h+4>>2]&V;if(!((f|0)==0&(h|0)==0)){i=d<<6;g=b;d=h;while(1){b=g+8|0;U=hb(f|0,d|0,0)|0;T=Xu(f|0,d|0,-1,-1)|0;f=T&f;d=C&d;c[g>>2]=U+i;if((f|0)==0&(d|0)==0)break;else g=b}}e=e+4|0;d=c[e>>2]|0}while((d|0)!=64)}e=a+3728|0;d=c[e>>2]|0;if((d|0)!=64){k=A;j=c[k>>2]|0;k=c[k+4>>2]|0;do{f=24064+(d<<3)|0;h=24576+(d<<3)|0;h=(_(c[f+4>>2]&k,c[h+4>>2]|0)|0)^(_(c[f>>2]&j,c[h>>2]|0)|0);h=(c[1031004+(d<<2)>>2]|0)+(h>>>(c[1031260+(d<<2)>>2]|0)<<3)|0;f=25088+(d<<3)|0;U=25600+(d<<3)|0;U=(_(c[f+4>>2]&k,c[U+4>>2]|0)|0)^(_(c[f>>2]&j,c[U>>2]|0)|0);U=(c[1031516+(d<<2)>>2]|0)+(U>>>(c[1031772+(d<<2)>>2]|0)<<3)|0;f=(c[U>>2]|c[h>>2])&W;h=(c[U+4>>2]|c[h+4>>2])&V;if(!((f|0)==0&(h|0)==0)){i=d<<6;g=b;d=h;while(1){b=g+8|0;U=hb(f|0,d|0,0)|0;T=Xu(f|0,d|0,-1,-1)|0;f=T&f;d=C&d;c[g>>2]=U+i;if((f|0)==0&(d|0)==0)break;else g=b}}e=e+4|0;d=c[e>>2]|0}while((d|0)!=64)}if((c[X>>2]|0)!=1){a=b;return a|0}e=a+304|0;d=c[e>>2]&x;e=c[e+4>>2]&y;if(!((d|0)==0&(e|0)==0))do{f=hb(d|0,e|0,0)|0;i=Xu(d|0,e|0,-1,-1)|0;d=i&d;e=C&e;i=30016+(f<<3)|0;g=c[i>>2]&W;i=c[i+4>>2]&V;if(!((g|0)==0&(i|0)==0)){j=f<<6;h=b;f=i;while(1){b=h+8|0;X=hb(g|0,f|0,0)|0;U=Xu(g|0,f|0,-1,-1)|0;g=U&g;f=C&f;c[h>>2]=X+j;if((g|0)==0&(f|0)==0)break;else h=b}}}while(!((d|0)==0&(e|0)==0));do if(m){d=c[Y>>2]|0;f=a+320+(d<<3)|0;e=c[f>>2]|0;f=c[f+4>>2]|0}else{X=A;X=Jf(a,l,c[X>>2]|0,c[X+4>>2]|0)|0;d=c[Y>>2]|0;f=a+320+(d<<3)|0;e=c[f>>2]|0;f=c[f+4>>2]|0;if((e&X&c[Z>>2]|0)==0?(f&C&c[Z+4>>2]|0)==0:0)break;return b|0}while(0);i=a+320+((d^1)<<3)|0;h=A;g=c[h>>2]|0;h=c[h+4>>2]|0;d=f;while(1){if((e|0)==0&(d|0)==0){S=175;break}Y=hb(e|0,d|0,0)|0;f=Xu(e|0,d|0,-1,-1)|0;d=C&d;Y=ac(c[a+(Y<<2)>>2]|0,Y,g,h)|0;Z=i;if(!((c[Z>>2]&Y|0)==0?(c[Z+4>>2]&C|0)==0:0)){S=175;break}else e=f&e}if((S|0)==175)return b|0}return 0}function df(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;v=a+5364|0;d=c[v>>2]|0;a:do switch(d|0){case 2:{d=c[a+5348>>2]<<3;if(!(c[a+336+((d^14)<<2)>>2]|0)){a=b;return a|0}if(!(c[a+336+((d|6)<<2)>>2]|0)){a=b;return a|0}else{k=c[a+5348>>2]|0;o=c[a+5356>>2]|0;l=o+344+(k<<3)|0;f=a+320+(k<<3)|0;l=c[f>>2]&c[l>>2]|0?1:(c[f+4>>2]&c[l+4>>2]|0)!=0;f=27;break a}}case 4:if(!(c[a+336+(((c[a+360>>2]|0)!=0&1)<<3<<2)>>2]|0)){a=b;return a|0}else{m=c[a+5348>>2]|0;r=c[a+5356>>2]|0;q=r+344+(m<<3)|0;f=a+320+(m<<3)|0;q=c[f>>2]&c[q>>2]|0?1:(c[f+4>>2]&c[q+4>>2]|0)!=0;f=26;break a}case 5:{e=c[a+5348>>2]|0;f=c[a+400+((e<<3|6)<<8)>>2]|0;if(((f>>3)+-3|0)>>>0<2?((f&7)+-3|0)>>>0<2:0){a=b;return a|0}f=c[a+400+((e<<3^14)<<8)>>2]|0;if(((f>>3)+-3|0)>>>0<2?((f&7)+-3|0)>>>0<2:0){a=b;return a|0}if((d|0)==6)f=12;else{g=d;f=17}break}case 6:{f=12;break}default:{g=d;f=17}}while(0);do if((f|0)==12){e=c[a+5348>>2]|0;d=e<<3;if((c[a+400+((d|6)<<8)>>2]&-8|0)==56){if((c[a+400+((d^14)<<8)>>2]&-8|0)==56){a=b;return a|0}if((c[a+400+((e<<3^14)<<8)>>2]>>3|0)<7){a=b;return a|0}}if(Ad(a)|0){a=b;return a|0}else{g=c[v>>2]|0;f=17;break}}while(0);b:do if((f|0)==17){c:do switch(g|0){case 7:{d=c[a+5348>>2]|0;e=c[a+5356>>2]|0;if((c[e+36+(d<<2)>>2]|0)==3){a=b;return a|0}if((c[e+36+((d^1)<<2)>>2]|0)==3){a=b;return a|0}else{e=c[a+5348>>2]|0;f=c[a+5356>>2]|0;d=f+344+(e<<3)|0;j=a+320+(e<<3)|0;d=c[j>>2]&c[d>>2]|0?1:(c[j+4>>2]&c[d+4>>2]|0)!=0;break c}}case 1:{d=c[a+5348>>2]|0;e=d<<3;if(!(c[a+336+(e<<2)>>2]|0)){a=b;return a|0}if(!(c[a+336+((e^8)<<2)>>2]|0)){a=b;return a|0}else{n=c[a+5356>>2]|0;p=n+344+(d<<3)|0;g=a+320+(d<<3)|0;s=64;p=c[g>>2]&c[p>>2]|0?1:(c[g+4>>2]&c[p+4>>2]|0)!=0;break b}}default:{e=c[a+5348>>2]|0;f=c[a+5356>>2]|0;d=f+344+(e<<3)|0;w=a+320+(e<<3)|0;d=(g|0)==6|(c[w>>2]&c[d>>2]|0?1:(c[w+4>>2]&c[d+4>>2]|0)!=0);switch(g|0){case 4:{q=d;m=e;r=f;f=26;break b}case 2:{l=d;k=e;o=f;f=27;break b}default:{}}}}while(0);j=d;i=e<<3|6;h=f;f=28}while(0);if((f|0)==26){d=m<<3|6;if(!(c[a+336+(d<<2)>>2]|0)){s=64;p=q;n=r}else{j=q;i=d;h=r;f=28}}else if((f|0)==27){d=k<<3|6;if(!(c[a+336+(d<<2)>>2]|0)){s=64;p=l;n=o}else{j=l;i=d;h=o;f=28}}if((f|0)==28){s=c[a+400+(i<<8)>>2]|0;p=j;n=h}w=n+64|0;if((c[w>>2]|0)==0&(c[w+4>>2]|0)==0)d=Ze(a,b)|0;else d=cf(a,b)|0;if((d|0)==(b|0)){w=b;return w|0}if(p){d:while(1){while(1){e=c[b>>2]|0;if((e&131072|0)==0?!(Kf(a,e)|0):0){e=b;break}if(((c[v>>2]|0)==2?(t=c[b>>2]|0,w=t&180224,(w|0)==32768|((w|0)!=49152?(c[a+((t&63)<<2)>>2]|0)!=0:0)):0)?!(Kf(a,t)|0):0){e=b;break}b=b+8|0;if((b|0)==(d|0)){f=50;break d}}c[e>>2]=c[d+-8>>2];d=d+-8|0;if((b|0)==(d|0)){d=b;f=50;break}}if((f|0)==50)return d|0}else{e:while(1){while(1){e=c[b>>2]|0;w=(e&131072|0)==0;if(!(((e&180224|0)!=32768?((w?e>>>6&63:64)|0)!=(s|0):0)|w^1)?!(Kf(a,e)|0):0){e=b;break}if(((c[v>>2]|0)==2?(u=c[b>>2]|0,w=u&180224,(w|0)==32768|((w|0)!=49152?(c[a+((u&63)<<2)>>2]|0)!=0:0)):0)?!(Kf(a,u)|0):0){e=b;break}b=b+8|0;if((b|0)==(d|0)){f=50;break e}}c[e>>2]=c[d+-8>>2];d=d+-8|0;if((b|0)==(d|0)){d=b;f=50;break}}if((f|0)==50)return d|0}return 0}function ef(){var a=0,b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0;a=i;i=i+96|0;b=a;rk(b,17165,5);d=b+12|0;rk(d,17171,8);e=b+24|0;rk(e,17180,6);f=b+36|0;rk(f,17187,10);g=b+48|0;rk(g,17198,5);h=b+60|0;rk(h,17204,13);j=b+72|0;rk(j,17218,11);k=b+84|0;rk(k,17230,10);l=Nu(96)|0;c[258705]=l;c[258704]=l;c[258706]=l+96;qk(l,b);l=(c[258705]|0)+12|0;c[258705]=l;qk(l,d);l=(c[258705]|0)+12|0;c[258705]=l;qk(l,e);l=(c[258705]|0)+12|0;c[258705]=l;qk(l,f);l=(c[258705]|0)+12|0;c[258705]=l;qk(l,g);l=(c[258705]|0)+12|0;c[258705]=l;qk(l,h);l=(c[258705]|0)+12|0;c[258705]=l;qk(l,j);l=(c[258705]|0)+12|0;c[258705]=l;qk(l,k);c[258705]=(c[258705]|0)+12;vk(k);vk(j);vk(h);vk(g);vk(f);vk(e);vk(d);vk(b);i=a;return}function ff(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;c[a>>2]=b;c[a+4>>2]=f;c[a+12>>2]=e;e=c[f+-28>>2]&63;c[a+8>>2]=c[(c[b+5352>>2]|0)+9652+(c[b+(e<<2)>>2]<<8)+(e<<2)>>2];e=(c[b+5356>>2]|0)+64|0;e=(c[e>>2]|0)!=0|(c[e+4>>2]|0)!=0?8:0;f=a+28|0;c[f>>2]=e;if(!d){d=0;b=e;a=a+16|0;c[a>>2]=d;d=(d|0)==0;d=d&1;d=b+d|0;c[f>>2]=d;return}b=Mf(b,d)|0;d=b?d:0;b=c[f>>2]|0;a=a+16|0;c[a>>2]=d;d=(d|0)==0;d=d&1;d=b+d|0;c[f>>2]=d;return}function gf(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0;c[a>>2]=b;g=(c[b+5356>>2]|0)+64|0;do if((c[g>>2]|0)==0&(c[g+4>>2]|0)==0){if((e|0)>-1){c[a+28>>2]=14;g=14;break}g=a+28|0;if((e|0)>-5){c[g>>2]=18;g=18;break}c[g>>2]=21;c[a+20>>2]=f;return}else{c[a+28>>2]=8;g=8}while(0);if(!d){f=a+28|0;e=0}else{e=Mf(b,d)|0;g=a+28|0;f=g;e=e?d:0;g=c[g>>2]|0}c[a+16>>2]=e;c[f>>2]=g+((e|0)==0&1);return}function hf(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;c[a>>2]=b;f=a+24|0;c[f>>2]=e;g=a+28|0;c[g>>2]=11;if(((d|0)!=0?Mf(b,d)|0:0)?(h=c[a>>2]|0,b=d&180224,(b|0)==32768|((b|0)!=49152?(c[h+((d&63)<<2)>>2]|0)!=0:0)):0){e=Uf(h,d,c[f>>2]|0)|0;e=e?d:0}else e=0;c[a+16>>2]=e;c[g>>2]=(c[g>>2]|0)+((e|0)==0&1);return}function jf(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;k=c[a>>2]|0;n=c[k+5352>>2]|0;j=c[a+4>>2]|0;i=c[j+-36>>2]|0;p=c[j+-76>>2]|0;j=c[j+-156>>2]|0;k=c[k+5348>>2]|0;b=c[a+32>>2]|0;l=c[a+36>>2]|0;if((b|0)==(l|0))return;m=(p|0)==0;o=(j|0)==0;if(!i){do{f=c[b>>2]|0;g=f&63;h=(f&131072|0)==0;if(h)d=c[(c[a>>2]|0)+((f>>>6&63)<<2)>>2]|0;else d=f>>>18&15;e=c[n+5556+(d<<8)+(g<<2)>>2]|0;if(m)d=0;else{if(h)d=c[(c[a>>2]|0)+((f>>>6&63)<<2)>>2]|0;else d=f>>>18&15;d=c[p+(d<<8)+(g<<2)>>2]|0}e=e+d|0;if(o)d=0;else{if(h)d=c[(c[a>>2]|0)+((f>>>6&63)<<2)>>2]|0;else d=f>>>18&15;d=c[j+(d<<8)+(g<<2)>>2]|0}c[b+4>>2]=e+d+(c[n+13748+(k*16640|0)+((h?f>>>6&63:64)<<8)+(g<<2)>>2]|0);b=b+8|0}while((b|0)!=(l|0));return}else{do{f=c[b>>2]|0;g=f&63;h=(f&131072|0)==0;if(h){e=c[a>>2]|0;d=c[e+((f>>>6&63)<<2)>>2]|0;e=c[e+((f>>>6&63)<<2)>>2]|0}else{d=f>>>18&15;e=f>>>18&15}e=(c[i+(d<<8)+(g<<2)>>2]|0)+(c[n+5556+(e<<8)+(g<<2)>>2]|0)|0;if(m)d=0;else{if(h)d=c[(c[a>>2]|0)+((f>>>6&63)<<2)>>2]|0;else d=f>>>18&15;d=c[p+(d<<8)+(g<<2)>>2]|0}e=e+d|0;if(o)d=0;else{if(h)d=c[(c[a>>2]|0)+((f>>>6&63)<<2)>>2]|0;else d=f>>>18&15;d=c[j+(d<<8)+(g<<2)>>2]|0}c[b+4>>2]=e+d+(c[n+13748+(k*16640|0)+((h?f>>>6&63:64)<<8)+(g<<2)>>2]|0);b=b+8|0}while((b|0)!=(l|0));return}}function kf(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0;N=a+28|0;e=c[N>>2]|0;do switch(e|0){case 11:case 18:case 14:case 8:case 0:{c[N>>2]=e+1;a=c[a+16>>2]|0;return a|0}case 1:{q=a+44|0;o=a+32|0;c[o>>2]=q;c[a+40>>2]=q;q=Ne(c[a>>2]|0,q)|0;e=a+36|0;c[e>>2]=q;r=c[o>>2]|0;if((r|0)!=(q|0)){n=r;do{f=c[a>>2]|0;i=c[f+5364>>2]|0;do if((i|0)!=1){k=c[n>>2]&63;m=c[6728+(i<<7)+(c[f+(k<<2)>>2]<<2)>>2]|0;if((i|0)==6){c[n+4>>2]=(_(k>>>3^7,-200)|0)+m;break}else{c[n+4>>2]=(_((c[f+5348>>2]|0)*7^k>>>3,-200)|0)+m;break}}else{A=c[n>>2]&63;c[n+4>>2]=(_((c[f+5348>>2]|0)*7^A>>>3,-50)|0)+(c[6856+(c[f+(A<<2)>>2]<<2)>>2]|0)}while(0);n=n+8|0}while((n|0)!=(q|0))}y=(c[N>>2]|0)+1|0;c[N>>2]=y;A=e;m=19;break}case 2:{r=a+32|0;q=a+36|0;A=q;o=r;q=c[q>>2]|0;r=c[r>>2]|0;y=2;m=19;break}case 3:{b=a+4|0;m=32;break}case 4:{m=36;break}case 5:{m=42;break}case 6:{H=a+32|0;F=a+36|0;G=7;m=62;break}case 7:{J=a+32|0;I=J;J=c[J>>2]|0;break}case 9:{u=a+44|0;s=a+32|0;c[s>>2]=u;u=cf(c[a>>2]|0,u)|0;x=a+36|0;c[x>>2]=u;e=c[a>>2]|0;v=c[e+5352>>2]|0;w=c[e+5348>>2]|0;f=c[s>>2]|0;a:do if((f|0)!=(u|0))while(1){m=c[f>>2]|0;n=m&63;k=c[e+(n<<2)>>2]|0;i=m&180224;if((i|0)==32768|(k|0)!=0&(i|0)!=49152){if(!(m&131072))i=c[e+((m>>>6&63)<<2)>>2]|0;else i=m>>>18&15;c[f+4>>2]=(c[6728+(c[e+5364>>2]<<7)+(k<<2)>>2]|0)+268435456-(i&7)}else{k=(m&131072|0)==0;if(k){m=m>>>6&63;i=c[e+(m<<2)>>2]|0;e=m}else{i=m>>>18&15;e=m>>>6&63}c[f+4>>2]=(c[v+13748+(w*16640|0)+((k?e:64)<<8)+(n<<2)>>2]|0)+(c[v+5556+(i<<8)+(n<<2)>>2]|0)}f=f+8|0;if((f|0)==(u|0))break a;e=c[a>>2]|0}while(0);c[N>>2]=(c[N>>2]|0)+1;u=s;m=86;break}case 10:{u=a+32|0;x=a+36|0;m=86;break}case 12:{g=a+44|0;e=a+32|0;c[e>>2]=g;g=Ne(c[a>>2]|0,g)|0;p=a+36|0;c[p>>2]=g;h=c[e>>2]|0;if((h|0)!=(g|0)){n=h;do{f=c[a>>2]|0;i=c[f+5364>>2]|0;do if((i|0)!=1){k=c[n>>2]&63;m=c[6728+(i<<7)+(c[f+(k<<2)>>2]<<2)>>2]|0;if((i|0)==6){c[n+4>>2]=(_(k>>>3^7,-200)|0)+m;break}else{c[n+4>>2]=(_((c[f+5348>>2]|0)*7^k>>>3,-200)|0)+m;break}}else{B=c[n>>2]&63;c[n+4>>2]=(_((c[f+5348>>2]|0)*7^B>>>3,-50)|0)+(c[6856+(c[f+(B<<2)>>2]<<2)>>2]|0)}while(0);n=n+8|0}while((n|0)!=(g|0))}c[N>>2]=(c[N>>2]|0)+1;B=e;m=99;break}case 13:{h=a+32|0;g=a+36|0;B=h;p=g;g=c[g>>2]|0;h=c[h>>2]|0;m=99;break}case 19:case 15:{n=a+44|0;e=a+32|0;c[e>>2]=n;n=Ne(c[a>>2]|0,n)|0;c[a+36>>2]=n;e=c[e>>2]|0;if((e|0)!=(n|0))do{f=c[a>>2]|0;i=c[f+5364>>2]|0;do if((i|0)!=1){k=c[e>>2]&63;m=c[6728+(i<<7)+(c[f+(k<<2)>>2]<<2)>>2]|0;if((i|0)==6){c[e+4>>2]=(_(k>>>3^7,-200)|0)+m;break}else{c[e+4>>2]=(_((c[f+5348>>2]|0)*7^k>>>3,-200)|0)+m;break}}else{w=c[e>>2]&63;c[e+4>>2]=(_((c[f+5348>>2]|0)*7^w>>>3,-50)|0)+(c[6856+(c[f+(w<<2)>>2]<<2)>>2]|0)}while(0);e=e+8|0}while((e|0)!=(n|0));c[N>>2]=(c[N>>2]|0)+1;m=114;break}case 20:case 16:{m=114;break}case 17:{j=a+32|0;l=a+16|0;D=c[a+36>>2]|0;m=121;break}case 21:{s=a+44|0;n=a+32|0;c[n>>2]=s;s=Ne(c[a>>2]|0,s)|0;t=a+36|0;c[t>>2]=s;e=c[n>>2]|0;if((e|0)!=(s|0))do{f=c[a>>2]|0;i=c[f+5364>>2]|0;do if((i|0)!=1){k=c[e>>2]&63;m=c[6728+(i<<7)+(c[f+(k<<2)>>2]<<2)>>2]|0;if((i|0)==6){c[e+4>>2]=(_(k>>>3^7,-200)|0)+m;break}else{c[e+4>>2]=(_((c[f+5348>>2]|0)*7^k>>>3,-200)|0)+m;break}}else{z=c[e>>2]&63;c[e+4>>2]=(_((c[f+5348>>2]|0)*7^z>>>3,-50)|0)+(c[6856+(c[f+(z<<2)>>2]<<2)>>2]|0)}while(0);e=e+8|0}while((e|0)!=(s|0));c[N>>2]=(c[N>>2]|0)+1;z=n;m=132;break}case 22:{z=a+32|0;t=a+36|0;m=132;break}default:{a=0;return a|0}}while(0);do if((m|0)==19){do if(r>>>0<q>>>0){i=a+16|0;k=a+40|0;h=r;g=q;while(1){e=h+8|0;c[o>>2]=e;if((h|0)==(g|0)|(e|0)==(g|0))b=h;else{b=h;f=h;while(1){b=(c[b+4>>2]|0)<(c[f+12>>2]|0)?e:b;f=e+8|0;if((f|0)==(g|0))break;else{B=e;e=f;f=B}}}B=h;z=c[B>>2]|0;B=c[B+4>>2]|0;w=b;x=c[w+4>>2]|0;y=h;c[y>>2]=c[w>>2];c[y+4>>2]=x;c[b>>2]=z;c[b+4>>2]=B;b=c[h>>2]|0;if((b|0)!=(c[i>>2]|0)){if(Uf(c[a>>2]|0,b,0)|0){d=b;m=138;break}B=c[k>>2]|0;c[k>>2]=B+8;c[B>>2]=b}h=c[o>>2]|0;g=c[A>>2]|0;if(h>>>0>=g>>>0){m=27;break}}if((m|0)==27){C=c[N>>2]|0;break}else if((m|0)==138)return d|0}else C=y;while(0);c[N>>2]=C+1;b=a+4|0;d=c[(c[b>>2]|0)+20>>2]|0;if((((d|0)!=0?(d|0)!=(c[a+16>>2]|0):0)?Mf(c[a>>2]|0,d)|0:0)?(C=d&180224,!((C|0)==32768|((C|0)!=49152?(c[(c[a>>2]|0)+((d&63)<<2)>>2]|0)!=0:0))):0){a=d;return a|0}else m=32}else if((m|0)==86){i=a+16|0;while(1){h=c[u>>2]|0;g=c[x>>2]|0;if(h>>>0>=g>>>0){d=0;m=138;break}e=h+8|0;c[u>>2]=e;if((h|0)==(g|0)|(e|0)==(g|0))d=h;else{d=h;f=h;while(1){d=(c[d+4>>2]|0)<(c[f+12>>2]|0)?e:d;f=e+8|0;if((f|0)==(g|0))break;else{C=e;e=f;f=C}}}C=h;B=c[C>>2]|0;C=c[C+4>>2]|0;y=d;z=c[y+4>>2]|0;A=h;c[A>>2]=c[y>>2];c[A+4>>2]=z;c[d>>2]=B;c[d+4>>2]=C;d=c[h>>2]|0;if((d|0)!=(c[i>>2]|0)){m=138;break}}if((m|0)==138)return d|0}else if((m|0)==99){if(h>>>0>=g>>>0){a=0;return a|0}i=a+16|0;k=a+24|0;while(1){e=h+8|0;c[B>>2]=e;if((h|0)==(g|0)|(e|0)==(g|0))d=h;else{d=h;f=h;while(1){d=(c[d+4>>2]|0)<(c[f+12>>2]|0)?e:d;f=e+8|0;if((f|0)==(g|0))break;else{C=e;e=f;f=C}}}C=h;A=c[C>>2]|0;C=c[C+4>>2]|0;x=d;y=c[x+4>>2]|0;z=h;c[z>>2]=c[x>>2];c[z+4>>2]=y;c[d>>2]=A;c[d+4>>2]=C;d=c[h>>2]|0;if((d|0)!=(c[i>>2]|0)?Uf(c[a>>2]|0,d,c[k>>2]|0)|0:0){m=138;break}h=c[B>>2]|0;g=c[p>>2]|0;if(h>>>0>=g>>>0){d=0;m=138;break}}if((m|0)==138)return d|0}else if((m|0)==114){j=a+32|0;k=a+36|0;l=a+16|0;while(1){i=c[j>>2]|0;h=c[k>>2]|0;if(i>>>0>=h>>>0)break;f=i+8|0;c[j>>2]=f;if((i|0)==(h|0)|(f|0)==(h|0))e=i;else{e=i;g=i;while(1){e=(c[e+4>>2]|0)<(c[g+12>>2]|0)?f:e;g=f+8|0;if((g|0)==(h|0))break;else{D=f;f=g;g=D}}}D=i;C=c[D>>2]|0;D=c[D+4>>2]|0;z=e;A=c[z+4>>2]|0;B=i;c[B>>2]=c[z>>2];c[B+4>>2]=A;c[e>>2]=C;c[e+4>>2]=D;e=c[i>>2]|0;if((e|0)!=(c[l>>2]|0)){d=e;m=138;break}}if((m|0)==138)return d|0;if((c[N>>2]|0)==20){a=0;return a|0}else{D=a+44|0;c[j>>2]=D;D=_e(c[a>>2]|0,D)|0;c[k>>2]=D;c[N>>2]=(c[N>>2]|0)+1;m=121;break}}else if((m|0)==132){i=a+20|0;while(1){h=c[z>>2]|0;g=c[t>>2]|0;if(h>>>0>=g>>>0){d=0;m=138;break}e=h+8|0;c[z>>2]=e;if((h|0)==(g|0)|(e|0)==(g|0))d=h;else{d=h;f=h;while(1){d=(c[d+4>>2]|0)<(c[f+12>>2]|0)?e:d;f=e+8|0;if((f|0)==(g|0))break;else{C=e;e=f;f=C}}}C=h;B=c[C>>2]|0;C=c[C+4>>2]|0;x=d;y=c[x+4>>2]|0;A=h;c[A>>2]=c[x>>2];c[A+4>>2]=y;c[d>>2]=B;c[d+4>>2]=C;d=c[h>>2]|0;if((d&63|0)==(c[i>>2]|0)){m=138;break}}if((m|0)==138)return d|0}while(0);if((m|0)==32){c[N>>2]=(c[N>>2]|0)+1;b=c[(c[b>>2]|0)+24>>2]|0;if((((b|0)!=0?(b|0)!=(c[a+16>>2]|0):0)?Mf(c[a>>2]|0,b)|0:0)?(D=b&180224,!((D|0)==32768|((D|0)!=49152?(c[(c[a>>2]|0)+((b&63)<<2)>>2]|0)!=0:0))):0){a=b;return a|0}else m=36}else if((m|0)==121){b=c[j>>2]|0;while(1){if(b>>>0>=D>>>0){d=0;m=138;break}d=b;b=b+8|0;c[j>>2]=b;d=c[d>>2]|0;if((d|0)!=(c[l>>2]|0)){m=138;break}}if((m|0)==138)return d|0}if((m|0)==36){c[N>>2]=(c[N>>2]|0)+1;b=c[a+8>>2]|0;if((((((b|0)!=0?(b|0)!=(c[a+16>>2]|0):0)?(E=c[a+4>>2]|0,(b|0)!=(c[E+20>>2]|0)):0)?(b|0)!=(c[E+24>>2]|0):0)?Mf(c[a>>2]|0,b)|0:0)?(E=b&180224,!((E|0)==32768|((E|0)!=49152?(c[(c[a>>2]|0)+((b&63)<<2)>>2]|0)!=0:0))):0){a=b;return a|0}else m=42}if((m|0)==42){b=c[a+40>>2]|0;j=a+32|0;c[j>>2]=b;k=a+36|0;c[k>>2]=Qe(c[a>>2]|0,b)|0;jf(a);b=c[j>>2]|0;d=c[k>>2]|0;if((c[a+12>>2]|0)<3){b:do if((b|0)!=(d|0))while(1){while(1){if((c[b+4>>2]|0)<=0)break;b=b+8|0;if((b|0)==(d|0)){b=d;break b}}while(1){e=d+-8|0;if((b|0)==(e|0))break b;if((c[d+-4>>2]|0)>0){d=e;break}else d=e}G=b;F=c[G>>2]|0;G=c[G+4>>2]|0;D=d;E=c[D+4>>2]|0;H=b;c[H>>2]=c[D>>2];c[H+4>>2]=E;H=d;c[H>>2]=F;c[H+4>>2]=G;b=b+8|0;if((b|0)==(d|0)){b=d;break}}while(0);i=c[j>>2]|0;d=i+8|0;if(d>>>0<b>>>0)do{h=d;g=c[h>>2]|0;h=c[h+4>>2]|0;c:do if((d|0)==(i|0))e=i;else{f=d;while(1){e=f;f=f+-8|0;if((c[e+-4>>2]|0)>=(h|0))break c;F=f;G=c[F+4>>2]|0;H=e;c[H>>2]=c[F>>2];c[H+4>>2]=G;if((f|0)==(i|0)){e=i;break}}}while(0);H=e;c[H>>2]=g;c[H+4>>2]=h;d=d+8|0}while(d>>>0<b>>>0)}else{e=b+8|0;if(e>>>0<d>>>0)do{i=e;h=c[i>>2]|0;i=c[i+4>>2]|0;d:do if((e|0)==(b|0))f=b;else{g=e;while(1){f=g;g=g+-8|0;if((c[f+-4>>2]|0)>=(i|0))break d;F=g;G=c[F+4>>2]|0;H=f;c[H>>2]=c[F>>2];c[H+4>>2]=G;if((g|0)==(b|0)){f=b;break}}}while(0);H=f;c[H>>2]=h;c[H+4>>2]=i;e=e+8|0}while(e>>>0<d>>>0)}G=c[N>>2]|0;c[N>>2]=G+1;H=j;F=k;G=G+2|0;m=62}if((m|0)==62){b=c[H>>2]|0;e=c[F>>2]|0;do if(b>>>0<e>>>0){f=c[a+16>>2]|0;g=a+4|0;h=a+8|0;while(1){d=b+8|0;b=c[b>>2]|0;if((((b|0)!=(f|0)?(O=c[g>>2]|0,(b|0)!=(c[O+20>>2]|0)):0)?(b|0)!=(c[O+24>>2]|0):0)?(b|0)!=(c[h>>2]|0):0){K=d;M=b;break}if(d>>>0<e>>>0)b=d;else{L=d;m=69;break}}if((m|0)==69){c[H>>2]=L;break}c[H>>2]=K;a=M;return a|0}while(0);c[N>>2]=G;J=a+44|0;c[H>>2]=J;I=H}if(J>>>0>=(c[a+40>>2]|0)>>>0){a=0;return a|0}c[I>>2]=J+8;a=c[J>>2]|0;return a|0}function lf(){var a=0,b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0;a=i;i=i+96|0;b=a;rk(b,17165,5);d=b+12|0;rk(d,17171,8);e=b+24|0;rk(e,17180,6);f=b+36|0;rk(f,17187,10);g=b+48|0;rk(g,17198,5);h=b+60|0;rk(h,17204,13);j=b+72|0;rk(j,17218,11);k=b+84|0;rk(k,17230,10);l=Nu(96)|0;c[258708]=l;c[258707]=l;c[258709]=l+96;qk(l,b);l=(c[258708]|0)+12|0;c[258708]=l;qk(l,d);l=(c[258708]|0)+12|0;c[258708]=l;qk(l,e);l=(c[258708]|0)+12|0;c[258708]=l;qk(l,f);l=(c[258708]|0)+12|0;c[258708]=l;qk(l,g);l=(c[258708]|0)+12|0;c[258708]=l;qk(l,h);l=(c[258708]|0)+12|0;c[258708]=l;qk(l,j);l=(c[258708]|0)+12|0;c[258708]=l;qk(l,k);c[258708]=(c[258708]|0)+12;vk(k);vk(j);vk(h);vk(g);vk(f);vk(e);vk(d);vk(b);c[258710]=2621485;c[258711]=1769502;c[258712]=5242930;c[258713]=4522038;c[258714]=1769497;c[258715]=1179675;c[258716]=2621485;c[258717]=1769502;c[258718]=2883644;c[258719]=2490386;c[258720]=2621485;c[258721]=1769502;b=1034888;c[b>>2]=0;c[b+4>>2]=0;c[258724]=2621485;c[258725]=1769502;c[258726]=2162744;c[258727]=1245225;c[258728]=1638464;c[258729]=3276826;c[258730]=1638441;c[258731]=852009;c[258732]=2162744;c[258733]=1245225;c[258734]=1703984;c[258735]=983120;c[258736]=2162744;c[258737]=1245225;b=1034952;c[b>>2]=0;c[b+4>>2]=0;c[258740]=2162744;c[258741]=1245225;c[258742]=524305;c[258743]=-3145773;c[258744]=45;c[258745]=524305;c[258746]=3276847;c[258747]=524305;c[258748]=0;c[258749]=524305;c[258750]=2490386;c[258751]=3342340;c[258752]=2752517;c[258753]=2490386;c[258754]=5111782;c[258755]=2490386;c[258756]=0;c[258757]=2490386;c[258758]=0;c[258759]=0;c[258760]=0;c[258761]=0;c[258762]=1048593;c[258763]=2097185;c[258764]=0;c[258765]=0;i=a;return}function mf(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0;c[a+64>>2]=d;e=c[b+5356>>2]|0;i=e+24|0;c[a+80>>2]=c[i>>2]&3;if((c[b+5364>>2]|0)==7)j=_(c[e+40>>2]|0,-2)|0;else j=0;g=b+320|0;h=b+264|0;f=c[h>>2]&c[g>>2];g=c[h+4>>2]&c[g+4>>2];if((f|0)==0&(g|0)==0)g=0;else{h=0;while(1){e=h+1|0;h=100672+(d<<6)+(h<<3)|0;if((c[h>>2]&f|0)==0?(c[h+4>>2]&g|0)==0:0)h=e;else break}g=_(e,-16)|0}e=nf(a,b,d)|0;f=c[i>>2]|0;if(f&1){i=nf(a,b,6)|0;e=(e|0)<(i|0)?i:e}if(!(f&2)){b=e;a=g+j|0;a=a<<16;a=b+a|0;return a|0}b=nf(a,b,2)|0;b=(e|0)<(b|0)?b:e;a=g+j|0;a=a<<16;a=b+a|0;return a|0}function nf(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;n=b+264|0;m=d>>3;h=26816+(m<<3)|0;g=26688+(m<<3)|0;i=(c[g>>2]|c[h>>2])&c[n>>2];n=(c[g+4>>2]|c[h+4>>2])&c[n+4>>2];h=b+320|0;g=i&c[h>>2];h=n&c[h+4>>2];j=b+328|0;i=i&c[j>>2];j=n&c[j+4>>2];n=d&7;k=n>>>0<6?n:6;k=(k|0)>1?k:1;f=k+-1|0;l=c[b+5364>>2]|0;m=m+1|0;b=26624+(f<<3)|0;e=c[b>>2]|0;b=c[b+4>>2]|0;o=g&e;d=h&b;a=hb(o|0,d|0,0)|0;a=(o|0)==0&(d|0)==0?0:a>>>3;e=i&e;b=j&b;d=hb(e|0,b|0,0)|0;d=(e|0)==0&(b|0)==0?0:d>>>3;b=8-k|0;b=(b|0)<(f|0)?b:f;e=c[4920+(l<<7)+(b<<5)+(a<<2)>>2]|0;if(!((f|0)==(n|0)&(d|0)==(m|0)))if(!a)a=0;else a=(d|0)==(a+1|0)?2:1;else a=3;f=258-e-(c[5944+(a<<7)+(b<<5)+(d<<2)>>2]|0)|0;b=26624+(k<<3)|0;e=c[b>>2]|0;b=c[b+4>>2]|0;o=g&e;d=h&b;a=hb(o|0,d|0,0)|0;a=(o|0)==0&(d|0)==0?0:a>>>3;e=i&e;b=j&b;d=hb(e|0,b|0,0)|0;d=(e|0)==0&(b|0)==0?0:d>>>3;b=k^7;b=(b|0)<(k|0)?b:k;e=c[4920+(l<<7)+(b<<5)+(a<<2)>>2]|0;if(!((k|0)==(n|0)&(d|0)==(m|0)))if(!a)a=0;else a=(d|0)==(a+1|0)?2:1;else a=3;f=f-e-(c[5944+(a<<7)+(b<<5)+(d<<2)>>2]|0)|0;o=k+1|0;d=26624+(o<<3)|0;a=c[d>>2]|0;d=c[d+4>>2]|0;g=g&a;b=h&d;e=hb(g|0,b|0,0)|0;e=(g|0)==0&(b|0)==0?0:e>>>3;a=i&a;d=j&d;b=hb(a|0,d|0,0)|0;b=(a|0)==0&(d|0)==0?0:b>>>3;d=6-k|0;d=(d|0)<(o|0)?d:o;a=c[4920+(l<<7)+(d<<5)+(e<<2)>>2]|0;if((o|0)==(n|0)&(b|0)==(m|0)){o=3;o=5944+(o<<7)+(d<<5)+(b<<2)|0;o=c[o>>2]|0;n=f-a|0;o=n-o|0;return o|0}if(!e){o=0;o=5944+(o<<7)+(d<<5)+(b<<2)|0;o=c[o>>2]|0;n=f-a|0;o=n-o|0;return o|0}o=(b|0)==(e+1|0)?2:1;o=5944+(o<<7)+(d<<5)+(b<<2)|0;o=c[o>>2]|0;n=f-a|0;o=n-o|0;return o|0}function of(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0;c[a+68>>2]=d;e=c[b+5356>>2]|0;i=e+24|0;c[a+84>>2]=c[i>>2]&12;if((c[b+5364>>2]|0)==7)j=_(c[e+36>>2]|0,-2)|0;else j=0;g=b+328|0;h=b+264|0;f=c[h>>2]&c[g>>2];g=c[h+4>>2]&c[g+4>>2];if((f|0)==0&(g|0)==0)g=0;else{h=0;while(1){e=h+1|0;h=100672+(d<<6)+(h<<3)|0;if((c[h>>2]&f|0)==0?(c[h+4>>2]&g|0)==0:0)h=e;else break}g=_(e,-16)|0}e=pf(a,b,d)|0;f=c[i>>2]|0;if(f&4){i=pf(a,b,62)|0;e=(e|0)<(i|0)?i:e}if(!(f&8)){b=e;a=g+j|0;a=a<<16;a=b+a|0;return a|0}b=pf(a,b,58)|0;b=(e|0)<(b|0)?b:e;a=g+j|0;a=a<<16;a=b+a|0;return a|0}function pf(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;n=b+264|0;m=d>>3;h=26880+(m<<3)|0;g=26688+(m<<3)|0;i=(c[g>>2]|c[h>>2])&c[n>>2];n=(c[g+4>>2]|c[h+4>>2])&c[n+4>>2];h=b+328|0;g=i&c[h>>2];h=n&c[h+4>>2];j=b+320|0;i=i&c[j>>2];j=n&c[j+4>>2];n=d&7;k=n>>>0<6?n:6;k=(k|0)>1?k:1;f=k+-1|0;l=c[b+5364>>2]|0;m=(m^7)+1|0;b=26624+(f<<3)|0;e=c[b>>2]|0;b=c[b+4>>2]|0;o=g&e;d=h&b;a=bv(o|0,d|0,0)|0;a=(o|0)==0&(d|0)==0?0:a>>>3;e=i&e;b=j&b;d=bv(e|0,b|0,0)|0;d=(e|0)==0&(b|0)==0?0:d>>>3;b=8-k|0;b=(b|0)<(f|0)?b:f;e=c[4920+(l<<7)+(b<<5)+(a<<2)>>2]|0;if(!((f|0)==(n|0)&(d|0)==(m|0)))if(!a)a=0;else a=(d|0)==(a+1|0)?2:1;else a=3;f=258-e-(c[5944+(a<<7)+(b<<5)+(d<<2)>>2]|0)|0;b=26624+(k<<3)|0;e=c[b>>2]|0;b=c[b+4>>2]|0;o=g&e;d=h&b;a=bv(o|0,d|0,0)|0;a=(o|0)==0&(d|0)==0?0:a>>>3;e=i&e;b=j&b;d=bv(e|0,b|0,0)|0;d=(e|0)==0&(b|0)==0?0:d>>>3;b=k^7;b=(b|0)<(k|0)?b:k;e=c[4920+(l<<7)+(b<<5)+(a<<2)>>2]|0;if(!((k|0)==(n|0)&(d|0)==(m|0)))if(!a)a=0;else a=(d|0)==(a+1|0)?2:1;else a=3;f=f-e-(c[5944+(a<<7)+(b<<5)+(d<<2)>>2]|0)|0;o=k+1|0;d=26624+(o<<3)|0;a=c[d>>2]|0;d=c[d+4>>2]|0;g=g&a;b=h&d;e=bv(g|0,b|0,0)|0;e=(g|0)==0&(b|0)==0?0:e>>>3;a=i&a;d=j&d;b=bv(a|0,d|0,0)|0;b=(a|0)==0&(d|0)==0?0:b>>>3;d=6-k|0;d=(d|0)<(o|0)?d:o;a=c[4920+(l<<7)+(d<<5)+(e<<2)>>2]|0;if((o|0)==(n|0)&(b|0)==(m|0)){o=3;o=5944+(o<<7)+(d<<5)+(b<<2)|0;o=c[o>>2]|0;n=f-a|0;o=n-o|0;return o|0}if(!e){o=0;o=5944+(o<<7)+(d<<5)+(b<<2)|0;o=c[o>>2]|0;n=f-a|0;o=n-o|0;return o|0}o=(b|0)==(e+1|0)?2:1;o=5944+(o<<7)+(d<<5)+(b<<2)|0;o=c[o>>2]|0;n=f-a|0;o=n-o|0;return o|0}function qf(){var a=0,b=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0;A=0;do{k=8>>>A;k=(((k|0)/-4|0)<<16)+k|0;n=1035064+(A<<7)+4|0;q=19>>>A;t=1035064+(A<<7)+8|0;b=13>>>A;b=(((b|0)/4|0)<<16)+b|0;d=1035064+(A<<7)+12|0;e=71>>>A;e=(((e|0)/2|0)<<16)+e|0;f=1035064+(A<<7)+16|0;g=94>>>A;g=(((g*3|0)/4|0)<<16)+g|0;h=1035064+(A<<7)+20|0;i=(169>>>A)*65537|0;j=1035064+(A<<7)+24|0;l=8>>>A;l=((l|0)/2|0)+l|0;l=(((l|0)/-4|0)<<16)+l|0;m=19>>>A;m=((m|0)/2|0)+m|0;o=13>>>A;o=((o|0)/2|0)+o|0;o=(((o|0)/4|0)<<16)+o|0;p=71>>>A;p=((p|0)/2|0)+p|0;p=(((p|0)/2|0)<<16)+p|0;r=94>>>A;r=((r|0)/2|0)+r|0;r=(((r*3|0)/4|0)<<16)+r|0;s=169>>>A;s=(((s|0)/2|0)+s|0)*65537|0;u=13>>>A;u=(((u|0)/-4|0)<<16)+u|0;v=16>>>A;w=42>>>A;w=(((w|0)/4|0)<<16)+w|0;x=82>>>A;x=(((x|0)/2|0)<<16)+x|0;y=131>>>A;y=(((y*3|0)/4|0)<<16)+y|0;z=(246>>>A)*65537|0;a=0;while(1)if(a){c[1035064+(A<<7)+(a<<5)+4>>2]=l;c[1035064+(A<<7)+(a<<5)+8>>2]=m;c[1035064+(A<<7)+(a<<5)+12>>2]=o;c[1035064+(A<<7)+(a<<5)+16>>2]=p;c[1035064+(A<<7)+(a<<5)+20>>2]=r;c[1035064+(A<<7)+(a<<5)+24>>2]=s;a=a+1|0;if((a|0)==2)break;else continue}else{c[n>>2]=k;c[t>>2]=q;c[d>>2]=b;c[f>>2]=e;c[h>>2]=g;c[j>>2]=i;a=1;continue}a=1035064+(A<<7)+68|0;b=1035064+(A<<7)+72|0;d=1035064+(A<<7)+76|0;e=1035064+(A<<7)+80|0;f=1035064+(A<<7)+84|0;g=1035064+(A<<7)+88|0;i=0;while(1){if(!i){c[a>>2]=u;c[b>>2]=v;c[d>>2]=w;c[e>>2]=x;c[f>>2]=y;c[g>>2]=z;i=1;continue}else{h=8;j=1}do{t=j;j=j+1|0;s=h;h=c[6456+(j<<2)>>2]|0;s=((h-s|0)/2|0)+s>>A;s=((s|0)/2|0)+s|0;c[1035064+(A<<7)+64+(i<<5)+(t<<2)>>2]=(((_(s,t+-2|0)|0)/4|0)<<16)+s}while((j|0)!=7);i=i+1|0;if((i|0)==2)break}A=A+1|0}while((A|0)!=2);return}function rf(a){a=a|0;var b=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0;e=c[a+5356>>2]|0;b=c[e>>2]|0;e=c[e+4>>2]|0;U=b&16383;V=c[(c[a+5352>>2]|0)+88>>2]|0;W=V+(U*120|0)|0;T=W;if((c[T>>2]|0)==(b|0)?(c[T+4>>2]|0)==(e|0):0)return W|0;R=W;c[R>>2]=b;c[R+4>>2]=e;R=a+320|0;J=R;P=a+264|0;L=P;K=c[L>>2]|0;L=c[L+4>>2]|0;I=K&c[J>>2];J=L&c[J+4>>2];Q=a+328|0;M=Q;K=c[M>>2]&K;L=c[M+4>>2]&L;M=V+(U*120|0)+48|0;N=M;c[N>>2]=0;c[N+4>>2]=0;N=V+(U*120|0)+16|0;O=N;c[O>>2]=0;c[O+4>>2]=0;O=V+(U*120|0)+88|0;c[O>>2]=255;c[V+(U*120|0)+64>>2]=64;H=Zu(I|0,J|0,9)|0;b=C&-16843010;S=Zu(I|0,J|0,7)|0;T=V+(U*120|0)+32|0;c[T>>2]=H&-16843264|S&2139062016;c[T+4>>2]=b|C&2139062143;T=Yu(I|0,J|0,16)|0;b=Yu(I|0,J|0,48)|0;b=(d[1151952+(T&43605)>>0]|0)+(d[1151952+(I&43605)>>0]|0)+(d[1151952+(J&43605)>>0]|0)+(d[1151952+(b&43605)>>0]|0)|0;c[V+(U*120|0)+100>>2]=b;c[V+(U*120|0)+96>>2]=(c[a+340>>2]|0)-b;b=c[a+656>>2]|0;if((b|0)==64){T=255;S=0}else{F=c[a+5364>>2]|0;G=1034968+(F<<2)|0;H=1035e3+(F<<2)|0;w=b;b=255;B=0;D=0;f=0;g=0;E=a+660|0;e=0;while(1){i=w&7;b=b&~(1<<i);m=106816+(w<<3)|0;B=c[m>>2]|B;D=c[m+4>>2]|D;m=M;c[m>>2]=B;c[m+4>>2]=D;m=104768+(w<<3)|0;l=c[m>>2]|0;m=c[m+4>>2]|0;q=(l&K|0)!=0|(m&L|0)!=0;o=105792+(w<<3)|0;n=c[o>>2]&K;o=c[o+4>>2]&L;z=27456+(w<<3)|0;z=c[z>>2]&K|0?1:(c[z+4>>2]&L|0)!=0;y=26112+(w+8<<3)|0;x=c[y>>2]&I;y=c[y+4>>2]&J;i=26752+(i<<3)|0;h=c[i>>2]|0;i=c[i+4>>2]|0;j=h&I;k=i&J;A=w>>3;s=26688+(A<<3)|0;r=j&c[s>>2];s=k&c[s+4>>2];u=26688+(w+-8>>3<<3)|0;t=c[u>>2]&j;u=c[u+4>>2]&k;v=(t|r|0)==0&(u|s|0)==0;p=(j|0)!=0|(k|0)!=0;if((A|0)>3|(z|p^1))h=0;else{T=hb(j|n|0,k|o|0,0)|0;T=26688+(T>>>3<<3)|0;S=c[T>>2]|0;T=c[T+4>>2]|0;h=Zu(S&h|0,T&i|0,8)|0;h=((h|S)&n|0)!=0|((C|T)&o|0)!=0}if((n|l&I|0)==0&(o|m&J|0)==0){T=26112+(w<<3)|0;f=c[T>>2]|f;g=c[T+4>>2]|g;T=N;c[T>>2]=f;c[T+4>>2]=g}do if(p){if(h){e=e-(c[1034904+(F<<3)+((q&1)<<2)>>2]|0)|0;break}if((t|0)==0&(u|0)==0)e=e-(c[G>>2]|0)|0}else e=e-(c[1034840+(F<<3)+((q&1)<<2)>>2]|0)|0;while(0);if(!v){T=Xu(t|0,u|0,-1,-1)|0;e=(c[1035064+((q&1)<<7)+((((r|0)!=0|(s|0)!=0)&1)<<6)+((((T&t|0)!=0|(C&u|0)!=0)&1)<<5)+(A<<2)>>2]|0)+e|0}if(!((x|0)==0&(y|0)==0))e=e-(c[H>>2]|0)|0;if(z)e=(c[1035032+(A<<2)>>2]|0)+e|0;w=c[E>>2]|0;if((w|0)==64)break;else E=E+4|0}c[O>>2]=b;T=b;S=e}N=Q;G=P;F=c[G>>2]|0;G=c[G+4>>2]|0;M=F&c[N>>2];N=G&c[N+4>>2];H=R;F=c[H>>2]&F;G=c[H+4>>2]&G;H=V+(U*120|0)+56|0;I=H;c[I>>2]=0;c[I+4>>2]=0;I=V+(U*120|0)+24|0;O=I;c[O>>2]=0;c[O+4>>2]=0;O=V+(U*120|0)+92|0;c[O>>2]=255;c[V+(U*120|0)+68>>2]=64;P=Yu(M|0,N|0,9)|0;b=C&8355711;Q=Yu(M|0,N|0,7)|0;R=V+(U*120|0)+40|0;c[R>>2]=P&2139062143|Q&-16843010;c[R+4>>2]=b|C&16711422;R=Yu(M|0,N|0,16)|0;b=Yu(M|0,N|0,48)|0;b=(d[1151952+(R&43605)>>0]|0)+(d[1151952+(M&43605)>>0]|0)+(d[1151952+(N&43605)>>0]|0)+(d[1151952+(b&43605)>>0]|0)|0;c[V+(U*120|0)+108>>2]=b;c[V+(U*120|0)+104>>2]=(c[a+372>>2]|0)-b;b=c[a+2704>>2]|0;if((b|0)==64){e=255;b=0}else{J=c[a+5364>>2]|0;K=1034968+(J<<2)|0;L=1035e3+(J<<2)|0;y=b;e=255;D=0;E=0;f=0;g=0;B=a+2708|0;b=0;while(1){i=y&7;e=e&~(1<<i);m=107328+(y<<3)|0;D=c[m>>2]|D;E=c[m+4>>2]|E;m=H;c[m>>2]=D;c[m+4>>2]=E;m=105280+(y<<3)|0;l=c[m>>2]|0;m=c[m+4>>2]|0;q=(l&F|0)!=0|(m&G|0)!=0;o=106304+(y<<3)|0;n=c[o>>2]&F;o=c[o+4>>2]&G;z=31552+(y<<3)|0;z=c[z>>2]&F|0?1:(c[z+4>>2]&G|0)!=0;x=26112+(y+-8<<3)|0;w=c[x>>2]&M;x=c[x+4>>2]&N;i=26752+(i<<3)|0;h=c[i>>2]|0;i=c[i+4>>2]|0;j=h&M;k=i&N;A=y>>3;s=26688+(A<<3)|0;r=j&c[s>>2];s=k&c[s+4>>2];u=26688+(y+8>>3<<3)|0;t=c[u>>2]&j;u=c[u+4>>2]&k;v=(t|r|0)==0&(u|s|0)==0;p=(j|0)!=0|(k|0)!=0;A=A^7;if((A|0)>3|(z|p^1))h=0;else{a=bv(j|n|0,k|o|0,0)|0;a=26688+((a>>>3^7)<<3)|0;R=c[a>>2]|0;a=c[a+4>>2]|0;h=Yu(R&h|0,a&i|0,8)|0;h=((h|R)&n|0)!=0|((C|a)&o|0)!=0}if((n|l&M|0)==0&(o|m&N|0)==0){a=26112+(y<<3)|0;f=c[a>>2]|f;g=c[a+4>>2]|g;a=I;c[a>>2]=f;c[a+4>>2]=g}do if(p){if(h){b=b-(c[1034904+(J<<3)+((q&1)<<2)>>2]|0)|0;break}if((t|0)==0&(u|0)==0)b=b-(c[K>>2]|0)|0}else b=b-(c[1034840+(J<<3)+((q&1)<<2)>>2]|0)|0;while(0);if(!v){a=Xu(t|0,u|0,-1,-1)|0;b=(c[1035064+((q&1)<<7)+((((r|0)!=0|(s|0)!=0)&1)<<6)+((((a&t|0)!=0|(C&u|0)!=0)&1)<<5)+(A<<2)>>2]|0)+b|0}if(!((w|0)==0&(x|0)==0))b=b-(c[L>>2]|0)|0;if(z)b=(c[1035032+(A<<2)>>2]|0)+b|0;y=c[B>>2]|0;if((y|0)==64)break;else B=B+4|0}c[O>>2]=e}c[V+(U*120|0)+8>>2]=S-b;a=e^T;R=((a|0)<0)<<31>>31;Q=Yu(a|0,R|0,16)|0;S=Yu(a|0,R|0,48)|0;c[V+(U*120|0)+112>>2]=(d[1151952+(Q&65535)>>0]|0)+(d[1151952+(a&65535)>>0]|0)+(d[1151952+(R&65535)>>0]|0)+(d[1151952+S>>0]|0);S=e&T;T=((S|0)<0)<<31>>31;R=Yu(S|0,T|0,16)|0;a=Yu(S|0,T|0,48)|0;c[V+(U*120|0)+116>>2]=(d[1151952+(R&65535)>>0]|0)+(d[1151952+(S&65535)>>0]|0)+(d[1151952+(T&65535)>>0]|0)+(d[1151952+a>>0]|0);return W|0}function sf(){var a=0,b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0;a=i;i=i+96|0;b=a;rk(b,17165,5);d=b+12|0;rk(d,17171,8);e=b+24|0;rk(e,17180,6);f=b+36|0;rk(f,17187,10);g=b+48|0;rk(g,17198,5);h=b+60|0;rk(h,17204,13);j=b+72|0;rk(j,17218,11);k=b+84|0;rk(k,17230,10);l=Nu(96)|0;c[258831]=l;c[258830]=l;c[258832]=l+96;qk(l,b);l=(c[258831]|0)+12|0;c[258831]=l;qk(l,d);l=(c[258831]|0)+12|0;c[258831]=l;qk(l,e);l=(c[258831]|0)+12|0;c[258831]=l;qk(l,f);l=(c[258831]|0)+12|0;c[258831]=l;qk(l,g);l=(c[258831]|0)+12|0;c[258831]=l;qk(l,h);l=(c[258831]|0)+12|0;c[258831]=l;qk(l,j);l=(c[258831]|0)+12|0;c[258831]=l;qk(l,k);c[258831]=(c[258831]|0)+12;vk(k);vk(j);vk(h);vk(g);vk(f);vk(e);vk(d);vk(b);rk(1035332,16259,15);i=a;return}function tf(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;u=i;i=i+208|0;l=u+184|0;t=u;k=u+172|0;o=u+160|0;p=u+148|0;q=u+136|0;r=t+4|0;c[t>>2]=6500;s=t+56|0;c[s>>2]=6520;fm(t+56|0,r);c[t+128>>2]=0;c[t+132>>2]=-1;c[t>>2]=6540;c[t+56>>2]=6560;hm(r);c[r>>2]=3544;m=t+36|0;c[m>>2]=0;c[m+4>>2]=0;c[m+8>>2]=0;c[m+12>>2]=0;c[t+52>>2]=16;c[l>>2]=0;c[l+4>>2]=0;c[l+8>>2]=0;Td(r,l);vk(l);n=d+5364|0;g=d+4560|0;j=7;while(1){h=j<<3;f=0;e=0;while(1){if(c[d+(e+h<<2)>>2]|0){if(f|0)tm(t,f)|0;f=e+h|0;a[l>>0]=a[((a[1035332]&1)==0?1035333:c[258835]|0)+(c[d+(f<<2)>>2]|0)>>0]|0;Ud(t,l,1)|0;if((c[n>>2]|0)==3?(v=g,f=26112+(f<<3)|0,!((c[f>>2]&c[v>>2]|0)==0?(c[f+4>>2]&c[v+4>>2]|0)==0:0)):0)Ud(t,16275,1)|0}else{f=f+1|0;e=e+1|0;if((e|0)<8)continue;tm(t,f)|0}e=e+1|0;if((e|0)>=8)break;else f=0}if((j|0)<=0)break;a[l>>0]=47;Ud(t,l,1)|0;j=j+-1|0}if((c[n>>2]|0)==3){a[l>>0]=91;Ud(t,l,1)|0;e=k+8|0;f=k+1|0;g=k+4|0;h=0;do{v=h<<3;sk(k,c[d+4496+(h<<5)+20>>2]|0,a[((a[1035332]&1)==0?1035333:c[258835]|0)+(v|5)>>0]|0);j=a[k>>0]|0;w=(j&1)==0;Ud(t,w?f:c[e>>2]|0,w?(j&255)>>>1:c[g>>2]|0)|0;vk(k);sk(k,c[d+4496+(h<<5)+16>>2]|0,a[((a[1035332]&1)==0?1035333:c[258835]|0)+(v|4)>>0]|0);j=a[k>>0]|0;w=(j&1)==0;Ud(t,w?f:c[e>>2]|0,w?(j&255)>>>1:c[g>>2]|0)|0;vk(k);sk(k,c[d+4496+(h<<5)+12>>2]|0,a[((a[1035332]&1)==0?1035333:c[258835]|0)+(v|3)>>0]|0);j=a[k>>0]|0;w=(j&1)==0;Ud(t,w?f:c[e>>2]|0,w?(j&255)>>>1:c[g>>2]|0)|0;vk(k);sk(k,c[d+4496+(h<<5)+8>>2]|0,a[((a[1035332]&1)==0?1035333:c[258835]|0)+(v|2)>>0]|0);j=a[k>>0]|0;w=(j&1)==0;Ud(t,w?f:c[e>>2]|0,w?(j&255)>>>1:c[g>>2]|0)|0;vk(k);sk(k,c[d+4496+(h<<5)+4>>2]|0,a[((a[1035332]&1)==0?1035333:c[258835]|0)+(v|1)>>0]|0);v=a[k>>0]|0;j=(v&1)==0;Ud(t,j?f:c[e>>2]|0,j?(v&255)>>>1:c[g>>2]|0)|0;vk(k);h=h+1|0}while((h|0)!=2);a[l>>0]=93;Ud(t,l,1)|0}g=d+5348|0;Ud(t,(c[g>>2]|0)==0?16277:16281,3)|0;h=d+5356|0;e=c[h>>2]|0;f=c[e+24>>2]|0;if(f&1){if(!(a[d+5360>>0]|0))e=75;else e=(c[d+5148>>2]&7)+65&255;a[l>>0]=e;Ud(t,l,1)|0;e=c[h>>2]|0;f=c[e+24>>2]|0}if(f&2){if(!(a[d+5360>>0]|0))e=81;else e=(c[d+5152>>2]&7)+65&255;a[l>>0]=e;Ud(t,l,1)|0;e=c[h>>2]|0;f=c[e+24>>2]|0}if(f&4){if(!(a[d+5360>>0]|0))e=107;else e=(c[d+5160>>2]&7)+97&255;a[l>>0]=e;Ud(t,l,1)|0;e=c[h>>2]|0;f=c[e+24>>2]|0}if(f&8){if(!(a[d+5360>>0]|0))e=113;else e=(c[d+5176>>2]&7)+97&255;a[l>>0]=e;Ud(t,l,1)|0;e=c[h>>2]|0;f=c[e+24>>2]|0}if(!(f&15)){a[l>>0]=45;Ud(t,l,1)|0;e=c[h>>2]|0}e=c[e+48>>2]|0;if((e|0)==64){rk(o,16285,3);w=a[o>>0]|0;v=(w&1)==0;Ud(t,v?o+1|0:c[o+8>>2]|0,v?(w&255)>>>1:c[o+4>>2]|0)|0;vk(o)}else{mh(q,e);w=Ik(q,0,17070)|0;c[p>>2]=c[w>>2];c[p+4>>2]=c[w+4>>2];c[p+8>>2]=c[w+8>>2];c[w>>2]=0;c[w+4>>2]=0;c[w+8>>2]=0;w=Fk(p,17070)|0;c[o>>2]=c[w>>2];c[o+4>>2]=c[w+4>>2];c[o+8>>2]=c[w+8>>2];c[w>>2]=0;c[w+4>>2]=0;c[w+8>>2]=0;w=a[o>>0]|0;v=(w&1)==0;Ud(t,v?o+1|0:c[o+8>>2]|0,v?(w&255)>>>1:c[o+4>>2]|0)|0;vk(o);vk(p);vk(q)}if((c[n>>2]|0)!=7){v=c[h>>2]|0;v=v+28|0;v=c[v>>2]|0;v=tm(t,v)|0;v=Ud(v,17070,1)|0;d=d+5344|0;d=c[d>>2]|0;w=c[g>>2]|0;w=(w|0)==1;w=w&1;w=d-w|0;w=(w|0)/2|0;w=w+1|0;tm(v,w)|0;Wd(b,r);c[t>>2]=6540;c[s>>2]=6560;c[r>>2]=3544;vk(m);il(r);el(s);i=u;return}v=Ud(tm(t,3-(c[(c[h>>2]|0)+36>>2]|0)|0)|0,16289,1)|0;Ud(tm(v,3-(c[(c[h>>2]|0)+40>>2]|0)|0)|0,17070,1)|0;v=c[h>>2]|0;v=v+28|0;v=c[v>>2]|0;v=tm(t,v)|0;v=Ud(v,17070,1)|0;d=d+5344|0;d=c[d>>2]|0;w=c[g>>2]|0;w=(w|0)==1;w=w&1;w=d-w|0;w=(w|0)/2|0;w=w+1|0;tm(v,w)|0;Wd(b,r);c[t>>2]=6540;c[s>>2]=6560;c[r>>2]=3544;vk(m);il(r);el(s);i=u;return}function uf(a){a=a|0;var b=0,d=0;c[a>>2]=6540;b=a+56|0;c[b>>2]=6560;d=a+4|0;c[d>>2]=3544;vk(a+36|0);il(d);el(b);return}function vf(a){a=a|0;var b=0,d=0;c[a>>2]=6540;b=a+56|0;c[b>>2]=6560;d=a+4|0;c[d>>2]=3544;vk(a+36|0);il(d);el(b);mu(a);return}function wf(a){a=a|0;var b=0,d=0;d=a+(c[(c[a>>2]|0)+-12>>2]|0)|0;c[d>>2]=6540;a=d+56|0;c[a>>2]=6560;b=d+4|0;c[b>>2]=3544;vk(d+36|0);il(b);el(a);return}function xf(a){a=a|0;var b=0,d=0;a=a+(c[(c[a>>2]|0)+-12>>2]|0)|0;c[a>>2]=6540;b=a+56|0;c[b>>2]=6560;d=a+4|0;c[d>>2]=3544;vk(a+36|0);il(d);el(b);mu(a);return}function yf(b,e,f,g,h,j){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0;I=i;i=i+144|0;B=I+140|0;H=I;E=H+8|0;c[H>>2]=6596;F=H+60|0;c[F>>2]=6616;c[H+4>>2]=0;fm(H+60|0,E);c[H+132>>2]=0;c[H+136>>2]=-1;c[H>>2]=6636;c[H+60>>2]=6656;hm(E);c[E>>2]=3544;G=H+40|0;c[G>>2]=0;c[G+4>>2]=0;c[G+8>>2]=0;c[G+12>>2]=0;c[H+56>>2]=8;Td(E,e);Wu(b|0,0,5368)|0;Wu(h|0,0,440)|0;e=1024;k=b+400|0;while(1){c[k>>2]=64;e=e+-1|0;if(!e)break;else k=k+4|0}D=b+5356|0;c[D>>2]=h;A=b+5364|0;c[A>>2]=g;m=H+(c[(c[H>>2]|0)+-12>>2]|0)+4|0;c[m>>2]=c[m>>2]&-4097;m=b+4560|0;q=b+256|0;n=56;e=0;a:while(1){l=26112+(n+-1<<3)|0;while(1){km(B,H,0);do if(a[B>>0]|0){k=c[H+(c[(c[H>>2]|0)+-12>>2]|0)+24>>2]|0;h=k+12|0;g=c[h>>2]|0;if((g|0)==(c[k+16>>2]|0)){k=Fb[c[(c[k>>2]|0)+40>>2]&127](k)|0;if((k|0)==-1){z=H+(c[(c[H>>2]|0)+-12>>2]|0)|0;em(z,c[z+16>>2]|6);break}else e=k}else{c[h>>2]=g+1;e=d[g>>0]|0}e=e&255}while(0);if(c[H+(c[(c[H>>2]|0)+-12>>2]|0)+16>>2]&5|0){x=23;break a}k=e&255;if(oi(k)|0){x=23;break a}k=k+-48|0;if(k>>>0<10){x=14;break}if(e<<24>>24==47){x=16;break}k=Jk(1035332,e,0)|0;if((k|0)!=-1){x=19;break}k=(c[A>>2]|0)==3;if(!(e<<24>>24==126&k))if(e<<24>>24==91&k){e=91;x=23;break a}else continue;else{w=l;v=m;x=c[v+4>>2]|c[w+4>>2];z=m;c[z>>2]=c[v>>2]|c[w>>2];c[z+4>>2]=x;continue}}if((x|0)==14){n=k+n|0;continue}else if((x|0)==16){if((n|0)<16&(c[A>>2]|0)==3){e=47;x=24;break}n=n+-16|0;e=47;continue}else if((x|0)==19){c[b+(n<<2)>>2]=k;v=26112+(n<<3)|0;x=v;w=q;u=c[w+4>>2]|c[x+4>>2];z=q;c[z>>2]=c[w>>2]|c[x>>2];c[z+4>>2]=u;z=b+256+((k&7)<<3)|0;u=v;x=z;w=c[x+4>>2]|c[u+4>>2];c[z>>2]=c[x>>2]|c[u>>2];c[z+4>>2]=w;z=k>>3;w=b+320+(z<<3)|0;u=w;x=c[u+4>>2]|c[v+4>>2];c[w>>2]=c[u>>2]|c[v>>2];c[w+4>>2]=x;w=b+336+(k<<2)|0;x=c[w>>2]|0;c[w>>2]=x+1;c[b+4568+(n<<2)>>2]=x;c[b+400+(k<<8)+(x<<2)>>2]=n;z=b+336+(z<<3<<2)|0;c[z>>2]=(c[z>>2]|0)+1;n=n+1|0;continue}}if((x|0)==23)if((c[A>>2]|0)==3)x=24;else k=e;b:do if((x|0)==24){k=e;while(1){km(B,H,0);do if(a[B>>0]|0){e=c[H+(c[(c[H>>2]|0)+-12>>2]|0)+24>>2]|0;h=e+12|0;g=c[h>>2]|0;if((g|0)==(c[e+16>>2]|0)){e=Fb[c[(c[e>>2]|0)+40>>2]&127](e)|0;if((e|0)==-1){z=H+(c[(c[H>>2]|0)+-12>>2]|0)|0;em(z,c[z+16>>2]|6);break}}else{c[h>>2]=g+1;e=d[g>>0]|0}k=e&255}while(0);if(c[H+(c[(c[H>>2]|0)+-12>>2]|0)+16>>2]&5|0)break b;if(oi(k&255)|0)break b;if(k<<24>>24==93){k=93;continue}e=Jk(1035332,k,0)|0;if((e|0)==-1)continue;z=b+4496+(e>>3<<5)+((e&7)<<2)|0;c[z>>2]=(c[z>>2]|0)+1}}while(0);km(B,H,0);do if(a[B>>0]|0){e=c[H+(c[(c[H>>2]|0)+-12>>2]|0)+24>>2]|0;h=e+12|0;g=c[h>>2]|0;if((g|0)==(c[e+16>>2]|0)){e=Fb[c[(c[e>>2]|0)+40>>2]&127](e)|0;if((e|0)==-1){z=H+(c[(c[H>>2]|0)+-12>>2]|0)|0;em(z,c[z+16>>2]|6);break}}else{c[h>>2]=g+1;e=d[g>>0]|0}k=e&255}while(0);z=b+5348|0;c[z>>2]=k<<24>>24!=119&1;km(B,H,0);do if(a[B>>0]|0){e=c[H+(c[(c[H>>2]|0)+-12>>2]|0)+24>>2]|0;h=e+12|0;g=c[h>>2]|0;if((g|0)==(c[e+16>>2]|0)){e=Fb[c[(c[e>>2]|0)+40>>2]&127](e)|0;if((e|0)==-1){w=H+(c[(c[H>>2]|0)+-12>>2]|0)|0;em(w,c[w+16>>2]|6);break}}else{c[h>>2]=g+1;e=d[g>>0]|0}k=e&255}while(0);c:while(1){km(B,H,0);do if(a[B>>0]|0){e=c[H+(c[(c[H>>2]|0)+-12>>2]|0)+24>>2]|0;h=e+12|0;g=c[h>>2]|0;if((g|0)==(c[e+16>>2]|0)){e=Fb[c[(c[e>>2]|0)+40>>2]&127](e)|0;if((e|0)==-1){w=H+(c[(c[H>>2]|0)+-12>>2]|0)|0;em(w,c[w+16>>2]|6);break}}else{c[h>>2]=g+1;e=d[g>>0]|0}k=e&255}while(0);if(c[H+(c[(c[H>>2]|0)+-12>>2]|0)+16>>2]&5|0){g=k;break}g=k&255;if(oi(g)|0){g=k;break}n=(ej(g)|0)!=0;o=n&1;l=n?7:0;d:do switch(c[A>>2]|0){case 4:{e=o<<3|6;if(!(c[b+336+(e<<2)>>2]|0))p=64;else x=61;break}case 2:{e=o<<3|6;if(!(c[b+336+(e<<2)>>2]|0))p=64;else x=61;break}case 1:{h=b+400+((o<<3|6)<<8)|0;while(1){e=c[h>>2]|0;if((e|0)==64){p=64;break d}if((e>>3|0)==(l|0)){p=e;break}else h=h+4|0}break}default:{e=o<<3|6;x=61}}while(0);if((x|0)==61){x=0;p=c[b+400+(e<<8)>>2]|0}if((p>>3|0)!=(l|0))continue;h=o<<3|4;e=dj(g)|0;k=e&255;e=e&255;e:do switch(e|0){case 75:{e=n?63:7;if((e|0)==(p|0))continue c;while(1){if((c[b+(e<<2)>>2]|0)==(h|0))break e;e=e+-1|0;if((e|0)==(p|0))continue c}}case 81:{e=n?56:0;if((e|0)==(p|0))continue c;while(1){if((c[b+(e<<2)>>2]|0)==(h|0))break e;e=e+1|0;if((e|0)==(p|0))continue c}}default:{if((e+-65|0)>>>0>=8)continue c;e=(l<<3)+-65+e|0}}while(0);if((e|0)==(p|0))continue;m=(p|0)<(e|0);w=1<<((m&1|o<<1)^1);h=(c[D>>2]|0)+24|0;c[h>>2]=c[h>>2]|w;h=b+4824+(p<<2)|0;c[h>>2]=c[h>>2]|w;h=b+4824+(e<<2)|0;c[h>>2]=c[h>>2]|w;c[b+5080+(w<<2)>>2]=p;c[b+5144+(w<<2)>>2]=e;h=n?56:0;l=(m?5:3)|h;g=(l|0)>(e|0)?l:e;n=b+5208+(w<<3)|0;l=(l|0)<(e|0)?l:e;while(1){if(!((l|0)==(p|0)|(l|0)==(e|0))){u=26112+(l<<3)|0;t=n;v=c[t+4>>2]|c[u+4>>2];w=n;c[w>>2]=c[t>>2]|c[u>>2];c[w+4>>2]=v}if((l|0)<(g|0))l=l+1|0;else break}g=(m?6:2)|h;h=(g|0)>(p|0)?g:p;g=(g|0)<(p|0)?g:p;while(1){if(!((g|0)==(p|0)|(g|0)==(e|0))){u=26112+(g<<3)|0;t=n;v=c[t+4>>2]|c[u+4>>2];w=n;c[w>>2]=c[t>>2]|c[u>>2];c[w+4>>2]=v}if((g|0)<(h|0))g=g+1|0;else continue c}}km(B,H,0);do if(!(a[B>>0]|0))l=0;else{e=c[H+(c[(c[H>>2]|0)+-12>>2]|0)+24>>2]|0;k=e+12|0;h=c[k>>2]|0;if((h|0)==(c[e+16>>2]|0)){e=Fb[c[(c[e>>2]|0)+40>>2]&127](e)|0;if((e|0)==-1){l=H+(c[(c[H>>2]|0)+-12>>2]|0)|0;em(l,c[l+16>>2]|6);l=0;break}}else{c[k>>2]=h+1;e=d[h>>0]|0}l=e&255}while(0);e=c[H>>2]|0;do if((l+-97&255)<8?(c[H+(c[e+-12>>2]|0)+16>>2]&5|0)==0:0){km(B,H,0);do if(!(a[B>>0]|0))k=0;else{e=c[H+(c[(c[H>>2]|0)+-12>>2]|0)+24>>2]|0;k=e+12|0;h=c[k>>2]|0;if((h|0)==(c[e+16>>2]|0)){e=Fb[c[(c[e>>2]|0)+40>>2]&127](e)|0;if((e|0)==-1){k=H+(c[(c[H>>2]|0)+-12>>2]|0)|0;em(k,c[k+16>>2]|6);k=0;break}}else{c[k>>2]=h+1;e=d[h>>0]|0}k=e&255}while(0);e=c[H>>2]|0;if(!(c[H+(c[e+-12>>2]|0)+16>>2]&5)){u=c[z>>2]|0;w=(u|0)==0;if(w){if(k<<24>>24!=54){x=118;break}}else if(k<<24>>24!=51){x=118;break}h=(l&255)+-489+((k&255)<<3)|0;k=c[D>>2]|0;v=k+48|0;c[v>>2]=h;n=q;m=c[n>>2]|0;n=c[n+4>>2]|0;R=31552+(h<<3)|0;p=b+320|0;o=c[p>>2]|0;p=c[p+4>>2]|0;r=b+264|0;q=c[r>>2]|0;r=c[r+4>>2]|0;S=27456+(h<<3)|0;t=b+328|0;s=c[t>>2]|0;t=c[t+4>>2]|0;P=27968+(h<<3)|0;Q=b+272|0;O=24064+(h<<3)|0;N=24576+(h<<3)|0;N=(_(c[O+4>>2]&n,c[N+4>>2]|0)|0)^(_(c[O>>2]&m,c[N>>2]|0)|0);N=(c[1031004+(h<<2)>>2]|0)+(N>>>(c[1031260+(h<<2)>>2]|0)<<3)|0;O=b+288|0;L=b+296|0;U=c[L>>2]|0;L=c[L+4>>2]|0;M=25088+(h<<3)|0;K=25600+(h<<3)|0;K=(_(c[M+4>>2]&n,c[K+4>>2]|0)|0)^(_(c[M>>2]&m,c[K>>2]|0)|0);K=(c[1031516+(h<<2)>>2]|0)+(K>>>(c[1031772+(h<<2)>>2]|0)<<3)|0;M=b+280|0;l=30016+(h<<3)|0;J=b+304|0;T=b+320+(u<<3)|0;if(!((c[T>>2]&q&(c[S>>2]&q&s|o&c[R>>2]&q|c[Q>>2]&c[P>>2]|(U|c[O>>2])&c[N>>2]|(c[M>>2]|U)&c[K>>2]|c[J>>2]&c[l>>2])|0)==0?(c[T+4>>2]&r&(c[S+4>>2]&r&t|p&c[R+4>>2]&r|c[Q+4>>2]&c[P+4>>2]|(L|c[O+4>>2])&c[N+4>>2]|(c[M+4>>2]|L)&c[K+4>>2]|c[J+4>>2]&c[l+4>>2])|0)==0:0)?(T=b+320+((u^1)<<3)|0,y=(u|0)==1,U=26112+((y?8:-8)+h<<3)|0,!((c[T>>2]&q&c[U>>2]|0)==0?(c[T+4>>2]&r&c[U+4>>2]|0)==0:0)):0){l=26112+(h<<3)|0;h=c[l>>2]|0;l=c[l+4>>2]|0;if(!((h&m|0)==0&(l&n|0)==0)){c[v>>2]=64;break}if(w?(U=Zu(h|0,l|0,8)|0,!((U&m|0)==0&(C&n|0)==0)):0){c[v>>2]=64;break}if(y?(U=Yu(h|0,l|0,8)|0,!((U&m|0)==0&(C&n|0)==0)):0){c[v>>2]=64;break}if(w?(U=Yu(h|0,l|0,8)|0,(U&s&q|0)==0&(C&t&r|0)==0):0){c[v>>2]=64;break}if(!y)break;U=Zu(h|0,l|0,8)|0;if(!((U&o&q|0)==0&(C&p&r|0)==0))break;c[v>>2]=64;break}c[v>>2]=64}else x=118}else x=118;while(0);if((x|0)==118){k=c[D>>2]|0;c[k+48>>2]=64}c[k+36>>2]=0;c[k+40>>2]=0;U=H+(c[e+-12>>2]|0)+4|0;c[U>>2]=c[U>>2]|4096;km(B,H,0);do if(a[B>>0]|0){e=c[H+(c[(c[H>>2]|0)+-12>>2]|0)+24>>2]|0;k=e+12|0;h=c[k>>2]|0;if((h|0)==(c[e+16>>2]|0)){e=Fb[c[(c[e>>2]|0)+40>>2]&127](e)|0;if((e|0)==-1){U=H+(c[(c[H>>2]|0)+-12>>2]|0)|0;em(U,c[U+16>>2]|6);break}}else{c[k>>2]=h+1;e=d[h>>0]|0}g=e&255}while(0);if((c[A>>2]|0)==7?(qm(H)|0)==43:0){U=51-(g&255)|0;U=(U|0)>3?3:U;c[(c[D>>2]|0)+36>>2]=(U|0)<0?0:U;km(B,H,0);do if(a[B>>0]|0){e=c[H+(c[(c[H>>2]|0)+-12>>2]|0)+24>>2]|0;k=e+12|0;h=c[k>>2]|0;if((h|0)==(c[e+16>>2]|0)){e=Fb[c[(c[e>>2]|0)+40>>2]&127](e)|0;if((e|0)==-1){U=H+(c[(c[H>>2]|0)+-12>>2]|0)|0;em(U,c[U+16>>2]|6);break}}else{c[k>>2]=h+1;e=d[h>>0]|0}g=e&255}while(0);km(B,H,0);do if(!(a[B>>0]|0))e=g;else{e=c[H+(c[(c[H>>2]|0)+-12>>2]|0)+24>>2]|0;k=e+12|0;h=c[k>>2]|0;if((h|0)==(c[e+16>>2]|0)){e=Fb[c[(c[e>>2]|0)+40>>2]&127](e)|0;if((e|0)==-1){e=H+(c[(c[H>>2]|0)+-12>>2]|0)|0;em(e,c[e+16>>2]|6);e=g;break}}else{c[k>>2]=h+1;e=d[h>>0]|0}e=e&255}while(0);g=51-(e&255)|0;g=(g|0)>3?3:g;k=c[D>>2]|0;c[k+40>>2]=(g|0)<0?0:g;g=e}else{rm(H,g)|0;k=c[D>>2]|0}l=H+(c[(c[H>>2]|0)+-12>>2]|0)+4|0;c[l>>2]=c[l>>2]|4096;l=b+5344|0;om(om(H,k+28|0)|0,l)|0;if((c[A>>2]|0)!=7){T=c[l>>2]|0;T=T<<1;T=T+-2|0;U=(T|0)<0;T=U?0:T;U=c[z>>2]|0;U=(U|0)==1;U=U&1;U=T|U;c[l>>2]=U;U=b+5360|0;T=f&1;a[U>>0]=T;U=b+5352|0;c[U>>2]=j;U=c[D>>2]|0;Df(b,U);c[H>>2]=6636;c[F>>2]=6656;c[E>>2]=3544;vk(G);il(E);el(F);i=I;return b|0}km(B,H,0);do if(!(a[B>>0]|0))e=g;else{e=c[H+(c[(c[H>>2]|0)+-12>>2]|0)+24>>2]|0;k=e+12|0;h=c[k>>2]|0;if((h|0)==(c[e+16>>2]|0)){e=Fb[c[(c[e>>2]|0)+40>>2]&127](e)|0;if((e|0)==-1){e=H+(c[(c[H>>2]|0)+-12>>2]|0)|0;em(e,c[e+16>>2]|6);e=g;break}}else{c[k>>2]=h+1;e=d[h>>0]|0}e=e&255}while(0);if(!(e<<24>>24==43?(c[H+(c[(c[H>>2]|0)+-12>>2]|0)+16>>2]&5|0)==0:0)){T=c[l>>2]|0;T=T<<1;T=T+-2|0;U=(T|0)<0;T=U?0:T;U=c[z>>2]|0;U=(U|0)==1;U=U&1;U=T|U;c[l>>2]=U;U=b+5360|0;T=f&1;a[U>>0]=T;U=b+5352|0;c[U>>2]=j;U=c[D>>2]|0;Df(b,U);c[H>>2]=6636;c[F>>2]=6656;c[E>>2]=3544;vk(G);il(E);el(F);i=I;return b|0}km(B,H,0);do if(!(a[B>>0]|0))g=43;else{e=c[H+(c[(c[H>>2]|0)+-12>>2]|0)+24>>2]|0;k=e+12|0;h=c[k>>2]|0;if((h|0)==(c[e+16>>2]|0)){e=Fb[c[(c[e>>2]|0)+40>>2]&127](e)|0;if((e|0)==-1){g=H+(c[(c[H>>2]|0)+-12>>2]|0)|0;em(g,c[g+16>>2]|6);g=43;break}}else{c[k>>2]=h+1;e=d[h>>0]|0}g=e&255}while(0);U=(g&255)+-48|0;U=(U|0)>3?3:U;c[(c[D>>2]|0)+36>>2]=(U|0)<0?0:U;km(B,H,0);do if(a[B>>0]|0){e=c[H+(c[(c[H>>2]|0)+-12>>2]|0)+24>>2]|0;k=e+12|0;h=c[k>>2]|0;if((h|0)==(c[e+16>>2]|0)){e=Fb[c[(c[e>>2]|0)+40>>2]&127](e)|0;if((e|0)==-1){U=H+(c[(c[H>>2]|0)+-12>>2]|0)|0;em(U,c[U+16>>2]|6);break}}else{c[k>>2]=h+1;e=d[h>>0]|0}g=e&255}while(0);km(B,H,0);do if(!(a[B>>0]|0))e=g;else{e=c[H+(c[(c[H>>2]|0)+-12>>2]|0)+24>>2]|0;k=e+12|0;h=c[k>>2]|0;if((h|0)==(c[e+16>>2]|0)){e=Fb[c[(c[e>>2]|0)+40>>2]&127](e)|0;if((e|0)==-1){e=H+(c[(c[H>>2]|0)+-12>>2]|0)|0;em(e,c[e+16>>2]|6);e=g;break}}else{c[k>>2]=h+1;e=d[h>>0]|0}e=e&255}while(0);T=(e&255)+-48|0;T=(T|0)>3?3:T;c[(c[D>>2]|0)+40>>2]=(T|0)<0?0:T;T=c[l>>2]|0;T=T<<1;T=T+-2|0;U=(T|0)<0;T=U?0:T;U=c[z>>2]|0;U=(U|0)==1;U=U&1;U=T|U;c[l>>2]=U;U=b+5360|0;T=f&1;a[U>>0]=T;U=b+5352|0;c[U>>2]=j;U=c[D>>2]|0;Df(b,U);c[H>>2]=6636;c[F>>2]=6656;c[E>>2]=3544;vk(G);il(E);el(F);i=I;return b|0}function zf(a){a=a|0;var b=0,d=0;c[a>>2]=6636;b=a+60|0;c[b>>2]=6656;d=a+8|0;c[d>>2]=3544;vk(a+40|0);il(d);el(b);return}function Af(a){a=a|0;var b=0,d=0;c[a>>2]=6636;b=a+60|0;c[b>>2]=6656;d=a+8|0;c[d>>2]=3544;vk(a+40|0);il(d);el(b);mu(a);return}function Bf(a){a=a|0;var b=0,d=0;d=a+(c[(c[a>>2]|0)+-12>>2]|0)|0;c[d>>2]=6636;a=d+60|0;c[a>>2]=6656;b=d+8|0;c[b>>2]=3544;vk(d+40|0);il(b);el(a);return}function Cf(a){a=a|0;var b=0,d=0;a=a+(c[(c[a>>2]|0)+-12>>2]|0)|0;c[a>>2]=6636;b=a+60|0;c[b>>2]=6656;d=a+8|0;c[d>>2]=3544;vk(a+40|0);il(d);el(b);mu(a);return}function Df(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0;k=b+8|0;m=k;c[m>>2]=0;c[m+4>>2]=0;m=b+56|0;l=m;c[l>>2]=0;c[l+4>>2]=0;l=a+5364|0;j=981536+(c[l>>2]<<3)|0;g=c[j+4>>2]|0;i=m;c[i>>2]=c[j>>2];c[i+4>>2]=g;i=981528;g=c[i+4>>2]|0;j=b;c[j>>2]=c[i>>2];c[j+4>>2]=g;c[b+20>>2]=0;c[b+16>>2]=0;j=b+44|0;c[j>>2]=0;Ef(a,b);g=c[l>>2]|0;a:do switch(g|0){case 6:{d=c[a+5348>>2]<<3;if((c[a+400+((d|6)<<8)>>2]&-8|0)==56){e=0;d=0}else{e=0;d=c[26112+(c[a+400+((d^14)<<8)>>2]<<3)+4>>2]&-16777216}i=b+64|0;c[i>>2]=e;c[i+4>>2]=d;break}case 4:{if(!(c[a+336+((c[a+5348>>2]<<3|6)<<2)>>2]|0)){i=b+64|0;c[i>>2]=0;c[i+4>>2]=0}else h=7;break}case 1:{i=b+64|0;c[i>>2]=0;c[i+4>>2]=0;break}case 2:{f=c[a+5348>>2]|0;d=f<<3|6;if(c[a+336+(d<<2)>>2]|0?(e=c[a+400+(d<<8)>>2]|0,(e|0)!=64):0){e=30016+(e<<3)|0;d=f<<3^14;if(!(c[a+336+(d<<2)>>2]|0))d=64;else d=c[a+400+(d<<8)>>2]|0;i=26112+(d<<3)|0;if((c[i>>2]&c[e>>2]|0)==0?(c[i+4>>2]&c[e+4>>2]|0)==0:0){e=f;h=15;break a}}i=b+64|0;c[i>>2]=0;c[i+4>>2]=0;break}default:h=7}while(0);if((h|0)==7){e=c[a+5348>>2]|0;h=15}if((h|0)==15){switch(g|0){case 4:{d=e<<3|6;if(!(c[a+336+(d<<2)>>2]|0))d=64;else h=19;break}case 2:{d=e<<3|6;if(!(c[a+336+(d<<2)>>2]|0))d=64;else h=19;break}case 1:{d=64;break}default:{d=e<<3|6;h=19}}if((h|0)==19)d=c[a+400+(d<<8)>>2]|0;g=a+256|0;p=c[g>>2]|0;g=c[g+4>>2]|0;v=31552+(d<<3)|0;w=a+320|0;i=a+264|0;u=c[i>>2]|0;i=c[i+4>>2]|0;y=27456+(d<<3)|0;x=a+328|0;s=27968+(d<<3)|0;t=a+272|0;r=24064+(d<<3)|0;q=24576+(d<<3)|0;q=(_(c[r+4>>2]&g,c[q+4>>2]|0)|0)^(_(c[r>>2]&p,c[q>>2]|0)|0);q=(c[1031004+(d<<2)>>2]|0)+(q>>>(c[1031260+(d<<2)>>2]|0)<<3)|0;r=a+288|0;h=a+296|0;o=c[h>>2]|0;h=c[h+4>>2]|0;f=25088+(d<<3)|0;n=25600+(d<<3)|0;n=(_(c[f+4>>2]&g,c[n+4>>2]|0)|0)^(_(c[f>>2]&p,c[n>>2]|0)|0);n=(c[1031516+(d<<2)>>2]|0)+(n>>>(c[1031772+(d<<2)>>2]|0)<<3)|0;p=a+280|0;f=30016+(d<<3)|0;d=a+304|0;g=a+320+((e^1)<<3)|0;h=(c[y+4>>2]&i&c[x+4>>2]|c[w+4>>2]&c[v+4>>2]&i|c[t+4>>2]&c[s+4>>2]|(h|c[r+4>>2])&c[q+4>>2]|(c[p+4>>2]|h)&c[n+4>>2]|c[d+4>>2]&c[f+4>>2])&c[g+4>>2];i=b+64|0;c[i>>2]=(c[y>>2]&u&c[x>>2]|c[w>>2]&c[v>>2]&u|c[t>>2]&c[s>>2]|(o|c[r>>2])&c[q>>2]|(c[p>>2]|o)&c[n>>2]|c[d>>2]&c[f>>2])&c[g>>2];c[i+4>>2]=h}e=a+256|0;d=c[e>>2]|0;e=c[e+4>>2]|0;if(!((d|0)==0&(e|0)==0)){i=c[l>>2]|0;g=m;f=c[g>>2]|0;g=c[g+4>>2]|0;h=c[j>>2]|0;do{y=hb(d|0,e|0,0)|0;x=Xu(d|0,e|0,-1,-1)|0;d=x&d;e=C&e;x=c[a+(y<<2)>>2]|0;w=973136+(x<<9)+(y<<3)|0;f=f^c[w>>2];g=g^c[w+4>>2];w=m;c[w>>2]=f;c[w+4>>2]=g;h=h+(c[1035344+(i*4160|0)+(x*260|0)+(y<<2)>>2]|0)|0;c[j>>2]=h}while(!((d|0)==0&(e|0)==0))}if((c[l>>2]|0)==3){y=_(c[262085]|0,c[a+4500>>2]|0)|0;y=(c[j>>2]|0)+y|0;c[j>>2]=y;y=y+(_(c[262150]|0,c[a+4504>>2]|0)|0)|0;c[j>>2]=y;y=y+(_(c[262215]|0,c[a+4508>>2]|0)|0)|0;c[j>>2]=y;y=y+(_(c[262280]|0,c[a+4512>>2]|0)|0)|0;c[j>>2]=y;y=y+(_(c[262345]|0,c[a+4516>>2]|0)|0)|0;c[j>>2]=y;y=y+(_(c[262410]|0,c[a+4520>>2]|0)|0)|0;c[j>>2]=y;y=y+(_(c[262605]|0,c[a+4532>>2]|0)|0)|0;c[j>>2]=y;y=y+(_(c[262670]|0,c[a+4536>>2]|0)|0)|0;c[j>>2]=y;y=y+(_(c[262735]|0,c[a+4540>>2]|0)|0)|0;c[j>>2]=y;y=y+(_(c[262800]|0,c[a+4544>>2]|0)|0)|0;c[j>>2]=y;y=y+(_(c[262865]|0,c[a+4548>>2]|0)|0)|0;c[j>>2]=y;c[j>>2]=y+(_(c[262930]|0,c[a+4552>>2]|0)|0)}d=c[b+48>>2]|0;if((d|0)!=64){w=981328+((d&7)<<3)|0;v=m;x=c[v+4>>2]^c[w+4>>2];y=m;c[y>>2]=c[v>>2]^c[w>>2];c[y+4>>2]=x}if((c[a+5348>>2]|0)==1){e=981520;y=m;d=c[y>>2]^c[e>>2];e=c[y+4>>2]^c[e+4>>2];y=m;c[y>>2]=d;c[y+4>>2]=e}else{e=m;d=c[e>>2]|0;e=c[e+4>>2]|0}x=981392+(c[b+24>>2]<<3)|0;y=e^c[x+4>>2];e=m;c[e>>2]=d^c[x>>2];c[e+4>>2]=y;e=a+264|0;d=c[e>>2]|0;e=c[e+4>>2]|0;if(!((d|0)==0&(e|0)==0)){g=b;f=c[g>>2]|0;g=c[g+4>>2]|0;do{y=hb(d|0,e|0,0)|0;x=Xu(d|0,e|0,-1,-1)|0;d=x&d;e=C&e;y=973136+(c[a+(y<<2)>>2]<<9)+(y<<3)|0;f=f^c[y>>2];g=g^c[y+4>>2];y=b;c[y>>2]=f;c[y+4>>2]=g}while(!((d|0)==0&(e|0)==0))}b:do if((c[l>>2]|0)==3){i=6680;while(1){d=c[i>>2]|0;e=d&7;switch(e|0){case 1:case 6:break;default:{y=b+16+(d>>3<<2)|0;c[y>>2]=(_(c[6728+(d<<2)>>2]|0,c[a+336+(d<<2)>>2]|0)|0)+(c[y>>2]|0)}}h=c[a+336+(d<<2)>>2]|0;if((h|0)>0){g=k;f=c[g>>2]|0;g=c[g+4>>2]|0;j=0;do{y=973136+(d<<9)+(j<<3)|0;f=f^c[y>>2];g=g^c[y+4>>2];y=k;c[y>>2]=f;c[y+4>>2]=g;j=j+1|0}while((j|0)<(h|0))}switch(e|0){case 1:case 6:break;default:{x=d>>3;y=b+16+(x<<2)|0;c[y>>2]=(_(c[6728+(d<<2)>>2]|0,c[a+4496+(x<<5)+(e<<2)>>2]|0)|0)+(c[y>>2]|0)}}w=981600+(d*136|0)+(c[a+4496+(d>>3<<5)+(e<<2)>>2]<<3)|0;v=m;x=c[v+4>>2]^c[w+4>>2];y=m;c[y>>2]=c[v>>2]^c[w>>2];c[y+4>>2]=x;i=i+4|0;if((i|0)==6728)break b}}else{h=6680;while(1){d=c[h>>2]|0;switch(d&7|0){case 1:case 6:break;default:{y=b+16+(d>>3<<2)|0;c[y>>2]=(_(c[6728+(d<<2)>>2]|0,c[a+336+(d<<2)>>2]|0)|0)+(c[y>>2]|0)}}e=c[a+336+(d<<2)>>2]|0;if((e|0)>0){g=k;f=c[g>>2]|0;g=c[g+4>>2]|0;i=0;do{y=973136+(d<<9)+(i<<3)|0;f=f^c[y>>2];g=g^c[y+4>>2];y=k;c[y>>2]=f;c[y+4>>2]=g;i=i+1|0}while((i|0)<(e|0))}h=h+4|0;if((h|0)==6728)break b}}while(0);if((c[l>>2]|0)!=7)return;x=983776+(c[b+36>>2]<<3)|0;w=m;v=c[w>>2]^c[x>>2];x=c[w+4>>2]^c[x+4>>2];w=m;c[w>>2]=v;c[w+4>>2]=x;w=983808+(c[b+40>>2]<<3)|0;x=x^c[w+4>>2];y=m;c[y>>2]=v^c[w>>2];c[y+4>>2]=x;return}function Ef(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;s=c[a+5364>>2]|0;a:do if((s|0)==1){a=b+344|0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0}else{e=a+328|0;d=c[e>>2]|0;e=c[e+4>>2]|0;switch(s|0){case 4:{if(!(c[a+360>>2]|0))k=64;else q=6;break}case 2:{if(!(c[a+360>>2]|0))k=64;else q=6;break}default:q=6}if((q|0)==6)k=c[a+1936>>2]|0;n=b+360|0;r=n;c[r>>2]=0;c[r+4>>2]=0;r=(s|0)==4|(s|0)==2;b:do if((k|0)==64&r){e=0;d=0}else{f=109888+(k<<3)|0;j=a+296|0;g=c[j>>2]|0;j=c[j+4>>2]|0;i=a+288|0;h=109376+(k<<3)|0;t=a+280|0;o=a+256|0;p=a+(k<<2)|0;l=0;m=0;g=((c[t>>2]|g)&c[h>>2]|(c[i>>2]|g)&c[f>>2])&d;f=((c[t+4>>2]|j)&c[h+4>>2]|(c[i+4>>2]|j)&c[f+4>>2])&e;e=0;d=0;while(1){while(1){do{if((g|0)==0&(f|0)==0)break b;j=hb(g|0,f|0,0)|0;i=Xu(g|0,f|0,-1,-1)|0;g=i&g;f=C&f;i=35136+(k<<9)+(j<<3)|0;t=o;h=c[t>>2]&c[i>>2];i=c[t+4>>2]&c[i+4>>2];t=Xu(h|0,i|0,-1,-1)|0}while(!((t&h|0)==0&(C&i|0)==0));e=h|e;d=i|d;t=a+320+(c[p>>2]>>3<<3)|0;if(!((c[t>>2]&h|0)==0?(c[t+4>>2]&i|0)==0:0)){h=j;break}}t=26112+(h<<3)|0;j=c[t>>2]|l;t=c[t+4>>2]|m;i=n;c[i>>2]=j;c[i+4>>2]=t;l=j;m=t}}while(0);t=b+344|0;c[t>>2]=e;c[t+4>>2]=d;e=a+320|0;d=c[e>>2]|0;e=c[e+4>>2]|0;switch(s|0){case 4:{if(!(c[a+392>>2]|0))p=64;else q=18;break}case 2:{if(!(c[a+392>>2]|0))p=64;else q=18;break}case 1:{p=64;break}default:q=18}if((q|0)==18)p=c[a+3984>>2]|0;o=b+368|0;t=o;c[t>>2]=0;c[t+4>>2]=0;c:do if((p|0)==64&r){e=0;d=0}else{f=109888+(p<<3)|0;t=a+296|0;g=c[t>>2]|0;t=c[t+4>>2]|0;r=a+288|0;q=109376+(p<<3)|0;j=a+280|0;k=a+256|0;l=a+(p<<2)|0;m=0;n=0;g=((c[j>>2]|g)&c[q>>2]|(c[r>>2]|g)&c[f>>2])&d;f=((c[j+4>>2]|t)&c[q+4>>2]|(c[r+4>>2]|t)&c[f+4>>2])&e;e=0;d=0;while(1){while(1){do{if((g|0)==0&(f|0)==0)break c;i=hb(g|0,f|0,0)|0;j=Xu(g|0,f|0,-1,-1)|0;g=j&g;f=C&f;j=35136+(p<<9)+(i<<3)|0;t=k;h=c[t>>2]&c[j>>2];j=c[t+4>>2]&c[j+4>>2];t=Xu(h|0,j|0,-1,-1)|0}while(!((t&h|0)==0&(C&j|0)==0));e=h|e;d=j|d;t=a+320+(c[l>>2]>>3<<3)|0;if(!((c[t>>2]&h|0)==0?(c[t+4>>2]&j|0)==0:0)){h=i;break}}t=26112+(h<<3)|0;r=c[t>>2]|m;t=c[t+4>>2]|n;q=o;c[q>>2]=r;c[q+4>>2]=t;m=r;n=t}}while(0);t=b+352|0;c[t>>2]=e;c[t+4>>2]=d;e=c[a+5348>>2]|0;d=e^1;switch(s|0){case 1:break a;case 4:{d=d<<3|6;if(!(c[a+336+(d<<2)>>2]|0))d=64;else d=c[a+400+(d<<8)>>2]|0;if(!(c[a+336+((e<<3^14)<<2)>>2]|0)){d=b+384|0;e=d+48|0;do{c[d>>2]=0;d=d+4|0}while((d|0)<(e|0));return}break}case 2:{d=d<<3|6;if(!(c[a+336+(d<<2)>>2]|0))d=64;else d=c[a+400+(d<<8)>>2]|0;if((d|0)==64){d=b+384|0;e=d+48|0;do{c[d>>2]=0;d=d+4|0}while((d|0)<(e|0));return}break}default:d=c[a+400+((d<<3|6)<<8)>>2]|0}r=26944+((e<<3^9)<<9)+(d<<3)|0;q=c[r+4>>2]|0;t=b+384|0;c[t>>2]=c[r>>2];c[t+4>>2]=q;t=27968+(d<<3)|0;q=c[t+4>>2]|0;r=b+392|0;c[r>>2]=c[t>>2];c[r+4>>2]=q;r=a+256|0;q=r;t=25088+(d<<3)|0;s=25600+(d<<3)|0;s=(_(c[t+4>>2]&c[q+4>>2],c[s+4>>2]|0)|0)^(_(c[t>>2]&c[q>>2],c[s>>2]|0)|0);s=(c[1031516+(d<<2)>>2]|0)+(s>>>(c[1031772+(d<<2)>>2]|0)<<3)|0;q=c[s>>2]|0;s=c[s+4>>2]|0;t=b+400|0;c[t>>2]=q;c[t+4>>2]=s;t=24064+(d<<3)|0;a=24576+(d<<3)|0;a=(_(c[t+4>>2]&c[r+4>>2],c[a+4>>2]|0)|0)^(_(c[t>>2]&c[r>>2],c[a>>2]|0)|0);a=(c[1031004+(d<<2)>>2]|0)+(a>>>(c[1031260+(d<<2)>>2]|0)<<3)|0;r=c[a>>2]|0;a=c[a+4>>2]|0;t=b+408|0;c[t>>2]=r;c[t+4>>2]=a;t=b+416|0;c[t>>2]=q|r;c[t+4>>2]=s|a;t=b+424|0;c[t>>2]=0;c[t+4>>2]=0;return}while(0);d=b+384|0;e=d+48|0;do{c[d>>2]=0;d=d+4|0}while((d|0)<(e|0));return}function Ff(){var a=0,b=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0;b=1070372;a=0;f=6680;do{e=c[f>>2]|0;d=0;do{j=Yu(b|0,a|0,12)|0;b=j^b;a=C^a;j=Zu(b|0,a|0,25)|0;b=j^b;a=C^a;j=Yu(b|0,a|0,27)|0;b=j^b;a=C^a;j=hv(b|0,a|0,1332534557,625341585)|0;k=973136+(e<<9)+(d<<3)|0;c[k>>2]=j;c[k+4>>2]=C;d=d+1|0}while((d|0)!=64);f=f+4|0}while((f|0)!=6728);e=Yu(b|0,a|0,12)|0;b=e^b;a=C^a;e=Zu(b|0,a|0,25)|0;b=e^b;a=C^a;e=Yu(b|0,a|0,27)|0;b=e^b;a=C^a;e=hv(b|0,a|0,1332534557,625341585)|0;k=981328;c[k>>2]=e;c[k+4>>2]=C;k=Yu(b|0,a|0,12)|0;b=k^b;a=C^a;k=Zu(b|0,a|0,25)|0;b=k^b;a=C^a;k=Yu(b|0,a|0,27)|0;b=k^b;a=C^a;k=hv(b|0,a|0,1332534557,625341585)|0;e=981336;c[e>>2]=k;c[e+4>>2]=C;e=Yu(b|0,a|0,12)|0;b=e^b;a=C^a;e=Zu(b|0,a|0,25)|0;b=e^b;a=C^a;e=Yu(b|0,a|0,27)|0;b=e^b;a=C^a;e=hv(b|0,a|0,1332534557,625341585)|0;k=981344;c[k>>2]=e;c[k+4>>2]=C;k=Yu(b|0,a|0,12)|0;b=k^b;a=C^a;k=Zu(b|0,a|0,25)|0;b=k^b;a=C^a;k=Yu(b|0,a|0,27)|0;b=k^b;a=C^a;k=hv(b|0,a|0,1332534557,625341585)|0;e=981352;c[e>>2]=k;c[e+4>>2]=C;e=Yu(b|0,a|0,12)|0;b=e^b;a=C^a;e=Zu(b|0,a|0,25)|0;b=e^b;a=C^a;e=Yu(b|0,a|0,27)|0;b=e^b;a=C^a;e=hv(b|0,a|0,1332534557,625341585)|0;k=981360;c[k>>2]=e;c[k+4>>2]=C;k=Yu(b|0,a|0,12)|0;b=k^b;a=C^a;k=Zu(b|0,a|0,25)|0;b=k^b;a=C^a;k=Yu(b|0,a|0,27)|0;b=k^b;a=C^a;k=hv(b|0,a|0,1332534557,625341585)|0;e=981368;c[e>>2]=k;c[e+4>>2]=C;e=Yu(b|0,a|0,12)|0;b=e^b;a=C^a;e=Zu(b|0,a|0,25)|0;b=e^b;a=C^a;e=Yu(b|0,a|0,27)|0;b=e^b;a=C^a;e=hv(b|0,a|0,1332534557,625341585)|0;k=981376;c[k>>2]=e;c[k+4>>2]=C;k=Yu(b|0,a|0,12)|0;b=k^b;a=C^a;k=Zu(b|0,a|0,25)|0;b=k^b;a=C^a;k=Yu(b|0,a|0,27)|0;b=k^b;a=C^a;k=hv(b|0,a|0,1332534557,625341585)|0;e=981384;c[e>>2]=k;c[e+4>>2]=C;e=0;do{while(1){d=981392+(e<<3)|0;k=d;c[k>>2]=0;c[k+4>>2]=0;if(!e)e=1;else break}j=e;k=((e|0)<0)<<31>>31;h=0;i=0;do{g=hb(j|0,k|0,0)|0;f=Xu(j|0,k|0,-1,-1)|0;j=f&j;k=C&k;g=Zu(1,0,g|0)|0;g=981392+(g<<3)|0;f=c[g>>2]|0;g=c[g+4>>2]|0;if((f|0)==0&(g|0)==0){f=Yu(b|0,a|0,12)|0;b=f^b;a=C^a;f=Zu(b|0,a|0,25)|0;b=f^b;a=C^a;f=Yu(b|0,a|0,27)|0;b=f^b;a=C^a;f=hv(b|0,a|0,1332534557,625341585)|0;g=C}h=h^f;i=i^g;g=d;c[g>>2]=h;c[g+4>>2]=i}while(!((j|0)==0&(k|0)==0));e=e+1|0}while((e|0)!=16);d=Yu(b|0,a|0,12)|0;d=d^b;b=C^a;k=Zu(d|0,b|0,25)|0;d=k^d;b=C^b;k=Yu(d|0,b|0,27)|0;d=k^d;b=C^b;k=hv(d|0,b|0,1332534557,625341585)|0;a=981520;c[a>>2]=k;c[a+4>>2]=C;a=Yu(d|0,b|0,12)|0;d=a^d;b=C^b;a=Zu(d|0,b|0,25)|0;d=a^d;b=C^b;a=Yu(d|0,b|0,27)|0;d=a^d;b=C^b;a=hv(d|0,b|0,1332534557,625341585)|0;k=981528;c[k>>2]=a;c[k+4>>2]=C;k=981536;c[k>>2]=0;c[k+4>>2]=0;k=Yu(d|0,b|0,12)|0;d=k^d;b=C^b;k=Zu(d|0,b|0,25)|0;d=k^d;b=C^b;k=Yu(d|0,b|0,27)|0;d=k^d;b=C^b;k=hv(d|0,b|0,1332534557,625341585)|0;a=981544;c[a>>2]=k;c[a+4>>2]=C;a=Yu(d|0,b|0,12)|0;d=a^d;b=C^b;a=Zu(d|0,b|0,25)|0;d=a^d;b=C^b;a=Yu(d|0,b|0,27)|0;d=a^d;b=C^b;a=hv(d|0,b|0,1332534557,625341585)|0;k=981552;c[k>>2]=a;c[k+4>>2]=C;k=Yu(d|0,b|0,12)|0;d=k^d;b=C^b;k=Zu(d|0,b|0,25)|0;d=k^d;b=C^b;k=Yu(d|0,b|0,27)|0;d=k^d;b=C^b;k=hv(d|0,b|0,1332534557,625341585)|0;a=981560;c[a>>2]=k;c[a+4>>2]=C;a=Yu(d|0,b|0,12)|0;d=a^d;b=C^b;a=Zu(d|0,b|0,25)|0;d=a^d;b=C^b;a=Yu(d|0,b|0,27)|0;d=a^d;b=C^b;a=hv(d|0,b|0,1332534557,625341585)|0;k=981568;c[k>>2]=a;c[k+4>>2]=C;k=Yu(d|0,b|0,12)|0;d=k^d;b=C^b;k=Zu(d|0,b|0,25)|0;d=k^d;b=C^b;k=Yu(d|0,b|0,27)|0;d=k^d;b=C^b;k=hv(d|0,b|0,1332534557,625341585)|0;a=981576;c[a>>2]=k;c[a+4>>2]=C;a=Yu(d|0,b|0,12)|0;d=a^d;b=C^b;a=Zu(d|0,b|0,25)|0;d=a^d;b=C^b;a=Yu(d|0,b|0,27)|0;d=a^d;b=C^b;a=hv(d|0,b|0,1332534557,625341585)|0;k=981584;c[k>>2]=a;c[k+4>>2]=C;k=Yu(d|0,b|0,12)|0;d=k^d;b=C^b;k=Zu(d|0,b|0,25)|0;d=k^d;b=C^b;k=Yu(d|0,b|0,27)|0;d=k^d;b=C^b;k=hv(d|0,b|0,1332534557,625341585)|0;a=981592;c[a>>2]=k;c[a+4>>2]=C;a=Yu(d|0,b|0,12)|0;d=a^d;b=C^b;a=Zu(d|0,b|0,25)|0;d=a^d;b=C^b;a=Yu(d|0,b|0,27)|0;d=a^d;b=C^b;a=hv(d|0,b|0,1332534557,625341585)|0;k=983776;c[k>>2]=a;c[k+4>>2]=C;k=Yu(d|0,b|0,12)|0;d=k^d;b=C^b;k=Zu(d|0,b|0,25)|0;d=k^d;b=C^b;k=Yu(d|0,b|0,27)|0;d=k^d;b=C^b;k=hv(d|0,b|0,1332534557,625341585)|0;a=983784;c[a>>2]=k;c[a+4>>2]=C;a=Yu(d|0,b|0,12)|0;d=a^d;b=C^b;a=Zu(d|0,b|0,25)|0;d=a^d;b=C^b;a=Yu(d|0,b|0,27)|0;d=a^d;b=C^b;a=hv(d|0,b|0,1332534557,625341585)|0;k=983792;c[k>>2]=a;c[k+4>>2]=C;k=Yu(d|0,b|0,12)|0;d=k^d;b=C^b;k=Zu(d|0,b|0,25)|0;d=k^d;b=C^b;k=Yu(d|0,b|0,27)|0;d=k^d;b=C^b;k=hv(d|0,b|0,1332534557,625341585)|0;a=983800;c[a>>2]=k;c[a+4>>2]=C;a=Yu(d|0,b|0,12)|0;d=a^d;b=C^b;a=Zu(d|0,b|0,25)|0;d=a^d;b=C^b;a=Yu(d|0,b|0,27)|0;d=a^d;b=C^b;a=hv(d|0,b|0,1332534557,625341585)|0;k=983808;c[k>>2]=a;c[k+4>>2]=C;k=Yu(d|0,b|0,12)|0;d=k^d;b=C^b;k=Zu(d|0,b|0,25)|0;d=k^d;b=C^b;k=Yu(d|0,b|0,27)|0;d=k^d;b=C^b;k=hv(d|0,b|0,1332534557,625341585)|0;a=983816;c[a>>2]=k;c[a+4>>2]=C;a=Yu(d|0,b|0,12)|0;d=a^d;b=C^b;a=Zu(d|0,b|0,25)|0;d=a^d;b=C^b;a=Yu(d|0,b|0,27)|0;d=a^d;b=C^b;a=hv(d|0,b|0,1332534557,625341585)|0;k=983824;c[k>>2]=a;c[k+4>>2]=C;k=Yu(d|0,b|0,12)|0;d=k^d;b=C^b;k=Zu(d|0,b|0,25)|0;d=k^d;b=C^b;k=Yu(d|0,b|0,27)|0;d=k^d;b=C^b;k=hv(d|0,b|0,1332534557,625341585)|0;a=983832;c[a>>2]=k;c[a+4>>2]=C;a=6680;do{f=c[a>>2]|0;e=0;do{j=Yu(d|0,b|0,12)|0;d=j^d;b=C^b;j=Zu(d|0,b|0,25)|0;d=j^d;b=C^b;j=Yu(d|0,b|0,27)|0;d=j^d;b=C^b;j=hv(d|0,b|0,1332534557,625341585)|0;k=981600+(f*136|0)+(e<<3)|0;c[k>>2]=j;c[k+4>>2]=C;e=e+1|0}while((e|0)!=17);a=a+4|0}while((a|0)!=6728);return}function Gf(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;o=f;c[o>>2]=0;c[o+4>>2]=0;o=c[a+5364>>2]|0;if((e|0)==64&((o|0)==4|(o|0)==2)){e=0;a=0;C=e;return a|0}h=109888+(e<<3)|0;k=a+296|0;g=c[k>>2]|0;k=c[k+4>>2]|0;j=a+288|0;i=109376+(e<<3)|0;p=a+280|0;n=a+256|0;o=a+(e<<2)|0;l=0;m=0;g=((c[p>>2]|g)&c[i>>2]|(c[j>>2]|g)&c[h>>2])&b;h=((c[p+4>>2]|k)&c[i+4>>2]|(c[j+4>>2]|k)&c[h+4>>2])&d;b=0;d=0;a:while(1){do{do{if((g|0)==0&(h|0)==0)break a;i=hb(g|0,h|0,0)|0;j=Xu(g|0,h|0,-1,-1)|0;g=j&g;h=C&h;j=35136+(e<<9)+(i<<3)|0;p=n;k=c[p>>2]&c[j>>2];j=c[p+4>>2]&c[j+4>>2];p=Xu(k|0,j|0,-1,-1)|0}while(!((p&k|0)==0&(C&j|0)==0));b=k|b;d=j|d;p=a+320+(c[o>>2]>>3<<3)|0}while((c[p>>2]&k|0)==0?(c[p+4>>2]&j|0)==0:0);p=26112+(i<<3)|0;k=l|c[p>>2];p=m|c[p+4>>2];j=f;c[j>>2]=k;c[j+4>>2]=p;l=k;m=p}C=d;return b|0}function Hf(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;r=i;i=i+96|0;q=r+64|0;p=r+48|0;k=r+36|0;l=r+24|0;m=r+12|0;n=r;tk(q,d,(Jk(d,118,0)|0)+1|0,-1,d);o=q+12|0;tk(o,d,0,Jk(d,118,0)|0,d);j=q+(e*12|0)|0;d=a[j>>0]|0;if(!(d&1)){h=j+1|0;e=((d&255)>>>1)+(j+1)|0;d=j+1|0}else{d=c[q+(e*12|0)+8>>2]|0;h=d;e=d+(c[q+(e*12|0)+4>>2]|0)|0}if((h|0)!=(e|0))while(1){a[d>>0]=aj(a[h>>0]|0)|0;h=h+1|0;if((h|0)==(e|0))break;else d=d+1|0}j=a[q>>0]|0;h=(j&1)==0;j=h?(j&255)>>>1:c[q+4>>2]|0;c[n>>2]=0;c[n+4>>2]=0;c[n+8>>2]=0;Mk(n,h?q+1|0:c[q+8>>2]|0,j,j+1|0);Gk(n,56-j&255);j=Fk(n,16291)|0;c[m>>2]=c[j>>2];c[m+4>>2]=c[j+4>>2];c[m+8>>2]=c[j+8>>2];c[j>>2]=0;c[j+4>>2]=0;c[j+8>>2]=0;j=a[o>>0]|0;h=(j&1)==0;e=q+16|0;j=Ek(m,h?o+1|0:c[q+20>>2]|0,h?(j&255)>>>1:c[e>>2]|0)|0;c[l>>2]=c[j>>2];c[l+4>>2]=c[j+4>>2];c[l+8>>2]=c[j+8>>2];c[j>>2]=0;c[j+4>>2]=0;c[j+8>>2]=0;o=a[o>>0]|0;Gk(l,56-((o&1)==0?(o&255)>>>1:c[e>>2]|0)&255);c[k>>2]=c[l>>2];c[k+4>>2]=c[l+4>>2];c[k+8>>2]=c[l+8>>2];c[l>>2]=0;c[l+4>>2]=0;c[l+8>>2]=0;o=Fk(k,16305)|0;c[p>>2]=c[o>>2];c[p+4>>2]=c[o+4>>2];c[p+8>>2]=c[o+8>>2];c[o>>2]=0;c[o+4>>2]=0;c[o+8>>2]=0;vk(k);vk(l);vk(m);vk(n);f=yf(b,p,0,f,g,0)|0;vk(p);vk(q+12|0);vk(q);i=r;return f|0}function If(a){a=a|0;var b=0;b=c[a+5356>>2]|0;if((c[a+5364>>2]|0)==4)b=c[b+16+(((c[a+360>>2]|0)==0&1)<<2)>>2]<<1;else b=(c[b+20>>2]|0)+(c[b+16>>2]|0)|0;a=(b|0)>15258?15258:b;return ((((a|0)>3915?a:3915)<<7)+-501120|0)/11343|0|0}function Jf(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;l=31552+(b<<3)|0;m=a+320|0;q=a+264|0;k=c[q>>2]|0;q=c[q+4>>2]|0;o=27456+(b<<3)|0;n=a+328|0;i=27968+(b<<3)|0;j=a+272|0;h=24064+(b<<3)|0;g=24576+(b<<3)|0;g=(_(c[h+4>>2]&e,c[g+4>>2]|0)|0)^(_(c[h>>2]&d,c[g>>2]|0)|0);g=(c[1031004+(b<<2)>>2]|0)+(g>>>(c[1031260+(b<<2)>>2]|0)<<3)|0;h=a+288|0;p=a+296|0;f=c[p>>2]|0;p=c[p+4>>2]|0;s=25088+(b<<3)|0;r=25600+(b<<3)|0;e=(_(c[s+4>>2]&e,c[r+4>>2]|0)|0)^(_(c[s>>2]&d,c[r>>2]|0)|0);e=(c[1031516+(b<<2)>>2]|0)+(e>>>(c[1031772+(b<<2)>>2]|0)<<3)|0;d=a+280|0;b=30016+(b<<3)|0;a=a+304|0;C=c[o+4>>2]&q&c[n+4>>2]|c[m+4>>2]&c[l+4>>2]&q|c[j+4>>2]&c[i+4>>2]|(p|c[h+4>>2])&c[g+4>>2]|(c[d+4>>2]|p)&c[e+4>>2]|c[a+4>>2]&c[b+4>>2];return c[o>>2]&k&c[n>>2]|c[m>>2]&c[l>>2]&k|c[j>>2]&c[i>>2]|(f|c[h>>2])&c[g>>2]|(c[d>>2]|f)&c[e>>2]|c[a>>2]&c[b>>2]|0}function Kf(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0;o=c[a+5348>>2]|0;j=(b&131072|0)==0;k=b>>>6&63;q=j?k:64;n=c[a+5364>>2]|0;a:do switch(n|0){case 6:{if(Lf(a,b)|0){a=0;return a|0}else d=0;break}case 4:{if(!(c[a+336+((o<<3|6)<<2)>>2]|0)){a=1;return a|0}else d=0;break}case 1:{a=1;return a|0}default:{h=(n|0)==2;if(h){d=o<<3|6;if(!(c[a+336+(d<<2)>>2]|0))m=64;else m=c[a+400+(d<<8)>>2]|0;i=b&63;f=b&180224;g=(f|0)==32768;f=g|((f|0)!=49152?(c[a+(i<<2)>>2]|0)!=0:0);if(f?(A=30016+(i<<3)|0,z=26112+(m<<3)|0,!((c[z>>2]&c[A>>2]|0)==0?(c[z+4>>2]&c[A+4>>2]|0)==0:0)):0){a=0;return a|0}l=o^1;d=l<<3|6;if(!(c[a+336+(d<<2)>>2]|0))d=64;else d=c[a+400+(d<<8)>>2]|0;e=30016+(d<<3)|0;d=c[e>>2]|0;e=c[e+4>>2]|0;if((c[a+(q<<2)>>2]&7|0)==6){A=26112+(i<<3)|0;if((c[A>>2]&d|0)==0?(c[A+4>>2]&e|0)==0:0){d=h;break a}else d=1;return d|0}A=26112+(m<<3)|0;if(!((c[A>>2]&d|0)==0?(c[A+4>>2]&e|0)==0:0)){a=1;return a|0}if(f){if(g)h=q&120|b&7;else h=i;g=30016+(i<<3)|0;j=a+256|0;f=c[j>>2]|0;j=c[j+4>>2]|0;d=a+264|0;e=(c[d>>2]^f)&c[g>>2];g=(c[d+4>>2]^j)&c[g+4>>2];d=l<<3|6;if(!(c[a+336+(d<<2)>>2]|0))d=64;else d=c[a+400+(d<<8)>>2]|0;C=26112+(d<<3)|0;if(!((c[C>>2]&e|0)==0?(c[C+4>>2]&g|0)==0:0)){a=1;return a|0}C=26112+(h<<3)|0;h=26112+(q<<3)|0;i=(c[C>>2]|e|c[h>>2])^f;h=(c[C+4>>2]|g|c[h+4>>2])^j;C=(c[a+5356>>2]|0)+64|0;if(!((c[C>>2]&i|0)==0?(c[C+4>>2]&h|0)==0:0)){a=0;return a|0}e=24064+(m<<3)|0;B=24576+(m<<3)|0;B=(_(c[e+4>>2]&h,c[B+4>>2]|0)|0)^(_(c[e>>2]&i,c[B>>2]|0)|0);B=(c[1031004+(m<<2)>>2]|0)+(B>>>(c[1031260+(m<<2)>>2]|0)<<3)|0;e=a+320+(l<<3)|0;d=c[e>>2]|0;e=c[e+4>>2]|0;g=a+296|0;f=c[g>>2]|0;g=c[g+4>>2]|0;C=a+288|0;if(!((c[B>>2]&i&d&(c[C>>2]|f)|0)==0?(c[B+4>>2]&h&e&(c[C+4>>2]|g)|0)==0:0)){a=0;return a|0}B=25088+(m<<3)|0;C=25600+(m<<3)|0;C=(_(c[B+4>>2]&h,c[C+4>>2]|0)|0)^(_(c[B>>2]&i,c[C>>2]|0)|0);C=(c[1031516+(m<<2)>>2]|0)+(C>>>(c[1031772+(m<<2)>>2]|0)<<3)|0;a=a+280|0;a=(d&i&c[C>>2]&(c[a>>2]|f)|0)==0?(e&h&c[C+4>>2]&(c[a+4>>2]|g)|0)==0:0;return a|0}else d=h}else d=0}}while(0);g=j?b&49152:131072;b:do if((g|0)<131072){switch(g|0){case 32768:break;default:break b}switch(n|0){case 4:{d=o<<3|6;if(!(c[a+336+(d<<2)>>2]|0))j=64;else p=28;break}case 2:{d=o<<3|6;if(!(c[a+336+(d<<2)>>2]|0))j=64;else p=28;break}case 1:{j=64;break}default:{d=o<<3|6;p=28}}if((p|0)==28)j=c[a+400+(d<<8)>>2]|0;d=b&63;e=a+256|0;B=26112+(q<<3)|0;i=26112+(d-((o|0)==0?8:-8)<<3)|0;d=26112+(d<<3)|0;h=c[d>>2]|c[B>>2]^c[e>>2]^c[i>>2];i=c[d+4>>2]|c[B+4>>2]^c[e+4>>2]^c[i+4>>2];e=24064+(j<<3)|0;B=24576+(j<<3)|0;B=(_(c[e+4>>2]&i,c[B+4>>2]|0)|0)^(_(c[e>>2]&h,c[B>>2]|0)|0);B=(c[1031004+(j<<2)>>2]|0)+(B>>>(c[1031260+(j<<2)>>2]|0)<<3)|0;e=a+320+((o^1)<<3)|0;d=c[e>>2]|0;e=c[e+4>>2]|0;g=a+296|0;f=c[g>>2]|0;g=c[g+4>>2]|0;C=a+288|0;if(!((d&c[B>>2]&(c[C>>2]|f)|0)==0?(e&c[B+4>>2]&(c[C+4>>2]|g)|0)==0:0)){a=0;return a|0}B=25088+(j<<3)|0;C=25600+(j<<3)|0;C=(_(c[B+4>>2]&i,c[C+4>>2]|0)|0)^(_(c[B>>2]&h,c[C>>2]|0)|0);C=(c[1031516+(j<<2)>>2]|0)+(C>>>(c[1031772+(j<<2)>>2]|0)<<3)|0;a=a+280|0;a=(c[C>>2]&d&(c[a>>2]|f)|0)==0?(c[C+4>>2]&e&(c[a+4>>2]|g)|0)==0:0;return a|0}else{switch(g|0){case 131072:break;default:break b}if(j)d=c[a+(k<<2)>>2]|0;else d=b>>>18&15;if(!(c[a+4496+(o<<5)+((d&7)<<2)>>2]|0)){a=0;return a|0}a=(c[a+((b&63)<<2)>>2]|0)==0;return a|0}while(0);f=c[a+(q<<2)>>2]|0;if(d?!((g|0)==49152|(f&7|0)!=6):0){y=o^1;d=y<<3|6;if(!(c[a+336+(d<<2)>>2]|0))d=64;else d=c[a+400+(d<<8)>>2]|0;x=b&63;e=30016+(d<<3)|0;d=c[e>>2]|0;e=c[e+4>>2]|0;A=26112+(q<<3)|0;z=c[A>>2]|0;A=c[A+4>>2]|0;if(!((z&d|0)==0&(A&e|0)==0)?(C=26112+(x<<3)|0,B=c[C>>2]|0,C=c[C+4>>2]|0,(B&d|0)==0&(C&e|0)==0):0){h=a+256|0;d=c[h>>2]|0;h=c[h+4>>2]|0;I=31552+(x<<3)|0;J=a+320|0;H=a+264|0;N=c[H>>2]|0;H=c[H+4>>2]|0;L=27456+(x<<3)|0;K=a+328|0;F=27968+(x<<3)|0;G=a+272|0;M=c[G>>2]|0;G=c[G+4>>2]|0;j=24064+(x<<3)|0;i=c[j>>2]|0;j=c[j+4>>2]|0;l=24576+(x<<3)|0;k=c[l>>2]|0;l=c[l+4>>2]|0;E=(_(j&h,l)|0)^(_(i&d,k)|0);m=c[1031260+(x<<2)>>2]|0;n=c[1031004+(x<<2)>>2]|0;E=n+(E>>>m<<3)|0;o=a+288|0;w=a+296|0;v=c[w>>2]|0;w=c[w+4>>2]|0;b=v|c[o>>2];o=w|c[o+4>>2];q=25088+(x<<3)|0;p=c[q>>2]|0;q=c[q+4>>2]|0;s=25600+(x<<3)|0;r=c[s>>2]|0;s=c[s+4>>2]|0;D=(_(q&h,s)|0)^(_(p&d,r)|0);t=c[1031772+(x<<2)>>2]|0;u=c[1031516+(x<<2)>>2]|0;D=u+(D>>>t<<3)|0;e=a+280|0;v=c[e>>2]|v;w=c[e+4>>2]|w;x=30016+(x<<3)|0;e=a+304|0;g=a+320+(y<<3)|0;f=c[g>>2]|0;g=c[g+4>>2]|0;if(!((f&(M|N)&(c[L>>2]&N&c[K>>2]|c[J>>2]&c[I>>2]&N|M&c[F>>2]|b&c[E>>2]|v&c[D>>2]|c[e>>2]&c[x>>2])|0)==0?(g&(G|H)&(c[L+4>>2]&H&c[K+4>>2]|c[J+4>>2]&c[I+4>>2]&H|G&c[F+4>>2]|o&c[E+4>>2]|w&c[D+4>>2]|c[e+4>>2]&c[x+4>>2])|0)==0:0)){N=0;return N|0}e=d^z|B;d=h^A|C;N=n+(((_(j&d,l)|0)^(_(i&e,k)|0))>>>m<<3)|0;if(!((f&b&c[N>>2]|0)==0?(g&o&c[N+4>>2]|0)==0:0)){N=0;return N|0}N=u+(((_(q&d,s)|0)^(_(p&e,r)|0))>>>t<<3)|0;N=(f&v&c[N>>2]|0)==0?(g&w&c[N+4>>2]|0)==0:0;return N|0}}if((f&7|0)==6){if((g|0)==49152){N=1;return N|0}M=b&63;N=a+256|0;I=c[N>>2]|0;N=c[N+4>>2]|0;C=31552+(M<<3)|0;B=a+320|0;D=a+264|0;x=c[D>>2]|0;D=c[D+4>>2]|0;z=27456+(M<<3)|0;A=a+328|0;F=27968+(M<<3)|0;E=a+272|0;G=24064+(M<<3)|0;H=24576+(M<<3)|0;H=(_(c[G+4>>2]&N,c[H+4>>2]|0)|0)^(_(c[G>>2]&I,c[H>>2]|0)|0);H=(c[1031004+(M<<2)>>2]|0)+(H>>>(c[1031260+(M<<2)>>2]|0)<<3)|0;G=a+288|0;J=a+296|0;y=c[J>>2]|0;J=c[J+4>>2]|0;L=25088+(M<<3)|0;K=25600+(M<<3)|0;K=(_(c[L+4>>2]&N,c[K+4>>2]|0)|0)^(_(c[L>>2]&I,c[K>>2]|0)|0);K=(c[1031516+(M<<2)>>2]|0)+(K>>>(c[1031772+(M<<2)>>2]|0)<<3)|0;I=a+280|0;M=30016+(M<<3)|0;L=a+304|0;N=a+320+((o^1)<<3)|0;N=((c[z>>2]&x&c[A>>2]|c[B>>2]&c[C>>2]&x|c[E>>2]&c[F>>2]|(y|c[G>>2])&c[H>>2]|(c[I>>2]|y)&c[K>>2]|c[L>>2]&c[M>>2])&c[N>>2]|0)==0?((c[z+4>>2]&D&c[A+4>>2]|c[B+4>>2]&c[C+4>>2]&D|c[E+4>>2]&c[F+4>>2]|(J|c[G+4>>2])&c[H+4>>2]|(c[I+4>>2]|J)&c[K+4>>2]|c[L+4>>2]&c[M+4>>2])&c[N+4>>2]|0)==0:0;return N|0}M=(c[a+5356>>2]|0)+344+(o<<3)|0;L=a+320+(o<<3)|0;N=26112+(q<<3)|0;if((c[L>>2]&c[M>>2]&c[N>>2]|0)==0?(c[L+4>>2]&c[M+4>>2]&c[N+4>>2]|0)==0:0){N=1;return N|0}e=b&63;switch(n|0){case 4:{d=o<<3|6;if(!(c[a+336+(d<<2)>>2]|0))d=64;else p=53;break}case 2:{d=o<<3|6;if(!(c[a+336+(d<<2)>>2]|0))d=64;else p=53;break}case 1:{d=64;break}default:{d=o<<3|6;p=53}}if((p|0)==53)d=c[a+400+(d<<8)>>2]|0;N=67904+(q<<9)+(e<<3)|0;M=26112+(d<<3)|0;N=c[M>>2]&c[N>>2]|0?1:(c[M+4>>2]&c[N+4>>2]|0)!=0;return N|0}function Lf(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0;D=(b&131072|0)==0;o=D?b>>>6&63:64;n=b&63;g=b&49152;if(!D){a=(c[a+5356>>2]|0)+376+((b>>>18&7)<<3)|0;D=26112+(n<<3)|0;a=c[D>>2]&c[a>>2]|0?1:(c[D+4>>2]&c[a+4>>2]|0)!=0;return a|0}q=c[a+5364>>2]|0;switch(q|0){case 4:{if(!(c[a+336+((c[a+5348>>2]<<3^14)<<2)>>2]|0)){a=0;return a|0}else r=5;break}case 2:{D=c[a+5348>>2]|0;d=D<<3^14;if(!(c[a+336+(d<<2)>>2]|0)){a=0;return a|0}i=c[a+400+(d<<8)>>2]|0;if((i|0)==64){a=0;return a|0}d=c[a+(o<<2)>>2]|0;B=30016+(i<<3)|0;A=c[B>>2]|0;B=c[B+4>>2]|0;if((d&7|0)==6){y=26112+(n<<3)|0;e=c[y>>2]|0;y=c[y+4>>2]|0;if(!((e&A|0)==0&(y&B|0)==0)){a=0;return a|0}z=26112+(o<<3)|0;x=c[z>>2]|0;z=c[z+4>>2]|0;if(!((x&A|0)==0&(z&B|0)==0)){j=a+256|0;d=c[j>>2]|0;j=c[j+4>>2]|0;K=31552+(i<<3)|0;L=a+320|0;J=a+264|0;P=c[J>>2]|0;J=c[J+4>>2]|0;N=27456+(i<<3)|0;M=a+328|0;H=27968+(i<<3)|0;I=a+272|0;O=c[I>>2]|0;I=c[I+4>>2]|0;l=24064+(i<<3)|0;k=c[l>>2]|0;l=c[l+4>>2]|0;n=24576+(i<<3)|0;m=c[n>>2]|0;n=c[n+4>>2]|0;G=(_(l&j,n)|0)^(_(k&d,m)|0);o=c[1031260+(i<<2)>>2]|0;p=c[1031004+(i<<2)>>2]|0;G=p+(G>>>o<<3)|0;r=a+288|0;E=a+296|0;h=c[E>>2]|0;E=c[E+4>>2]|0;q=h|c[r>>2];r=E|c[r+4>>2];t=25088+(i<<3)|0;s=c[t>>2]|0;t=c[t+4>>2]|0;v=25600+(i<<3)|0;u=c[v>>2]|0;v=c[v+4>>2]|0;F=(_(t&j,v)|0)^(_(s&d,u)|0);w=c[1031772+(i<<2)>>2]|0;b=c[1031516+(i<<2)>>2]|0;F=b+(F>>>w<<3)|0;i=a+280|0;h=c[i>>2]|h;i=c[i+4>>2]|E;E=a+304|0;g=a+320+(D<<3)|0;f=c[g>>2]|0;g=c[g+4>>2]|0;if(!((f&(O|P)&(c[N>>2]&P&c[M>>2]|c[L>>2]&c[K>>2]&P|O&c[H>>2]|q&c[G>>2]|h&c[F>>2]|c[E>>2]&A)|0)==0?(g&(I|J)&(c[N+4>>2]&J&c[M+4>>2]|c[L+4>>2]&c[K+4>>2]&J|I&c[H+4>>2]|r&c[G+4>>2]|i&c[F+4>>2]|c[E+4>>2]&B)|0)==0:0)){P=1;return P|0}e=d^x|e;d=j^z|y;P=p+(((_(l&d,n)|0)^(_(k&e,m)|0))>>>o<<3)|0;if(!((f&q&c[P>>2]|0)==0?(g&r&c[P+4>>2]|0)==0:0)){P=1;return P|0}P=b+(((_(t&d,v)|0)^(_(s&e,u)|0))>>>w<<3)|0;P=f&h&c[P>>2]|0?1:(g&i&c[P+4>>2]|0)!=0;return P|0}}else{e=D<<3|6;if(!(c[a+336+(e<<2)>>2]|0))e=64;else e=c[a+400+(e<<8)>>2]|0;P=26112+(e<<3)|0;if(!((c[P>>2]&A|0)==0?(c[P+4>>2]&B|0)==0:0)){P=0;return P|0}}P=b&180224;if((P|0)==32768|((P|0)!=49152?(c[a+(n<<2)>>2]|0)!=0:0)){if((g|0)==32768)b=o&120|b&7;else b=n;g=30016+(n<<3)|0;f=a+256|0;d=c[f>>2]|0;f=c[f+4>>2]|0;P=a+264|0;e=(c[P>>2]^d)&c[g>>2];g=(c[P+4>>2]^f)&c[g+4>>2];P=26112+(i<<3)|0;if(!((e&c[P>>2]|0)==0?(g&c[P+4>>2]|0)==0:0)){P=0;return P|0}O=26112+(b<<3)|0;b=26112+(o<<3)|0;h=(c[O>>2]|e|c[b>>2])^d;b=(c[O+4>>2]|g|c[b+4>>2])^f;e=24064+(i<<3)|0;O=24576+(i<<3)|0;O=(_(b&c[e+4>>2],c[O+4>>2]|0)|0)^(_(h&c[e>>2],c[O>>2]|0)|0);O=(c[1031004+(i<<2)>>2]|0)+(O>>>(c[1031260+(i<<2)>>2]|0)<<3)|0;e=a+320+(D<<3)|0;d=c[e>>2]|0;e=c[e+4>>2]|0;g=a+296|0;f=c[g>>2]|0;g=c[g+4>>2]|0;P=a+288|0;if(!((c[O>>2]&h&d&(c[P>>2]|f)|0)==0?(c[O+4>>2]&b&e&(c[P+4>>2]|g)|0)==0:0)){P=1;return P|0}P=25088+(i<<3)|0;O=25600+(i<<3)|0;O=(_(c[P+4>>2]&b,c[O+4>>2]|0)|0)^(_(c[P>>2]&h,c[O>>2]|0)|0);O=(c[1031516+(i<<2)>>2]|0)+(O>>>(c[1031772+(i<<2)>>2]|0)<<3)|0;P=a+280|0;P=d&h&c[O>>2]&(c[P>>2]|f)|0?1:(e&b&c[O+4>>2]&(c[P+4>>2]|g)|0)!=0;return P|0}break}case 1:{P=0;return P|0}default:r=5}if((r|0)==5)d=c[a+(o<<2)>>2]|0;e=c[a+5356>>2]|0;P=e+376+((d&7)<<3)|0;j=26112+(n<<3)|0;h=c[j>>2]|0;j=c[j+4>>2]|0;if(!((h&c[P>>2]|0)==0?(j&c[P+4>>2]|0)==0:0)){P=1;return P|0}f=c[a+5348>>2]|0;p=f^1;P=e+344+(p<<3)|0;m=a+320+(f<<3)|0;l=c[m>>2]|0;m=c[m+4>>2]|0;k=26112+(o<<3)|0;i=c[k>>2]|0;k=c[k+4>>2]|0;if(!((l&c[P>>2]&i|0)==0?(m&c[P+4>>2]&k|0)==0:0)){switch(q|0){case 4:{d=p<<3|6;if(!(c[a+336+(d<<2)>>2]|0))d=64;else r=29;break}case 2:{d=p<<3|6;if(!(c[a+336+(d<<2)>>2]|0))d=64;else r=29;break}case 1:{d=64;break}default:{d=p<<3|6;r=29}}if((r|0)==29)d=c[a+400+(d<<8)>>2]|0;P=67904+(o<<9)+(n<<3)|0;O=26112+(d<<3)|0;if((c[O>>2]&c[P>>2]|0)==0?(c[O+4>>2]&c[P+4>>2]|0)==0:0){P=1;return P|0}}if((g|0)<32768){switch(g|0){case 16384:break;default:{P=0;return P|0}}if(!(b&65536))d=(b>>>12&3)+2|0;else d=6;e=a+256|0;e=ac(d,n,i^c[e>>2],k^c[e+4>>2])|0;f=C;switch(q|0){case 4:{d=p<<3|6;if(!(c[a+336+(d<<2)>>2]|0))d=64;else r=38;break}case 2:{d=p<<3|6;if(!(c[a+336+(d<<2)>>2]|0))d=64;else r=38;break}case 1:{d=64;break}default:{d=p<<3|6;r=38}}if((r|0)==38)d=c[a+400+(d<<8)>>2]|0;P=26112+(d<<3)|0;P=c[P>>2]&e|0?1:(c[P+4>>2]&f|0)!=0;return P|0}if((g|0)<49152){switch(g|0){case 32768:break;default:{P=0;return P|0}}O=a+256|0;P=26112+((o&120|b&7)<<3)|0;i=h|i^c[O>>2]^c[P>>2];h=j|k^c[O+4>>2]^c[P+4>>2];switch(q|0){case 4:{d=p<<3|6;if(!(c[a+336+(d<<2)>>2]|0))d=64;else r=44;break}case 2:{d=p<<3|6;if(!(c[a+336+(d<<2)>>2]|0))d=64;else r=44;break}case 1:{d=64;break}default:{d=p<<3|6;r=44}}if((r|0)==44)d=c[a+400+(d<<8)>>2]|0;f=24064+(d<<3)|0;P=24576+(d<<3)|0;P=(_(c[f+4>>2]&h,c[P+4>>2]|0)|0)^(_(c[f>>2]&i,c[P>>2]|0)|0);P=(c[1031004+(d<<2)>>2]|0)+(P>>>(c[1031260+(d<<2)>>2]|0)<<3)|0;f=a+296|0;e=c[f>>2]|0;f=c[f+4>>2]|0;b=a+288|0;g=l&c[P>>2]&(c[b>>2]|e);b=m&c[P+4>>2]&(c[b+4>>2]|f);switch(q|0){case 4:{d=p<<3|6;if(!(c[a+336+(d<<2)>>2]|0))d=64;else r=49;break}case 2:{d=p<<3|6;if(!(c[a+336+(d<<2)>>2]|0))d=64;else r=49;break}case 1:{d=64;break}default:{d=p<<3|6;r=49}}if((r|0)==49)d=c[a+400+(d<<8)>>2]|0;P=25088+(d<<3)|0;O=25600+(d<<3)|0;O=(_(c[P+4>>2]&h,c[O+4>>2]|0)|0)^(_(c[P>>2]&i,c[O>>2]|0)|0);O=(c[1031516+(d<<2)>>2]|0)+(O>>>(c[1031772+(d<<2)>>2]|0)<<3)|0;P=a+280|0;P=l&c[O>>2]&(c[P>>2]|e)|g|0?1:(m&c[O+4>>2]&(c[P+4>>2]|f)|b|0)!=0;return P|0}switch(g|0){case 49152:break;default:{P=0;return P|0}}b=n>>>0>o>>>0;f=f*56|0;e=f|(b?6:2);f=f|(b?5:3);b=109888+(f<<3)|0;g=c[b>>2]|0;b=c[b+4>>2]|0;switch(q|0){case 4:{d=p<<3|6;if(!(c[a+336+(d<<2)>>2]|0))d=64;else r=55;break}case 2:{d=p<<3|6;if(!(c[a+336+(d<<2)>>2]|0))d=64;else r=55;break}case 1:{d=64;break}default:{d=p<<3|6;r=55}}if((r|0)==55)d=c[a+400+(d<<8)>>2]|0;P=26112+(d<<3)|0;if((c[P>>2]&g|0)==0?(c[P+4>>2]&b|0)==0:0){P=0;return P|0}O=a+256|0;N=26112+(f<<3)|0;P=26112+(e<<3)|0;M=24064+(f<<3)|0;e=24576+(f<<3)|0;e=(_(c[M+4>>2]&(c[N+4>>2]|k^c[O+4>>2]^j|c[P+4>>2]),c[e+4>>2]|0)|0)^(_(c[M>>2]&(c[N>>2]|i^c[O>>2]^h|c[P>>2]),c[e>>2]|0)|0);f=(c[1031004+(f<<2)>>2]|0)+(e>>>(c[1031260+(f<<2)>>2]|0)<<3)|0;e=c[f>>2]|0;f=c[f+4>>2]|0;switch(q|0){case 4:{d=p<<3|6;if(!(c[a+336+(d<<2)>>2]|0))d=64;else r=61;break}case 2:{d=p<<3|6;if(!(c[a+336+(d<<2)>>2]|0))d=64;else r=61;break}case 1:{d=64;break}default:{d=p<<3|6;r=61}}if((r|0)==61)d=c[a+400+(d<<8)>>2]|0;P=26112+(d<<3)|0;P=c[P>>2]&e|0?1:(c[P+4>>2]&f|0)!=0;return P|0}function Mf(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,D=0,E=0,F=0,G=0;w=i;i=i+4112|0;d=w;u=c[a+5348>>2]|0;p=(b&131072|0)==0;e=b>>>6&63;r=p?e:64;t=b&63;if(p)q=c[a+(e<<2)>>2]|0;else q=b>>>18&15;s=c[a+5364>>2]|0;switch(s|0){case 5:{v=c[a+400+((u<<3|6)<<8)>>2]|0;if(((v>>3)+-3|0)>>>0<2?((v&7)+-3|0)>>>0<2:0){v=0;i=w;return v|0}v=c[a+400+((u<<3^14)<<8)>>2]|0;if(((v>>3)+-3|0)>>>0<2?((v&7)+-3|0)>>>0<2:0){v=0;i=w;return v|0}switch(s|0){case 6:{v=10;break}case 4:{v=15;break}case 1:{v=16;break}default:v=18}break}case 6:{v=10;break}case 4:{v=15;break}case 1:{v=16;break}default:v=18}a:do if((v|0)==10){e=u<<3;if((c[a+400+((e|6)<<8)>>2]&-8|0)==56){if((c[a+400+((e^14)<<8)>>2]&-8|0)==56){v=0;i=w;return v|0}if((c[a+400+((u<<3^14)<<8)>>2]>>3|0)<7){v=0;i=w;return v|0}}if(Ad(a)|0){v=0;i=w;return v|0}else switch(s|0){case 4:{v=15;break a}case 1:{v=16;break a}default:{v=18;break a}}}while(0);b:do if((v|0)==15)if(!(c[a+336+(((c[a+360>>2]|0)!=0&1)<<3<<2)>>2]|0)){v=0;i=w;return v|0}else f=0;else if((v|0)==16){e=u<<3;if(!(c[a+336+(e<<2)>>2]|0)){v=0;i=w;return v|0}if(!(c[a+336+((e^8)<<2)>>2]|0)){v=0;i=w;return v|0}o=b&180224;if((o|0)==32768|((o|0)!=49152?(c[a+(t<<2)>>2]|0)!=0:0))f=0;else{e=c[(c[a+5356>>2]|0)+48>>2]|0;if((e|0)!=64){f=a+256|0;m=f;j=c[m>>2]|0;m=c[m+4>>2]|0;A=31552+(e<<3)|0;B=a+320|0;o=a+264|0;F=c[o>>2]|0;o=c[o+4>>2]|0;E=27456+(e<<3)|0;D=a+328|0;y=27968+(e<<3)|0;z=a+272|0;x=24064+(e<<3)|0;h=24576+(e<<3)|0;h=(_(c[x+4>>2]&m,c[h+4>>2]|0)|0)^(_(c[x>>2]&j,c[h>>2]|0)|0);h=(c[1031004+(e<<2)>>2]|0)+(h>>>(c[1031260+(e<<2)>>2]|0)<<3)|0;x=a+288|0;k=a+296|0;G=c[k>>2]|0;k=c[k+4>>2]|0;n=25088+(e<<3)|0;l=25600+(e<<3)|0;l=(_(c[n+4>>2]&m,c[l+4>>2]|0)|0)^(_(c[n>>2]&j,c[l>>2]|0)|0);l=(c[1031516+(e<<2)>>2]|0)+(l>>>(c[1031772+(e<<2)>>2]|0)<<3)|0;j=a+280|0;n=30016+(e<<3)|0;m=a+304|0;g=a+320+(u<<3)|0;e=c[g>>2]|0;g=c[g+4>>2]|0;if(!(((c[E>>2]&F&c[D>>2]|c[B>>2]&c[A>>2]&F|c[z>>2]&c[y>>2]|(G|c[x>>2])&c[h>>2]|(c[j>>2]|G)&c[l>>2]|c[m>>2]&c[n>>2])&F&e|0)==0?((c[E+4>>2]&o&c[D+4>>2]|c[B+4>>2]&c[A+4>>2]&o|c[z+4>>2]&c[y+4>>2]|(k|c[x+4>>2])&c[h+4>>2]|(c[j+4>>2]|k)&c[l+4>>2]|c[m+4>>2]&c[n+4>>2])&o&g|0)==0:0)){G=0;i=w;return G|0}}else{g=a+320+(u<<3)|0;f=a+256|0;e=c[g>>2]|0;g=c[g+4>>2]|0}j=a+320+((u^1)<<3)|0;while(1){if((e|0)==0&(g|0)==0){f=0;break b}G=hb(e|0,g|0,0)|0;h=Xu(e|0,g|0,-1,-1)|0;g=C&g;F=f;F=ac(c[a+(G<<2)>>2]|0,G,c[F>>2]|0,c[F+4>>2]|0)|0;G=j;if(!((c[G>>2]&F|0)==0?(c[G+4>>2]&C|0)==0:0)){d=0;break}else e=h&e}i=w;return d|0}}else if((v|0)==18){o=(s|0)==2;if(o){e=u<<3;if(!(c[a+336+((e^14)<<2)>>2]|0)){G=0;i=w;return G|0}e=e|6;if(!((q>>3|0)==(u|0)&(q|0?(c[a+336+(e<<2)>>2]|0)!=0:0))){G=0;i=w;return G|0}G=b&180224;g=(G|0)==32768;if(g|((G|0)!=49152?(c[a+(t<<2)>>2]|0)!=0:0)){h=q&7;if((h|0)==6){G=0;i=w;return G|0}n=c[a+400+(e<<8)>>2]|0;G=a+320+(u<<3)|0;f=26112+(t<<3)|0;e=c[f>>2]|0;f=c[f+4>>2]|0;if(!((e&c[G>>2]|0)==0?(f&c[G+4>>2]|0)==0:0)){G=0;i=w;return G|0}G=30016+(n<<3)|0;if(!((c[G>>2]&e|0)==0?(c[G+4>>2]&f|0)==0:0)){G=0;i=w;return G|0}m=u^1;e=m<<3|6;if(!(c[a+336+(e<<2)>>2]|0))e=64;else e=c[a+400+(e<<8)>>2]|0;G=30016+(e<<3)|0;F=26112+(n<<3)|0;if((c[F>>2]&c[G>>2]|0)==0?(c[F+4>>2]&c[G+4>>2]|0)==0:0){if((h|0)==1?((r^b)&7|0)==0:0){G=0;i=w;return G|0}if(g)h=r&120|b&7;else h=t;k=30016+(t<<3)|0;j=a+256|0;f=c[j>>2]|0;j=c[j+4>>2]|0;e=a+264|0;g=(c[e>>2]^f)&c[k>>2];k=(c[e+4>>2]^j)&c[k+4>>2];e=m<<3|6;if(!(c[a+336+(e<<2)>>2]|0))e=64;else e=c[a+400+(e<<8)>>2]|0;G=26112+(e<<3)|0;if(!((c[G>>2]&g|0)==0?(c[G+4>>2]&k|0)==0:0)){G=1;i=w;return G|0}F=26112+(h<<3)|0;G=26112+(r<<3)|0;l=(c[F>>2]|g|c[G>>2])^f;j=(c[F+4>>2]|k|c[G+4>>2])^j;G=(c[a+5356>>2]|0)+64|0;if(!((c[G>>2]&l|0)==0?(c[G+4>>2]&j|0)==0:0)){G=0;i=w;return G|0}f=24064+(n<<3)|0;F=24576+(n<<3)|0;F=(_(c[f+4>>2]&j,c[F+4>>2]|0)|0)^(_(c[f>>2]&l,c[F>>2]|0)|0);F=(c[1031004+(n<<2)>>2]|0)+(F>>>(c[1031260+(n<<2)>>2]|0)<<3)|0;f=a+320+(m<<3)|0;e=c[f>>2]|0;f=c[f+4>>2]|0;h=a+296|0;g=c[h>>2]|0;h=c[h+4>>2]|0;G=a+288|0;if(!((c[F>>2]&l&e&(c[G>>2]|g)|0)==0?(c[F+4>>2]&j&f&(c[G+4>>2]|h)|0)==0:0)){G=0;i=w;return G|0}G=25088+(n<<3)|0;F=25600+(n<<3)|0;F=(_(c[G+4>>2]&j,c[F+4>>2]|0)|0)^(_(c[G>>2]&l,c[F>>2]|0)|0);F=(c[1031516+(n<<2)>>2]|0)+(F>>>(c[1031772+(n<<2)>>2]|0)<<3)|0;G=a+280|0;if(!((e&l&c[F>>2]&(c[G>>2]|g)|0)==0?(f&j&c[F+4>>2]&(c[G+4>>2]|h)|0)==0:0)){G=0;i=w;return G|0}else f=o}else f=o}else f=1}else f=0}while(0);e=p?b&49152:131072;if((e|0)<131072)switch(e|0){case 0:break;default:v=46}else switch(e|0){case 131072:break;default:v=46}if((v|0)==46){e=df(a,d)|0;c[d+4096>>2]=e;if((d|0)==(e|0)){G=0;i=w;return G|0}while(1){if((c[d>>2]|0)==(b|0)){d=1;v=84;break}d=d+8|0;if((d|0)==(e|0)){d=0;v=84;break}}if((v|0)==84){i=w;return d|0}}if(b&65536|0){G=0;i=w;return G|0}if(!((b&12288|0)==0&(q|0)!=0&(q>>3|0)==(u|0))){G=0;i=w;return G|0}d=(e|0)==131072;if(d){if(!(c[a+4496+(u<<5)+((q&7)<<2)>>2]|0)){G=0;i=w;return G|0}if(c[a+(t<<2)>>2]|0){G=0;i=w;return G|0}}G=a+320+(u<<3)|0;j=26112+(t<<3)|0;h=c[j>>2]|0;j=c[j+4>>2]|0;if(!((h&c[G>>2]|0)==0?(j&c[G+4>>2]|0)==0:0)){G=0;i=w;return G|0}do if(!d){if((q&7|0)!=1){G=a+256|0;G=ac(q,r,c[G>>2]|0,c[G+4>>2]|0)|0;if((G&h|0)==0&(C&j|0)==0)d=0;else break;i=w;return d|0}d=u*7|0;if((t>>>3|0)==(d^7|0)){G=0;i=w;return G|0}F=26944+((u<<3|1)<<9)+(r<<3)|0;G=a+320+((u^1)<<3)|0;if((c[F>>2]&h&c[G>>2]|0)==0?(c[F+4>>2]&j&c[G+4>>2]|0)==0:0){e=(u|0)==0?8:-8;if((e+r|0)==(t|0)?(c[a+(t<<2)>>2]|0)==0:0)break;if(((e<<1)+r|0)!=(t|0)){G=0;i=w;return G|0}if((r>>>3|0)!=(d^1|0)){G=0;i=w;return G|0}if(c[a+(t<<2)>>2]|0){G=0;i=w;return G|0}if(c[a+(t-e<<2)>>2]|0){G=0;i=w;return G|0}}}while(0);if(f){e=u<<3;d=e^14;if(!(c[a+336+(d<<2)>>2]|0))d=64;else d=c[a+400+(d<<8)>>2]|0;g=30016+(d<<3)|0;f=c[g>>2]|0;g=c[g+4>>2]|0;if((q&7|0)!=6){d=e|6;if(!(c[a+336+(d<<2)>>2]|0))d=64;else d=c[a+400+(d<<8)>>2]|0}else d=t;G=26112+(d<<3)|0;if(!((c[G>>2]&f|0)==0?(c[G+4>>2]&g|0)==0:0)){G=1;i=w;return G|0}}g=(c[a+5356>>2]|0)+64|0;f=c[g>>2]|0;g=c[g+4>>2]|0;do if(!((f|0)==0&(g|0)==0)){if((q&7|0)==6){E=a+256|0;r=26112+(r<<3)|0;A=c[r>>2]^c[E>>2];E=c[r+4>>2]^c[E+4>>2];r=31552+(t<<3)|0;q=a+320|0;s=a+264|0;n=c[s>>2]|0;s=c[s+4>>2]|0;p=27456+(t<<3)|0;b=a+328|0;x=27968+(t<<3)|0;v=a+272|0;y=24064+(t<<3)|0;z=24576+(t<<3)|0;z=(_(c[y+4>>2]&E,c[z+4>>2]|0)|0)^(_(c[y>>2]&A,c[z>>2]|0)|0);z=(c[1031004+(t<<2)>>2]|0)+(z>>>(c[1031260+(t<<2)>>2]|0)<<3)|0;y=a+288|0;B=a+296|0;o=c[B>>2]|0;B=c[B+4>>2]|0;F=25088+(t<<3)|0;D=25600+(t<<3)|0;D=(_(c[F+4>>2]&E,c[D+4>>2]|0)|0)^(_(c[F>>2]&A,c[D>>2]|0)|0);D=(c[1031516+(t<<2)>>2]|0)+(D>>>(c[1031772+(t<<2)>>2]|0)<<3)|0;A=a+280|0;F=30016+(t<<3)|0;E=a+304|0;G=a+320+((u^1)<<3)|0;if(((c[p>>2]&n&c[b>>2]|c[q>>2]&c[r>>2]&n|c[v>>2]&c[x>>2]|(o|c[y>>2])&c[z>>2]|(c[A>>2]|o)&c[D>>2]|c[E>>2]&c[F>>2])&c[G>>2]|0)==0?((c[p+4>>2]&s&c[b+4>>2]|c[q+4>>2]&c[r+4>>2]&s|c[v+4>>2]&c[x+4>>2]|(B|c[y+4>>2])&c[z+4>>2]|(c[A+4>>2]|B)&c[D+4>>2]|c[E+4>>2]&c[F+4>>2])&c[G+4>>2]|0)==0:0)break;else d=0;i=w;return d|0}G=Xu(f|0,g|0,-1,-1)|0;if(!((G&f|0)==0&(C&g|0)==0)){G=0;i=w;return G|0}e=hb(f|0,g|0,0)|0;switch(s|0){case 4:{d=u<<3|6;if(!(c[a+336+(d<<2)>>2]|0))d=64;else v=80;break}case 2:{d=u<<3|6;if(!(c[a+336+(d<<2)>>2]|0))d=64;else v=80;break}case 1:{d=64;break}default:{d=u<<3|6;v=80}}if((v|0)==80)d=c[a+400+(d<<8)>>2]|0;G=35136+(e<<9)+(d<<3)|0;if((h&(f|c[G>>2])|0)==0?(j&(g|c[G+4>>2])|0)==0:0){G=0;i=w;return G|0}}while(0);G=1;i=w;return G|0}
function Ob(a){a=a|0;var b=0;b=i;i=i+a|0;i=i+15&-16;return b|0}function Pb(){return i|0}function Qb(a){a=a|0;i=a}function Rb(a,b){a=a|0;b=b|0;i=a;j=b}function Sb(a,b){a=a|0;b=b|0;if(!n){n=a;o=b}}function Tb(b){b=b|0;a[k>>0]=a[b>>0];a[k+1>>0]=a[b+1>>0];a[k+2>>0]=a[b+2>>0];a[k+3>>0]=a[b+3>>0]}function Ub(b){b=b|0;a[k>>0]=a[b>>0];a[k+1>>0]=a[b+1>>0];a[k+2>>0]=a[b+2>>0];a[k+3>>0]=a[b+3>>0];a[k+4>>0]=a[b+4>>0];a[k+5>>0]=a[b+5>>0];a[k+6>>0]=a[b+6>>0];a[k+7>>0]=a[b+7>>0]}function Vb(a){a=a|0;C=a}function Wb(){return C|0}function Xb(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;return (c[990044+((d<<6|a|b<<13&57344|e<<12|6-(b>>>3)<<15)>>>5<<2)>>2]&1<<(a&31)|0)!=0|0}function Yb(){var a=0,b=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;n=Nu(3932160)|0;Wu(n|0,0,3932160)|0;k=0;do{f=k&63;h=k>>>6&63;j=k>>>12&1;a=6-(k>>>15&7)<<3;g=a|k>>>13&3;do if((h|0)==(g|0)|((f|0)==(g|0)?1:(c[1014620+(f<<8)+(h<<2)>>2]|0)<2))a=0;else{if(!j){e=27456+(g<<3)|0;d=26112+(h<<3)|0;if(!((c[d>>2]&c[e>>2]|0)==0?(c[d+4>>2]&c[e+4>>2]|0)==0:0)){a=0;break}if((a|0)==48?(i=g+8|0,(f|0)!=(i|0)):0){if((c[1014620+(h<<8)+(i<<2)>>2]|0)>1){a=4;break}e=30016+(f<<3)|0;d=26112+(i<<3)|0;if(!((c[d>>2]&c[e>>2]|0)==0?(c[d+4>>2]&c[e+4>>2]|0)==0:0)){a=4;break}}}else{b=30016+(h<<3)|0;a=c[b>>2]|0;b=c[b+4>>2]|0;e=30016+(f<<3)|0;d=c[e>>2]|0;e=c[e+4>>2]|0;o=27456+(g<<3)|0;if((a&~(c[o>>2]|d)|0)==0?(b&~(c[o+4>>2]|e)|0)==0:0){a=2;break}o=26112+(g<<3)|0;if(!((a&~d&c[o>>2]|0)==0?(b&~e&c[o+4>>2]|0)==0:0)){a=2;break}}a=1}while(0);c[n+(k*20|0)>>2]=j;c[n+(k*20|0)+4>>2]=f;c[n+(k*20|0)+8>>2]=h;c[n+(k*20|0)+12>>2]=g;c[n+(k*20|0)+16>>2]=a;k=k+1|0}while((k|0)!=196608);a=0;b=0;while(1){j=n+(a*20|0)+16|0;if((c[j>>2]|0)==1){do if(!(c[n+(a*20|0)>>2]|0)){i=c[n+(a*20|0)+4>>2]|0;f=30016+(i<<3)|0;d=c[f>>2]|0;f=c[f+4>>2]|0;if((d|0)==0&(f|0)==0){e=c[n+(a*20|0)+12>>2]|0;d=0}else{e=c[n+(a*20|0)+12>>2]|0;h=c[n+(a*20|0)+8>>2]<<6|e<<13&57344|6-(e>>>3)<<15;g=d;d=0;do{o=hb(g|0,f|0,0)|0;k=Xu(g|0,f|0,-1,-1)|0;g=k&g;f=C&f;d=c[n+((h|o|4096)*20|0)+16>>2]|d}while(!((g|0)==0&(f|0)==0))}if((e>>3|0)<6){o=e+8|0;d=c[n+((i|o<<13&57344|6-(o>>>3)<<15|c[n+(a*20|0)+8>>2]<<6|4096)*20|0)+16>>2]|d}if(((e&-8|0)==8?(l=e+8|0,(l|0)!=(i|0)):0)?(m=c[n+(a*20|0)+8>>2]|0,(l|0)!=(m|0)):0){o=e+16|0;d=c[n+((i|o<<13&57344|6-(o>>>3)<<15|m<<6|4096)*20|0)+16>>2]|d}d=(d&4|0)==0?2-(d&1)|0:4}else{e=30016+(c[n+(a*20|0)+8>>2]<<3)|0;d=c[e>>2]|0;e=c[e+4>>2]|0;if(!((d|0)==0&(e|0)==0)){g=c[n+(a*20|0)+12>>2]|0;g=g<<13&57344|c[n+(a*20|0)+4>>2]|6-(g>>>3)<<15;f=d;d=0;do{o=hb(f|0,e|0,0)|0;k=Xu(f|0,e|0,-1,-1)|0;f=k&f;e=C&e;d=c[n+((g|o<<6)*20|0)+16>>2]|d}while(!((f|0)==0&(e|0)==0));if(d&2){d=2;break}}else d=0;d=d&1|0?1:4}while(0);c[j>>2]=d;d=(d|0)!=1}else d=0;b=d&1|b;a=a+1|0;if(a>>>0<196608)continue;if(!b){a=0;break}else{a=0;b=0}}do{if((c[n+(a*20|0)+16>>2]|0)==4){o=990044+(a>>>5<<2)|0;c[o>>2]=c[o>>2]|1<<(a&31)}a=a+1|0}while((a|0)!=196608);mu(n);return}function Zb(){var a=0,b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0;a=i;i=i+96|0;b=a;rk(b,17165,5);d=b+12|0;rk(d,17171,8);e=b+24|0;rk(e,17180,6);f=b+36|0;rk(f,17187,10);g=b+48|0;rk(g,17198,5);h=b+60|0;rk(h,17204,13);j=b+72|0;rk(j,17218,11);k=b+84|0;rk(k,17230,10);l=Nu(96)|0;c[247509]=l;c[247508]=l;c[247510]=l+96;qk(l,b);l=(c[247509]|0)+12|0;c[247509]=l;qk(l,d);l=(c[247509]|0)+12|0;c[247509]=l;qk(l,e);l=(c[247509]|0)+12|0;c[247509]=l;qk(l,f);l=(c[247509]|0)+12|0;c[247509]=l;qk(l,g);l=(c[247509]|0)+12|0;c[247509]=l;qk(l,h);l=(c[247509]|0)+12|0;c[247509]=l;qk(l,j);l=(c[247509]|0)+12|0;c[247509]=l;qk(l,k);c[247509]=(c[247509]|0)+12;vk(k);vk(j);vk(h);vk(g);vk(f);vk(e);vk(d);vk(b);i=a;return}function _b(){var a=0,b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0;a=i;i=i+96|0;b=a;rk(b,17165,5);d=b+12|0;rk(d,17171,8);e=b+24|0;rk(e,17180,6);f=b+36|0;rk(f,17187,10);g=b+48|0;rk(g,17198,5);h=b+60|0;rk(h,17204,13);j=b+72|0;rk(j,17218,11);k=b+84|0;rk(k,17230,10);l=Nu(96)|0;c[258008]=l;c[258007]=l;c[258009]=l+96;qk(l,b);l=(c[258008]|0)+12|0;c[258008]=l;qk(l,d);l=(c[258008]|0)+12|0;c[258008]=l;qk(l,e);l=(c[258008]|0)+12|0;c[258008]=l;qk(l,f);l=(c[258008]|0)+12|0;c[258008]=l;qk(l,g);l=(c[258008]|0)+12|0;c[258008]=l;qk(l,h);l=(c[258008]|0)+12|0;c[258008]=l;qk(l,j);l=(c[258008]|0)+12|0;c[258008]=l;qk(l,k);c[258008]=(c[258008]|0)+12;vk(k);vk(j);vk(h);vk(g);vk(f);vk(e);vk(d);vk(b);i=a;return}function $b(){var b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0;s=i;i=i+32|0;l=s+16|0;k=s;b=0;do{r=b-(b>>>1&21845)|0;r=(r>>>2&13107)+(r&13107)|0;a[1151952+b>>0]=(((r>>>4)+r&3855)*257|0)>>>8;b=b+1|0}while((b|0)!=65536);b=0;do{q=Zu(1,0,b|0)|0;r=26112+(b<<3)|0;c[r>>2]=q;c[r+4>>2]=C;b=b+1|0}while((b|0)!=64);b=2;d=0;do{q=Xu(b|0,d|0,-1,0)|0;q=c[1032040+(q<<2)>>2]|0;r=Xu(b|0,d|0,-1,-1)|0;c[1032040+(b<<2)>>2]=q+((r&b|0)==0&(C&d|0)==0&1);b=Xu(b|0,d|0,1,0)|0;d=C}while(d>>>0<0|(d|0)==0&b>>>0<256);r=26624;c[r>>2]=16843009;c[r+4>>2]=16843009;r=26632;c[r>>2]=33686018;c[r+4>>2]=33686018;r=26640;c[r>>2]=67372036;c[r+4>>2]=67372036;r=26648;c[r>>2]=134744072;c[r+4>>2]=134744072;r=26656;c[r>>2]=269488144;c[r+4>>2]=269488144;r=26664;c[r>>2]=538976288;c[r+4>>2]=538976288;r=26672;c[r>>2]=1077952576;c[r+4>>2]=1077952576;r=26680;c[r>>2]=-2139062144;c[r+4>>2]=-2139062144;r=26688;c[r>>2]=255;c[r+4>>2]=0;r=26696;c[r>>2]=65280;c[r+4>>2]=0;r=26704;c[r>>2]=16711680;c[r+4>>2]=0;r=26712;c[r>>2]=-16777216;c[r+4>>2]=0;r=26720;c[r>>2]=0;c[r+4>>2]=255;r=26728;c[r>>2]=0;c[r+4>>2]=65280;r=26736;c[r>>2]=0;c[r+4>>2]=16711680;r=26744;c[r>>2]=0;c[r+4>>2]=-16777216;r=26752;c[r>>2]=33686018;c[r+4>>2]=33686018;r=26760;c[r>>2]=84215045;c[r+4>>2]=84215045;r=26768;c[r>>2]=168430090;c[r+4>>2]=168430090;r=26776;c[r>>2]=336860180;c[r+4>>2]=336860180;r=26784;c[r>>2]=673720360;c[r+4>>2]=673720360;r=26792;c[r>>2]=1347440720;c[r+4>>2]=1347440720;r=26800;c[r>>2]=-1600085856;c[r+4>>2]=-1600085856;r=26808;c[r>>2]=1077952576;c[r+4>>2]=1077952576;r=26880;q=c[r>>2]|0;r=c[r+4>>2]|0;b=26888;c[b>>2]=q|255;c[b+4>>2]=r;b=26816;c[b>>2]=q&-256^-256;c[b+4>>2]=~r;b=26896;c[b>>2]=q|65535;c[b+4>>2]=r;b=26824;c[b>>2]=q&-65536^-65536;c[b+4>>2]=~r;b=26904;c[b>>2]=q|16777215;c[b+4>>2]=r;b=26832;c[b>>2]=q&-16777216^-16777216;c[b+4>>2]=~r;b=26912;c[b>>2]=-1;c[b+4>>2]=r;b=26840;c[b>>2]=0;c[b+4>>2]=~r;b=26920;c[b>>2]=-1;c[b+4>>2]=r|255;b=26848;c[b>>2]=0;c[b+4>>2]=r&-256^-256;b=26928;c[b>>2]=-1;c[b+4>>2]=r|65535;b=26856;c[b>>2]=0;c[b+4>>2]=r&-65536^-65536;b=26936;c[b>>2]=-1;c[b+4>>2]=r|16777215;b=26864;c[b>>2]=0;c[b+4>>2]=r&-16777216^-16777216;b=0;do{q=26816+(b>>3<<3)|0;o=c[q>>2]|0;q=c[q+4>>2]|0;r=b&7;p=26624+(r<<3)|0;n=c[p>>2]&o;p=c[p+4>>2]&q;m=104768+(b<<3)|0;c[m>>2]=n;c[m+4>>2]=p;r=26752+(r<<3)|0;o=c[r>>2]&o;q=c[r+4>>2]&q;r=106816+(b<<3)|0;c[r>>2]=o;c[r+4>>2]=q;r=105792+(b<<3)|0;c[r>>2]=n|o;c[r+4>>2]=p|q;b=b+1|0}while((b|0)!=64);b=0;do{q=26880+(b>>3<<3)|0;o=c[q>>2]|0;q=c[q+4>>2]|0;r=b&7;p=26624+(r<<3)|0;n=c[p>>2]&o;p=c[p+4>>2]&q;m=105280+(b<<3)|0;c[m>>2]=n;c[m+4>>2]=p;r=26752+(r<<3)|0;o=c[r>>2]&o;q=c[r+4>>2]&q;r=107328+(b<<3)|0;c[r>>2]=o;c[r+4>>2]=q;r=106304+(b<<3)|0;c[r>>2]=n|o;c[r+4>>2]=p|q;b=b+1|0}while((b|0)!=64);e=0;do{b=e&7;d=e>>3;f=0;do{if((e|0)!=(f|0)){r=f&7;r=b>>>0<r>>>0?r-b|0:b-r|0;p=f>>3;p=(d|0)<(p|0)?p-d|0:d-p|0;r=(r|0)<(p|0)?p:r;c[1014620+(e<<8)+(f<<2)>>2]=r;r=100672+(e<<6)+(r+-1<<3)|0;p=26112+(f<<3)|0;o=r;q=c[o+4>>2]|c[p+4>>2];c[r>>2]=c[o>>2]|c[p>>2];c[r+4>>2]=q}f=f+1|0}while((f|0)!=64);e=e+1|0}while((e|0)!=64);g=1;do{d=c[1576+(g*36|0)>>2]|0;if(!(57>>>g&1)){h=0;do{e=26944+(g<<9)+(h<<3)|0;b=d;f=0;do{b=b+h|0;if(b>>>0<64?(c[1014620+(h<<8)+(b<<2)>>2]|0)<3:0){p=26112+(b<<3)|0;o=e;q=c[o+4>>2]|c[p+4>>2];r=e;c[r>>2]=c[o>>2]|c[p>>2];c[r+4>>2]=q}f=f+1|0;b=c[1576+(g*36|0)+(f<<2)>>2]|0}while((b|0)!=0);h=h+1|0}while((h|0)!=64)}g=g+1|0}while((g|0)!=7);h=1;do{d=c[1576+(h*36|0)>>2]|0;e=h+8|0;if(!(57>>>h&1)){j=0;do{f=26944+(e<<9)+(j<<3)|0;b=d;g=0;do{b=j-b|0;if(b>>>0<64?(c[1014620+(j<<8)+(b<<2)>>2]|0)<3:0){p=26112+(b<<3)|0;o=f;q=c[o+4>>2]|c[p+4>>2];r=f;c[r>>2]=c[o>>2]|c[p>>2];c[r+4>>2]=q}g=g+1|0;b=c[1576+(h*36|0)+(g<<2)>>2]|0}while((b|0)!=0);j=j+1|0}while((j|0)!=64)}h=h+1|0}while((h|0)!=7);c[l>>2]=c[457];c[l+4>>2]=c[458];c[l+8>>2]=c[459];c[l+12>>2]=c[460];c[k>>2]=c[461];c[k+4>>2]=c[462];c[k+8>>2]=c[463];c[k+12>>2]=c[464];cc(111936,1031004,24576,24064,1031260,l,27);cc(931136,1031516,25600,25088,1031772,k,28);r=0;do{l=c[1031516+(r<<2)>>2]|0;q=l;o=c[q>>2]|0;q=c[q+4>>2]|0;n=109376+(r<<3)|0;c[n>>2]=o;c[n+4>>2]=q;n=110400+(r<<3)|0;m=n;c[m>>2]=o;c[m+4>>2]=q;m=c[1031004+(r<<2)>>2]|0;p=m;k=c[p>>2]|0;p=c[p+4>>2]|0;j=109888+(r<<3)|0;c[j>>2]=k;c[j+4>>2]=p;c[n>>2]=k|o;c[n+4>>2]=p|q;n=26112+(r<<3)|0;q=3;do{b=26944+(q<<9)+(r<<3)|0;p=107840+(q<<9)+(r<<3)|0;o=c[p>>2]|0;p=c[p+4>>2]|0;if((q|0)==3){e=0;do{d=26112+(e<<3)|0;b=c[d>>2]|0;d=c[d+4>>2]|0;if(!((b&o|0)==0&(d&p|0)==0)){f=l;t=c[1031516+(e<<2)>>2]|0;g=n;k=c[g>>2]|0;g=c[g+4>>2]|0;j=g|c[t+4>>2]&c[f+4>>2]|d;h=67904+(r<<9)+(e<<3)|0;c[h>>2]=k|c[t>>2]&c[f>>2]|b;c[h+4>>2]=j;h=ac(3,r,b,d)|0;j=C;g=ac(3,e,k,g)|0;k=35136+(r<<9)+(e<<3)|0;c[k>>2]=g&h;c[k+4>>2]=C&j}e=e+1|0}while((e|0)!=64)}else{k=0;do{e=26112+(k<<3)|0;d=c[e>>2]|0;e=c[e+4>>2]|0;if(!((d&o|0)==0&(e&p|0)==0)){switch(q|0){case 5:{h=l;u=m;j=c[1031516+(k<<2)>>2]|0;t=c[1031004+(k<<2)>>2]|0;f=c[u>>2]|c[h>>2];g=c[t>>2]|c[j>>2];h=c[u+4>>2]|c[h+4>>2];j=c[t+4>>2]|c[j+4>>2];break}case 4:{h=m;j=c[1031004+(k<<2)>>2]|0;f=c[h>>2]|0;g=c[j>>2]|0;h=c[h+4>>2]|0;j=c[j+4>>2]|0;break}default:{h=b;j=26944+(q<<9)+(k<<3)|0;f=c[h>>2]|0;g=c[j>>2]|0;h=c[h+4>>2]|0;j=c[j+4>>2]|0}}u=n;v=c[u>>2]|0;u=c[u+4>>2]|0;t=67904+(r<<9)+(k<<3)|0;c[t>>2]=v|g&f|d;c[t+4>>2]=u|j&h|e;j=ac(q,r,d,e)|0;t=C;h=ac(q,k,v,u)|0;u=35136+(r<<9)+(k<<3)|0;c[u>>2]=h&j;c[u+4>>2]=C&t}k=k+1|0}while((k|0)!=64)}q=q+1|0}while((q|0)!=5);r=r+1|0}while((r|0)!=64);i=s;return}function ac(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0;switch(a&7|0){case 3:{f=25088+(b<<3)|0;a=25600+(b<<3)|0;a=(_(c[f+4>>2]&e,c[a+4>>2]|0)|0)^(_(c[f>>2]&d,c[a>>2]|0)|0);b=(c[1031516+(b<<2)>>2]|0)+(a>>>(c[1031772+(b<<2)>>2]|0)<<3)|0;a=c[b+4>>2]|0;b=c[b>>2]|0;C=a;return b|0}case 4:{a=24064+(b<<3)|0;f=24576+(b<<3)|0;f=(_(c[a+4>>2]&e,c[f+4>>2]|0)|0)^(_(c[a>>2]&d,c[f>>2]|0)|0);f=(c[1031004+(b<<2)>>2]|0)+(f>>>(c[1031260+(b<<2)>>2]|0)<<3)|0;b=c[f+4>>2]|0;f=c[f>>2]|0;C=b;return f|0}case 5:{g=25088+(b<<3)|0;f=25600+(b<<3)|0;f=(_(c[g+4>>2]&e,c[f+4>>2]|0)|0)^(_(c[g>>2]&d,c[f>>2]|0)|0);f=(c[1031516+(b<<2)>>2]|0)+(f>>>(c[1031772+(b<<2)>>2]|0)<<3)|0;g=24064+(b<<3)|0;a=24576+(b<<3)|0;a=(_(c[g+4>>2]&e,c[a+4>>2]|0)|0)^(_(c[g>>2]&d,c[a>>2]|0)|0);a=(c[1031004+(b<<2)>>2]|0)+(a>>>(c[1031260+(b<<2)>>2]|0)<<3)|0;b=c[a+4>>2]|c[f+4>>2];f=c[a>>2]|c[f>>2];C=b;return f|0}default:{g=26944+(a<<9)+(b<<3)|0;f=c[g+4>>2]|0;g=c[g>>2]|0;C=f;return g|0}}return 0}function bc(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;f=24064+(a<<3)|0;e=24576+(a<<3)|0;d=(_(c[f+4>>2]&d,c[e+4>>2]|0)|0)^(_(c[f>>2]&b,c[e>>2]|0)|0);return d>>>(c[1031260+(a<<2)>>2]|0)|0}function cc(a,b,e,f,g,h,j){a=a|0;b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0;y=i;i=i+81920|0;w=y+32768|0;x=y;v=y+65536|0;Wu(v|0,0,16384)|0;c[b>>2]=a;a=0;u=0;while(1){q=u>>3;l=26688+(q<<3)|0;t=26624+((u&7)<<3)|0;o=c[t>>2]&-2122219135^-2122219135|c[l>>2]&255^255;l=c[t+4>>2]&-2122219135^-2122219135|c[l+4>>2]&-16777216^-16777216;t=dc(h,u,0,0)|0;o=t&~o;l=C&~l;t=f+(u<<3)|0;n=t;c[n>>2]=o;c[n+4>>2]=l;n=Yu(o|0,l|0,16)|0;m=Yu(o|0,l|0,48)|0;c[g+(u<<2)>>2]=32-(d[1151952+(o&65535)>>0]|0)-(d[1151952+(n&65535)>>0]|0)-(d[1151952+(l&65535)>>0]|0)-(d[1151952+m>>0]|0);m=t;l=c[m>>2]|0;m=c[m+4>>2]|0;n=0;o=0;p=0;while(1){s=w+(p<<3)|0;c[s>>2]=n;c[s+4>>2]=o;s=dc(h,u,n,o)|0;k=x+(p<<3)|0;c[k>>2]=s;c[k+4>>2]=C;k=p+1|0;s=Vu(n|0,o|0,l|0,m|0)|0;n=s&l;o=C&m;if((n|0)==0&(o|0)==0)break;else p=k}r=b+(u<<2)|0;if((u|0)<63)c[b+(u+1<<2)>>2]=(c[r>>2]|0)+(k<<3);k=c[1860+(q<<2)>>2]|0;l=((k|0)<0)<<31>>31;s=e+(u<<3)|0;a:do if((p|0)<0){do{n=Yu(k|0,l|0,12)|0;n=n^k;p=C^l;r=Zu(n|0,p|0,25)|0;n=r^n;p=C^p;r=Yu(n|0,p|0,27)|0;n=r^n;p=C^p;r=hv(n|0,p|0,1332534557,625341585)|0;q=C;o=Yu(n|0,p|0,12)|0;n=o^n;p=C^p;o=Zu(n|0,p|0,25)|0;n=o^n;p=C^p;o=Yu(n|0,p|0,27)|0;n=o^n;p=C^p;o=hv(n|0,p|0,1332534557,625341585)|0;q=C&q;m=Yu(n|0,p|0,12)|0;n=m^n;p=C^p;m=Zu(n|0,p|0,25)|0;n=m^n;p=C^p;m=Yu(n|0,p|0,27)|0;k=m^n;l=C^p;p=hv(k|0,l|0,1332534557,625341585)|0;p=o&r&p;q=q&C;r=s;c[r>>2]=p;c[r+4>>2]=q;r=t;r=hv(p|0,q|0,c[r>>2]|0,c[r+4>>2]|0)|0;r=Yu(r|0,C|0,56)|0}while((((d[1151952]|0)*3|0)+(d[1151952+r>>0]|0)|0)>>>0<6);a=a+1|0}else{q=a;b:while(1){do{o=Yu(k|0,l|0,12)|0;k=o^k;l=C^l;o=Zu(k|0,l|0,25)|0;k=o^k;l=C^l;o=Yu(k|0,l|0,27)|0;k=o^k;l=C^l;o=hv(k|0,l|0,1332534557,625341585)|0;n=C;a=Yu(k|0,l|0,12)|0;k=a^k;l=C^l;a=Zu(k|0,l|0,25)|0;k=a^k;l=C^l;a=Yu(k|0,l|0,27)|0;k=a^k;l=C^l;a=hv(k|0,l|0,1332534557,625341585)|0;n=C&n;m=Yu(k|0,l|0,12)|0;k=m^k;l=C^l;m=Zu(k|0,l|0,25)|0;k=m^k;l=C^l;m=Yu(k|0,l|0,27)|0;k=m^k;l=C^l;m=hv(k|0,l|0,1332534557,625341585)|0;m=a&o&m;n=n&C;o=s;c[o>>2]=m;c[o+4>>2]=n;o=t;o=hv(m|0,n|0,c[o>>2]|0,c[o+4>>2]|0)|0;o=Yu(o|0,C|0,56)|0}while((((d[1151952]|0)*3|0)+(d[1151952+o>>0]|0)|0)>>>0<6);a=q+1|0;o=0;while(1){m=w+(o<<3)|0;m=yb[j&31](u,c[m>>2]|0,c[m+4>>2]|0)|0;n=v+(m<<2)|0;if((c[n>>2]|0)>(q|0)){m=(c[r>>2]|0)+(m<<3)|0;n=x+(o<<3)|0;if(!((c[m>>2]|0)==(c[n>>2]|0)?(c[m+4>>2]|0)==(c[n+4>>2]|0):0)){q=a;continue b}}else{c[n>>2]=a;A=x+(o<<3)|0;z=c[A+4>>2]|0;n=(c[r>>2]|0)+(m<<3)|0;c[n>>2]=c[A>>2];c[n+4>>2]=z}if((o|0)<(p|0))o=o+1|0;else break a}}}while(0);u=u+1|0;if((u|0)==64)break}i=y;return}function dc(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0;i=c[a>>2]|0;g=i+b|0;a:do if(g>>>0<64){f=0;h=0;do{if((c[1014620+(g<<8)+(g-i<<2)>>2]|0)!=1)break a;j=26112+(g<<3)|0;k=c[j>>2]|0;j=c[j+4>>2]|0;f=k|f;h=j|h;g=i+g|0}while((k&d|0)==0&(j&e|0)==0&g>>>0<64)}else{f=0;h=0}while(0);i=c[a+4>>2]|0;g=i+b|0;b:do if(g>>>0<64)do{if((c[1014620+(g<<8)+(g-i<<2)>>2]|0)!=1)break b;k=26112+(g<<3)|0;j=c[k>>2]|0;k=c[k+4>>2]|0;f=j|f;h=k|h;g=i+g|0}while((j&d|0)==0&(k&e|0)==0&g>>>0<64);while(0);i=c[a+8>>2]|0;g=i+b|0;c:do if(g>>>0<64)do{if((c[1014620+(g<<8)+(g-i<<2)>>2]|0)!=1)break c;k=26112+(g<<3)|0;j=c[k>>2]|0;k=c[k+4>>2]|0;f=j|f;h=k|h;g=i+g|0}while((j&d|0)==0&(k&e|0)==0&g>>>0<64);while(0);i=c[a+12>>2]|0;g=i+b|0;if(g>>>0>=64){j=h;k=f;C=j;return k|0}while(1){if((c[1014620+(g<<8)+(g-i<<2)>>2]|0)!=1){g=13;break}k=26112+(g<<3)|0;j=c[k>>2]|0;k=c[k+4>>2]|0;f=j|f;h=k|h;g=i+g|0;if(!((j&d|0)==0&(k&e|0)==0&g>>>0<64)){g=13;break}}if((g|0)==13){C=h;return f|0}return 0}function ec(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;f=25088+(a<<3)|0;e=25600+(a<<3)|0;d=(_(c[f+4>>2]&d,c[e+4>>2]|0)|0)^(_(c[f>>2]&b,c[e>>2]|0)|0);return d>>>(c[1031772+(a<<2)>>2]|0)|0}function fc(){var a=0,b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0;a=i;i=i+96|0;b=a;rk(b,17165,5);d=b+12|0;rk(d,17171,8);e=b+24|0;rk(e,17180,6);f=b+36|0;rk(f,17187,10);g=b+48|0;rk(g,17198,5);h=b+60|0;rk(h,17204,13);j=b+72|0;rk(j,17218,11);k=b+84|0;rk(k,17230,10);l=Nu(96)|0;c[258267]=l;c[258266]=l;c[258268]=l+96;qk(l,b);l=(c[258267]|0)+12|0;c[258267]=l;qk(l,d);l=(c[258267]|0)+12|0;c[258267]=l;qk(l,e);l=(c[258267]|0)+12|0;c[258267]=l;qk(l,f);l=(c[258267]|0)+12|0;c[258267]=l;qk(l,g);l=(c[258267]|0)+12|0;c[258267]=l;qk(l,h);l=(c[258267]|0)+12|0;c[258267]=l;qk(l,j);l=(c[258267]|0)+12|0;c[258267]=l;qk(l,k);c[258267]=(c[258267]|0)+12;vk(k);vk(j);vk(h);vk(g);vk(f);vk(e);vk(d);vk(b);i=a;return}function gc(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;b=i;i=i+192|0;t=b+180|0;s=b+168|0;r=b+156|0;q=b+144|0;p=b+132|0;o=b+120|0;n=b+108|0;m=b+96|0;l=b+84|0;k=b+72|0;j=b+60|0;h=b+48|0;g=b+36|0;f=b+24|0;e=b+12|0;d=b;c[a+4>>2]=0;c[a+8>>2]=0;c[a>>2]=a+4;c[a+16>>2]=0;c[a+20>>2]=0;c[a+12>>2]=a+16;rk(t,16008,4);hc(a,t);vk(t);rk(s,16013,5);nc(a,s);vk(s);rk(r,16019,5);rc(a,r);vk(r);rk(q,16025,5);vc(a,q);vk(q);rk(p,16031,5);zc(a,p);vk(p);rk(o,16037,5);Dc(a,o);vk(o);rk(n,16043,5);Hc(a,n);vk(n);rk(m,16049,5);Lc(a,m);vk(m);rk(l,16055,5);Pc(a,l);vk(l);rk(k,16061,6);Uc(a,k);vk(k);rk(j,16068,6);Yc(a,j);vk(j);rk(h,16075,6);ad(a,h);vk(h);rk(g,16082,6);ed(a,g);vk(g);rk(f,16089,6);id(a,f);vk(f);rk(e,16096,7);md(a,e);vk(e);rk(d,16104,8);qd(a,d);vk(d);i=b;return}function hc(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;o=i;i=i+11184|0;n=o+11176|0;l=o+5368|0;g=o+5808|0;k=o;Wu(g|0,0,5368)|0;g=(c[(Hf(g,b,0,0,l)|0)+5356>>2]|0)+8|0;h=c[g>>2]|0;g=c[g+4>>2]|0;m=a+4|0;d=c[m>>2]|0;do if(d){while(1){f=d+16|0;e=c[f>>2]|0;f=c[f+4>>2]|0;if(g>>>0<f>>>0|(g|0)==(f|0)&h>>>0<e>>>0){e=c[d>>2]|0;if(!e){e=d;j=4;break}else d=e}else{if(!(f>>>0<g>>>0|(f|0)==(g|0)&e>>>0<h>>>0)){j=10;break}e=d+4|0;f=c[e>>2]|0;if(!f){j=8;break}else d=f}}if((j|0)==4){c[n>>2]=d;j=11;break}else if((j|0)==8){c[n>>2]=d;j=11;break}else if((j|0)==10){c[n>>2]=d;if(!d){e=n;j=11;break}else break}}else{c[n>>2]=m;e=m;d=m;j=11}while(0);if((j|0)==11){f=Nu(32)|0;j=f+16|0;c[j>>2]=h;c[j+4>>2]=g;c[f+24>>2]=0;c[f>>2]=0;c[f+4>>2]=0;c[f+8>>2]=d;c[e>>2]=f;d=c[c[a>>2]>>2]|0;if(!d)d=f;else{c[a>>2]=d;d=c[e>>2]|0}ic(c[a+4>>2]|0,d);d=a+8|0;c[d>>2]=(c[d>>2]|0)+1;d=f}j=d+24|0;h=Nu(12)|0;c[h>>2]=1932;c[h+4>>2]=0;c[h+8>>2]=1;d=c[j>>2]|0;c[j>>2]=h;if(d|0)Bb[c[(c[d>>2]|0)+4>>2]&255](d);Wu(k|0,0,5368)|0;h=(c[(Hf(k,b,1,0,l)|0)+5356>>2]|0)+8|0;g=c[h>>2]|0;h=c[h+4>>2]|0;d=c[m>>2]|0;do if(d){while(1){f=d+16|0;e=c[f>>2]|0;f=c[f+4>>2]|0;if(h>>>0<f>>>0|(h|0)==(f|0)&g>>>0<e>>>0){e=c[d>>2]|0;if(!e){f=d;e=d;j=19;break}else d=e}else{if(!(f>>>0<h>>>0|(f|0)==(h|0)&e>>>0<g>>>0)){j=25;break}e=d+4|0;f=c[e>>2]|0;if(!f){j=23;break}else d=f}}if((j|0)==19){c[n>>2]=e;j=26;break}else if((j|0)==23){c[n>>2]=d;f=e;e=d;j=26;break}else if((j|0)==25){c[n>>2]=d;if(!d){f=n;e=d;j=26;break}else break}}else{c[n>>2]=m;f=m;e=m;j=26}while(0);if((j|0)==26){d=Nu(32)|0;n=d+16|0;c[n>>2]=g;c[n+4>>2]=h;c[d+24>>2]=0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=e;c[f>>2]=d;e=c[c[a>>2]>>2]|0;if(!e)e=d;else{c[a>>2]=e;e=c[f>>2]|0}ic(c[a+4>>2]|0,e);a=a+8|0;c[a>>2]=(c[a>>2]|0)+1}a=d+24|0;n=Nu(12)|0;c[n>>2]=1932;c[n+4>>2]=1;c[n+8>>2]=0;d=c[a>>2]|0;c[a>>2]=n;if(!d){i=o;return}Bb[c[(c[d>>2]|0)+4>>2]&255](d);i=o;return}function ic(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0;j=(d|0)==(b|0);a[d+12>>0]=j&1;if(j)return;while(1){h=c[d+8>>2]|0;g=h+12|0;if(a[g>>0]|0){d=37;break}j=h+8|0;f=d;d=c[j>>2]|0;e=c[d>>2]|0;if((e|0)==(h|0)){e=c[d+4>>2]|0;if(!e){e=f;i=j;g=j;f=d;b=d;d=8;break}e=e+12|0;if(a[e>>0]|0){e=f;i=j;g=j;f=d;b=d;d=8;break}a[g>>0]=1;a[d+12>>0]=(d|0)==(b|0)&1;a[e>>0]=1}else{if(!e){e=f;i=j;b=j;f=d;g=d;d=24;break}e=e+12|0;if(a[e>>0]|0){e=f;i=j;b=j;f=d;g=d;d=24;break}a[g>>0]=1;a[d+12>>0]=(d|0)==(b|0)&1;a[e>>0]=1}if((d|0)==(b|0)){d=37;break}}if((d|0)==8){if((c[h>>2]|0)==(e|0))d=h;else{j=h+4|0;d=c[j>>2]|0;e=c[d>>2]|0;c[j>>2]=e;if(!e)e=f;else{c[e+8>>2]=h;e=c[i>>2]|0}f=d+8|0;c[f>>2]=e;e=c[g>>2]|0;if((c[e>>2]|0)==(h|0))c[e>>2]=d;else c[e+4>>2]=d;c[d>>2]=h;c[i>>2]=d;b=c[f>>2]|0}a[d+12>>0]=1;a[b+12>>0]=0;f=c[b>>2]|0;g=f+4|0;d=c[g>>2]|0;c[b>>2]=d;if(d|0)c[d+8>>2]=b;d=b+8|0;c[f+8>>2]=c[d>>2];e=c[d>>2]|0;if((c[e>>2]|0)==(b|0))c[e>>2]=f;else c[e+4>>2]=f;c[g>>2]=b;c[d>>2]=f;return}else if((d|0)==24){if((c[h>>2]|0)==(e|0)){d=c[h>>2]|0;g=d+4|0;e=c[g>>2]|0;c[h>>2]=e;if(!e)e=f;else{c[e+8>>2]=h;e=c[i>>2]|0}f=d+8|0;c[f>>2]=e;e=c[b>>2]|0;if((c[e>>2]|0)==(h|0))c[e>>2]=d;else c[e+4>>2]=d;c[g>>2]=h;c[i>>2]=d;g=c[f>>2]|0}else d=h;a[d+12>>0]=1;a[g+12>>0]=0;j=g+4|0;f=c[j>>2]|0;d=c[f>>2]|0;c[j>>2]=d;if(d|0)c[d+8>>2]=g;d=g+8|0;c[f+8>>2]=c[d>>2];e=c[d>>2]|0;if((c[e>>2]|0)==(g|0))c[e>>2]=f;else c[e+4>>2]=f;c[f>>2]=g;c[d>>2]=f;return}else if((d|0)==37)return}function jc(a){a=a|0;return}function kc(a){a=a|0;mu(a);return}function lc(a){a=a|0;return c[a+4>>2]|0}function mc(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;k=a+4|0;l=c[k>>2]|0;g=c[b+5364>>2]|0;a:do switch(g|0){case 4:{d=l<<3|6;if(!(c[b+336+(d<<2)>>2]|0))d=64;else d=c[b+400+(d<<8)>>2]|0;e=l<<3|1;if(!(c[b+336+(e<<2)>>2]|0)){i=(l|0)==1;f=i?d^56:d;d=c[a+8>>2]|0;j=15;break a}else{f=c[b+400+(e<<8)>>2]&4|0?d^7:d;i=(l|0)==1;f=i?f^56:f;d=c[a+8>>2]|0;j=15;break a}}case 2:{d=l<<3|6;if(!(c[b+336+(d<<2)>>2]|0))d=64;else d=c[b+400+(d<<8)>>2]|0;e=l<<3|1;if(!(c[b+336+(e<<2)>>2]|0)){i=(l|0)==1;f=i?d^56:d}else{f=c[b+400+(e<<8)>>2]&4|0?d^7:d;i=(l|0)==1;f=i?f^56:f}d=c[a+8>>2]<<3|6;if(!(c[b+336+(d<<2)>>2]|0))d=64;else d=c[b+400+(d<<8)>>2]|0;e=l<<3|1;if(!(c[b+336+(e<<2)>>2]|0))d=i?d^56:d;else{d=c[b+400+(e<<8)>>2]&4|0?d^7:d;d=i?d^56:d}e=l<<3|1;if(!(c[b+336+(e<<2)>>2]|0))g=64;else g=c[b+400+(e<<8)>>2]|0;e=l<<3|1;if(!(c[b+336+(e<<2)>>2]|0)){h=f;f=g;e=i}else{a=e;e=i;j=33}break}case 1:{d=64;j=13;break}default:{d=c[b+400+((l<<3|6)<<8)>>2]|0;j=13}}while(0);b:do if((j|0)==13){f=c[b+400+((l<<3|1)<<8)>>2]&4|0?d^7:d;e=(l|0)==1;f=e?f^56:f;d=c[a+8>>2]|0;switch(g|0){case 4:{i=e;j=15;break b}case 1:{d=c[b+400+((l<<3|1)<<8)>>2]&4|0?71:64;d=e?d|56:d;break}default:{d=c[b+400+((d<<3|6)<<8)>>2]|0;d=c[b+400+((l<<3|1)<<8)>>2]&4|0?d^7:d;d=e?d^56:d}}g=c[b+400+((l<<3|1)<<8)>>2]|0;a=l<<3|1;j=33}while(0);if((j|0)==15){d=d<<3|6;if(!(c[b+336+(d<<2)>>2]|0))d=64;else d=c[b+400+(d<<8)>>2]|0;e=l<<3|1;if(!(c[b+336+(e<<2)>>2]|0))d=i?d^56:d;else{d=c[b+400+(e<<8)>>2]&4|0?d^7:d;d=i?d^56:d}e=l<<3|1;if(!(c[b+336+(e<<2)>>2]|0))g=64;else g=c[b+400+(e<<8)>>2]|0;e=l<<3|1;if(!(c[b+336+(e<<2)>>2]|0)){h=f;f=g;e=i}else{a=e;e=i;j=33}}if((j|0)==33){h=f;f=c[b+400+(a<<8)>>2]&4|0?g^7:g}f=e?f^56:f;e=b+5348|0;if(Xb(h,f,d,(l|0)!=(c[e>>2]|0)&1)|0){l=f>>3;return ((c[k>>2]|0)==(c[e>>2]|0)?l+10248|0:-10248-l|0)|0}else return 0;return 0}function nc(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;o=i;i=i+11184|0;n=o+11176|0;l=o+5368|0;g=o+5808|0;k=o;Wu(g|0,0,5368)|0;g=(c[(Hf(g,b,0,0,l)|0)+5356>>2]|0)+8|0;h=c[g>>2]|0;g=c[g+4>>2]|0;m=a+4|0;d=c[m>>2]|0;do if(d){while(1){f=d+16|0;e=c[f>>2]|0;f=c[f+4>>2]|0;if(g>>>0<f>>>0|(g|0)==(f|0)&h>>>0<e>>>0){e=c[d>>2]|0;if(!e){e=d;j=4;break}else d=e}else{if(!(f>>>0<g>>>0|(f|0)==(g|0)&e>>>0<h>>>0)){j=10;break}e=d+4|0;f=c[e>>2]|0;if(!f){j=8;break}else d=f}}if((j|0)==4){c[n>>2]=d;j=11;break}else if((j|0)==8){c[n>>2]=d;j=11;break}else if((j|0)==10){c[n>>2]=d;if(!d){e=n;j=11;break}else break}}else{c[n>>2]=m;e=m;d=m;j=11}while(0);if((j|0)==11){f=Nu(32)|0;j=f+16|0;c[j>>2]=h;c[j+4>>2]=g;c[f+24>>2]=0;c[f>>2]=0;c[f+4>>2]=0;c[f+8>>2]=d;c[e>>2]=f;d=c[c[a>>2]>>2]|0;if(!d)d=f;else{c[a>>2]=d;d=c[e>>2]|0}ic(c[a+4>>2]|0,d);d=a+8|0;c[d>>2]=(c[d>>2]|0)+1;d=f}j=d+24|0;h=Nu(12)|0;c[h>>2]=1956;c[h+4>>2]=0;c[h+8>>2]=1;d=c[j>>2]|0;c[j>>2]=h;if(d|0)Bb[c[(c[d>>2]|0)+4>>2]&255](d);Wu(k|0,0,5368)|0;h=(c[(Hf(k,b,1,0,l)|0)+5356>>2]|0)+8|0;g=c[h>>2]|0;h=c[h+4>>2]|0;d=c[m>>2]|0;do if(d){while(1){f=d+16|0;e=c[f>>2]|0;f=c[f+4>>2]|0;if(h>>>0<f>>>0|(h|0)==(f|0)&g>>>0<e>>>0){e=c[d>>2]|0;if(!e){f=d;e=d;j=19;break}else d=e}else{if(!(f>>>0<h>>>0|(f|0)==(h|0)&e>>>0<g>>>0)){j=25;break}e=d+4|0;f=c[e>>2]|0;if(!f){j=23;break}else d=f}}if((j|0)==19){c[n>>2]=e;j=26;break}else if((j|0)==23){c[n>>2]=d;f=e;e=d;j=26;break}else if((j|0)==25){c[n>>2]=d;if(!d){f=n;e=d;j=26;break}else break}}else{c[n>>2]=m;f=m;e=m;j=26}while(0);if((j|0)==26){d=Nu(32)|0;n=d+16|0;c[n>>2]=g;c[n+4>>2]=h;c[d+24>>2]=0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=e;c[f>>2]=d;e=c[c[a>>2]>>2]|0;if(!e)e=d;else{c[a>>2]=e;e=c[f>>2]|0}ic(c[a+4>>2]|0,e);a=a+8|0;c[a>>2]=(c[a>>2]|0)+1}a=d+24|0;n=Nu(12)|0;c[n>>2]=1956;c[n+4>>2]=1;c[n+8>>2]=0;d=c[a>>2]|0;c[a>>2]=n;if(!d){i=o;return}Bb[c[(c[d>>2]|0)+4>>2]&255](d);i=o;return}function oc(a){a=a|0;mu(a);return}function pc(a){a=a|0;return c[a+4>>2]|0}function qc(a,b){a=a|0;b=b|0;return 0}function rc(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;o=i;i=i+11184|0;n=o+11176|0;l=o+5368|0;g=o+5808|0;k=o;Wu(g|0,0,5368)|0;g=(c[(Hf(g,b,0,0,l)|0)+5356>>2]|0)+8|0;h=c[g>>2]|0;g=c[g+4>>2]|0;m=a+4|0;d=c[m>>2]|0;do if(d){while(1){f=d+16|0;e=c[f>>2]|0;f=c[f+4>>2]|0;if(g>>>0<f>>>0|(g|0)==(f|0)&h>>>0<e>>>0){e=c[d>>2]|0;if(!e){e=d;j=4;break}else d=e}else{if(!(f>>>0<g>>>0|(f|0)==(g|0)&e>>>0<h>>>0)){j=10;break}e=d+4|0;f=c[e>>2]|0;if(!f){j=8;break}else d=f}}if((j|0)==4){c[n>>2]=d;j=11;break}else if((j|0)==8){c[n>>2]=d;j=11;break}else if((j|0)==10){c[n>>2]=d;if(!d){e=n;j=11;break}else break}}else{c[n>>2]=m;e=m;d=m;j=11}while(0);if((j|0)==11){f=Nu(32)|0;j=f+16|0;c[j>>2]=h;c[j+4>>2]=g;c[f+24>>2]=0;c[f>>2]=0;c[f+4>>2]=0;c[f+8>>2]=d;c[e>>2]=f;d=c[c[a>>2]>>2]|0;if(!d)d=f;else{c[a>>2]=d;d=c[e>>2]|0}ic(c[a+4>>2]|0,d);d=a+8|0;c[d>>2]=(c[d>>2]|0)+1;d=f}j=d+24|0;h=Nu(12)|0;c[h>>2]=1980;c[h+4>>2]=0;c[h+8>>2]=1;d=c[j>>2]|0;c[j>>2]=h;if(d|0)Bb[c[(c[d>>2]|0)+4>>2]&255](d);Wu(k|0,0,5368)|0;h=(c[(Hf(k,b,1,0,l)|0)+5356>>2]|0)+8|0;g=c[h>>2]|0;h=c[h+4>>2]|0;d=c[m>>2]|0;do if(d){while(1){f=d+16|0;e=c[f>>2]|0;f=c[f+4>>2]|0;if(h>>>0<f>>>0|(h|0)==(f|0)&g>>>0<e>>>0){e=c[d>>2]|0;if(!e){f=d;e=d;j=19;break}else d=e}else{if(!(f>>>0<h>>>0|(f|0)==(h|0)&e>>>0<g>>>0)){j=25;break}e=d+4|0;f=c[e>>2]|0;if(!f){j=23;break}else d=f}}if((j|0)==19){c[n>>2]=e;j=26;break}else if((j|0)==23){c[n>>2]=d;f=e;e=d;j=26;break}else if((j|0)==25){c[n>>2]=d;if(!d){f=n;e=d;j=26;break}else break}}else{c[n>>2]=m;f=m;e=m;j=26}while(0);if((j|0)==26){d=Nu(32)|0;n=d+16|0;c[n>>2]=g;c[n+4>>2]=h;c[d+24>>2]=0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=e;c[f>>2]=d;e=c[c[a>>2]>>2]|0;if(!e)e=d;else{c[a>>2]=e;e=c[f>>2]|0}ic(c[a+4>>2]|0,e);a=a+8|0;c[a>>2]=(c[a>>2]|0)+1}a=d+24|0;n=Nu(12)|0;c[n>>2]=1980;c[n+4>>2]=1;c[n+8>>2]=0;d=c[a>>2]|0;c[a>>2]=n;if(!d){i=o;return}Bb[c[(c[d>>2]|0)+4>>2]&255](d);i=o;return}function sc(a){a=a|0;mu(a);return}function tc(a){a=a|0;return c[a+4>>2]|0}function uc(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;f=c[a+4>>2]|0;switch(c[b+5364>>2]|0){case 4:{d=f<<3|6;if(!(c[b+336+(d<<2)>>2]|0))e=64;else e=c[b+400+(d<<8)>>2]|0;d=c[a+8>>2]<<3|6;if(!(c[b+336+(d<<2)>>2]|0))d=64;else d=c[b+400+(d<<8)>>2]|0;if(!(c[b+336+((f<<3|3)<<2)>>2]|0))a=64;else g=12;break}case 2:{d=f<<3|6;if(!(c[b+336+(d<<2)>>2]|0))e=64;else e=c[b+400+(d<<8)>>2]|0;d=c[a+8>>2]<<3|6;if(!(c[b+336+(d<<2)>>2]|0))d=64;else d=c[b+400+(d<<8)>>2]|0;a=f<<3|3;if(!(c[b+336+(a<<2)>>2]|0))a=64;else g=14;break}case 1:{d=64;e=64;g=12;break}default:{d=c[b+400+((c[a+8>>2]<<3|6)<<8)>>2]|0;e=c[b+400+((f<<3|6)<<8)>>2]|0;g=12}}if((g|0)==12){a=f<<3|3;g=14}if((g|0)==14)a=c[b+400+(a<<8)>>2]|0;a=((a>>>3^a)&1|0)!=0;g=a?d^56:d;g=(c[1996+(c[1014620+((a?e^56:e)<<8)+(g<<2)>>2]<<2)>>2]|0)+1e4+(c[2028+(g<<2)>>2]|0)|0;return ((f|0)==(c[b+5348>>2]|0)?g:0-g|0)|0}function vc(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;o=i;i=i+11184|0;n=o+11176|0;l=o+5368|0;g=o+5808|0;k=o;Wu(g|0,0,5368)|0;g=(c[(Hf(g,b,0,0,l)|0)+5356>>2]|0)+8|0;h=c[g>>2]|0;g=c[g+4>>2]|0;m=a+4|0;d=c[m>>2]|0;do if(d){while(1){f=d+16|0;e=c[f>>2]|0;f=c[f+4>>2]|0;if(g>>>0<f>>>0|(g|0)==(f|0)&h>>>0<e>>>0){e=c[d>>2]|0;if(!e){e=d;j=4;break}else d=e}else{if(!(f>>>0<g>>>0|(f|0)==(g|0)&e>>>0<h>>>0)){j=10;break}e=d+4|0;f=c[e>>2]|0;if(!f){j=8;break}else d=f}}if((j|0)==4){c[n>>2]=d;j=11;break}else if((j|0)==8){c[n>>2]=d;j=11;break}else if((j|0)==10){c[n>>2]=d;if(!d){e=n;j=11;break}else break}}else{c[n>>2]=m;e=m;d=m;j=11}while(0);if((j|0)==11){f=Nu(32)|0;j=f+16|0;c[j>>2]=h;c[j+4>>2]=g;c[f+24>>2]=0;c[f>>2]=0;c[f+4>>2]=0;c[f+8>>2]=d;c[e>>2]=f;d=c[c[a>>2]>>2]|0;if(!d)d=f;else{c[a>>2]=d;d=c[e>>2]|0}ic(c[a+4>>2]|0,d);d=a+8|0;c[d>>2]=(c[d>>2]|0)+1;d=f}j=d+24|0;h=Nu(12)|0;c[h>>2]=2292;c[h+4>>2]=0;c[h+8>>2]=1;d=c[j>>2]|0;c[j>>2]=h;if(d|0)Bb[c[(c[d>>2]|0)+4>>2]&255](d);Wu(k|0,0,5368)|0;h=(c[(Hf(k,b,1,0,l)|0)+5356>>2]|0)+8|0;g=c[h>>2]|0;h=c[h+4>>2]|0;d=c[m>>2]|0;do if(d){while(1){f=d+16|0;e=c[f>>2]|0;f=c[f+4>>2]|0;if(h>>>0<f>>>0|(h|0)==(f|0)&g>>>0<e>>>0){e=c[d>>2]|0;if(!e){f=d;e=d;j=19;break}else d=e}else{if(!(f>>>0<h>>>0|(f|0)==(h|0)&e>>>0<g>>>0)){j=25;break}e=d+4|0;f=c[e>>2]|0;if(!f){j=23;break}else d=f}}if((j|0)==19){c[n>>2]=e;j=26;break}else if((j|0)==23){c[n>>2]=d;f=e;e=d;j=26;break}else if((j|0)==25){c[n>>2]=d;if(!d){f=n;e=d;j=26;break}else break}}else{c[n>>2]=m;f=m;e=m;j=26}while(0);if((j|0)==26){d=Nu(32)|0;n=d+16|0;c[n>>2]=g;c[n+4>>2]=h;c[d+24>>2]=0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=e;c[f>>2]=d;e=c[c[a>>2]>>2]|0;if(!e)e=d;else{c[a>>2]=e;e=c[f>>2]|0}ic(c[a+4>>2]|0,e);a=a+8|0;c[a>>2]=(c[a>>2]|0)+1}a=d+24|0;n=Nu(12)|0;c[n>>2]=2292;c[n+4>>2]=1;c[n+8>>2]=0;d=c[a>>2]|0;c[a>>2]=n;if(!d){i=o;return}Bb[c[(c[d>>2]|0)+4>>2]&255](d);i=o;return}function wc(a){a=a|0;mu(a);return}function xc(a){a=a|0;return c[a+4>>2]|0}function yc(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;l=c[a+4>>2]|0;switch(c[b+5364>>2]|0){case 4:{d=l<<3|6;if(!(c[b+336+(d<<2)>>2]|0)){e=l*56|0;f=e^64}else{e=l*56|0;f=c[b+400+(d<<8)>>2]^e}h=a+8|0;d=c[h>>2]<<3|6;if(!(c[b+336+(d<<2)>>2]|0))d=64;else d=c[b+400+(d<<8)>>2]|0;g=d^e;d=l<<3|4;if(!(c[b+336+(d<<2)>>2]|0))d=64;else d=c[b+400+(d<<8)>>2]|0;a=d^e;h=c[h>>2]|0;d=h<<3|1;if(!(c[b+336+(d<<2)>>2]|0)){d=64;j=f;i=h;h=a}else k=21;break}case 2:{d=l<<3|6;if(!(c[b+336+(d<<2)>>2]|0)){e=l*56|0;f=e^64}else{e=l*56|0;f=c[b+400+(d<<8)>>2]^e}h=a+8|0;d=c[h>>2]<<3|6;if(!(c[b+336+(d<<2)>>2]|0))d=64;else d=c[b+400+(d<<8)>>2]|0;g=d^e;d=l<<3|4;if(!(c[b+336+(d<<2)>>2]|0))d=64;else d=c[b+400+(d<<8)>>2]|0;a=d^e;h=c[h>>2]|0;d=h<<3|1;if(!(c[b+336+(d<<2)>>2]|0)){d=64;j=f;i=h;h=a}else k=21;break}case 1:{g=l*56|0;d=a+8|0;e=g;a=c[b+400+((l<<3|4)<<8)>>2]^g;f=g^64;g=g^64;k=18;break}default:{g=l*56|0;k=a+8|0;d=k;e=g;a=c[b+400+((l<<3|4)<<8)>>2]^g;f=c[b+400+((l<<3|6)<<8)>>2]^g;g=c[b+400+((c[k>>2]<<3|6)<<8)>>2]^g;k=18}}if((k|0)==18){h=c[d>>2]|0;d=h<<3|1;k=21}if((k|0)==21){d=c[b+400+(d<<8)>>2]|0;j=f;i=h;h=a}f=d^e;a=d&7;if((j|0)<(f|0)&(j&7|0)==(a|0)){m=c[b+5348>>2]|0;b=1371-(c[1014620+(j<<8)+(f<<2)>>2]|0)|0;l=(l|0)==(m|0);m=0-b|0;m=l?b:m;return m|0}e=c[1014620+(g<<8)+(f<<2)>>2]|0;d=c[b+5348>>2]|0;if((e|0)>=(((d|0)==(i|0)?4:3)|0)?(c[1014620+(g<<8)+(h<<2)>>2]|0)>2:0){m=d;b=1371-(c[1014620+(j<<8)+(f<<2)>>2]|0)|0;l=(l|0)==(m|0);m=0-b|0;m=l?b:m;return m|0}if(((g>>3|0)<3?(j>>3|0)>2&(e|0)==1:0)?(m=c[1014620+(j<<8)+(f<<2)>>2]|0,(m|0)>(((d|0)==(l|0)?3:2)|0)):0){k=d;b=80-(m<<3)|0;l=(l|0)==(k|0);m=0-b|0;m=l?b:m;return m|0}b=f+-8|0;m=d;b=200-((c[1014620+(j<<8)+(b<<2)>>2]|0)-(c[1014620+(g<<8)+(b<<2)>>2]|0)-(c[1014620+(f<<8)+(a<<2)>>2]|0)<<3)|0;l=(l|0)==(m|0);m=0-b|0;m=l?b:m;return m|0}function zc(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;o=i;i=i+11184|0;n=o+11176|0;l=o+5368|0;g=o+5808|0;k=o;Wu(g|0,0,5368)|0;g=(c[(Hf(g,b,0,0,l)|0)+5356>>2]|0)+8|0;h=c[g>>2]|0;g=c[g+4>>2]|0;m=a+4|0;d=c[m>>2]|0;do if(d){while(1){f=d+16|0;e=c[f>>2]|0;f=c[f+4>>2]|0;if(g>>>0<f>>>0|(g|0)==(f|0)&h>>>0<e>>>0){e=c[d>>2]|0;if(!e){e=d;j=4;break}else d=e}else{if(!(f>>>0<g>>>0|(f|0)==(g|0)&e>>>0<h>>>0)){j=10;break}e=d+4|0;f=c[e>>2]|0;if(!f){j=8;break}else d=f}}if((j|0)==4){c[n>>2]=d;j=11;break}else if((j|0)==8){c[n>>2]=d;j=11;break}else if((j|0)==10){c[n>>2]=d;if(!d){e=n;j=11;break}else break}}else{c[n>>2]=m;e=m;d=m;j=11}while(0);if((j|0)==11){f=Nu(32)|0;j=f+16|0;c[j>>2]=h;c[j+4>>2]=g;c[f+24>>2]=0;c[f>>2]=0;c[f+4>>2]=0;c[f+8>>2]=d;c[e>>2]=f;d=c[c[a>>2]>>2]|0;if(!d)d=f;else{c[a>>2]=d;d=c[e>>2]|0}ic(c[a+4>>2]|0,d);d=a+8|0;c[d>>2]=(c[d>>2]|0)+1;d=f}j=d+24|0;h=Nu(12)|0;c[h>>2]=2316;c[h+4>>2]=0;c[h+8>>2]=1;d=c[j>>2]|0;c[j>>2]=h;if(d|0)Bb[c[(c[d>>2]|0)+4>>2]&255](d);Wu(k|0,0,5368)|0;h=(c[(Hf(k,b,1,0,l)|0)+5356>>2]|0)+8|0;g=c[h>>2]|0;h=c[h+4>>2]|0;d=c[m>>2]|0;do if(d){while(1){f=d+16|0;e=c[f>>2]|0;f=c[f+4>>2]|0;if(h>>>0<f>>>0|(h|0)==(f|0)&g>>>0<e>>>0){e=c[d>>2]|0;if(!e){f=d;e=d;j=19;break}else d=e}else{if(!(f>>>0<h>>>0|(f|0)==(h|0)&e>>>0<g>>>0)){j=25;break}e=d+4|0;f=c[e>>2]|0;if(!f){j=23;break}else d=f}}if((j|0)==19){c[n>>2]=e;j=26;break}else if((j|0)==23){c[n>>2]=d;f=e;e=d;j=26;break}else if((j|0)==25){c[n>>2]=d;if(!d){f=n;e=d;j=26;break}else break}}else{c[n>>2]=m;f=m;e=m;j=26}while(0);if((j|0)==26){d=Nu(32)|0;n=d+16|0;c[n>>2]=g;c[n+4>>2]=h;c[d+24>>2]=0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=e;c[f>>2]=d;e=c[c[a>>2]>>2]|0;if(!e)e=d;else{c[a>>2]=e;e=c[f>>2]|0}ic(c[a+4>>2]|0,e);a=a+8|0;c[a>>2]=(c[a>>2]|0)+1}a=d+24|0;n=Nu(12)|0;c[n>>2]=2316;c[n+4>>2]=1;c[n+8>>2]=0;d=c[a>>2]|0;c[a>>2]=n;if(!d){i=o;return}Bb[c[(c[d>>2]|0)+4>>2]&255](d);i=o;return}function Ac(a){a=a|0;mu(a);return}function Bc(a){a=a|0;return c[a+4>>2]|0}function Cc(a,b){a=a|0;b=b|0;var d=0,e=0;d=c[a+8>>2]|0;switch(c[b+5364>>2]|0){case 4:{d=d<<3|6;if(!(c[b+336+(d<<2)>>2]|0))d=64;else e=5;break}case 2:{d=d<<3|6;if(!(c[b+336+(d<<2)>>2]|0))d=64;else e=5;break}case 1:{d=64;break}default:{d=d<<3|6;e=5}}if((e|0)==5)d=c[b+400+(d<<8)>>2]|0;e=c[2332+(d<<2)>>2]|0;return ((c[a+4>>2]|0)==(c[b+5348>>2]|0)?e:0-e|0)|0}function Dc(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;o=i;i=i+11184|0;n=o+11176|0;l=o+5368|0;g=o+5808|0;k=o;Wu(g|0,0,5368)|0;g=(c[(Hf(g,b,0,0,l)|0)+5356>>2]|0)+8|0;h=c[g>>2]|0;g=c[g+4>>2]|0;m=a+4|0;d=c[m>>2]|0;do if(d){while(1){f=d+16|0;e=c[f>>2]|0;f=c[f+4>>2]|0;if(g>>>0<f>>>0|(g|0)==(f|0)&h>>>0<e>>>0){e=c[d>>2]|0;if(!e){e=d;j=4;break}else d=e}else{if(!(f>>>0<g>>>0|(f|0)==(g|0)&e>>>0<h>>>0)){j=10;break}e=d+4|0;f=c[e>>2]|0;if(!f){j=8;break}else d=f}}if((j|0)==4){c[n>>2]=d;j=11;break}else if((j|0)==8){c[n>>2]=d;j=11;break}else if((j|0)==10){c[n>>2]=d;if(!d){e=n;j=11;break}else break}}else{c[n>>2]=m;e=m;d=m;j=11}while(0);if((j|0)==11){f=Nu(32)|0;j=f+16|0;c[j>>2]=h;c[j+4>>2]=g;c[f+24>>2]=0;c[f>>2]=0;c[f+4>>2]=0;c[f+8>>2]=d;c[e>>2]=f;d=c[c[a>>2]>>2]|0;if(!d)d=f;else{c[a>>2]=d;d=c[e>>2]|0}ic(c[a+4>>2]|0,d);d=a+8|0;c[d>>2]=(c[d>>2]|0)+1;d=f}j=d+24|0;h=Nu(12)|0;c[h>>2]=2596;c[h+4>>2]=0;c[h+8>>2]=1;d=c[j>>2]|0;c[j>>2]=h;if(d|0)Bb[c[(c[d>>2]|0)+4>>2]&255](d);Wu(k|0,0,5368)|0;h=(c[(Hf(k,b,1,0,l)|0)+5356>>2]|0)+8|0;g=c[h>>2]|0;h=c[h+4>>2]|0;d=c[m>>2]|0;do if(d){while(1){f=d+16|0;e=c[f>>2]|0;f=c[f+4>>2]|0;if(h>>>0<f>>>0|(h|0)==(f|0)&g>>>0<e>>>0){e=c[d>>2]|0;if(!e){f=d;e=d;j=19;break}else d=e}else{if(!(f>>>0<h>>>0|(f|0)==(h|0)&e>>>0<g>>>0)){j=25;break}e=d+4|0;f=c[e>>2]|0;if(!f){j=23;break}else d=f}}if((j|0)==19){c[n>>2]=e;j=26;break}else if((j|0)==23){c[n>>2]=d;f=e;e=d;j=26;break}else if((j|0)==25){c[n>>2]=d;if(!d){f=n;e=d;j=26;break}else break}}else{c[n>>2]=m;f=m;e=m;j=26}while(0);if((j|0)==26){d=Nu(32)|0;n=d+16|0;c[n>>2]=g;c[n+4>>2]=h;c[d+24>>2]=0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=e;c[f>>2]=d;e=c[c[a>>2]>>2]|0;if(!e)e=d;else{c[a>>2]=e;e=c[f>>2]|0}ic(c[a+4>>2]|0,e);a=a+8|0;c[a>>2]=(c[a>>2]|0)+1}a=d+24|0;n=Nu(12)|0;c[n>>2]=2596;c[n+4>>2]=1;c[n+8>>2]=0;d=c[a>>2]|0;c[a>>2]=n;if(!d){i=o;return}Bb[c[(c[d>>2]|0)+4>>2]&255](d);i=o;return}function Ec(a){a=a|0;mu(a);return}function Fc(a){a=a|0;return c[a+4>>2]|0}function Gc(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;e=c[a+8>>2]|0;switch(c[b+5364>>2]|0){case 4:{d=e<<3|6;if(!(c[b+336+(d<<2)>>2]|0))d=64;else d=c[b+400+(d<<8)>>2]|0;if(!(c[b+336+((e<<3|2)<<2)>>2]|0))e=64;else f=8;break}case 2:{d=e<<3|6;if(!(c[b+336+(d<<2)>>2]|0))d=64;else d=c[b+400+(d<<8)>>2]|0;e=e<<3|2;if(!(c[b+336+(e<<2)>>2]|0))e=64;else f=10;break}case 1:{d=64;f=8;break}default:{d=c[b+400+((e<<3|6)<<8)>>2]|0;f=8}}if((f|0)==8){e=e<<3|2;f=10}if((f|0)==10)e=c[b+400+(e<<8)>>2]|0;f=(c[2612+(c[1014620+(d<<8)+(e<<2)>>2]<<2)>>2]|0)+(c[2332+(d<<2)>>2]|0)|0;return ((c[a+4>>2]|0)==(c[b+5348>>2]|0)?f:0-f|0)|0}function Hc(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;o=i;i=i+11184|0;n=o+11176|0;l=o+5368|0;g=o+5808|0;k=o;Wu(g|0,0,5368)|0;g=(c[(Hf(g,b,0,0,l)|0)+5356>>2]|0)+8|0;h=c[g>>2]|0;g=c[g+4>>2]|0;m=a+4|0;d=c[m>>2]|0;do if(d){while(1){f=d+16|0;e=c[f>>2]|0;f=c[f+4>>2]|0;if(g>>>0<f>>>0|(g|0)==(f|0)&h>>>0<e>>>0){e=c[d>>2]|0;if(!e){e=d;j=4;break}else d=e}else{if(!(f>>>0<g>>>0|(f|0)==(g|0)&e>>>0<h>>>0)){j=10;break}e=d+4|0;f=c[e>>2]|0;if(!f){j=8;break}else d=f}}if((j|0)==4){c[n>>2]=d;j=11;break}else if((j|0)==8){c[n>>2]=d;j=11;break}else if((j|0)==10){c[n>>2]=d;if(!d){e=n;j=11;break}else break}}else{c[n>>2]=m;e=m;d=m;j=11}while(0);if((j|0)==11){f=Nu(32)|0;j=f+16|0;c[j>>2]=h;c[j+4>>2]=g;c[f+24>>2]=0;c[f>>2]=0;c[f+4>>2]=0;c[f+8>>2]=d;c[e>>2]=f;d=c[c[a>>2]>>2]|0;if(!d)d=f;else{c[a>>2]=d;d=c[e>>2]|0}ic(c[a+4>>2]|0,d);d=a+8|0;c[d>>2]=(c[d>>2]|0)+1;d=f}j=d+24|0;h=Nu(12)|0;c[h>>2]=2652;c[h+4>>2]=0;c[h+8>>2]=1;d=c[j>>2]|0;c[j>>2]=h;if(d|0)Bb[c[(c[d>>2]|0)+4>>2]&255](d);Wu(k|0,0,5368)|0;h=(c[(Hf(k,b,1,0,l)|0)+5356>>2]|0)+8|0;g=c[h>>2]|0;h=c[h+4>>2]|0;d=c[m>>2]|0;do if(d){while(1){f=d+16|0;e=c[f>>2]|0;f=c[f+4>>2]|0;if(h>>>0<f>>>0|(h|0)==(f|0)&g>>>0<e>>>0){e=c[d>>2]|0;if(!e){f=d;e=d;j=19;break}else d=e}else{if(!(f>>>0<h>>>0|(f|0)==(h|0)&e>>>0<g>>>0)){j=25;break}e=d+4|0;f=c[e>>2]|0;if(!f){j=23;break}else d=f}}if((j|0)==19){c[n>>2]=e;j=26;break}else if((j|0)==23){c[n>>2]=d;f=e;e=d;j=26;break}else if((j|0)==25){c[n>>2]=d;if(!d){f=n;e=d;j=26;break}else break}}else{c[n>>2]=m;f=m;e=m;j=26}while(0);if((j|0)==26){d=Nu(32)|0;n=d+16|0;c[n>>2]=g;c[n+4>>2]=h;c[d+24>>2]=0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=e;c[f>>2]=d;e=c[c[a>>2]>>2]|0;if(!e)e=d;else{c[a>>2]=e;e=c[f>>2]|0}ic(c[a+4>>2]|0,e);a=a+8|0;c[a>>2]=(c[a>>2]|0)+1}a=d+24|0;n=Nu(12)|0;c[n>>2]=2652;c[n+4>>2]=1;c[n+8>>2]=0;d=c[a>>2]|0;c[a>>2]=n;if(!d){i=o;return}Bb[c[(c[d>>2]|0)+4>>2]&255](d);i=o;return}function Ic(a){a=a|0;mu(a);return}function Jc(a){a=a|0;return c[a+4>>2]|0}function Kc(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0;i=c[a+4>>2]|0;switch(c[b+5364>>2]|0){case 4:{d=i<<3|6;if(!(c[b+336+(d<<2)>>2]|0))e=64;else e=c[b+400+(d<<8)>>2]|0;a=c[a+8>>2]|0;d=a<<3|6;if(!(c[b+336+(d<<2)>>2]|0))d=64;else d=c[b+400+(d<<8)>>2]|0;if(!(c[b+336+((a<<3|1)<<2)>>2]|0)){g=64;f=d}else h=13;break}case 2:{d=i<<3|6;if(!(c[b+336+(d<<2)>>2]|0))e=64;else e=c[b+400+(d<<8)>>2]|0;a=c[a+8>>2]|0;d=a<<3|6;if(!(c[b+336+(d<<2)>>2]|0))d=64;else d=c[b+400+(d<<8)>>2]|0;f=a<<3|1;if(!(c[b+336+(f<<2)>>2]|0)){g=64;f=d}else h=15;break}case 1:{d=64;e=64;a=c[a+8>>2]|0;h=13;break}default:{a=c[a+8>>2]|0;d=c[b+400+((a<<3|6)<<8)>>2]|0;e=c[b+400+((i<<3|6)<<8)>>2]|0;h=13}}if((h|0)==13){f=a<<3|1;h=15}if((h|0)==15){g=c[b+400+(f<<8)>>2]|0;f=d}d=c[1996+(c[1014620+(e<<8)+(f<<2)>>2]<<2)>>2]|0;if(((a*7^g>>3|0)==6?(c[1014620+(f<<8)+(g<<2)>>2]|0)==1:0)?(h=26112+(g<<3)|0,!((c[h>>2]&-1515870811|0)==0?(c[h+4>>2]&-1515870811|0)==0:0)):0){h=d;b=b+5348|0;b=c[b>>2]|0;i=(i|0)==(b|0);b=0-h|0;b=i?h:b;return b|0}h=d+2402|0;b=b+5348|0;b=c[b>>2]|0;i=(i|0)==(b|0);b=0-h|0;b=i?h:b;return b|0}function Lc(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;o=i;i=i+11184|0;n=o+11176|0;l=o+5368|0;g=o+5808|0;k=o;Wu(g|0,0,5368)|0;g=(c[(Hf(g,b,0,0,l)|0)+5356>>2]|0)+8|0;h=c[g>>2]|0;g=c[g+4>>2]|0;m=a+4|0;d=c[m>>2]|0;do if(d){while(1){f=d+16|0;e=c[f>>2]|0;f=c[f+4>>2]|0;if(g>>>0<f>>>0|(g|0)==(f|0)&h>>>0<e>>>0){e=c[d>>2]|0;if(!e){e=d;j=4;break}else d=e}else{if(!(f>>>0<g>>>0|(f|0)==(g|0)&e>>>0<h>>>0)){j=10;break}e=d+4|0;f=c[e>>2]|0;if(!f){j=8;break}else d=f}}if((j|0)==4){c[n>>2]=d;j=11;break}else if((j|0)==8){c[n>>2]=d;j=11;break}else if((j|0)==10){c[n>>2]=d;if(!d){e=n;j=11;break}else break}}else{c[n>>2]=m;e=m;d=m;j=11}while(0);if((j|0)==11){f=Nu(32)|0;j=f+16|0;c[j>>2]=h;c[j+4>>2]=g;c[f+24>>2]=0;c[f>>2]=0;c[f+4>>2]=0;c[f+8>>2]=d;c[e>>2]=f;d=c[c[a>>2]>>2]|0;if(!d)d=f;else{c[a>>2]=d;d=c[e>>2]|0}ic(c[a+4>>2]|0,d);d=a+8|0;c[d>>2]=(c[d>>2]|0)+1;d=f}j=d+24|0;h=Nu(12)|0;c[h>>2]=2676;c[h+4>>2]=0;c[h+8>>2]=1;d=c[j>>2]|0;c[j>>2]=h;if(d|0)Bb[c[(c[d>>2]|0)+4>>2]&255](d);Wu(k|0,0,5368)|0;h=(c[(Hf(k,b,1,0,l)|0)+5356>>2]|0)+8|0;g=c[h>>2]|0;h=c[h+4>>2]|0;d=c[m>>2]|0;do if(d){while(1){f=d+16|0;e=c[f>>2]|0;f=c[f+4>>2]|0;if(h>>>0<f>>>0|(h|0)==(f|0)&g>>>0<e>>>0){e=c[d>>2]|0;if(!e){f=d;e=d;j=19;break}else d=e}else{if(!(f>>>0<h>>>0|(f|0)==(h|0)&e>>>0<g>>>0)){j=25;break}e=d+4|0;f=c[e>>2]|0;if(!f){j=23;break}else d=f}}if((j|0)==19){c[n>>2]=e;j=26;break}else if((j|0)==23){c[n>>2]=d;f=e;e=d;j=26;break}else if((j|0)==25){c[n>>2]=d;if(!d){f=n;e=d;j=26;break}else break}}else{c[n>>2]=m;f=m;e=m;j=26}while(0);if((j|0)==26){d=Nu(32)|0;n=d+16|0;c[n>>2]=g;c[n+4>>2]=h;c[d+24>>2]=0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=e;c[f>>2]=d;e=c[c[a>>2]>>2]|0;if(!e)e=d;else{c[a>>2]=e;e=c[f>>2]|0}ic(c[a+4>>2]|0,e);a=a+8|0;c[a>>2]=(c[a>>2]|0)+1}a=d+24|0;n=Nu(12)|0;c[n>>2]=2676;c[n+4>>2]=1;c[n+8>>2]=0;d=c[a>>2]|0;c[a>>2]=n;if(!d){i=o;return}Bb[c[(c[d>>2]|0)+4>>2]&255](d);i=o;return}function Mc(a){a=a|0;mu(a);return}function Nc(a){a=a|0;return c[a+4>>2]|0}function Oc(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;e=c[a+4>>2]|0;switch(c[b+5364>>2]|0){case 4:{d=e<<3|6;if(!(c[b+336+(d<<2)>>2]|0))d=64;else d=c[b+400+(d<<8)>>2]|0;a=c[a+8>>2]<<3|6;if(!(c[b+336+(a<<2)>>2]|0))a=64;else f=9;break}case 2:{d=e<<3|6;if(!(c[b+336+(d<<2)>>2]|0))d=64;else d=c[b+400+(d<<8)>>2]|0;a=c[a+8>>2]<<3|6;if(!(c[b+336+(a<<2)>>2]|0))a=64;else f=9;break}case 1:{a=64;d=64;break}default:{d=c[b+400+((e<<3|6)<<8)>>2]|0;a=c[a+8>>2]<<3|6;f=9}}if((f|0)==9)a=c[b+400+(a<<8)>>2]|0;f=(c[2332+(a<<2)>>2]|0)+1279+(c[1996+(c[1014620+(d<<8)+(a<<2)>>2]<<2)>>2]|0)|0;return ((e|0)==(c[b+5348>>2]|0)?f:0-f|0)|0}function Pc(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;p=i;i=i+11184|0;n=p+11176|0;l=p+5368|0;g=p+5808|0;k=p;o=a+12|0;Wu(g|0,0,5368)|0;g=(c[(Hf(g,b,0,0,l)|0)+5356>>2]|0)+8|0;h=c[g>>2]|0;g=c[g+4>>2]|0;m=a+16|0;d=c[m>>2]|0;do if(d){while(1){f=d+16|0;e=c[f>>2]|0;f=c[f+4>>2]|0;if(g>>>0<f>>>0|(g|0)==(f|0)&h>>>0<e>>>0){e=c[d>>2]|0;if(!e){e=d;j=4;break}else d=e}else{if(!(f>>>0<g>>>0|(f|0)==(g|0)&e>>>0<h>>>0)){j=10;break}e=d+4|0;f=c[e>>2]|0;if(!f){j=8;break}else d=f}}if((j|0)==4){c[n>>2]=d;j=11;break}else if((j|0)==8){c[n>>2]=d;j=11;break}else if((j|0)==10){c[n>>2]=d;if(!d){e=n;j=11;break}else break}}else{c[n>>2]=m;e=m;d=m;j=11}while(0);if((j|0)==11){f=Nu(32)|0;j=f+16|0;c[j>>2]=h;c[j+4>>2]=g;c[f+24>>2]=0;c[f>>2]=0;c[f+4>>2]=0;c[f+8>>2]=d;c[e>>2]=f;d=c[c[o>>2]>>2]|0;if(!d)d=f;else{c[o>>2]=d;d=c[e>>2]|0}ic(c[a+16>>2]|0,d);d=a+20|0;c[d>>2]=(c[d>>2]|0)+1;d=f}j=d+24|0;h=Nu(12)|0;c[h>>2]=2700;c[h+4>>2]=0;c[h+8>>2]=1;d=c[j>>2]|0;c[j>>2]=h;if(d|0)Bb[c[(c[d>>2]|0)+4>>2]&255](d);Wu(k|0,0,5368)|0;h=(c[(Hf(k,b,1,0,l)|0)+5356>>2]|0)+8|0;g=c[h>>2]|0;h=c[h+4>>2]|0;d=c[m>>2]|0;do if(d){while(1){f=d+16|0;e=c[f>>2]|0;f=c[f+4>>2]|0;if(h>>>0<f>>>0|(h|0)==(f|0)&g>>>0<e>>>0){e=c[d>>2]|0;if(!e){f=d;e=d;j=19;break}else d=e}else{if(!(f>>>0<h>>>0|(f|0)==(h|0)&e>>>0<g>>>0)){j=25;break}e=d+4|0;f=c[e>>2]|0;if(!f){j=23;break}else d=f}}if((j|0)==19){c[n>>2]=e;j=26;break}else if((j|0)==23){c[n>>2]=d;f=e;e=d;j=26;break}else if((j|0)==25){c[n>>2]=d;if(!d){f=n;e=d;j=26;break}else break}}else{c[n>>2]=m;f=m;e=m;j=26}while(0);if((j|0)==26){d=Nu(32)|0;n=d+16|0;c[n>>2]=g;c[n+4>>2]=h;c[d+24>>2]=0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=e;c[f>>2]=d;e=c[c[o>>2]>>2]|0;if(!e)e=d;else{c[o>>2]=e;e=c[f>>2]|0}ic(c[a+16>>2]|0,e);a=a+20|0;c[a>>2]=(c[a>>2]|0)+1}a=d+24|0;o=Nu(12)|0;c[o>>2]=2700;c[o+4>>2]=1;c[o+8>>2]=0;d=c[a>>2]|0;c[a>>2]=o;if(!d){i=p;return}Bb[c[(c[d>>2]|0)+4>>2]&255](d);i=p;return}function Qc(a){a=a|0;return}function Rc(a){a=a|0;mu(a);return}function Sc(a){a=a|0;return c[a+4>>2]|0}function Tc(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0;h=c[a+4>>2]|0;e=c[b+5364>>2]|0;switch(e|0){case 4:{d=h<<3|1;if(!(c[b+336+(d<<2)>>2]|0))d=64;else d=c[b+400+(d<<8)>>2]|0;e=h<<3|1;if(!(c[b+336+(e<<2)>>2]|0)){f=(h|0)==1;g=f?d^56:d;d=f}else{g=c[b+400+(e<<8)>>2]&4|0?d^7:d;d=(h|0)==1;g=d?g^56:g}e=c[a+8>>2]<<3|6;if(!(c[b+336+(e<<2)>>2]|0))e=64;else e=c[b+400+(e<<8)>>2]|0;f=h<<3|1;if(c[b+336+(f<<2)>>2]|0)i=21;break}case 2:{d=h<<3|1;if(!(c[b+336+(d<<2)>>2]|0))d=64;else d=c[b+400+(d<<8)>>2]|0;e=h<<3|1;if(!(c[b+336+(e<<2)>>2]|0)){f=(h|0)==1;g=f?d^56:d;d=f}else{g=c[b+400+(e<<8)>>2]&4|0?d^7:d;d=(h|0)==1;g=d?g^56:g}e=c[a+8>>2]<<3|6;if(!(c[b+336+(e<<2)>>2]|0))e=64;else e=c[b+400+(e<<8)>>2]|0;f=h<<3|1;if(c[b+336+(f<<2)>>2]|0)i=21;break}default:{f=c[b+400+((h<<3|1)<<8)>>2]|0;f=c[b+400+((h<<3|1)<<8)>>2]&4|0?f^7:f;d=(h|0)==1;if((e|0)==1)e=64;else e=c[b+400+((c[a+8>>2]<<3|6)<<8)>>2]|0;g=d?f^56:f;f=h<<3|1;i=21}}if((i|0)==21)e=c[b+400+(f<<8)>>2]&4|0?e^7:e;if((g|0)==48?(c[1028956+((d?e^56:e)<<2)>>2]|0)<2:0){b=0;return b|0}b=255;return b|0}function Uc(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;p=i;i=i+11184|0;n=p+11176|0;l=p+5368|0;g=p+5808|0;k=p;o=a+12|0;Wu(g|0,0,5368)|0;g=(c[(Hf(g,b,0,0,l)|0)+5356>>2]|0)+8|0;h=c[g>>2]|0;g=c[g+4>>2]|0;m=a+16|0;d=c[m>>2]|0;do if(d){while(1){f=d+16|0;e=c[f>>2]|0;f=c[f+4>>2]|0;if(g>>>0<f>>>0|(g|0)==(f|0)&h>>>0<e>>>0){e=c[d>>2]|0;if(!e){e=d;j=4;break}else d=e}else{if(!(f>>>0<g>>>0|(f|0)==(g|0)&e>>>0<h>>>0)){j=10;break}e=d+4|0;f=c[e>>2]|0;if(!f){j=8;break}else d=f}}if((j|0)==4){c[n>>2]=d;j=11;break}else if((j|0)==8){c[n>>2]=d;j=11;break}else if((j|0)==10){c[n>>2]=d;if(!d){e=n;j=11;break}else break}}else{c[n>>2]=m;e=m;d=m;j=11}while(0);if((j|0)==11){f=Nu(32)|0;j=f+16|0;c[j>>2]=h;c[j+4>>2]=g;c[f+24>>2]=0;c[f>>2]=0;c[f+4>>2]=0;c[f+8>>2]=d;c[e>>2]=f;d=c[c[o>>2]>>2]|0;if(!d)d=f;else{c[o>>2]=d;d=c[e>>2]|0}ic(c[a+16>>2]|0,d);d=a+20|0;c[d>>2]=(c[d>>2]|0)+1;d=f}j=d+24|0;h=Nu(12)|0;c[h>>2]=2724;c[h+4>>2]=0;c[h+8>>2]=1;d=c[j>>2]|0;c[j>>2]=h;if(d|0)Bb[c[(c[d>>2]|0)+4>>2]&255](d);Wu(k|0,0,5368)|0;h=(c[(Hf(k,b,1,0,l)|0)+5356>>2]|0)+8|0;g=c[h>>2]|0;h=c[h+4>>2]|0;d=c[m>>2]|0;do if(d){while(1){f=d+16|0;e=c[f>>2]|0;f=c[f+4>>2]|0;if(h>>>0<f>>>0|(h|0)==(f|0)&g>>>0<e>>>0){e=c[d>>2]|0;if(!e){f=d;e=d;j=19;break}else d=e}else{if(!(f>>>0<h>>>0|(f|0)==(h|0)&e>>>0<g>>>0)){j=25;break}e=d+4|0;f=c[e>>2]|0;if(!f){j=23;break}else d=f}}if((j|0)==19){c[n>>2]=e;j=26;break}else if((j|0)==23){c[n>>2]=d;f=e;e=d;j=26;break}else if((j|0)==25){c[n>>2]=d;if(!d){f=n;e=d;j=26;break}else break}}else{c[n>>2]=m;f=m;e=m;j=26}while(0);if((j|0)==26){d=Nu(32)|0;n=d+16|0;c[n>>2]=g;c[n+4>>2]=h;c[d+24>>2]=0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=e;c[f>>2]=d;e=c[c[o>>2]>>2]|0;if(!e)e=d;else{c[o>>2]=e;e=c[f>>2]|0}ic(c[a+16>>2]|0,e);a=a+20|0;c[a>>2]=(c[a>>2]|0)+1}a=d+24|0;o=Nu(12)|0;c[o>>2]=2724;c[o+4>>2]=1;c[o+8>>2]=0;d=c[a>>2]|0;c[a>>2]=o;if(!d){i=p;return}Bb[c[(c[d>>2]|0)+4>>2]&255](d);i=p;return}function Vc(a){a=a|0;mu(a);return}function Wc(a){a=a|0;return c[a+4>>2]|0}function Xc(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0;g=c[a+4>>2]|0;e=c[b+5364>>2]|0;switch(e|0){case 4:{d=g<<3|1;if(!(c[b+336+(d<<2)>>2]|0))f=64;else f=c[b+400+(d<<8)>>2]|0;e=c[a+8>>2]|0;d=e<<3|3;if(!(c[b+336+(d<<2)>>2]|0))d=64;else d=c[b+400+(d<<8)>>2]|0;e=e<<3|6;if(!(c[b+336+(e<<2)>>2]|0))e=64;else h=14;break}case 2:{d=g<<3|1;if(!(c[b+336+(d<<2)>>2]|0))f=64;else f=c[b+400+(d<<8)>>2]|0;e=c[a+8>>2]|0;d=e<<3|3;if(!(c[b+336+(d<<2)>>2]|0))d=64;else d=c[b+400+(d<<8)>>2]|0;e=e<<3|6;if(!(c[b+336+(e<<2)>>2]|0))e=64;else h=14;break}default:{f=c[b+400+((g<<3|1)<<8)>>2]|0;a=c[a+8>>2]|0;d=c[b+400+((a<<3|3)<<8)>>2]|0;if((e|0)==1)e=64;else{e=a<<3|6;h=14}}}if((h|0)==14)e=c[b+400+(e<<8)>>2]|0;h=104768+(g<<9)+(f<<3)|0;g=b+256|0;a=25088+(d<<3)|0;b=25600+(d<<3)|0;b=(_(c[a+4>>2]&c[g+4>>2],c[b+4>>2]|0)|0)^(_(c[a>>2]&c[g>>2],c[b>>2]|0)|0);b=(c[1031516+(d<<2)>>2]|0)+(b>>>(c[1031772+(d<<2)>>2]|0)<<3)|0;if((c[b>>2]&c[h>>2]|0)==0?(c[b+4>>2]&c[h+4>>2]|0)==0:0){h=255;return h|0}h=c[1014620+(e<<8)+(f<<2)>>2]|0;return h|0}function Yc(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;p=i;i=i+11184|0;n=p+11176|0;l=p+5368|0;g=p+5808|0;k=p;o=a+12|0;Wu(g|0,0,5368)|0;g=(c[(Hf(g,b,0,0,l)|0)+5356>>2]|0)+8|0;h=c[g>>2]|0;g=c[g+4>>2]|0;m=a+16|0;d=c[m>>2]|0;do if(d){while(1){f=d+16|0;e=c[f>>2]|0;f=c[f+4>>2]|0;if(g>>>0<f>>>0|(g|0)==(f|0)&h>>>0<e>>>0){e=c[d>>2]|0;if(!e){e=d;j=4;break}else d=e}else{if(!(f>>>0<g>>>0|(f|0)==(g|0)&e>>>0<h>>>0)){j=10;break}e=d+4|0;f=c[e>>2]|0;if(!f){j=8;break}else d=f}}if((j|0)==4){c[n>>2]=d;j=11;break}else if((j|0)==8){c[n>>2]=d;j=11;break}else if((j|0)==10){c[n>>2]=d;if(!d){e=n;j=11;break}else break}}else{c[n>>2]=m;e=m;d=m;j=11}while(0);if((j|0)==11){f=Nu(32)|0;j=f+16|0;c[j>>2]=h;c[j+4>>2]=g;c[f+24>>2]=0;c[f>>2]=0;c[f+4>>2]=0;c[f+8>>2]=d;c[e>>2]=f;d=c[c[o>>2]>>2]|0;if(!d)d=f;else{c[o>>2]=d;d=c[e>>2]|0}ic(c[a+16>>2]|0,d);d=a+20|0;c[d>>2]=(c[d>>2]|0)+1;d=f}j=d+24|0;h=Nu(12)|0;c[h>>2]=2748;c[h+4>>2]=0;c[h+8>>2]=1;d=c[j>>2]|0;c[j>>2]=h;if(d|0)Bb[c[(c[d>>2]|0)+4>>2]&255](d);Wu(k|0,0,5368)|0;h=(c[(Hf(k,b,1,0,l)|0)+5356>>2]|0)+8|0;g=c[h>>2]|0;h=c[h+4>>2]|0;d=c[m>>2]|0;do if(d){while(1){f=d+16|0;e=c[f>>2]|0;f=c[f+4>>2]|0;if(h>>>0<f>>>0|(h|0)==(f|0)&g>>>0<e>>>0){e=c[d>>2]|0;if(!e){f=d;e=d;j=19;break}else d=e}else{if(!(f>>>0<h>>>0|(f|0)==(h|0)&e>>>0<g>>>0)){j=25;break}e=d+4|0;f=c[e>>2]|0;if(!f){j=23;break}else d=f}}if((j|0)==19){c[n>>2]=e;j=26;break}else if((j|0)==23){c[n>>2]=d;f=e;e=d;j=26;break}else if((j|0)==25){c[n>>2]=d;if(!d){f=n;e=d;j=26;break}else break}}else{c[n>>2]=m;f=m;e=m;j=26}while(0);if((j|0)==26){d=Nu(32)|0;n=d+16|0;c[n>>2]=g;c[n+4>>2]=h;c[d+24>>2]=0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=e;c[f>>2]=d;e=c[c[o>>2]>>2]|0;if(!e)e=d;else{c[o>>2]=e;e=c[f>>2]|0}ic(c[a+16>>2]|0,e);a=a+20|0;c[a>>2]=(c[a>>2]|0)+1}a=d+24|0;o=Nu(12)|0;c[o>>2]=2748;c[o+4>>2]=1;c[o+8>>2]=0;d=c[a>>2]|0;c[a>>2]=o;if(!d){i=p;return}Bb[c[(c[d>>2]|0)+4>>2]&255](d);i=p;return}function Zc(a){a=a|0;mu(a);return}function _c(a){a=a|0;return c[a+4>>2]|0}function $c(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;o=c[a+4>>2]|0;e=c[b+5364>>2]|0;a:do switch(e|0){case 4:{d=o<<3|6;if(!(c[b+336+(d<<2)>>2]|0))d=64;else d=c[b+400+(d<<8)>>2]|0;e=o<<3|1;if(!(c[b+336+(e<<2)>>2]|0)){j=(o|0)==1;i=j?d^56:d;h=c[a+8>>2]|0;n=15;break a}else{i=c[b+400+(e<<8)>>2]&4|0?d^7:d;j=(o|0)==1;i=j?i^56:i;h=c[a+8>>2]|0;n=15;break a}}case 2:{d=o<<3|6;if(!(c[b+336+(d<<2)>>2]|0))d=64;else d=c[b+400+(d<<8)>>2]|0;e=o<<3|1;if(!(c[b+336+(e<<2)>>2]|0)){j=(o|0)==1;i=j?d^56:d}else{i=c[b+400+(e<<8)>>2]&4|0?d^7:d;j=(o|0)==1;i=j?i^56:i}g=c[a+8>>2]|0;d=g<<3|6;if(!(c[b+336+(d<<2)>>2]|0))d=64;else d=c[b+400+(d<<8)>>2]|0;e=o<<3|1;if(!(c[b+336+(e<<2)>>2]|0))a=j?d^56:d;else{a=c[b+400+(e<<8)>>2]&4|0?d^7:d;a=j?a^56:a}d=o<<3|4;if(!(c[b+336+(d<<2)>>2]|0))d=64;else d=c[b+400+(d<<8)>>2]|0;e=o<<3|1;if(!(c[b+336+(e<<2)>>2]|0))e=j?d^56:d;else{e=c[b+400+(e<<8)>>2]&4|0?d^7:d;e=j?e^56:e}d=o<<3|1;if(!(c[b+336+(d<<2)>>2]|0))d=64;else d=c[b+400+(d<<8)>>2]|0;f=o<<3|1;if(!(c[b+336+(f<<2)>>2]|0))d=j?d^56:d;else{d=c[b+400+(f<<8)>>2]&4|0?d^7:d;d=j?d^56:d}f=g<<3|4;if(!(c[b+336+(f<<2)>>2]|0))g=64;else g=c[b+400+(f<<8)>>2]|0;f=o<<3|1;if(!(c[b+336+(f<<2)>>2]|0)){m=i;f=j}else{h=f;f=j;n=53}break}case 1:{d=64;n=13;break}default:{d=c[b+400+((o<<3|6)<<8)>>2]|0;n=13}}while(0);b:do if((n|0)==13){g=c[b+400+((o<<3|1)<<8)>>2]&4|0?d^7:d;f=(o|0)==1;g=f?g^56:g;h=c[a+8>>2]|0;switch(e|0){case 4:{i=g;j=f;n=15;break b}case 1:{a=c[b+400+((o<<3|1)<<8)>>2]&4|0?71:64;e=c[b+400+((o<<3|4)<<8)>>2]|0;e=c[b+400+((o<<3|1)<<8)>>2]&4|0?e^7:e;d=c[b+400+((o<<3|1)<<8)>>2]|0;d=c[b+400+((o<<3|1)<<8)>>2]&4|0?d^7:d;d=f?d^56:d;e=f?e^56:e;a=f?a|56:a;break}default:{a=c[b+400+((h<<3|6)<<8)>>2]|0;a=c[b+400+((o<<3|1)<<8)>>2]&4|0?a^7:a;e=c[b+400+((o<<3|4)<<8)>>2]|0;e=c[b+400+((o<<3|1)<<8)>>2]&4|0?e^7:e;d=c[b+400+((o<<3|1)<<8)>>2]|0;d=c[b+400+((o<<3|1)<<8)>>2]&4|0?d^7:d;d=f?d^56:d;e=f?e^56:e;a=f?a^56:a}}i=g;g=c[b+400+((h<<3|4)<<8)>>2]|0;h=o<<3|1;n=53}while(0);if((n|0)==15){d=h<<3|6;if(!(c[b+336+(d<<2)>>2]|0))d=64;else d=c[b+400+(d<<8)>>2]|0;e=o<<3|1;if(!(c[b+336+(e<<2)>>2]|0))a=j?d^56:d;else{a=c[b+400+(e<<8)>>2]&4|0?d^7:d;a=j?a^56:a}d=o<<3|4;if(!(c[b+336+(d<<2)>>2]|0))d=64;else d=c[b+400+(d<<8)>>2]|0;e=o<<3|1;if(!(c[b+336+(e<<2)>>2]|0))e=j?d^56:d;else{e=c[b+400+(e<<8)>>2]&4|0?d^7:d;e=j?e^56:e}d=o<<3|1;if(!(c[b+336+(d<<2)>>2]|0))d=64;else d=c[b+400+(d<<8)>>2]|0;f=o<<3|1;if(!(c[b+336+(f<<2)>>2]|0))d=j?d^56:d;else{d=c[b+400+(f<<8)>>2]&4|0?d^7:d;d=j?d^56:d}f=h<<3|4;if(!(c[b+336+(f<<2)>>2]|0))g=64;else g=c[b+400+(f<<8)>>2]|0;f=o<<3|1;if(!(c[b+336+(f<<2)>>2]|0)){m=i;f=j}else{h=f;f=j;n=53}}if((n|0)==53){m=i;g=c[b+400+(h<<8)>>2]&4|0?g^7:g}i=f?g^56:g;l=d&7;j=d>>3;k=l|56;g=(c[b+5348>>2]|0)==(o|0);h=g&1;f=(j|0)<5;do if(f){if((m|0)<40?(c[1014620+(a<<8)+(k<<2)>>2]|0)<2:0){if((i&-8|0)==40){s=0;return s|0}if(!((e&-8|0)==40|(j|0)>2)){s=0;return s|0}}}else{if(((j|0)==5?(c[1014620+(a<<8)+(k<<2)>>2]|0)<2:0)?(h+(m>>3)|0)<6:0){if(i>>>0<8){s=0;return s|0}if(g)break;b=i&7;if(((b>>>0<l>>>0?l-b|0:b-l|0)|0)>2)d=0;else break;return d|0}if((a|0)==(k|0)&i>>>0<8){if(!g){s=0;return s|0}if((c[1014620+(m<<8)+(d<<2)>>2]|0)>1){s=0;return s|0}}}while(0);if((a|1|0)==55&((e|0)==56&(d|0)==48)&(i&7|0)==0?(m>>3|0)<5|((m&7)>>>0>2|(i>>3|0)<3):0){s=0;return s|0}if(f){if(((a|0)==(d+8|0)?((c[1014620+(m<<8)+(d<<2)>>2]|0)-h|0)>1:0)?((c[1014620+(m<<8)+(i<<2)>>2]|0)-h|0)>1:0){s=0;return s|0}if(l|0)n=80}else{f=(l|0)!=0;if((((j|0)==6&f?!((e&7|0)!=(l|0)|(e|0)==(k|0)):0)?(p=c[1014620+(m<<8)+(k<<2)>>2]|0,(p|0)<((g?-1:-2)+(c[1014620+(a<<8)+(k<<2)>>2]|0)|0)):0)?(p|0)<((c[1014620+(a<<8)+(e<<2)>>2]|0)+h|0):0){s=128-(p<<1)|0;return s|0}if(f)n=80}do if((((n|0)==80?(e|0)<(d|0)&(e&7|0)==(l|0):0)?(q=c[1014620+(m<<8)+(k<<2)>>2]|0,r=g?-1:-2,(q|0)<(r+(c[1014620+(a<<8)+(k<<2)>>2]|0)|0)):0)?(p=d+8|0,s=c[1014620+(m<<8)+(p<<2)>>2]|0,(s|0)<(r+(c[1014620+(a<<8)+(p<<2)>>2]|0)|0)):0){r=(c[1014620+(a<<8)+(e<<2)>>2]|0)+h|0;if((r|0)<=2?!((q|0)<(r|0)&(s|0)<(r|0)):0)break;s=128-(c[1014620+(d<<8)+(k<<2)>>2]<<3)-(q<<1)|0;return s|0}while(0);if(!((a|0)>(d|0)&(j|0)<4)){s=255;return s|0}d=a&7;if((d|0)==(l|0)){s=10;return s|0}if(((d>>>0<l>>>0?l-d|0:d-l|0)|0)!=1){s=255;return s|0}d=c[1014620+(m<<8)+(a<<2)>>2]|0;if((d|0)<=2){s=255;return s|0}s=24-(d<<1)|0;return s|0}function ad(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;p=i;i=i+11184|0;n=p+11176|0;l=p+5368|0;g=p+5808|0;k=p;o=a+12|0;Wu(g|0,0,5368)|0;g=(c[(Hf(g,b,0,0,l)|0)+5356>>2]|0)+8|0;h=c[g>>2]|0;g=c[g+4>>2]|0;m=a+16|0;d=c[m>>2]|0;do if(d){while(1){f=d+16|0;e=c[f>>2]|0;f=c[f+4>>2]|0;if(g>>>0<f>>>0|(g|0)==(f|0)&h>>>0<e>>>0){e=c[d>>2]|0;if(!e){e=d;j=4;break}else d=e}else{if(!(f>>>0<g>>>0|(f|0)==(g|0)&e>>>0<h>>>0)){j=10;break}e=d+4|0;f=c[e>>2]|0;if(!f){j=8;break}else d=f}}if((j|0)==4){c[n>>2]=d;j=11;break}else if((j|0)==8){c[n>>2]=d;j=11;break}else if((j|0)==10){c[n>>2]=d;if(!d){e=n;j=11;break}else break}}else{c[n>>2]=m;e=m;d=m;j=11}while(0);if((j|0)==11){f=Nu(32)|0;j=f+16|0;c[j>>2]=h;c[j+4>>2]=g;c[f+24>>2]=0;c[f>>2]=0;c[f+4>>2]=0;c[f+8>>2]=d;c[e>>2]=f;d=c[c[o>>2]>>2]|0;if(!d)d=f;else{c[o>>2]=d;d=c[e>>2]|0}ic(c[a+16>>2]|0,d);d=a+20|0;c[d>>2]=(c[d>>2]|0)+1;d=f}j=d+24|0;h=Nu(12)|0;c[h>>2]=2772;c[h+4>>2]=0;c[h+8>>2]=1;d=c[j>>2]|0;c[j>>2]=h;if(d|0)Bb[c[(c[d>>2]|0)+4>>2]&255](d);Wu(k|0,0,5368)|0;h=(c[(Hf(k,b,1,0,l)|0)+5356>>2]|0)+8|0;g=c[h>>2]|0;h=c[h+4>>2]|0;d=c[m>>2]|0;do if(d){while(1){f=d+16|0;e=c[f>>2]|0;f=c[f+4>>2]|0;if(h>>>0<f>>>0|(h|0)==(f|0)&g>>>0<e>>>0){e=c[d>>2]|0;if(!e){f=d;e=d;j=19;break}else d=e}else{if(!(f>>>0<h>>>0|(f|0)==(h|0)&e>>>0<g>>>0)){j=25;break}e=d+4|0;f=c[e>>2]|0;if(!f){j=23;break}else d=f}}if((j|0)==19){c[n>>2]=e;j=26;break}else if((j|0)==23){c[n>>2]=d;f=e;e=d;j=26;break}else if((j|0)==25){c[n>>2]=d;if(!d){f=n;e=d;j=26;break}else break}}else{c[n>>2]=m;f=m;e=m;j=26}while(0);if((j|0)==26){d=Nu(32)|0;n=d+16|0;c[n>>2]=g;c[n+4>>2]=h;c[d+24>>2]=0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=e;c[f>>2]=d;e=c[c[o>>2]>>2]|0;if(!e)e=d;else{c[o>>2]=e;e=c[f>>2]|0}ic(c[a+16>>2]|0,e);a=a+20|0;c[a>>2]=(c[a>>2]|0)+1}a=d+24|0;o=Nu(12)|0;c[o>>2]=2772;c[o+4>>2]=1;c[o+8>>2]=0;d=c[a>>2]|0;c[a>>2]=o;if(!d){i=p;return}Bb[c[(c[d>>2]|0)+4>>2]&255](d);i=p;return}function bd(a){a=a|0;mu(a);return}function cd(a){a=a|0;return c[a+4>>2]|0}function dd(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0;i=b+264|0;if((c[i>>2]&-2122219135|0)==0?(c[i+4>>2]&-2122219135|0)==0:0){j=255;return j|0}e=c[a+8>>2]|0;i=c[b+5364>>2]|0;switch(i|0){case 4:{d=e<<3|6;if(!(c[b+336+(d<<2)>>2]|0))d=64;else d=c[b+400+(d<<8)>>2]|0;e=e<<3|3;if(!(c[b+336+(e<<2)>>2]|0))f=64;else f=c[b+400+(e<<8)>>2]|0;a=c[a+4>>2]|0;e=a<<3|1;if(!(c[b+336+(e<<2)>>2]|0)){h=d;g=64;d=f;e=a}else j=15;break}case 2:{d=e<<3|6;if(!(c[b+336+(d<<2)>>2]|0))d=64;else d=c[b+400+(d<<8)>>2]|0;e=e<<3|3;if(!(c[b+336+(e<<2)>>2]|0))f=64;else f=c[b+400+(e<<8)>>2]|0;a=c[a+4>>2]|0;e=a<<3|1;if(!(c[b+336+(e<<2)>>2]|0)){h=d;g=64;d=f;e=a}else j=15;break}case 1:{d=64;j=12;break}default:{d=c[b+400+((e<<3|6)<<8)>>2]|0;j=12}}if((j|0)==12){a=c[a+4>>2]|0;f=c[b+400+((e<<3|3)<<8)>>2]|0;e=a<<3|1;j=15}if((j|0)==15){h=d;g=c[b+400+(e<<8)>>2]|0;d=f;e=a}a=(e|0)==0?8:-8;a:do switch(e*7^g>>3|0){case 4:{f=g^d;if((f>>>3^f)&1|0){j=255;return j|0}d=c[1014620+((a*3|0)+g<<8)+(h<<2)>>2]|0;if((d|0)<3){if(d|0){d=24;break a}switch(i|0){case 4:{d=e<<3|6;if(!(c[b+336+(d<<2)>>2]|0))d=64;else j=24;break}case 2:{d=e<<3|6;if(!(c[b+336+(d<<2)>>2]|0))d=64;else j=24;break}case 1:{d=64;break}default:{d=e<<3|6;j=24}}if((j|0)==24)d=c[b+400+(d<<8)>>2]|0;if((h|0)!=(d+(a<<1)|0)){d=24;break a}}d=48;break}case 5:{if((c[1014620+((a<<1)+g<<8)+(h<<2)>>2]|0)>=2){j=255;return j|0}j=109376+(d<<3)|0;b=26112+(a+g<<3)|0;if((c[b>>2]&c[j>>2]|0)==0?(c[b+4>>2]&c[j+4>>2]|0)==0:0){j=255;return j|0}b=d&7;j=g&7;if(((b>>>0<j>>>0?j-b|0:b-j|0)|0)>1)d=8;else{j=255;return j|0}break}default:{j=255;return j|0}}while(0);j=d;return j|0}function ed(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;p=i;i=i+11184|0;n=p+11176|0;l=p+5368|0;g=p+5808|0;k=p;o=a+12|0;Wu(g|0,0,5368)|0;g=(c[(Hf(g,b,0,0,l)|0)+5356>>2]|0)+8|0;h=c[g>>2]|0;g=c[g+4>>2]|0;m=a+16|0;d=c[m>>2]|0;do if(d){while(1){f=d+16|0;e=c[f>>2]|0;f=c[f+4>>2]|0;if(g>>>0<f>>>0|(g|0)==(f|0)&h>>>0<e>>>0){e=c[d>>2]|0;if(!e){e=d;j=4;break}else d=e}else{if(!(f>>>0<g>>>0|(f|0)==(g|0)&e>>>0<h>>>0)){j=10;break}e=d+4|0;f=c[e>>2]|0;if(!f){j=8;break}else d=f}}if((j|0)==4){c[n>>2]=d;j=11;break}else if((j|0)==8){c[n>>2]=d;j=11;break}else if((j|0)==10){c[n>>2]=d;if(!d){e=n;j=11;break}else break}}else{c[n>>2]=m;e=m;d=m;j=11}while(0);if((j|0)==11){f=Nu(32)|0;j=f+16|0;c[j>>2]=h;c[j+4>>2]=g;c[f+24>>2]=0;c[f>>2]=0;c[f+4>>2]=0;c[f+8>>2]=d;c[e>>2]=f;d=c[c[o>>2]>>2]|0;if(!d)d=f;else{c[o>>2]=d;d=c[e>>2]|0}ic(c[a+16>>2]|0,d);d=a+20|0;c[d>>2]=(c[d>>2]|0)+1;d=f}j=d+24|0;h=Nu(12)|0;c[h>>2]=2796;c[h+4>>2]=0;c[h+8>>2]=1;d=c[j>>2]|0;c[j>>2]=h;if(d|0)Bb[c[(c[d>>2]|0)+4>>2]&255](d);Wu(k|0,0,5368)|0;h=(c[(Hf(k,b,1,0,l)|0)+5356>>2]|0)+8|0;g=c[h>>2]|0;h=c[h+4>>2]|0;d=c[m>>2]|0;do if(d){while(1){f=d+16|0;e=c[f>>2]|0;f=c[f+4>>2]|0;if(h>>>0<f>>>0|(h|0)==(f|0)&g>>>0<e>>>0){e=c[d>>2]|0;if(!e){f=d;e=d;j=19;break}else d=e}else{if(!(f>>>0<h>>>0|(f|0)==(h|0)&e>>>0<g>>>0)){j=25;break}e=d+4|0;f=c[e>>2]|0;if(!f){j=23;break}else d=f}}if((j|0)==19){c[n>>2]=e;j=26;break}else if((j|0)==23){c[n>>2]=d;f=e;e=d;j=26;break}else if((j|0)==25){c[n>>2]=d;if(!d){f=n;e=d;j=26;break}else break}}else{c[n>>2]=m;f=m;e=m;j=26}while(0);if((j|0)==26){d=Nu(32)|0;n=d+16|0;c[n>>2]=g;c[n+4>>2]=h;c[d+24>>2]=0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=e;c[f>>2]=d;e=c[c[o>>2]>>2]|0;if(!e)e=d;else{c[o>>2]=e;e=c[f>>2]|0}ic(c[a+16>>2]|0,e);a=a+20|0;c[a>>2]=(c[a>>2]|0)+1}a=d+24|0;o=Nu(12)|0;c[o>>2]=2796;c[o+4>>2]=1;c[o+8>>2]=0;d=c[a>>2]|0;c[a>>2]=o;if(!d){i=p;return}Bb[c[(c[d>>2]|0)+4>>2]&255](d);i=p;return}function fd(a){a=a|0;mu(a);return}function gd(a){a=a|0;return c[a+4>>2]|0}function hd(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0;i=c[a+4>>2]|0;e=c[b+5364>>2]|0;switch(e|0){case 4:{d=i<<3|1;if(!(c[b+336+(d<<2)>>2]|0))h=64;else h=c[b+400+(d<<8)>>2]|0;d=i<<3|3;if(!(c[b+336+(d<<2)>>2]|0))e=64;else e=c[b+400+(d<<8)>>2]|0;a=c[a+8>>2]|0;d=a<<3|3;if(!(c[b+336+(d<<2)>>2]|0))g=64;else g=c[b+400+(d<<8)>>2]|0;f=a<<3|6;if(!(c[b+336+(f<<2)>>2]|0)){d=e;e=64;f=h}else{d=e;k=18}break}case 2:{d=i<<3|1;if(!(c[b+336+(d<<2)>>2]|0))h=64;else h=c[b+400+(d<<8)>>2]|0;d=i<<3|3;if(!(c[b+336+(d<<2)>>2]|0))e=64;else e=c[b+400+(d<<8)>>2]|0;a=c[a+8>>2]|0;d=a<<3|3;if(!(c[b+336+(d<<2)>>2]|0))g=64;else g=c[b+400+(d<<8)>>2]|0;f=a<<3|6;if(!(c[b+336+(f<<2)>>2]|0)){d=e;e=64;f=h}else{d=e;k=18}break}default:{f=c[b+400+((i<<3|1)<<8)>>2]|0;d=c[b+400+((i<<3|3)<<8)>>2]|0;a=c[a+8>>2]|0;g=c[b+400+((a<<3|3)<<8)>>2]|0;if((e|0)==1)e=64;else{h=f;f=a<<3|6;k=18}}}if((k|0)==18){e=c[b+400+(f<<8)>>2]|0;f=h}if((((e^f)&7|0)==0?(k=i*7|0,j=k^e>>3,(k^f>>3|0)<(j|0)):0)?(k=e^d,((k>>>3^k)&1|0)!=0|(j|0)<6):0){b=0;return b|0}k=g^d;if(!((k>>>3^k)&1)){b=255;return b|0}if((i*7^f>>3|0)<5){b=0;return b|0}e=104768+(i<<9)+(f<<3)|0;d=c[e>>2]|0;e=c[e+4>>2]|0;j=b+320+(a<<3)|0;k=b+304|0;if(!((c[j>>2]&d&c[k>>2]|0)==0?(c[j+4>>2]&e&c[k+4>>2]|0)==0:0)){b=0;return b|0}k=b+256|0;j=25088+(g<<3)|0;b=25600+(g<<3)|0;b=(_(c[j+4>>2]&c[k+4>>2],c[b+4>>2]|0)|0)^(_(c[j>>2]&c[k>>2],c[b>>2]|0)|0);b=(c[1031516+(g<<2)>>2]|0)+(b>>>(c[1031772+(g<<2)>>2]|0)<<3)|0;if(!((c[b>>2]&d|0)==0?(c[b+4>>2]&e|0)==0:0)?(c[1014620+(g<<8)+(f<<2)>>2]|0)>2:0){b=0;return b|0}b=255;return b|0}function id(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;p=i;i=i+11184|0;n=p+11176|0;l=p+5368|0;g=p+5808|0;k=p;o=a+12|0;Wu(g|0,0,5368)|0;g=(c[(Hf(g,b,0,0,l)|0)+5356>>2]|0)+8|0;h=c[g>>2]|0;g=c[g+4>>2]|0;m=a+16|0;d=c[m>>2]|0;do if(d){while(1){f=d+16|0;e=c[f>>2]|0;f=c[f+4>>2]|0;if(g>>>0<f>>>0|(g|0)==(f|0)&h>>>0<e>>>0){e=c[d>>2]|0;if(!e){e=d;j=4;break}else d=e}else{if(!(f>>>0<g>>>0|(f|0)==(g|0)&e>>>0<h>>>0)){j=10;break}e=d+4|0;f=c[e>>2]|0;if(!f){j=8;break}else d=f}}if((j|0)==4){c[n>>2]=d;j=11;break}else if((j|0)==8){c[n>>2]=d;j=11;break}else if((j|0)==10){c[n>>2]=d;if(!d){e=n;j=11;break}else break}}else{c[n>>2]=m;e=m;d=m;j=11}while(0);if((j|0)==11){f=Nu(32)|0;j=f+16|0;c[j>>2]=h;c[j+4>>2]=g;c[f+24>>2]=0;c[f>>2]=0;c[f+4>>2]=0;c[f+8>>2]=d;c[e>>2]=f;d=c[c[o>>2]>>2]|0;if(!d)d=f;else{c[o>>2]=d;d=c[e>>2]|0}ic(c[a+16>>2]|0,d);d=a+20|0;c[d>>2]=(c[d>>2]|0)+1;d=f}j=d+24|0;h=Nu(12)|0;c[h>>2]=2820;c[h+4>>2]=0;c[h+8>>2]=1;d=c[j>>2]|0;c[j>>2]=h;if(d|0)Bb[c[(c[d>>2]|0)+4>>2]&255](d);Wu(k|0,0,5368)|0;h=(c[(Hf(k,b,1,0,l)|0)+5356>>2]|0)+8|0;g=c[h>>2]|0;h=c[h+4>>2]|0;d=c[m>>2]|0;do if(d){while(1){f=d+16|0;e=c[f>>2]|0;f=c[f+4>>2]|0;if(h>>>0<f>>>0|(h|0)==(f|0)&g>>>0<e>>>0){e=c[d>>2]|0;if(!e){f=d;e=d;j=19;break}else d=e}else{if(!(f>>>0<h>>>0|(f|0)==(h|0)&e>>>0<g>>>0)){j=25;break}e=d+4|0;f=c[e>>2]|0;if(!f){j=23;break}else d=f}}if((j|0)==19){c[n>>2]=e;j=26;break}else if((j|0)==23){c[n>>2]=d;f=e;e=d;j=26;break}else if((j|0)==25){c[n>>2]=d;if(!d){f=n;e=d;j=26;break}else break}}else{c[n>>2]=m;f=m;e=m;j=26}while(0);if((j|0)==26){d=Nu(32)|0;n=d+16|0;c[n>>2]=g;c[n+4>>2]=h;c[d+24>>2]=0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=e;c[f>>2]=d;e=c[c[o>>2]>>2]|0;if(!e)e=d;else{c[o>>2]=e;e=c[f>>2]|0}ic(c[a+16>>2]|0,e);a=a+20|0;c[a>>2]=(c[a>>2]|0)+1}a=d+24|0;o=Nu(12)|0;c[o>>2]=2820;c[o+4>>2]=1;c[o+8>>2]=0;d=c[a>>2]|0;c[a>>2]=o;if(!d){i=p;return}Bb[c[(c[d>>2]|0)+4>>2]&255](d);i=p;return}function jd(a){a=a|0;mu(a);return}function kd(a){a=a|0;return c[a+4>>2]|0}function ld(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0;g=c[a+4>>2]|0;e=c[b+5364>>2]|0;switch(e|0){case 4:{d=g<<3|1;if(!(c[b+336+(d<<2)>>2]|0))f=64;else f=c[b+400+(d<<8)>>2]|0;d=g<<3|3;if(!(c[b+336+(d<<2)>>2]|0))d=64;else d=c[b+400+(d<<8)>>2]|0;e=c[a+8>>2]<<3|6;if(!(c[b+336+(e<<2)>>2]|0))e=64;else i=14;break}case 2:{d=g<<3|1;if(!(c[b+336+(d<<2)>>2]|0))f=64;else f=c[b+400+(d<<8)>>2]|0;d=g<<3|3;if(!(c[b+336+(d<<2)>>2]|0))d=64;else d=c[b+400+(d<<8)>>2]|0;e=c[a+8>>2]<<3|6;if(!(c[b+336+(e<<2)>>2]|0))e=64;else i=14;break}default:{f=c[b+400+((g<<3|1)<<8)>>2]|0;d=c[b+400+((g<<3|3)<<8)>>2]|0;if((e|0)==1)e=64;else{e=c[a+8>>2]<<3|6;i=14}}}if((i|0)==14)e=c[b+400+(e<<8)>>2]|0;if((((e^f)&7|0)==0?(i=g*7|0,h=i^e>>3,(i^f>>3|0)<(h|0)):0)?(i=e^d,((i>>>3^i)&1|0)!=0|(h|0)<6):0){i=0;return i|0}i=255;return i|0}function md(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;p=i;i=i+11184|0;n=p+11176|0;l=p+5368|0;g=p+5808|0;k=p;o=a+12|0;Wu(g|0,0,5368)|0;g=(c[(Hf(g,b,0,0,l)|0)+5356>>2]|0)+8|0;h=c[g>>2]|0;g=c[g+4>>2]|0;m=a+16|0;d=c[m>>2]|0;do if(d){while(1){f=d+16|0;e=c[f>>2]|0;f=c[f+4>>2]|0;if(g>>>0<f>>>0|(g|0)==(f|0)&h>>>0<e>>>0){e=c[d>>2]|0;if(!e){e=d;j=4;break}else d=e}else{if(!(f>>>0<g>>>0|(f|0)==(g|0)&e>>>0<h>>>0)){j=10;break}e=d+4|0;f=c[e>>2]|0;if(!f){j=8;break}else d=f}}if((j|0)==4){c[n>>2]=d;j=11;break}else if((j|0)==8){c[n>>2]=d;j=11;break}else if((j|0)==10){c[n>>2]=d;if(!d){e=n;j=11;break}else break}}else{c[n>>2]=m;e=m;d=m;j=11}while(0);if((j|0)==11){f=Nu(32)|0;j=f+16|0;c[j>>2]=h;c[j+4>>2]=g;c[f+24>>2]=0;c[f>>2]=0;c[f+4>>2]=0;c[f+8>>2]=d;c[e>>2]=f;d=c[c[o>>2]>>2]|0;if(!d)d=f;else{c[o>>2]=d;d=c[e>>2]|0}ic(c[a+16>>2]|0,d);d=a+20|0;c[d>>2]=(c[d>>2]|0)+1;d=f}j=d+24|0;h=Nu(12)|0;c[h>>2]=2844;c[h+4>>2]=0;c[h+8>>2]=1;d=c[j>>2]|0;c[j>>2]=h;if(d|0)Bb[c[(c[d>>2]|0)+4>>2]&255](d);Wu(k|0,0,5368)|0;h=(c[(Hf(k,b,1,0,l)|0)+5356>>2]|0)+8|0;g=c[h>>2]|0;h=c[h+4>>2]|0;d=c[m>>2]|0;do if(d){while(1){f=d+16|0;e=c[f>>2]|0;f=c[f+4>>2]|0;if(h>>>0<f>>>0|(h|0)==(f|0)&g>>>0<e>>>0){e=c[d>>2]|0;if(!e){f=d;e=d;j=19;break}else d=e}else{if(!(f>>>0<h>>>0|(f|0)==(h|0)&e>>>0<g>>>0)){j=25;break}e=d+4|0;f=c[e>>2]|0;if(!f){j=23;break}else d=f}}if((j|0)==19){c[n>>2]=e;j=26;break}else if((j|0)==23){c[n>>2]=d;f=e;e=d;j=26;break}else if((j|0)==25){c[n>>2]=d;if(!d){f=n;e=d;j=26;break}else break}}else{c[n>>2]=m;f=m;e=m;j=26}while(0);if((j|0)==26){d=Nu(32)|0;n=d+16|0;c[n>>2]=g;c[n+4>>2]=h;c[d+24>>2]=0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=e;c[f>>2]=d;e=c[c[o>>2]>>2]|0;if(!e)e=d;else{c[o>>2]=e;e=c[f>>2]|0}ic(c[a+16>>2]|0,e);a=a+20|0;c[a>>2]=(c[a>>2]|0)+1}a=d+24|0;o=Nu(12)|0;c[o>>2]=2844;c[o+4>>2]=1;c[o+8>>2]=0;d=c[a>>2]|0;c[a>>2]=o;if(!d){i=p;return}Bb[c[(c[d>>2]|0)+4>>2]&255](d);i=p;return}function nd(a){a=a|0;mu(a);return}function od(a){a=a|0;return c[a+4>>2]|0}function pd(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;o=c[a+4>>2]|0;f=c[b+5364>>2]|0;switch(f|0){case 4:{d=o<<3|3;if(!(c[b+336+(d<<2)>>2]|0))d=64;else d=c[b+400+(d<<8)>>2]|0;e=c[a+8>>2]|0;a=e<<3|3;if(!(c[b+336+(a<<2)>>2]|0)){n=d;m=64}else g=9;break}case 2:{d=o<<3|3;if(!(c[b+336+(d<<2)>>2]|0))d=64;else d=c[b+400+(d<<8)>>2]|0;e=c[a+8>>2]|0;a=e<<3|3;if(!(c[b+336+(a<<2)>>2]|0)){n=d;m=64}else g=9;break}default:{e=c[a+8>>2]|0;d=c[b+400+((o<<3|3)<<8)>>2]|0;a=e<<3|3;g=9}}if((g|0)==9){n=d;m=c[b+400+(a<<8)>>2]|0}l=m^n;if(!((l>>>3^l)&1)){b=255;return b|0}switch(f|0){case 4:{d=e<<3|6;if(!(c[b+336+(d<<2)>>2]|0))l=64;else g=15;break}case 2:{d=e<<3|6;if(!(c[b+336+(d<<2)>>2]|0))l=64;else g=15;break}case 1:{l=64;break}default:{d=e<<3|6;g=15}}if((g|0)==15)l=c[b+400+(d<<8)>>2]|0;d=o<<3|1;a=c[b+400+(d<<8)>>2]|0;d=c[b+400+(d<<8)+4>>2]|0;i=a>>3;j=d>>3;k=o*7|0;if((i^k|0)>(j^k|0)){f=d&7;g=a;h=f;a=a&7;f=i<<3|f}else{f=a&7;g=d;h=d&7;a=f;f=j<<3|f}d=g+((o|0)==0?8:-8)|0;switch((a>>>0<h>>>0?h-a|0:a-h|0)|0){case 0:{if((((d^l)&7|0)==0?(k^l>>3|0)>=(k^d>>3|0):0)?(b=l^n,(b>>>3^b)&1|0):0){b=0;return b|0}b=255;return b|0}case 1:{if((l|0)==(d|0)?(o=l^n,(o>>>3^o)&1|0):0){if((m|0)==(f|0)){b=0;return b|0}h=b+256|0;o=25088+(f<<3)|0;k=25600+(f<<3)|0;k=(_(c[o+4>>2]&c[h+4>>2],c[k+4>>2]|0)|0)^(_(c[o>>2]&c[h>>2],c[k>>2]|0)|0);k=(c[1031516+(f<<2)>>2]|0)+(k>>>(c[1031772+(f<<2)>>2]|0)<<3)|0;h=b+320+(e<<3)|0;o=b+280|0;if(!((c[h>>2]&c[k>>2]&c[o>>2]|0)==0?(c[h+4>>2]&c[k+4>>2]&c[o+4>>2]|0)==0:0)){b=0;return b|0}if((((i|0)<(j|0)?j-i|0:i-j|0)|0)>1){b=0;return b|0}}if((l|0)==(f|0)?(o=l^n,(o>>>3^o)&1|0):0){if((m|0)==(d|0)){b=0;return b|0}n=b+256|0;m=25088+(d<<3)|0;o=25600+(d<<3)|0;o=(_(c[m+4>>2]&c[n+4>>2],c[o+4>>2]|0)|0)^(_(c[m>>2]&c[n>>2],c[o>>2]|0)|0);o=(c[1031516+(d<<2)>>2]|0)+(o>>>(c[1031772+(d<<2)>>2]|0)<<3)|0;n=b+320+(e<<3)|0;b=b+280|0;if(!((c[n>>2]&c[o>>2]&c[b>>2]|0)==0?(c[n+4>>2]&c[o+4>>2]&c[b+4>>2]|0)==0:0)){b=0;return b|0}}b=255;return b|0}default:{b=255;return b|0}}return 0}function qd(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;p=i;i=i+11184|0;n=p+11176|0;l=p+5368|0;g=p+5808|0;k=p;o=a+12|0;Wu(g|0,0,5368)|0;g=(c[(Hf(g,b,0,0,l)|0)+5356>>2]|0)+8|0;h=c[g>>2]|0;g=c[g+4>>2]|0;m=a+16|0;d=c[m>>2]|0;do if(d){while(1){f=d+16|0;e=c[f>>2]|0;f=c[f+4>>2]|0;if(g>>>0<f>>>0|(g|0)==(f|0)&h>>>0<e>>>0){e=c[d>>2]|0;if(!e){e=d;j=4;break}else d=e}else{if(!(f>>>0<g>>>0|(f|0)==(g|0)&e>>>0<h>>>0)){j=10;break}e=d+4|0;f=c[e>>2]|0;if(!f){j=8;break}else d=f}}if((j|0)==4){c[n>>2]=d;j=11;break}else if((j|0)==8){c[n>>2]=d;j=11;break}else if((j|0)==10){c[n>>2]=d;if(!d){e=n;j=11;break}else break}}else{c[n>>2]=m;e=m;d=m;j=11}while(0);if((j|0)==11){f=Nu(32)|0;j=f+16|0;c[j>>2]=h;c[j+4>>2]=g;c[f+24>>2]=0;c[f>>2]=0;c[f+4>>2]=0;c[f+8>>2]=d;c[e>>2]=f;d=c[c[o>>2]>>2]|0;if(!d)d=f;else{c[o>>2]=d;d=c[e>>2]|0}ic(c[a+16>>2]|0,d);d=a+20|0;c[d>>2]=(c[d>>2]|0)+1;d=f}j=d+24|0;h=Nu(12)|0;c[h>>2]=2868;c[h+4>>2]=0;c[h+8>>2]=1;d=c[j>>2]|0;c[j>>2]=h;if(d|0)Bb[c[(c[d>>2]|0)+4>>2]&255](d);Wu(k|0,0,5368)|0;h=(c[(Hf(k,b,1,0,l)|0)+5356>>2]|0)+8|0;g=c[h>>2]|0;h=c[h+4>>2]|0;d=c[m>>2]|0;do if(d){while(1){f=d+16|0;e=c[f>>2]|0;f=c[f+4>>2]|0;if(h>>>0<f>>>0|(h|0)==(f|0)&g>>>0<e>>>0){e=c[d>>2]|0;if(!e){f=d;e=d;j=19;break}else d=e}else{if(!(f>>>0<h>>>0|(f|0)==(h|0)&e>>>0<g>>>0)){j=25;break}e=d+4|0;f=c[e>>2]|0;if(!f){j=23;break}else d=f}}if((j|0)==19){c[n>>2]=e;j=26;break}else if((j|0)==23){c[n>>2]=d;f=e;e=d;j=26;break}else if((j|0)==25){c[n>>2]=d;if(!d){f=n;e=d;j=26;break}else break}}else{c[n>>2]=m;f=m;e=m;j=26}while(0);if((j|0)==26){d=Nu(32)|0;n=d+16|0;c[n>>2]=g;c[n+4>>2]=h;c[d+24>>2]=0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=e;c[f>>2]=d;e=c[c[o>>2]>>2]|0;if(!e)e=d;else{c[o>>2]=e;e=c[f>>2]|0}ic(c[a+16>>2]|0,e);a=a+20|0;c[a>>2]=(c[a>>2]|0)+1}a=d+24|0;o=Nu(12)|0;c[o>>2]=2868;c[o+4>>2]=1;c[o+8>>2]=0;d=c[a>>2]|0;c[a>>2]=o;if(!d){i=p;return}Bb[c[(c[d>>2]|0)+4>>2]&255](d);i=p;return}function rd(a){a=a|0;mu(a);return}function sd(a){a=a|0;return c[a+4>>2]|0}function td(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;i=c[a+4>>2]|0;h=i<<3;k=h|1;j=c[b+400+(k<<8)>>2]|0;k=c[b+400+(k<<8)+4>>2]|0;a=c[a+8>>2]|0;e=c[b+5364>>2]|0;switch(e|0){case 4:{a=a<<3|6;if(!(c[b+336+(a<<2)>>2]|0))f=64;else f=c[b+400+(a<<8)>>2]|0;if(!(c[b+336+((h|6)<<2)>>2]|0)){e=b+320+((i^1)<<3)|0;a=b+264|0;d=c[a>>2]|0;a=c[a+4>>2]|0;g=104768+(i<<9)+(j<<3)|0;if((d&c[e>>2]&c[g>>2]|0)==0?(a&c[e+4>>2]&c[g+4>>2]|0)==0:0){k=255;return k|0}else g=11}else g=9;break}case 2:{a=a<<3|6;if(!(c[b+336+(a<<2)>>2]|0)){f=64;g=9}else{f=c[b+400+(a<<8)>>2]|0;g=9}break}case 1:{f=64;g=9;break}default:if((e|0)==6){k=255;return k|0}else{f=c[b+400+((a<<3|6)<<8)>>2]|0;g=9}}a:do if((g|0)==9){l=b+320+((i^1)<<3)|0;a=b+264|0;d=c[a>>2]|0;a=c[a+4>>2]|0;g=105792+(i<<9)+(j<<3)|0;if((d&c[l>>2]&c[g>>2]|0)==0?(a&c[l+4>>2]&c[g+4>>2]|0)==0:0){l=255;return l|0}switch(e|0){case 4:{g=11;break a}case 6:{a=255;break}default:{g=13;break a}}return a|0}while(0);if((g|0)==11)if(!(c[b+336+((h|6)<<2)>>2]|0)){b=b+320+((i^1)<<3)|0;l=104768+(i<<9)+(k<<3)|0;if((d&c[b>>2]&c[l>>2]|0)==0?(a&c[b+4>>2]&c[l+4>>2]|0)==0:0){l=255;return l|0}}else g=13;if((g|0)==13){b=b+320+((i^1)<<3)|0;l=105792+(i<<9)+(k<<3)|0;if((d&c[b>>2]&c[l>>2]|0)==0?(a&c[b+4>>2]&c[l+4>>2]|0)==0:0){l=255;return l|0}}a=i*7|0;d=a^j>>3;e=a^k>>3;d=(d|0)<(e|0)?e:d;e=f&7;l=j&7;if(((e>>>0<l>>>0?l-e|0:e-l|0)|0)>=2){l=255;return l|0}l=k&7;if(((e>>>0<l>>>0?l-e|0:e-l|0)|0)>=2){l=255;return l|0}if((a^f>>3|0)<=(d|0)){l=255;return l|0}l=c[2884+(d<<2)>>2]|0;return l|0}function ud(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0;j=i;i=i+4112|0;d=j;h=b+5348|0;e=a+8|0;if((c[h>>2]|0)==(c[e>>2]|0)?(g=df(b,d)|0,c[d+4096>>2]=g,(g|0)==(d|0)):0){i=j;return 0}g=c[a+4>>2]|0;switch(c[b+5364>>2]|0){case 4:{d=g<<3|6;if(!(c[b+336+(d<<2)>>2]|0))a=64;else a=c[b+400+(d<<8)>>2]|0;d=c[e>>2]<<3|6;if(!(c[b+336+(d<<2)>>2]|0)){e=64;d=a}else f=11;break}case 2:{d=g<<3|6;if(!(c[b+336+(d<<2)>>2]|0))a=64;else a=c[b+400+(d<<8)>>2]|0;d=c[e>>2]<<3|6;if(!(c[b+336+(d<<2)>>2]|0)){e=64;d=a}else f=11;break}case 1:{e=64;d=64;break}default:{a=c[b+400+((g<<3|6)<<8)>>2]|0;d=c[e>>2]<<3|6;f=11}}if((f|0)==11){e=c[b+400+(d<<8)>>2]|0;d=a}f=g<<3;d=((c[b+336+((f|1)<<2)>>2]|0)*248|0)+(c[(c[b+5356>>2]|0)+16+(g<<2)>>2]|0)+(c[2332+(e<<2)>>2]|0)+(c[1996+(c[1014620+(d<<8)+(e<<2)>>2]<<2)>>2]|0)|0;if((c[b+336+((f|5)<<2)>>2]|0)==0?(c[b+336+((f|4)<<2)>>2]|0)==0:0){a=f|3;e=c[b+336+(a<<2)>>2]|0;if(!e){f=d;h=c[h>>2]|0;h=(g|0)==(h|0);b=0-f|0;b=h?f:b;i=j;return b|0}if(!(c[b+336+((f|2)<<2)>>2]|0)){if((e|0)<=1){f=d;h=c[h>>2]|0;h=(g|0)==(h|0);b=0-f|0;b=h?f:b;i=j;return b|0}b=c[b+400+(a<<8)+4>>2]^c[b+400+(a<<8)>>2];if(!((b>>>3^b)&1)){f=d;h=c[h>>2]|0;h=(g|0)==(h|0);b=0-f|0;b=h?f:b;i=j;return b|0}}}f=d+1e4|0;f=(f|0)>31743?31743:f;h=c[h>>2]|0;h=(g|0)==(h|0);b=0-f|0;b=h?f:b;i=j;return b|0}function vd(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;n=c[a+4>>2]|0;p=b+320+(n<<3)|0;j=b+264|0;i=c[j>>2]|0;j=c[j+4>>2]|0;o=i&c[p>>2];p=j&c[p+4>>2];k=hb(o|0,p|0,0)|0;k=k&7;switch(k|0){case 0:case 7:{g=26624+(k<<3)|0;if((o&~c[g>>2]|0)==0?(p&~c[g+4>>2]|0)==0:0){d=c[b+5364>>2]|0;switch(d|0){case 4:{d=n<<3|3;if(!(c[b+336+(d<<2)>>2]|0)){e=64;d=n*56^(k|56)}else{e=c[b+400+(d<<8)>>2]|0;d=n*56^(k|56)}f=c[a+8>>2]<<3|6;if(!(c[b+336+(f<<2)>>2]|0))f=64;else m=14;break}case 2:{d=n<<3|3;if(!(c[b+336+(d<<2)>>2]|0)){e=64;d=n*56^(k|56)}else{e=c[b+400+(d<<8)>>2]|0;d=n*56^(k|56)}f=c[a+8>>2]<<3|6;if(!(c[b+336+(f<<2)>>2]|0))f=64;else m=14;break}default:{e=c[b+400+((n<<3|3)<<8)>>2]|0;g=n*56^(k|56);if((d|0)==1){f=64;d=g}else{f=c[a+8>>2]<<3|6;d=g;m=14}}}if((m|0)==14)f=c[b+400+(f<<8)>>2]|0;g=d^e;if((g>>>3^g)&1|0?(c[1014620+(d<<8)+(f<<2)>>2]|0)<2:0){b=0;return b|0}}switch(k|0){case 1:case 6:{m=18;break}default:{}}break}case 1:case 6:{m=18;break}default:{}}do if((((m|0)==18?(k=26624+(k<<3)|0,(i&~c[k>>2]|0)==0?(j&~c[k+4>>2]|0)==0:0):0)?(h=c[a+8>>2]|0,(c[(c[b+5356>>2]|0)+16+(h<<2)>>2]|0)==0):0)?(l=h<<3,(c[b+336+((l|1)<<2)>>2]|0)>0):0){a=b+320+(h<<3)|0;k=c[a>>2]&i;i=c[a+4>>2]&j;h=(h|0)==0;a=hb(k|0,i|0,0)|0;i=bv(k|0,i|0,0)|0;i=h?a:i^63;switch(c[b+5364>>2]|0){case 4:{d=n<<3|6;if(!(c[b+336+(d<<2)>>2]|0))e=64;else e=c[b+400+(d<<8)>>2]|0;d=l|6;if(!(c[b+336+(d<<2)>>2]|0))d=64;else d=c[b+400+(d<<8)>>2]|0;if(!(c[b+336+((n<<3|3)<<2)>>2]|0))g=64;else m=32;break}case 2:{d=n<<3|6;if(!(c[b+336+(d<<2)>>2]|0))e=64;else e=c[b+400+(d<<8)>>2]|0;d=l|6;if(!(c[b+336+(d<<2)>>2]|0))d=64;else d=c[b+400+(d<<8)>>2]|0;f=n<<3|3;if(!(c[b+336+(f<<2)>>2]|0))g=64;else m=34;break}case 1:{d=64;e=64;m=32;break}default:{d=c[b+400+((l|6)<<8)>>2]|0;e=c[b+400+((n<<3|6)<<8)>>2]|0;m=32}}if((m|0)==32){f=n<<3|3;m=34}if((m|0)==34)g=c[b+400+(f<<8)>>2]|0;f=n*7|0;if((f^i>>3|0)==6?(m=26112+((h?8:-8)+i<<3)|0,!((o&c[m>>2]|0)==0?(p&c[m+4>>2]|0)==0:0)):0){p=g^i;if(((p>>>3^p)&1|0)==0?(c[b+336+((n<<3|1)<<2)>>2]|0)!=1:0)break;b=c[1014620+(i<<8)+(d<<2)>>2]|0;if(!((b|0)>(c[1014620+(i<<8)+(e<<2)>>2]|0)|((b|0)>2|(f^d>>3|0)<6))){b=0;return b|0}}}while(0);b=255;return b|0}function wd(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0;i=c[a+8>>2]|0;h=c[b+5364>>2]|0;switch(h|0){case 4:{d=i<<3|6;if(!(c[b+336+(d<<2)>>2]|0))d=64;else d=c[b+400+(d<<8)>>2]|0;if(!(c[b+336+((i<<3|4)<<2)>>2]|0))g=64;else j=8;break}case 2:{d=i<<3|6;if(!(c[b+336+(d<<2)>>2]|0))d=64;else d=c[b+400+(d<<8)>>2]|0;e=i<<3|4;if(!(c[b+336+(e<<2)>>2]|0))g=64;else j=10;break}case 1:{d=64;j=8;break}default:{d=c[b+400+((i<<3|6)<<8)>>2]|0;j=8}}if((j|0)==8){e=i<<3|4;j=10}if((j|0)==10)g=c[b+400+(e<<8)>>2]|0;f=i*7|0;if((f^d>>3|0)<2){a=c[a+4>>2]|0;switch(h|0){case 4:{e=a<<3|6;if(!(c[b+336+(e<<2)>>2]|0))e=8;else j=16;break}case 2:{e=a<<3|6;if(!(c[b+336+(e<<2)>>2]|0))e=8;else j=16;break}case 1:{e=8;break}default:{e=a<<3|6;j=16}}if((j|0)==16)e=c[b+400+(e<<8)>>2]>>3;if(((e^f|0)>2?(f^g>>3|0)==2:0)?(i=b+320+(i<<3)|0,h=b+264|0,b=30016+(d<<3)|0,j=26944+((a<<3|1)<<9)+(g<<3)|0,!((c[h>>2]&c[i>>2]&c[b>>2]&c[j>>2]|0)==0?(c[h+4>>2]&c[i+4>>2]&c[b+4>>2]&c[j+4>>2]|0)==0:0)):0){j=0;return j|0}}j=255;return j|0}function xd(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;g=c[a+8>>2]|0;switch(c[b+5364>>2]|0){case 4:{d=g<<3|6;if(!(c[b+336+(d<<2)>>2]|0))e=64;else f=5;break}case 2:{d=g<<3|6;if(!(c[b+336+(d<<2)>>2]|0))e=64;else f=5;break}case 1:{e=64;break}default:{d=g<<3|6;f=5}}if((f|0)==5)e=c[b+400+(d<<8)>>2]|0;f=b+320+(c[a+4>>2]<<3)|0;b=b+264|0;d=c[b>>2]&c[f>>2];b=c[b+4>>2]&c[f+4>>2];g=26816+(g<<6)+(e>>3<<3)|0;if((((d&~c[g>>2]|0)==0?(b&~c[g+4>>2]|0)==0:0)?(d&-16843010|0)==0&(b&-16843010|0)==0|(d&2139062143|0)==0&(b&2139062143|0)==0:0)?(g=hb(d|0,b|0,0)|0,f=e&7,g=g&7,((f>>>0<g>>>0?g-f|0:f-g|0)|0)<2):0){g=0;return g|0}g=255;return g|0}function yd(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0;k=c[a+4>>2]|0;f=c[b+5364>>2]|0;a:do switch(f|0){case 4:{d=k<<3|6;if(!(c[b+336+(d<<2)>>2]|0))d=64;else d=c[b+400+(d<<8)>>2]|0;e=k<<3|1;if(!(c[b+336+(e<<2)>>2]|0)){g=(k|0)==1;h=g?d^56:d;d=c[a+8>>2]|0;j=15;break a}else{h=c[b+400+(e<<8)>>2]&4|0?d^7:d;g=(k|0)==1;h=g?h^56:h;d=c[a+8>>2]|0;j=15;break a}}case 2:{d=k<<3|6;if(!(c[b+336+(d<<2)>>2]|0))d=64;else d=c[b+400+(d<<8)>>2]|0;e=k<<3|1;if(!(c[b+336+(e<<2)>>2]|0)){g=(k|0)==1;h=g?d^56:d}else{h=c[b+400+(e<<8)>>2]&4|0?d^7:d;g=(k|0)==1;h=g?h^56:h}d=c[a+8>>2]<<3|6;if(!(c[b+336+(d<<2)>>2]|0))d=64;else d=c[b+400+(d<<8)>>2]|0;e=k<<3|1;if(!(c[b+336+(e<<2)>>2]|0))d=g?d^56:d;else{d=c[b+400+(e<<8)>>2]&4|0?d^7:d;d=g?d^56:d}e=k<<3|1;if(!(c[b+336+(e<<2)>>2]|0))f=64;else f=c[b+400+(e<<8)>>2]|0;a=k<<3|1;if(!(c[b+336+(a<<2)>>2]|0)){i=d;e=h;d=g}else{e=h;j=33}break}case 1:{d=64;j=13;break}default:{d=c[b+400+((k<<3|6)<<8)>>2]|0;j=13}}while(0);b:do if((j|0)==13){e=c[b+400+((k<<3|1)<<8)>>2]&4|0?d^7:d;g=(k|0)==1;e=g?e^56:e;d=c[a+8>>2]|0;switch(f|0){case 4:{h=e;j=15;break b}case 1:{d=c[b+400+((k<<3|1)<<8)>>2]&4|0?71:64;d=g?d|56:d;break}default:{d=c[b+400+((d<<3|6)<<8)>>2]|0;d=c[b+400+((k<<3|1)<<8)>>2]&4|0?d^7:d;d=g?d^56:d}}f=c[b+400+((k<<3|1)<<8)>>2]|0;a=k<<3|1;j=33}while(0);if((j|0)==15){d=d<<3|6;if(!(c[b+336+(d<<2)>>2]|0))d=64;else d=c[b+400+(d<<8)>>2]|0;e=k<<3|1;if(!(c[b+336+(e<<2)>>2]|0))d=g?d^56:d;else{d=c[b+400+(e<<8)>>2]&4|0?d^7:d;d=g?d^56:d}e=k<<3|1;if(!(c[b+336+(e<<2)>>2]|0))f=64;else f=c[b+400+(e<<8)>>2]|0;a=k<<3|1;if(!(c[b+336+(a<<2)>>2]|0)){i=d;e=h;d=g}else{e=h;j=33}}if((j|0)==33){i=d;f=c[b+400+(a<<8)>>2]&4|0?f^7:f;d=g}d=d?f^56:f;if(!((d>>3|0)<4|(d&7|0)==0)){b=255;return b|0}b=Xb(e,d,i,(k|0)!=(c[b+5348>>2]|0)&1)|0;b=b?255:0;return b|0}function zd(){var a=0,b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0;b=i;i=i+96|0;a=b;rk(a,17165,5);d=a+12|0;rk(d,17171,8);e=a+24|0;rk(e,17180,6);f=a+36|0;rk(f,17187,10);g=a+48|0;rk(g,17198,5);h=a+60|0;rk(h,17204,13);j=a+72|0;rk(j,17218,11);k=a+84|0;rk(k,17230,10);l=Nu(96)|0;c[258270]=l;c[258269]=l;c[258271]=l+96;qk(l,a);l=(c[258270]|0)+12|0;c[258270]=l;qk(l,d);l=(c[258270]|0)+12|0;c[258270]=l;qk(l,e);l=(c[258270]|0)+12|0;c[258270]=l;qk(l,f);l=(c[258270]|0)+12|0;c[258270]=l;qk(l,g);l=(c[258270]|0)+12|0;c[258270]=l;qk(l,h);l=(c[258270]|0)+12|0;c[258270]=l;qk(l,j);l=(c[258270]|0)+12|0;c[258270]=l;qk(l,k);c[258270]=(c[258270]|0)+12;vk(k);vk(j);vk(h);vk(g);vk(f);vk(e);vk(d);vk(a);Wu(1033088,0,256)|0;c[258336]=-4980811;c[258337]=-3539e3;c[258338]=-1703945;c[258339]=-655362;c[258340]=327686;c[258341]=720911;c[258342]=1703958;c[258343]=1835038;c[258344]=1900580;a=1033380;d=a+92|0;do{c[a>>2]=0;a=a+4|0}while((a|0)<(d|0));c[258368]=-3801136;c[258369]=-1245205;c[258370]=-131056;c[258371]=786458;c[258372]=1441829;c[258373]=2752563;c[258374]=3538998;c[258375]=3801151;c[258376]=4128833;c[258377]=4587591;c[258378]=4849743;c[258379]=5636177;c[258380]=5898332;c[258381]=6160481;a=1033528;d=a+72|0;do{c[a>>2]=0;a=a+4|0}while((a|0)<(d|0));c[258400]=-5111864;c[258401]=-1179673;c[258402]=1703925;c[258403]=3604475;c[258404]=4587516;c[258405]=5308415;c[258406]=7143432;c[258407]=7864334;c[258408]=8388629;c[258409]=9371671;c[258410]=10092575;c[258411]=10485792;c[258412]=10813483;c[258413]=11010097;c[258414]=11075643;a=1033660;d=a+68|0;do{c[a>>2]=0;a=a+4|0}while((a|0)<(d|0));c[258432]=-2293800;c[258433]=-786457;c[258434]=458754;c[258435]=1245188;c[258436]=2424846;c[258437]=3604504;c[258438]=4063257;c[258439]=4980776;c[258440]=5177387;c[258441]=5701679;c[258442]=6160438;c[258443]=6684728;c[258444]=7274556;c[258445]=7602246;c[258446]=7733320;c[258447]=7995465;c[258448]=8388683;c[258449]=8519757;c[258450]=8716373;c[258451]=8912990;c[258452]=9175139;c[258453]=10289260;c[258454]=10354800;c[258455]=10551409;c[258456]=11403382;c[258457]=11599991;c[258458]=12517499;c[258459]=13041792;c[258460]=0;c[258461]=0;c[258462]=0;c[258463]=0;c[258464]=720939;c[258465]=1310785;c[258466]=196628;c[258467]=524317;c[258468]=327701;c[258469]=524323;c[258470]=8;c[258471]=262158;c[258472]=458772;c[258473]=1310765;c[258474]=0;c[258475]=0;c[258476]=9109680;c[258477]=8323203;c[258478]=14287065;c[258479]=14090443;l=1033920;c[l>>2]=0;c[l+4>>2]=0;c[258482]=0;c[258483]=2162688;c[258484]=2818093;c[258485]=3080238;c[258486]=7012424;c[258487]=7733296;c[258488]=0;c[258489]=0;c[258490]=0;c[258491]=1638400;c[258492]=4063272;c[258493]=3866664;c[258494]=2228224;c[258495]=3145763;l=1033984;c[l>>2]=0;c[l+4>>2]=0;c[258498]=4063235;c[258499]=9043977;c[258500]=0;c[258501]=24183256;c[258502]=75958204;c[258503]=0;c[258504]=101779042;c[258505]=25166224;c[258506]=11403429;c[258507]=5701715;c[258508]=3276849;c[258509]=0;c[258510]=13828255;c[258511]=7798906;c[258512]=18284760;c[258513]=22348217;c[258514]=8323183;c[258515]=6226022;c[258516]=11993209;c[258517]=2424972;c[258518]=6488184;c[258519]=720951;c[258520]=6094936;c[258521]=0;c[258522]=4522040;c[258523]=8126536;c[258524]=10092653;c[258525]=9764962;c[258526]=7405697;c[258527]=4718739;c[258528]=9961629;c[258529]=0;c[258530]=9175067;c[258531]=6225943;c[258532]=7340192;c[258533]=8454222;c[258534]=4915265;c[258535]=852038;c[258536]=8061074;c[258537]=0;c[258538]=5374010;c[258539]=7340112;c[258540]=5701756;c[258541]=7209063;c[258542]=7012537;c[258543]=3932232;c[258544]=4063358;c[258545]=0;c[258546]=945567624;c[258547]=351541035;c[258548]=249041172;c[258549]=161679990;c[258550]=99288617;c[258551]=59900864;c[258552]=31457798;c[258553]=0;c[258554]=655369;c[258555]=655362;c[258556]=-524287;c[258557]=-786452;c[258558]=-786452;c[258559]=-524287;c[258560]=655362;c[258561]=655369;c[258562]=16;c[258563]=786440;c[258564]=1572872;c[258565]=92;c[258566]=7;c[258567]=0;c[258568]=17;c[258569]=1310730;c[258570]=7;c[258571]=7;c[258572]=0;c[258573]=15;c[258574]=1310740;c[258575]=655370;c[258576]=3997767;c[258577]=1638400;c[258578]=655410;c[258579]=1769520;c[258580]=1441830;c[258581]=2949120;c[258582]=5242900;c[258583]=7;c[258584]=196624;c[258585]=3276850;i=b;return}function Ad(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,i=0;g=a+5348|0;f=c[g>>2]|0;b=f^1;e=c[a+5364>>2]|0;switch(e|0){case 4:{b=b<<3|6;if(!(c[a+336+(b<<2)>>2]|0)){a=0;return a|0}break}case 2:{b=b<<3|6;if(!(c[a+336+(b<<2)>>2]|0)){a=0;return a|0}break}case 1:{a=0;return a|0}default:b=b<<3|6}if((c[a+400+(b<<8)>>2]&-8|0)!=56){a=0;return a|0}switch(e|0){case 4:{b=f<<3|6;if(!(c[a+336+(b<<2)>>2]|0))d=13;else d=10;break}case 2:{b=f<<3|6;if(!(c[a+336+(b<<2)>>2]|0))d=14;else d=10;break}default:{b=f<<3|6;d=10}}a:do if((d|0)==10){if((c[a+400+(b<<8)>>2]>>3|0)<(((f|0)==0?7:6)|0)){a=1;return a|0}switch(e|0){case 4:{d=13;break a}case 2:{d=14;break a}default:{}}b=f<<3|6;d=15}while(0);if((d|0)==13){b=f<<3|6;if(!(c[a+336+(b<<2)>>2]|0))b=64;else d=15}else if((d|0)==14){b=f<<3|6;if(!(c[a+336+(b<<2)>>2]|0))b=64;else d=15}if((d|0)==15)b=c[a+400+(b<<8)>>2]|0;h=30016+(b<<3)|0;i=26744;e=a+320+(f<<3)|0;b=a+256|0;d=c[i>>2]&c[h>>2]&~c[e>>2];e=c[i+4>>2]&c[h+4>>2]&~c[e+4>>2];while(1){if((d|0)==0&(e|0)==0){b=1;d=19;break}i=hb(d|0,e|0,0)|0;f=Xu(d|0,e|0,-1,-1)|0;e=C&e;h=b;h=Jf(a,i,c[h>>2]|0,c[h+4>>2]|0)|0;i=a+320+((c[g>>2]^1)<<3)|0;if((c[i>>2]&h|0)==0?(c[i+4>>2]&C|0)==0:0){b=0;d=19;break}else d=f&d}if((d|0)==19)return b|0;return 0}function Bd(a,b){a=a|0;b=b|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;m=a+320|0;l=c[m>>2]|0;n=a+264|0;h=c[n>>2]|0;f=b+72|0;g=b;i=b+64|0;k=c[a+5364>>2]|0;j=(k|0)==4;e=(c[g>>2]|~c[i>>2])&~c[f>>2]&(j?-1:l&1010580480&h^1010580480);f=(c[g+4>>2]|~c[i+4>>2])&~c[f+4>>2]&(j?-1:0);l=h&l;m=c[n+4>>2]&c[m+4>>2];n=Yu(l|0,m|0,8)|0;l=n|l;m=C|m;n=Yu(l|0,m|0,16)|0;l=n|l;m=C|m;n=Yu(l|0,m|0,24)|0;l=((j?n:0)|l)&e;m=((j?C:0)|m)&f;n=m|e;h=Yu(l|0,m|0,16)|0;i=Yu(l|0,n|0,48)|0;g=d[1151952+(l&65535)>>0]|0;h=d[1151952+(h&65535)>>0]|0;i=h+g+(d[1151952+(n&65535)>>0]|0)+(d[1151952+i>>0]|0)|0;if(j){o=Yu(e|0,f|0,16)|0;n=Yu(e|0,f|0,48)|0;e=d[1151952+(e&65535)>>0]|0;o=d[1151952+(o&65535)>>0]|0;i=d[1151952+(f&65535)>>0]|0;n=d[1151952+n>>0]|0;f=Yu(l|0,m|0,48)|0;f=o+e+i+n+g+h+(d[1151952+(m&65535)>>0]|0)+(d[1151952+f>>0]|0)|0}else f=i>>>0<16?i:16;e=(c[a+336>>2]|0)-(c[(c[b+204>>2]|0)+116>>2]<<1)|0;if((k|0)==7){o=c[a+5356>>2]|0;e=e-(c[o+36>>2]|0)-(c[o+40>>2]|0)|0}if(j){e=_(_(e,f)|0,e)|0;if(!(c[a+360>>2]|0)){o=(e|0)/200|0;return o|0}}else{e=_(_(e,f)|0,e)|0;if((k|0)==5){o=c[258510]|0;n=m&24;a=Yu(l&402653184|0,n|0,16)|0;o=(_(((d[1151952]|0)<<1)+(d[1151952+(a&6144)>>0]|0)+(d[1151952+n>>0]|0)|0,o)|0)+((e|0)/22|0)|0;return o|0}}o=(e|0)/18|0;return o|0}function Cd(a,b){a=a|0;b=b|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;l=a+328|0;m=c[l+4>>2]|0;n=a+264|0;i=c[n+4>>2]|0;f=b+8|0;g=b+64|0;h=b;k=c[a+5364>>2]|0;j=(k|0)==4;e=(c[g>>2]|~c[h>>2])&~c[f>>2]&(j?-1:0);f=(c[g+4>>2]|~c[h+4>>2])&~c[f+4>>2]&(j?-1:m&3947580&i^3947580);l=c[n>>2]&c[l>>2];m=i&m;i=Zu(l|0,m|0,8)|0;l=i|l;m=C|m;i=Zu(l|0,m|0,16)|0;l=i|l;m=C|m;i=Zu(l|0,m|0,24)|0;l=((j?i:0)|l)&e;m=((j?C:0)|m)&f;i=l|f;n=Yu(i|0,m|0,16)|0;h=Yu(l|0,m|0,48)|0;g=d[1151952+(m&65535)>>0]|0;h=d[1151952+h>>0]|0;i=(d[1151952+(n&65535)>>0]|0)+(d[1151952+(i&65535)>>0]|0)+g+h|0;if(j){o=Yu(e|0,f|0,16)|0;n=Yu(e|0,f|0,48)|0;e=d[1151952+(e&65535)>>0]|0;o=d[1151952+(o&65535)>>0]|0;i=d[1151952+(f&65535)>>0]|0;n=d[1151952+n>>0]|0;f=Yu(l|0,m|0,16)|0;f=o+e+i+n+(d[1151952+(l&65535)>>0]|0)+(d[1151952+(f&65535)>>0]|0)+g+h|0}else f=i>>>0<16?i:16;e=(c[a+368>>2]|0)-(c[(c[b+204>>2]|0)+116>>2]<<1)|0;if((k|0)==7){o=c[a+5356>>2]|0;e=e-(c[o+36>>2]|0)-(c[o+40>>2]|0)|0}if(j){e=_(_(e,f)|0,e)|0;if(!(c[a+392>>2]|0)){o=(e|0)/200|0;return o|0}}else{e=_(_(e,f)|0,e)|0;if((k|0)==5){o=c[258510]|0;n=m&24;a=Yu(l&402653184|0,n|0,16)|0;o=(_(((d[1151952]|0)<<1)+(d[1151952+(a&6144)>>0]|0)+(d[1151952+n>>0]|0)|0,o)|0)+((e|0)/22|0)|0;return o|0}}o=(e|0)/18|0;return o|0}function Dd(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0;switch(c[a+5364>>2]|0){case 1:{e=5;break}case 4:{e=(c[a+360>>2]|0)==0?0:c[a+1936>>2]&7;if(c[a+392>>2]|0){h=c[a+3984>>2]&7;e=e>>>0<h>>>0?h-e|0:e-h|0}f=(c[a+360>>2]|0)==0?64:c[a+1936>>2]|0;if(!(c[a+392>>2]|0)){h=8;g=10}else g=9;break}case 2:{e=(c[a+360>>2]|0)==0?0:c[a+1936>>2]&7;if(c[a+392>>2]|0){h=c[a+3984>>2]&7;e=e>>>0<h>>>0?h-e|0:e-h|0}f=(c[a+360>>2]|0)==0?64:c[a+1936>>2]|0;if(!(c[a+392>>2]|0)){h=8;g=10}else g=9;break}default:{g=c[a+1936>>2]&7;e=c[a+3984>>2]&7;f=c[a+1936>>2]|0;e=g>>>0<e>>>0?e-g|0:g-e|0;g=9}}if((g|0)==9){h=c[a+3984>>2]>>3;g=10}if((g|0)==10){g=f>>3;e=e-((g|0)<(h|0)?h-g|0:g-h|0)|0}a=(e+b<<3)+-120+0+(((c[a+372>>2]|0)+(c[a+340>>2]|0)|0)*12|0)|0;b=(d|0)/2|0;b=0-((d|0)>-2?b:0-b|0)|0;return (_(((d|0)>0&1)-(d>>>31)<<16,(a|0)<(b|0)?b:a)|0)+0|0}function Ed(a,b,e){a=a|0;b=b|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;l=(e|0)<1&1;g=b+200|0;b=c[g>>2]|0;i=a+5364|0;do if(((c[i>>2]|0)+-1|0)>>>0<7)h=64;else{f=c[b+16+(l<<2)>>2]|0;if(f|0?(h=Lb[c[(c[f>>2]|0)+12>>2]&63](f,a)|0,(h|0)!=255):0)break;h=d[b+10+l>>0]|0}while(0);if((c[(c[g>>2]|0)+24>>2]|0)>=128){a=h;return a|0}switch(h|0){case 48:case 64:break;default:{a=h;return a|0}}if(((c[a+348>>2]|0)==1?(c[a+380>>2]|0)==1:0)?(g=c[a+3216>>2]^c[a+1168>>2],(g>>>3^g)&1|0):0){b=c[a+5356>>2]|0;if((c[b+16>>2]|0)!=826){a=46;return a|0}if((c[b+20>>2]|0)!=826){a=46;return a|0}a=a+264|0;l=c[a>>2]|0;a=c[a+4>>2]|0;k=Xu(l|0,a|0,-1,-1)|0;a=(k&l|0)!=0|(C&a|0)!=0?31:9;return a|0}if((((e|0)>-1?e:0-e|0)|0)>=898){a=h;return a|0}f=c[a+336+((l<<3|1)<<2)>>2]|0;if((f|0)>=3){a=h;return a|0}g=l^1;b=c[i>>2]|0;switch(b|0){case 4:{b=g<<3|6;if(!(c[a+336+(b<<2)>>2]|0))b=64;else b=c[a+400+(b<<8)>>2]|0;if(!(c[a+336+((g<<3|6)<<2)>>2]|0)){e=a+320+(l<<3)|0;m=a+264|0;i=104768+(g<<9)+(b<<3)|0;if((c[m>>2]&c[e>>2]&c[i>>2]|0)==0?(c[m+4>>2]&c[e+4>>2]&c[i+4>>2]|0)==0:0){m=h;return m|0}}else{j=b;k=23}break}case 2:{b=g<<3|6;if(!(c[a+336+(b<<2)>>2]|0)){j=64;k=23}else{j=c[a+400+(b<<8)>>2]|0;k=23}break}case 1:{j=64;k=23;break}default:if((b|0)==6){m=h;return m|0}else{j=c[a+400+((g<<3|6)<<8)>>2]|0;k=23}}if((k|0)==23?(l=a+320+(l<<3)|0,a=a+264|0,m=105792+(g<<9)+(j<<3)|0,(c[a>>2]&c[l>>2]&c[m>>2]|0)==0?(c[a+4>>2]&c[l+4>>2]&c[m+4>>2]|0)==0:0):0){m=h;return m|0}m=(f*7|0)+37|0;return m|0}
function Fd(e){e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ia=0,ja=0,ka=0,la=0,ma=0,na=0,oa=0,pa=0,qa=0,ra=0,sa=0,ta=0,ua=0,va=0,wa=0,xa=0,ya=0,za=0,Aa=0,Ba=0,Ca=0,Da=0,Ea=0,Fa=0,Ga=0,Ha=0,Ia=0,Ja=0,Ka=0,La=0,Ma=0,Na=0,Oa=0,Pa=0,Qa=0,Ra=0,Sa=0,Ta=0,Ua=0,Va=0,Wa=0,Xa=0,Ya=0,Za=0,_a=0,$a=0,ab=0,bb=0,cb=0,db=0,eb=0,fb=0,gb=0,ib=0,jb=0,kb=0,lb=0,mb=0,nb=0,ob=0,pb=0,qb=0,rb=0,sb=0,tb=0,ub=0;ub=i;i=i+224|0;Na=ub+208|0;tb=ub;sb=e+5364|0;f=c[sb>>2]|0;switch(f|0){case 5:{g=c[e+5348>>2]|0;rb=c[e+400+((g<<3|6)<<8)>>2]|0;if(((rb>>3)+-3|0)>>>0<2?((rb&7)+-3|0)>>>0<2:0){e=32e3;i=ub;return e|0}rb=c[e+400+((g<<3^14)<<8)>>2]|0;if(((rb>>3)+-3|0)>>>0<2?((rb&7)+-3|0)>>>0<2:0){e=-32e3;i=ub;return e|0}if((f|0)==6)cb=7;break}case 6:{cb=7;break}default:{}}do if((cb|0)==7){g=c[e+5348>>2]|0;f=g<<3;if((c[e+400+((f|6)<<8)>>2]&-8|0)==56){if((c[e+400+((f^14)<<8)>>2]&-8|0)==56){e=0;i=ub;return e|0}if((c[e+400+((g<<3^14)<<8)>>2]>>3|0)<7){e=32e3;i=ub;return e|0}}if(Ad(e)|0){e=-32e3;i=ub;return e|0}else{f=c[sb>>2]|0;break}}while(0);switch(f|0){case 7:{f=c[e+5348>>2]|0;g=c[e+5356>>2]|0;if((c[g+36+(f<<2)>>2]|0)==3){e=32e3;i=ub;return e|0}if((c[g+36+((f^1)<<2)>>2]|0)==3){e=-32e3;i=ub;return e|0}break}case 4:{if(!(c[e+336+(((c[e+360>>2]|0)!=0&1)<<3<<2)>>2]|0)){e=-32e3;i=ub;return e|0}break}case 2:{f=c[e+5348>>2]<<3;if(!(c[e+336+((f^14)<<2)>>2]|0)){e=32e3;i=ub;return e|0}if(!(c[e+336+((f|6)<<2)>>2]|0)){e=-32e3;i=ub;return e|0}break}case 1:{f=c[e+5348>>2]<<3;if(!(c[e+336+(f<<2)>>2]|0)){e=32e3;i=ub;return e|0}if(!(c[e+336+((f^8)<<2)>>2]|0)){e=-32e3;i=ub;return e|0}break}default:{}}f=je(e)|0;rb=tb+200|0;c[rb>>2]=f;if(((c[sb>>2]|0)+-1|0)>>>0>=7?(h=c[f+12>>2]|0,h|0):0){e=Lb[c[(c[h>>2]|0)+12>>2]&63](h,e)|0;i=ub;return e|0}pb=e+5356|0;Ma=c[(c[pb>>2]|0)+44>>2]|0;Ka=(b[f+8>>1]|0)*65537|0;wa=rf(e)|0;qb=tb+204|0;c[qb>>2]=wa;La=c[wa+8>>2]|0;ob=tb+64|0;Ea=ob;c[Ea>>2]=0;c[Ea+4>>2]=0;Ea=tb;c[Ea>>2]=0;c[Ea+4>>2]=0;Ea=c[sb>>2]|0;switch(Ea|0){case 4:{if(!(c[e+360>>2]|0)){g=30528;f=c[g>>2]|0;g=c[g+4>>2]|0;h=tb+48|0;nb=h;c[nb>>2]=f;c[nb+4>>2]=g}else{g=30016+(c[e+1936>>2]<<3)|0;f=c[g>>2]|0;g=c[g+4>>2]|0;h=tb+48|0;nb=h;c[nb>>2]=f;c[nb+4>>2]=g}if(!(c[e+392>>2]|0)){j=64;Ya=h}else cb=34;break}case 2:{if(!(c[e+360>>2]|0)){g=30528;f=c[g>>2]|0;g=c[g+4>>2]|0;h=tb+48|0;nb=h;c[nb>>2]=f;c[nb+4>>2]=g}else{g=30016+(c[e+1936>>2]<<3)|0;f=c[g>>2]|0;g=c[g+4>>2]|0;h=tb+48|0;nb=h;c[nb>>2]=f;c[nb+4>>2]=g}if(!(c[e+392>>2]|0)){j=64;Ya=h}else cb=34;break}case 1:{g=30528;f=c[g>>2]|0;g=c[g+4>>2]|0;Ya=tb+48|0;j=Ya;c[j>>2]=f;c[j+4>>2]=g;j=64;break}default:{g=30016+(c[e+1936>>2]<<3)|0;f=c[g>>2]|0;g=c[g+4>>2]|0;h=tb+48|0;cb=h;c[cb>>2]=f;c[cb+4>>2]=g;cb=34}}if((cb|0)==34){j=c[e+3984>>2]|0;Ya=h}oa=30016+(j<<3)|0;na=c[oa>>2]|0;oa=c[oa+4>>2]|0;gb=tb+112|0;lb=gb;c[lb>>2]=na;c[lb+4>>2]=oa;lb=e+320|0;ia=lb;ha=c[ia>>2]|0;ia=c[ia+4>>2]|0;va=c[pb>>2]|0;n=va+344|0;o=c[n>>2]&ha;n=c[n+4>>2]&ia;Oa=tb+184|0;ba=Oa;c[ba>>2]=o;c[ba+4>>2]=n;ba=ob;c[ba>>2]=na;c[ba+4>>2]=oa;ba=wa+32|0;aa=c[ba>>2]|0;ba=c[ba+4>>2]|0;ab=tb+8|0;t=ab;c[t>>2]=aa;c[t+4>>2]=ba;t=tb;c[t>>2]=aa;c[t+4>>2]=ba;t=f&aa;x=g&ba;Va=tb+128|0;xa=Va;c[xa>>2]=t;c[xa+4>>2]=x;xa=(Ea|0)==1;if(!xa?((Ea|0)==3?1:(c[va+16>>2]|0)>2512):0){ra=Yu(na|0,oa|0,8)|0;ra=ra|na;sa=C|oa;mb=tb+152|0;c[mb>>2]=ra;c[mb+4>>2]=sa;mb=aa&na;nb=ba&oa;kb=Yu(mb|0,nb|0,16)|0;s=Yu(mb|0,nb|0,48)|0;s=(d[1151952+(kb&65535)>>0]|0)+(d[1151952+(mb&65535)>>0]|0)+(d[1151952+(nb&65535)>>0]|0)+(d[1151952+s>>0]|0)|0;c[tb+160>>2]=s;c[tb+168>>2]=0;c[tb+176>>2]=0}else{c[tb+160>>2]=0;ra=tb+152|0;c[ra>>2]=0;c[ra+4>>2]=0;ra=0;sa=0;s=0}mb=e+328|0;ua=mb;ta=c[ua>>2]|0;ua=c[ua+4>>2]|0;za=va+352|0;ya=c[za>>2]&ta;za=c[za+4>>2]&ua;Ua=tb+192|0;v=Ua;c[v>>2]=ya;c[v+4>>2]=za;v=aa|f;F=ba|g;da=tb;c[da>>2]=v;c[da+4>>2]=F;da=wa+40|0;ca=c[da>>2]|0;da=c[da+4>>2]|0;eb=tb+72|0;E=eb;c[E>>2]=ca;c[E+4>>2]=da;E=na|ca;D=oa|da;B=ob;c[B>>2]=E;c[B+4>>2]=D;B=na&ca;V=oa&da;bb=tb+136|0;nb=bb;c[nb>>2]=B;c[nb+4>>2]=V;if(!xa?((Ea|0)==3?1:(c[va+20>>2]|0)>2512):0){Ca=Zu(f|0,g|0,8)|0;Ca=Ca|f;Da=C|g;kb=tb+144|0;c[kb>>2]=Ca;c[kb+4>>2]=Da;kb=ca&f;nb=da&g;jb=Yu(kb|0,nb|0,16)|0;U=Yu(kb|0,nb|0,48)|0;U=(d[1151952+(jb&65535)>>0]|0)+(d[1151952+(kb&65535)>>0]|0)+(d[1151952+(nb&65535)>>0]|0)+(d[1151952+U>>0]|0)|0;c[tb+164>>2]=U;c[tb+172>>2]=0;c[tb+180>>2]=0}else{c[tb+164>>2]=0;U=tb+144|0;c[U>>2]=0;c[U+4>>2]=0;U=0;Ca=0;Da=0}db=e+264|0;fa=db;ea=c[fa>>2]|0;fa=c[fa+4>>2]|0;Aa=ea&ha;Ba=fa&ia;nb=e+256|0;q=nb;r=c[q>>2]|0;q=c[q+4>>2]|0;k=Yu(r|0,q|0,8)|0;m=Ba&C;pa=ta&ea;qa=ua&fa;h=Zu(r|0,q|0,8)|0;h=pa&h;j=qa&(C|16776960);k=Aa&(k|16776960)|ca;m=m|da;switch(Ea|0){case 4:{kb=(c[e+360>>2]|0)==0?26624:26112+(c[e+1936>>2]<<3)|0;l=~(k|c[kb>>2]);k=~(m|c[kb+4>>2]);h=aa|h;j=ba|j;if(!(c[e+392>>2]|0)){p=64;Ga=l;Fa=k}else cb=48;break}case 2:{kb=(c[e+360>>2]|0)==0?26624:26112+(c[e+1936>>2]<<3)|0;l=~(k|c[kb>>2]);k=~(m|c[kb+4>>2]);h=aa|h;j=ba|j;if(!(c[e+392>>2]|0)){p=64;Ga=l;Fa=k}else cb=48;break}case 1:{Fa=26624;p=64;h=aa|h;j=ba|j;Ga=~(k|c[Fa>>2]);Fa=~(m|c[Fa+4>>2]);break}default:{cb=26112+(c[e+1936>>2]<<3)|0;h=aa|h;j=ba|j;l=~(k|c[cb>>2]);k=~(m|c[cb+4>>2]);cb=48}}if((cb|0)==48){p=c[e+3984>>2]|0;Ga=l;Fa=k}Ha=26112+(p<<3)|0;Ia=~(h|c[Ha>>2]);Ha=~(j|c[Ha+4>>2]);Wa=tb+16|0;Ra=Wa;c[Ra>>2]=0;c[Ra+4>>2]=0;Ra=tb+152|0;Qa=tb+160|0;Sa=tb+168|0;Ta=tb+176|0;jb=e+1936|0;kb=e+360|0;h=c[e+912>>2]|0;a:do if((h|0)==64){w=0;u=0;Y=s;m=t;l=x;X=v;s=0;ga=0}else{L=wa+56|0;K=c[jb>>2]|0;M=(c[kb>>2]|0)==0;N=(Ea|0)==4;O=~ha;P=~ia;Q=c[258562]|0;J=M?64:K;w=0;u=0;A=s;m=t;l=x;p=F;t=h;z=e+916|0;j=0;h=0;s=0;k=0;b:while(1){c:do if(N){G=t;F=p;while(1){t=27968+(G<<3)|0;p=c[t>>2]|0;t=c[t+4>>2]|0;x=26112+(G<<3)|0;y=c[x>>2]|0;x=c[x+4>>2]|0;if(!((y&o|0)==0&(x&n|0)==0)){ib=67904+(J<<9)+(G<<3)|0;p=c[ib>>2]&p;t=c[ib+4>>2]&t}m=m|v&p;l=l|F&t;j=p|j;h=t|h;v=v|j;F=F|h;if(!((ra&p|0)==0&(sa&t|0)==0)){A=A+1|0;c[Qa>>2]=A;u=u+78|0;c[Sa>>2]=u;$a=na&p;fb=oa&t;Xa=Yu($a|0,fb|0,16)|0;ib=Yu($a|0,fb|0,48)|0;w=(d[1151952+(Xa&65535)>>0]|0)+(d[1151952+($a&65535)>>0]|0)+(d[1151952+(fb&65535)>>0]|0)+(d[1151952+ib>>0]|0)+w|0;c[Ta>>2]=w}if(!xa){H=G;I=u;G=m;break c}ib=Yu(p|0,t|0,16)|0;G=Yu(p|0,t|0,48)|0;s=(c[1033344+((d[1151952+(ib&65535)>>0]|0)+(d[1151952+(p&65535)>>0]|0)+(d[1151952+(t&65535)>>0]|0)+(d[1151952+G>>0]|0)<<2)>>2]|0)+s|0;G=c[z>>2]|0;if((G|0)==64){p=A;t=F;break b}else z=z+4|0}}else{H=t;G=p;F=u;while(1){u=27968+(H<<3)|0;p=c[u>>2]|0;u=c[u+4>>2]|0;x=26112+(H<<3)|0;y=c[x>>2]|0;x=c[x+4>>2]|0;if((y&o|0)==0&(x&n|0)==0)t=u;else{switch(Ea|0){case 1:{t=64;break}case 2:{if(M)t=64;else cb=61;break}default:cb=61}if((cb|0)==61){cb=0;t=K}t=67904+(t<<9)+(H<<3)|0;p=c[t>>2]&p;t=c[t+4>>2]&u}m=m|v&p;l=l|G&t;j=p|j;h=t|h;v=v|j;G=G|h;if((ra&p|0)==0&(sa&t|0)==0)u=F;else{A=A+1|0;c[Qa>>2]=A;u=F+78|0;c[Sa>>2]=u;$a=na&p;fb=oa&t;Xa=Yu($a|0,fb|0,16)|0;ib=Yu($a|0,fb|0,48)|0;w=(d[1151952+(Xa&65535)>>0]|0)+(d[1151952+($a&65535)>>0]|0)+(d[1151952+(fb&65535)>>0]|0)+(d[1151952+ib>>0]|0)+w|0;c[Ta>>2]=w}if(!xa){I=u;F=G;G=m;break c}ib=Yu(p|0,t|0,16)|0;H=Yu(p|0,t|0,48)|0;s=(c[1033344+((d[1151952+(ib&65535)>>0]|0)+(d[1151952+(p&65535)>>0]|0)+(d[1151952+(t&65535)>>0]|0)+(d[1151952+H>>0]|0)<<2)>>2]|0)+s|0;H=c[z>>2]|0;if((H|0)==64){p=A;t=G;break b}else{F=u;z=z+4|0}}}while(0);u=tb;c[u>>2]=v;c[u+4>>2]=F;u=Va;c[u>>2]=G;c[u+4>>2]=l;u=Wa;c[u>>2]=j;c[u+4>>2]=h;u=p&Ga;m=t&Fa;ib=Yu(u|0,m|0,48)|0;ib=a[1151952+ib>>0]|0;fb=a[1151952+(m&65535)>>0]|0;m=Yu(u|0,m|0,16)|0;s=(c[1033344+((fb&255)+(ib&255)+(d[1151952+(m&65535)>>0]|0)+(d[1151952+(u&65535)>>0]|0)<<2)>>2]|0)+s|0;u=L;m=c[u>>2]&-16777216^-16777216;u=c[u+4>>2]&65535^65535;if((m&y|0)==0&(u&x|0)==0){p=m&p&O;m=u&t&P;if(!((p|0)==0&(m|0)==0))k=(c[1033872+((((aa&p|0)!=0|(ba&m|0)!=0)&1)<<2)>>2]|0)+k|0}else k=(c[1033856+((((aa&y|0)!=0|(ba&x|0)!=0)&1)<<2)>>2]|0)+k|0;if((H>>3|0)<4){ib=26112+(H+8<<3)|0;k=k+(((c[ib>>2]&ea|0)==0?(c[ib+4>>2]&fa|0)==0:0)?0:Q)|0}t=c[z>>2]|0;if((t|0)==64){u=I;Y=A;m=G;X=v;ga=k;break a}else{u=I;m=G;p=F;z=z+4|0}}Y=tb;c[Y>>2]=v;c[Y+4>>2]=t;Y=Va;c[Y>>2]=m;c[Y+4>>2]=l;Y=Wa;c[Y>>2]=j;c[Y+4>>2]=h;Y=p;X=v;F=t;ga=k}while(0);Xa=tb+80|0;ka=Xa;c[ka>>2]=0;c[ka+4>>2]=0;ka=tb+144|0;ja=tb+164|0;la=tb+172|0;ma=tb+180|0;ib=e+3984|0;fb=e+392|0;j=c[e+2960>>2]|0;d:do if((j|0)==64){p=0;t=0;h=U;y=V;v=0;$=0}else{O=wa+48|0;N=c[ib>>2]|0;P=(c[fb>>2]|0)==0;Q=(Ea|0)==4;R=~ta;S=~ua;T=c[258562]|0;M=P?64:N;p=0;t=0;h=U;y=V;z=j;A=e+2964|0;x=0;j=0;v=0;k=0;e:while(1){f:do if(Q){I=A;J=z;while(1){A=27968+(J<<3)|0;z=c[A>>2]|0;A=c[A+4>>2]|0;G=26112+(J<<3)|0;H=c[G>>2]|0;G=c[G+4>>2]|0;if(!((H&ya|0)==0&(G&za|0)==0)){$a=67904+(M<<9)+(J<<3)|0;z=c[$a>>2]&z;A=c[$a+4>>2]&A}B=B|E&z;y=y|D&A;x=z|x;j=A|j;E=E|x;D=D|j;if(!((Ca&z|0)==0&(Da&A|0)==0)){h=h+1|0;c[ja>>2]=h;t=t+78|0;c[la>>2]=t;Ja=f&z;Pa=g&A;$=Yu(Ja|0,Pa|0,16)|0;$a=Yu(Ja|0,Pa|0,48)|0;p=(d[1151952+($&65535)>>0]|0)+(d[1151952+(Ja&65535)>>0]|0)+(d[1151952+(Pa&65535)>>0]|0)+(d[1151952+$a>>0]|0)+p|0;c[ma>>2]=p}if(!xa){L=E;K=y;break f}$a=Yu(z|0,A|0,16)|0;J=Yu(z|0,A|0,48)|0;v=(c[1033344+((d[1151952+($a&65535)>>0]|0)+(d[1151952+(z&65535)>>0]|0)+(d[1151952+(A&65535)>>0]|0)+(d[1151952+J>>0]|0)<<2)>>2]|0)+v|0;J=c[I>>2]|0;if((J|0)==64)break e;else I=I+4|0}}else{K=z;J=D;I=A;while(1){D=27968+(K<<3)|0;z=c[D>>2]|0;D=c[D+4>>2]|0;G=26112+(K<<3)|0;H=c[G>>2]|0;G=c[G+4>>2]|0;if((H&ya|0)==0&(G&za|0)==0)A=D;else{switch(Ea|0){case 1:{A=64;break}case 2:{if(P)A=64;else cb=87;break}default:cb=87}if((cb|0)==87){cb=0;A=N}A=67904+(A<<9)+(K<<3)|0;z=c[A>>2]&z;A=c[A+4>>2]&D}B=B|E&z;y=y|J&A;x=z|x;j=A|j;E=E|x;D=J|j;if(!((Ca&z|0)==0&(Da&A|0)==0)){h=h+1|0;c[ja>>2]=h;t=t+78|0;c[la>>2]=t;Ja=f&z;Pa=g&A;$=Yu(Ja|0,Pa|0,16)|0;$a=Yu(Ja|0,Pa|0,48)|0;p=(d[1151952+($&65535)>>0]|0)+(d[1151952+(Ja&65535)>>0]|0)+(d[1151952+(Pa&65535)>>0]|0)+(d[1151952+$a>>0]|0)+p|0;c[ma>>2]=p}if(!xa){J=K;L=E;K=y;break f}$a=Yu(z|0,A|0,16)|0;K=Yu(z|0,A|0,48)|0;v=(c[1033344+((d[1151952+($a&65535)>>0]|0)+(d[1151952+(z&65535)>>0]|0)+(d[1151952+(A&65535)>>0]|0)+(d[1151952+K>>0]|0)<<2)>>2]|0)+v|0;K=c[I>>2]|0;if((K|0)==64)break e;else{J=D;I=I+4|0}}}while(0);E=ob;c[E>>2]=L;c[E+4>>2]=D;E=bb;c[E>>2]=B;c[E+4>>2]=K;E=Xa;c[E>>2]=x;c[E+4>>2]=j;E=z&Ia;y=A&Ha;$a=Yu(E|0,y|0,48)|0;$a=a[1151952+$a>>0]|0;Pa=a[1151952+(y&65535)>>0]|0;y=Yu(E|0,y|0,16)|0;v=(c[1033344+((Pa&255)+($a&255)+(d[1151952+(y&65535)>>0]|0)+(d[1151952+(E&65535)>>0]|0)<<2)>>2]|0)+v|0;E=O;y=c[E>>2]&-65536^-65536;E=c[E+4>>2]&255^255;if((y&H|0)==0&(E&G|0)==0){z=y&z&R;y=E&A&S;if(!((z|0)==0&(y|0)==0))k=(c[1033872+((((ca&z|0)!=0|(da&y|0)!=0)&1)<<2)>>2]|0)+k|0}else k=(c[1033856+((((ca&H|0)!=0|(da&G|0)!=0)&1)<<2)>>2]|0)+k|0;if((J>>3^7|0)<4){$a=26112+(J+-8<<3)|0;k=k+(((c[$a>>2]&ea|0)==0?(c[$a+4>>2]&fa|0)==0:0)?0:T)|0}z=c[I>>2]|0;if((z|0)==64){y=K;E=L;$=k;break d}else{y=K;E=L;A=I+4|0}}$=ob;c[$>>2]=E;c[$+4>>2]=D;$=bb;c[$>>2]=B;c[$+4>>2]=y;$=Xa;c[$>>2]=x;c[$+4>>2]=j;$=k}while(0);Ja=tb+24|0;$a=Ja;c[$a>>2]=0;c[$a+4>>2]=0;$a=e+296|0;Z=e+5360|0;j=c[e+1168>>2]|0;g:do if((j|0)==64){z=u;A=Y;H=X;X=0}else{P=wa+56|0;Q=c[258562]|0;R=c[258563]|0;S=c[258585]|0;U=$a;T=c[U>>2]&ha^r;U=c[U+4>>2]&ia^q;V=~ha;W=~ia;A=Y;H=X;x=Ea;k=j;I=e+1172|0;z=0;G=0;j=0;while(1){M=k;L=x;N=z;while(1){x=25088+(M<<3)|0;z=25600+(M<<3)|0;z=(_(U&c[x+4>>2],c[z+4>>2]|0)|0)^(_(T&c[x>>2],c[z>>2]|0)|0);z=(c[1031516+(M<<2)>>2]|0)+(z>>>(c[1031772+(M<<2)>>2]|0)<<3)|0;x=c[z>>2]|0;z=c[z+4>>2]|0;J=26112+(M<<3)|0;K=c[J>>2]|0;J=c[J+4>>2]|0;if(!((K&o|0)==0&(J&n|0)==0)){switch(L|0){case 4:{if(!(c[kb>>2]|0))k=64;else cb=108;break}case 2:{if(!(c[kb>>2]|0))k=64;else cb=108;break}case 1:{k=64;break}default:cb=108}if((cb|0)==108){cb=0;k=c[jb>>2]|0}Pa=67904+(k<<9)+(M<<3)|0;x=c[Pa>>2]&x;z=c[Pa+4>>2]&z}m=m|H&x;l=l|F&z;Pa=Va;c[Pa>>2]=m;c[Pa+4>>2]=l;N=x|N;G=z|G;Pa=Ja;c[Pa>>2]=N;c[Pa+4>>2]=G;H=H|N;F=F|G;Pa=tb;c[Pa>>2]=H;c[Pa+4>>2]=F;if(!((ra&x|0)==0&(sa&z|0)==0)){A=A+1|0;c[Qa>>2]=A;u=u+56|0;c[Sa>>2]=u;X=na&x;Y=oa&z;O=Yu(X|0,Y|0,16)|0;Pa=Yu(X|0,Y|0,48)|0;w=(d[1151952+(O&65535)>>0]|0)+(d[1151952+(X&65535)>>0]|0)+(d[1151952+(Y&65535)>>0]|0)+(d[1151952+Pa>>0]|0)+w|0;c[Ta>>2]=w}if((L|0)!=1){O=G;break}Pa=Yu(x|0,z|0,16)|0;M=Yu(x|0,z|0,48)|0;s=(c[1033472+((d[1151952+(Pa&65535)>>0]|0)+(d[1151952+(x&65535)>>0]|0)+(d[1151952+(z&65535)>>0]|0)+(d[1151952+M>>0]|0)<<2)>>2]|0)+s|0;M=c[I>>2]|0;if((M|0)==64){z=u;X=j;break g}else{L=1;I=I+4|0}}G=x&Ga;k=z&Fa;Pa=Yu(G|0,k|0,48)|0;Pa=a[1151952+Pa>>0]|0;Y=a[1151952+(k&65535)>>0]|0;k=Yu(G|0,k|0,16)|0;s=(c[1033472+((Y&255)+(Pa&255)+(d[1151952+(k&65535)>>0]|0)+(d[1151952+(G&65535)>>0]|0)<<2)>>2]|0)+s|0;G=P;k=c[G>>2]&-16777216^-16777216;G=c[G+4>>2]&65535^65535;if((k&K|0)==0&(G&J|0)==0){x=k&x&V;k=G&z&W;if(!((x|0)==0&(k|0)==0))j=(c[1033880+((((aa&x|0)!=0|(ba&k|0)!=0)&1)<<2)>>2]|0)+j|0}else j=(c[1033864+((((aa&K|0)!=0|(ba&J|0)!=0)&1)<<2)>>2]|0)+j|0;if((M>>3|0)<4){Pa=26112+(M+8<<3)|0;j=j+(((c[Pa>>2]&ea|0)==0?(c[Pa+4>>2]&fa|0)==0:0)?0:Q)|0}x=j-(_(c[wa+96+((((K&-1437226411|0)!=0|(J&-1437226411|0)!=0)&1)<<2)>>2]|0,R)|0)|0;h:do if(a[Z>>0]|0){switch(M|0){case 7:case 0:break;default:{j=x;break h}}k=(M&7|0)==0?9:7;j=k+M|0;if((c[e+(j<<2)>>2]|0)==1){if(!(c[e+(j+8<<2)>>2]|0))j=(c[e+(j+k<<2)>>2]|0)==1&1;else j=2;j=x-(S<<j)|0}else j=x}else j=x;while(0);k=c[I>>2]|0;if((k|0)==64){z=u;X=j;break}else{x=L;I=I+4|0;z=N;G=O}}}while(0);Pa=tb+88|0;j=Pa;c[j>>2]=0;c[j+4>>2]=0;j=c[e+3216>>2]|0;i:do if((j|0)==64){u=h;T=0}else{P=wa+48|0;Q=c[258562]|0;R=c[258563]|0;S=c[258585]|0;U=$a;T=c[U>>2]&ta^r;U=c[U+4>>2]&ua^q;V=~ta;W=~ua;u=Ea;k=j;I=e+3220|0;x=0;G=0;j=0;while(1){M=k;L=u;N=x;while(1){u=25088+(M<<3)|0;x=25600+(M<<3)|0;x=(_(U&c[u+4>>2],c[x+4>>2]|0)|0)^(_(T&c[u>>2],c[x>>2]|0)|0);x=(c[1031516+(M<<2)>>2]|0)+(x>>>(c[1031772+(M<<2)>>2]|0)<<3)|0;u=c[x>>2]|0;x=c[x+4>>2]|0;J=26112+(M<<3)|0;K=c[J>>2]|0;J=c[J+4>>2]|0;if(!((K&ya|0)==0&(J&za|0)==0)){switch(L|0){case 4:{if(!(c[fb>>2]|0))k=64;else cb=134;break}case 2:{if(!(c[fb>>2]|0))k=64;else cb=134;break}case 1:{k=64;break}default:cb=134}if((cb|0)==134){cb=0;k=c[ib>>2]|0}ba=67904+(k<<9)+(M<<3)|0;u=c[ba>>2]&u;x=c[ba+4>>2]&x}B=B|E&u;y=y|D&x;ba=bb;c[ba>>2]=B;c[ba+4>>2]=y;N=u|N;G=x|G;ba=Pa;c[ba>>2]=N;c[ba+4>>2]=G;E=E|N;D=D|G;ba=ob;c[ba>>2]=E;c[ba+4>>2]=D;if(!((Ca&u|0)==0&(Da&x|0)==0)){h=h+1|0;c[ja>>2]=h;t=t+56|0;c[la>>2]=t;Y=f&u;aa=g&x;O=Yu(Y|0,aa|0,16)|0;ba=Yu(Y|0,aa|0,48)|0;p=(d[1151952+(O&65535)>>0]|0)+(d[1151952+(Y&65535)>>0]|0)+(d[1151952+(aa&65535)>>0]|0)+(d[1151952+ba>>0]|0)+p|0;c[ma>>2]=p}if((L|0)!=1){O=G;break}ba=Yu(u|0,x|0,16)|0;M=Yu(u|0,x|0,48)|0;v=(c[1033472+((d[1151952+(ba&65535)>>0]|0)+(d[1151952+(u&65535)>>0]|0)+(d[1151952+(x&65535)>>0]|0)+(d[1151952+M>>0]|0)<<2)>>2]|0)+v|0;M=c[I>>2]|0;if((M|0)==64){u=h;T=j;break i}else{L=1;I=I+4|0}}G=u&Ia;k=x&Ha;ba=Yu(G|0,k|0,48)|0;ba=a[1151952+ba>>0]|0;aa=a[1151952+(k&65535)>>0]|0;k=Yu(G|0,k|0,16)|0;v=(c[1033472+((aa&255)+(ba&255)+(d[1151952+(k&65535)>>0]|0)+(d[1151952+(G&65535)>>0]|0)<<2)>>2]|0)+v|0;G=P;k=c[G>>2]&-65536^-65536;G=c[G+4>>2]&255^255;if((k&K|0)==0&(G&J|0)==0){u=k&u&V;k=G&x&W;if(!((u|0)==0&(k|0)==0))j=(c[1033880+((((ca&u|0)!=0|(da&k|0)!=0)&1)<<2)>>2]|0)+j|0}else j=(c[1033864+((((ca&K|0)!=0|(da&J|0)!=0)&1)<<2)>>2]|0)+j|0;if((M>>3^7|0)<4){ba=26112+(M+-8<<3)|0;j=j+(((c[ba>>2]&ea|0)==0?(c[ba+4>>2]&fa|0)==0:0)?0:Q)|0}u=j-(_(c[wa+104+((((K&-1437226411|0)!=0|(J&-1437226411|0)!=0)&1)<<2)>>2]|0,R)|0)|0;j:do if(a[Z>>0]|0){switch(M|0){case 63:case 56:break;default:{j=u;break j}}k=(M&7|0)==0?-7:-9;j=k+M|0;if((c[e+(j<<2)>>2]|0)==9){if(!(c[e+(j+-8<<2)>>2]|0))j=(c[e+(j+k<<2)>>2]|0)==9&1;else j=2;j=u-(S<<j)|0}else j=u}else j=u;while(0);k=c[I>>2]|0;if((k|0)==64){u=h;T=j;break}else{u=L;I=I+4|0;x=N;G=O}}}while(0);aa=tb+32|0;h=aa;c[h>>2]=0;c[h+4>>2]=0;h=c[e+1424>>2]|0;if((h|0)==64)N=0;else{P=c[258564]|0;Q=wa+88|0;R=c[258565]|0;S=wa+92|0;M=e+288|0;N=$a;O=(c[N>>2]|c[M>>2])&ha^r;M=(c[N+4>>2]|c[M+4>>2])&ia^q;N=va+24|0;L=H;J=0;K=0;I=e+1428|0;H=0;while(1){k=24064+(h<<3)|0;x=24576+(h<<3)|0;x=(_(M&c[k+4>>2],c[x+4>>2]|0)|0)^(_(O&c[k>>2],c[x>>2]|0)|0);x=(c[1031004+(h<<2)>>2]|0)+(x>>>(c[1031260+(h<<2)>>2]|0)<<3)|0;k=c[x>>2]|0;x=c[x+4>>2]|0;ia=26112+(h<<3)|0;if(!((c[ia>>2]&o|0)==0?(c[ia+4>>2]&n|0)==0:0)){switch(Ea|0){case 4:{if(!(c[kb>>2]|0))j=64;else cb=159;break}case 2:{if(!(c[kb>>2]|0))j=64;else cb=159;break}case 1:{j=64;break}default:cb=159}if((cb|0)==159){cb=0;j=c[jb>>2]|0}ia=67904+(j<<9)+(h<<3)|0;k=c[ia>>2]&k;x=c[ia+4>>2]&x}m=m|L&k;l=l|F&x;ia=Va;c[ia>>2]=m;c[ia+4>>2]=l;J=k|J;K=x|K;ia=aa;c[ia>>2]=J;c[ia+4>>2]=K;L=L|J;F=F|K;ia=tb;c[ia>>2]=L;c[ia+4>>2]=F;if((ra&k|0)==0&(sa&x|0)==0)G=z;else{A=A+1|0;c[Qa>>2]=A;G=z+45|0;c[Sa>>2]=G;fa=na&k;ha=oa&x;ea=Yu(fa|0,ha|0,16)|0;ia=Yu(fa|0,ha|0,48)|0;w=(d[1151952+(ea&65535)>>0]|0)+(d[1151952+(fa&65535)>>0]|0)+(d[1151952+(ha&65535)>>0]|0)+(d[1151952+ia>>0]|0)+w|0;c[Ta>>2]=w}ha=k&Ga;ia=x&Fa;fa=Yu(ha|0,ia|0,16)|0;z=Yu(ha|0,ia|0,48)|0;z=(d[1151952+(fa&65535)>>0]|0)+(d[1151952+(ha&65535)>>0]|0)+(d[1151952+(ia&65535)>>0]|0)+(d[1151952+z>>0]|0)|0;k:do if(!xa){s=(c[1033600+(z<<2)>>2]|0)+s|0;if((h>>3|0)>3){ia=109888+(h<<3)|0;ha=pa&c[ia>>2];ia=qa&c[ia+4>>2];fa=Yu(ha|0,ia|0,16)|0;x=Yu(ha|0,ia|0,48)|0;x=(_((d[1151952+(fa&65535)>>0]|0)+(d[1151952+(ha&65535)>>0]|0)+(d[1151952+(ia&65535)>>0]|0)+(d[1151952+x>>0]|0)|0,P)|0)+H|0}else x=H;h=h&7;j=c[Q>>2]|0;k=1<<h;if(j&k|0){j=(c[1033888+(((c[S>>2]&k|0)!=0&1)<<2)>>2]|0)+x|0;break}if(z>>>0<4){switch(Ea|0){case 4:{if(!(c[kb>>2]|0)){j=x;break k}break}case 2:{if(!(c[kb>>2]|0)){j=x;break k}break}default:{}}ia=c[jb>>2]&7;ha=h>>>0<ia>>>0;if(!(ia>>>0<4^ha)?((ha?(1<<ia)+-1|0:-1<<ia+1)&j|0)==0:0){j=R+(_(z,-22)|0)|0;j=x-(_((c[N>>2]&3|0)==0?2:1,j)|0)|0}else j=x}else j=x}else{ia=Yu(k|0,x|0,16)|0;j=Yu(k|0,x|0,48)|0;s=(c[1033600+((d[1151952+(ia&65535)>>0]|0)+(d[1151952+(k&65535)>>0]|0)+(d[1151952+(x&65535)>>0]|0)+(d[1151952+j>>0]|0)<<2)>>2]|0)+s|0;j=H}while(0);h=c[I>>2]|0;if((h|0)==64){N=j;break}else{z=G;I=I+4|0;H=j}}}ba=tb+96|0;h=ba;c[h>>2]=0;c[h+4>>2]=0;h=c[e+3472>>2]|0;if((h|0)==64){J=e+288|0;g=v;u=0}else{J=e+288|0;K=c[258564]|0;L=wa+92|0;M=c[258565]|0;I=wa+88|0;G=J;F=$a;H=(c[F>>2]|c[G>>2])&ta^r;G=(c[F+4>>2]|c[G+4>>2])&ua^q;F=va+24|0;z=0;A=0;x=e+3476|0;m=0;while(1){k=24064+(h<<3)|0;l=24576+(h<<3)|0;l=(_(G&c[k+4>>2],c[l+4>>2]|0)|0)^(_(H&c[k>>2],c[l>>2]|0)|0);l=(c[1031004+(h<<2)>>2]|0)+(l>>>(c[1031260+(h<<2)>>2]|0)<<3)|0;k=c[l>>2]|0;l=c[l+4>>2]|0;wa=26112+(h<<3)|0;if(!((c[wa>>2]&ya|0)==0?(c[wa+4>>2]&za|0)==0:0)){switch(Ea|0){case 4:{if(!(c[fb>>2]|0))j=64;else cb=184;break}case 2:{if(!(c[fb>>2]|0))j=64;else cb=184;break}case 1:{j=64;break}default:cb=184}if((cb|0)==184){cb=0;j=c[ib>>2]|0}wa=67904+(j<<9)+(h<<3)|0;k=c[wa>>2]&k;l=c[wa+4>>2]&l}B=B|E&k;y=y|D&l;wa=bb;c[wa>>2]=B;c[wa+4>>2]=y;z=k|z;A=l|A;wa=ba;c[wa>>2]=z;c[wa+4>>2]=A;E=E|z;D=D|A;wa=ob;c[wa>>2]=E;c[wa+4>>2]=D;if((Ca&k|0)==0&(Da&l|0)==0)w=t;else{u=u+1|0;c[ja>>2]=u;w=t+45|0;c[la>>2]=w;ua=f&k;va=g&l;ta=Yu(ua|0,va|0,16)|0;wa=Yu(ua|0,va|0,48)|0;p=(d[1151952+(ta&65535)>>0]|0)+(d[1151952+(ua&65535)>>0]|0)+(d[1151952+(va&65535)>>0]|0)+(d[1151952+wa>>0]|0)+p|0;c[ma>>2]=p}va=k&Ia;wa=l&Ha;ua=Yu(va|0,wa|0,16)|0;t=Yu(va|0,wa|0,48)|0;t=(d[1151952+(ua&65535)>>0]|0)+(d[1151952+(va&65535)>>0]|0)+(d[1151952+(wa&65535)>>0]|0)+(d[1151952+t>>0]|0)|0;l:do if(!xa){l=(c[1033600+(t<<2)>>2]|0)+v|0;if((h>>3^7|0)>3){va=109888+(h<<3)|0;ua=Aa&c[va>>2];va=Ba&c[va+4>>2];ta=Yu(ua|0,va|0,16)|0;wa=Yu(ua|0,va|0,48)|0;m=(_((d[1151952+(ta&65535)>>0]|0)+(d[1151952+(ua&65535)>>0]|0)+(d[1151952+(va&65535)>>0]|0)+(d[1151952+wa>>0]|0)|0,K)|0)+m|0}h=h&7;j=c[L>>2]|0;k=1<<h;if(j&k|0){m=(c[1033888+(((c[I>>2]&k|0)!=0&1)<<2)>>2]|0)+m|0;break}if(t>>>0<4){switch(Ea|0){case 4:{if(!(c[fb>>2]|0))break l;break}case 2:{if(!(c[fb>>2]|0))break l;break}default:{}}wa=c[ib>>2]&7;va=h>>>0<wa>>>0;if(!(wa>>>0<4^va)?((va?(1<<wa)+-1|0:-1<<wa+1)&j|0)==0:0){wa=M+(_(t,-22)|0)|0;m=m-(_((c[F>>2]&12|0)==0?2:1,wa)|0)|0}}}else{va=Yu(k|0,l|0,16)|0;wa=Yu(k|0,l|0,48)|0;l=(c[1033600+((d[1151952+(va&65535)>>0]|0)+(d[1151952+(k&65535)>>0]|0)+(d[1151952+(l&65535)>>0]|0)+(d[1151952+wa>>0]|0)<<2)>>2]|0)+v|0}while(0);h=c[x>>2]|0;if((h|0)==64){g=l;u=m;break}else{t=w;x=x+4|0;v=l}}}Y=tb+40|0;t=Y;c[t>>2]=0;c[t+4>>2]=0;t=e+280|0;h=c[e+1680>>2]|0;m:do if((h|0)==64)r=0;else{j=e+1684|0;f=s;p=0;while(1){l=h;m=j;while(1){j=24064+(l<<3)|0;h=24576+(l<<3)|0;h=(_(c[j+4>>2]&q,c[h+4>>2]|0)|0)^(_(c[j>>2]&r,c[h>>2]|0)|0);h=(c[1031004+(l<<2)>>2]|0)+(h>>>(c[1031260+(l<<2)>>2]|0)<<3)|0;j=25088+(l<<3)|0;Ea=25600+(l<<3)|0;Ea=(_(c[j+4>>2]&q,c[Ea+4>>2]|0)|0)^(_(c[j>>2]&r,c[Ea>>2]|0)|0);Ea=(c[1031516+(l<<2)>>2]|0)+(Ea>>>(c[1031772+(l<<2)>>2]|0)<<3)|0;j=c[Ea>>2]|c[h>>2];h=c[Ea+4>>2]|c[h+4>>2];Ea=26112+(l<<3)|0;if(!((c[Ea>>2]&o|0)==0?(c[Ea+4>>2]&n|0)==0:0)){switch(c[sb>>2]|0){case 4:{if(!(c[kb>>2]|0))k=64;else cb=209;break}case 2:{if(!(c[kb>>2]|0))k=64;else cb=209;break}case 1:{k=64;break}default:cb=209}if((cb|0)==209){cb=0;k=c[jb>>2]|0}Ea=67904+(k<<9)+(l<<3)|0;j=c[Ea>>2]&j;h=c[Ea+4>>2]&h}Da=tb;Ba=c[Da>>2]|0;Da=c[Da+4>>2]|0;Ea=Va;Aa=c[Ea+4>>2]|Da&h;Ca=Va;c[Ca>>2]=c[Ea>>2]|Ba&j;c[Ca+4>>2]=Aa;Ca=Y;Aa=c[Ca>>2]|j;Ca=c[Ca+4>>2]|h;Ea=Y;c[Ea>>2]=Aa;c[Ea+4>>2]=Ca;Ea=tb;c[Ea>>2]=Aa|Ba;c[Ea+4>>2]=Ca|Da;Ea=Ra;if(!((c[Ea>>2]&j|0)==0?(c[Ea+4>>2]&h|0)==0:0)){c[Qa>>2]=(c[Qa>>2]|0)+1;c[Sa>>2]=(c[Sa>>2]|0)+11;Da=gb;Ca=c[Da>>2]&j;Da=c[Da+4>>2]&h;Ba=Yu(Ca|0,Da|0,16)|0;Ea=Yu(Ca|0,Da|0,48)|0;c[Ta>>2]=(d[1151952+(Ba&65535)>>0]|0)+(d[1151952+(Ca&65535)>>0]|0)+(d[1151952+(Da&65535)>>0]|0)+(d[1151952+Ea>>0]|0)+(c[Ta>>2]|0)}if((c[sb>>2]|0)!=1){k=l;break}Ea=Yu(j|0,h|0,16)|0;l=Yu(j|0,h|0,48)|0;f=(c[1033728+((d[1151952+(Ea&65535)>>0]|0)+(d[1151952+(j&65535)>>0]|0)+(d[1151952+(h&65535)>>0]|0)+(d[1151952+l>>0]|0)<<2)>>2]|0)+f|0;l=c[m>>2]|0;if((l|0)==64){s=f;r=p;break m}else m=m+4|0}Ca=Xa;Ba=Pa;Da=ba;Ea=j&Ga&~(c[Ba>>2]|c[Ca>>2]|c[Da>>2]);h=h&Fa&~(c[Ba+4>>2]|c[Ca+4>>2]|c[Da+4>>2]);Da=Yu(Ea|0,h|0,48)|0;Da=a[1151952+Da>>0]|0;Ca=a[1151952+(h&65535)>>0]|0;h=Yu(Ea|0,h|0,16)|0;f=(c[1033728+((Ca&255)+(Da&255)+(d[1151952+(h&65535)>>0]|0)+(d[1151952+(Ea&65535)>>0]|0)<<2)>>2]|0)+f|0;h=mb;Ea=J;Da=t;k=Gf(e,(c[Da>>2]|c[Ea>>2])&c[h>>2],(c[Da+4>>2]|c[Ea+4>>2])&c[h+4>>2],k,Na)|0;k=p-((k|0)==0&(C|0)==0?0:c[258578]|0)|0;h=c[m>>2]|0;if((h|0)==64){s=f;r=k;break m}n=Oa;q=nb;r=c[q>>2]|0;q=c[q+4>>2]|0;o=c[n>>2]|0;n=c[n+4>>2]|0;j=m+4|0;p=k}}while(0);Z=tb+104|0;f=Z;c[f>>2]=0;c[f+4>>2]=0;f=c[e+3728>>2]|0;n:do if((f|0)==64)f=0;else{h=f;l=e+3732|0;f=0;while(1){o=Ua;n=c[o>>2]|0;o=c[o+4>>2]|0;q=nb;p=c[q>>2]|0;q=c[q+4>>2]|0;m=h;while(1){j=24064+(m<<3)|0;h=24576+(m<<3)|0;h=(_(c[j+4>>2]&q,c[h+4>>2]|0)|0)^(_(c[j>>2]&p,c[h>>2]|0)|0);h=(c[1031004+(m<<2)>>2]|0)+(h>>>(c[1031260+(m<<2)>>2]|0)<<3)|0;j=25088+(m<<3)|0;Ga=25600+(m<<3)|0;Ga=(_(c[j+4>>2]&q,c[Ga+4>>2]|0)|0)^(_(c[j>>2]&p,c[Ga>>2]|0)|0);Ga=(c[1031516+(m<<2)>>2]|0)+(Ga>>>(c[1031772+(m<<2)>>2]|0)<<3)|0;j=c[Ga>>2]|c[h>>2];h=c[Ga+4>>2]|c[h+4>>2];Ga=26112+(m<<3)|0;if(!((c[Ga>>2]&n|0)==0?(c[Ga+4>>2]&o|0)==0:0)){switch(c[sb>>2]|0){case 4:{if(!(c[fb>>2]|0))k=64;else cb=224;break}case 2:{if(!(c[fb>>2]|0))k=64;else cb=224;break}case 1:{k=64;break}default:cb=224}if((cb|0)==224){cb=0;k=c[ib>>2]|0}Ga=67904+(k<<9)+(m<<3)|0;j=c[Ga>>2]&j;h=c[Ga+4>>2]&h}Fa=ob;Da=c[Fa>>2]|0;Fa=c[Fa+4>>2]|0;Ga=bb;Ca=c[Ga+4>>2]|Fa&h;Ea=bb;c[Ea>>2]=c[Ga>>2]|Da&j;c[Ea+4>>2]=Ca;Ea=Z;Ca=c[Ea>>2]|j;Ea=c[Ea+4>>2]|h;Ga=Z;c[Ga>>2]=Ca;c[Ga+4>>2]=Ea;Ga=ob;c[Ga>>2]=Ca|Da;c[Ga+4>>2]=Ea|Fa;Ga=ka;if(!((c[Ga>>2]&j|0)==0?(c[Ga+4>>2]&h|0)==0:0)){c[ja>>2]=(c[ja>>2]|0)+1;c[la>>2]=(c[la>>2]|0)+11;Fa=Ya;Ea=c[Fa>>2]&j;Fa=c[Fa+4>>2]&h;Da=Yu(Ea|0,Fa|0,16)|0;Ga=Yu(Ea|0,Fa|0,48)|0;c[ma>>2]=(d[1151952+(Da&65535)>>0]|0)+(d[1151952+(Ea&65535)>>0]|0)+(d[1151952+(Fa&65535)>>0]|0)+(d[1151952+Ga>>0]|0)+(c[ma>>2]|0)}if((c[sb>>2]|0)!=1){k=m;break}Ga=Yu(j|0,h|0,16)|0;m=Yu(j|0,h|0,48)|0;g=(c[1033728+((d[1151952+(Ga&65535)>>0]|0)+(d[1151952+(j&65535)>>0]|0)+(d[1151952+(h&65535)>>0]|0)+(d[1151952+m>>0]|0)<<2)>>2]|0)+g|0;m=c[l>>2]|0;if((m|0)==64)break n;else l=l+4|0}Ea=Wa;Da=Ja;Fa=aa;Ga=j&Ia&~(c[Da>>2]|c[Ea>>2]|c[Fa>>2]);h=h&Ha&~(c[Da+4>>2]|c[Ea+4>>2]|c[Fa+4>>2]);Fa=Yu(Ga|0,h|0,48)|0;Fa=a[1151952+Fa>>0]|0;Ea=a[1151952+(h&65535)>>0]|0;h=Yu(Ga|0,h|0,16)|0;g=(c[1033728+((Ea&255)+(Fa&255)+(d[1151952+(h&65535)>>0]|0)+(d[1151952+(Ga&65535)>>0]|0)<<2)>>2]|0)+g|0;h=lb;Ga=J;Fa=t;h=Gf(e,(c[Fa>>2]|c[Ga>>2])&c[h>>2],(c[Fa+4>>2]|c[Ga+4>>2])&c[h+4>>2],k,Na)|0;f=f-((h|0)==0&(C|0)==0?0:c[258578]|0)|0;h=c[l>>2]|0;if((h|0)==64)break;else l=l+4|0}}while(0);cb=c[sb>>2]|0;h=Ka+Ma+La+ga-$+X-T+N-u+r-f+(s-g<<((cb|0)==1&1))|0;switch(cb|0){case 1:{cb=316;break}case 6:{v=6;cb=325;break}case 4:{if(!(c[kb>>2]|0)){V=64;cb=235}else cb=234;break}case 2:{if(!(c[kb>>2]|0)){V=64;cb=235}else cb=234;break}default:cb=234}if((cb|0)==234){V=c[jb>>2]|0;cb=235}o:do if((cb|0)==235){f=c[qb>>2]|0;if((c[f+64>>2]|0)==(V|0)?(c[f+80>>2]|0)==(c[(c[pb>>2]|0)+24>>2]&3|0):0)O=c[f+72>>2]|0;else{O=mf(f,e,V)|0;c[f+72>>2]=O}f=c[ja>>2]|0;do if(!f){p=ob;j=bb;m=ab;f=db;q=c[p>>2]|0;p=c[p+4>>2]|0;o=c[m>>2]|0;m=c[m+4>>2]|0;k=c[j>>2]|0;j=c[j+4>>2]|0;l=c[sb>>2]|0;g=c[f>>2]|0;f=c[f+4>>2]|0}else{T=Ya;S=c[T>>2]|0;T=c[T+4>>2]|0;J=Va;I=c[J>>2]|0;J=c[J+4>>2]|0;g=S&~I;j=T&~J;p=ob;q=c[p>>2]|0;p=c[p+4>>2]|0;m=g&q;n=j&p;r=tb;o=c[r>>2]|0;r=c[r+4>>2]|0;Ma=ka;G=mb;F=c[G>>2]|0;G=c[G+4>>2]|0;w=~F;z=~G;La=q&~o&c[Ma>>2]&w;Ma=p&~r&c[Ma+4>>2]&z;Ha=_(c[la>>2]|0,f)|0;Ga=(c[ma>>2]|0)*101|0;Ka=Yu(m|0,n|0,16)|0;Ia=Yu(m|0,n|0,48)|0;Ia=((d[1151952+(Ka&65535)>>0]|0)+(d[1151952+(m&65535)>>0]|0)+(d[1151952+(n&65535)>>0]|0)+(d[1151952+Ia>>0]|0)|0)*235|0;Ka=Yu(La|0,Ma|0,16)|0;Na=Yu(La|0,Ma|0,48)|0;f=Oa;l=c[sb>>2]|0;U=(l|0)==3;f=(((O<<16>>16)*7|0)/-5|0)+-5+Ga+((Ha|0)<807?Ha:807)+Ia+(((d[1151952+(Ka&65535)>>0]|0)+(d[1151952+(La&65535)>>0]|0)+(d[1151952+(Ma&65535)>>0]|0)+(d[1151952+Na>>0]|0)+(((c[f>>2]|0)!=0|(c[f+4>>2]|0)!=0)&1)|0)*134|0)-(0-(((c[e+388>>2]|0)!=0|U)&1^1)&717)|0;if(U){Oa=c[e+4548>>2]|0;f=((c[e+4532>>2]|0)*124|0)+f+((c[e+4536>>2]|0)*129|0)+((c[e+4540>>2]|0)*27|0)+((c[e+4544>>2]|0)*73|0)+(Oa*71|0)|0;if(!Oa){B=0;A=0}else{A=nb;B=g&~c[A>>2];A=j&~c[A+4>>2]}}else{B=0;A=0}y=Z;x=c[y>>2]|0;y=c[y+4>>2]|0;Q=(l|0)==2;g=Q?S:0;R=Q?T:0;j=bb;k=c[j>>2]|0;j=c[j+4>>2]|0;m=(g|m&w&x)&k|B&q;n=(R|n&z&y)&j|A&p;s=Yu(m|0,n|0,16)|0;t=Yu(m|0,n|0,48)|0;t=(((d[1151952+(s&65535)>>0]|0)+(d[1151952+(m&65535)>>0]|0)+(d[1151952+(n&65535)>>0]|0)+(d[1151952+t>>0]|0)|0)*997|0)+f|0;f=g|~(F|o);n=R|~(G|r);m=ab;o=c[m>>2]|0;m=c[m+4>>2]|0;R=db;g=c[R>>2]|0;R=c[R+4>>2]|0;r=Zu(g|0,R|0,8)|0;r=~(g&F&r|o);s=~(R&G&C|m);P=(l|0)==7;if(P){K=(c[(c[pb>>2]|0)+40>>2]|0)==0;u=K?f:w;v=K?n:z;N=K?r:w;K=K?s:z}else{u=f;v=n;N=r;K=s}M=nb;L=c[M>>2]|0;M=c[M+4>>2]|0;w=24064+(V<<3)|0;z=24576+(V<<3)|0;z=(_(c[w+4>>2]&M,c[z+4>>2]|0)|0)^(_(c[w>>2]&L,c[z>>2]|0)|0);z=(c[1031004+(V<<2)>>2]|0)+(z>>>(c[1031260+(V<<2)>>2]|0)<<3)|0;w=c[z>>2]|0;z=c[z+4>>2]|0;D=25088+(V<<3)|0;E=25600+(V<<3)|0;E=(_(c[D+4>>2]&M,c[E+4>>2]|0)|0)^(_(c[D>>2]&L,c[E>>2]|0)|0);E=(c[1031516+(V<<2)>>2]|0)+(E>>>(c[1031772+(V<<2)>>2]|0)<<3)|0;D=c[E>>2]|0;E=c[E+4>>2]|0;f=(u&(x|B)&(D|w)|0)==0?(v&(y|A)&(E|z)|0)==0:0;H=c[258574]|0;n=O-(f?0:H)|0;f=f?t:t+695|0;x=Y;y=c[x>>2]&~(I|F);x=c[x+4>>2]&~(J|G);B=lb;A=(y&q|u)&~c[B>>2];B=(x&p|v)&~c[B+4>>2];y=y&k|u;x=x&j|v;if(U){u=(c[e+4544>>2]|0)==0;t=u?0:~L;u=u?0:~M}else{t=0;u=0}s=ba;r=c[s>>2]|0;s=c[s+4>>2]|0;do if(((r&y|t&A)&w|0)==0?((s&x|u&B)&z|0)==0:0){if((w&N&(r|t)|0)==0?(z&K&(s|u)|0)==0:0)break;n=n-(c[258575]|0)|0}else{f=f+638|0;n=n-H|0}while(0);if(U){u=(c[e+4540>>2]|0)==0;t=u?0:~L;u=u?0:~M}else{t=0;u=0}s=Pa;r=c[s>>2]|0;s=c[s+4>>2]|0;do if(((r&y|t&A)&D|0)==0?((s&x|u&B)&E|0)==0:0){if((D&N&(r|t)|0)==0?(E&K&(s|u)|0)==0:0)break;n=n-(c[258575]|0)|0}else{f=f+538|0;n=n-H|0}while(0);if(U){t=(c[e+4536>>2]|0)==0;r=t?0:~L;t=t?0:~M}else{r=0;t=0}Oa=27968+(V<<3)|0;s=c[Oa>>2]|0;Oa=c[Oa+4>>2]|0;v=Xa;u=c[v>>2]&s;v=c[v+4>>2]&Oa;s=s&r;r=Oa&t;do if((u&y|s&A|0)==0?(v&x|r&B|0)==0:0){if(((u|s)&N|0)==0&((v|r)&K|0)==0)break;n=n-(c[258575]|0)|0}else{f=f+874|0;n=n-H|0}while(0);if(Q){Ma=L&S;Na=M&T;La=Yu(Ma|0,Na|0,16)|0;Oa=Yu(Ma|0,Na|0,48)|0;n=(_((d[1151952+(La&65535)>>0]|0)+(d[1151952+(Ma&65535)>>0]|0)+(d[1151952+(Na&65535)>>0]|0)+(d[1151952+Oa>>0]|0)|0,-6553700)|0)+n|0}if((f|0)<=0){f=R;O=n;break}p:do if(P)switch(c[(c[pb>>2]|0)+40>>2]|0){case 2:case 3:case 4:{f=f*3|0;break p}case 1:{f=f<<1;break p}case 0:{f=((f|0)/2|0)+f|0;break p}default:break p}while(0);O=(_(f,f)|0)>>>12;f=c[2916+(l<<2)>>2]|0;O=(f|0)<(O|0)?f:O;f=R;O=n-(U?O*65537|0:O)|0}while(0);Oa=V&7;W=8+(Oa<<3)|0;Na=c[W>>2]|0;W=c[W+4>>2]|0;X=Na&q;La=W&p;Ka=Zu(X|0,La|0,4)|0;Ka=k&~o&X|Ka;La=j&~m&La|C;X=c[1034264+(l<<2)>>2]|0;Ia=Yu(Ka|0,La|0,16)|0;Ma=Yu(Ka|0,La|0,48)|0;X=_((d[1151952+(Ia&65535)>>0]|0)+(d[1151952+(Ka&65535)>>0]|0)+(d[1151952+(La&65535)>>0]|0)+(d[1151952+Ma>>0]|0)|0,X)|0;Oa=72+(Oa<<3)|0;W=(((c[Oa>>2]|Na)&g|0)==0?((c[Oa+4>>2]|W)&f|0)==0:0)?0-(c[258582]|0)|0:0;switch(l|0){case 4:{if(!(c[fb>>2]|0))V=64;else cb=276;break}case 2:{if(!(c[fb>>2]|0))V=64;else cb=276;break}case 1:{V=64;break}default:cb=276}if((cb|0)==276)V=c[ib>>2]|0;f=c[qb>>2]|0;if((c[f+68>>2]|0)==(V|0)?(c[f+84>>2]|0)==(c[(c[pb>>2]|0)+24>>2]&12|0):0)f=c[f+76>>2]|0;else{cb=of(f,e,V)|0;c[f+76>>2]=cb;f=cb}g=c[Qa>>2]|0;do if(!g){p=tb;k=Va;n=eb;g=db;q=c[p>>2]|0;p=c[p+4>>2]|0;o=c[n>>2]|0;n=c[n+4>>2]|0;m=c[k>>2]|0;k=c[k+4>>2]|0;l=c[sb>>2]|0;j=c[g>>2]|0;g=c[g+4>>2]|0}else{T=gb;S=c[T>>2]|0;T=c[T+4>>2]|0;J=bb;I=c[J>>2]|0;J=c[J+4>>2]|0;j=S&~I;k=T&~J;p=tb;q=c[p>>2]|0;p=c[p+4>>2]|0;n=j&q;o=k&p;s=ob;r=c[s>>2]|0;s=c[s+4>>2]|0;G=lb;F=c[G>>2]|0;G=c[G+4>>2]|0;w=~F;z=~G;Qa=q&~r&c[Ra>>2]&w;Ra=p&~s&c[Ra+4>>2]&z;Oa=_(c[Sa>>2]|0,g)|0;Na=(c[Ta>>2]|0)*101|0;Ta=Yu(n|0,o|0,16)|0;Sa=Yu(n|0,o|0,48)|0;Sa=((d[1151952+(Ta&65535)>>0]|0)+(d[1151952+(n&65535)>>0]|0)+(d[1151952+(o&65535)>>0]|0)+(d[1151952+Sa>>0]|0)|0)*235|0;Ta=Yu(Qa|0,Ra|0,16)|0;cb=Yu(Qa|0,Ra|0,48)|0;g=Ua;l=c[sb>>2]|0;U=(l|0)==3;g=(((f<<16>>16)*7|0)/-5|0)+-5+Na+((Oa|0)<807?Oa:807)+Sa+(((d[1151952+(Ta&65535)>>0]|0)+(d[1151952+(Qa&65535)>>0]|0)+(d[1151952+(Ra&65535)>>0]|0)+(d[1151952+cb>>0]|0)+(((c[g>>2]|0)!=0|(c[g+4>>2]|0)!=0)&1)|0)*134|0)-(0-(((c[e+356>>2]|0)!=0|U)&1^1)&717)|0;if(U){cb=c[e+4516>>2]|0;g=((c[e+4500>>2]|0)*124|0)+g+((c[e+4504>>2]|0)*129|0)+((c[e+4508>>2]|0)*27|0)+((c[e+4512>>2]|0)*73|0)+(cb*71|0)|0;if(!cb){B=0;A=0}else{A=nb;B=j&~c[A>>2];A=k&~c[A+4>>2]}}else{B=0;A=0}y=Y;x=c[y>>2]|0;y=c[y+4>>2]|0;Q=(l|0)==2;j=Q?S:0;R=Q?T:0;k=Va;m=c[k>>2]|0;k=c[k+4>>2]|0;t=(j|n&w&x)&m|B&q;n=(R|o&z&y)&k|A&p;o=Yu(t|0,n|0,16)|0;u=Yu(t|0,n|0,48)|0;u=(((d[1151952+(o&65535)>>0]|0)+(d[1151952+(t&65535)>>0]|0)+(d[1151952+(n&65535)>>0]|0)+(d[1151952+u>>0]|0)|0)*997|0)+g|0;g=j|~(F|r);r=R|~(G|s);n=eb;o=c[n>>2]|0;n=c[n+4>>2]|0;R=db;j=c[R>>2]|0;R=c[R+4>>2]|0;s=Yu(j|0,R|0,8)|0;s=~(j&F&s|o);t=~(R&G&C|n);P=(l|0)==7;if(P){K=(c[(c[pb>>2]|0)+36>>2]|0)==0;v=K?g:w;r=K?r:z;N=K?s:w;K=K?t:z}else{v=g;N=s;K=t}M=nb;L=c[M>>2]|0;M=c[M+4>>2]|0;w=24064+(V<<3)|0;z=24576+(V<<3)|0;z=(_(c[w+4>>2]&M,c[z+4>>2]|0)|0)^(_(c[w>>2]&L,c[z>>2]|0)|0);z=(c[1031004+(V<<2)>>2]|0)+(z>>>(c[1031260+(V<<2)>>2]|0)<<3)|0;w=c[z>>2]|0;z=c[z+4>>2]|0;D=25088+(V<<3)|0;E=25600+(V<<3)|0;E=(_(c[D+4>>2]&M,c[E+4>>2]|0)|0)^(_(c[D>>2]&L,c[E>>2]|0)|0);E=(c[1031516+(V<<2)>>2]|0)+(E>>>(c[1031772+(V<<2)>>2]|0)<<3)|0;D=c[E>>2]|0;E=c[E+4>>2]|0;g=(v&(x|B)&(D|w)|0)==0?(r&(y|A)&(E|z)|0)==0:0;H=c[258574]|0;f=f-(g?0:H)|0;g=g?u:u+695|0;x=Z;y=c[x>>2]&~(I|F);x=c[x+4>>2]&~(J|G);B=mb;A=(y&q|v)&~c[B>>2];B=(x&p|r)&~c[B+4>>2];y=y&m|v;x=x&k|r;if(U){u=(c[e+4512>>2]|0)==0;t=u?0:~L;u=u?0:~M}else{t=0;u=0}s=aa;r=c[s>>2]|0;s=c[s+4>>2]|0;do if(((r&y|t&A)&w|0)==0?((s&x|u&B)&z|0)==0:0){if((w&N&(r|t)|0)==0?(z&K&(s|u)|0)==0:0)break;f=f-(c[258575]|0)|0}else{g=g+638|0;f=f-H|0}while(0);if(U){u=(c[e+4508>>2]|0)==0;t=u?0:~L;u=u?0:~M}else{t=0;u=0}s=Ja;r=c[s>>2]|0;s=c[s+4>>2]|0;do if(((r&y|t&A)&D|0)==0?((s&x|u&B)&E|0)==0:0){if((D&N&(r|t)|0)==0?(E&K&(s|u)|0)==0:0)break;f=f-(c[258575]|0)|0}else{g=g+538|0;f=f-H|0}while(0);if(U){t=(c[e+4504>>2]|0)==0;r=t?0:~L;t=t?0:~M}else{r=0;t=0}cb=27968+(V<<3)|0;s=c[cb>>2]|0;cb=c[cb+4>>2]|0;v=Wa;u=c[v>>2]&s;v=c[v+4>>2]&cb;s=s&r;r=cb&t;do if((u&y|s&A|0)==0?(v&x|r&B|0)==0:0){if(((u|s)&N|0)==0&((v|r)&K|0)==0)break;f=f-(c[258575]|0)|0}else{g=g+874|0;f=f-H|0}while(0);if(Q){Ta=L&S;Ua=M&T;Sa=Yu(Ta|0,Ua|0,16)|0;cb=Yu(Ta|0,Ua|0,48)|0;f=(_((d[1151952+(Sa&65535)>>0]|0)+(d[1151952+(Ta&65535)>>0]|0)+(d[1151952+(Ua&65535)>>0]|0)+(d[1151952+cb>>0]|0)|0,-6553700)|0)+f|0}if((g|0)<=0){g=R;break}q:do if(P)switch(c[(c[pb>>2]|0)+36>>2]|0){case 2:case 3:case 4:{g=g*3|0;break q}case 1:{g=g<<1;break q}case 0:{g=((g|0)/2|0)+g|0;break q}default:break q}while(0);cb=(_(g,g)|0)>>>12;g=c[2916+(l<<2)>>2]|0;cb=(g|0)<(cb|0)?g:cb;g=R;f=f-(U?cb*65537|0:cb)|0}while(0);Ua=V&7;cb=72+(Ua<<3)|0;Ta=c[cb>>2]|0;cb=c[cb+4>>2]|0;Sa=Ta&q;Qa=cb&p;Oa=Yu(Sa|0,Qa|0,4)|0;Oa=m&~o&Sa|Oa;Qa=k&~n&Qa|C;Sa=c[1034264+(l<<2)>>2]|0;Na=Yu(Oa|0,Qa|0,16)|0;Ra=Yu(Oa|0,Qa|0,48)|0;Ua=8+(Ua<<3)|0;Sa=_((d[1151952+(Na&65535)>>0]|0)+(d[1151952+(Oa&65535)>>0]|0)+(d[1151952+(Qa&65535)>>0]|0)+(d[1151952+Ra>>0]|0)|0,Sa)|0;h=O+h-X+W-f+Sa+((((c[Ua>>2]|Ta)&j|0)==0?((c[Ua+4>>2]|cb)&g|0)==0:0)?c[258582]|0:0)|0;switch(l|0){case 1:{cb=316;break o}case 2:break;default:{v=l;cb=325;break o}}y=mb;x=c[y>>2]|0;y=c[y+4>>2]|0;t=db;s=c[t>>2]|0;t=c[t+4>>2]|0;r=eb;v=2;g=x&~s;n=0;j=y&~t;m=0;o=c[r>>2]|0;r=c[r+4>>2]|0;p=1;f=0;cb=330}while(0);do if((cb|0)==316){I=tb;H=c[I>>2]|0;I=c[I+4>>2]|0;o=mb;l=c[o>>2]|0;o=c[o+4>>2]|0;f=l&H;g=o&I;K=ob;J=c[K>>2]|0;K=c[K+4>>2]|0;q=lb;n=c[q>>2]|0;q=c[q+4>>2]|0;F=(n&J|0)!=0|(q&K|0)!=0;if((f|0)==0&(g|0)==0){m=Wa;r=Ja;t=aa;v=Y;x=Ya;g=Va;w=c[x>>2]|0;y=c[v>>2]|0;x=c[x+4>>2]|0;v=c[v+4>>2]|0;u=c[t>>2]|0;t=c[t+4>>2]|0;s=c[r>>2]|0;r=c[r+4>>2]|0;p=c[m>>2]|0;m=c[m+4>>2]|0;j=c[g>>2]|0;g=c[g+4>>2]|0;f=0}else{G=Va;j=c[G>>2]|0;G=c[G+4>>2]|0;D=~j;E=~G;z=(f&J|0)==0&(g&K|0)==0&((f&~J|0)!=0|(g&~K|0)!=0)&1;A=F&1;B=1034056+(A<<6)+(z<<5)|0;g=ab;f=c[g>>2]&l;g=c[g+4>>2]&o;if((f&D|0)==0&(g&E|0)==0)if((f|0)==0&(g|0)==0)k=0;else k=0-(c[B>>2]|0)|0;else k=0-(c[1034056+(A<<6)+(z<<5)+4>>2]|0)|0;m=Wa;p=c[m>>2]|0;m=c[m+4>>2]|0;f=p&l;g=m&o;if((f&D|0)==0&(g&E|0)==0){if(!((f|0)==0&(g|0)==0))k=k-(c[B>>2]|0)|0}else k=k-(c[1034056+(A<<6)+(z<<5)+8>>2]|0)|0;r=Ja;s=c[r>>2]|0;r=c[r+4>>2]|0;f=s&l;g=r&o;if((f&D|0)==0&(g&E|0)==0){if(!((f|0)==0&(g|0)==0))k=k-(c[B>>2]|0)|0}else k=k-(c[1034056+(A<<6)+(z<<5)+12>>2]|0)|0;t=aa;u=c[t>>2]|0;t=c[t+4>>2]|0;f=u&l;g=t&o;if((f&D|0)==0&(g&E|0)==0){if(!((f|0)==0&(g|0)==0))k=k-(c[B>>2]|0)|0}else k=k-(c[1034056+(A<<6)+(z<<5)+16>>2]|0)|0;v=Y;y=c[v>>2]|0;v=c[v+4>>2]|0;f=y&l;g=v&o;do if((f&D|0)==0&(g&E|0)==0){if((f|0)==0&(g|0)==0)break;k=k-(c[B>>2]|0)|0}else k=k-(c[1034056+(A<<6)+(z<<5)+20>>2]|0)|0;while(0);x=Ya;w=c[x>>2]|0;x=c[x+4>>2]|0;f=w&l;g=x&o;do if((f&D|0)==0&(g&E|0)==0){if((f|0)==0&(g|0)==0)break;k=k-(c[B>>2]|0)|0}else k=k-(c[1034056+(A<<6)+(z<<5)+24>>2]|0)|0;while(0);if(!F){cb=377;break}g=G;f=k-(_(c[258511]|0,c[e+336>>2]|0)|0)|0}k=db;_a=c[k>>2]&n;k=c[k+4>>2]&q;cb=nb;ab=~c[cb>>2];cb=~c[cb+4>>2];Wa=Zu(_a|0,k|0,8)|0;k=Zu(ab&16711680&Wa|_a|0,k|0,8)|0;k=k&ab;_a=C&cb;ab=(y|w|u|s|p)&ab;cb=(v|x|t|r|m)&cb;Wa=(k|ab)&J;Ya=(_a|cb)&K;Va=Yu(Wa|0,Ya|0,16)|0;Za=Yu(Wa|0,Ya|0,48)|0;Za=(_((d[1151952+(Va&65535)>>0]|0)+(d[1151952+(Wa&65535)>>0]|0)+(d[1151952+(Ya&65535)>>0]|0)+(d[1151952+Za>>0]|0)|0,c[258512]|0)|0)+f|0;ab=(k&~H|ab&~j)&J;cb=(_a&~I|cb&~g)&K;_a=Yu(ab|0,cb|0,16)|0;k=Yu(ab|0,cb|0,48)|0;k=Za+(_((d[1151952+(_a&65535)>>0]|0)+(d[1151952+(ab&65535)>>0]|0)+(d[1151952+(cb&65535)>>0]|0)+(d[1151952+k>>0]|0)|0,c[258513]|0)|0)|0;cb=377}else if((cb|0)==325){r=mb;q=c[r>>2]|0;r=c[r+4>>2]|0;f=$a;t=e+304|0;p=tb;n=c[p>>2]|0;p=c[p+4>>2]|0;j=ob;g=c[j>>2]|0;j=c[j+4>>2]|0;f=((q&~(c[t>>2]|c[f>>2])&~(g|n)|0)==0?(r&~(c[t+4>>2]|c[f+4>>2])&~(j|p)|0)==0:0)?0:c[258577]|0;t=db;s=c[t>>2]|0;t=c[t+4>>2]|0;m=q&~s;o=r&~t;l=ab;k=m&c[l>>2];l=o&c[l+4>>2];if(!((k|0)==0&(l|0)==0)){cb=lb;Va=s&(n|~g)&c[cb>>2];j=t&(p|~j)&c[cb+4>>2];cb=Zu(Va|0,j|0,9)|0;g=C&-16843010;j=Zu(Va|0,j|0,7)|0;j=(cb&-16843264|j&2139062016)&k;g=(g|C&2139062143)&l;f=((k|0)==(j|0)&(l|0)==(g|0)?0:c[258576]|0)+f|0;if(!((j|0)==0&(g|0)==0))do{cb=hb(j|0,g|0,0)|0;Va=Xu(j|0,g|0,-1,-1)|0;j=Va&j;g=C&g;f=(c[1033896+((c[e+(cb<<2)>>2]&7)<<2)>>2]|0)+f|0}while(!((j|0)==0&(g|0)==0))}cb=eb;Va=c[cb>>2]|0;cb=c[cb+4>>2]|0;g=Va&m;n=q&~Va&n;j=cb&o;m=r&~cb&p;x=q;y=r;o=Va;r=cb;p=0;cb=330}while(0);r:do if((cb|0)==330){g=n|g;j=m|j;if(!((g|0)==0&(j|0)==0)){Va=Ja;g=(c[Va>>2]|c[Wa>>2])&g;j=(c[Va+4>>2]|c[Wa+4>>2])&j;if(!((g|0)==0&(j|0)==0)){l=c[258584]|0;do{k=hb(g|0,j|0,0)|0;Wa=Xu(g|0,j|0,-1,-1)|0;g=Wa&g;j=C&j;Wa=c[e+(k<<2)>>2]&7;f=(c[1033928+(Wa<<2)>>2]|0)+f|0;if((Wa|0)!=1)f=(_(k>>>3^7,l)|0)+f|0}while(!((g|0)==0&(j|0)==0))}Wa=$a;j=aa;g=(c[Wa>>2]&x|n)&c[j>>2];j=(c[Wa+4>>2]&y|m)&c[j+4>>2];if(!((g|0)==0&(j|0)==0)){l=c[258584]|0;do{k=hb(g|0,j|0,0)|0;Wa=Xu(g|0,j|0,-1,-1)|0;g=Wa&g;j=C&j;Wa=c[e+(k<<2)>>2]&7;f=(c[1033960+(Wa<<2)>>2]|0)+f|0;if((Wa|0)!=1)f=(_(k>>>3^7,l)|0)+f|0}while(!((g|0)==0&(j|0)==0))}j=c[258579]|0;Wa=ob;Va=n&~c[Wa>>2];Wa=m&~c[Wa+4>>2];Ua=Yu(Va|0,Wa|0,16)|0;g=Yu(Va|0,Wa|0,48)|0;j=(_((d[1151952+(Ua&65535)>>0]|0)+(d[1151952+(Va&65535)>>0]|0)+(d[1151952+(Wa&65535)>>0]|0)+(d[1151952+g>>0]|0)|0,j)|0)+f|0;f=Ya;g=c[f>>2]&n;f=c[f+4>>2]&m;if((v|0)!=2&((g|0)!=0|(f|0)!=0)){Ya=Xu(g|0,f|0,-1,-1)|0;j=(c[1033992+((((Ya&g|0)!=0|(C&f|0)!=0)&1)<<2)>>2]|0)+j|0}}else j=f;q=lb;n=c[q>>2]|0;q=c[q+4>>2]|0;Ya=n&s;k=q&t;Wa=Zu(Ya|0,k|0,8)|0;f=nb;g=~c[f>>2];f=~c[f+4>>2];k=Zu(g&16711680&Wa|Ya|0,k&65535|0,8)|0;if(!p){Wa=tb;Ya=ob;g=g&~o&(c[Wa>>2]|~c[Ya>>2]);f=f&~r&(c[Wa+4>>2]|~c[Ya+4>>2])}k=g&k;Ya=f&C;Va=Zu(k|0,Ya|0,7)|0;Wa=C&2139062143;Ya=Zu(k|0,Ya|0,9)|0;k=ab;Ya=(c[k>>2]^-65536)&x&(Va&2139029504|Ya&-16908288);Wa=~c[k+4>>2]&y&(Wa|C&-16843010);k=c[258580]|0;Va=Yu(Ya|0,Wa|0,16)|0;Ya=Yu(Ya|0,Wa|0,48)|0;k=(_((d[1151952+(Va&65535)>>0]|0)+(d[1151952]|0)+(d[1151952+(Wa&65535)>>0]|0)+(d[1151952+Ya>>0]|0)|0,k)|0)+j|0;switch(v|0){case 1:{l=x;o=y;cb=377;break r}case 7:{v=7;k=(c[1034e3+(c[(c[pb>>2]|0)+36>>2]<<2)>>2]|0)+k|0;cb=386;break}case 4:{if((c[fb>>2]|0)==0?(cb=e+288|0,_a=$a,Za=c[_a>>2]|0,_a=c[_a+4>>2]|0,!(((Za|c[cb>>2])&n|0)==0?((_a|c[cb+4>>2])&q|0)==0:0)):0){bb=Y;Ya=aa;cb=26688;if(((c[Ya>>2]|c[bb>>2])&c[cb>>2]|0)==0?((c[Ya+4>>2]|c[bb+4>>2])&c[cb+4>>2]|0)==0:0){o=s&x;m=t&y;g=0;f=8;s:while(1){cb=26624+(g<<3)|0;bb=c[cb>>2]&o;cb=c[cb+4>>2]&m;Ya=Yu(bb|0,cb|0,16)|0;l=Yu(bb|0,cb|0,48)|0;l=(d[1151952+(Ya&65535)>>0]|0)+(d[1151952+(bb&65535)>>0]|0)+(d[1151952+(cb&65535)>>0]|0)+(d[1151952+l>>0]|0)|0;do if((g|0)>0){cb=26624+(g+-1<<3)|0;bb=c[cb>>2]&o;cb=c[cb+4>>2]&m;Ya=Yu(bb|0,cb|0,16)|0;j=Yu(bb|0,cb|0,48)|0;j=(d[1151952+(Ya&65535)>>0]|0)+(d[1151952+(bb&65535)>>0]|0)+(d[1151952+(cb&65535)>>0]|0)+(d[1151952+j>>0]|0)|0;j=l>>>0<j>>>0?l:j;if((g|0)<7)break;g=g+1|0;f=(j|0)<(f|0)?j:f;if((g|0)==8)break s;else continue s}else j=0;while(0);bb=g+1|0;Ya=26624+(bb<<3)|0;Wa=c[Ya>>2]&o;Ya=c[Ya+4>>2]&m;Va=Yu(Wa|0,Ya|0,16)|0;cb=Yu(Wa|0,Ya|0,48)|0;cb=(d[1151952+(Va&65535)>>0]|0)+(d[1151952+(Wa&65535)>>0]|0)+(d[1151952+(Ya&65535)>>0]|0)+(d[1151952+cb>>0]|0)|0;cb=(l>>>0<cb>>>0?l:cb)+j|0;g=bb;f=(cb|0)<(f|0)?cb:f}f=f+1|0}else f=1;bb=_(c[e+372>>2]|0,c[258576]|0)|0;bb=(((bb+32768>>16|0)/(f|0)|0)<<16)+((bb<<16>>16|0)/(f|0)|0)|0;cb=(Za&n|0)!=0|(_a&q|0)!=0?2:4;v=4;k=((bb<<16>>16|0)/(cb|0)|0)+k+(((bb+32768>>16|0)/(cb|0)|0)<<16)|0;cb=386}else{v=4;cb=386}break}case 2:{u=db;t=c[u>>2]|0;u=c[u+4>>2]|0;w=ab;g=n&~t;p=0;j=q&~u;o=0;v=2;r=c[w>>2]|0;w=c[w+4>>2]|0;s=1;f=0;break}default:cb=386}if((cb|0)==386){f=$a;u=e+304|0;s=ob;p=c[s>>2]|0;s=c[s+4>>2]|0;j=tb;g=c[j>>2]|0;j=c[j+4>>2]|0;f=((n&~(c[u>>2]|c[f>>2])&~(g|p)|0)==0?(q&~(c[u+4>>2]|c[f+4>>2])&~(j|s)|0)==0:0)?0:c[258577]|0;u=db;t=c[u>>2]|0;u=c[u+4>>2]|0;o=n&~t;r=q&~u;m=eb;l=o&c[m>>2];m=r&c[m+4>>2];if(!((l|0)==0&(m|0)==0)){bb=t&(p|~g)&x;j=u&(s|~j)&y;db=Yu(bb|0,j|0,9)|0;g=C&8355711;j=Yu(bb|0,j|0,7)|0;j=(db&2139062143|j&-16843010)&l;g=(g|C&16711422)&m;f=((l|0)==(j|0)&(m|0)==(g|0)?0:c[258576]|0)+f|0;if(!((j|0)==0&(g|0)==0))do{db=hb(j|0,g|0,0)|0;bb=Xu(j|0,g|0,-1,-1)|0;j=bb&j;g=C&g;f=(c[1033896+((c[e+(db<<2)>>2]&7)<<2)>>2]|0)+f|0}while(!((j|0)==0&(g|0)==0))}w=ab;db=c[w>>2]|0;w=c[w+4>>2]|0;g=db&o;p=n&~db&p;j=w&r;o=q&~w&s;r=db;s=0}g=p|g;j=o|j;if(!((g|0)==0&(j|0)==0)){db=Xa;bb=Pa;g=(c[bb>>2]|c[db>>2])&g;j=(c[bb+4>>2]|c[db+4>>2])&j;if(!((g|0)==0&(j|0)==0)){m=c[258584]|0;do{l=hb(g|0,j|0,0)|0;db=Xu(g|0,j|0,-1,-1)|0;g=db&g;j=C&j;db=c[e+(l<<2)>>2]&7;f=(c[1033928+(db<<2)>>2]|0)+f|0;if((db|0)!=1)f=(_(l>>>3,m)|0)+f|0}while(!((g|0)==0&(j|0)==0))}db=$a;j=ba;g=(c[db>>2]&n|p)&c[j>>2];j=(c[db+4>>2]&q|o)&c[j+4>>2];if(!((g|0)==0&(j|0)==0)){m=c[258584]|0;do{l=hb(g|0,j|0,0)|0;db=Xu(g|0,j|0,-1,-1)|0;g=db&g;j=C&j;db=c[e+(l<<2)>>2]&7;f=(c[1033960+(db<<2)>>2]|0)+f|0;if((db|0)!=1)f=(_(l>>>3,m)|0)+f|0}while(!((g|0)==0&(j|0)==0))}j=c[258579]|0;db=tb;bb=p&~c[db>>2];db=o&~c[db+4>>2];ab=Yu(bb|0,db|0,16)|0;g=Yu(bb|0,db|0,48)|0;j=(_((d[1151952+(ab&65535)>>0]|0)+(d[1151952+(bb&65535)>>0]|0)+(d[1151952+(db&65535)>>0]|0)+(d[1151952+g>>0]|0)|0,j)|0)+f|0;f=gb;g=c[f>>2]&p;f=c[f+4>>2]&o;if((v|0)!=2&((g|0)!=0|(f|0)!=0)){gb=Xu(g|0,f|0,-1,-1)|0;j=(c[1033992+((((gb&g|0)!=0|(C&f|0)!=0)&1)<<2)>>2]|0)+j|0}}else j=f;gb=x&t;l=y&u;Yu(gb|0,l|0,8)|0;f=nb;g=~c[f>>2];f=~c[f+4>>2];l=Yu(gb&-65536|0,f&65280&C|l|0,8)|0;if(!s){db=ob;gb=tb;g=g&~r&(c[db>>2]|~c[gb>>2]);f=f&~w&(c[db+4>>2]|~c[gb+4>>2])}ab=g&l;db=f&C;bb=Yu(ab|0,db|0,7)|0;gb=C&65278;db=Yu(ab|0,db|0,9)|0;db=~c[eb>>2]&n&(bb&-16843010|db&2139062143);eb=(c[eb+4>>2]^65535)&q&(gb|C&32639);gb=c[258580]|0;bb=Yu(db|0,eb|0,16)|0;j=(_((d[1151952+(bb&65535)>>0]|0)+(d[1151952+(db&65535)>>0]|0)+(d[1151952+eb>>0]|0)+(d[1151952]|0)|0,gb)|0)+j|0;switch(v|0){case 7:{l=x;o=y;j=(c[1034e3+(c[(c[pb>>2]|0)+40>>2]<<2)>>2]|0)+j|0;cb=443;break r}case 4:{cb=408;break}default:{}}if((cb|0)==408){if(c[kb>>2]|0){l=x;o=y;cb=443;break}gb=e+288|0;s=$a;r=c[s>>2]|0;s=c[s+4>>2]|0;if(((r|c[gb>>2])&x|0)==0?((s|c[gb+4>>2])&y|0)==0:0){l=x;o=y;cb=443;break}eb=Z;db=ba;gb=26688;if(((c[db>>2]|c[eb>>2])&c[gb>>2]|0)==0?((c[db+4>>2]|c[eb+4>>2])&c[gb+4>>2]|0)==0:0){p=t&n;o=u&q;g=0;f=8;t:while(1){gb=26624+(g<<3)|0;eb=c[gb>>2]&p;gb=c[gb+4>>2]&o;db=Yu(eb|0,gb|0,16)|0;m=Yu(eb|0,gb|0,48)|0;m=(d[1151952+(db&65535)>>0]|0)+(d[1151952+(eb&65535)>>0]|0)+(d[1151952+(gb&65535)>>0]|0)+(d[1151952+m>>0]|0)|0;do if((g|0)>0){gb=26624+(g+-1<<3)|0;eb=c[gb>>2]&p;gb=c[gb+4>>2]&o;db=Yu(eb|0,gb|0,16)|0;l=Yu(eb|0,gb|0,48)|0;l=(d[1151952+(db&65535)>>0]|0)+(d[1151952+(eb&65535)>>0]|0)+(d[1151952+(gb&65535)>>0]|0)+(d[1151952+l>>0]|0)|0;l=m>>>0<l>>>0?m:l;if((g|0)<7)break;g=g+1|0;f=(l|0)<(f|0)?l:f;if((g|0)==8)break t;else continue t}else l=0;while(0);eb=g+1|0;db=26624+(eb<<3)|0;cb=c[db>>2]&p;db=c[db+4>>2]&o;bb=Yu(cb|0,db|0,16)|0;gb=Yu(cb|0,db|0,48)|0;gb=(d[1151952+(bb&65535)>>0]|0)+(d[1151952+(cb&65535)>>0]|0)+(d[1151952+(db&65535)>>0]|0)+(d[1151952+gb>>0]|0)|0;gb=(m>>>0<gb>>>0?m:gb)+l|0;g=eb;f=(gb|0)<(f|0)?gb:f}f=f+1|0}else f=1;eb=_(c[e+340>>2]|0,c[258576]|0)|0;eb=(((eb+32768>>16|0)/(f|0)|0)<<16)+((eb<<16>>16|0)/(f|0)|0)|0;gb=(r&x|0)!=0|(s&y|0)!=0?2:4;j=((eb<<16>>16|0)/(gb|0)|0)+j+(((eb+32768>>16|0)/(gb|0)|0)<<16)|0}if((v|0)!=6){r=(c[qb>>2]|0)+16|0;p=c[r>>2]|0;r=c[r+4>>2]|0;if((v|0)!=5){l=x;o=y;f=0;cb=446;break}g=c[jb>>2]|0;m=0;f=0;while(1){eb=c[2948+(m<<2)>>2]|0;Ya=c[1014620+(g<<8)+(eb<<2)>>2]|0;Za=nb;Za=Jf(e,eb,c[Za>>2]|0,c[Za+4>>2]|0)|0;o=mb;l=c[o>>2]|0;o=c[o+4>>2]|0;Za=l&Za;ab=o&C;_a=Yu(Za|0,ab|0,16)|0;bb=Yu(Za|0,ab|0,48)|0;Za=d[1151952+(Za&65535)>>0]|0;_a=d[1151952+(_a&65535)>>0]|0;ab=d[1151952+(ab&65535)>>0]|0;bb=d[1151952+bb>>0]|0;q=lb;n=c[q>>2]|0;q=c[q+4>>2]|0;eb=26112+(eb<<3)|0;cb=c[eb>>2]&n;eb=c[eb+4>>2]&q;db=Yu(cb|0,eb|0,16)|0;gb=Yu(cb|0,eb|0,48)|0;gb=Ya+-1+Za+_a+ab+bb+(d[1151952+(cb&65535)>>0]|0)+(d[1151952+(db&65535)>>0]|0)+(d[1151952+(eb&65535)>>0]|0)+(d[1151952+gb>>0]|0)|0;f=(c[1034016+(((gb|0)>5?5:gb)<<2)>>2]|0)+f|0;m=m+1|0;if((m|0)==4){cb=446;break r}}}o=c[jb>>2]|0;p=o>>3;f=p^7;l=p+1|0;if((l|0)<8){m=ob;n=~(n|c[m>>2]);m=~(q|c[m+4>>2]);g=p;while(1){ob=26688+(l<<3)|0;g=100672+(o<<6)+(g-p<<3)|0;f=(((c[ob>>2]&n&c[g>>2]|0)==0?(c[ob+4>>2]&m&c[g+4>>2]|0)==0:0)&1)+f|0;g=l+1|0;if((g|0)==8)break;else{ob=l;l=g;g=ob}}}l=x;o=y;r=k;q=j;p=h;f=c[1034184+(((f|0)>7?7:f)<<2)>>2]|0;cb=475}while(0);do if((cb|0)==377){J=ob;I=c[J>>2]|0;J=c[J+4>>2]|0;f=n&I;g=q&J;L=tb;K=c[L>>2]|0;L=c[L+4>>2]|0;G=(l&K|0)!=0|(o&L|0)!=0;if((f|0)==0&(g|0)==0){p=Xa;s=Pa;u=ba;w=Z;y=gb;g=bb;x=c[y>>2]|0;z=c[w>>2]|0;y=c[y+4>>2]|0;w=c[w+4>>2]|0;v=c[u>>2]|0;u=c[u+4>>2]|0;t=c[s>>2]|0;s=c[s+4>>2]|0;r=c[p>>2]|0;p=c[p+4>>2]|0;m=c[g>>2]|0;g=c[g+4>>2]|0;f=0}else{H=bb;m=c[H>>2]|0;H=c[H+4>>2]|0;E=~m;F=~H;A=(f&K|0)==0&(g&L|0)==0&((f&~K|0)!=0|(g&~L|0)!=0)&1;B=G&1;D=1034056+(B<<6)+(A<<5)|0;g=eb;f=c[g>>2]&n;g=c[g+4>>2]&q;if((f&E|0)==0&(g&F|0)==0)if((f|0)==0&(g|0)==0)j=0;else j=0-(c[D>>2]|0)|0;else j=0-(c[1034056+(B<<6)+(A<<5)+4>>2]|0)|0;p=Xa;r=c[p>>2]|0;p=c[p+4>>2]|0;f=r&n;g=p&q;if((f&E|0)==0&(g&F|0)==0){if(!((f|0)==0&(g|0)==0))j=j-(c[D>>2]|0)|0}else j=j-(c[1034056+(B<<6)+(A<<5)+8>>2]|0)|0;s=Pa;t=c[s>>2]|0;s=c[s+4>>2]|0;f=t&n;g=s&q;if((f&E|0)==0&(g&F|0)==0){if(!((f|0)==0&(g|0)==0))j=j-(c[D>>2]|0)|0}else j=j-(c[1034056+(B<<6)+(A<<5)+12>>2]|0)|0;u=ba;v=c[u>>2]|0;u=c[u+4>>2]|0;f=v&n;g=u&q;if((f&E|0)==0&(g&F|0)==0){if(!((f|0)==0&(g|0)==0))j=j-(c[D>>2]|0)|0}else j=j-(c[1034056+(B<<6)+(A<<5)+16>>2]|0)|0;w=Z;z=c[w>>2]|0;w=c[w+4>>2]|0;f=z&n;g=w&q;do if((f&E|0)==0&(g&F|0)==0){if((f|0)==0&(g|0)==0)break;j=j-(c[D>>2]|0)|0}else j=j-(c[1034056+(B<<6)+(A<<5)+20>>2]|0)|0;while(0);y=gb;x=c[y>>2]|0;y=c[y+4>>2]|0;f=x&n;g=y&q;do if((f&E|0)==0&(g&F|0)==0){if((f|0)==0&(g|0)==0)break;j=j-(c[D>>2]|0)|0}else j=j-(c[1034056+(B<<6)+(A<<5)+24>>2]|0)|0;while(0);if(!G){cb=443;break}g=H;f=j-(_(c[258511]|0,c[e+368>>2]|0)|0)|0}j=db;eb=c[j>>2]&l;j=c[j+4>>2]&o;cb=nb;gb=~c[cb>>2];cb=~c[cb+4>>2];Yu(eb|0,j|0,8)|0;j=Yu(eb|0,cb&65280&C|j|0,8)|0;j=j&gb;eb=C&cb;gb=(z|x|v|t|r)&gb;cb=(w|y|u|s|p)&cb;ab=(j|gb)&K;bb=(eb|cb)&L;_a=Yu(ab|0,bb|0,16)|0;db=Yu(ab|0,bb|0,48)|0;db=(_((d[1151952+(_a&65535)>>0]|0)+(d[1151952+(ab&65535)>>0]|0)+(d[1151952+(bb&65535)>>0]|0)+(d[1151952+db>>0]|0)|0,c[258512]|0)|0)+f|0;gb=(j&~I|gb&~m)&K;cb=(eb&~J|cb&~g)&L;eb=Yu(gb|0,cb|0,16)|0;j=Yu(gb|0,cb|0,48)|0;j=db+(_((d[1151952+(eb&65535)>>0]|0)+(d[1151952+(gb&65535)>>0]|0)+(d[1151952+(cb&65535)>>0]|0)+(d[1151952+j>>0]|0)|0,c[258513]|0)|0)|0;cb=443}while(0);if((cb|0)==443){r=(c[qb>>2]|0)+16|0;p=c[r>>2]|0;r=c[r+4>>2]|0;f=0;cb=446}if((cb|0)==446){if((p|0)==0&(r|0)==0)g=c[sb>>2]|0;else{G=ob;F=l|c[G>>2];G=o|c[G+4>>2];H=c[258583]|0;g=c[sb>>2]|0;I=c[ib>>2]|0;J=c[jb>>2]|0;K=(c[kb>>2]|0)==0;M=e+288|0;O=$a;L=c[O>>2]|c[M>>2];M=c[O+4>>2]|c[M+4>>2];O=nb;N=c[O>>2]|0;O=c[O+4>>2]|0;Q=tb;P=c[Q>>2]|0;Q=c[Q+4>>2]|0;R=(c[fb>>2]|0)==0;E=R?64:I;do{B=hb(p|0,r|0,0)|0;y=Xu(p|0,r|0,-1,-1)|0;p=y&p;r=C&r;y=104768+(B<<3)|0;x=c[y>>2]|0;y=c[y+4>>2]|0;w=x&F;v=y&G;A=Yu(w|0,v|0,16)|0;D=Yu(w|0,v|0,48)|0;D=_((d[1151952+(A&65535)>>0]|0)+(d[1151952+(w&65535)>>0]|0)+(d[1151952+(v&65535)>>0]|0)+(d[1151952+D>>0]|0)|0,H)|0;v=B>>>3;w=v+-1|0;A=_(w,v+-2|0)|0;m=c[2964+(g<<6)+(w<<2)>>2]|0;s=c[2964+(g<<6)+32+(w<<2)>>2]|0;do if(A){z=B+8|0;u:do switch(g|0){case 4:if(K){s=(_(((c[1014620+(E<<8)+(z<<2)>>2]|0)*5|0)+-10|0,A)|0)+s|0;break u}else{s=(_(25-(c[1014620+(J<<8)+(z<<2)>>2]<<1)|0,A)|0)+s|0;break u}case 1:break;case 2:{t=(c[(R?1031004+(z<<2)|0:1014620+(I<<8)+(z<<2)|0)>>2]|0)*5|0;if(K){u=64;cb=458}else cb=457;break}default:{t=(c[1014620+(I<<8)+(z<<2)>>2]|0)*5|0;cb=457}}while(0);if((cb|0)==457){u=J;cb=458}if((cb|0)==458){cb=0;s=(_(t-(c[1014620+(u<<8)+(z<<2)>>2]<<1)|0,A)|0)+s|0;if((z&248|0)!=56){switch(g|0){case 4:{if(K)t=64;else cb=462;break}case 2:{if(K)t=64;else cb=462;break}default:cb=462}if((cb|0)==462){cb=0;t=J}s=s-(_(c[1014620+(t<<8)+(B+16<<2)>>2]|0,A)|0)|0}}if(c[e+(z<<2)>>2]|0){gb=26112+(z<<3)|0;if((c[gb>>2]&n|0)==0?(c[gb+4>>2]&q|0)==0:0)break;gb=_(w,v)|0;s=s+gb|0;m=m+gb|0;break}w=105280+(B<<3)|0;t=24064+(B<<3)|0;u=24576+(B<<3)|0;u=(_(c[t+4>>2]&O,c[u+4>>2]|0)|0)^(_(c[t>>2]&N,c[u>>2]|0)|0);u=(c[1031004+(B<<2)>>2]|0)+(u>>>(c[1031260+(B<<2)>>2]|0)<<3)|0;t=c[w>>2]&L&c[u>>2];u=c[w+4>>2]&M&c[u+4>>2];w=(t&n|0)==0&(u&q|0)==0;v=(w?P:-1)&x;w=(w?Q:-1)&y;u=(t&l|0)==0&(u&o|0)==0;t=(u?F:-1)&x;u=(u?G:-1)&y;if((t|0)==0&(u|0)==0)t=18;else{gb=26112+(z<<3)|0;t=((c[gb>>2]&t|0)==0?(c[gb+4>>2]&u|0)==0:0)?8:0}if((v|0)==(x|0)&(w|0)==(y|0))t=t+6|0;else{gb=26112+(z<<3)|0;t=((c[gb>>2]&v|0)==0?(c[gb+4>>2]&w|0)==0:0)?t:t|4}gb=_(t,A)|0;s=gb+s|0;m=gb+m|0}while(0);f=f-D+m+(s<<16)+(c[1034216+((B&7)<<2)>>2]|0)|0}while(!((p|0)==0&(r|0)==0))}if((g|0)!=6){s=(c[qb>>2]|0)+24|0;r=c[s>>2]|0;s=c[s+4>>2]|0;if((g|0)==5){m=c[ib>>2]|0;p=0;g=0;do{eb=c[2948+(p<<2)>>2]|0;Xa=c[1014620+(m<<8)+(eb<<2)>>2]|0;Ya=nb;Ya=Jf(e,eb,c[Ya>>2]|0,c[Ya+4>>2]|0)|0;q=lb;n=c[q>>2]|0;q=c[q+4>>2]|0;Ya=n&Ya;_a=q&C;Za=Yu(Ya|0,_a|0,16)|0;ab=Yu(Ya|0,_a|0,48)|0;Ya=d[1151952+(Ya&65535)>>0]|0;Za=d[1151952+(Za&65535)>>0]|0;_a=d[1151952+(_a&65535)>>0]|0;ab=d[1151952+ab>>0]|0;o=mb;l=c[o>>2]|0;o=c[o+4>>2]|0;eb=26112+(eb<<3)|0;bb=c[eb>>2]&l;eb=c[eb+4>>2]&o;db=Yu(bb|0,eb|0,16)|0;gb=Yu(bb|0,eb|0,48)|0;gb=Xa+-1+Ya+Za+_a+ab+(d[1151952+(bb&65535)>>0]|0)+(d[1151952+(db&65535)>>0]|0)+(d[1151952+(eb&65535)>>0]|0)+(d[1151952+gb>>0]|0)|0;g=(c[1034016+(((gb|0)>5?5:gb)<<2)>>2]|0)+g|0;p=p+1|0}while((p|0)!=4)}else g=0;if(!((r|0)==0&(s|0)==0)){Q=tb;P=n|c[Q>>2];Q=q|c[Q+4>>2];R=c[258583]|0;S=c[sb>>2]|0;O=c[jb>>2]|0;N=c[ib>>2]|0;M=(c[fb>>2]|0)==0;L=e+288|0;J=$a;K=c[J>>2]|c[L>>2];L=c[J+4>>2]|c[L+4>>2];J=nb;I=c[J>>2]|0;J=c[J+4>>2]|0;H=ob;G=c[H>>2]|0;H=c[H+4>>2]|0;F=(c[kb>>2]|0)==0;E=F?64:O;D=r;B=s;do{z=hb(D|0,B|0,0)|0;w=Xu(D|0,B|0,-1,-1)|0;D=w&D;B=C&B;w=105280+(z<<3)|0;v=c[w>>2]|0;w=c[w+4>>2]|0;u=v&P;t=w&Q;y=Yu(u|0,t|0,16)|0;A=Yu(u|0,t|0,48)|0;A=_((d[1151952+(y&65535)>>0]|0)+(d[1151952+(u&65535)>>0]|0)+(d[1151952+(t&65535)>>0]|0)+(d[1151952+A>>0]|0)|0,R)|0;t=z>>>3^7;u=t+-1|0;y=_(u,t+-2|0)|0;m=c[2964+(S<<6)+(u<<2)>>2]|0;p=c[2964+(S<<6)+32+(u<<2)>>2]|0;do if(y){x=z+-8|0;v:do switch(S|0){case 4:if(M){p=(_(((c[1014620+(E<<8)+(x<<2)>>2]|0)*5|0)+-10|0,y)|0)+p|0;break v}else{p=(_(25-(c[1014620+(N<<8)+(x<<2)>>2]<<1)|0,y)|0)+p|0;break v}case 1:break;case 2:{r=(c[(F?1031004+(x<<2)|0:1014620+(O<<8)+(x<<2)|0)>>2]|0)*5|0;if(M){s=64;cb=492}else cb=491;break}default:{r=(c[1014620+(O<<8)+(x<<2)>>2]|0)*5|0;cb=491}}while(0);if((cb|0)==491){s=N;cb=492}do if((cb|0)==492){cb=0;p=(_(r-(c[1014620+(s<<8)+(x<<2)>>2]<<1)|0,y)|0)+p|0;if(x>>>0<8)break;switch(S|0){case 4:{if(M)r=64;else cb=496;break}case 2:{if(M)r=64;else cb=496;break}default:cb=496}if((cb|0)==496){cb=0;r=N}p=p-(_(c[1014620+(r<<8)+(z+-16<<2)>>2]|0,y)|0)|0}while(0);if(c[e+(x<<2)>>2]|0){ob=26112+(x<<3)|0;if((c[ob>>2]&l|0)==0?(c[ob+4>>2]&o|0)==0:0)break;ob=_(u,t)|0;p=p+ob|0;m=m+ob|0;break}u=104768+(z<<3)|0;r=24064+(z<<3)|0;s=24576+(z<<3)|0;s=(_(c[r+4>>2]&J,c[s+4>>2]|0)|0)^(_(c[r>>2]&I,c[s>>2]|0)|0);s=(c[1031004+(z<<2)>>2]|0)+(s>>>(c[1031260+(z<<2)>>2]|0)<<3)|0;r=c[u>>2]&K&c[s>>2];s=c[u+4>>2]&L&c[s+4>>2];u=(r&l|0)==0&(s&o|0)==0;t=(u?G:-1)&v;u=(u?H:-1)&w;s=(r&n|0)==0&(s&q|0)==0;r=(s?P:-1)&v;s=(s?Q:-1)&w;if((r|0)==0&(s|0)==0)r=18;else{ob=26112+(x<<3)|0;r=((c[ob>>2]&r|0)==0?(c[ob+4>>2]&s|0)==0:0)?8:0}if((t|0)==(v|0)&(u|0)==(w|0))r=r+6|0;else{ob=26112+(x<<3)|0;r=((c[ob>>2]&t|0)==0?(c[ob+4>>2]&u|0)==0:0)?r:r|4}ob=_(r,y)|0;p=ob+p|0;m=ob+m|0}while(0);g=g-A+m+(p<<16)+(c[1034216+((z&7)<<2)>>2]|0)|0}while(!((D|0)==0&(B|0)==0))}}else{r=k;q=j;p=h;cb=475}}if((cb|0)==475){m=c[ib>>2]|0;n=m>>3;g=n^7;j=n+1|0;if((j|0)<8){k=tb;l=~(l|c[k>>2]);k=~(o|c[k+4>>2]);h=n;while(1){ob=26688+(j<<3)|0;h=100672+(m<<6)+(h-n<<3)|0;g=(((c[ob>>2]&l&c[h>>2]|0)==0?(c[ob+4>>2]&k&c[h+4>>2]|0)==0:0)&1)+g|0;h=j+1|0;if((h|0)==8)break;else{ob=j;j=h;h=ob}}}k=r;j=q;h=p;g=c[1034184+(((g|0)>7?7:g)<<2)>>2]|0}f=k+h-j+(f-g)|0;g=c[pb>>2]|0;h=c[g+16>>2]|0;if((h|0)==0?(c[g+20>>2]|0)==0:0){ob=c[qb>>2]|0;nb=ob+16|0;pb=c[258581]|0;ob=ob+24|0;f=((c[nb>>2]|0)==0&(c[nb+4>>2]|0)==0?0:pb)+f-((c[ob>>2]|0)==0&(c[ob+4>>2]|0)==0?0:pb)|0}j=c[sb>>2]|0;if((j|0)!=4){if(((c[g+20>>2]|0)+h|0)>12221){pb=Bd(e,tb)|0;f=pb+f-(Cd(e,tb)|0)|0}if((j|0)!=1)f=(Dd(e,c[(c[qb>>2]|0)+112>>2]|0,f+32768>>16)|0)+f|0}else{qb=Bd(e,tb)|0;f=qb+f-(Cd(e,tb)|0)|0}pb=f+32768>>16;qb=Ed(e,tb,pb)|0;tb=c[(c[rb>>2]|0)+24>>2]|0;tb=(((_(_(pb,qb)|0,128-tb|0)|0)/64|0)+(_(tb,f<<16>>16)|0)|0)/128|0;e=((c[e+5348>>2]|0)==0?tb:0-tb|0)+(c[7772+(c[sb>>2]<<2)>>2]|0)|0;i=ub;return e|0}function Gd(a){a=a|0;var b=0,d=0;c[a>>2]=3488;b=a+64|0;c[b>>2]=3528;c[a+8>>2]=3508;d=a+12|0;c[d>>2]=3544;vk(a+44|0);il(d);el(b);return}function Hd(a){a=a|0;c[a>>2]=3544;vk(a+32|0);il(a);return}function Id(a){a=a|0;c[a>>2]=3544;vk(a+32|0);il(a);mu(a);return}function Jd(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0;i=d+44|0;j=c[i>>2]|0;m=d+24|0;n=c[m>>2]|0;k=n;if(j>>>0<n>>>0){c[i>>2]=n;l=k}else l=j;i=h&24;if(!i){d=b;c[d>>2]=0;c[d+4>>2]=0;d=b+8|0;c[d>>2]=-1;c[d+4>>2]=-1;return}if((g|0)==1&(i|0)==24){d=b;c[d>>2]=0;c[d+4>>2]=0;d=b+8|0;c[d>>2]=-1;c[d+4>>2]=-1;return}a:do switch(g|0){case 0:{i=0;j=0;break}case 1:if(!(h&8)){j=k-(c[d+20>>2]|0)|0;i=j;j=((j|0)<0)<<31>>31;break a}else{j=(c[d+12>>2]|0)-(c[d+8>>2]|0)|0;i=j;j=((j|0)<0)<<31>>31;break a}case 2:{i=d+32|0;if(!(a[i>>0]&1))i=i+1|0;else i=c[d+40>>2]|0;j=l-i|0;i=j;j=((j|0)<0)<<31>>31;break}default:{d=b;c[d>>2]=0;c[d+4>>2]=0;d=b+8|0;c[d>>2]=-1;c[d+4>>2]=-1;return}}while(0);j=Xu(i|0,j|0,e|0,f|0)|0;k=C;if((k|0)>=0){i=d+32|0;if(!(a[i>>0]&1))i=i+1|0;else i=c[d+40>>2]|0;f=l-i|0;e=((f|0)<0)<<31>>31;if(!((e|0)<(k|0)|(e|0)==(k|0)&f>>>0<j>>>0)){i=h&8;if(!((j|0)==0&(k|0)==0)){if(i|0?(c[d+12>>2]|0)==0:0){d=b;c[d>>2]=0;c[d+4>>2]=0;d=b+8|0;c[d>>2]=-1;c[d+4>>2]=-1;return}if((h&16|0)!=0&(n|0)==0){d=b;c[d>>2]=0;c[d+4>>2]=0;d=b+8|0;c[d>>2]=-1;c[d+4>>2]=-1;return}}if(i|0){c[d+12>>2]=(c[d+8>>2]|0)+j;c[d+16>>2]=l}if(h&16|0)c[m>>2]=(c[d+20>>2]|0)+j;d=b;c[d>>2]=0;c[d+4>>2]=0;d=b+8|0;c[d>>2]=j;c[d+4>>2]=k;return}}d=b;c[d>>2]=0;c[d+4>>2]=0;d=b+8|0;c[d>>2]=-1;c[d+4>>2]=-1;return}function Kd(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;d=d+8|0;Kb[c[(c[b>>2]|0)+16>>2]&15](a,b,c[d>>2]|0,c[d+4>>2]|0,0,e);return}function Ld(a){a=a|0;var b=0,e=0,f=0;b=a+44|0;e=c[b>>2]|0;f=c[a+24>>2]|0;if(e>>>0<f>>>0){c[b>>2]=f;b=f}else b=e;if(!(c[a+48>>2]&8)){a=-1;return a|0}f=a+16|0;e=c[f>>2]|0;if(e>>>0<b>>>0){c[f>>2]=b;e=b}b=c[a+12>>2]|0;if(b>>>0>=e>>>0){a=-1;return a|0}a=d[b>>0]|0;return a|0}function Md(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0;f=b+44|0;e=c[f>>2]|0;g=c[b+24>>2]|0;if(e>>>0<g>>>0){c[f>>2]=g;e=g}h=b+12|0;f=c[h>>2]|0;if((c[b+8>>2]|0)>>>0>=f>>>0){b=-1;return b|0}if((d|0)==-1){c[h>>2]=f+-1;c[b+16>>2]=e;b=0;return b|0}if(!(c[b+48>>2]&16)){g=d&255;f=f+-1|0;if(g<<24>>24!=(a[f>>0]|0)){b=-1;return b|0}}else{g=d&255;f=f+-1|0}c[h>>2]=f;c[b+16>>2]=e;a[f>>0]=g;b=d;return b|0}function Nd(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;t=i;i=i+16|0;o=t;if((d|0)==-1){b=0;i=t;return b|0}p=b+12|0;q=b+8|0;r=(c[p>>2]|0)-(c[q>>2]|0)|0;s=b+24|0;l=c[s>>2]|0;m=b+28|0;e=c[m>>2]|0;if((l|0)==(e|0)){k=b+48|0;if(!(c[k>>2]&16)){b=-1;i=t;return b|0}g=b+20|0;h=c[g>>2]|0;n=b+44|0;j=(c[n>>2]|0)-h|0;f=b+32|0;Gk(f,0);if(!(a[f>>0]&1))e=10;else e=(c[f>>2]&-2)+-1|0;Bk(f,e,0);e=a[f>>0]|0;if(!(e&1)){f=f+1|0;e=(e&255)>>>1}else{f=c[b+40>>2]|0;e=c[b+36>>2]|0}e=f+e|0;c[g>>2]=f;c[m>>2]=e;l=f+(l-h)|0;c[s>>2]=l;f=f+j|0;c[n>>2]=f;m=n;g=n;j=e}else{f=b+44|0;m=f;k=b+48|0;g=f;f=c[f>>2]|0;j=e}h=l+1|0;c[o>>2]=h;f=c[(h>>>0<f>>>0?g:o)>>2]|0;c[m>>2]=f;if(c[k>>2]&8|0){e=b+32|0;if(!(a[e>>0]&1))e=e+1|0;else e=c[b+40>>2]|0;c[q>>2]=e;c[p>>2]=e+r;c[b+16>>2]=f}if((l|0)==(j|0)){b=Lb[c[(c[b>>2]|0)+52>>2]&63](b,d&255)|0;i=t;return b|0}else{c[s>>2]=h;a[l>>0]=d;b=d&255;i=t;return b|0}return 0}function Od(a){a=a|0;var b=0,d=0;c[a>>2]=3488;b=a+64|0;c[b>>2]=3528;c[a+8>>2]=3508;d=a+12|0;c[d>>2]=3544;vk(a+44|0);il(d);el(b);mu(a);return}function Pd(a){a=a|0;var b=0,d=0;d=a+-8|0;c[d>>2]=3488;a=d+64|0;c[a>>2]=3528;c[d+8>>2]=3508;b=d+12|0;c[b>>2]=3544;vk(d+44|0);il(b);el(a);return}function Qd(a){a=a|0;var b=0,d=0;a=a+-8|0;c[a>>2]=3488;b=a+64|0;c[b>>2]=3528;c[a+8>>2]=3508;d=a+12|0;c[d>>2]=3544;vk(a+44|0);il(d);el(b);mu(a);return}function Rd(a){a=a|0;var b=0,d=0;d=a+(c[(c[a>>2]|0)+-12>>2]|0)|0;c[d>>2]=3488;a=d+64|0;c[a>>2]=3528;c[d+8>>2]=3508;b=d+12|0;c[b>>2]=3544;vk(d+44|0);il(b);el(a);return}function Sd(a){a=a|0;var b=0,d=0;a=a+(c[(c[a>>2]|0)+-12>>2]|0)|0;c[a>>2]=3488;b=a+64|0;c[b>>2]=3528;c[a+8>>2]=3508;d=a+12|0;c[d>>2]=3544;vk(a+44|0);il(d);el(b);mu(a);return}function Td(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0;i=b+32|0;wk(i,d)|0;h=b+44|0;c[h>>2]=0;j=b+48|0;g=c[j>>2]|0;if(g&8|0){d=a[i>>0]|0;if(!(d&1)){d=((d&255)>>>1)+(i+1)|0;c[h>>2]=d;e=i+1|0;f=i+1|0}else{f=c[b+40>>2]|0;d=f+(c[b+36>>2]|0)|0;c[h>>2]=d;e=f}c[b+8>>2]=e;c[b+12>>2]=f;c[b+16>>2]=d}if(!(g&16))return;d=a[i>>0]|0;if(!(d&1)){g=(d&255)>>>1;c[h>>2]=i+1+g;d=10;h=g}else{g=c[b+36>>2]|0;c[h>>2]=(c[b+40>>2]|0)+g;d=(c[i>>2]&-2)+-1|0;h=g}Bk(i,d,0);d=a[i>>0]|0;if(!(d&1)){g=i+1|0;f=(d&255)>>>1;e=i+1|0}else{e=c[b+40>>2]|0;g=e;f=c[b+36>>2]|0}d=b+24|0;c[d>>2]=e;c[b+20>>2]=e;c[b+28>>2]=g+f;if(!(c[j>>2]&3))return;c[d>>2]=e+h;return}function Ud(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;n=i;i=i+16|0;j=n+12|0;m=n;k=n+8|0;mm(m,b);if(!(a[m>>0]|0)){nm(m);i=n;return b|0}l=b+(c[(c[b>>2]|0)+-12>>2]|0)|0;c[k>>2]=c[l+24>>2];g=d+e|0;h=(c[l+4>>2]&176|0)==32?g:d;f=l+76|0;e=c[f>>2]|0;if((e|0)==-1){c[j>>2]=gm(l)|0;e=Om(j,1150100)|0;e=Lb[c[(c[e>>2]|0)+28>>2]&63](e,32)|0;_t(j);e=e<<24>>24;c[f>>2]=e}c[j>>2]=c[k>>2];if(Vd(j,d,h,g,l,e&255)|0){nm(m);i=n;return b|0}d=b+(c[(c[b>>2]|0)+-12>>2]|0)|0;em(d,c[d+16>>2]|5);nm(m);i=n;return b|0}function Vd(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0;o=i;i=i+16|0;m=o;n=c[b>>2]|0;if(!n){b=0;i=o;return b|0}p=d;k=f-p|0;l=g+12|0;j=c[l>>2]|0;k=(j|0)>(k|0)?j-k|0:0;j=e;g=j-p|0;if((g|0)>0?(yb[c[(c[n>>2]|0)+48>>2]&31](n,d,g)|0)!=(g|0):0){c[b>>2]=0;p=0;i=o;return p|0}do if((k|0)>0){sk(m,k,h);if((yb[c[(c[n>>2]|0)+48>>2]&31](n,(a[m>>0]&1)==0?m+1|0:c[m+8>>2]|0,k)|0)==(k|0)){vk(m);break}c[b>>2]=0;vk(m);p=0;i=o;return p|0}while(0);f=f-j|0;if((f|0)>0?(yb[c[(c[n>>2]|0)+48>>2]&31](n,e,f)|0)!=(f|0):0){c[b>>2]=0;p=0;i=o;return p|0}c[l>>2]=0;p=n;i=o;return p|0}function Wd(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0;e=c[d+48>>2]|0;if(e&16|0){e=d+44|0;f=c[e>>2]|0;g=c[d+24>>2]|0;if(f>>>0<g>>>0)c[e>>2]=g;else g=f;f=c[d+20>>2]|0;h=g-f|0;if(h>>>0>4294967279)ok(b);if(h>>>0<11){a[b>>0]=h<<1;e=b+1|0}else{d=h+16&-16;e=Nu(d)|0;c[b+8>>2]=e;c[b>>2]=d|1;c[b+4>>2]=h}if((f|0)!=(g|0)){d=e;while(1){a[d>>0]=a[f>>0]|0;f=f+1|0;if((f|0)==(g|0))break;else d=d+1|0}e=e+h|0}a[e>>0]=0;return}if(!(e&8)){c[b>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;return}f=c[d+8>>2]|0;d=c[d+16>>2]|0;h=d-f|0;if(h>>>0>4294967279)ok(b);if(h>>>0<11){a[b>>0]=h<<1;e=b+1|0}else{g=h+16&-16;e=Nu(g)|0;c[b+8>>2]=e;c[b>>2]=g|1;c[b+4>>2]=h}if((f|0)!=(d|0)){g=e;while(1){a[g>>0]=a[f>>0]|0;f=f+1|0;if((f|0)==(d|0))break;else g=g+1|0}e=e+h|0}a[e>>0]=0;return}function Xd(){var a=0,b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0;a=i;i=i+96|0;b=a;rk(b,17165,5);d=b+12|0;rk(d,17171,8);e=b+24|0;rk(e,17180,6);f=b+36|0;rk(f,17187,10);g=b+48|0;rk(g,17198,5);h=b+60|0;rk(h,17204,13);j=b+72|0;rk(j,17218,11);k=b+84|0;rk(k,17230,10);l=Nu(96)|0;c[258587]=l;c[258586]=l;c[258588]=l+96;qk(l,b);l=(c[258587]|0)+12|0;c[258587]=l;qk(l,d);l=(c[258587]|0)+12|0;c[258587]=l;qk(l,e);l=(c[258587]|0)+12|0;c[258587]=l;qk(l,f);l=(c[258587]|0)+12|0;c[258587]=l;qk(l,g);l=(c[258587]|0)+12|0;c[258587]=l;qk(l,h);l=(c[258587]|0)+12|0;c[258587]=l;qk(l,j);l=(c[258587]|0)+12|0;c[258587]=l;qk(l,k);c[258587]=(c[258587]|0)+12;vk(k);vk(j);vk(h);vk(g);vk(f);vk(e);vk(d);vk(b);i=a;return}function Yd(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0;d=i;i=i+32|0;h=d+24|0;e=d+12|0;b=d;le(e,0);f=a[e>>0]|0;g=(f&1)==0;f=Ud(1149064,g?e+1|0:c[e+8>>2]|0,g?(f&255)>>>1:c[e+4>>2]|0)|0;c[h>>2]=gm(f+(c[(c[f>>2]|0)+-12>>2]|0)|0)|0;g=Om(h,1150100)|0;g=Lb[c[(c[g>>2]|0)+28>>2]&63](g,10)|0;_t(h);ym(f,g)|0;lm(f)|0;vk(e);vh(1148396);Zf();$b();Ff();Yb();Eg();qf();Og(1148216);rk(b,17285,4);Zg(1148256,qh(Zd(1148396,b)|0)|0);vk(b);i=d;return 0}function Zd(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0;j=i;i=i+16|0;h=j;d=a+4|0;f=c[d>>2]|0;do if(f){g=a+8|0;while(1){d=f+16|0;if(uh(g,b,d)|0){d=c[f>>2]|0;if(!d){e=f;d=f;g=5;break}}else{if(!(uh(g,d,b)|0)){d=f;g=10;break}e=f+4|0;d=c[e>>2]|0;if(!d){d=f;g=9;break}}f=d}if((g|0)==5){c[h>>2]=d;break}else if((g|0)==9){c[h>>2]=d;break}else if((g|0)==10){c[h>>2]=d;e=h;f=d;g=12;break}}else{c[h>>2]=d;e=d;g=12}while(0);if((g|0)==12)if(f){a=f;a=a+28|0;i=j;return a|0}f=Nu(92)|0;h=f+16|0;c[h>>2]=c[b>>2];c[h+4>>2]=c[b+4>>2];c[h+8>>2]=c[b+8>>2];c[b>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;zh(f+28|0,0);c[f>>2]=0;c[f+4>>2]=0;c[f+8>>2]=d;c[e>>2]=f;d=c[c[a>>2]>>2]|0;if(!d)d=f;else{c[a>>2]=d;d=c[e>>2]|0}ic(c[a+4>>2]|0,d);a=a+8|0;c[a>>2]=(c[a>>2]|0)+1;a=f;a=a+28|0;i=j;return a|0}function _d(){var a=0,b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0;a=i;i=i+96|0;b=a;rk(b,17165,5);d=b+12|0;rk(d,17171,8);e=b+24|0;rk(e,17180,6);f=b+36|0;rk(f,17187,10);g=b+48|0;rk(g,17198,5);h=b+60|0;rk(h,17204,13);j=b+72|0;rk(j,17218,11);k=b+84|0;rk(k,17230,10);l=Nu(96)|0;c[258590]=l;c[258589]=l;c[258591]=l+96;qk(l,b);l=(c[258590]|0)+12|0;c[258590]=l;qk(l,d);l=(c[258590]|0)+12|0;c[258590]=l;qk(l,e);l=(c[258590]|0)+12|0;c[258590]=l;qk(l,f);l=(c[258590]|0)+12|0;c[258590]=l;qk(l,g);l=(c[258590]|0)+12|0;c[258590]=l;qk(l,h);l=(c[258590]|0)+12|0;c[258590]=l;qk(l,j);l=(c[258590]|0)+12|0;c[258590]=l;qk(l,k);c[258590]=(c[258590]|0)+12;vk(k);vk(j);vk(h);vk(g);vk(f);vk(e);vk(d);vk(b);c[258592]=3748;c[258593]=0;c[258594]=1;c[258595]=3748;c[258596]=1;c[258597]=0;c[258598]=3772;c[258599]=0;c[258600]=1;c[258601]=3772;c[258602]=1;c[258603]=0;c[258604]=3796;c[258605]=0;c[258606]=1;c[258607]=3796;c[258608]=1;c[258609]=0;c[258610]=3820;c[258611]=0;c[258612]=1;c[258613]=3820;c[258614]=1;c[258615]=0;c[258616]=3844;c[258617]=0;c[258618]=1;c[258619]=3844;c[258620]=1;c[258621]=0;i=a;return}function $d(a){a=a|0;mu(a);return}function ae(a){a=a|0;return c[a+4>>2]|0}function be(a){a=a|0;mu(a);return}function ce(a){a=a|0;return c[a+4>>2]|0}function de(a){a=a|0;mu(a);return}function ee(a){a=a|0;return c[a+4>>2]|0}function fe(a){a=a|0;mu(a);return}function ge(a){a=a|0;return c[a+4>>2]|0}function he(a){a=a|0;mu(a);return}function ie(a){a=a|0;return c[a+4>>2]|0}function je(d){d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0;y=i;i=i+64|0;u=y;r=d+5356|0;o=(c[r>>2]|0)+8|0;n=c[o>>2]|0;o=c[o+4>>2]|0;m=d+5352|0;v=n&8191;w=c[(c[m>>2]|0)+100>>2]|0;x=w+(v<<5)|0;t=x;if((c[t>>2]|0)==(n|0)?(c[t+4>>2]|0)==(o|0):0){i=y;return x|0};c[x>>2]=0;c[x+4>>2]=0;c[x+8>>2]=0;c[x+12>>2]=0;c[x+16>>2]=0;c[x+20>>2]=0;c[x+24>>2]=0;c[x+28>>2]=0;t=x;c[t>>2]=n;c[t+4>>2]=o;t=w+(v<<5)+11|0;a[t>>0]=64;s=w+(v<<5)+10|0;a[s>>0]=64;c[w+(v<<5)+24>>2]=If(d)|0;l=c[m>>2]|0;k=l+112|0;e=c[l+116>>2]|0;a:do if(e){g=e;while(1){j=g+16|0;h=c[j>>2]|0;j=c[j+4>>2]|0;if(!(j>>>0>o>>>0|(j|0)==(o|0)&h>>>0>n>>>0)){if(!(j>>>0<o>>>0|(j|0)==(o|0)&h>>>0<n>>>0))break;g=g+4|0}g=c[g>>2]|0;if(!g){p=20;break a}}while(1){h=e+16|0;g=c[h>>2]|0;h=c[h+4>>2]|0;if(o>>>0<h>>>0|(o|0)==(h|0)&n>>>0<g>>>0){g=c[e>>2]|0;if(!g){g=e;p=11;break}else e=g}else{if(!(h>>>0<o>>>0|(h|0)==(o|0)&g>>>0<n>>>0)){p=16;break}g=e+4|0;h=c[g>>2]|0;if(!h){p=15;break}else e=h}}if((p|0)==11){c[u>>2]=e;h=e;p=17}else if((p|0)==15){c[u>>2]=e;h=e;p=17}else if((p|0)==16){c[u>>2]=e;if(!e){g=u;h=e;p=17}}if((p|0)==17){e=Nu(32)|0;j=e+16|0;c[j>>2]=n;c[j+4>>2]=o;c[e+24>>2]=0;c[e>>2]=0;c[e+4>>2]=0;c[e+8>>2]=h;c[g>>2]=e;h=c[c[k>>2]>>2]|0;if(!h)g=e;else{c[k>>2]=h;g=c[g>>2]|0}ic(c[l+116>>2]|0,g);l=l+120|0;c[l>>2]=(c[l>>2]|0)+1}l=c[e+24>>2]|0;e=w+(v<<5)+12|0;c[e>>2]=l;if(!l)g=e;else{i=y;return x|0}}else p=20;while(0);if((p|0)==20){g=w+(v<<5)+12|0;c[g>>2]=0}e=c[r>>2]|0;l=d+328|0;k=c[l>>2]|0;l=c[l+4>>2]|0;j=Xu(k|0,l|0,-1,-1)|0;if((j&k|0)==0&(C&l|0)==0?(c[e+16>>2]|0)>1284:0)e=0;else p=25;do if((p|0)==25){l=d+320|0;k=c[l>>2]|0;l=c[l+4>>2]|0;j=Xu(k|0,l|0,-1,-1)|0;if((j&k|0)==0&(C&l|0)==0?(c[e+20>>2]|0)>1284:0){e=1;break}m=c[m>>2]|0;l=m+124|0;k=c[m+128>>2]|0;b:do if(k){g=k;while(1){j=g+16|0;h=c[j>>2]|0;j=c[j+4>>2]|0;if(!(j>>>0>o>>>0|(j|0)==(o|0)&h>>>0>n>>>0)){if(!(j>>>0<o>>>0|(j|0)==(o|0)&h>>>0<n>>>0))break;g=g+4|0}g=c[g>>2]|0;if(!g)break b}e=k;while(1){h=e+16|0;g=c[h>>2]|0;h=c[h+4>>2]|0;if(o>>>0<h>>>0|(o|0)==(h|0)&n>>>0<g>>>0){g=c[e>>2]|0;if(!g){g=e;p=35;break}else e=g}else{if(!(h>>>0<o>>>0|(h|0)==(o|0)&g>>>0<n>>>0)){p=40;break}g=e+4|0;h=c[g>>2]|0;if(!h){p=39;break}else e=h}}if((p|0)==35){c[u>>2]=e;h=g;g=e;p=41}else if((p|0)==39){c[u>>2]=e;h=g;g=e;p=41}else if((p|0)==40){c[u>>2]=e;if(!e){h=u;g=e;p=41}}if((p|0)==41){e=Nu(32)|0;k=e+16|0;c[k>>2]=n;c[k+4>>2]=o;c[e+24>>2]=0;c[e>>2]=0;c[e+4>>2]=0;c[e+8>>2]=g;c[h>>2]=e;g=c[c[l>>2]>>2]|0;if(!g)g=e;else{c[l>>2]=g;g=c[h>>2]|0}ic(c[m+128>>2]|0,g);o=m+132|0;c[o>>2]=(c[o>>2]|0)+1}e=c[e+24>>2]|0;if(!e){e=c[r>>2]|0;break}c[w+(v<<5)+16+((Fb[c[(c[e>>2]|0)+8>>2]&127](e)|0)<<2)>>2]=e;i=y;return x|0}while(0);g=c[e+16>>2]|0;if(((g|0)==826?(c[d+348>>2]|0)==1:0)?(q=c[d+340>>2]|0,(q|0)>0):0){c[w+(v<<5)+16>>2]=1034392;e=q}else{e=c[d+340>>2]|0;if(!e)if((((g|0)==2513?(c[d+356>>2]|0)==1:0)?(c[d+384>>2]|0)==1:0)?(c[d+372>>2]|0)>0:0){c[w+(v<<5)+16>>2]=1034416;e=0}else e=0}g=c[(c[r>>2]|0)+20>>2]|0;if(((g|0)==826?(c[d+380>>2]|0)==1:0)?(f=c[d+372>>2]|0,(f|0)>0):0)c[w+(v<<5)+20>>2]=1034404;else{f=c[d+372>>2]|0;if(!f)if(((g|0)==2513?(c[d+388>>2]|0)==1:0)?((e|0)>0?(c[d+352>>2]|0)==1:0):0){c[w+(v<<5)+20>>2]=1034428;f=0}else f=0}l=c[r>>2]|0;m=c[l+16>>2]|0;l=c[l+20>>2]|0;c:do if((l|0)==(0-m|0)?(r=d+264|0,!((c[r>>2]|0)==0&(c[r+4>>2]|0)==0)):0){if(!f){c[w+(v<<5)+16>>2]=1034440;p=65;break}switch(e|0){case 0:{c[w+(v<<5)+20>>2]=1034452;p=65;break c}case 1:{p=62;break}default:{}}if((p|0)==62?(f|0)==1:0){c[w+(v<<5)+16>>2]=1034464;c[w+(v<<5)+20>>2]=1034476}e=(m-l|0)<827;g=d+340|0;p=66}else p=65;while(0);if((p|0)==65){g=d+340|0;h=(m-l|0)<827;if(h&(e|0)==0){a[s>>0]=(m|0)<1285?0:(l|0)<827?4:14;f=d+372|0;k=f;f=c[f>>2]|0;j=g;e=h}else{e=h;p=66}}if((p|0)==66){k=d+372|0;j=g}g=(l-m|0)<827;if(g&(f|0)==0)a[t>>0]=(l|0)<1285?0:(m|0)<827?4:14;if(e&(c[j>>2]|0)==1)a[s>>0]=48;e=c[k>>2]|0;if(g&(e|0)==1){a[t>>0]=48;e=c[k>>2]|0}m=c[d+348>>2]|0;f=(m|0)>1&1;c[u>>2]=f;c[u+4>>2]=c[j>>2];c[u+8>>2]=c[d+344>>2];c[u+12>>2]=m;c[u+16>>2]=c[d+352>>2];c[u+20>>2]=c[d+356>>2];m=u+24|0;c[m>>2]=0;c[m+4>>2]=0;m=c[d+380>>2]|0;c[u+32>>2]=(m|0)>1&1;c[u+36>>2]=e;c[u+40>>2]=c[d+376>>2];c[u+44>>2]=m;c[u+48>>2]=c[d+384>>2];c[u+52>>2]=c[d+388>>2];m=u+56|0;c[m>>2]=0;c[m+4>>2]=0;m=(c[d+5364>>2]|0)==1;n=m?6:5;d:do if(m){e=0;j=1;k=0;while(1){if(f){h=0;g=0;do{d=_(c[u+(h<<2)>>2]|0,c[3860+(k<<5)+(h<<2)>>2]|0)|0;g=d+g+(_(c[u+32+(h<<2)>>2]|0,c[4084+(k<<5)+(h<<2)>>2]|0)|0)|0;h=h+1|0}while((h|0)!=(j|0));e=(_(g,f)|0)+e|0}g=k+1|0;if((k|0)>=(n|0)){l=e;break d}f=c[u+(g<<2)>>2]|0;j=j+1|0;k=g}}else{e=0;j=1;k=0;while(1){if(f){h=0;g=0;do{d=_(c[u+(h<<2)>>2]|0,c[4308+(k<<5)+(h<<2)>>2]|0)|0;g=d+g+(_(c[u+32+(h<<2)>>2]|0,c[4500+(k<<5)+(h<<2)>>2]|0)|0)|0;h=h+1|0}while((h|0)!=(j|0));e=(_(g,f)|0)+e|0}g=k+1|0;if((k|0)>=(n|0)){l=e;break d}f=c[u+(g<<2)>>2]|0;j=j+1|0;k=g}}while(0);if(m){e=0;j=1;k=0;while(1){h=c[u+32+(k<<2)>>2]|0;if(h){g=0;f=0;do{d=_(c[u+32+(g<<2)>>2]|0,c[3860+(k<<5)+(g<<2)>>2]|0)|0;f=d+f+(_(c[u+(g<<2)>>2]|0,c[4084+(k<<5)+(g<<2)>>2]|0)|0)|0;g=g+1|0}while((g|0)!=(j|0));e=(_(f,h)|0)+e|0}if((k|0)<(n|0)){j=j+1|0;k=k+1|0}else break}}else{e=0;j=1;k=0;while(1){h=c[u+32+(k<<2)>>2]|0;if(h){g=0;f=0;do{d=_(c[u+32+(g<<2)>>2]|0,c[4308+(k<<5)+(g<<2)>>2]|0)|0;f=d+f+(_(c[u+(g<<2)>>2]|0,c[4500+(k<<5)+(g<<2)>>2]|0)|0)|0;g=g+1|0}while((g|0)!=(j|0));e=(_(f,h)|0)+e|0}if((k|0)<(n|0)){j=j+1|0;k=k+1|0}else break}}b[w+(v<<5)+8>>1]=(l-e|0)/16|0;i=y;return x|0}while(0);c[g>>2]=1034368+(e*12|0);i=y;return x|0}function ke(){var a=0,b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0;a=i;i=i+96|0;b=a;rk(b,17165,5);d=b+12|0;rk(d,17171,8);e=b+24|0;rk(e,17180,6);f=b+36|0;rk(f,17187,10);g=b+48|0;rk(g,17198,5);h=b+60|0;rk(h,17204,13);j=b+72|0;rk(j,17218,11);k=b+84|0;rk(k,17230,10);l=Nu(96)|0;c[258623]=l;c[258622]=l;c[258624]=l+96;qk(l,b);l=(c[258623]|0)+12|0;c[258623]=l;qk(l,d);l=(c[258623]|0)+12|0;c[258623]=l;qk(l,e);l=(c[258623]|0)+12|0;c[258623]=l;qk(l,f);l=(c[258623]|0)+12|0;c[258623]=l;qk(l,g);l=(c[258623]|0)+12|0;c[258623]=l;qk(l,h);l=(c[258623]|0)+12|0;c[258623]=l;qk(l,j);l=(c[258623]|0)+12|0;c[258623]=l;qk(l,k);c[258623]=(c[258623]|0)+12;vk(k);vk(j);vk(h);vk(g);vk(f);vk(e);vk(d);vk(b);rk(1034500,1219563,0);i=a;return}function le(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0;D=i;i=i+368|0;o=D+216|0;A=D+204|0;z=D+192|0;y=D+180|0;C=D+168|0;B=D+24|0;u=D+12|0;s=D;rk(A,16113,47);c[z>>2]=0;c[z+4>>2]=0;c[z+8>>2]=0;c[y>>2]=0;c[y+4>>2]=0;c[y+8>>2]=0;c[C>>2]=0;c[C+4>>2]=0;c[C+8>>2]=0;p=B+8|0;c[p>>2]=3508;v=B+12|0;c[B>>2]=3712;w=B+64|0;c[w>>2]=3732;c[B+4>>2]=0;fm(B+64|0,v);c[B+136>>2]=0;c[B+140>>2]=-1;c[B>>2]=3488;c[B+64>>2]=3528;c[p>>2]=3508;hm(v);c[v>>2]=3544;p=B+44|0;c[p>>2]=0;c[p+4>>2]=0;c[p+8>>2]=0;c[p+12>>2]=0;c[B+60>>2]=24;c[o>>2]=0;c[o+4>>2]=0;c[o+8>>2]=0;Td(v,o);vk(o);rk(u,16161,11);t=o+8|0;c[t>>2]=3508;q=o+12|0;c[o>>2]=3712;r=o+64|0;c[r>>2]=3732;c[o+4>>2]=0;fm(o+64|0,q);c[o+136>>2]=0;c[o+140>>2]=-1;c[o>>2]=3488;c[o+64>>2]=3528;c[t>>2]=3508;hm(q);c[q>>2]=3544;t=o+44|0;c[t>>2]=0;c[t+4>>2]=0;c[t+8>>2]=0;c[t+12>>2]=0;c[o+60>>2]=24;Td(q,u);vk(u);u=B+8|0;m=Ud(u,16173,10)|0;x=a[1034500]|0;n=(x&1)==0;x=Ud(m,n?1034501:c[258627]|0,n?(x&255)>>>1:c[258626]|0)|0;c[x+(c[(c[x>>2]|0)+-12>>2]|0)+76>>2]=48;x=a[1034500]|0;if(!(((x&1)==0?(x&255)>>>1:c[258626]|0)|0)){me(me(me(o,z)|0,y)|0,C)|0;c[u+(c[(c[u>>2]|0)+-12>>2]|0)+12>>2]=2;x=a[y>>0]|0;f=(x&1)==0;x=Ud(u,f?y+1|0:c[y+8>>2]|0,f?(x&255)>>>1:c[y+4>>2]|0)|0;c[x+(c[(c[x>>2]|0)+-12>>2]|0)+12>>2]=2;f=a[A>>0]|0;g=(f&1)==0;e=g?A+1|0:c[A+8>>2]|0;f=g?(f&255)>>>1:c[A+4>>2]|0;g=a[z>>0]|0;n=(g&1)==0;l=n?z+1|0:c[z+8>>2]|0;g=n?(g&255)>>>1:c[z+4>>2]|0;if(f>>>0>=g>>>0)if(!g)e=1;else{n=e+f|0;j=l+g|0;m=e;a:do if((f|0)>=(g|0)?(k=n+(1-g)|0,(k|0)!=(e|0)):0){h=a[l>>0]|0;while(1){if((a[e>>0]|0)==h<<24>>24){f=e;g=l;do{g=g+1|0;if((g|0)==(j|0))break a;f=f+1|0}while((a[f>>0]|0)==(a[g>>0]|0))}e=e+1|0;if((e|0)==(k|0)){e=n;break}}}else e=n;while(0);e=(e|0)==(n|0)?1073741824:((e-m|0)>>>2)+1|0}else e=1073741824;m=um(x,e)|0;tk(s,C,2,-1,C);x=a[s>>0]|0;n=(x&1)==0;Ud(m,n?s+1|0:c[s+8>>2]|0,n?(x&255)>>>1:c[s+4>>2]|0)|0;vk(s)}x=Ud(Ud(u,1219563,0)|0,1219563,0)|0;Ud(Ud(x,d?16184:16196,d?11:4)|0,16201,47)|0;Wd(b,v);c[o>>2]=3488;c[r>>2]=3528;c[o+8>>2]=3508;c[q>>2]=3544;vk(t);il(q);el(r);c[B>>2]=3488;c[w>>2]=3528;c[u>>2]=3508;c[v>>2]=3544;vk(p);il(v);el(w);vk(C);vk(y);vk(z);vk(A);i=D;return}function me(e,f){e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0;n=i;i=i+16|0;m=n+4|0;g=n;km(m,e,0);if(!(a[m>>0]|0)){f=e+(c[(c[e>>2]|0)+-12>>2]|0)|0;em(f,c[f+16>>2]|4);i=n;return e|0}if(!(a[f>>0]&1)){a[f+1>>0]=0;a[f>>0]=0}else{a[c[f+8>>2]>>0]=0;c[f+4>>2]=0}h=e+(c[(c[e>>2]|0)+-12>>2]|0)|0;m=c[h+12>>2]|0;m=(m|0)<1?2147483647:m;c[g>>2]=gm(h)|0;h=Om(g,1150100)|0;_t(g);a:do if((m|0)>0){l=h+8|0;g=0;while(1){h=c[e+(c[(c[e>>2]|0)+-12>>2]|0)+24>>2]|0;j=c[h+12>>2]|0;if((j|0)==(c[h+16>>2]|0)){h=Fb[c[(c[h>>2]|0)+36>>2]&127](h)|0;if((h|0)==-1){h=2;break a}}else h=d[j>>0]|0;j=h&255;if(j<<24>>24>-1?b[(c[l>>2]|0)+(h<<24>>24<<1)>>1]&8192:0){h=0;break a}Gk(f,j);g=g+1|0;h=c[e+(c[(c[e>>2]|0)+-12>>2]|0)+24>>2]|0;j=h+12|0;k=c[j>>2]|0;if((k|0)==(c[h+16>>2]|0))Fb[c[(c[h>>2]|0)+40>>2]&127](h)|0;else c[j>>2]=k+1;if((g|0)>=(m|0)){h=0;break}}}else{g=0;h=0}while(0);c[e+(c[(c[e>>2]|0)+-12>>2]|0)+12>>2]=0;f=e+(c[(c[e>>2]|0)+-12>>2]|0)|0;em(f,c[f+16>>2]|((g|0)==0?h|4:h));i=n;return e|0}function ne(){return}function oe(b,c){b=b|0;c=c|0;if((a[973120]|0)==0?Ca(973120)|0:0)Ja(973120);switch(c|0){case 0:{lk(1034512);return b|0}case 1:{mk(1034512);return b|0}default:return b|0}return 0}function pe(a){a=a|0;qe(a);return}function qe(b){b=b|0;var d=0,e=0,f=0,g=0;if((a[973128]|0)==0?Ca(973128)|0:0){c[258635]=4704;c[258661]=4724;fm(1034644,1034544);c[258679]=0;c[258680]=-1;c[258635]=4744;c[258661]=4764;Fe(1034544);f=c[1148976+(c[(c[287244]|0)+-12>>2]|0)+24>>2]|0;hm(1034724);c[258681]=4860;c[258689]=f;c[258690]=1034544;f=c[1149064+(c[(c[287266]|0)+-12>>2]|0)+24>>2]|0;hm(1034764);c[258691]=4860;c[258699]=f;c[258700]=1034544;Ja(973128)}e=a[b>>0]|0;d=(e&1)==0;e=((d?(e&255)>>>1:c[b+4>>2]|0)|0)==0;f=(c[258652]|0)!=0;if(!(f|e)){g=Mi(d?b+1|0:c[b+8>>2]|0,16257)|0;c[258652]=g;if(!g){g=1034540+(c[(c[258635]|0)+-12>>2]|0)|0;em(g,c[g+16>>2]|4)}else{c[258658]=16;em(1034540+(c[(c[258635]|0)+-12>>2]|0)|0,0)}g=1148976+(c[(c[287244]|0)+-12>>2]|0)|0;c[g+24>>2]=1034724;em(g,0);g=1149064+(c[(c[287266]|0)+-12>>2]|0)|0;c[g+24>>2]=1034764;em(g,0);return}if(!(e&f))return;d=1149064+(c[(c[287266]|0)+-12>>2]|0)|0;c[d+24>>2]=c[258699];em(d,0);d=1148976+(c[(c[287244]|0)+-12>>2]|0)|0;c[d+24>>2]=c[258689];em(d,0);d=c[258652]|0;if((d|0?(g=Fb[c[(c[1034544>>2]|0)+24>>2]&127](1034544)|0,(Ci(d)|0)==0):0)?(c[258652]=0,(g|0)==0):0)return;g=1034540+(c[(c[258635]|0)+-12>>2]|0)|0;em(g,c[g+16>>2]|4);return}function re(a){a=a|0;var b=0;c[a>>2]=4744;b=a+104|0;c[b>>2]=4764;se(a+4|0);el(b);return}function se(d){d=d|0;var e=0,f=0,g=0,h=0;c[d>>2]=4780;e=d+64|0;f=c[e>>2]|0;if(f|0?(ye(d)|0,(Ci(f)|0)==0):0)c[e>>2]=0;f=b[d+96>>1]|0;e=(f&65535)>>>8&255;if((f&255)<<24>>24!=0?(g=c[d+32>>2]|0,(g|0)!=0):0){Ru(g);e=a[d+97>>0]|0}if(e<<24>>24?(h=c[d+56>>2]|0,h|0):0)Ru(h);il(d);return}function te(a){a=a|0;se(a);mu(a);return}function ue(d,e){d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0;Fb[c[(c[d>>2]|0)+24>>2]&127](d)|0;f=Om(e,1151892)|0;c[d+68>>2]=f;g=d+98|0;j=a[g>>0]|0;f=Fb[c[(c[f>>2]|0)+28>>2]&127](f)|0;a[g>>0]=f&1;if((j&255|0)==(f&1|0))return;e=d+8|0;j=d+96|0;c[e>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;c[e+16>>2]=0;c[e+20>>2]=0;e=b[j>>1]|0;g=(e&255)<<24>>24!=0;e=(e&65535)>>>8&255;if(f){f=d+32|0;if(g?(k=c[f>>2]|0,(k|0)!=0):0){Ru(k);e=a[d+97>>0]|0}a[j>>0]=e;j=d+60|0;c[d+52>>2]=c[j>>2];k=d+56|0;c[f>>2]=c[k>>2];c[j>>2]=0;c[k>>2]=0;a[d+97>>0]=0;return}if(!g?(h=d+32|0,i=c[h>>2]|0,(i|0)!=(d+44|0)):0){k=c[d+52>>2]|0;c[d+60>>2]=k;c[d+56>>2]=i;a[d+97>>0]=0;c[h>>2]=Qu(k)|0;a[j>>0]=1;return}k=c[d+52>>2]|0;c[d+60>>2]=k;c[d+56>>2]=Qu(k)|0;a[d+97>>0]=1;return}function ve(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0;j=b+8|0;i=b+96|0;c[j>>2]=0;c[j+4>>2]=0;c[j+8>>2]=0;c[j+12>>2]=0;c[j+16>>2]=0;c[j+20>>2]=0;j=c[i>>2]|0;f=(j&65535)>>>8&255;if((j&255)<<24>>24!=0?(g=c[b+32>>2]|0,(g|0)!=0):0){Ru(g);f=a[b+97>>0]|0}g=b+97|0;if(f<<24>>24?(h=c[b+56>>2]|0,h|0):0)Ru(h);f=b+52|0;c[f>>2]=e;do if(e>>>0>8){f=a[b+98>>0]|0;if((d|0)!=0&f<<24>>24!=0){c[b+32>>2]=d;a[i>>0]=0;break}else{c[b+32>>2]=Qu(e)|0;a[i>>0]=1;break}}else{c[b+32>>2]=b+44;c[f>>2]=8;a[i>>0]=0;f=a[b+98>>0]|0}while(0);if(f<<24>>24){c[b+60>>2]=0;c[b+56>>2]=0;a[g>>0]=0;return b|0}f=(e|0)<8?8:e;c[b+60>>2]=f;if((d|0)!=0&f>>>0>7){c[b+56>>2]=d;a[g>>0]=0;return b|0}else{c[b+56>>2]=Qu(f)|0;a[g>>0]=1;return b|0}return 0}function we(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0;g=c[b+68>>2]|0;g=Fb[c[(c[g>>2]|0)+24>>2]&127](g)|0;h=b+64|0;if((c[h>>2]|0?!(((d|0)!=0|(e|0)!=0)&(g|0)<1):0)?(Fb[c[(c[b>>2]|0)+24>>2]&127](b)|0)==0:0){if(f>>>0>=3){b=a;c[b>>2]=0;c[b+4>>2]=0;b=a+8|0;c[b>>2]=-1;c[b+4>>2]=-1;return}i=c[h>>2]|0;e=hv(g|0,((g|0)<0)<<31>>31|0,d|0,e|0)|0;if(!(Ui(i,(g|0)>0?e:0,f)|0)){f=Ai(c[h>>2]|0)|0;e=b+72|0;b=c[e+4>>2]|0;i=a;c[i>>2]=c[e>>2];c[i+4>>2]=b;i=a+8|0;c[i>>2]=f;c[i+4>>2]=((f|0)<0)<<31>>31;return}else{i=a;c[i>>2]=0;c[i+4>>2]=0;i=a+8|0;c[i>>2]=-1;c[i+4>>2]=-1;return}}i=a;c[i>>2]=0;c[i+4>>2]=0;i=a+8|0;c[i>>2]=-1;c[i+4>>2]=-1;return}function xe(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;e=b+64|0;if(c[e>>2]|0?(Fb[c[(c[b>>2]|0)+24>>2]&127](b)|0)==0:0)if(!(Ui(c[e>>2]|0,c[d+8>>2]|0,0)|0)){f=d;e=c[f+4>>2]|0;b=b+72|0;c[b>>2]=c[f>>2];c[b+4>>2]=e;c[a>>2]=c[d>>2];c[a+4>>2]=c[d+4>>2];c[a+8>>2]=c[d+8>>2];c[a+12>>2]=c[d+12>>2];return}else{f=a;c[f>>2]=0;c[f+4>>2]=0;f=a+8|0;c[f>>2]=-1;c[f+4>>2]=-1;return}f=a;c[f>>2]=0;c[f+4>>2]=0;f=a+8|0;c[f>>2]=-1;c[f+4>>2]=-1;return}function ye(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;m=i;i=i+16|0;k=m;l=b+64|0;if(!(c[l>>2]|0)){l=0;i=m;return l|0}j=b+92|0;d=c[j>>2]|0;do if(!(d&16)){if(d&8|0){f=b+80|0;g=c[f+4>>2]|0;h=k;c[h>>2]=c[f>>2];c[h+4>>2]=g;do if(!(a[b+98>>0]|0)){f=b+68|0;e=c[f>>2]|0;e=Fb[c[(c[e>>2]|0)+24>>2]&127](e)|0;g=b+36|0;h=c[g>>2]|0;d=(c[b+40>>2]|0)-h|0;if((e|0)>0){d=(_((c[b+16>>2]|0)-(c[b+12>>2]|0)|0,e)|0)+d|0;e=0;break}e=c[b+12>>2]|0;if((e|0)==(c[b+16>>2]|0))e=0;else{n=c[f>>2]|0;f=b+32|0;e=Mb[c[(c[n>>2]|0)+32>>2]&31](n,k,c[f>>2]|0,h,e-(c[b+8>>2]|0)|0)|0;d=d-e+(c[g>>2]|0)-(c[f>>2]|0)|0;e=1}}else{d=(c[b+16>>2]|0)-(c[b+12>>2]|0)|0;e=0}while(0);if(Ui(c[l>>2]|0,0-d|0,1)|0){n=-1;i=m;return n|0}if(e){l=c[k+4>>2]|0;n=b+72|0;c[n>>2]=c[k>>2];c[n+4>>2]=l}n=c[b+32>>2]|0;c[b+40>>2]=n;c[b+36>>2]=n;c[b+8>>2]=0;c[b+12>>2]=0;c[b+16>>2]=0;c[j>>2]=0}}else{if((c[b+24>>2]|0)!=(c[b+20>>2]|0)?(Lb[c[(c[b>>2]|0)+52>>2]&63](b,-1)|0)==-1:0){n=-1;i=m;return n|0}f=b+68|0;g=b+72|0;h=b+32|0;d=b+52|0;a:while(1){b=c[f>>2]|0;e=c[h>>2]|0;e=Mb[c[(c[b>>2]|0)+20>>2]&31](b,g,e,e+(c[d>>2]|0)|0,k)|0;b=c[h>>2]|0;n=(c[k>>2]|0)-b|0;if((Fi(b,1,n,c[l>>2]|0)|0)!=(n|0)){d=-1;e=22;break}switch(e|0){case 1:break;case 2:{d=-1;e=22;break a}default:{e=8;break a}}}if((e|0)==8){if(!(Di(c[l>>2]|0)|0))break;else d=-1;i=m;return d|0}else if((e|0)==22){i=m;return d|0}}while(0);n=0;i=m;return n|0}function ze(b){b=b|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;t=i;i=i+16|0;s=t+4|0;p=t;o=b+64|0;if(!(c[o>>2]|0)){s=-1;i=t;return s|0}f=b+92|0;if(!(c[f>>2]&8)){c[b+24>>2]=0;c[b+20>>2]=0;c[b+28>>2]=0;if(!(a[b+98>>0]|0)){e=c[b+56>>2]|0;g=e+(c[b+60>>2]|0)|0}else{e=c[b+32>>2]|0;g=e+(c[b+52>>2]|0)|0}c[b+8>>2]=e;r=b+12|0;c[r>>2]=g;c[b+16>>2]=g;c[f>>2]=8;f=1;e=g}else{e=b+12|0;f=0;r=e;e=c[e>>2]|0}if(!e){e=s+1|0;c[b+8>>2]=s;c[r>>2]=e;c[b+16>>2]=e}q=b+16|0;if(f){f=c[q>>2]|0;n=0}else{f=c[q>>2]|0;n=(f-(c[b+8>>2]|0)|0)/2|0;n=n>>>0>4?4:n}do if((e|0)==(f|0)){f=b+8|0;$u(c[f>>2]|0,e+(0-n)|0,n|0)|0;if(a[b+98>>0]|0){e=c[f>>2]|0;e=Ii(e+n|0,1,(c[q>>2]|0)-n-e|0,c[o>>2]|0)|0;if(!e){e=-1;break}b=(c[f>>2]|0)+n|0;c[r>>2]=b;c[q>>2]=b+e;e=d[b>>0]|0;break}k=b+32|0;l=b+36|0;e=c[l>>2]|0;m=b+40|0;$u(c[k>>2]|0,e|0,(c[m>>2]|0)-e|0)|0;e=c[k>>2]|0;j=e+((c[m>>2]|0)-(c[l>>2]|0))|0;c[l>>2]=j;if((e|0)==(b+44|0))g=8;else g=c[b+52>>2]|0;u=e+g|0;c[m>>2]=u;g=b+60|0;e=(c[g>>2]|0)-n|0;u=u-j|0;h=b+72|0;x=h;w=c[x+4>>2]|0;v=b+80|0;c[v>>2]=c[x>>2];c[v+4>>2]=w;e=Ii(j,1,u>>>0<e>>>0?u:e,c[o>>2]|0)|0;if(!e)e=-1;else{w=(c[l>>2]|0)+e|0;c[m>>2]=w;v=c[b+68>>2]|0;x=c[f>>2]|0;if((Ib[c[(c[v>>2]|0)+16>>2]&15](v,h,c[k>>2]|0,w,l,x+n|0,x+(c[g>>2]|0)|0,p)|0)!=3){g=c[p>>2]|0;e=(c[f>>2]|0)+n|0;if((g|0)==(e|0))e=-1;else{c[r>>2]=e;c[q>>2]=g;e=d[e>>0]|0}}else{e=c[k>>2]|0;x=c[m>>2]|0;c[f>>2]=e;c[r>>2]=e;c[q>>2]=x;e=d[e>>0]|0}}}else{f=b+8|0;e=d[e>>0]|0}while(0);if((c[f>>2]|0)==(s|0)){c[f>>2]=0;c[r>>2]=0;c[q>>2]=0}x=e;i=t;return x|0}function Ae(b,d){b=b|0;d=d|0;var e=0,f=0,g=0;if(!(c[b+64>>2]|0)){d=-1;return d|0}g=b+12|0;f=c[g>>2]|0;if((c[b+8>>2]|0)>>>0>=f>>>0){d=-1;return d|0}if((d|0)==-1){c[g>>2]=f+-1;d=0;return d|0}if(!(c[b+88>>2]&16)){e=d&255;b=f+-1|0;if(e<<24>>24!=(a[b>>0]|0)){d=-1;return d|0}}else{e=d&255;b=f+-1|0}c[g>>2]=b;a[b>>0]=e;return d|0}function Be(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;x=i;i=i+16|0;l=x+8|0;v=x+4|0;u=x;w=b+64|0;if(!(c[w>>2]|0)){d=-1;i=x;return d|0}f=b+92|0;if(!(c[f>>2]&16)){c[b+8>>2]=0;c[b+12>>2]=0;c[b+16>>2]=0;e=c[b+52>>2]|0;do if(e>>>0>8)if(!(a[b+98>>0]|0)){h=c[b+56>>2]|0;j=h+((c[b+60>>2]|0)+-1)|0;c[b+24>>2]=h;g=b+20|0;c[g>>2]=h;e=b+28|0;c[e>>2]=j;k=h;break}else{h=c[b+32>>2]|0;j=h+(e+-1)|0;c[b+24>>2]=h;g=b+20|0;c[g>>2]=h;e=b+28|0;c[e>>2]=j;k=h;break}else{c[b+24>>2]=0;g=b+20|0;c[g>>2]=0;e=b+28|0;c[e>>2]=0;k=0;j=0;h=0}while(0);c[f>>2]=16;t=g;r=e;s=e;q=g;g=k}else{q=b+20|0;g=c[q>>2]|0;j=b+28|0;t=q;r=j;s=j;h=g;j=c[j>>2]|0}p=(d|0)==-1;e=b+24|0;f=c[e>>2]|0;if(!p){if(!f){c[e>>2]=l;c[q>>2]=l;c[r>>2]=l+1;f=l}a[f>>0]=d;f=(c[e>>2]|0)+1|0;c[e>