import { WebPlugin } from '@capacitor/core';
export class SoundEffectWeb extends WebPlugin {
    constructor() {
        super({
            name: 'SoundEffect',
            platforms: ['web']
        });
        this.audioMap = {};
    }
    async loadSound({ id, path }) {
        const audio = new Audio();
        audio.setAttribute('src', path);
        audio.load();
        this.audioMap[id] = audio;
    }
    async play({ id }) {
        const audio = this.audioMap[id];
        if (audio)
            audio.play();
    }
}
//# sourceMappingURL=web.js.map