import { WebPlugin } from '@capacitor/core';
export class KeepAwakeWeb extends WebPlugin {
    constructor() {
        super(...arguments);
        this.wakeLock = null;
        this.isSupported = 'wakeLock' in navigator;
    }
    async keepAwake() {
        if (!this.isSupported) {
            this.throwUnsupportedError();
        }
        if (this.wakeLock) {
            await this.allowSleep();
        }
        this.wakeLock = await navigator.wakeLock.request('screen');
    }
    async allowSleep() {
        var _a;
        if (!this.isSupported) {
            this.throwUnsupportedError();
        }
        (_a = this.wakeLock) === null || _a === void 0 ? void 0 : _a.release();
        this.wakeLock = null;
    }
    throwUnsupportedError() {
        throw this.unavailable('Screen Wake Lock API not available in this browser.');
    }
}
//# sourceMappingURL=web.js.map