package org.libre.agosto.p2play.viewModels

import android.content.SharedPreferences
import android.util.Log
import androidx.lifecycle.LiveData
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.ViewModel
import androidx.lifecycle.viewModelScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.launch
import kotlinx.coroutines.withContext
import org.libre.agosto.p2play.data.rest.InstanceDS
import org.libre.agosto.p2play.domain.entities.InstanceDetailModel
import org.libre.agosto.p2play.helpers.RetrofitBuilder
import retrofit2.HttpException
import androidx.core.content.edit

class InstancesViewModel(private val settings: SharedPreferences) : ViewModel() {
    private val client =
        RetrofitBuilder("https://instances.joinpeertube.org/api/v1/", InstanceDS::class.java)

    private val _instances = MutableLiveData<List<InstanceDetailModel>>()
    val instances: LiveData<List<InstanceDetailModel>> = _instances

    private val _search = MutableLiveData<String>()
    val search: LiveData<String> = _search

    fun loadInstances(withFilters: Boolean = true) {
        viewModelScope.launch {
            try {
                val result = withContext(Dispatchers.IO) {
                    if (withFilters) {
                        client.getService().findInstances(search.value)
                    } else {
                        client.getService()
                            .findInstances(search.value, signup = null, healthy = null)
                    }
                }
                _instances.value = result.data
            } catch (err: HttpException) {
                err.printStackTrace()
                Log.e("InstancesModel", "Err", err)
            }
            catch(err: Exception) {
                Log.e("InstancesModel", "Err", err)
            }
        }
    }

    fun onSearch(query: String) {
        _search.value = query
        _instances.value = listOf()
        this.loadInstances(false)
    }

    fun onSelectInstance(instance: String) {
        this.settings.edit { putString("hostP2play", instance) }
    }
}
