package org.libre.agosto.p2play.ui.views.channelView

import androidx.lifecycle.LiveData
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.ViewModel
import androidx.lifecycle.viewModelScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.launch
import kotlinx.coroutines.withContext
import org.libre.agosto.p2play.ManagerSingleton
import org.libre.agosto.p2play.R
import org.libre.agosto.p2play.ajax.Actions
import org.libre.agosto.p2play.ajax.Channels
import org.libre.agosto.p2play.ajax.Videos
import org.libre.agosto.p2play.domain.entities.ChannelModel
import org.libre.agosto.p2play.domain.entities.VideoModel

class ChannelViewModel: ViewModel() {
    private lateinit var channelId: String
    private val _channel = MutableLiveData<ChannelModel>()
    val channel: LiveData<ChannelModel> = _channel

    private val _videos = MutableLiveData<ArrayList<VideoModel>>()
    val videos: LiveData<ArrayList<VideoModel>> = _videos

    private val _isSubscribed = MutableLiveData<Boolean>()
    val isSubscribed: LiveData<Boolean> = _isSubscribed

    private val _toastMessage = MutableLiveData<Int?>()
    val toastMessage: LiveData<Int?> = _toastMessage

    private val clientChannel = Channels()
    private val clientVideos = Videos()
    private val clientActions = Actions()

    fun getChannel(channelId: String) {
        this.channelId = channelId

        viewModelScope.launch {
            _channel.value = withContext(Dispatchers.IO) {
                clientChannel.getChannelInfo(channelId)
            }

            getChannelVideo()
            getSubscription()
        }
    }

    fun onSubscribe() {
        viewModelScope.launch {
            val result = withContext(Dispatchers.IO) {
                if (_isSubscribed.value == true) {
                    clientActions.unSubscribe(ManagerSingleton.token.token, channelId)
                } else {
                    clientActions.subscribe(ManagerSingleton.token.token, channelId)
                }
            }
            if (result == 1) {
                if (_isSubscribed.value == true) {
                    showToast(R.string.unSubscribeMsg)
                } else {
                    showToast(R.string.subscribeMsg)
                }
            } else {
                showToast(R.string.errorMsg)
            }

            getSubscription()
        }
    }

    private suspend fun getChannelVideo () {
        _videos.value = withContext(Dispatchers.IO) {
            clientVideos.channelVideos(channelId, 0)
        }
    }

    private suspend fun getSubscription() {
        if (ManagerSingleton.isLogged()) {
            _isSubscribed.value = withContext(Dispatchers.IO) {
                clientActions.getSubscription(ManagerSingleton.token.token, channelId)
            }
        }
    }

    private fun showToast(stringResId: Int) {
        _toastMessage.postValue(stringResId)
    }
}
