package org.libre.agosto.p2play.ui.views.accountView

import androidx.lifecycle.LiveData
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.ViewModel
import androidx.lifecycle.viewModelScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.launch
import kotlinx.coroutines.withContext
import org.libre.agosto.p2play.ManagerSingleton
import org.libre.agosto.p2play.R
import org.libre.agosto.p2play.ajax.Accounts
import org.libre.agosto.p2play.ajax.Actions
import org.libre.agosto.p2play.ajax.Channels
import org.libre.agosto.p2play.ajax.Videos
import org.libre.agosto.p2play.domain.entities.AccountModel
import org.libre.agosto.p2play.domain.entities.ChannelModel
import org.libre.agosto.p2play.domain.entities.VideoModel

class AccountViewModel: ViewModel() {
    private lateinit var accountId: String
    private val _account = MutableLiveData<AccountModel>()
    val account: LiveData<AccountModel> = _account

    private val _videos = MutableLiveData<ArrayList<VideoModel>>()
    val videos: LiveData<ArrayList<VideoModel>> = _videos

    private val _channels = MutableLiveData<ArrayList<ChannelModel>>()
    val channels: LiveData<ArrayList<ChannelModel>> = _channels

    private val _toastMessage = MutableLiveData<Int?>()
    val toastMessage: LiveData<Int?> = _toastMessage

    private val clientAccount = Accounts()
    private val clientVideos = Videos()
    private val clientActions = Actions()

    fun getAccount(accountId: String) {
        this.accountId = accountId
        viewModelScope.launch {
            _account.value = withContext(Dispatchers.IO) {
                clientAccount.get(accountId)
            }

            getVideos()
            getChannels()
        }
    }

    fun onSubscribe(channel: ChannelModel) {
        viewModelScope.launch {
            val result = withContext(Dispatchers.IO) {
                if (channel.subscribed) {
                    clientActions.unSubscribe(ManagerSingleton.token.token, channel.getFullName())
                } else {
                    clientActions.subscribe(ManagerSingleton.token.token, channel.getFullName())
                }
            }
            if (result == 1) {
                if (channel.subscribed) {
                    showToast(R.string.unSubscribeMsg)
                } else {
                    showToast(R.string.subscribeMsg)
                }

                getSubscriptions()
            } else {
                showToast(R.string.errorMsg)
            }
        }
    }

    private suspend fun getVideos() {
        _videos.value = withContext(Dispatchers.IO) {
            clientVideos.accountVideos(accountId, 0)
        }
    }

    private suspend fun getChannels() {
        _channels.value = withContext(Dispatchers.IO) {
            clientAccount.getChannels(accountId)
        }

        getSubscriptions()
    }

    private suspend fun getSubscriptions() {
        if (ManagerSingleton.isLogged()) {
            val cs = arrayListOf<ChannelModel>()
            _channels.value?.forEach {
                val c = it
                c.subscribed = withContext(Dispatchers.IO) {
                    clientActions.getSubscription(ManagerSingleton.token.token, it.getFullName())
                }

                cs.add(c)
            }

            _channels.postValue(cs)
        }
    }

    private fun showToast(stringResId: Int) {
        _toastMessage.postValue(stringResId)
    }
}
