package org.libre.agosto.p2play.ui.views

import androidx.compose.foundation.Image
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.size
import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.automirrored.filled.ArrowForward
import androidx.compose.material3.ExperimentalMaterial3Api
import androidx.compose.material3.Icon
import androidx.compose.material3.IconButton
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Surface
import androidx.compose.material3.Text
import androidx.compose.material3.TopAppBar
import androidx.compose.material3.TopAppBarDefaults
import androidx.compose.runtime.Composable
import androidx.compose.runtime.LaunchedEffect
import androidx.compose.runtime.getValue
import androidx.compose.runtime.livedata.observeAsState
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.res.painterResource
import androidx.compose.ui.unit.dp
import org.libre.agosto.p2play.R
import org.libre.agosto.p2play.ui.components.molecules.SearchBar
import org.libre.agosto.p2play.ui.lists.InstanceList
import org.libre.agosto.p2play.viewModels.InstancesViewModel
import org.libre.agosto.p2play.viewModels.SessionsViewModel

@OptIn(ExperimentalMaterial3Api::class)
@Composable
fun ChooseInstanceView(
    sessionsViewModel: SessionsViewModel,
    instancesViewModel: InstancesViewModel,
    modifier: Modifier = Modifier
) {
    val instances by instancesViewModel.instances.observeAsState(listOf())
    // TODO: Observe session instance to finish return to main view
    val search by instancesViewModel.search.observeAsState("")

    fun onSelect(host: String) {
        instancesViewModel.onSelectInstance(host)
        sessionsViewModel.loadInstance()
    }

    LaunchedEffect(Unit) {
        instancesViewModel.loadInstances()
    }

    Column {
        Surface(Modifier.padding(bottom = 8.dp)) {
            Column(horizontalAlignment = Alignment.CenterHorizontally) {
                TopAppBar(
                    {
                        Text("Choose an instance")
                    },
                    colors = TopAppBarDefaults.topAppBarColors(
                        containerColor = MaterialTheme.colorScheme.surface
                    )
                )
                Image(painterResource(R.drawable.icon), null, modifier = Modifier.size(100.dp))
                SearchBar(
                    search,
                    {
                        onSelect(it)
                    },
                    {
                        instancesViewModel.onSearch(it)
                    },
                    "Write here your instance URL"
                ) {
                    IconButton({
                        onSelect(search)
                    }) {
                        Icon(Icons.AutoMirrored.Default.ArrowForward, contentDescription = null)
                    }
                }
            }
        }
        InstanceList(
            instances,
            {
                onSelect(it.host)
            },
            modifier
        ) {
        }
    }
}
