package org.libre.agosto.p2play.ui.lists

import androidx.compose.foundation.clickable
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.size
import androidx.compose.foundation.lazy.LazyRow
import androidx.compose.foundation.lazy.items
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.unit.dp
import org.libre.agosto.p2play.domain.entities.ChannelModel
import org.libre.agosto.p2play.ui.components.atoms.UserImg

@Composable
fun SubscriptionIconList(subscriptions: List<ChannelModel>, onChannelClick: (ChannelModel) -> Unit) {
    LazyRow(modifier = Modifier.padding(bottom = 10.dp)) {
        items(subscriptions, key = { it.id }) {
            UserImg(
                Modifier
                    .padding(horizontal = 5.dp)
                    .size(45.dp)
                    .clickable {
                        onChannelClick(it)
                    },
                it.channelImg
            )
        }
    }
}
