package org.libre.agosto.p2play.ui.lists

import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.lazy.grid.GridCells
import androidx.compose.foundation.lazy.grid.GridItemSpan
import androidx.compose.foundation.lazy.grid.LazyGridItemSpanScope
import androidx.compose.foundation.lazy.grid.LazyVerticalGrid
import androidx.compose.foundation.lazy.grid.items
import androidx.compose.foundation.lazy.grid.rememberLazyGridState
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.unit.dp
import org.libre.agosto.p2play.domain.entities.InstanceDetailModel
import org.libre.agosto.p2play.ui.components.organisms.InstanceItem

@Composable
fun InstanceList(
    instances: List<InstanceDetailModel>,
    onClickInstance: (InstanceDetailModel) -> Unit,
    modifier: Modifier = Modifier,
    header: @Composable (() -> Unit)? = null
) {
    val lazyState = rememberLazyGridState()
    val maxSpan: (LazyGridItemSpanScope) -> GridItemSpan = {
        GridItemSpan(it.maxCurrentLineSpan)
    }

    LazyVerticalGrid(
        GridCells.Adaptive(150.dp),
        state = lazyState,
        verticalArrangement = Arrangement.spacedBy(12.dp),
        horizontalArrangement = Arrangement.spacedBy(12.dp),
        modifier = modifier
    ) {
        if (header !== null) {
            item(key = "header", span = maxSpan) { header() }
        }
        items(instances, key = { it.host }) {
            InstanceItem(it, onClickInstance)
        }
    }
}
