package org.libre.agosto.p2play.ui.components.organisms

import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.height
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.unit.dp
import org.libre.agosto.p2play.domain.entities.VideoModel
import org.libre.agosto.p2play.ui.components.molecules.VideoAccount
import org.libre.agosto.p2play.ui.components.molecules.VideoActions
import org.libre.agosto.p2play.ui.components.molecules.VideoTitle

@Composable
fun VideoInfo (
    video: VideoModel,
    subscribed: Boolean,
    liked: Boolean,
    disliked: Boolean,
    onRate: (String) -> Unit,
    onSubscribe: () -> Unit,
    onReport: (String) -> Unit,
    onAccountClick: () -> Unit
) {
    Column(Modifier.fillMaxWidth()) {
        VideoTitle(
            video.name,
            video.views.toString(),
            video.publishedAt
        )
        Spacer(Modifier.height(6.dp))
        VideoActions(video, liked, disliked, onRate, onReport)
        Spacer(Modifier.height(6.dp))
        VideoAccount(
            video.username,
            video.getChannel(),
            video.userImageUrl,
            subscribed,
            onAccountClick,
            onSubscribe
        )
    }
}
