package org.libre.agosto.p2play.ui.components.organisms

import androidx.compose.animation.core.tween
import androidx.compose.animation.slideInHorizontally
import androidx.compose.animation.slideOutHorizontally
import androidx.compose.material3.ExperimentalMaterial3Api
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.ModalBottomSheet
import androidx.compose.material3.Surface
import androidx.compose.material3.rememberModalBottomSheetState
import androidx.compose.runtime.Composable
import androidx.compose.runtime.getValue
import androidx.compose.runtime.livedata.observeAsState
import androidx.compose.runtime.mutableIntStateOf
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.saveable.rememberSaveable
import androidx.compose.runtime.setValue
import androidx.lifecycle.viewmodel.compose.viewModel
import androidx.navigation.compose.NavHost
import androidx.navigation.compose.composable
import androidx.navigation.compose.rememberNavController
import org.libre.agosto.p2play.domain.entities.CommentaryModel
import org.libre.agosto.p2play.ui.components.molecules.CommentThread
import org.libre.agosto.p2play.ui.components.molecules.CommentariesList
import org.libre.agosto.p2play.ui.components.molecules.CommentsPreview
import org.libre.agosto.p2play.viewModels.CommentsViewModel

@OptIn(ExperimentalMaterial3Api::class)
@Composable
fun VideoComments (
    videoId: Int,
    enabled: Boolean = true,
    commentsViewModel: CommentsViewModel = viewModel(factory = CommentsViewModel.Factory(videoId))
) {
    val commentaries by commentsViewModel.commentaries.observeAsState(initial = emptyList())
    val replies by commentsViewModel.replies.observeAsState(initial = emptyList())
    var commentThread by rememberSaveable { mutableStateOf<CommentaryModel?>(null) }
    var showCommentaries by remember { mutableStateOf(false) }
    val sheetState = rememberModalBottomSheetState(
        skipPartiallyExpanded = true
    )
    val navHost = rememberNavController()

    CommentsPreview(commentaries, enabled) { showCommentaries = true }

    if (showCommentaries) {
        ModalBottomSheet(
            { showCommentaries = false },
            sheetState = sheetState
        ) {
            NavHost(navHost, "comment-list") {
                composable(
                    "comment-list"
                    // enterTransition = { slideInHorizontally() },
                    // exitTransition = { slideOutHorizontally() }
                ) {
                    CommentariesList(commentaries, enabled, {
                        commentThread = it
                        commentsViewModel.getThread(it.id)
                        navHost.navigate("comment-thread")
                    }) {
                        commentsViewModel.comment(it)
                    }
                }
                composable(
                    "comment-thread",
                    enterTransition = { slideInHorizontally() { it } },
                    exitTransition = { slideOutHorizontally(tween(500)) { it } }
                ) {
                    Surface(color = MaterialTheme.colorScheme.surfaceContainerLow) {
                        commentThread?.let {
                            CommentThread(
                                it,
                                replies,
                                enabled,
                                {
                                    navHost.popBackStack()
                                }
                            ) {
                                commentsViewModel.replyThread(it)
                            }
                        }
                    }
                }
            }
        }
    }
}
