package org.libre.agosto.p2play.ui.components.organisms

import androidx.compose.foundation.background
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.aspectRatio
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.material3.Card
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.layout.ContentScale
import androidx.compose.ui.text.style.TextOverflow
import androidx.compose.ui.unit.dp
import androidx.compose.ui.unit.sp
import androidx.constraintlayout.compose.ConstraintLayout
import coil3.compose.AsyncImage
import org.libre.agosto.p2play.activities.ui.theme.AppTypography
import org.libre.agosto.p2play.domain.entities.InstanceDetailModel

@Composable
fun InstanceItem(instance: InstanceDetailModel, onInstanceClick: (InstanceDetailModel) -> Unit) {
    Card(
        {
            onInstanceClick(instance)
        }
    ) {
        ConstraintLayout {
            val (thumbnailImg, nameTxt, descriptionTxt) = createRefs()

            val instanceBanner = if (instance.banners.isNotEmpty()) instance.banners[0] else null
            // val instanceBanner: InstanceBannersModel? = null
            Box(
                modifier = Modifier.background(
                    MaterialTheme.colorScheme.primaryContainer
                ).fillMaxWidth().aspectRatio(
                    16f / 3f
                ).constrainAs(thumbnailImg) {
                    top.linkTo(parent.top)
                    start.linkTo(parent.start)
                    end.linkTo(parent.end)
                }
            ) {
                if (instanceBanner !== null) {
                    AsyncImage(
                        instanceBanner.url,
                        instance.name,
                        contentScale = ContentScale.FillHeight,

                        modifier = Modifier.matchParentSize()
                    )
                }
            }

            val mod = Modifier.padding(start = 4.dp, end = 4.dp)
            Text(
                instance.name,
                style = AppTypography.titleMedium,
                maxLines = 2,
                overflow = TextOverflow.Ellipsis,
                lineHeight = 18.sp,
                modifier = mod.constrainAs(nameTxt) {
                    top.linkTo(thumbnailImg.bottom)
                    bottom.linkTo(descriptionTxt.top)
                    start.linkTo(parent.start)
                }
            )
            Text(
                instance.shortDescription,
                style = AppTypography.labelSmall,
                maxLines = 2,
                overflow = TextOverflow.Ellipsis,
                modifier = mod.padding(bottom = 4.dp).constrainAs(descriptionTxt) {
                    top.linkTo(nameTxt.bottom)
                    bottom.linkTo(parent.bottom)
                    start.linkTo(parent.start)
                }
            )
        }
    }
}
