package org.libre.agosto.p2play.ui.components.molecules

import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.res.stringResource
import org.libre.agosto.p2play.R
import org.libre.agosto.p2play.helpers.getRelativeTime
import org.libre.agosto.p2play.ui.components.atoms.BoldText
import org.libre.agosto.p2play.ui.components.atoms.SupportText

@Composable
fun VideoTitle(title: String, views: String, date: String) {
    Column(Modifier.fillMaxWidth()) {
        BoldText(title)
        Row {
            SupportText(views)
            SupportText(" ")
            SupportText(stringResource(R.string.view_text))
            SupportText(" - ")
            SupportText(getRelativeTime(date))
        }
    }
}
