package org.libre.agosto.p2play.ui.components.molecules

import androidx.compose.foundation.layout.Column
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Text
import androidx.compose.material3.TextButton
import androidx.compose.runtime.Composable
import androidx.compose.runtime.LaunchedEffect
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.setValue
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.text.AnnotatedString
import androidx.compose.ui.text.fromHtml
import dev.jeziellago.compose.markdowntext.MarkdownText
import org.libre.agosto.p2play.R
import org.libre.agosto.p2play.ui.components.atoms.BoldText
import org.libre.agosto.p2play.ui.components.atoms.SupportText

@Composable
fun VideoDescription (shortDescription: String, description: String, onClick: () -> Unit = {}) {
    var haveDescription by remember { mutableStateOf(true) }

    LaunchedEffect(Unit) {
        haveDescription = description.length > 100
    }

    Column() {
        BoldText(stringResource(R.string.descriptionTxt))

        if (haveDescription) {
            MarkdownText(
                shortDescription,
                style = MaterialTheme.typography.bodySmall
            )
        } else {
            MarkdownText(
                description,
                style = MaterialTheme.typography.bodySmall
            )
        }

        if (haveDescription) {
            TextButton({
                onClick()
                haveDescription = false
            }) {
                Text(stringResource(R.string.showMore))
            }
        }
    }
}
