package org.libre.agosto.p2play.ui.components.molecules

import androidx.compose.foundation.clickable
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.PaddingValues
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.size
import androidx.compose.foundation.shape.CircleShape
import androidx.compose.material3.Button
import androidx.compose.material3.ButtonDefaults
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.draw.clip
import androidx.compose.ui.layout.ContentScale
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.unit.dp
import coil3.compose.AsyncImage
import org.libre.agosto.p2play.ManagerSingleton
import org.libre.agosto.p2play.R
import org.libre.agosto.p2play.ui.components.atoms.BoldText
import org.libre.agosto.p2play.ui.components.atoms.SupportText

@Composable
fun VideoAccount (
    name: String,
    username: String,
    img: String,
    isSubscribed: Boolean = false,
    onClick: (() -> Unit)? = null,
    onSubscribe: () -> Unit
) {
    val isLogged = ManagerSingleton.isLogged()
    val userImgSource = if (img !== "") {
        "https://${ManagerSingleton.url}$img"
    } else {
        R.drawable.default_avatar
    }

    val subText = if (isSubscribed) {
        stringResource(R.string.unSubscribeBtn)
    } else {
        stringResource(R.string.subscribeBtn)
    }

    Row(
        Modifier.fillMaxWidth(),
        verticalAlignment = Alignment.CenterVertically
    ) {
        AsyncImage(
            userImgSource,
            contentDescription = null,
            modifier = Modifier
                .size(40.dp)
                .clip(CircleShape)
                .clickable { onClick?.let { it() } },
            contentScale = ContentScale.Crop
        )
        Column(Modifier.weight(1f).padding(horizontal = 8.dp)) {
            BoldText(name)
            SupportText(username)
        }
        if (isLogged) {
            Button(
                onClick = { onSubscribe() },
                contentPadding = PaddingValues(horizontal = 12.dp, vertical = 4.dp),
                modifier = Modifier.height(32.dp),
                colors = ButtonDefaults.buttonColors(
                    containerColor = MaterialTheme.colorScheme.tertiaryContainer,
                    contentColor = MaterialTheme.colorScheme.onTertiaryContainer
                )
            ) {
                Text(
                    subText,
                    style = MaterialTheme.typography.labelSmall
                )
            }
        }
    }
}
