package org.libre.agosto.p2play.ui.components.molecules

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.filled.Close
import androidx.compose.material3.ExperimentalMaterial3Api
import androidx.compose.material3.Icon
import androidx.compose.material3.IconButton
import androidx.compose.material3.SearchBarDefaults
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.runtime.LaunchedEffect
import androidx.compose.runtime.getValue
import androidx.compose.runtime.remember
import androidx.compose.runtime.setValue
import androidx.compose.ui.Modifier
import androidx.compose.ui.focus.FocusRequester
import androidx.compose.ui.focus.focusRequester

@OptIn(ExperimentalMaterial3Api::class)
@Composable
fun SearchBar(
    queryText: String,
    onSearch: (String) -> Unit,
    onChange: (String) -> Unit,
    hintText: String? = null,
    trailingIcon: @Composable () -> Unit
) {
    val focusRequester = remember { FocusRequester() }

    LaunchedEffect(Unit) {
        focusRequester.requestFocus()
    }

    androidx.compose.material3.SearchBar(
        // modifier = Modifier.align(Alignment.TopCenter).semantics { traversalIndex = 0f },
        inputField = {
            SearchBarDefaults.InputField(
                onSearch = {
                    onSearch(it)
                },
                onQueryChange = { onChange(it) },
                query = queryText,
                expanded = false,
                onExpandedChange = {},
                leadingIcon = {
                    if (queryText.isNotEmpty()) {
                        IconButton(onClick = { onChange("") }) {
                            Icon(Icons.Default.Close, contentDescription = null)
                        }
                    }
                },
                trailingIcon = {
                    trailingIcon()
                },
                placeholder = {
                    if (hintText !== null) {
                        Text(hintText)
                    }
                },
                modifier = Modifier.focusRequester(focusRequester)
            )
        },
        expanded = false,
        onExpandedChange = { }
    ) {
        Text("hola")
    }
}
