package org.libre.agosto.p2play.ui.components.molecules

import androidx.compose.foundation.clickable
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.material3.Card
import androidx.compose.material3.Text
import androidx.compose.material3.TextButton
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.unit.dp
import org.libre.agosto.p2play.R
import org.libre.agosto.p2play.domain.entities.CommentaryModel
import org.libre.agosto.p2play.ui.components.atoms.BoldText
import org.libre.agosto.p2play.ui.components.atoms.CommentSmall
import org.libre.agosto.p2play.ui.components.atoms.DisabledComments
import org.libre.agosto.p2play.ui.components.atoms.EmptyContent
import org.libre.agosto.p2play.ui.components.atoms.SupportText

@Composable
fun CommentsPreview (commentaries: List<CommentaryModel>, enabled: Boolean = true, onClick: () -> Unit = {}) {
    val comment1 = commentaries.getOrNull(0)
    val comment2 = commentaries.getOrNull(1)
    Card(Modifier.fillMaxWidth().clickable {
        onClick()
    }) {
        Column(Modifier.fillMaxWidth().padding(5.dp)) {
            BoldText(stringResource(R.string.commentariesTxt))

            if (!enabled) {
                DisabledComments()
            } else if (commentaries.isEmpty()) {
                EmptyContent()
            }

            comment1?.let {
                CommentSmall(it.userImageUrl, it.commentary)
            }

            comment2?.let {
                CommentSmall(it.userImageUrl, it.commentary)
            }

            TextButton({ onClick() }, Modifier.fillMaxWidth()) {
                Text(stringResource(R.string.commentaryText))
            }
        }
    }
}
