package org.libre.agosto.p2play.ui.components.molecules

import androidx.activity.compose.LocalActivity
import androidx.compose.foundation.Image
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.fillMaxHeight
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.size
import androidx.compose.foundation.layout.width
import androidx.compose.foundation.lazy.LazyColumn
import androidx.compose.foundation.lazy.items
import androidx.compose.foundation.lazy.rememberLazyListState
import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.automirrored.filled.Send
import androidx.compose.material.icons.filled.Person
import androidx.compose.material.icons.filled.Send
import androidx.compose.material3.Icon
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.OutlinedTextField
import androidx.compose.material3.Text
import androidx.compose.material3.TextButton
import androidx.compose.runtime.Composable
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.rememberCoroutineScope
import androidx.compose.runtime.saveable.rememberSaveable
import androidx.compose.runtime.setValue
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.unit.dp
import kotlinx.coroutines.launch
import org.libre.agosto.p2play.ManagerSingleton
import org.libre.agosto.p2play.R
import org.libre.agosto.p2play.domain.entities.CommentaryModel
import org.libre.agosto.p2play.ui.components.atoms.CommentBox
import org.libre.agosto.p2play.ui.components.atoms.DisabledComments
import org.libre.agosto.p2play.ui.components.atoms.EmptyContent
import org.libre.agosto.p2play.ui.components.atoms.SupportText
import org.libre.agosto.p2play.ui.components.atoms.UserImg
import org.libre.agosto.p2play.ui.components.organisms.VideoInfo

@Composable
fun CommentariesList (
    commentaries: List<CommentaryModel>,
    enabled: Boolean,
    onClickThread: (CommentaryModel) -> Unit,
    onComment: suspend (String) -> Boolean
) {
    val lazyState = rememberLazyListState()

    Column(
        modifier = Modifier
            .fillMaxWidth()
            .fillMaxHeight(0.85f) // Limita el modal a 2/3 de la pantalla
    ) {
        Text(
            stringResource(R.string.commentariesTxt),
            modifier = Modifier.padding(horizontal = 16.dp),
            style = MaterialTheme.typography.titleMedium
        )
        Spacer(Modifier.height(4.dp))
        LazyColumn(
            Modifier.weight(1f),
            state = lazyState
        ) {
            if (!enabled) {
                item(key = "disabled") {
                    DisabledComments()
                }
            } else if (commentaries.isEmpty()) {
                item("empty-comments") {
                    EmptyContent()
                }
            }

            items(commentaries, key = { it.id }) { c ->
                Comment(c) { onClickThread(c) }
            }
        }
        if (enabled && ManagerSingleton.isLogged()) {
            CommentBox(onComment)
        }
    }
}
