package org.libre.agosto.p2play.ui.components.molecules

import androidx.compose.foundation.Image
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.fillMaxHeight
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.size
import androidx.compose.foundation.layout.width
import androidx.compose.foundation.lazy.LazyColumn
import androidx.compose.foundation.lazy.items
import androidx.compose.foundation.lazy.rememberLazyListState
import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.automirrored.filled.ArrowBack
import androidx.compose.material.icons.automirrored.filled.Send
import androidx.compose.material.icons.filled.ArrowBack
import androidx.compose.material.icons.filled.Person
import androidx.compose.material3.Icon
import androidx.compose.material3.OutlinedTextField
import androidx.compose.material3.TextButton
import androidx.compose.runtime.Composable
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.rememberCoroutineScope
import androidx.compose.runtime.saveable.rememberSaveable
import androidx.compose.runtime.setValue
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.unit.dp
import kotlinx.coroutines.launch
import org.libre.agosto.p2play.ManagerSingleton
import org.libre.agosto.p2play.domain.entities.CommentaryModel
import org.libre.agosto.p2play.ui.components.atoms.CommentBox
import org.libre.agosto.p2play.ui.components.atoms.DisabledComments
import org.libre.agosto.p2play.ui.components.atoms.UserImg

@Composable
fun CommentThread(
    comment: CommentaryModel,
    replies: List<CommentaryModel>,
    enabled: Boolean,
    onBack: () -> Unit,
    onComment: suspend (String) -> Boolean
) {
    val lazyState = rememberLazyListState()
    val replyMod = Modifier.padding(start = 25.dp)
    var txtComment by remember { mutableStateOf("@${comment.getAccount()}") }

    Column(
        modifier = Modifier
            .fillMaxWidth()
            .fillMaxHeight(0.85f)
    ) {
        Row(Modifier.fillMaxWidth()) {
            TextButton({ onBack() }) {
                Icon(Icons.AutoMirrored.Filled.ArrowBack, "")
            }
        }
        Spacer(Modifier.height(4.dp))
        LazyColumn(
            Modifier.weight(1f),
            state = lazyState
        ) {
            item("comment") {
                Comment(comment, { txtComment = "@${comment.getAccount()}" })
            }

            items(replies, { it.id }) {
                Box(replyMod) {
                    Comment(it, { txtComment = "@${it.getAccount()}" })
                }
            }

            if (!enabled) {
                item("disabled") {
                    DisabledComments()
                }
            }
        }

        if (enabled && ManagerSingleton.isLogged()) {
            CommentBox(onComment, initialValue = txtComment, requestFocus = true)
        }
    }
}
