package org.libre.agosto.p2play.ui.components.molecules

import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.size
import androidx.compose.foundation.shape.CircleShape
import androidx.compose.material3.Text
import androidx.compose.material3.TextButton
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.draw.clip
import androidx.compose.ui.layout.ContentScale
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.unit.dp
import coil3.compose.AsyncImage
import dev.jeziellago.compose.markdowntext.MarkdownText
import org.libre.agosto.p2play.ManagerSingleton
import org.libre.agosto.p2play.R
import org.libre.agosto.p2play.domain.entities.CommentaryModel
import org.libre.agosto.p2play.ui.components.atoms.BoldText
import org.libre.agosto.p2play.ui.components.atoms.SupportText

@Composable
fun Comment (comment: CommentaryModel, onReply: () -> Unit) {
    Row() {
        val userImgSource = if (comment.userImageUrl !== "") {
            "https://${ManagerSingleton.url}${comment.userImageUrl}"
        } else {
            R.drawable.default_avatar
        }
        Row() {
            AsyncImage(
                userImgSource,
                contentDescription = null,
                modifier = Modifier
                    .padding(5.dp)
                    .size(30.dp)
                    .clip(CircleShape),
                contentScale = ContentScale.Companion.Crop
            )
            Column() {
                BoldText(comment.nameChannel)
                SupportText(comment.username)
                MarkdownText(comment.commentary)
                TextButton({ onReply() }) {
                    if (comment.replies > 0) {
                        Text(stringResource(R.string.see_replies, comment.replies))
                    } else if (ManagerSingleton.isLogged()) {
                        Text(stringResource(R.string.reply))
                    }
                }
            }
        }
    }
}
