package org.libre.agosto.p2play.ui.components.atoms

import androidx.compose.foundation.Image
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.size
import androidx.compose.foundation.shape.CircleShape
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.draw.clip
import androidx.compose.ui.layout.ContentScale
import androidx.compose.ui.unit.dp
import coil3.compose.AsyncImage
import org.libre.agosto.p2play.ManagerSingleton
import org.libre.agosto.p2play.R

@Composable
fun UserImg(modifier: Modifier = Modifier, source: String? = null) {
    val img = source ?: ManagerSingleton.user.avatar
    val userImgSource = if (img !== "") {
        "https://${ManagerSingleton.url}$img"
    } else {
        R.drawable.default_avatar
    }

    AsyncImage(
        userImgSource,
        contentDescription = null,
        modifier = modifier
            // .padding(5.dp)
            .clip(CircleShape),
        contentScale = ContentScale.Crop
    )
}
