package org.libre.agosto.p2play.ui.components.atoms

import androidx.annotation.OptIn
import androidx.compose.runtime.Composable
import androidx.compose.runtime.getValue
import androidx.compose.runtime.rememberUpdatedState
import androidx.compose.ui.Modifier
import androidx.compose.ui.platform.LocalContext
import androidx.compose.ui.viewinterop.AndroidView
import androidx.media3.common.util.UnstableApi
import androidx.media3.exoplayer.ExoPlayer
import androidx.media3.ui.AspectRatioFrameLayout
import androidx.media3.ui.PlayerView
import androidx.media3.ui.PlayerView.SHOW_BUFFERING_ALWAYS

@OptIn(UnstableApi::class)
@Composable
fun Player(playerProvider: () -> ExoPlayer?, modifier: Modifier = Modifier, onFullscreen: () -> Unit) {
    val context = LocalContext.current
    val currentPlayer by rememberUpdatedState(newValue = playerProvider())

    AndroidView(factory = {
        PlayerView(context).apply {
            player = currentPlayer
            useController = true
            resizeMode = AspectRatioFrameLayout.RESIZE_MODE_FIT
            setFullscreenButtonClickListener {
                onFullscreen()
            }
            keepScreenOn = true
            setShowNextButton(false)
            setShowPreviousButton(false)
            setShowBuffering(SHOW_BUFFERING_ALWAYS)
        }
    }, modifier, {
        it.player = currentPlayer
    })
}
