package org.libre.agosto.p2play.ui.components.atoms

import androidx.annotation.OptIn
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.runtime.Composable
import androidx.compose.runtime.getValue
import androidx.compose.runtime.rememberUpdatedState
import androidx.compose.ui.Modifier
import androidx.compose.ui.platform.LocalContext
import androidx.compose.ui.viewinterop.AndroidView
import androidx.media3.common.util.UnstableApi
import androidx.media3.exoplayer.ExoPlayer
import androidx.media3.ui.AspectRatioFrameLayout
import androidx.media3.ui.PlayerView

@OptIn(UnstableApi::class)
@Composable
fun MiniPlayer(playerProvider: () -> ExoPlayer?, modifier: Modifier = Modifier) {
    val context = LocalContext.current
    val currentPlayer by rememberUpdatedState(newValue = playerProvider())

    AndroidView(factory = {
        PlayerView(context).apply {
            // setControllerLayoutId(R.layout.custom_player_controls)
            resizeMode = AspectRatioFrameLayout.RESIZE_MODE_FIT
            player = currentPlayer
            useController = false
        }
    }, modifier, {
        it.player = currentPlayer
    })
}
