package org.libre.agosto.p2play.ui.components.atoms

import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.padding
import androidx.compose.material3.Card
import androidx.compose.material3.OutlinedTextField
import androidx.compose.material3.Text
import androidx.compose.material3.TextButton
import androidx.compose.runtime.Composable
import androidx.compose.runtime.LaunchedEffect
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.saveable.rememberSaveable
import androidx.compose.runtime.setValue
import androidx.compose.ui.Modifier
import androidx.compose.ui.focus.FocusRequester
import androidx.compose.ui.focus.focusRequester
import androidx.compose.ui.unit.dp
import androidx.compose.ui.window.Dialog

@Composable
fun InputDialog (
    message: String,
    placeholder: String? = null,
    onDismiss: (() -> Unit)? = null,
    onConfirm: (String) -> Unit
) {
    var inputValue by rememberSaveable { mutableStateOf("") }
    val focusRequester = remember { FocusRequester() }


    Dialog(
        {
            onDismiss?.let { it() }
        }
    ) {
        Card {
            Column(Modifier.padding(start = 10.dp, end = 10.dp, top = 12.dp)) {
                Text(message)
                Spacer(Modifier.height(4.dp))
                OutlinedTextField(
                    inputValue,
                    { inputValue = it },
                    Modifier.fillMaxWidth().focusRequester(focusRequester),
                    placeholder = {
                        placeholder?.let { Text(it) }
                    }
                )

                Row(
                    modifier = Modifier
                        .fillMaxWidth(),
                    horizontalArrangement = Arrangement.End,
                ) {
                    TextButton(
                        onClick = { onDismiss?.let { it() } },
                        modifier = Modifier.padding(8.dp),
                    ) {
                        Text("Cancel")
                    }
                    TextButton(
                        onClick = { onConfirm(inputValue) },
                        modifier = Modifier.padding(8.dp),
                    ) {
                        Text("Confirm")
                    }
                }
            }
        }
    }

    LaunchedEffect(Unit) {
        focusRequester.requestFocus()
    }
}
