package org.libre.agosto.p2play.ui.components.atoms

import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.size
import androidx.compose.foundation.shape.CircleShape
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.draw.clip
import androidx.compose.ui.layout.ContentScale
import androidx.compose.ui.unit.dp
import coil3.compose.AsyncImage
import org.libre.agosto.p2play.ManagerSingleton
import org.libre.agosto.p2play.R

@Composable
fun CommentSmall (img: String, comment: String) {
    Row(Modifier.padding(vertical = 6.dp, horizontal = 2.dp)) {
        UserImg(Modifier.padding(5.dp).size(25.dp), img)
        val displayText = if (comment.length > 80) {
            comment.take(80) + "..."
        } else {
            comment
        }
        Text(displayText)
    }
}
