package org.libre.agosto.p2play.ui.components.atoms

import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.size
import androidx.compose.foundation.layout.width
import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.automirrored.filled.Send
import androidx.compose.material3.CircularProgressIndicator
import androidx.compose.material3.Icon
import androidx.compose.material3.OutlinedTextField
import androidx.compose.material3.Text
import androidx.compose.material3.TextButton
import androidx.compose.runtime.Composable
import androidx.compose.runtime.LaunchedEffect
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.rememberCoroutineScope
import androidx.compose.runtime.saveable.rememberSaveable
import androidx.compose.runtime.setValue
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.focus.FocusRequester
import androidx.compose.ui.focus.focusRequester
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.unit.dp
import kotlinx.coroutines.launch
import org.libre.agosto.p2play.R

@Composable
fun CommentBox(
    onComment: suspend (String) -> Boolean,
    placeholder: String = stringResource(R.string.commentaryText),
    initialValue: String = "",
    requestFocus: Boolean = false
) {
    var comment by rememberSaveable { mutableStateOf(initialValue) }
    val scope = rememberCoroutineScope()
    var isLoading by remember { mutableStateOf(false) }
    val focusRequester = remember { FocusRequester() }

    Row(Modifier
        .fillMaxWidth()
        .padding(top = 10.dp), verticalAlignment = Alignment.CenterVertically) {
        UserImg(Modifier.size(45.dp))
        Spacer(Modifier.width(10.dp))
        OutlinedTextField(
            comment,
            { comment = it },
            Modifier.focusRequester(focusRequester).weight(1f),
            placeholder = {
                Text(placeholder)
            }
        )
        TextButton({
            isLoading = true
            scope.launch {
                val res = onComment(comment)
                if (res) {
                    comment = ""
                    isLoading = false
                }
            }
        }, enabled = !isLoading) {
            if (isLoading) {
                CircularProgressIndicator()
            } else {
                Icon(Icons.AutoMirrored.Filled.Send, "")
            }
        }
    }

    LaunchedEffect(Unit) {
        if (requestFocus) {
            focusRequester.requestFocus()
        }
    }
}
