package org.libre.agosto.p2play.ui

import androidx.navigation.NamedNavArgument
import androidx.navigation.NavType
import androidx.navigation.navArgument
import org.libre.agosto.p2play.R

sealed class Routes(
    val route: String,
    val title: Int?,
    val arguments: List<NamedNavArgument> = emptyList(),
    val hasTopAppBar: Boolean = false
) {
    data object Videos : Routes("videos", R.string.app_name)
    data object Subscriptions : Routes("subscriptions", R.string.title_subscriptions)
    data object Search : Routes("search", null)
    data object You : Routes("you", R.string.you)
    data object VideoList : Routes("video-list?key={key}", null, hasTopAppBar = true) {
        fun nav(key: String): String = "video-list?key=$key"
    }
    data object Notifications : Routes("notifications", null)
    data object ChooseInstance : Routes("choose-instance", null, hasTopAppBar = true)

    data object VideoPlayer : Routes(
        "video/{id}?res={resume}",
        null,
        listOf(
            navArgument("id") {
                type = NavType.StringType
            },
            navArgument("resume") {
                type = NavType.BoolType
                defaultValue = false
            }
        ),
        hasTopAppBar = false
    ) {
        fun nav(videoId: String, isResume: Boolean? = null):String = "video/$videoId?res=$isResume"
    }

    data object Channel : Routes("channel/{channelId}", null) {
        fun nav (channelId: String): String = "channel/$channelId"
    }

    data object Account : Routes("account/{accountId}", null) {
        fun nav (accountId: String): String = "account/$accountId"
    }

    companion object {
        private val entries: List<Routes> = listOf(
            Videos,
            Subscriptions,
            Search,
            You,
            VideoList,
            Notifications,
            ChooseInstance,
            VideoPlayer
        )
        private val routeMap = entries.associateBy { it.route }

        fun fromRoute(route: String?): Routes? {
            if (route == null) {
                return null
            }

            return routeMap[route]
        }
    }
}
