package org.libre.agosto.p2play.helpers

import android.icu.text.RelativeDateTimeFormatter
import java.time.Instant
import java.util.Locale

fun getRelativeTime(isoString: String): String {
    if (isoString.isEmpty()) return ""
    val formatter = RelativeDateTimeFormatter.getInstance(Locale.getDefault())

    val past = Instant.parse(isoString).toEpochMilli()
    val now = System.currentTimeMillis()
    val diff = now - past

    val minutes = diff / 60000
    val hours = minutes / 60
    val days = hours / 24
    val months = days / 30
    val years = months / 12

    return when {
        minutes < 60 -> formatter.format(minutes.toDouble(), RelativeDateTimeFormatter.Direction.LAST, RelativeDateTimeFormatter.RelativeUnit.MINUTES)
        hours < 24 -> formatter.format(hours.toDouble(), RelativeDateTimeFormatter.Direction.LAST, RelativeDateTimeFormatter.RelativeUnit.HOURS)
        days < 30 -> formatter.format(days.toDouble(), RelativeDateTimeFormatter.Direction.LAST, RelativeDateTimeFormatter.RelativeUnit.DAYS)
        months < 12 -> formatter.format(months.toDouble(), RelativeDateTimeFormatter.Direction.LAST, RelativeDateTimeFormatter.RelativeUnit.MONTHS)
        else -> formatter.format(years.toDouble(), RelativeDateTimeFormatter.Direction.LAST, RelativeDateTimeFormatter.RelativeUnit.YEARS)
    }
}
