package org.libre.agosto.p2play.domain.entities

import android.util.JsonReader
import android.util.JsonToken

class ChannelModel(
    var id: Int = 0,
    var url: String = "",
    var nameChannel: String = "",
    var followers: Int = 0,
    var host: String = "",
    var name: String = "",
    var description: String = "",
    var support: String = "",
    var channelImg: String = "",
    var banner: String = "",
    var account: AccountModel? = null,
    var subscribed: Boolean = false
) {
    fun getFullName(): String = "$nameChannel@$host"

    fun parseChannel(data: JsonReader) {
        data.beginObject()

        while (data.hasNext()) {
            when (data.nextName()) {
                "id" -> this.id = data.nextInt()
                "url" -> this.url = data.nextString()
                "name" -> this.nameChannel = data.nextString()
                "host" -> this.host = data.nextString()
                "followersCount" -> this.followers = data.nextInt()
                "displayName" -> this.name = data.nextString()
                "description" -> {
                    if (data.peek() == JsonToken.STRING) {
                        this.description = data.nextString()
                    } else {
                        data.skipValue()
                    }
                }
                "support" -> {
                    if (data.peek() == JsonToken.STRING) {
                        this.support = data.nextString()
                    } else {
                        data.skipValue()
                    }
                }
                "avatar" -> {
                    if (data.peek() == JsonToken.BEGIN_OBJECT) {
                        data.beginObject()
                        while (data.hasNext()) {
                            when (data.nextName()) {
                                "path" -> this.channelImg = data.nextString()
                                else -> data.skipValue()
                            }
                        }
                        data.endObject()
                    } else if(data.peek() == JsonToken.BEGIN_ARRAY) {
                        data.beginArray()
                        while (data.hasNext()) {
                            data.beginObject()
                            while (data.hasNext()) {
                                val avKey = data.nextName()
                                when (avKey) {
                                    "path" -> this.channelImg = data.nextString()
                                    else -> data.skipValue()
                                }
                            }
                            data.endObject()
                        }
                    } else {
                        data.skipValue()
                    }
                }
                "avatars" -> {
                    if(data.peek() == JsonToken.BEGIN_ARRAY) {
                        data.beginArray()
                        while (data.hasNext()) {
                            data.beginObject()
                            while (data.hasNext()) {
                                val avKey = data.nextName()
                                when (avKey) {
                                    "path" -> this.channelImg = data.nextString()
                                    else -> data.skipValue()
                                }
                            }
                            data.endObject()
                        }
                        data.endArray()
                    } else {
                        data.skipValue()
                    }
                }
                "banners" -> {
                    if (data.peek() == JsonToken.BEGIN_ARRAY) {
                        data.beginArray()
                        while (data.hasNext()) {
                            data.beginObject()
                            while (data.hasNext()) {
                                val avKey = data.nextName()
                                when (avKey) {
                                    "path" -> this.banner = data.nextString()
                                    else -> data.skipValue()
                                }
                            }
                            data.endObject()
                        }
                        data.endArray()
                    } else {
                        data.skipValue()
                    }

                }
                "ownerAccount" -> {
                    if (data.peek() == JsonToken.BEGIN_OBJECT) {
                        this.account = AccountModel("", "", "", arrayListOf(), "", "")
                        data.beginObject()
                        while (data.hasNext()) {
                            when (data.nextName()) {
                                "name" -> this.account?.name = data.nextString()
                                "host" -> this.account?.host = data.nextString()
                                "avatars" -> {
                                    if(data.peek() == JsonToken.BEGIN_ARRAY) {
                                        this.account?.avatars = arrayListOf()
                                        data.beginArray()
                                        while (data.hasNext()) {
                                            data.beginObject()
                                            while (data.hasNext()) {
                                                val avKey = data.nextName()
                                                when (avKey) {
                                                    "path" -> this.account?.avatars?.add(
                                                        AccountAvatar(data.nextString())
                                                    )
                                                    else -> data.skipValue()
                                                }
                                            }
                                            data.endObject()
                                        }
                                        data.endArray()
                                    } else {
                                        data.skipValue()
                                    }
                                }
                                else -> data.skipValue()
                            }
                        }
                        data.endObject()
                    }
                    else {
                        data.skipValue()
                    }
                }
                else -> data.skipValue()
            }
        }
        data.endObject()
    }
}
