package org.libre.agosto.p2play.data.rest

import org.libre.agosto.p2play.data.dtos.InstancesDTO
import retrofit2.http.GET
import retrofit2.http.Query

interface InstanceDS {
    @GET("instances?customizations=3")
    suspend fun findInstances(
        @Query("search")
        search: String?,
        @Query("count")
        count: Int = 20,
        @Query("start")
        start: Int = 0,
        @Query("healthy")
        healthy: Boolean? = true,
        @Query("signup")
        signup: Boolean? = true,
        @Query("sort")
        sort: String? = "-customizations"
    ): InstancesDTO
}
