package org.libre.agosto.p2play.data.database

import androidx.room.Dao
import androidx.room.Insert
import androidx.room.Query
import androidx.room.Update
import org.libre.agosto.p2play.domain.entities.SessionModel

@Dao
interface SessionDAO {
    @Query("SELECT * FROM sessions WHERE status = 1")
    fun getAll(): List<SessionModel>

    @Query("SELECT * FROM sessions WHERE host = :host AND status = 1 LIMIT 1")
    fun get(host: String): SessionModel?

    @Insert
    fun create(vararg session: SessionModel)

    @Update
    fun update(vararg session: SessionModel)
}
