package org.libre.agosto.p2play.data.database

import androidx.room.Dao
import androidx.room.Insert
import androidx.room.Query
import androidx.room.Update
import org.libre.agosto.p2play.domain.entities.InstanceModel

@Dao
interface InstanceDAO {
    @Query("SELECT * FROM instances")
    fun getAll(): List<InstanceModel>

    @Query("SELECT * FROM instances WHERE host = :host")
    fun get(host: String): InstanceModel?

    @Insert
    fun create(vararg instance: InstanceModel)

    @Update
    fun update(vararg instance: InstanceModel)
}
