package org.libre.agosto.p2play

import android.content.Intent
import android.content.SharedPreferences
import android.os.Bundle
import android.util.Log
import android.widget.EditText
import androidx.appcompat.app.AlertDialog
import androidx.appcompat.app.AppCompatActivity
import androidx.preference.PreferenceManager
import androidx.room.Room
import org.libre.agosto.p2play.ajax.Auth
import org.libre.agosto.p2play.databinding.ActivityLoginBinding
import org.libre.agosto.p2play.domain.entities.InstanceModel
import org.libre.agosto.p2play.domain.entities.TokenModel
import org.libre.agosto.p2play.helpers.TaskManager
import org.libre.agosto.p2play.viewModels.SessionsViewModel

class LoginActivity : AppCompatActivity() {
    private val auth = Auth()
    lateinit var settings: SharedPreferences

    // private lateinit var clientId: String
    // private lateinit var clientSecret: String
    // private lateinit var db: Database
    private lateinit var db: AppDatabase
    private var optCode: String? = null

    private lateinit var binding: ActivityLoginBinding

    private lateinit var sessionViewModel: SessionsViewModel
    private lateinit var instance: InstanceModel

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityLoginBinding.inflate(layoutInflater)
        val view = binding.root
        setContentView(view)
        setTitle(R.string.action_login)
        // db = Database(this)

        db = Room.databaseBuilder(
            this,
            AppDatabase::class.java,
            "p2play_v2"
        ).build()
        settings = PreferenceManager.getDefaultSharedPreferences(this)
        sessionViewModel = SessionsViewModel(db, settings, Database(this))
        sessionViewModel.loadInstance()

        sessionViewModel.instance.observe(this, {
            it?.let {
                instance = it
            }
        })

        sessionViewModel.session.observe(this, {
            it?.let {
                Log.d("Logged", it.toString())
                finish()
            }
        })

        // clientId = settings.getString("client_id", "")!!
        // clientSecret = settings.getString("client_secret", "")!!

        binding.registerActionBtn.setOnClickListener {
            startActivity(Intent(this, RegisterActivity::class.java))
        }
        binding.loginBtn.setOnClickListener { tryLogin() }
    }

    private fun tryLogin() {
        binding.loginBtn.isEnabled = false
        val username = binding.userText.text.toString()
        val password = binding.passwordText.text.toString()

        val task = TaskManager<TokenModel>()

        task.runTask({
            auth.login(username, password, instance.clientId, instance.clientSecret, optCode)
        }, {
            val token = it

            when (token.status.toString()) {
                "1" -> {
                    sessionViewModel.onUserLogger(token)
                }
                "0" -> {
                    runOnUiThread {
                        binding.loginBtn.isEnabled = true
                        ManagerSingleton.toast(getString(R.string.loginError_msg), this)
                        this.optCode = null
                    }
                }
                "-1" -> {
                    runOnUiThread {
                        binding.loginBtn.isEnabled = true
                        ManagerSingleton.toast(getString(R.string.loginFailed_msg), this)
                        this.optCode = null
                    }
                }
                "-2" -> {
                    // TODO: Start 2FA modal
                    runOnUiThread {
                        val builder = AlertDialog.Builder(
                            this,
                            R.style.Widget_Material3_MaterialCalendar_Fullscreen
                        )
                        val dialog = layoutInflater.inflate(R.layout.two_factor_dialog, null)

                        val inputTwoFactor = dialog.findViewById<EditText>(R.id.twoFactorText)

                        builder.setView(dialog)
                            .setTitle(R.string.twoFactorLabel)
                            // Add action buttons
                            .setPositiveButton(R.string.loginBtn) { d, _ ->
                                this.optCode = inputTwoFactor.text.toString()
                                this.tryLogin()
                                d.dismiss()
                            }
                            .setNegativeButton("Cancel") { d, _ ->
                                dialog.run { d.cancel() }
                                binding.loginBtn.isEnabled = true
                            }
                        val alertDialog = builder.create()
                        alertDialog.show()
                    }
                }
            }
        })
    }
}
