/*
Copyright (C) 2012 Haowen Ning

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
package org.liberty.android.fantastischmemo.downloader.dropbox;

import android.os.Bundle;

import org.json.JSONException;
import org.liberty.android.fantastischmemo.downloader.common.AbstractDownloaderFragment;
import org.liberty.android.fantastischmemo.downloader.common.DownloadItem;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import io.reactivex.functions.Consumer;

public class DropboxListFragment extends AbstractDownloaderFragment {

    public static final String EXTRA_AUTH_TOKEN = "authToken";

    private static final String ANYMEMO_FOLDER = "AnyMemo";

    private String authToken;

    public DropboxListFragment() { }

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        Bundle args = getArguments();
        authToken = args.getString(EXTRA_AUTH_TOKEN);
    }

    @Override
    protected List<DownloadItem> initialRetrieve() throws IOException, JSONException {
        final List<DownloadItem> result = new ArrayList<>();
        appComponents().dropboxApiHelper().listFiles(authToken, ANYMEMO_FOLDER).blockingForEach(new Consumer<List<DownloadItem>>() {
            @Override
            public void accept(List<DownloadItem> downloadItems) throws Exception {
                result.addAll(downloadItems);

            }
        });

        return result;
    }

    @Override
    protected List<DownloadItem> openCategory(DownloadItem di) {
        return Collections.emptyList();
    }

    @Override
    protected List<DownloadItem> goBack() {
        return Collections.emptyList();
    }

    @Override
    protected String fetchDatabase(DownloadItem di) throws Exception {
        return appComponents().dropboxApiHelper().downloadFile(authToken, di.getAddress()).blockingGet();
    }

    @Override
    protected List<DownloadItem> loadMore() throws Exception {
        return null;
    }

    @Override
    protected boolean hasMore() {
        return false;
    }

}
