describe("MockTime tests", function()
    teardown(function()
        require("mock_time"):uninstall()
    end)

    it("should be able to install and uninstall", function()
        local mock_time = require("mock_time")
        local util = require("ffi/util")
        local current_time = os.time()
        local current_highres_sec = util.gettime()
        mock_time:install()
        assert.is.truthy(mock_time:set(10))
        assert.are.equal(os.time(), 10)
        local sec, usec = util.gettime()
        assert.are.equal(sec, 10)
        assert.are.equal(usec, 0)
        mock_time:uninstall()
        assert.is.truthy(os.time() >= current_time)
        assert.is.truthy(util.gettime() >= current_highres_sec)
    end)

    it("should be able to install several times", function()
        local mock_time = require("mock_time")
        local util = require("ffi/util")
        local current_time = os.time()
        local current_highres_sec = util.gettime()
        mock_time:install()
        mock_time:install()
        mock_time:uninstall()
        assert.is.truthy(os.time() >= current_time)
        assert.is.truthy(util.gettime() >= current_highres_sec)
    end)

    it("should reject invalid value", function()
        local mock_time = require("mock_time")
        assert.is.falsy(mock_time:set("100"))
        assert.is.falsy(mock_time:set(true))
        assert.is.falsy(mock_time:set(nil))
        assert.is.falsy(mock_time:set(function() end))
    end)

    it("should increase time", function()
        local mock_time = require("mock_time")
        mock_time:install()
        assert.is.truthy(mock_time:set(10.1))
        assert.are.equal(os.time(), 10)
        mock_time:increase(1)
        assert.are.equal(os.time(), 11)
        mock_time:uninstall()
    end)
end)
