// Needs inkview.h encompassing full 4.x-6.x API
// https://github.com/ezdiy/pocketbook-sdk5/blob/master/arm-obreey-linux-gnueabi/sysroot/usr/local/include/inkview.h
// ~/ffi-cdecl/ffi-cdecl arm-buildroot-linux-musleabihf-gcc inkview_decl.c inkview_h.lua && sed -i 's/char data\[\];/char data[0];/' inkview_h.lua

#include "inkview.h"
#include "inkinternal.h"
#include "ffi-cdecl.h"

cdecl_const(MSG_REBOOT)

cdecl_const(EVT_ACTIVATE)
cdecl_const(EVT_ASYNC_TASK_FINISHED)
cdecl_const(EVT_AUDIO_CHANGED)
cdecl_const(EVT_AVRCP_COMMAND)
cdecl_const(EVT_BACKGROUND)
cdecl_const(EVT_BT_RXCOMPLETE)
cdecl_const(EVT_BT_TXCOMPLETE)
cdecl_const(EVT_CALLBACK)
cdecl_const(EVT_CONFIGCHANGED)
cdecl_const(EVT_CONTROL_PANEL_ABOUT_TO_OPEN)
cdecl_const(EVT_CUSTOM)
cdecl_const(EVT_DIC_CLOSED)
cdecl_const(EVT_DUMP_BITMAPS_DEBUG_INFO)
cdecl_const(EVT_EXIT)
cdecl_const(EVT_EXT_KB)
cdecl_const(EVT_FOCUS)
cdecl_const(EVT_FOREGROUND)
cdecl_const(EVT_FRAME_ACTIVATED)
cdecl_const(EVT_FRAME_DEACTIVATED)
cdecl_const(EVT_FSCHANGED)
cdecl_const(EVT_FSINCOMING)
cdecl_const(EVT_GLOBALACTION)
cdecl_const(EVT_GLOBALREQUEST)
cdecl_const(EVT_HIDE)
cdecl_const(EVT_INIT)
cdecl_const(EVT_KEYPRESS)
cdecl_const(EVT_KEYPRESS_EXT)
cdecl_const(EVT_KEYRELEASE)
cdecl_const(EVT_KEYRELEASE_EXT)
cdecl_const(EVT_KEYREPEAT)
cdecl_const(EVT_KEYREPEAT_EXT)
cdecl_const(EVT_LETTER)
cdecl_const(EVT_MP_STATECHANGED)
cdecl_const(EVT_MP_TRACKCHANGED)
cdecl_const(EVT_MTSYNC)
cdecl_const(EVT_NET_CONNECTED)
cdecl_const(EVT_NET_DISCONNECTED)
cdecl_const(EVT_NET_FOUND_NEW_FW)
cdecl_const(EVT_NEXTPAGE)
cdecl_const(EVT_OBREEY_CONFIG_CHANGED)
cdecl_const(EVT_OPENDIC)
cdecl_const(EVT_ORIENTATION)
cdecl_const(EVT_PACKAGE_JOB_CHANGED)
cdecl_const(EVT_PANEL)
cdecl_const(EVT_PANEL_BLUETOOTH)
cdecl_const(EVT_PANEL_BLUETOOTH_A2DP)
cdecl_const(EVT_PANEL_CLOCK)
cdecl_const(EVT_PANEL_FRONT_LIGHT)
cdecl_const(EVT_PANEL_ICON)
cdecl_const(EVT_PANEL_MPLAYER)
cdecl_const(EVT_PANEL_NETWORK)
cdecl_const(EVT_PANEL_OBREEY_SYNC)
cdecl_const(EVT_PANEL_PROGRESS)
cdecl_const(EVT_PANEL_SETREADINGMODE)
cdecl_const(EVT_PANEL_SETREADINGMODE_INVERT)
cdecl_const(EVT_PANEL_TASKLIST)
cdecl_const(EVT_PANEL_TEXT)
cdecl_const(EVT_PANEL_USBDRIVE)
cdecl_const(EVT_POINTERCANCEL)
cdecl_const(EVT_POINTERCHANGED)
cdecl_const(EVT_POINTERDOWN)
cdecl_const(EVT_POINTERDRAG)
cdecl_const(EVT_POINTERHOLD)
cdecl_const(EVT_POINTERLONG)
cdecl_const(EVT_POINTERMOVE)
cdecl_const(EVT_POINTERUP)
cdecl_const(EVT_POSTPONE_TIMED_POWEROFF)
cdecl_const(EVT_PREVPAGE)
cdecl_const(EVT_QN_BORDER)
cdecl_const(EVT_QN_MOVE)
cdecl_const(EVT_QN_RELEASE)
cdecl_const(EVT_READ_PROGRESS_CHANGED)
cdecl_const(EVT_REPAINT)
cdecl_const(EVT_SAVESTATE)
cdecl_const(EVT_SCANPROGRESS)
cdecl_const(EVT_SCANSTOPPED)
cdecl_const(EVT_SCROLL)
cdecl_const(EVT_SDIN)
cdecl_const(EVT_SDOUT)
cdecl_const(EVT_SHOW)
cdecl_const(EVT_SNAPSHOT)
cdecl_const(EVT_STARTSCAN)
cdecl_const(EVT_STOPSCAN)
cdecl_const(EVT_STOP_PLAYING)
cdecl_const(EVT_SUBTASKCLOSE)
cdecl_const(EVT_SYNTH_ENDED)
cdecl_const(EVT_SYNTH_POSITION)
cdecl_const(EVT_TAB)
cdecl_const(EVT_TEXTCLEAR)
cdecl_const(EVT_TOUCHDOWN)
cdecl_const(EVT_TOUCHMOVE)
cdecl_const(EVT_TOUCHUP)
cdecl_const(EVT_UNFOCUS)
cdecl_const(EVT_UPDATE)
cdecl_const(EVT_USBSTORE_IN)
cdecl_const(EVT_USBSTORE_OUT)

cdecl_const(IV_KEY_0)
cdecl_const(IV_KEY_1)
cdecl_const(IV_KEY_2)
cdecl_const(IV_KEY_3)
cdecl_const(IV_KEY_4)
cdecl_const(IV_KEY_5)
cdecl_const(IV_KEY_6)
cdecl_const(IV_KEY_7)
cdecl_const(IV_KEY_8)
cdecl_const(IV_KEY_9)
cdecl_const(IV_KEY_BACK)
cdecl_const(IV_KEY_COVERCLOSE)
cdecl_const(IV_KEY_COVEROPEN)
cdecl_const(IV_KEY_DELETE)
cdecl_const(IV_KEY_DOWN)
cdecl_const(IV_KEY_HOME)
cdecl_const(IV_KEY_KEYBOARDCLOSE)
cdecl_const(IV_KEY_LANGUAGECHANGE)
cdecl_const(IV_KEY_LEFT)
cdecl_const(IV_KEY_MAX)
cdecl_const(IV_KEY_MENU)
cdecl_const(IV_KEY_MENU_POWER)
cdecl_const(IV_KEY_MINUS)
cdecl_const(IV_KEY_MUSIC)
cdecl_const(IV_KEY_NEXT)
cdecl_const(IV_KEY_NEXT2)
cdecl_const(IV_KEY_OK)
cdecl_const(IV_KEY_PLUS)
cdecl_const(IV_KEY_POWER)
cdecl_const(IV_KEY_PREV)
cdecl_const(IV_KEY_PREV2)
cdecl_const(IV_KEY_RIGHT)
cdecl_const(IV_KEY_SHIFT)
cdecl_const(IV_KEY_UP)
cdecl_const(IV_KEY_ZOOMIN)
cdecl_const(IV_KEY_ZOOMOUT)

cdecl_const(NET_CONNECTED)
cdecl_const(NET_OK)

cdecl_const(REQ_KEYLOCK)

cdecl_enum(input_dev_e)
cdecl_struct(hw_event_data_common_s)
cdecl_type(hw_event_data_common)
cdecl_struct(hw_event_data_pointer_s)
cdecl_type(hw_event_data_pointer)
cdecl_struct(hw_event_s)
cdecl_type(hw_event)

cdecl_struct(icanvas_s)
cdecl_type(icanvas)

cdecl_type(iv_handler)
cdecl_struct(iv_mtinfo_s)
cdecl_type(iv_mtinfo)

cdecl_type(PANEL_FLAGS)

cdecl_func(ClearOnExit)
cdecl_func(DynamicUpdate)
cdecl_func(FullUpdate)
cdecl_func(FullUpdateHQ)
cdecl_func(GetBatteryPower)
cdecl_func(GetCurrentProfile)
cdecl_func(GetCurrentTask)
cdecl_func(GetDeviceModel)
cdecl_func(GetFrontlightColor)
cdecl_func(GetFrontlightEnabled)
cdecl_func(GetFrontlightState)
cdecl_func(GetSleepmode)
cdecl_func(GetSoftwareVersion)
cdecl_func(GetTaskFramebuffer)
cdecl_func(GetTouchInfoI)
cdecl_func(GoSleep)
cdecl_func(IsCharging)
cdecl_func(IsTaskActive)
cdecl_func(MultitaskingSupported)
cdecl_func(NetConnect)
cdecl_func(NetDisconnect)
cdecl_func(NetMgrPing)
cdecl_func(OpenBook)
cdecl_func(OpenScreen)
cdecl_func(PartialUpdate)
cdecl_func(PartialUpdateHQ)
cdecl_func(PowerOff)
cdecl_func(PrepareForLoop)
cdecl_func(ProcessEventLoop)
cdecl_func(QueryGSensor)
cdecl_func(QueryNetwork)
cdecl_func(SendGlobalRequest)
cdecl_func(SetFrontlightColor)
cdecl_func(SetFrontlightEnabled)
cdecl_func(SetFrontlightState)
cdecl_func(SetPanelType)
cdecl_func(SetSubtaskInfo)
cdecl_func(WaitForUpdateComplete)
cdecl_func(WiFiPower)
cdecl_func(adjustAreaDefault)
cdecl_func(hw_close)
cdecl_func(hw_get_keylock)
cdecl_func(hw_init)
cdecl_func(iv_ipc_request)
cdecl_func(iv_setup_gsensor)
cdecl_func(iv_setup_touchpanel)
cdecl_func(iv_sleepmode)
cdecl_func(iv_update_orientation)
