require("ffi_wrapper")
local qrencode = require("ffi/qrencode")

describe("QRencode module", function()
    it("should match the defined result", function()
        local result = '2;2;2;2;2;2;2;-2;-2;-1;1;1;1;-2;2;2;2;2;2;2;2;2;-2;-2;-2;-2;-2;2;-2;-2;-1;-1;1;1;-2;2;-2;-2;'
          ..'-2;-2;-2;2;2;-2;2;2;2;-2;2;-2;-2;-1;1;-1;-1;-2;2;-2;2;2;2;-2;2;2;-2;2;2;2;-2;2;-2;2;1;1;1;-1;-2;2;-2;2;'
          ..'2;2;-2;2;2;-2;2;2;2;-2;2;-2;-2;1;-1;-1;-1;-2;2;-2;2;2;2;-2;2;2;-2;-2;-2;-2;-2;2;-2;-2;-1;-1;-1;1;-2;2;'
          ..'-2;-2;-2;-2;-2;2;2;2;2;2;2;2;2;-2;2;-2;2;-2;2;-2;2;2;2;2;2;2;2;-2;-2;-2;-2;-2;-2;-2;-2;-2;1;1;-1;-1;-2;'
          ..'-2;-2;-2;-2;-2;-2;-2;2;2;-2;2;2;2;2;-2;-2;1;1;-1;1;2;-2;-2;-2;2;-2;-2;-2;1;1;-1;-1;-1;1;-2;1;1;-1;-1;1;'
          ..'1;-1;1;1;-1;1;-1;1;-1;1;-1;1;-1;-1;-1;2;1;-1;-1;1;-1;1;-1;1;1;-1;-1;-1;-1;1;-1;-1;1;1;1;-1;-2;-1;1;-1;'
          ..'-1;-1;-1;1;1;-1;1;1;-1;1;1;1;-1;-1;1;-1;-1;2;1;-1;1;1;1;-1;1;-1;1;-1;-1;1;-1;-1;-2;-2;-2;-2;-2;-2;-2;-2;'
          ..'-2;-1;-1;-1;-1;1;-1;-1;1;-1;1;-1;1;2;2;2;2;2;2;2;-2;-2;1;1;1;-1;-1;1;1;1;-1;-1;1;-1;2;-2;-2;-2;-2;-2;2;'
          ..'-2;2;1;1;1;1;-1;-1;-1;-1;1;1;1;1;2;-2;2;2;2;-2;2;-2;2;-1;1;1;-1;1;1;-1;-1;-1;-1;-1;-1;2;-2;2;2;2;-2;2;'
          ..'-2;2;-1;1;1;1;1;-1;-1;1;1;-1;1;1;2;-2;2;2;2;-2;2;-2;-2;-1;1;-1;-1;-1;-1;-1;-1;-1;1;-1;1;2;-2;-2;-2;-2;'
          ..'-2;2;-2;2;1;-1;1;1;1;1;1;-1;1;-1;-1;1;2;2;2;2;2;2;2;-2;2;1;1;1;1;1;-1;-1;1;1;1;-1;-1;'
        local ok, tab = qrencode.qrcode('test')
        assert.are.same(ok, true)
        local ret = {}
        for _, col in ipairs(tab) do
            for _, lgn in ipairs(col) do
                table.insert(ret, lgn)
                table.insert(ret, ';')
            end
        end
        assert.are.same(table.concat(ret, ''), result)
    end)
end)