describe("QuickStart module", function()
    setup(function()
        require("commonrequire")
    end)
    it("should return false shown_version lower than force_show_version", function()
        G_reader_settings:saveSetting("quickstart_shown_version", 1)
        G_reader_settings:flush()
        local QuickStart = require("ui/quickstart")
        QuickStart.quickstart_force_show_version = 2
        assert.is_false(QuickStart:isShown())
    end)
    it("should return true when shown_version equal to force_show_version", function()
        G_reader_settings:saveSetting("quickstart_shown_version", 1)
        G_reader_settings:flush()
        local QuickStart = require("ui/quickstart")
        QuickStart.quickstart_force_show_version = 1
        assert.is_true(QuickStart:isShown())
    end)
    it("should return true when shown_version higher than force_show_version", function()
        G_reader_settings:saveSetting("quickstart_shown_version", 2)
        G_reader_settings:flush()
        local QuickStart = require("ui/quickstart")
        QuickStart.quickstart_force_show_version = 1
        assert.is_true(QuickStart:isShown())
    end)
    it("should return a proper quickstart filename", function()
        local DataStorage = require("datastorage")
        local QuickStart = require("ui/quickstart")
        local Version = require("version")
        local language = "en"
        local rev = Version:getCurrentRevision()
        local quickstart_dir = string.format("%s%s", DataStorage:getDataDir(), "/help")
        local expected_quickstart_filename = ("%s/quickstart-%s-%s.html"):format(quickstart_dir, language, rev)
        assert.is.same(expected_quickstart_filename, QuickStart:getQuickStart())
    end)
end)
