# Diatronome
*Diatronome* is a 3-in-1 android application. It provide a **tuner**, a **visual-metronome**, and a **synthesizer**.
The application is provided as is, in hope it will be useful.
It is delivered without any unnecessary features like advertisement, selling personal data, privacy spy, making money behind you, etc.
*Diatronome* is a contraction of the word *diapason*, meaning *fork-tuner* in french and *metronome*.

[<img src="https://fdroid.gitlab.io/artwork/badge/get-it-on.png"
alt="Get it on F-Droid"
height="80">](https://f-droid.org/packages/org.kalinisa.diatronome/)
[<img src="https://play.google.com/intl/en_us/badges/images/generic/en-play-badge.png"
alt="Get it on Google Play"
height="80">](https://play.google.com/store/apps/details?id=org.kalinisa.diatronome)

Or download the latest APK from the [Releases Section](https://github.com/grizzlyfute/Diatronome/releases/latest).

# Features
## Tuner
* Note reference pitch with large range. (Tap to bottom-right corner to adjust calibration).
* Transposition support. (Tap to bottom-left corner to set transposition).
* Multiple temperament table.
* Several pitch-detection algorithm available.
* Adjustable microphone sensitivity.

[<img src="/metadata/en-US/images/phoneScreenshots/land_sc2.jpg"
alt=""
height="300">]

## Visual metronome
* Tempo from 1 to 320 beats per minute.
* Visual indicator for better timing precision.
* Set *accent*, *normal*, *sub-division* or *off* beat by taping on a pie part.
* Adjustable table signature, including irregular measure.
* Tap on center to adjust tempo.
* Tap on tempo to open a keyboard for manual input.
* Change metronome's tonality in settings.

[<img src="/metadata/en-US/images/phoneScreenshots/land_sc1.jpg"
alt=""
height="300">]

## Synthesizer
* 8 octaves range.
* Continuous playback mode.
* Different waveforms available.

[<img src="/metadata/en-US/images/phoneScreenshots/land_sc3.jpg"
alt=""
height="300">]

## Other application feature
* Customization of themes colors.
* Option to keep the screen on.
* Metronome can play in the background.
* Changing sharp / flat and note name mode.
* Dark and light themes available.


[<img src="/metadata/en-US/images/phoneScreenshots/port_sc5.jpg"
alt=""
width="300">]

# Required permissions
* Audio record (for tuner function).
* Media playback (for metronome and note playing).

# Known issues
* The tuner use a custom algorithm based on envelop detector. The accuracy may vary depending on your device brand or your instrument. In some cases, alternative methods like Fourier spectral analysis or Yin detection might be more suitable.
* Minor glitches may occurs when using note player, due to abrupt wave stops causing signal distortion.
* AudioTrack may not works properly on Android virtual device.

## Developers
Your contributions are welcome! Whether for improvements or translations, or simply create a ticket your help would be appreciated.
However, remember: the app should remain simple to use and to develop. It must also be compatible with a wide range of devices, including my 10-year-old tablet !

# Support it
If you enjoy this application, you could consider **making a donation**.

Paypal: [paypal](https://www.paypal.com/donate/?hosted_button_id=SJJNG9XBY59W4)
Libreapay: [libreapay](https://en.liberapay.com/grizzlyfute)

