import { IEvent, IStatsCallback, IWatchRTCConfiguration, IWatchRTCInitServices, Rating, StateListener } from "./interfaces";
export declare const sdkLog: (level: "debug" | "info" | "error", message: string, object?: Object | undefined) => void;
export declare const sdkLogWithoutTrace: (level: "debug" | "info" | "error", message: string, object?: Object | undefined) => void;
/**
 * Initialize SDK.
 * @param watchrtc
 * @param prefixesToWrap
 * @param services
 */
export declare const initSDK: (watchrtc: Omit<IWatchRTCConfiguration, "allowBrowserLogCollection">, prefixesToWrap: string[], services?: IWatchRTCInitServices) => void;
export declare const setConfig: (newWatchrtcConfig: Omit<IWatchRTCConfiguration, "collectionInterval" | "allowBrowserLogCollection">) => void;
/**
 * Set user rating and/or comment for peer session
 * @param rating number from 1 to 5
 * @param comment string
 */
export declare const setUserRating: (rating: Rating, ratingComment?: string) => Promise<{
    error?: string;
}>;
/**
 * Add keys for peer session
 * @param keys
 */
export declare const addKeys: (keys: any) => Promise<unknown> | undefined;
export declare const disableDataCollection: () => void;
export declare const enableDataCollection: () => void;
export declare const addEvent: (event: IEvent) => Promise<unknown> | undefined;
export declare const mapStream: (id: string, name: string) => void;
export declare const mapTrack: (id: string, name: string) => void;
export declare const connect: () => void;
export declare const disconnect: () => void;
export declare const registerOnStatsListener: (listener: IStatsCallback | null) => void;
export declare const registerStateListener: (listener: StateListener | null) => void;
export declare const persistentEnd: (nailUpCallEnd?: boolean) => void;
export declare const persistentStart: (roomId: string, peerId: string) => void;
export declare const qrtcRun: ({ options, progressCallback, }: {
    options?: Record<string, any> | undefined;
    progressCallback: (progress: number) => void;
}) => Promise<any>;
export declare const qrtcStop: () => void;
